/*
  File autogenerated by gengetopt version 2.22.4
  generated with the following command:
  gengetopt --show-required --default-option -c cc -H hpp -F cite_cmdline -f cite_cmdline -a cite_args

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifndef FIX_UNUSED
#define FIX_UNUSED(X) (void) (X) /* avoid warnings for unused params */
#endif

#include <getopt.h>

#include "cite_cmdline.hpp"

const char *cite_args_purpose = "How to cite Jellyfish's paper";

const char *cite_args_usage = "Usage: jellyfish cite [OPTIONS]...";

const char *cite_args_description = "";

const char *cite_args_help[] = {
  "  -h, --help           Print help and exit",
  "  -V, --version        Print version and exit",
  "  -b, --bibtex         Bibtex format  (default=off)",
  "  -o, --output=STRING  Output file  (default=`/dev/fd/1')",
    0
};

typedef enum {ARG_NO
  , ARG_FLAG
  , ARG_STRING
} cite_cmdline_arg_type;

static
void clear_given (struct cite_args *args_info);
static
void clear_args (struct cite_args *args_info);

static int
cite_cmdline_internal (int argc, char **argv, struct cite_args *args_info,
                        struct cite_cmdline_params *params, const char *additional_error);


static char *
gengetopt_strdup (const char *s);

static
void clear_given (struct cite_args *args_info)
{
  args_info->help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->bibtex_given = 0 ;
  args_info->output_given = 0 ;
}

static
void clear_args (struct cite_args *args_info)
{
  FIX_UNUSED (args_info);
  args_info->bibtex_flag = 0;
  args_info->output_arg = gengetopt_strdup ("/dev/fd/1");
  args_info->output_orig = NULL;
  
}

static
void init_args_info(struct cite_args *args_info)
{


  args_info->help_help = cite_args_help[0] ;
  args_info->version_help = cite_args_help[1] ;
  args_info->bibtex_help = cite_args_help[2] ;
  args_info->output_help = cite_args_help[3] ;
  
}

void
cite_cmdline_print_version (void)
{
  printf ("%s %s\n",
     (strlen(CITE_CMDLINE_PACKAGE_NAME) ? CITE_CMDLINE_PACKAGE_NAME : CITE_CMDLINE_PACKAGE),
     CITE_CMDLINE_VERSION);
}

static void print_help_common(void) {
  cite_cmdline_print_version ();

  if (strlen(cite_args_purpose) > 0)
    printf("\n%s\n", cite_args_purpose);

  if (strlen(cite_args_usage) > 0)
    printf("\n%s\n", cite_args_usage);

  printf("\n");

  if (strlen(cite_args_description) > 0)
    printf("%s\n\n", cite_args_description);
}

void
cite_cmdline_print_help (void)
{
  int i = 0;
  print_help_common();
  while (cite_args_help[i])
    printf("%s\n", cite_args_help[i++]);
}

void
cite_cmdline_init (struct cite_args *args_info)
{
  clear_given (args_info);
  clear_args (args_info);
  init_args_info (args_info);
}

void
cite_cmdline_params_init(struct cite_cmdline_params *params)
{
  if (params)
    { 
      params->override = 0;
      params->initialize = 1;
      params->check_required = 1;
      params->check_ambiguity = 0;
      params->print_errors = 1;
    }
}

struct cite_cmdline_params *
cite_cmdline_params_create(void)
{
  struct cite_cmdline_params *params = 
    (struct cite_cmdline_params *)malloc(sizeof(struct cite_cmdline_params));
  cite_cmdline_params_init(params);  
  return params;
}

static void
free_string_field (char **s)
{
  if (*s)
    {
      free (*s);
      *s = 0;
    }
}


static void
cite_cmdline_release (struct cite_args *args_info)
{

  free_string_field (&(args_info->output_arg));
  free_string_field (&(args_info->output_orig));
  
  

  clear_given (args_info);
}


static void
write_into_file(FILE *outfile, const char *opt, const char *arg, const char *values[])
{
  FIX_UNUSED (values);
  if (arg) {
    fprintf(outfile, "%s=\"%s\"\n", opt, arg);
  } else {
    fprintf(outfile, "%s\n", opt);
  }
}


int
cite_cmdline_dump(FILE *outfile, struct cite_args *args_info)
{
  int i = 0;

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot dump options to stream\n", CITE_CMDLINE_PACKAGE);
      return EXIT_FAILURE;
    }

  if (args_info->help_given)
    write_into_file(outfile, "help", 0, 0 );
  if (args_info->version_given)
    write_into_file(outfile, "version", 0, 0 );
  if (args_info->bibtex_given)
    write_into_file(outfile, "bibtex", 0, 0 );
  if (args_info->output_given)
    write_into_file(outfile, "output", args_info->output_orig, 0);
  

  i = EXIT_SUCCESS;
  return i;
}

int
cite_cmdline_file_save(const char *filename, struct cite_args *args_info)
{
  FILE *outfile;
  int i = 0;

  outfile = fopen(filename, "w");

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot open file for writing: %s\n", CITE_CMDLINE_PACKAGE, filename);
      return EXIT_FAILURE;
    }

  i = cite_cmdline_dump(outfile, args_info);
  fclose (outfile);

  return i;
}

void
cite_cmdline_free (struct cite_args *args_info)
{
  cite_cmdline_release (args_info);
}

/** @brief replacement of strdup, which is not standard */
char *
gengetopt_strdup (const char *s)
{
  char *result = 0;
  if (!s)
    return result;

  result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}

int
cite_cmdline (int argc, char **argv, struct cite_args *args_info)
{
  return cite_cmdline2 (argc, argv, args_info, 0, 1, 1);
}

int
cite_cmdline_ext (int argc, char **argv, struct cite_args *args_info,
                   struct cite_cmdline_params *params)
{
  int result;
  result = cite_cmdline_internal (argc, argv, args_info, params, 0);

  if (result == EXIT_FAILURE)
    {
      cite_cmdline_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
cite_cmdline2 (int argc, char **argv, struct cite_args *args_info, int override, int initialize, int check_required)
{
  int result;
  struct cite_cmdline_params params;
  
  params.override = override;
  params.initialize = initialize;
  params.check_required = check_required;
  params.check_ambiguity = 0;
  params.print_errors = 1;

  result = cite_cmdline_internal (argc, argv, args_info, &params, 0);

  if (result == EXIT_FAILURE)
    {
      cite_cmdline_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
cite_cmdline_required (struct cite_args *args_info, const char *prog_name)
{
  FIX_UNUSED (args_info);
  FIX_UNUSED (prog_name);
  return EXIT_SUCCESS;
}


static char *package_name = 0;

/**
 * @brief updates an option
 * @param field the generic pointer to the field to update
 * @param orig_field the pointer to the orig field
 * @param field_given the pointer to the number of occurrence of this option
 * @param prev_given the pointer to the number of occurrence already seen
 * @param value the argument for this option (if null no arg was specified)
 * @param possible_values the possible values for this option (if specified)
 * @param default_value the default value (in case the option only accepts fixed values)
 * @param arg_type the type of this option
 * @param check_ambiguity @see cite_cmdline_params.check_ambiguity
 * @param override @see cite_cmdline_params.override
 * @param no_free whether to free a possible previous value
 * @param multiple_option whether this is a multiple option
 * @param long_opt the corresponding long option
 * @param short_opt the corresponding short option (or '-' if none)
 * @param additional_error possible further error specification
 */
static
int update_arg(void *field, char **orig_field,
               unsigned int *field_given, unsigned int *prev_given, 
               char *value, const char *possible_values[],
               const char *default_value,
               cite_cmdline_arg_type arg_type,
               int check_ambiguity, int override,
               int no_free, int multiple_option,
               const char *long_opt, char short_opt,
               const char *additional_error)
{
  char *stop_char = 0;
  const char *val = value;
  int found;
  char **string_field;
  FIX_UNUSED (field);

  stop_char = 0;
  found = 0;

  if (!multiple_option && prev_given && (*prev_given || (check_ambiguity && *field_given)))
    {
      if (short_opt != '-')
        fprintf (stderr, "%s: `--%s' (`-%c') option given more than once%s\n", 
               package_name, long_opt, short_opt,
               (additional_error ? additional_error : ""));
      else
        fprintf (stderr, "%s: `--%s' option given more than once%s\n", 
               package_name, long_opt,
               (additional_error ? additional_error : ""));
      return 1; /* failure */
    }

  FIX_UNUSED (default_value);
    
  if (field_given && *field_given && ! override)
    return 0;
  if (prev_given)
    (*prev_given)++;
  if (field_given)
    (*field_given)++;
  if (possible_values)
    val = possible_values[found];

  switch(arg_type) {
  case ARG_FLAG:
    *((int *)field) = !*((int *)field);
    break;
  case ARG_STRING:
    if (val) {
      string_field = (char **)field;
      if (!no_free && *string_field)
        free (*string_field); /* free previous string */
      *string_field = gengetopt_strdup (val);
    }
    break;
  default:
    break;
  };


  /* store the original value */
  switch(arg_type) {
  case ARG_NO:
  case ARG_FLAG:
    break;
  default:
    if (value && orig_field) {
      if (no_free) {
        *orig_field = value;
      } else {
        if (*orig_field)
          free (*orig_field); /* free previous string */
        *orig_field = gengetopt_strdup (value);
      }
    }
  };

  return 0; /* OK */
}


int
cite_cmdline_internal (
  int argc, char **argv, struct cite_args *args_info,
                        struct cite_cmdline_params *params, const char *additional_error)
{
  int c;	/* Character of the parsed option.  */

  int error = 0;
  struct cite_args local_args_info;
  
  int override;
  int initialize;
  int check_required;
  int check_ambiguity;
  
  package_name = argv[0];
  
  override = params->override;
  initialize = params->initialize;
  check_required = params->check_required;
  check_ambiguity = params->check_ambiguity;

  if (initialize)
    cite_cmdline_init (args_info);

  cite_cmdline_init (&local_args_info);

  optarg = 0;
  optind = 0;
  opterr = params->print_errors;
  optopt = '?';

  while (1)
    {
      int option_index = 0;

      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "version",	0, NULL, 'V' },
        { "bibtex",	0, NULL, 'b' },
        { "output",	1, NULL, 'o' },
        { 0,  0, 0, 0 }
      };

      c = getopt_long (argc, argv, "hVbo:", long_options, &option_index);

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          cite_cmdline_print_help ();
          cite_cmdline_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'V':	/* Print version and exit.  */
          cite_cmdline_print_version ();
          cite_cmdline_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'b':	/* Bibtex format.  */
        
        
          if (update_arg((void *)&(args_info->bibtex_flag), 0, &(args_info->bibtex_given),
              &(local_args_info.bibtex_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "bibtex", 'b',
              additional_error))
            goto failure;
        
          break;
        case 'o':	/* Output file.  */
        
        
          if (update_arg( (void *)&(args_info->output_arg), 
               &(args_info->output_orig), &(args_info->output_given),
              &(local_args_info.output_given), optarg, 0, "/dev/fd/1", ARG_STRING,
              check_ambiguity, override, 0, 0,
              "output", 'o',
              additional_error))
            goto failure;
        
          break;

        case 0:	/* Long option with no short option */
        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          goto failure;

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c%s\n", CITE_CMDLINE_PACKAGE, c, (additional_error ? additional_error : ""));
          abort ();
        } /* switch */
    } /* while */




  cite_cmdline_release (&local_args_info);

  if ( error )
    return (EXIT_FAILURE);

  return 0;

failure:
  
  cite_cmdline_release (&local_args_info);
  return (EXIT_FAILURE);
}
