 /*
 * Project       : ipv6calc
 * File          : dbipv4_assignment.h
 * Version       : $Id: dbipv4addr_assignment.h,v 1.75 2014/07/31 18:39:42 ds6peter Exp $
 * Generated     : Thu Jul 31 20:35:10 2014
 * Data copyright: RIPE NCC, APNIC, ARIN, LACNIC, AFRINIC
 *
 * Information:
 *  Additional header file for databases/lib/libipv6calc_db_wrapper_BuiltIn.c
 */

#include "databases/lib/libipv6calc_db_wrapper_BuiltIn.h"

/*@unused@*/ static const char* dbipv4addr_registry_status __attribute__ ((__unused__)) = "AFRINIC/20140730 APNIC/20140731 ARIN/20140731 IANA/20140520 LACNIC/20140730 RIPENCC/20140730";

static const s_ipv4addr_assignment dbipv4addr_assignment[] = {
	//first     , last      , registry  
	{ 0x01000000, 0x01ffffff, REGISTRY_APNIC      }, // 1.0.0.0         - 1.255.255.255  
	{ 0x02000000, 0x0237ffff, REGISTRY_RIPENCC    }, // 2.0.0.0         - 2.55.255.255   
	{ 0x023c0000, 0x02ffffff, REGISTRY_RIPENCC    }, // 2.60.0.0        - 2.255.255.255  
	{ 0x03000000, 0x04ffffff, REGISTRY_ARIN       }, // 3.0.0.0         - 4.255.255.255  
	{ 0x05000000, 0x052d1fff, REGISTRY_RIPENCC    }, // 5.0.0.0         - 5.45.31.255    
	{ 0x052d3000, 0x0564efff, REGISTRY_RIPENCC    }, // 5.45.48.0       - 5.100.239.255  
	{ 0x0564f800, 0x05853fff, REGISTRY_RIPENCC    }, // 5.100.248.0     - 5.133.63.255   
	{ 0x05858000, 0x05b3ffff, REGISTRY_RIPENCC    }, // 5.133.128.0     - 5.179.255.255  
	{ 0x05b80000, 0x05c7b7ff, REGISTRY_RIPENCC    }, // 5.184.0.0       - 5.199.183.255  
	{ 0x05c7c000, 0x05fbffff, REGISTRY_RIPENCC    }, // 5.199.192.0     - 5.251.255.255  
	{ 0x05fe0000, 0x05ffffff, REGISTRY_RIPENCC    }, // 5.254.0.0       - 5.255.255.255  
	{ 0x06000000, 0x09ffffff, REGISTRY_ARIN       }, // 6.0.0.0         - 9.255.255.255  
	{ 0x0b000000, 0x0dffffff, REGISTRY_ARIN       }, // 11.0.0.0        - 13.255.255.255 
	{ 0x0e000000, 0x0e0117ff, REGISTRY_APNIC      }, // 14.0.0.0        - 14.1.23.255    
	{ 0x0e012000, 0x0e015fff, REGISTRY_APNIC      }, // 14.1.32.0       - 14.1.95.255    
	{ 0x0e018000, 0x0e669fff, REGISTRY_APNIC      }, // 14.1.128.0      - 14.102.159.255 
	{ 0x0e66c000, 0x0ebfffff, REGISTRY_APNIC      }, // 14.102.192.0    - 14.191.255.255 
	{ 0x0ec02000, 0x0effffff, REGISTRY_APNIC      }, // 14.192.32.0     - 14.255.255.255 
	{ 0x0f000000, 0x1883ffff, REGISTRY_ARIN       }, // 15.0.0.0        - 24.131.255.255 
	{ 0x18840000, 0x1887ffff, REGISTRY_RIPENCC    }, // 24.132.0.0      - 24.135.255.255 
	{ 0x18880000, 0x1897ffff, REGISTRY_ARIN       }, // 24.136.0.0      - 24.151.255.255 
	{ 0x18988000, 0x18e5ffff, REGISTRY_ARIN       }, // 24.152.128.0    - 24.229.255.255 
	{ 0x18e60000, 0x18e61fff, REGISTRY_APNIC      }, // 24.230.0.0      - 24.230.31.255  
	{ 0x18e62000, 0x18e7ffff, REGISTRY_ARIN       }, // 24.230.32.0     - 24.231.255.255 
	{ 0x18e80000, 0x18e8ffff, REGISTRY_LACNIC     }, // 24.232.0.0      - 24.232.255.255 
	{ 0x18e90000, 0x18ffffff, REGISTRY_ARIN       }, // 24.233.0.0      - 24.255.255.255 
	{ 0x19000000, 0x19ffffff, REGISTRY_RIPENCC    }, // 25.0.0.0        - 25.255.255.255 
	{ 0x1a000000, 0x1affffff, REGISTRY_ARIN       }, // 26.0.0.0        - 26.255.255.255 
	{ 0x1b000000, 0x1b007fff, REGISTRY_APNIC      }, // 27.0.0.0        - 27.0.127.255   
	{ 0x1b010000, 0x1b3673ff, REGISTRY_APNIC      }, // 27.1.0.0        - 27.54.115.255  
	{ 0x1b367800, 0x1b368fff, REGISTRY_APNIC      }, // 27.54.120.0     - 27.54.143.255  
	{ 0x1b369800, 0x1b6057ff, REGISTRY_APNIC      }, // 27.54.152.0     - 27.96.87.255   
	{ 0x1b606000, 0x1b6403ff, REGISTRY_APNIC      }, // 27.96.96.0      - 27.100.3.255   
	{ 0x1b640800, 0x1b6417ff, REGISTRY_APNIC      }, // 27.100.8.0      - 27.100.23.255  
	{ 0x1b641c00, 0x1b6423ff, REGISTRY_APNIC      }, // 27.100.28.0     - 27.100.35.255  
	{ 0x1b642800, 0x1b6d7bff, REGISTRY_APNIC      }, // 27.100.40.0     - 27.109.123.255 
	{ 0x1b6d8000, 0x1b6f47ff, REGISTRY_APNIC      }, // 27.109.128.0    - 27.111.71.255  
	{ 0x1b6f4c00, 0x1b706fff, REGISTRY_APNIC      }, // 27.111.76.0     - 27.112.111.255 
	{ 0x1b707c00, 0x1b7427ff, REGISTRY_APNIC      }, // 27.112.124.0    - 27.116.39.255  
	{ 0x1b742c00, 0x1b7a3bff, REGISTRY_APNIC      }, // 27.116.44.0     - 27.122.59.255  
	{ 0x1b7a4000, 0x1bffffff, REGISTRY_APNIC      }, // 27.122.64.0     - 27.255.255.255 
	{ 0x1c000000, 0x1effffff, REGISTRY_ARIN       }, // 28.0.0.0        - 30.255.255.255 
	{ 0x1f000000, 0x1f0db7ff, REGISTRY_RIPENCC    }, // 31.0.0.0        - 31.13.183.255  
	{ 0x1f0dc000, 0x1f1607ff, REGISTRY_RIPENCC    }, // 31.13.192.0     - 31.22.7.255    
	{ 0x1f161000, 0x1f27ffff, REGISTRY_RIPENCC    }, // 31.22.16.0      - 31.39.255.255  
	{ 0x1f280000, 0x1f28bfff, REGISTRY_RIPENCC    }, // 31.40.0.0       - 31.40.191.255  
	{ 0x1f290000, 0x1f29c7ff, REGISTRY_RIPENCC    }, // 31.41.0.0       - 31.41.199.255  
	{ 0x1f29c800, 0x1f29cfff, REGISTRY_RIPENCC    }, // 31.41.200.0     - 31.41.207.255  
	{ 0x1f29d000, 0x1f2bffff, REGISTRY_RIPENCC    }, // 31.41.208.0     - 31.43.255.255  
	{ 0x1f2c0000, 0x1f7fffff, REGISTRY_RIPENCC    }, // 31.44.0.0       - 31.127.255.255 
	{ 0x1f800000, 0x1f83ffff, REGISTRY_RIPENCC    }, // 31.128.0.0      - 31.131.255.255 
	{ 0x1f840000, 0x1f8407ff, REGISTRY_RIPENCC    }, // 31.132.0.0      - 31.132.7.255   
	{ 0x1f841000, 0x1f841fff, REGISTRY_RIPENCC    }, // 31.132.16.0     - 31.132.31.255  
	{ 0x1f844000, 0x1f855fff, REGISTRY_RIPENCC    }, // 31.132.64.0     - 31.133.95.255  
	{ 0x1f856800, 0x1f87ffff, REGISTRY_RIPENCC    }, // 31.133.104.0    - 31.135.255.255 
	{ 0x1f880000, 0x1faca7ff, REGISTRY_RIPENCC    }, // 31.136.0.0      - 31.172.167.255 
	{ 0x1facb000, 0x1fd20fff, REGISTRY_RIPENCC    }, // 31.172.176.0    - 31.210.15.255  
	{ 0x1fd21800, 0x1fffffff, REGISTRY_RIPENCC    }, // 31.210.24.0     - 31.255.255.255 
	{ 0x20000000, 0x23ffffff, REGISTRY_ARIN       }, // 32.0.0.0        - 35.255.255.255 
	{ 0x24000000, 0x2431ffff, REGISTRY_APNIC      }, // 36.0.0.0        - 36.49.255.255  
	{ 0x24330000, 0x24feffff, REGISTRY_APNIC      }, // 36.51.0.0       - 36.254.255.255 
	{ 0x25000000, 0x251057ff, REGISTRY_RIPENCC    }, // 37.0.0.0        - 37.16.87.255   
	{ 0x25106000, 0x25127fff, REGISTRY_RIPENCC    }, // 37.16.96.0      - 37.18.127.255  
	{ 0x25128800, 0x258b7fff, REGISTRY_RIPENCC    }, // 37.18.136.0     - 37.139.127.255 
	{ 0x258b8800, 0x2594f7ff, REGISTRY_RIPENCC    }, // 37.139.136.0    - 37.148.247.255 
	{ 0x25950000, 0x25dd3fff, REGISTRY_RIPENCC    }, // 37.149.0.0      - 37.221.63.255  
	{ 0x25dd8000, 0x25fcd7ff, REGISTRY_RIPENCC    }, // 37.221.128.0    - 37.252.215.255 
	{ 0x25fce000, 0x25ffffff, REGISTRY_RIPENCC    }, // 37.252.224.0    - 37.255.255.255 
	{ 0x26000000, 0x26ffffff, REGISTRY_ARIN       }, // 38.0.0.0        - 38.255.255.255 
	{ 0x27000000, 0x27ffffff, REGISTRY_APNIC      }, // 39.0.0.0        - 39.255.255.255 
	{ 0x28000000, 0x28ffffff, REGISTRY_ARIN       }, // 40.0.0.0        - 40.255.255.255 
	{ 0x29000000, 0x293dffff, REGISTRY_AFRINIC    }, // 41.0.0.0        - 41.61.255.255  
	{ 0x293f0000, 0x2948ffff, REGISTRY_AFRINIC    }, // 41.63.0.0       - 41.72.255.255  
	{ 0x29492000, 0x294a5fff, REGISTRY_AFRINIC    }, // 41.73.32.0      - 41.74.95.255   
	{ 0x294a7000, 0x294c2fff, REGISTRY_AFRINIC    }, // 41.74.112.0     - 41.76.47.255   
	{ 0x294c3800, 0x294df7ff, REGISTRY_AFRINIC    }, // 41.76.56.0      - 41.77.247.255  
	{ 0x294e0000, 0x294e0bff, REGISTRY_AFRINIC    }, // 41.78.0.0       - 41.78.11.255   
	{ 0x294e1000, 0x294e2bff, REGISTRY_AFRINIC    }, // 41.78.16.0      - 41.78.43.255   
	{ 0x294e3000, 0x294e43ff, REGISTRY_AFRINIC    }, // 41.78.48.0      - 41.78.67.255   
	{ 0x294e4800, 0x294e77ff, REGISTRY_AFRINIC    }, // 41.78.72.0      - 41.78.119.255  
	{ 0x294e7c00, 0x294e83ff, REGISTRY_AFRINIC    }, // 41.78.124.0     - 41.78.131.255  
	{ 0x294e8800, 0x294e9fff, REGISTRY_AFRINIC    }, // 41.78.136.0     - 41.78.159.255  
	{ 0x294ea400, 0x294eb3ff, REGISTRY_AFRINIC    }, // 41.78.164.0     - 41.78.179.255  
	{ 0x294eb800, 0x294eebff, REGISTRY_AFRINIC    }, // 41.78.184.0     - 41.78.235.255  
	{ 0x294ef000, 0x294effff, REGISTRY_AFRINIC    }, // 41.78.240.0     - 41.78.255.255  
	{ 0x294f0400, 0x294f53ff, REGISTRY_AFRINIC    }, // 41.79.4.0       - 41.79.83.255   
	{ 0x294f5800, 0x294f8bff, REGISTRY_AFRINIC    }, // 41.79.88.0      - 41.79.139.255  
	{ 0x294f9000, 0x29571fff, REGISTRY_AFRINIC    }, // 41.79.144.0     - 41.87.31.255   
	{ 0x29574000, 0x2983ffff, REGISTRY_AFRINIC    }, // 41.87.64.0      - 41.131.255.255 
	{ 0x29840000, 0x29bd5fff, REGISTRY_AFRINIC    }, // 41.132.0.0      - 41.189.95.255  
	{ 0x29bda000, 0x29bdffff, REGISTRY_AFRINIC    }, // 41.189.160.0    - 41.189.255.255 
	{ 0x29be2000, 0x29be47ff, REGISTRY_AFRINIC    }, // 41.190.32.0     - 41.190.71.255  
	{ 0x29be4c00, 0x29beefff, REGISTRY_AFRINIC    }, // 41.190.76.0     - 41.190.239.255 
	{ 0x29bef400, 0x29bf3fff, REGISTRY_AFRINIC    }, // 41.190.244.0    - 41.191.63.255  
	{ 0x29bf4400, 0x29bf5bff, REGISTRY_AFRINIC    }, // 41.191.68.0     - 41.191.91.255  
	{ 0x29bf6000, 0x29bf6bff, REGISTRY_AFRINIC    }, // 41.191.96.0     - 41.191.107.255 
	{ 0x29bf7400, 0x29c4ffff, REGISTRY_AFRINIC    }, // 41.191.116.0    - 41.196.255.255 
	{ 0x29c60000, 0x29cedfff, REGISTRY_AFRINIC    }, // 41.198.0.0      - 41.206.223.255 
	{ 0x29cf0000, 0x29cfdfff, REGISTRY_AFRINIC    }, // 41.207.0.0      - 41.207.223.255 
	{ 0x29cfe400, 0x29d17fff, REGISTRY_AFRINIC    }, // 41.207.228.0    - 41.209.127.255 
	{ 0x29d1c000, 0x29d8afff, REGISTRY_AFRINIC    }, // 41.209.192.0    - 41.216.175.255 
	{ 0x29d8c000, 0x29d8efff, REGISTRY_AFRINIC    }, // 41.216.192.0    - 41.216.239.255 
	{ 0x29d98000, 0x29d9c3ff, REGISTRY_AFRINIC    }, // 41.217.128.0    - 41.217.195.255 
	{ 0x29d9c800, 0x29d9f7ff, REGISTRY_AFRINIC    }, // 41.217.200.0    - 41.217.247.255 
	{ 0x29da0000, 0x29dd6fff, REGISTRY_AFRINIC    }, // 41.218.0.0      - 41.221.111.255 
	{ 0x29dd8000, 0x29de97ff, REGISTRY_AFRINIC    }, // 41.221.128.0    - 41.222.151.255 
	{ 0x29dea000, 0x29deffff, REGISTRY_AFRINIC    }, // 41.222.160.0    - 41.222.255.255 
	{ 0x29df0400, 0x29df0bff, REGISTRY_AFRINIC    }, // 41.223.4.0      - 41.223.11.255  
	{ 0x29df1000, 0x29df43ff, REGISTRY_AFRINIC    }, // 41.223.16.0     - 41.223.67.255  
	{ 0x29df4800, 0x29dfcfff, REGISTRY_AFRINIC    }, // 41.223.72.0     - 41.223.207.255 
	{ 0x29dfd400, 0x29f283ff, REGISTRY_AFRINIC    }, // 41.223.212.0    - 41.242.131.255 
	{ 0x29f28800, 0x29f4ffff, REGISTRY_AFRINIC    }, // 41.242.136.0    - 41.244.255.255 
	{ 0x29f60000, 0x29ffffff, REGISTRY_AFRINIC    }, // 41.246.0.0      - 41.255.255.255 
	{ 0x2a000000, 0x2bdfffff, REGISTRY_APNIC      }, // 42.0.0.0        - 43.223.255.255 
	{ 0x2be80000, 0x2bebffff, REGISTRY_APNIC      }, // 43.232.0.0      - 43.235.255.255 
	{ 0x2bf40000, 0x2bf663ff, REGISTRY_APNIC      }, // 43.244.0.0      - 43.246.99.255  
	{ 0x2bf70000, 0x2bf7ffff, REGISTRY_APNIC      }, // 43.247.0.0      - 43.247.255.255 
	{ 0x2bfc0000, 0x2bff5fff, REGISTRY_APNIC      }, // 43.252.0.0      - 43.255.95.255  
	{ 0x2c000000, 0x2d01ffff, REGISTRY_ARIN       }, // 44.0.0.0        - 45.1.255.255   
	{ 0x2d200000, 0x2d3fffff, REGISTRY_ARIN       }, // 45.32.0.0       - 45.63.255.255  
	{ 0x2d400000, 0x2d410fff, REGISTRY_APNIC      }, // 45.64.0.0       - 45.65.15.255   
	{ 0x2da00000, 0x2dbfffff, REGISTRY_LACNIC     }, // 45.160.0.0      - 45.191.255.255 
	{ 0x2e000000, 0x2e1d17ff, REGISTRY_RIPENCC    }, // 46.0.0.0        - 46.29.23.255   
	{ 0x2e1d2000, 0x2e1eb7ff, REGISTRY_RIPENCC    }, // 46.29.32.0      - 46.30.183.255  
	{ 0x2e1ec000, 0x2e93ffff, REGISTRY_RIPENCC    }, // 46.30.192.0     - 46.147.255.255 
	{ 0x2e940000, 0x2e97ffff, REGISTRY_RIPENCC    }, // 46.148.0.0      - 46.151.255.255 
	{ 0x2e980000, 0x2eabffff, REGISTRY_RIPENCC    }, // 46.152.0.0      - 46.171.255.255 
	{ 0x2eac0000, 0x2eafffff, REGISTRY_RIPENCC    }, // 46.172.0.0      - 46.175.255.255 
	{ 0x2eb00000, 0x2eb7b7ff, REGISTRY_RIPENCC    }, // 46.176.0.0      - 46.183.183.255 
	{ 0x2eb7c000, 0x2ee8f7ff, REGISTRY_RIPENCC    }, // 46.183.192.0    - 46.232.247.255 
	{ 0x2ee90000, 0x2ef337ff, REGISTRY_RIPENCC    }, // 46.233.0.0      - 46.243.55.255  
	{ 0x2ef34000, 0x2effffff, REGISTRY_RIPENCC    }, // 46.243.64.0     - 46.255.255.255 
	{ 0x2f000000, 0x30ffffff, REGISTRY_ARIN       }, // 47.0.0.0        - 48.255.255.255 
	{ 0x31000000, 0x310003ff, REGISTRY_APNIC      }, // 49.0.0.0        - 49.0.3.255     
	{ 0x31000800, 0x318003ff, REGISTRY_APNIC      }, // 49.0.8.0        - 49.128.3.255   
	{ 0x31800800, 0x319c13ff, REGISTRY_APNIC      }, // 49.128.8.0      - 49.156.19.255  
	{ 0x319c1800, 0x31ffffff, REGISTRY_APNIC      }, // 49.156.24.0     - 49.255.255.255 
	{ 0x32000000, 0x32ffffff, REGISTRY_ARIN       }, // 50.0.0.0        - 50.255.255.255 
	{ 0x33000000, 0x33ffffff, REGISTRY_RIPENCC    }, // 51.0.0.0        - 51.255.255.255 
	{ 0x34000000, 0x36ddffff, REGISTRY_ARIN       }, // 52.0.0.0        - 54.221.255.255 
	{ 0x36de0000, 0x36dfffff, REGISTRY_APNIC      }, // 54.222.0.0      - 54.223.255.255 
	{ 0x36e00000, 0x39ffffff, REGISTRY_ARIN       }, // 54.224.0.0      - 57.255.255.255 
	{ 0x3a000000, 0x3a53ffff, REGISTRY_APNIC      }, // 58.0.0.0        - 58.83.255.255  
	{ 0x3a544000, 0x3b980fff, REGISTRY_APNIC      }, // 58.84.64.0      - 59.152.15.255  
	{ 0x3b985800, 0x3b986fff, REGISTRY_APNIC      }, // 59.152.88.0     - 59.152.111.255 
	{ 0x3b988000, 0x3b98ffff, REGISTRY_APNIC      }, // 59.152.128.0    - 59.152.255.255 
	{ 0x3b9a0000, 0x3d0ec7ff, REGISTRY_APNIC      }, // 59.154.0.0      - 61.14.199.255  
	{ 0x3d0f0000, 0x3dffffff, REGISTRY_APNIC      }, // 61.15.0.0       - 61.255.255.255 
	{ 0x3e000000, 0x3e083fff, REGISTRY_RIPENCC    }, // 62.0.0.0        - 62.8.63.255    
	{ 0x3e084000, 0x3e085fff, REGISTRY_AFRINIC    }, // 62.8.64.0       - 62.8.95.255    
	{ 0x3e086000, 0x3e0c5fff, REGISTRY_RIPENCC    }, // 62.8.96.0       - 62.12.95.255   
	{ 0x3e0c8000, 0x3e185fff, REGISTRY_RIPENCC    }, // 62.12.128.0     - 62.24.95.255   
	{ 0x3e186000, 0x3e187fff, REGISTRY_AFRINIC    }, // 62.24.96.0      - 62.24.127.255  
	{ 0x3e188000, 0x3e2c5fff, REGISTRY_RIPENCC    }, // 62.24.128.0     - 62.44.95.255   
	{ 0x3e2c6000, 0x3e2c7fff, REGISTRY_RIPENCC    }, // 62.44.96.0      - 62.44.127.255  
	{ 0x3e2c8000, 0x3e3dbfff, REGISTRY_RIPENCC    }, // 62.44.128.0     - 62.61.191.255  
	{ 0x3e3e0000, 0x3e441fff, REGISTRY_RIPENCC    }, // 62.62.0.0       - 62.68.31.255   
	{ 0x3e442000, 0x3e443fff, REGISTRY_AFRINIC    }, // 62.68.32.0      - 62.68.63.255   
	{ 0x3e444000, 0x3e44dfff, REGISTRY_RIPENCC    }, // 62.68.64.0      - 62.68.223.255  
	{ 0x3e44e000, 0x3e44ffff, REGISTRY_AFRINIC    }, // 62.68.224.0     - 62.68.255.255  
	{ 0x3e450000, 0x3e4e3fff, REGISTRY_RIPENCC    }, // 62.69.0.0       - 62.78.63.255   
	{ 0x3e4e4000, 0x3e4e5fff, REGISTRY_RIPENCC    }, // 62.78.64.0      - 62.78.95.255   
	{ 0x3e4e6000, 0x3e5f7fff, REGISTRY_RIPENCC    }, // 62.78.96.0      - 62.95.127.255  
	{ 0x3e5f8000, 0x3e5fffff, REGISTRY_RIPENCC    }, // 62.95.128.0     - 62.95.255.255  
	{ 0x3e600000, 0x3e71ffff, REGISTRY_RIPENCC    }, // 62.96.0.0       - 62.113.255.255 
	{ 0x3e720000, 0x3e72ffff, REGISTRY_AFRINIC    }, // 62.114.0.0      - 62.114.255.255 
	{ 0x3e730000, 0x3e751fff, REGISTRY_RIPENCC    }, // 62.115.0.0      - 62.117.31.255  
	{ 0x3e752000, 0x3e753fff, REGISTRY_AFRINIC    }, // 62.117.32.0     - 62.117.63.255  
	{ 0x3e754000, 0x3e79ffff, REGISTRY_RIPENCC    }, // 62.117.64.0     - 62.121.255.255 
	{ 0x3e7a0000, 0x3e7a17ff, REGISTRY_RIPENCC    }, // 62.122.0.0      - 62.122.23.255  
	{ 0x3e7a2800, 0x3e7ad7ff, REGISTRY_RIPENCC    }, // 62.122.40.0     - 62.122.215.255 
	{ 0x3e7ae800, 0x3e7affff, REGISTRY_RIPENCC    }, // 62.122.232.0    - 62.122.255.255 
	{ 0x3e7b0000, 0x3e851fff, REGISTRY_RIPENCC    }, // 62.123.0.0      - 62.133.31.255  
	{ 0x3e854000, 0x3e86ffff, REGISTRY_RIPENCC    }, // 62.133.64.0     - 62.134.255.255 
	{ 0x3e870000, 0x3e877fff, REGISTRY_AFRINIC    }, // 62.135.0.0      - 62.135.127.255 
	{ 0x3e878000, 0x3e8affff, REGISTRY_RIPENCC    }, // 62.135.128.0    - 62.138.255.255 
	{ 0x3e8b0000, 0x3e8bffff, REGISTRY_AFRINIC    }, // 62.139.0.0      - 62.139.255.255 
	{ 0x3e8c0000, 0x3e8c3fff, REGISTRY_RIPENCC    }, // 62.140.0.0      - 62.140.63.255  
	{ 0x3e8c4000, 0x3e8c7fff, REGISTRY_AFRINIC    }, // 62.140.64.0     - 62.140.127.255 
	{ 0x3e8c8000, 0x3ead1fff, REGISTRY_RIPENCC    }, // 62.140.128.0    - 62.173.31.255  
	{ 0x3ead2000, 0x3ead3fff, REGISTRY_AFRINIC    }, // 62.173.32.0     - 62.173.63.255  
	{ 0x3ead4000, 0x3eb5ffff, REGISTRY_RIPENCC    }, // 62.173.64.0     - 62.181.255.255 
	{ 0x3eb60000, 0x3eb627ff, REGISTRY_RIPENCC    }, // 62.182.0.0      - 62.182.39.255  
	{ 0x3eb63000, 0x3eb65fff, REGISTRY_RIPENCC    }, // 62.182.48.0     - 62.182.95.255  
	{ 0x3eb66600, 0x3eb6afff, REGISTRY_RIPENCC    }, // 62.182.102.0    - 62.182.175.255 
	{ 0x3eb6b000, 0x3eb6b7ff, REGISTRY_RIPENCC    }, // 62.182.176.0    - 62.182.183.255 
	{ 0x3eb6b800, 0x3eb6ffff, REGISTRY_RIPENCC    }, // 62.182.184.0    - 62.182.255.255 
	{ 0x3eb70000, 0x3ec13fff, REGISTRY_RIPENCC    }, // 62.183.0.0      - 62.193.63.255  
	{ 0x3ec14000, 0x3ec17fff, REGISTRY_AFRINIC    }, // 62.193.64.0     - 62.193.127.255 
	{ 0x3ec18000, 0x3ec19fff, REGISTRY_RIPENCC    }, // 62.193.128.0    - 62.193.159.255 
	{ 0x3ec1c000, 0x3ef01fff, REGISTRY_RIPENCC    }, // 62.193.192.0    - 62.240.31.255  
	{ 0x3ef02000, 0x3ef03fff, REGISTRY_AFRINIC    }, // 62.240.32.0     - 62.240.63.255  
	{ 0x3ef04000, 0x3ef05fff, REGISTRY_RIPENCC    }, // 62.240.64.0     - 62.240.95.255  
	{ 0x3ef06000, 0x3ef07fff, REGISTRY_AFRINIC    }, // 62.240.96.0     - 62.240.127.255 
	{ 0x3ef08000, 0x3ef17fff, REGISTRY_RIPENCC    }, // 62.240.128.0    - 62.241.127.255 
	{ 0x3ef18000, 0x3ef19fff, REGISTRY_AFRINIC    }, // 62.241.128.0    - 62.241.159.255 
	{ 0x3ef1a000, 0x3efb7fff, REGISTRY_RIPENCC    }, // 62.241.160.0    - 62.251.127.255 
	{ 0x3efb8000, 0x3efbffff, REGISTRY_AFRINIC    }, // 62.251.128.0    - 62.251.255.255 
	{ 0x3efc0000, 0x3effffff, REGISTRY_RIPENCC    }, // 62.252.0.0      - 62.255.255.255 
	{ 0x3f000000, 0x401c7fff, REGISTRY_ARIN       }, // 63.0.0.0        - 64.28.127.255  
	{ 0x401c8000, 0x401c8fff, REGISTRY_LACNIC     }, // 64.28.128.0     - 64.28.143.255  
	{ 0x401c9000, 0x40203fff, REGISTRY_ARIN       }, // 64.28.144.0     - 64.32.63.255   
	{ 0x40204000, 0x40207fff, REGISTRY_LACNIC     }, // 64.32.64.0      - 64.32.127.255  
	{ 0x40208000, 0x40396fff, REGISTRY_ARIN       }, // 64.32.128.0     - 64.57.111.255  
	{ 0x40397000, 0x40397fff, REGISTRY_AFRINIC    }, // 64.57.112.0     - 64.57.127.255  
	{ 0x40398000, 0x4207ffff, REGISTRY_ARIN       }, // 64.57.128.0     - 66.7.255.255   
	{ 0x42080000, 0x42087fff, REGISTRY_AFRINIC    }, // 66.8.0.0        - 66.8.127.255   
	{ 0x42088000, 0x42123fff, REGISTRY_ARIN       }, // 66.8.128.0      - 66.18.63.255   
	{ 0x42124000, 0x42125fff, REGISTRY_AFRINIC    }, // 66.18.64.0      - 66.18.95.255   
	{ 0x42126000, 0x423bffff, REGISTRY_ARIN       }, // 66.18.96.0      - 66.59.255.255  
	{ 0x423c0000, 0x423c3fff, REGISTRY_LACNIC     }, // 66.60.0.0       - 66.60.63.255   
	{ 0x423c4000, 0x4261ffff, REGISTRY_ARIN       }, // 66.60.64.0      - 66.97.255.255  
	{ 0x42620000, 0x42625fff, REGISTRY_LACNIC     }, // 66.98.0.0       - 66.98.95.255   
	{ 0x42626000, 0x42801fff, REGISTRY_ARIN       }, // 66.98.96.0      - 66.128.31.255  
	{ 0x42802000, 0x42802fff, REGISTRY_LACNIC     }, // 66.128.32.0     - 66.128.47.255  
	{ 0x42803000, 0x42da83ff, REGISTRY_ARIN       }, // 66.128.48.0     - 66.218.131.255 
	{ 0x42da8600, 0x42e73fff, REGISTRY_ARIN       }, // 66.218.134.0    - 66.231.63.255  
	{ 0x42e74000, 0x42e74fff, REGISTRY_LACNIC     }, // 66.231.64.0     - 66.231.79.255  
	{ 0x42e75000, 0x42fb7fff, REGISTRY_ARIN       }, // 66.231.80.0     - 66.251.127.255 
	{ 0x42fbc000, 0x453f3fff, REGISTRY_ARIN       }, // 66.251.192.0    - 69.63.63.255   
	{ 0x453f4000, 0x453f4fff, REGISTRY_AFRINIC    }, // 69.63.64.0      - 69.63.79.255   
	{ 0x453f5000, 0x45431fff, REGISTRY_ARIN       }, // 69.63.80.0      - 69.67.31.255   
	{ 0x45432000, 0x45432fff, REGISTRY_AFRINIC    }, // 69.67.32.0      - 69.67.47.255   
	{ 0x45433000, 0x482c0fff, REGISTRY_ARIN       }, // 69.67.48.0      - 72.44.15.255   
	{ 0x482c2000, 0x4a5b2fff, REGISTRY_ARIN       }, // 72.44.32.0      - 74.91.47.255   
	{ 0x4a5b4000, 0x4a764fff, REGISTRY_ARIN       }, // 74.91.64.0      - 74.118.79.255  
	{ 0x4a765000, 0x4a7653ff, REGISTRY_APNIC      }, // 74.118.80.0     - 74.118.83.255  
	{ 0x4a765400, 0x4cffffff, REGISTRY_ARIN       }, // 74.118.84.0     - 76.255.255.255 
	{ 0x4d000000, 0x4d490fff, REGISTRY_RIPENCC    }, // 77.0.0.0        - 77.73.15.255   
	{ 0x4d491800, 0x4d4ac7ff, REGISTRY_RIPENCC    }, // 77.73.24.0      - 77.74.199.255  
	{ 0x4d4ad000, 0x4d4fffff, REGISTRY_RIPENCC    }, // 77.74.208.0     - 77.79.255.255  
	{ 0x4d500000, 0x4d50ffff, REGISTRY_RIPENCC    }, // 77.80.0.0       - 77.80.255.255  
	{ 0x4d510000, 0x4d52ffff, REGISTRY_RIPENCC    }, // 77.81.0.0       - 77.82.255.255  
	{ 0x4d540000, 0x4d56ffff, REGISTRY_RIPENCC    }, // 77.84.0.0       - 77.86.255.255  
	{ 0x4d570000, 0x4d5787ff, REGISTRY_RIPENCC    }, // 77.87.0.0       - 77.87.135.255  
	{ 0x4d578800, 0x4d578fff, REGISTRY_RIPENCC    }, // 77.87.136.0     - 77.87.143.255  
	{ 0x4d579000, 0x4d57ffff, REGISTRY_RIPENCC    }, // 77.87.144.0     - 77.87.255.255  
	{ 0x4d580000, 0x4ddbffff, REGISTRY_RIPENCC    }, // 77.88.0.0       - 77.219.255.255 
	{ 0x4ddc0000, 0x4ddc1fff, REGISTRY_AFRINIC    }, // 77.220.0.0      - 77.220.31.255  
	{ 0x4ddc2000, 0x4df34fff, REGISTRY_RIPENCC    }, // 77.220.32.0     - 77.243.79.255  
	{ 0x4df36000, 0x4df75fff, REGISTRY_RIPENCC    }, // 77.243.96.0     - 77.247.95.255  
	{ 0x4df78000, 0x4e1857ff, REGISTRY_RIPENCC    }, // 77.247.128.0    - 78.24.87.255   
	{ 0x4e186800, 0x4e1b7fff, REGISTRY_RIPENCC    }, // 78.24.104.0     - 78.27.127.255  
	{ 0x4e1b8000, 0x4e1bffff, REGISTRY_RIPENCC    }, // 78.27.128.0     - 78.27.255.255  
	{ 0x4e1c0000, 0x4e1effff, REGISTRY_RIPENCC    }, // 78.28.0.0       - 78.30.255.255  
	{ 0x4e1f0000, 0x4e1fffff, REGISTRY_RIPENCC    }, // 78.31.0.0       - 78.31.255.255  
	{ 0x4e200000, 0x4e292fff, REGISTRY_RIPENCC    }, // 78.32.0.0       - 78.41.47.255   
	{ 0x4e293800, 0x4e294fff, REGISTRY_RIPENCC    }, // 78.41.56.0      - 78.41.79.255   
	{ 0x4e295800, 0x4e6ccfff, REGISTRY_RIPENCC    }, // 78.41.88.0      - 78.108.207.255 
	{ 0x4e6ce000, 0x4f6357ff, REGISTRY_RIPENCC    }, // 78.108.224.0    - 79.99.87.255   
	{ 0x4f636000, 0x4f6e0fff, REGISTRY_RIPENCC    }, // 79.99.96.0      - 79.110.15.255  
	{ 0x4f6e1000, 0x4f6e2fff, REGISTRY_RIPENCC    }, // 79.110.16.0     - 79.110.47.255  
	{ 0x4f6e4000, 0x4f6e9fff, REGISTRY_RIPENCC    }, // 79.110.64.0     - 79.110.159.255 
	{ 0x4f6eb000, 0x4f6effff, REGISTRY_RIPENCC    }, // 79.110.176.0    - 79.110.255.255 
	{ 0x4f6f0000, 0x4f8eafff, REGISTRY_RIPENCC    }, // 79.111.0.0      - 79.142.175.255 
	{ 0x4f8ec000, 0x4faa8fff, REGISTRY_RIPENCC    }, // 79.142.192.0    - 79.170.143.255 
	{ 0x4faa9800, 0x4fadffff, REGISTRY_RIPENCC    }, // 79.170.152.0    - 79.173.255.255 
	{ 0x4fae2000, 0x4fae7fff, REGISTRY_RIPENCC    }, // 79.174.32.0     - 79.174.127.255 
	{ 0x4fae8000, 0x5040cfff, REGISTRY_RIPENCC    }, // 79.174.128.0    - 80.64.207.255  
	{ 0x5040e000, 0x5041cfff, REGISTRY_RIPENCC    }, // 80.64.224.0     - 80.65.207.255  
	{ 0x5041e000, 0x5042bfff, REGISTRY_RIPENCC    }, // 80.65.224.0     - 80.66.191.255  
	{ 0x5042d000, 0x50431fff, REGISTRY_RIPENCC    }, // 80.66.208.0     - 80.67.31.255   
	{ 0x50433000, 0x50437fff, REGISTRY_RIPENCC    }, // 80.67.48.0      - 80.67.127.255  
	{ 0x50439000, 0x5044dfff, REGISTRY_RIPENCC    }, // 80.67.144.0     - 80.68.223.255  
	{ 0x5044e000, 0x5044ffff, REGISTRY_RIPENCC    }, // 80.68.224.0     - 80.68.255.255  
	{ 0x50450000, 0x50485fff, REGISTRY_RIPENCC    }, // 80.69.0.0       - 80.72.95.255   
	{ 0x50486000, 0x50486fff, REGISTRY_AFRINIC    }, // 80.72.96.0      - 80.72.111.255  
	{ 0x50487000, 0x504b9fff, REGISTRY_RIPENCC    }, // 80.72.112.0     - 80.75.159.255  
	{ 0x504ba000, 0x504bbfff, REGISTRY_AFRINIC    }, // 80.75.160.0     - 80.75.191.255  
	{ 0x504bc000, 0x504e7fff, REGISTRY_RIPENCC    }, // 80.75.192.0     - 80.78.127.255  
	{ 0x504e9000, 0x50573fff, REGISTRY_RIPENCC    }, // 80.78.144.0     - 80.87.63.255   
	{ 0x50574000, 0x50575fff, REGISTRY_AFRINIC    }, // 80.87.64.0      - 80.87.95.255   
	{ 0x50576000, 0x5057ffff, REGISTRY_RIPENCC    }, // 80.87.96.0      - 80.87.255.255  
	{ 0x50580400, 0x505807ff, REGISTRY_AFRINIC    }, // 80.88.4.0       - 80.88.7.255    
	{ 0x50580c00, 0x50580fff, REGISTRY_AFRINIC    }, // 80.88.12.0      - 80.88.15.255   
	{ 0x50581000, 0x505effff, REGISTRY_RIPENCC    }, // 80.88.16.0      - 80.94.255.255  
	{ 0x505f1000, 0x50edffff, REGISTRY_RIPENCC    }, // 80.95.16.0      - 80.237.255.255 
	{ 0x50ee0000, 0x50ee1fff, REGISTRY_RIPENCC    }, // 80.238.0.0      - 80.238.31.255  
	{ 0x50ee2000, 0x50ee5fff, REGISTRY_RIPENCC    }, // 80.238.32.0     - 80.238.95.255  
	{ 0x50ee6000, 0x50ee7fff, REGISTRY_RIPENCC    }, // 80.238.96.0     - 80.238.127.255 
	{ 0x50ee8000, 0x50f0bfff, REGISTRY_RIPENCC    }, // 80.238.128.0    - 80.240.191.255 
	{ 0x50f0c000, 0x50f0cfff, REGISTRY_AFRINIC    }, // 80.240.192.0    - 80.240.207.255 
	{ 0x50f0d000, 0x50f187ff, REGISTRY_RIPENCC    }, // 80.240.208.0    - 80.241.135.255 
	{ 0x50f19000, 0x50f3dfff, REGISTRY_RIPENCC    }, // 80.241.144.0    - 80.243.223.255 
	{ 0x50f3f000, 0x50f55fff, REGISTRY_RIPENCC    }, // 80.243.240.0    - 80.245.95.255  
	{ 0x50f57000, 0x50f5ffff, REGISTRY_RIPENCC    }, // 80.245.112.0    - 80.245.255.255 
	{ 0x50f60000, 0x50f60fff, REGISTRY_AFRINIC    }, // 80.246.0.0      - 80.246.15.255  
	{ 0x50f61000, 0x50f7ffff, REGISTRY_RIPENCC    }, // 80.246.16.0     - 80.247.255.255 
	{ 0x50f80000, 0x50f80fff, REGISTRY_AFRINIC    }, // 80.248.0.0      - 80.248.15.255  
	{ 0x50f81000, 0x50f83fff, REGISTRY_RIPENCC    }, // 80.248.16.0     - 80.248.63.255  
	{ 0x50f84000, 0x50f84fff, REGISTRY_AFRINIC    }, // 80.248.64.0     - 80.248.79.255  
	{ 0x50f85000, 0x50f93fff, REGISTRY_RIPENCC    }, // 80.248.80.0     - 80.249.63.255  
	{ 0x50f94000, 0x50f94fff, REGISTRY_AFRINIC    }, // 80.249.64.0     - 80.249.79.255  
	{ 0x50f95000, 0x50f96fff, REGISTRY_RIPENCC    }, // 80.249.80.0     - 80.249.111.255 
	{ 0x50f98000, 0x50fa1fff, REGISTRY_RIPENCC    }, // 80.249.128.0    - 80.250.31.255  
	{ 0x50fa3000, 0x50fedfff, REGISTRY_RIPENCC    }, // 80.250.48.0     - 80.254.223.255 
	{ 0x50fef000, 0x5103ffff, REGISTRY_RIPENCC    }, // 80.254.240.0    - 81.3.255.255   
	{ 0x51040000, 0x51043fff, REGISTRY_AFRINIC    }, // 81.4.0.0        - 81.4.63.255    
	{ 0x51044000, 0x5109ffff, REGISTRY_RIPENCC    }, // 81.4.64.0       - 81.9.255.255   
	{ 0x510a0000, 0x510a7fff, REGISTRY_AFRINIC    }, // 81.10.0.0       - 81.10.127.255  
	{ 0x510a8000, 0x510affff, REGISTRY_RIPENCC    }, // 81.10.128.0     - 81.10.255.255  
	{ 0x510b0000, 0x510b7fff, REGISTRY_RIPENCC    }, // 81.11.0.0       - 81.11.127.255  
	{ 0x510b8000, 0x51100fff, REGISTRY_RIPENCC    }, // 81.11.128.0     - 81.16.15.255   
	{ 0x51102000, 0x51107fff, REGISTRY_RIPENCC    }, // 81.16.32.0      - 81.16.127.255  
	{ 0x51109000, 0x5114dfff, REGISTRY_RIPENCC    }, // 81.16.144.0     - 81.20.223.255  
	{ 0x5114e000, 0x5114ffff, REGISTRY_RIPENCC    }, // 81.20.224.0     - 81.20.255.255  
	{ 0x51150000, 0x51155fff, REGISTRY_RIPENCC    }, // 81.21.0.0       - 81.21.95.255   
	{ 0x51156000, 0x51156fff, REGISTRY_AFRINIC    }, // 81.21.96.0      - 81.21.111.255  
	{ 0x51157000, 0x51163fff, REGISTRY_RIPENCC    }, // 81.21.112.0     - 81.22.63.255   
	{ 0x51166000, 0x51193fff, REGISTRY_RIPENCC    }, // 81.22.96.0      - 81.25.63.255   
	{ 0x51195000, 0x511a3fff, REGISTRY_RIPENCC    }, // 81.25.80.0      - 81.26.63.255   
	{ 0x511a5000, 0x511cefff, REGISTRY_RIPENCC    }, // 81.26.80.0      - 81.28.239.255  
	{ 0x511d0000, 0x511d5fff, REGISTRY_RIPENCC    }, // 81.29.0.0       - 81.29.95.255   
	{ 0x511d6000, 0x511d6fff, REGISTRY_AFRINIC    }, // 81.29.96.0      - 81.29.111.255  
	{ 0x511d7000, 0x5157ffff, REGISTRY_RIPENCC    }, // 81.29.112.0     - 81.87.255.255  
	{ 0x51580000, 0x51580fff, REGISTRY_RIPENCC    }, // 81.88.0.0       - 81.88.15.255   
	{ 0x51581000, 0x515bdfff, REGISTRY_RIPENCC    }, // 81.88.16.0      - 81.91.223.255  
	{ 0x515be000, 0x515befff, REGISTRY_AFRINIC    }, // 81.91.224.0     - 81.91.239.255  
	{ 0x515bf000, 0x519fffff, REGISTRY_RIPENCC    }, // 81.91.240.0     - 81.159.255.255 
	{ 0x51a00000, 0x51a1dfff, REGISTRY_RIPENCC    }, // 81.160.0.0      - 81.161.223.255 
	{ 0x51a1f000, 0x51a3ffff, REGISTRY_RIPENCC    }, // 81.161.240.0    - 81.163.255.255 
	{ 0x51a40000, 0x51b9ffff, REGISTRY_RIPENCC    }, // 81.164.0.0      - 81.185.255.255 
	{ 0x51ba0000, 0x51baffff, REGISTRY_RIPENCC    }, // 81.186.0.0      - 81.186.255.255 
	{ 0x51bb0000, 0x51bfffff, REGISTRY_RIPENCC    }, // 81.187.0.0      - 81.191.255.255 
	{ 0x51c00000, 0x51c0ffff, REGISTRY_AFRINIC    }, // 81.192.0.0      - 81.192.255.255 
	{ 0x51c10000, 0x52657fff, REGISTRY_RIPENCC    }, // 81.193.0.0      - 82.101.127.255 
	{ 0x5265c000, 0x5273bfff, REGISTRY_RIPENCC    }, // 82.101.192.0    - 82.115.191.255 
	{ 0x5273c000, 0x5273cfff, REGISTRY_RIPENCC    }, // 82.115.192.0    - 82.115.207.255 
	{ 0x5273e000, 0x527fffff, REGISTRY_RIPENCC    }, // 82.115.224.0    - 82.127.255.255 
	{ 0x52800000, 0x52807fff, REGISTRY_AFRINIC    }, // 82.128.0.0      - 82.128.127.255 
	{ 0x52808000, 0x52817fff, REGISTRY_RIPENCC    }, // 82.128.128.0    - 82.129.127.255 
	{ 0x52818000, 0x5281ffff, REGISTRY_AFRINIC    }, // 82.129.128.0    - 82.129.255.255 
	{ 0x52820000, 0x52827fff, REGISTRY_RIPENCC    }, // 82.130.0.0      - 82.130.127.255 
	{ 0x52828000, 0x52973fff, REGISTRY_RIPENCC    }, // 82.130.128.0    - 82.151.63.255  
	{ 0x52974000, 0x52975fff, REGISTRY_AFRINIC    }, // 82.151.64.0     - 82.151.95.255  
	{ 0x52976000, 0x52c97fff, REGISTRY_RIPENCC    }, // 82.151.96.0     - 82.201.127.255 
	{ 0x52c98000, 0x52c9ffff, REGISTRY_AFRINIC    }, // 82.201.128.0    - 82.201.255.255 
	{ 0x52ca0000, 0x52d3bfff, REGISTRY_RIPENCC    }, // 82.202.0.0      - 82.211.191.255 
	{ 0x52d3c000, 0x52d3ffff, REGISTRY_RIPENCC    }, // 82.211.192.0    - 82.211.255.255 
	{ 0x52d40000, 0x5360ffff, REGISTRY_RIPENCC    }, // 82.212.0.0      - 83.96.255.255  
	{ 0x53610000, 0x53610fff, REGISTRY_RIPENCC    }, // 83.97.0.0       - 83.97.15.255   
	{ 0x53611800, 0x53616fff, REGISTRY_RIPENCC    }, // 83.97.24.0      - 83.97.111.255  
	{ 0x53617800, 0x53617fff, REGISTRY_RIPENCC    }, // 83.97.120.0     - 83.97.127.255  
	{ 0x53618000, 0x53882fff, REGISTRY_RIPENCC    }, // 83.97.128.0     - 83.136.47.255  
	{ 0x53883800, 0x53888fff, REGISTRY_RIPENCC    }, // 83.136.56.0     - 83.136.143.255 
	{ 0x53889800, 0x538dffff, REGISTRY_RIPENCC    }, // 83.136.152.0    - 83.141.255.255 
	{ 0x538e0000, 0x538e37ff, REGISTRY_RIPENCC    }, // 83.142.0.0      - 83.142.55.255  
	{ 0x538e3800, 0x538e3fff, REGISTRY_RIPENCC    }, // 83.142.56.0     - 83.142.63.255  
	{ 0x538e4000, 0x538f17ff, REGISTRY_RIPENCC    }, // 83.142.64.0     - 83.143.23.255  
	{ 0x538f1800, 0x538f1fff, REGISTRY_AFRINIC    }, // 83.143.24.0     - 83.143.31.255  
	{ 0x538f2000, 0x538f47ff, REGISTRY_RIPENCC    }, // 83.143.32.0     - 83.143.71.255  
	{ 0x538f5000, 0x538f67ff, REGISTRY_RIPENCC    }, // 83.143.80.0     - 83.143.103.255 
	{ 0x538f7800, 0x538fefff, REGISTRY_RIPENCC    }, // 83.143.120.0    - 83.143.239.255 
	{ 0x538ff000, 0x538ff7ff, REGISTRY_RIPENCC    }, // 83.143.240.0    - 83.143.247.255 
	{ 0x538ff800, 0x538fffff, REGISTRY_RIPENCC    }, // 83.143.248.0    - 83.143.255.255 
	{ 0x53900000, 0x5396ffff, REGISTRY_RIPENCC    }, // 83.144.0.0      - 83.150.255.255 
	{ 0x53970000, 0x53973fff, REGISTRY_RIPENCC    }, // 83.151.0.0      - 83.151.63.255  
	{ 0x53974000, 0x53af7fff, REGISTRY_RIPENCC    }, // 83.151.64.0     - 83.175.127.255 
	{ 0x53af8000, 0x53afbfff, REGISTRY_RIPENCC    }, // 83.175.128.0    - 83.175.191.255 
	{ 0x53afc000, 0x53db5fff, REGISTRY_RIPENCC    }, // 83.175.192.0    - 83.219.95.255  
	{ 0x53db6800, 0x53f1ffff, REGISTRY_RIPENCC    }, // 83.219.104.0    - 83.241.255.255 
	{ 0x53f20000, 0x53f27fff, REGISTRY_RIPENCC    }, // 83.242.0.0      - 83.242.127.255 
	{ 0x53f28000, 0x53f2ffff, REGISTRY_RIPENCC    }, // 83.242.128.0    - 83.242.255.255 
	{ 0x53f30000, 0x53f377ff, REGISTRY_RIPENCC    }, // 83.243.0.0      - 83.243.119.255 
	{ 0x53f38000, 0x54159fff, REGISTRY_RIPENCC    }, // 83.243.128.0    - 84.21.159.255  
	{ 0x5415c000, 0x5423ffff, REGISTRY_RIPENCC    }, // 84.21.192.0     - 84.35.255.255  
	{ 0x54240000, 0x5424ffff, REGISTRY_AFRINIC    }, // 84.36.0.0       - 84.36.255.255  
	{ 0x54250000, 0x5425ffff, REGISTRY_RIPENCC    }, // 84.37.0.0       - 84.37.255.255  
	{ 0x54260000, 0x54261fff, REGISTRY_RIPENCC    }, // 84.38.0.0       - 84.38.31.255   
	{ 0x54262000, 0x54262fff, REGISTRY_RIPENCC    }, // 84.38.32.0      - 84.38.47.255   
	{ 0x54263000, 0x54265fff, REGISTRY_RIPENCC    }, // 84.38.48.0      - 84.38.95.255   
	{ 0x54266000, 0x54266fff, REGISTRY_RIPENCC    }, // 84.38.96.0      - 84.38.111.255  
	{ 0x54267000, 0x5426ffff, REGISTRY_RIPENCC    }, // 84.38.112.0     - 84.38.255.255  
	{ 0x54270000, 0x5427bfff, REGISTRY_RIPENCC    }, // 84.39.0.0       - 84.39.191.255  
	{ 0x5427d000, 0x54333fff, REGISTRY_RIPENCC    }, // 84.39.208.0     - 84.51.63.255   
	{ 0x54334000, 0x54337fff, REGISTRY_RIPENCC    }, // 84.51.64.0      - 84.51.127.255  
	{ 0x54338000, 0x54c9bfff, REGISTRY_RIPENCC    }, // 84.51.128.0     - 84.201.191.255 
	{ 0x54c9c000, 0x54c9ffff, REGISTRY_RIPENCC    }, // 84.201.192.0    - 84.201.255.255 
	{ 0x54ca0000, 0x54ccffff, REGISTRY_RIPENCC    }, // 84.202.0.0      - 84.204.255.255 
	{ 0x54cd0000, 0x54cd5fff, REGISTRY_RIPENCC    }, // 84.205.0.0      - 84.205.95.255  
	{ 0x54cd6000, 0x54cd7fff, REGISTRY_AFRINIC    }, // 84.205.96.0     - 84.205.127.255 
	{ 0x54cd8000, 0x54cdffff, REGISTRY_RIPENCC    }, // 84.205.128.0    - 84.205.255.255 
	{ 0x54ce0000, 0x54e8ffff, REGISTRY_RIPENCC    }, // 84.206.0.0      - 84.232.255.255 
	{ 0x54e90000, 0x54e97fff, REGISTRY_AFRINIC    }, // 84.233.0.0      - 84.233.127.255 
	{ 0x54e98000, 0x54ea0fff, REGISTRY_RIPENCC    }, // 84.233.128.0    - 84.234.15.255  
	{ 0x54ea1000, 0x54ea1fff, REGISTRY_RIPENCC    }, // 84.234.16.0     - 84.234.31.255  
	{ 0x54ea2000, 0x54ea2fff, REGISTRY_RIPENCC    }, // 84.234.32.0     - 84.234.47.255  
	{ 0x54ea3000, 0x54ea7fff, REGISTRY_RIPENCC    }, // 84.234.48.0     - 84.234.127.255 
	{ 0x54ea8000, 0x54fc3fff, REGISTRY_RIPENCC    }, // 84.234.128.0    - 84.252.63.255  
	{ 0x54fc8000, 0x55087fff, REGISTRY_RIPENCC    }, // 84.252.128.0    - 85.8.127.255   
	{ 0x5508c000, 0x551fdfff, REGISTRY_RIPENCC    }, // 85.8.192.0      - 85.31.223.255  
	{ 0x551fe000, 0x551fefff, REGISTRY_RIPENCC    }, // 85.31.224.0     - 85.31.239.255  
	{ 0x551ff000, 0x555c5fff, REGISTRY_RIPENCC    }, // 85.31.240.0     - 85.92.95.255   
	{ 0x555c8000, 0x5575dfff, REGISTRY_RIPENCC    }, // 85.92.128.0     - 85.117.223.255 
	{ 0x55760000, 0x559e07ff, REGISTRY_RIPENCC    }, // 85.118.0.0      - 85.158.7.255   
	{ 0x559e1000, 0x55bbffff, REGISTRY_RIPENCC    }, // 85.158.16.0     - 85.187.255.255 
	{ 0x55bc0000, 0x55bcbfff, REGISTRY_RIPENCC    }, // 85.188.0.0      - 85.188.191.255 
	{ 0x55bcc000, 0x55c9ffff, REGISTRY_RIPENCC    }, // 85.188.192.0    - 85.201.255.255 
	{ 0x55ca0000, 0x55ca2fff, REGISTRY_RIPENCC    }, // 85.202.0.0      - 85.202.47.255  
	{ 0x55ca3000, 0x55ca3fff, REGISTRY_RIPENCC    }, // 85.202.48.0     - 85.202.63.255  
	{ 0x55ca4000, 0x55ca4fff, REGISTRY_RIPENCC    }, // 85.202.64.0     - 85.202.79.255  
	{ 0x55ca6000, 0x55ca8fff, REGISTRY_RIPENCC    }, // 85.202.96.0     - 85.202.143.255 
	{ 0x55ca9000, 0x55ca9fff, REGISTRY_RIPENCC    }, // 85.202.144.0    - 85.202.159.255 
	{ 0x55cab000, 0x55cabfff, REGISTRY_RIPENCC    }, // 85.202.176.0    - 85.202.191.255 
	{ 0x55cad000, 0x55cadfff, REGISTRY_RIPENCC    }, // 85.202.208.0    - 85.202.223.255 
	{ 0x55cae000, 0x55caffff, REGISTRY_RIPENCC    }, // 85.202.224.0    - 85.202.255.255 
	{ 0x55cb0000, 0x55feffff, REGISTRY_RIPENCC    }, // 85.203.0.0      - 85.254.255.255 
	{ 0x55ff0000, 0x55ff4fff, REGISTRY_RIPENCC    }, // 85.255.0.0      - 85.255.79.255  
	{ 0x55ff6000, 0x55ffffff, REGISTRY_RIPENCC    }, // 85.255.96.0     - 85.255.255.255 
	{ 0x56000000, 0x563dffff, REGISTRY_RIPENCC    }, // 86.0.0.0        - 86.61.255.255  
	{ 0x563e4000, 0x566f3fff, REGISTRY_RIPENCC    }, // 86.62.64.0      - 86.111.63.255  
	{ 0x566f4000, 0x566f7fff, REGISTRY_RIPENCC    }, // 86.111.64.0     - 86.111.127.255 
	{ 0x566f8000, 0x566fbfff, REGISTRY_RIPENCC    }, // 86.111.128.0    - 86.111.191.255 
	{ 0x566fc000, 0x566fcfff, REGISTRY_RIPENCC    }, // 86.111.192.0    - 86.111.207.255 
	{ 0x566fd800, 0x566fffff, REGISTRY_RIPENCC    }, // 86.111.216.0    - 86.111.255.255 
	{ 0x56700000, 0x574bffff, REGISTRY_RIPENCC    }, // 86.112.0.0      - 87.75.255.255  
	{ 0x574c0000, 0x574dffff, REGISTRY_RIPENCC    }, // 87.76.0.0       - 87.77.255.255  
	{ 0x574e0000, 0x57633fff, REGISTRY_RIPENCC    }, // 87.78.0.0       - 87.99.63.255   
	{ 0x57634000, 0x57637fff, REGISTRY_RIPENCC    }, // 87.99.64.0      - 87.99.127.255  
	{ 0x57638000, 0x5764ffff, REGISTRY_RIPENCC    }, // 87.99.128.0     - 87.100.255.255 
	{ 0x57650000, 0x57654fff, REGISTRY_RIPENCC    }, // 87.101.0.0      - 87.101.79.255  
	{ 0x57656000, 0x57657fff, REGISTRY_RIPENCC    }, // 87.101.96.0     - 87.101.127.255 
	{ 0x57658000, 0x57eeffff, REGISTRY_RIPENCC    }, // 87.101.128.0    - 87.238.255.255 
	{ 0x57ef0000, 0x57ef2fff, REGISTRY_RIPENCC    }, // 87.239.0.0      - 87.239.47.255  
	{ 0x57ef3800, 0x57ef47ff, REGISTRY_RIPENCC    }, // 87.239.56.0     - 87.239.71.255  
	{ 0x57ef4800, 0x57ef4fff, REGISTRY_RIPENCC    }, // 87.239.72.0     - 87.239.79.255  
	{ 0x57ef5000, 0x57efffff, REGISTRY_RIPENCC    }, // 87.239.80.0     - 87.239.255.255 
	{ 0x57f00000, 0x57ff5fff, REGISTRY_RIPENCC    }, // 87.240.0.0      - 87.255.95.255  
	{ 0x57ff6000, 0x57ff7fff, REGISTRY_AFRINIC    }, // 87.255.96.0     - 87.255.127.255 
	{ 0x57ff8000, 0x5886ffff, REGISTRY_RIPENCC    }, // 87.255.128.0    - 88.134.255.255 
	{ 0x58870000, 0x5887ffff, REGISTRY_RIPENCC    }, // 88.135.0.0      - 88.135.255.255 
	{ 0x58880000, 0x58c4ffff, REGISTRY_RIPENCC    }, // 88.136.0.0      - 88.196.255.255 
	{ 0x58c50000, 0x58c5ffff, REGISTRY_RIPENCC    }, // 88.197.0.0      - 88.197.255.255 
	{ 0x58c60000, 0x59131fff, REGISTRY_RIPENCC    }, // 88.198.0.0      - 89.19.31.255   
	{ 0x59134000, 0x5915ffff, REGISTRY_RIPENCC    }, // 89.19.64.0      - 89.21.255.255  
	{ 0x59160000, 0x5917ffff, REGISTRY_RIPENCC    }, // 89.22.0.0       - 89.23.255.255  
	{ 0x59180000, 0x591f17ff, REGISTRY_RIPENCC    }, // 89.24.0.0       - 89.31.23.255   
	{ 0x591f2000, 0x591f77ff, REGISTRY_RIPENCC    }, // 89.31.32.0      - 89.31.119.255  
	{ 0x591f8000, 0x59be7fff, REGISTRY_RIPENCC    }, // 89.31.128.0     - 89.190.127.255 
	{ 0x59bea000, 0x59c887ff, REGISTRY_RIPENCC    }, // 89.190.160.0    - 89.200.135.255 
	{ 0x59c88800, 0x59c897ff, REGISTRY_RIPENCC    }, // 89.200.136.0    - 89.200.151.255 
	{ 0x59c89800, 0x59c89fff, REGISTRY_RIPENCC    }, // 89.200.152.0    - 89.200.159.255 
	{ 0x59c8a000, 0x59c8ffff, REGISTRY_RIPENCC    }, // 89.200.160.0    - 89.200.255.255 
	{ 0x59c90000, 0x59cdffff, REGISTRY_RIPENCC    }, // 89.201.0.0      - 89.205.255.255 
	{ 0x59ce0000, 0x59ce7fff, REGISTRY_RIPENCC    }, // 89.206.0.0      - 89.206.127.255 
	{ 0x59ce8000, 0x59cf07ff, REGISTRY_RIPENCC    }, // 89.206.128.0    - 89.207.7.255   
	{ 0x59cf1000, 0x59cfafff, REGISTRY_RIPENCC    }, // 89.207.16.0     - 89.207.175.255 
	{ 0x59cfb800, 0x5b59ffff, REGISTRY_RIPENCC    }, // 89.207.184.0    - 91.89.255.255  
	{ 0x5b5a0000, 0x5b5a4fff, REGISTRY_RIPENCC    }, // 91.90.0.0       - 91.90.79.255   
	{ 0x5b5a5800, 0x5b5affff, REGISTRY_RIPENCC    }, // 91.90.88.0      - 91.90.255.255  
	{ 0x5b5b0000, 0x5b7affff, REGISTRY_RIPENCC    }, // 91.91.0.0       - 91.122.255.255 
	{ 0x5b7b0000, 0x5b7bffff, REGISTRY_RIPENCC    }, // 91.123.0.0      - 91.123.255.255 
	{ 0x5b7c0000, 0x5b8e7fff, REGISTRY_RIPENCC    }, // 91.124.0.0      - 91.142.127.255 
	{ 0x5b8e8000, 0x5b8e84ff, REGISTRY_RIPENCC    }, // 91.142.128.0    - 91.142.132.255 
	{ 0x5b8e8600, 0x5b8e8bff, REGISTRY_RIPENCC    }, // 91.142.134.0    - 91.142.139.255 
	{ 0x5b8e8d00, 0x5b8e8fff, REGISTRY_RIPENCC    }, // 91.142.141.0    - 91.142.143.255 
	{ 0x5b8e9000, 0x5b969fff, REGISTRY_RIPENCC    }, // 91.142.144.0    - 91.150.159.255 
	{ 0x5b96a000, 0x5b96ffff, REGISTRY_RIPENCC    }, // 91.150.160.0    - 91.150.255.255 
	{ 0x5b970000, 0x5bbcbfff, REGISTRY_RIPENCC    }, // 91.151.0.0      - 91.188.191.255 
	{ 0x5bbd0000, 0x5bbdb7ff, REGISTRY_RIPENCC    }, // 91.189.0.0      - 91.189.183.255 
	{ 0x5bbdc000, 0x5bbddfff, REGISTRY_RIPENCC    }, // 91.189.192.0    - 91.189.223.255 
	{ 0x5bbde000, 0x5bbde7ff, REGISTRY_RIPENCC    }, // 91.189.224.0    - 91.189.231.255 
	{ 0x5bbde800, 0x5bbdffff, REGISTRY_RIPENCC    }, // 91.189.232.0    - 91.189.255.255 
	{ 0x5bbe0000, 0x5bbfffff, REGISTRY_RIPENCC    }, // 91.190.0.0      - 91.191.255.255 
	{ 0x5bc00000, 0x5bc003ff, REGISTRY_RIPENCC    }, // 91.192.0.0      - 91.192.3.255   
	{ 0x5bc00800, 0x5bc017ff, REGISTRY_RIPENCC    }, // 91.192.8.0      - 91.192.23.255  
	{ 0x5bc01c00, 0x5bc069ff, REGISTRY_RIPENCC    }, // 91.192.28.0     - 91.192.105.255 
	{ 0x5bc06c00, 0x5bc0afff, REGISTRY_RIPENCC    }, // 91.192.108.0    - 91.192.175.255 
	{ 0x5bc0b400, 0x5bc103ff, REGISTRY_RIPENCC    }, // 91.192.180.0    - 91.193.3.255   
	{ 0x5bc10800, 0x5bc10fff, REGISTRY_RIPENCC    }, // 91.193.8.0      - 91.193.15.255  
	{ 0x5bc11400, 0x5bc13bff, REGISTRY_RIPENCC    }, // 91.193.20.0     - 91.193.59.255  
	{ 0x5bc14000, 0x5bc163ff, REGISTRY_RIPENCC    }, // 91.193.64.0     - 91.193.99.255  
	{ 0x5bc16800, 0x5bc16fff, REGISTRY_RIPENCC    }, // 91.193.104.0    - 91.193.111.255 
	{ 0x5bc17800, 0x5bc197ff, REGISTRY_RIPENCC    }, // 91.193.120.0    - 91.193.151.255 
	{ 0x5bc19c00, 0x5bc1bfff, REGISTRY_RIPENCC    }, // 91.193.156.0    - 91.193.191.255 
	{ 0x5bc1c400, 0x5bc1f7ff, REGISTRY_RIPENCC    }, // 91.193.196.0    - 91.193.247.255 
	{ 0x5bc1fc00, 0x5bc1ffff, REGISTRY_RIPENCC    }, // 91.193.252.0    - 91.193.255.255 
	{ 0x5bc20200, 0x5bc20dff, REGISTRY_RIPENCC    }, // 91.194.2.0      - 91.194.13.255  
	{ 0x5bc21000, 0x5bc217ff, REGISTRY_RIPENCC    }, // 91.194.16.0     - 91.194.23.255  
	{ 0x5bc21a00, 0x5bc233ff, REGISTRY_RIPENCC    }, // 91.194.26.0     - 91.194.51.255  
	{ 0x5bc23800, 0x5bc267ff, REGISTRY_RIPENCC    }, // 91.194.56.0     - 91.194.103.255 
	{ 0x5bc26a00, 0x5bc275ff, REGISTRY_RIPENCC    }, // 91.194.106.0    - 91.194.117.255 
	{ 0x5bc27800, 0x5bc27bff, REGISTRY_RIPENCC    }, // 91.194.120.0    - 91.194.123.255 
	{ 0x5bc27e00, 0x5bc28bff, REGISTRY_RIPENCC    }, // 91.194.126.0    - 91.194.139.255 
	{ 0x5bc28e00, 0x5bc2a5ff, REGISTRY_RIPENCC    }, // 91.194.142.0    - 91.194.165.255 
	{ 0x5bc2a800, 0x5bc2a9ff, REGISTRY_RIPENCC    }, // 91.194.168.0    - 91.194.169.255 
	{ 0x5bc2ac00, 0x5bc2b5ff, REGISTRY_RIPENCC    }, // 91.194.172.0    - 91.194.181.255 
	{ 0x5bc2b800, 0x5bc2bfff, REGISTRY_RIPENCC    }, // 91.194.184.0    - 91.194.191.255 
	{ 0x5bc2c400, 0x5bc2d5ff, REGISTRY_RIPENCC    }, // 91.194.196.0    - 91.194.213.255 
	{ 0x5bc2d800, 0x5bc2efff, REGISTRY_RIPENCC    }, // 91.194.216.0    - 91.194.239.255 
	{ 0x5bc2f200, 0x5bc331ff, REGISTRY_RIPENCC    }, // 91.194.242.0    - 91.195.49.255  
	{ 0x5bc33400, 0x5bc33fff, REGISTRY_RIPENCC    }, // 91.195.52.0     - 91.195.63.255  
	{ 0x5bc34400, 0x5bc3d3ff, REGISTRY_RIPENCC    }, // 91.195.68.0     - 91.195.211.255 
	{ 0x5bc3d600, 0x5bc40fff, REGISTRY_RIPENCC    }, // 91.195.214.0    - 91.196.15.255  
	{ 0x5bc41400, 0x5bc427ff, REGISTRY_RIPENCC    }, // 91.196.20.0     - 91.196.39.255  
	{ 0x5bc42c00, 0x5bc43fff, REGISTRY_RIPENCC    }, // 91.196.44.0     - 91.196.63.255  
	{ 0x5bc44800, 0x5bc4b3ff, REGISTRY_RIPENCC    }, // 91.196.72.0     - 91.196.179.255 
	{ 0x5bc4b800, 0x5bc4c7ff, REGISTRY_RIPENCC    }, // 91.196.184.0    - 91.196.199.255 
	{ 0x5bc4cc00, 0x5bc4dbff, REGISTRY_RIPENCC    }, // 91.196.204.0    - 91.196.219.255 
	{ 0x5bc4e000, 0x5bc4e7ff, REGISTRY_RIPENCC    }, // 91.196.224.0    - 91.196.231.255 
	{ 0x5bc4ec00, 0x5bc4ffff, REGISTRY_RIPENCC    }, // 91.196.236.0    - 91.196.255.255 
	{ 0x5bc50400, 0x5bc523ff, REGISTRY_RIPENCC    }, // 91.197.4.0      - 91.197.35.255  
	{ 0x5bc52c00, 0x5bc577ff, REGISTRY_RIPENCC    }, // 91.197.44.0     - 91.197.119.255 
	{ 0x5bc57c00, 0x5bc5c7ff, REGISTRY_RIPENCC    }, // 91.197.124.0    - 91.197.199.255 
	{ 0x5bc5cc00, 0x5bc5efff, REGISTRY_RIPENCC    }, // 91.197.204.0    - 91.197.239.255 
	{ 0x5bc5f400, 0x5bc61bff, REGISTRY_RIPENCC    }, // 91.197.244.0    - 91.198.27.255  
	{ 0x5bc61d00, 0x5bc628ff, REGISTRY_RIPENCC    }, // 91.198.29.0     - 91.198.40.255  
	{ 0x5bc62a00, 0x5bc62fff, REGISTRY_RIPENCC    }, // 91.198.42.0     - 91.198.47.255  
	{ 0x5bc63100, 0x5bc64cff, REGISTRY_RIPENCC    }, // 91.198.49.0     - 91.198.76.255  
	{ 0x5bc64e00, 0x5bc66bff, REGISTRY_RIPENCC    }, // 91.198.78.0     - 91.198.107.255 
	{ 0x5bc66e00, 0x5bc672ff, REGISTRY_RIPENCC    }, // 91.198.110.0    - 91.198.114.255 
	{ 0x5bc67400, 0x5bc692ff, REGISTRY_RIPENCC    }, // 91.198.116.0    - 91.198.146.255 
	{ 0x5bc69400, 0x5bc69dff, REGISTRY_RIPENCC    }, // 91.198.148.0    - 91.198.157.255 
	{ 0x5bc69f00, 0x5bc6a6ff, REGISTRY_RIPENCC    }, // 91.198.159.0    - 91.198.166.255 
	{ 0x5bc6a800, 0x5bc6a9ff, REGISTRY_RIPENCC    }, // 91.198.168.0    - 91.198.169.255 
	{ 0x5bc6ab00, 0x5bc6b8ff, REGISTRY_RIPENCC    }, // 91.198.171.0    - 91.198.184.255 
	{ 0x5bc6ba00, 0x5bc6c3ff, REGISTRY_RIPENCC    }, // 91.198.186.0    - 91.198.195.255 
	{ 0x5bc6c500, 0x5bc6cfff, REGISTRY_RIPENCC    }, // 91.198.197.0    - 91.198.207.255 
	{ 0x5bc6d100, 0x5bc6d1ff, REGISTRY_RIPENCC    }, // 91.198.209.0    - 91.198.209.255 
	{ 0x5bc6d300, 0x5bc6d9ff, REGISTRY_RIPENCC    }, // 91.198.211.0    - 91.198.217.255 
	{ 0x5bc6db00, 0x5bc6dbff, REGISTRY_RIPENCC    }, // 91.198.219.0    - 91.198.219.255 
	{ 0x5bc6dd00, 0x5bc6e5ff, REGISTRY_RIPENCC    }, // 91.198.221.0    - 91.198.229.255 
	{ 0x5bc6e700, 0x5bc6fdff, REGISTRY_RIPENCC    }, // 91.198.231.0    - 91.198.253.255 
	{ 0x5bc6ff00, 0x5bc708ff, REGISTRY_RIPENCC    }, // 91.198.255.0    - 91.199.8.255   
	{ 0x5bc70a00, 0x5bc71aff, REGISTRY_RIPENCC    }, // 91.199.10.0     - 91.199.26.255  
	{ 0x5bc71c00, 0x5bc71dff, REGISTRY_RIPENCC    }, // 91.199.28.0     - 91.199.29.255  
	{ 0x5bc71f00, 0x5bc71fff, REGISTRY_RIPENCC    }, // 91.199.31.0     - 91.199.31.255  
	{ 0x5bc72100, 0x5bc729ff, REGISTRY_RIPENCC    }, // 91.199.33.0     - 91.199.41.255  
	{ 0x5bc72b00, 0x5bc72bff, REGISTRY_RIPENCC    }, // 91.199.43.0     - 91.199.43.255  
	{ 0x5bc72d00, 0x5bc72eff, REGISTRY_RIPENCC    }, // 91.199.45.0     - 91.199.46.255  
	{ 0x5bc73000, 0x5bc750ff, REGISTRY_RIPENCC    }, // 91.199.48.0     - 91.199.80.255  
	{ 0x5bc75300, 0x5bc756ff, REGISTRY_RIPENCC    }, // 91.199.83.0     - 91.199.86.255  
	{ 0x5bc75800, 0x5bc759ff, REGISTRY_RIPENCC    }, // 91.199.88.0     - 91.199.89.255  
	{ 0x5bc75b00, 0x5bc765ff, REGISTRY_RIPENCC    }, // 91.199.91.0     - 91.199.101.255 
	{ 0x5bc76700, 0x5bc77aff, REGISTRY_RIPENCC    }, // 91.199.103.0    - 91.199.122.255 
	{ 0x5bc77c00, 0x5bc792ff, REGISTRY_RIPENCC    }, // 91.199.124.0    - 91.199.146.255 
	{ 0x5bc79400, 0x5bc7a2ff, REGISTRY_RIPENCC    }, // 91.199.148.0    - 91.199.162.255 
	{ 0x5bc7a400, 0x5bc7a7ff, REGISTRY_RIPENCC    }, // 91.199.164.0    - 91.199.167.255 
	{ 0x5bc7a900, 0x5bc7abff, REGISTRY_RIPENCC    }, // 91.199.169.0    - 91.199.171.255 
	{ 0x5bc7ad00, 0x5bc7b2ff, REGISTRY_RIPENCC    }, // 91.199.173.0    - 91.199.178.255 
	{ 0x5bc7b400, 0x5bc7b7ff, REGISTRY_RIPENCC    }, // 91.199.180.0    - 91.199.183.255 
	{ 0x5bc7ba00, 0x5bc7c0ff, REGISTRY_RIPENCC    }, // 91.199.186.0    - 91.199.192.255 
	{ 0x5bc7c200, 0x5bc7d2ff, REGISTRY_RIPENCC    }, // 91.199.194.0    - 91.199.210.255 
	{ 0x5bc7d400, 0x5bc7f7ff, REGISTRY_RIPENCC    }, // 91.199.212.0    - 91.199.247.255 
	{ 0x5bc7f900, 0x5bc81fff, REGISTRY_RIPENCC    }, // 91.199.249.0    - 91.200.31.255  
	{ 0x5bc82000, 0x5bc823ff, REGISTRY_RIPENCC    }, // 91.200.32.0     - 91.200.35.255  
	{ 0x5bc82400, 0x5bc857ff, REGISTRY_RIPENCC    }, // 91.200.36.0     - 91.200.87.255  
	{ 0x5bc85c00, 0x5bc863ff, REGISTRY_RIPENCC    }, // 91.200.92.0     - 91.200.99.255  
	{ 0x5bc86800, 0x5bc893ff, REGISTRY_RIPENCC    }, // 91.200.104.0    - 91.200.147.255 
	{ 0x5bc89800, 0x5bc8afff, REGISTRY_RIPENCC    }, // 91.200.152.0    - 91.200.175.255 
	{ 0x5bc8b400, 0x5bc8bbff, REGISTRY_RIPENCC    }, // 91.200.180.0    - 91.200.187.255 
	{ 0x5bc8c000, 0x5bc8efff, REGISTRY_RIPENCC    }, // 91.200.192.0    - 91.200.239.255 
	{ 0x5bc8f400, 0x5bc903ff, REGISTRY_RIPENCC    }, // 91.200.244.0    - 91.201.3.255   
	{ 0x5bc90800, 0x5bc913ff, REGISTRY_RIPENCC    }, // 91.201.8.0      - 91.201.19.255  
	{ 0x5bc91400, 0x5bc917ff, REGISTRY_RIPENCC    }, // 91.201.20.0     - 91.201.23.255  
	{ 0x5bc91800, 0x5bc91bff, REGISTRY_RIPENCC    }, // 91.201.24.0     - 91.201.27.255  
	{ 0x5bc92400, 0x5bc93fff, REGISTRY_RIPENCC    }, // 91.201.36.0     - 91.201.63.255  
	{ 0x5bc94400, 0x5bc967ff, REGISTRY_RIPENCC    }, // 91.201.68.0     - 91.201.103.255 
	{ 0x5bc96c00, 0x5bc97bff, REGISTRY_RIPENCC    }, // 91.201.108.0    - 91.201.123.255 
	{ 0x5bc98000, 0x5bc98bff, REGISTRY_RIPENCC    }, // 91.201.128.0    - 91.201.139.255 
	{ 0x5bc99000, 0x5bc9c3ff, REGISTRY_RIPENCC    }, // 91.201.144.0    - 91.201.195.255 
	{ 0x5bc9c800, 0x5bca1bff, REGISTRY_RIPENCC    }, // 91.201.200.0    - 91.202.27.255  
	{ 0x5bca2400, 0x5bcaabff, REGISTRY_RIPENCC    }, // 91.202.36.0     - 91.202.171.255 
	{ 0x5bcaac00, 0x5bcaafff, REGISTRY_RIPENCC    }, // 91.202.172.0    - 91.202.175.255 
	{ 0x5bcab000, 0x5bcaf3ff, REGISTRY_RIPENCC    }, // 91.202.176.0    - 91.202.243.255 
	{ 0x5bcafc00, 0x5bcb4bff, REGISTRY_RIPENCC    }, // 91.202.252.0    - 91.203.75.255  
	{ 0x5bcb5000, 0x5bcb5bff, REGISTRY_RIPENCC    }, // 91.203.80.0     - 91.203.91.255  
	{ 0x5bcb6000, 0x5bcbe3ff, REGISTRY_RIPENCC    }, // 91.203.96.0     - 91.203.227.255 
	{ 0x5bcbe800, 0x5bcc13ff, REGISTRY_RIPENCC    }, // 91.203.232.0    - 91.204.19.255  
	{ 0x5bcc1400, 0x5bcc17ff, REGISTRY_RIPENCC    }, // 91.204.20.0     - 91.204.23.255  
	{ 0x5bcc1800, 0x5bcc27ff, REGISTRY_RIPENCC    }, // 91.204.24.0     - 91.204.39.255  
	{ 0x5bcc3800, 0x5bccdbff, REGISTRY_RIPENCC    }, // 91.204.56.0     - 91.204.219.255 
	{ 0x5bcce000, 0x5bcd67ff, REGISTRY_RIPENCC    }, // 91.204.224.0    - 91.205.103.255 
	{ 0x5bcd7000, 0x5bcdbbff, REGISTRY_RIPENCC    }, // 91.205.112.0    - 91.205.187.255 
	{ 0x5bcdc000, 0x5bcdc3ff, REGISTRY_RIPENCC    }, // 91.205.192.0    - 91.205.195.255 
	{ 0x5bcdc800, 0x5bce43ff, REGISTRY_RIPENCC    }, // 91.205.200.0    - 91.206.67.255  
	{ 0x5bce4600, 0x5bce5bff, REGISTRY_RIPENCC    }, // 91.206.70.0     - 91.206.91.255  
	{ 0x5bce5e00, 0x5bceffff, REGISTRY_RIPENCC    }, // 91.206.94.0     - 91.206.255.255 
	{ 0x5bcf0200, 0x5bcf0bff, REGISTRY_RIPENCC    }, // 91.207.2.0      - 91.207.11.255  
	{ 0x5bcf0e00, 0x5bcf45ff, REGISTRY_RIPENCC    }, // 91.207.14.0     - 91.207.69.255  
	{ 0x5bcf4800, 0x5bcf5fff, REGISTRY_RIPENCC    }, // 91.207.72.0     - 91.207.95.255  
	{ 0x5bcf6200, 0x5bcf6bff, REGISTRY_RIPENCC    }, // 91.207.98.0     - 91.207.107.255 
	{ 0x5bcf6e00, 0x5bcf99ff, REGISTRY_RIPENCC    }, // 91.207.110.0    - 91.207.153.255 
	{ 0x5bcf9c00, 0x5bcfabff, REGISTRY_RIPENCC    }, // 91.207.156.0    - 91.207.171.255 
	{ 0x5bcfb000, 0x5bcfb1ff, REGISTRY_RIPENCC    }, // 91.207.176.0    - 91.207.177.255 
	{ 0x5bcfb400, 0x5bcfc3ff, REGISTRY_RIPENCC    }, // 91.207.180.0    - 91.207.195.255 
	{ 0x5bcfc600, 0x5bcfddff, REGISTRY_RIPENCC    }, // 91.207.198.0    - 91.207.221.255 
	{ 0x5bcfe000, 0x5bcfe5ff, REGISTRY_RIPENCC    }, // 91.207.224.0    - 91.207.229.255 
	{ 0x5bcfe800, 0x5bcfe9ff, REGISTRY_RIPENCC    }, // 91.207.232.0    - 91.207.233.255 
	{ 0x5bcfec00, 0x5bd00fff, REGISTRY_RIPENCC    }, // 91.207.236.0    - 91.208.15.255  
	{ 0x5bd01100, 0x5bd012ff, REGISTRY_RIPENCC    }, // 91.208.17.0     - 91.208.18.255  
	{ 0x5bd01400, 0x5bd014ff, REGISTRY_RIPENCC    }, // 91.208.20.0     - 91.208.20.255  
	{ 0x5bd01600, 0x5bd01eff, REGISTRY_RIPENCC    }, // 91.208.22.0     - 91.208.30.255  
	{ 0x5bd02000, 0x5bd02dff, REGISTRY_RIPENCC    }, // 91.208.32.0     - 91.208.45.255  
	{ 0x5bd02f00, 0x5bd044ff, REGISTRY_RIPENCC    }, // 91.208.47.0     - 91.208.68.255  
	{ 0x5bd04600, 0x5bd067ff, REGISTRY_RIPENCC    }, // 91.208.70.0     - 91.208.103.255 
	{ 0x5bd06900, 0x5bd070ff, REGISTRY_RIPENCC    }, // 91.208.105.0    - 91.208.112.255 
	{ 0x5bd07200, 0x5bd07fff, REGISTRY_RIPENCC    }, // 91.208.114.0    - 91.208.127.255 
	{ 0x5bd08100, 0x5bd088ff, REGISTRY_RIPENCC    }, // 91.208.129.0    - 91.208.136.255 
	{ 0x5bd08a00, 0x5bd0a1ff, REGISTRY_RIPENCC    }, // 91.208.138.0    - 91.208.161.255 
	{ 0x5bd0a300, 0x5bd0c4ff, REGISTRY_RIPENCC    }, // 91.208.163.0    - 91.208.196.255 
	{ 0x5bd0c600, 0x5bd0cdff, REGISTRY_RIPENCC    }, // 91.208.198.0    - 91.208.205.255 
	{ 0x5bd0cf00, 0x5bd0cfff, REGISTRY_RIPENCC    }, // 91.208.207.0    - 91.208.207.255 
	{ 0x5bd0d100, 0x5bd0e3ff, REGISTRY_RIPENCC    }, // 91.208.209.0    - 91.208.227.255 
	{ 0x5bd0e500, 0x5bd0e5ff, REGISTRY_RIPENCC    }, // 91.208.229.0    - 91.208.229.255 
	{ 0x5bd0e700, 0x5bd0ebff, REGISTRY_RIPENCC    }, // 91.208.231.0    - 91.208.235.255 
	{ 0x5bd0ed00, 0x5bd0efff, REGISTRY_RIPENCC    }, // 91.208.237.0    - 91.208.239.255 
	{ 0x5bd0f100, 0x5bd0f5ff, REGISTRY_RIPENCC    }, // 91.208.241.0    - 91.208.245.255 
	{ 0x5bd0f700, 0x5bd10dff, REGISTRY_RIPENCC    }, // 91.208.247.0    - 91.209.13.255  
	{ 0x5bd10f00, 0x5bd114ff, REGISTRY_RIPENCC    }, // 91.209.15.0     - 91.209.20.255  
	{ 0x5bd11700, 0x5bd127ff, REGISTRY_RIPENCC    }, // 91.209.23.0     - 91.209.39.255  
	{ 0x5bd12900, 0x5bd12fff, REGISTRY_RIPENCC    }, // 91.209.41.0     - 91.209.47.255  
	{ 0x5bd13100, 0x5bd139ff, REGISTRY_RIPENCC    }, // 91.209.49.0     - 91.209.57.255  
	{ 0x5bd13b00, 0x5bd13dff, REGISTRY_RIPENCC    }, // 91.209.59.0     - 91.209.61.255  
	{ 0x5bd14000, 0x5bd143ff, REGISTRY_RIPENCC    }, // 91.209.64.0     - 91.209.67.255  
	{ 0x5bd14500, 0x5bd162ff, REGISTRY_RIPENCC    }, // 91.209.69.0     - 91.209.98.255  
	{ 0x5bd16500, 0x5bd172ff, REGISTRY_RIPENCC    }, // 91.209.101.0    - 91.209.114.255 
	{ 0x5bd17400, 0x5bd194ff, REGISTRY_RIPENCC    }, // 91.209.116.0    - 91.209.148.255 
	{ 0x5bd19600, 0x5bd196ff, REGISTRY_RIPENCC    }, // 91.209.150.0    - 91.209.150.255 
	{ 0x5bd19800, 0x5bd1a2ff, REGISTRY_RIPENCC    }, // 91.209.152.0    - 91.209.162.255 
	{ 0x5bd1a400, 0x5bd1b2ff, REGISTRY_RIPENCC    }, // 91.209.164.0    - 91.209.178.255 
	{ 0x5bd1b400, 0x5bd1b6ff, REGISTRY_RIPENCC    }, // 91.209.180.0    - 91.209.182.255 
	{ 0x5bd1b900, 0x5bd1b9ff, REGISTRY_RIPENCC    }, // 91.209.185.0    - 91.209.185.255 
	{ 0x5bd1bb00, 0x5bd1d0ff, REGISTRY_RIPENCC    }, // 91.209.187.0    - 91.209.208.255 
	{ 0x5bd1d200, 0x5bd1dfff, REGISTRY_RIPENCC    }, // 91.209.210.0    - 91.209.223.255 
	{ 0x5bd1e100, 0x5bd1e2ff, REGISTRY_RIPENCC    }, // 91.209.225.0    - 91.209.226.255 
	{ 0x5bd1e400, 0x5bd1e5ff, REGISTRY_RIPENCC    }, // 91.209.228.0    - 91.209.229.255 
	{ 0x5bd1e700, 0x5bd237ff, REGISTRY_RIPENCC    }, // 91.209.231.0    - 91.210.55.255  
	{ 0x5bd23c00, 0x5bd263ff, REGISTRY_RIPENCC    }, // 91.210.60.0     - 91.210.99.255  
	{ 0x5bd26800, 0x5bd33fff, REGISTRY_RIPENCC    }, // 91.210.104.0    - 91.211.63.255  
	{ 0x5bd34400, 0x5bd357ff, REGISTRY_RIPENCC    }, // 91.211.68.0     - 91.211.87.255  
	{ 0x5bd35c00, 0x5bd397ff, REGISTRY_RIPENCC    }, // 91.211.92.0     - 91.211.151.255 
	{ 0x5bd39c00, 0x5bd3c3ff, REGISTRY_RIPENCC    }, // 91.211.156.0    - 91.211.195.255 
	{ 0x5bd3c800, 0x5bd3dfff, REGISTRY_RIPENCC    }, // 91.211.200.0    - 91.211.223.255 
	{ 0x5bd3e400, 0x5bd3f7ff, REGISTRY_RIPENCC    }, // 91.211.228.0    - 91.211.247.255 
	{ 0x5bd3fc00, 0x5bd40aff, REGISTRY_RIPENCC    }, // 91.211.252.0    - 91.212.10.255  
	{ 0x5bd40c00, 0x5bd40dff, REGISTRY_RIPENCC    }, // 91.212.12.0     - 91.212.13.255  
	{ 0x5bd40f00, 0x5bd413ff, REGISTRY_RIPENCC    }, // 91.212.15.0     - 91.212.19.255  
	{ 0x5bd41500, 0x5bd41aff, REGISTRY_RIPENCC    }, // 91.212.21.0     - 91.212.26.255  
	{ 0x5bd41c00, 0x5bd425ff, REGISTRY_RIPENCC    }, // 91.212.28.0     - 91.212.37.255  
	{ 0x5bd42700, 0x5bd428ff, REGISTRY_RIPENCC    }, // 91.212.39.0     - 91.212.40.255  
	{ 0x5bd42a00, 0x5bd430ff, REGISTRY_RIPENCC    }, // 91.212.42.0     - 91.212.48.255  
	{ 0x5bd43200, 0x5bd432ff, REGISTRY_RIPENCC    }, // 91.212.50.0     - 91.212.50.255  
	{ 0x5bd43400, 0x5bd435ff, REGISTRY_RIPENCC    }, // 91.212.52.0     - 91.212.53.255  
	{ 0x5bd43800, 0x5bd440ff, REGISTRY_RIPENCC    }, // 91.212.56.0     - 91.212.64.255  
	{ 0x5bd44200, 0x5bd447ff, REGISTRY_RIPENCC    }, // 91.212.66.0     - 91.212.71.255  
	{ 0x5bd44a00, 0x5bd46aff, REGISTRY_RIPENCC    }, // 91.212.74.0     - 91.212.106.255 
	{ 0x5bd46c00, 0x5bd48cff, REGISTRY_RIPENCC    }, // 91.212.108.0    - 91.212.140.255 
	{ 0x5bd48e00, 0x5bd4e1ff, REGISTRY_RIPENCC    }, // 91.212.142.0    - 91.212.225.255 
	{ 0x5bd4e300, 0x5bd531ff, REGISTRY_RIPENCC    }, // 91.212.227.0    - 91.213.49.255  
	{ 0x5bd53300, 0x5bd549ff, REGISTRY_RIPENCC    }, // 91.213.51.0     - 91.213.73.255  
	{ 0x5bd54c00, 0x5bd574ff, REGISTRY_RIPENCC    }, // 91.213.76.0     - 91.213.116.255 
	{ 0x5bd57600, 0x5bd577ff, REGISTRY_RIPENCC    }, // 91.213.118.0    - 91.213.119.255 
	{ 0x5bd57900, 0x5bd589ff, REGISTRY_RIPENCC    }, // 91.213.121.0    - 91.213.137.255 
	{ 0x5bd58b00, 0x5bd596ff, REGISTRY_RIPENCC    }, // 91.213.139.0    - 91.213.150.255 
	{ 0x5bd59800, 0x5bd61fff, REGISTRY_RIPENCC    }, // 91.213.152.0    - 91.214.31.255  
	{ 0x5bd62400, 0x5bd63fff, REGISTRY_RIPENCC    }, // 91.214.36.0     - 91.214.63.255  
	{ 0x5bd64400, 0x5bd65bff, REGISTRY_RIPENCC    }, // 91.214.68.0     - 91.214.91.255  
	{ 0x5bd66000, 0x5bd73fff, REGISTRY_RIPENCC    }, // 91.214.96.0     - 91.215.63.255  
	{ 0x5bd74000, 0x5bd743ff, REGISTRY_RIPENCC    }, // 91.215.64.0     - 91.215.67.255  
	{ 0x5bd74400, 0x5bd80aff, REGISTRY_RIPENCC    }, // 91.215.68.0     - 91.216.10.255  
	{ 0x5bd80c00, 0x5bd826ff, REGISTRY_RIPENCC    }, // 91.216.12.0     - 91.216.38.255  
	{ 0x5bd82800, 0x5bd879ff, REGISTRY_RIPENCC    }, // 91.216.40.0     - 91.216.121.255 
	{ 0x5bd87b00, 0x5bd8bdff, REGISTRY_RIPENCC    }, // 91.216.123.0    - 91.216.189.255 
	{ 0x5bd8bf00, 0x5bd94fff, REGISTRY_RIPENCC    }, // 91.216.191.0    - 91.217.79.255  
	{ 0x5bd95200, 0x5bd9a6ff, REGISTRY_RIPENCC    }, // 91.217.82.0     - 91.217.166.255 
	{ 0x5bd9a800, 0x5bd9c7ff, REGISTRY_RIPENCC    }, // 91.217.168.0    - 91.217.199.255 
	{ 0x5bd9c900, 0x5bd9ceff, REGISTRY_RIPENCC    }, // 91.217.201.0    - 91.217.206.255 
	{ 0x5bd9d000, 0x5bd9deff, REGISTRY_RIPENCC    }, // 91.217.208.0    - 91.217.222.255 
	{ 0x5bd9e000, 0x5bd9eeff, REGISTRY_RIPENCC    }, // 91.217.224.0    - 91.217.238.255 
	{ 0x5bd9f000, 0x5bd9f9ff, REGISTRY_RIPENCC    }, // 91.217.240.0    - 91.217.249.255 
	{ 0x5bd9fb00, 0x5bda13ff, REGISTRY_RIPENCC    }, // 91.217.251.0    - 91.218.19.255  
	{ 0x5bda1800, 0x5bda37ff, REGISTRY_RIPENCC    }, // 91.218.24.0     - 91.218.55.255  
	{ 0x5bda3c00, 0x5bda3fff, REGISTRY_RIPENCC    }, // 91.218.60.0     - 91.218.63.255  
	{ 0x5bda4400, 0x5bdc1bff, REGISTRY_RIPENCC    }, // 91.218.68.0     - 91.220.27.255  
	{ 0x5bdc1d00, 0x5bdc46ff, REGISTRY_RIPENCC    }, // 91.220.29.0     - 91.220.70.255  
	{ 0x5bdc4800, 0x5bdcafff, REGISTRY_RIPENCC    }, // 91.220.72.0     - 91.220.175.255 
	{ 0x5bdcb100, 0x5bdcb9ff, REGISTRY_RIPENCC    }, // 91.220.177.0    - 91.220.185.255 
	{ 0x5bdcbb00, 0x5bdccaff, REGISTRY_RIPENCC    }, // 91.220.187.0    - 91.220.202.255 
	{ 0x5bdccc00, 0x5bdce4ff, REGISTRY_RIPENCC    }, // 91.220.204.0    - 91.220.228.255 
	{ 0x5bdce600, 0x5bdd73ff, REGISTRY_RIPENCC    }, // 91.220.230.0    - 91.221.115.255 
	{ 0x5bdd7600, 0x5bdf45ff, REGISTRY_RIPENCC    }, // 91.221.118.0    - 91.223.69.255  
	{ 0x5bdf4700, 0x5bdf4aff, REGISTRY_RIPENCC    }, // 91.223.71.0     - 91.223.74.255  
	{ 0x5bdf4c00, 0x5bdf62ff, REGISTRY_RIPENCC    }, // 91.223.76.0     - 91.223.98.255  
	{ 0x5bdf6400, 0x5bdfa2ff, REGISTRY_RIPENCC    }, // 91.223.100.0    - 91.223.162.255 
	{ 0x5bdfa400, 0x5bdfa8ff, REGISTRY_RIPENCC    }, // 91.223.164.0    - 91.223.168.255 
	{ 0x5bdfaa00, 0x5be03fff, REGISTRY_RIPENCC    }, // 91.223.170.0    - 91.224.63.255  
	{ 0x5be04200, 0x5be063ff, REGISTRY_RIPENCC    }, // 91.224.66.0     - 91.224.99.255  
	{ 0x5be06600, 0x5be0e3ff, REGISTRY_RIPENCC    }, // 91.224.102.0    - 91.224.227.255 
	{ 0x5be0e600, 0x5be0f5ff, REGISTRY_RIPENCC    }, // 91.224.230.0    - 91.224.245.255 
	{ 0x5be0f800, 0x5be24bff, REGISTRY_RIPENCC    }, // 91.224.248.0    - 91.226.75.255  
	{ 0x5be24d00, 0x5be253ff, REGISTRY_RIPENCC    }, // 91.226.77.0     - 91.226.83.255  
	{ 0x5be25800, 0x5be2dcff, REGISTRY_RIPENCC    }, // 91.226.88.0     - 91.226.220.255 
	{ 0x5be2de00, 0x5be3a9ff, REGISTRY_RIPENCC    }, // 91.226.222.0    - 91.227.169.255 
	{ 0x5be3ac00, 0x5be3c7ff, REGISTRY_RIPENCC    }, // 91.227.172.0    - 91.227.199.255 
	{ 0x5be3c800, 0x5be3cbff, REGISTRY_RIPENCC    }, // 91.227.200.0    - 91.227.203.255 
	{ 0x5be3cc00, 0x5be3f5ff, REGISTRY_RIPENCC    }, // 91.227.204.0    - 91.227.245.255 
	{ 0x5be3f800, 0x5be3fcff, REGISTRY_RIPENCC    }, // 91.227.248.0    - 91.227.252.255 
	{ 0x5be3fe00, 0x5be49fff, REGISTRY_RIPENCC    }, // 91.227.254.0    - 91.228.159.255 
	{ 0x5be4a100, 0x5be4e6ff, REGISTRY_RIPENCC    }, // 91.228.161.0    - 91.228.230.255 
	{ 0x5be4e800, 0x5be52dff, REGISTRY_RIPENCC    }, // 91.228.232.0    - 91.229.45.255  
	{ 0x5be53000, 0x5be559ff, REGISTRY_RIPENCC    }, // 91.229.48.0     - 91.229.89.255  
	{ 0x5be55c00, 0x5be583ff, REGISTRY_RIPENCC    }, // 91.229.92.0     - 91.229.131.255 
	{ 0x5be58800, 0x5be5b5ff, REGISTRY_RIPENCC    }, // 91.229.136.0    - 91.229.181.255 
	{ 0x5be5b700, 0x5be66eff, REGISTRY_RIPENCC    }, // 91.229.183.0    - 91.230.110.255 
	{ 0x5be67000, 0x5be685ff, REGISTRY_RIPENCC    }, // 91.230.112.0    - 91.230.133.255 
	{ 0x5be68700, 0x5be687ff, REGISTRY_RIPENCC    }, // 91.230.135.0    - 91.230.135.255 
	{ 0x5be68c00, 0x5be68eff, REGISTRY_RIPENCC    }, // 91.230.140.0    - 91.230.142.255 
	{ 0x5be69000, 0x5be692ff, REGISTRY_RIPENCC    }, // 91.230.144.0    - 91.230.146.255 
	{ 0x5be69400, 0x5be6b5ff, REGISTRY_RIPENCC    }, // 91.230.148.0    - 91.230.181.255 
	{ 0x5be6b800, 0x5be6e3ff, REGISTRY_RIPENCC    }, // 91.230.184.0    - 91.230.227.255 
	{ 0x5be6e600, 0x5be758ff, REGISTRY_RIPENCC    }, // 91.230.230.0    - 91.231.88.255  
	{ 0x5be75a00, 0x5be7c7ff, REGISTRY_RIPENCC    }, // 91.231.90.0     - 91.231.199.255 
	{ 0x5be7cc00, 0x5be862ff, REGISTRY_RIPENCC    }, // 91.231.204.0    - 91.232.98.255  
	{ 0x5be86400, 0x5be880ff, REGISTRY_RIPENCC    }, // 91.232.100.0    - 91.232.128.255 
	{ 0x5be88200, 0x5be8cfff, REGISTRY_RIPENCC    }, // 91.232.130.0    - 91.232.207.255 
	{ 0x5be8d100, 0x5be8eaff, REGISTRY_RIPENCC    }, // 91.232.209.0    - 91.232.234.255 
	{ 0x5be8ec00, 0x5be8feff, REGISTRY_RIPENCC    }, // 91.232.236.0    - 91.232.254.255 
	{ 0x5be90000, 0x5be913ff, REGISTRY_RIPENCC    }, // 91.233.0.0      - 91.233.19.255  
	{ 0x5be91500, 0x5be977ff, REGISTRY_RIPENCC    }, // 91.233.21.0     - 91.233.119.255 
	{ 0x5be97a00, 0x5be981ff, REGISTRY_RIPENCC    }, // 91.233.122.0    - 91.233.129.255 
	{ 0x5be98400, 0x5beafdff, REGISTRY_RIPENCC    }, // 91.233.132.0    - 91.234.253.255 
	{ 0x5beaff00, 0x5bebf0ff, REGISTRY_RIPENCC    }, // 91.234.255.0    - 91.235.240.255 
	{ 0x5bebf200, 0x5bec72ff, REGISTRY_RIPENCC    }, // 91.235.242.0    - 91.236.114.255 
	{ 0x5bec7400, 0x5bec78ff, REGISTRY_RIPENCC    }, // 91.236.116.0    - 91.236.120.255 
	{ 0x5bec7a00, 0x5bee11ff, REGISTRY_RIPENCC    }, // 91.236.122.0    - 91.238.17.255  
	{ 0x5bee1300, 0x5bef24ff, REGISTRY_RIPENCC    }, // 91.238.19.0     - 91.239.36.255  
	{ 0x5bef2600, 0x5bef81ff, REGISTRY_RIPENCC    }, // 91.239.38.0     - 91.239.129.255 
	{ 0x5bef8300, 0x5bef9cff, REGISTRY_RIPENCC    }, // 91.239.131.0    - 91.239.156.255 
	{ 0x5bef9e00, 0x5bf058ff, REGISTRY_RIPENCC    }, // 91.239.158.0    - 91.240.88.255  
	{ 0x5bf05a00, 0x5bf15cff, REGISTRY_RIPENCC    }, // 91.240.90.0     - 91.241.92.255  
	{ 0x5bf15e00, 0x5bf5dfff, REGISTRY_RIPENCC    }, // 91.241.94.0     - 91.245.223.255 
	{ 0x5bf60000, 0x5bf7ffff, REGISTRY_RIPENCC    }, // 91.246.0.0      - 91.247.255.255 
	{ 0x5bf80000, 0x5c3c1fff, REGISTRY_RIPENCC    }, // 91.248.0.0      - 92.60.31.255   
	{ 0x5c3c3000, 0x5cf29fff, REGISTRY_RIPENCC    }, // 92.60.48.0      - 92.242.159.255 
	{ 0x5cf2c000, 0x5cf63fff, REGISTRY_RIPENCC    }, // 92.242.192.0    - 92.246.63.255  
	{ 0x5cf66000, 0x5cf8ffff, REGISTRY_RIPENCC    }, // 92.246.96.0     - 92.248.255.255 
	{ 0x5cf94000, 0x5cf97fff, REGISTRY_RIPENCC    }, // 92.249.64.0     - 92.249.127.255 
	{ 0x5cf98000, 0x5d5a3fff, REGISTRY_RIPENCC    }, // 92.249.128.0    - 93.90.63.255   
	{ 0x5d5a5000, 0x5d5d67ff, REGISTRY_RIPENCC    }, // 93.90.80.0      - 93.93.103.255  
	{ 0x5d5d7000, 0x5d7dffff, REGISTRY_RIPENCC    }, // 93.93.112.0     - 93.125.255.255 
	{ 0x5d7e0000, 0x5d7e7fff, REGISTRY_RIPENCC    }, // 93.126.0.0      - 93.126.127.255 
	{ 0x5d7e8000, 0x5d9cffff, REGISTRY_RIPENCC    }, // 93.126.128.0    - 93.156.255.255 
	{ 0x5d9d0000, 0x5d9dffff, REGISTRY_RIPENCC    }, // 93.157.0.0      - 93.157.255.255 
	{ 0x5d9e0000, 0x5daeffff, REGISTRY_RIPENCC    }, // 93.158.0.0      - 93.174.255.255 
	{ 0x5daf0000, 0x5dafffff, REGISTRY_RIPENCC    }, // 93.175.0.0      - 93.175.255.255 
	{ 0x5db00000, 0x5db13fff, REGISTRY_RIPENCC    }, // 93.176.0.0      - 93.177.63.255  
	{ 0x5db18000, 0x5db99fff, REGISTRY_RIPENCC    }, // 93.177.128.0    - 93.185.159.255 
	{ 0x5db9b000, 0x5dbb7fff, REGISTRY_RIPENCC    }, // 93.185.176.0    - 93.187.127.255 
	{ 0x5dbb8800, 0x5dbc37ff, REGISTRY_RIPENCC    }, // 93.187.136.0    - 93.188.55.255  
	{ 0x5dbc4000, 0x5dbd77ff, REGISTRY_RIPENCC    }, // 93.188.64.0     - 93.189.119.255 
	{ 0x5dbd8000, 0x5dbe07ff, REGISTRY_RIPENCC    }, // 93.189.128.0    - 93.190.7.255   
	{ 0x5dbe1000, 0x5e2cffff, REGISTRY_RIPENCC    }, // 93.190.16.0     - 94.44.255.255  
	{ 0x5e2d0000, 0x5e2dffff, REGISTRY_RIPENCC    }, // 94.45.0.0       - 94.45.255.255  
	{ 0x5e2e0000, 0x5e656fff, REGISTRY_RIPENCC    }, // 94.46.0.0       - 94.101.111.255 
	{ 0x5e658000, 0x5e676fff, REGISTRY_RIPENCC    }, // 94.101.128.0    - 94.103.111.255 
	{ 0x5e678000, 0x5e7c5fff, REGISTRY_RIPENCC    }, // 94.103.128.0    - 94.124.95.255  
	{ 0x5e7c6800, 0x5e8e7fff, REGISTRY_RIPENCC    }, // 94.124.104.0    - 94.142.127.255 
	{ 0x5e8e8800, 0x5e8eafff, REGISTRY_RIPENCC    }, // 94.142.136.0    - 94.142.175.255 
	{ 0x5e8eb800, 0x5e8f9fff, REGISTRY_RIPENCC    }, // 94.142.184.0    - 94.143.159.255 
	{ 0x5e8fa800, 0x5e99ffff, REGISTRY_RIPENCC    }, // 94.143.168.0    - 94.153.255.255 
	{ 0x5e9a0000, 0x5e9affff, REGISTRY_RIPENCC    }, // 94.154.0.0      - 94.154.255.255 
	{ 0x5e9b0000, 0x5e9dffff, REGISTRY_RIPENCC    }, // 94.155.0.0      - 94.157.255.255 
	{ 0x5e9e0000, 0x5e9e0fff, REGISTRY_RIPENCC    }, // 94.158.0.0      - 94.158.15.255  
	{ 0x5e9e2000, 0x5e9eefff, REGISTRY_RIPENCC    }, // 94.158.32.0     - 94.158.239.255 
	{ 0x5e9f0000, 0x5ec75fff, REGISTRY_RIPENCC    }, // 94.159.0.0      - 94.199.95.255  
	{ 0x5ec76800, 0x5ec787ff, REGISTRY_RIPENCC    }, // 94.199.104.0    - 94.199.135.255 
	{ 0x5ec79000, 0x5ee6ffff, REGISTRY_RIPENCC    }, // 94.199.144.0    - 94.230.255.255 
	{ 0x5ee70000, 0x5ee7dfff, REGISTRY_RIPENCC    }, // 94.231.0.0      - 94.231.223.255 
	{ 0x5ee7e000, 0x5ee7efff, REGISTRY_RIPENCC    }, // 94.231.224.0    - 94.231.239.255 
	{ 0x5ee7f000, 0x5ee897ff, REGISTRY_RIPENCC    }, // 94.231.240.0    - 94.232.151.255 
	{ 0x5ee89800, 0x5ee89fff, REGISTRY_RIPENCC    }, // 94.232.152.0    - 94.232.159.255 
	{ 0x5ee8a000, 0x5ee8efff, REGISTRY_RIPENCC    }, // 94.232.160.0    - 94.232.239.255 
	{ 0x5ee90000, 0x5ef3ffff, REGISTRY_RIPENCC    }, // 94.233.0.0      - 94.243.255.255 
	{ 0x5ef40000, 0x5ef4ffff, REGISTRY_RIPENCC    }, // 94.244.0.0      - 94.244.255.255 
	{ 0x5ef50000, 0x5ef787ff, REGISTRY_RIPENCC    }, // 94.245.0.0      - 94.247.135.255 
	{ 0x5ef79000, 0x5f82dfff, REGISTRY_RIPENCC    }, // 94.247.144.0    - 95.130.223.255 
	{ 0x5f82e800, 0x5fae3fff, REGISTRY_RIPENCC    }, // 95.130.232.0    - 95.174.63.255  
	{ 0x5fae4800, 0x5fd6ffff, REGISTRY_RIPENCC    }, // 95.174.72.0     - 95.214.255.255 
	{ 0x5fd70000, 0x5fd72bff, REGISTRY_RIPENCC    }, // 95.215.0.0      - 95.215.43.255  
	{ 0x5fd72c00, 0x5fd72fff, REGISTRY_RIPENCC    }, // 95.215.44.0     - 95.215.47.255  
	{ 0x5fd73000, 0x5fd74fff, REGISTRY_RIPENCC    }, // 95.215.48.0     - 95.215.79.255  
	{ 0x5fd75400, 0x5fd767ff, REGISTRY_RIPENCC    }, // 95.215.84.0     - 95.215.103.255 
	{ 0x5fd76800, 0x5fd76bff, REGISTRY_RIPENCC    }, // 95.215.104.0    - 95.215.107.255 
	{ 0x5fd76c00, 0x5fd78bff, REGISTRY_RIPENCC    }, // 95.215.108.0    - 95.215.139.255 
	{ 0x5fd79000, 0x5fd7ffff, REGISTRY_RIPENCC    }, // 95.215.144.0    - 95.215.255.255 
	{ 0x5fd80000, 0x5fffffff, REGISTRY_RIPENCC    }, // 95.216.0.0      - 95.255.255.255 
	{ 0x60000000, 0x643fffff, REGISTRY_ARIN       }, // 96.0.0.0        - 100.63.255.255 
	{ 0x64800000, 0x64ffffff, REGISTRY_ARIN       }, // 100.128.0.0     - 100.255.255.255
	{ 0x65000000, 0x653207ff, REGISTRY_APNIC      }, // 101.0.0.0       - 101.50.7.255   
	{ 0x65321000, 0x65ffffff, REGISTRY_APNIC      }, // 101.50.16.0     - 101.255.255.255
	{ 0x67000000, 0x6701dbff, REGISTRY_APNIC      }, // 103.0.0.0       - 103.1.219.255  
	{ 0x6701e000, 0x67031bff, REGISTRY_APNIC      }, // 103.1.224.0     - 103.3.27.255   
	{ 0x67032000, 0x670413ff, REGISTRY_APNIC      }, // 103.3.32.0      - 103.4.19.255   
	{ 0x67041800, 0x6704dfff, REGISTRY_APNIC      }, // 103.4.24.0      - 103.4.223.255  
	{ 0x6704e400, 0x67054eff, REGISTRY_APNIC      }, // 103.4.228.0     - 103.5.78.255   
	{ 0x67055000, 0x670567ff, REGISTRY_APNIC      }, // 103.5.80.0      - 103.5.103.255  
	{ 0x67056900, 0x670569ff, REGISTRY_APNIC      }, // 103.5.105.0     - 103.5.105.255  
	{ 0x67056b00, 0x670597ff, REGISTRY_APNIC      }, // 103.5.107.0     - 103.5.151.255  
	{ 0x67059c00, 0x6705a7ff, REGISTRY_APNIC      }, // 103.5.156.0     - 103.5.167.255  
	{ 0x6705ac00, 0x6705bfff, REGISTRY_APNIC      }, // 103.5.172.0     - 103.5.191.255  
	{ 0x6705c400, 0x6705e5ff, REGISTRY_APNIC      }, // 103.5.196.0     - 103.5.229.255  
	{ 0x6705e800, 0x670602ff, REGISTRY_APNIC      }, // 103.5.232.0     - 103.6.2.255    
	{ 0x67060400, 0x670659ff, REGISTRY_APNIC      }, // 103.6.4.0       - 103.6.89.255   
	{ 0x67065c00, 0x670667ff, REGISTRY_APNIC      }, // 103.6.92.0      - 103.6.103.255  
	{ 0x67066900, 0x67066bff, REGISTRY_APNIC      }, // 103.6.105.0     - 103.6.107.255  
	{ 0x67067000, 0x6706e3ff, REGISTRY_APNIC      }, // 103.6.112.0     - 103.6.227.255  
	{ 0x6706e800, 0x67078bff, REGISTRY_APNIC      }, // 103.6.232.0     - 103.7.139.255  
	{ 0x67079000, 0x6707bdff, REGISTRY_APNIC      }, // 103.7.144.0     - 103.7.189.255  
	{ 0x6707c000, 0x670843ff, REGISTRY_APNIC      }, // 103.7.192.0     - 103.8.67.255   
	{ 0x67084800, 0x670878ff, REGISTRY_APNIC      }, // 103.8.72.0      - 103.8.120.255  
	{ 0x67087a00, 0x670913ff, REGISTRY_APNIC      }, // 103.8.122.0     - 103.9.19.255   
	{ 0x67091600, 0x670917ff, REGISTRY_APNIC      }, // 103.9.22.0      - 103.9.23.255   
	{ 0x67091c00, 0x67092fff, REGISTRY_APNIC      }, // 103.9.28.0      - 103.9.47.255   
	{ 0x67093200, 0x670932ff, REGISTRY_APNIC      }, // 103.9.50.0      - 103.9.50.255   
	{ 0x67093400, 0x67096aff, REGISTRY_APNIC      }, // 103.9.52.0      - 103.9.106.255  
	{ 0x67097000, 0x67098bff, REGISTRY_APNIC      }, // 103.9.112.0     - 103.9.139.255  
	{ 0x67099000, 0x670a09ff, REGISTRY_APNIC      }, // 103.9.144.0     - 103.10.9.255   
	{ 0x670a0b00, 0x670a2bff, REGISTRY_APNIC      }, // 103.10.11.0     - 103.10.43.255  
	{ 0x670a3000, 0x670a6cff, REGISTRY_APNIC      }, // 103.10.48.0     - 103.10.108.255 
	{ 0x670a6e00, 0x670aebff, REGISTRY_APNIC      }, // 103.10.110.0    - 103.10.235.255 
	{ 0x670af000, 0x670affff, REGISTRY_APNIC      }, // 103.10.240.0    - 103.10.255.255 
	{ 0x670b0400, 0x670b14ff, REGISTRY_APNIC      }, // 103.11.4.0      - 103.11.20.255  
	{ 0x670b1600, 0x670b47ff, REGISTRY_APNIC      }, // 103.11.22.0     - 103.11.71.255  
	{ 0x670b4a00, 0x670ba7ff, REGISTRY_APNIC      }, // 103.11.74.0     - 103.11.167.255 
	{ 0x670bac00, 0x670bffff, REGISTRY_APNIC      }, // 103.11.172.0    - 103.11.255.255 
	{ 0x670c0100, 0x670c5bff, REGISTRY_APNIC      }, // 103.12.1.0      - 103.12.91.255  
	{ 0x670c6000, 0x670cffff, REGISTRY_APNIC      }, // 103.12.96.0     - 103.12.255.255 
	{ 0x670d0100, 0x670d03ff, REGISTRY_APNIC      }, // 103.13.1.0      - 103.13.3.255   
	{ 0x670d0800, 0x670d0bff, REGISTRY_APNIC      }, // 103.13.8.0      - 103.13.11.255  
	{ 0x670d1000, 0x670d47ff, REGISTRY_APNIC      }, // 103.13.16.0     - 103.13.71.255  
	{ 0x670d4b00, 0x670d6fff, REGISTRY_APNIC      }, // 103.13.75.0     - 103.13.111.255 
	{ 0x670d7400, 0x670db7ff, REGISTRY_APNIC      }, // 103.13.116.0    - 103.13.183.255 
	{ 0x670dba00, 0x670ddbff, REGISTRY_APNIC      }, // 103.13.186.0    - 103.13.219.255 
	{ 0x670de000, 0x670dffff, REGISTRY_APNIC      }, // 103.13.224.0    - 103.13.255.255 
	{ 0x670e0100, 0x670e18ff, REGISTRY_APNIC      }, // 103.14.1.0      - 103.14.24.255  
	{ 0x670e1b00, 0x670e63ff, REGISTRY_APNIC      }, // 103.14.27.0     - 103.14.99.255  
	{ 0x670e6c00, 0x670ec3ff, REGISTRY_APNIC      }, // 103.14.108.0    - 103.14.195.255 
	{ 0x670ec800, 0x670fe3ff, REGISTRY_APNIC      }, // 103.14.200.0    - 103.15.227.255 
	{ 0x670fe800, 0x670ffbff, REGISTRY_APNIC      }, // 103.15.232.0    - 103.15.251.255 
	{ 0x67100000, 0x67110bff, REGISTRY_APNIC      }, // 103.16.0.0      - 103.17.11.255  
	{ 0x67111000, 0x67116bff, REGISTRY_APNIC      }, // 103.17.16.0     - 103.17.107.255 
	{ 0x67116e00, 0x671187ff, REGISTRY_APNIC      }, // 103.17.110.0    - 103.17.135.255 
	{ 0x67118c00, 0x6711f8ff, REGISTRY_APNIC      }, // 103.17.140.0    - 103.17.248.255 
	{ 0x6711fa00, 0x67124bff, REGISTRY_APNIC      }, // 103.17.250.0    - 103.18.75.255  
	{ 0x67125400, 0x67125bff, REGISTRY_APNIC      }, // 103.18.84.0     - 103.18.91.255  
	{ 0x67126000, 0x6712f7ff, REGISTRY_APNIC      }, // 103.18.96.0     - 103.18.247.255 
	{ 0x6712fc00, 0x6712ffff, REGISTRY_APNIC      }, // 103.18.252.0    - 103.18.255.255 
	{ 0x67130400, 0x671323ff, REGISTRY_APNIC      }, // 103.19.4.0      - 103.19.35.255  
	{ 0x67132500, 0x671326ff, REGISTRY_APNIC      }, // 103.19.37.0     - 103.19.38.255  
	{ 0x67132800, 0x67142bff, REGISTRY_APNIC      }, // 103.19.40.0     - 103.20.43.255  
	{ 0x67143000, 0x671439ff, REGISTRY_APNIC      }, // 103.20.48.0     - 103.20.57.255  
	{ 0x67143b00, 0x671443ff, REGISTRY_APNIC      }, // 103.20.59.0     - 103.20.67.255  
	{ 0x67144800, 0x671463ff, REGISTRY_APNIC      }, // 103.20.72.0     - 103.20.99.255  
	{ 0x67146800, 0x671503ff, REGISTRY_APNIC      }, // 103.20.104.0    - 103.21.3.255   
	{ 0x67150800, 0x6715ebff, REGISTRY_APNIC      }, // 103.21.8.0      - 103.21.235.255 
	{ 0x6715f000, 0x67168bff, REGISTRY_APNIC      }, // 103.21.240.0    - 103.22.139.255 
	{ 0x67169000, 0x6716cbff, REGISTRY_APNIC      }, // 103.22.144.0    - 103.22.203.255 
	{ 0x6716d100, 0x6716f3ff, REGISTRY_APNIC      }, // 103.22.209.0    - 103.22.243.255 
	{ 0x6716f800, 0x67171eff, REGISTRY_APNIC      }, // 103.22.248.0    - 103.23.30.255  
	{ 0x67172000, 0x671746ff, REGISTRY_APNIC      }, // 103.23.32.0     - 103.23.70.255  
	{ 0x67174800, 0x6717adff, REGISTRY_APNIC      }, // 103.23.72.0     - 103.23.173.255 
	{ 0x6717af00, 0x6717cbff, REGISTRY_APNIC      }, // 103.23.175.0    - 103.23.203.255 
	{ 0x6717d000, 0x671933ff, REGISTRY_APNIC      }, // 103.23.208.0    - 103.25.51.255  
	{ 0x67193500, 0x671977ff, REGISTRY_APNIC      }, // 103.25.53.0     - 103.25.119.255 
	{ 0x67197c00, 0x671a83ff, REGISTRY_APNIC      }, // 103.25.124.0    - 103.26.131.255 
	{ 0x671a8800, 0x671c33ff, REGISTRY_APNIC      }, // 103.26.136.0    - 103.28.51.255  
	{ 0x671c3600, 0x671cd3ff, REGISTRY_APNIC      }, // 103.28.54.0     - 103.28.211.255 
	{ 0x671cd800, 0x671cf3ff, REGISTRY_APNIC      }, // 103.28.216.0    - 103.28.243.255 
	{ 0x671cf800, 0x671d29ff, REGISTRY_APNIC      }, // 103.28.248.0    - 103.29.41.255  
	{ 0x671d2b00, 0x671debff, REGISTRY_APNIC      }, // 103.29.43.0     - 103.29.235.255 
	{ 0x671df000, 0x671e3fff, REGISTRY_APNIC      }, // 103.29.240.0    - 103.30.63.255  
	{ 0x671e4400, 0x671e73ff, REGISTRY_APNIC      }, // 103.30.68.0     - 103.30.115.255 
	{ 0x671e7800, 0x671eafff, REGISTRY_APNIC      }, // 103.30.120.0    - 103.30.175.255 
	{ 0x671eb400, 0x671edfff, REGISTRY_APNIC      }, // 103.30.180.0    - 103.30.223.255 
	{ 0x671ee400, 0x671febff, REGISTRY_APNIC      }, // 103.30.228.0    - 103.31.235.255 
	{ 0x671ff000, 0x671fffff, REGISTRY_APNIC      }, // 103.31.240.0    - 103.31.255.255 
	{ 0x67e00000, 0x67e663ff, REGISTRY_APNIC      }, // 103.224.0.0     - 103.230.99.255 
	{ 0x67e66500, 0x67eacfff, REGISTRY_APNIC      }, // 103.230.101.0   - 103.234.207.255
	{ 0x67ead800, 0x67ec63ff, REGISTRY_APNIC      }, // 103.234.216.0   - 103.236.99.255 
	{ 0x67ed0000, 0x67ef32ff, REGISTRY_APNIC      }, // 103.237.0.0     - 103.239.50.255 
	{ 0x67ef3400, 0x67ef3fff, REGISTRY_APNIC      }, // 103.239.52.0    - 103.239.63.255 
	{ 0x67f00000, 0x67f077ff, REGISTRY_APNIC      }, // 103.240.0.0     - 103.240.119.255
	{ 0x67f07c00, 0x67f1e3ff, REGISTRY_APNIC      }, // 103.240.124.0   - 103.241.227.255
	{ 0x67f1e800, 0x67f4ebff, REGISTRY_APNIC      }, // 103.241.232.0   - 103.244.235.255
	{ 0x67f4f000, 0x67f50fff, REGISTRY_APNIC      }, // 103.244.240.0   - 103.245.15.255 
	{ 0x67f51400, 0x67f627ff, REGISTRY_APNIC      }, // 103.245.20.0    - 103.246.39.255 
	{ 0x67f62c00, 0x67f668ff, REGISTRY_APNIC      }, // 103.246.44.0    - 103.246.104.255
	{ 0x67f66a00, 0x67f6bfff, REGISTRY_APNIC      }, // 103.246.106.0   - 103.246.191.255
	{ 0x67f6c400, 0x67f6d9ff, REGISTRY_APNIC      }, // 103.246.196.0   - 103.246.217.255
	{ 0x67f6dc00, 0x67f703ff, REGISTRY_APNIC      }, // 103.246.220.0   - 103.247.3.255  
	{ 0x67f70800, 0x67f723ff, REGISTRY_APNIC      }, // 103.247.8.0     - 103.247.35.255 
	{ 0x67f72600, 0x67f733ff, REGISTRY_APNIC      }, // 103.247.38.0    - 103.247.51.255 
	{ 0x67f73800, 0x67f7b3ff, REGISTRY_APNIC      }, // 103.247.56.0    - 103.247.179.255
	{ 0x67f7b600, 0x67f857ff, REGISTRY_APNIC      }, // 103.247.182.0   - 103.248.87.255 
	{ 0x67f85c00, 0x67f8dbff, REGISTRY_APNIC      }, // 103.248.92.0    - 103.248.219.255
	{ 0x67f8e000, 0x67f983ff, REGISTRY_APNIC      }, // 103.248.224.0   - 103.249.131.255
	{ 0x67f98800, 0x67f99bff, REGISTRY_APNIC      }, // 103.249.136.0   - 103.249.155.255
	{ 0x67f9a000, 0x67f9ffff, REGISTRY_APNIC      }, // 103.249.160.0   - 103.249.255.255
	{ 0x67fa0400, 0x67ffffff, REGISTRY_APNIC      }, // 103.250.4.0     - 103.255.255.255
	{ 0x68000000, 0x68ffffff, REGISTRY_ARIN       }, // 104.0.0.0       - 104.255.255.255
	{ 0x69100000, 0x69ffffff, REGISTRY_AFRINIC    }, // 105.16.0.0      - 105.255.255.255
	{ 0x6a000000, 0x6a001fff, REGISTRY_APNIC      }, // 106.0.0.0       - 106.0.31.255   
	{ 0x6a004000, 0x6affffff, REGISTRY_APNIC      }, // 106.0.64.0      - 106.255.255.255
	{ 0x6b000000, 0x6cffffff, REGISTRY_ARIN       }, // 107.0.0.0       - 108.255.255.255
	{ 0x6d000000, 0x6d4797ff, REGISTRY_RIPENCC    }, // 109.0.0.0       - 109.71.151.255 
	{ 0x6d47a000, 0x6d497fff, REGISTRY_RIPENCC    }, // 109.71.160.0    - 109.73.127.255 
	{ 0x6d499000, 0x6d5dffff, REGISTRY_RIPENCC    }, // 109.73.144.0    - 109.93.255.255 
	{ 0x6d5e0000, 0x6d5f77ff, REGISTRY_RIPENCC    }, // 109.94.0.0      - 109.95.119.255 
	{ 0x6d5f8000, 0x6d5f9fff, REGISTRY_RIPENCC    }, // 109.95.128.0    - 109.95.159.255 
	{ 0x6d5fa000, 0x6d5fa7ff, REGISTRY_RIPENCC    }, // 109.95.160.0    - 109.95.167.255 
	{ 0x6d5fa800, 0x6d5fffff, REGISTRY_RIPENCC    }, // 109.95.168.0    - 109.95.255.255 
	{ 0x6d600000, 0x6dc3ffff, REGISTRY_RIPENCC    }, // 109.96.0.0      - 109.195.255.255
	{ 0x6dc40000, 0x6dc49fff, REGISTRY_RIPENCC    }, // 109.196.0.0     - 109.196.159.255
	{ 0x6dc4b000, 0x6dc5ffff, REGISTRY_RIPENCC    }, // 109.196.176.0   - 109.197.255.255
	{ 0x6dc60000, 0x6dcdffff, REGISTRY_RIPENCC    }, // 109.198.0.0     - 109.205.255.255
	{ 0x6dce0000, 0x6dcf3fff, REGISTRY_RIPENCC    }, // 109.206.0.0     - 109.207.63.255 
	{ 0x6dcf5000, 0x6dcfffff, REGISTRY_RIPENCC    }, // 109.207.80.0    - 109.207.255.255
	{ 0x6dd00000, 0x6de4ffff, REGISTRY_RIPENCC    }, // 109.208.0.0     - 109.228.255.255
	{ 0x6de50000, 0x6de5ffff, REGISTRY_RIPENCC    }, // 109.229.0.0     - 109.229.255.255
	{ 0x6de60000, 0x6de89fff, REGISTRY_RIPENCC    }, // 109.230.0.0     - 109.232.159.255
	{ 0x6de8a800, 0x6dec2fff, REGISTRY_RIPENCC    }, // 109.232.168.0   - 109.236.47.255 
	{ 0x6dec4000, 0x6dffffff, REGISTRY_RIPENCC    }, // 109.236.64.0    - 109.255.255.255
	{ 0x6e000000, 0x6e2227ff, REGISTRY_APNIC      }, // 110.0.0.0       - 110.34.39.255  
	{ 0x6e223000, 0x6e2bffff, REGISTRY_APNIC      }, // 110.34.48.0     - 110.43.255.255 
	{ 0x6e2c1000, 0x6e4c7fff, REGISTRY_APNIC      }, // 110.44.16.0     - 110.76.127.255 
	{ 0x6e4c8800, 0x6e5c3fff, REGISTRY_APNIC      }, // 110.76.136.0    - 110.92.63.255  
	{ 0x6e5c4800, 0x6f5cf7ff, REGISTRY_APNIC      }, // 110.92.72.0     - 111.92.247.255 
	{ 0x6f5d0000, 0x6fdeffff, REGISTRY_APNIC      }, // 111.93.0.0      - 111.222.255.255
	{ 0x6fdf2000, 0x6feb43ff, REGISTRY_APNIC      }, // 111.223.32.0    - 111.235.67.255 
	{ 0x6feb4800, 0x708cbbff, REGISTRY_APNIC      }, // 111.235.72.0    - 112.140.187.255
	{ 0x708cc000, 0x7115e7ff, REGISTRY_APNIC      }, // 112.140.192.0   - 113.21.231.255 
	{ 0x7115f000, 0x721ddfff, REGISTRY_APNIC      }, // 113.21.240.0    - 114.29.223.255 
	{ 0x721e0000, 0x721f3fff, REGISTRY_APNIC      }, // 114.30.0.0      - 114.31.63.255  
	{ 0x721f4800, 0x72860fff, REGISTRY_APNIC      }, // 114.31.72.0     - 114.134.15.255 
	{ 0x72862000, 0x728d4fff, REGISTRY_APNIC      }, // 114.134.32.0    - 114.141.79.255 
	{ 0x728d5800, 0x731f3fff, REGISTRY_APNIC      }, // 114.141.88.0    - 115.31.63.255  
	{ 0x731f5000, 0x732a1fff, REGISTRY_APNIC      }, // 115.31.80.0     - 115.42.31.255  
	{ 0x732a4000, 0x73a67fff, REGISTRY_APNIC      }, // 115.42.64.0     - 115.166.127.255
	{ 0x73a69000, 0x744487ff, REGISTRY_APNIC      }, // 115.166.144.0   - 116.68.135.255 
	{ 0x74449000, 0x7444afff, REGISTRY_APNIC      }, // 116.68.144.0    - 116.68.175.255 
	{ 0x7444b800, 0x74c197ff, REGISTRY_APNIC      }, // 116.68.184.0    - 116.193.151.255
	{ 0x74c19c00, 0x74c1a3ff, REGISTRY_APNIC      }, // 116.193.156.0   - 116.193.163.255
	{ 0x74c1a800, 0x74c59fff, REGISTRY_APNIC      }, // 116.193.168.0   - 116.197.159.255
	{ 0x74c5a800, 0x74cdffff, REGISTRY_APNIC      }, // 116.197.168.0   - 116.205.255.255
	{ 0x74cf0000, 0x74d51fff, REGISTRY_APNIC      }, // 116.207.0.0     - 116.213.31.255 
	{ 0x74d53000, 0x74fe67ff, REGISTRY_APNIC      }, // 116.213.48.0    - 116.254.103.255
	{ 0x74fe7000, 0x753527ff, REGISTRY_APNIC      }, // 116.254.112.0   - 117.53.39.255  
	{ 0x75353000, 0x75358fff, REGISTRY_APNIC      }, // 117.53.48.0     - 117.53.143.255 
	{ 0x75359800, 0x757837ff, REGISTRY_APNIC      }, // 117.53.152.0    - 117.120.55.255 
	{ 0x75784000, 0x76679fff, REGISTRY_APNIC      }, // 117.120.64.0    - 118.103.159.255
	{ 0x7667c000, 0x766bafff, REGISTRY_APNIC      }, // 118.103.192.0   - 118.107.175.255
	{ 0x766bb800, 0x77a15fff, REGISTRY_APNIC      }, // 118.107.184.0   - 119.161.95.255 
	{ 0x77a16800, 0x77a177ff, REGISTRY_APNIC      }, // 119.161.104.0   - 119.161.119.255
	{ 0x77a18000, 0x78880fff, REGISTRY_APNIC      }, // 119.161.128.0   - 120.136.15.255 
	{ 0x78881800, 0x7889ffff, REGISTRY_APNIC      }, // 120.136.24.0    - 120.137.255.255
	{ 0x788a1000, 0x792e3fff, REGISTRY_APNIC      }, // 120.138.16.0    - 121.46.63.255  
	{ 0x792e8000, 0x7932a7ff, REGISTRY_APNIC      }, // 121.46.128.0    - 121.50.167.255 
	{ 0x7932b000, 0x79369fff, REGISTRY_APNIC      }, // 121.50.176.0    - 121.54.159.255 
	{ 0x7936a800, 0x7a805fff, REGISTRY_APNIC      }, // 121.54.168.0    - 122.128.95.255 
	{ 0x7a806800, 0x7ac827ff, REGISTRY_APNIC      }, // 122.128.104.0   - 122.200.39.255 
	{ 0x7ac83000, 0x7bf2bfff, REGISTRY_APNIC      }, // 122.200.48.0    - 123.242.191.255
	{ 0x7bf2c800, 0x7bfe5fff, REGISTRY_APNIC      }, // 123.242.200.0   - 123.254.95.255 
	{ 0x7bfe6800, 0x7c28efff, REGISTRY_APNIC      }, // 123.254.104.0   - 124.40.239.255 
	{ 0x7c28f400, 0x7c42a7ff, REGISTRY_APNIC      }, // 124.40.244.0    - 124.66.167.255 
	{ 0x7c42b000, 0x7c6c13ff, REGISTRY_APNIC      }, // 124.66.176.0    - 124.108.19.255 
	{ 0x7c6c1800, 0x7c9688ff, REGISTRY_APNIC      }, // 124.108.24.0    - 124.150.136.255
	{ 0x7c968c00, 0x7c9e1bff, REGISTRY_APNIC      }, // 124.150.140.0   - 124.158.27.255 
	{ 0x7c9e2000, 0x7dfe33ff, REGISTRY_APNIC      }, // 124.158.32.0    - 125.254.51.255 
	{ 0x7dfe3800, 0x7effffff, REGISTRY_APNIC      }, // 125.254.56.0    - 126.255.255.255
	{ 0x80000000, 0x80004fff, REGISTRY_RIPENCC    }, // 128.0.0.0       - 128.0.79.255   
	{ 0x80005000, 0x80005fff, REGISTRY_RIPENCC    }, // 128.0.80.0      - 128.0.95.255   
	{ 0x80006000, 0x800067ff, REGISTRY_RIPENCC    }, // 128.0.96.0      - 128.0.103.255  
	{ 0x80006800, 0x80008fff, REGISTRY_RIPENCC    }, // 128.0.104.0     - 128.0.143.255  
	{ 0x80009000, 0x80009bff, REGISTRY_RIPENCC    }, // 128.0.144.0     - 128.0.155.255  
	{ 0x8000a000, 0x8000ffff, REGISTRY_RIPENCC    }, // 128.0.160.0     - 128.0.255.255  
	{ 0x80010000, 0x8006ffff, REGISTRY_ARIN       }, // 128.1.0.0       - 128.6.255.255  
	{ 0x80070000, 0x8007ffff, REGISTRY_RIPENCC    }, // 128.7.0.0       - 128.7.255.255  
	{ 0x80080000, 0x800fffff, REGISTRY_ARIN       }, // 128.8.0.0       - 128.15.255.255 
	{ 0x80100000, 0x8010ffff, REGISTRY_RIPENCC    }, // 128.16.0.0      - 128.16.255.255 
	{ 0x80110000, 0x8026ffff, REGISTRY_ARIN       }, // 128.17.0.0      - 128.38.255.255 
	{ 0x80270000, 0x8029ffff, REGISTRY_RIPENCC    }, // 128.39.0.0      - 128.41.255.255 
	{ 0x802a0000, 0x802cffff, REGISTRY_ARIN       }, // 128.42.0.0      - 128.44.255.255 
	{ 0x802d0000, 0x802dffff, REGISTRY_RIPENCC    }, // 128.45.0.0      - 128.45.255.255 
	{ 0x802e0000, 0x8040ffff, REGISTRY_ARIN       }, // 128.46.0.0      - 128.64.255.255 
	{ 0x80410000, 0x804fffff, REGISTRY_RIPENCC    }, // 128.65.0.0      - 128.79.255.255 
	{ 0x80500000, 0x8055ffff, REGISTRY_ARIN       }, // 128.80.0.0      - 128.85.255.255 
	{ 0x80560000, 0x8057ffff, REGISTRY_RIPENCC    }, // 128.86.0.0      - 128.87.255.255 
	{ 0x80580000, 0x805cffff, REGISTRY_ARIN       }, // 128.88.0.0      - 128.92.255.255 
	{ 0x805d0000, 0x805dffff, REGISTRY_RIPENCC    }, // 128.93.0.0      - 128.93.255.255 
	{ 0x805e0000, 0x8061ffff, REGISTRY_ARIN       }, // 128.94.0.0      - 128.97.255.255 
	{ 0x80620000, 0x8062ffff, REGISTRY_RIPENCC    }, // 128.98.0.0      - 128.98.255.255 
	{ 0x80630000, 0x807bffff, REGISTRY_ARIN       }, // 128.99.0.0      - 128.123.255.255
	{ 0x807c0000, 0x807cffff, REGISTRY_RIPENCC    }, // 128.124.0.0     - 128.124.255.255
	{ 0x807d0000, 0x807effff, REGISTRY_ARIN       }, // 128.125.0.0     - 128.126.255.255
	{ 0x807f0000, 0x807f07ff, REGISTRY_RIPENCC    }, // 128.127.0.0     - 128.127.7.255  
	{ 0x807f1000, 0x807fafff, REGISTRY_RIPENCC    }, // 128.127.16.0    - 128.127.175.255
	{ 0x807fb800, 0x807fffff, REGISTRY_RIPENCC    }, // 128.127.184.0   - 128.127.255.255
	{ 0x80800000, 0x8081ffff, REGISTRY_ARIN       }, // 128.128.0.0     - 128.129.255.255
	{ 0x80820000, 0x8083ffff, REGISTRY_RIPENCC    }, // 128.130.0.0     - 128.131.255.255
	{ 0x80840000, 0x8085ffff, REGISTRY_ARIN       }, // 128.132.0.0     - 128.133.255.255
	{ 0x80860000, 0x8086ffff, REGISTRY_APNIC      }, // 128.134.0.0     - 128.134.255.255
	{ 0x80870000, 0x808affff, REGISTRY_ARIN       }, // 128.135.0.0     - 128.138.255.255
	{ 0x808b0000, 0x808bffff, REGISTRY_RIPENCC    }, // 128.139.0.0     - 128.139.255.255
	{ 0x808c0000, 0x808cffff, REGISTRY_RIPENCC    }, // 128.140.0.0     - 128.140.255.255
	{ 0x808d0000, 0x808effff, REGISTRY_RIPENCC    }, // 128.141.0.0     - 128.142.255.255
	{ 0x808f0000, 0x80afffff, REGISTRY_ARIN       }, // 128.143.0.0     - 128.175.255.255
	{ 0x80b00000, 0x80b0ffff, REGISTRY_RIPENCC    }, // 128.176.0.0     - 128.176.255.255
	{ 0x80b10000, 0x80b1ffff, REGISTRY_ARIN       }, // 128.177.0.0     - 128.177.255.255
	{ 0x80b20000, 0x80b3ffff, REGISTRY_RIPENCC    }, // 128.178.0.0     - 128.179.255.255
	{ 0x80b40000, 0x80b7ffff, REGISTRY_ARIN       }, // 128.180.0.0     - 128.183.255.255
	{ 0x80b80000, 0x80b9ffff, REGISTRY_APNIC      }, // 128.184.0.0     - 128.185.255.255
	{ 0x80ba0000, 0x80c6ffff, REGISTRY_ARIN       }, // 128.186.0.0     - 128.198.255.255
	{ 0x80c70000, 0x80c7ffff, REGISTRY_RIPENCC    }, // 128.199.0.0     - 128.199.255.255
	{ 0x80c80000, 0x80c8ffff, REGISTRY_ARIN       }, // 128.200.0.0     - 128.200.255.255
	{ 0x80ca0000, 0x80cbffff, REGISTRY_ARIN       }, // 128.202.0.0     - 128.203.255.255
	{ 0x80cc0000, 0x80ccffff, REGISTRY_RIPENCC    }, // 128.204.0.0     - 128.204.255.255
	{ 0x80cd0000, 0x80d5ffff, REGISTRY_ARIN       }, // 128.205.0.0     - 128.213.255.255
	{ 0x80d60000, 0x80d6ffff, REGISTRY_RIPENCC    }, // 128.214.0.0     - 128.214.255.255
	{ 0x80d70000, 0x80e7ffff, REGISTRY_ARIN       }, // 128.215.0.0     - 128.231.255.255
	{ 0x80e80000, 0x80e8ffff, REGISTRY_RIPENCC    }, // 128.232.0.0     - 128.232.255.255
	{ 0x80e90000, 0x80e9ffff, REGISTRY_ARIN       }, // 128.233.0.0     - 128.233.255.255
	{ 0x80ea0000, 0x80eaffff, REGISTRY_RIPENCC    }, // 128.234.0.0     - 128.234.255.255
	{ 0x80eb0000, 0x80efffff, REGISTRY_ARIN       }, // 128.235.0.0     - 128.239.255.255
	{ 0x80f00000, 0x80f0ffff, REGISTRY_RIPENCC    }, // 128.240.0.0     - 128.240.255.255
	{ 0x80f10000, 0x80f2ffff, REGISTRY_ARIN       }, // 128.241.0.0     - 128.242.255.255
	{ 0x80f30000, 0x80f3ffff, REGISTRY_RIPENCC    }, // 128.243.0.0     - 128.243.255.255
	{ 0x80f40000, 0x80f5ffff, REGISTRY_ARIN       }, // 128.244.0.0     - 128.245.255.255
	{ 0x80f60000, 0x80f6ffff, REGISTRY_RIPENCC    }, // 128.246.0.0     - 128.246.255.255
	{ 0x80f70000, 0x80f9ffff, REGISTRY_ARIN       }, // 128.247.0.0     - 128.249.255.255
	{ 0x80fa0000, 0x80faffff, REGISTRY_APNIC      }, // 128.250.0.0     - 128.250.255.255
	{ 0x80fb0000, 0x80ffffff, REGISTRY_ARIN       }, // 128.251.0.0     - 128.255.255.255
	{ 0x81010000, 0x810affff, REGISTRY_ARIN       }, // 129.1.0.0       - 129.10.255.255 
	{ 0x810b0000, 0x810dffff, REGISTRY_RIPENCC    }, // 129.11.0.0      - 129.13.255.255 
	{ 0x810e0000, 0x810fffff, REGISTRY_ARIN       }, // 129.14.0.0      - 129.15.255.255 
	{ 0x81100000, 0x8110ffff, REGISTRY_RIPENCC    }, // 129.16.0.0      - 129.16.255.255 
	{ 0x81110000, 0x8111ffff, REGISTRY_ARIN       }, // 129.17.0.0      - 129.17.255.255 
	{ 0x81130000, 0x8113ffff, REGISTRY_ARIN       }, // 129.19.0.0      - 129.19.255.255 
	{ 0x81140000, 0x8114ffff, REGISTRY_RIPENCC    }, // 129.20.0.0      - 129.20.255.255 
	{ 0x81150000, 0x8119ffff, REGISTRY_ARIN       }, // 129.21.0.0      - 129.25.255.255 
	{ 0x811a0000, 0x811bffff, REGISTRY_RIPENCC    }, // 129.26.0.0      - 129.27.255.255 
	{ 0x811c0000, 0x811effff, REGISTRY_ARIN       }, // 129.28.0.0      - 129.30.255.255 
	{ 0x811f0000, 0x811fffff, REGISTRY_RIPENCC    }, // 129.31.0.0      - 129.31.255.255 
	{ 0x81200000, 0x812cffff, REGISTRY_ARIN       }, // 129.32.0.0      - 129.44.255.255 
	{ 0x812e0000, 0x8137ffff, REGISTRY_ARIN       }, // 129.46.0.0      - 129.55.255.255 
	{ 0x81390000, 0x813bffff, REGISTRY_ARIN       }, // 129.57.0.0      - 129.59.255.255 
	{ 0x813c0000, 0x813cffff, REGISTRY_APNIC      }, // 129.60.0.0      - 129.60.255.255 
	{ 0x813d0000, 0x8142ffff, REGISTRY_ARIN       }, // 129.61.0.0      - 129.66.255.255 
	{ 0x81430000, 0x8143ffff, REGISTRY_RIPENCC    }, // 129.67.0.0      - 129.67.255.255 
	{ 0x81440000, 0x8144ffff, REGISTRY_ARIN       }, // 129.68.0.0      - 129.68.255.255 
	{ 0x81450000, 0x8146ffff, REGISTRY_RIPENCC    }, // 129.69.0.0      - 129.70.255.255 
	{ 0x81470000, 0x8148ffff, REGISTRY_ARIN       }, // 129.71.0.0      - 129.72.255.255 
	{ 0x81490000, 0x8149ffff, REGISTRY_RIPENCC    }, // 129.73.0.0      - 129.73.255.255 
	{ 0x814a0000, 0x814dffff, REGISTRY_ARIN       }, // 129.74.0.0      - 129.77.255.255 
	{ 0x814e0000, 0x814effff, REGISTRY_APNIC      }, // 129.78.0.0      - 129.78.255.255 
	{ 0x814f0000, 0x8157ffff, REGISTRY_ARIN       }, // 129.79.0.0      - 129.87.255.255 
	{ 0x81580000, 0x8158ffff, REGISTRY_RIPENCC    }, // 129.88.0.0      - 129.88.255.255 
	{ 0x81590000, 0x8159ffff, REGISTRY_ARIN       }, // 129.89.0.0      - 129.89.255.255 
	{ 0x815a0000, 0x815affff, REGISTRY_LACNIC     }, // 129.90.0.0      - 129.90.255.255 
	{ 0x815b0000, 0x815dffff, REGISTRY_ARIN       }, // 129.91.0.0      - 129.93.255.255 
	{ 0x815e0000, 0x815effff, REGISTRY_APNIC      }, // 129.94.0.0      - 129.94.255.255 
	{ 0x815f0000, 0x815fffff, REGISTRY_ARIN       }, // 129.95.0.0      - 129.95.255.255 
	{ 0x81600000, 0x8160ffff, REGISTRY_APNIC      }, // 129.96.0.0      - 129.96.255.255 
	{ 0x81610000, 0x8165ffff, REGISTRY_ARIN       }, // 129.97.0.0      - 129.101.255.255
	{ 0x81660000, 0x8168ffff, REGISTRY_RIPENCC    }, // 129.102.0.0     - 129.104.255.255
	{ 0x81690000, 0x8179ffff, REGISTRY_ARIN       }, // 129.105.0.0     - 129.121.255.255
	{ 0x817b0000, 0x817cffff, REGISTRY_ARIN       }, // 129.123.0.0     - 129.124.255.255
	{ 0x817d0000, 0x817dffff, REGISTRY_RIPENCC    }, // 129.125.0.0     - 129.125.255.255
	{ 0x817e0000, 0x817effff, REGISTRY_ARIN       }, // 129.126.0.0     - 129.126.255.255
	{ 0x817f0000, 0x817fffff, REGISTRY_APNIC      }, // 129.127.0.0     - 129.127.255.255
	{ 0x81800000, 0x8180ffff, REGISTRY_ARIN       }, // 129.128.0.0     - 129.128.255.255
	{ 0x81810000, 0x8181ffff, REGISTRY_RIPENCC    }, // 129.129.0.0     - 129.129.255.255
	{ 0x81820000, 0x8183ffff, REGISTRY_ARIN       }, // 129.130.0.0     - 129.131.255.255
	{ 0x81840000, 0x8184ffff, REGISTRY_RIPENCC    }, // 129.132.0.0     - 129.132.255.255
	{ 0x81850000, 0x8187ffff, REGISTRY_ARIN       }, // 129.133.0.0     - 129.135.255.255
	{ 0x81880000, 0x8188ffff, REGISTRY_APNIC      }, // 129.136.0.0     - 129.136.255.255
	{ 0x81890000, 0x818bffff, REGISTRY_ARIN       }, // 129.137.0.0     - 129.139.255.255
	{ 0x818d0000, 0x818dffff, REGISTRY_ARIN       }, // 129.141.0.0     - 129.141.255.255
	{ 0x818e0000, 0x818fffff, REGISTRY_RIPENCC    }, // 129.142.0.0     - 129.143.255.255
	{ 0x81900000, 0x81a8ffff, REGISTRY_ARIN       }, // 129.144.0.0     - 129.168.255.255
	{ 0x81a90000, 0x81a9ffff, REGISTRY_RIPENCC    }, // 129.169.0.0     - 129.169.255.255
	{ 0x81aa0000, 0x81aeffff, REGISTRY_ARIN       }, // 129.170.0.0     - 129.174.255.255
	{ 0x81af0000, 0x81afffff, REGISTRY_RIPENCC    }, // 129.175.0.0     - 129.175.255.255
	{ 0x81b00000, 0x81b0ffff, REGISTRY_ARIN       }, // 129.176.0.0     - 129.176.255.255
	{ 0x81b10000, 0x81b2ffff, REGISTRY_RIPENCC    }, // 129.177.0.0     - 129.178.255.255
	{ 0x81b30000, 0x81b3ffff, REGISTRY_ARIN       }, // 129.179.0.0     - 129.179.255.255
	{ 0x81b40000, 0x81b4ffff, REGISTRY_APNIC      }, // 129.180.0.0     - 129.180.255.255
	{ 0x81b50000, 0x81b9ffff, REGISTRY_RIPENCC    }, // 129.181.0.0     - 129.185.255.255
	{ 0x81ba0000, 0x81baffff, REGISTRY_ARIN       }, // 129.186.0.0     - 129.186.255.255
	{ 0x81bb0000, 0x81bbffff, REGISTRY_RIPENCC    }, // 129.187.0.0     - 129.187.255.255
	{ 0x81bc0000, 0x81c1ffff, REGISTRY_ARIN       }, // 129.188.0.0     - 129.193.255.255
	{ 0x81c20000, 0x81c3ffff, REGISTRY_RIPENCC    }, // 129.194.0.0     - 129.195.255.255
	{ 0x81c40000, 0x81c6ffff, REGISTRY_ARIN       }, // 129.196.0.0     - 129.198.255.255
	{ 0x81c70000, 0x81c7ffff, REGISTRY_RIPENCC    }, // 129.199.0.0     - 129.199.255.255
	{ 0x81c80000, 0x81ccffff, REGISTRY_ARIN       }, // 129.200.0.0     - 129.204.255.255
	{ 0x81ce0000, 0x81ceffff, REGISTRY_RIPENCC    }, // 129.206.0.0     - 129.206.255.255
	{ 0x81cf0000, 0x81cfffff, REGISTRY_ARIN       }, // 129.207.0.0     - 129.207.255.255
	{ 0x81d00000, 0x81d0ffff, REGISTRY_RIPENCC    }, // 129.208.0.0     - 129.208.255.255
	{ 0x81d10000, 0x81d5ffff, REGISTRY_ARIN       }, // 129.209.0.0     - 129.213.255.255
	{ 0x81d60000, 0x81d7ffff, REGISTRY_RIPENCC    }, // 129.214.0.0     - 129.215.255.255
	{ 0x81d80000, 0x81d8ffff, REGISTRY_ARIN       }, // 129.216.0.0     - 129.216.255.255
	{ 0x81d90000, 0x81d9ffff, REGISTRY_RIPENCC    }, // 129.217.0.0     - 129.217.255.255
	{ 0x81da0000, 0x81e7ffff, REGISTRY_ARIN       }, // 129.218.0.0     - 129.231.255.255
	{ 0x81e90000, 0x81eaffff, REGISTRY_RIPENCC    }, // 129.233.0.0     - 129.234.255.255
	{ 0x81eb0000, 0x81efffff, REGISTRY_ARIN       }, // 129.235.0.0     - 129.239.255.255
	{ 0x81f00000, 0x81f2ffff, REGISTRY_RIPENCC    }, // 129.240.0.0     - 129.242.255.255
	{ 0x81f30000, 0x81f6ffff, REGISTRY_ARIN       }, // 129.243.0.0     - 129.246.255.255
	{ 0x81f70000, 0x81f7ffff, REGISTRY_RIPENCC    }, // 129.247.0.0     - 129.247.255.255
	{ 0x81f80000, 0x81f8ffff, REGISTRY_ARIN       }, // 129.248.0.0     - 129.248.255.255
	{ 0x81f90000, 0x81f9ffff, REGISTRY_APNIC      }, // 129.249.0.0     - 129.249.255.255
	{ 0x81fa0000, 0x81fdffff, REGISTRY_ARIN       }, // 129.250.0.0     - 129.253.255.255
	{ 0x81fe0000, 0x81feffff, REGISTRY_APNIC      }, // 129.254.0.0     - 129.254.255.255
	{ 0x81ff0000, 0x81ffffff, REGISTRY_ARIN       }, // 129.255.0.0     - 129.255.255.255
	{ 0x82000000, 0x8200ffff, REGISTRY_RIPENCC    }, // 130.0.0.0       - 130.0.255.255  
	{ 0x82010000, 0x8217ffff, REGISTRY_ARIN       }, // 130.1.0.0       - 130.23.255.255 
	{ 0x82180000, 0x8218ffff, REGISTRY_RIPENCC    }, // 130.24.0.0      - 130.24.255.255 
	{ 0x82190000, 0x8219ffff, REGISTRY_RIPENCC    }, // 130.25.0.0      - 130.25.255.255 
	{ 0x821a0000, 0x821affff, REGISTRY_RIPENCC    }, // 130.26.0.0      - 130.26.255.255 
	{ 0x821b0000, 0x821bffff, REGISTRY_ARIN       }, // 130.27.0.0      - 130.27.255.255 
	{ 0x821c0000, 0x821cffff, REGISTRY_RIPENCC    }, // 130.28.0.0      - 130.28.255.255 
	{ 0x821d0000, 0x821fffff, REGISTRY_ARIN       }, // 130.29.0.0      - 130.31.255.255 
	{ 0x82200000, 0x8220ffff, REGISTRY_RIPENCC    }, // 130.32.0.0      - 130.32.255.255 
	{ 0x82210000, 0x8221ffff, REGISTRY_ARIN       }, // 130.33.0.0      - 130.33.255.255 
	{ 0x82220000, 0x8222ffff, REGISTRY_APNIC      }, // 130.34.0.0      - 130.34.255.255 
	{ 0x82230000, 0x8224ffff, REGISTRY_ARIN       }, // 130.35.0.0      - 130.36.255.255 
	{ 0x82250000, 0x8225ffff, REGISTRY_RIPENCC    }, // 130.37.0.0      - 130.37.255.255 
	{ 0x82260000, 0x822affff, REGISTRY_ARIN       }, // 130.38.0.0      - 130.42.255.255 
	{ 0x822b0000, 0x822bffff, REGISTRY_RIPENCC    }, // 130.43.0.0      - 130.43.255.255 
	{ 0x822c0000, 0x8235ffff, REGISTRY_ARIN       }, // 130.44.0.0      - 130.53.255.255 
	{ 0x82360000, 0x8236ffff, REGISTRY_APNIC      }, // 130.54.0.0      - 130.54.255.255 
	{ 0x82370000, 0x8237ffff, REGISTRY_ARIN       }, // 130.55.0.0      - 130.55.255.255 
	{ 0x82380000, 0x8238ffff, REGISTRY_APNIC      }, // 130.56.0.0      - 130.56.255.255 
	{ 0x82390000, 0x823affff, REGISTRY_ARIN       }, // 130.57.0.0      - 130.58.255.255 
	{ 0x823b0000, 0x823cffff, REGISTRY_RIPENCC    }, // 130.59.0.0      - 130.60.255.255 
	{ 0x823d0000, 0x8241ffff, REGISTRY_ARIN       }, // 130.61.0.0      - 130.65.255.255 
	{ 0x82420000, 0x8243ffff, REGISTRY_RIPENCC    }, // 130.66.0.0      - 130.67.255.255 
	{ 0x82440000, 0x8244ffff, REGISTRY_ARIN       }, // 130.68.0.0      - 130.68.255.255 
	{ 0x82450000, 0x8245ffff, REGISTRY_APNIC      }, // 130.69.0.0      - 130.69.255.255 
	{ 0x82460000, 0x8248ffff, REGISTRY_ARIN       }, // 130.70.0.0      - 130.72.255.255 
	{ 0x82490000, 0x8249ffff, REGISTRY_RIPENCC    }, // 130.73.0.0      - 130.73.255.255 
	{ 0x824a0000, 0x824affff, REGISTRY_ARIN       }, // 130.74.0.0      - 130.74.255.255 
	{ 0x824b0000, 0x824bffff, REGISTRY_RIPENCC    }, // 130.75.0.0      - 130.75.255.255 
	{ 0x824c0000, 0x824dffff, REGISTRY_ARIN       }, // 130.76.0.0      - 130.77.255.255 
	{ 0x824e0000, 0x824fffff, REGISTRY_RIPENCC    }, // 130.78.0.0      - 130.79.255.255 
	{ 0x82500000, 0x8251ffff, REGISTRY_ARIN       }, // 130.80.0.0      - 130.81.255.255 
	{ 0x82520000, 0x8254ffff, REGISTRY_RIPENCC    }, // 130.82.0.0      - 130.84.255.255 
	{ 0x82550000, 0x8256ffff, REGISTRY_ARIN       }, // 130.85.0.0      - 130.86.255.255 
	{ 0x82570000, 0x8257ffff, REGISTRY_APNIC      }, // 130.87.0.0      - 130.87.255.255 
	{ 0x82580000, 0x8259ffff, REGISTRY_RIPENCC    }, // 130.88.0.0      - 130.89.255.255 
	{ 0x825a0000, 0x825bffff, REGISTRY_ARIN       }, // 130.90.0.0      - 130.91.255.255 
	{ 0x825c0000, 0x825cffff, REGISTRY_RIPENCC    }, // 130.92.0.0      - 130.92.255.255 
	{ 0x825d0000, 0x825effff, REGISTRY_ARIN       }, // 130.93.0.0      - 130.94.255.255 
	{ 0x825f0000, 0x825fffff, REGISTRY_APNIC      }, // 130.95.0.0      - 130.95.255.255 
	{ 0x82600000, 0x8261ffff, REGISTRY_ARIN       }, // 130.96.0.0      - 130.97.255.255 
	{ 0x82620000, 0x8262ffff, REGISTRY_RIPENCC    }, // 130.98.0.0      - 130.98.255.255 
	{ 0x82630000, 0x8263ffff, REGISTRY_ARIN       }, // 130.99.0.0      - 130.99.255.255 
	{ 0x82640000, 0x8264ffff, REGISTRY_RIPENCC    }, // 130.100.0.0     - 130.100.255.255
	{ 0x82650000, 0x8265ffff, REGISTRY_ARIN       }, // 130.101.0.0     - 130.101.255.255
	{ 0x82660000, 0x8266ffff, REGISTRY_APNIC      }, // 130.102.0.0     - 130.102.255.255
	{ 0x82670000, 0x8267ffff, REGISTRY_ARIN       }, // 130.103.0.0     - 130.103.255.255
	{ 0x82680000, 0x8268ffff, REGISTRY_RIPENCC    }, // 130.104.0.0     - 130.104.255.255
	{ 0x82690000, 0x826fffff, REGISTRY_ARIN       }, // 130.105.0.0     - 130.111.255.255
	{ 0x82700000, 0x8270ffff, REGISTRY_RIPENCC    }, // 130.112.0.0     - 130.112.255.255
	{ 0x82710000, 0x8272ffff, REGISTRY_ARIN       }, // 130.113.0.0     - 130.114.255.255
	{ 0x82730000, 0x8273ffff, REGISTRY_RIPENCC    }, // 130.115.0.0     - 130.115.255.255
	{ 0x82740000, 0x8274ffff, REGISTRY_APNIC      }, // 130.116.0.0     - 130.116.255.255
	{ 0x82750000, 0x8277ffff, REGISTRY_ARIN       }, // 130.117.0.0     - 130.119.255.255
	{ 0x82780000, 0x8278ffff, REGISTRY_RIPENCC    }, // 130.120.0.0     - 130.120.255.255
	{ 0x82790000, 0x827affff, REGISTRY_ARIN       }, // 130.121.0.0     - 130.122.255.255
	{ 0x827b0000, 0x827bffff, REGISTRY_APNIC      }, // 130.123.0.0     - 130.123.255.255
	{ 0x827c0000, 0x827cffff, REGISTRY_ARIN       }, // 130.124.0.0     - 130.124.255.255
	{ 0x827d0000, 0x827dffff, REGISTRY_RIPENCC    }, // 130.125.0.0     - 130.125.255.255
	{ 0x827e0000, 0x8281ffff, REGISTRY_ARIN       }, // 130.126.0.0     - 130.129.255.255
	{ 0x82820000, 0x8282ffff, REGISTRY_APNIC      }, // 130.130.0.0     - 130.130.255.255
	{ 0x82830000, 0x8284ffff, REGISTRY_ARIN       }, // 130.131.0.0     - 130.132.255.255
	{ 0x82850000, 0x8285ffff, REGISTRY_RIPENCC    }, // 130.133.0.0     - 130.133.255.255
	{ 0x82860000, 0x8287ffff, REGISTRY_ARIN       }, // 130.134.0.0     - 130.135.255.255
	{ 0x82880000, 0x8288ffff, REGISTRY_RIPENCC    }, // 130.136.0.0     - 130.136.255.255
	{ 0x82890000, 0x8289ffff, REGISTRY_ARIN       }, // 130.137.0.0     - 130.137.255.255
	{ 0x828a0000, 0x8295ffff, REGISTRY_RIPENCC    }, // 130.138.0.0     - 130.149.255.255
	{ 0x82960000, 0x8298ffff, REGISTRY_ARIN       }, // 130.150.0.0     - 130.152.255.255
	{ 0x82990000, 0x8299ffff, REGISTRY_APNIC      }, // 130.153.0.0     - 130.153.255.255
	{ 0x829a0000, 0x829affff, REGISTRY_ARIN       }, // 130.154.0.0     - 130.154.255.255
	{ 0x829b0000, 0x829bffff, REGISTRY_APNIC      }, // 130.155.0.0     - 130.155.255.255
	{ 0x829c0000, 0x829dffff, REGISTRY_ARIN       }, // 130.156.0.0     - 130.157.255.255
	{ 0x829e0000, 0x829effff, REGISTRY_APNIC      }, // 130.158.0.0     - 130.158.255.255
	{ 0x829f0000, 0x829fffff, REGISTRY_RIPENCC    }, // 130.159.0.0     - 130.159.255.255
	{ 0x82a00000, 0x82a0ffff, REGISTRY_ARIN       }, // 130.160.0.0     - 130.160.255.255
	{ 0x82a10000, 0x82a1ffff, REGISTRY_RIPENCC    }, // 130.161.0.0     - 130.161.255.255
	{ 0x82a20000, 0x82b3ffff, REGISTRY_ARIN       }, // 130.162.0.0     - 130.179.255.255
	{ 0x82b40000, 0x82b4ffff, REGISTRY_RIPENCC    }, // 130.180.0.0     - 130.180.255.255
	{ 0x82b50000, 0x82b6ffff, REGISTRY_ARIN       }, // 130.181.0.0     - 130.182.255.255
	{ 0x82b70000, 0x82b7ffff, REGISTRY_RIPENCC    }, // 130.183.0.0     - 130.183.255.255
	{ 0x82b80000, 0x82b8ffff, REGISTRY_ARIN       }, // 130.184.0.0     - 130.184.255.255
	{ 0x82b90000, 0x82b96fff, REGISTRY_RIPENCC    }, // 130.185.0.0     - 130.185.111.255
	{ 0x82b98000, 0x82b9ffff, REGISTRY_RIPENCC    }, // 130.185.128.0   - 130.185.255.255
	{ 0x82ba0000, 0x82baffff, REGISTRY_RIPENCC    }, // 130.186.0.0     - 130.186.255.255
	{ 0x82bb0000, 0x82bbffff, REGISTRY_ARIN       }, // 130.187.0.0     - 130.187.255.255
	{ 0x82bc0000, 0x82bcffff, REGISTRY_RIPENCC    }, // 130.188.0.0     - 130.188.255.255
	{ 0x82bd0000, 0x82bdffff, REGISTRY_ARIN       }, // 130.189.0.0     - 130.189.255.255
	{ 0x82be0000, 0x82beffff, REGISTRY_RIPENCC    }, // 130.190.0.0     - 130.190.255.255
	{ 0x82bf0000, 0x82bfffff, REGISTRY_ARIN       }, // 130.191.0.0     - 130.191.255.255
	{ 0x82c00000, 0x82c0ffff, REGISTRY_RIPENCC    }, // 130.192.0.0     - 130.192.255.255
	{ 0x82c10000, 0x82c1ffff, REGISTRY_RIPENCC    }, // 130.193.0.0     - 130.193.255.255
	{ 0x82c20000, 0x82c3ffff, REGISTRY_APNIC      }, // 130.194.0.0     - 130.195.255.255
	{ 0x82c40000, 0x82c5ffff, REGISTRY_ARIN       }, // 130.196.0.0     - 130.197.255.255
	{ 0x82c60000, 0x82c6ffff, REGISTRY_RIPENCC    }, // 130.198.0.0     - 130.198.255.255
	{ 0x82c70000, 0x82cbffff, REGISTRY_ARIN       }, // 130.199.0.0     - 130.203.255.255
	{ 0x82cc0000, 0x82ccffff, REGISTRY_RIPENCC    }, // 130.204.0.0     - 130.204.255.255
	{ 0x82cd0000, 0x82cdffff, REGISTRY_ARIN       }, // 130.205.0.0     - 130.205.255.255
	{ 0x82ce0000, 0x82ceffff, REGISTRY_RIPENCC    }, // 130.206.0.0     - 130.206.255.255
	{ 0x82cf0000, 0x82cfffff, REGISTRY_ARIN       }, // 130.207.0.0     - 130.207.255.255
	{ 0x82d00000, 0x82d1ffff, REGISTRY_RIPENCC    }, // 130.208.0.0     - 130.209.255.255
	{ 0x82d20000, 0x82d7ffff, REGISTRY_ARIN       }, // 130.210.0.0     - 130.215.255.255
	{ 0x82d80000, 0x82d9ffff, REGISTRY_APNIC      }, // 130.216.0.0     - 130.217.255.255
	{ 0x82da0000, 0x82dbffff, REGISTRY_ARIN       }, // 130.218.0.0     - 130.219.255.255
	{ 0x82dc0000, 0x82dcffff, REGISTRY_APNIC      }, // 130.220.0.0     - 130.220.255.255
	{ 0x82dd0000, 0x82deffff, REGISTRY_ARIN       }, // 130.221.0.0     - 130.222.255.255
	{ 0x82df0000, 0x82dfffff, REGISTRY_RIPENCC    }, // 130.223.0.0     - 130.223.255.255
	{ 0x82e00000, 0x82e0ffff, REGISTRY_ARIN       }, // 130.224.0.0     - 130.224.255.255
	{ 0x82e10000, 0x82f4ffff, REGISTRY_RIPENCC    }, // 130.225.0.0     - 130.244.255.255
	{ 0x82f50000, 0x82f5ffff, REGISTRY_ARIN       }, // 130.245.0.0     - 130.245.255.255
	{ 0x82f60000, 0x82f6ffff, REGISTRY_RIPENCC    }, // 130.246.0.0     - 130.246.255.255
	{ 0x82f70000, 0x82faffff, REGISTRY_ARIN       }, // 130.247.0.0     - 130.250.255.255
	{ 0x82fb0000, 0x82fbffff, REGISTRY_RIPENCC    }, // 130.251.0.0     - 130.251.255.255
	{ 0x82fc0000, 0x82feffff, REGISTRY_ARIN       }, // 130.252.0.0     - 130.254.255.255
	{ 0x82ff0000, 0x82ffffff, REGISTRY_RIPENCC    }, // 130.255.0.0     - 130.255.255.255
	{ 0x83000000, 0x830007ff, REGISTRY_LACNIC     }, // 131.0.0.0       - 131.0.7.255    
	{ 0x83000c00, 0x8300c7ff, REGISTRY_LACNIC     }, // 131.0.12.0      - 131.0.199.255  
	{ 0x8300d000, 0x8300ebff, REGISTRY_LACNIC     }, // 131.0.208.0     - 131.0.235.255  
	{ 0x8300f400, 0x8300f7ff, REGISTRY_LACNIC     }, // 131.0.244.0     - 131.0.247.255  
	{ 0x8300fc00, 0x8300ffff, REGISTRY_LACNIC     }, // 131.0.252.0     - 131.0.255.255  
	{ 0x83010000, 0x8301ffff, REGISTRY_RIPENCC    }, // 131.1.0.0       - 131.1.255.255  
	{ 0x83020000, 0x8347ffff, REGISTRY_ARIN       }, // 131.2.0.0       - 131.71.255.255 
	{ 0x83480000, 0x834823ff, REGISTRY_LACNIC     }, // 131.72.0.0      - 131.72.35.255  
	{ 0x83482c00, 0x834837ff, REGISTRY_LACNIC     }, // 131.72.44.0     - 131.72.55.255  
	{ 0x83483c00, 0x83483fff, REGISTRY_LACNIC     }, // 131.72.60.0     - 131.72.63.255  
	{ 0x83484800, 0x83484bff, REGISTRY_LACNIC     }, // 131.72.72.0     - 131.72.75.255  
	{ 0x83485000, 0x834857ff, REGISTRY_LACNIC     }, // 131.72.80.0     - 131.72.87.255  
	{ 0x83487000, 0x834873ff, REGISTRY_LACNIC     }, // 131.72.112.0    - 131.72.115.255 
	{ 0x83490000, 0x8360ffff, REGISTRY_ARIN       }, // 131.73.0.0      - 131.96.255.255 
	{ 0x83610000, 0x8361ffff, REGISTRY_RIPENCC    }, // 131.97.0.0      - 131.97.255.255 
	{ 0x83620000, 0x8362ffff, REGISTRY_ARIN       }, // 131.98.0.0      - 131.98.255.255 
	{ 0x83630000, 0x8363ffff, REGISTRY_RIPENCC    }, // 131.99.0.0      - 131.99.255.255 
	{ 0x83650000, 0x8365ffff, REGISTRY_ARIN       }, // 131.101.0.0     - 131.101.255.255
	{ 0x83660000, 0x8366ffff, REGISTRY_RIPENCC    }, // 131.102.0.0     - 131.102.255.255
	{ 0x83670000, 0x836bffff, REGISTRY_ARIN       }, // 131.103.0.0     - 131.107.255.255
	{ 0x836d0000, 0x836effff, REGISTRY_ARIN       }, // 131.109.0.0     - 131.110.255.255
	{ 0x836f0000, 0x836fffff, REGISTRY_RIPENCC    }, // 131.111.0.0     - 131.111.255.255
	{ 0x83700000, 0x8371ffff, REGISTRY_APNIC      }, // 131.112.0.0     - 131.113.255.255
	{ 0x83720000, 0x83757fff, REGISTRY_RIPENCC    }, // 131.114.0.0     - 131.117.127.255
	{ 0x83758000, 0x8375ffff, REGISTRY_RIPENCC    }, // 131.117.128.0   - 131.117.255.255
	{ 0x83760000, 0x8381ffff, REGISTRY_ARIN       }, // 131.118.0.0     - 131.129.255.255
	{ 0x83820000, 0x8382ffff, REGISTRY_RIPENCC    }, // 131.130.0.0     - 131.130.255.255
	{ 0x83830000, 0x8397ffff, REGISTRY_ARIN       }, // 131.131.0.0     - 131.151.255.255
	{ 0x83980000, 0x8398ffff, REGISTRY_RIPENCC    }, // 131.152.0.0     - 131.152.255.255
	{ 0x83990000, 0x8399ffff, REGISTRY_ARIN       }, // 131.153.0.0     - 131.153.255.255
	{ 0x839a0000, 0x839bffff, REGISTRY_RIPENCC    }, // 131.154.0.0     - 131.155.255.255
	{ 0x839c0000, 0x839effff, REGISTRY_ARIN       }, // 131.156.0.0     - 131.158.255.255
	{ 0x839f0000, 0x83a0ffff, REGISTRY_RIPENCC    }, // 131.159.0.0     - 131.160.255.255
	{ 0x83a20000, 0x83a3ffff, REGISTRY_ARIN       }, // 131.162.0.0     - 131.163.255.255
	{ 0x83a40000, 0x83a6ffff, REGISTRY_RIPENCC    }, // 131.164.0.0     - 131.166.255.255
	{ 0x83a70000, 0x83a8ffff, REGISTRY_ARIN       }, // 131.167.0.0     - 131.168.255.255
	{ 0x83a90000, 0x83a9ffff, REGISTRY_RIPENCC    }, // 131.169.0.0     - 131.169.255.255
	{ 0x83aa0000, 0x83aaffff, REGISTRY_APNIC      }, // 131.170.0.0     - 131.170.255.255
	{ 0x83ab0000, 0x83abffff, REGISTRY_ARIN       }, // 131.171.0.0     - 131.171.255.255
	{ 0x83ac0000, 0x83acffff, REGISTRY_APNIC      }, // 131.172.0.0     - 131.172.255.255
	{ 0x83ad0000, 0x83b1ffff, REGISTRY_RIPENCC    }, // 131.173.0.0     - 131.177.255.255
	{ 0x83b20000, 0x83b2ffff, REGISTRY_LACNIC     }, // 131.178.0.0     - 131.178.255.255
	{ 0x83b30000, 0x83b3ffff, REGISTRY_ARIN       }, // 131.179.0.0     - 131.179.255.255
	{ 0x83b40000, 0x83b4ffff, REGISTRY_RIPENCC    }, // 131.180.0.0     - 131.180.255.255
	{ 0x83b50000, 0x83b5ffff, REGISTRY_APNIC      }, // 131.181.0.0     - 131.181.255.255
	{ 0x83b60000, 0x83b8ffff, REGISTRY_ARIN       }, // 131.182.0.0     - 131.184.255.255
	{ 0x83b90000, 0x83b9ffff, REGISTRY_APNIC      }, // 131.185.0.0     - 131.185.255.255
	{ 0x83ba0000, 0x83bbffff, REGISTRY_ARIN       }, // 131.186.0.0     - 131.187.255.255
	{ 0x83bc0000, 0x83bcffff, REGISTRY_RIPENCC    }, // 131.188.0.0     - 131.188.255.255
	{ 0x83bd0000, 0x83c3ffff, REGISTRY_ARIN       }, // 131.189.0.0     - 131.195.255.255
	{ 0x83c50000, 0x83caffff, REGISTRY_ARIN       }, // 131.197.0.0     - 131.202.255.255
	{ 0x83cb0000, 0x83cbffff, REGISTRY_APNIC      }, // 131.203.0.0     - 131.203.255.255
	{ 0x83cc0000, 0x83ccffff, REGISTRY_ARIN       }, // 131.204.0.0     - 131.204.255.255
	{ 0x83cd0000, 0x83cdffff, REGISTRY_RIPENCC    }, // 131.205.0.0     - 131.205.255.255
	{ 0x83ce0000, 0x83ceffff, REGISTRY_APNIC      }, // 131.206.0.0     - 131.206.255.255
	{ 0x83cf0000, 0x83cfffff, REGISTRY_RIPENCC    }, // 131.207.0.0     - 131.207.255.255
	{ 0x83d00000, 0x83d2ffff, REGISTRY_ARIN       }, // 131.208.0.0     - 131.210.255.255
	{ 0x83d30000, 0x83d3ffff, REGISTRY_RIPENCC    }, // 131.211.0.0     - 131.211.255.255
	{ 0x83d40000, 0x83d8ffff, REGISTRY_ARIN       }, // 131.212.0.0     - 131.216.255.255
	{ 0x83d90000, 0x83d9ffff, REGISTRY_APNIC      }, // 131.217.0.0     - 131.217.255.255
	{ 0x83da0000, 0x83dbffff, REGISTRY_ARIN       }, // 131.218.0.0     - 131.219.255.255
	{ 0x83dc0000, 0x83dcffff, REGISTRY_RIPENCC    }, // 131.220.0.0     - 131.220.255.255
	{ 0x83de0000, 0x83dfffff, REGISTRY_ARIN       }, // 131.222.0.0     - 131.223.255.255
	{ 0x83e00000, 0x83e0ffff, REGISTRY_RIPENCC    }, // 131.224.0.0     - 131.224.255.255
	{ 0x83e10000, 0x83e2ffff, REGISTRY_ARIN       }, // 131.225.0.0     - 131.226.255.255
	{ 0x83e30000, 0x83e4ffff, REGISTRY_RIPENCC    }, // 131.227.0.0     - 131.228.255.255
	{ 0x83e50000, 0x83e6ffff, REGISTRY_ARIN       }, // 131.229.0.0     - 131.230.255.255
	{ 0x83e70000, 0x83e7ffff, REGISTRY_RIPENCC    }, // 131.231.0.0     - 131.231.255.255
	{ 0x83e80000, 0x83e9ffff, REGISTRY_ARIN       }, // 131.232.0.0     - 131.233.255.255
	{ 0x83ea0000, 0x83eaffff, REGISTRY_RIPENCC    }, // 131.234.0.0     - 131.234.255.255
	{ 0x83eb0000, 0x83ebffff, REGISTRY_ARIN       }, // 131.235.0.0     - 131.235.255.255
	{ 0x83ec0000, 0x83ecffff, REGISTRY_APNIC      }, // 131.236.0.0     - 131.236.255.255
	{ 0x83ed0000, 0x83edffff, REGISTRY_RIPENCC    }, // 131.237.0.0     - 131.237.255.255
	{ 0x83ee0000, 0x83f1ffff, REGISTRY_ARIN       }, // 131.238.0.0     - 131.241.255.255
	{ 0x83f20000, 0x83f2ffff, REGISTRY_APNIC      }, // 131.242.0.0     - 131.242.255.255
	{ 0x83f30000, 0x83f3ffff, REGISTRY_ARIN       }, // 131.243.0.0     - 131.243.255.255
	{ 0x83f40000, 0x83f5ffff, REGISTRY_APNIC      }, // 131.244.0.0     - 131.245.255.255
	{ 0x83f60000, 0x83f6ffff, REGISTRY_RIPENCC    }, // 131.246.0.0     - 131.246.255.255
	{ 0x83f70000, 0x83f7ffff, REGISTRY_ARIN       }, // 131.247.0.0     - 131.247.255.255
	{ 0x83f80000, 0x83f8ffff, REGISTRY_APNIC      }, // 131.248.0.0     - 131.248.255.255
	{ 0x83f90000, 0x83faffff, REGISTRY_ARIN       }, // 131.249.0.0     - 131.250.255.255
	{ 0x83fb0000, 0x83fbffff, REGISTRY_RIPENCC    }, // 131.251.0.0     - 131.251.255.255
	{ 0x83fc0000, 0x83fdffff, REGISTRY_ARIN       }, // 131.252.0.0     - 131.253.255.255
	{ 0x83fe0000, 0x83feffff, REGISTRY_RIPENCC    }, // 131.254.0.0     - 131.254.255.255
	{ 0x84000000, 0x843fffff, REGISTRY_ARIN       }, // 132.0.0.0       - 132.63.255.255 
	{ 0x84400000, 0x844effff, REGISTRY_RIPENCC    }, // 132.64.0.0      - 132.78.255.255 
	{ 0x844f0000, 0x8491ffff, REGISTRY_ARIN       }, // 132.79.0.0      - 132.145.255.255
	{ 0x84920000, 0x8492ffff, REGISTRY_RIPENCC    }, // 132.146.0.0     - 132.146.255.255
	{ 0x84930000, 0x84933fff, REGISTRY_ARIN       }, // 132.147.0.0     - 132.147.63.255 
	{ 0x84934000, 0x84937fff, REGISTRY_APNIC      }, // 132.147.64.0    - 132.147.127.255
	{ 0x84938000, 0x8494ffff, REGISTRY_ARIN       }, // 132.147.128.0   - 132.148.255.255
	{ 0x84950000, 0x8496ffff, REGISTRY_RIPENCC    }, // 132.149.0.0     - 132.150.255.255
	{ 0x84970000, 0x8498ffff, REGISTRY_ARIN       }, // 132.151.0.0     - 132.152.255.255
	{ 0x84990000, 0x8499ffff, REGISTRY_RIPENCC    }, // 132.153.0.0     - 132.153.255.255
	{ 0x849a0000, 0x849affff, REGISTRY_ARIN       }, // 132.154.0.0     - 132.154.255.255
	{ 0x849b0000, 0x849bffff, REGISTRY_RIPENCC    }, // 132.155.0.0     - 132.155.255.255
	{ 0x849c0000, 0x849cffff, REGISTRY_ARIN       }, // 132.156.0.0     - 132.156.255.255
	{ 0x849d0000, 0x849dffff, REGISTRY_LACNIC     }, // 132.157.0.0     - 132.157.255.255
	{ 0x849e0000, 0x84a4ffff, REGISTRY_ARIN       }, // 132.158.0.0     - 132.164.255.255
	{ 0x84a50000, 0x84a9ffff, REGISTRY_RIPENCC    }, // 132.165.0.0     - 132.169.255.255
	{ 0x84aa0000, 0x84aaffff, REGISTRY_ARIN       }, // 132.170.0.0     - 132.170.255.255
	{ 0x84ab0000, 0x84abffff, REGISTRY_RIPENCC    }, // 132.171.0.0     - 132.171.255.255
	{ 0x84ac0000, 0x84afffff, REGISTRY_ARIN       }, // 132.172.0.0     - 132.175.255.255
	{ 0x84b00000, 0x84b0ffff, REGISTRY_RIPENCC    }, // 132.176.0.0     - 132.176.255.255
	{ 0x84b10000, 0x84b2ffff, REGISTRY_ARIN       }, // 132.177.0.0     - 132.178.255.255
	{ 0x84b30000, 0x84b3ffff, REGISTRY_APNIC      }, // 132.179.0.0     - 132.179.255.255
	{ 0x84b40000, 0x84b4ffff, REGISTRY_RIPENCC    }, // 132.180.0.0     - 132.180.255.255
	{ 0x84b50000, 0x84b6ffff, REGISTRY_APNIC      }, // 132.181.0.0     - 132.182.255.255
	{ 0x84b70000, 0x84b7ffff, REGISTRY_ARIN       }, // 132.183.0.0     - 132.183.255.255
	{ 0x84b80000, 0x84b8ffff, REGISTRY_LACNIC     }, // 132.184.0.0     - 132.184.255.255
	{ 0x84b90000, 0x84bbffff, REGISTRY_RIPENCC    }, // 132.185.0.0     - 132.187.255.255
	{ 0x84bc0000, 0x84beffff, REGISTRY_ARIN       }, // 132.188.0.0     - 132.190.255.255
	{ 0x84bf0000, 0x84bfffff, REGISTRY_LACNIC     }, // 132.191.0.0     - 132.191.255.255
	{ 0x84c00000, 0x84c2ffff, REGISTRY_ARIN       }, // 132.192.0.0     - 132.194.255.255
	{ 0x84c30000, 0x84c4ffff, REGISTRY_RIPENCC    }, // 132.195.0.0     - 132.196.255.255
	{ 0x84c50000, 0x84c6ffff, REGISTRY_ARIN       }, // 132.197.0.0     - 132.198.255.255
	{ 0x84c70000, 0x84c7ffff, REGISTRY_RIPENCC    }, // 132.199.0.0     - 132.199.255.255
	{ 0x84c80000, 0x84ddffff, REGISTRY_ARIN       }, // 132.200.0.0     - 132.221.255.255
	{ 0x84de0000, 0x84deffff, REGISTRY_APNIC      }, // 132.222.0.0     - 132.222.255.255
	{ 0x84df0000, 0x84e2ffff, REGISTRY_ARIN       }, // 132.223.0.0     - 132.226.255.255
	{ 0x84e30000, 0x84e3ffff, REGISTRY_RIPENCC    }, // 132.227.0.0     - 132.227.255.255
	{ 0x84e40000, 0x84e4ffff, REGISTRY_ARIN       }, // 132.228.0.0     - 132.228.255.255
	{ 0x84e50000, 0x84e8ffff, REGISTRY_RIPENCC    }, // 132.229.0.0     - 132.232.255.255
	{ 0x84e90000, 0x84e9ffff, REGISTRY_ARIN       }, // 132.233.0.0     - 132.233.255.255
	{ 0x84ea0000, 0x84eaffff, REGISTRY_APNIC      }, // 132.234.0.0     - 132.234.255.255
	{ 0x84eb0000, 0x84f3ffff, REGISTRY_ARIN       }, // 132.235.0.0     - 132.243.255.255
	{ 0x84f40000, 0x84f4ffff, REGISTRY_RIPENCC    }, // 132.244.0.0     - 132.244.255.255
	{ 0x84f50000, 0x84f6ffff, REGISTRY_ARIN       }, // 132.245.0.0     - 132.246.255.255
	{ 0x84f70000, 0x84f8ffff, REGISTRY_LACNIC     }, // 132.247.0.0     - 132.248.255.255
	{ 0x84f90000, 0x84faffff, REGISTRY_ARIN       }, // 132.249.0.0     - 132.250.255.255
	{ 0x84fb0000, 0x84fbffff, REGISTRY_LACNIC     }, // 132.251.0.0     - 132.251.255.255
	{ 0x84fc0000, 0x84fcffff, REGISTRY_RIPENCC    }, // 132.252.0.0     - 132.252.255.255
	{ 0x84fd0000, 0x84fdffff, REGISTRY_ARIN       }, // 132.253.0.0     - 132.253.255.255
	{ 0x84fe0000, 0x84feffff, REGISTRY_LACNIC     }, // 132.254.0.0     - 132.254.255.255
	{ 0x85000000, 0x85ffffff, REGISTRY_APNIC      }, // 133.0.0.0       - 133.255.255.255
	{ 0x86000000, 0x8600ffff, REGISTRY_RIPENCC    }, // 134.0.0.0       - 134.0.255.255  
	{ 0x86010000, 0x8602ffff, REGISTRY_RIPENCC    }, // 134.1.0.0       - 134.2.255.255  
	{ 0x86030000, 0x8603ffff, REGISTRY_RIPENCC    }, // 134.3.0.0       - 134.3.255.255  
	{ 0x86040000, 0x8606ffff, REGISTRY_ARIN       }, // 134.4.0.0       - 134.6.255.255  
	{ 0x86070000, 0x8607ffff, REGISTRY_APNIC      }, // 134.7.0.0       - 134.7.255.255  
	{ 0x86080000, 0x8610ffff, REGISTRY_ARIN       }, // 134.8.0.0       - 134.16.255.255 
	{ 0x86110000, 0x8611ffff, REGISTRY_RIPENCC    }, // 134.17.0.0      - 134.17.255.255 
	{ 0x86120000, 0x8612ffff, REGISTRY_APNIC      }, // 134.18.0.0      - 134.18.255.255 
	{ 0x86130000, 0x8613ffff, REGISTRY_RIPENCC    }, // 134.19.0.0      - 134.19.255.255 
	{ 0x86140000, 0x8614ffff, REGISTRY_ARIN       }, // 134.20.0.0      - 134.20.255.255 
	{ 0x86150000, 0x8615ffff, REGISTRY_RIPENCC    }, // 134.21.0.0      - 134.21.255.255 
	{ 0x86160000, 0x8618ffff, REGISTRY_ARIN       }, // 134.22.0.0      - 134.24.255.255 
	{ 0x86190000, 0x8619ffff, REGISTRY_RIPENCC    }, // 134.25.0.0      - 134.25.255.255 
	{ 0x861a0000, 0x861affff, REGISTRY_ARIN       }, // 134.26.0.0      - 134.26.255.255 
	{ 0x861b0000, 0x861cffff, REGISTRY_RIPENCC    }, // 134.27.0.0      - 134.28.255.255 
	{ 0x861d0000, 0x861dffff, REGISTRY_ARIN       }, // 134.29.0.0      - 134.29.255.255 
	{ 0x861e0000, 0x861effff, REGISTRY_RIPENCC    }, // 134.30.0.0      - 134.30.255.255 
	{ 0x861f0000, 0x8621ffff, REGISTRY_ARIN       }, // 134.31.0.0      - 134.33.255.255 
	{ 0x86220000, 0x8622ffff, REGISTRY_RIPENCC    }, // 134.34.0.0      - 134.34.255.255 
	{ 0x86230000, 0x8623ffff, REGISTRY_ARIN       }, // 134.35.0.0      - 134.35.255.255 
	{ 0x86240000, 0x8625ffff, REGISTRY_RIPENCC    }, // 134.36.0.0      - 134.37.255.255 
	{ 0x86260000, 0x862adfff, REGISTRY_ARIN       }, // 134.38.0.0      - 134.42.223.255 
	{ 0x862ae000, 0x862ae3ff, REGISTRY_APNIC      }, // 134.42.224.0    - 134.42.227.255 
	{ 0x862ae400, 0x862effff, REGISTRY_ARIN       }, // 134.42.228.0    - 134.46.255.255 
	{ 0x862f0000, 0x862fffff, REGISTRY_RIPENCC    }, // 134.47.0.0      - 134.47.255.255 
	{ 0x86300000, 0x8635ffff, REGISTRY_ARIN       }, // 134.48.0.0      - 134.53.255.255 
	{ 0x86360000, 0x8636ffff, REGISTRY_RIPENCC    }, // 134.54.0.0      - 134.54.255.255 
	{ 0x86370000, 0x8639ffff, REGISTRY_ARIN       }, // 134.55.0.0      - 134.57.255.255 
	{ 0x863a0000, 0x863dffff, REGISTRY_RIPENCC    }, // 134.58.0.0      - 134.61.255.255 
	{ 0x863e0000, 0x864affff, REGISTRY_ARIN       }, // 134.62.0.0      - 134.74.255.255 
	{ 0x864b0000, 0x864bffff, REGISTRY_APNIC      }, // 134.75.0.0      - 134.75.255.255 
	{ 0x864c0000, 0x864cffff, REGISTRY_RIPENCC    }, // 134.76.0.0      - 134.76.255.255 
	{ 0x864d0000, 0x8650ffff, REGISTRY_ARIN       }, // 134.77.0.0      - 134.80.255.255 
	{ 0x86510000, 0x8651ffff, REGISTRY_RIPENCC    }, // 134.81.0.0      - 134.81.255.255 
	{ 0x86520000, 0x8652ffff, REGISTRY_ARIN       }, // 134.82.0.0      - 134.82.255.255 
	{ 0x86530000, 0x8653ffff, REGISTRY_RIPENCC    }, // 134.83.0.0      - 134.83.255.255 
	{ 0x86540000, 0x8659ffff, REGISTRY_ARIN       }, // 134.84.0.0      - 134.89.255.255 
	{ 0x865a0000, 0x865affff, REGISTRY_RIPENCC    }, // 134.90.0.0      - 134.90.255.255 
	{ 0x865b0000, 0x866effff, REGISTRY_RIPENCC    }, // 134.91.0.0      - 134.110.255.255
	{ 0x866f0000, 0x8672ffff, REGISTRY_ARIN       }, // 134.111.0.0     - 134.114.255.255
	{ 0x86730000, 0x8673ffff, REGISTRY_APNIC      }, // 134.115.0.0     - 134.115.255.255
	{ 0x86740000, 0x8676ffff, REGISTRY_ARIN       }, // 134.116.0.0     - 134.118.255.255
	{ 0x86770000, 0x8677ffff, REGISTRY_RIPENCC    }, // 134.119.0.0     - 134.119.255.255
	{ 0x86780000, 0x8681ffff, REGISTRY_ARIN       }, // 134.120.0.0     - 134.129.255.255
	{ 0x86820000, 0x8682ffff, REGISTRY_RIPENCC    }, // 134.130.0.0     - 134.130.255.255
	{ 0x86830000, 0x8689ffff, REGISTRY_ARIN       }, // 134.131.0.0     - 134.137.255.255
	{ 0x868a0000, 0x868affff, REGISTRY_RIPENCC    }, // 134.138.0.0     - 134.138.255.255
	{ 0x868b0000, 0x868dffff, REGISTRY_ARIN       }, // 134.139.0.0     - 134.141.255.255
	{ 0x868e0000, 0x868fffff, REGISTRY_RIPENCC    }, // 134.142.0.0     - 134.143.255.255
	{ 0x86900000, 0x8690ffff, REGISTRY_APNIC      }, // 134.144.0.0     - 134.144.255.255
	{ 0x86910000, 0x8693ffff, REGISTRY_RIPENCC    }, // 134.145.0.0     - 134.147.255.255
	{ 0x86940000, 0x8694ffff, REGISTRY_APNIC      }, // 134.148.0.0     - 134.148.255.255
	{ 0x86950000, 0x8696ffff, REGISTRY_ARIN       }, // 134.149.0.0     - 134.150.255.255
	{ 0x86970000, 0x8697ffff, REGISTRY_RIPENCC    }, // 134.151.0.0     - 134.151.255.255
	{ 0x86980000, 0x869affff, REGISTRY_ARIN       }, // 134.152.0.0     - 134.154.255.255
	{ 0x869b0000, 0x869bffff, REGISTRY_RIPENCC    }, // 134.155.0.0     - 134.155.255.255
	{ 0x869c0000, 0x869cffff, REGISTRY_ARIN       }, // 134.156.0.0     - 134.156.255.255
	{ 0x869d0000, 0x869effff, REGISTRY_RIPENCC    }, // 134.157.0.0     - 134.158.255.255
	{ 0x869f0000, 0x86a0ffff, REGISTRY_APNIC      }, // 134.159.0.0     - 134.160.255.255
	{ 0x86a10000, 0x86a8ffff, REGISTRY_ARIN       }, // 134.161.0.0     - 134.168.255.255
	{ 0x86a90000, 0x86a9ffff, REGISTRY_RIPENCC    }, // 134.169.0.0     - 134.169.255.255
	{ 0x86aa0000, 0x86aaffff, REGISTRY_ARIN       }, // 134.170.0.0     - 134.170.255.255
	{ 0x86ab0000, 0x86abffff, REGISTRY_RIPENCC    }, // 134.171.0.0     - 134.171.255.255
	{ 0x86ac0000, 0x86afffff, REGISTRY_ARIN       }, // 134.172.0.0     - 134.175.255.255
	{ 0x86b00000, 0x86b0ffff, REGISTRY_RIPENCC    }, // 134.176.0.0     - 134.176.255.255
	{ 0x86b10000, 0x86b1ffff, REGISTRY_ARIN       }, // 134.177.0.0     - 134.177.255.255
	{ 0x86b20000, 0x86b2ffff, REGISTRY_APNIC      }, // 134.178.0.0     - 134.178.255.255
	{ 0x86b30000, 0x86b3ffff, REGISTRY_ARIN       }, // 134.179.0.0     - 134.179.255.255
	{ 0x86b40000, 0x86b4ffff, REGISTRY_APNIC      }, // 134.180.0.0     - 134.180.255.255
	{ 0x86b50000, 0x86b6ffff, REGISTRY_ARIN       }, // 134.181.0.0     - 134.182.255.255
	{ 0x86b70000, 0x86b8ffff, REGISTRY_RIPENCC    }, // 134.183.0.0     - 134.184.255.255
	{ 0x86b90000, 0x86bbffff, REGISTRY_ARIN       }, // 134.185.0.0     - 134.187.255.255
	{ 0x86bc0000, 0x86bcffff, REGISTRY_RIPENCC    }, // 134.188.0.0     - 134.188.255.255
	{ 0x86bd0000, 0x86beffff, REGISTRY_ARIN       }, // 134.189.0.0     - 134.190.255.255
	{ 0x86bf0000, 0x86bfffff, REGISTRY_RIPENCC    }, // 134.191.0.0     - 134.191.255.255
	{ 0x86c00000, 0x86c3ffff, REGISTRY_ARIN       }, // 134.192.0.0     - 134.195.255.255
	{ 0x86c40000, 0x86c4ffff, REGISTRY_APNIC      }, // 134.196.0.0     - 134.196.255.255
	{ 0x86c50000, 0x86caffff, REGISTRY_ARIN       }, // 134.197.0.0     - 134.202.255.255
	{ 0x86cb0000, 0x86cbffff, REGISTRY_RIPENCC    }, // 134.203.0.0     - 134.203.255.255
	{ 0x86cc0000, 0x86cdffff, REGISTRY_ARIN       }, // 134.204.0.0     - 134.205.255.255
	{ 0x86ce0000, 0x86ceffff, REGISTRY_RIPENCC    }, // 134.206.0.0     - 134.206.255.255
	{ 0x86cf0000, 0x86cfffff, REGISTRY_ARIN       }, // 134.207.0.0     - 134.207.255.255
	{ 0x86d00000, 0x86d0ffff, REGISTRY_APNIC      }, // 134.208.0.0     - 134.208.255.255
	{ 0x86d10000, 0x86d2ffff, REGISTRY_ARIN       }, // 134.209.0.0     - 134.210.255.255
	{ 0x86d30000, 0x86d3ffff, REGISTRY_APNIC      }, // 134.211.0.0     - 134.211.255.255
	{ 0x86d40000, 0x86d6ffff, REGISTRY_RIPENCC    }, // 134.212.0.0     - 134.214.255.255
	{ 0x86d70000, 0x86daffff, REGISTRY_ARIN       }, // 134.215.0.0     - 134.218.255.255
	{ 0x86db0000, 0x86deffff, REGISTRY_RIPENCC    }, // 134.219.0.0     - 134.222.255.255
	{ 0x86df0000, 0x86e0ffff, REGISTRY_ARIN       }, // 134.223.0.0     - 134.224.255.255
	{ 0x86e10000, 0x86e3ffff, REGISTRY_RIPENCC    }, // 134.225.0.0     - 134.227.255.255
	{ 0x86e40000, 0x86ecffff, REGISTRY_ARIN       }, // 134.228.0.0     - 134.236.255.255
	{ 0x86ed0000, 0x86edffff, REGISTRY_APNIC      }, // 134.237.0.0     - 134.237.255.255
	{ 0x86ee0000, 0x86eeffff, REGISTRY_ARIN       }, // 134.238.0.0     - 134.238.255.255
	{ 0x86ef0000, 0x86efffff, REGISTRY_RIPENCC    }, // 134.239.0.0     - 134.239.255.255
	{ 0x86f00000, 0x86f4ffff, REGISTRY_ARIN       }, // 134.240.0.0     - 134.244.255.255
	{ 0x86f50000, 0x86f7ffff, REGISTRY_RIPENCC    }, // 134.245.0.0     - 134.247.255.255
	{ 0x86f80000, 0x86f8ffff, REGISTRY_ARIN       }, // 134.248.0.0     - 134.248.255.255
	{ 0x86f90000, 0x86f9ffff, REGISTRY_RIPENCC    }, // 134.249.0.0     - 134.249.255.255
	{ 0x86fa0000, 0x86feffff, REGISTRY_ARIN       }, // 134.250.0.0     - 134.254.255.255
	{ 0x86ff0000, 0x86ffffff, REGISTRY_RIPENCC    }, // 134.255.0.0     - 134.255.255.255
	{ 0x87000000, 0x87c3ffff, REGISTRY_ARIN       }, // 135.0.0.0       - 135.195.255.255
	{ 0x87c40000, 0x87c4ffff, REGISTRY_RIPENCC    }, // 135.196.0.0     - 135.196.255.255
	{ 0x87c50000, 0x8893ffff, REGISTRY_ARIN       }, // 135.197.0.0     - 136.147.255.255
	{ 0x88940000, 0x8894ffff, REGISTRY_RIPENCC    }, // 136.148.0.0     - 136.148.255.255
	{ 0x88950000, 0x8898ffff, REGISTRY_ARIN       }, // 136.149.0.0     - 136.152.255.255
	{ 0x88990000, 0x889affff, REGISTRY_APNIC      }, // 136.153.0.0     - 136.154.255.255
	{ 0x889b0000, 0x889effff, REGISTRY_RIPENCC    }, // 136.155.0.0     - 136.158.255.255
	{ 0x889f0000, 0x88a2ffff, REGISTRY_ARIN       }, // 136.159.0.0     - 136.162.255.255
	{ 0x88a30000, 0x88a4ffff, REGISTRY_RIPENCC    }, // 136.163.0.0     - 136.164.255.255
	{ 0x88a50000, 0x88a8ffff, REGISTRY_ARIN       }, // 136.165.0.0     - 136.168.255.255
	{ 0x88a90000, 0x88a9ffff, REGISTRY_RIPENCC    }, // 136.169.0.0     - 136.169.255.255
	{ 0x88aa0000, 0x88aaffff, REGISTRY_RIPENCC    }, // 136.170.0.0     - 136.170.255.255
	{ 0x88ab0000, 0x88abffff, REGISTRY_ARIN       }, // 136.171.0.0     - 136.171.255.255
	{ 0x88ac0000, 0x88adffff, REGISTRY_RIPENCC    }, // 136.172.0.0     - 136.173.255.255
	{ 0x88ae0000, 0x88b8ffff, REGISTRY_ARIN       }, // 136.174.0.0     - 136.184.255.255
	{ 0x88b90000, 0x88bbffff, REGISTRY_APNIC      }, // 136.185.0.0     - 136.187.255.255
	{ 0x88bc0000, 0x88c5ffff, REGISTRY_ARIN       }, // 136.188.0.0     - 136.197.255.255
	{ 0x88c60000, 0x88c6ffff, REGISTRY_APNIC      }, // 136.198.0.0     - 136.198.255.255
	{ 0x88c70000, 0x88c7ffff, REGISTRY_RIPENCC    }, // 136.199.0.0     - 136.199.255.255
	{ 0x88c80000, 0x88c8ffff, REGISTRY_ARIN       }, // 136.200.0.0     - 136.200.255.255
	{ 0x88c90000, 0x88c9ffff, REGISTRY_RIPENCC    }, // 136.201.0.0     - 136.201.255.255
	{ 0x88ca0000, 0x88cdffff, REGISTRY_ARIN       }, // 136.202.0.0     - 136.205.255.255
	{ 0x88ce0000, 0x88ceffff, REGISTRY_RIPENCC    }, // 136.206.0.0     - 136.206.255.255
	{ 0x88cf0000, 0x88e0ffff, REGISTRY_ARIN       }, // 136.207.0.0     - 136.224.255.255
	{ 0x88e10000, 0x88e1ffff, REGISTRY_RIPENCC    }, // 136.225.0.0     - 136.225.255.255
	{ 0x88e20000, 0x88e5ffff, REGISTRY_ARIN       }, // 136.226.0.0     - 136.229.255.255
	{ 0x88e60000, 0x88e7ffff, REGISTRY_RIPENCC    }, // 136.230.0.0     - 136.231.255.255
	{ 0x88e80000, 0x88f2ffff, REGISTRY_ARIN       }, // 136.232.0.0     - 136.242.255.255
	{ 0x88f30000, 0x88f3ffff, REGISTRY_RIPENCC    }, // 136.243.0.0     - 136.243.255.255
	{ 0x88f40000, 0x8910ffff, REGISTRY_ARIN       }, // 136.244.0.0     - 137.16.255.255 
	{ 0x89110000, 0x8911ffff, REGISTRY_RIPENCC    }, // 137.17.0.0      - 137.17.255.255 
	{ 0x89120000, 0x8920ffff, REGISTRY_ARIN       }, // 137.18.0.0      - 137.32.255.255 
	{ 0x89210000, 0x8922ffff, REGISTRY_RIPENCC    }, // 137.33.0.0      - 137.34.255.255 
	{ 0x89230000, 0x892affff, REGISTRY_ARIN       }, // 137.35.0.0      - 137.42.255.255 
	{ 0x892b0000, 0x892cffff, REGISTRY_RIPENCC    }, // 137.43.0.0      - 137.44.255.255 
	{ 0x892d0000, 0x892effff, REGISTRY_ARIN       }, // 137.45.0.0      - 137.46.255.255 
	{ 0x892f0000, 0x892fffff, REGISTRY_RIPENCC    }, // 137.47.0.0      - 137.47.255.255 
	{ 0x89300000, 0x8931ffff, REGISTRY_ARIN       }, // 137.48.0.0      - 137.49.255.255 
	{ 0x89320000, 0x8932ffff, REGISTRY_RIPENCC    }, // 137.50.0.0      - 137.50.255.255 
	{ 0x89330000, 0x8936ffff, REGISTRY_ARIN       }, // 137.51.0.0      - 137.54.255.255 
	{ 0x89370000, 0x8938ffff, REGISTRY_RIPENCC    }, // 137.55.0.0      - 137.56.255.255 
	{ 0x89390000, 0x8939ffff, REGISTRY_ARIN       }, // 137.57.0.0      - 137.57.255.255 
	{ 0x893a0000, 0x893affff, REGISTRY_RIPENCC    }, // 137.58.0.0      - 137.58.255.255 
	{ 0x893c0000, 0x893effff, REGISTRY_RIPENCC    }, // 137.60.0.0      - 137.62.255.255 
	{ 0x893f0000, 0x893f7fff, REGISTRY_AFRINIC    }, // 137.63.0.0      - 137.63.127.255 
	{ 0x89410000, 0x8943ffff, REGISTRY_ARIN       }, // 137.65.0.0      - 137.67.255.255 
	{ 0x89440000, 0x8944ffff, REGISTRY_APNIC      }, // 137.68.0.0      - 137.68.255.255 
	{ 0x89450000, 0x8948ffff, REGISTRY_ARIN       }, // 137.69.0.0      - 137.72.255.255 
	{ 0x89490000, 0x8949ffff, REGISTRY_RIPENCC    }, // 137.73.0.0      - 137.73.255.255 
	{ 0x894a0000, 0x894bffff, REGISTRY_ARIN       }, // 137.74.0.0      - 137.75.255.255 
	{ 0x894c0000, 0x894cffff, REGISTRY_APNIC      }, // 137.76.0.0      - 137.76.255.255 
	{ 0x894d0000, 0x895bffff, REGISTRY_ARIN       }, // 137.77.0.0      - 137.91.255.255 
	{ 0x895c0000, 0x895cffff, REGISTRY_APNIC      }, // 137.92.0.0      - 137.92.255.255 
	{ 0x895d0000, 0x895dffff, REGISTRY_RIPENCC    }, // 137.93.0.0      - 137.93.255.255 
	{ 0x895e0000, 0x895fffff, REGISTRY_ARIN       }, // 137.94.0.0      - 137.95.255.255 
	{ 0x89600000, 0x8960ffff, REGISTRY_RIPENCC    }, // 137.96.0.0      - 137.96.255.255 
	{ 0x89610000, 0x8964ffff, REGISTRY_ARIN       }, // 137.97.0.0      - 137.100.255.255
	{ 0x89650000, 0x8965ffff, REGISTRY_RIPENCC    }, // 137.101.0.0     - 137.101.255.255
	{ 0x89660000, 0x8968ffff, REGISTRY_ARIN       }, // 137.102.0.0     - 137.104.255.255
	{ 0x89690000, 0x8969ffff, REGISTRY_RIPENCC    }, // 137.105.0.0     - 137.105.255.255
	{ 0x896a0000, 0x896bffff, REGISTRY_ARIN       }, // 137.106.0.0     - 137.107.255.255
	{ 0x896c0000, 0x896cffff, REGISTRY_RIPENCC    }, // 137.108.0.0     - 137.108.255.255
	{ 0x896d0000, 0x896dffff, REGISTRY_APNIC      }, // 137.109.0.0     - 137.109.255.255
	{ 0x896e0000, 0x896effff, REGISTRY_ARIN       }, // 137.110.0.0     - 137.110.255.255
	{ 0x896f0000, 0x896fffff, REGISTRY_APNIC      }, // 137.111.0.0     - 137.111.255.255
	{ 0x89700000, 0x8972ffff, REGISTRY_ARIN       }, // 137.112.0.0     - 137.114.255.255
	{ 0x89740000, 0x8977ffff, REGISTRY_ARIN       }, // 137.116.0.0     - 137.119.255.255
	{ 0x89780000, 0x8979ffff, REGISTRY_RIPENCC    }, // 137.120.0.0     - 137.121.255.255
	{ 0x897a0000, 0x8980ffff, REGISTRY_ARIN       }, // 137.122.0.0     - 137.128.255.255
	{ 0x89810000, 0x8981ffff, REGISTRY_RIPENCC    }, // 137.129.0.0     - 137.129.255.255
	{ 0x89820000, 0x8983ffff, REGISTRY_ARIN       }, // 137.130.0.0     - 137.131.255.255
	{ 0x89840000, 0x8984ffff, REGISTRY_APNIC      }, // 137.132.0.0     - 137.132.255.255
	{ 0x89850000, 0x8985ffff, REGISTRY_RIPENCC    }, // 137.133.0.0     - 137.133.255.255
	{ 0x89860000, 0x8989ffff, REGISTRY_ARIN       }, // 137.134.0.0     - 137.137.255.255
	{ 0x898a0000, 0x898affff, REGISTRY_RIPENCC    }, // 137.138.0.0     - 137.138.255.255
	{ 0x898b0000, 0x8992ffff, REGISTRY_ARIN       }, // 137.139.0.0     - 137.146.255.255
	{ 0x89930000, 0x8993ffff, REGISTRY_APNIC      }, // 137.147.0.0     - 137.147.255.255
	{ 0x89940000, 0x8998ffff, REGISTRY_ARIN       }, // 137.148.0.0     - 137.152.255.255
	{ 0x89990000, 0x899affff, REGISTRY_APNIC      }, // 137.153.0.0     - 137.154.255.255
	{ 0x899b0000, 0x899bffff, REGISTRY_ARIN       }, // 137.155.0.0     - 137.155.255.255
	{ 0x899c0000, 0x899cffff, REGISTRY_RIPENCC    }, // 137.156.0.0     - 137.156.255.255
	{ 0x899d0000, 0x899dffff, REGISTRY_APNIC      }, // 137.157.0.0     - 137.157.255.255
	{ 0x899e0000, 0x899effff, REGISTRY_AFRINIC    }, // 137.158.0.0     - 137.158.255.255
	{ 0x899f0000, 0x89a2ffff, REGISTRY_ARIN       }, // 137.159.0.0     - 137.162.255.255
	{ 0x89a30000, 0x89a3ffff, REGISTRY_RIPENCC    }, // 137.163.0.0     - 137.163.255.255
	{ 0x89a40000, 0x89a5ffff, REGISTRY_ARIN       }, // 137.164.0.0     - 137.165.255.255
	{ 0x89a60000, 0x89a6ffff, REGISTRY_APNIC      }, // 137.166.0.0     - 137.166.255.255
	{ 0x89a70000, 0x89aaffff, REGISTRY_ARIN       }, // 137.167.0.0     - 137.170.255.255
	{ 0x89ab0000, 0x89abffff, REGISTRY_AFRINIC    }, // 137.171.0.0     - 137.171.255.255
	{ 0x89ac0000, 0x89acffff, REGISTRY_APNIC      }, // 137.172.0.0     - 137.172.255.255
	{ 0x89ad0000, 0x89adffff, REGISTRY_ARIN       }, // 137.173.0.0     - 137.173.255.255
	{ 0x89ae0000, 0x89aeffff, REGISTRY_RIPENCC    }, // 137.174.0.0     - 137.174.255.255
	{ 0x89af0000, 0x89bcffff, REGISTRY_ARIN       }, // 137.175.0.0     - 137.188.255.255
	{ 0x89bd0000, 0x89bdffff, REGISTRY_APNIC      }, // 137.189.0.0     - 137.189.255.255
	{ 0x89be0000, 0x89beffff, REGISTRY_ARIN       }, // 137.190.0.0     - 137.190.255.255
	{ 0x89bf0000, 0x89bfffff, REGISTRY_RIPENCC    }, // 137.191.0.0     - 137.191.255.255
	{ 0x89c00000, 0x89c0ffff, REGISTRY_ARIN       }, // 137.192.0.0     - 137.192.255.255
	{ 0x89c10000, 0x89c3ffff, REGISTRY_RIPENCC    }, // 137.193.0.0     - 137.195.255.255
	{ 0x89c50000, 0x89cbffff, REGISTRY_ARIN       }, // 137.197.0.0     - 137.203.255.255
	{ 0x89cc0000, 0x89cdffff, REGISTRY_RIPENCC    }, // 137.204.0.0     - 137.205.255.255
	{ 0x89ce0000, 0x89cfffff, REGISTRY_ARIN       }, // 137.206.0.0     - 137.207.255.255
	{ 0x89d00000, 0x89d0ffff, REGISTRY_RIPENCC    }, // 137.208.0.0     - 137.208.255.255
	{ 0x89d10000, 0x89d4ffff, REGISTRY_ARIN       }, // 137.209.0.0     - 137.212.255.255
	{ 0x89d50000, 0x89d5ffff, REGISTRY_RIPENCC    }, // 137.213.0.0     - 137.213.255.255
	{ 0x89d60000, 0x89d7ffff, REGISTRY_AFRINIC    }, // 137.214.0.0     - 137.215.255.255
	{ 0x89d80000, 0x89d8ffff, REGISTRY_ARIN       }, // 137.216.0.0     - 137.216.255.255
	{ 0x89d90000, 0x89daffff, REGISTRY_RIPENCC    }, // 137.217.0.0     - 137.218.255.255
	{ 0x89db0000, 0x89dbffff, REGISTRY_APNIC      }, // 137.219.0.0     - 137.219.255.255
	{ 0x89dc0000, 0x89dcffff, REGISTRY_ARIN       }, // 137.220.0.0     - 137.220.255.255
	{ 0x89dd0000, 0x89e0ffff, REGISTRY_RIPENCC    }, // 137.221.0.0     - 137.224.255.255
	{ 0x89e10000, 0x89e1ffff, REGISTRY_ARIN       }, // 137.225.0.0     - 137.225.255.255
	{ 0x89e20000, 0x89e2ffff, REGISTRY_RIPENCC    }, // 137.226.0.0     - 137.226.255.255
	{ 0x89e30000, 0x89f7ffff, REGISTRY_ARIN       }, // 137.227.0.0     - 137.247.255.255
	{ 0x89f80000, 0x89f8ffff, REGISTRY_RIPENCC    }, // 137.248.0.0     - 137.248.255.255
	{ 0x89f90000, 0x89f9ffff, REGISTRY_ARIN       }, // 137.249.0.0     - 137.249.255.255
	{ 0x89fa0000, 0x89fbffff, REGISTRY_RIPENCC    }, // 137.250.0.0     - 137.251.255.255
	{ 0x89fc0000, 0x89fcffff, REGISTRY_ARIN       }, // 137.252.0.0     - 137.252.255.255
	{ 0x89fd0000, 0x89fdffff, REGISTRY_RIPENCC    }, // 137.253.0.0     - 137.253.255.255
	{ 0x89fe0000, 0x89feffff, REGISTRY_ARIN       }, // 137.254.0.0     - 137.254.255.255
	{ 0x8a010000, 0x8a02ffff, REGISTRY_ARIN       }, // 138.1.0.0       - 138.2.255.255  
	{ 0x8a030000, 0x8a04ffff, REGISTRY_RIPENCC    }, // 138.3.0.0       - 138.4.255.255  
	{ 0x8a050000, 0x8a05ffff, REGISTRY_ARIN       }, // 138.5.0.0       - 138.5.255.255  
	{ 0x8a060000, 0x8a06ffff, REGISTRY_RIPENCC    }, // 138.6.0.0       - 138.6.255.255  
	{ 0x8a070000, 0x8a07ffff, REGISTRY_APNIC      }, // 138.7.0.0       - 138.7.255.255  
	{ 0x8a080000, 0x8a0dffff, REGISTRY_ARIN       }, // 138.8.0.0       - 138.13.255.255 
	{ 0x8a0e0000, 0x8a0effff, REGISTRY_RIPENCC    }, // 138.14.0.0      - 138.14.255.255 
	{ 0x8a0f0000, 0x8a12ffff, REGISTRY_ARIN       }, // 138.15.0.0      - 138.18.255.255 
	{ 0x8a130000, 0x8a13ffff, REGISTRY_APNIC      }, // 138.19.0.0      - 138.19.255.255 
	{ 0x8a140000, 0x8a14ffff, REGISTRY_ARIN       }, // 138.20.0.0      - 138.20.255.255 
	{ 0x8a150000, 0x8a16ffff, REGISTRY_RIPENCC    }, // 138.21.0.0      - 138.22.255.255 
	{ 0x8a170000, 0x8a17ffff, REGISTRY_ARIN       }, // 138.23.0.0      - 138.23.255.255 
	{ 0x8a180000, 0x8a19ffff, REGISTRY_APNIC      }, // 138.24.0.0      - 138.25.255.255 
	{ 0x8a1a0000, 0x8a1dffff, REGISTRY_ARIN       }, // 138.26.0.0      - 138.29.255.255 
	{ 0x8a1e0000, 0x8a1effff, REGISTRY_APNIC      }, // 138.30.0.0      - 138.30.255.255 
	{ 0x8a1f0000, 0x8a23ffff, REGISTRY_ARIN       }, // 138.31.0.0      - 138.35.255.255 
	{ 0x8a250000, 0x8a26ffff, REGISTRY_RIPENCC    }, // 138.37.0.0      - 138.38.255.255 
	{ 0x8a270000, 0x8a27ffff, REGISTRY_ARIN       }, // 138.39.0.0      - 138.39.255.255 
	{ 0x8a280000, 0x8a29ffff, REGISTRY_RIPENCC    }, // 138.40.0.0      - 138.41.255.255 
	{ 0x8a2a0000, 0x8a2bffff, REGISTRY_ARIN       }, // 138.42.0.0      - 138.43.255.255 
	{ 0x8a2c0000, 0x8a2cffff, REGISTRY_APNIC      }, // 138.44.0.0      - 138.44.255.255 
	{ 0x8a2d0000, 0x8a2fffff, REGISTRY_ARIN       }, // 138.45.0.0      - 138.47.255.255 
	{ 0x8a300000, 0x8a30ffff, REGISTRY_RIPENCC    }, // 138.48.0.0      - 138.48.255.255 
	{ 0x8a310000, 0x8a3affff, REGISTRY_ARIN       }, // 138.49.0.0      - 138.58.255.255 
	{ 0x8a3c0000, 0x8a3dffff, REGISTRY_ARIN       }, // 138.60.0.0      - 138.61.255.255 
	{ 0x8a3e0000, 0x8a3fffff, REGISTRY_RIPENCC    }, // 138.62.0.0      - 138.63.255.255 
	{ 0x8a400000, 0x8a41ffff, REGISTRY_ARIN       }, // 138.64.0.0      - 138.65.255.255 
	{ 0x8a420000, 0x8a42ffff, REGISTRY_RIPENCC    }, // 138.66.0.0      - 138.66.255.255 
	{ 0x8a430000, 0x8a45ffff, REGISTRY_ARIN       }, // 138.67.0.0      - 138.69.255.255 
	{ 0x8a460000, 0x8a46ffff, REGISTRY_RIPENCC    }, // 138.70.0.0      - 138.70.255.255 
	{ 0x8a470000, 0x8a47ffff, REGISTRY_APNIC      }, // 138.71.0.0      - 138.71.255.255 
	{ 0x8a480000, 0x8a4affff, REGISTRY_ARIN       }, // 138.72.0.0      - 138.74.255.255 
	{ 0x8a4b0000, 0x8a4bffff, REGISTRY_APNIC      }, // 138.75.0.0      - 138.75.255.255 
	{ 0x8a4c0000, 0x8a4cffff, REGISTRY_ARIN       }, // 138.76.0.0      - 138.76.255.255 
	{ 0x8a4d0000, 0x8a4dffff, REGISTRY_APNIC      }, // 138.77.0.0      - 138.77.255.255 
	{ 0x8a4e0000, 0x8a4effff, REGISTRY_ARIN       }, // 138.78.0.0      - 138.78.255.255 
	{ 0x8a4f0000, 0x8a50ffff, REGISTRY_APNIC      }, // 138.79.0.0      - 138.80.255.255 
	{ 0x8a510000, 0x8a51ffff, REGISTRY_RIPENCC    }, // 138.81.0.0      - 138.81.255.255 
	{ 0x8a520000, 0x8a5dffff, REGISTRY_ARIN       }, // 138.82.0.0      - 138.93.255.255 
	{ 0x8a5f0000, 0x8a5fffff, REGISTRY_ARIN       }, // 138.95.0.0      - 138.95.255.255 
	{ 0x8a600000, 0x8a60ffff, REGISTRY_RIPENCC    }, // 138.96.0.0      - 138.96.255.255 
	{ 0x8a620000, 0x8a62ffff, REGISTRY_ARIN       }, // 138.98.0.0      - 138.98.255.255 
	{ 0x8a640000, 0x8a64ffff, REGISTRY_RIPENCC    }, // 138.100.0.0     - 138.100.255.255
	{ 0x8a650000, 0x8a65ffff, REGISTRY_APNIC      }, // 138.101.0.0     - 138.101.255.255
	{ 0x8a660000, 0x8a68ffff, REGISTRY_RIPENCC    }, // 138.102.0.0     - 138.104.255.255
	{ 0x8a690000, 0x8a69ffff, REGISTRY_ARIN       }, // 138.105.0.0     - 138.105.255.255
	{ 0x8a6a0000, 0x8a6affff, REGISTRY_RIPENCC    }, // 138.106.0.0     - 138.106.255.255
	{ 0x8a6b0000, 0x8a6bffff, REGISTRY_APNIC      }, // 138.107.0.0     - 138.107.255.255
	{ 0x8a6c0000, 0x8a74ffff, REGISTRY_ARIN       }, // 138.108.0.0     - 138.116.255.255
	{ 0x8a770000, 0x8a78ffff, REGISTRY_ARIN       }, // 138.119.0.0     - 138.120.255.255
	{ 0x8a7b0000, 0x8a7bffff, REGISTRY_ARIN       }, // 138.123.0.0     - 138.123.255.255
	{ 0x8a7c0000, 0x8a7cffff, REGISTRY_RIPENCC    }, // 138.124.0.0     - 138.124.255.255
	{ 0x8a7d0000, 0x8a81ffff, REGISTRY_ARIN       }, // 138.125.0.0     - 138.129.255.255
	{ 0x8a820000, 0x8a82ffff, REGISTRY_APNIC      }, // 138.130.0.0     - 138.130.255.255
	{ 0x8a830000, 0x8a84ffff, REGISTRY_RIPENCC    }, // 138.131.0.0     - 138.132.255.255
	{ 0x8a850000, 0x8a85ffff, REGISTRY_ARIN       }, // 138.133.0.0     - 138.133.255.255
	{ 0x8a860000, 0x8a86ffff, REGISTRY_RIPENCC    }, // 138.134.0.0     - 138.134.255.255
	{ 0x8a870000, 0x8ab8ffff, REGISTRY_ARIN       }, // 138.135.0.0     - 138.184.255.255
	{ 0x8abb0000, 0x8abfffff, REGISTRY_RIPENCC    }, // 138.187.0.0     - 138.191.255.255
	{ 0x8ac00000, 0x8ac1ffff, REGISTRY_ARIN       }, // 138.192.0.0     - 138.193.255.255
	{ 0x8ac20000, 0x8ac2ffff, REGISTRY_APNIC      }, // 138.194.0.0     - 138.194.255.255
	{ 0x8ac30000, 0x8ac3ffff, REGISTRY_RIPENCC    }, // 138.195.0.0     - 138.195.255.255
	{ 0x8ac40000, 0x8ac5ffff, REGISTRY_ARIN       }, // 138.196.0.0     - 138.197.255.255
	{ 0x8ac60000, 0x8ac9ffff, REGISTRY_RIPENCC    }, // 138.198.0.0     - 138.201.255.255
	{ 0x8aca0000, 0x8acaffff, REGISTRY_ARIN       }, // 138.202.0.0     - 138.202.255.255
	{ 0x8acb0000, 0x8acbffff, REGISTRY_RIPENCC    }, // 138.203.0.0     - 138.203.255.255
	{ 0x8acd0000, 0x8aceffff, REGISTRY_RIPENCC    }, // 138.205.0.0     - 138.206.255.255
	{ 0x8acf0000, 0x8ad2ffff, REGISTRY_ARIN       }, // 138.207.0.0     - 138.210.255.255
	{ 0x8ad30000, 0x8ad4ffff, REGISTRY_APNIC      }, // 138.211.0.0     - 138.212.255.255
	{ 0x8ad60000, 0x8ad6ffff, REGISTRY_ARIN       }, // 138.214.0.0     - 138.214.255.255
	{ 0x8ad70000, 0x8ad8ffff, REGISTRY_RIPENCC    }, // 138.215.0.0     - 138.216.255.255
	{ 0x8ad90000, 0x8ad9ffff, REGISTRY_APNIC      }, // 138.217.0.0     - 138.217.255.255
	{ 0x8ada0000, 0x8adaffff, REGISTRY_ARIN       }, // 138.218.0.0     - 138.218.255.255
	{ 0x8adc0000, 0x8adcffff, REGISTRY_ARIN       }, // 138.220.0.0     - 138.220.255.255
	{ 0x8add0000, 0x8ae4ffff, REGISTRY_RIPENCC    }, // 138.221.0.0     - 138.228.255.255
	{ 0x8ae50000, 0x8ae6ffff, REGISTRY_ARIN       }, // 138.229.0.0     - 138.230.255.255
	{ 0x8ae70000, 0x8ae9ffff, REGISTRY_RIPENCC    }, // 138.231.0.0     - 138.233.255.255
	{ 0x8aea0000, 0x8aeaffff, REGISTRY_ARIN       }, // 138.234.0.0     - 138.234.255.255
	{ 0x8aeb0000, 0x8aebffff, REGISTRY_APNIC      }, // 138.235.0.0     - 138.235.255.255
	{ 0x8aec0000, 0x8af2ffff, REGISTRY_ARIN       }, // 138.236.0.0     - 138.242.255.255
	{ 0x8af30000, 0x8af3ffff, REGISTRY_APNIC      }, // 138.243.0.0     - 138.243.255.255
	{ 0x8af40000, 0x8af6ffff, REGISTRY_RIPENCC    }, // 138.244.0.0     - 138.246.255.255
	{ 0x8af70000, 0x8af7ffff, REGISTRY_ARIN       }, // 138.247.0.0     - 138.247.255.255
	{ 0x8af80000, 0x8afbffff, REGISTRY_RIPENCC    }, // 138.248.0.0     - 138.251.255.255
	{ 0x8afd0000, 0x8afdffff, REGISTRY_RIPENCC    }, // 138.253.0.0     - 138.253.255.255
	{ 0x8afe0000, 0x8afeffff, REGISTRY_ARIN       }, // 138.254.0.0     - 138.254.255.255
	{ 0x8b000000, 0x8b00ffff, REGISTRY_APNIC      }, // 139.0.0.0       - 139.0.255.255  
	{ 0x8b010000, 0x8b04ffff, REGISTRY_RIPENCC    }, // 139.1.0.0       - 139.4.255.255  
	{ 0x8b060000, 0x8b08ffff, REGISTRY_RIPENCC    }, // 139.6.0.0       - 139.8.255.255  
	{ 0x8b090000, 0x8b09ffff, REGISTRY_APNIC      }, // 139.9.0.0       - 139.9.255.255  
	{ 0x8b0a0000, 0x8b19ffff, REGISTRY_RIPENCC    }, // 139.10.0.0      - 139.25.255.255 
	{ 0x8b1b0000, 0x8b1bffff, REGISTRY_RIPENCC    }, // 139.27.0.0      - 139.27.255.255 
	{ 0x8b1d0000, 0x8b1effff, REGISTRY_RIPENCC    }, // 139.29.0.0      - 139.30.255.255 
	{ 0x8b1f0000, 0x8b2bffff, REGISTRY_ARIN       }, // 139.31.0.0      - 139.43.255.255 
	{ 0x8b2c0000, 0x8b2cffff, REGISTRY_APNIC      }, // 139.44.0.0      - 139.44.255.255 
	{ 0x8b2d0000, 0x8b31ffff, REGISTRY_ARIN       }, // 139.45.0.0      - 139.49.255.255 
	{ 0x8b320000, 0x8b32ffff, REGISTRY_RIPENCC    }, // 139.50.0.0      - 139.50.255.255 
	{ 0x8b330000, 0x8b34ffff, REGISTRY_ARIN       }, // 139.51.0.0      - 139.52.255.255 
	{ 0x8b350000, 0x8b35ffff, REGISTRY_AFRINIC    }, // 139.53.0.0      - 139.53.255.255 
	{ 0x8b360000, 0x8b36ffff, REGISTRY_RIPENCC    }, // 139.54.0.0      - 139.54.255.255 
	{ 0x8b370000, 0x8b39ffff, REGISTRY_ARIN       }, // 139.55.0.0      - 139.57.255.255 
	{ 0x8b3a0000, 0x8b3affff, REGISTRY_RIPENCC    }, // 139.58.0.0      - 139.58.255.255 
	{ 0x8b3b0000, 0x8b3bffff, REGISTRY_APNIC      }, // 139.59.0.0      - 139.59.255.255 
	{ 0x8b3c0000, 0x8b3effff, REGISTRY_ARIN       }, // 139.60.0.0      - 139.62.255.255 
	{ 0x8b3f0000, 0x8b3fffff, REGISTRY_RIPENCC    }, // 139.63.0.0      - 139.63.255.255 
	{ 0x8b400000, 0x8b41ffff, REGISTRY_ARIN       }, // 139.64.0.0      - 139.65.255.255 
	{ 0x8b420000, 0x8b42ffff, REGISTRY_RIPENCC    }, // 139.66.0.0      - 139.66.255.255 
	{ 0x8b430000, 0x8b49ffff, REGISTRY_ARIN       }, // 139.67.0.0      - 139.73.255.255 
	{ 0x8b4a0000, 0x8b4bffff, REGISTRY_RIPENCC    }, // 139.74.0.0      - 139.75.255.255 
	{ 0x8b4c0000, 0x8b4effff, REGISTRY_ARIN       }, // 139.76.0.0      - 139.78.255.255 
	{ 0x8b4f0000, 0x8b4fffff, REGISTRY_RIPENCC    }, // 139.79.0.0      - 139.79.255.255 
	{ 0x8b500000, 0x8b50ffff, REGISTRY_APNIC      }, // 139.80.0.0      - 139.80.255.255 
	{ 0x8b510000, 0x8b51ffff, REGISTRY_ARIN       }, // 139.81.0.0      - 139.81.255.255 
	{ 0x8b520000, 0x8b52ffff, REGISTRY_LACNIC     }, // 139.82.0.0      - 139.82.255.255 
	{ 0x8b530000, 0x8b53ffff, REGISTRY_RIPENCC    }, // 139.83.0.0      - 139.83.255.255 
	{ 0x8b540000, 0x8b55ffff, REGISTRY_ARIN       }, // 139.84.0.0      - 139.85.255.255 
	{ 0x8b560000, 0x8b56ffff, REGISTRY_APNIC      }, // 139.86.0.0      - 139.86.255.255 
	{ 0x8b570000, 0x8b58ffff, REGISTRY_ARIN       }, // 139.87.0.0      - 139.88.255.255 
	{ 0x8b590000, 0x8b5cffff, REGISTRY_RIPENCC    }, // 139.89.0.0      - 139.92.255.255 
	{ 0x8b5d0000, 0x8b5fffff, REGISTRY_ARIN       }, // 139.93.0.0      - 139.95.255.255 
	{ 0x8b600000, 0x8b62ffff, REGISTRY_RIPENCC    }, // 139.96.0.0      - 139.98.255.255 
	{ 0x8b630000, 0x8b63ffff, REGISTRY_ARIN       }, // 139.99.0.0      - 139.99.255.255 
	{ 0x8b640000, 0x8b64ffff, REGISTRY_RIPENCC    }, // 139.100.0.0     - 139.100.255.255
	{ 0x8b650000, 0x8b65ffff, REGISTRY_APNIC      }, // 139.101.0.0     - 139.101.255.255
	{ 0x8b660000, 0x8b68ffff, REGISTRY_ARIN       }, // 139.102.0.0     - 139.104.255.255
	{ 0x8b690000, 0x8b78ffff, REGISTRY_RIPENCC    }, // 139.105.0.0     - 139.120.255.255
	{ 0x8b790000, 0x8b79ffff, REGISTRY_ARIN       }, // 139.121.0.0     - 139.121.255.255
	{ 0x8b7a0000, 0x8b7cffff, REGISTRY_RIPENCC    }, // 139.122.0.0     - 139.124.255.255
	{ 0x8b7d0000, 0x8b7fffff, REGISTRY_ARIN       }, // 139.125.0.0     - 139.127.255.255
	{ 0x8b800000, 0x8b80ffff, REGISTRY_RIPENCC    }, // 139.128.0.0     - 139.128.255.255
	{ 0x8b810000, 0x8b82ffff, REGISTRY_APNIC      }, // 139.129.0.0     - 139.130.255.255
	{ 0x8b830000, 0x8b83ffff, REGISTRY_ARIN       }, // 139.131.0.0     - 139.131.255.255
	{ 0x8b840000, 0x8b84ffff, REGISTRY_APNIC      }, // 139.132.0.0     - 139.132.255.255
	{ 0x8b850000, 0x8b85ffff, REGISTRY_RIPENCC    }, // 139.133.0.0     - 139.133.255.255
	{ 0x8b860000, 0x8b86ffff, REGISTRY_APNIC      }, // 139.134.0.0     - 139.134.255.255
	{ 0x8b870000, 0x8b8cffff, REGISTRY_ARIN       }, // 139.135.0.0     - 139.140.255.255
	{ 0x8b8d0000, 0x8b8dffff, REGISTRY_RIPENCC    }, // 139.141.0.0     - 139.141.255.255
	{ 0x8b8e0000, 0x8b8effff, REGISTRY_ARIN       }, // 139.142.0.0     - 139.142.255.255
	{ 0x8b8f0000, 0x8b8fffff, REGISTRY_RIPENCC    }, // 139.143.0.0     - 139.143.255.255
	{ 0x8b900000, 0x8b90ffff, REGISTRY_ARIN       }, // 139.144.0.0     - 139.144.255.255
	{ 0x8b910000, 0x8b91ffff, REGISTRY_RIPENCC    }, // 139.145.0.0     - 139.145.255.255
	{ 0x8b920000, 0x8b93ffff, REGISTRY_ARIN       }, // 139.146.0.0     - 139.147.255.255
	{ 0x8b940000, 0x8b94ffff, REGISTRY_APNIC      }, // 139.148.0.0     - 139.148.255.255
	{ 0x8b950000, 0x8b95ffff, REGISTRY_RIPENCC    }, // 139.149.0.0     - 139.149.255.255
	{ 0x8b960000, 0x8b96ffff, REGISTRY_APNIC      }, // 139.150.0.0     - 139.150.255.255
	{ 0x8b970000, 0x8b97ffff, REGISTRY_ARIN       }, // 139.151.0.0     - 139.151.255.255
	{ 0x8b980000, 0x8b98ffff, REGISTRY_APNIC      }, // 139.152.0.0     - 139.152.255.255
	{ 0x8b990000, 0x8b99ffff, REGISTRY_RIPENCC    }, // 139.153.0.0     - 139.153.255.255
	{ 0x8b9a0000, 0x8b9bffff, REGISTRY_APNIC      }, // 139.154.0.0     - 139.155.255.255
	{ 0x8b9c0000, 0x8b9effff, REGISTRY_RIPENCC    }, // 139.156.0.0     - 139.158.255.255
	{ 0x8b9f0000, 0x8b9fffff, REGISTRY_APNIC      }, // 139.159.0.0     - 139.159.255.255
	{ 0x8ba00000, 0x8ba0ffff, REGISTRY_RIPENCC    }, // 139.160.0.0     - 139.160.255.255
	{ 0x8ba10000, 0x8ba1ffff, REGISTRY_ARIN       }, // 139.161.0.0     - 139.161.255.255
	{ 0x8ba20000, 0x8ba2ffff, REGISTRY_RIPENCC    }, // 139.162.0.0     - 139.162.255.255
	{ 0x8ba30000, 0x8ba3ffff, REGISTRY_APNIC      }, // 139.163.0.0     - 139.163.255.255
	{ 0x8ba40000, 0x8ba6ffff, REGISTRY_RIPENCC    }, // 139.164.0.0     - 139.166.255.255
	{ 0x8ba70000, 0x8ba7ffff, REGISTRY_ARIN       }, // 139.167.0.0     - 139.167.255.255
	{ 0x8ba80000, 0x8ba8ffff, REGISTRY_APNIC      }, // 139.168.0.0     - 139.168.255.255
	{ 0x8ba90000, 0x8ba9ffff, REGISTRY_ARIN       }, // 139.169.0.0     - 139.169.255.255
	{ 0x8baa0000, 0x8baaffff, REGISTRY_APNIC      }, // 139.170.0.0     - 139.170.255.255
	{ 0x8bab0000, 0x8badffff, REGISTRY_ARIN       }, // 139.171.0.0     - 139.173.255.255
	{ 0x8bae0000, 0x8baeffff, REGISTRY_RIPENCC    }, // 139.174.0.0     - 139.174.255.255
	{ 0x8baf0000, 0x8bb0ffff, REGISTRY_APNIC      }, // 139.175.0.0     - 139.176.255.255
	{ 0x8bb10000, 0x8bb1ffff, REGISTRY_ARIN       }, // 139.177.0.0     - 139.177.255.255
	{ 0x8bb20000, 0x8bb3ffff, REGISTRY_RIPENCC    }, // 139.178.0.0     - 139.179.255.255
	{ 0x8bb40000, 0x8bb6ffff, REGISTRY_ARIN       }, // 139.180.0.0     - 139.182.255.255
	{ 0x8bb70000, 0x8bb7ffff, REGISTRY_APNIC      }, // 139.183.0.0     - 139.183.255.255
	{ 0x8bb80000, 0x8bb8ffff, REGISTRY_RIPENCC    }, // 139.184.0.0     - 139.184.255.255
	{ 0x8bb90000, 0x8bb9ffff, REGISTRY_ARIN       }, // 139.185.0.0     - 139.185.255.255
	{ 0x8bba0000, 0x8bbaffff, REGISTRY_APNIC      }, // 139.186.0.0     - 139.186.255.255
	{ 0x8bbb0000, 0x8bbbffff, REGISTRY_ARIN       }, // 139.187.0.0     - 139.187.255.255
	{ 0x8bbc0000, 0x8bbeffff, REGISTRY_APNIC      }, // 139.188.0.0     - 139.190.255.255
	{ 0x8bbf0000, 0x8bbfffff, REGISTRY_RIPENCC    }, // 139.191.0.0     - 139.191.255.255
	{ 0x8bc00000, 0x8bddffff, REGISTRY_APNIC      }, // 139.192.0.0     - 139.221.255.255
	{ 0x8bde0000, 0x8bdeffff, REGISTRY_RIPENCC    }, // 139.222.0.0     - 139.222.255.255
	{ 0x8bdf0000, 0x8be0ffff, REGISTRY_APNIC      }, // 139.223.0.0     - 139.224.255.255
	{ 0x8be10000, 0x8be1ffff, REGISTRY_ARIN       }, // 139.225.0.0     - 139.225.255.255
	{ 0x8be20000, 0x8be4ffff, REGISTRY_APNIC      }, // 139.226.0.0     - 139.228.255.255
	{ 0x8be50000, 0x8be5ffff, REGISTRY_ARIN       }, // 139.229.0.0     - 139.229.255.255
	{ 0x8be60000, 0x8be6ffff, REGISTRY_APNIC      }, // 139.230.0.0     - 139.230.255.255
	{ 0x8be70000, 0x8bfeffff, REGISTRY_ARIN       }, // 139.231.0.0     - 139.254.255.255
	{ 0x8bff0000, 0x8c00ffff, REGISTRY_APNIC      }, // 139.255.0.0     - 140.0.255.255  
	{ 0x8c010000, 0x8c4affff, REGISTRY_ARIN       }, // 140.1.0.0       - 140.74.255.255 
	{ 0x8c4b0000, 0x8c4bffff, REGISTRY_APNIC      }, // 140.75.0.0      - 140.75.255.255 
	{ 0x8c4c0000, 0x8c4cffff, REGISTRY_ARIN       }, // 140.76.0.0      - 140.76.255.255 
	{ 0x8c4d0000, 0x8c4effff, REGISTRY_RIPENCC    }, // 140.77.0.0      - 140.78.255.255 
	{ 0x8c4f0000, 0x8c4fffff, REGISTRY_APNIC      }, // 140.79.0.0      - 140.79.255.255 
	{ 0x8c500000, 0x8c50ffff, REGISTRY_ARIN       }, // 140.80.0.0      - 140.80.255.255 
	{ 0x8c520000, 0x8c52ffff, REGISTRY_ARIN       }, // 140.82.0.0      - 140.82.255.255 
	{ 0x8c530000, 0x8c53ffff, REGISTRY_APNIC      }, // 140.83.0.0      - 140.83.255.255 
	{ 0x8c540000, 0x8c56ffff, REGISTRY_RIPENCC    }, // 140.84.0.0      - 140.86.255.255 
	{ 0x8c570000, 0x8c5bffff, REGISTRY_ARIN       }, // 140.87.0.0      - 140.91.255.255 
	{ 0x8c5c0000, 0x8c5cffff, REGISTRY_APNIC      }, // 140.92.0.0      - 140.92.255.255 
	{ 0x8c5d0000, 0x8c5effff, REGISTRY_RIPENCC    }, // 140.93.0.0      - 140.94.255.255 
	{ 0x8c5f0000, 0x8c5fffff, REGISTRY_ARIN       }, // 140.95.0.0      - 140.95.255.255 
	{ 0x8c600000, 0x8c60ffff, REGISTRY_APNIC      }, // 140.96.0.0      - 140.96.255.255 
	{ 0x8c610000, 0x8c61ffff, REGISTRY_RIPENCC    }, // 140.97.0.0      - 140.97.255.255 
	{ 0x8c620000, 0x8c68ffff, REGISTRY_ARIN       }, // 140.98.0.0      - 140.104.255.255
	{ 0x8c690000, 0x8c69ffff, REGISTRY_RIPENCC    }, // 140.105.0.0     - 140.105.255.255
	{ 0x8c6a0000, 0x8c6cffff, REGISTRY_ARIN       }, // 140.106.0.0     - 140.108.255.255
	{ 0x8c6d0000, 0x8c8affff, REGISTRY_APNIC      }, // 140.109.0.0     - 140.138.255.255
	{ 0x8c8b0000, 0x8c8effff, REGISTRY_ARIN       }, // 140.139.0.0     - 140.142.255.255
	{ 0x8c8f0000, 0x8c8fffff, REGISTRY_APNIC      }, // 140.143.0.0     - 140.143.255.255
	{ 0x8c900000, 0x8c93ffff, REGISTRY_ARIN       }, // 140.144.0.0     - 140.147.255.255
	{ 0x8c940000, 0x8c94ffff, REGISTRY_LACNIC     }, // 140.148.0.0     - 140.148.255.255
	{ 0x8c950000, 0x8c95ffff, REGISTRY_APNIC      }, // 140.149.0.0     - 140.149.255.255
	{ 0x8c960000, 0x8c97ffff, REGISTRY_RIPENCC    }, // 140.150.0.0     - 140.151.255.255
	{ 0x8c980000, 0x8c9effff, REGISTRY_ARIN       }, // 140.152.0.0     - 140.158.255.255
	{ 0x8c9f0000, 0x8c9fffff, REGISTRY_APNIC      }, // 140.159.0.0     - 140.159.255.255
	{ 0x8ca00000, 0x8ca3ffff, REGISTRY_ARIN       }, // 140.160.0.0     - 140.163.255.255
	{ 0x8ca40000, 0x8ca4ffff, REGISTRY_RIPENCC    }, // 140.164.0.0     - 140.164.255.255
	{ 0x8ca50000, 0x8ca5ffff, REGISTRY_ARIN       }, // 140.165.0.0     - 140.165.255.255
	{ 0x8ca60000, 0x8ca6ffff, REGISTRY_RIPENCC    }, // 140.166.0.0     - 140.166.255.255
	{ 0x8ca70000, 0x8ca7ffff, REGISTRY_ARIN       }, // 140.167.0.0     - 140.167.255.255
	{ 0x8ca80000, 0x8ca8ffff, REGISTRY_APNIC      }, // 140.168.0.0     - 140.168.255.255
	{ 0x8ca90000, 0x8cb4ffff, REGISTRY_ARIN       }, // 140.169.0.0     - 140.180.255.255
	{ 0x8cb50000, 0x8cb5ffff, REGISTRY_RIPENCC    }, // 140.181.0.0     - 140.181.255.255
	{ 0x8cb60000, 0x8cbeffff, REGISTRY_ARIN       }, // 140.182.0.0     - 140.190.255.255
	{ 0x8cbf0000, 0x8cbfffff, REGISTRY_LACNIC     }, // 140.191.0.0     - 140.191.255.255
	{ 0x8cc00000, 0x8cc7ffff, REGISTRY_ARIN       }, // 140.192.0.0     - 140.199.255.255
	{ 0x8cc80000, 0x8cc8ffff, REGISTRY_APNIC      }, // 140.200.0.0     - 140.200.255.255
	{ 0x8cc90000, 0x8ccaffff, REGISTRY_ARIN       }, // 140.201.0.0     - 140.202.255.255
	{ 0x8ccb0000, 0x8ccbffff, REGISTRY_RIPENCC    }, // 140.203.0.0     - 140.203.255.255
	{ 0x8ccc0000, 0x8cccffff, REGISTRY_ARIN       }, // 140.204.0.0     - 140.204.255.255
	{ 0x8ccd0000, 0x8ccfffff, REGISTRY_APNIC      }, // 140.205.0.0     - 140.207.255.255
	{ 0x8cd00000, 0x8cd1ffff, REGISTRY_ARIN       }, // 140.208.0.0     - 140.209.255.255
	{ 0x8cd20000, 0x8cd2ffff, REGISTRY_APNIC      }, // 140.210.0.0     - 140.210.255.255
	{ 0x8cd30000, 0x8cd4ffff, REGISTRY_ARIN       }, // 140.211.0.0     - 140.212.255.255
	{ 0x8cd50000, 0x8cd5ffff, REGISTRY_APNIC      }, // 140.213.0.0     - 140.213.255.255
	{ 0x8cd60000, 0x8cdfffff, REGISTRY_ARIN       }, // 140.214.0.0     - 140.223.255.255
	{ 0x8ce00000, 0x8ce0ffff, REGISTRY_APNIC      }, // 140.224.0.0     - 140.224.255.255
	{ 0x8ce10000, 0x8ce6ffff, REGISTRY_ARIN       }, // 140.225.0.0     - 140.230.255.255
	{ 0x8ce70000, 0x8ce7ffff, REGISTRY_RIPENCC    }, // 140.231.0.0     - 140.231.255.255
	{ 0x8ce80000, 0x8cecffff, REGISTRY_ARIN       }, // 140.232.0.0     - 140.236.255.255
	{ 0x8ced0000, 0x8cedffff, REGISTRY_APNIC      }, // 140.237.0.0     - 140.237.255.255
	{ 0x8cee0000, 0x8cefffff, REGISTRY_ARIN       }, // 140.238.0.0     - 140.239.255.255
	{ 0x8cf00000, 0x8cf0ffff, REGISTRY_APNIC      }, // 140.240.0.0     - 140.240.255.255
	{ 0x8cf10000, 0x8cf2ffff, REGISTRY_ARIN       }, // 140.241.0.0     - 140.242.255.255
	{ 0x8cf30000, 0x8cf3ffff, REGISTRY_APNIC      }, // 140.243.0.0     - 140.243.255.255
	{ 0x8cf40000, 0x8cf5ffff, REGISTRY_ARIN       }, // 140.244.0.0     - 140.245.255.255
	{ 0x8cf60000, 0x8cf6ffff, REGISTRY_APNIC      }, // 140.246.0.0     - 140.246.255.255
	{ 0x8cf70000, 0x8cf8ffff, REGISTRY_ARIN       }, // 140.247.0.0     - 140.248.255.255
	{ 0x8cf90000, 0x8cfaffff, REGISTRY_APNIC      }, // 140.249.0.0     - 140.250.255.255
	{ 0x8cfb0000, 0x8cfcffff, REGISTRY_ARIN       }, // 140.251.0.0     - 140.252.255.255
	{ 0x8cfd0000, 0x8cfdffff, REGISTRY_APNIC      }, // 140.253.0.0     - 140.253.255.255
	{ 0x8cfe0000, 0x8cfeffff, REGISTRY_ARIN       }, // 140.254.0.0     - 140.254.255.255
	{ 0x8cff0000, 0x8cffffff, REGISTRY_APNIC      }, // 140.255.0.0     - 140.255.255.255
	{ 0x8d000000, 0x8d00ffff, REGISTRY_RIPENCC    }, // 141.0.0.0       - 141.0.255.255  
	{ 0x8d010000, 0x8d07ffff, REGISTRY_RIPENCC    }, // 141.1.0.0       - 141.7.255.255  
	{ 0x8d080000, 0x8d08ffff, REGISTRY_RIPENCC    }, // 141.8.0.0       - 141.8.255.255  
	{ 0x8d090000, 0x8d55ffff, REGISTRY_RIPENCC    }, // 141.9.0.0       - 141.85.255.255 
	{ 0x8d560000, 0x8d56ffff, REGISTRY_ARIN       }, // 141.86.0.0      - 141.86.255.255 
	{ 0x8d570000, 0x8d60ffff, REGISTRY_RIPENCC    }, // 141.87.0.0      - 141.96.255.255 
	{ 0x8d610000, 0x8d61ffff, REGISTRY_RIPENCC    }, // 141.97.0.0      - 141.97.255.255 
	{ 0x8d630000, 0x8d64ffff, REGISTRY_RIPENCC    }, // 141.99.0.0      - 141.100.255.255
	{ 0x8d650000, 0x8d65ffff, REGISTRY_RIPENCC    }, // 141.101.0.0     - 141.101.255.255
	{ 0x8d660000, 0x8d66ffff, REGISTRY_ARIN       }, // 141.102.0.0     - 141.102.255.255
	{ 0x8d670000, 0x8d67ffff, REGISTRY_APNIC      }, // 141.103.0.0     - 141.103.255.255
	{ 0x8d680000, 0x8d68ffff, REGISTRY_ARIN       }, // 141.104.0.0     - 141.104.255.255
	{ 0x8d690000, 0x8d69ffff, REGISTRY_RIPENCC    }, // 141.105.0.0     - 141.105.255.255
	{ 0x8d6a0000, 0x8d6bffff, REGISTRY_ARIN       }, // 141.106.0.0     - 141.107.255.255
	{ 0x8d6c0000, 0x8d6cffff, REGISTRY_RIPENCC    }, // 141.108.0.0     - 141.108.255.255
	{ 0x8d6d0000, 0x8d70ffff, REGISTRY_ARIN       }, // 141.109.0.0     - 141.112.255.255
	{ 0x8d710000, 0x8d71ffff, REGISTRY_RIPENCC    }, // 141.113.0.0     - 141.113.255.255
	{ 0x8d720000, 0x8d72ffff, REGISTRY_ARIN       }, // 141.114.0.0     - 141.114.255.255
	{ 0x8d730000, 0x8d73ffff, REGISTRY_RIPENCC    }, // 141.115.0.0     - 141.115.255.255
	{ 0x8d740000, 0x8d77ffff, REGISTRY_ARIN       }, // 141.116.0.0     - 141.119.255.255
	{ 0x8d780000, 0x8d78ffff, REGISTRY_APNIC      }, // 141.120.0.0     - 141.120.255.255
	{ 0x8d790000, 0x8d81ffff, REGISTRY_ARIN       }, // 141.121.0.0     - 141.129.255.255
	{ 0x8d820000, 0x8d82ffff, REGISTRY_RIPENCC    }, // 141.130.0.0     - 141.130.255.255
	{ 0x8d830000, 0x8d83ffff, REGISTRY_ARIN       }, // 141.131.0.0     - 141.131.255.255
	{ 0x8d840000, 0x8d84ffff, REGISTRY_APNIC      }, // 141.132.0.0     - 141.132.255.255
	{ 0x8d850000, 0x8d85ffff, REGISTRY_ARIN       }, // 141.133.0.0     - 141.133.255.255
	{ 0x8d860000, 0x8d88ffff, REGISTRY_RIPENCC    }, // 141.134.0.0     - 141.136.255.255
	{ 0x8d890000, 0x8d89ffff, REGISTRY_RIPENCC    }, // 141.137.0.0     - 141.137.255.255
	{ 0x8d8a0000, 0x8d8affff, REGISTRY_RIPENCC    }, // 141.138.0.0     - 141.138.255.255
	{ 0x8d8b0000, 0x8d8effff, REGISTRY_ARIN       }, // 141.139.0.0     - 141.142.255.255
	{ 0x8d8f0000, 0x8d94ffff, REGISTRY_RIPENCC    }, // 141.143.0.0     - 141.148.255.255
	{ 0x8d950000, 0x8da2ffff, REGISTRY_ARIN       }, // 141.149.0.0     - 141.162.255.255
	{ 0x8da30000, 0x8da3ffff, REGISTRY_RIPENCC    }, // 141.163.0.0     - 141.163.255.255
	{ 0x8da40000, 0x8da7ffff, REGISTRY_ARIN       }, // 141.164.0.0     - 141.167.255.255
	{ 0x8da80000, 0x8da8ffff, REGISTRY_APNIC      }, // 141.168.0.0     - 141.168.255.255
	{ 0x8da90000, 0x8da9ffff, REGISTRY_RIPENCC    }, // 141.169.0.0     - 141.169.255.255
	{ 0x8daa0000, 0x8daaffff, REGISTRY_RIPENCC    }, // 141.170.0.0     - 141.170.255.255
	{ 0x8dab0000, 0x8dacffff, REGISTRY_RIPENCC    }, // 141.171.0.0     - 141.172.255.255
	{ 0x8dad0000, 0x8daeffff, REGISTRY_ARIN       }, // 141.173.0.0     - 141.174.255.255
	{ 0x8daf0000, 0x8db0ffff, REGISTRY_RIPENCC    }, // 141.175.0.0     - 141.176.255.255
	{ 0x8db10000, 0x8db1ffff, REGISTRY_ARIN       }, // 141.177.0.0     - 141.177.255.255
	{ 0x8db20000, 0x8db2ffff, REGISTRY_APNIC      }, // 141.178.0.0     - 141.178.255.255
	{ 0x8db30000, 0x8dbfffff, REGISTRY_ARIN       }, // 141.179.0.0     - 141.191.255.255
	{ 0x8dc00000, 0x8dc0ffff, REGISTRY_RIPENCC    }, // 141.192.0.0     - 141.192.255.255
	{ 0x8dc10000, 0x8dc1ffff, REGISTRY_ARIN       }, // 141.193.0.0     - 141.193.255.255
	{ 0x8dc20000, 0x8dc2ffff, REGISTRY_RIPENCC    }, // 141.194.0.0     - 141.194.255.255
	{ 0x8dc30000, 0x8dc3ffff, REGISTRY_ARIN       }, // 141.195.0.0     - 141.195.255.255
	{ 0x8dc40000, 0x8dc4ffff, REGISTRY_RIPENCC    }, // 141.196.0.0     - 141.196.255.255
	{ 0x8dc50000, 0x8dc7ffff, REGISTRY_ARIN       }, // 141.197.0.0     - 141.199.255.255
	{ 0x8dc80000, 0x8dc9ffff, REGISTRY_RIPENCC    }, // 141.200.0.0     - 141.201.255.255
	{ 0x8dca0000, 0x8dcaffff, REGISTRY_ARIN       }, // 141.202.0.0     - 141.202.255.255
	{ 0x8dcb0000, 0x8dcbffff, REGISTRY_RIPENCC    }, // 141.203.0.0     - 141.203.255.255
	{ 0x8dcc0000, 0x8dcfffff, REGISTRY_ARIN       }, // 141.204.0.0     - 141.207.255.255
	{ 0x8dd00000, 0x8dd0ffff, REGISTRY_RIPENCC    }, // 141.208.0.0     - 141.208.255.255
	{ 0x8dd10000, 0x8ddeffff, REGISTRY_ARIN       }, // 141.209.0.0     - 141.222.255.255
	{ 0x8ddf0000, 0x8ddfffff, REGISTRY_APNIC      }, // 141.223.0.0     - 141.223.255.255
	{ 0x8de00000, 0x8de1ffff, REGISTRY_ARIN       }, // 141.224.0.0     - 141.225.255.255
	{ 0x8de20000, 0x8de4ffff, REGISTRY_RIPENCC    }, // 141.226.0.0     - 141.228.255.255
	{ 0x8de60000, 0x8de6ffff, REGISTRY_ARIN       }, // 141.230.0.0     - 141.230.255.255
	{ 0x8de70000, 0x8de7ffff, REGISTRY_RIPENCC    }, // 141.231.0.0     - 141.231.255.255
	{ 0x8de80000, 0x8decffff, REGISTRY_ARIN       }, // 141.232.0.0     - 141.236.255.255
	{ 0x8ded0000, 0x8dedffff, REGISTRY_RIPENCC    }, // 141.237.0.0     - 141.237.255.255
	{ 0x8dee0000, 0x8df0ffff, REGISTRY_ARIN       }, // 141.238.0.0     - 141.240.255.255
	{ 0x8df10000, 0x8df1ffff, REGISTRY_RIPENCC    }, // 141.241.0.0     - 141.241.255.255
	{ 0x8df20000, 0x8df2ffff, REGISTRY_ARIN       }, // 141.242.0.0     - 141.242.255.255
	{ 0x8df30000, 0x8df3ffff, REGISTRY_APNIC      }, // 141.243.0.0     - 141.243.255.255
	{ 0x8df40000, 0x8df5ffff, REGISTRY_RIPENCC    }, // 141.244.0.0     - 141.245.255.255
	{ 0x8df60000, 0x8df8ffff, REGISTRY_ARIN       }, // 141.246.0.0     - 141.248.255.255
	{ 0x8df90000, 0x8dfaffff, REGISTRY_RIPENCC    }, // 141.249.0.0     - 141.250.255.255
	{ 0x8dfb0000, 0x8dfbffff, REGISTRY_ARIN       }, // 141.251.0.0     - 141.251.255.255
	{ 0x8dfc0000, 0x8dfdffff, REGISTRY_RIPENCC    }, // 141.252.0.0     - 141.253.255.255
	{ 0x8dfe0000, 0x8dfeffff, REGISTRY_ARIN       }, // 141.254.0.0     - 141.254.255.255
	{ 0x8dff0000, 0x8dffffff, REGISTRY_RIPENCC    }, // 141.255.0.0     - 141.255.255.255
	{ 0x8e000000, 0x8effffff, REGISTRY_ARIN       }, // 142.0.0.0       - 142.255.255.255
	{ 0x8f010000, 0x8f28ffff, REGISTRY_ARIN       }, // 143.1.0.0       - 143.40.255.255 
	{ 0x8f290000, 0x8f29ffff, REGISTRY_RIPENCC    }, // 143.41.0.0      - 143.41.255.255 
	{ 0x8f2a0000, 0x8f2effff, REGISTRY_ARIN       }, // 143.42.0.0      - 143.46.255.255 
	{ 0x8f2f0000, 0x8f2fffff, REGISTRY_RIPENCC    }, // 143.47.0.0      - 143.47.255.255 
	{ 0x8f300000, 0x8f31ffff, REGISTRY_ARIN       }, // 143.48.0.0      - 143.49.255.255 
	{ 0x8f320000, 0x8f35ffff, REGISTRY_RIPENCC    }, // 143.50.0.0      - 143.53.255.255 
	{ 0x8f360000, 0x8f36ffff, REGISTRY_LACNIC     }, // 143.54.0.0      - 143.54.255.255 
	{ 0x8f370000, 0x8f40ffff, REGISTRY_ARIN       }, // 143.55.0.0      - 143.64.255.255 
	{ 0x8f410000, 0x8f41ffff, REGISTRY_RIPENCC    }, // 143.65.0.0      - 143.65.255.255 
	{ 0x8f420000, 0x8f58ffff, REGISTRY_ARIN       }, // 143.66.0.0      - 143.88.255.255 
	{ 0x8f590000, 0x8f5affff, REGISTRY_APNIC      }, // 143.89.0.0      - 143.90.255.255 
	{ 0x8f5b0000, 0x8f5bffff, REGISTRY_ARIN       }, // 143.91.0.0      - 143.91.255.255 
	{ 0x8f5c0000, 0x8f5cffff, REGISTRY_APNIC      }, // 143.92.0.0      - 143.92.255.255 
	{ 0x8f5d0000, 0x8f5dffff, REGISTRY_RIPENCC    }, // 143.93.0.0      - 143.93.255.255 
	{ 0x8f5e0000, 0x8f5effff, REGISTRY_APNIC      }, // 143.94.0.0      - 143.94.255.255 
	{ 0x8f5f0000, 0x8f5fffff, REGISTRY_ARIN       }, // 143.95.0.0      - 143.95.255.255 
	{ 0x8f600000, 0x8f60ffff, REGISTRY_APNIC      }, // 143.96.0.0      - 143.96.255.255 
	{ 0x8f610000, 0x8f61ffff, REGISTRY_RIPENCC    }, // 143.97.0.0      - 143.97.255.255 
	{ 0x8f620000, 0x8f62ffff, REGISTRY_ARIN       }, // 143.98.0.0      - 143.98.255.255 
	{ 0x8f630000, 0x8f63ffff, REGISTRY_RIPENCC    }, // 143.99.0.0      - 143.99.255.255 
	{ 0x8f640000, 0x8f69ffff, REGISTRY_ARIN       }, // 143.100.0.0     - 143.105.255.255
	{ 0x8f6a0000, 0x8f6cffff, REGISTRY_LACNIC     }, // 143.106.0.0     - 143.108.255.255
	{ 0x8f6d0000, 0x8f74ffff, REGISTRY_ARIN       }, // 143.109.0.0     - 143.116.255.255
	{ 0x8f750000, 0x8f76ffff, REGISTRY_RIPENCC    }, // 143.117.0.0     - 143.118.255.255
	{ 0x8f770000, 0x8f77ffff, REGISTRY_APNIC      }, // 143.119.0.0     - 143.119.255.255
	{ 0x8f780000, 0x8f78ffff, REGISTRY_ARIN       }, // 143.120.0.0     - 143.120.255.255
	{ 0x8f790000, 0x8f79ffff, REGISTRY_RIPENCC    }, // 143.121.0.0     - 143.121.255.255
	{ 0x8f7a0000, 0x8f7cffff, REGISTRY_ARIN       }, // 143.122.0.0     - 143.124.255.255
	{ 0x8f7d0000, 0x8f7dffff, REGISTRY_APNIC      }, // 143.125.0.0     - 143.125.255.255
	{ 0x8f7e0000, 0x8f7effff, REGISTRY_RIPENCC    }, // 143.126.0.0     - 143.126.255.255
	{ 0x8f7f0000, 0x8f7fffff, REGISTRY_ARIN       }, // 143.127.0.0     - 143.127.255.255
	{ 0x8f800000, 0x8f80ffff, REGISTRY_AFRINIC    }, // 143.128.0.0     - 143.128.255.255
	{ 0x8f810000, 0x8f82ffff, REGISTRY_RIPENCC    }, // 143.129.0.0     - 143.130.255.255
	{ 0x8f830000, 0x8f87ffff, REGISTRY_ARIN       }, // 143.131.0.0     - 143.135.255.255
	{ 0x8f880000, 0x8f88ffff, REGISTRY_APNIC      }, // 143.136.0.0     - 143.136.255.255
	{ 0x8f8a0000, 0x8f9fffff, REGISTRY_ARIN       }, // 143.138.0.0     - 143.159.255.255
	{ 0x8fa00000, 0x8fa0ffff, REGISTRY_AFRINIC    }, // 143.160.0.0     - 143.160.255.255
	{ 0x8fa10000, 0x8fa1ffff, REGISTRY_RIPENCC    }, // 143.161.0.0     - 143.161.255.255
	{ 0x8fa20000, 0x8fa2ffff, REGISTRY_ARIN       }, // 143.162.0.0     - 143.162.255.255
	{ 0x8fa30000, 0x8fa4ffff, REGISTRY_RIPENCC    }, // 143.163.0.0     - 143.164.255.255
	{ 0x8fa50000, 0x8fa6ffff, REGISTRY_ARIN       }, // 143.165.0.0     - 143.166.255.255
	{ 0x8fa70000, 0x8fa7ffff, REGISTRY_RIPENCC    }, // 143.167.0.0     - 143.167.255.255
	{ 0x8fa80000, 0x8fa8ffff, REGISTRY_ARIN       }, // 143.168.0.0     - 143.168.255.255
	{ 0x8fa90000, 0x8fa9ffff, REGISTRY_RIPENCC    }, // 143.169.0.0     - 143.169.255.255
	{ 0x8faa0000, 0x8faaffff, REGISTRY_ARIN       }, // 143.170.0.0     - 143.170.255.255
	{ 0x8fac0000, 0x8fadffff, REGISTRY_ARIN       }, // 143.172.0.0     - 143.173.255.255
	{ 0x8fae0000, 0x8faeffff, REGISTRY_APNIC      }, // 143.174.0.0     - 143.174.255.255
	{ 0x8faf0000, 0x8fafffff, REGISTRY_ARIN       }, // 143.175.0.0     - 143.175.255.255
	{ 0x8fb00000, 0x8fb4ffff, REGISTRY_RIPENCC    }, // 143.176.0.0     - 143.180.255.255
	{ 0x8fb50000, 0x8fbbffff, REGISTRY_ARIN       }, // 143.181.0.0     - 143.187.255.255
	{ 0x8fbc0000, 0x8fbdffff, REGISTRY_APNIC      }, // 143.188.0.0     - 143.189.255.255
	{ 0x8fbe0000, 0x8fc05fff, REGISTRY_ARIN       }, // 143.190.0.0     - 143.192.95.255 
	{ 0x8fc06000, 0x8fc06fff, REGISTRY_APNIC      }, // 143.192.96.0    - 143.192.111.255
	{ 0x8fc07000, 0x8fc3ffff, REGISTRY_ARIN       }, // 143.192.112.0   - 143.195.255.255
	{ 0x8fc40000, 0x8fc4ffff, REGISTRY_RIPENCC    }, // 143.196.0.0     - 143.196.255.255
	{ 0x8fc50000, 0x8fc8ffff, REGISTRY_ARIN       }, // 143.197.0.0     - 143.200.255.255
	{ 0x8fcb0000, 0x8fccffff, REGISTRY_ARIN       }, // 143.203.0.0     - 143.204.255.255
	{ 0x8fcd0000, 0x8fcdffff, REGISTRY_RIPENCC    }, // 143.205.0.0     - 143.205.255.255
	{ 0x8fce0000, 0x8fcfffff, REGISTRY_ARIN       }, // 143.206.0.0     - 143.207.255.255
	{ 0x8fd10000, 0x8fd1ffff, REGISTRY_ARIN       }, // 143.209.0.0     - 143.209.255.255
	{ 0x8fd20000, 0x8fd2ffff, REGISTRY_RIPENCC    }, // 143.210.0.0     - 143.210.255.255
	{ 0x8fd30000, 0x8fd7ffff, REGISTRY_ARIN       }, // 143.211.0.0     - 143.215.255.255
	{ 0x8fd80000, 0x8fd8ffff, REGISTRY_APNIC      }, // 143.216.0.0     - 143.216.255.255
	{ 0x8fd90000, 0x8fd9ffff, REGISTRY_RIPENCC    }, // 143.217.0.0     - 143.217.255.255
	{ 0x8fda0000, 0x8fdaffff, REGISTRY_APNIC      }, // 143.218.0.0     - 143.218.255.255
	{ 0x8fdb0000, 0x8fdcffff, REGISTRY_ARIN       }, // 143.219.0.0     - 143.220.255.255
	{ 0x8fdd0000, 0x8fddffff, REGISTRY_APNIC      }, // 143.221.0.0     - 143.221.255.255
	{ 0x8fde0000, 0x8fdfffff, REGISTRY_ARIN       }, // 143.222.0.0     - 143.223.255.255
	{ 0x8fe00000, 0x8fe1ffff, REGISTRY_RIPENCC    }, // 143.224.0.0     - 143.225.255.255
	{ 0x8fe20000, 0x8fe8ffff, REGISTRY_ARIN       }, // 143.226.0.0     - 143.232.255.255
	{ 0x8fe90000, 0x8feaffff, REGISTRY_RIPENCC    }, // 143.233.0.0     - 143.234.255.255
	{ 0x8feb0000, 0x8fecffff, REGISTRY_ARIN       }, // 143.235.0.0     - 143.236.255.255
	{ 0x8fed0000, 0x8fedffff, REGISTRY_RIPENCC    }, // 143.237.0.0     - 143.237.255.255
	{ 0x8fee0000, 0x8feeffff, REGISTRY_APNIC      }, // 143.238.0.0     - 143.238.255.255
	{ 0x8fef0000, 0x8fefffff, REGISTRY_RIPENCC    }, // 143.239.0.0     - 143.239.255.255
	{ 0x8ff00000, 0x8ff4ffff, REGISTRY_ARIN       }, // 143.240.0.0     - 143.244.255.255
	{ 0x8ff50000, 0x8ff5ffff, REGISTRY_RIPENCC    }, // 143.245.0.0     - 143.245.255.255
	{ 0x8ff60000, 0x8ff7ffff, REGISTRY_ARIN       }, // 143.246.0.0     - 143.247.255.255
	{ 0x8ff80000, 0x8ff8ffff, REGISTRY_APNIC      }, // 143.248.0.0     - 143.248.255.255
	{ 0x8ff90000, 0x8ffbffff, REGISTRY_ARIN       }, // 143.249.0.0     - 143.251.255.255
	{ 0x8ffc0000, 0x8ffcffff, REGISTRY_RIPENCC    }, // 143.252.0.0     - 143.252.255.255
	{ 0x8ffd0000, 0x8ffdffff, REGISTRY_APNIC      }, // 143.253.0.0     - 143.253.255.255
	{ 0x8ffe0000, 0x8ffeffff, REGISTRY_ARIN       }, // 143.254.0.0     - 143.254.255.255
	{ 0x90000000, 0x9000ffff, REGISTRY_APNIC      }, // 144.0.0.0       - 144.0.255.255  
	{ 0x90020000, 0x9002ffff, REGISTRY_RIPENCC    }, // 144.2.0.0       - 144.2.255.255  
	{ 0x90030000, 0x9003ffff, REGISTRY_ARIN       }, // 144.3.0.0       - 144.3.255.255  
	{ 0x90040000, 0x9004ffff, REGISTRY_RIPENCC    }, // 144.4.0.0       - 144.4.255.255  
	{ 0x90050000, 0x9005ffff, REGISTRY_ARIN       }, // 144.5.0.0       - 144.5.255.255  
	{ 0x90060000, 0x9007ffff, REGISTRY_APNIC      }, // 144.6.0.0       - 144.7.255.255  
	{ 0x90080000, 0x900bffff, REGISTRY_ARIN       }, // 144.8.0.0       - 144.11.255.255 
	{ 0x900c0000, 0x900cffff, REGISTRY_APNIC      }, // 144.12.0.0      - 144.12.255.255 
	{ 0x900d0000, 0x900fffff, REGISTRY_ARIN       }, // 144.13.0.0      - 144.15.255.255 
	{ 0x90100000, 0x9010ffff, REGISTRY_APNIC      }, // 144.16.0.0      - 144.16.255.255 
	{ 0x90110000, 0x9013ffff, REGISTRY_ARIN       }, // 144.17.0.0      - 144.19.255.255 
	{ 0x90140000, 0x9015ffff, REGISTRY_RIPENCC    }, // 144.20.0.0      - 144.21.255.255 
	{ 0x90160000, 0x9017ffff, REGISTRY_LACNIC     }, // 144.22.0.0      - 144.23.255.255 
	{ 0x90180000, 0x9018ffff, REGISTRY_RIPENCC    }, // 144.24.0.0      - 144.24.255.255 
	{ 0x90190000, 0x901affff, REGISTRY_ARIN       }, // 144.25.0.0      - 144.26.255.255 
	{ 0x901b0000, 0x901bffff, REGISTRY_RIPENCC    }, // 144.27.0.0      - 144.27.255.255 
	{ 0x901c0000, 0x901fffff, REGISTRY_ARIN       }, // 144.28.0.0      - 144.31.255.255 
	{ 0x90200000, 0x9020ffff, REGISTRY_RIPENCC    }, // 144.32.0.0      - 144.32.255.255 
	{ 0x90210000, 0x9028ffff, REGISTRY_ARIN       }, // 144.33.0.0      - 144.40.255.255 
	{ 0x90290000, 0x9029ffff, REGISTRY_RIPENCC    }, // 144.41.0.0      - 144.41.255.255 
	{ 0x902a0000, 0x902affff, REGISTRY_ARIN       }, // 144.42.0.0      - 144.42.255.255 
	{ 0x902b0000, 0x902cffff, REGISTRY_RIPENCC    }, // 144.43.0.0      - 144.44.255.255 
	{ 0x902d0000, 0x902fffff, REGISTRY_ARIN       }, // 144.45.0.0      - 144.47.255.255 
	{ 0x90310000, 0x9033ffff, REGISTRY_ARIN       }, // 144.49.0.0      - 144.51.255.255 
	{ 0x90340000, 0x9035ffff, REGISTRY_APNIC      }, // 144.52.0.0      - 144.53.255.255 
	{ 0x90360000, 0x9036ffff, REGISTRY_RIPENCC    }, // 144.54.0.0      - 144.54.255.255 
	{ 0x90370000, 0x9037ffff, REGISTRY_APNIC      }, // 144.55.0.0      - 144.55.255.255 
	{ 0x90380000, 0x9039ffff, REGISTRY_RIPENCC    }, // 144.56.0.0      - 144.57.255.255 
	{ 0x903a0000, 0x903effff, REGISTRY_ARIN       }, // 144.58.0.0      - 144.62.255.255 
	{ 0x903f0000, 0x903fffff, REGISTRY_RIPENCC    }, // 144.63.0.0      - 144.63.255.255 
	{ 0x90400000, 0x9040ffff, REGISTRY_RIPENCC    }, // 144.64.0.0      - 144.64.255.255 
	{ 0x90410000, 0x9041ffff, REGISTRY_RIPENCC    }, // 144.65.0.0      - 144.65.255.255 
	{ 0x90420000, 0x9042ffff, REGISTRY_APNIC      }, // 144.66.0.0      - 144.66.255.255 
	{ 0x90430000, 0x904bffff, REGISTRY_ARIN       }, // 144.67.0.0      - 144.75.255.255 
	{ 0x904c0000, 0x904cffff, REGISTRY_RIPENCC    }, // 144.76.0.0      - 144.76.255.255 
	{ 0x904d0000, 0x904effff, REGISTRY_ARIN       }, // 144.77.0.0      - 144.78.255.255 
	{ 0x90500000, 0x9051ffff, REGISTRY_ARIN       }, // 144.80.0.0      - 144.81.255.255 
	{ 0x90520000, 0x9052ffff, REGISTRY_RIPENCC    }, // 144.82.0.0      - 144.82.255.255 
	{ 0x90530000, 0x9053ffff, REGISTRY_ARIN       }, // 144.83.0.0      - 144.83.255.255 
	{ 0x90540000, 0x9055ffff, REGISTRY_RIPENCC    }, // 144.84.0.0      - 144.85.255.255 
	{ 0x90560000, 0x9056ffff, REGISTRY_ARIN       }, // 144.86.0.0      - 144.86.255.255 
	{ 0x90570000, 0x9057ffff, REGISTRY_RIPENCC    }, // 144.87.0.0      - 144.87.255.255 
	{ 0x90580000, 0x905effff, REGISTRY_ARIN       }, // 144.88.0.0      - 144.94.255.255 
	{ 0x905f0000, 0x905fffff, REGISTRY_RIPENCC    }, // 144.95.0.0      - 144.95.255.255 
	{ 0x90600000, 0x9060ffff, REGISTRY_ARIN       }, // 144.96.0.0      - 144.96.255.255 
	{ 0x90610000, 0x9061ffff, REGISTRY_APNIC      }, // 144.97.0.0      - 144.97.255.255 
	{ 0x90620000, 0x9062ffff, REGISTRY_RIPENCC    }, // 144.98.0.0      - 144.98.255.255 
	{ 0x90630000, 0x906dffff, REGISTRY_ARIN       }, // 144.99.0.0      - 144.109.255.255
	{ 0x906e0000, 0x906effff, REGISTRY_APNIC      }, // 144.110.0.0     - 144.110.255.255
	{ 0x906f0000, 0x9076ffff, REGISTRY_ARIN       }, // 144.111.0.0     - 144.118.255.255
	{ 0x90770000, 0x9077ffff, REGISTRY_RIPENCC    }, // 144.119.0.0     - 144.119.255.255
	{ 0x90780000, 0x9078ffff, REGISTRY_APNIC      }, // 144.120.0.0     - 144.120.255.255
	{ 0x90790000, 0x9079ffff, REGISTRY_ARIN       }, // 144.121.0.0     - 144.121.255.255
	{ 0x907a0000, 0x907affff, REGISTRY_RIPENCC    }, // 144.122.0.0     - 144.122.255.255
	{ 0x907b0000, 0x907bffff, REGISTRY_APNIC      }, // 144.123.0.0     - 144.123.255.255
	{ 0x907c0000, 0x907cffff, REGISTRY_RIPENCC    }, // 144.124.0.0     - 144.124.255.255
	{ 0x907d0000, 0x907effff, REGISTRY_ARIN       }, // 144.125.0.0     - 144.126.255.255
	{ 0x907f0000, 0x907fffff, REGISTRY_RIPENCC    }, // 144.127.0.0     - 144.127.255.255
	{ 0x90800000, 0x9081ffff, REGISTRY_ARIN       }, // 144.128.0.0     - 144.129.255.255
	{ 0x90820000, 0x908cffff, REGISTRY_APNIC      }, // 144.130.0.0     - 144.140.255.255
	{ 0x908d0000, 0x9090ffff, REGISTRY_ARIN       }, // 144.141.0.0     - 144.144.255.255
	{ 0x90910000, 0x9091ffff, REGISTRY_RIPENCC    }, // 144.145.0.0     - 144.145.255.255
	{ 0x90920000, 0x90a3ffff, REGISTRY_ARIN       }, // 144.146.0.0     - 144.163.255.255
	{ 0x90a40000, 0x90a5ffff, REGISTRY_RIPENCC    }, // 144.164.0.0     - 144.165.255.255
	{ 0x90a60000, 0x90a7ffff, REGISTRY_ARIN       }, // 144.166.0.0     - 144.167.255.255
	{ 0x90a90000, 0x90acffff, REGISTRY_ARIN       }, // 144.169.0.0     - 144.172.255.255
	{ 0x90ad0000, 0x90adffff, REGISTRY_RIPENCC    }, // 144.173.0.0     - 144.173.255.255
	{ 0x90ae0000, 0x90afffff, REGISTRY_ARIN       }, // 144.174.0.0     - 144.175.255.255
	{ 0x90b00000, 0x90b5ffff, REGISTRY_RIPENCC    }, // 144.176.0.0     - 144.181.255.255
	{ 0x90b60000, 0x90c0ffff, REGISTRY_ARIN       }, // 144.182.0.0     - 144.192.255.255
	{ 0x90c10000, 0x90c1ffff, REGISTRY_RIPENCC    }, // 144.193.0.0     - 144.193.255.255
	{ 0x90c20000, 0x90c6ffff, REGISTRY_ARIN       }, // 144.194.0.0     - 144.198.255.255
	{ 0x90c70000, 0x90c7ffff, REGISTRY_APNIC      }, // 144.199.0.0     - 144.199.255.255
	{ 0x90c80000, 0x90c8ffff, REGISTRY_RIPENCC    }, // 144.200.0.0     - 144.200.255.255
	{ 0x90c90000, 0x90cbffff, REGISTRY_ARIN       }, // 144.201.0.0     - 144.203.255.255
	{ 0x90cc0000, 0x90ccffff, REGISTRY_RIPENCC    }, // 144.204.0.0     - 144.204.255.255
	{ 0x90cd0000, 0x90cdffff, REGISTRY_APNIC      }, // 144.205.0.0     - 144.205.255.255
	{ 0x90ce0000, 0x90ceffff, REGISTRY_RIPENCC    }, // 144.206.0.0     - 144.206.255.255
	{ 0x90cf0000, 0x90d0ffff, REGISTRY_ARIN       }, // 144.207.0.0     - 144.208.255.255
	{ 0x90d10000, 0x90d1ffff, REGISTRY_RIPENCC    }, // 144.209.0.0     - 144.209.255.255
	{ 0x90d20000, 0x90d4ffff, REGISTRY_ARIN       }, // 144.210.0.0     - 144.212.255.255
	{ 0x90d50000, 0x90d6ffff, REGISTRY_APNIC      }, // 144.213.0.0     - 144.214.255.255
	{ 0x90d70000, 0x90d9ffff, REGISTRY_ARIN       }, // 144.215.0.0     - 144.217.255.255
	{ 0x90db0000, 0x90f7ffff, REGISTRY_ARIN       }, // 144.219.0.0     - 144.247.255.255
	{ 0x90f80000, 0x90f8ffff, REGISTRY_RIPENCC    }, // 144.248.0.0     - 144.248.255.255
	{ 0x90f90000, 0x90feffff, REGISTRY_ARIN       }, // 144.249.0.0     - 144.254.255.255
	{ 0x90ff0000, 0x90ffffff, REGISTRY_APNIC      }, // 144.255.0.0     - 144.255.255.255
	{ 0x91000000, 0x91e8ffff, REGISTRY_RIPENCC    }, // 145.0.0.0       - 145.232.255.255
	{ 0x91e90000, 0x91e9ffff, REGISTRY_RIPENCC    }, // 145.233.0.0     - 145.233.255.255
	{ 0x91ea0000, 0x91fcffff, REGISTRY_RIPENCC    }, // 145.234.0.0     - 145.252.255.255
	{ 0x91fd0000, 0x9200ffff, REGISTRY_RIPENCC    }, // 145.253.0.0     - 146.0.255.255  
	{ 0x92010000, 0x9201ffff, REGISTRY_ARIN       }, // 146.1.0.0       - 146.1.255.255  
	{ 0x92020000, 0x9204ffff, REGISTRY_RIPENCC    }, // 146.2.0.0       - 146.4.255.255  
	{ 0x92050000, 0x920affff, REGISTRY_ARIN       }, // 146.5.0.0       - 146.10.255.255 
	{ 0x920b0000, 0x920bffff, REGISTRY_APNIC      }, // 146.11.0.0      - 146.11.255.255 
	{ 0x920c0000, 0x9212ffff, REGISTRY_ARIN       }, // 146.12.0.0      - 146.18.255.255 
	{ 0x92130000, 0x9213ffff, REGISTRY_RIPENCC    }, // 146.19.0.0      - 146.19.255.255 
	{ 0x92140000, 0x9214ffff, REGISTRY_ARIN       }, // 146.20.0.0      - 146.20.255.255 
	{ 0x92150000, 0x9215ffff, REGISTRY_RIPENCC    }, // 146.21.0.0      - 146.21.255.255 
	{ 0x92160000, 0x922fffff, REGISTRY_ARIN       }, // 146.22.0.0      - 146.47.255.255 
	{ 0x92300000, 0x9230ffff, REGISTRY_RIPENCC    }, // 146.48.0.0      - 146.48.255.255 
	{ 0x92310000, 0x9231ffff, REGISTRY_ARIN       }, // 146.49.0.0      - 146.49.255.255 
	{ 0x92320000, 0x9232ffff, REGISTRY_RIPENCC    }, // 146.50.0.0      - 146.50.255.255 
	{ 0x92330000, 0x9233ffff, REGISTRY_APNIC      }, // 146.51.0.0      - 146.51.255.255 
	{ 0x92340000, 0x9234ffff, REGISTRY_RIPENCC    }, // 146.52.0.0      - 146.52.255.255 
	{ 0x92350000, 0x9237ffff, REGISTRY_ARIN       }, // 146.53.0.0      - 146.55.255.255 
	{ 0x92380000, 0x9238ffff, REGISTRY_APNIC      }, // 146.56.0.0      - 146.56.255.255 
	{ 0x92390000, 0x923affff, REGISTRY_ARIN       }, // 146.57.0.0      - 146.58.255.255 
	{ 0x923b0000, 0x923bffff, REGISTRY_RIPENCC    }, // 146.59.0.0      - 146.59.255.255 
	{ 0x923c0000, 0x923cffff, REGISTRY_RIPENCC    }, // 146.60.0.0      - 146.60.255.255 
	{ 0x923d0000, 0x923dffff, REGISTRY_ARIN       }, // 146.61.0.0      - 146.61.255.255 
	{ 0x923f0000, 0x923fffff, REGISTRY_ARIN       }, // 146.63.0.0      - 146.63.255.255 
	{ 0x92400000, 0x9240ffff, REGISTRY_AFRINIC    }, // 146.64.0.0      - 146.64.255.255 
	{ 0x92410000, 0x9241ffff, REGISTRY_ARIN       }, // 146.65.0.0      - 146.65.255.255 
	{ 0x92420000, 0x9242ffff, REGISTRY_RIPENCC    }, // 146.66.0.0      - 146.66.255.255 
	{ 0x92430000, 0x9243ffff, REGISTRY_RIPENCC    }, // 146.67.0.0      - 146.67.255.255 
	{ 0x92440000, 0x9245ffff, REGISTRY_ARIN       }, // 146.68.0.0      - 146.69.255.255 
	{ 0x92460000, 0x9246ffff, REGISTRY_RIPENCC    }, // 146.70.0.0      - 146.70.255.255 
	{ 0x92470000, 0x9247ffff, REGISTRY_ARIN       }, // 146.71.0.0      - 146.71.255.255 
	{ 0x92480000, 0x9248ffff, REGISTRY_RIPENCC    }, // 146.72.0.0      - 146.72.255.255 
	{ 0x92490000, 0x924affff, REGISTRY_ARIN       }, // 146.73.0.0      - 146.74.255.255 
	{ 0x924b0000, 0x924bffff, REGISTRY_RIPENCC    }, // 146.75.0.0      - 146.75.255.255 
	{ 0x924c0000, 0x924cffff, REGISTRY_ARIN       }, // 146.76.0.0      - 146.76.255.255 
	{ 0x924d0000, 0x924dffff, REGISTRY_RIPENCC    }, // 146.77.0.0      - 146.77.255.255 
	{ 0x924e0000, 0x924fffff, REGISTRY_ARIN       }, // 146.78.0.0      - 146.79.255.255 
	{ 0x92500000, 0x9251ffff, REGISTRY_RIPENCC    }, // 146.80.0.0      - 146.81.255.255 
	{ 0x92520000, 0x9252ffff, REGISTRY_ARIN       }, // 146.82.0.0      - 146.82.255.255 
	{ 0x92530000, 0x9253ffff, REGISTRY_LACNIC     }, // 146.83.0.0      - 146.83.255.255 
	{ 0x92540000, 0x9256ffff, REGISTRY_ARIN       }, // 146.84.0.0      - 146.86.255.255 
	{ 0x92570000, 0x9257ffff, REGISTRY_RIPENCC    }, // 146.87.0.0      - 146.87.255.255 
	{ 0x92580000, 0x92580fff, REGISTRY_ARIN       }, // 146.88.0.0      - 146.88.15.255  
	{ 0x92581000, 0x925812ff, REGISTRY_APNIC      }, // 146.88.16.0     - 146.88.18.255  
	{ 0x92581300, 0x925813ff, REGISTRY_ARIN       }, // 146.88.19.0     - 146.88.19.255  
	{ 0x92581400, 0x92581cff, REGISTRY_APNIC      }, // 146.88.20.0     - 146.88.28.255  
	{ 0x92581d00, 0x92581fff, REGISTRY_ARIN       }, // 146.88.29.0     - 146.88.31.255  
	{ 0x92582000, 0x92584fff, REGISTRY_APNIC      }, // 146.88.32.0     - 146.88.79.255  
	{ 0x92585000, 0x925853ff, REGISTRY_ARIN       }, // 146.88.80.0     - 146.88.83.255  
	{ 0x92585400, 0x92585fff, REGISTRY_APNIC      }, // 146.88.84.0     - 146.88.95.255  
	{ 0x92586000, 0x92587fff, REGISTRY_ARIN       }, // 146.88.96.0     - 146.88.127.255 
	{ 0x92588000, 0x925887ff, REGISTRY_APNIC      }, // 146.88.128.0    - 146.88.135.255 
	{ 0x92588800, 0x9259ffff, REGISTRY_ARIN       }, // 146.88.136.0    - 146.89.255.255 
	{ 0x925a0000, 0x925affff, REGISTRY_RIPENCC    }, // 146.90.0.0      - 146.90.255.255 
	{ 0x925b0000, 0x9260ffff, REGISTRY_ARIN       }, // 146.91.0.0      - 146.96.255.255 
	{ 0x92610000, 0x9261ffff, REGISTRY_RIPENCC    }, // 146.97.0.0      - 146.97.255.255 
	{ 0x92620000, 0x9263ffff, REGISTRY_ARIN       }, // 146.98.0.0      - 146.99.255.255 
	{ 0x92640000, 0x926effff, REGISTRY_RIPENCC    }, // 146.100.0.0     - 146.110.255.255
	{ 0x926f0000, 0x926fffff, REGISTRY_ARIN       }, // 146.111.0.0     - 146.111.255.255
	{ 0x92700000, 0x9270ffff, REGISTRY_RIPENCC    }, // 146.112.0.0     - 146.112.255.255
	{ 0x92710000, 0x9273ffff, REGISTRY_ARIN       }, // 146.113.0.0     - 146.115.255.255
	{ 0x92740000, 0x9274ffff, REGISTRY_APNIC      }, // 146.116.0.0     - 146.116.255.255
	{ 0x92760000, 0x9276ffff, REGISTRY_APNIC      }, // 146.118.0.0     - 146.118.255.255
	{ 0x92770000, 0x9277ffff, REGISTRY_RIPENCC    }, // 146.119.0.0     - 146.119.255.255
	{ 0x92780000, 0x9278ffff, REGISTRY_RIPENCC    }, // 146.120.0.0     - 146.120.255.255
	{ 0x92790000, 0x927bffff, REGISTRY_ARIN       }, // 146.121.0.0     - 146.123.255.255
	{ 0x927c0000, 0x927cffff, REGISTRY_RIPENCC    }, // 146.124.0.0     - 146.124.255.255
	{ 0x927d0000, 0x9284ffff, REGISTRY_ARIN       }, // 146.125.0.0     - 146.132.255.255
	{ 0x92850000, 0x9285ffff, REGISTRY_RIPENCC    }, // 146.133.0.0     - 146.133.255.255
	{ 0x92860000, 0x9286ffff, REGISTRY_LACNIC     }, // 146.134.0.0     - 146.134.255.255
	{ 0x92870000, 0x9287ffff, REGISTRY_ARIN       }, // 146.135.0.0     - 146.135.255.255
	{ 0x92880000, 0x9288ffff, REGISTRY_RIPENCC    }, // 146.136.0.0     - 146.136.255.255
	{ 0x92890000, 0x928bffff, REGISTRY_ARIN       }, // 146.137.0.0     - 146.139.255.255
	{ 0x928c0000, 0x928cffff, REGISTRY_RIPENCC    }, // 146.140.0.0     - 146.140.255.255
	{ 0x928d0000, 0x928dffff, REGISTRY_AFRINIC    }, // 146.141.0.0     - 146.141.255.255
	{ 0x928e0000, 0x928fffff, REGISTRY_ARIN       }, // 146.142.0.0     - 146.143.255.255
	{ 0x92910000, 0x929affff, REGISTRY_ARIN       }, // 146.145.0.0     - 146.154.255.255
	{ 0x929b0000, 0x929bffff, REGISTRY_LACNIC     }, // 146.155.0.0     - 146.155.255.255
	{ 0x929c0000, 0x929dffff, REGISTRY_ARIN       }, // 146.156.0.0     - 146.157.255.255
	{ 0x929e0000, 0x929effff, REGISTRY_RIPENCC    }, // 146.158.0.0     - 146.158.255.255
	{ 0x929f0000, 0x929fffff, REGISTRY_RIPENCC    }, // 146.159.0.0     - 146.159.255.255
	{ 0x92a00000, 0x92a0ffff, REGISTRY_ARIN       }, // 146.160.0.0     - 146.160.255.255
	{ 0x92a10000, 0x92a2ffff, REGISTRY_RIPENCC    }, // 146.161.0.0     - 146.162.255.255
	{ 0x92a30000, 0x92a3ffff, REGISTRY_ARIN       }, // 146.163.0.0     - 146.163.255.255
	{ 0x92a40000, 0x92a4ffff, REGISTRY_LACNIC     }, // 146.164.0.0     - 146.164.255.255
	{ 0x92a50000, 0x92a8ffff, REGISTRY_ARIN       }, // 146.165.0.0     - 146.168.255.255
	{ 0x92a90000, 0x92a9ffff, REGISTRY_RIPENCC    }, // 146.169.0.0     - 146.169.255.255
	{ 0x92aa0000, 0x92aaffff, REGISTRY_ARIN       }, // 146.170.0.0     - 146.170.255.255
	{ 0x92ab0000, 0x92abffff, REGISTRY_APNIC      }, // 146.171.0.0     - 146.171.255.255
	{ 0x92ac0000, 0x92adffff, REGISTRY_RIPENCC    }, // 146.172.0.0     - 146.173.255.255
	{ 0x92ae0000, 0x92aeffff, REGISTRY_ARIN       }, // 146.174.0.0     - 146.174.255.255
	{ 0x92af0000, 0x92b1ffff, REGISTRY_RIPENCC    }, // 146.175.0.0     - 146.177.255.255
	{ 0x92b20000, 0x92b2ffff, REGISTRY_APNIC      }, // 146.178.0.0     - 146.178.255.255
	{ 0x92b30000, 0x92b3ffff, REGISTRY_RIPENCC    }, // 146.179.0.0     - 146.179.255.255
	{ 0x92b40000, 0x92b5ffff, REGISTRY_ARIN       }, // 146.180.0.0     - 146.181.255.255
	{ 0x92b60000, 0x92b6ffff, REGISTRY_AFRINIC    }, // 146.182.0.0     - 146.182.255.255
	{ 0x92b70000, 0x92b8ffff, REGISTRY_ARIN       }, // 146.183.0.0     - 146.184.255.255
	{ 0x92b90000, 0x92b9ffff, REGISTRY_RIPENCC    }, // 146.185.0.0     - 146.185.255.255
	{ 0x92ba0000, 0x92bbffff, REGISTRY_ARIN       }, // 146.186.0.0     - 146.187.255.255
	{ 0x92bc0000, 0x92bcffff, REGISTRY_RIPENCC    }, // 146.188.0.0     - 146.188.255.255
	{ 0x92bd0000, 0x92beffff, REGISTRY_ARIN       }, // 146.189.0.0     - 146.190.255.255
	{ 0x92bf0000, 0x92c2ffff, REGISTRY_RIPENCC    }, // 146.191.0.0     - 146.194.255.255
	{ 0x92c30000, 0x92c41fff, REGISTRY_APNIC      }, // 146.195.0.0     - 146.196.31.255 
	{ 0x92c50000, 0x92d1ffff, REGISTRY_ARIN       }, // 146.197.0.0     - 146.209.255.255
	{ 0x92d20000, 0x92d3ffff, REGISTRY_RIPENCC    }, // 146.210.0.0     - 146.211.255.255
	{ 0x92d40000, 0x92d4ffff, REGISTRY_RIPENCC    }, // 146.212.0.0     - 146.212.255.255
	{ 0x92d50000, 0x92d5ffff, REGISTRY_RIPENCC    }, // 146.213.0.0     - 146.213.255.255
	{ 0x92d60000, 0x92d7ffff, REGISTRY_ARIN       }, // 146.214.0.0     - 146.215.255.255
	{ 0x92d80000, 0x92d8ffff, REGISTRY_RIPENCC    }, // 146.216.0.0     - 146.216.255.255
	{ 0x92d90000, 0x92daffff, REGISTRY_ARIN       }, // 146.217.0.0     - 146.218.255.255
	{ 0x92db0000, 0x92dcffff, REGISTRY_RIPENCC    }, // 146.219.0.0     - 146.220.255.255
	{ 0x92dd0000, 0x92ddffff, REGISTRY_APNIC      }, // 146.221.0.0     - 146.221.255.255
	{ 0x92de0000, 0x92dfffff, REGISTRY_ARIN       }, // 146.222.0.0     - 146.223.255.255
	{ 0x92e00000, 0x92e0ffff, REGISTRY_RIPENCC    }, // 146.224.0.0     - 146.224.255.255
	{ 0x92e10000, 0x92e2ffff, REGISTRY_ARIN       }, // 146.225.0.0     - 146.226.255.255
	{ 0x92e30000, 0x92e4ffff, REGISTRY_RIPENCC    }, // 146.227.0.0     - 146.228.255.255
	{ 0x92e50000, 0x92e5ffff, REGISTRY_ARIN       }, // 146.229.0.0     - 146.229.255.255
	{ 0x92e60000, 0x92e8ffff, REGISTRY_AFRINIC    }, // 146.230.0.0     - 146.232.255.255
	{ 0x92e90000, 0x92e9ffff, REGISTRY_ARIN       }, // 146.233.0.0     - 146.233.255.255
	{ 0x92ea0000, 0x92eaffff, REGISTRY_RIPENCC    }, // 146.234.0.0     - 146.234.255.255
	{ 0x92eb0000, 0x92f6ffff, REGISTRY_ARIN       }, // 146.235.0.0     - 146.246.255.255
	{ 0x92f70000, 0x92f7ffff, REGISTRY_RIPENCC    }, // 146.247.0.0     - 146.247.255.255
	{ 0x92f80000, 0x92f9ffff, REGISTRY_RIPENCC    }, // 146.248.0.0     - 146.249.255.255
	{ 0x92fa0000, 0x92faffff, REGISTRY_ARIN       }, // 146.250.0.0     - 146.250.255.255
	{ 0x92fb0000, 0x92fbffff, REGISTRY_RIPENCC    }, // 146.251.0.0     - 146.251.255.255
	{ 0x92fc0000, 0x92fcffff, REGISTRY_ARIN       }, // 146.252.0.0     - 146.252.255.255
	{ 0x92fd0000, 0x92feffff, REGISTRY_RIPENCC    }, // 146.253.0.0     - 146.254.255.255
	{ 0x92ff0000, 0x92ffffff, REGISTRY_RIPENCC    }, // 146.255.0.0     - 146.255.255.255
	{ 0x93000000, 0x9305ffff, REGISTRY_ARIN       }, // 147.0.0.0       - 147.5.255.255  
	{ 0x93060000, 0x9306ffff, REGISTRY_APNIC      }, // 147.6.0.0       - 147.6.255.255  
	{ 0x93070000, 0x9307ffff, REGISTRY_RIPENCC    }, // 147.7.0.0       - 147.7.255.255  
	{ 0x93080000, 0x9308ffff, REGISTRY_APNIC      }, // 147.8.0.0       - 147.8.255.255  
	{ 0x93090000, 0x9309ffff, REGISTRY_ARIN       }, // 147.9.0.0       - 147.9.255.255  
	{ 0x930a0000, 0x930affff, REGISTRY_APNIC      }, // 147.10.0.0      - 147.10.255.255 
	{ 0x930b0000, 0x930bffff, REGISTRY_ARIN       }, // 147.11.0.0      - 147.11.255.255 
	{ 0x930c0000, 0x930effff, REGISTRY_RIPENCC    }, // 147.12.0.0      - 147.14.255.255 
	{ 0x930f0000, 0x931affff, REGISTRY_ARIN       }, // 147.15.0.0      - 147.26.255.255 
	{ 0x931b0000, 0x931bffff, REGISTRY_RIPENCC    }, // 147.27.0.0      - 147.27.255.255 
	{ 0x931c0000, 0x931cffff, REGISTRY_ARIN       }, // 147.28.0.0      - 147.28.255.255 
	{ 0x931d0000, 0x931dffff, REGISTRY_RIPENCC    }, // 147.29.0.0      - 147.29.255.255 
	{ 0x931e0000, 0x931effff, REGISTRY_RIPENCC    }, // 147.30.0.0      - 147.30.255.255 
	{ 0x931f0000, 0x931fffff, REGISTRY_ARIN       }, // 147.31.0.0      - 147.31.255.255 
	{ 0x93200000, 0x9321ffff, REGISTRY_RIPENCC    }, // 147.32.0.0      - 147.33.255.255 
	{ 0x93220000, 0x9328ffff, REGISTRY_ARIN       }, // 147.34.0.0      - 147.40.255.255 
	{ 0x93290000, 0x9329ffff, REGISTRY_APNIC      }, // 147.41.0.0      - 147.41.255.255 
	{ 0x932a0000, 0x932affff, REGISTRY_ARIN       }, // 147.42.0.0      - 147.42.255.255 
	{ 0x932b0000, 0x932bffff, REGISTRY_APNIC      }, // 147.43.0.0      - 147.43.255.255 
	{ 0x932c0000, 0x932dffff, REGISTRY_RIPENCC    }, // 147.44.0.0      - 147.45.255.255 
	{ 0x932e0000, 0x932fffff, REGISTRY_APNIC      }, // 147.46.0.0      - 147.47.255.255 
	{ 0x93300000, 0x9333ffff, REGISTRY_ARIN       }, // 147.48.0.0      - 147.51.255.255 
	{ 0x93340000, 0x9334ffff, REGISTRY_RIPENCC    }, // 147.52.0.0      - 147.52.255.255 
	{ 0x93350000, 0x9335ffff, REGISTRY_ARIN       }, // 147.53.0.0      - 147.53.255.255 
	{ 0x93360000, 0x9336ffff, REGISTRY_RIPENCC    }, // 147.54.0.0      - 147.54.255.255 
	{ 0x93370000, 0x933bffff, REGISTRY_ARIN       }, // 147.55.0.0      - 147.59.255.255 
	{ 0x933c0000, 0x933cffff, REGISTRY_RIPENCC    }, // 147.60.0.0      - 147.60.255.255 
	{ 0x933d0000, 0x9340ffff, REGISTRY_ARIN       }, // 147.61.0.0      - 147.64.255.255 
	{ 0x93410000, 0x9341ffff, REGISTRY_LACNIC     }, // 147.65.0.0      - 147.65.255.255 
	{ 0x93420000, 0x9342ffff, REGISTRY_APNIC      }, // 147.66.0.0      - 147.66.255.255 
	{ 0x93430000, 0x9344ffff, REGISTRY_RIPENCC    }, // 147.67.0.0      - 147.68.255.255 
	{ 0x93450000, 0x9345ffff, REGISTRY_APNIC      }, // 147.69.0.0      - 147.69.255.255 
	{ 0x93460000, 0x934affff, REGISTRY_ARIN       }, // 147.70.0.0      - 147.74.255.255 
	{ 0x934b0000, 0x934bffff, REGISTRY_RIPENCC    }, // 147.75.0.0      - 147.75.255.255 
	{ 0x934c0000, 0x934cffff, REGISTRY_APNIC      }, // 147.76.0.0      - 147.76.255.255 
	{ 0x934d0000, 0x934dffff, REGISTRY_RIPENCC    }, // 147.77.0.0      - 147.77.255.255 
	{ 0x934f0000, 0x9352ffff, REGISTRY_ARIN       }, // 147.79.0.0      - 147.82.255.255 
	{ 0x93530000, 0x9354ffff, REGISTRY_RIPENCC    }, // 147.83.0.0      - 147.84.255.255 
	{ 0x93550000, 0x9355ffff, REGISTRY_ARIN       }, // 147.85.0.0      - 147.85.255.255 
	{ 0x93560000, 0x9359ffff, REGISTRY_RIPENCC    }, // 147.86.0.0      - 147.89.255.255 
	{ 0x935a0000, 0x935affff, REGISTRY_ARIN       }, // 147.90.0.0      - 147.90.255.255 
	{ 0x935b0000, 0x935bffff, REGISTRY_RIPENCC    }, // 147.91.0.0      - 147.91.255.255 
	{ 0x935c0000, 0x935cffff, REGISTRY_ARIN       }, // 147.92.0.0      - 147.92.255.255 
	{ 0x935d0000, 0x9360ffff, REGISTRY_RIPENCC    }, // 147.93.0.0      - 147.96.255.255 
	{ 0x93610000, 0x9361ffff, REGISTRY_ARIN       }, // 147.97.0.0      - 147.97.255.255 
	{ 0x93620000, 0x9364ffff, REGISTRY_RIPENCC    }, // 147.98.0.0      - 147.100.255.255
	{ 0x93650000, 0x9365ffff, REGISTRY_ARIN       }, // 147.101.0.0     - 147.101.255.255
	{ 0x93660000, 0x9366ffff, REGISTRY_RIPENCC    }, // 147.102.0.0     - 147.102.255.255
	{ 0x93670000, 0x936cffff, REGISTRY_ARIN       }, // 147.103.0.0     - 147.108.255.255
	{ 0x936d0000, 0x936dffff, REGISTRY_APNIC      }, // 147.109.0.0     - 147.109.255.255
	{ 0x936e0000, 0x936effff, REGISTRY_AFRINIC    }, // 147.110.0.0     - 147.110.255.255
	{ 0x936f0000, 0x9370ffff, REGISTRY_RIPENCC    }, // 147.111.0.0     - 147.112.255.255
	{ 0x93710000, 0x9376ffff, REGISTRY_ARIN       }, // 147.113.0.0     - 147.118.255.255
	{ 0x93770000, 0x9377ffff, REGISTRY_RIPENCC    }, // 147.119.0.0     - 147.119.255.255
	{ 0x93780000, 0x9379ffff, REGISTRY_ARIN       }, // 147.120.0.0     - 147.121.255.255
	{ 0x937a0000, 0x937bffff, REGISTRY_RIPENCC    }, // 147.122.0.0     - 147.123.255.255
	{ 0x937c0000, 0x937cffff, REGISTRY_ARIN       }, // 147.124.0.0     - 147.124.255.255
	{ 0x937d0000, 0x937dffff, REGISTRY_RIPENCC    }, // 147.125.0.0     - 147.125.255.255
	{ 0x937e0000, 0x937effff, REGISTRY_ARIN       }, // 147.126.0.0     - 147.126.255.255
	{ 0x937f0000, 0x937fffff, REGISTRY_RIPENCC    }, // 147.127.0.0     - 147.127.255.255
	{ 0x93800000, 0x9383ffff, REGISTRY_ARIN       }, // 147.128.0.0     - 147.131.255.255
	{ 0x93840000, 0x9384ffff, REGISTRY_APNIC      }, // 147.132.0.0     - 147.132.255.255
	{ 0x93850000, 0x938dffff, REGISTRY_ARIN       }, // 147.133.0.0     - 147.141.255.255
	{ 0x938e0000, 0x938fffff, REGISTRY_RIPENCC    }, // 147.142.0.0     - 147.143.255.255
	{ 0x93900000, 0x9392ffff, REGISTRY_ARIN       }, // 147.144.0.0     - 147.146.255.255
	{ 0x93930000, 0x9398ffff, REGISTRY_RIPENCC    }, // 147.147.0.0     - 147.152.255.255
	{ 0x93990000, 0x939bffff, REGISTRY_ARIN       }, // 147.153.0.0     - 147.155.255.255
	{ 0x939c0000, 0x939cffff, REGISTRY_RIPENCC    }, // 147.156.0.0     - 147.156.255.255
	{ 0x939d0000, 0x939effff, REGISTRY_APNIC      }, // 147.157.0.0     - 147.158.255.255
	{ 0x939f0000, 0x93a0ffff, REGISTRY_ARIN       }, // 147.159.0.0     - 147.160.255.255
	{ 0x93a10000, 0x93a3ffff, REGISTRY_RIPENCC    }, // 147.161.0.0     - 147.163.255.255
	{ 0x93a40000, 0x93a6ffff, REGISTRY_ARIN       }, // 147.164.0.0     - 147.166.255.255
	{ 0x93a70000, 0x93a7ffff, REGISTRY_RIPENCC    }, // 147.167.0.0     - 147.167.255.255
	{ 0x93a80000, 0x93aaffff, REGISTRY_ARIN       }, // 147.168.0.0     - 147.170.255.255
	{ 0x93ab0000, 0x93adffff, REGISTRY_RIPENCC    }, // 147.171.0.0     - 147.173.255.255
	{ 0x93ae0000, 0x93aeffff, REGISTRY_ARIN       }, // 147.174.0.0     - 147.174.255.255
	{ 0x93af0000, 0x93afffff, REGISTRY_RIPENCC    }, // 147.175.0.0     - 147.175.255.255
	{ 0x93b00000, 0x93b0ffff, REGISTRY_APNIC      }, // 147.176.0.0     - 147.176.255.255
	{ 0x93b10000, 0x93b3ffff, REGISTRY_ARIN       }, // 147.177.0.0     - 147.179.255.255
	{ 0x93b40000, 0x93b5ffff, REGISTRY_RIPENCC    }, // 147.180.0.0     - 147.181.255.255
	{ 0x93b60000, 0x93b7ffff, REGISTRY_ARIN       }, // 147.182.0.0     - 147.183.255.255
	{ 0x93b80000, 0x93b8ffff, REGISTRY_RIPENCC    }, // 147.184.0.0     - 147.184.255.255
	{ 0x93b90000, 0x93b9ffff, REGISTRY_ARIN       }, // 147.185.0.0     - 147.185.255.255
	{ 0x93ba0000, 0x93baffff, REGISTRY_RIPENCC    }, // 147.186.0.0     - 147.186.255.255
	{ 0x93bb0000, 0x93bbffff, REGISTRY_ARIN       }, // 147.187.0.0     - 147.187.255.255
	{ 0x93bc0000, 0x93bdffff, REGISTRY_RIPENCC    }, // 147.188.0.0     - 147.189.255.255
	{ 0x93be0000, 0x93c0ffff, REGISTRY_ARIN       }, // 147.190.0.0     - 147.192.255.255
	{ 0x93c10000, 0x93c1ffff, REGISTRY_RIPENCC    }, // 147.193.0.0     - 147.193.255.255
	{ 0x93c20000, 0x93c3ffff, REGISTRY_ARIN       }, // 147.194.0.0     - 147.195.255.255
	{ 0x93c40000, 0x93c5ffff, REGISTRY_RIPENCC    }, // 147.196.0.0     - 147.197.255.255
	{ 0x93c60000, 0x93c7ffff, REGISTRY_ARIN       }, // 147.198.0.0     - 147.199.255.255
	{ 0x93c80000, 0x93c8ffff, REGISTRY_APNIC      }, // 147.200.0.0     - 147.200.255.255
	{ 0x93c90000, 0x93c9ffff, REGISTRY_RIPENCC    }, // 147.201.0.0     - 147.201.255.255
	{ 0x93ca0000, 0x93cbffff, REGISTRY_ARIN       }, // 147.202.0.0     - 147.203.255.255
	{ 0x93cc0000, 0x93ccffff, REGISTRY_RIPENCC    }, // 147.204.0.0     - 147.204.255.255
	{ 0x93cd0000, 0x93d0ffff, REGISTRY_ARIN       }, // 147.205.0.0     - 147.208.255.255
	{ 0x93d10000, 0x93d1ffff, REGISTRY_APNIC      }, // 147.209.0.0     - 147.209.255.255
	{ 0x93d20000, 0x93d2ffff, REGISTRY_RIPENCC    }, // 147.210.0.0     - 147.210.255.255
	{ 0x93d30000, 0x93d3ffff, REGISTRY_APNIC      }, // 147.211.0.0     - 147.211.255.255
	{ 0x93d50000, 0x93d7ffff, REGISTRY_RIPENCC    }, // 147.213.0.0     - 147.215.255.255
	{ 0x93d80000, 0x93dbffff, REGISTRY_ARIN       }, // 147.216.0.0     - 147.219.255.255
	{ 0x93dc0000, 0x93dcffff, REGISTRY_RIPENCC    }, // 147.220.0.0     - 147.220.255.255
	{ 0x93dd0000, 0x93e3ffff, REGISTRY_ARIN       }, // 147.221.0.0     - 147.227.255.255
	{ 0x93e40000, 0x93edffff, REGISTRY_RIPENCC    }, // 147.228.0.0     - 147.237.255.255
	{ 0x93ee0000, 0x93f2ffff, REGISTRY_ARIN       }, // 147.238.0.0     - 147.242.255.255
	{ 0x93f30000, 0x93f3ffff, REGISTRY_RIPENCC    }, // 147.243.0.0     - 147.243.255.255
	{ 0x93f40000, 0x93f9ffff, REGISTRY_ARIN       }, // 147.244.0.0     - 147.249.255.255
	{ 0x93fa0000, 0x93fcffff, REGISTRY_RIPENCC    }, // 147.250.0.0     - 147.252.255.255
	{ 0x93fd0000, 0x93ffffff, REGISTRY_ARIN       }, // 147.253.0.0     - 147.255.255.255
	{ 0x94000000, 0x9400ffff, REGISTRY_LACNIC     }, // 148.0.0.0       - 148.0.255.255  
	{ 0x94010000, 0x9401ffff, REGISTRY_ARIN       }, // 148.1.0.0       - 148.1.255.255  
	{ 0x94020000, 0x9403ffff, REGISTRY_RIPENCC    }, // 148.2.0.0       - 148.3.255.255  
	{ 0x94040000, 0x9405ffff, REGISTRY_ARIN       }, // 148.4.0.0       - 148.5.255.255  
	{ 0x94060000, 0x9406ffff, REGISTRY_RIPENCC    }, // 148.6.0.0       - 148.6.255.255  
	{ 0x94070000, 0x9435ffff, REGISTRY_ARIN       }, // 148.7.0.0       - 148.53.255.255 
	{ 0x94360000, 0x9436ffff, REGISTRY_RIPENCC    }, // 148.54.0.0      - 148.54.255.255 
	{ 0x94370000, 0x9437ffff, REGISTRY_ARIN       }, // 148.55.0.0      - 148.55.255.255 
	{ 0x94380000, 0x9438ffff, REGISTRY_RIPENCC    }, // 148.56.0.0      - 148.56.255.255 
	{ 0x94390000, 0x943bffff, REGISTRY_ARIN       }, // 148.57.0.0      - 148.59.255.255 
	{ 0x943c0000, 0x943cffff, REGISTRY_RIPENCC    }, // 148.60.0.0      - 148.60.255.255 
	{ 0x943d0000, 0x944effff, REGISTRY_ARIN       }, // 148.61.0.0      - 148.78.255.255 
	{ 0x944f0000, 0x944fffff, REGISTRY_RIPENCC    }, // 148.79.0.0      - 148.79.255.255 
	{ 0x94500000, 0x9450ffff, REGISTRY_ARIN       }, // 148.80.0.0      - 148.80.255.255 
	{ 0x94510000, 0x9453ffff, REGISTRY_RIPENCC    }, // 148.81.0.0      - 148.83.255.255 
	{ 0x94540000, 0x9457ffff, REGISTRY_ARIN       }, // 148.84.0.0      - 148.87.255.255 
	{ 0x94580000, 0x9458ffff, REGISTRY_RIPENCC    }, // 148.88.0.0      - 148.88.255.255 
	{ 0x94590000, 0x9464ffff, REGISTRY_ARIN       }, // 148.89.0.0      - 148.100.255.255
	{ 0x94650000, 0x9467ffff, REGISTRY_LACNIC     }, // 148.101.0.0     - 148.103.255.255
	{ 0x94680000, 0x946dffff, REGISTRY_ARIN       }, // 148.104.0.0     - 148.109.255.255
	{ 0x946e0000, 0x946effff, REGISTRY_RIPENCC    }, // 148.110.0.0     - 148.110.255.255
	{ 0x946f0000, 0x9475ffff, REGISTRY_ARIN       }, // 148.111.0.0     - 148.117.255.255
	{ 0x94760000, 0x947bffff, REGISTRY_RIPENCC    }, // 148.118.0.0     - 148.123.255.255
	{ 0x947c0000, 0x9486ffff, REGISTRY_ARIN       }, // 148.124.0.0     - 148.134.255.255
	{ 0x94870000, 0x9488ffff, REGISTRY_RIPENCC    }, // 148.135.0.0     - 148.136.255.255
	{ 0x94890000, 0x9489ffff, REGISTRY_ARIN       }, // 148.137.0.0     - 148.137.255.255
	{ 0x948a0000, 0x948affff, REGISTRY_RIPENCC    }, // 148.138.0.0     - 148.138.255.255
	{ 0x948b0000, 0x948bffff, REGISTRY_ARIN       }, // 148.139.0.0     - 148.139.255.255
	{ 0x948c0000, 0x948cffff, REGISTRY_RIPENCC    }, // 148.140.0.0     - 148.140.255.255
	{ 0x948d0000, 0x948effff, REGISTRY_ARIN       }, // 148.141.0.0     - 148.142.255.255
	{ 0x948f0000, 0x948fffff, REGISTRY_RIPENCC    }, // 148.143.0.0     - 148.143.255.255
	{ 0x94900000, 0x9490ffff, REGISTRY_ARIN       }, // 148.144.0.0     - 148.144.255.255
	{ 0x94910000, 0x9491ffff, REGISTRY_APNIC      }, // 148.145.0.0     - 148.145.255.255
	{ 0x94920000, 0x9493ffff, REGISTRY_ARIN       }, // 148.146.0.0     - 148.147.255.255
	{ 0x94940000, 0x9494ffff, REGISTRY_RIPENCC    }, // 148.148.0.0     - 148.148.255.255
	{ 0x94950000, 0x9496ffff, REGISTRY_ARIN       }, // 148.149.0.0     - 148.150.255.255
	{ 0x94970000, 0x9497ffff, REGISTRY_RIPENCC    }, // 148.151.0.0     - 148.151.255.255
	{ 0x94980000, 0x949fffff, REGISTRY_ARIN       }, // 148.152.0.0     - 148.159.255.255
	{ 0x94a00000, 0x94a0ffff, REGISTRY_RIPENCC    }, // 148.160.0.0     - 148.160.255.255
	{ 0x94a10000, 0x94a1ffff, REGISTRY_APNIC      }, // 148.161.0.0     - 148.161.255.255
	{ 0x94a20000, 0x94a8ffff, REGISTRY_ARIN       }, // 148.162.0.0     - 148.168.255.255
	{ 0x94a90000, 0x94a9ffff, REGISTRY_RIPENCC    }, // 148.169.0.0     - 148.169.255.255
	{ 0x94aa0000, 0x94afffff, REGISTRY_ARIN       }, // 148.170.0.0     - 148.175.255.255
	{ 0x94b00000, 0x94b0ffff, REGISTRY_RIPENCC    }, // 148.176.0.0     - 148.176.255.255
	{ 0x94b10000, 0x94b4ffff, REGISTRY_ARIN       }, // 148.177.0.0     - 148.180.255.255
	{ 0x94b50000, 0x94b5ffff, REGISTRY_RIPENCC    }, // 148.181.0.0     - 148.181.255.255
	{ 0x94b60000, 0x94b6ffff, REGISTRY_APNIC      }, // 148.182.0.0     - 148.182.255.255
	{ 0x94b70000, 0x94b8ffff, REGISTRY_ARIN       }, // 148.183.0.0     - 148.184.255.255
	{ 0x94b90000, 0x94b9ffff, REGISTRY_RIPENCC    }, // 148.185.0.0     - 148.185.255.255
	{ 0x94ba0000, 0x94baffff, REGISTRY_ARIN       }, // 148.186.0.0     - 148.186.255.255
	{ 0x94bb0000, 0x94bbffff, REGISTRY_RIPENCC    }, // 148.187.0.0     - 148.187.255.255
	{ 0x94bc0000, 0x94c2ffff, REGISTRY_ARIN       }, // 148.188.0.0     - 148.194.255.255
	{ 0x94c30000, 0x94c3ffff, REGISTRY_APNIC      }, // 148.195.0.0     - 148.195.255.255
	{ 0x94c40000, 0x94c6ffff, REGISTRY_RIPENCC    }, // 148.196.0.0     - 148.198.255.255
	{ 0x94c70000, 0x94c7ffff, REGISTRY_ARIN       }, // 148.199.0.0     - 148.199.255.255
	{ 0x94c80000, 0x94c8ffff, REGISTRY_RIPENCC    }, // 148.200.0.0     - 148.200.255.255
	{ 0x94c90000, 0x94faffff, REGISTRY_LACNIC     }, // 148.201.0.0     - 148.250.255.255
	{ 0x94fb0000, 0x94fdffff, REGISTRY_RIPENCC    }, // 148.251.0.0     - 148.253.255.255
	{ 0x94fe0000, 0x94feffff, REGISTRY_ARIN       }, // 148.254.0.0     - 148.254.255.255
	{ 0x94ff0000, 0x94ffffff, REGISTRY_LACNIC     }, // 148.255.0.0     - 148.255.255.255
	{ 0x95000000, 0x9500ffff, REGISTRY_RIPENCC    }, // 149.0.0.0       - 149.0.255.255  
	{ 0x95010000, 0x9502ffff, REGISTRY_ARIN       }, // 149.1.0.0       - 149.2.255.255  
	{ 0x95030000, 0x9503ffff, REGISTRY_RIPENCC    }, // 149.3.0.0       - 149.3.255.255  
	{ 0x95040000, 0x951affff, REGISTRY_ARIN       }, // 149.4.0.0       - 149.26.255.255 
	{ 0x951b0000, 0x951bffff, REGISTRY_RIPENCC    }, // 149.27.0.0      - 149.27.255.255 
	{ 0x951c0000, 0x9530ffff, REGISTRY_ARIN       }, // 149.28.0.0      - 149.48.255.255 
	{ 0x95310000, 0x9531ffff, REGISTRY_RIPENCC    }, // 149.49.0.0      - 149.49.255.255 
	{ 0x95320000, 0x953affff, REGISTRY_ARIN       }, // 149.50.0.0      - 149.58.255.255 
	{ 0x953b0000, 0x953bffff, REGISTRY_RIPENCC    }, // 149.59.0.0      - 149.59.255.255 
	{ 0x953c0000, 0x953dffff, REGISTRY_ARIN       }, // 149.60.0.0      - 149.61.255.255 
	{ 0x953e0000, 0x953e1fff, REGISTRY_RIPENCC    }, // 149.62.0.0      - 149.62.31.255  
	{ 0x953e3000, 0x953effff, REGISTRY_RIPENCC    }, // 149.62.48.0     - 149.62.255.255 
	{ 0x953f0000, 0x957dffff, REGISTRY_ARIN       }, // 149.63.0.0      - 149.125.255.255
	{ 0x957e0000, 0x957effff, REGISTRY_RIPENCC    }, // 149.126.0.0     - 149.126.255.255
	{ 0x957f0000, 0x9580ffff, REGISTRY_ARIN       }, // 149.127.0.0     - 149.128.255.255
	{ 0x95810000, 0x9581ffff, REGISTRY_APNIC      }, // 149.129.0.0     - 149.129.255.255
	{ 0x95820000, 0x9583ffff, REGISTRY_ARIN       }, // 149.130.0.0     - 149.131.255.255
	{ 0x95840000, 0x9586ffff, REGISTRY_RIPENCC    }, // 149.132.0.0     - 149.134.255.255
	{ 0x95870000, 0x9587ffff, REGISTRY_APNIC      }, // 149.135.0.0     - 149.135.255.255
	{ 0x95880000, 0x958affff, REGISTRY_ARIN       }, // 149.136.0.0     - 149.138.255.255
	{ 0x958b0000, 0x958bffff, REGISTRY_RIPENCC    }, // 149.139.0.0     - 149.139.255.255
	{ 0x958c0000, 0x958cffff, REGISTRY_RIPENCC    }, // 149.140.0.0     - 149.140.255.255
	{ 0x958d0000, 0x958fffff, REGISTRY_ARIN       }, // 149.141.0.0     - 149.143.255.255
	{ 0x95900000, 0x9590ffff, REGISTRY_APNIC      }, // 149.144.0.0     - 149.144.255.255
	{ 0x95910000, 0x9591ffff, REGISTRY_ARIN       }, // 149.145.0.0     - 149.145.255.255
	{ 0x95920000, 0x9592ffff, REGISTRY_RIPENCC    }, // 149.146.0.0     - 149.146.255.255
	{ 0x95930000, 0x9593ffff, REGISTRY_RIPENCC    }, // 149.147.0.0     - 149.147.255.255
	{ 0x95940000, 0x9594ffff, REGISTRY_RIPENCC    }, // 149.148.0.0     - 149.148.255.255
	{ 0x95950000, 0x9598ffff, REGISTRY_ARIN       }, // 149.149.0.0     - 149.152.255.255
	{ 0x95990000, 0x9599ffff, REGISTRY_RIPENCC    }, // 149.153.0.0     - 149.153.255.255
	{ 0x959a0000, 0x959affff, REGISTRY_RIPENCC    }, // 149.154.0.0     - 149.154.255.255
	{ 0x959b0000, 0x959dffff, REGISTRY_RIPENCC    }, // 149.155.0.0     - 149.157.255.255
	{ 0x959e0000, 0x95a6ffff, REGISTRY_ARIN       }, // 149.158.0.0     - 149.166.255.255
	{ 0x95a70000, 0x95a7ffff, REGISTRY_APNIC      }, // 149.167.0.0     - 149.167.255.255
	{ 0x95a80000, 0x95a9ffff, REGISTRY_ARIN       }, // 149.168.0.0     - 149.169.255.255
	{ 0x95aa0000, 0x95aaffff, REGISTRY_RIPENCC    }, // 149.170.0.0     - 149.170.255.255
	{ 0x95ab0000, 0x95abffff, REGISTRY_APNIC      }, // 149.171.0.0     - 149.171.255.255
	{ 0x95ac0000, 0x95acffff, REGISTRY_RIPENCC    }, // 149.172.0.0     - 149.172.255.255
	{ 0x95ad0000, 0x95afffff, REGISTRY_ARIN       }, // 149.173.0.0     - 149.175.255.255
	{ 0x95b00000, 0x95b0ffff, REGISTRY_APNIC      }, // 149.176.0.0     - 149.176.255.255
	{ 0x95b10000, 0x95c5ffff, REGISTRY_RIPENCC    }, // 149.177.0.0     - 149.197.255.255
	{ 0x95c60000, 0x95c7ffff, REGISTRY_ARIN       }, // 149.198.0.0     - 149.199.255.255
	{ 0x95c80000, 0x95c8ffff, REGISTRY_RIPENCC    }, // 149.200.0.0     - 149.200.255.255
	{ 0x95c90000, 0x95d1ffff, REGISTRY_RIPENCC    }, // 149.201.0.0     - 149.209.255.255
	{ 0x95d20000, 0x95d2ffff, REGISTRY_RIPENCC    }, // 149.210.0.0     - 149.210.255.255
	{ 0x95d30000, 0x95f0ffff, REGISTRY_RIPENCC    }, // 149.211.0.0     - 149.240.255.255
	{ 0x95f10000, 0x95f1ffff, REGISTRY_RIPENCC    }, // 149.241.0.0     - 149.241.255.255
	{ 0x95f20000, 0x95f7ffff, REGISTRY_RIPENCC    }, // 149.242.0.0     - 149.247.255.255
	{ 0x95f90000, 0x95fbffff, REGISTRY_RIPENCC    }, // 149.249.0.0     - 149.251.255.255
	{ 0x95fc0000, 0x95fdffff, REGISTRY_ARIN       }, // 149.252.0.0     - 149.253.255.255
	{ 0x95fe0000, 0x95feffff, REGISTRY_RIPENCC    }, // 149.254.0.0     - 149.254.255.255
	{ 0x95ff0000, 0x95ffffff, REGISTRY_RIPENCC    }, // 149.255.0.0     - 149.255.255.255
	{ 0x96000000, 0x9665ffff, REGISTRY_APNIC      }, // 150.0.0.0       - 150.101.255.255
	{ 0x96660000, 0x9669ffff, REGISTRY_ARIN       }, // 150.102.0.0     - 150.105.255.255
	{ 0x966a0000, 0x966affff, REGISTRY_RIPENCC    }, // 150.106.0.0     - 150.106.255.255
	{ 0x966b0000, 0x966bffff, REGISTRY_APNIC      }, // 150.107.0.0     - 150.107.255.255
	{ 0x966c0000, 0x9672ffff, REGISTRY_ARIN       }, // 150.108.0.0     - 150.114.255.255
	{ 0x96730000, 0x9675ffff, REGISTRY_APNIC      }, // 150.115.0.0     - 150.117.255.255
	{ 0x96760000, 0x9678ffff, REGISTRY_ARIN       }, // 150.118.0.0     - 150.120.255.255
	{ 0x96790000, 0x967affff, REGISTRY_APNIC      }, // 150.121.0.0     - 150.122.255.255
	{ 0x967b0000, 0x967fffff, REGISTRY_ARIN       }, // 150.123.0.0     - 150.127.255.255
	{ 0x96800000, 0x9680ffff, REGISTRY_RIPENCC    }, // 150.128.0.0     - 150.128.255.255
	{ 0x96810000, 0x9681ffff, REGISTRY_APNIC      }, // 150.129.0.0     - 150.129.255.255
	{ 0x96820000, 0x9683ffff, REGISTRY_ARIN       }, // 150.130.0.0     - 150.131.255.255
	{ 0x96840000, 0x9684ffff, REGISTRY_RIPENCC    }, // 150.132.0.0     - 150.132.255.255
	{ 0x96850000, 0x9689ffff, REGISTRY_ARIN       }, // 150.133.0.0     - 150.137.255.255
	{ 0x968a0000, 0x968bffff, REGISTRY_APNIC      }, // 150.138.0.0     - 150.139.255.255
	{ 0x968c0000, 0x968cffff, REGISTRY_RIPENCC    }, // 150.140.0.0     - 150.140.255.255
	{ 0x968d0000, 0x9690ffff, REGISTRY_ARIN       }, // 150.141.0.0     - 150.144.255.255
	{ 0x96910000, 0x9692ffff, REGISTRY_RIPENCC    }, // 150.145.0.0     - 150.146.255.255
	{ 0x96930000, 0x9695ffff, REGISTRY_ARIN       }, // 150.147.0.0     - 150.149.255.255
	{ 0x96960000, 0x9697ffff, REGISTRY_APNIC      }, // 150.150.0.0     - 150.151.255.255
	{ 0x96980000, 0x969dffff, REGISTRY_ARIN       }, // 150.152.0.0     - 150.157.255.255
	{ 0x969e0000, 0x969effff, REGISTRY_RIPENCC    }, // 150.158.0.0     - 150.158.255.255
	{ 0x969f0000, 0x96a0ffff, REGISTRY_ARIN       }, // 150.159.0.0     - 150.160.255.255
	{ 0x96a10000, 0x96a5ffff, REGISTRY_LACNIC     }, // 150.161.0.0     - 150.165.255.255
	{ 0x96a60000, 0x96acffff, REGISTRY_ARIN       }, // 150.166.0.0     - 150.172.255.255
	{ 0x96ad0000, 0x96adffff, REGISTRY_APNIC      }, // 150.173.0.0     - 150.173.255.255
	{ 0x96ae0000, 0x96aeffff, REGISTRY_ARIN       }, // 150.174.0.0     - 150.174.255.255
	{ 0x96af0000, 0x96afffff, REGISTRY_RIPENCC    }, // 150.175.0.0     - 150.175.255.255
	{ 0x96b00000, 0x96b1ffff, REGISTRY_ARIN       }, // 150.176.0.0     - 150.177.255.255
	{ 0x96b20000, 0x96b2ffff, REGISTRY_RIPENCC    }, // 150.178.0.0     - 150.178.255.255
	{ 0x96b30000, 0x96b6ffff, REGISTRY_ARIN       }, // 150.179.0.0     - 150.182.255.255
	{ 0x96b70000, 0x96b7ffff, REGISTRY_APNIC      }, // 150.183.0.0     - 150.183.255.255
	{ 0x96b80000, 0x96b8ffff, REGISTRY_ARIN       }, // 150.184.0.0     - 150.184.255.255
	{ 0x96b90000, 0x96bdffff, REGISTRY_LACNIC     }, // 150.185.0.0     - 150.189.255.255
	{ 0x96be0000, 0x96beffff, REGISTRY_ARIN       }, // 150.190.0.0     - 150.190.255.255
	{ 0x96bf0000, 0x96bfffff, REGISTRY_APNIC      }, // 150.191.0.0     - 150.191.255.255
	{ 0x96c00000, 0x96c4ffff, REGISTRY_ARIN       }, // 150.192.0.0     - 150.196.255.255
	{ 0x96c50000, 0x96c5ffff, REGISTRY_APNIC      }, // 150.197.0.0     - 150.197.255.255
	{ 0x96c60000, 0x96caffff, REGISTRY_ARIN       }, // 150.198.0.0     - 150.202.255.255
	{ 0x96cb0000, 0x96cbffff, REGISTRY_APNIC      }, // 150.203.0.0     - 150.203.255.255
	{ 0x96cc0000, 0x96cdffff, REGISTRY_RIPENCC    }, // 150.204.0.0     - 150.205.255.255
	{ 0x96ce0000, 0x96cfffff, REGISTRY_APNIC      }, // 150.206.0.0     - 150.207.255.255
	{ 0x96d00000, 0x96d4ffff, REGISTRY_ARIN       }, // 150.208.0.0     - 150.212.255.255
	{ 0x96d50000, 0x96d6ffff, REGISTRY_RIPENCC    }, // 150.213.0.0     - 150.214.255.255
	{ 0x96d70000, 0x96d8ffff, REGISTRY_ARIN       }, // 150.215.0.0     - 150.216.255.255
	{ 0x96d90000, 0x96d9ffff, REGISTRY_RIPENCC    }, // 150.217.0.0     - 150.217.255.255
	{ 0x96da0000, 0x96deffff, REGISTRY_ARIN       }, // 150.218.0.0     - 150.222.255.255
	{ 0x96df0000, 0x96dfffff, REGISTRY_APNIC      }, // 150.223.0.0     - 150.223.255.255
	{ 0x96e00000, 0x96e2ffff, REGISTRY_ARIN       }, // 150.224.0.0     - 150.226.255.255
	{ 0x96e30000, 0x96e3ffff, REGISTRY_RIPENCC    }, // 150.227.0.0     - 150.227.255.255
	{ 0x96e40000, 0x96e4ffff, REGISTRY_ARIN       }, // 150.228.0.0     - 150.228.255.255
	{ 0x96e50000, 0x96e5ffff, REGISTRY_APNIC      }, // 150.229.0.0     - 150.229.255.255
	{ 0x96e60000, 0x96ebffff, REGISTRY_ARIN       }, // 150.230.0.0     - 150.235.255.255
	{ 0x96ec0000, 0x96edffff, REGISTRY_RIPENCC    }, // 150.236.0.0     - 150.237.255.255
	{ 0x96ee0000, 0x96f0ffff, REGISTRY_ARIN       }, // 150.238.0.0     - 150.240.255.255
	{ 0x96f10000, 0x96f1ffff, REGISTRY_RIPENCC    }, // 150.241.0.0     - 150.241.255.255
	{ 0x96f20000, 0x96f2ffff, REGISTRY_APNIC      }, // 150.242.0.0     - 150.242.255.255
	{ 0x96f30000, 0x96f3ffff, REGISTRY_ARIN       }, // 150.243.0.0     - 150.243.255.255
	{ 0x96f40000, 0x96f4ffff, REGISTRY_RIPENCC    }, // 150.244.0.0     - 150.244.255.255
	{ 0x96f50000, 0x96faffff, REGISTRY_ARIN       }, // 150.245.0.0     - 150.250.255.255
	{ 0x96fb0000, 0x96fbffff, REGISTRY_RIPENCC    }, // 150.251.0.0     - 150.251.255.255
	{ 0x96fc0000, 0x96fdffff, REGISTRY_ARIN       }, // 150.252.0.0     - 150.253.255.255
	{ 0x96fe0000, 0x96feffff, REGISTRY_RIPENCC    }, // 150.254.0.0     - 150.254.255.255
	{ 0x96ff0000, 0x96ffffff, REGISTRY_APNIC      }, // 150.255.0.0     - 150.255.255.255
	{ 0x97000000, 0x9700ffff, REGISTRY_RIPENCC    }, // 151.0.0.0       - 151.0.255.255  
	{ 0x97010000, 0x9764ffff, REGISTRY_RIPENCC    }, // 151.1.0.0       - 151.100.255.255
	{ 0x97650000, 0x9772ffff, REGISTRY_ARIN       }, // 151.101.0.0     - 151.114.255.255
	{ 0x97730000, 0x9773ffff, REGISTRY_RIPENCC    }, // 151.115.0.0     - 151.115.255.255
	{ 0x97740000, 0x9777ffff, REGISTRY_ARIN       }, // 151.116.0.0     - 151.119.255.255
	{ 0x97780000, 0x9778ffff, REGISTRY_RIPENCC    }, // 151.120.0.0     - 151.120.255.255
	{ 0x97790000, 0x977effff, REGISTRY_ARIN       }, // 151.121.0.0     - 151.126.255.255
	{ 0x977f0000, 0x977fffff, REGISTRY_RIPENCC    }, // 151.127.0.0     - 151.127.255.255
	{ 0x97800000, 0x9780ffff, REGISTRY_ARIN       }, // 151.128.0.0     - 151.128.255.255
	{ 0x97810000, 0x9781ffff, REGISTRY_RIPENCC    }, // 151.129.0.0     - 151.129.255.255
	{ 0x97820000, 0x9782ffff, REGISTRY_APNIC      }, // 151.130.0.0     - 151.130.255.255
	{ 0x97830000, 0x9784ffff, REGISTRY_ARIN       }, // 151.131.0.0     - 151.132.255.255
	{ 0x97850000, 0x9785ffff, REGISTRY_RIPENCC    }, // 151.133.0.0     - 151.133.255.255
	{ 0x97860000, 0x9786ffff, REGISTRY_ARIN       }, // 151.134.0.0     - 151.134.255.255
	{ 0x97870000, 0x9787ffff, REGISTRY_RIPENCC    }, // 151.135.0.0     - 151.135.255.255
	{ 0x97880000, 0x9788ffff, REGISTRY_RIPENCC    }, // 151.136.0.0     - 151.136.255.255
	{ 0x97890000, 0x979bffff, REGISTRY_ARIN       }, // 151.137.0.0     - 151.155.255.255
	{ 0x979c0000, 0x979dffff, REGISTRY_RIPENCC    }, // 151.156.0.0     - 151.157.255.255
	{ 0x979f0000, 0x97a9ffff, REGISTRY_ARIN       }, // 151.159.0.0     - 151.169.255.255
	{ 0x97aa0000, 0x97aaffff, REGISTRY_RIPENCC    }, // 151.170.0.0     - 151.170.255.255
	{ 0x97ab0000, 0x97abffff, REGISTRY_ARIN       }, // 151.171.0.0     - 151.171.255.255
	{ 0x97ad0000, 0x97aeffff, REGISTRY_ARIN       }, // 151.173.0.0     - 151.174.255.255
	{ 0x97af0000, 0x97b1ffff, REGISTRY_RIPENCC    }, // 151.175.0.0     - 151.177.255.255
	{ 0x97b20000, 0x97b2ffff, REGISTRY_APNIC      }, // 151.178.0.0     - 151.178.255.255
	{ 0x97b30000, 0x97b3ffff, REGISTRY_ARIN       }, // 151.179.0.0     - 151.179.255.255
	{ 0x97b40000, 0x97b4ffff, REGISTRY_RIPENCC    }, // 151.180.0.0     - 151.180.255.255
	{ 0x97b50000, 0x97b5ffff, REGISTRY_ARIN       }, // 151.181.0.0     - 151.181.255.255
	{ 0x97b60000, 0x97b7ffff, REGISTRY_RIPENCC    }, // 151.182.0.0     - 151.183.255.255
	{ 0x97b80000, 0x97baffff, REGISTRY_ARIN       }, // 151.184.0.0     - 151.186.255.255
	{ 0x97bb0000, 0x97bbffff, REGISTRY_RIPENCC    }, // 151.187.0.0     - 151.187.255.255
	{ 0x97bc0000, 0x97bcffff, REGISTRY_ARIN       }, // 151.188.0.0     - 151.188.255.255
	{ 0x97bd0000, 0x97bdffff, REGISTRY_RIPENCC    }, // 151.189.0.0     - 151.189.255.255
	{ 0x97be0000, 0x97d2ffff, REGISTRY_ARIN       }, // 151.190.0.0     - 151.210.255.255
	{ 0x97d30000, 0x97d4ffff, REGISTRY_RIPENCC    }, // 151.211.0.0     - 151.212.255.255
	{ 0x97d50000, 0x97d7ffff, REGISTRY_ARIN       }, // 151.213.0.0     - 151.215.255.255
	{ 0x97d80000, 0x97d81fff, REGISTRY_RIPENCC    }, // 151.216.0.0     - 151.216.31.255 
	{ 0x97e00000, 0x97ffffff, REGISTRY_RIPENCC    }, // 151.224.0.0     - 151.255.255.255
	{ 0x98000000, 0x9800ffff, REGISTRY_LACNIC     }, // 152.0.0.0       - 152.0.255.255  
	{ 0x98010000, 0x9833ffff, REGISTRY_ARIN       }, // 152.1.0.0       - 152.51.255.255 
	{ 0x98340000, 0x9834ffff, REGISTRY_APNIC      }, // 152.52.0.0      - 152.52.255.255 
	{ 0x98350000, 0x9841ffff, REGISTRY_ARIN       }, // 152.53.0.0      - 152.65.255.255 
	{ 0x98420000, 0x9842ffff, REGISTRY_RIPENCC    }, // 152.66.0.0      - 152.66.255.255 
	{ 0x98430000, 0x9846ffff, REGISTRY_ARIN       }, // 152.67.0.0      - 152.70.255.255 
	{ 0x98470000, 0x9847ffff, REGISTRY_RIPENCC    }, // 152.71.0.0      - 152.71.255.255 
	{ 0x98480000, 0x9848ffff, REGISTRY_ARIN       }, // 152.72.0.0      - 152.72.255.255 
	{ 0x98490000, 0x9849ffff, REGISTRY_RIPENCC    }, // 152.73.0.0      - 152.73.255.255 
	{ 0x984a0000, 0x984affff, REGISTRY_LACNIC     }, // 152.74.0.0      - 152.74.255.255 
	{ 0x984b0000, 0x984bffff, REGISTRY_ARIN       }, // 152.75.0.0      - 152.75.255.255 
	{ 0x984c0000, 0x984cffff, REGISTRY_APNIC      }, // 152.76.0.0      - 152.76.255.255 
	{ 0x984d0000, 0x984effff, REGISTRY_RIPENCC    }, // 152.77.0.0      - 152.78.255.255 
	{ 0x984f0000, 0x9850ffff, REGISTRY_ARIN       }, // 152.79.0.0      - 152.80.255.255 
	{ 0x98510000, 0x9851ffff, REGISTRY_RIPENCC    }, // 152.81.0.0      - 152.81.255.255 
	{ 0x98520000, 0x9852ffff, REGISTRY_ARIN       }, // 152.82.0.0      - 152.82.255.255 
	{ 0x98530000, 0x9853ffff, REGISTRY_APNIC      }, // 152.83.0.0      - 152.83.255.255 
	{ 0x98540000, 0x9854ffff, REGISTRY_LACNIC     }, // 152.84.0.0      - 152.84.255.255 
	{ 0x98550000, 0x9857ffff, REGISTRY_ARIN       }, // 152.85.0.0      - 152.87.255.255 
	{ 0x98580000, 0x9858ffff, REGISTRY_RIPENCC    }, // 152.88.0.0      - 152.88.255.255 
	{ 0x985a0000, 0x985affff, REGISTRY_RIPENCC    }, // 152.90.0.0      - 152.90.255.255 
	{ 0x985b0000, 0x985bffff, REGISTRY_APNIC      }, // 152.91.0.0      - 152.91.255.255 
	{ 0x985c0000, 0x985cffff, REGISTRY_LACNIC     }, // 152.92.0.0      - 152.92.255.255 
	{ 0x985d0000, 0x9860ffff, REGISTRY_RIPENCC    }, // 152.93.0.0      - 152.96.255.255 
	{ 0x98610000, 0x9861ffff, REGISTRY_ARIN       }, // 152.97.0.0      - 152.97.255.255 
	{ 0x98620000, 0x9863ffff, REGISTRY_APNIC      }, // 152.98.0.0      - 152.99.255.255 
	{ 0x98640000, 0x9864ffff, REGISTRY_ARIN       }, // 152.100.0.0     - 152.100.255.255
	{ 0x98650000, 0x9868ffff, REGISTRY_APNIC      }, // 152.101.0.0     - 152.104.255.255
	{ 0x98690000, 0x9869ffff, REGISTRY_RIPENCC    }, // 152.105.0.0     - 152.105.255.255
	{ 0x986a0000, 0x9870ffff, REGISTRY_AFRINIC    }, // 152.106.0.0     - 152.112.255.255
	{ 0x98710000, 0x9871ffff, REGISTRY_ARIN       }, // 152.113.0.0     - 152.113.255.255
	{ 0x98720000, 0x9873ffff, REGISTRY_RIPENCC    }, // 152.114.0.0     - 152.115.255.255
	{ 0x98740000, 0x9875ffff, REGISTRY_ARIN       }, // 152.116.0.0     - 152.117.255.255
	{ 0x98760000, 0x9876ffff, REGISTRY_APNIC      }, // 152.118.0.0     - 152.118.255.255
	{ 0x98770000, 0x9885ffff, REGISTRY_ARIN       }, // 152.119.0.0     - 152.133.255.255
	{ 0x98860000, 0x9886ffff, REGISTRY_RIPENCC    }, // 152.134.0.0     - 152.134.255.255
	{ 0x98870000, 0x988affff, REGISTRY_ARIN       }, // 152.135.0.0     - 152.138.255.255
	{ 0x988b0000, 0x988bffff, REGISTRY_LACNIC     }, // 152.139.0.0     - 152.139.255.255
	{ 0x988c0000, 0x988effff, REGISTRY_ARIN       }, // 152.140.0.0     - 152.142.255.255
	{ 0x988f0000, 0x988fffff, REGISTRY_RIPENCC    }, // 152.143.0.0     - 152.143.255.255
	{ 0x98900000, 0x9892ffff, REGISTRY_ARIN       }, // 152.144.0.0     - 152.146.255.255
	{ 0x98930000, 0x9893ffff, REGISTRY_APNIC      }, // 152.147.0.0     - 152.147.255.255
	{ 0x98940000, 0x9894ffff, REGISTRY_ARIN       }, // 152.148.0.0     - 152.148.255.255
	{ 0x98950000, 0x9895ffff, REGISTRY_APNIC      }, // 152.149.0.0     - 152.149.255.255
	{ 0x98960000, 0x9896ffff, REGISTRY_RIPENCC    }, // 152.150.0.0     - 152.150.255.255
	{ 0x98970000, 0x9897ffff, REGISTRY_ARIN       }, // 152.151.0.0     - 152.151.255.255
	{ 0x98980000, 0x9898ffff, REGISTRY_RIPENCC    }, // 152.152.0.0     - 152.152.255.255
	{ 0x989a0000, 0x989bffff, REGISTRY_ARIN       }, // 152.154.0.0     - 152.155.255.255
	{ 0x989c0000, 0x989cffff, REGISTRY_LACNIC     }, // 152.156.0.0     - 152.156.255.255
	{ 0x989d0000, 0x98a5ffff, REGISTRY_ARIN       }, // 152.157.0.0     - 152.165.255.255
	{ 0x98a60000, 0x98afffff, REGISTRY_LACNIC     }, // 152.166.0.0     - 152.175.255.255
	{ 0x98b00000, 0x98c7ffff, REGISTRY_ARIN       }, // 152.176.0.0     - 152.199.255.255
	{ 0x98c80000, 0x98cfffff, REGISTRY_LACNIC     }, // 152.200.0.0     - 152.207.255.255
	{ 0x98d00000, 0x98e1ffff, REGISTRY_ARIN       }, // 152.208.0.0     - 152.225.255.255
	{ 0x98e20000, 0x98e2ffff, REGISTRY_APNIC      }, // 152.226.0.0     - 152.226.255.255
	{ 0x98e30000, 0x98e5ffff, REGISTRY_ARIN       }, // 152.227.0.0     - 152.229.255.255
	{ 0x98e60000, 0x98ffffff, REGISTRY_LACNIC     }, // 152.230.0.0     - 152.255.255.255
	{ 0x99000000, 0x9900ffff, REGISTRY_APNIC      }, // 153.0.0.0       - 153.0.255.255  
	{ 0x99010000, 0x9901ffff, REGISTRY_RIPENCC    }, // 153.1.0.0       - 153.1.255.255  
	{ 0x99020000, 0x9902ffff, REGISTRY_ARIN       }, // 153.2.0.0       - 153.2.255.255  
	{ 0x99030000, 0x9903ffff, REGISTRY_APNIC      }, // 153.3.0.0       - 153.3.255.255  
	{ 0x99040000, 0x9904ffff, REGISTRY_ARIN       }, // 153.4.0.0       - 153.4.255.255  
	{ 0x99050000, 0x9905ffff, REGISTRY_RIPENCC    }, // 153.5.0.0       - 153.5.255.255  
	{ 0x99060000, 0x990effff, REGISTRY_ARIN       }, // 153.6.0.0       - 153.14.255.255 
	{ 0x990f0000, 0x990fffff, REGISTRY_RIPENCC    }, // 153.15.0.0      - 153.15.255.255 
	{ 0x99100000, 0x9910ffff, REGISTRY_ARIN       }, // 153.16.0.0      - 153.16.255.255 
	{ 0x99110000, 0x9911ffff, REGISTRY_RIPENCC    }, // 153.17.0.0      - 153.17.255.255 
	{ 0x99120000, 0x9912ffff, REGISTRY_ARIN       }, // 153.18.0.0      - 153.18.255.255 
	{ 0x99130000, 0x9913ffff, REGISTRY_RIPENCC    }, // 153.19.0.0      - 153.19.255.255 
	{ 0x99140000, 0x9914ffff, REGISTRY_APNIC      }, // 153.20.0.0      - 153.20.255.255 
	{ 0x99150000, 0x9921ffff, REGISTRY_ARIN       }, // 153.21.0.0      - 153.33.255.255 
	{ 0x99220000, 0x9925ffff, REGISTRY_APNIC      }, // 153.34.0.0      - 153.37.255.255 
	{ 0x99260000, 0x9957ffff, REGISTRY_ARIN       }, // 153.38.0.0      - 153.87.255.255 
	{ 0x99580000, 0x9958ffff, REGISTRY_RIPENCC    }, // 153.88.0.0      - 153.88.255.255 
	{ 0x99590000, 0x995bffff, REGISTRY_ARIN       }, // 153.89.0.0      - 153.91.255.255 
	{ 0x995c0000, 0x9962ffff, REGISTRY_RIPENCC    }, // 153.92.0.0      - 153.98.255.255 
	{ 0x99630000, 0x9963ffff, REGISTRY_APNIC      }, // 153.99.0.0      - 153.99.255.255 
	{ 0x99640000, 0x9964ffff, REGISTRY_RIPENCC    }, // 153.100.0.0     - 153.100.255.255
	{ 0x99650000, 0x9965ffff, REGISTRY_APNIC      }, // 153.101.0.0     - 153.101.255.255
	{ 0x99660000, 0x996affff, REGISTRY_ARIN       }, // 153.102.0.0     - 153.106.255.255
	{ 0x996b0000, 0x996bffff, REGISTRY_APNIC      }, // 153.107.0.0     - 153.107.255.255
	{ 0x996c0000, 0x996effff, REGISTRY_RIPENCC    }, // 153.108.0.0     - 153.110.255.255
	{ 0x996f0000, 0x996fffff, REGISTRY_APNIC      }, // 153.111.0.0     - 153.111.255.255
	{ 0x99700000, 0x9970ffff, REGISTRY_RIPENCC    }, // 153.112.0.0     - 153.112.255.255
	{ 0x99710000, 0x9975ffff, REGISTRY_ARIN       }, // 153.113.0.0     - 153.117.255.255
	{ 0x99760000, 0x99ffffff, REGISTRY_APNIC      }, // 153.118.0.0     - 153.255.255.255
	{ 0x9a000000, 0x9a00ffff, REGISTRY_AFRINIC    }, // 154.0.0.0       - 154.0.255.255  
	{ 0x9a010000, 0x9a07ffff, REGISTRY_ARIN       }, // 154.1.0.0       - 154.7.255.255  
	{ 0x9a080000, 0x9a08ffff, REGISTRY_RIPENCC    }, // 154.8.0.0       - 154.8.255.255  
	{ 0x9a090000, 0x9a09ffff, REGISTRY_ARIN       }, // 154.9.0.0       - 154.9.255.255  
	{ 0x9a0a0000, 0x9a0affff, REGISTRY_APNIC      }, // 154.10.0.0      - 154.10.255.255 
	{ 0x9a0b0000, 0x9a0dffff, REGISTRY_ARIN       }, // 154.11.0.0      - 154.13.255.255 
	{ 0x9a0e0000, 0x9a0fffff, REGISTRY_RIPENCC    }, // 154.14.0.0      - 154.15.255.255 
	{ 0x9a100000, 0x9a10ffff, REGISTRY_AFRINIC    }, // 154.16.0.0      - 154.16.255.255 
	{ 0x9a110000, 0x9a1fffff, REGISTRY_ARIN       }, // 154.17.0.0      - 154.31.255.255 
	{ 0x9a200000, 0x9a20ffff, REGISTRY_RIPENCC    }, // 154.32.0.0      - 154.32.255.255 
	{ 0x9a210000, 0x9a22ffff, REGISTRY_APNIC      }, // 154.33.0.0      - 154.34.255.255 
	{ 0x9a230000, 0x9a40ffff, REGISTRY_ARIN       }, // 154.35.0.0      - 154.64.255.255 
	{ 0x9a410000, 0x9a4157ff, REGISTRY_AFRINIC    }, // 154.65.0.0      - 154.65.87.255  
	{ 0x9a416000, 0x9a426fff, REGISTRY_AFRINIC    }, // 154.65.96.0     - 154.66.111.255 
	{ 0x9a427400, 0x9a447fff, REGISTRY_AFRINIC    }, // 154.66.116.0    - 154.68.127.255 
	{ 0x9a44c000, 0x9a464fff, REGISTRY_AFRINIC    }, // 154.68.192.0    - 154.70.79.255  
	{ 0x9a466000, 0x9a4903ff, REGISTRY_AFRINIC    }, // 154.70.96.0     - 154.73.3.255   
	{ 0x9a490800, 0x9a4967ff, REGISTRY_AFRINIC    }, // 154.73.8.0      - 154.73.103.255 
	{ 0x9a496c00, 0x9a498fff, REGISTRY_AFRINIC    }, // 154.73.108.0    - 154.73.143.255 
	{ 0x9a49b800, 0x9a49d7ff, REGISTRY_AFRINIC    }, // 154.73.184.0    - 154.73.215.255 
	{ 0x9a49e000, 0x9a49e7ff, REGISTRY_AFRINIC    }, // 154.73.224.0    - 154.73.231.255 
	{ 0x9a49f000, 0x9a49f7ff, REGISTRY_AFRINIC    }, // 154.73.240.0    - 154.73.247.255 
	{ 0x9a4c0000, 0x9a70ffff, REGISTRY_AFRINIC    }, // 154.76.0.0      - 154.112.255.255
	{ 0x9a740000, 0x9a747fff, REGISTRY_AFRINIC    }, // 154.116.0.0     - 154.116.127.255
	{ 0x9a77a000, 0x9a77ffff, REGISTRY_AFRINIC    }, // 154.119.160.0   - 154.119.255.255
	{ 0x9a784000, 0x9a7bffff, REGISTRY_AFRINIC    }, // 154.120.64.0    - 154.123.255.255
	{ 0x9a7e0000, 0x9a7fffff, REGISTRY_AFRINIC    }, // 154.126.0.0     - 154.127.255.255
	{ 0x9b010000, 0x9b03ffff, REGISTRY_ARIN       }, // 155.1.0.0       - 155.3.255.255  
	{ 0x9b040000, 0x9b04ffff, REGISTRY_RIPENCC    }, // 155.4.0.0       - 155.4.255.255  
	{ 0x9b050000, 0x9b0affff, REGISTRY_ARIN       }, // 155.5.0.0       - 155.10.255.255 
	{ 0x9b0d0000, 0x9b1fffff, REGISTRY_ARIN       }, // 155.13.0.0      - 155.31.255.255 
	{ 0x9b200000, 0x9b20ffff, REGISTRY_APNIC      }, // 155.32.0.0      - 155.32.255.255 
	{ 0x9b210000, 0x9b2cffff, REGISTRY_ARIN       }, // 155.33.0.0      - 155.44.255.255 
	{ 0x9b2d0000, 0x9b2dffff, REGISTRY_RIPENCC    }, // 155.45.0.0      - 155.45.255.255 
	{ 0x9b2e0000, 0x9b35ffff, REGISTRY_ARIN       }, // 155.46.0.0      - 155.53.255.255 
	{ 0x9b360000, 0x9b38ffff, REGISTRY_RIPENCC    }, // 155.54.0.0      - 155.56.255.255 
	{ 0x9b390000, 0x9b3affff, REGISTRY_ARIN       }, // 155.57.0.0      - 155.58.255.255 
	{ 0x9b3b0000, 0x9b3cffff, REGISTRY_APNIC      }, // 155.59.0.0      - 155.60.255.255 
	{ 0x9b3d0000, 0x9b41ffff, REGISTRY_ARIN       }, // 155.61.0.0      - 155.65.255.255 
	{ 0x9b420000, 0x9b42ffff, REGISTRY_RIPENCC    }, // 155.66.0.0      - 155.66.255.255 
	{ 0x9b430000, 0x9b44ffff, REGISTRY_ARIN       }, // 155.67.0.0      - 155.68.255.255 
	{ 0x9b450000, 0x9b45ffff, REGISTRY_APNIC      }, // 155.69.0.0      - 155.69.255.255 
	{ 0x9b460000, 0x9b46ffff, REGISTRY_ARIN       }, // 155.70.0.0      - 155.70.255.255 
	{ 0x9b470000, 0x9b47ffff, REGISTRY_APNIC      }, // 155.71.0.0      - 155.71.255.255 
	{ 0x9b480000, 0x9b48ffff, REGISTRY_ARIN       }, // 155.72.0.0      - 155.72.255.255 
	{ 0x9b490000, 0x9b49ffff, REGISTRY_RIPENCC    }, // 155.73.0.0      - 155.73.255.255 
	{ 0x9b4a0000, 0x9b58ffff, REGISTRY_ARIN       }, // 155.74.0.0      - 155.88.255.255 
	{ 0x9b5a0000, 0x9b5cffff, REGISTRY_ARIN       }, // 155.90.0.0      - 155.92.255.255 
	{ 0x9b5e0000, 0x9b68ffff, REGISTRY_ARIN       }, // 155.94.0.0      - 155.104.255.255
	{ 0x9b690000, 0x9b69ffff, REGISTRY_RIPENCC    }, // 155.105.0.0     - 155.105.255.255
	{ 0x9b6a0000, 0x9b82ffff, REGISTRY_ARIN       }, // 155.106.0.0     - 155.130.255.255
	{ 0x9b830000, 0x9b85ffff, REGISTRY_RIPENCC    }, // 155.131.0.0     - 155.133.255.255
	{ 0x9b860000, 0x9b87ffff, REGISTRY_ARIN       }, // 155.134.0.0     - 155.135.255.255
	{ 0x9b880000, 0x9b89ffff, REGISTRY_RIPENCC    }, // 155.136.0.0     - 155.137.255.255
	{ 0x9b8a0000, 0x9b8bffff, REGISTRY_ARIN       }, // 155.138.0.0     - 155.139.255.255
	{ 0x9b8c0000, 0x9b8cffff, REGISTRY_RIPENCC    }, // 155.140.0.0     - 155.140.255.255
	{ 0x9b8d0000, 0x9b8effff, REGISTRY_ARIN       }, // 155.141.0.0     - 155.142.255.255
	{ 0x9b8f0000, 0x9b90ffff, REGISTRY_APNIC      }, // 155.143.0.0     - 155.144.255.255
	{ 0x9b910000, 0x9b91ffff, REGISTRY_RIPENCC    }, // 155.145.0.0     - 155.145.255.255
	{ 0x9b920000, 0x9b9dffff, REGISTRY_ARIN       }, // 155.146.0.0     - 155.157.255.255
	{ 0x9b9e0000, 0x9b9effff, REGISTRY_RIPENCC    }, // 155.158.0.0     - 155.158.255.255
	{ 0x9b9f0000, 0x9b9fffff, REGISTRY_AFRINIC    }, // 155.159.0.0     - 155.159.255.255
	{ 0x9ba00000, 0x9ba0ffff, REGISTRY_APNIC      }, // 155.160.0.0     - 155.160.255.255
	{ 0x9ba10000, 0x9bb8ffff, REGISTRY_ARIN       }, // 155.161.0.0     - 155.184.255.255
	{ 0x9bb90000, 0x9bb9ffff, REGISTRY_RIPENCC    }, // 155.185.0.0     - 155.185.255.255
	{ 0x9bba0000, 0x9bbaffff, REGISTRY_ARIN       }, // 155.186.0.0     - 155.186.255.255
	{ 0x9bbb0000, 0x9bbbffff, REGISTRY_APNIC      }, // 155.187.0.0     - 155.187.255.255
	{ 0x9bbc0000, 0x9bbfffff, REGISTRY_ARIN       }, // 155.188.0.0     - 155.191.255.255
	{ 0x9bc00000, 0x9bc0ffff, REGISTRY_RIPENCC    }, // 155.192.0.0     - 155.192.255.255
	{ 0x9bc10000, 0x9bc3ffff, REGISTRY_ARIN       }, // 155.193.0.0     - 155.195.255.255
	{ 0x9bc50000, 0x9bc5ffff, REGISTRY_ARIN       }, // 155.197.0.0     - 155.197.255.255
	{ 0x9bc60000, 0x9bc6ffff, REGISTRY_RIPENCC    }, // 155.198.0.0     - 155.198.255.255
	{ 0x9bc70000, 0x9bc9ffff, REGISTRY_ARIN       }, // 155.199.0.0     - 155.201.255.255
	{ 0x9bca0000, 0x9bcaffff, REGISTRY_RIPENCC    }, // 155.202.0.0     - 155.202.255.255
	{ 0x9bcb0000, 0x9bcbffff, REGISTRY_ARIN       }, // 155.203.0.0     - 155.203.255.255
	{ 0x9bcc0000, 0x9bccffff, REGISTRY_RIPENCC    }, // 155.204.0.0     - 155.204.255.255
	{ 0x9bcd0000, 0x9bcdffff, REGISTRY_APNIC      }, // 155.205.0.0     - 155.205.255.255
	{ 0x9bce0000, 0x9bceffff, REGISTRY_ARIN       }, // 155.206.0.0     - 155.206.255.255
	{ 0x9bcf0000, 0x9bcfffff, REGISTRY_RIPENCC    }, // 155.207.0.0     - 155.207.255.255
	{ 0x9bd00000, 0x9bd0ffff, REGISTRY_ARIN       }, // 155.208.0.0     - 155.208.255.255
	{ 0x9bd10000, 0x9bd2ffff, REGISTRY_RIPENCC    }, // 155.209.0.0     - 155.210.255.255
	{ 0x9bd30000, 0x9bd3ffff, REGISTRY_LACNIC     }, // 155.211.0.0     - 155.211.255.255
	{ 0x9bd40000, 0x9bdeffff, REGISTRY_ARIN       }, // 155.212.0.0     - 155.222.255.255
	{ 0x9bdf0000, 0x9bdfffff, REGISTRY_RIPENCC    }, // 155.223.0.0     - 155.223.255.255
	{ 0x9be00000, 0x9be2ffff, REGISTRY_ARIN       }, // 155.224.0.0     - 155.226.255.255
	{ 0x9be30000, 0x9be4ffff, REGISTRY_RIPENCC    }, // 155.227.0.0     - 155.228.255.255
	{ 0x9be50000, 0x9be5ffff, REGISTRY_ARIN       }, // 155.229.0.0     - 155.229.255.255
	{ 0x9be60000, 0x9be6ffff, REGISTRY_APNIC      }, // 155.230.0.0     - 155.230.255.255
	{ 0x9be70000, 0x9be7ffff, REGISTRY_RIPENCC    }, // 155.231.0.0     - 155.231.255.255
	{ 0x9be80000, 0x9bf0ffff, REGISTRY_AFRINIC    }, // 155.232.0.0     - 155.240.255.255
	{ 0x9bf10000, 0x9bf4ffff, REGISTRY_ARIN       }, // 155.241.0.0     - 155.244.255.255
	{ 0x9bf50000, 0x9bf5ffff, REGISTRY_RIPENCC    }, // 155.245.0.0     - 155.245.255.255
	{ 0x9bf60000, 0x9bf8ffff, REGISTRY_ARIN       }, // 155.246.0.0     - 155.248.255.255
	{ 0x9bf90000, 0x9bfaffff, REGISTRY_RIPENCC    }, // 155.249.0.0     - 155.250.255.255
	{ 0x9bfc0000, 0x9bfcffff, REGISTRY_ARIN       }, // 155.252.0.0     - 155.252.255.255
	{ 0x9bfd0000, 0x9bfdffff, REGISTRY_RIPENCC    }, // 155.253.0.0     - 155.253.255.255
	{ 0x9bfe0000, 0x9bfeffff, REGISTRY_ARIN       }, // 155.254.0.0     - 155.254.255.255
	{ 0x9c010000, 0x9c07ffff, REGISTRY_ARIN       }, // 156.1.0.0       - 156.7.255.255  
	{ 0x9c080000, 0x9c08ffff, REGISTRY_AFRINIC    }, // 156.8.0.0       - 156.8.255.255  
	{ 0x9c090000, 0x9c09ffff, REGISTRY_ARIN       }, // 156.9.0.0       - 156.9.255.255  
	{ 0x9c0a0000, 0x9c0affff, REGISTRY_RIPENCC    }, // 156.10.0.0      - 156.10.255.255 
	{ 0x9c0b0000, 0x9c0cffff, REGISTRY_ARIN       }, // 156.11.0.0      - 156.12.255.255 
	{ 0x9c0d0000, 0x9c0dffff, REGISTRY_APNIC      }, // 156.13.0.0      - 156.13.255.255 
	{ 0x9c0e0000, 0x9c0effff, REGISTRY_RIPENCC    }, // 156.14.0.0      - 156.14.255.255 
	{ 0x9c0f0000, 0x9c0fffff, REGISTRY_ARIN       }, // 156.15.0.0      - 156.15.255.255 
	{ 0x9c110000, 0x9c12ffff, REGISTRY_RIPENCC    }, // 156.17.0.0      - 156.18.255.255 
	{ 0x9c130000, 0x9c15ffff, REGISTRY_ARIN       }, // 156.19.0.0      - 156.21.255.255 
	{ 0x9c160000, 0x9c16ffff, REGISTRY_APNIC      }, // 156.22.0.0      - 156.22.255.255 
	{ 0x9c170000, 0x9c18ffff, REGISTRY_ARIN       }, // 156.23.0.0      - 156.24.255.255 
	{ 0x9c190000, 0x9c19ffff, REGISTRY_RIPENCC    }, // 156.25.0.0      - 156.25.255.255 
	{ 0x9c1a0000, 0x9c1bffff, REGISTRY_ARIN       }, // 156.26.0.0      - 156.27.255.255 
	{ 0x9c1c0000, 0x9c1cffff, REGISTRY_RIPENCC    }, // 156.28.0.0      - 156.28.255.255 
	{ 0x9c1d0000, 0x9c1effff, REGISTRY_ARIN       }, // 156.29.0.0      - 156.30.255.255 
	{ 0x9c1f0000, 0x9c1fffff, REGISTRY_APNIC      }, // 156.31.0.0      - 156.31.255.255 
	{ 0x9c200000, 0x9c22ffff, REGISTRY_ARIN       }, // 156.32.0.0      - 156.34.255.255 
	{ 0x9c230000, 0x9c23ffff, REGISTRY_RIPENCC    }, // 156.35.0.0      - 156.35.255.255 
	{ 0x9c240000, 0x9c25ffff, REGISTRY_ARIN       }, // 156.36.0.0      - 156.37.255.255 
	{ 0x9c270000, 0x9c2affff, REGISTRY_ARIN       }, // 156.39.0.0      - 156.42.255.255 
	{ 0x9c2b0000, 0x9c2bffff, REGISTRY_RIPENCC    }, // 156.43.0.0      - 156.43.255.255 
	{ 0x9c2c0000, 0x9c2fffff, REGISTRY_ARIN       }, // 156.44.0.0      - 156.47.255.255 
	{ 0x9c300000, 0x9c31ffff, REGISTRY_RIPENCC    }, // 156.48.0.0      - 156.49.255.255 
	{ 0x9c320000, 0x9c32ffff, REGISTRY_APNIC      }, // 156.50.0.0      - 156.50.255.255 
	{ 0x9c330000, 0x9c34ffff, REGISTRY_RIPENCC    }, // 156.51.0.0      - 156.52.255.255 
	{ 0x9c350000, 0x9c35ffff, REGISTRY_ARIN       }, // 156.53.0.0      - 156.53.255.255 
	{ 0x9c360000, 0x9c36ffff, REGISTRY_RIPENCC    }, // 156.54.0.0      - 156.54.255.255 
	{ 0x9c370000, 0x9c39ffff, REGISTRY_ARIN       }, // 156.55.0.0      - 156.57.255.255 
	{ 0x9c3a0000, 0x9c3affff, REGISTRY_RIPENCC    }, // 156.58.0.0      - 156.58.255.255 
	{ 0x9c3b0000, 0x9c3bffff, REGISTRY_APNIC      }, // 156.59.0.0      - 156.59.255.255 
	{ 0x9c3c0000, 0x9c3cffff, REGISTRY_ARIN       }, // 156.60.0.0      - 156.60.255.255 
	{ 0x9c3d0000, 0x9c3dffff, REGISTRY_RIPENCC    }, // 156.61.0.0      - 156.61.255.255 
	{ 0x9c3e0000, 0x9c3effff, REGISTRY_APNIC      }, // 156.62.0.0      - 156.62.255.255 
	{ 0x9c3f0000, 0x9c42ffff, REGISTRY_ARIN       }, // 156.63.0.0      - 156.66.255.255 
	{ 0x9c430000, 0x9c43ffff, REGISTRY_RIPENCC    }, // 156.67.0.0      - 156.67.255.255 
	{ 0x9c440000, 0x9c44ffff, REGISTRY_ARIN       }, // 156.68.0.0      - 156.68.255.255 
	{ 0x9c450000, 0x9c45ffff, REGISTRY_APNIC      }, // 156.69.0.0      - 156.69.255.255 
	{ 0x9c460000, 0x9c52ffff, REGISTRY_ARIN       }, // 156.70.0.0      - 156.82.255.255 
	{ 0x9c530000, 0x9c53ffff, REGISTRY_RIPENCC    }, // 156.83.0.0      - 156.83.255.255 
	{ 0x9c540000, 0x9c60ffff, REGISTRY_ARIN       }, // 156.84.0.0      - 156.96.255.255 
	{ 0x9c610000, 0x9c61ffff, REGISTRY_LACNIC     }, // 156.97.0.0      - 156.97.255.255 
	{ 0x9c620000, 0x9c69ffff, REGISTRY_ARIN       }, // 156.98.0.0      - 156.105.255.255
	{ 0x9c6a0000, 0x9c6affff, REGISTRY_RIPENCC    }, // 156.106.0.0     - 156.106.255.255
	{ 0x9c6b0000, 0x9c71ffff, REGISTRY_ARIN       }, // 156.107.0.0     - 156.113.255.255
	{ 0x9c720000, 0x9c74ffff, REGISTRY_RIPENCC    }, // 156.114.0.0     - 156.116.255.255
	{ 0x9c750000, 0x9c75ffff, REGISTRY_ARIN       }, // 156.117.0.0     - 156.117.255.255
	{ 0x9c760000, 0x9c76ffff, REGISTRY_RIPENCC    }, // 156.118.0.0     - 156.118.255.255
	{ 0x9c770000, 0x9c84ffff, REGISTRY_ARIN       }, // 156.119.0.0     - 156.132.255.255
	{ 0x9c850000, 0x9c85ffff, REGISTRY_RIPENCC    }, // 156.133.0.0     - 156.133.255.255
	{ 0x9c860000, 0x9c86ffff, REGISTRY_ARIN       }, // 156.134.0.0     - 156.134.255.255
	{ 0x9c870000, 0x9c87ffff, REGISTRY_RIPENCC    }, // 156.135.0.0     - 156.135.255.255
	{ 0x9c880000, 0x9c92ffff, REGISTRY_ARIN       }, // 156.136.0.0     - 156.146.255.255
	{ 0x9c930000, 0x9c93ffff, REGISTRY_APNIC      }, // 156.147.0.0     - 156.147.255.255
	{ 0x9c940000, 0x9c94ffff, REGISTRY_RIPENCC    }, // 156.148.0.0     - 156.148.255.255
	{ 0x9c950000, 0x9c95ffff, REGISTRY_APNIC      }, // 156.149.0.0     - 156.149.255.255
	{ 0x9c960000, 0x9c96ffff, REGISTRY_RIPENCC    }, // 156.150.0.0     - 156.150.255.255
	{ 0x9c970000, 0x9c9affff, REGISTRY_ARIN       }, // 156.151.0.0     - 156.154.255.255
	{ 0x9d000000, 0x9d04ffff, REGISTRY_APNIC      }, // 157.0.0.0       - 157.4.255.255  
	{ 0x9d060000, 0x9d0effff, REGISTRY_APNIC      }, // 157.6.0.0       - 157.14.255.255 
	{ 0x9d100000, 0x9d14ffff, REGISTRY_APNIC      }, // 157.16.0.0      - 157.20.255.255 
	{ 0x9d150000, 0x9d16ffff, REGISTRY_ARIN       }, // 157.21.0.0      - 157.22.255.255 
	{ 0x9d170000, 0x9d1dffff, REGISTRY_RIPENCC    }, // 157.23.0.0      - 157.29.255.255 
	{ 0x9d1e0000, 0x9d3cffff, REGISTRY_ARIN       }, // 157.30.0.0      - 157.60.255.255 
	{ 0x9d3d0000, 0x9d3dffff, REGISTRY_APNIC      }, // 157.61.0.0      - 157.61.255.255 
	{ 0x9d3e0000, 0x9d3effff, REGISTRY_ARIN       }, // 157.62.0.0      - 157.62.255.255 
	{ 0x9d3f0000, 0x9d50ffff, REGISTRY_APNIC      }, // 157.63.0.0      - 157.80.255.255 
	{ 0x9d520000, 0x9d52ffff, REGISTRY_APNIC      }, // 157.82.0.0      - 157.82.255.255 
	{ 0x9d530000, 0x9d54ffff, REGISTRY_RIPENCC    }, // 157.83.0.0      - 157.84.255.255 
	{ 0x9d550000, 0x9d55ffff, REGISTRY_APNIC      }, // 157.85.0.0      - 157.85.255.255 
	{ 0x9d560000, 0x9d56ffff, REGISTRY_LACNIC     }, // 157.86.0.0      - 157.86.255.255 
	{ 0x9d570000, 0x9d57ffff, REGISTRY_ARIN       }, // 157.87.0.0      - 157.87.255.255 
	{ 0x9d580000, 0x9d58ffff, REGISTRY_RIPENCC    }, // 157.88.0.0      - 157.88.255.255 
	{ 0x9d590000, 0x9d5bffff, REGISTRY_ARIN       }, // 157.89.0.0      - 157.91.255.255 
	{ 0x9d5c0000, 0x9d5cffff, REGISTRY_LACNIC     }, // 157.92.0.0      - 157.92.255.255 
	{ 0x9d5d0000, 0x9d5dffff, REGISTRY_ARIN       }, // 157.93.0.0      - 157.93.255.255 
	{ 0x9d5e0000, 0x9d5effff, REGISTRY_RIPENCC    }, // 157.94.0.0      - 157.94.255.255 
	{ 0x9d5f0000, 0x9d5fffff, REGISTRY_ARIN       }, // 157.95.0.0      - 157.95.255.255 
	{ 0x9d600000, 0x9d60ffff, REGISTRY_RIPENCC    }, // 157.96.0.0      - 157.96.255.255 
	{ 0x9d610000, 0x9d62ffff, REGISTRY_ARIN       }, // 157.97.0.0      - 157.98.255.255 
	{ 0x9d630000, 0x9d63ffff, REGISTRY_RIPENCC    }, // 157.99.0.0      - 157.99.255.255 
	{ 0x9d640000, 0x9d64ffff, REGISTRY_LACNIC     }, // 157.100.0.0     - 157.100.255.255
	{ 0x9d650000, 0x9d76ffff, REGISTRY_APNIC      }, // 157.101.0.0     - 157.118.255.255
	{ 0x9d780000, 0x9d78ffff, REGISTRY_APNIC      }, // 157.120.0.0     - 157.120.255.255
	{ 0x9d790000, 0x9d79ffff, REGISTRY_ARIN       }, // 157.121.0.0     - 157.121.255.255
	{ 0x9d7a0000, 0x9d7affff, REGISTRY_APNIC      }, // 157.122.0.0     - 157.122.255.255
	{ 0x9d7b0000, 0x9d7bffff, REGISTRY_ARIN       }, // 157.123.0.0     - 157.123.255.255
	{ 0x9d7c0000, 0x9d7dffff, REGISTRY_RIPENCC    }, // 157.124.0.0     - 157.125.255.255
	{ 0x9d7e0000, 0x9d7fffff, REGISTRY_ARIN       }, // 157.126.0.0     - 157.127.255.255
	{ 0x9d800000, 0x9d80ffff, REGISTRY_APNIC      }, // 157.128.0.0     - 157.128.255.255
	{ 0x9d810000, 0x9d81ffff, REGISTRY_RIPENCC    }, // 157.129.0.0     - 157.129.255.255
	{ 0x9d820000, 0x9d87ffff, REGISTRY_ARIN       }, // 157.130.0.0     - 157.135.255.255
	{ 0x9d880000, 0x9d88ffff, REGISTRY_RIPENCC    }, // 157.136.0.0     - 157.136.255.255
	{ 0x9d890000, 0x9d89ffff, REGISTRY_ARIN       }, // 157.137.0.0     - 157.137.255.255
	{ 0x9d8a0000, 0x9d8affff, REGISTRY_RIPENCC    }, // 157.138.0.0     - 157.138.255.255
	{ 0x9d8b0000, 0x9d8bffff, REGISTRY_ARIN       }, // 157.139.0.0     - 157.139.255.255
	{ 0x9d8c0000, 0x9d8cffff, REGISTRY_RIPENCC    }, // 157.140.0.0     - 157.140.255.255
	{ 0x9d8d0000, 0x9d8fffff, REGISTRY_ARIN       }, // 157.141.0.0     - 157.143.255.255
	{ 0x9d900000, 0x9d90ffff, REGISTRY_RIPENCC    }, // 157.144.0.0     - 157.144.255.255
	{ 0x9d910000, 0x9d93ffff, REGISTRY_ARIN       }, // 157.145.0.0     - 157.147.255.255
	{ 0x9d940000, 0x9d94ffff, REGISTRY_APNIC      }, // 157.148.0.0     - 157.148.255.255
	{ 0x9d950000, 0x9d9affff, REGISTRY_ARIN       }, // 157.149.0.0     - 157.154.255.255
	{ 0x9d9b0000, 0x9d9cffff, REGISTRY_APNIC      }, // 157.155.0.0     - 157.156.255.255
	{ 0x9d9d0000, 0x9d9fffff, REGISTRY_RIPENCC    }, // 157.157.0.0     - 157.159.255.255
	{ 0x9da00000, 0x9da0ffff, REGISTRY_ARIN       }, // 157.160.0.0     - 157.160.255.255
	{ 0x9da10000, 0x9da4ffff, REGISTRY_RIPENCC    }, // 157.161.0.0     - 157.164.255.255
	{ 0x9da50000, 0x9da6ffff, REGISTRY_ARIN       }, // 157.165.0.0     - 157.166.255.255
	{ 0x9da70000, 0x9da9ffff, REGISTRY_RIPENCC    }, // 157.167.0.0     - 157.169.255.255
	{ 0x9daa0000, 0x9daaffff, REGISTRY_ARIN       }, // 157.170.0.0     - 157.170.255.255
	{ 0x9dab0000, 0x9dadffff, REGISTRY_RIPENCC    }, // 157.171.0.0     - 157.173.255.255
	{ 0x9dae0000, 0x9db0ffff, REGISTRY_ARIN       }, // 157.174.0.0     - 157.176.255.255
	{ 0x9db10000, 0x9db1ffff, REGISTRY_RIPENCC    }, // 157.177.0.0     - 157.177.255.255
	{ 0x9db20000, 0x9db2ffff, REGISTRY_ARIN       }, // 157.178.0.0     - 157.178.255.255
	{ 0x9db30000, 0x9db3ffff, REGISTRY_APNIC      }, // 157.179.0.0     - 157.179.255.255
	{ 0x9db40000, 0x9db5ffff, REGISTRY_RIPENCC    }, // 157.180.0.0     - 157.181.255.255
	{ 0x9db60000, 0x9db9ffff, REGISTRY_ARIN       }, // 157.182.0.0     - 157.185.255.255
	{ 0x9dba0000, 0x9dbaffff, REGISTRY_RIPENCC    }, // 157.186.0.0     - 157.186.255.255
	{ 0x9dbb0000, 0x9dbdffff, REGISTRY_ARIN       }, // 157.187.0.0     - 157.189.255.255
	{ 0x9dbe0000, 0x9dbeffff, REGISTRY_RIPENCC    }, // 157.190.0.0     - 157.190.255.255
	{ 0x9dbf0000, 0x9dbfffff, REGISTRY_ARIN       }, // 157.191.0.0     - 157.191.255.255
	{ 0x9dc00000, 0x9dc0ffff, REGISTRY_APNIC      }, // 157.192.0.0     - 157.192.255.255
	{ 0x9dc10000, 0x9dc1ffff, REGISTRY_RIPENCC    }, // 157.193.0.0     - 157.193.255.255
	{ 0x9dc20000, 0x9dc4ffff, REGISTRY_ARIN       }, // 157.194.0.0     - 157.196.255.255
	{ 0x9dc50000, 0x9dc5ffff, REGISTRY_APNIC      }, // 157.197.0.0     - 157.197.255.255
	{ 0x9dc60000, 0x9dc7ffff, REGISTRY_ARIN       }, // 157.198.0.0     - 157.199.255.255
	{ 0x9dc80000, 0x9dc8ffff, REGISTRY_RIPENCC    }, // 157.200.0.0     - 157.200.255.255
	{ 0x9dc90000, 0x9dcaffff, REGISTRY_ARIN       }, // 157.201.0.0     - 157.202.255.255
	{ 0x9dcb0000, 0x9dcbffff, REGISTRY_RIPENCC    }, // 157.203.0.0     - 157.203.255.255
	{ 0x9dcc0000, 0x9dccffff, REGISTRY_ARIN       }, // 157.204.0.0     - 157.204.255.255
	{ 0x9dcd0000, 0x9dcdffff, REGISTRY_APNIC      }, // 157.205.0.0     - 157.205.255.255
	{ 0x9dce0000, 0x9dd2ffff, REGISTRY_ARIN       }, // 157.206.0.0     - 157.210.255.255
	{ 0x9dd30000, 0x9dd3ffff, REGISTRY_APNIC      }, // 157.211.0.0     - 157.211.255.255
	{ 0x9dd40000, 0x9de2ffff, REGISTRY_ARIN       }, // 157.212.0.0     - 157.226.255.255
	{ 0x9de30000, 0x9de3ffff, REGISTRY_APNIC      }, // 157.227.0.0     - 157.227.255.255
	{ 0x9de40000, 0x9de4ffff, REGISTRY_RIPENCC    }, // 157.228.0.0     - 157.228.255.255
	{ 0x9de50000, 0x9debffff, REGISTRY_ARIN       }, // 157.229.0.0     - 157.235.255.255
	{ 0x9dec0000, 0x9dedffff, REGISTRY_RIPENCC    }, // 157.236.0.0     - 157.237.255.255
	{ 0x9dee0000, 0x9df2ffff, REGISTRY_ARIN       }, // 157.238.0.0     - 157.242.255.255
	{ 0x9df30000, 0x9df3ffff, REGISTRY_RIPENCC    }, // 157.243.0.0     - 157.243.255.255
	{ 0x9df40000, 0x9df6ffff, REGISTRY_ARIN       }, // 157.244.0.0     - 157.246.255.255
	{ 0x9df70000, 0x9df7ffff, REGISTRY_RIPENCC    }, // 157.247.0.0     - 157.247.255.255
	{ 0x9df80000, 0x9df8ffff, REGISTRY_ARIN       }, // 157.248.0.0     - 157.248.255.255
	{ 0x9df90000, 0x9df9ffff, REGISTRY_RIPENCC    }, // 157.249.0.0     - 157.249.255.255
	{ 0x9dfa0000, 0x9dfa3fff, REGISTRY_ARIN       }, // 157.250.0.0     - 157.250.63.255 
	{ 0x9dfa4000, 0x9dfaffff, REGISTRY_APNIC      }, // 157.250.64.0    - 157.250.255.255
	{ 0x9dfb0000, 0x9dfcffff, REGISTRY_ARIN       }, // 157.251.0.0     - 157.252.255.255
	{ 0x9dfd0000, 0x9dfdffff, REGISTRY_LACNIC     }, // 157.253.0.0     - 157.253.255.255
	{ 0x9dfe0000, 0x9dfeffff, REGISTRY_ARIN       }, // 157.254.0.0     - 157.254.255.255
	{ 0x9dff0000, 0x9dffffff, REGISTRY_APNIC      }, // 157.255.0.0     - 157.255.255.255
	{ 0x9e000000, 0x9e23ffff, REGISTRY_ARIN       }, // 158.0.0.0       - 158.35.255.255 
	{ 0x9e240000, 0x9e27ffff, REGISTRY_RIPENCC    }, // 158.36.0.0      - 158.39.255.255 
	{ 0x9e280000, 0x9e28ffff, REGISTRY_APNIC      }, // 158.40.0.0      - 158.40.255.255 
	{ 0x9e290000, 0x9e2bffff, REGISTRY_RIPENCC    }, // 158.41.0.0      - 158.43.255.255 
	{ 0x9e2c0000, 0x9e2dffff, REGISTRY_APNIC      }, // 158.44.0.0      - 158.45.255.255 
	{ 0x9e2e0000, 0x9e2effff, REGISTRY_RIPENCC    }, // 158.46.0.0      - 158.46.255.255 
	{ 0x9e2f0000, 0x9e2fffff, REGISTRY_RIPENCC    }, // 158.47.0.0      - 158.47.255.255 
	{ 0x9e300000, 0x9e30ffff, REGISTRY_ARIN       }, // 158.48.0.0      - 158.48.255.255 
	{ 0x9e310000, 0x9e32ffff, REGISTRY_RIPENCC    }, // 158.49.0.0      - 158.50.255.255 
	{ 0x9e330000, 0x9e35ffff, REGISTRY_ARIN       }, // 158.51.0.0      - 158.53.255.255 
	{ 0x9e360000, 0x9e36ffff, REGISTRY_APNIC      }, // 158.54.0.0      - 158.54.255.255 
	{ 0x9e370000, 0x9e39ffff, REGISTRY_ARIN       }, // 158.55.0.0      - 158.57.255.255 
	{ 0x9e3a0000, 0x9e3affff, REGISTRY_RIPENCC    }, // 158.58.0.0      - 158.58.255.255 
	{ 0x9e3b0000, 0x9e3fffff, REGISTRY_ARIN       }, // 158.59.0.0      - 158.63.255.255 
	{ 0x9e400000, 0x9e40ffff, REGISTRY_RIPENCC    }, // 158.64.0.0      - 158.64.255.255 
	{ 0x9e410000, 0x9e41ffff, REGISTRY_ARIN       }, // 158.65.0.0      - 158.65.255.255 
	{ 0x9e420000, 0x9e43ffff, REGISTRY_RIPENCC    }, // 158.66.0.0      - 158.67.255.255 
	{ 0x9e440000, 0x9e4affff, REGISTRY_ARIN       }, // 158.68.0.0      - 158.74.255.255 
	{ 0x9e4b0000, 0x9e4bffff, REGISTRY_RIPENCC    }, // 158.75.0.0      - 158.75.255.255 
	{ 0x9e4c0000, 0x9e58ffff, REGISTRY_ARIN       }, // 158.76.0.0      - 158.88.255.255 
	{ 0x9e590000, 0x9e59ffff, REGISTRY_APNIC      }, // 158.89.0.0      - 158.89.255.255 
	{ 0x9e5a0000, 0x9e5affff, REGISTRY_RIPENCC    }, // 158.90.0.0      - 158.90.255.255 
	{ 0x9e5b0000, 0x9e5bffff, REGISTRY_ARIN       }, // 158.91.0.0      - 158.91.255.255 
	{ 0x9e5c0000, 0x9e5cffff, REGISTRY_RIPENCC    }, // 158.92.0.0      - 158.92.255.255 
	{ 0x9e5d0000, 0x9e5dffff, REGISTRY_ARIN       }, // 158.93.0.0      - 158.93.255.255 
	{ 0x9e5e0000, 0x9e5effff, REGISTRY_RIPENCC    }, // 158.94.0.0      - 158.94.255.255 
	{ 0x9e5f0000, 0x9e60ffff, REGISTRY_ARIN       }, // 158.95.0.0      - 158.96.255.255 
	{ 0x9e610000, 0x9e61ffff, REGISTRY_LACNIC     }, // 158.97.0.0      - 158.97.255.255 
	{ 0x9e620000, 0x9e62ffff, REGISTRY_ARIN       }, // 158.98.0.0      - 158.98.255.255 
	{ 0x9e630000, 0x9e63ffff, REGISTRY_RIPENCC    }, // 158.99.0.0      - 158.99.255.255 
	{ 0x9e640000, 0x9e65ffff, REGISTRY_ARIN       }, // 158.100.0.0     - 158.101.255.255
	{ 0x9e660000, 0x9e66ffff, REGISTRY_RIPENCC    }, // 158.102.0.0     - 158.102.255.255
	{ 0x9e670000, 0x9e68ffff, REGISTRY_ARIN       }, // 158.103.0.0     - 158.104.255.255
	{ 0x9e690000, 0x9e69ffff, REGISTRY_RIPENCC    }, // 158.105.0.0     - 158.105.255.255
	{ 0x9e6a0000, 0x9e6bffff, REGISTRY_ARIN       }, // 158.106.0.0     - 158.107.255.255
	{ 0x9e6c0000, 0x9e6cffff, REGISTRY_APNIC      }, // 158.108.0.0     - 158.108.255.255
	{ 0x9e6d0000, 0x9e6effff, REGISTRY_RIPENCC    }, // 158.109.0.0     - 158.110.255.255
	{ 0x9e6f0000, 0x9e6fffff, REGISTRY_ARIN       }, // 158.111.0.0     - 158.111.255.255
	{ 0x9e700000, 0x9e70ffff, REGISTRY_RIPENCC    }, // 158.112.0.0     - 158.112.255.255
	{ 0x9e710000, 0x9e76ffff, REGISTRY_ARIN       }, // 158.113.0.0     - 158.118.255.255
	{ 0x9e770000, 0x9e77ffff, REGISTRY_RIPENCC    }, // 158.119.0.0     - 158.119.255.255
	{ 0x9e780000, 0x9e7bffff, REGISTRY_ARIN       }, // 158.120.0.0     - 158.123.255.255
	{ 0x9e7c0000, 0x9e7fffff, REGISTRY_RIPENCC    }, // 158.124.0.0     - 158.127.255.255
	{ 0x9e800000, 0x9e80ffff, REGISTRY_ARIN       }, // 158.128.0.0     - 158.128.255.255
	{ 0x9e810000, 0x9e81ffff, REGISTRY_RIPENCC    }, // 158.129.0.0     - 158.129.255.255
	{ 0x9e820000, 0x9e82ffff, REGISTRY_ARIN       }, // 158.130.0.0     - 158.130.255.255
	{ 0x9e830000, 0x9e83ffff, REGISTRY_RIPENCC    }, // 158.131.0.0     - 158.131.255.255
	{ 0x9e840000, 0x9e84ffff, REGISTRY_APNIC      }, // 158.132.0.0     - 158.132.255.255
	{ 0x9e850000, 0x9e85ffff, REGISTRY_RIPENCC    }, // 158.133.0.0     - 158.133.255.255
	{ 0x9e860000, 0x9e8effff, REGISTRY_ARIN       }, // 158.134.0.0     - 158.142.255.255
	{ 0x9e8f0000, 0x9e8fffff, REGISTRY_RIPENCC    }, // 158.143.0.0     - 158.143.255.255
	{ 0x9e900000, 0x9e90ffff, REGISTRY_APNIC      }, // 158.144.0.0     - 158.144.255.255
	{ 0x9e910000, 0x9e93ffff, REGISTRY_ARIN       }, // 158.145.0.0     - 158.147.255.255
	{ 0x9e940000, 0x9e94ffff, REGISTRY_RIPENCC    }, // 158.148.0.0     - 158.148.255.255
	{ 0x9e950000, 0x9e96ffff, REGISTRY_RIPENCC    }, // 158.149.0.0     - 158.150.255.255
	{ 0x9e970000, 0x9e97ffff, REGISTRY_ARIN       }, // 158.151.0.0     - 158.151.255.255
	{ 0x9e980000, 0x9e98ffff, REGISTRY_RIPENCC    }, // 158.152.0.0     - 158.152.255.255
	{ 0x9e990000, 0x9e9bffff, REGISTRY_ARIN       }, // 158.153.0.0     - 158.155.255.255
	{ 0x9e9c0000, 0x9e9cffff, REGISTRY_RIPENCC    }, // 158.156.0.0     - 158.156.255.255
	{ 0x9e9d0000, 0x9e9fffff, REGISTRY_ARIN       }, // 158.157.0.0     - 158.159.255.255
	{ 0x9ea00000, 0x9ea0ffff, REGISTRY_LACNIC     }, // 158.160.0.0     - 158.160.255.255
	{ 0x9ea10000, 0x9ea1ffff, REGISTRY_APNIC      }, // 158.161.0.0     - 158.161.255.255
	{ 0x9ea20000, 0x9ea2ffff, REGISTRY_RIPENCC    }, // 158.162.0.0     - 158.162.255.255
	{ 0x9ea30000, 0x9ea5ffff, REGISTRY_ARIN       }, // 158.163.0.0     - 158.165.255.255
	{ 0x9ea60000, 0x9ea9ffff, REGISTRY_RIPENCC    }, // 158.166.0.0     - 158.169.255.255
	{ 0x9eaa0000, 0x9eaaffff, REGISTRY_LACNIC     }, // 158.170.0.0     - 158.170.255.255
	{ 0x9eab0000, 0x9eabffff, REGISTRY_ARIN       }, // 158.171.0.0     - 158.171.255.255
	{ 0x9eac0000, 0x9eb4ffff, REGISTRY_RIPENCC    }, // 158.172.0.0     - 158.180.255.255
	{ 0x9eb50000, 0x9eb5ffff, REGISTRY_RIPENCC    }, // 158.181.0.0     - 158.181.255.255
	{ 0x9eb60000, 0x9eb6ffff, REGISTRY_APNIC      }, // 158.182.0.0     - 158.182.255.255
	{ 0x9eb70000, 0x9ebdffff, REGISTRY_ARIN       }, // 158.183.0.0     - 158.189.255.255
	{ 0x9ebe0000, 0x9ec5ffff, REGISTRY_RIPENCC    }, // 158.190.0.0     - 158.197.255.255
	{ 0x9ec60000, 0x9ed7ffff, REGISTRY_APNIC      }, // 158.198.0.0     - 158.215.255.255
	{ 0x9ed80000, 0x9ed8ffff, REGISTRY_RIPENCC    }, // 158.216.0.0     - 158.216.255.255
	{ 0x9ed90000, 0x9ed9ffff, REGISTRY_APNIC      }, // 158.217.0.0     - 158.217.255.255
	{ 0x9eda0000, 0x9edaffff, REGISTRY_RIPENCC    }, // 158.218.0.0     - 158.218.255.255
	{ 0x9edb0000, 0x9edbffff, REGISTRY_ARIN       }, // 158.219.0.0     - 158.219.255.255
	{ 0x9edc0000, 0x9edcffff, REGISTRY_RIPENCC    }, // 158.220.0.0     - 158.220.255.255
	{ 0x9edd0000, 0x9edeffff, REGISTRY_ARIN       }, // 158.221.0.0     - 158.222.255.255
	{ 0x9edf0000, 0x9edfffff, REGISTRY_RIPENCC    }, // 158.223.0.0     - 158.223.255.255
	{ 0x9ee00000, 0x9ee0ffff, REGISTRY_ARIN       }, // 158.224.0.0     - 158.224.255.255
	{ 0x9ee10000, 0x9ee3ffff, REGISTRY_RIPENCC    }, // 158.225.0.0     - 158.227.255.255
	{ 0x9ee40000, 0x9ee5ffff, REGISTRY_ARIN       }, // 158.228.0.0     - 158.229.255.255
	{ 0x9ee60000, 0x9eeaffff, REGISTRY_RIPENCC    }, // 158.230.0.0     - 158.234.255.255
	{ 0x9eeb0000, 0x9ef7ffff, REGISTRY_ARIN       }, // 158.235.0.0     - 158.247.255.255
	{ 0x9ef80000, 0x9efaffff, REGISTRY_RIPENCC    }, // 158.248.0.0     - 158.250.255.255
	{ 0x9efb0000, 0x9efbffff, REGISTRY_LACNIC     }, // 158.251.0.0     - 158.251.255.255
	{ 0x9efc0000, 0x9efeffff, REGISTRY_ARIN       }, // 158.252.0.0     - 158.254.255.255
	{ 0x9eff0000, 0x9f00ffff, REGISTRY_RIPENCC    }, // 158.255.0.0     - 159.0.255.255  
	{ 0x9f010000, 0x9f06ffff, REGISTRY_ARIN       }, // 159.1.0.0       - 159.6.255.255  
	{ 0x9f070000, 0x9f08ffff, REGISTRY_RIPENCC    }, // 159.7.0.0       - 159.8.255.255  
	{ 0x9f090000, 0x9f0bffff, REGISTRY_ARIN       }, // 159.9.0.0       - 159.11.255.255 
	{ 0x9f0c0000, 0x9f0cffff, REGISTRY_RIPENCC    }, // 159.12.0.0      - 159.12.255.255 
	{ 0x9f0d0000, 0x9f0dffff, REGISTRY_APNIC      }, // 159.13.0.0      - 159.13.255.255 
	{ 0x9f0e0000, 0x9f0effff, REGISTRY_ARIN       }, // 159.14.0.0      - 159.14.255.255 
	{ 0x9f0f0000, 0x9f0fffff, REGISTRY_RIPENCC    }, // 159.15.0.0      - 159.15.255.255 
	{ 0x9f100000, 0x9f10ffff, REGISTRY_LACNIC     }, // 159.16.0.0      - 159.16.255.255 
	{ 0x9f110000, 0x9f13ffff, REGISTRY_ARIN       }, // 159.17.0.0      - 159.19.255.255 
	{ 0x9f140000, 0x9f14ffff, REGISTRY_RIPENCC    }, // 159.20.0.0      - 159.20.255.255 
	{ 0x9f150000, 0x9f15ffff, REGISTRY_ARIN       }, // 159.21.0.0      - 159.21.255.255 
	{ 0x9f160000, 0x9f17ffff, REGISTRY_RIPENCC    }, // 159.22.0.0      - 159.23.255.255 
	{ 0x9f180000, 0x9f18ffff, REGISTRY_ARIN       }, // 159.24.0.0      - 159.24.255.255 
	{ 0x9f190000, 0x9f19ffff, REGISTRY_RIPENCC    }, // 159.25.0.0      - 159.25.255.255 
	{ 0x9f1a0000, 0x9f1cffff, REGISTRY_ARIN       }, // 159.26.0.0      - 159.28.255.255 
	{ 0x9f1d0000, 0x9f1fffff, REGISTRY_RIPENCC    }, // 159.29.0.0      - 159.31.255.255 
	{ 0x9f200000, 0x9f21ffff, REGISTRY_ARIN       }, // 159.32.0.0      - 159.33.255.255 
	{ 0x9f220000, 0x9f22ffff, REGISTRY_RIPENCC    }, // 159.34.0.0      - 159.34.255.255 
	{ 0x9f230000, 0x9f25ffff, REGISTRY_ARIN       }, // 159.35.0.0      - 159.37.255.255 
	{ 0x9f260000, 0x9f26ffff, REGISTRY_RIPENCC    }, // 159.38.0.0      - 159.38.255.255 
	{ 0x9f270000, 0x9f2dffff, REGISTRY_ARIN       }, // 159.39.0.0      - 159.45.255.255 
	{ 0x9f2e0000, 0x9f2effff, REGISTRY_RIPENCC    }, // 159.46.0.0      - 159.46.255.255 
	{ 0x9f2f0000, 0x9f31ffff, REGISTRY_ARIN       }, // 159.47.0.0      - 159.49.255.255 
	{ 0x9f320000, 0x9f33ffff, REGISTRY_RIPENCC    }, // 159.50.0.0      - 159.51.255.255 
	{ 0x9f340000, 0x9f34ffff, REGISTRY_APNIC      }, // 159.52.0.0      - 159.52.255.255 
	{ 0x9f350000, 0x9f39ffff, REGISTRY_ARIN       }, // 159.53.0.0      - 159.57.255.255 
	{ 0x9f3a0000, 0x9f3affff, REGISTRY_RIPENCC    }, // 159.58.0.0      - 159.58.255.255 
	{ 0x9f3b0000, 0x9f3bffff, REGISTRY_ARIN       }, // 159.59.0.0      - 159.59.255.255 
	{ 0x9f3c0000, 0x9f3cffff, REGISTRY_RIPENCC    }, // 159.60.0.0      - 159.60.255.255 
	{ 0x9f3d0000, 0x9f47ffff, REGISTRY_ARIN       }, // 159.61.0.0      - 159.71.255.255 
	{ 0x9f480000, 0x9f48ffff, REGISTRY_RIPENCC    }, // 159.72.0.0      - 159.72.255.255 
	{ 0x9f490000, 0x9f49ffff, REGISTRY_APNIC      }, // 159.73.0.0      - 159.73.255.255 
	{ 0x9f4a0000, 0x9f4fffff, REGISTRY_ARIN       }, // 159.74.0.0      - 159.79.255.255 
	{ 0x9f500000, 0x9f50ffff, REGISTRY_APNIC      }, // 159.80.0.0      - 159.80.255.255 
	{ 0x9f510000, 0x9f51ffff, REGISTRY_RIPENCC    }, // 159.81.0.0      - 159.81.255.255 
	{ 0x9f520000, 0x9f53ffff, REGISTRY_ARIN       }, // 159.82.0.0      - 159.83.255.255 
	{ 0x9f540000, 0x9f54ffff, REGISTRY_RIPENCC    }, // 159.84.0.0      - 159.84.255.255 
	{ 0x9f550000, 0x9f55ffff, REGISTRY_ARIN       }, // 159.85.0.0      - 159.85.255.255 
	{ 0x9f560000, 0x9f56ffff, REGISTRY_RIPENCC    }, // 159.86.0.0      - 159.86.255.255 
	{ 0x9f570000, 0x9f59ffff, REGISTRY_ARIN       }, // 159.87.0.0      - 159.89.255.255 
	{ 0x9f5a0000, 0x9f5affff, REGISTRY_LACNIC     }, // 159.90.0.0      - 159.90.255.255 
	{ 0x9f5b0000, 0x9f5bffff, REGISTRY_ARIN       }, // 159.91.0.0      - 159.91.255.255 
	{ 0x9f5c0000, 0x9f5dffff, REGISTRY_RIPENCC    }, // 159.92.0.0      - 159.93.255.255 
	{ 0x9f5e0000, 0x9f5effff, REGISTRY_ARIN       }, // 159.94.0.0      - 159.94.255.255 
	{ 0x9f5f0000, 0x9f5fffff, REGISTRY_RIPENCC    }, // 159.95.0.0      - 159.95.255.255 
	{ 0x9f600000, 0x9f63ffff, REGISTRY_ARIN       }, // 159.96.0.0      - 159.99.255.255 
	{ 0x9f640000, 0x9f65ffff, REGISTRY_RIPENCC    }, // 159.100.0.0     - 159.101.255.255
	{ 0x9f660000, 0x9f66ffff, REGISTRY_ARIN       }, // 159.102.0.0     - 159.102.255.255
	{ 0x9f670000, 0x9f68ffff, REGISTRY_RIPENCC    }, // 159.103.0.0     - 159.104.255.255
	{ 0x9f690000, 0x9f6affff, REGISTRY_ARIN       }, // 159.105.0.0     - 159.106.255.255
	{ 0x9f6b0000, 0x9f6bffff, REGISTRY_RIPENCC    }, // 159.107.0.0     - 159.107.255.255
	{ 0x9f6c0000, 0x9f6cffff, REGISTRY_ARIN       }, // 159.108.0.0     - 159.108.255.255
	{ 0x9f6d0000, 0x9f6dffff, REGISTRY_RIPENCC    }, // 159.109.0.0     - 159.109.255.255
	{ 0x9f6e0000, 0x9f6effff, REGISTRY_ARIN       }, // 159.110.0.0     - 159.110.255.255
	{ 0x9f6f0000, 0x9f6fffff, REGISTRY_APNIC      }, // 159.111.0.0     - 159.111.255.255
	{ 0x9f700000, 0x9f71ffff, REGISTRY_ARIN       }, // 159.112.0.0     - 159.113.255.255
	{ 0x9f720000, 0x9f72ffff, REGISTRY_RIPENCC    }, // 159.114.0.0     - 159.114.255.255
	{ 0x9f730000, 0x9f74ffff, REGISTRY_ARIN       }, // 159.115.0.0     - 159.116.255.255
	{ 0x9f750000, 0x9f75ffff, REGISTRY_APNIC      }, // 159.117.0.0     - 159.117.255.255
	{ 0x9f760000, 0x9f79ffff, REGISTRY_ARIN       }, // 159.118.0.0     - 159.121.255.255
	{ 0x9f7a0000, 0x9f7affff, REGISTRY_RIPENCC    }, // 159.122.0.0     - 159.122.255.255
	{ 0x9f7b0000, 0x9f81ffff, REGISTRY_ARIN       }, // 159.123.0.0     - 159.129.255.255
	{ 0x9f820000, 0x9f82ffff, REGISTRY_RIPENCC    }, // 159.130.0.0     - 159.130.255.255
	{ 0x9f830000, 0x9f85ffff, REGISTRY_ARIN       }, // 159.131.0.0     - 159.133.255.255
	{ 0x9f860000, 0x9f86ffff, REGISTRY_RIPENCC    }, // 159.134.0.0     - 159.134.255.255
	{ 0x9f870000, 0x9f8fffff, REGISTRY_ARIN       }, // 159.135.0.0     - 159.143.255.255
	{ 0x9f900000, 0x9f90ffff, REGISTRY_RIPENCC    }, // 159.144.0.0     - 159.144.255.255
	{ 0x9f910000, 0x9f91ffff, REGISTRY_ARIN       }, // 159.145.0.0     - 159.145.255.255
	{ 0x9f920000, 0x9f92ffff, REGISTRY_RIPENCC    }, // 159.146.0.0     - 159.146.255.255
	{ 0x9f930000, 0x9f95ffff, REGISTRY_RIPENCC    }, // 159.147.0.0     - 159.149.255.255
	{ 0x9f960000, 0x9f96ffff, REGISTRY_ARIN       }, // 159.150.0.0     - 159.150.255.255
	{ 0x9f970000, 0x9f98ffff, REGISTRY_RIPENCC    }, // 159.151.0.0     - 159.152.255.255
	{ 0x9f990000, 0x9f99ffff, REGISTRY_ARIN       }, // 159.153.0.0     - 159.153.255.255
	{ 0x9f9a0000, 0x9f9affff, REGISTRY_RIPENCC    }, // 159.154.0.0     - 159.154.255.255
	{ 0x9f9b0000, 0x9f9bffff, REGISTRY_ARIN       }, // 159.155.0.0     - 159.155.255.255
	{ 0x9f9c0000, 0x9f9cffff, REGISTRY_RIPENCC    }, // 159.156.0.0     - 159.156.255.255
	{ 0x9f9d0000, 0x9f9fffff, REGISTRY_ARIN       }, // 159.157.0.0     - 159.159.255.255
	{ 0x9fa00000, 0x9fa0ffff, REGISTRY_RIPENCC    }, // 159.160.0.0     - 159.160.255.255
	{ 0x9fa10000, 0x9fa1ffff, REGISTRY_ARIN       }, // 159.161.0.0     - 159.161.255.255
	{ 0x9fa20000, 0x9fa2ffff, REGISTRY_RIPENCC    }, // 159.162.0.0     - 159.162.255.255
	{ 0x9fa30000, 0x9fa6ffff, REGISTRY_ARIN       }, // 159.163.0.0     - 159.166.255.255
	{ 0x9fa70000, 0x9fa8ffff, REGISTRY_RIPENCC    }, // 159.167.0.0     - 159.168.255.255
	{ 0x9fa90000, 0x9fa9ffff, REGISTRY_ARIN       }, // 159.169.0.0     - 159.169.255.255
	{ 0x9faa0000, 0x9fabffff, REGISTRY_RIPENCC    }, // 159.170.0.0     - 159.171.255.255
	{ 0x9fac0000, 0x9facffff, REGISTRY_ARIN       }, // 159.172.0.0     - 159.172.255.255
	{ 0x9fad0000, 0x9fadffff, REGISTRY_RIPENCC    }, // 159.173.0.0     - 159.173.255.255
	{ 0x9fae0000, 0x9fb2ffff, REGISTRY_ARIN       }, // 159.174.0.0     - 159.178.255.255
	{ 0x9fb30000, 0x9fb4ffff, REGISTRY_RIPENCC    }, // 159.179.0.0     - 159.180.255.255
	{ 0x9fb50000, 0x9fbdffff, REGISTRY_ARIN       }, // 159.181.0.0     - 159.189.255.255
	{ 0x9fbe0000, 0x9fbeffff, REGISTRY_RIPENCC    }, // 159.190.0.0     - 159.190.255.255
	{ 0x9fbf0000, 0x9fc0ffff, REGISTRY_ARIN       }, // 159.191.0.0     - 159.192.255.255
	{ 0x9fc10000, 0x9fc3ffff, REGISTRY_RIPENCC    }, // 159.193.0.0     - 159.195.255.255
	{ 0x9fc40000, 0x9fc4ffff, REGISTRY_APNIC      }, // 159.196.0.0     - 159.196.255.255
	{ 0x9fc50000, 0x9fc5ffff, REGISTRY_RIPENCC    }, // 159.197.0.0     - 159.197.255.255
	{ 0x9fc60000, 0x9fc7ffff, REGISTRY_ARIN       }, // 159.198.0.0     - 159.199.255.255
	{ 0x9fc80000, 0x9fc8ffff, REGISTRY_RIPENCC    }, // 159.200.0.0     - 159.200.255.255
	{ 0x9fc90000, 0x9fccffff, REGISTRY_ARIN       }, // 159.201.0.0     - 159.204.255.255
	{ 0x9fcd0000, 0x9fcdffff, REGISTRY_RIPENCC    }, // 159.205.0.0     - 159.205.255.255
	{ 0x9fce0000, 0x9fceffff, REGISTRY_ARIN       }, // 159.206.0.0     - 159.206.255.255
	{ 0x9fcf0000, 0x9fcfffff, REGISTRY_APNIC      }, // 159.207.0.0     - 159.207.255.255
	{ 0x9fd00000, 0x9fd1ffff, REGISTRY_ARIN       }, // 159.208.0.0     - 159.209.255.255
	{ 0x9fd20000, 0x9fd2ffff, REGISTRY_RIPENCC    }, // 159.210.0.0     - 159.210.255.255
	{ 0x9fd30000, 0x9fd3ffff, REGISTRY_APNIC      }, // 159.211.0.0     - 159.211.255.255
	{ 0x9fd40000, 0x9fd4ffff, REGISTRY_ARIN       }, // 159.212.0.0     - 159.212.255.255
	{ 0x9fd50000, 0x9fd5ffff, REGISTRY_RIPENCC    }, // 159.213.0.0     - 159.213.255.255
	{ 0x9fd60000, 0x9fd7ffff, REGISTRY_ARIN       }, // 159.214.0.0     - 159.215.255.255
	{ 0x9fd80000, 0x9fd9ffff, REGISTRY_RIPENCC    }, // 159.216.0.0     - 159.217.255.255
	{ 0x9fda0000, 0x9fdaffff, REGISTRY_ARIN       }, // 159.218.0.0     - 159.218.255.255
	{ 0x9fdb0000, 0x9fdbffff, REGISTRY_RIPENCC    }, // 159.219.0.0     - 159.219.255.255
	{ 0x9fdc0000, 0x9fdfffff, REGISTRY_ARIN       }, // 159.220.0.0     - 159.223.255.255
	{ 0x9fe00000, 0x9fe0ffff, REGISTRY_RIPENCC    }, // 159.224.0.0     - 159.224.255.255
	{ 0x9fe10000, 0x9fe1ffff, REGISTRY_ARIN       }, // 159.225.0.0     - 159.225.255.255
	{ 0x9fe20000, 0x9fe2ffff, REGISTRY_APNIC      }, // 159.226.0.0     - 159.226.255.255
	{ 0x9fe30000, 0x9fe3ffff, REGISTRY_ARIN       }, // 159.227.0.0     - 159.227.255.255
	{ 0x9fe50000, 0x9fe7ffff, REGISTRY_ARIN       }, // 159.229.0.0     - 159.231.255.255
	{ 0x9fe80000, 0x9fe8ffff, REGISTRY_RIPENCC    }, // 159.232.0.0     - 159.232.255.255
	{ 0x9fe90000, 0x9febffff, REGISTRY_ARIN       }, // 159.233.0.0     - 159.235.255.255
	{ 0x9fec0000, 0x9fedffff, REGISTRY_RIPENCC    }, // 159.236.0.0     - 159.237.255.255
	{ 0x9fee0000, 0x9feeffff, REGISTRY_ARIN       }, // 159.238.0.0     - 159.238.255.255
	{ 0x9fef0000, 0x9fefffff, REGISTRY_RIPENCC    }, // 159.239.0.0     - 159.239.255.255
	{ 0x9ff00000, 0x9ff0ffff, REGISTRY_ARIN       }, // 159.240.0.0     - 159.240.255.255
	{ 0x9ff10000, 0x9ff1ffff, REGISTRY_RIPENCC    }, // 159.241.0.0     - 159.241.255.255
	{ 0x9ff20000, 0x9ff3ffff, REGISTRY_ARIN       }, // 159.242.0.0     - 159.243.255.255
	{ 0x9ff40000, 0x9ff5ffff, REGISTRY_RIPENCC    }, // 159.244.0.0     - 159.245.255.255
	{ 0x9ff60000, 0x9ff7ffff, REGISTRY_ARIN       }, // 159.246.0.0     - 159.247.255.255
	{ 0x9ff80000, 0x9ff8ffff, REGISTRY_APNIC      }, // 159.248.0.0     - 159.248.255.255
	{ 0x9ff90000, 0x9ffcffff, REGISTRY_ARIN       }, // 159.249.0.0     - 159.252.255.255
	{ 0x9ffd0000, 0x9ffdffff, REGISTRY_RIPENCC    }, // 159.253.0.0     - 159.253.255.255
	{ 0x9ffe0000, 0x9ffeffff, REGISTRY_RIPENCC    }, // 159.254.0.0     - 159.254.255.255
	{ 0x9fff0000, 0x9fffffff, REGISTRY_RIPENCC    }, // 159.255.0.0     - 159.255.255.255
	{ 0xa0010000, 0xa003ffff, REGISTRY_ARIN       }, // 160.1.0.0       - 160.3.255.255  
	{ 0xa0040000, 0xa004ffff, REGISTRY_APNIC      }, // 160.4.0.0       - 160.4.255.255  
	{ 0xa0050000, 0xa006ffff, REGISTRY_RIPENCC    }, // 160.5.0.0       - 160.6.255.255  
	{ 0xa0070000, 0xa007ffff, REGISTRY_ARIN       }, // 160.7.0.0       - 160.7.255.255  
	{ 0xa0080000, 0xa009ffff, REGISTRY_RIPENCC    }, // 160.8.0.0       - 160.9.255.255  
	{ 0xa00a0000, 0xa00affff, REGISTRY_ARIN       }, // 160.10.0.0      - 160.10.255.255 
	{ 0xa00b0000, 0xa012ffff, REGISTRY_APNIC      }, // 160.11.0.0      - 160.18.255.255 
	{ 0xa0150000, 0xa018ffff, REGISTRY_APNIC      }, // 160.21.0.0      - 160.24.255.255 
	{ 0xa01a0000, 0xa01dffff, REGISTRY_APNIC      }, // 160.26.0.0      - 160.29.255.255 
	{ 0xa01f0000, 0xa025ffff, REGISTRY_ARIN       }, // 160.31.0.0      - 160.37.255.255 
	{ 0xa0260000, 0xa026ffff, REGISTRY_RIPENCC    }, // 160.38.0.0      - 160.38.255.255 
	{ 0xa0270000, 0xa027ffff, REGISTRY_ARIN       }, // 160.39.0.0      - 160.39.255.255 
	{ 0xa0280000, 0xa028ffff, REGISTRY_RIPENCC    }, // 160.40.0.0      - 160.40.255.255 
	{ 0xa0290000, 0xa02bffff, REGISTRY_ARIN       }, // 160.41.0.0      - 160.43.255.255 
	{ 0xa02c0000, 0xa02cffff, REGISTRY_RIPENCC    }, // 160.44.0.0      - 160.44.255.255 
	{ 0xa02d0000, 0xa03cffff, REGISTRY_RIPENCC    }, // 160.45.0.0      - 160.60.255.255 
	{ 0xa03d0000, 0xa03effff, REGISTRY_RIPENCC    }, // 160.61.0.0      - 160.62.255.255 
	{ 0xa03f0000, 0xa03fffff, REGISTRY_RIPENCC    }, // 160.63.0.0      - 160.63.255.255 
	{ 0xa0400000, 0xa040ffff, REGISTRY_APNIC      }, // 160.64.0.0      - 160.64.255.255 
	{ 0xa0410000, 0xa041ffff, REGISTRY_ARIN       }, // 160.65.0.0      - 160.65.255.255 
	{ 0xa0420000, 0xa044ffff, REGISTRY_RIPENCC    }, // 160.66.0.0      - 160.68.255.255 
	{ 0xa0450000, 0xa045ffff, REGISTRY_ARIN       }, // 160.69.0.0      - 160.69.255.255 
	{ 0xa0460000, 0xa047ffff, REGISTRY_RIPENCC    }, // 160.70.0.0      - 160.71.255.255 
	{ 0xa0480000, 0xa049ffff, REGISTRY_ARIN       }, // 160.72.0.0      - 160.73.255.255 
	{ 0xa04a0000, 0xa04affff, REGISTRY_APNIC      }, // 160.74.0.0      - 160.74.255.255 
	{ 0xa04b0000, 0xa04bffff, REGISTRY_RIPENCC    }, // 160.75.0.0      - 160.75.255.255 
	{ 0xa04c0000, 0xa04cffff, REGISTRY_ARIN       }, // 160.76.0.0      - 160.76.255.255 
	{ 0xa04e0000, 0xa04effff, REGISTRY_RIPENCC    }, // 160.78.0.0      - 160.78.255.255 
	{ 0xa04f0000, 0xa04fffff, REGISTRY_ARIN       }, // 160.79.0.0      - 160.79.255.255 
	{ 0xa0500000, 0xa050ffff, REGISTRY_RIPENCC    }, // 160.80.0.0      - 160.80.255.255 
	{ 0xa0510000, 0xa054ffff, REGISTRY_ARIN       }, // 160.81.0.0      - 160.84.255.255 
	{ 0xa0550000, 0xa055ffff, REGISTRY_RIPENCC    }, // 160.85.0.0      - 160.85.255.255 
	{ 0xa0560000, 0xa058ffff, REGISTRY_ARIN       }, // 160.86.0.0      - 160.88.255.255 
	{ 0xa05b0000, 0xa05bffff, REGISTRY_ARIN       }, // 160.91.0.0      - 160.91.255.255 
	{ 0xa05c0000, 0xa05cffff, REGISTRY_RIPENCC    }, // 160.92.0.0      - 160.92.255.255 
	{ 0xa05d0000, 0xa05fffff, REGISTRY_ARIN       }, // 160.93.0.0      - 160.95.255.255 
	{ 0xa0600000, 0xa060ffff, REGISTRY_APNIC      }, // 160.96.0.0      - 160.96.255.255 
	{ 0xa0610000, 0xa064ffff, REGISTRY_RIPENCC    }, // 160.97.0.0      - 160.100.255.255
	{ 0xa0650000, 0xa066ffff, REGISTRY_ARIN       }, // 160.101.0.0     - 160.102.255.255
	{ 0xa0670000, 0xa068ffff, REGISTRY_RIPENCC    }, // 160.103.0.0     - 160.104.255.255
	{ 0xa06a0000, 0xa070ffff, REGISTRY_ARIN       }, // 160.106.0.0     - 160.112.255.255
	{ 0xa0720000, 0xa072ffff, REGISTRY_RIPENCC    }, // 160.114.0.0     - 160.114.255.255
	{ 0xa0730000, 0xa076ffff, REGISTRY_AFRINIC    }, // 160.115.0.0     - 160.118.255.255
	{ 0xa0790000, 0xa07cffff, REGISTRY_AFRINIC    }, // 160.121.0.0     - 160.124.255.255
	{ 0xa07d0000, 0xa097ffff, REGISTRY_ARIN       }, // 160.125.0.0     - 160.151.255.255
	{ 0xa0990000, 0xa099ffff, REGISTRY_ARIN       }, // 160.153.0.0     - 160.153.255.255
	{ 0xa0b40000, 0xa0b4ffff, REGISTRY_RIPENCC    }, // 160.180.0.0     - 160.180.255.255
	{ 0xa0b50000, 0xa0b5ffff, REGISTRY_AFRINIC    }, // 160.181.0.0     - 160.181.255.255
	{ 0xa0b80000, 0xa0b8ffff, REGISTRY_AFRINIC    }, // 160.184.0.0     - 160.184.255.255
	{ 0xa0b90000, 0xa0beffff, REGISTRY_APNIC      }, // 160.185.0.0     - 160.190.255.255
	{ 0xa0c00000, 0xa0ca07ff, REGISTRY_APNIC      }, // 160.192.0.0     - 160.202.7.255  
	{ 0xa0cb0000, 0xa0ccffff, REGISTRY_APNIC      }, // 160.203.0.0     - 160.204.255.255
	{ 0xa0cd0000, 0xa0cdffff, REGISTRY_ARIN       }, // 160.205.0.0     - 160.205.255.255
	{ 0xa0ce0000, 0xa0ceffff, REGISTRY_APNIC      }, // 160.206.0.0     - 160.206.255.255
	{ 0xa0cf0000, 0xa0d1ffff, REGISTRY_ARIN       }, // 160.207.0.0     - 160.209.255.255
	{ 0xa0d20000, 0xa0d3ffff, REGISTRY_RIPENCC    }, // 160.210.0.0     - 160.211.255.255
	{ 0xa0d40000, 0xa0d4ffff, REGISTRY_ARIN       }, // 160.212.0.0     - 160.212.255.255
	{ 0xa0d50000, 0xa0d6ffff, REGISTRY_RIPENCC    }, // 160.213.0.0     - 160.214.255.255
	{ 0xa0d70000, 0xa0d7ffff, REGISTRY_APNIC      }, // 160.215.0.0     - 160.215.255.255
	{ 0xa0d80000, 0xa0ddffff, REGISTRY_RIPENCC    }, // 160.216.0.0     - 160.221.255.255
	{ 0xa0de0000, 0xa0deffff, REGISTRY_APNIC      }, // 160.222.0.0     - 160.222.255.255
	{ 0xa0df0000, 0xa0dfffff, REGISTRY_ARIN       }, // 160.223.0.0     - 160.223.255.255
	{ 0xa0e30000, 0xa0e3ffff, REGISTRY_ARIN       }, // 160.227.0.0     - 160.227.255.255
	{ 0xa0e40000, 0xa0e4ffff, REGISTRY_RIPENCC    }, // 160.228.0.0     - 160.228.255.255
	{ 0xa0e50000, 0xa0e8ffff, REGISTRY_ARIN       }, // 160.229.0.0     - 160.232.255.255
	{ 0xa0e90000, 0xa0e9ffff, REGISTRY_APNIC      }, // 160.233.0.0     - 160.233.255.255
	{ 0xa0eb0000, 0xa0ebffff, REGISTRY_APNIC      }, // 160.235.0.0     - 160.235.255.255
	{ 0xa0ed0000, 0xa0edffff, REGISTRY_APNIC      }, // 160.237.0.0     - 160.237.255.255
	{ 0xa0ee0100, 0xa0ee0aff, REGISTRY_APNIC      }, // 160.238.1.0     - 160.238.10.255 
	{ 0xa0ee1400, 0xa0ee14ff, REGISTRY_APNIC      }, // 160.238.20.0    - 160.238.20.255 
	{ 0xa0ee1e00, 0xa0ee1eff, REGISTRY_APNIC      }, // 160.238.30.0    - 160.238.30.255 
	{ 0xa0ee2000, 0xa0ee20ff, REGISTRY_APNIC      }, // 160.238.32.0    - 160.238.32.255 
	{ 0xa0ee2800, 0xa0ee28ff, REGISTRY_APNIC      }, // 160.238.40.0    - 160.238.40.255 
	{ 0xa0ee3300, 0xa0ee33ff, REGISTRY_APNIC      }, // 160.238.51.0    - 160.238.51.255 
	{ 0xa0ee3800, 0xa0ee38ff, REGISTRY_APNIC      }, // 160.238.56.0    - 160.238.56.255 
	{ 0xa0ee3e00, 0xa0ee3eff, REGISTRY_APNIC      }, // 160.238.62.0    - 160.238.62.255 
	{ 0xa0ee6400, 0xa0ee64ff, REGISTRY_APNIC      }, // 160.238.100.0   - 160.238.100.255
	{ 0xa0ef0000, 0xa0f1ffff, REGISTRY_APNIC      }, // 160.239.0.0     - 160.241.255.255
	{ 0xa0f30000, 0xa0f9ffff, REGISTRY_APNIC      }, // 160.243.0.0     - 160.249.255.255
	{ 0xa0fb0000, 0xa0fcffff, REGISTRY_APNIC      }, // 160.251.0.0     - 160.252.255.255
	{ 0xa0fd0000, 0xa0feffff, REGISTRY_ARIN       }, // 160.253.0.0     - 160.254.255.255
	{ 0xa0ff0000, 0xa0ffffff, REGISTRY_AFRINIC    }, // 160.255.0.0     - 160.255.255.255
	{ 0xa1000000, 0xa100ffff, REGISTRY_LACNIC     }, // 161.0.0.0       - 161.0.255.255  
	{ 0xa1010000, 0xa101ffff, REGISTRY_ARIN       }, // 161.1.0.0       - 161.1.255.255  
	{ 0xa1020000, 0xa105ffff, REGISTRY_RIPENCC    }, // 161.2.0.0       - 161.5.255.255  
	{ 0xa1060000, 0xa107ffff, REGISTRY_ARIN       }, // 161.6.0.0       - 161.7.255.255  
	{ 0xa1080000, 0xa109ffff, REGISTRY_RIPENCC    }, // 161.8.0.0       - 161.9.255.255  
	{ 0xa10a0000, 0xa10affff, REGISTRY_LACNIC     }, // 161.10.0.0      - 161.10.255.255 
	{ 0xa10b0000, 0xa10bffff, REGISTRY_ARIN       }, // 161.11.0.0      - 161.11.255.255 
	{ 0xa10c0000, 0xa10cffff, REGISTRY_RIPENCC    }, // 161.12.0.0      - 161.12.255.255 
	{ 0xa10d0000, 0xa110ffff, REGISTRY_ARIN       }, // 161.13.0.0      - 161.16.255.255 
	{ 0xa1110000, 0xa111ffff, REGISTRY_RIPENCC    }, // 161.17.0.0      - 161.17.255.255 
	{ 0xa1120000, 0xa112ffff, REGISTRY_LACNIC     }, // 161.18.0.0      - 161.18.255.255 
	{ 0xa1130000, 0xa113ffff, REGISTRY_ARIN       }, // 161.19.0.0      - 161.19.255.255 
	{ 0xa1140000, 0xa114ffff, REGISTRY_RIPENCC    }, // 161.20.0.0      - 161.20.255.255 
	{ 0xa1150000, 0xa115ffff, REGISTRY_ARIN       }, // 161.21.0.0      - 161.21.255.255 
	{ 0xa1160000, 0xa116ffff, REGISTRY_LACNIC     }, // 161.22.0.0      - 161.22.255.255 
	{ 0xa1170000, 0xa117ffff, REGISTRY_RIPENCC    }, // 161.23.0.0      - 161.23.255.255 
	{ 0xa1180000, 0xa119ffff, REGISTRY_LACNIC     }, // 161.24.0.0      - 161.25.255.255 
	{ 0xa11a0000, 0xa11affff, REGISTRY_ARIN       }, // 161.26.0.0      - 161.26.255.255 
	{ 0xa11b0000, 0xa11bffff, REGISTRY_RIPENCC    }, // 161.27.0.0      - 161.27.255.255 
	{ 0xa11c0000, 0xa11cffff, REGISTRY_ARIN       }, // 161.28.0.0      - 161.28.255.255 
	{ 0xa11d0000, 0xa11dffff, REGISTRY_APNIC      }, // 161.29.0.0      - 161.29.255.255 
	{ 0xa11e0000, 0xa11effff, REGISTRY_RIPENCC    }, // 161.30.0.0      - 161.30.255.255 
	{ 0xa11f0000, 0xa124ffff, REGISTRY_ARIN       }, // 161.31.0.0      - 161.36.255.255 
	{ 0xa1250000, 0xa125ffff, REGISTRY_RIPENCC    }, // 161.37.0.0      - 161.37.255.255 
	{ 0xa1260000, 0xa128ffff, REGISTRY_ARIN       }, // 161.38.0.0      - 161.40.255.255 
	{ 0xa1290000, 0xa12affff, REGISTRY_RIPENCC    }, // 161.41.0.0      - 161.42.255.255 
	{ 0xa12b0000, 0xa12bffff, REGISTRY_APNIC      }, // 161.43.0.0      - 161.43.255.255 
	{ 0xa12c0000, 0xa12fffff, REGISTRY_ARIN       }, // 161.44.0.0      - 161.47.255.255 
	{ 0xa1300000, 0xa130ffff, REGISTRY_RIPENCC    }, // 161.48.0.0      - 161.48.255.255 
	{ 0xa1310000, 0xa131ffff, REGISTRY_ARIN       }, // 161.49.0.0      - 161.49.255.255 
	{ 0xa1320000, 0xa132ffff, REGISTRY_APNIC      }, // 161.50.0.0      - 161.50.255.255 
	{ 0xa1330000, 0xa133ffff, REGISTRY_ARIN       }, // 161.51.0.0      - 161.51.255.255 
	{ 0xa1340000, 0xa136ffff, REGISTRY_RIPENCC    }, // 161.52.0.0      - 161.54.255.255 
	{ 0xa1370000, 0xa137ffff, REGISTRY_ARIN       }, // 161.55.0.0      - 161.55.255.255 
	{ 0xa1380000, 0xa138ffff, REGISTRY_LACNIC     }, // 161.56.0.0      - 161.56.255.255 
	{ 0xa1390000, 0xa13affff, REGISTRY_ARIN       }, // 161.57.0.0      - 161.58.255.255 
	{ 0xa13b0000, 0xa13bffff, REGISTRY_RIPENCC    }, // 161.59.0.0      - 161.59.255.255 
	{ 0xa13c0000, 0xa13dffff, REGISTRY_ARIN       }, // 161.60.0.0      - 161.61.255.255 
	{ 0xa13e0000, 0xa13effff, REGISTRY_RIPENCC    }, // 161.62.0.0      - 161.62.255.255 
	{ 0xa13f0000, 0xa13fffff, REGISTRY_ARIN       }, // 161.63.0.0      - 161.63.255.255 
	{ 0xa1400000, 0xa142ffff, REGISTRY_APNIC      }, // 161.64.0.0      - 161.66.255.255 
	{ 0xa1430000, 0xa143ffff, REGISTRY_RIPENCC    }, // 161.67.0.0      - 161.67.255.255 
	{ 0xa1440000, 0xa146ffff, REGISTRY_ARIN       }, // 161.68.0.0      - 161.70.255.255 
	{ 0xa1470000, 0xa14affff, REGISTRY_RIPENCC    }, // 161.71.0.0      - 161.74.255.255 
	{ 0xa14b0000, 0xa14bffff, REGISTRY_APNIC      }, // 161.75.0.0      - 161.75.255.255 
	{ 0xa14c0000, 0xa14cffff, REGISTRY_RIPENCC    }, // 161.76.0.0      - 161.76.255.255 
	{ 0xa14d0000, 0xa14dffff, REGISTRY_ARIN       }, // 161.77.0.0      - 161.77.255.255 
	{ 0xa14e0000, 0xa14effff, REGISTRY_RIPENCC    }, // 161.78.0.0      - 161.78.255.255 
	{ 0xa14f0000, 0xa14fffff, REGISTRY_LACNIC     }, // 161.79.0.0      - 161.79.255.255 
	{ 0xa1500000, 0xa152ffff, REGISTRY_ARIN       }, // 161.80.0.0      - 161.82.255.255 
	{ 0xa1530000, 0xa15cffff, REGISTRY_RIPENCC    }, // 161.83.0.0      - 161.92.255.255 
	{ 0xa15d0000, 0xa160ffff, REGISTRY_APNIC      }, // 161.93.0.0      - 161.96.255.255 
	{ 0xa1610000, 0xa167ffff, REGISTRY_ARIN       }, // 161.97.0.0      - 161.103.255.255
	{ 0xa1680000, 0xa16affff, REGISTRY_RIPENCC    }, // 161.104.0.0     - 161.106.255.255
	{ 0xa16b0000, 0xa16dffff, REGISTRY_ARIN       }, // 161.107.0.0     - 161.109.255.255
	{ 0xa16e0000, 0xa170ffff, REGISTRY_RIPENCC    }, // 161.110.0.0     - 161.112.255.255
	{ 0xa1710000, 0xa173ffff, REGISTRY_ARIN       }, // 161.113.0.0     - 161.115.255.255
	{ 0xa1740000, 0xa174ffff, REGISTRY_RIPENCC    }, // 161.116.0.0     - 161.116.255.255
	{ 0xa1750000, 0xa176ffff, REGISTRY_APNIC      }, // 161.117.0.0     - 161.118.255.255
	{ 0xa1770000, 0xa179ffff, REGISTRY_ARIN       }, // 161.119.0.0     - 161.121.255.255
	{ 0xa17a0000, 0xa17affff, REGISTRY_APNIC      }, // 161.122.0.0     - 161.122.255.255
	{ 0xa17c0000, 0xa17dffff, REGISTRY_ARIN       }, // 161.124.0.0     - 161.125.255.255
	{ 0xa17e0000, 0xa17effff, REGISTRY_APNIC      }, // 161.126.0.0     - 161.126.255.255
	{ 0xa17f0000, 0xa182ffff, REGISTRY_ARIN       }, // 161.127.0.0     - 161.130.255.255
	{ 0xa1830000, 0xa184ffff, REGISTRY_LACNIC     }, // 161.131.0.0     - 161.132.255.255
	{ 0xa1850000, 0xa185ffff, REGISTRY_ARIN       }, // 161.133.0.0     - 161.133.255.255
	{ 0xa1860000, 0xa186ffff, REGISTRY_RIPENCC    }, // 161.134.0.0     - 161.134.255.255
	{ 0xa1870000, 0xa189ffff, REGISTRY_ARIN       }, // 161.135.0.0     - 161.137.255.255
	{ 0xa18a0000, 0xa18affff, REGISTRY_LACNIC     }, // 161.138.0.0     - 161.138.255.255
	{ 0xa18b0000, 0xa18bffff, REGISTRY_APNIC      }, // 161.139.0.0     - 161.139.255.255
	{ 0xa18c0000, 0xa18cffff, REGISTRY_LACNIC     }, // 161.140.0.0     - 161.140.255.255
	{ 0xa18d0000, 0xa18dffff, REGISTRY_ARIN       }, // 161.141.0.0     - 161.141.255.255
	{ 0xa18e0000, 0xa18fffff, REGISTRY_APNIC      }, // 161.142.0.0     - 161.143.255.255
	{ 0xa1900000, 0xa191ffff, REGISTRY_ARIN       }, // 161.144.0.0     - 161.145.255.255
	{ 0xa1920000, 0xa192ffff, REGISTRY_APNIC      }, // 161.146.0.0     - 161.146.255.255
	{ 0xa1930000, 0xa193ffff, REGISTRY_RIPENCC    }, // 161.147.0.0     - 161.147.255.255
	{ 0xa1940000, 0xa194ffff, REGISTRY_LACNIC     }, // 161.148.0.0     - 161.148.255.255
	{ 0xa1950000, 0xa197ffff, REGISTRY_ARIN       }, // 161.149.0.0     - 161.151.255.255
	{ 0xa1980000, 0xa198ffff, REGISTRY_APNIC      }, // 161.152.0.0     - 161.152.255.255
	{ 0xa1990000, 0xa19dffff, REGISTRY_ARIN       }, // 161.153.0.0     - 161.157.255.255
	{ 0xa19e0000, 0xa19effff, REGISTRY_RIPENCC    }, // 161.158.0.0     - 161.158.255.255
	{ 0xa19f0000, 0xa1bdffff, REGISTRY_ARIN       }, // 161.159.0.0     - 161.189.255.255
	{ 0xa1be0000, 0xa1beffff, REGISTRY_LACNIC     }, // 161.190.0.0     - 161.190.255.255
	{ 0xa1bf0000, 0xa1c3ffff, REGISTRY_ARIN       }, // 161.191.0.0     - 161.195.255.255
	{ 0xa1c40000, 0xa1c4ffff, REGISTRY_LACNIC     }, // 161.196.0.0     - 161.196.255.255
	{ 0xa1c50000, 0xa1c7ffff, REGISTRY_ARIN       }, // 161.197.0.0     - 161.199.255.255
	{ 0xa1c80000, 0xa1c8ffff, REGISTRY_APNIC      }, // 161.200.0.0     - 161.200.255.255
	{ 0xa1c90000, 0xa1c9ffff, REGISTRY_ARIN       }, // 161.201.0.0     - 161.201.255.255
	{ 0xa1ca0000, 0xa1caffff, REGISTRY_RIPENCC    }, // 161.202.0.0     - 161.202.255.255
	{ 0xa1cb0000, 0xa1ceffff, REGISTRY_ARIN       }, // 161.203.0.0     - 161.206.255.255
	{ 0xa1cf0000, 0xa1cfffff, REGISTRY_APNIC      }, // 161.207.0.0     - 161.207.255.255
	{ 0xa1d00000, 0xa1d3ffff, REGISTRY_ARIN       }, // 161.208.0.0     - 161.211.255.255
	{ 0xa1d40000, 0xa1d4ffff, REGISTRY_LACNIC     }, // 161.212.0.0     - 161.212.255.255
	{ 0xa1d50000, 0xa1d9ffff, REGISTRY_ARIN       }, // 161.213.0.0     - 161.217.255.255
	{ 0xa1da0000, 0xa1daffff, REGISTRY_RIPENCC    }, // 161.218.0.0     - 161.218.255.255
	{ 0xa1db0000, 0xa1e4ffff, REGISTRY_ARIN       }, // 161.219.0.0     - 161.228.255.255
	{ 0xa1e50000, 0xa1e5ffff, REGISTRY_APNIC      }, // 161.229.0.0     - 161.229.255.255
	{ 0xa1e60000, 0xa1e9ffff, REGISTRY_ARIN       }, // 161.230.0.0     - 161.233.255.255
	{ 0xa1ea0000, 0xa1eaffff, REGISTRY_LACNIC     }, // 161.234.0.0     - 161.234.255.255
	{ 0xa1eb0000, 0xa1edffff, REGISTRY_ARIN       }, // 161.235.0.0     - 161.237.255.255
	{ 0xa1ee0000, 0xa1eeffff, REGISTRY_LACNIC     }, // 161.238.0.0     - 161.238.255.255
	{ 0xa1ef0000, 0xa1f5ffff, REGISTRY_ARIN       }, // 161.239.0.0     - 161.245.255.255
	{ 0xa1f60000, 0xa1f6ffff, REGISTRY_APNIC      }, // 161.246.0.0     - 161.246.255.255
	{ 0xa1f70000, 0xa1f7ffff, REGISTRY_ARIN       }, // 161.247.0.0     - 161.247.255.255
	{ 0xa1f90000, 0xa1fbffff, REGISTRY_ARIN       }, // 161.249.0.0     - 161.251.255.255
	{ 0xa1fc0000, 0xa1fcffff, REGISTRY_RIPENCC    }, // 161.252.0.0     - 161.252.255.255
	{ 0xa1fd0000, 0xa1feffff, REGISTRY_ARIN       }, // 161.253.0.0     - 161.254.255.255
	{ 0xa1ff0000, 0xa1ffffff, REGISTRY_LACNIC     }, // 161.255.0.0     - 161.255.255.255
	{ 0xa2000000, 0xa203ffff, REGISTRY_ARIN       }, // 162.0.0.0       - 162.3.255.255  
	{ 0xa2050000, 0xa20affff, REGISTRY_ARIN       }, // 162.5.0.0       - 162.10.255.255 
	{ 0xa20b0000, 0xa20bffff, REGISTRY_RIPENCC    }, // 162.11.0.0      - 162.11.255.255 
	{ 0xa20c0000, 0xa20cc3ff, REGISTRY_ARIN       }, // 162.12.0.0      - 162.12.195.255 
	{ 0xa20cdc00, 0xa20cdfff, REGISTRY_ARIN       }, // 162.12.220.0    - 162.12.223.255 
	{ 0xa20cec00, 0xa20cefff, REGISTRY_ARIN       }, // 162.12.236.0    - 162.12.239.255 
	{ 0xa20cf800, 0xa20cffff, REGISTRY_ARIN       }, // 162.12.248.0    - 162.12.255.255 
	{ 0xa20d0000, 0xa20dffff, REGISTRY_RIPENCC    }, // 162.13.0.0      - 162.13.255.255 
	{ 0xa20e0000, 0xa214ffff, REGISTRY_ARIN       }, // 162.14.0.0      - 162.20.255.255 
	{ 0xa2150000, 0xa215ffff, REGISTRY_RIPENCC    }, // 162.21.0.0      - 162.21.255.255 
	{ 0xa2160000, 0xa216ffff, REGISTRY_ARIN       }, // 162.22.0.0      - 162.22.255.255 
	{ 0xa2170000, 0xa217ffff, REGISTRY_RIPENCC    }, // 162.23.0.0      - 162.23.255.255 
	{ 0xa2180000, 0xa218ffff, REGISTRY_ARIN       }, // 162.24.0.0      - 162.24.255.255 
	{ 0xa2190000, 0xa21affff, REGISTRY_RIPENCC    }, // 162.25.0.0      - 162.26.255.255 
	{ 0xa21b0000, 0xa225ffff, REGISTRY_ARIN       }, // 162.27.0.0      - 162.37.255.255 
	{ 0xa2260000, 0xa226ffff, REGISTRY_RIPENCC    }, // 162.38.0.0      - 162.38.255.255 
	{ 0xa2270000, 0xa237ffff, REGISTRY_ARIN       }, // 162.39.0.0      - 162.55.255.255 
	{ 0xa2380000, 0xa238ffff, REGISTRY_APNIC      }, // 162.56.0.0      - 162.56.255.255 
	{ 0xa2390000, 0xa255ffff, REGISTRY_ARIN       }, // 162.57.0.0      - 162.85.255.255 
	{ 0xa2560000, 0xa256ffff, REGISTRY_RIPENCC    }, // 162.86.0.0      - 162.86.255.255 
	{ 0xa2570000, 0xa268ffff, REGISTRY_ARIN       }, // 162.87.0.0      - 162.104.255.255
	{ 0xa2690000, 0xa269ffff, REGISTRY_APNIC      }, // 162.105.0.0     - 162.105.255.255
	{ 0xa26a0000, 0xa26fffff, REGISTRY_ARIN       }, // 162.106.0.0     - 162.111.255.255
	{ 0xa2700000, 0xa270ffff, REGISTRY_APNIC      }, // 162.112.0.0     - 162.112.255.255
	{ 0xa2710000, 0xa279ffff, REGISTRY_ARIN       }, // 162.113.0.0     - 162.121.255.255
	{ 0xa27a0000, 0xa27affff, REGISTRY_LACNIC     }, // 162.122.0.0     - 162.122.255.255
	{ 0xa27b0000, 0xa290ffff, REGISTRY_ARIN       }, // 162.123.0.0     - 162.144.255.255
	{ 0xa2910000, 0xa293ffff, REGISTRY_APNIC      }, // 162.145.0.0     - 162.147.255.255
	{ 0xa2940000, 0xa2ffffff, REGISTRY_ARIN       }, // 162.148.0.0     - 162.255.255.255
	{ 0xa3000000, 0xa300ffff, REGISTRY_APNIC      }, // 163.0.0.0       - 163.0.255.255  
	{ 0xa3010000, 0xa301ffff, REGISTRY_RIPENCC    }, // 163.1.0.0       - 163.1.255.255  
	{ 0xa3020000, 0xa302ffff, REGISTRY_ARIN       }, // 163.2.0.0       - 163.2.255.255  
	{ 0xa3030000, 0xa303ffff, REGISTRY_RIPENCC    }, // 163.3.0.0       - 163.3.255.255  
	{ 0xa3040000, 0xa304ffff, REGISTRY_ARIN       }, // 163.4.0.0       - 163.4.255.255  
	{ 0xa3050000, 0xa305ffff, REGISTRY_RIPENCC    }, // 163.5.0.0       - 163.5.255.255  
	{ 0xa3060000, 0xa306ffff, REGISTRY_ARIN       }, // 163.6.0.0       - 163.6.255.255  
	{ 0xa3070000, 0xa308ffff, REGISTRY_APNIC      }, // 163.7.0.0       - 163.8.255.255  
	{ 0xa3090000, 0xa309ffff, REGISTRY_RIPENCC    }, // 163.9.0.0       - 163.9.255.255  
	{ 0xa30a0000, 0xa30affff, REGISTRY_LACNIC     }, // 163.10.0.0      - 163.10.255.255 
	{ 0xa30b0000, 0xa30cffff, REGISTRY_ARIN       }, // 163.11.0.0      - 163.12.255.255 
	{ 0xa30d0000, 0xa320ffff, REGISTRY_APNIC      }, // 163.13.0.0      - 163.32.255.255 
	{ 0xa3210000, 0xa321ffff, REGISTRY_ARIN       }, // 163.33.0.0      - 163.33.255.255 
	{ 0xa3220000, 0xa322ffff, REGISTRY_RIPENCC    }, // 163.34.0.0      - 163.34.255.255 
	{ 0xa3230000, 0xa329ffff, REGISTRY_ARIN       }, // 163.35.0.0      - 163.41.255.255 
	{ 0xa32a0000, 0xa32f15ff, REGISTRY_APNIC      }, // 163.42.0.0      - 163.47.21.255  
	{ 0xa32f1800, 0xa32f18ff, REGISTRY_APNIC      }, // 163.47.24.0     - 163.47.24.255  
	{ 0xa32f1d00, 0xa32f1dff, REGISTRY_APNIC      }, // 163.47.29.0     - 163.47.29.255  
	{ 0xa32f2000, 0xa32f2dff, REGISTRY_APNIC      }, // 163.47.32.0     - 163.47.45.255  
	{ 0xa32f2f00, 0xa333ffff, REGISTRY_APNIC      }, // 163.47.47.0     - 163.51.255.255 
	{ 0xa3350000, 0xa338ffff, REGISTRY_APNIC      }, // 163.53.0.0      - 163.56.255.255 
	{ 0xa33a0000, 0xa33cffff, REGISTRY_APNIC      }, // 163.58.0.0      - 163.60.255.255 
	{ 0xa33e0000, 0xa375ffff, REGISTRY_RIPENCC    }, // 163.62.0.0      - 163.117.255.255
	{ 0xa3760000, 0xa376ffff, REGISTRY_ARIN       }, // 163.118.0.0     - 163.118.255.255
	{ 0xa3770000, 0xa377ffff, REGISTRY_RIPENCC    }, // 163.119.0.0     - 163.119.255.255
	{ 0xa3780000, 0xa378ffff, REGISTRY_ARIN       }, // 163.120.0.0     - 163.120.255.255
	{ 0xa3790000, 0xa379ffff, REGISTRY_AFRINIC    }, // 163.121.0.0     - 163.121.255.255
	{ 0xa37a0000, 0xa37affff, REGISTRY_APNIC      }, // 163.122.0.0     - 163.122.255.255
	{ 0xa37b0000, 0xa37cffff, REGISTRY_ARIN       }, // 163.123.0.0     - 163.124.255.255
	{ 0xa37d0000, 0xa37dffff, REGISTRY_APNIC      }, // 163.125.0.0     - 163.125.255.255
	{ 0xa37e0000, 0xa37effff, REGISTRY_ARIN       }, // 163.126.0.0     - 163.126.255.255
	{ 0xa3810000, 0xa381ffff, REGISTRY_ARIN       }, // 163.129.0.0     - 163.129.255.255
	{ 0xa3820000, 0xa395ffff, REGISTRY_APNIC      }, // 163.130.0.0     - 163.149.255.255
	{ 0xa3960000, 0xa397ffff, REGISTRY_ARIN       }, // 163.150.0.0     - 163.151.255.255
	{ 0xa3980000, 0xa398ffff, REGISTRY_APNIC      }, // 163.152.0.0     - 163.152.255.255
	{ 0xa3990000, 0xa39bffff, REGISTRY_ARIN       }, // 163.153.0.0     - 163.155.255.255
	{ 0xa39c0000, 0xa3afffff, REGISTRY_RIPENCC    }, // 163.156.0.0     - 163.175.255.255
	{ 0xa3b00000, 0xa3b0ffff, REGISTRY_ARIN       }, // 163.176.0.0     - 163.176.255.255
	{ 0xa3b10000, 0xa3b1ffff, REGISTRY_APNIC      }, // 163.177.0.0     - 163.177.255.255
	{ 0xa3b20000, 0xa3b2ffff, REGISTRY_LACNIC     }, // 163.178.0.0     - 163.178.255.255
	{ 0xa3b30000, 0xa3b4ffff, REGISTRY_APNIC      }, // 163.179.0.0     - 163.180.255.255
	{ 0xa3b50000, 0xa3bcffff, REGISTRY_ARIN       }, // 163.181.0.0     - 163.188.255.255
	{ 0xa3bd0000, 0xa3bdffff, REGISTRY_APNIC      }, // 163.189.0.0     - 163.189.255.255
	{ 0xa3be0000, 0xa3c2ffff, REGISTRY_ARIN       }, // 163.190.0.0     - 163.194.255.255
	{ 0xa3c30000, 0xa3cbffff, REGISTRY_AFRINIC    }, // 163.195.0.0     - 163.203.255.255
	{ 0xa3cc0000, 0xa3ccffff, REGISTRY_APNIC      }, // 163.204.0.0     - 163.204.255.255
	{ 0xa3cd0000, 0xa3cfffff, REGISTRY_ARIN       }, // 163.205.0.0     - 163.207.255.255
	{ 0xa3d00000, 0xa3d7ffff, REGISTRY_APNIC      }, // 163.208.0.0     - 163.215.255.255
	{ 0xa3d90000, 0xa3e2ffff, REGISTRY_APNIC      }, // 163.217.0.0     - 163.226.255.255
	{ 0xa3e30100, 0xa3e301ff, REGISTRY_APNIC      }, // 163.227.1.0     - 163.227.1.255  
	{ 0xa3e31100, 0xa3e311ff, REGISTRY_APNIC      }, // 163.227.17.0    - 163.227.17.255 
	{ 0xa3e37d00, 0xa3e37dff, REGISTRY_APNIC      }, // 163.227.125.0   - 163.227.125.255
	{ 0xa3e3dd00, 0xa3e3ddff, REGISTRY_APNIC      }, // 163.227.221.0   - 163.227.221.255
	{ 0xa3e3e100, 0xa3e3e3ff, REGISTRY_APNIC      }, // 163.227.225.0   - 163.227.227.255
	{ 0xa3e3e900, 0xa3e3eaff, REGISTRY_APNIC      }, // 163.227.233.0   - 163.227.234.255
	{ 0xa3e3f100, 0xa3e3f3ff, REGISTRY_APNIC      }, // 163.227.241.0   - 163.227.243.255
	{ 0xa3e3fe00, 0xa3e3feff, REGISTRY_APNIC      }, // 163.227.254.0   - 163.227.254.255
	{ 0xa3e40000, 0xa3e4ffff, REGISTRY_ARIN       }, // 163.228.0.0     - 163.228.255.255
	{ 0xa3e50000, 0xa3e5ffff, REGISTRY_APNIC      }, // 163.229.0.0     - 163.229.255.255
	{ 0xa3e60000, 0xa3e7ffff, REGISTRY_ARIN       }, // 163.230.0.0     - 163.231.255.255
	{ 0xa3e80000, 0xa3e9ffff, REGISTRY_APNIC      }, // 163.232.0.0     - 163.233.255.255
	{ 0xa3ea0000, 0xa3eeffff, REGISTRY_ARIN       }, // 163.234.0.0     - 163.238.255.255
	{ 0xa3ef0000, 0xa3efffff, REGISTRY_APNIC      }, // 163.239.0.0     - 163.239.255.255
	{ 0xa3f00000, 0xa3f1ffff, REGISTRY_ARIN       }, // 163.240.0.0     - 163.241.255.255
	{ 0xa3f20000, 0xa3f2ffff, REGISTRY_RIPENCC    }, // 163.242.0.0     - 163.242.255.255
	{ 0xa3f30000, 0xa3f6ffff, REGISTRY_ARIN       }, // 163.243.0.0     - 163.246.255.255
	{ 0xa3f70000, 0xa3f7ffff, REGISTRY_LACNIC     }, // 163.247.0.0     - 163.247.255.255
	{ 0xa3f80000, 0xa3f9ffff, REGISTRY_ARIN       }, // 163.248.0.0     - 163.249.255.255
	{ 0xa3fa0000, 0xa3faffff, REGISTRY_LACNIC     }, // 163.250.0.0     - 163.250.255.255
	{ 0xa3fb0000, 0xa3feffff, REGISTRY_ARIN       }, // 163.251.0.0     - 163.254.255.255
	{ 0xa3ff0000, 0xa3ffffff, REGISTRY_APNIC      }, // 163.255.0.0     - 163.255.255.255
	{ 0xa4000000, 0xa400ffff, REGISTRY_RIPENCC    }, // 164.0.0.0       - 164.0.255.255  
	{ 0xa4010000, 0xa40fffff, REGISTRY_RIPENCC    }, // 164.1.0.0       - 164.15.255.255 
	{ 0xa4100000, 0xa422ffff, REGISTRY_RIPENCC    }, // 164.16.0.0      - 164.34.255.255 
	{ 0xa4230000, 0xa427ffff, REGISTRY_RIPENCC    }, // 164.35.0.0      - 164.39.255.255 
	{ 0xa4280000, 0xa428b7ff, REGISTRY_RIPENCC    }, // 164.40.0.0      - 164.40.183.255 
	{ 0xa428c000, 0xa428ffff, REGISTRY_RIPENCC    }, // 164.40.192.0    - 164.40.255.255 
	{ 0xa4290000, 0xa429ffff, REGISTRY_LACNIC     }, // 164.41.0.0      - 164.41.255.255 
	{ 0xa42a0000, 0xa42affff, REGISTRY_ARIN       }, // 164.42.0.0      - 164.42.255.255 
	{ 0xa42b0000, 0xa42bffff, REGISTRY_APNIC      }, // 164.43.0.0      - 164.43.255.255 
	{ 0xa42c0000, 0xa42dffff, REGISTRY_ARIN       }, // 164.44.0.0      - 164.45.255.255 
	{ 0xa42e0000, 0xa42effff, REGISTRY_APNIC      }, // 164.46.0.0      - 164.46.255.255 
	{ 0xa42f0000, 0xa42fffff, REGISTRY_ARIN       }, // 164.47.0.0      - 164.47.255.255 
	{ 0xa4300000, 0xa430ffff, REGISTRY_RIPENCC    }, // 164.48.0.0      - 164.48.255.255 
	{ 0xa4310000, 0xa434ffff, REGISTRY_ARIN       }, // 164.49.0.0      - 164.52.255.255 
	{ 0xa4350000, 0xa435ffff, REGISTRY_APNIC      }, // 164.53.0.0      - 164.53.255.255 
	{ 0xa4360000, 0xa43affff, REGISTRY_ARIN       }, // 164.54.0.0      - 164.58.255.255 
	{ 0xa43b0000, 0xa43dffff, REGISTRY_RIPENCC    }, // 164.59.0.0      - 164.61.255.255 
	{ 0xa43e0000, 0xa444ffff, REGISTRY_ARIN       }, // 164.62.0.0      - 164.68.255.255 
	{ 0xa4450000, 0xa447ffff, REGISTRY_APNIC      }, // 164.69.0.0      - 164.71.255.255 
	{ 0xa4480000, 0xa448ffff, REGISTRY_ARIN       }, // 164.72.0.0      - 164.72.255.255 
	{ 0xa4490000, 0xa449ffff, REGISTRY_LACNIC     }, // 164.73.0.0      - 164.73.255.255 
	{ 0xa44a0000, 0xa44affff, REGISTRY_ARIN       }, // 164.74.0.0      - 164.74.255.255 
	{ 0xa44b0000, 0xa44bffff, REGISTRY_APNIC      }, // 164.75.0.0      - 164.75.255.255 
	{ 0xa44c0000, 0xa44cffff, REGISTRY_ARIN       }, // 164.76.0.0      - 164.76.255.255 
	{ 0xa44d0000, 0xa44dffff, REGISTRY_LACNIC     }, // 164.77.0.0      - 164.77.255.255 
	{ 0xa44e0000, 0xa44effff, REGISTRY_APNIC      }, // 164.78.0.0      - 164.78.255.255 
	{ 0xa44f0000, 0xa44fffff, REGISTRY_ARIN       }, // 164.79.0.0      - 164.79.255.255 
	{ 0xa4500000, 0xa450ffff, REGISTRY_APNIC      }, // 164.80.0.0      - 164.80.255.255 
	{ 0xa4510000, 0xa451ffff, REGISTRY_RIPENCC    }, // 164.81.0.0      - 164.81.255.255 
	{ 0xa4520000, 0xa454ffff, REGISTRY_ARIN       }, // 164.82.0.0      - 164.84.255.255 
	{ 0xa4550000, 0xa455ffff, REGISTRY_LACNIC     }, // 164.85.0.0      - 164.85.255.255 
	{ 0xa4560000, 0xa457ffff, REGISTRY_ARIN       }, // 164.86.0.0      - 164.87.255.255 
	{ 0xa4580000, 0xa458ffff, REGISTRY_AFRINIC    }, // 164.88.0.0      - 164.88.255.255 
	{ 0xa4590000, 0xa45fffff, REGISTRY_ARIN       }, // 164.89.0.0      - 164.95.255.255 
	{ 0xa4600000, 0xa460ffff, REGISTRY_LACNIC     }, // 164.96.0.0      - 164.96.255.255 
	{ 0xa4610000, 0xa461ffff, REGISTRY_APNIC      }, // 164.97.0.0      - 164.97.255.255 
	{ 0xa4620000, 0xa462ffff, REGISTRY_LACNIC     }, // 164.98.0.0      - 164.98.255.255 
	{ 0xa4630000, 0xa463ffff, REGISTRY_ARIN       }, // 164.99.0.0      - 164.99.255.255 
	{ 0xa4640000, 0xa464ffff, REGISTRY_APNIC      }, // 164.100.0.0     - 164.100.255.255
	{ 0xa4650000, 0xa46bffff, REGISTRY_ARIN       }, // 164.101.0.0     - 164.107.255.255
	{ 0xa46c0000, 0xa46cffff, REGISTRY_APNIC      }, // 164.108.0.0     - 164.108.255.255
	{ 0xa46d0000, 0xa46fffff, REGISTRY_ARIN       }, // 164.109.0.0     - 164.111.255.255
	{ 0xa4700000, 0xa470ffff, REGISTRY_APNIC      }, // 164.112.0.0     - 164.112.255.255
	{ 0xa4710000, 0xa472ffff, REGISTRY_ARIN       }, // 164.113.0.0     - 164.114.255.255
	{ 0xa4730000, 0xa473ffff, REGISTRY_APNIC      }, // 164.115.0.0     - 164.115.255.255
	{ 0xa4740000, 0xa47bffff, REGISTRY_ARIN       }, // 164.116.0.0     - 164.123.255.255
	{ 0xa47c0000, 0xa47dffff, REGISTRY_APNIC      }, // 164.124.0.0     - 164.125.255.255
	{ 0xa47e0000, 0xa480ffff, REGISTRY_RIPENCC    }, // 164.126.0.0     - 164.128.255.255
	{ 0xa4810000, 0xa489ffff, REGISTRY_RIPENCC    }, // 164.129.0.0     - 164.137.255.255
	{ 0xa48a0000, 0xa48a5fff, REGISTRY_RIPENCC    }, // 164.138.0.0     - 164.138.95.255 
	{ 0xa48a6800, 0xa48affff, REGISTRY_RIPENCC    }, // 164.138.104.0   - 164.138.255.255
	{ 0xa48b0000, 0xa48fffff, REGISTRY_RIPENCC    }, // 164.139.0.0     - 164.143.255.255
	{ 0xa4900000, 0xa491ffff, REGISTRY_ARIN       }, // 164.144.0.0     - 164.145.255.255
	{ 0xa4920000, 0xa497ffff, REGISTRY_AFRINIC    }, // 164.146.0.0     - 164.151.255.255
	{ 0xa4980000, 0xa49affff, REGISTRY_ARIN       }, // 164.152.0.0     - 164.154.255.255
	{ 0xa49b0000, 0xa49bffff, REGISTRY_AFRINIC    }, // 164.155.0.0     - 164.155.255.255
	{ 0xa49c0000, 0xa49fffff, REGISTRY_ARIN       }, // 164.156.0.0     - 164.159.255.255
	{ 0xa4a10000, 0xa4a2ffff, REGISTRY_APNIC      }, // 164.161.0.0     - 164.162.255.255
	{ 0xa4a40000, 0xa4a4ffff, REGISTRY_APNIC      }, // 164.164.0.0     - 164.164.255.255
	{ 0xa4a50000, 0xa4b0ffff, REGISTRY_ARIN       }, // 164.165.0.0     - 164.176.255.255
	{ 0xa4b10000, 0xa4b1ffff, REGISTRY_RIPENCC    }, // 164.177.0.0     - 164.177.255.255
	{ 0xa4b20000, 0xa4d6ffff, REGISTRY_ARIN       }, // 164.178.0.0     - 164.214.255.255
	{ 0xa4d70000, 0xa4d7ffff, REGISTRY_RIPENCC    }, // 164.215.0.0     - 164.215.255.255
	{ 0xa4d80000, 0xa4ffffff, REGISTRY_ARIN       }, // 164.216.0.0     - 164.255.255.255
	{ 0xa5010000, 0xa502ffff, REGISTRY_ARIN       }, // 165.1.0.0       - 165.2.255.255  
	{ 0xa5030000, 0xa505ffff, REGISTRY_AFRINIC    }, // 165.3.0.0       - 165.5.255.255  
	{ 0xa5060000, 0xa507ffff, REGISTRY_ARIN       }, // 165.6.0.0       - 165.7.255.255  
	{ 0xa5080000, 0xa50bffff, REGISTRY_AFRINIC    }, // 165.8.0.0       - 165.11.255.255 
	{ 0xa50c0000, 0xa50cffff, REGISTRY_APNIC      }, // 165.12.0.0      - 165.12.255.255 
	{ 0xa50d0000, 0xa50dffff, REGISTRY_ARIN       }, // 165.13.0.0      - 165.13.255.255 
	{ 0xa50e0000, 0xa50effff, REGISTRY_APNIC      }, // 165.14.0.0      - 165.14.255.255 
	{ 0xa5130000, 0xa514ffff, REGISTRY_ARIN       }, // 165.19.0.0      - 165.20.255.255 
	{ 0xa5150000, 0xa515ffff, REGISTRY_APNIC      }, // 165.21.0.0      - 165.21.255.255 
	{ 0xa5160000, 0xa518ffff, REGISTRY_ARIN       }, // 165.22.0.0      - 165.24.255.255 
	{ 0xa5190000, 0xa519ffff, REGISTRY_AFRINIC    }, // 165.25.0.0      - 165.25.255.255 
	{ 0xa51a0000, 0xa51effff, REGISTRY_ARIN       }, // 165.26.0.0      - 165.30.255.255 
	{ 0xa51f0000, 0xa51fffff, REGISTRY_APNIC      }, // 165.31.0.0      - 165.31.255.255 
	{ 0xa5200000, 0xa529ffff, REGISTRY_ARIN       }, // 165.32.0.0      - 165.41.255.255 
	{ 0xa52a0000, 0xa52bffff, REGISTRY_APNIC      }, // 165.42.0.0      - 165.43.255.255 
	{ 0xa52c0000, 0xa530ffff, REGISTRY_ARIN       }, // 165.44.0.0      - 165.48.255.255 
	{ 0xa5340000, 0xa537ffff, REGISTRY_AFRINIC    }, // 165.52.0.0      - 165.55.255.255 
	{ 0xa5400000, 0xa542ffff, REGISTRY_ARIN       }, // 165.64.0.0      - 165.66.255.255 
	{ 0xa5440000, 0xa544ffff, REGISTRY_ARIN       }, // 165.68.0.0      - 165.68.255.255 
	{ 0xa5450000, 0xa545ffff, REGISTRY_APNIC      }, // 165.69.0.0      - 165.69.255.255 
	{ 0xa5460000, 0xa548ffff, REGISTRY_ARIN       }, // 165.70.0.0      - 165.72.255.255 
	{ 0xa54a0000, 0xa54bffff, REGISTRY_ARIN       }, // 165.74.0.0      - 165.75.255.255 
	{ 0xa54c0000, 0xa54cffff, REGISTRY_APNIC      }, // 165.76.0.0      - 165.76.255.255 
	{ 0xa54d0000, 0xa553ffff, REGISTRY_ARIN       }, // 165.77.0.0      - 165.83.255.255 
	{ 0xa5540000, 0xa554ffff, REGISTRY_APNIC      }, // 165.84.0.0      - 165.84.255.255 
	{ 0xa5550000, 0xa555ffff, REGISTRY_ARIN       }, // 165.85.0.0      - 165.85.255.255 
	{ 0xa5560000, 0xa556ffff, REGISTRY_APNIC      }, // 165.86.0.0      - 165.86.255.255 
	{ 0xa5570000, 0xa559ffff, REGISTRY_ARIN       }, // 165.87.0.0      - 165.89.255.255 
	{ 0xa55b0000, 0xa55cffff, REGISTRY_ARIN       }, // 165.91.0.0      - 165.92.255.255 
	{ 0xa55d0000, 0xa55dffff, REGISTRY_APNIC      }, // 165.93.0.0      - 165.93.255.255 
	{ 0xa55e0000, 0xa55fffff, REGISTRY_ARIN       }, // 165.94.0.0      - 165.95.255.255 
	{ 0xa5600000, 0xa560ffff, REGISTRY_APNIC      }, // 165.96.0.0      - 165.96.255.255 
	{ 0xa5610000, 0xa561ffff, REGISTRY_ARIN       }, // 165.97.0.0      - 165.97.255.255 
	{ 0xa5620000, 0xa562ffff, REGISTRY_LACNIC     }, // 165.98.0.0      - 165.98.255.255 
	{ 0xa5630000, 0xa56503ff, REGISTRY_APNIC      }, // 165.99.0.0      - 165.101.3.255  
	{ 0xa5660000, 0xa566ffff, REGISTRY_APNIC      }, // 165.102.0.0     - 165.102.255.255
	{ 0xa5670000, 0xa56bffff, REGISTRY_ARIN       }, // 165.103.0.0     - 165.107.255.255
	{ 0xa56c0000, 0xa56cffff, REGISTRY_APNIC      }, // 165.108.0.0     - 165.108.255.255
	{ 0xa56d0000, 0xa571ffff, REGISTRY_ARIN       }, // 165.109.0.0     - 165.113.255.255
	{ 0xa5720000, 0xa572ffff, REGISTRY_RIPENCC    }, // 165.114.0.0     - 165.114.255.255
	{ 0xa5730000, 0xa575ffff, REGISTRY_ARIN       }, // 165.115.0.0     - 165.117.255.255
	{ 0xa5760000, 0xa576ffff, REGISTRY_APNIC      }, // 165.118.0.0     - 165.118.255.255
	{ 0xa5770000, 0xa583ffff, REGISTRY_ARIN       }, // 165.119.0.0     - 165.131.255.255
	{ 0xa5840000, 0xa585ffff, REGISTRY_APNIC      }, // 165.132.0.0     - 165.133.255.255
	{ 0xa5860000, 0xa58cffff, REGISTRY_ARIN       }, // 165.134.0.0     - 165.140.255.255
	{ 0xa58d0000, 0xa58effff, REGISTRY_APNIC      }, // 165.141.0.0     - 165.142.255.255
	{ 0xa58f0000, 0xa595ffff, REGISTRY_AFRINIC    }, // 165.143.0.0     - 165.149.255.255
	{ 0xa5960000, 0xa5a4ffff, REGISTRY_ARIN       }, // 165.150.0.0     - 165.164.255.255
	{ 0xa5a50000, 0xa5a5ffff, REGISTRY_AFRINIC    }, // 165.165.0.0     - 165.165.255.255
	{ 0xa5a60000, 0xa5a8ffff, REGISTRY_ARIN       }, // 165.166.0.0     - 165.168.255.255
	{ 0xa5aa0000, 0xa5b3ffff, REGISTRY_ARIN       }, // 165.170.0.0     - 165.179.255.255
	{ 0xa5b40000, 0xa5b4ffff, REGISTRY_AFRINIC    }, // 165.180.0.0     - 165.180.255.255
	{ 0xa5b50000, 0xa5b5ffff, REGISTRY_ARIN       }, // 165.181.0.0     - 165.181.255.255
	{ 0xa5b60000, 0xa5b7ffff, REGISTRY_LACNIC     }, // 165.182.0.0     - 165.183.255.255
	{ 0xa5b80000, 0xa5b9ffff, REGISTRY_ARIN       }, // 165.184.0.0     - 165.185.255.255
	{ 0xa5ba0000, 0xa5bbffff, REGISTRY_APNIC      }, // 165.186.0.0     - 165.187.255.255
	{ 0xa5bc0000, 0xa5beffff, REGISTRY_ARIN       }, // 165.188.0.0     - 165.190.255.255
	{ 0xa5bf0000, 0xa5bfffff, REGISTRY_APNIC      }, // 165.191.0.0     - 165.191.255.255
	{ 0xa5c00000, 0xa5c1ffff, REGISTRY_ARIN       }, // 165.192.0.0     - 165.193.255.255
	{ 0xa5c20000, 0xa5c2ffff, REGISTRY_APNIC      }, // 165.194.0.0     - 165.194.255.255
	{ 0xa5c30000, 0xa5c9ffff, REGISTRY_ARIN       }, // 165.195.0.0     - 165.201.255.255
	{ 0xa5ca0000, 0xa5caffff, REGISTRY_APNIC      }, // 165.202.0.0     - 165.202.255.255
	{ 0xa5cb0000, 0xa5ccffff, REGISTRY_ARIN       }, // 165.203.0.0     - 165.204.255.255
	{ 0xa5cd0000, 0xa5cdffff, REGISTRY_APNIC      }, // 165.205.0.0     - 165.205.255.255
	{ 0xa5ce0000, 0xa5d0ffff, REGISTRY_ARIN       }, // 165.206.0.0     - 165.208.255.255
	{ 0xa5d10000, 0xa5d1ffff, REGISTRY_APNIC      }, // 165.209.0.0     - 165.209.255.255
	{ 0xa5d40000, 0xa5d4ffff, REGISTRY_ARIN       }, // 165.212.0.0     - 165.212.255.255
	{ 0xa5d50000, 0xa5d5ffff, REGISTRY_APNIC      }, // 165.213.0.0     - 165.213.255.255
	{ 0xa5d60000, 0xa5d9ffff, REGISTRY_ARIN       }, // 165.214.0.0     - 165.217.255.255
	{ 0xa5da0000, 0xa5daffff, REGISTRY_RIPENCC    }, // 165.218.0.0     - 165.218.255.255
	{ 0xa5db0000, 0xa5dbffff, REGISTRY_ARIN       }, // 165.219.0.0     - 165.219.255.255
	{ 0xa5dc0000, 0xa5dcffff, REGISTRY_APNIC      }, // 165.220.0.0     - 165.220.255.255
	{ 0xa5dd0000, 0xa5ddffff, REGISTRY_ARIN       }, // 165.221.0.0     - 165.221.255.255
	{ 0xa5de0000, 0xa5deffff, REGISTRY_RIPENCC    }, // 165.222.0.0     - 165.222.255.255
	{ 0xa5df0000, 0xa5e3ffff, REGISTRY_ARIN       }, // 165.223.0.0     - 165.227.255.255
	{ 0xa5e40000, 0xa5e5ffff, REGISTRY_APNIC      }, // 165.228.0.0     - 165.229.255.255
	{ 0xa5e60000, 0xa5e6ffff, REGISTRY_ARIN       }, // 165.230.0.0     - 165.230.255.255
	{ 0xa5e70000, 0xa5e7ffff, REGISTRY_AFRINIC    }, // 165.231.0.0     - 165.231.255.255
	{ 0xa5e80000, 0xa5e8ffff, REGISTRY_ARIN       }, // 165.232.0.0     - 165.232.255.255
	{ 0xa5e90000, 0xa5e9ffff, REGISTRY_AFRINIC    }, // 165.233.0.0     - 165.233.255.255
	{ 0xa5ea0000, 0xa5efffff, REGISTRY_ARIN       }, // 165.234.0.0     - 165.239.255.255
	{ 0xa5f00000, 0xa5f4ffff, REGISTRY_APNIC      }, // 165.240.0.0     - 165.244.255.255
	{ 0xa5f50000, 0xa5f5ffff, REGISTRY_ARIN       }, // 165.245.0.0     - 165.245.255.255
	{ 0xa5f60000, 0xa5f6ffff, REGISTRY_APNIC      }, // 165.246.0.0     - 165.246.255.255
	{ 0xa5f70000, 0xa5feffff, REGISTRY_ARIN       }, // 165.247.0.0     - 165.254.255.255
	{ 0xa6000000, 0xa607ffff, REGISTRY_ARIN       }, // 166.0.0.0       - 166.7.255.255  
	{ 0xa6080000, 0xa60fffff, REGISTRY_RIPENCC    }, // 166.8.0.0       - 166.15.255.255 
	{ 0xa6100000, 0xa6317fff, REGISTRY_ARIN       }, // 166.16.0.0      - 166.49.127.255 
	{ 0xa6318000, 0xa631ffff, REGISTRY_RIPENCC    }, // 166.49.128.0    - 166.49.255.255 
	{ 0xa6320000, 0xa63fffff, REGISTRY_ARIN       }, // 166.50.0.0      - 166.63.255.255 
	{ 0xa6400000, 0xa641ffff, REGISTRY_APNIC      }, // 166.64.0.0      - 166.65.255.255 
	{ 0xa6420000, 0xa64affff, REGISTRY_ARIN       }, // 166.66.0.0      - 166.74.255.255 
	{ 0xa64b0000, 0xa64bffff, REGISTRY_LACNIC     }, // 166.75.0.0      - 166.75.255.255 
	{ 0xa64c0000, 0xa64effff, REGISTRY_ARIN       }, // 166.76.0.0      - 166.78.255.255 
	{ 0xa64f0000, 0xa64fffff, REGISTRY_APNIC      }, // 166.79.0.0      - 166.79.255.255 
	{ 0xa6500000, 0xa650ffff, REGISTRY_ARIN       }, // 166.80.0.0      - 166.80.255.255 
	{ 0xa6520000, 0xa652ffff, REGISTRY_ARIN       }, // 166.82.0.0      - 166.82.255.255 
	{ 0xa6530000, 0xa653ffff, REGISTRY_APNIC      }, // 166.83.0.0      - 166.83.255.255 
	{ 0xa6540000, 0xa654ffff, REGISTRY_ARIN       }, // 166.84.0.0      - 166.84.255.255 
	{ 0xa6550000, 0xa655ffff, REGISTRY_AFRINIC    }, // 166.85.0.0      - 166.85.255.255 
	{ 0xa6560000, 0xa656ffff, REGISTRY_ARIN       }, // 166.86.0.0      - 166.86.255.255 
	{ 0xa6570000, 0xa657ffff, REGISTRY_RIPENCC    }, // 166.87.0.0      - 166.87.255.255 
	{ 0xa6580000, 0xa663ffff, REGISTRY_ARIN       }, // 166.88.0.0      - 166.99.255.255 
	{ 0xa6640000, 0xa664ffff, REGISTRY_APNIC      }, // 166.100.0.0     - 166.100.255.255
	{ 0xa6650000, 0xa666ffff, REGISTRY_ARIN       }, // 166.101.0.0     - 166.102.255.255
	{ 0xa6670000, 0xa668ffff, REGISTRY_APNIC      }, // 166.103.0.0     - 166.104.255.255
	{ 0xa6690000, 0xa669ffff, REGISTRY_ARIN       }, // 166.105.0.0     - 166.105.255.255
	{ 0xa66b0000, 0xa66dffff, REGISTRY_ARIN       }, // 166.107.0.0     - 166.109.255.255
	{ 0xa66e0000, 0xa66effff, REGISTRY_LACNIC     }, // 166.110.0.0     - 166.110.255.255
	{ 0xa66f0000, 0xa66fffff, REGISTRY_APNIC      }, // 166.111.0.0     - 166.111.255.255
	{ 0xa6700000, 0xa671ffff, REGISTRY_ARIN       }, // 166.112.0.0     - 166.113.255.255
	{ 0xa6720000, 0xa672ffff, REGISTRY_LACNIC     }, // 166.114.0.0     - 166.114.255.255
	{ 0xa6730000, 0xa675ffff, REGISTRY_ARIN       }, // 166.115.0.0     - 166.117.255.255
	{ 0xa6760000, 0xa679ffff, REGISTRY_APNIC      }, // 166.118.0.0     - 166.121.255.255
	{ 0xa67a0000, 0xa67cffff, REGISTRY_ARIN       }, // 166.122.0.0     - 166.124.255.255
	{ 0xa67d0000, 0xa67dffff, REGISTRY_APNIC      }, // 166.125.0.0     - 166.125.255.255
	{ 0xa67e0000, 0xa6ffffff, REGISTRY_ARIN       }, // 166.126.0.0     - 166.255.255.255
	{ 0xa7000000, 0xa700ffff, REGISTRY_LACNIC     }, // 167.0.0.0       - 167.0.255.255  
	{ 0xa7010000, 0xa71bffff, REGISTRY_ARIN       }, // 167.1.0.0       - 167.27.255.255 
	{ 0xa71c0000, 0xa71cffff, REGISTRY_LACNIC     }, // 167.28.0.0      - 167.28.255.255 
	{ 0xa71d0000, 0xa71dffff, REGISTRY_ARIN       }, // 167.29.0.0      - 167.29.255.255 
	{ 0xa71e0000, 0xa71effff, REGISTRY_APNIC      }, // 167.30.0.0      - 167.30.255.255 
	{ 0xa71f0000, 0xa737ffff, REGISTRY_ARIN       }, // 167.31.0.0      - 167.55.255.255 
	{ 0xa7380000, 0xa73fffff, REGISTRY_LACNIC     }, // 167.56.0.0      - 167.63.255.255 
	{ 0xa7400000, 0xa750ffff, REGISTRY_ARIN       }, // 167.64.0.0      - 167.80.255.255 
	{ 0xa7510000, 0xa751ffff, REGISTRY_RIPENCC    }, // 167.81.0.0      - 167.81.255.255 
	{ 0xa7520000, 0xa766ffff, REGISTRY_ARIN       }, // 167.82.0.0      - 167.102.255.255
	{ 0xa7670000, 0xa767ffff, REGISTRY_APNIC      }, // 167.103.0.0     - 167.103.255.255
	{ 0xa7680000, 0xa76bffff, REGISTRY_ARIN       }, // 167.104.0.0     - 167.107.255.255
	{ 0xa76c0000, 0xa76cffff, REGISTRY_LACNIC     }, // 167.108.0.0     - 167.108.255.255
	{ 0xa76d0000, 0xa76effff, REGISTRY_ARIN       }, // 167.109.0.0     - 167.110.255.255
	{ 0xa76f0000, 0xa76fffff, REGISTRY_RIPENCC    }, // 167.111.0.0     - 167.111.255.255
	{ 0xa7700000, 0xa773ffff, REGISTRY_ARIN       }, // 167.112.0.0     - 167.115.255.255
	{ 0xa7740000, 0xa774ffff, REGISTRY_LACNIC     }, // 167.116.0.0     - 167.116.255.255
	{ 0xa7750000, 0xa77affff, REGISTRY_ARIN       }, // 167.117.0.0     - 167.122.255.255
	{ 0xa77b0000, 0xa77bffff, REGISTRY_APNIC      }, // 167.123.0.0     - 167.123.255.255
	{ 0xa77c0000, 0xa781ffff, REGISTRY_ARIN       }, // 167.124.0.0     - 167.129.255.255
	{ 0xa7820000, 0xa782ffff, REGISTRY_APNIC      }, // 167.130.0.0     - 167.130.255.255
	{ 0xa7830000, 0xa785ffff, REGISTRY_ARIN       }, // 167.131.0.0     - 167.133.255.255
	{ 0xa7860000, 0xa786ffff, REGISTRY_LACNIC     }, // 167.134.0.0     - 167.134.255.255
	{ 0xa7870000, 0xa78affff, REGISTRY_ARIN       }, // 167.135.0.0     - 167.138.255.255
	{ 0xa78b0000, 0xa78bffff, REGISTRY_APNIC      }, // 167.139.0.0     - 167.139.255.255
	{ 0xa78c0000, 0xa79cffff, REGISTRY_ARIN       }, // 167.140.0.0     - 167.156.255.255
	{ 0xa79d0000, 0xa79dffff, REGISTRY_LACNIC     }, // 167.157.0.0     - 167.157.255.255
	{ 0xa79e0000, 0xa7a1ffff, REGISTRY_ARIN       }, // 167.158.0.0     - 167.161.255.255
	{ 0xa7a20000, 0xa7a2ffff, REGISTRY_APNIC      }, // 167.162.0.0     - 167.162.255.255
	{ 0xa7a30000, 0xa7a7ffff, REGISTRY_ARIN       }, // 167.163.0.0     - 167.167.255.255
	{ 0xa7a80000, 0xa7a8ffff, REGISTRY_RIPENCC    }, // 167.168.0.0     - 167.168.255.255
	{ 0xa7a90000, 0xa7a9ffff, REGISTRY_APNIC      }, // 167.169.0.0     - 167.169.255.255
	{ 0xa7aa0000, 0xa7abffff, REGISTRY_ARIN       }, // 167.170.0.0     - 167.171.255.255
	{ 0xa7ac0000, 0xa7acffff, REGISTRY_RIPENCC    }, // 167.172.0.0     - 167.172.255.255
	{ 0xa7ad0000, 0xa7aeffff, REGISTRY_ARIN       }, // 167.173.0.0     - 167.174.255.255
	{ 0xa7af0000, 0xa7afffff, REGISTRY_APNIC      }, // 167.175.0.0     - 167.175.255.255
	{ 0xa7b00000, 0xa7b2ffff, REGISTRY_ARIN       }, // 167.176.0.0     - 167.178.255.255
	{ 0xa7b30000, 0xa7b3ffff, REGISTRY_APNIC      }, // 167.179.0.0     - 167.179.255.255
	{ 0xa7b40000, 0xa7bcffff, REGISTRY_ARIN       }, // 167.180.0.0     - 167.188.255.255
	{ 0xa7bd0000, 0xa7bdffff, REGISTRY_APNIC      }, // 167.189.0.0     - 167.189.255.255
	{ 0xa7be0000, 0xa7caffff, REGISTRY_ARIN       }, // 167.190.0.0     - 167.202.255.255
	{ 0xa7cb0000, 0xa7cbffff, REGISTRY_RIPENCC    }, // 167.203.0.0     - 167.203.255.255
	{ 0xa7cc0000, 0xa7ccffff, REGISTRY_ARIN       }, // 167.204.0.0     - 167.204.255.255
	{ 0xa7cd0000, 0xa7cdffff, REGISTRY_APNIC      }, // 167.205.0.0     - 167.205.255.255
	{ 0xa7ce0000, 0xa7dcdfff, REGISTRY_ARIN       }, // 167.206.0.0     - 167.220.223.255
	{ 0xa7dce000, 0xa7dcffff, REGISTRY_APNIC      }, // 167.220.224.0   - 167.220.255.255
	{ 0xa7dd0000, 0xa7f8ffff, REGISTRY_ARIN       }, // 167.221.0.0     - 167.248.255.255
	{ 0xa7fb0000, 0xa7fbffff, REGISTRY_ARIN       }, // 167.251.0.0     - 167.251.255.255
	{ 0xa7fc0000, 0xa7fcffff, REGISTRY_LACNIC     }, // 167.252.0.0     - 167.252.255.255
	{ 0xa7fd0000, 0xa7ffffff, REGISTRY_ARIN       }, // 167.253.0.0     - 167.255.255.255
	{ 0xa8010000, 0xa801ffff, REGISTRY_RIPENCC    }, // 168.1.0.0       - 168.1.255.255  
	{ 0xa8020000, 0xa845ffff, REGISTRY_ARIN       }, // 168.2.0.0       - 168.69.255.255 
	{ 0xa8460000, 0xa846ffff, REGISTRY_APNIC      }, // 168.70.0.0      - 168.70.255.255 
	{ 0xa8470000, 0xa84bffff, REGISTRY_ARIN       }, // 168.71.0.0      - 168.75.255.255 
	{ 0xa84c0000, 0xa84cffff, REGISTRY_AFRINIC    }, // 168.76.0.0      - 168.76.255.255 
	{ 0xa84d0000, 0xa84dffff, REGISTRY_LACNIC     }, // 168.77.0.0      - 168.77.255.255 
	{ 0xa84e0000, 0xa84effff, REGISTRY_APNIC      }, // 168.78.0.0      - 168.78.255.255 
	{ 0xa8500000, 0xa851ffff, REGISTRY_AFRINIC    }, // 168.80.0.0      - 168.81.255.255 
	{ 0xa8520000, 0xa852ffff, REGISTRY_ARIN       }, // 168.82.0.0      - 168.82.255.255 
	{ 0xa8530000, 0xa853ffff, REGISTRY_LACNIC     }, // 168.83.0.0      - 168.83.255.255 
	{ 0xa8540000, 0xa858ffff, REGISTRY_ARIN       }, // 168.84.0.0      - 168.88.255.255 
	{ 0xa8590000, 0xa859ffff, REGISTRY_AFRINIC    }, // 168.89.0.0      - 168.89.255.255 
	{ 0xa85b0000, 0xa85effff, REGISTRY_ARIN       }, // 168.91.0.0      - 168.94.255.255 
	{ 0xa85f0000, 0xa85fffff, REGISTRY_APNIC      }, // 168.95.0.0      - 168.95.255.255 
	{ 0xa8600000, 0xa860ffff, REGISTRY_LACNIC     }, // 168.96.0.0      - 168.96.255.255 
	{ 0xa8610000, 0xa864ffff, REGISTRY_ARIN       }, // 168.97.0.0      - 168.100.255.255
	{ 0xa8650000, 0xa865ffff, REGISTRY_LACNIC     }, // 168.101.0.0     - 168.101.255.255
	{ 0xa8660000, 0xa869ffff, REGISTRY_ARIN       }, // 168.102.0.0     - 168.105.255.255
	{ 0xa86a0000, 0xa86affff, REGISTRY_APNIC      }, // 168.106.0.0     - 168.106.255.255
	{ 0xa86b0000, 0xa872ffff, REGISTRY_ARIN       }, // 168.107.0.0     - 168.114.255.255
	{ 0xa8730000, 0xa873ffff, REGISTRY_APNIC      }, // 168.115.0.0     - 168.115.255.255
	{ 0xa8740000, 0xa877ffff, REGISTRY_ARIN       }, // 168.116.0.0     - 168.119.255.255
	{ 0xa8780000, 0xa878ffff, REGISTRY_APNIC      }, // 168.120.0.0     - 168.120.255.255
	{ 0xa87a0000, 0xa87dffff, REGISTRY_ARIN       }, // 168.122.0.0     - 168.125.255.255
	{ 0xa87e0000, 0xa87effff, REGISTRY_APNIC      }, // 168.126.0.0     - 168.126.255.255
	{ 0xa87f0000, 0xa87fffff, REGISTRY_ARIN       }, // 168.127.0.0     - 168.127.255.255
	{ 0xa8800000, 0xa880ffff, REGISTRY_AFRINIC    }, // 168.128.0.0     - 168.128.255.255
	{ 0xa8810000, 0xa881ffff, REGISTRY_ARIN       }, // 168.129.0.0     - 168.129.255.255
	{ 0xa8820000, 0xa884ffff, REGISTRY_APNIC      }, // 168.130.0.0     - 168.132.255.255
	{ 0xa8850000, 0xa885ffff, REGISTRY_ARIN       }, // 168.133.0.0     - 168.133.255.255
	{ 0xa8860000, 0xa886ffff, REGISTRY_APNIC      }, // 168.134.0.0     - 168.134.255.255
	{ 0xa8870000, 0xa88affff, REGISTRY_ARIN       }, // 168.135.0.0     - 168.138.255.255
	{ 0xa88b0000, 0xa88bffff, REGISTRY_RIPENCC    }, // 168.139.0.0     - 168.139.255.255
	{ 0xa88c0000, 0xa88cffff, REGISTRY_APNIC      }, // 168.140.0.0     - 168.140.255.255
	{ 0xa88d0000, 0xa88dffff, REGISTRY_ARIN       }, // 168.141.0.0     - 168.141.255.255
	{ 0xa88e0000, 0xa88effff, REGISTRY_AFRINIC    }, // 168.142.0.0     - 168.142.255.255
	{ 0xa88f0000, 0xa897ffff, REGISTRY_ARIN       }, // 168.143.0.0     - 168.151.255.255
	{ 0xa8980000, 0xa89affff, REGISTRY_APNIC      }, // 168.152.0.0     - 168.154.255.255
	{ 0xa89b0000, 0xa89bffff, REGISTRY_AFRINIC    }, // 168.155.0.0     - 168.155.255.255
	{ 0xa89c0000, 0xa89fffff, REGISTRY_ARIN       }, // 168.156.0.0     - 168.159.255.255
	{ 0xa8a00000, 0xa8a0ffff, REGISTRY_APNIC      }, // 168.160.0.0     - 168.160.255.255
	{ 0xa8a10000, 0xa8a3ffff, REGISTRY_ARIN       }, // 168.161.0.0     - 168.163.255.255
	{ 0xa8a40000, 0xa8a4ffff, REGISTRY_AFRINIC    }, // 168.164.0.0     - 168.164.255.255
	{ 0xa8a50000, 0xa8a5ffff, REGISTRY_LACNIC     }, // 168.165.0.0     - 168.165.255.255
	{ 0xa8a60000, 0xa8a6ffff, REGISTRY_ARIN       }, // 168.166.0.0     - 168.166.255.255
	{ 0xa8a70000, 0xa8a7ffff, REGISTRY_AFRINIC    }, // 168.167.0.0     - 168.167.255.255
	{ 0xa8a80000, 0xa8abffff, REGISTRY_ARIN       }, // 168.168.0.0     - 168.171.255.255
	{ 0xa8ac0000, 0xa8acffff, REGISTRY_AFRINIC    }, // 168.172.0.0     - 168.172.255.255
	{ 0xa8ad0000, 0xa8afffff, REGISTRY_ARIN       }, // 168.173.0.0     - 168.175.255.255
	{ 0xa8b00000, 0xa8b0ffff, REGISTRY_LACNIC     }, // 168.176.0.0     - 168.176.255.255
	{ 0xa8b10000, 0xa8b4ffff, REGISTRY_ARIN       }, // 168.177.0.0     - 168.180.255.255
	{ 0xa8b60000, 0xa8b9ffff, REGISTRY_ARIN       }, // 168.182.0.0     - 168.185.255.255
	{ 0xa8ba0000, 0xa8baffff, REGISTRY_APNIC      }, // 168.186.0.0     - 168.186.255.255
	{ 0xa8bb0000, 0xa8bbffff, REGISTRY_RIPENCC    }, // 168.187.0.0     - 168.187.255.255
	{ 0xa8bc0000, 0xa8bcffff, REGISTRY_APNIC      }, // 168.188.0.0     - 168.188.255.255
	{ 0xa8bd0000, 0xa8c1ffff, REGISTRY_ARIN       }, // 168.189.0.0     - 168.193.255.255
	{ 0xa8c60000, 0xa8c6ffff, REGISTRY_APNIC      }, // 168.198.0.0     - 168.198.255.255
	{ 0xa8c70000, 0xa8ccffff, REGISTRY_ARIN       }, // 168.199.0.0     - 168.204.255.255
	{ 0xa8ce0000, 0xa8ceffff, REGISTRY_AFRINIC    }, // 168.206.0.0     - 168.206.255.255
	{ 0xa8cf0000, 0xa8d0ffff, REGISTRY_ARIN       }, // 168.207.0.0     - 168.208.255.255
	{ 0xa8d10000, 0xa8d3ffff, REGISTRY_AFRINIC    }, // 168.209.0.0     - 168.211.255.255
	{ 0xa8d40000, 0xa8d8ffff, REGISTRY_ARIN       }, // 168.212.0.0     - 168.216.255.255
	{ 0xa8d90000, 0xa8d9ffff, REGISTRY_APNIC      }, // 168.217.0.0     - 168.217.255.255
	{ 0xa8da0000, 0xa8daffff, REGISTRY_ARIN       }, // 168.218.0.0     - 168.218.255.255
	{ 0xa8db0000, 0xa8dbffff, REGISTRY_APNIC      }, // 168.219.0.0     - 168.219.255.255
	{ 0xa8dc0000, 0xa8e1ffff, REGISTRY_ARIN       }, // 168.220.0.0     - 168.225.255.255
	{ 0xa8e20000, 0xa8e2ffff, REGISTRY_LACNIC     }, // 168.226.0.0     - 168.226.255.255
	{ 0xa8e50000, 0xa8e6ffff, REGISTRY_ARIN       }, // 168.229.0.0     - 168.230.255.255
	{ 0xa8e70000, 0xa8e7ffff, REGISTRY_LACNIC     }, // 168.231.0.0     - 168.231.255.255
	{ 0xa8e90000, 0xa8e9ffff, REGISTRY_ARIN       }, // 168.233.0.0     - 168.233.255.255
	{ 0xa8ea0000, 0xa8eaffff, REGISTRY_LACNIC     }, // 168.234.0.0     - 168.234.255.255
	{ 0xa8eb0000, 0xa8f2ffff, REGISTRY_ARIN       }, // 168.235.0.0     - 168.242.255.255
	{ 0xa8f30000, 0xa8f3ffff, REGISTRY_LACNIC     }, // 168.243.0.0     - 168.243.255.255
	{ 0xa8f40000, 0xa8f7ffff, REGISTRY_ARIN       }, // 168.244.0.0     - 168.247.255.255
	{ 0xa8f80000, 0xa8f9ffff, REGISTRY_APNIC      }, // 168.248.0.0     - 168.249.255.255
	{ 0xa8fa0000, 0xa8fbffff, REGISTRY_ARIN       }, // 168.250.0.0     - 168.251.255.255
	{ 0xa8fc0000, 0xa8fcffff, REGISTRY_APNIC      }, // 168.252.0.0     - 168.252.255.255
	{ 0xa8fe0000, 0xa8feffff, REGISTRY_ARIN       }, // 168.254.0.0     - 168.254.255.255
	{ 0xa8ff0000, 0xa8ffffff, REGISTRY_LACNIC     }, // 168.255.0.0     - 168.255.255.255
	{ 0xa9020000, 0xa91fffff, REGISTRY_ARIN       }, // 169.2.0.0       - 169.31.255.255 
	{ 0xa9200000, 0xa93fffff, REGISTRY_RIPENCC    }, // 169.32.0.0      - 169.63.255.255 
	{ 0xa9400000, 0xa980ffff, REGISTRY_ARIN       }, // 169.64.0.0      - 169.128.255.255
	{ 0xa9810000, 0xa981ffff, REGISTRY_AFRINIC    }, // 169.129.0.0     - 169.129.255.255
	{ 0xa9820000, 0xa98bffff, REGISTRY_ARIN       }, // 169.130.0.0     - 169.139.255.255
	{ 0xa98c0000, 0xa98cffff, REGISTRY_APNIC      }, // 169.140.0.0     - 169.140.255.255
	{ 0xa98d0000, 0xa99dffff, REGISTRY_ARIN       }, // 169.141.0.0     - 169.157.255.255
	{ 0xa99e0000, 0xa99effff, REGISTRY_LACNIC     }, // 169.158.0.0     - 169.158.255.255
	{ 0xa9a00000, 0xa9c8ffff, REGISTRY_ARIN       }, // 169.160.0.0     - 169.200.255.255
	{ 0xa9ca0000, 0xa9caffff, REGISTRY_AFRINIC    }, // 169.202.0.0     - 169.202.255.255
	{ 0xa9cb0000, 0xa9cfffff, REGISTRY_ARIN       }, // 169.203.0.0     - 169.207.255.255
	{ 0xa9d00000, 0xa9dfffff, REGISTRY_APNIC      }, // 169.208.0.0     - 169.223.255.255
	{ 0xa9e00000, 0xa9eeffff, REGISTRY_ARIN       }, // 169.224.0.0     - 169.238.255.255
	{ 0xa9f00000, 0xa9fdffff, REGISTRY_ARIN       }, // 169.240.0.0     - 169.253.255.255
	{ 0xaa010000, 0xaa11ffff, REGISTRY_ARIN       }, // 170.1.0.0       - 170.17.255.255 
	{ 0xaa120000, 0xaa12ffff, REGISTRY_LACNIC     }, // 170.18.0.0      - 170.18.255.255 
	{ 0xaa130000, 0xaa18ffff, REGISTRY_ARIN       }, // 170.19.0.0      - 170.24.255.255 
	{ 0xaa190000, 0xaa19ffff, REGISTRY_LACNIC     }, // 170.25.0.0      - 170.25.255.255 
	{ 0xaa1a0000, 0xaa20ffff, REGISTRY_ARIN       }, // 170.26.0.0      - 170.32.255.255 
	{ 0xaa210000, 0xaa21ffff, REGISTRY_APNIC      }, // 170.33.0.0      - 170.33.255.255 
	{ 0xaa220000, 0xaa25ffff, REGISTRY_ARIN       }, // 170.34.0.0      - 170.37.255.255 
	{ 0xaa260000, 0xaa26ffff, REGISTRY_APNIC      }, // 170.38.0.0      - 170.38.255.255 
	{ 0xaa270000, 0xaa32ffff, REGISTRY_ARIN       }, // 170.39.0.0      - 170.50.255.255 
	{ 0xaa330000, 0xaa33ffff, REGISTRY_LACNIC     }, // 170.51.0.0      - 170.51.255.255 
	{ 0xaa340000, 0xaa3bffff, REGISTRY_ARIN       }, // 170.52.0.0      - 170.59.255.255 
	{ 0xaa3c0000, 0xaa3cffff, REGISTRY_RIPENCC    }, // 170.60.0.0      - 170.60.255.255 
	{ 0xaa3d0000, 0xaa41ffff, REGISTRY_ARIN       }, // 170.61.0.0      - 170.65.255.255 
	{ 0xaa420000, 0xaa42ffff, REGISTRY_LACNIC     }, // 170.66.0.0      - 170.66.255.255 
	{ 0xaa430000, 0xaa45ffff, REGISTRY_ARIN       }, // 170.67.0.0      - 170.69.255.255 
	{ 0xaa460000, 0xaa46ffff, REGISTRY_LACNIC     }, // 170.70.0.0      - 170.70.255.255 
	{ 0xaa470000, 0xaa4dffff, REGISTRY_ARIN       }, // 170.71.0.0      - 170.77.255.255 
	{ 0xaa550000, 0xaa5effff, REGISTRY_ARIN       }, // 170.85.0.0      - 170.94.255.255 
	{ 0xaa600000, 0xaa95ffff, REGISTRY_ARIN       }, // 170.96.0.0      - 170.149.255.255
	{ 0xaa970000, 0xaa9affff, REGISTRY_ARIN       }, // 170.151.0.0     - 170.154.255.255
	{ 0xaa9b0000, 0xaa9bffff, REGISTRY_LACNIC     }, // 170.155.0.0     - 170.155.255.255
	{ 0xaa9c0000, 0xaa9cffff, REGISTRY_ARIN       }, // 170.156.0.0     - 170.156.255.255
	{ 0xaa9d0000, 0xaa9dffff, REGISTRY_APNIC      }, // 170.157.0.0     - 170.157.255.255
	{ 0xaa9e0000, 0xaaa8ffff, REGISTRY_ARIN       }, // 170.158.0.0     - 170.168.255.255
	{ 0xaaa90000, 0xaaa9ffff, REGISTRY_LACNIC     }, // 170.169.0.0     - 170.169.255.255
	{ 0xaaaa0000, 0xaab2ffff, REGISTRY_ARIN       }, // 170.170.0.0     - 170.178.255.255
	{ 0xaab30000, 0xaab3ffff, REGISTRY_APNIC      }, // 170.179.0.0     - 170.179.255.255
	{ 0xaab40000, 0xaad1ffff, REGISTRY_ARIN       }, // 170.180.0.0     - 170.209.255.255
	{ 0xaad20000, 0xaad2ffff, REGISTRY_LACNIC     }, // 170.210.0.0     - 170.210.255.255
	{ 0xaad30000, 0xaae6ffff, REGISTRY_ARIN       }, // 170.211.0.0     - 170.230.255.255
	{ 0xaae80000, 0xaae8ffff, REGISTRY_ARIN       }, // 170.232.0.0     - 170.232.255.255
	{ 0xaaea0000, 0xaaebffff, REGISTRY_ARIN       }, // 170.234.0.0     - 170.235.255.255
	{ 0xaaec0000, 0xaaedffff, REGISTRY_RIPENCC    }, // 170.236.0.0     - 170.237.255.255
	{ 0xaaf00000, 0xaaf3ffff, REGISTRY_ARIN       }, // 170.240.0.0     - 170.243.255.255
	{ 0xaaf80000, 0xaafdffff, REGISTRY_ARIN       }, // 170.248.0.0     - 170.253.255.255
	{ 0xaaff0000, 0xaaffffff, REGISTRY_RIPENCC    }, // 170.255.0.0     - 170.255.255.255
	{ 0xab000000, 0xab0fffff, REGISTRY_APNIC      }, // 171.0.0.0       - 171.15.255.255 
	{ 0xab100000, 0xab213fff, REGISTRY_RIPENCC    }, // 171.16.0.0      - 171.33.63.255  
	{ 0xab214000, 0xab21ffff, REGISTRY_RIPENCC    }, // 171.33.64.0     - 171.33.255.255 
	{ 0xab220000, 0xab3fffff, REGISTRY_APNIC      }, // 171.34.0.0      - 171.63.255.255 
	{ 0xab400000, 0xab4bffff, REGISTRY_ARIN       }, // 171.64.0.0      - 171.75.255.255 
	{ 0xab4c0000, 0xab7fffff, REGISTRY_APNIC      }, // 171.76.0.0      - 171.127.255.255
	{ 0xab800000, 0xabceffff, REGISTRY_ARIN       }, // 171.128.0.0     - 171.206.255.255
	{ 0xabcf0000, 0xabffffff, REGISTRY_APNIC      }, // 171.207.0.0     - 171.255.255.255
	{ 0xac000000, 0xac0fffff, REGISTRY_ARIN       }, // 172.0.0.0       - 172.15.255.255 
	{ 0xac200000, 0xacbfffff, REGISTRY_ARIN       }, // 172.32.0.0      - 172.191.255.255
	{ 0xacc00000, 0xacc7ffff, REGISTRY_APNIC      }, // 172.192.0.0     - 172.199.255.255
	{ 0xacc80000, 0xae8a8fff, REGISTRY_ARIN       }, // 172.200.0.0     - 174.138.143.255
	{ 0xae8a9000, 0xae8a9fff, REGISTRY_APNIC      }, // 174.138.144.0   - 174.138.159.255
	{ 0xae8aa000, 0xaeffffff, REGISTRY_ARIN       }, // 174.138.160.0   - 174.255.255.255
	{ 0xaf000000, 0xaf2db3ff, REGISTRY_APNIC      }, // 175.0.0.0       - 175.45.179.255 
	{ 0xaf2db800, 0xaf6a03ff, REGISTRY_APNIC      }, // 175.45.184.0    - 175.106.3.255  
	{ 0xaf6a0800, 0xaf6f6bff, REGISTRY_APNIC      }, // 175.106.8.0     - 175.111.107.255
	{ 0xaf6f7000, 0xaf6f7fff, REGISTRY_APNIC      }, // 175.111.112.0   - 175.111.127.255
	{ 0xaf6fc000, 0xaf9e5fff, REGISTRY_APNIC      }, // 175.111.192.0   - 175.158.95.255 
	{ 0xaf9e6800, 0xafb097ff, REGISTRY_APNIC      }, // 175.158.104.0   - 175.176.151.255
	{ 0xafb0a000, 0xafb0afff, REGISTRY_APNIC      }, // 175.176.160.0   - 175.176.175.255
	{ 0xafb0c000, 0xafffffff, REGISTRY_APNIC      }, // 175.176.192.0   - 175.255.255.255
	{ 0xb0000000, 0xb0357fff, REGISTRY_RIPENCC    }, // 176.0.0.0       - 176.53.127.255 
	{ 0xb035c000, 0xb03827ff, REGISTRY_RIPENCC    }, // 176.53.192.0    - 176.56.39.255  
	{ 0xb0383000, 0xb0393fff, REGISTRY_RIPENCC    }, // 176.56.48.0     - 176.57.63.255  
	{ 0xb0394800, 0xb05fffff, REGISTRY_RIPENCC    }, // 176.57.72.0     - 176.95.255.255 
	{ 0xb0600000, 0xb0621fff, REGISTRY_RIPENCC    }, // 176.96.0.0      - 176.98.31.255  
	{ 0xb0623000, 0xb065a7ff, REGISTRY_RIPENCC    }, // 176.98.48.0     - 176.101.167.255
	{ 0xb065b000, 0xb0698fff, REGISTRY_RIPENCC    }, // 176.101.176.0   - 176.105.143.255
	{ 0xb069a000, 0xb069dfff, REGISTRY_RIPENCC    }, // 176.105.160.0   - 176.105.223.255
	{ 0xb06a0000, 0xb06a6fff, REGISTRY_RIPENCC    }, // 176.106.0.0     - 176.106.111.255
	{ 0xb06a7000, 0xb06a77ff, REGISTRY_RIPENCC    }, // 176.106.112.0   - 176.106.119.255
	{ 0xb06a7800, 0xb06bafff, REGISTRY_RIPENCC    }, // 176.106.120.0   - 176.107.175.255
	{ 0xb06bb000, 0xb06bbfff, REGISTRY_RIPENCC    }, // 176.107.176.0   - 176.107.191.255
	{ 0xb06bc000, 0xb06f67ff, REGISTRY_RIPENCC    }, // 176.107.192.0   - 176.111.103.255
	{ 0xb06f6800, 0xb06f6fff, REGISTRY_RIPENCC    }, // 176.111.104.0   - 176.111.111.255
	{ 0xb06f7000, 0xb06fa7ff, REGISTRY_RIPENCC    }, // 176.111.112.0   - 176.111.167.255
	{ 0xb06fb000, 0xb07127ff, REGISTRY_RIPENCC    }, // 176.111.176.0   - 176.113.39.255 
	{ 0xb0713000, 0xb0713fff, REGISTRY_RIPENCC    }, // 176.113.48.0    - 176.113.63.255 
	{ 0xb0716000, 0xb0761fff, REGISTRY_RIPENCC    }, // 176.113.96.0    - 176.118.31.255 
	{ 0xb0762800, 0xb0769fff, REGISTRY_RIPENCC    }, // 176.118.40.0    - 176.118.159.255
	{ 0xb076c800, 0xb076cfff, REGISTRY_RIPENCC    }, // 176.118.200.0   - 176.118.207.255
	{ 0xb076d000, 0xb076dfff, REGISTRY_RIPENCC    }, // 176.118.208.0   - 176.118.223.255
	{ 0xb076e000, 0xb0773fff, REGISTRY_RIPENCC    }, // 176.118.224.0   - 176.119.63.255 
	{ 0xb0774000, 0xb0777fff, REGISTRY_RIPENCC    }, // 176.119.64.0    - 176.119.127.255
	{ 0xb077a000, 0xb07acfff, REGISTRY_RIPENCC    }, // 176.119.160.0   - 176.122.207.255
	{ 0xb07ad200, 0xb07c1fff, REGISTRY_RIPENCC    }, // 176.122.210.0   - 176.124.31.255 
	{ 0xb07c4000, 0xb07ddfff, REGISTRY_RIPENCC    }, // 176.124.64.0    - 176.125.223.255
	{ 0xb07e0000, 0xb07ea7ff, REGISTRY_RIPENCC    }, // 176.126.0.0     - 176.126.167.255
	{ 0xb07ea800, 0xb0e3efff, REGISTRY_RIPENCC    }, // 176.126.168.0   - 176.227.239.255
	{ 0xb0e3f800, 0xb0ffffff, REGISTRY_RIPENCC    }, // 176.227.248.0   - 176.255.255.255
	{ 0xb1000000, 0xb10b7fff, REGISTRY_LACNIC     }, // 177.0.0.0       - 177.11.127.255 
	{ 0xb10b8800, 0xb1251fff, REGISTRY_LACNIC     }, // 177.11.136.0    - 177.37.31.255  
	{ 0xb1253000, 0xb1ffffff, REGISTRY_LACNIC     }, // 177.37.48.0     - 177.255.255.255
	{ 0xb2000000, 0xb214cfff, REGISTRY_RIPENCC    }, // 178.0.0.0       - 178.20.207.255 
	{ 0xb214d800, 0xb235ffff, REGISTRY_RIPENCC    }, // 178.20.216.0    - 178.53.255.255 
	{ 0xb2360000, 0xb236ffff, REGISTRY_RIPENCC    }, // 178.54.0.0      - 178.54.255.255 
	{ 0xb2370000, 0xb29dffff, REGISTRY_RIPENCC    }, // 178.55.0.0      - 178.157.255.255
	{ 0xb29e0000, 0xb29fffff, REGISTRY_RIPENCC    }, // 178.158.0.0     - 178.159.255.255
	{ 0xb2a00000, 0xb2d3ffff, REGISTRY_RIPENCC    }, // 178.160.0.0     - 178.211.255.255
	{ 0xb2d40000, 0xb2d67fff, REGISTRY_RIPENCC    }, // 178.212.0.0     - 178.214.127.255
	{ 0xb2d68000, 0xb2d69fff, REGISTRY_RIPENCC    }, // 178.214.128.0   - 178.214.159.255
	{ 0xb2d6a000, 0xb2d857ff, REGISTRY_RIPENCC    }, // 178.214.160.0   - 178.216.87.255 
	{ 0xb2d85800, 0xb2d85fff, REGISTRY_RIPENCC    }, // 178.216.88.0    - 178.216.95.255 
	{ 0xb2d86000, 0xb2d957ff, REGISTRY_RIPENCC    }, // 178.216.96.0    - 178.217.87.255 
	{ 0xb2d96000, 0xb2d9e7ff, REGISTRY_RIPENCC    }, // 178.217.96.0    - 178.217.231.255
	{ 0xb2d9f000, 0xb2dabfff, REGISTRY_RIPENCC    }, // 178.217.240.0   - 178.218.191.255
	{ 0xb2dac800, 0xb2daefff, REGISTRY_RIPENCC    }, // 178.218.200.0   - 178.218.239.255
	{ 0xb2db0000, 0xb2db0fff, REGISTRY_RIPENCC    }, // 178.219.0.0     - 178.219.15.255 
	{ 0xb2db1000, 0xb2dbffff, REGISTRY_RIPENCC    }, // 178.219.16.0    - 178.219.255.255
	{ 0xb2dc0000, 0xb2edffff, REGISTRY_RIPENCC    }, // 178.220.0.0     - 178.237.255.255
	{ 0xb2ee1000, 0xb2f9e7ff, REGISTRY_RIPENCC    }, // 178.238.16.0    - 178.249.231.255
	{ 0xb2f9f000, 0xb2ff6fff, REGISTRY_RIPENCC    }, // 178.249.240.0   - 178.255.111.255
	{ 0xb2ff7800, 0xb2ffffff, REGISTRY_RIPENCC    }, // 178.255.120.0   - 178.255.255.255
	{ 0xb3000000, 0xb3ffffff, REGISTRY_LACNIC     }, // 179.0.0.0       - 179.255.255.255
	{ 0xb4000000, 0xb45e1fff, REGISTRY_APNIC      }, // 180.0.0.0       - 180.94.31.255  
	{ 0xb45e2400, 0xb45e77ff, REGISTRY_APNIC      }, // 180.94.36.0     - 180.94.119.255 
	{ 0xb45e8000, 0xb4b26fff, REGISTRY_APNIC      }, // 180.94.128.0    - 180.178.111.255
	{ 0xb4b27800, 0xb4d2d3ff, REGISTRY_APNIC      }, // 180.178.120.0   - 180.210.211.255
	{ 0xb4d2d800, 0xb4d2dbff, REGISTRY_APNIC      }, // 180.210.216.0   - 180.210.219.255
	{ 0xb4d2e000, 0xb4e98fff, REGISTRY_APNIC      }, // 180.210.224.0   - 180.233.143.255
	{ 0xb4e99800, 0xb4eb6fff, REGISTRY_APNIC      }, // 180.233.152.0   - 180.235.111.255
	{ 0xb4eb8000, 0xb4eb87ff, REGISTRY_APNIC      }, // 180.235.128.0   - 180.235.135.255
	{ 0xb4eb8c00, 0xb4ffffff, REGISTRY_APNIC      }, // 180.235.140.0   - 180.255.255.255
	{ 0xb5000000, 0xb5ffffff, REGISTRY_LACNIC     }, // 181.0.0.0       - 181.255.255.255
	{ 0xb6000000, 0xb6108fff, REGISTRY_APNIC      }, // 182.0.0.0       - 182.16.143.255 
	{ 0xb6109800, 0xb63243ff, REGISTRY_APNIC      }, // 182.16.152.0    - 182.50.67.255  
	{ 0xb6324800, 0xb636f3ff, REGISTRY_APNIC      }, // 182.50.72.0     - 182.54.243.255 
	{ 0xb636f800, 0xb6a11fff, REGISTRY_APNIC      }, // 182.54.248.0    - 182.161.31.255 
	{ 0xb6a14000, 0xb6ed18ff, REGISTRY_APNIC      }, // 182.161.64.0    - 182.237.24.255 
	{ 0xb6ed2000, 0xb74e9fff, REGISTRY_APNIC      }, // 182.237.32.0    - 183.78.159.255 
	{ 0xb74ea800, 0xb74eafff, REGISTRY_APNIC      }, // 183.78.168.0    - 183.78.175.255 
	{ 0xb74eb400, 0xb751abff, REGISTRY_APNIC      }, // 183.78.180.0    - 183.81.171.255 
	{ 0xb751b000, 0xb7ffffff, REGISTRY_APNIC      }, // 183.81.176.0    - 183.255.255.255
	{ 0xb8000000, 0xb8ffffff, REGISTRY_ARIN       }, // 184.0.0.0       - 184.255.255.255
	{ 0xb9010000, 0xb90114ff, REGISTRY_RIPENCC    }, // 185.1.0.0       - 185.1.20.255   
	{ 0xb9011600, 0xb9011dff, REGISTRY_RIPENCC    }, // 185.1.22.0      - 185.1.29.255   
	{ 0xb9020000, 0xb905f7ff, REGISTRY_RIPENCC    }, // 185.2.0.0       - 185.5.247.255  
	{ 0xb905fc00, 0xb90693ff, REGISTRY_RIPENCC    }, // 185.5.252.0     - 185.6.147.255  
	{ 0xb9069800, 0xb90fafff, REGISTRY_RIPENCC    }, // 185.6.152.0     - 185.15.175.255 
	{ 0xb90fb400, 0xb9133bff, REGISTRY_RIPENCC    }, // 185.15.180.0    - 185.19.59.255  
	{ 0xb9134000, 0xb913afff, REGISTRY_RIPENCC    }, // 185.19.64.0     - 185.19.175.255 
	{ 0xb913b400, 0xb913fbff, REGISTRY_RIPENCC    }, // 185.19.180.0    - 185.19.251.255 
	{ 0xb9140000, 0xb917a3ff, REGISTRY_RIPENCC    }, // 185.20.0.0      - 185.23.163.255 
	{ 0xb917a800, 0xb9186bff, REGISTRY_RIPENCC    }, // 185.23.168.0    - 185.24.107.255 
	{ 0xb9187000, 0xb91a73ff, REGISTRY_RIPENCC    }, // 185.24.112.0    - 185.26.115.255 
	{ 0xb91a7800, 0xb91aefff, REGISTRY_RIPENCC    }, // 185.26.120.0    - 185.26.239.255 
	{ 0xb91af400, 0xb91c3bff, REGISTRY_RIPENCC    }, // 185.26.244.0    - 185.28.59.255  
	{ 0xb91c4000, 0xb91cb3ff, REGISTRY_RIPENCC    }, // 185.28.64.0     - 185.28.179.255 
	{ 0xb91cb800, 0xb91fdbff, REGISTRY_RIPENCC    }, // 185.28.184.0    - 185.31.219.255 
	{ 0xb91fe400, 0xb92093ff, REGISTRY_RIPENCC    }, // 185.31.228.0    - 185.32.147.255 
	{ 0xb9209800, 0xb920ffff, REGISTRY_RIPENCC    }, // 185.32.152.0    - 185.32.255.255 
	{ 0xb9210400, 0xb9257fff, REGISTRY_RIPENCC    }, // 185.33.4.0      - 185.37.127.255 
	{ 0xb9258400, 0xb9289bff, REGISTRY_RIPENCC    }, // 185.37.132.0    - 185.40.155.255 
	{ 0xb928a000, 0xb941a3ff, REGISTRY_RIPENCC    }, // 185.40.160.0    - 185.65.163.255 
	{ 0xba000000, 0xba008fff, REGISTRY_LACNIC     }, // 186.0.0.0       - 186.0.143.255  
	{ 0xba009800, 0xba02f7ff, REGISTRY_LACNIC     }, // 186.0.152.0     - 186.2.247.255  
	{ 0xba02fc00, 0xba4167ff, REGISTRY_LACNIC     }, // 186.2.252.0     - 186.65.103.255 
	{ 0xba416c00, 0xbae867ff, REGISTRY_LACNIC     }, // 186.65.108.0    - 186.232.103.255
	{ 0xbae86c00, 0xbafa8fff, REGISTRY_LACNIC     }, // 186.232.108.0   - 186.250.143.255
	{ 0xbafa9400, 0xbb318fff, REGISTRY_LACNIC     }, // 186.250.148.0   - 187.49.143.255 
	{ 0xbb31c000, 0xbb49afff, REGISTRY_LACNIC     }, // 187.49.192.0    - 187.73.175.255 
	{ 0xbb49c000, 0xbb5fcfff, REGISTRY_LACNIC     }, // 187.73.192.0    - 187.95.207.255 
	{ 0xbb5fe000, 0xbb67bfff, REGISTRY_LACNIC     }, // 187.95.224.0    - 187.103.191.255
	{ 0xbb67d000, 0xbb789fff, REGISTRY_LACNIC     }, // 187.103.208.0   - 187.120.159.255
	{ 0xbb78b000, 0xbbffffff, REGISTRY_LACNIC     }, // 187.120.176.0   - 187.255.255.255
	{ 0xbc000000, 0xbc01ffff, REGISTRY_RIPENCC    }, // 188.0.0.0       - 188.1.255.255  
	{ 0xbc020000, 0xbc4217ff, REGISTRY_RIPENCC    }, // 188.2.0.0       - 188.66.23.255  
	{ 0xbc422000, 0xbc422fff, REGISTRY_RIPENCC    }, // 188.66.32.0     - 188.66.47.255  
	{ 0xbc424000, 0xbc5c77ff, REGISTRY_RIPENCC    }, // 188.66.64.0     - 188.92.119.255 
	{ 0xbc5c8000, 0xbc5eb7ff, REGISTRY_RIPENCC    }, // 188.92.128.0    - 188.94.183.255 
	{ 0xbc5ec000, 0xbc5f57ff, REGISTRY_RIPENCC    }, // 188.94.192.0    - 188.95.87.255  
	{ 0xbc5f6000, 0xbcbdffff, REGISTRY_RIPENCC    }, // 188.95.96.0     - 188.189.255.255
	{ 0xbcbe0000, 0xbcbfffff, REGISTRY_RIPENCC    }, // 188.190.0.0     - 188.191.255.255
	{ 0xbcc00000, 0xbce3bfff, REGISTRY_RIPENCC    }, // 188.192.0.0     - 188.227.191.255
	{ 0xbce3c800, 0xbceeffff, REGISTRY_RIPENCC    }, // 188.227.200.0   - 188.238.255.255
	{ 0xbcef0000, 0xbcefffff, REGISTRY_RIPENCC    }, // 188.239.0.0     - 188.239.255.255
	{ 0xbcf00000, 0xbcffffff, REGISTRY_RIPENCC    }, // 188.240.0.0     - 188.255.255.255
	{ 0xbd000000, 0xbd2dafff, REGISTRY_LACNIC     }, // 189.0.0.0       - 189.45.175.255 
	{ 0xbd2dc000, 0xbd32cfff, REGISTRY_LACNIC     }, // 189.45.192.0    - 189.50.207.255 
	{ 0xbd32e000, 0xbd541fff, REGISTRY_LACNIC     }, // 189.50.224.0    - 189.84.31.255  
	{ 0xbd543000, 0xbd555fff, REGISTRY_LACNIC     }, // 189.84.48.0     - 189.85.95.255  
	{ 0xbd558000, 0xbd71afff, REGISTRY_LACNIC     }, // 189.85.128.0    - 189.113.175.255
	{ 0xbd71c000, 0xbd7dffff, REGISTRY_LACNIC     }, // 189.113.192.0   - 189.125.255.255
	{ 0xbd7e1000, 0xbe023fff, REGISTRY_LACNIC     }, // 189.126.16.0    - 190.2.63.255   
	{ 0xbe024800, 0xbe039fff, REGISTRY_LACNIC     }, // 190.2.72.0      - 190.3.159.255  
	{ 0xbe03a800, 0xbe52ffff, REGISTRY_LACNIC     }, // 190.3.168.0     - 190.82.255.255 
	{ 0xbe538000, 0xbe58ffff, REGISTRY_LACNIC     }, // 190.83.128.0    - 190.88.255.255 
	{ 0xbe5a0000, 0xbe5dafff, REGISTRY_LACNIC     }, // 190.90.0.0      - 190.93.175.255 
	{ 0xbe5dc000, 0xbe61abff, REGISTRY_LACNIC     }, // 190.93.192.0    - 190.97.171.255 
	{ 0xbe61b000, 0xbe6b9fff, REGISTRY_LACNIC     }, // 190.97.176.0    - 190.107.159.255
	{ 0xbe6bb000, 0xbe6f5fff, REGISTRY_LACNIC     }, // 190.107.176.0   - 190.111.95.255 
	{ 0xbe6f7000, 0xbe6f7fff, REGISTRY_LACNIC     }, // 190.111.112.0   - 190.111.127.255
	{ 0xbe6fc000, 0xbe733fff, REGISTRY_LACNIC     }, // 190.111.192.0   - 190.115.63.255 
	{ 0xbe736000, 0xbe781fff, REGISTRY_LACNIC     }, // 190.115.96.0    - 190.120.31.255 
	{ 0xbe783000, 0xbe7cfbff, REGISTRY_LACNIC     }, // 190.120.48.0    - 190.124.251.255
	{ 0xbe7d0000, 0xbfffffff, REGISTRY_LACNIC     }, // 190.125.0.0     - 191.255.255.255
	{ 0xc0000100, 0xc00001ff, REGISTRY_ARIN       }, // 192.0.1.0       - 192.0.1.255    
	{ 0xc0000300, 0xc0051bff, REGISTRY_ARIN       }, // 192.0.3.0       - 192.5.27.255   
	{ 0xc0051c00, 0xc0051eff, REGISTRY_RIPENCC    }, // 192.5.28.0      - 192.5.30.255   
	{ 0xc0051f00, 0xc00523ff, REGISTRY_ARIN       }, // 192.5.31.0      - 192.5.35.255   
	{ 0xc0052400, 0xc00524ff, REGISTRY_RIPENCC    }, // 192.5.36.0      - 192.5.36.255   
	{ 0xc0052500, 0xc00531ff, REGISTRY_ARIN       }, // 192.5.37.0      - 192.5.49.255   
	{ 0xc0053200, 0xc00532ff, REGISTRY_RIPENCC    }, // 192.5.50.0      - 192.5.50.255   
	{ 0xc0053300, 0xc0053aff, REGISTRY_ARIN       }, // 192.5.51.0      - 192.5.58.255   
	{ 0xc0053b00, 0xc0053bff, REGISTRY_RIPENCC    }, // 192.5.59.0      - 192.5.59.255   
	{ 0xc0053c00, 0xc0053cff, REGISTRY_ARIN       }, // 192.5.60.0      - 192.5.60.255   
	{ 0xc0053d00, 0xc0053eff, REGISTRY_RIPENCC    }, // 192.5.61.0      - 192.5.62.255   
	{ 0xc0053f00, 0xc00559ff, REGISTRY_ARIN       }, // 192.5.63.0      - 192.5.89.255   
	{ 0xc0055a00, 0xc0055aff, REGISTRY_APNIC      }, // 192.5.90.0      - 192.5.90.255   
	{ 0xc0055b00, 0xc00560ff, REGISTRY_ARIN       }, // 192.5.91.0      - 192.5.96.255   
	{ 0xc0056100, 0xc00561ff, REGISTRY_RIPENCC    }, // 192.5.97.0      - 192.5.97.255   
	{ 0xc0056200, 0xc0058dff, REGISTRY_ARIN       }, // 192.5.98.0      - 192.5.141.255  
	{ 0xc0058e00, 0xc0058eff, REGISTRY_RIPENCC    }, // 192.5.142.0     - 192.5.142.255  
	{ 0xc0058f00, 0xc00590ff, REGISTRY_ARIN       }, // 192.5.143.0     - 192.5.144.255  
	{ 0xc0059100, 0xc00591ff, REGISTRY_RIPENCC    }, // 192.5.145.0     - 192.5.145.255  
	{ 0xc0059200, 0xc005a1ff, REGISTRY_ARIN       }, // 192.5.146.0     - 192.5.161.255  
	{ 0xc005a200, 0xc005a2ff, REGISTRY_RIPENCC    }, // 192.5.162.0     - 192.5.162.255  
	{ 0xc005a300, 0xc005d7ff, REGISTRY_ARIN       }, // 192.5.163.0     - 192.5.215.255  
	{ 0xc005d800, 0xc005d8ff, REGISTRY_APNIC      }, // 192.5.216.0     - 192.5.216.255  
	{ 0xc005d900, 0xc005eeff, REGISTRY_ARIN       }, // 192.5.217.0     - 192.5.238.255  
	{ 0xc005ef00, 0xc005efff, REGISTRY_RIPENCC    }, // 192.5.239.0     - 192.5.239.255  
	{ 0xc005f000, 0xc005f0ff, REGISTRY_APNIC      }, // 192.5.240.0     - 192.5.240.255  
	{ 0xc005f100, 0xc005fdff, REGISTRY_ARIN       }, // 192.5.241.0     - 192.5.253.255  
	{ 0xc005fe00, 0xc005feff, REGISTRY_RIPENCC    }, // 192.5.254.0     - 192.5.254.255  
	{ 0xc005ff00, 0xc008b2ff, REGISTRY_ARIN       }, // 192.5.255.0     - 192.8.178.255  
	{ 0xc008b300, 0xc008b3ff, REGISTRY_APNIC      }, // 192.8.179.0     - 192.8.179.255  
	{ 0xc008b400, 0xc00c00ff, REGISTRY_ARIN       }, // 192.8.180.0     - 192.12.0.255   
	{ 0xc00c0100, 0xc00c01ff, REGISTRY_RIPENCC    }, // 192.12.1.0      - 192.12.1.255   
	{ 0xc00c0200, 0xc00c2eff, REGISTRY_ARIN       }, // 192.12.2.0      - 192.12.46.255  
	{ 0xc00c2f00, 0xc00c2fff, REGISTRY_RIPENCC    }, // 192.12.47.0     - 192.12.47.255  
	{ 0xc00c3000, 0xc00c35ff, REGISTRY_ARIN       }, // 192.12.48.0     - 192.12.53.255  
	{ 0xc00c3600, 0xc00c36ff, REGISTRY_RIPENCC    }, // 192.12.54.0     - 192.12.54.255  
	{ 0xc00c3700, 0xc00c47ff, REGISTRY_ARIN       }, // 192.12.55.0     - 192.12.71.255  
	{ 0xc00c4800, 0xc00c49ff, REGISTRY_RIPENCC    }, // 192.12.72.0     - 192.12.73.255  
	{ 0xc00c4a00, 0xc00c4bff, REGISTRY_ARIN       }, // 192.12.74.0     - 192.12.75.255  
	{ 0xc00c4c00, 0xc00c4cff, REGISTRY_APNIC      }, // 192.12.76.0     - 192.12.76.255  
	{ 0xc00c4d00, 0xc00c4dff, REGISTRY_RIPENCC    }, // 192.12.77.0     - 192.12.77.255  
	{ 0xc00c4e00, 0xc00c50ff, REGISTRY_ARIN       }, // 192.12.78.0     - 192.12.80.255  
	{ 0xc00c5100, 0xc00c51ff, REGISTRY_RIPENCC    }, // 192.12.81.0     - 192.12.81.255  
	{ 0xc00c5200, 0xc00c5fff, REGISTRY_ARIN       }, // 192.12.82.0     - 192.12.95.255  
	{ 0xc00c6000, 0xc00c60ff, REGISTRY_RIPENCC    }, // 192.12.96.0     - 192.12.96.255  
	{ 0xc00c6100, 0xc00c62ff, REGISTRY_ARIN       }, // 192.12.97.0     - 192.12.98.255  
	{ 0xc00c6300, 0xc00c63ff, REGISTRY_RIPENCC    }, // 192.12.99.0     - 192.12.99.255  
	{ 0xc00c6400, 0xc00c6cff, REGISTRY_ARIN       }, // 192.12.100.0    - 192.12.108.255 
	{ 0xc00c7700, 0xc00cbfff, REGISTRY_ARIN       }, // 192.12.119.0    - 192.12.191.255 
	{ 0xc00cc000, 0xc00cc2ff, REGISTRY_RIPENCC    }, // 192.12.192.0    - 192.12.194.255 
	{ 0xc00cc300, 0xc00cd8ff, REGISTRY_ARIN       }, // 192.12.195.0    - 192.12.216.255 
	{ 0xc00cd900, 0xc00cdaff, REGISTRY_RIPENCC    }, // 192.12.217.0    - 192.12.218.255 
	{ 0xc00cdb00, 0xc00ce6ff, REGISTRY_ARIN       }, // 192.12.219.0    - 192.12.230.255 
	{ 0xc00ce700, 0xc00ce8ff, REGISTRY_RIPENCC    }, // 192.12.231.0    - 192.12.232.255 
	{ 0xc00ce900, 0xc00ceaff, REGISTRY_ARIN       }, // 192.12.233.0    - 192.12.234.255 
	{ 0xc00ceb00, 0xc00cebff, REGISTRY_RIPENCC    }, // 192.12.235.0    - 192.12.235.255 
	{ 0xc00cec00, 0xc00cf6ff, REGISTRY_ARIN       }, // 192.12.236.0    - 192.12.246.255 
	{ 0xc00cf700, 0xc00cf7ff, REGISTRY_RIPENCC    }, // 192.12.247.0    - 192.12.247.255 
	{ 0xc00cf800, 0xc0107aff, REGISTRY_ARIN       }, // 192.12.248.0    - 192.16.122.255 
	{ 0xc0107b00, 0xc010a6ff, REGISTRY_RIPENCC    }, // 192.16.123.0    - 192.16.166.255 
	{ 0xc010a700, 0xc010b1ff, REGISTRY_ARIN       }, // 192.16.167.0    - 192.16.177.255 
	{ 0xc010b200, 0xc010b4ff, REGISTRY_APNIC      }, // 192.16.178.0    - 192.16.180.255 
	{ 0xc010b500, 0xc010b6ff, REGISTRY_ARIN       }, // 192.16.181.0    - 192.16.182.255 
	{ 0xc010b700, 0xc010caff, REGISTRY_RIPENCC    }, // 192.16.183.0    - 192.16.202.255 
	{ 0xc010cb00, 0xc012c2ff, REGISTRY_ARIN       }, // 192.16.203.0    - 192.18.194.255 
	{ 0xc012c300, 0xc012c3ff, REGISTRY_RIPENCC    }, // 192.18.195.0    - 192.18.195.255 
	{ 0xc012c400, 0xc01a1bff, REGISTRY_ARIN       }, // 192.18.196.0    - 192.26.27.255  
	{ 0xc01a1c00, 0xc01a2fff, REGISTRY_RIPENCC    }, // 192.26.28.0     - 192.26.47.255  
	{ 0xc01a3000, 0xc01a5aff, REGISTRY_ARIN       }, // 192.26.48.0     - 192.26.90.255  
	{ 0xc01a5b00, 0xc01a5bff, REGISTRY_APNIC      }, // 192.26.91.0     - 192.26.91.255  
	{ 0xc01a5c00, 0xc01a5cff, REGISTRY_ARIN       }, // 192.26.92.0     - 192.26.92.255  
	{ 0xc01a5d00, 0xc01a5eff, REGISTRY_APNIC      }, // 192.26.93.0     - 192.26.94.255  
	{ 0xc01a5f00, 0xc01a5fff, REGISTRY_ARIN       }, // 192.26.95.0     - 192.26.95.255  
	{ 0xc01a6000, 0xc01a60ff, REGISTRY_APNIC      }, // 192.26.96.0     - 192.26.96.255  
	{ 0xc01a6100, 0xc01a68ff, REGISTRY_ARIN       }, // 192.26.97.0     - 192.26.104.255 
	{ 0xc01a6900, 0xc01a6dff, REGISTRY_RIPENCC    }, // 192.26.105.0    - 192.26.109.255 
	{ 0xc01a6f00, 0xc01a80ff, REGISTRY_RIPENCC    }, // 192.26.111.0    - 192.26.128.255 
	{ 0xc01a8100, 0xc01a84ff, REGISTRY_ARIN       }, // 192.26.129.0    - 192.26.132.255 
	{ 0xc01a8500, 0xc01a87ff, REGISTRY_RIPENCC    }, // 192.26.133.0    - 192.26.135.255 
	{ 0xc01a8800, 0xc01a99ff, REGISTRY_ARIN       }, // 192.26.136.0    - 192.26.153.255 
	{ 0xc01a9a00, 0xc01ac1ff, REGISTRY_RIPENCC    }, // 192.26.154.0    - 192.26.193.255 
	{ 0xc01ac200, 0xc01ad6ff, REGISTRY_ARIN       }, // 192.26.194.0    - 192.26.214.255 
	{ 0xc01ad800, 0xc01ae6ff, REGISTRY_APNIC      }, // 192.26.216.0    - 192.26.230.255 
	{ 0xc01ae700, 0xc01ae7ff, REGISTRY_RIPENCC    }, // 192.26.231.0    - 192.26.231.255 
	{ 0xc01ae800, 0xc01ae8ff, REGISTRY_APNIC      }, // 192.26.232.0    - 192.26.232.255 
	{ 0xc01ae900, 0xc01ae9ff, REGISTRY_ARIN       }, // 192.26.233.0    - 192.26.233.255 
	{ 0xc01aea00, 0xc01aeaff, REGISTRY_RIPENCC    }, // 192.26.234.0    - 192.26.234.255 
	{ 0xc01aeb00, 0xc01aebff, REGISTRY_ARIN       }, // 192.26.235.0    - 192.26.235.255 
	{ 0xc01aec00, 0xc01aefff, REGISTRY_RIPENCC    }, // 192.26.236.0    - 192.26.239.255 
	{ 0xc01af000, 0xc01f0dff, REGISTRY_ARIN       }, // 192.26.240.0    - 192.31.13.255  
	{ 0xc01f0e00, 0xc01f0eff, REGISTRY_RIPENCC    }, // 192.31.14.0     - 192.31.14.255  
	{ 0xc01f0f00, 0xc01f16ff, REGISTRY_ARIN       }, // 192.31.15.0     - 192.31.22.255  
	{ 0xc01f1700, 0xc01f17ff, REGISTRY_RIPENCC    }, // 192.31.23.0     - 192.31.23.255  
	{ 0xc01f1800, 0xc01f19ff, REGISTRY_ARIN       }, // 192.31.24.0     - 192.31.25.255  
	{ 0xc01f1a00, 0xc01f1bff, REGISTRY_RIPENCC    }, // 192.31.26.0     - 192.31.27.255  
	{ 0xc01f1c00, 0xc01f1eff, REGISTRY_ARIN       }, // 192.31.28.0     - 192.31.30.255  
	{ 0xc01f1f00, 0xc01f1fff, REGISTRY_RIPENCC    }, // 192.31.31.0     - 192.31.31.255  
	{ 0xc01f2000, 0xc01f27ff, REGISTRY_ARIN       }, // 192.31.32.0     - 192.31.39.255  
	{ 0xc01f2800, 0xc01f28ff, REGISTRY_RIPENCC    }, // 192.31.40.0     - 192.31.40.255  
	{ 0xc01f2900, 0xc01f3dff, REGISTRY_ARIN       }, // 192.31.41.0     - 192.31.61.255  
	{ 0xc01f3e00, 0xc01f3eff, REGISTRY_RIPENCC    }, // 192.31.62.0     - 192.31.62.255  
	{ 0xc01f3f00, 0xc01f65ff, REGISTRY_ARIN       }, // 192.31.63.0     - 192.31.101.255 
	{ 0xc01f6600, 0xc01f66ff, REGISTRY_RIPENCC    }, // 192.31.102.0    - 192.31.102.255 
	{ 0xc01f6700, 0xc01f73ff, REGISTRY_ARIN       }, // 192.31.103.0    - 192.31.115.255 
	{ 0xc01f7400, 0xc01f7cff, REGISTRY_APNIC      }, // 192.31.116.0    - 192.31.124.255 
	{ 0xc01f7d00, 0xc01fa5ff, REGISTRY_ARIN       }, // 192.31.125.0    - 192.31.165.255 
	{ 0xc01fa600, 0xc01fabff, REGISTRY_RIPENCC    }, // 192.31.166.0    - 192.31.171.255 
	{ 0xc01fac00, 0xc01fc3ff, REGISTRY_ARIN       }, // 192.31.172.0    - 192.31.195.255 
	{ 0xc01fc500, 0xc01fceff, REGISTRY_APNIC      }, // 192.31.197.0    - 192.31.206.255 
	{ 0xc01fcf00, 0xc01fd2ff, REGISTRY_ARIN       }, // 192.31.207.0    - 192.31.210.255 
	{ 0xc01fd300, 0xc01fd3ff, REGISTRY_RIPENCC    }, // 192.31.211.0    - 192.31.211.255 
	{ 0xc01fd400, 0xc01fe6ff, REGISTRY_ARIN       }, // 192.31.212.0    - 192.31.230.255 
	{ 0xc01fe700, 0xc01fe7ff, REGISTRY_RIPENCC    }, // 192.31.231.0    - 192.31.231.255 
	{ 0xc01fe800, 0xc01ffbff, REGISTRY_ARIN       }, // 192.31.232.0    - 192.31.251.255 
	{ 0xc01ffc00, 0xc01ffcff, REGISTRY_RIPENCC    }, // 192.31.252.0    - 192.31.252.255 
	{ 0xc01ffd00, 0xc02109ff, REGISTRY_ARIN       }, // 192.31.253.0    - 192.33.9.255   
	{ 0xc0210a00, 0xc0210aff, REGISTRY_AFRINIC    }, // 192.33.10.0     - 192.33.10.255  
	{ 0xc0210b00, 0xc0210eff, REGISTRY_ARIN       }, // 192.33.11.0     - 192.33.14.255  
	{ 0xc0210f00, 0xc02110ff, REGISTRY_RIPENCC    }, // 192.33.15.0     - 192.33.16.255  
	{ 0xc0211100, 0xc02123ff, REGISTRY_ARIN       }, // 192.33.17.0     - 192.33.35.255  
	{ 0xc0212400, 0xc02124ff, REGISTRY_RIPENCC    }, // 192.33.36.0     - 192.33.36.255  
	{ 0xc0212500, 0xc02156ff, REGISTRY_ARIN       }, // 192.33.37.0     - 192.33.86.255  
	{ 0xc0215700, 0xc0216fff, REGISTRY_RIPENCC    }, // 192.33.87.0     - 192.33.111.255 
	{ 0xc0217000, 0xc02170ff, REGISTRY_ARIN       }, // 192.33.112.0    - 192.33.112.255 
	{ 0xc0217100, 0xc02172ff, REGISTRY_RIPENCC    }, // 192.33.113.0    - 192.33.114.255 
	{ 0xc0217300, 0xc02175ff, REGISTRY_ARIN       }, // 192.33.115.0    - 192.33.117.255 
	{ 0xc0217600, 0xc0217fff, REGISTRY_RIPENCC    }, // 192.33.118.0    - 192.33.127.255 
	{ 0xc0218000, 0xc02181ff, REGISTRY_ARIN       }, // 192.33.128.0    - 192.33.129.255 
	{ 0xc0218200, 0xc02183ff, REGISTRY_RIPENCC    }, // 192.33.130.0    - 192.33.131.255 
	{ 0xc0218400, 0xc02186ff, REGISTRY_ARIN       }, // 192.33.132.0    - 192.33.134.255 
	{ 0xc0218700, 0xc02187ff, REGISTRY_APNIC      }, // 192.33.135.0    - 192.33.135.255 
	{ 0xc0218800, 0xc0218eff, REGISTRY_ARIN       }, // 192.33.136.0    - 192.33.142.255 
	{ 0xc0218f00, 0xc02191ff, REGISTRY_RIPENCC    }, // 192.33.143.0    - 192.33.145.255 
	{ 0xc0219200, 0xc02192ff, REGISTRY_ARIN       }, // 192.33.146.0    - 192.33.146.255 
	{ 0xc0219300, 0xc021a6ff, REGISTRY_RIPENCC    }, // 192.33.147.0    - 192.33.166.255 
	{ 0xc021a700, 0xc021a8ff, REGISTRY_ARIN       }, // 192.33.167.0    - 192.33.168.255 
	{ 0xc021a900, 0xc021abff, REGISTRY_RIPENCC    }, // 192.33.169.0    - 192.33.171.255 
	{ 0xc021ac00, 0xc021afff, REGISTRY_ARIN       }, // 192.33.172.0    - 192.33.175.255 
	{ 0xc021b000, 0xc021b6ff, REGISTRY_RIPENCC    }, // 192.33.176.0    - 192.33.182.255 
	{ 0xc021b700, 0xc021bfff, REGISTRY_ARIN       }, // 192.33.183.0    - 192.33.191.255 
	{ 0xc021c000, 0xc021e7ff, REGISTRY_RIPENCC    }, // 192.33.192.0    - 192.33.231.255 
	{ 0xc021e800, 0xc021fdff, REGISTRY_ARIN       }, // 192.33.232.0    - 192.33.253.255 
	{ 0xc021fe00, 0xc021feff, REGISTRY_RIPENCC    }, // 192.33.254.0    - 192.33.254.255 
	{ 0xc021ff00, 0xc02212ff, REGISTRY_ARIN       }, // 192.33.255.0    - 192.34.18.255  
	{ 0xc0221300, 0xc02213ff, REGISTRY_RIPENCC    }, // 192.34.19.0     - 192.34.19.255  
	{ 0xc0221400, 0xc02231ff, REGISTRY_ARIN       }, // 192.34.20.0     - 192.34.49.255  
	{ 0xc0223200, 0xc02232ff, REGISTRY_RIPENCC    }, // 192.34.50.0     - 192.34.50.255  
	{ 0xc0223300, 0xc0226aff, REGISTRY_ARIN       }, // 192.34.51.0     - 192.34.106.255 
	{ 0xc0226b00, 0xc0226bff, REGISTRY_RIPENCC    }, // 192.34.107.0    - 192.34.107.255 
	{ 0xc0226c00, 0xc02273ff, REGISTRY_ARIN       }, // 192.34.108.0    - 192.34.115.255 
	{ 0xc0227400, 0xc02274ff, REGISTRY_RIPENCC    }, // 192.34.116.0    - 192.34.116.255 
	{ 0xc0227500, 0xc022b2ff, REGISTRY_ARIN       }, // 192.34.117.0    - 192.34.178.255 
	{ 0xc022b300, 0xc022b3ff, REGISTRY_RIPENCC    }, // 192.34.179.0    - 192.34.179.255 
	{ 0xc022b400, 0xc022ffff, REGISTRY_ARIN       }, // 192.34.180.0    - 192.34.255.255 
	{ 0xc0230000, 0xc02313ff, REGISTRY_RIPENCC    }, // 192.35.0.0      - 192.35.19.255  
	{ 0xc0231400, 0xc0233aff, REGISTRY_ARIN       }, // 192.35.20.0     - 192.35.58.255  
	{ 0xc0233b00, 0xc0233bff, REGISTRY_APNIC      }, // 192.35.59.0     - 192.35.59.255  
	{ 0xc0233c00, 0xc0233eff, REGISTRY_ARIN       }, // 192.35.60.0     - 192.35.62.255  
	{ 0xc0233f00, 0xc02348ff, REGISTRY_RIPENCC    }, // 192.35.63.0     - 192.35.72.255  
	{ 0xc0234900, 0xc02359ff, REGISTRY_ARIN       }, // 192.35.73.0     - 192.35.89.255  
	{ 0xc0235a00, 0xc0235aff, REGISTRY_RIPENCC    }, // 192.35.90.0     - 192.35.90.255  
	{ 0xc0235b00, 0xc0235dff, REGISTRY_ARIN       }, // 192.35.91.0     - 192.35.93.255  
	{ 0xc0235e00, 0xc0235eff, REGISTRY_RIPENCC    }, // 192.35.94.0     - 192.35.94.255  
	{ 0xc0235f00, 0xc0236bff, REGISTRY_ARIN       }, // 192.35.95.0     - 192.35.107.255 
	{ 0xc0236c00, 0xc0236cff, REGISTRY_RIPENCC    }, // 192.35.108.0    - 192.35.108.255 
	{ 0xc0236d00, 0xc02389ff, REGISTRY_ARIN       }, // 192.35.109.0    - 192.35.137.255 
	{ 0xc0238a00, 0xc0238aff, REGISTRY_RIPENCC    }, // 192.35.138.0    - 192.35.138.255 
	{ 0xc0238b00, 0xc02391ff, REGISTRY_ARIN       }, // 192.35.139.0    - 192.35.145.255 
	{ 0xc0239200, 0xc02392ff, REGISTRY_RIPENCC    }, // 192.35.146.0    - 192.35.146.255 
	{ 0xc0239300, 0xc02394ff, REGISTRY_ARIN       }, // 192.35.147.0    - 192.35.148.255 
	{ 0xc0239500, 0xc02399ff, REGISTRY_RIPENCC    }, // 192.35.149.0    - 192.35.153.255 
	{ 0xc0239a00, 0xc023abff, REGISTRY_ARIN       }, // 192.35.154.0    - 192.35.171.255 
	{ 0xc023ac00, 0xc023acff, REGISTRY_RIPENCC    }, // 192.35.172.0    - 192.35.172.255 
	{ 0xc023ad00, 0xc023b6ff, REGISTRY_ARIN       }, // 192.35.173.0    - 192.35.182.255 
	{ 0xc023b700, 0xc023c0ff, REGISTRY_RIPENCC    }, // 192.35.183.0    - 192.35.192.255 
	{ 0xc023c100, 0xc023c4ff, REGISTRY_ARIN       }, // 192.35.193.0    - 192.35.196.255 
	{ 0xc023c500, 0xc023c6ff, REGISTRY_RIPENCC    }, // 192.35.197.0    - 192.35.198.255 
	{ 0xc023c700, 0xc023ccff, REGISTRY_ARIN       }, // 192.35.199.0    - 192.35.204.255 
	{ 0xc023cd00, 0xc023cfff, REGISTRY_RIPENCC    }, // 192.35.205.0    - 192.35.207.255 
	{ 0xc023d000, 0xc023e4ff, REGISTRY_ARIN       }, // 192.35.208.0    - 192.35.228.255 
	{ 0xc023e500, 0xc023e5ff, REGISTRY_RIPENCC    }, // 192.35.229.0    - 192.35.229.255 
	{ 0xc023e600, 0xc023efff, REGISTRY_ARIN       }, // 192.35.230.0    - 192.35.239.255 
	{ 0xc023f000, 0xc023f4ff, REGISTRY_RIPENCC    }, // 192.35.240.0    - 192.35.244.255 
	{ 0xc023f500, 0xc023f5ff, REGISTRY_ARIN       }, // 192.35.245.0    - 192.35.245.255 
	{ 0xc023f600, 0xc023f7ff, REGISTRY_RIPENCC    }, // 192.35.246.0    - 192.35.247.255 
	{ 0xc023f800, 0xc023f8ff, REGISTRY_APNIC      }, // 192.35.248.0    - 192.35.248.255 
	{ 0xc023f900, 0xc023ffff, REGISTRY_ARIN       }, // 192.35.249.0    - 192.35.255.255 
	{ 0xc0240000, 0xc026ffff, REGISTRY_RIPENCC    }, // 192.36.0.0      - 192.38.255.255 
	{ 0xc0270000, 0xc02844ff, REGISTRY_ARIN       }, // 192.39.0.0      - 192.40.68.255  
	{ 0xc0284500, 0xc02850ff, REGISTRY_RIPENCC    }, // 192.40.69.0     - 192.40.80.255  
	{ 0xc0285100, 0xc028e3ff, REGISTRY_ARIN       }, // 192.40.81.0     - 192.40.227.255 
	{ 0xc028e400, 0xc028e4ff, REGISTRY_RIPENCC    }, // 192.40.228.0    - 192.40.228.255 
	{ 0xc028e500, 0xc02966ff, REGISTRY_ARIN       }, // 192.40.229.0    - 192.41.102.255 
	{ 0xc0296700, 0xc02988ff, REGISTRY_RIPENCC    }, // 192.41.103.0    - 192.41.136.255 
	{ 0xc0298900, 0xc0298bff, REGISTRY_ARIN       }, // 192.41.137.0    - 192.41.139.255 
	{ 0xc0298c00, 0xc02991ff, REGISTRY_RIPENCC    }, // 192.41.140.0    - 192.41.145.255 
	{ 0xc0299200, 0xc02992ff, REGISTRY_APNIC      }, // 192.41.146.0    - 192.41.146.255 
	{ 0xc0299300, 0xc02993ff, REGISTRY_RIPENCC    }, // 192.41.147.0    - 192.41.147.255 
	{ 0xc0299400, 0xc02994ff, REGISTRY_ARIN       }, // 192.41.148.0    - 192.41.148.255 
	{ 0xc0299500, 0xc029a0ff, REGISTRY_RIPENCC    }, // 192.41.149.0    - 192.41.160.255 
	{ 0xc029a100, 0xc029a9ff, REGISTRY_ARIN       }, // 192.41.161.0    - 192.41.169.255 
	{ 0xc029aa00, 0xc029aaff, REGISTRY_APNIC      }, // 192.41.170.0    - 192.41.170.255 
	{ 0xc029ab00, 0xc029b1ff, REGISTRY_ARIN       }, // 192.41.171.0    - 192.41.177.255 
	{ 0xc029b200, 0xc029c5ff, REGISTRY_APNIC      }, // 192.41.178.0    - 192.41.197.255 
	{ 0xc029c600, 0xc029caff, REGISTRY_ARIN       }, // 192.41.198.0    - 192.41.202.255 
	{ 0xc029cb00, 0xc029cbff, REGISTRY_APNIC      }, // 192.41.203.0    - 192.41.203.255 
	{ 0xc029cc00, 0xc029cdff, REGISTRY_ARIN       }, // 192.41.204.0    - 192.41.205.255 
	{ 0xc029ce00, 0xc029ceff, REGISTRY_APNIC      }, // 192.41.206.0    - 192.41.206.255 
	{ 0xc029cf00, 0xc029d1ff, REGISTRY_ARIN       }, // 192.41.207.0    - 192.41.209.255 
	{ 0xc029d200, 0xc029d2ff, REGISTRY_RIPENCC    }, // 192.41.210.0    - 192.41.210.255 
	{ 0xc029d300, 0xc029d7ff, REGISTRY_ARIN       }, // 192.41.211.0    - 192.41.215.255 
	{ 0xc029d800, 0xc029d8ff, REGISTRY_RIPENCC    }, // 192.41.216.0    - 192.41.216.255 
	{ 0xc029d900, 0xc029d9ff, REGISTRY_ARIN       }, // 192.41.217.0    - 192.41.217.255 
	{ 0xc029da00, 0xc029daff, REGISTRY_RIPENCC    }, // 192.41.218.0    - 192.41.218.255 
	{ 0xc029db00, 0xc029e2ff, REGISTRY_ARIN       }, // 192.41.219.0    - 192.41.226.255 
	{ 0xc029e300, 0xc029e3ff, REGISTRY_RIPENCC    }, // 192.41.227.0    - 192.41.227.255 
	{ 0xc029e400, 0xc02a00ff, REGISTRY_ARIN       }, // 192.41.228.0    - 192.42.0.255   
	{ 0xc02a0100, 0xc02a01ff, REGISTRY_RIPENCC    }, // 192.42.1.0      - 192.42.1.255   
	{ 0xc02a0200, 0xc02a29ff, REGISTRY_ARIN       }, // 192.42.2.0      - 192.42.41.255  
	{ 0xc02a2a00, 0xc02a2fff, REGISTRY_RIPENCC    }, // 192.42.42.0     - 192.42.47.255  
	{ 0xc02a3000, 0xc02a33ff, REGISTRY_ARIN       }, // 192.42.48.0     - 192.42.51.255  
	{ 0xc02a3500, 0xc02a35ff, REGISTRY_RIPENCC    }, // 192.42.53.0     - 192.42.53.255  
	{ 0xc02a3600, 0xc02a3bff, REGISTRY_ARIN       }, // 192.42.54.0     - 192.42.59.255  
	{ 0xc02a3c00, 0xc02a3eff, REGISTRY_APNIC      }, // 192.42.60.0     - 192.42.62.255  
	{ 0xc02a3f00, 0xc02a40ff, REGISTRY_RIPENCC    }, // 192.42.63.0     - 192.42.64.255  
	{ 0xc02a4200, 0xc02a53ff, REGISTRY_ARIN       }, // 192.42.66.0     - 192.42.83.255  
	{ 0xc02a5700, 0xc02a57ff, REGISTRY_RIPENCC    }, // 192.42.87.0     - 192.42.87.255  
	{ 0xc02a5800, 0xc02a62ff, REGISTRY_ARIN       }, // 192.42.88.0     - 192.42.98.255  
	{ 0xc02a6300, 0xc02a63ff, REGISTRY_AFRINIC    }, // 192.42.99.0     - 192.42.99.255  
	{ 0xc02a6400, 0xc02a64ff, REGISTRY_RIPENCC    }, // 192.42.100.0    - 192.42.100.255 
	{ 0xc02a6500, 0xc02a65ff, REGISTRY_ARIN       }, // 192.42.101.0    - 192.42.101.255 
	{ 0xc02a6600, 0xc02a66ff, REGISTRY_RIPENCC    }, // 192.42.102.0    - 192.42.102.255 
	{ 0xc02a6700, 0xc02a6bff, REGISTRY_APNIC      }, // 192.42.103.0    - 192.42.107.255 
	{ 0xc02a6c00, 0xc02a70ff, REGISTRY_ARIN       }, // 192.42.108.0    - 192.42.112.255 
	{ 0xc02a7100, 0xc02a84ff, REGISTRY_RIPENCC    }, // 192.42.113.0    - 192.42.132.255 
	{ 0xc02a8500, 0xc02a8eff, REGISTRY_ARIN       }, // 192.42.133.0    - 192.42.142.255 
	{ 0xc02a8f00, 0xc02a8fff, REGISTRY_RIPENCC    }, // 192.42.143.0    - 192.42.143.255 
	{ 0xc02a9000, 0xc02a96ff, REGISTRY_ARIN       }, // 192.42.144.0    - 192.42.150.255 
	{ 0xc02a9700, 0xc02a97ff, REGISTRY_APNIC      }, // 192.42.151.0    - 192.42.151.255 
	{ 0xc02a9800, 0xc02ab3ff, REGISTRY_ARIN       }, // 192.42.152.0    - 192.42.179.255 
	{ 0xc02ab400, 0xc02ac9ff, REGISTRY_RIPENCC    }, // 192.42.180.0    - 192.42.201.255 
	{ 0xc02aca00, 0xc02aecff, REGISTRY_ARIN       }, // 192.42.202.0    - 192.42.236.255 
	{ 0xc02aed00, 0xc02aedff, REGISTRY_APNIC      }, // 192.42.237.0    - 192.42.237.255 
	{ 0xc02aee00, 0xc02afcff, REGISTRY_ARIN       }, // 192.42.238.0    - 192.42.252.255 
	{ 0xc02afd00, 0xc02afdff, REGISTRY_RIPENCC    }, // 192.42.253.0    - 192.42.253.255 
	{ 0xc02afe00, 0xc02ba1ff, REGISTRY_ARIN       }, // 192.42.254.0    - 192.43.161.255 
	{ 0xc02ba200, 0xc02babff, REGISTRY_RIPENCC    }, // 192.43.162.0    - 192.43.171.255 
	{ 0xc02bac00, 0xc02badff, REGISTRY_ARIN       }, // 192.43.172.0    - 192.43.173.255 
	{ 0xc02baf00, 0xc02bb8ff, REGISTRY_ARIN       }, // 192.43.175.0    - 192.43.184.255 
	{ 0xc02bb900, 0xc02bb9ff, REGISTRY_APNIC      }, // 192.43.185.0    - 192.43.185.255 
	{ 0xc02bba00, 0xc02bbcff, REGISTRY_ARIN       }, // 192.43.186.0    - 192.43.188.255 
	{ 0xc02bbe00, 0xc02bbfff, REGISTRY_ARIN       }, // 192.43.190.0    - 192.43.191.255 
	{ 0xc02bc000, 0xc02bc4ff, REGISTRY_RIPENCC    }, // 192.43.192.0    - 192.43.196.255 
	{ 0xc02bc500, 0xc02bc5ff, REGISTRY_ARIN       }, // 192.43.197.0    - 192.43.197.255 
	{ 0xc02bc600, 0xc02bc6ff, REGISTRY_APNIC      }, // 192.43.198.0    - 192.43.198.255 
	{ 0xc02bc700, 0xc02bc8ff, REGISTRY_ARIN       }, // 192.43.199.0    - 192.43.200.255 
	{ 0xc02bcb00, 0xc02bceff, REGISTRY_ARIN       }, // 192.43.203.0    - 192.43.206.255 
	{ 0xc02bcf00, 0xc02bd1ff, REGISTRY_APNIC      }, // 192.43.207.0    - 192.43.209.255 
	{ 0xc02bd200, 0xc02bd2ff, REGISTRY_RIPENCC    }, // 192.43.210.0    - 192.43.210.255 
	{ 0xc02bd300, 0xc02bd3ff, REGISTRY_ARIN       }, // 192.43.211.0    - 192.43.211.255 
	{ 0xc02bd400, 0xc02bd4ff, REGISTRY_RIPENCC    }, // 192.43.212.0    - 192.43.212.255 
	{ 0xc02bd500, 0xc02be1ff, REGISTRY_ARIN       }, // 192.43.213.0    - 192.43.225.255 
	{ 0xc02be200, 0xc02be5ff, REGISTRY_APNIC      }, // 192.43.226.0    - 192.43.229.255 
	{ 0xc02be600, 0xc02be9ff, REGISTRY_ARIN       }, // 192.43.230.0    - 192.43.233.255 
	{ 0xc02bea00, 0xc02beaff, REGISTRY_RIPENCC    }, // 192.43.234.0    - 192.43.234.255 
	{ 0xc02beb00, 0xc02beeff, REGISTRY_ARIN       }, // 192.43.235.0    - 192.43.238.255 
	{ 0xc02bef00, 0xc02befff, REGISTRY_APNIC      }, // 192.43.239.0    - 192.43.239.255 
	{ 0xc02bf000, 0xc02bffff, REGISTRY_ARIN       }, // 192.43.240.0    - 192.43.255.255 
	{ 0xc02c0000, 0xc02c43ff, REGISTRY_RIPENCC    }, // 192.44.0.0      - 192.44.67.255  
	{ 0xc02c4400, 0xc02c46ff, REGISTRY_ARIN       }, // 192.44.68.0     - 192.44.70.255  
	{ 0xc02c4700, 0xc02c5aff, REGISTRY_RIPENCC    }, // 192.44.71.0     - 192.44.90.255  
	{ 0xc02c5b00, 0xc02cefff, REGISTRY_ARIN       }, // 192.44.91.0     - 192.44.239.255 
	{ 0xc02cf000, 0xc02cfbff, REGISTRY_RIPENCC    }, // 192.44.240.0    - 192.44.251.255 
	{ 0xc02cfc00, 0xc02effff, REGISTRY_ARIN       }, // 192.44.252.0    - 192.46.255.255 
	{ 0xc02f0000, 0xc02f1bff, REGISTRY_APNIC      }, // 192.47.0.0      - 192.47.27.255  
	{ 0xc02f1d00, 0xc02f23ff, REGISTRY_APNIC      }, // 192.47.29.0     - 192.47.35.255  
	{ 0xc02f2500, 0xc02ff1ff, REGISTRY_APNIC      }, // 192.47.37.0     - 192.47.241.255 
	{ 0xc02ff200, 0xc02ff3ff, REGISTRY_ARIN       }, // 192.47.242.0    - 192.47.243.255 
	{ 0xc02ff400, 0xc02ff9ff, REGISTRY_RIPENCC    }, // 192.47.244.0    - 192.47.249.255 
	{ 0xc02ffa00, 0xc0301eff, REGISTRY_ARIN       }, // 192.47.250.0    - 192.48.30.255  
	{ 0xc0301f00, 0xc0301fff, REGISTRY_RIPENCC    }, // 192.48.31.0     - 192.48.31.255  
	{ 0xc0302000, 0xc0306aff, REGISTRY_ARIN       }, // 192.48.32.0     - 192.48.106.255 
	{ 0xc0306b00, 0xc0306bff, REGISTRY_RIPENCC    }, // 192.48.107.0    - 192.48.107.255 
	{ 0xc0306c00, 0xc0306cff, REGISTRY_ARIN       }, // 192.48.108.0    - 192.48.108.255 
	{ 0xc0306d00, 0xc0306eff, REGISTRY_APNIC      }, // 192.48.109.0    - 192.48.110.255 
	{ 0xc0306f00, 0xc03090ff, REGISTRY_ARIN       }, // 192.48.111.0    - 192.48.144.255 
	{ 0xc0309100, 0xc03091ff, REGISTRY_RIPENCC    }, // 192.48.145.0    - 192.48.145.255 
	{ 0xc0309200, 0xc030dfff, REGISTRY_ARIN       }, // 192.48.146.0    - 192.48.223.255 
	{ 0xc030e000, 0xc030e0ff, REGISTRY_RIPENCC    }, // 192.48.224.0    - 192.48.224.255 
	{ 0xc030e100, 0xc030e6ff, REGISTRY_ARIN       }, // 192.48.225.0    - 192.48.230.255 
	{ 0xc030e700, 0xc030e7ff, REGISTRY_RIPENCC    }, // 192.48.231.0    - 192.48.231.255 
	{ 0xc030e800, 0xc030f7ff, REGISTRY_ARIN       }, // 192.48.232.0    - 192.48.247.255 
	{ 0xc030f900, 0xc030fcff, REGISTRY_ARIN       }, // 192.48.249.0    - 192.48.252.255 
	{ 0xc030fd00, 0xc030fdff, REGISTRY_AFRINIC    }, // 192.48.253.0    - 192.48.253.255 
	{ 0xc030fe00, 0xc030ffff, REGISTRY_ARIN       }, // 192.48.254.0    - 192.48.255.255 
	{ 0xc0310000, 0xc031ffff, REGISTRY_RIPENCC    }, // 192.49.0.0      - 192.49.255.255 
	{ 0xc0320000, 0xc032ffff, REGISTRY_APNIC      }, // 192.50.0.0      - 192.50.255.255 
	{ 0xc0330000, 0xc0330fff, REGISTRY_RIPENCC    }, // 192.51.0.0      - 192.51.15.255  
	{ 0xc0331000, 0xc0332fff, REGISTRY_APNIC      }, // 192.51.16.0     - 192.51.47.255  
	{ 0xc0333000, 0xc03330ff, REGISTRY_ARIN       }, // 192.51.48.0     - 192.51.48.255  
	{ 0xc0333100, 0xc033abff, REGISTRY_APNIC      }, // 192.51.49.0     - 192.51.171.255 
	{ 0xc033b000, 0xc033bbff, REGISTRY_APNIC      }, // 192.51.176.0    - 192.51.187.255 
	{ 0xc033bd00, 0xc033bfff, REGISTRY_APNIC      }, // 192.51.189.0    - 192.51.191.255 
	{ 0xc033c000, 0xc033c1ff, REGISTRY_ARIN       }, // 192.51.192.0    - 192.51.193.255 
	{ 0xc033c200, 0xc033efff, REGISTRY_APNIC      }, // 192.51.194.0    - 192.51.239.255 
	{ 0xc033f100, 0xc033fdff, REGISTRY_APNIC      }, // 192.51.241.0    - 192.51.253.255 
	{ 0xc033ff00, 0xc033ffff, REGISTRY_APNIC      }, // 192.51.255.0    - 192.51.255.255 
	{ 0xc0340000, 0xc03432ff, REGISTRY_RIPENCC    }, // 192.52.0.0      - 192.52.50.255  
	{ 0xc0343300, 0xc03447ff, REGISTRY_ARIN       }, // 192.52.51.0     - 192.52.71.255  
	{ 0xc0344800, 0xc03449ff, REGISTRY_APNIC      }, // 192.52.72.0     - 192.52.73.255  
	{ 0xc0344a00, 0xc03476ff, REGISTRY_ARIN       }, // 192.52.74.0     - 192.52.118.255 
	{ 0xc0349700, 0xc03497ff, REGISTRY_ARIN       }, // 192.52.151.0    - 192.52.151.255 
	{ 0xc0349800, 0xc03498ff, REGISTRY_RIPENCC    }, // 192.52.152.0    - 192.52.152.255 
	{ 0xc0349900, 0xc0349eff, REGISTRY_ARIN       }, // 192.52.153.0    - 192.52.158.255 
	{ 0xc0349f00, 0xc034a1ff, REGISTRY_RIPENCC    }, // 192.52.159.0    - 192.52.161.255 
	{ 0xc034a200, 0xc034aaff, REGISTRY_ARIN       }, // 192.52.162.0    - 192.52.170.255 
	{ 0xc034ab00, 0xc034b0ff, REGISTRY_APNIC      }, // 192.52.171.0    - 192.52.176.255 
	{ 0xc034b100, 0xc034b8ff, REGISTRY_ARIN       }, // 192.52.177.0    - 192.52.184.255 
	{ 0xc034ba00, 0xc034c0ff, REGISTRY_ARIN       }, // 192.52.186.0    - 192.52.192.255 
	{ 0xc034c200, 0xc034c3ff, REGISTRY_ARIN       }, // 192.52.194.0    - 192.52.195.255 
	{ 0xc034c600, 0xc034dcff, REGISTRY_ARIN       }, // 192.52.198.0    - 192.52.220.255 
	{ 0xc034dd00, 0xc034dfff, REGISTRY_RIPENCC    }, // 192.52.221.0    - 192.52.223.255 
	{ 0xc034e000, 0xc034e7ff, REGISTRY_ARIN       }, // 192.52.224.0    - 192.52.231.255 
	{ 0xc034e800, 0xc034e8ff, REGISTRY_AFRINIC    }, // 192.52.232.0    - 192.52.232.255 
	{ 0xc034e900, 0xc034fcff, REGISTRY_ARIN       }, // 192.52.233.0    - 192.52.252.255 
	{ 0xc034fd00, 0xc034feff, REGISTRY_RIPENCC    }, // 192.52.253.0    - 192.52.254.255 
	{ 0xc034ff00, 0xc03566ff, REGISTRY_ARIN       }, // 192.52.255.0    - 192.53.102.255 
	{ 0xc0356700, 0xc03568ff, REGISTRY_RIPENCC    }, // 192.53.103.0    - 192.53.104.255 
	{ 0xc0356900, 0xc0361eff, REGISTRY_ARIN       }, // 192.53.105.0    - 192.54.30.255  
	{ 0xc0361f00, 0xc03634ff, REGISTRY_RIPENCC    }, // 192.54.31.0     - 192.54.52.255  
	{ 0xc0363500, 0xc03635ff, REGISTRY_ARIN       }, // 192.54.53.0     - 192.54.53.255  
	{ 0xc0363c00, 0xc0364bff, REGISTRY_RIPENCC    }, // 192.54.60.0     - 192.54.75.255  
	{ 0xc0364e00, 0xc03650ff, REGISTRY_RIPENCC    }, // 192.54.78.0     - 192.54.80.255  
	{ 0xc0365100, 0xc03667ff, REGISTRY_ARIN       }, // 192.54.81.0     - 192.54.103.255 
	{ 0xc0366800, 0xc03668ff, REGISTRY_RIPENCC    }, // 192.54.104.0    - 192.54.104.255 
	{ 0xc0366900, 0xc0366aff, REGISTRY_APNIC      }, // 192.54.105.0    - 192.54.106.255 
	{ 0xc0366b00, 0xc03670ff, REGISTRY_ARIN       }, // 192.54.107.0    - 192.54.112.255 
	{ 0xc0367100, 0xc03671ff, REGISTRY_RIPENCC    }, // 192.54.113.0    - 192.54.113.255 
	{ 0xc0367200, 0xc03672ff, REGISTRY_ARIN       }, // 192.54.114.0    - 192.54.114.255 
	{ 0xc0367300, 0xc03678ff, REGISTRY_RIPENCC    }, // 192.54.115.0    - 192.54.120.255 
	{ 0xc0367900, 0xc03679ff, REGISTRY_ARIN       }, // 192.54.121.0    - 192.54.121.255 
	{ 0xc0367a00, 0xc0367aff, REGISTRY_RIPENCC    }, // 192.54.122.0    - 192.54.122.255 
	{ 0xc0367b00, 0xc0367cff, REGISTRY_ARIN       }, // 192.54.123.0    - 192.54.124.255 
	{ 0xc0367d00, 0xc03680ff, REGISTRY_RIPENCC    }, // 192.54.125.0    - 192.54.128.255 
	{ 0xc0368100, 0xc03681ff, REGISTRY_ARIN       }, // 192.54.129.0    - 192.54.129.255 
	{ 0xc0368200, 0xc03682ff, REGISTRY_APNIC      }, // 192.54.130.0    - 192.54.130.255 
	{ 0xc0368300, 0xc03683ff, REGISTRY_ARIN       }, // 192.54.131.0    - 192.54.131.255 
	{ 0xc0368400, 0xc03684ff, REGISTRY_RIPENCC    }, // 192.54.132.0    - 192.54.132.255 
	{ 0xc0368500, 0xc03686ff, REGISTRY_ARIN       }, // 192.54.133.0    - 192.54.134.255 
	{ 0xc0368700, 0xc03687ff, REGISTRY_APNIC      }, // 192.54.135.0    - 192.54.135.255 
	{ 0xc0368800, 0xc03688ff, REGISTRY_ARIN       }, // 192.54.136.0    - 192.54.136.255 
	{ 0xc0368a00, 0xc0368aff, REGISTRY_ARIN       }, // 192.54.138.0    - 192.54.138.255 
	{ 0xc0368b00, 0xc0368bff, REGISTRY_RIPENCC    }, // 192.54.139.0    - 192.54.139.255 
	{ 0xc0368c00, 0xc0368cff, REGISTRY_ARIN       }, // 192.54.140.0    - 192.54.140.255 
	{ 0xc0368d00, 0xc036ddff, REGISTRY_RIPENCC    }, // 192.54.141.0    - 192.54.221.255 
	{ 0xc036de00, 0xc036e0ff, REGISTRY_ARIN       }, // 192.54.222.0    - 192.54.224.255 
	{ 0xc036e100, 0xc036e1ff, REGISTRY_RIPENCC    }, // 192.54.225.0    - 192.54.225.255 
	{ 0xc036e200, 0xc036f3ff, REGISTRY_ARIN       }, // 192.54.226.0    - 192.54.243.255 
	{ 0xc036f500, 0xc036f5ff, REGISTRY_RIPENCC    }, // 192.54.245.0    - 192.54.245.255 
	{ 0xc036f600, 0xc036f6ff, REGISTRY_ARIN       }, // 192.54.246.0    - 192.54.246.255 
	{ 0xc036f800, 0xc036faff, REGISTRY_ARIN       }, // 192.54.248.0    - 192.54.250.255 
	{ 0xc036fb00, 0xc036fbff, REGISTRY_APNIC      }, // 192.54.251.0    - 192.54.251.255 
	{ 0xc036fc00, 0xc036fdff, REGISTRY_ARIN       }, // 192.54.252.0    - 192.54.253.255 
	{ 0xc036fe00, 0xc036feff, REGISTRY_RIPENCC    }, // 192.54.254.0    - 192.54.254.255 
	{ 0xc036ff00, 0xc03753ff, REGISTRY_ARIN       }, // 192.54.255.0    - 192.55.83.255  
	{ 0xc0375400, 0xc03754ff, REGISTRY_RIPENCC    }, // 192.55.84.0     - 192.55.84.255  
	{ 0xc0375500, 0xc03758ff, REGISTRY_ARIN       }, // 192.55.85.0     - 192.55.88.255  
	{ 0xc0375900, 0xc03759ff, REGISTRY_RIPENCC    }, // 192.55.89.0     - 192.55.89.255  
	{ 0xc0375a00, 0xc03761ff, REGISTRY_ARIN       }, // 192.55.90.0     - 192.55.97.255  
	{ 0xc0376200, 0xc03763ff, REGISTRY_APNIC      }, // 192.55.98.0     - 192.55.99.255  
	{ 0xc0376400, 0xc03764ff, REGISTRY_ARIN       }, // 192.55.100.0    - 192.55.100.255 
	{ 0xc0376500, 0xc03765ff, REGISTRY_RIPENCC    }, // 192.55.101.0    - 192.55.101.255 
	{ 0xc0376600, 0xc03768ff, REGISTRY_ARIN       }, // 192.55.102.0    - 192.55.104.255 
	{ 0xc0376900, 0xc03769ff, REGISTRY_RIPENCC    }, // 192.55.105.0    - 192.55.105.255 
	{ 0xc0376a00, 0xc0376cff, REGISTRY_ARIN       }, // 192.55.106.0    - 192.55.108.255 
	{ 0xc0376d00, 0xc0376dff, REGISTRY_RIPENCC    }, // 192.55.109.0    - 192.55.109.255 
	{ 0xc0376f00, 0xc0376fff, REGISTRY_ARIN       }, // 192.55.111.0    - 192.55.111.255 
	{ 0xc0377000, 0xc03770ff, REGISTRY_APNIC      }, // 192.55.112.0    - 192.55.112.255 
	{ 0xc0377100, 0xc03772ff, REGISTRY_ARIN       }, // 192.55.113.0    - 192.55.114.255 
	{ 0xc0377300, 0xc03773ff, REGISTRY_RIPENCC    }, // 192.55.115.0    - 192.55.115.255 
	{ 0xc0377400, 0xc03775ff, REGISTRY_ARIN       }, // 192.55.116.0    - 192.55.117.255 
	{ 0xc0377600, 0xc03776ff, REGISTRY_APNIC      }, // 192.55.118.0    - 192.55.118.255 
	{ 0xc0377700, 0xc03780ff, REGISTRY_ARIN       }, // 192.55.119.0    - 192.55.128.255 
	{ 0xc0378100, 0xc03781ff, REGISTRY_RIPENCC    }, // 192.55.129.0    - 192.55.129.255 
	{ 0xc0378200, 0xc03783ff, REGISTRY_ARIN       }, // 192.55.130.0    - 192.55.131.255 
	{ 0xc0378400, 0xc03784ff, REGISTRY_RIPENCC    }, // 192.55.132.0    - 192.55.132.255 
	{ 0xc0378500, 0xc037bbff, REGISTRY_ARIN       }, // 192.55.133.0    - 192.55.187.255 
	{ 0xc037bc00, 0xc037bcff, REGISTRY_RIPENCC    }, // 192.55.188.0    - 192.55.188.255 
	{ 0xc037bd00, 0xc037bdff, REGISTRY_ARIN       }, // 192.55.189.0    - 192.55.189.255 
	{ 0xc037be00, 0xc037beff, REGISTRY_APNIC      }, // 192.55.190.0    - 192.55.190.255 
	{ 0xc037bf00, 0xc037c0ff, REGISTRY_ARIN       }, // 192.55.191.0    - 192.55.192.255 
	{ 0xc037c100, 0xc037c1ff, REGISTRY_RIPENCC    }, // 192.55.193.0    - 192.55.193.255 
	{ 0xc037c200, 0xc037c4ff, REGISTRY_ARIN       }, // 192.55.194.0    - 192.55.196.255 
	{ 0xc037c500, 0xc037c5ff, REGISTRY_RIPENCC    }, // 192.55.197.0    - 192.55.197.255 
	{ 0xc037c600, 0xc037c6ff, REGISTRY_APNIC      }, // 192.55.198.0    - 192.55.198.255 
	{ 0xc037c700, 0xc037d0ff, REGISTRY_ARIN       }, // 192.55.199.0    - 192.55.208.255 
	{ 0xc037d200, 0xc037d3ff, REGISTRY_ARIN       }, // 192.55.210.0    - 192.55.211.255 
	{ 0xc037d400, 0xc037d4ff, REGISTRY_RIPENCC    }, // 192.55.212.0    - 192.55.212.255 
	{ 0xc037d500, 0xc037daff, REGISTRY_ARIN       }, // 192.55.213.0    - 192.55.218.255 
	{ 0xc037db00, 0xc037dcff, REGISTRY_APNIC      }, // 192.55.219.0    - 192.55.220.255 
	{ 0xc037dd00, 0xc037e7ff, REGISTRY_ARIN       }, // 192.55.221.0    - 192.55.231.255 
	{ 0xc037e800, 0xc037e8ff, REGISTRY_APNIC      }, // 192.55.232.0    - 192.55.232.255 
	{ 0xc037e900, 0xc037edff, REGISTRY_ARIN       }, // 192.55.233.0    - 192.55.237.255 
	{ 0xc037ef00, 0xc037f3ff, REGISTRY_ARIN       }, // 192.55.239.0    - 192.55.243.255 
	{ 0xc037f400, 0xc037f4ff, REGISTRY_RIPENCC    }, // 192.55.244.0    - 192.55.244.255 
	{ 0xc037f500, 0xc03a08ff, REGISTRY_ARIN       }, // 192.55.245.0    - 192.58.8.255   
	{ 0xc03a0900, 0xc03a12ff, REGISTRY_APNIC      }, // 192.58.9.0      - 192.58.18.255  
	{ 0xc03a1300, 0xc03a1bff, REGISTRY_ARIN       }, // 192.58.19.0     - 192.58.27.255  
	{ 0xc03a1c00, 0xc03a23ff, REGISTRY_RIPENCC    }, // 192.58.28.0     - 192.58.35.255  
	{ 0xc03a2400, 0xc03a28ff, REGISTRY_ARIN       }, // 192.58.36.0     - 192.58.40.255  
	{ 0xc03a2900, 0xc03a59ff, REGISTRY_RIPENCC    }, // 192.58.41.0     - 192.58.89.255  
	{ 0xc03a5a00, 0xc03a60ff, REGISTRY_ARIN       }, // 192.58.90.0     - 192.58.96.255  
	{ 0xc03a6600, 0xc03a84ff, REGISTRY_ARIN       }, // 192.58.102.0    - 192.58.132.255 
	{ 0xc03a8500, 0xc03a88ff, REGISTRY_APNIC      }, // 192.58.133.0    - 192.58.136.255 
	{ 0xc03a8900, 0xc03ac4ff, REGISTRY_ARIN       }, // 192.58.137.0    - 192.58.196.255 
	{ 0xc03ac500, 0xc03ac5ff, REGISTRY_RIPENCC    }, // 192.58.197.0    - 192.58.197.255 
	{ 0xc03ac600, 0xc03ad9ff, REGISTRY_ARIN       }, // 192.58.198.0    - 192.58.217.255 
	{ 0xc03ada00, 0xc03adaff, REGISTRY_RIPENCC    }, // 192.58.218.0    - 192.58.218.255 
	{ 0xc03adb00, 0xc0401bff, REGISTRY_ARIN       }, // 192.58.219.0    - 192.64.27.255  
	{ 0xc0401c00, 0xc0401cff, REGISTRY_RIPENCC    }, // 192.64.28.0     - 192.64.28.255  
	{ 0xc0401d00, 0xc0402bff, REGISTRY_ARIN       }, // 192.64.29.0     - 192.64.43.255  
	{ 0xc0402c00, 0xc0402dff, REGISTRY_RIPENCC    }, // 192.64.44.0     - 192.64.45.255  
	{ 0xc0402e00, 0xc04063ff, REGISTRY_ARIN       }, // 192.64.46.0     - 192.64.99.255  
	{ 0xc0406400, 0xc04067ff, REGISTRY_RIPENCC    }, // 192.64.100.0    - 192.64.103.255 
	{ 0xc0406800, 0xc0407cff, REGISTRY_ARIN       }, // 192.64.104.0    - 192.64.124.255 
	{ 0xc0407d00, 0xc0407dff, REGISTRY_RIPENCC    }, // 192.64.125.0    - 192.64.125.255 
	{ 0xc0407e00, 0xc040c9ff, REGISTRY_ARIN       }, // 192.64.126.0    - 192.64.201.255 
	{ 0xc040ca00, 0xc040caff, REGISTRY_RIPENCC    }, // 192.64.202.0    - 192.64.202.255 
	{ 0xc040cb00, 0xc04132ff, REGISTRY_ARIN       }, // 192.64.203.0    - 192.65.50.255  
	{ 0xc0413300, 0xc04146ff, REGISTRY_RIPENCC    }, // 192.65.51.0     - 192.65.70.255  
	{ 0xc0414700, 0xc04151ff, REGISTRY_ARIN       }, // 192.65.71.0     - 192.65.81.255  
	{ 0xc0415200, 0xc0415bff, REGISTRY_APNIC      }, // 192.65.82.0     - 192.65.91.255  
	{ 0xc0415c00, 0xc0415eff, REGISTRY_RIPENCC    }, // 192.65.92.0     - 192.65.94.255  
	{ 0xc0415f00, 0xc0415fff, REGISTRY_ARIN       }, // 192.65.95.0     - 192.65.95.255  
	{ 0xc0416000, 0xc04160ff, REGISTRY_RIPENCC    }, // 192.65.96.0     - 192.65.96.255  
	{ 0xc0416100, 0xc04181ff, REGISTRY_ARIN       }, // 192.65.97.0     - 192.65.129.255 
	{ 0xc0418200, 0xc04182ff, REGISTRY_APNIC      }, // 192.65.130.0    - 192.65.130.255 
	{ 0xc0418300, 0xc04184ff, REGISTRY_RIPENCC    }, // 192.65.131.0    - 192.65.132.255 
	{ 0xc0418500, 0xc0418aff, REGISTRY_ARIN       }, // 192.65.133.0    - 192.65.138.255 
	{ 0xc0418b00, 0xc0418bff, REGISTRY_RIPENCC    }, // 192.65.139.0    - 192.65.139.255 
	{ 0xc0418c00, 0xc0418fff, REGISTRY_ARIN       }, // 192.65.140.0    - 192.65.143.255 
	{ 0xc0419000, 0xc04192ff, REGISTRY_RIPENCC    }, // 192.65.144.0    - 192.65.146.255 
	{ 0xc0419300, 0xc04197ff, REGISTRY_ARIN       }, // 192.65.147.0    - 192.65.151.255 
	{ 0xc0419800, 0xc04198ff, REGISTRY_LACNIC     }, // 192.65.152.0    - 192.65.152.255 
	{ 0xc0419900, 0xc04199ff, REGISTRY_RIPENCC    }, // 192.65.153.0    - 192.65.153.255 
	{ 0xc0419a00, 0xc041b5ff, REGISTRY_ARIN       }, // 192.65.154.0    - 192.65.181.255 
	{ 0xc041b600, 0xc041b6ff, REGISTRY_APNIC      }, // 192.65.182.0    - 192.65.182.255 
	{ 0xc041b700, 0xc041c5ff, REGISTRY_RIPENCC    }, // 192.65.183.0    - 192.65.197.255 
	{ 0xc041c600, 0xc041d8ff, REGISTRY_ARIN       }, // 192.65.198.0    - 192.65.216.255 
	{ 0xc041d900, 0xc041d9ff, REGISTRY_APNIC      }, // 192.65.217.0    - 192.65.217.255 
	{ 0xc041da00, 0xc041daff, REGISTRY_ARIN       }, // 192.65.218.0    - 192.65.218.255 
	{ 0xc041db00, 0xc041e4ff, REGISTRY_RIPENCC    }, // 192.65.219.0    - 192.65.228.255 
	{ 0xc041e500, 0xc041f7ff, REGISTRY_ARIN       }, // 192.65.229.0    - 192.65.247.255 
	{ 0xc041f900, 0xc041f9ff, REGISTRY_ARIN       }, // 192.65.249.0    - 192.65.249.255 
	{ 0xc041fb00, 0xc041ffff, REGISTRY_ARIN       }, // 192.65.251.0    - 192.65.255.255 
	{ 0xc0420000, 0xc042ffff, REGISTRY_RIPENCC    }, // 192.66.0.0      - 192.66.255.255 
	{ 0xc0430000, 0xc04300ff, REGISTRY_ARIN       }, // 192.67.0.0      - 192.67.0.255   
	{ 0xc0430200, 0xc04302ff, REGISTRY_ARIN       }, // 192.67.2.0      - 192.67.2.255   
	{ 0xc0430300, 0xc04304ff, REGISTRY_RIPENCC    }, // 192.67.3.0      - 192.67.4.255   
	{ 0xc0430500, 0xc0430bff, REGISTRY_ARIN       }, // 192.67.5.0      - 192.67.11.255  
	{ 0xc0430c00, 0xc0430cff, REGISTRY_APNIC      }, // 192.67.12.0     - 192.67.12.255  
	{ 0xc0430d00, 0xc04316ff, REGISTRY_ARIN       }, // 192.67.13.0     - 192.67.22.255  
	{ 0xc0431800, 0xc04326ff, REGISTRY_ARIN       }, // 192.67.24.0     - 192.67.38.255  
	{ 0xc0432700, 0xc04327ff, REGISTRY_RIPENCC    }, // 192.67.39.0     - 192.67.39.255  
	{ 0xc0432800, 0xc0432aff, REGISTRY_ARIN       }, // 192.67.40.0     - 192.67.42.255  
	{ 0xc0432b00, 0xc0432bff, REGISTRY_RIPENCC    }, // 192.67.43.0     - 192.67.43.255  
	{ 0xc0432c00, 0xc0432eff, REGISTRY_ARIN       }, // 192.67.44.0     - 192.67.46.255  
	{ 0xc0432f00, 0xc0432fff, REGISTRY_RIPENCC    }, // 192.67.47.0     - 192.67.47.255  
	{ 0xc0433000, 0xc04331ff, REGISTRY_ARIN       }, // 192.67.48.0     - 192.67.49.255  
	{ 0xc0433200, 0xc04332ff, REGISTRY_RIPENCC    }, // 192.67.50.0     - 192.67.50.255  
	{ 0xc0433300, 0xc04333ff, REGISTRY_ARIN       }, // 192.67.51.0     - 192.67.51.255  
	{ 0xc0433400, 0xc04334ff, REGISTRY_RIPENCC    }, // 192.67.52.0     - 192.67.52.255  
	{ 0xc0433500, 0xc04336ff, REGISTRY_ARIN       }, // 192.67.53.0     - 192.67.54.255  
	{ 0xc0433700, 0xc04337ff, REGISTRY_RIPENCC    }, // 192.67.55.0     - 192.67.55.255  
	{ 0xc0433800, 0xc04339ff, REGISTRY_ARIN       }, // 192.67.56.0     - 192.67.57.255  
	{ 0xc0433a00, 0xc0433aff, REGISTRY_RIPENCC    }, // 192.67.58.0     - 192.67.58.255  
	{ 0xc0433b00, 0xc0434bff, REGISTRY_ARIN       }, // 192.67.59.0     - 192.67.75.255  
	{ 0xc0434c00, 0xc0434cff, REGISTRY_RIPENCC    }, // 192.67.76.0     - 192.67.76.255  
	{ 0xc0434d00, 0xc0434eff, REGISTRY_ARIN       }, // 192.67.77.0     - 192.67.78.255  
	{ 0xc0434f00, 0xc0434fff, REGISTRY_RIPENCC    }, // 192.67.79.0     - 192.67.79.255  
	{ 0xc0435000, 0xc04353ff, REGISTRY_ARIN       }, // 192.67.80.0     - 192.67.83.255  
	{ 0xc0435400, 0xc04354ff, REGISTRY_APNIC      }, // 192.67.84.0     - 192.67.84.255  
	{ 0xc0435600, 0xc04356ff, REGISTRY_ARIN       }, // 192.67.86.0     - 192.67.86.255  
	{ 0xc0435700, 0xc04357ff, REGISTRY_RIPENCC    }, // 192.67.87.0     - 192.67.87.255  
	{ 0xc0435800, 0xc0435dff, REGISTRY_ARIN       }, // 192.67.88.0     - 192.67.93.255  
	{ 0xc0435e00, 0xc0435eff, REGISTRY_RIPENCC    }, // 192.67.94.0     - 192.67.94.255  
	{ 0xc0435f00, 0xc04363ff, REGISTRY_ARIN       }, // 192.67.95.0     - 192.67.99.255  
	{ 0xc0436400, 0xc04368ff, REGISTRY_RIPENCC    }, // 192.67.100.0    - 192.67.104.255 
	{ 0xc0436900, 0xc04386ff, REGISTRY_ARIN       }, // 192.67.105.0    - 192.67.134.255 
	{ 0xc0438700, 0xc04387ff, REGISTRY_RIPENCC    }, // 192.67.135.0    - 192.67.135.255 
	{ 0xc0438800, 0xc043a6ff, REGISTRY_ARIN       }, // 192.67.136.0    - 192.67.166.255 
	{ 0xc043a700, 0xc043a7ff, REGISTRY_RIPENCC    }, // 192.67.167.0    - 192.67.167.255 
	{ 0xc043a900, 0xc043a9ff, REGISTRY_ARIN       }, // 192.67.169.0    - 192.67.169.255 
	{ 0xc043aa00, 0xc043aaff, REGISTRY_RIPENCC    }, // 192.67.170.0    - 192.67.170.255 
	{ 0xc043ab00, 0xc043abff, REGISTRY_APNIC      }, // 192.67.171.0    - 192.67.171.255 
	{ 0xc043ac00, 0xc043bcff, REGISTRY_ARIN       }, // 192.67.172.0    - 192.67.188.255 
	{ 0xc043bd00, 0xc043d0ff, REGISTRY_RIPENCC    }, // 192.67.189.0    - 192.67.208.255 
	{ 0xc043d100, 0xc043d8ff, REGISTRY_ARIN       }, // 192.67.209.0    - 192.67.216.255 
	{ 0xc043da00, 0xc043daff, REGISTRY_RIPENCC    }, // 192.67.218.0    - 192.67.218.255 
	{ 0xc043db00, 0xc043dbff, REGISTRY_ARIN       }, // 192.67.219.0    - 192.67.219.255 
	{ 0xc043dc00, 0xc043ddff, REGISTRY_RIPENCC    }, // 192.67.220.0    - 192.67.221.255 
	{ 0xc043de00, 0xc043deff, REGISTRY_ARIN       }, // 192.67.222.0    - 192.67.222.255 
	{ 0xc043df00, 0xc043dfff, REGISTRY_RIPENCC    }, // 192.67.223.0    - 192.67.223.255 
	{ 0xc043e000, 0xc043f7ff, REGISTRY_ARIN       }, // 192.67.224.0    - 192.67.247.255 
	{ 0xc043f800, 0xc043f8ff, REGISTRY_APNIC      }, // 192.67.248.0    - 192.67.248.255 
	{ 0xc043f900, 0xc043f9ff, REGISTRY_RIPENCC    }, // 192.67.249.0    - 192.67.249.255 
	{ 0xc043fa00, 0xc043ffff, REGISTRY_ARIN       }, // 192.67.250.0    - 192.67.255.255 
	{ 0xc0440000, 0xc04413ff, REGISTRY_RIPENCC    }, // 192.68.0.0      - 192.68.19.255  
	{ 0xc0441400, 0xc04416ff, REGISTRY_ARIN       }, // 192.68.20.0     - 192.68.22.255  
	{ 0xc0441700, 0xc04417ff, REGISTRY_RIPENCC    }, // 192.68.23.0     - 192.68.23.255  
	{ 0xc0441800, 0xc0441eff, REGISTRY_ARIN       }, // 192.68.24.0     - 192.68.30.255  
	{ 0xc0441f00, 0xc04433ff, REGISTRY_RIPENCC    }, // 192.68.31.0     - 192.68.51.255  
	{ 0xc0443400, 0xc0444bff, REGISTRY_ARIN       }, // 192.68.52.0     - 192.68.75.255  
	{ 0xc0444c00, 0xc0446bff, REGISTRY_RIPENCC    }, // 192.68.76.0     - 192.68.107.255 
	{ 0xc0446c00, 0xc0446dff, REGISTRY_ARIN       }, // 192.68.108.0    - 192.68.109.255 
	{ 0xc0447000, 0xc04483ff, REGISTRY_ARIN       }, // 192.68.112.0    - 192.68.131.255 
	{ 0xc0448400, 0xc04484ff, REGISTRY_APNIC      }, // 192.68.132.0    - 192.68.132.255 
	{ 0xc0448500, 0xc04489ff, REGISTRY_ARIN       }, // 192.68.133.0    - 192.68.137.255 
	{ 0xc0448a00, 0xc0448aff, REGISTRY_AFRINIC    }, // 192.68.138.0    - 192.68.138.255 
	{ 0xc0448c00, 0xc04496ff, REGISTRY_ARIN       }, // 192.68.140.0    - 192.68.150.255 
	{ 0xc0449700, 0xc04499ff, REGISTRY_RIPENCC    }, // 192.68.151.0    - 192.68.153.255 
	{ 0xc0449a00, 0xc044a4ff, REGISTRY_ARIN       }, // 192.68.154.0    - 192.68.164.255 
	{ 0xc044a500, 0xc044aaff, REGISTRY_RIPENCC    }, // 192.68.165.0    - 192.68.170.255 
	{ 0xc044ab00, 0xc044acff, REGISTRY_APNIC      }, // 192.68.171.0    - 192.68.172.255 
	{ 0xc044ad00, 0xc044adff, REGISTRY_ARIN       }, // 192.68.173.0    - 192.68.173.255 
	{ 0xc044ae00, 0xc044aeff, REGISTRY_RIPENCC    }, // 192.68.174.0    - 192.68.174.255 
	{ 0xc044af00, 0xc044afff, REGISTRY_ARIN       }, // 192.68.175.0    - 192.68.175.255 
	{ 0xc044b000, 0xc044b0ff, REGISTRY_RIPENCC    }, // 192.68.176.0    - 192.68.176.255 
	{ 0xc044b100, 0xc044b2ff, REGISTRY_ARIN       }, // 192.68.177.0    - 192.68.178.255 
	{ 0xc044b400, 0xc044b5ff, REGISTRY_ARIN       }, // 192.68.180.0    - 192.68.181.255 
	{ 0xc044b600, 0xc044b6ff, REGISTRY_RIPENCC    }, // 192.68.182.0    - 192.68.182.255 
	{ 0xc044b700, 0xc044b8ff, REGISTRY_ARIN       }, // 192.68.183.0    - 192.68.184.255 
	{ 0xc044ba00, 0xc044baff, REGISTRY_RIPENCC    }, // 192.68.186.0    - 192.68.186.255 
	{ 0xc044bb00, 0xc044d0ff, REGISTRY_ARIN       }, // 192.68.187.0    - 192.68.208.255 
	{ 0xc044d100, 0xc044d1ff, REGISTRY_RIPENCC    }, // 192.68.209.0    - 192.68.209.255 
	{ 0xc044d200, 0xc044d2ff, REGISTRY_ARIN       }, // 192.68.210.0    - 192.68.210.255 
	{ 0xc044d300, 0xc044d8ff, REGISTRY_RIPENCC    }, // 192.68.211.0    - 192.68.216.255 
	{ 0xc044d900, 0xc044dcff, REGISTRY_ARIN       }, // 192.68.217.0    - 192.68.220.255 
	{ 0xc044dd00, 0xc044ddff, REGISTRY_RIPENCC    }, // 192.68.221.0    - 192.68.221.255 
	{ 0xc044de00, 0xc044dfff, REGISTRY_ARIN       }, // 192.68.222.0    - 192.68.223.255 
	{ 0xc044e000, 0xc044e0ff, REGISTRY_RIPENCC    }, // 192.68.224.0    - 192.68.224.255 
	{ 0xc044e100, 0xc044e5ff, REGISTRY_ARIN       }, // 192.68.225.0    - 192.68.229.255 
	{ 0xc044e600, 0xc044e6ff, REGISTRY_RIPENCC    }, // 192.68.230.0    - 192.68.230.255 
	{ 0xc044e700, 0xc044eaff, REGISTRY_ARIN       }, // 192.68.231.0    - 192.68.234.255 
	{ 0xc044eb00, 0xc044f9ff, REGISTRY_APNIC      }, // 192.68.235.0    - 192.68.249.255 
	{ 0xc044fa00, 0xc044fcff, REGISTRY_RIPENCC    }, // 192.68.250.0    - 192.68.252.255 
	{ 0xc044fd00, 0xc044fdff, REGISTRY_ARIN       }, // 192.68.253.0    - 192.68.253.255 
	{ 0xc044fe00, 0xc044feff, REGISTRY_RIPENCC    }, // 192.68.254.0    - 192.68.254.255 
	{ 0xc044ff00, 0xc045ffff, REGISTRY_ARIN       }, // 192.68.255.0    - 192.69.255.255 
	{ 0xc0460000, 0xc04677ff, REGISTRY_RIPENCC    }, // 192.70.0.0      - 192.70.119.255 
	{ 0xc0467800, 0xc04684ff, REGISTRY_ARIN       }, // 192.70.120.0    - 192.70.132.255 
	{ 0xc0468500, 0xc04686ff, REGISTRY_RIPENCC    }, // 192.70.133.0    - 192.70.134.255 
	{ 0xc0468700, 0xc04687ff, REGISTRY_APNIC      }, // 192.70.135.0    - 192.70.135.255 
	{ 0xc0468800, 0xc04688ff, REGISTRY_RIPENCC    }, // 192.70.136.0    - 192.70.136.255 
	{ 0xc0468900, 0xc0468bff, REGISTRY_ARIN       }, // 192.70.137.0    - 192.70.139.255 
	{ 0xc0468c00, 0xc0469fff, REGISTRY_RIPENCC    }, // 192.70.140.0    - 192.70.159.255 
	{ 0xc046a000, 0xc046adff, REGISTRY_ARIN       }, // 192.70.160.0    - 192.70.173.255 
	{ 0xc046ae00, 0xc046aeff, REGISTRY_APNIC      }, // 192.70.174.0    - 192.70.174.255 
	{ 0xc046af00, 0xc046b2ff, REGISTRY_ARIN       }, // 192.70.175.0    - 192.70.178.255 
	{ 0xc046b300, 0xc046b5ff, REGISTRY_APNIC      }, // 192.70.179.0    - 192.70.181.255 
	{ 0xc046b800, 0xc046bfff, REGISTRY_ARIN       }, // 192.70.184.0    - 192.70.191.255 
	{ 0xc046ca00, 0xc046d7ff, REGISTRY_ARIN       }, // 192.70.202.0    - 192.70.215.255 
	{ 0xc046d800, 0xc046d8ff, REGISTRY_APNIC      }, // 192.70.216.0    - 192.70.216.255 
	{ 0xc046d900, 0xc046daff, REGISTRY_ARIN       }, // 192.70.217.0    - 192.70.218.255 
	{ 0xc046db00, 0xc046dbff, REGISTRY_APNIC      }, // 192.70.219.0    - 192.70.219.255 
	{ 0xc046dc00, 0xc046ecff, REGISTRY_ARIN       }, // 192.70.220.0    - 192.70.236.255 
	{ 0xc046ed00, 0xc046edff, REGISTRY_AFRINIC    }, // 192.70.237.0    - 192.70.237.255 
	{ 0xc046ee00, 0xc046f1ff, REGISTRY_ARIN       }, // 192.70.238.0    - 192.70.241.255 
	{ 0xc046f200, 0xc046f2ff, REGISTRY_RIPENCC    }, // 192.70.242.0    - 192.70.242.255 
	{ 0xc046f300, 0xc046ffff, REGISTRY_ARIN       }, // 192.70.243.0    - 192.70.255.255 
	{ 0xc0470000, 0xc047ffff, REGISTRY_RIPENCC    }, // 192.71.0.0      - 192.71.255.255 
	{ 0xc0480000, 0xc04802ff, REGISTRY_ARIN       }, // 192.72.0.0      - 192.72.2.255   
	{ 0xc0480300, 0xc048fcff, REGISTRY_APNIC      }, // 192.72.3.0      - 192.72.252.255 
	{ 0xc048fd00, 0xc0490bff, REGISTRY_ARIN       }, // 192.72.253.0    - 192.73.11.255  
	{ 0xc0490c00, 0xc0490cff, REGISTRY_APNIC      }, // 192.73.12.0     - 192.73.12.255  
	{ 0xc0490d00, 0xc04912ff, REGISTRY_ARIN       }, // 192.73.13.0     - 192.73.18.255  
	{ 0xc0491300, 0xc04914ff, REGISTRY_RIPENCC    }, // 192.73.19.0     - 192.73.20.255  
	{ 0xc0491500, 0xc04916ff, REGISTRY_APNIC      }, // 192.73.21.0     - 192.73.22.255  
	{ 0xc0491700, 0xc04917ff, REGISTRY_ARIN       }, // 192.73.23.0     - 192.73.23.255  
	{ 0xc0491800, 0xc04919ff, REGISTRY_APNIC      }, // 192.73.24.0     - 192.73.25.255  
	{ 0xc0491a00, 0xc04921ff, REGISTRY_ARIN       }, // 192.73.26.0     - 192.73.33.255  
	{ 0xc0492200, 0xc0492cff, REGISTRY_RIPENCC    }, // 192.73.34.0     - 192.73.44.255  
	{ 0xc0492d00, 0xc04941ff, REGISTRY_ARIN       }, // 192.73.45.0     - 192.73.65.255  
	{ 0xc0494200, 0xc04942ff, REGISTRY_APNIC      }, // 192.73.66.0     - 192.73.66.255  
	{ 0xc0494300, 0xc049e1ff, REGISTRY_ARIN       }, // 192.73.67.0     - 192.73.225.255 
	{ 0xc049e200, 0xc049e2ff, REGISTRY_RIPENCC    }, // 192.73.226.0    - 192.73.226.255 
	{ 0xc049e300, 0xc049e4ff, REGISTRY_ARIN       }, // 192.73.227.0    - 192.73.228.255 
	{ 0xc049e500, 0xc049e5ff, REGISTRY_RIPENCC    }, // 192.73.229.0    - 192.73.229.255 
	{ 0xc049e600, 0xc04a8aff, REGISTRY_ARIN       }, // 192.73.230.0    - 192.74.138.255 
	{ 0xc04a8b00, 0xc04ad0ff, REGISTRY_APNIC      }, // 192.74.139.0    - 192.74.208.255 
	{ 0xc04ad100, 0xc04b03ff, REGISTRY_ARIN       }, // 192.74.209.0    - 192.75.3.255   
	{ 0xc04b0500, 0xc04b88ff, REGISTRY_ARIN       }, // 192.75.5.0      - 192.75.136.255 
	{ 0xc04b8a00, 0xc04bebff, REGISTRY_ARIN       }, // 192.75.138.0    - 192.75.235.255 
	{ 0xc04bed00, 0xc04c05ff, REGISTRY_ARIN       }, // 192.75.237.0    - 192.76.5.255   
	{ 0xc04c0600, 0xc04c23ff, REGISTRY_RIPENCC    }, // 192.76.6.0      - 192.76.35.255  
	{ 0xc04c2400, 0xc04c79ff, REGISTRY_ARIN       }, // 192.76.36.0     - 192.76.121.255 
	{ 0xc04c7a00, 0xc04c7aff, REGISTRY_APNIC      }, // 192.76.122.0    - 192.76.122.255 
	{ 0xc04c7b00, 0xc04c84ff, REGISTRY_RIPENCC    }, // 192.76.123.0    - 192.76.132.255 
	{ 0xc04c8500, 0xc04c85ff, REGISTRY_ARIN       }, // 192.76.133.0    - 192.76.133.255 
	{ 0xc04c8600, 0xc04c94ff, REGISTRY_RIPENCC    }, // 192.76.134.0    - 192.76.148.255 
	{ 0xc04c9600, 0xc04cacff, REGISTRY_RIPENCC    }, // 192.76.150.0    - 192.76.172.255 
	{ 0xc04cad00, 0xc04cafff, REGISTRY_ARIN       }, // 192.76.173.0    - 192.76.175.255 
	{ 0xc04cb000, 0xc04cb0ff, REGISTRY_RIPENCC    }, // 192.76.176.0    - 192.76.176.255 
	{ 0xc04cb100, 0xc04cf0ff, REGISTRY_ARIN       }, // 192.76.177.0    - 192.76.240.255 
	{ 0xc04cf100, 0xc04cf8ff, REGISTRY_RIPENCC    }, // 192.76.241.0    - 192.76.248.255 
	{ 0xc04cf900, 0xc04cfbff, REGISTRY_ARIN       }, // 192.76.249.0    - 192.76.251.255 
	{ 0xc04cff00, 0xc04d07ff, REGISTRY_ARIN       }, // 192.76.255.0    - 192.77.7.255   
	{ 0xc04d0900, 0xc04d0aff, REGISTRY_ARIN       }, // 192.77.9.0      - 192.77.10.255  
	{ 0xc04d0b00, 0xc04d0bff, REGISTRY_RIPENCC    }, // 192.77.11.0     - 192.77.11.255  
	{ 0xc04d0c00, 0xc04d10ff, REGISTRY_ARIN       }, // 192.77.12.0     - 192.77.16.255  
	{ 0xc04d1200, 0xc04d71ff, REGISTRY_ARIN       }, // 192.77.18.0     - 192.77.113.255 
	{ 0xc04d7200, 0xc04d73ff, REGISTRY_RIPENCC    }, // 192.77.114.0    - 192.77.115.255 
	{ 0xc04d7400, 0xc04d77ff, REGISTRY_ARIN       }, // 192.77.116.0    - 192.77.119.255 
	{ 0xc04d7800, 0xc04d7bff, REGISTRY_RIPENCC    }, // 192.77.120.0    - 192.77.123.255 
	{ 0xc04d7c00, 0xc04d83ff, REGISTRY_ARIN       }, // 192.77.124.0    - 192.77.131.255 
	{ 0xc04d8400, 0xc04d8aff, REGISTRY_RIPENCC    }, // 192.77.132.0    - 192.77.138.255 
	{ 0xc04d8b00, 0xc04d8bff, REGISTRY_ARIN       }, // 192.77.139.0    - 192.77.139.255 
	{ 0xc04d8c00, 0xc04d8dff, REGISTRY_RIPENCC    }, // 192.77.140.0    - 192.77.141.255 
	{ 0xc04d8e00, 0xc05013ff, REGISTRY_ARIN       }, // 192.77.142.0    - 192.80.19.255  
	{ 0xc0501400, 0xc05015ff, REGISTRY_RIPENCC    }, // 192.80.20.0     - 192.80.21.255  
	{ 0xc0501600, 0xc05017ff, REGISTRY_ARIN       }, // 192.80.22.0     - 192.80.23.255  
	{ 0xc0501800, 0xc05018ff, REGISTRY_LACNIC     }, // 192.80.24.0     - 192.80.24.255  
	{ 0xc0501900, 0xc0501eff, REGISTRY_ARIN       }, // 192.80.25.0     - 192.80.30.255  
	{ 0xc0501f00, 0xc0502aff, REGISTRY_RIPENCC    }, // 192.80.31.0     - 192.80.42.255  
	{ 0xc0502b00, 0xc0502dff, REGISTRY_ARIN       }, // 192.80.43.0     - 192.80.45.255  
	{ 0xc0502e00, 0xc0502eff, REGISTRY_RIPENCC    }, // 192.80.46.0     - 192.80.46.255  
	{ 0xc0502f00, 0xc05032ff, REGISTRY_ARIN       }, // 192.80.47.0     - 192.80.50.255  
	{ 0xc0503300, 0xc05033ff, REGISTRY_RIPENCC    }, // 192.80.51.0     - 192.80.51.255  
	{ 0xc0503400, 0xc050d0ff, REGISTRY_ARIN       }, // 192.80.52.0     - 192.80.208.255 
	{ 0xc050d100, 0xc050d1ff, REGISTRY_LACNIC     }, // 192.80.209.0    - 192.80.209.255 
	{ 0xc050d200, 0xc0513aff, REGISTRY_ARIN       }, // 192.80.210.0    - 192.81.58.255  
	{ 0xc0513b00, 0xc0513bff, REGISTRY_RIPENCC    }, // 192.81.59.0     - 192.81.59.255  
	{ 0xc0513c00, 0xc0513cff, REGISTRY_ARIN       }, // 192.81.60.0     - 192.81.60.255  
	{ 0xc0513d00, 0xc0513eff, REGISTRY_RIPENCC    }, // 192.81.61.0     - 192.81.62.255  
	{ 0xc0513f00, 0xc0516cff, REGISTRY_ARIN       }, // 192.81.63.0     - 192.81.108.255 
	{ 0xc0516d00, 0xc0516dff, REGISTRY_RIPENCC    }, // 192.81.109.0    - 192.81.109.255 
	{ 0xc0516e00, 0xc05178ff, REGISTRY_ARIN       }, // 192.81.110.0    - 192.81.120.255 
	{ 0xc0517900, 0xc05179ff, REGISTRY_RIPENCC    }, // 192.81.121.0    - 192.81.121.255 
	{ 0xc0517a00, 0xc0517aff, REGISTRY_ARIN       }, // 192.81.122.0    - 192.81.122.255 
	{ 0xc0517b00, 0xc0517bff, REGISTRY_RIPENCC    }, // 192.81.123.0    - 192.81.123.255 
	{ 0xc0517c00, 0xc0519fff, REGISTRY_ARIN       }, // 192.81.124.0    - 192.81.159.255 
	{ 0xc051a000, 0xc051a0ff, REGISTRY_RIPENCC    }, // 192.81.160.0    - 192.81.160.255 
	{ 0xc051a100, 0xc051b5ff, REGISTRY_ARIN       }, // 192.81.161.0    - 192.81.181.255 
	{ 0xc051b600, 0xc051b8ff, REGISTRY_RIPENCC    }, // 192.81.182.0    - 192.81.184.255 
	{ 0xc051b900, 0xc051c1ff, REGISTRY_ARIN       }, // 192.81.185.0    - 192.81.193.255 
	{ 0xc051c200, 0xc051c2ff, REGISTRY_RIPENCC    }, // 192.81.194.0    - 192.81.194.255 
	{ 0xc051c300, 0xc051e5ff, REGISTRY_ARIN       }, // 192.81.195.0    - 192.81.229.255 
	{ 0xc051e600, 0xc051e6ff, REGISTRY_RIPENCC    }, // 192.81.230.0    - 192.81.230.255 
	{ 0xc051e700, 0xc051e9ff, REGISTRY_ARIN       }, // 192.81.231.0    - 192.81.233.255 
	{ 0xc051ea00, 0xc051eaff, REGISTRY_RIPENCC    }, // 192.81.234.0    - 192.81.234.255 
	{ 0xc051eb00, 0xc05278ff, REGISTRY_ARIN       }, // 192.81.235.0    - 192.82.120.255 
	{ 0xc0527900, 0xc05279ff, REGISTRY_RIPENCC    }, // 192.82.121.0    - 192.82.121.255 
	{ 0xc0527a00, 0xc0527bff, REGISTRY_ARIN       }, // 192.82.122.0    - 192.82.123.255 
	{ 0xc0527c00, 0xc0527cff, REGISTRY_RIPENCC    }, // 192.82.124.0    - 192.82.124.255 
	{ 0xc0527d00, 0xc0527eff, REGISTRY_ARIN       }, // 192.82.125.0    - 192.82.126.255 
	{ 0xc0527f00, 0xc0527fff, REGISTRY_RIPENCC    }, // 192.82.127.0    - 192.82.127.255 
	{ 0xc0528000, 0xc05283ff, REGISTRY_ARIN       }, // 192.82.128.0    - 192.82.131.255 
	{ 0xc0528500, 0xc0528bff, REGISTRY_ARIN       }, // 192.82.133.0    - 192.82.139.255 
	{ 0xc0528c00, 0xc0528cff, REGISTRY_APNIC      }, // 192.82.140.0    - 192.82.140.255 
	{ 0xc0528d00, 0xc0528dff, REGISTRY_ARIN       }, // 192.82.141.0    - 192.82.141.255 
	{ 0xc0528e00, 0xc0528eff, REGISTRY_AFRINIC    }, // 192.82.142.0    - 192.82.142.255 
	{ 0xc0528f00, 0xc0528fff, REGISTRY_APNIC      }, // 192.82.143.0    - 192.82.143.255 
	{ 0xc0529000, 0xc05298ff, REGISTRY_ARIN       }, // 192.82.144.0    - 192.82.152.255 
	{ 0xc0529900, 0xc05299ff, REGISTRY_RIPENCC    }, // 192.82.153.0    - 192.82.153.255 
	{ 0xc0529a00, 0xc0529cff, REGISTRY_ARIN       }, // 192.82.154.0    - 192.82.156.255 
	{ 0xc0529d00, 0xc0529eff, REGISTRY_RIPENCC    }, // 192.82.157.0    - 192.82.158.255 
	{ 0xc0529f00, 0xc052a0ff, REGISTRY_ARIN       }, // 192.82.159.0    - 192.82.160.255 
	{ 0xc052a100, 0xc052a1ff, REGISTRY_APNIC      }, // 192.82.161.0    - 192.82.161.255 
	{ 0xc052a200, 0xc052d5ff, REGISTRY_ARIN       }, // 192.82.162.0    - 192.82.213.255 
	{ 0xc052d600, 0xc052d6ff, REGISTRY_RIPENCC    }, // 192.82.214.0    - 192.82.214.255 
	{ 0xc052d700, 0xc052dbff, REGISTRY_ARIN       }, // 192.82.215.0    - 192.82.219.255 
	{ 0xc052dc00, 0xc052ddff, REGISTRY_RIPENCC    }, // 192.82.220.0    - 192.82.221.255 
	{ 0xc052de00, 0xc052deff, REGISTRY_APNIC      }, // 192.82.222.0    - 192.82.222.255 
	{ 0xc052df00, 0xc052e5ff, REGISTRY_ARIN       }, // 192.82.223.0    - 192.82.229.255 
	{ 0xc052e700, 0xc052f0ff, REGISTRY_ARIN       }, // 192.82.231.0    - 192.82.240.255 
	{ 0xc052f100, 0xc052f1ff, REGISTRY_RIPENCC    }, // 192.82.241.0    - 192.82.241.255 
	{ 0xc052f200, 0xc052ffff, REGISTRY_ARIN       }, // 192.82.242.0    - 192.82.255.255 
	{ 0xc0530000, 0xc05364ff, REGISTRY_RIPENCC    }, // 192.83.0.0      - 192.83.100.255 
	{ 0xc0536500, 0xc05365ff, REGISTRY_ARIN       }, // 192.83.101.0    - 192.83.101.255 
	{ 0xc0536600, 0xc05366ff, REGISTRY_RIPENCC    }, // 192.83.102.0    - 192.83.102.255 
	{ 0xc0536700, 0xc05367ff, REGISTRY_ARIN       }, // 192.83.103.0    - 192.83.103.255 
	{ 0xc0536900, 0xc05375ff, REGISTRY_ARIN       }, // 192.83.105.0    - 192.83.117.255 
	{ 0xc0537600, 0xc05377ff, REGISTRY_APNIC      }, // 192.83.118.0    - 192.83.119.255 
	{ 0xc0537800, 0xc05379ff, REGISTRY_ARIN       }, // 192.83.120.0    - 192.83.121.255 
	{ 0xc0537b00, 0xc0537bff, REGISTRY_APNIC      }, // 192.83.123.0    - 192.83.123.255 
	{ 0xc0537c00, 0xc0539cff, REGISTRY_ARIN       }, // 192.83.124.0    - 192.83.156.255 
	{ 0xc0539e00, 0xc0539fff, REGISTRY_ARIN       }, // 192.83.158.0    - 192.83.159.255 
	{ 0xc053a000, 0xc053a0ff, REGISTRY_RIPENCC    }, // 192.83.160.0    - 192.83.160.255 
	{ 0xc053a100, 0xc053a4ff, REGISTRY_ARIN       }, // 192.83.161.0    - 192.83.164.255 
	{ 0xc053a500, 0xc053a5ff, REGISTRY_RIPENCC    }, // 192.83.165.0    - 192.83.165.255 
	{ 0xc053a600, 0xc053c4ff, REGISTRY_APNIC      }, // 192.83.166.0    - 192.83.196.255 
	{ 0xc053c500, 0xc053c5ff, REGISTRY_ARIN       }, // 192.83.197.0    - 192.83.197.255 
	{ 0xc053c600, 0xc053c6ff, REGISTRY_APNIC      }, // 192.83.198.0    - 192.83.198.255 
	{ 0xc053c700, 0xc053c7ff, REGISTRY_ARIN       }, // 192.83.199.0    - 192.83.199.255 
	{ 0xc053c800, 0xc053c8ff, REGISTRY_RIPENCC    }, // 192.83.200.0    - 192.83.200.255 
	{ 0xc053c900, 0xc053c9ff, REGISTRY_ARIN       }, // 192.83.201.0    - 192.83.201.255 
	{ 0xc053ca00, 0xc053caff, REGISTRY_RIPENCC    }, // 192.83.202.0    - 192.83.202.255 
	{ 0xc053cb00, 0xc053ceff, REGISTRY_ARIN       }, // 192.83.203.0    - 192.83.206.255 
	{ 0xc053da00, 0xc053dbff, REGISTRY_APNIC      }, // 192.83.218.0    - 192.83.219.255 
	{ 0xc053dc00, 0xc053deff, REGISTRY_ARIN       }, // 192.83.220.0    - 192.83.222.255 
	{ 0xc053df00, 0xc053dfff, REGISTRY_RIPENCC    }, // 192.83.223.0    - 192.83.223.255 
	{ 0xc053e000, 0xc053e0ff, REGISTRY_APNIC      }, // 192.83.224.0    - 192.83.224.255 
	{ 0xc053e100, 0xc053e4ff, REGISTRY_ARIN       }, // 192.83.225.0    - 192.83.228.255 
	{ 0xc053e500, 0xc053e5ff, REGISTRY_RIPENCC    }, // 192.83.229.0    - 192.83.229.255 
	{ 0xc053e600, 0xc053e6ff, REGISTRY_ARIN       }, // 192.83.230.0    - 192.83.230.255 
	{ 0xc053e700, 0xc053e7ff, REGISTRY_APNIC      }, // 192.83.231.0    - 192.83.231.255 
	{ 0xc053e800, 0xc053ecff, REGISTRY_ARIN       }, // 192.83.232.0    - 192.83.236.255 
	{ 0xc053ed00, 0xc053eeff, REGISTRY_APNIC      }, // 192.83.237.0    - 192.83.238.255 
	{ 0xc053ef00, 0xc05404ff, REGISTRY_ARIN       }, // 192.83.239.0    - 192.84.4.255   
	{ 0xc0540500, 0xc05405ff, REGISTRY_RIPENCC    }, // 192.84.5.0      - 192.84.5.255   
	{ 0xc0540600, 0xc0540bff, REGISTRY_ARIN       }, // 192.84.6.0      - 192.84.11.255  
	{ 0xc0540c00, 0xc0540cff, REGISTRY_LACNIC     }, // 192.84.12.0     - 192.84.12.255  
	{ 0xc0540d00, 0xc0540dff, REGISTRY_RIPENCC    }, // 192.84.13.0     - 192.84.13.255  
	{ 0xc0540e00, 0xc0540eff, REGISTRY_ARIN       }, // 192.84.14.0     - 192.84.14.255  
	{ 0xc0540f00, 0xc0540fff, REGISTRY_RIPENCC    }, // 192.84.15.0     - 192.84.15.255  
	{ 0xc0541000, 0xc0541aff, REGISTRY_ARIN       }, // 192.84.16.0     - 192.84.26.255  
	{ 0xc0541b00, 0xc0541bff, REGISTRY_RIPENCC    }, // 192.84.27.0     - 192.84.27.255  
	{ 0xc0541c00, 0xc0541dff, REGISTRY_ARIN       }, // 192.84.28.0     - 192.84.29.255  
	{ 0xc0541e00, 0xc0541eff, REGISTRY_RIPENCC    }, // 192.84.30.0     - 192.84.30.255  
	{ 0xc0541f00, 0xc0541fff, REGISTRY_ARIN       }, // 192.84.31.0     - 192.84.31.255  
	{ 0xc0542000, 0xc05421ff, REGISTRY_RIPENCC    }, // 192.84.32.0     - 192.84.33.255  
	{ 0xc0542200, 0xc0543dff, REGISTRY_ARIN       }, // 192.84.34.0     - 192.84.61.255  
	{ 0xc0543e00, 0xc0543eff, REGISTRY_RIPENCC    }, // 192.84.62.0     - 192.84.62.255  
	{ 0xc0543f00, 0xc05446ff, REGISTRY_ARIN       }, // 192.84.63.0     - 192.84.70.255  
	{ 0xc0544a00, 0xc0544aff, REGISTRY_ARIN       }, // 192.84.74.0     - 192.84.74.255  
	{ 0xc0544b00, 0xc05454ff, REGISTRY_RIPENCC    }, // 192.84.75.0     - 192.84.84.255  
	{ 0xc0545500, 0xc05456ff, REGISTRY_ARIN       }, // 192.84.85.0     - 192.84.86.255  
	{ 0xc0545700, 0xc05457ff, REGISTRY_RIPENCC    }, // 192.84.87.0     - 192.84.87.255  
	{ 0xc0545800, 0xc05458ff, REGISTRY_ARIN       }, // 192.84.88.0     - 192.84.88.255  
	{ 0xc0545900, 0xc05459ff, REGISTRY_APNIC      }, // 192.84.89.0     - 192.84.89.255  
	{ 0xc0545a00, 0xc05463ff, REGISTRY_RIPENCC    }, // 192.84.90.0     - 192.84.99.255  
	{ 0xc0546400, 0xc05464ff, REGISTRY_ARIN       }, // 192.84.100.0    - 192.84.100.255 
	{ 0xc0546500, 0xc0546dff, REGISTRY_RIPENCC    }, // 192.84.101.0    - 192.84.109.255 
	{ 0xc0546e00, 0xc0547eff, REGISTRY_ARIN       }, // 192.84.110.0    - 192.84.126.255 
	{ 0xc0547f00, 0xc0549cff, REGISTRY_RIPENCC    }, // 192.84.127.0    - 192.84.156.255 
	{ 0xc0549d00, 0xc054a5ff, REGISTRY_ARIN       }, // 192.84.157.0    - 192.84.165.255 
	{ 0xc054a600, 0xc054a6ff, REGISTRY_RIPENCC    }, // 192.84.166.0    - 192.84.166.255 
	{ 0xc054a700, 0xc054acff, REGISTRY_ARIN       }, // 192.84.167.0    - 192.84.172.255 
	{ 0xc054ad00, 0xc054adff, REGISTRY_RIPENCC    }, // 192.84.173.0    - 192.84.173.255 
	{ 0xc054ae00, 0xc054afff, REGISTRY_ARIN       }, // 192.84.174.0    - 192.84.175.255 
	{ 0xc054b000, 0xc054cfff, REGISTRY_RIPENCC    }, // 192.84.176.0    - 192.84.207.255 
	{ 0xc054d000, 0xc054d3ff, REGISTRY_ARIN       }, // 192.84.208.0    - 192.84.211.255 
	{ 0xc054d400, 0xc054d4ff, REGISTRY_RIPENCC    }, // 192.84.212.0    - 192.84.212.255 
	{ 0xc054d500, 0xc054daff, REGISTRY_ARIN       }, // 192.84.213.0    - 192.84.218.255 
	{ 0xc054db00, 0xc054dbff, REGISTRY_APNIC      }, // 192.84.219.0    - 192.84.219.255 
	{ 0xc054dc00, 0xc054ddff, REGISTRY_RIPENCC    }, // 192.84.220.0    - 192.84.221.255 
	{ 0xc054de00, 0xc054e1ff, REGISTRY_ARIN       }, // 192.84.222.0    - 192.84.225.255 
	{ 0xc054e200, 0xc054e5ff, REGISTRY_RIPENCC    }, // 192.84.226.0    - 192.84.229.255 
	{ 0xc054e600, 0xc054e6ff, REGISTRY_APNIC      }, // 192.84.230.0    - 192.84.230.255 
	{ 0xc054e700, 0xc054ecff, REGISTRY_ARIN       }, // 192.84.231.0    - 192.84.236.255 
	{ 0xc054ed00, 0xc054eeff, REGISTRY_APNIC      }, // 192.84.237.0    - 192.84.238.255 
	{ 0xc054ef00, 0xc054f0ff, REGISTRY_ARIN       }, // 192.84.239.0    - 192.84.240.255 
	{ 0xc054f200, 0xc054f2ff, REGISTRY_APNIC      }, // 192.84.242.0    - 192.84.242.255 
	{ 0xc054f300, 0xc054f3ff, REGISTRY_ARIN       }, // 192.84.243.0    - 192.84.243.255 
	{ 0xc054f400, 0xc054f4ff, REGISTRY_AFRINIC    }, // 192.84.244.0    - 192.84.244.255 
	{ 0xc054f500, 0xc054f7ff, REGISTRY_RIPENCC    }, // 192.84.245.0    - 192.84.247.255 
	{ 0xc054f800, 0xc054fcff, REGISTRY_ARIN       }, // 192.84.248.0    - 192.84.252.255 
	{ 0xc054fd00, 0xc054fdff, REGISTRY_APNIC      }, // 192.84.253.0    - 192.84.253.255 
	{ 0xc054fe00, 0xc0560aff, REGISTRY_ARIN       }, // 192.84.254.0    - 192.86.10.255  
	{ 0xc0560b00, 0xc0560bff, REGISTRY_RIPENCC    }, // 192.86.11.0     - 192.86.11.255  
	{ 0xc0560d00, 0xc0560dff, REGISTRY_ARIN       }, // 192.86.13.0     - 192.86.13.255  
	{ 0xc0560e00, 0xc0560eff, REGISTRY_RIPENCC    }, // 192.86.14.0     - 192.86.14.255  
	{ 0xc0560f00, 0xc05611ff, REGISTRY_ARIN       }, // 192.86.15.0     - 192.86.17.255  
	{ 0xc0561200, 0xc05612ff, REGISTRY_RIPENCC    }, // 192.86.18.0     - 192.86.18.255  
	{ 0xc0561300, 0xc05618ff, REGISTRY_ARIN       }, // 192.86.19.0     - 192.86.24.255  
	{ 0xc0561900, 0xc05619ff, REGISTRY_RIPENCC    }, // 192.86.25.0     - 192.86.25.255  
	{ 0xc0561a00, 0xc0561aff, REGISTRY_ARIN       }, // 192.86.26.0     - 192.86.26.255  
	{ 0xc0561b00, 0xc0561bff, REGISTRY_RIPENCC    }, // 192.86.27.0     - 192.86.27.255  
	{ 0xc0561c00, 0xc05658ff, REGISTRY_ARIN       }, // 192.86.28.0     - 192.86.88.255  
	{ 0xc0565900, 0xc05659ff, REGISTRY_RIPENCC    }, // 192.86.89.0     - 192.86.89.255  
	{ 0xc0565a00, 0xc0567cff, REGISTRY_ARIN       }, // 192.86.90.0     - 192.86.124.255 
	{ 0xc0567d00, 0xc0567fff, REGISTRY_RIPENCC    }, // 192.86.125.0    - 192.86.127.255 
	{ 0xc0568000, 0xc05680ff, REGISTRY_ARIN       }, // 192.86.128.0    - 192.86.128.255 
	{ 0xc0568200, 0xc05683ff, REGISTRY_ARIN       }, // 192.86.130.0    - 192.86.131.255 
	{ 0xc0568600, 0xc05686ff, REGISTRY_RIPENCC    }, // 192.86.134.0    - 192.86.134.255 
	{ 0xc0568700, 0xc05688ff, REGISTRY_ARIN       }, // 192.86.135.0    - 192.86.136.255 
	{ 0xc0568900, 0xc0568aff, REGISTRY_RIPENCC    }, // 192.86.137.0    - 192.86.138.255 
	{ 0xc0568b00, 0xc056a2ff, REGISTRY_ARIN       }, // 192.86.139.0    - 192.86.162.255 
	{ 0xc056a300, 0xc056a3ff, REGISTRY_RIPENCC    }, // 192.86.163.0    - 192.86.163.255 
	{ 0xc056a400, 0xc056a4ff, REGISTRY_ARIN       }, // 192.86.164.0    - 192.86.164.255 
	{ 0xc056a500, 0xc056a5ff, REGISTRY_APNIC      }, // 192.86.165.0    - 192.86.165.255 
	{ 0xc056a600, 0xc056a7ff, REGISTRY_RIPENCC    }, // 192.86.166.0    - 192.86.167.255 
	{ 0xc056a800, 0xc056a8ff, REGISTRY_ARIN       }, // 192.86.168.0    - 192.86.168.255 
	{ 0xc056a900, 0xc056a9ff, REGISTRY_RIPENCC    }, // 192.86.169.0    - 192.86.169.255 
	{ 0xc056aa00, 0xc056fdff, REGISTRY_ARIN       }, // 192.86.170.0    - 192.86.253.255 
	{ 0xc056fe00, 0xc056feff, REGISTRY_RIPENCC    }, // 192.86.254.0    - 192.86.254.255 
	{ 0xc056ff00, 0xc056ffff, REGISTRY_ARIN       }, // 192.86.255.0    - 192.86.255.255 
	{ 0xc0570000, 0xc057ffff, REGISTRY_RIPENCC    }, // 192.87.0.0      - 192.87.255.255 
	{ 0xc0580000, 0xc05800ff, REGISTRY_ARIN       }, // 192.88.0.0      - 192.88.0.255   
	{ 0xc0580100, 0xc05801ff, REGISTRY_RIPENCC    }, // 192.88.1.0      - 192.88.1.255   
	{ 0xc0580200, 0xc05803ff, REGISTRY_ARIN       }, // 192.88.2.0      - 192.88.3.255   
	{ 0xc0580400, 0xc05804ff, REGISTRY_RIPENCC    }, // 192.88.4.0      - 192.88.4.255   
	{ 0xc0580500, 0xc05805ff, REGISTRY_ARIN       }, // 192.88.5.0      - 192.88.5.255   
	{ 0xc0580600, 0xc05807ff, REGISTRY_APNIC      }, // 192.88.6.0      - 192.88.7.255   
	{ 0xc0580800, 0xc05808ff, REGISTRY_ARIN       }, // 192.88.8.0      - 192.88.8.255   
	{ 0xc0580900, 0xc0580aff, REGISTRY_RIPENCC    }, // 192.88.9.0      - 192.88.10.255  
	{ 0xc0580b00, 0xc05810ff, REGISTRY_ARIN       }, // 192.88.11.0     - 192.88.16.255  
	{ 0xc0581100, 0xc05811ff, REGISTRY_RIPENCC    }, // 192.88.17.0     - 192.88.17.255  
	{ 0xc0581200, 0xc05816ff, REGISTRY_ARIN       }, // 192.88.18.0     - 192.88.22.255  
	{ 0xc0581700, 0xc05818ff, REGISTRY_RIPENCC    }, // 192.88.23.0     - 192.88.24.255  
	{ 0xc0581900, 0xc0584fff, REGISTRY_ARIN       }, // 192.88.25.0     - 192.88.79.255  
	{ 0xc0585100, 0xc05852ff, REGISTRY_ARIN       }, // 192.88.81.0     - 192.88.82.255  
	{ 0xc0585300, 0xc05854ff, REGISTRY_RIPENCC    }, // 192.88.83.0     - 192.88.84.255  
	{ 0xc0585500, 0xc05855ff, REGISTRY_APNIC      }, // 192.88.85.0     - 192.88.85.255  
	{ 0xc0585600, 0xc05856ff, REGISTRY_RIPENCC    }, // 192.88.86.0     - 192.88.86.255  
	{ 0xc0585700, 0xc05860ff, REGISTRY_ARIN       }, // 192.88.87.0     - 192.88.96.255  
	{ 0xc0586100, 0xc05862ff, REGISTRY_RIPENCC    }, // 192.88.97.0     - 192.88.98.255  
	{ 0xc0586400, 0xc05864ff, REGISTRY_ARIN       }, // 192.88.100.0    - 192.88.100.255 
	{ 0xc0586700, 0xc0586bff, REGISTRY_ARIN       }, // 192.88.103.0    - 192.88.107.255 
	{ 0xc0586c00, 0xc0586cff, REGISTRY_RIPENCC    }, // 192.88.108.0    - 192.88.108.255 
	{ 0xc0586d00, 0xc05875ff, REGISTRY_ARIN       }, // 192.88.109.0    - 192.88.117.255 
	{ 0xc0587600, 0xc05876ff, REGISTRY_RIPENCC    }, // 192.88.118.0    - 192.88.118.255 
	{ 0xc0587800, 0xc0587aff, REGISTRY_ARIN       }, // 192.88.120.0    - 192.88.122.255 
	{ 0xc0587b00, 0xc0587bff, REGISTRY_RIPENCC    }, // 192.88.123.0    - 192.88.123.255 
	{ 0xc0587c00, 0xc0587fff, REGISTRY_ARIN       }, // 192.88.124.0    - 192.88.127.255 
	{ 0xc0588000, 0xc05880ff, REGISTRY_RIPENCC    }, // 192.88.128.0    - 192.88.128.255 
	{ 0xc0588100, 0xc05881ff, REGISTRY_ARIN       }, // 192.88.129.0    - 192.88.129.255 
	{ 0xc0588200, 0xc05882ff, REGISTRY_RIPENCC    }, // 192.88.130.0    - 192.88.130.255 
	{ 0xc0588300, 0xc05884ff, REGISTRY_ARIN       }, // 192.88.131.0    - 192.88.132.255 
	{ 0xc0588500, 0xc05885ff, REGISTRY_RIPENCC    }, // 192.88.133.0    - 192.88.133.255 
	{ 0xc0588600, 0xc058baff, REGISTRY_ARIN       }, // 192.88.134.0    - 192.88.186.255 
	{ 0xc058bb00, 0xc058bbff, REGISTRY_APNIC      }, // 192.88.187.0    - 192.88.187.255 
	{ 0xc058bc00, 0xc058bdff, REGISTRY_ARIN       }, // 192.88.188.0    - 192.88.189.255 
	{ 0xc058be00, 0xc058beff, REGISTRY_APNIC      }, // 192.88.190.0    - 192.88.190.255 
	{ 0xc058bf00, 0xc058c3ff, REGISTRY_ARIN       }, // 192.88.191.0    - 192.88.195.255 
	{ 0xc058c400, 0xc058c4ff, REGISTRY_RIPENCC    }, // 192.88.196.0    - 192.88.196.255 
	{ 0xc058c500, 0xc058cbff, REGISTRY_ARIN       }, // 192.88.197.0    - 192.88.203.255 
	{ 0xc058cc00, 0xc058ccff, REGISTRY_RIPENCC    }, // 192.88.204.0    - 192.88.204.255 
	{ 0xc058cd00, 0xc058edff, REGISTRY_ARIN       }, // 192.88.205.0    - 192.88.237.255 
	{ 0xc058ee00, 0xc058efff, REGISTRY_RIPENCC    }, // 192.88.238.0    - 192.88.239.255 
	{ 0xc058f000, 0xc058f9ff, REGISTRY_ARIN       }, // 192.88.240.0    - 192.88.249.255 
	{ 0xc058fa00, 0xc058feff, REGISTRY_RIPENCC    }, // 192.88.250.0    - 192.88.254.255 
	{ 0xc058ff00, 0xc058ffff, REGISTRY_ARIN       }, // 192.88.255.0    - 192.88.255.255 
	{ 0xc0590000, 0xc059ffff, REGISTRY_RIPENCC    }, // 192.89.0.0      - 192.89.255.255 
	{ 0xc05a0000, 0xc05b8bff, REGISTRY_ARIN       }, // 192.90.0.0      - 192.91.139.255 
	{ 0xc05b8c00, 0xc05b8dff, REGISTRY_RIPENCC    }, // 192.91.140.0    - 192.91.141.255 
	{ 0xc05b8e00, 0xc05bb0ff, REGISTRY_ARIN       }, // 192.91.142.0    - 192.91.176.255 
	{ 0xc05bb100, 0xc05bb1ff, REGISTRY_RIPENCC    }, // 192.91.177.0    - 192.91.177.255 
	{ 0xc05bb200, 0xc05bb2ff, REGISTRY_ARIN       }, // 192.91.178.0    - 192.91.178.255 
	{ 0xc05bb300, 0xc05bb3ff, REGISTRY_APNIC      }, // 192.91.179.0    - 192.91.179.255 
	{ 0xc05bb400, 0xc05bb8ff, REGISTRY_ARIN       }, // 192.91.180.0    - 192.91.184.255 
	{ 0xc05bb900, 0xc05bb9ff, REGISTRY_APNIC      }, // 192.91.185.0    - 192.91.185.255 
	{ 0xc05bba00, 0xc05bbaff, REGISTRY_RIPENCC    }, // 192.91.186.0    - 192.91.186.255 
	{ 0xc05bbb00, 0xc05bbcff, REGISTRY_ARIN       }, // 192.91.187.0    - 192.91.188.255 
	{ 0xc05bbd00, 0xc05bbdff, REGISTRY_RIPENCC    }, // 192.91.189.0    - 192.91.189.255 
	{ 0xc05bbe00, 0xc05bbeff, REGISTRY_ARIN       }, // 192.91.190.0    - 192.91.190.255 
	{ 0xc05bbf00, 0xc05bbfff, REGISTRY_RIPENCC    }, // 192.91.191.0    - 192.91.191.255 
	{ 0xc05bc000, 0xc05bc6ff, REGISTRY_ARIN       }, // 192.91.192.0    - 192.91.198.255 
	{ 0xc05bc700, 0xc05bc7ff, REGISTRY_RIPENCC    }, // 192.91.199.0    - 192.91.199.255 
	{ 0xc05bc900, 0xc05bc9ff, REGISTRY_RIPENCC    }, // 192.91.201.0    - 192.91.201.255 
	{ 0xc05bca00, 0xc05bd2ff, REGISTRY_ARIN       }, // 192.91.202.0    - 192.91.210.255 
	{ 0xc05bd300, 0xc05bd3ff, REGISTRY_RIPENCC    }, // 192.91.211.0    - 192.91.211.255 
	{ 0xc05bd400, 0xc05bd4ff, REGISTRY_ARIN       }, // 192.91.212.0    - 192.91.212.255 
	{ 0xc05bd600, 0xc05be9ff, REGISTRY_RIPENCC    }, // 192.91.214.0    - 192.91.233.255 
	{ 0xc05bea00, 0xc05bebff, REGISTRY_ARIN       }, // 192.91.234.0    - 192.91.235.255 
	{ 0xc05bec00, 0xc05bf7ff, REGISTRY_RIPENCC    }, // 192.91.236.0    - 192.91.247.255 
	{ 0xc05bf800, 0xc05bfdff, REGISTRY_ARIN       }, // 192.91.248.0    - 192.91.253.255 
	{ 0xc05bff00, 0xc05c0eff, REGISTRY_ARIN       }, // 192.91.255.0    - 192.92.14.255  
	{ 0xc05c1000, 0xc05c55ff, REGISTRY_ARIN       }, // 192.92.16.0     - 192.92.85.255  
	{ 0xc05c5600, 0xc05c56ff, REGISTRY_RIPENCC    }, // 192.92.86.0     - 192.92.86.255  
	{ 0xc05c5700, 0xc05c5dff, REGISTRY_ARIN       }, // 192.92.87.0     - 192.92.93.255  
	{ 0xc05c5e00, 0xc05c5eff, REGISTRY_RIPENCC    }, // 192.92.94.0     - 192.92.94.255  
	{ 0xc05c5f00, 0xc05c67ff, REGISTRY_ARIN       }, // 192.92.95.0     - 192.92.103.255 
	{ 0xc05c6800, 0xc05c6aff, REGISTRY_RIPENCC    }, // 192.92.104.0    - 192.92.106.255 
	{ 0xc05c6b00, 0xc05c6bff, REGISTRY_ARIN       }, // 192.92.107.0    - 192.92.107.255 
	{ 0xc05c6c00, 0xc05c6dff, REGISTRY_RIPENCC    }, // 192.92.108.0    - 192.92.109.255 
	{ 0xc05c6e00, 0xc05c73ff, REGISTRY_ARIN       }, // 192.92.110.0    - 192.92.115.255 
	{ 0xc05c7400, 0xc05c74ff, REGISTRY_RIPENCC    }, // 192.92.116.0    - 192.92.116.255 
	{ 0xc05c7500, 0xc05c7cff, REGISTRY_ARIN       }, // 192.92.117.0    - 192.92.124.255 
	{ 0xc05c7d00, 0xc05c8bff, REGISTRY_RIPENCC    }, // 192.92.125.0    - 192.92.139.255 
	{ 0xc05c8c00, 0xc05c8cff, REGISTRY_ARIN       }, // 192.92.140.0    - 192.92.140.255 
	{ 0xc05c8d00, 0xc05c99ff, REGISTRY_RIPENCC    }, // 192.92.141.0    - 192.92.153.255 
	{ 0xc05c9b00, 0xc05c9cff, REGISTRY_RIPENCC    }, // 192.92.155.0    - 192.92.156.255 
	{ 0xc05c9d00, 0xc05cd7ff, REGISTRY_ARIN       }, // 192.92.157.0    - 192.92.215.255 
	{ 0xc05cd800, 0xc05cd8ff, REGISTRY_RIPENCC    }, // 192.92.216.0    - 192.92.216.255 
	{ 0xc05cd900, 0xc05cffff, REGISTRY_ARIN       }, // 192.92.217.0    - 192.92.255.255 
	{ 0xc05d0000, 0xc05dffff, REGISTRY_RIPENCC    }, // 192.93.0.0      - 192.93.255.255 
	{ 0xc05e0000, 0xc05e17ff, REGISTRY_ARIN       }, // 192.94.0.0      - 192.94.23.255  
	{ 0xc05e1800, 0xc05e18ff, REGISTRY_RIPENCC    }, // 192.94.24.0     - 192.94.24.255  
	{ 0xc05e1900, 0xc05e1bff, REGISTRY_ARIN       }, // 192.94.25.0     - 192.94.27.255  
	{ 0xc05e1c00, 0xc05e1cff, REGISTRY_RIPENCC    }, // 192.94.28.0     - 192.94.28.255  
	{ 0xc05e1d00, 0xc05e28ff, REGISTRY_ARIN       }, // 192.94.29.0     - 192.94.40.255  
	{ 0xc05e2900, 0xc05e29ff, REGISTRY_APNIC      }, // 192.94.41.0     - 192.94.41.255  
	{ 0xc05e2a00, 0xc05e38ff, REGISTRY_ARIN       }, // 192.94.42.0     - 192.94.56.255  
	{ 0xc05e3900, 0xc05e3aff, REGISTRY_RIPENCC    }, // 192.94.57.0     - 192.94.58.255  
	{ 0xc05e3b00, 0xc05e3cff, REGISTRY_ARIN       }, // 192.94.59.0     - 192.94.60.255  
	{ 0xc05e3d00, 0xc05e3dff, REGISTRY_AFRINIC    }, // 192.94.61.0     - 192.94.61.255  
	{ 0xc05e3e00, 0xc05e40ff, REGISTRY_APNIC      }, // 192.94.62.0     - 192.94.64.255  
	{ 0xc05e4100, 0xc05e42ff, REGISTRY_ARIN       }, // 192.94.65.0     - 192.94.66.255  
	{ 0xc05e4300, 0xc05e44ff, REGISTRY_RIPENCC    }, // 192.94.67.0     - 192.94.68.255  
	{ 0xc05e4500, 0xc05e4bff, REGISTRY_ARIN       }, // 192.94.69.0     - 192.94.75.255  
	{ 0xc05e4c00, 0xc05e4cff, REGISTRY_RIPENCC    }, // 192.94.76.0     - 192.94.76.255  
	{ 0xc05e4f00, 0xc05e6eff, REGISTRY_ARIN       }, // 192.94.79.0     - 192.94.110.255 
	{ 0xc05e6f00, 0xc05e75ff, REGISTRY_RIPENCC    }, // 192.94.111.0    - 192.94.117.255 
	{ 0xc05e7600, 0xc05e79ff, REGISTRY_ARIN       }, // 192.94.118.0    - 192.94.121.255 
	{ 0xc05e7a00, 0xc05e7aff, REGISTRY_APNIC      }, // 192.94.122.0    - 192.94.122.255 
	{ 0xc05e7b00, 0xc05e9bff, REGISTRY_ARIN       }, // 192.94.123.0    - 192.94.155.255 
	{ 0xc05e9c00, 0xc05ea3ff, REGISTRY_RIPENCC    }, // 192.94.156.0    - 192.94.163.255 
	{ 0xc05ea400, 0xc05ea8ff, REGISTRY_ARIN       }, // 192.94.164.0    - 192.94.168.255 
	{ 0xc05ea900, 0xc05ea9ff, REGISTRY_APNIC      }, // 192.94.169.0    - 192.94.169.255 
	{ 0xc05eaa00, 0xc05eabff, REGISTRY_ARIN       }, // 192.94.170.0    - 192.94.171.255 
	{ 0xc05eac00, 0xc05eacff, REGISTRY_RIPENCC    }, // 192.94.172.0    - 192.94.172.255 
	{ 0xc05ead00, 0xc05eadff, REGISTRY_ARIN       }, // 192.94.173.0    - 192.94.173.255 
	{ 0xc05eae00, 0xc05eaeff, REGISTRY_APNIC      }, // 192.94.174.0    - 192.94.174.255 
	{ 0xc05eaf00, 0xc05ec7ff, REGISTRY_RIPENCC    }, // 192.94.175.0    - 192.94.199.255 
	{ 0xc05ec900, 0xc05ecfff, REGISTRY_ARIN       }, // 192.94.201.0    - 192.94.207.255 
	{ 0xc05ed000, 0xc05ed1ff, REGISTRY_APNIC      }, // 192.94.208.0    - 192.94.209.255 
	{ 0xc05ed200, 0xc05ed2ff, REGISTRY_AFRINIC    }, // 192.94.210.0    - 192.94.210.255 
	{ 0xc05ed300, 0xc05ed3ff, REGISTRY_ARIN       }, // 192.94.211.0    - 192.94.211.255 
	{ 0xc05ed400, 0xc05ed4ff, REGISTRY_RIPENCC    }, // 192.94.212.0    - 192.94.212.255 
	{ 0xc05ed500, 0xc05edbff, REGISTRY_ARIN       }, // 192.94.213.0    - 192.94.219.255 
	{ 0xc05edd00, 0xc05eddff, REGISTRY_RIPENCC    }, // 192.94.221.0    - 192.94.221.255 
	{ 0xc05ede00, 0xc05ee1ff, REGISTRY_ARIN       }, // 192.94.222.0    - 192.94.225.255 
	{ 0xc05ee200, 0xc05ee2ff, REGISTRY_RIPENCC    }, // 192.94.226.0    - 192.94.226.255 
	{ 0xc05ee300, 0xc05ee3ff, REGISTRY_APNIC      }, // 192.94.227.0    - 192.94.227.255 
	{ 0xc05ee400, 0xc05ee8ff, REGISTRY_ARIN       }, // 192.94.228.0    - 192.94.232.255 
	{ 0xc05ee900, 0xc05ee9ff, REGISTRY_RIPENCC    }, // 192.94.233.0    - 192.94.233.255 
	{ 0xc05eea00, 0xc05eeaff, REGISTRY_ARIN       }, // 192.94.234.0    - 192.94.234.255 
	{ 0xc05eeb00, 0xc05eebff, REGISTRY_RIPENCC    }, // 192.94.235.0    - 192.94.235.255 
	{ 0xc05eec00, 0xc05eedff, REGISTRY_ARIN       }, // 192.94.236.0    - 192.94.237.255 
	{ 0xc05eef00, 0xc05eefff, REGISTRY_RIPENCC    }, // 192.94.239.0    - 192.94.239.255 
	{ 0xc05ef000, 0xc05ef1ff, REGISTRY_AFRINIC    }, // 192.94.240.0    - 192.94.241.255 
	{ 0xc05ef200, 0xc05ef2ff, REGISTRY_ARIN       }, // 192.94.242.0    - 192.94.242.255 
	{ 0xc05ef300, 0xc05ef4ff, REGISTRY_APNIC      }, // 192.94.243.0    - 192.94.244.255 
	{ 0xc05ef500, 0xc05ef5ff, REGISTRY_ARIN       }, // 192.94.245.0    - 192.94.245.255 
	{ 0xc05ef600, 0xc05ef6ff, REGISTRY_AFRINIC    }, // 192.94.246.0    - 192.94.246.255 
	{ 0xc05ef700, 0xc06000ff, REGISTRY_ARIN       }, // 192.94.247.0    - 192.96.0.255   
	{ 0xc0600100, 0xc06010ff, REGISTRY_AFRINIC    }, // 192.96.1.0      - 192.96.16.255  
	{ 0xc0601100, 0xc06012ff, REGISTRY_ARIN       }, // 192.96.17.0     - 192.96.18.255  
	{ 0xc0601300, 0xc06016ff, REGISTRY_AFRINIC    }, // 192.96.19.0     - 192.96.22.255  
	{ 0xc0601700, 0xc06017ff, REGISTRY_ARIN       }, // 192.96.23.0     - 192.96.23.255  
	{ 0xc0601800, 0xc06023ff, REGISTRY_AFRINIC    }, // 192.96.24.0     - 192.96.35.255  
	{ 0xc0602400, 0xc06024ff, REGISTRY_ARIN       }, // 192.96.36.0     - 192.96.36.255  
	{ 0xc0602500, 0xc06028ff, REGISTRY_AFRINIC    }, // 192.96.37.0     - 192.96.40.255  
	{ 0xc0602900, 0xc0602aff, REGISTRY_ARIN       }, // 192.96.41.0     - 192.96.42.255  
	{ 0xc0602b00, 0xc0602bff, REGISTRY_AFRINIC    }, // 192.96.43.0     - 192.96.43.255  
	{ 0xc0602c00, 0xc0602cff, REGISTRY_ARIN       }, // 192.96.44.0     - 192.96.44.255  
	{ 0xc0602d00, 0xc0603aff, REGISTRY_AFRINIC    }, // 192.96.45.0     - 192.96.58.255  
	{ 0xc0603b00, 0xc0603bff, REGISTRY_ARIN       }, // 192.96.59.0     - 192.96.59.255  
	{ 0xc0603c00, 0xc0603dff, REGISTRY_AFRINIC    }, // 192.96.60.0     - 192.96.61.255  
	{ 0xc0603e00, 0xc06043ff, REGISTRY_ARIN       }, // 192.96.62.0     - 192.96.67.255  
	{ 0xc0604400, 0xc06048ff, REGISTRY_AFRINIC    }, // 192.96.68.0     - 192.96.72.255  
	{ 0xc0604900, 0xc06049ff, REGISTRY_ARIN       }, // 192.96.73.0     - 192.96.73.255  
	{ 0xc0604a00, 0xc0604dff, REGISTRY_AFRINIC    }, // 192.96.74.0     - 192.96.77.255  
	{ 0xc0604e00, 0xc0604eff, REGISTRY_ARIN       }, // 192.96.78.0     - 192.96.78.255  
	{ 0xc0604f00, 0xc06066ff, REGISTRY_AFRINIC    }, // 192.96.79.0     - 192.96.102.255 
	{ 0xc0606700, 0xc06067ff, REGISTRY_ARIN       }, // 192.96.103.0    - 192.96.103.255 
	{ 0xc0606800, 0xc06086ff, REGISTRY_AFRINIC    }, // 192.96.104.0    - 192.96.134.255 
	{ 0xc0608700, 0xc06089ff, REGISTRY_ARIN       }, // 192.96.135.0    - 192.96.137.255 
	{ 0xc0608a00, 0xc0608eff, REGISTRY_AFRINIC    }, // 192.96.138.0    - 192.96.142.255 
	{ 0xc0608f00, 0xc0608fff, REGISTRY_ARIN       }, // 192.96.143.0    - 192.96.143.255 
	{ 0xc0609000, 0xc06090ff, REGISTRY_AFRINIC    }, // 192.96.144.0    - 192.96.144.255 
	{ 0xc0609100, 0xc06091ff, REGISTRY_ARIN       }, // 192.96.145.0    - 192.96.145.255 
	{ 0xc0609200, 0xc0609bff, REGISTRY_AFRINIC    }, // 192.96.146.0    - 192.96.155.255 
	{ 0xc0609c00, 0xc0609dff, REGISTRY_ARIN       }, // 192.96.156.0    - 192.96.157.255 
	{ 0xc0609e00, 0xc0609eff, REGISTRY_AFRINIC    }, // 192.96.158.0    - 192.96.158.255 
	{ 0xc0609f00, 0xc060a3ff, REGISTRY_ARIN       }, // 192.96.159.0    - 192.96.163.255 
	{ 0xc060a400, 0xc060a7ff, REGISTRY_AFRINIC    }, // 192.96.164.0    - 192.96.167.255 
	{ 0xc060a800, 0xc060b0ff, REGISTRY_ARIN       }, // 192.96.168.0    - 192.96.176.255 
	{ 0xc060b100, 0xc060bfff, REGISTRY_AFRINIC    }, // 192.96.177.0    - 192.96.191.255 
	{ 0xc060c000, 0xc060c0ff, REGISTRY_ARIN       }, // 192.96.192.0    - 192.96.192.255 
	{ 0xc060c100, 0xc060c7ff, REGISTRY_AFRINIC    }, // 192.96.193.0    - 192.96.199.255 
	{ 0xc060c800, 0xc060dfff, REGISTRY_ARIN       }, // 192.96.200.0    - 192.96.223.255 
	{ 0xc060e000, 0xc060e8ff, REGISTRY_AFRINIC    }, // 192.96.224.0    - 192.96.232.255 
	{ 0xc060e900, 0xc060e9ff, REGISTRY_ARIN       }, // 192.96.233.0    - 192.96.233.255 
	{ 0xc060ea00, 0xc060f3ff, REGISTRY_AFRINIC    }, // 192.96.234.0    - 192.96.243.255 
	{ 0xc060f400, 0xc060f4ff, REGISTRY_ARIN       }, // 192.96.244.0    - 192.96.244.255 
	{ 0xc060f500, 0xc060feff, REGISTRY_AFRINIC    }, // 192.96.245.0    - 192.96.254.255 
	{ 0xc060ff00, 0xc061ffff, REGISTRY_ARIN       }, // 192.96.255.0    - 192.97.255.255 
	{ 0xc0620000, 0xc062ffff, REGISTRY_RIPENCC    }, // 192.98.0.0      - 192.98.255.255 
	{ 0xc0630000, 0xc06400ff, REGISTRY_ARIN       }, // 192.99.0.0      - 192.100.0.255  
	{ 0xc0640100, 0xc06401ff, REGISTRY_AFRINIC    }, // 192.100.1.0     - 192.100.1.255  
	{ 0xc0640200, 0xc06402ff, REGISTRY_APNIC      }, // 192.100.2.0     - 192.100.2.255  
	{ 0xc0640300, 0xc06411ff, REGISTRY_ARIN       }, // 192.100.3.0     - 192.100.17.255 
	{ 0xc0641200, 0xc06412ff, REGISTRY_RIPENCC    }, // 192.100.18.0    - 192.100.18.255 
	{ 0xc0641300, 0xc06415ff, REGISTRY_ARIN       }, // 192.100.19.0    - 192.100.21.255 
	{ 0xc0641600, 0xc06416ff, REGISTRY_APNIC      }, // 192.100.22.0    - 192.100.22.255 
	{ 0xc0641700, 0xc06419ff, REGISTRY_RIPENCC    }, // 192.100.23.0    - 192.100.25.255 
	{ 0xc0641a00, 0xc06433ff, REGISTRY_ARIN       }, // 192.100.26.0    - 192.100.51.255 
	{ 0xc0643400, 0xc06434ff, REGISTRY_RIPENCC    }, // 192.100.52.0    - 192.100.52.255 
	{ 0xc0643500, 0xc06435ff, REGISTRY_APNIC      }, // 192.100.53.0    - 192.100.53.255 
	{ 0xc0643600, 0xc0643cff, REGISTRY_ARIN       }, // 192.100.54.0    - 192.100.60.255 
	{ 0xc0643d00, 0xc0643dff, REGISTRY_RIPENCC    }, // 192.100.61.0    - 192.100.61.255 
	{ 0xc0643e00, 0xc0643eff, REGISTRY_ARIN       }, // 192.100.62.0    - 192.100.62.255 
	{ 0xc0643f00, 0xc0643fff, REGISTRY_RIPENCC    }, // 192.100.63.0    - 192.100.63.255 
	{ 0xc0644000, 0xc0644cff, REGISTRY_ARIN       }, // 192.100.64.0    - 192.100.76.255 
	{ 0xc0644d00, 0xc0644dff, REGISTRY_APNIC      }, // 192.100.77.0    - 192.100.77.255 
	{ 0xc0644e00, 0xc0644eff, REGISTRY_RIPENCC    }, // 192.100.78.0    - 192.100.78.255 
	{ 0xc0644f00, 0xc0644fff, REGISTRY_ARIN       }, // 192.100.79.0    - 192.100.79.255 
	{ 0xc0645000, 0xc06450ff, REGISTRY_APNIC      }, // 192.100.80.0    - 192.100.80.255 
	{ 0xc0645100, 0xc0645fff, REGISTRY_ARIN       }, // 192.100.81.0    - 192.100.95.255 
	{ 0xc0646000, 0xc06463ff, REGISTRY_RIPENCC    }, // 192.100.96.0    - 192.100.99.255 
	{ 0xc0646400, 0xc06465ff, REGISTRY_ARIN       }, // 192.100.100.0   - 192.100.101.255
	{ 0xc0646600, 0xc06485ff, REGISTRY_RIPENCC    }, // 192.100.102.0   - 192.100.133.255
	{ 0xc0648600, 0xc06486ff, REGISTRY_ARIN       }, // 192.100.134.0   - 192.100.134.255
	{ 0xc0648700, 0xc0648cff, REGISTRY_RIPENCC    }, // 192.100.135.0   - 192.100.140.255
	{ 0xc0648d00, 0xc0648fff, REGISTRY_ARIN       }, // 192.100.141.0   - 192.100.143.255
	{ 0xc0649000, 0xc06490ff, REGISTRY_RIPENCC    }, // 192.100.144.0   - 192.100.144.255
	{ 0xc0649100, 0xc06499ff, REGISTRY_ARIN       }, // 192.100.145.0   - 192.100.153.255
	{ 0xc0649a00, 0xc0649aff, REGISTRY_RIPENCC    }, // 192.100.154.0   - 192.100.154.255
	{ 0xc0649b00, 0xc064f6ff, REGISTRY_LACNIC     }, // 192.100.155.0   - 192.100.246.255
	{ 0xc064f800, 0xc064fbff, REGISTRY_LACNIC     }, // 192.100.248.0   - 192.100.251.255
	{ 0xc064fe00, 0xc064feff, REGISTRY_LACNIC     }, // 192.100.254.0   - 192.100.254.255
	{ 0xc064ff00, 0xc06500ff, REGISTRY_ARIN       }, // 192.100.255.0   - 192.101.0.255  
	{ 0xc0650100, 0xc06501ff, REGISTRY_RIPENCC    }, // 192.101.1.0     - 192.101.1.255  
	{ 0xc0650200, 0xc06503ff, REGISTRY_ARIN       }, // 192.101.2.0     - 192.101.3.255  
	{ 0xc0650400, 0xc06504ff, REGISTRY_RIPENCC    }, // 192.101.4.0     - 192.101.4.255  
	{ 0xc0650500, 0xc06507ff, REGISTRY_ARIN       }, // 192.101.5.0     - 192.101.7.255  
	{ 0xc0650800, 0xc06508ff, REGISTRY_RIPENCC    }, // 192.101.8.0     - 192.101.8.255  
	{ 0xc0650900, 0xc0650aff, REGISTRY_ARIN       }, // 192.101.9.0     - 192.101.10.255 
	{ 0xc0650b00, 0xc0650bff, REGISTRY_RIPENCC    }, // 192.101.11.0    - 192.101.11.255 
	{ 0xc0650c00, 0xc0650fff, REGISTRY_ARIN       }, // 192.101.12.0    - 192.101.15.255 
	{ 0xc0651000, 0xc06510ff, REGISTRY_APNIC      }, // 192.101.16.0    - 192.101.16.255 
	{ 0xc0651100, 0xc0651bff, REGISTRY_ARIN       }, // 192.101.17.0    - 192.101.27.255 
	{ 0xc0651c00, 0xc0651cff, REGISTRY_RIPENCC    }, // 192.101.28.0    - 192.101.28.255 
	{ 0xc0651d00, 0xc06521ff, REGISTRY_ARIN       }, // 192.101.29.0    - 192.101.33.255 
	{ 0xc0652200, 0xc06522ff, REGISTRY_RIPENCC    }, // 192.101.34.0    - 192.101.34.255 
	{ 0xc0652300, 0xc0654aff, REGISTRY_ARIN       }, // 192.101.35.0    - 192.101.74.255 
	{ 0xc0654b00, 0xc0654bff, REGISTRY_RIPENCC    }, // 192.101.75.0    - 192.101.75.255 
	{ 0xc0654c00, 0xc06550ff, REGISTRY_ARIN       }, // 192.101.76.0    - 192.101.80.255 
	{ 0xc0655100, 0xc0655aff, REGISTRY_RIPENCC    }, // 192.101.81.0    - 192.101.90.255 
	{ 0xc0655b00, 0xc0655bff, REGISTRY_APNIC      }, // 192.101.91.0    - 192.101.91.255 
	{ 0xc0655c00, 0xc06575ff, REGISTRY_ARIN       }, // 192.101.92.0    - 192.101.117.255
	{ 0xc0657600, 0xc06576ff, REGISTRY_RIPENCC    }, // 192.101.118.0   - 192.101.118.255
	{ 0xc0657700, 0xc06585ff, REGISTRY_ARIN       }, // 192.101.119.0   - 192.101.133.255
	{ 0xc0658600, 0xc06586ff, REGISTRY_APNIC      }, // 192.101.134.0   - 192.101.134.255
	{ 0xc0658700, 0xc06588ff, REGISTRY_ARIN       }, // 192.101.135.0   - 192.101.136.255
	{ 0xc0658900, 0xc06589ff, REGISTRY_RIPENCC    }, // 192.101.137.0   - 192.101.137.255
	{ 0xc0658a00, 0xc0658dff, REGISTRY_ARIN       }, // 192.101.138.0   - 192.101.141.255
	{ 0xc0658e00, 0xc0658eff, REGISTRY_AFRINIC    }, // 192.101.142.0   - 192.101.142.255
	{ 0xc0658f00, 0xc065a0ff, REGISTRY_ARIN       }, // 192.101.143.0   - 192.101.160.255
	{ 0xc065a100, 0xc065a8ff, REGISTRY_RIPENCC    }, // 192.101.161.0   - 192.101.168.255
	{ 0xc065a900, 0xc065a9ff, REGISTRY_ARIN       }, // 192.101.169.0   - 192.101.169.255
	{ 0xc065aa00, 0xc065aaff, REGISTRY_RIPENCC    }, // 192.101.170.0   - 192.101.170.255
	{ 0xc065ab00, 0xc065afff, REGISTRY_ARIN       }, // 192.101.171.0   - 192.101.175.255
	{ 0xc065b000, 0xc065b0ff, REGISTRY_RIPENCC    }, // 192.101.176.0   - 192.101.176.255
	{ 0xc065b100, 0xc065b2ff, REGISTRY_ARIN       }, // 192.101.177.0   - 192.101.178.255
	{ 0xc065b300, 0xc065b4ff, REGISTRY_RIPENCC    }, // 192.101.179.0   - 192.101.180.255
	{ 0xc065b500, 0xc065b6ff, REGISTRY_ARIN       }, // 192.101.181.0   - 192.101.182.255
	{ 0xc065b700, 0xc065b7ff, REGISTRY_APNIC      }, // 192.101.183.0   - 192.101.183.255
	{ 0xc065b800, 0xc065bfff, REGISTRY_ARIN       }, // 192.101.184.0   - 192.101.191.255
	{ 0xc065c000, 0xc065c0ff, REGISTRY_RIPENCC    }, // 192.101.192.0   - 192.101.192.255
	{ 0xc065c100, 0xc065c4ff, REGISTRY_ARIN       }, // 192.101.193.0   - 192.101.196.255
	{ 0xc065c500, 0xc065c6ff, REGISTRY_RIPENCC    }, // 192.101.197.0   - 192.101.198.255
	{ 0xc065c700, 0xc065fbff, REGISTRY_ARIN       }, // 192.101.199.0   - 192.101.251.255
	{ 0xc065fc00, 0xc065fcff, REGISTRY_RIPENCC    }, // 192.101.252.0   - 192.101.252.255
	{ 0xc065fd00, 0xc065fdff, REGISTRY_ARIN       }, // 192.101.253.0   - 192.101.253.255
	{ 0xc065fe00, 0xc065feff, REGISTRY_APNIC      }, // 192.101.254.0   - 192.101.254.255
	{ 0xc065ff00, 0xc06600ff, REGISTRY_ARIN       }, // 192.101.255.0   - 192.102.0.255  
	{ 0xc0660100, 0xc06601ff, REGISTRY_RIPENCC    }, // 192.102.1.0     - 192.102.1.255  
	{ 0xc0660200, 0xc06605ff, REGISTRY_ARIN       }, // 192.102.2.0     - 192.102.5.255  
	{ 0xc0660600, 0xc06608ff, REGISTRY_RIPENCC    }, // 192.102.6.0     - 192.102.8.255  
	{ 0xc0660900, 0xc06609ff, REGISTRY_AFRINIC    }, // 192.102.9.0     - 192.102.9.255  
	{ 0xc0660a00, 0xc06610ff, REGISTRY_ARIN       }, // 192.102.10.0    - 192.102.16.255 
	{ 0xc0661100, 0xc06651ff, REGISTRY_RIPENCC    }, // 192.102.17.0    - 192.102.81.255 
	{ 0xc0665200, 0xc06652ff, REGISTRY_ARIN       }, // 192.102.82.0    - 192.102.82.255 
	{ 0xc0665300, 0xc06653ff, REGISTRY_APNIC      }, // 192.102.83.0    - 192.102.83.255 
	{ 0xc0665400, 0xc06654ff, REGISTRY_LACNIC     }, // 192.102.84.0    - 192.102.84.255 
	{ 0xc0665500, 0xc06658ff, REGISTRY_ARIN       }, // 192.102.85.0    - 192.102.88.255 
	{ 0xc0665900, 0xc06659ff, REGISTRY_RIPENCC    }, // 192.102.89.0    - 192.102.89.255 
	{ 0xc0665a00, 0xc0665bff, REGISTRY_ARIN       }, // 192.102.90.0    - 192.102.91.255 
	{ 0xc0665c00, 0xc0665cff, REGISTRY_APNIC      }, // 192.102.92.0    - 192.102.92.255 
	{ 0xc0665d00, 0xc0665eff, REGISTRY_ARIN       }, // 192.102.93.0    - 192.102.94.255 
	{ 0xc0665f00, 0xc0665fff, REGISTRY_RIPENCC    }, // 192.102.95.0    - 192.102.95.255 
	{ 0xc0666000, 0xc06691ff, REGISTRY_ARIN       }, // 192.102.96.0    - 192.102.145.255
	{ 0xc0669200, 0xc066b1ff, REGISTRY_RIPENCC    }, // 192.102.146.0   - 192.102.177.255
	{ 0xc066b200, 0xc066d5ff, REGISTRY_ARIN       }, // 192.102.178.0   - 192.102.213.255
	{ 0xc066d600, 0xc066d6ff, REGISTRY_RIPENCC    }, // 192.102.214.0   - 192.102.214.255
	{ 0xc066d700, 0xc066dfff, REGISTRY_ARIN       }, // 192.102.215.0   - 192.102.223.255
	{ 0xc066e000, 0xc066e1ff, REGISTRY_RIPENCC    }, // 192.102.224.0   - 192.102.225.255
	{ 0xc066e200, 0xc066e2ff, REGISTRY_ARIN       }, // 192.102.226.0   - 192.102.226.255
	{ 0xc066e300, 0xc066e5ff, REGISTRY_RIPENCC    }, // 192.102.227.0   - 192.102.229.255
	{ 0xc066e600, 0xc066eeff, REGISTRY_ARIN       }, // 192.102.230.0   - 192.102.238.255
	{ 0xc066ef00, 0xc066efff, REGISTRY_APNIC      }, // 192.102.239.0   - 192.102.239.255
	{ 0xc066f000, 0xc066f9ff, REGISTRY_ARIN       }, // 192.102.240.0   - 192.102.249.255
	{ 0xc066fa00, 0xc066fbff, REGISTRY_APNIC      }, // 192.102.250.0   - 192.102.251.255
	{ 0xc066fc00, 0xc06701ff, REGISTRY_ARIN       }, // 192.102.252.0   - 192.103.1.255  
	{ 0xc0670200, 0xc06702ff, REGISTRY_RIPENCC    }, // 192.103.2.0     - 192.103.2.255  
	{ 0xc0670300, 0xc06706ff, REGISTRY_ARIN       }, // 192.103.3.0     - 192.103.6.255  
	{ 0xc0670700, 0xc06707ff, REGISTRY_RIPENCC    }, // 192.103.7.0     - 192.103.7.255  
	{ 0xc0670800, 0xc0670dff, REGISTRY_ARIN       }, // 192.103.8.0     - 192.103.13.255 
	{ 0xc0670e00, 0xc0670eff, REGISTRY_RIPENCC    }, // 192.103.14.0    - 192.103.14.255 
	{ 0xc0670f00, 0xc06713ff, REGISTRY_ARIN       }, // 192.103.15.0    - 192.103.19.255 
	{ 0xc0671400, 0xc06714ff, REGISTRY_RIPENCC    }, // 192.103.20.0    - 192.103.20.255 
	{ 0xc0671500, 0xc06716ff, REGISTRY_ARIN       }, // 192.103.21.0    - 192.103.22.255 
	{ 0xc0671700, 0xc06717ff, REGISTRY_RIPENCC    }, // 192.103.23.0    - 192.103.23.255 
	{ 0xc0671800, 0xc0671aff, REGISTRY_ARIN       }, // 192.103.24.0    - 192.103.26.255 
	{ 0xc0671b00, 0xc06728ff, REGISTRY_RIPENCC    }, // 192.103.27.0    - 192.103.40.255 
	{ 0xc0672900, 0xc06729ff, REGISTRY_ARIN       }, // 192.103.41.0    - 192.103.41.255 
	{ 0xc0672b00, 0xc0672bff, REGISTRY_APNIC      }, // 192.103.43.0    - 192.103.43.255 
	{ 0xc0672c00, 0xc0672dff, REGISTRY_ARIN       }, // 192.103.44.0    - 192.103.45.255 
	{ 0xc0672f00, 0xc06754ff, REGISTRY_ARIN       }, // 192.103.47.0    - 192.103.84.255 
	{ 0xc0675500, 0xc06774ff, REGISTRY_RIPENCC    }, // 192.103.85.0    - 192.103.116.255
	{ 0xc0677500, 0xc06781ff, REGISTRY_ARIN       }, // 192.103.117.0   - 192.103.129.255
	{ 0xc0678200, 0xc06782ff, REGISTRY_APNIC      }, // 192.103.130.0   - 192.103.130.255
	{ 0xc0678300, 0xc06783ff, REGISTRY_ARIN       }, // 192.103.131.0   - 192.103.131.255
	{ 0xc0678500, 0xc06788ff, REGISTRY_ARIN       }, // 192.103.133.0   - 192.103.136.255
	{ 0xc0678900, 0xc0678bff, REGISTRY_RIPENCC    }, // 192.103.137.0   - 192.103.139.255
	{ 0xc0678c00, 0xc06792ff, REGISTRY_ARIN       }, // 192.103.140.0   - 192.103.146.255
	{ 0xc0679300, 0xc06793ff, REGISTRY_RIPENCC    }, // 192.103.147.0   - 192.103.147.255
	{ 0xc0679400, 0xc0680eff, REGISTRY_ARIN       }, // 192.103.148.0   - 192.104.14.255 
	{ 0xc0680f00, 0xc0680fff, REGISTRY_APNIC      }, // 192.104.15.0    - 192.104.15.255 
	{ 0xc0681000, 0xc06816ff, REGISTRY_ARIN       }, // 192.104.16.0    - 192.104.22.255 
	{ 0xc0681700, 0xc06817ff, REGISTRY_RIPENCC    }, // 192.104.23.0    - 192.104.23.255 
	{ 0xc0681800, 0xc0681bff, REGISTRY_ARIN       }, // 192.104.24.0    - 192.104.27.255 
	{ 0xc0681c00, 0xc0681dff, REGISTRY_RIPENCC    }, // 192.104.28.0    - 192.104.29.255 
	{ 0xc0681e00, 0xc06822ff, REGISTRY_ARIN       }, // 192.104.30.0    - 192.104.34.255 
	{ 0xc0682300, 0xc06825ff, REGISTRY_RIPENCC    }, // 192.104.35.0    - 192.104.37.255 
	{ 0xc0682600, 0xc06827ff, REGISTRY_ARIN       }, // 192.104.38.0    - 192.104.39.255 
	{ 0xc0682900, 0xc06829ff, REGISTRY_RIPENCC    }, // 192.104.41.0    - 192.104.41.255 
	{ 0xc0682a00, 0xc0682aff, REGISTRY_ARIN       }, // 192.104.42.0    - 192.104.42.255 
	{ 0xc0682b00, 0xc0682dff, REGISTRY_APNIC      }, // 192.104.43.0    - 192.104.45.255 
	{ 0xc0682e00, 0xc0682fff, REGISTRY_ARIN       }, // 192.104.46.0    - 192.104.47.255 
	{ 0xc0683000, 0xc06830ff, REGISTRY_RIPENCC    }, // 192.104.48.0    - 192.104.48.255 
	{ 0xc0683100, 0xc06834ff, REGISTRY_ARIN       }, // 192.104.49.0    - 192.104.52.255 
	{ 0xc0683500, 0xc06835ff, REGISTRY_RIPENCC    }, // 192.104.53.0    - 192.104.53.255 
	{ 0xc0683600, 0xc06836ff, REGISTRY_ARIN       }, // 192.104.54.0    - 192.104.54.255 
	{ 0xc0683700, 0xc0683aff, REGISTRY_RIPENCC    }, // 192.104.55.0    - 192.104.58.255 
	{ 0xc0683b00, 0xc06847ff, REGISTRY_ARIN       }, // 192.104.59.0    - 192.104.71.255 
	{ 0xc0684800, 0xc06848ff, REGISTRY_RIPENCC    }, // 192.104.72.0    - 192.104.72.255 
	{ 0xc0684900, 0xc0684cff, REGISTRY_ARIN       }, // 192.104.73.0    - 192.104.76.255 
	{ 0xc0684d00, 0xc0684dff, REGISTRY_RIPENCC    }, // 192.104.77.0    - 192.104.77.255 
	{ 0xc0684e00, 0xc0684fff, REGISTRY_ARIN       }, // 192.104.78.0    - 192.104.79.255 
	{ 0xc0685100, 0xc06851ff, REGISTRY_ARIN       }, // 192.104.81.0    - 192.104.81.255 
	{ 0xc0685200, 0xc06852ff, REGISTRY_RIPENCC    }, // 192.104.82.0    - 192.104.82.255 
	{ 0xc0685300, 0xc0688bff, REGISTRY_ARIN       }, // 192.104.83.0    - 192.104.139.255
	{ 0xc0688c00, 0xc0688cff, REGISTRY_RIPENCC    }, // 192.104.140.0   - 192.104.140.255
	{ 0xc0688d00, 0xc0688dff, REGISTRY_ARIN       }, // 192.104.141.0   - 192.104.141.255
	{ 0xc0688e00, 0xc0688eff, REGISTRY_RIPENCC    }, // 192.104.142.0   - 192.104.142.255
	{ 0xc0688f00, 0xc06892ff, REGISTRY_ARIN       }, // 192.104.143.0   - 192.104.146.255
	{ 0xc0689300, 0xc06893ff, REGISTRY_RIPENCC    }, // 192.104.147.0   - 192.104.147.255
	{ 0xc0689400, 0xc06899ff, REGISTRY_ARIN       }, // 192.104.148.0   - 192.104.153.255
	{ 0xc0689a00, 0xc0689bff, REGISTRY_RIPENCC    }, // 192.104.154.0   - 192.104.155.255
	{ 0xc0689c00, 0xc068a6ff, REGISTRY_ARIN       }, // 192.104.156.0   - 192.104.166.255
	{ 0xc068a700, 0xc068a8ff, REGISTRY_RIPENCC    }, // 192.104.167.0   - 192.104.168.255
	{ 0xc068a900, 0xc068abff, REGISTRY_ARIN       }, // 192.104.169.0   - 192.104.171.255
	{ 0xc068ac00, 0xc068acff, REGISTRY_APNIC      }, // 192.104.172.0   - 192.104.172.255
	{ 0xc068ad00, 0xc068e7ff, REGISTRY_ARIN       }, // 192.104.173.0   - 192.104.231.255
	{ 0xc068e800, 0xc068e9ff, REGISTRY_APNIC      }, // 192.104.232.0   - 192.104.233.255
	{ 0xc068ea00, 0xc068edff, REGISTRY_ARIN       }, // 192.104.234.0   - 192.104.237.255
	{ 0xc068ee00, 0xc068eeff, REGISTRY_RIPENCC    }, // 192.104.238.0   - 192.104.238.255
	{ 0xc068ef00, 0xc068f4ff, REGISTRY_ARIN       }, // 192.104.239.0   - 192.104.244.255
	{ 0xc068f500, 0xc068f5ff, REGISTRY_RIPENCC    }, // 192.104.245.0   - 192.104.245.255
	{ 0xc068f600, 0xc068f7ff, REGISTRY_APNIC      }, // 192.104.246.0   - 192.104.247.255
	{ 0xc068f800, 0xc068f8ff, REGISTRY_RIPENCC    }, // 192.104.248.0   - 192.104.248.255
	{ 0xc068f900, 0xc068faff, REGISTRY_ARIN       }, // 192.104.249.0   - 192.104.250.255
	{ 0xc068fb00, 0xc068fbff, REGISTRY_RIPENCC    }, // 192.104.251.0   - 192.104.251.255
	{ 0xc068fd00, 0xc06909ff, REGISTRY_ARIN       }, // 192.104.253.0   - 192.105.9.255  
	{ 0xc0690a00, 0xc0690aff, REGISTRY_APNIC      }, // 192.105.10.0    - 192.105.10.255 
	{ 0xc0690b00, 0xc0694aff, REGISTRY_ARIN       }, // 192.105.11.0    - 192.105.74.255 
	{ 0xc0694b00, 0xc0694bff, REGISTRY_RIPENCC    }, // 192.105.75.0    - 192.105.75.255 
	{ 0xc0694c00, 0xc069ffff, REGISTRY_ARIN       }, // 192.105.76.0    - 192.105.255.255
	{ 0xc06a0000, 0xc06affff, REGISTRY_RIPENCC    }, // 192.106.0.0     - 192.106.255.255
	{ 0xc06b0000, 0xc06b00ff, REGISTRY_ARIN       }, // 192.107.0.0     - 192.107.0.255  
	{ 0xc06b0200, 0xc06b02ff, REGISTRY_RIPENCC    }, // 192.107.2.0     - 192.107.2.255  
	{ 0xc06b0300, 0xc06b03ff, REGISTRY_ARIN       }, // 192.107.3.0     - 192.107.3.255  
	{ 0xc06b0400, 0xc06b05ff, REGISTRY_RIPENCC    }, // 192.107.4.0     - 192.107.5.255  
	{ 0xc06b0600, 0xc06b08ff, REGISTRY_ARIN       }, // 192.107.6.0     - 192.107.8.255  
	{ 0xc06b0900, 0xc06b09ff, REGISTRY_APNIC      }, // 192.107.9.0     - 192.107.9.255  
	{ 0xc06b0b00, 0xc06b0dff, REGISTRY_RIPENCC    }, // 192.107.11.0    - 192.107.13.255 
	{ 0xc06b0e00, 0xc06b32ff, REGISTRY_ARIN       }, // 192.107.14.0    - 192.107.50.255 
	{ 0xc06b3300, 0xc06b64ff, REGISTRY_RIPENCC    }, // 192.107.51.0    - 192.107.100.255
	{ 0xc06b6500, 0xc06b65ff, REGISTRY_APNIC      }, // 192.107.101.0   - 192.107.101.255
	{ 0xc06b6600, 0xc06b67ff, REGISTRY_ARIN       }, // 192.107.102.0   - 192.107.103.255
	{ 0xc06b6800, 0xc06b68ff, REGISTRY_LACNIC     }, // 192.107.104.0   - 192.107.104.255
	{ 0xc06b6900, 0xc06b6dff, REGISTRY_ARIN       }, // 192.107.105.0   - 192.107.109.255
	{ 0xc06b6e00, 0xc06b6eff, REGISTRY_RIPENCC    }, // 192.107.110.0   - 192.107.110.255
	{ 0xc06b6f00, 0xc06b6fff, REGISTRY_ARIN       }, // 192.107.111.0   - 192.107.111.255
	{ 0xc06b7100, 0xc06b71ff, REGISTRY_APNIC      }, // 192.107.113.0   - 192.107.113.255
	{ 0xc06b7200, 0xc06b72ff, REGISTRY_RIPENCC    }, // 192.107.114.0   - 192.107.114.255
	{ 0xc06b7300, 0xc06b79ff, REGISTRY_ARIN       }, // 192.107.115.0   - 192.107.121.255
	{ 0xc06b7a00, 0xc06b81ff, REGISTRY_RIPENCC    }, // 192.107.122.0   - 192.107.129.255
	{ 0xc06b8200, 0xc06b83ff, REGISTRY_ARIN       }, // 192.107.130.0   - 192.107.131.255
	{ 0xc06b8400, 0xc06b84ff, REGISTRY_RIPENCC    }, // 192.107.132.0   - 192.107.132.255
	{ 0xc06b8500, 0xc06ba7ff, REGISTRY_ARIN       }, // 192.107.133.0   - 192.107.167.255
	{ 0xc06ba800, 0xc06ba8ff, REGISTRY_RIPENCC    }, // 192.107.168.0   - 192.107.168.255
	{ 0xc06ba900, 0xc06baaff, REGISTRY_ARIN       }, // 192.107.169.0   - 192.107.170.255
	{ 0xc06bab00, 0xc06bacff, REGISTRY_APNIC      }, // 192.107.171.0   - 192.107.172.255
	{ 0xc06bad00, 0xc06badff, REGISTRY_ARIN       }, // 192.107.173.0   - 192.107.173.255
	{ 0xc06bae00, 0xc06baeff, REGISTRY_RIPENCC    }, // 192.107.174.0   - 192.107.174.255
	{ 0xc06baf00, 0xc06bb0ff, REGISTRY_ARIN       }, // 192.107.175.0   - 192.107.176.255
	{ 0xc06bb100, 0xc06bb2ff, REGISTRY_RIPENCC    }, // 192.107.177.0   - 192.107.178.255
	{ 0xc06bb300, 0xc06bbaff, REGISTRY_ARIN       }, // 192.107.179.0   - 192.107.186.255
	{ 0xc06bbb00, 0xc06bbbff, REGISTRY_RIPENCC    }, // 192.107.187.0   - 192.107.187.255
	{ 0xc06bbc00, 0xc06bc7ff, REGISTRY_ARIN       }, // 192.107.188.0   - 192.107.199.255
	{ 0xc06bc800, 0xc06be9ff, REGISTRY_RIPENCC    }, // 192.107.200.0   - 192.107.233.255
	{ 0xc06bea00, 0xc06beaff, REGISTRY_ARIN       }, // 192.107.234.0   - 192.107.234.255
	{ 0xc06beb00, 0xc06becff, REGISTRY_RIPENCC    }, // 192.107.235.0   - 192.107.236.255
	{ 0xc06bed00, 0xc06c16ff, REGISTRY_ARIN       }, // 192.107.237.0   - 192.108.22.255 
	{ 0xc06c1700, 0xc06c31ff, REGISTRY_RIPENCC    }, // 192.108.23.0    - 192.108.49.255 
	{ 0xc06c3200, 0xc06c32ff, REGISTRY_ARIN       }, // 192.108.50.0    - 192.108.50.255 
	{ 0xc06c3300, 0xc06c5cff, REGISTRY_RIPENCC    }, // 192.108.51.0    - 192.108.92.255 
	{ 0xc06c5d00, 0xc06c62ff, REGISTRY_ARIN       }, // 192.108.93.0    - 192.108.98.255 
	{ 0xc06c6300, 0xc06c63ff, REGISTRY_APNIC      }, // 192.108.99.0    - 192.108.99.255 
	{ 0xc06c6400, 0xc06c65ff, REGISTRY_RIPENCC    }, // 192.108.100.0   - 192.108.101.255
	{ 0xc06c6600, 0xc06c6aff, REGISTRY_ARIN       }, // 192.108.102.0   - 192.108.106.255
	{ 0xc06c6b00, 0xc06c6cff, REGISTRY_RIPENCC    }, // 192.108.107.0   - 192.108.108.255
	{ 0xc06c6d00, 0xc06c70ff, REGISTRY_ARIN       }, // 192.108.109.0   - 192.108.112.255
	{ 0xc06c7200, 0xc06c79ff, REGISTRY_RIPENCC    }, // 192.108.114.0   - 192.108.121.255
	{ 0xc06c7a00, 0xc06c7cff, REGISTRY_ARIN       }, // 192.108.122.0   - 192.108.124.255
	{ 0xc06c7d00, 0xc06c7eff, REGISTRY_RIPENCC    }, // 192.108.125.0   - 192.108.126.255
	{ 0xc06c7f00, 0xc06c7fff, REGISTRY_ARIN       }, // 192.108.127.0   - 192.108.127.255
	{ 0xc06c8000, 0xc06caeff, REGISTRY_RIPENCC    }, // 192.108.128.0   - 192.108.174.255
	{ 0xc06caf00, 0xc06cc2ff, REGISTRY_ARIN       }, // 192.108.175.0   - 192.108.194.255
	{ 0xc06cc300, 0xc06cd6ff, REGISTRY_RIPENCC    }, // 192.108.195.0   - 192.108.214.255
	{ 0xc06cd700, 0xc06ce5ff, REGISTRY_ARIN       }, // 192.108.215.0   - 192.108.229.255
	{ 0xc06ce600, 0xc06ce6ff, REGISTRY_APNIC      }, // 192.108.230.0   - 192.108.230.255
	{ 0xc06ce700, 0xc06ce9ff, REGISTRY_ARIN       }, // 192.108.231.0   - 192.108.233.255
	{ 0xc06cea00, 0xc06ceaff, REGISTRY_RIPENCC    }, // 192.108.234.0   - 192.108.234.255
	{ 0xc06ceb00, 0xc06cedff, REGISTRY_ARIN       }, // 192.108.235.0   - 192.108.237.255
	{ 0xc06cee00, 0xc06ceeff, REGISTRY_RIPENCC    }, // 192.108.238.0   - 192.108.238.255
	{ 0xc06cef00, 0xc06cffff, REGISTRY_ARIN       }, // 192.108.239.0   - 192.108.255.255
	{ 0xc06d0000, 0xc06d10ff, REGISTRY_RIPENCC    }, // 192.109.0.0     - 192.109.16.255 
	{ 0xc06d1200, 0xc06d24ff, REGISTRY_RIPENCC    }, // 192.109.18.0    - 192.109.36.255 
	{ 0xc06d2600, 0xc06d27ff, REGISTRY_RIPENCC    }, // 192.109.38.0    - 192.109.39.255 
	{ 0xc06d2900, 0xc06d2cff, REGISTRY_RIPENCC    }, // 192.109.41.0    - 192.109.44.255 
	{ 0xc06d2d00, 0xc06d2dff, REGISTRY_ARIN       }, // 192.109.45.0    - 192.109.45.255 
	{ 0xc06d2e00, 0xc06d4aff, REGISTRY_RIPENCC    }, // 192.109.46.0    - 192.109.74.255 
	{ 0xc06d4b00, 0xc06d4bff, REGISTRY_ARIN       }, // 192.109.75.0    - 192.109.75.255 
	{ 0xc06d4c00, 0xc06d5bff, REGISTRY_RIPENCC    }, // 192.109.76.0    - 192.109.91.255 
	{ 0xc06d5c00, 0xc06d5dff, REGISTRY_ARIN       }, // 192.109.92.0    - 192.109.93.255 
	{ 0xc06d5e00, 0xc06d62ff, REGISTRY_RIPENCC    }, // 192.109.94.0    - 192.109.98.255 
	{ 0xc06d6300, 0xc06d63ff, REGISTRY_ARIN       }, // 192.109.99.0    - 192.109.99.255 
	{ 0xc06d6500, 0xc06d66ff, REGISTRY_RIPENCC    }, // 192.109.101.0   - 192.109.102.255
	{ 0xc06d6700, 0xc06d68ff, REGISTRY_ARIN       }, // 192.109.103.0   - 192.109.104.255
	{ 0xc06d6900, 0xc06d77ff, REGISTRY_RIPENCC    }, // 192.109.105.0   - 192.109.119.255
	{ 0xc06d7800, 0xc06d78ff, REGISTRY_ARIN       }, // 192.109.120.0   - 192.109.120.255
	{ 0xc06d7900, 0xc06dc7ff, REGISTRY_RIPENCC    }, // 192.109.121.0   - 192.109.199.255
	{ 0xc06dca00, 0xc06ddaff, REGISTRY_RIPENCC    }, // 192.109.202.0   - 192.109.218.255
	{ 0xc06ddc00, 0xc06ddfff, REGISTRY_RIPENCC    }, // 192.109.220.0   - 192.109.223.255
	{ 0xc06de200, 0xc06df1ff, REGISTRY_RIPENCC    }, // 192.109.226.0   - 192.109.241.255
	{ 0xc06df200, 0xc06df2ff, REGISTRY_AFRINIC    }, // 192.109.242.0   - 192.109.242.255
	{ 0xc06df300, 0xc06df3ff, REGISTRY_RIPENCC    }, // 192.109.243.0   - 192.109.243.255
	{ 0xc06df500, 0xc06df7ff, REGISTRY_RIPENCC    }, // 192.109.245.0   - 192.109.247.255
	{ 0xc06df900, 0xc06dffff, REGISTRY_RIPENCC    }, // 192.109.249.0   - 192.109.255.255
	{ 0xc06e0000, 0xc06f1fff, REGISTRY_ARIN       }, // 192.110.0.0     - 192.111.31.255 
	{ 0xc06f2000, 0xc06f20ff, REGISTRY_APNIC      }, // 192.111.32.0    - 192.111.32.255 
	{ 0xc06f2100, 0xc06f21ff, REGISTRY_RIPENCC    }, // 192.111.33.0    - 192.111.33.255 
	{ 0xc06f2200, 0xc06f26ff, REGISTRY_ARIN       }, // 192.111.34.0    - 192.111.38.255 
	{ 0xc06f2700, 0xc06f27ff, REGISTRY_RIPENCC    }, // 192.111.39.0    - 192.111.39.255 
	{ 0xc06f2800, 0xc06f2bff, REGISTRY_ARIN       }, // 192.111.40.0    - 192.111.43.255 
	{ 0xc06f2c00, 0xc06f2cff, REGISTRY_RIPENCC    }, // 192.111.44.0    - 192.111.44.255 
	{ 0xc06f2d00, 0xc06f2eff, REGISTRY_ARIN       }, // 192.111.45.0    - 192.111.46.255 
	{ 0xc06f2f00, 0xc06f30ff, REGISTRY_RIPENCC    }, // 192.111.47.0    - 192.111.48.255 
	{ 0xc06f3100, 0xc06f57ff, REGISTRY_ARIN       }, // 192.111.49.0    - 192.111.87.255 
	{ 0xc06f5800, 0xc06f58ff, REGISTRY_RIPENCC    }, // 192.111.88.0    - 192.111.88.255 
	{ 0xc06f5900, 0xc06f64ff, REGISTRY_ARIN       }, // 192.111.89.0    - 192.111.100.255
	{ 0xc06f6500, 0xc06f65ff, REGISTRY_RIPENCC    }, // 192.111.101.0   - 192.111.101.255
	{ 0xc06f6600, 0xc06f66ff, REGISTRY_APNIC      }, // 192.111.102.0   - 192.111.102.255
	{ 0xc06f6700, 0xc06f68ff, REGISTRY_RIPENCC    }, // 192.111.103.0   - 192.111.104.255
	{ 0xc06f6900, 0xc06f69ff, REGISTRY_APNIC      }, // 192.111.105.0   - 192.111.105.255
	{ 0xc06f6a00, 0xc06f7bff, REGISTRY_ARIN       }, // 192.111.106.0   - 192.111.123.255
	{ 0xc06f7c00, 0xc06f7dff, REGISTRY_RIPENCC    }, // 192.111.124.0   - 192.111.125.255
	{ 0xc06f7e00, 0xc06f7eff, REGISTRY_ARIN       }, // 192.111.126.0   - 192.111.126.255
	{ 0xc06f7f00, 0xc06f7fff, REGISTRY_RIPENCC    }, // 192.111.127.0   - 192.111.127.255
	{ 0xc06f8000, 0xc06fe4ff, REGISTRY_ARIN       }, // 192.111.128.0   - 192.111.228.255
	{ 0xc06fe500, 0xc06fe5ff, REGISTRY_LACNIC     }, // 192.111.229.0   - 192.111.229.255
	{ 0xc06fe700, 0xc06ffbff, REGISTRY_ARIN       }, // 192.111.231.0   - 192.111.251.255
	{ 0xc06ffc00, 0xc06ffcff, REGISTRY_RIPENCC    }, // 192.111.252.0   - 192.111.252.255
	{ 0xc06ffd00, 0xc0701dff, REGISTRY_ARIN       }, // 192.111.253.0   - 192.112.29.255 
	{ 0xc0701e00, 0xc07020ff, REGISTRY_RIPENCC    }, // 192.112.30.0    - 192.112.32.255 
	{ 0xc0702100, 0xc0702cff, REGISTRY_ARIN       }, // 192.112.33.0    - 192.112.44.255 
	{ 0xc0702d00, 0xc0702dff, REGISTRY_RIPENCC    }, // 192.112.45.0    - 192.112.45.255 
	{ 0xc0702e00, 0xc07030ff, REGISTRY_ARIN       }, // 192.112.46.0    - 192.112.48.255 
	{ 0xc0703100, 0xc07031ff, REGISTRY_RIPENCC    }, // 192.112.49.0    - 192.112.49.255 
	{ 0xc0703200, 0xc0703cff, REGISTRY_ARIN       }, // 192.112.50.0    - 192.112.60.255 
	{ 0xc0703d00, 0xc0703dff, REGISTRY_RIPENCC    }, // 192.112.61.0    - 192.112.61.255 
	{ 0xc0703e00, 0xc07045ff, REGISTRY_ARIN       }, // 192.112.62.0    - 192.112.69.255 
	{ 0xc0704600, 0xc0704fff, REGISTRY_RIPENCC    }, // 192.112.70.0    - 192.112.79.255 
	{ 0xc0705000, 0xc07061ff, REGISTRY_ARIN       }, // 192.112.80.0    - 192.112.97.255 
	{ 0xc0706200, 0xc07064ff, REGISTRY_RIPENCC    }, // 192.112.98.0    - 192.112.100.255
	{ 0xc0706500, 0xc070cbff, REGISTRY_ARIN       }, // 192.112.101.0   - 192.112.203.255
	{ 0xc070cc00, 0xc070ccff, REGISTRY_RIPENCC    }, // 192.112.204.0   - 192.112.204.255
	{ 0xc070cd00, 0xc070cdff, REGISTRY_ARIN       }, // 192.112.205.0   - 192.112.205.255
	{ 0xc070ce00, 0xc070ceff, REGISTRY_RIPENCC    }, // 192.112.206.0   - 192.112.206.255
	{ 0xc070cf00, 0xc070cfff, REGISTRY_ARIN       }, // 192.112.207.0   - 192.112.207.255
	{ 0xc070d000, 0xc070d0ff, REGISTRY_RIPENCC    }, // 192.112.208.0   - 192.112.208.255
	{ 0xc070d100, 0xc070d4ff, REGISTRY_ARIN       }, // 192.112.209.0   - 192.112.212.255
	{ 0xc070d500, 0xc070d6ff, REGISTRY_RIPENCC    }, // 192.112.213.0   - 192.112.214.255
	{ 0xc070d700, 0xc070d7ff, REGISTRY_APNIC      }, // 192.112.215.0   - 192.112.215.255
	{ 0xc070d800, 0xc070f6ff, REGISTRY_ARIN       }, // 192.112.216.0   - 192.112.246.255
	{ 0xc070f700, 0xc070f7ff, REGISTRY_RIPENCC    }, // 192.112.247.0   - 192.112.247.255
	{ 0xc070f800, 0xc070fdff, REGISTRY_ARIN       }, // 192.112.248.0   - 192.112.253.255
	{ 0xc070fe00, 0xc070feff, REGISTRY_RIPENCC    }, // 192.112.254.0   - 192.112.254.255
	{ 0xc070ff00, 0xc070ffff, REGISTRY_ARIN       }, // 192.112.255.0   - 192.112.255.255
	{ 0xc0710000, 0xc076ffff, REGISTRY_RIPENCC    }, // 192.113.0.0     - 192.118.255.255
	{ 0xc0770000, 0xc078ffff, REGISTRY_ARIN       }, // 192.119.0.0     - 192.120.255.255
	{ 0xc0790000, 0xc079ffff, REGISTRY_RIPENCC    }, // 192.121.0.0     - 192.121.255.255
	{ 0xc07a0000, 0xc07a00ff, REGISTRY_ARIN       }, // 192.122.0.0     - 192.122.0.255  
	{ 0xc07a0100, 0xc07a82ff, REGISTRY_RIPENCC    }, // 192.122.1.0     - 192.122.130.255
	{ 0xc07a8300, 0xc07a8cff, REGISTRY_APNIC      }, // 192.122.131.0   - 192.122.140.255
	{ 0xc07a8d00, 0xc07a92ff, REGISTRY_RIPENCC    }, // 192.122.141.0   - 192.122.146.255
	{ 0xc07a9300, 0xc07a96ff, REGISTRY_ARIN       }, // 192.122.147.0   - 192.122.150.255
	{ 0xc07a9700, 0xc07aaaff, REGISTRY_RIPENCC    }, // 192.122.151.0   - 192.122.170.255
	{ 0xc07aab00, 0xc07aabff, REGISTRY_APNIC      }, // 192.122.171.0   - 192.122.171.255
	{ 0xc07aac00, 0xc07aafff, REGISTRY_ARIN       }, // 192.122.172.0   - 192.122.175.255
	{ 0xc07ab000, 0xc07ab0ff, REGISTRY_APNIC      }, // 192.122.176.0   - 192.122.176.255
	{ 0xc07ab100, 0xc07ab3ff, REGISTRY_ARIN       }, // 192.122.177.0   - 192.122.179.255
	{ 0xc07ab400, 0xc07ab4ff, REGISTRY_APNIC      }, // 192.122.180.0   - 192.122.180.255
	{ 0xc07ab500, 0xc07ad1ff, REGISTRY_ARIN       }, // 192.122.181.0   - 192.122.209.255
	{ 0xc07ad300, 0xc07ad5ff, REGISTRY_ARIN       }, // 192.122.211.0   - 192.122.213.255
	{ 0xc07ad600, 0xc07ad6ff, REGISTRY_RIPENCC    }, // 192.122.214.0   - 192.122.214.255
	{ 0xc07ad700, 0xc07ad7ff, REGISTRY_ARIN       }, // 192.122.215.0   - 192.122.215.255
	{ 0xc07ad800, 0xc07aeaff, REGISTRY_RIPENCC    }, // 192.122.216.0   - 192.122.234.255
	{ 0xc07aeb00, 0xc07aedff, REGISTRY_ARIN       }, // 192.122.235.0   - 192.122.237.255
	{ 0xc07aee00, 0xc07af2ff, REGISTRY_RIPENCC    }, // 192.122.238.0   - 192.122.242.255
	{ 0xc07af300, 0xc07afdff, REGISTRY_ARIN       }, // 192.122.243.0   - 192.122.253.255
	{ 0xc07afe00, 0xc07afeff, REGISTRY_RIPENCC    }, // 192.122.254.0   - 192.122.254.255
	{ 0xc07aff00, 0xc07c09ff, REGISTRY_ARIN       }, // 192.122.255.0   - 192.124.9.255  
	{ 0xc07c0a00, 0xc07c0eff, REGISTRY_APNIC      }, // 192.124.10.0    - 192.124.14.255 
	{ 0xc07c0f00, 0xc07c17ff, REGISTRY_ARIN       }, // 192.124.15.0    - 192.124.23.255 
	{ 0xc07c1900, 0xc07c1cff, REGISTRY_RIPENCC    }, // 192.124.25.0    - 192.124.28.255 
	{ 0xc07c1d00, 0xc07c1fff, REGISTRY_ARIN       }, // 192.124.29.0    - 192.124.31.255 
	{ 0xc07c2000, 0xc07c20ff, REGISTRY_RIPENCC    }, // 192.124.32.0    - 192.124.32.255 
	{ 0xc07c2100, 0xc07c26ff, REGISTRY_ARIN       }, // 192.124.33.0    - 192.124.38.255 
	{ 0xc07c2700, 0xc07c27ff, REGISTRY_RIPENCC    }, // 192.124.39.0    - 192.124.39.255 
	{ 0xc07c2800, 0xc07c2dff, REGISTRY_ARIN       }, // 192.124.40.0    - 192.124.45.255 
	{ 0xc07c2e00, 0xc07c2eff, REGISTRY_RIPENCC    }, // 192.124.46.0    - 192.124.46.255 
	{ 0xc07c2f00, 0xc07c6fff, REGISTRY_ARIN       }, // 192.124.47.0    - 192.124.111.255
	{ 0xc07c7000, 0xc07c70ff, REGISTRY_RIPENCC    }, // 192.124.112.0   - 192.124.112.255
	{ 0xc07c7100, 0xc07c72ff, REGISTRY_ARIN       }, // 192.124.113.0   - 192.124.114.255
	{ 0xc07c7300, 0xc07c74ff, REGISTRY_RIPENCC    }, // 192.124.115.0   - 192.124.116.255
	{ 0xc07c7500, 0xc07c75ff, REGISTRY_APNIC      }, // 192.124.117.0   - 192.124.117.255
	{ 0xc07c7600, 0xc07c97ff, REGISTRY_ARIN       }, // 192.124.118.0   - 192.124.151.255
	{ 0xc07c9800, 0xc07c98ff, REGISTRY_APNIC      }, // 192.124.152.0   - 192.124.152.255
	{ 0xc07c9900, 0xc07c99ff, REGISTRY_ARIN       }, // 192.124.153.0   - 192.124.153.255
	{ 0xc07c9a00, 0xc07c9aff, REGISTRY_APNIC      }, // 192.124.154.0   - 192.124.154.255
	{ 0xc07c9b00, 0xc07c9bff, REGISTRY_RIPENCC    }, // 192.124.155.0   - 192.124.155.255
	{ 0xc07c9c00, 0xc07ca9ff, REGISTRY_ARIN       }, // 192.124.156.0   - 192.124.169.255
	{ 0xc07caa00, 0xc07cdbff, REGISTRY_RIPENCC    }, // 192.124.170.0   - 192.124.219.255
	{ 0xc07cdc00, 0xc07ceaff, REGISTRY_ARIN       }, // 192.124.220.0   - 192.124.234.255
	{ 0xc07ceb00, 0xc07cebff, REGISTRY_RIPENCC    }, // 192.124.235.0   - 192.124.235.255
	{ 0xc07cec00, 0xc07cecff, REGISTRY_ARIN       }, // 192.124.236.0   - 192.124.236.255
	{ 0xc07ced00, 0xc07cf5ff, REGISTRY_RIPENCC    }, // 192.124.237.0   - 192.124.245.255
	{ 0xc07cf600, 0xc07cf6ff, REGISTRY_ARIN       }, // 192.124.246.0   - 192.124.246.255
	{ 0xc07cf700, 0xc07cf8ff, REGISTRY_RIPENCC    }, // 192.124.247.0   - 192.124.248.255
	{ 0xc07cf900, 0xc07cf9ff, REGISTRY_ARIN       }, // 192.124.249.0   - 192.124.249.255
	{ 0xc07cfa00, 0xc07cfeff, REGISTRY_RIPENCC    }, // 192.124.250.0   - 192.124.254.255
	{ 0xc07cff00, 0xc07cffff, REGISTRY_ARIN       }, // 192.124.255.0   - 192.124.255.255
	{ 0xc07d0000, 0xc07dffff, REGISTRY_RIPENCC    }, // 192.125.0.0     - 192.125.255.255
	{ 0xc07e0000, 0xc07e00ff, REGISTRY_ARIN       }, // 192.126.0.0     - 192.126.0.255  
	{ 0xc07e0100, 0xc07e40ff, REGISTRY_RIPENCC    }, // 192.126.1.0     - 192.126.64.255 
	{ 0xc07e4100, 0xc08100ff, REGISTRY_ARIN       }, // 192.126.65.0    - 192.129.0.255  
	{ 0xc0810100, 0xc0813dff, REGISTRY_RIPENCC    }, // 192.129.1.0     - 192.129.61.255 
	{ 0xc0813e00, 0xc0814fff, REGISTRY_ARIN       }, // 192.129.62.0    - 192.129.79.255 
	{ 0xc0815000, 0xc08150ff, REGISTRY_RIPENCC    }, // 192.129.80.0    - 192.129.80.255 
	{ 0xc0815100, 0xc08156ff, REGISTRY_ARIN       }, // 192.129.81.0    - 192.129.86.255 
	{ 0xc0815700, 0xc08157ff, REGISTRY_RIPENCC    }, // 192.129.87.0    - 192.129.87.255 
	{ 0xc0815800, 0xc08161ff, REGISTRY_ARIN       }, // 192.129.88.0    - 192.129.97.255 
	{ 0xc0816200, 0xc08162ff, REGISTRY_RIPENCC    }, // 192.129.98.0    - 192.129.98.255 
	{ 0xc0816300, 0xc081ffff, REGISTRY_ARIN       }, // 192.129.99.0    - 192.129.255.255
	{ 0xc0820000, 0xc082ffff, REGISTRY_RIPENCC    }, // 192.130.0.0     - 192.130.255.255
	{ 0xc0830000, 0xc0830cff, REGISTRY_ARIN       }, // 192.131.0.0     - 192.131.12.255 
	{ 0xc0830d00, 0xc0830dff, REGISTRY_APNIC      }, // 192.131.13.0    - 192.131.13.255 
	{ 0xc0830e00, 0xc08313ff, REGISTRY_ARIN       }, // 192.131.14.0    - 192.131.19.255 
	{ 0xc0831400, 0xc08314ff, REGISTRY_RIPENCC    }, // 192.131.20.0    - 192.131.20.255 
	{ 0xc0831500, 0xc08318ff, REGISTRY_ARIN       }, // 192.131.21.0    - 192.131.24.255 
	{ 0xc0831900, 0xc0831aff, REGISTRY_RIPENCC    }, // 192.131.25.0    - 192.131.26.255 
	{ 0xc0831b00, 0xc0831eff, REGISTRY_APNIC      }, // 192.131.27.0    - 192.131.30.255 
	{ 0xc0831f00, 0xc0834eff, REGISTRY_ARIN       }, // 192.131.31.0    - 192.131.78.255 
	{ 0xc0834f00, 0xc0834fff, REGISTRY_RIPENCC    }, // 192.131.79.0    - 192.131.79.255 
	{ 0xc0835000, 0xc08358ff, REGISTRY_ARIN       }, // 192.131.80.0    - 192.131.88.255 
	{ 0xc0835900, 0xc08359ff, REGISTRY_RIPENCC    }, // 192.131.89.0    - 192.131.89.255 
	{ 0xc0835a00, 0xc0835cff, REGISTRY_APNIC      }, // 192.131.90.0    - 192.131.92.255 
	{ 0xc0835d00, 0xc0835fff, REGISTRY_ARIN       }, // 192.131.93.0    - 192.131.95.255 
	{ 0xc0836000, 0xc08360ff, REGISTRY_RIPENCC    }, // 192.131.96.0    - 192.131.96.255 
	{ 0xc0836100, 0xc0836bff, REGISTRY_ARIN       }, // 192.131.97.0    - 192.131.107.255
	{ 0xc0836c00, 0xc0836cff, REGISTRY_RIPENCC    }, // 192.131.108.0   - 192.131.108.255
	{ 0xc0836d00, 0xc08383ff, REGISTRY_ARIN       }, // 192.131.109.0   - 192.131.131.255
	{ 0xc0838400, 0xc08384ff, REGISTRY_RIPENCC    }, // 192.131.132.0   - 192.131.132.255
	{ 0xc0838500, 0xc083faff, REGISTRY_ARIN       }, // 192.131.133.0   - 192.131.250.255
	{ 0xc083fb00, 0xc083fcff, REGISTRY_APNIC      }, // 192.131.251.0   - 192.131.252.255
	{ 0xc083fd00, 0xc08408ff, REGISTRY_ARIN       }, // 192.131.253.0   - 192.132.8.255  
	{ 0xc0840900, 0xc0840bff, REGISTRY_RIPENCC    }, // 192.132.9.0     - 192.132.11.255 
	{ 0xc0840c00, 0xc0840eff, REGISTRY_ARIN       }, // 192.132.12.0    - 192.132.14.255 
	{ 0xc0840f00, 0xc0840fff, REGISTRY_APNIC      }, // 192.132.15.0    - 192.132.15.255 
	{ 0xc0841000, 0xc0841eff, REGISTRY_ARIN       }, // 192.132.16.0    - 192.132.30.255 
	{ 0xc0841f00, 0xc0841fff, REGISTRY_APNIC      }, // 192.132.31.0    - 192.132.31.255 
	{ 0xc0842000, 0xc08421ff, REGISTRY_ARIN       }, // 192.132.32.0    - 192.132.33.255 
	{ 0xc0842200, 0xc08422ff, REGISTRY_RIPENCC    }, // 192.132.34.0    - 192.132.34.255 
	{ 0xc0842300, 0xc08423ff, REGISTRY_LACNIC     }, // 192.132.35.0    - 192.132.35.255 
	{ 0xc0842400, 0xc08428ff, REGISTRY_ARIN       }, // 192.132.36.0    - 192.132.40.255 
	{ 0xc0842900, 0xc08429ff, REGISTRY_APNIC      }, // 192.132.41.0    - 192.132.41.255 
	{ 0xc0842a00, 0xc08434ff, REGISTRY_ARIN       }, // 192.132.42.0    - 192.132.52.255 
	{ 0xc0843500, 0xc08435ff, REGISTRY_RIPENCC    }, // 192.132.53.0    - 192.132.53.255 
	{ 0xc0843600, 0xc08436ff, REGISTRY_ARIN       }, // 192.132.54.0    - 192.132.54.255 
	{ 0xc0843700, 0xc08437ff, REGISTRY_RIPENCC    }, // 192.132.55.0    - 192.132.55.255 
	{ 0xc0843800, 0xc0845cff, REGISTRY_ARIN       }, // 192.132.56.0    - 192.132.92.255 
	{ 0xc0845d00, 0xc0845dff, REGISTRY_APNIC      }, // 192.132.93.0    - 192.132.93.255 
	{ 0xc0845e00, 0xc08462ff, REGISTRY_ARIN       }, // 192.132.94.0    - 192.132.98.255 
	{ 0xc0846300, 0xc08463ff, REGISTRY_RIPENCC    }, // 192.132.99.0    - 192.132.99.255 
	{ 0xc0846400, 0xc08465ff, REGISTRY_ARIN       }, // 192.132.100.0   - 192.132.101.255
	{ 0xc0846700, 0xc084eeff, REGISTRY_ARIN       }, // 192.132.103.0   - 192.132.238.255
	{ 0xc084ef00, 0xc084efff, REGISTRY_RIPENCC    }, // 192.132.239.0   - 192.132.239.255
	{ 0xc084f000, 0xc084f3ff, REGISTRY_ARIN       }, // 192.132.240.0   - 192.132.243.255
	{ 0xc084f400, 0xc084f5ff, REGISTRY_RIPENCC    }, // 192.132.244.0   - 192.132.245.255
	{ 0xc084f600, 0xc084f6ff, REGISTRY_ARIN       }, // 192.132.246.0   - 192.132.246.255
	{ 0xc084f700, 0xc084fbff, REGISTRY_APNIC      }, // 192.132.247.0   - 192.132.251.255
	{ 0xc084fc00, 0xc084fcff, REGISTRY_RIPENCC    }, // 192.132.252.0   - 192.132.252.255
	{ 0xc084fd00, 0xc084fdff, REGISTRY_APNIC      }, // 192.132.253.0   - 192.132.253.255
	{ 0xc084fe00, 0xc08509ff, REGISTRY_ARIN       }, // 192.132.254.0   - 192.133.9.255  
	{ 0xc0850b00, 0xc0850dff, REGISTRY_ARIN       }, // 192.133.11.0    - 192.133.13.255 
	{ 0xc0850f00, 0xc0850fff, REGISTRY_RIPENCC    }, // 192.133.15.0    - 192.133.15.255 
	{ 0xc0851000, 0xc08514ff, REGISTRY_ARIN       }, // 192.133.16.0    - 192.133.20.255 
	{ 0xc0851500, 0xc08515ff, REGISTRY_APNIC      }, // 192.133.21.0    - 192.133.21.255 
	{ 0xc0851600, 0xc0851bff, REGISTRY_ARIN       }, // 192.133.22.0    - 192.133.27.255 
	{ 0xc0851c00, 0xc0851cff, REGISTRY_RIPENCC    }, // 192.133.28.0    - 192.133.28.255 
	{ 0xc0851d00, 0xc0851eff, REGISTRY_ARIN       }, // 192.133.29.0    - 192.133.30.255 
	{ 0xc0851f00, 0xc0851fff, REGISTRY_APNIC      }, // 192.133.31.0    - 192.133.31.255 
	{ 0xc0852000, 0xc08520ff, REGISTRY_RIPENCC    }, // 192.133.32.0    - 192.133.32.255 
	{ 0xc0852100, 0xc08523ff, REGISTRY_ARIN       }, // 192.133.33.0    - 192.133.35.255 
	{ 0xc0852400, 0xc08524ff, REGISTRY_RIPENCC    }, // 192.133.36.0    - 192.133.36.255 
	{ 0xc0852500, 0xc08528ff, REGISTRY_ARIN       }, // 192.133.37.0    - 192.133.40.255 
	{ 0xc0852900, 0xc08529ff, REGISTRY_APNIC      }, // 192.133.41.0    - 192.133.41.255 
	{ 0xc0852a00, 0xc08534ff, REGISTRY_ARIN       }, // 192.133.42.0    - 192.133.52.255 
	{ 0xc0853500, 0xc08537ff, REGISTRY_RIPENCC    }, // 192.133.53.0    - 192.133.55.255 
	{ 0xc0853800, 0xc08539ff, REGISTRY_ARIN       }, // 192.133.56.0    - 192.133.57.255 
	{ 0xc0853a00, 0xc0853aff, REGISTRY_RIPENCC    }, // 192.133.58.0    - 192.133.58.255 
	{ 0xc0853b00, 0xc0853fff, REGISTRY_ARIN       }, // 192.133.59.0    - 192.133.63.255 
	{ 0xc0854000, 0xc08540ff, REGISTRY_RIPENCC    }, // 192.133.64.0    - 192.133.64.255 
	{ 0xc0854100, 0xc08541ff, REGISTRY_ARIN       }, // 192.133.65.0    - 192.133.65.255 
	{ 0xc0854300, 0xc08543ff, REGISTRY_APNIC      }, // 192.133.67.0    - 192.133.67.255 
	{ 0xc0854400, 0xc08566ff, REGISTRY_ARIN       }, // 192.133.68.0    - 192.133.102.255
	{ 0xc0856800, 0xc0856bff, REGISTRY_ARIN       }, // 192.133.104.0   - 192.133.107.255
	{ 0xc0856c00, 0xc0856fff, REGISTRY_RIPENCC    }, // 192.133.108.0   - 192.133.111.255
	{ 0xc0857000, 0xc08578ff, REGISTRY_ARIN       }, // 192.133.112.0   - 192.133.120.255
	{ 0xc0857900, 0xc08579ff, REGISTRY_RIPENCC    }, // 192.133.121.0   - 192.133.121.255
	{ 0xc0857a00, 0xc08582ff, REGISTRY_ARIN       }, // 192.133.122.0   - 192.133.130.255
	{ 0xc0858300, 0xc08583ff, REGISTRY_RIPENCC    }, // 192.133.131.0   - 192.133.131.255
	{ 0xc0858400, 0xc085f3ff, REGISTRY_ARIN       }, // 192.133.132.0   - 192.133.243.255
	{ 0xc085f400, 0xc085f4ff, REGISTRY_RIPENCC    }, // 192.133.244.0   - 192.133.244.255
	{ 0xc085f500, 0xc085f9ff, REGISTRY_ARIN       }, // 192.133.245.0   - 192.133.249.255
	{ 0xc085fa00, 0xc085faff, REGISTRY_AFRINIC    }, // 192.133.250.0   - 192.133.250.255
	{ 0xc085fb00, 0xc085ffff, REGISTRY_ARIN       }, // 192.133.251.0   - 192.133.255.255
	{ 0xc0860000, 0xc086ffff, REGISTRY_RIPENCC    }, // 192.134.0.0     - 192.134.255.255
	{ 0xc0870000, 0xc08706ff, REGISTRY_ARIN       }, // 192.135.0.0     - 192.135.6.255  
	{ 0xc0870700, 0xc08725ff, REGISTRY_RIPENCC    }, // 192.135.7.0     - 192.135.37.255 
	{ 0xc0872600, 0xc0872dff, REGISTRY_ARIN       }, // 192.135.38.0    - 192.135.45.255 
	{ 0xc0872e00, 0xc0872eff, REGISTRY_RIPENCC    }, // 192.135.46.0    - 192.135.46.255 
	{ 0xc0872f00, 0xc08732ff, REGISTRY_ARIN       }, // 192.135.47.0    - 192.135.50.255 
	{ 0xc0873300, 0xc08735ff, REGISTRY_RIPENCC    }, // 192.135.51.0    - 192.135.53.255 
	{ 0xc0873600, 0xc0873eff, REGISTRY_ARIN       }, // 192.135.54.0    - 192.135.62.255 
	{ 0xc0873f00, 0xc0873fff, REGISTRY_RIPENCC    }, // 192.135.63.0    - 192.135.63.255 
	{ 0xc0874000, 0xc08741ff, REGISTRY_ARIN       }, // 192.135.64.0    - 192.135.65.255 
	{ 0xc0874200, 0xc08742ff, REGISTRY_RIPENCC    }, // 192.135.66.0    - 192.135.66.255 
	{ 0xc0874300, 0xc08743ff, REGISTRY_ARIN       }, // 192.135.67.0    - 192.135.67.255 
	{ 0xc0874400, 0xc08744ff, REGISTRY_RIPENCC    }, // 192.135.68.0    - 192.135.68.255 
	{ 0xc0874500, 0xc08751ff, REGISTRY_ARIN       }, // 192.135.69.0    - 192.135.81.255 
	{ 0xc0875200, 0xc08752ff, REGISTRY_RIPENCC    }, // 192.135.82.0    - 192.135.82.255 
	{ 0xc0875300, 0xc08758ff, REGISTRY_ARIN       }, // 192.135.83.0    - 192.135.88.255 
	{ 0xc0875900, 0xc08759ff, REGISTRY_APNIC      }, // 192.135.89.0    - 192.135.89.255 
	{ 0xc0875c00, 0xc0875cff, REGISTRY_APNIC      }, // 192.135.92.0    - 192.135.92.255 
	{ 0xc0875d00, 0xc0875dff, REGISTRY_ARIN       }, // 192.135.93.0    - 192.135.93.255 
	{ 0xc0875e00, 0xc0875eff, REGISTRY_APNIC      }, // 192.135.94.0    - 192.135.94.255 
	{ 0xc0876000, 0xc08760ff, REGISTRY_APNIC      }, // 192.135.96.0    - 192.135.96.255 
	{ 0xc0876500, 0xc08765ff, REGISTRY_APNIC      }, // 192.135.101.0   - 192.135.101.255
	{ 0xc0876700, 0xc0876cff, REGISTRY_APNIC      }, // 192.135.103.0   - 192.135.108.255
	{ 0xc0876d00, 0xc08780ff, REGISTRY_ARIN       }, // 192.135.109.0   - 192.135.128.255
	{ 0xc0878100, 0xc08781ff, REGISTRY_RIPENCC    }, // 192.135.129.0   - 192.135.129.255
	{ 0xc0878200, 0xc08784ff, REGISTRY_ARIN       }, // 192.135.130.0   - 192.135.132.255
	{ 0xc0878500, 0xc08785ff, REGISTRY_RIPENCC    }, // 192.135.133.0   - 192.135.133.255
	{ 0xc0878600, 0xc0878eff, REGISTRY_ARIN       }, // 192.135.134.0   - 192.135.142.255
	{ 0xc0878f00, 0xc0878fff, REGISTRY_RIPENCC    }, // 192.135.143.0   - 192.135.143.255
	{ 0xc0879000, 0xc08790ff, REGISTRY_ARIN       }, // 192.135.144.0   - 192.135.144.255
	{ 0xc0879100, 0xc087a8ff, REGISTRY_RIPENCC    }, // 192.135.145.0   - 192.135.168.255
	{ 0xc087a900, 0xc087aeff, REGISTRY_ARIN       }, // 192.135.169.0   - 192.135.174.255
	{ 0xc087af00, 0xc087afff, REGISTRY_RIPENCC    }, // 192.135.175.0   - 192.135.175.255
	{ 0xc087b000, 0xc087b8ff, REGISTRY_ARIN       }, // 192.135.176.0   - 192.135.184.255
	{ 0xc087ba00, 0xc087baff, REGISTRY_ARIN       }, // 192.135.186.0   - 192.135.186.255
	{ 0xc087bb00, 0xc087bbff, REGISTRY_RIPENCC    }, // 192.135.187.0   - 192.135.187.255
	{ 0xc087bc00, 0xc087ceff, REGISTRY_ARIN       }, // 192.135.188.0   - 192.135.206.255
	{ 0xc087cf00, 0xc087d0ff, REGISTRY_APNIC      }, // 192.135.207.0   - 192.135.208.255
	{ 0xc087d100, 0xc087d1ff, REGISTRY_ARIN       }, // 192.135.209.0   - 192.135.209.255
	{ 0xc087d300, 0xc087daff, REGISTRY_ARIN       }, // 192.135.211.0   - 192.135.218.255
	{ 0xc087db00, 0xc087dbff, REGISTRY_RIPENCC    }, // 192.135.219.0   - 192.135.219.255
	{ 0xc087dc00, 0xc087ddff, REGISTRY_ARIN       }, // 192.135.220.0   - 192.135.221.255
	{ 0xc087de00, 0xc087deff, REGISTRY_APNIC      }, // 192.135.222.0   - 192.135.222.255
	{ 0xc087df00, 0xc087e0ff, REGISTRY_ARIN       }, // 192.135.223.0   - 192.135.224.255
	{ 0xc087e100, 0xc087e1ff, REGISTRY_RIPENCC    }, // 192.135.225.0   - 192.135.225.255
	{ 0xc087e200, 0xc087e6ff, REGISTRY_ARIN       }, // 192.135.226.0   - 192.135.230.255
	{ 0xc087e700, 0xc087eaff, REGISTRY_RIPENCC    }, // 192.135.231.0   - 192.135.234.255
	{ 0xc087eb00, 0xc087fcff, REGISTRY_ARIN       }, // 192.135.235.0   - 192.135.252.255
	{ 0xc087fd00, 0xc087feff, REGISTRY_RIPENCC    }, // 192.135.253.0   - 192.135.254.255
	{ 0xc087ff00, 0xc08806ff, REGISTRY_ARIN       }, // 192.135.255.0   - 192.136.6.255  
	{ 0xc0880700, 0xc08807ff, REGISTRY_RIPENCC    }, // 192.136.7.0     - 192.136.7.255  
	{ 0xc0880800, 0xc08808ff, REGISTRY_ARIN       }, // 192.136.8.0     - 192.136.8.255  
	{ 0xc0880900, 0xc08809ff, REGISTRY_RIPENCC    }, // 192.136.9.0     - 192.136.9.255  
	{ 0xc0880a00, 0xc08811ff, REGISTRY_ARIN       }, // 192.136.10.0    - 192.136.17.255 
	{ 0xc0881200, 0xc08813ff, REGISTRY_RIPENCC    }, // 192.136.18.0    - 192.136.19.255 
	{ 0xc0881400, 0xc08816ff, REGISTRY_ARIN       }, // 192.136.20.0    - 192.136.22.255 
	{ 0xc0881700, 0xc08817ff, REGISTRY_RIPENCC    }, // 192.136.23.0    - 192.136.23.255 
	{ 0xc0881800, 0xc0881cff, REGISTRY_ARIN       }, // 192.136.24.0    - 192.136.28.255 
	{ 0xc0881d00, 0xc0881fff, REGISTRY_RIPENCC    }, // 192.136.29.0    - 192.136.31.255 
	{ 0xc0882000, 0xc08826ff, REGISTRY_ARIN       }, // 192.136.32.0    - 192.136.38.255 
	{ 0xc0882700, 0xc08827ff, REGISTRY_APNIC      }, // 192.136.39.0    - 192.136.39.255 
	{ 0xc0882800, 0xc08829ff, REGISTRY_RIPENCC    }, // 192.136.40.0    - 192.136.41.255 
	{ 0xc0882a00, 0xc0882fff, REGISTRY_LACNIC     }, // 192.136.42.0    - 192.136.47.255 
	{ 0xc0883000, 0xc08830ff, REGISTRY_ARIN       }, // 192.136.48.0    - 192.136.48.255 
	{ 0xc0883100, 0xc08831ff, REGISTRY_RIPENCC    }, // 192.136.49.0    - 192.136.49.255 
	{ 0xc0883200, 0xc08832ff, REGISTRY_ARIN       }, // 192.136.50.0    - 192.136.50.255 
	{ 0xc0883300, 0xc08834ff, REGISTRY_RIPENCC    }, // 192.136.51.0    - 192.136.52.255 
	{ 0xc0883500, 0xc08836ff, REGISTRY_ARIN       }, // 192.136.53.0    - 192.136.54.255 
	{ 0xc0883700, 0xc08839ff, REGISTRY_AFRINIC    }, // 192.136.55.0    - 192.136.57.255 
	{ 0xc0883a00, 0xc0883aff, REGISTRY_ARIN       }, // 192.136.58.0    - 192.136.58.255 
	{ 0xc0883b00, 0xc0883bff, REGISTRY_APNIC      }, // 192.136.59.0    - 192.136.59.255 
	{ 0xc0883c00, 0xc0883cff, REGISTRY_ARIN       }, // 192.136.60.0    - 192.136.60.255 
	{ 0xc0883d00, 0xc0883dff, REGISTRY_RIPENCC    }, // 192.136.61.0    - 192.136.61.255 
	{ 0xc0883e00, 0xc08846ff, REGISTRY_ARIN       }, // 192.136.62.0    - 192.136.70.255 
	{ 0xc0884700, 0xc08866ff, REGISTRY_RIPENCC    }, // 192.136.71.0    - 192.136.102.255
	{ 0xc0886700, 0xc0888cff, REGISTRY_ARIN       }, // 192.136.103.0   - 192.136.140.255
	{ 0xc0889000, 0xc08899ff, REGISTRY_ARIN       }, // 192.136.144.0   - 192.136.153.255
	{ 0xc0889a00, 0xc0889cff, REGISTRY_RIPENCC    }, // 192.136.154.0   - 192.136.156.255
	{ 0xc0889d00, 0xc08a00ff, REGISTRY_ARIN       }, // 192.136.157.0   - 192.138.0.255  
	{ 0xc08a0100, 0xc08a08ff, REGISTRY_RIPENCC    }, // 192.138.1.0     - 192.138.8.255  
	{ 0xc08a0900, 0xc08a55ff, REGISTRY_ARIN       }, // 192.138.9.0     - 192.138.85.255 
	{ 0xc08a5600, 0xc08a56ff, REGISTRY_RIPENCC    }, // 192.138.86.0    - 192.138.86.255 
	{ 0xc08a5700, 0xc08a63ff, REGISTRY_ARIN       }, // 192.138.87.0    - 192.138.99.255 
	{ 0xc08a6400, 0xc08a64ff, REGISTRY_APNIC      }, // 192.138.100.0   - 192.138.100.255
	{ 0xc08a6500, 0xc08a68ff, REGISTRY_ARIN       }, // 192.138.101.0   - 192.138.104.255
	{ 0xc08a6900, 0xc08a75ff, REGISTRY_RIPENCC    }, // 192.138.105.0   - 192.138.117.255
	{ 0xc08a7e00, 0xc08a9aff, REGISTRY_ARIN       }, // 192.138.126.0   - 192.138.154.255
	{ 0xc08a9b00, 0xc08a9eff, REGISTRY_RIPENCC    }, // 192.138.155.0   - 192.138.158.255
	{ 0xc08a9f00, 0xc08ab6ff, REGISTRY_ARIN       }, // 192.138.159.0   - 192.138.182.255
	{ 0xc08ab700, 0xc08ab7ff, REGISTRY_RIPENCC    }, // 192.138.183.0   - 192.138.183.255
	{ 0xc08ab800, 0xc08abbff, REGISTRY_ARIN       }, // 192.138.184.0   - 192.138.187.255
	{ 0xc08abd00, 0xc08abfff, REGISTRY_ARIN       }, // 192.138.189.0   - 192.138.191.255
	{ 0xc08ac000, 0xc08ac0ff, REGISTRY_RIPENCC    }, // 192.138.192.0   - 192.138.192.255
	{ 0xc08ac100, 0xc08acbff, REGISTRY_ARIN       }, // 192.138.193.0   - 192.138.203.255
	{ 0xc08acc00, 0xc08accff, REGISTRY_RIPENCC    }, // 192.138.204.0   - 192.138.204.255
	{ 0xc08acd00, 0xc08ae3ff, REGISTRY_ARIN       }, // 192.138.205.0   - 192.138.227.255
	{ 0xc08ae400, 0xc08ae8ff, REGISTRY_RIPENCC    }, // 192.138.228.0   - 192.138.232.255
	{ 0xc08ae900, 0xc08af7ff, REGISTRY_ARIN       }, // 192.138.233.0   - 192.138.247.255
	{ 0xc08af800, 0xc08af8ff, REGISTRY_RIPENCC    }, // 192.138.248.0   - 192.138.248.255
	{ 0xc08af900, 0xc08afaff, REGISTRY_ARIN       }, // 192.138.249.0   - 192.138.250.255
	{ 0xc08afb00, 0xc08afbff, REGISTRY_APNIC      }, // 192.138.251.0   - 192.138.251.255
	{ 0xc08afc00, 0xc08b4dff, REGISTRY_ARIN       }, // 192.138.252.0   - 192.139.77.255 
	{ 0xc08b4e00, 0xc08b4eff, REGISTRY_RIPENCC    }, // 192.139.78.0    - 192.139.78.255 
	{ 0xc08b4f00, 0xc08c00ff, REGISTRY_ARIN       }, // 192.139.79.0    - 192.140.0.255  
	{ 0xc0904a00, 0xc0904aff, REGISTRY_RIPENCC    }, // 192.144.74.0    - 192.144.74.255 
	{ 0xc0904c00, 0xc0904dff, REGISTRY_RIPENCC    }, // 192.144.76.0    - 192.144.77.255 
	{ 0xc091e700, 0xc09274ff, REGISTRY_ARIN       }, // 192.145.231.0   - 192.146.116.255
	{ 0xc0927500, 0xc09275ff, REGISTRY_RIPENCC    }, // 192.146.117.0   - 192.146.117.255
	{ 0xc0927600, 0xc09276ff, REGISTRY_ARIN       }, // 192.146.118.0   - 192.146.118.255
	{ 0xc0927700, 0xc09277ff, REGISTRY_RIPENCC    }, // 192.146.119.0   - 192.146.119.255
	{ 0xc0927800, 0xc0927aff, REGISTRY_ARIN       }, // 192.146.120.0   - 192.146.122.255
	{ 0xc0927b00, 0xc0927eff, REGISTRY_RIPENCC    }, // 192.146.123.0   - 192.146.126.255
	{ 0xc0927f00, 0xc09283ff, REGISTRY_ARIN       }, // 192.146.127.0   - 192.146.131.255
	{ 0xc0928400, 0xc09284ff, REGISTRY_RIPENCC    }, // 192.146.132.0   - 192.146.132.255
	{ 0xc0928500, 0xc09285ff, REGISTRY_APNIC      }, // 192.146.133.0   - 192.146.133.255
	{ 0xc0928600, 0xc09289ff, REGISTRY_RIPENCC    }, // 192.146.134.0   - 192.146.137.255
	{ 0xc0928c00, 0xc0928dff, REGISTRY_RIPENCC    }, // 192.146.140.0   - 192.146.141.255
	{ 0xc0928e00, 0xc09295ff, REGISTRY_ARIN       }, // 192.146.142.0   - 192.146.149.255
	{ 0xc0929600, 0xc09296ff, REGISTRY_APNIC      }, // 192.146.150.0   - 192.146.150.255
	{ 0xc0929700, 0xc09297ff, REGISTRY_ARIN       }, // 192.146.151.0   - 192.146.151.255
	{ 0xc0929800, 0xc09298ff, REGISTRY_RIPENCC    }, // 192.146.152.0   - 192.146.152.255
	{ 0xc0929900, 0xc0929cff, REGISTRY_ARIN       }, // 192.146.153.0   - 192.146.156.255
	{ 0xc0929d00, 0xc0929dff, REGISTRY_LACNIC     }, // 192.146.157.0   - 192.146.157.255
	{ 0xc0929e00, 0xc092a2ff, REGISTRY_ARIN       }, // 192.146.158.0   - 192.146.162.255
	{ 0xc092a300, 0xc092aaff, REGISTRY_RIPENCC    }, // 192.146.163.0   - 192.146.170.255
	{ 0xc092ab00, 0xc092abff, REGISTRY_ARIN       }, // 192.146.171.0   - 192.146.171.255
	{ 0xc092ac00, 0xc092b6ff, REGISTRY_RIPENCC    }, // 192.146.172.0   - 192.146.182.255
	{ 0xc092b700, 0xc092b7ff, REGISTRY_ARIN       }, // 192.146.183.0   - 192.146.183.255
	{ 0xc092b800, 0xc092b8ff, REGISTRY_APNIC      }, // 192.146.184.0   - 192.146.184.255
	{ 0xc092b900, 0xc092b9ff, REGISTRY_RIPENCC    }, // 192.146.185.0   - 192.146.185.255
	{ 0xc092ba00, 0xc092baff, REGISTRY_ARIN       }, // 192.146.186.0   - 192.146.186.255
	{ 0xc092bb00, 0xc092bbff, REGISTRY_RIPENCC    }, // 192.146.187.0   - 192.146.187.255
	{ 0xc092bc00, 0xc092bcff, REGISTRY_ARIN       }, // 192.146.188.0   - 192.146.188.255
	{ 0xc092be00, 0xc092c0ff, REGISTRY_ARIN       }, // 192.146.190.0   - 192.146.192.255
	{ 0xc092c100, 0xc092c1ff, REGISTRY_RIPENCC    }, // 192.146.193.0   - 192.146.193.255
	{ 0xc092c200, 0xc092c7ff, REGISTRY_ARIN       }, // 192.146.194.0   - 192.146.199.255
	{ 0xc092c800, 0xc092c8ff, REGISTRY_APNIC      }, // 192.146.200.0   - 192.146.200.255
	{ 0xc092c900, 0xc092cbff, REGISTRY_ARIN       }, // 192.146.201.0   - 192.146.203.255
	{ 0xc092cc00, 0xc092ccff, REGISTRY_RIPENCC    }, // 192.146.204.0   - 192.146.204.255
	{ 0xc092cd00, 0xc092d9ff, REGISTRY_ARIN       }, // 192.146.205.0   - 192.146.217.255
	{ 0xc092da00, 0xc092dbff, REGISTRY_APNIC      }, // 192.146.218.0   - 192.146.219.255
	{ 0xc092dc00, 0xc092e2ff, REGISTRY_ARIN       }, // 192.146.220.0   - 192.146.226.255
	{ 0xc092e300, 0xc092e4ff, REGISTRY_RIPENCC    }, // 192.146.227.0   - 192.146.228.255
	{ 0xc092e500, 0xc092e5ff, REGISTRY_LACNIC     }, // 192.146.229.0   - 192.146.229.255
	{ 0xc092e600, 0xc092e7ff, REGISTRY_ARIN       }, // 192.146.230.0   - 192.146.231.255
	{ 0xc092e900, 0xc092eaff, REGISTRY_RIPENCC    }, // 192.146.233.0   - 192.146.234.255
	{ 0xc092eb00, 0xc092ecff, REGISTRY_ARIN       }, // 192.146.235.0   - 192.146.236.255
	{ 0xc092ed00, 0xc092edff, REGISTRY_LACNIC     }, // 192.146.237.0   - 192.146.237.255
	{ 0xc092ee00, 0xc092efff, REGISTRY_RIPENCC    }, // 192.146.238.0   - 192.146.239.255
	{ 0xc092f000, 0xc092f1ff, REGISTRY_ARIN       }, // 192.146.240.0   - 192.146.241.255
	{ 0xc092f200, 0xc092f2ff, REGISTRY_RIPENCC    }, // 192.146.242.0   - 192.146.242.255
	{ 0xc092f300, 0xc092faff, REGISTRY_ARIN       }, // 192.146.243.0   - 192.146.250.255
	{ 0xc092fb00, 0xc092fdff, REGISTRY_APNIC      }, // 192.146.251.0   - 192.146.253.255
	{ 0xc092fe00, 0xc0930aff, REGISTRY_ARIN       }, // 192.146.254.0   - 192.147.10.255 
	{ 0xc0930c00, 0xc09316ff, REGISTRY_ARIN       }, // 192.147.12.0    - 192.147.22.255 
	{ 0xc0931700, 0xc09317ff, REGISTRY_RIPENCC    }, // 192.147.23.0    - 192.147.23.255 
	{ 0xc0931800, 0xc09321ff, REGISTRY_ARIN       }, // 192.147.24.0    - 192.147.33.255 
	{ 0xc0932200, 0xc09322ff, REGISTRY_RIPENCC    }, // 192.147.34.0    - 192.147.34.255 
	{ 0xc0932300, 0xc09323ff, REGISTRY_ARIN       }, // 192.147.35.0    - 192.147.35.255 
	{ 0xc0932400, 0xc09324ff, REGISTRY_RIPENCC    }, // 192.147.36.0    - 192.147.36.255 
	{ 0xc0932500, 0xc09329ff, REGISTRY_ARIN       }, // 192.147.37.0    - 192.147.41.255 
	{ 0xc0932a00, 0xc0932aff, REGISTRY_RIPENCC    }, // 192.147.42.0    - 192.147.42.255 
	{ 0xc0932b00, 0xc0934bff, REGISTRY_ARIN       }, // 192.147.43.0    - 192.147.75.255 
	{ 0xc0934c00, 0xc0934fff, REGISTRY_RIPENCC    }, // 192.147.76.0    - 192.147.79.255 
	{ 0xc0935000, 0xc09371ff, REGISTRY_ARIN       }, // 192.147.80.0    - 192.147.113.255
	{ 0xc0937200, 0xc09372ff, REGISTRY_APNIC      }, // 192.147.114.0   - 192.147.114.255
	{ 0xc0937300, 0xc0938cff, REGISTRY_ARIN       }, // 192.147.115.0   - 192.147.140.255
	{ 0xc0938d00, 0xc0938dff, REGISTRY_RIPENCC    }, // 192.147.141.0   - 192.147.141.255
	{ 0xc0938e00, 0xc09395ff, REGISTRY_ARIN       }, // 192.147.142.0   - 192.147.149.255
	{ 0xc0939600, 0xc09396ff, REGISTRY_RIPENCC    }, // 192.147.150.0   - 192.147.150.255
	{ 0xc0939a00, 0xc0939aff, REGISTRY_ARIN       }, // 192.147.154.0   - 192.147.154.255
	{ 0xc0939b00, 0xc0939bff, REGISTRY_RIPENCC    }, // 192.147.155.0   - 192.147.155.255
	{ 0xc0939c00, 0xc093d1ff, REGISTRY_ARIN       }, // 192.147.156.0   - 192.147.209.255
	{ 0xc093d200, 0xc093d2ff, REGISTRY_LACNIC     }, // 192.147.210.0   - 192.147.210.255
	{ 0xc093d300, 0xc093d3ff, REGISTRY_ARIN       }, // 192.147.211.0   - 192.147.211.255
	{ 0xc093d400, 0xc093d4ff, REGISTRY_RIPENCC    }, // 192.147.212.0   - 192.147.212.255
	{ 0xc093d500, 0xc093d6ff, REGISTRY_ARIN       }, // 192.147.213.0   - 192.147.214.255
	{ 0xc093d700, 0xc093d9ff, REGISTRY_RIPENCC    }, // 192.147.215.0   - 192.147.217.255
	{ 0xc093db00, 0xc093dbff, REGISTRY_RIPENCC    }, // 192.147.219.0   - 192.147.219.255
	{ 0xc093dc00, 0xc093e3ff, REGISTRY_ARIN       }, // 192.147.220.0   - 192.147.227.255
	{ 0xc093e400, 0xc093e4ff, REGISTRY_RIPENCC    }, // 192.147.228.0   - 192.147.228.255
	{ 0xc093e500, 0xc093eaff, REGISTRY_ARIN       }, // 192.147.229.0   - 192.147.234.255
	{ 0xc093eb00, 0xc093ebff, REGISTRY_APNIC      }, // 192.147.235.0   - 192.147.235.255
	{ 0xc093ec00, 0xc093f5ff, REGISTRY_ARIN       }, // 192.147.236.0   - 192.147.245.255
	{ 0xc093f600, 0xc093f6ff, REGISTRY_APNIC      }, // 192.147.246.0   - 192.147.246.255
	{ 0xc093f700, 0xc093f7ff, REGISTRY_RIPENCC    }, // 192.147.247.0   - 192.147.247.255
	{ 0xc093f800, 0xc093faff, REGISTRY_ARIN       }, // 192.147.248.0   - 192.147.250.255
	{ 0xc093fb00, 0xc093fbff, REGISTRY_RIPENCC    }, // 192.147.251.0   - 192.147.251.255
	{ 0xc093fc00, 0xc093fcff, REGISTRY_ARIN       }, // 192.147.252.0   - 192.147.252.255
	{ 0xc093fe00, 0xc09420ff, REGISTRY_ARIN       }, // 192.147.254.0   - 192.148.32.255 
	{ 0xc0942100, 0xc0945cff, REGISTRY_RIPENCC    }, // 192.148.33.0    - 192.148.92.255 
	{ 0xc0945d00, 0xc09466ff, REGISTRY_ARIN       }, // 192.148.93.0    - 192.148.102.255
	{ 0xc0946700, 0xc09467ff, REGISTRY_RIPENCC    }, // 192.148.103.0   - 192.148.103.255
	{ 0xc0946800, 0xc09473ff, REGISTRY_ARIN       }, // 192.148.104.0   - 192.148.115.255
	{ 0xc0947400, 0xc094a5ff, REGISTRY_APNIC      }, // 192.148.116.0   - 192.148.165.255
	{ 0xc094a600, 0xc094a7ff, REGISTRY_RIPENCC    }, // 192.148.166.0   - 192.148.167.255
	{ 0xc094a800, 0xc094aeff, REGISTRY_ARIN       }, // 192.148.168.0   - 192.148.174.255
	{ 0xc094af00, 0xc094afff, REGISTRY_LACNIC     }, // 192.148.175.0   - 192.148.175.255
	{ 0xc094b000, 0xc094b0ff, REGISTRY_ARIN       }, // 192.148.176.0   - 192.148.176.255
	{ 0xc094b100, 0xc094baff, REGISTRY_RIPENCC    }, // 192.148.177.0   - 192.148.186.255
	{ 0xc094bb00, 0xc094bfff, REGISTRY_ARIN       }, // 192.148.187.0   - 192.148.191.255
	{ 0xc094c000, 0xc094c2ff, REGISTRY_RIPENCC    }, // 192.148.192.0   - 192.148.194.255
	{ 0xc094c300, 0xc094c5ff, REGISTRY_ARIN       }, // 192.148.195.0   - 192.148.197.255
	{ 0xc094c600, 0xc094d8ff, REGISTRY_RIPENCC    }, // 192.148.198.0   - 192.148.216.255
	{ 0xc094d900, 0xc094dbff, REGISTRY_ARIN       }, // 192.148.217.0   - 192.148.219.255
	{ 0xc094dc00, 0xc094dcff, REGISTRY_RIPENCC    }, // 192.148.220.0   - 192.148.220.255
	{ 0xc094dd00, 0xc094ddff, REGISTRY_APNIC      }, // 192.148.221.0   - 192.148.221.255
	{ 0xc094de00, 0xc094deff, REGISTRY_ARIN       }, // 192.148.222.0   - 192.148.222.255
	{ 0xc094df00, 0xc094e6ff, REGISTRY_APNIC      }, // 192.148.223.0   - 192.148.230.255
	{ 0xc094e700, 0xc09502ff, REGISTRY_ARIN       }, // 192.148.231.0   - 192.149.2.255  
	{ 0xc0950300, 0xc09503ff, REGISTRY_RIPENCC    }, // 192.149.3.0     - 192.149.3.255  
	{ 0xc0950400, 0xc09504ff, REGISTRY_ARIN       }, // 192.149.4.0     - 192.149.4.255  
	{ 0xc0950500, 0xc09505ff, REGISTRY_RIPENCC    }, // 192.149.5.0     - 192.149.5.255  
	{ 0xc0950600, 0xc0950eff, REGISTRY_ARIN       }, // 192.149.6.0     - 192.149.14.255 
	{ 0xc0950f00, 0xc0950fff, REGISTRY_RIPENCC    }, // 192.149.15.0    - 192.149.15.255 
	{ 0xc0951000, 0xc09512ff, REGISTRY_ARIN       }, // 192.149.16.0    - 192.149.18.255 
	{ 0xc0951300, 0xc09513ff, REGISTRY_RIPENCC    }, // 192.149.19.0    - 192.149.19.255 
	{ 0xc0951400, 0xc09514ff, REGISTRY_APNIC      }, // 192.149.20.0    - 192.149.20.255 
	{ 0xc0951500, 0xc0951aff, REGISTRY_ARIN       }, // 192.149.21.0    - 192.149.26.255 
	{ 0xc0951b00, 0xc0951bff, REGISTRY_RIPENCC    }, // 192.149.27.0    - 192.149.27.255 
	{ 0xc0951c00, 0xc0951cff, REGISTRY_ARIN       }, // 192.149.28.0    - 192.149.28.255 
	{ 0xc0951d00, 0xc09521ff, REGISTRY_RIPENCC    }, // 192.149.29.0    - 192.149.33.255 
	{ 0xc0952200, 0xc09522ff, REGISTRY_ARIN       }, // 192.149.34.0    - 192.149.34.255 
	{ 0xc0952300, 0xc09523ff, REGISTRY_RIPENCC    }, // 192.149.35.0    - 192.149.35.255 
	{ 0xc0952400, 0xc09524ff, REGISTRY_APNIC      }, // 192.149.36.0    - 192.149.36.255 
	{ 0xc0952500, 0xc09528ff, REGISTRY_ARIN       }, // 192.149.37.0    - 192.149.40.255 
	{ 0xc0952900, 0xc09529ff, REGISTRY_RIPENCC    }, // 192.149.41.0    - 192.149.41.255 
	{ 0xc0952a00, 0xc09535ff, REGISTRY_ARIN       }, // 192.149.42.0    - 192.149.53.255 
	{ 0xc0953600, 0xc09536ff, REGISTRY_APNIC      }, // 192.149.54.0    - 192.149.54.255 
	{ 0xc0953700, 0xc09538ff, REGISTRY_ARIN       }, // 192.149.55.0    - 192.149.56.255 
	{ 0xc0953900, 0xc09539ff, REGISTRY_RIPENCC    }, // 192.149.57.0    - 192.149.57.255 
	{ 0xc0953a00, 0xc0953aff, REGISTRY_ARIN       }, // 192.149.58.0    - 192.149.58.255 
	{ 0xc0953b00, 0xc0953cff, REGISTRY_RIPENCC    }, // 192.149.59.0    - 192.149.60.255 
	{ 0xc0953d00, 0xc0954cff, REGISTRY_ARIN       }, // 192.149.61.0    - 192.149.76.255 
	{ 0xc0954d00, 0xc0954fff, REGISTRY_RIPENCC    }, // 192.149.77.0    - 192.149.79.255 
	{ 0xc0955000, 0xc09563ff, REGISTRY_ARIN       }, // 192.149.80.0    - 192.149.99.255 
	{ 0xc0956400, 0xc09564ff, REGISTRY_RIPENCC    }, // 192.149.100.0   - 192.149.100.255
	{ 0xc0956500, 0xc09565ff, REGISTRY_ARIN       }, // 192.149.101.0   - 192.149.101.255
	{ 0xc0956600, 0xc09566ff, REGISTRY_RIPENCC    }, // 192.149.102.0   - 192.149.102.255
	{ 0xc0956700, 0xc0956dff, REGISTRY_ARIN       }, // 192.149.103.0   - 192.149.109.255
	{ 0xc0956e00, 0xc0956fff, REGISTRY_RIPENCC    }, // 192.149.110.0   - 192.149.111.255
	{ 0xc0957000, 0xc09574ff, REGISTRY_ARIN       }, // 192.149.112.0   - 192.149.116.255
	{ 0xc0957500, 0xc09579ff, REGISTRY_RIPENCC    }, // 192.149.117.0   - 192.149.121.255
	{ 0xc0957a00, 0xc0957dff, REGISTRY_ARIN       }, // 192.149.122.0   - 192.149.125.255
	{ 0xc0957e00, 0xc0957eff, REGISTRY_RIPENCC    }, // 192.149.126.0   - 192.149.126.255
	{ 0xc0957f00, 0xc09594ff, REGISTRY_ARIN       }, // 192.149.127.0   - 192.149.148.255
	{ 0xc0959600, 0xc095d0ff, REGISTRY_ARIN       }, // 192.149.150.0   - 192.149.208.255
	{ 0xc095d100, 0xc095d1ff, REGISTRY_APNIC      }, // 192.149.209.0   - 192.149.209.255
	{ 0xc095d200, 0xc095e2ff, REGISTRY_ARIN       }, // 192.149.210.0   - 192.149.226.255
	{ 0xc095e300, 0xc095e3ff, REGISTRY_RIPENCC    }, // 192.149.227.0   - 192.149.227.255
	{ 0xc095e400, 0xc095e7ff, REGISTRY_ARIN       }, // 192.149.228.0   - 192.149.231.255
	{ 0xc095e800, 0xc095e8ff, REGISTRY_RIPENCC    }, // 192.149.232.0   - 192.149.232.255
	{ 0xc095e900, 0xc095edff, REGISTRY_ARIN       }, // 192.149.233.0   - 192.149.237.255
	{ 0xc095ee00, 0xc095eeff, REGISTRY_RIPENCC    }, // 192.149.238.0   - 192.149.238.255
	{ 0xc095f000, 0xc09639ff, REGISTRY_ARIN       }, // 192.149.240.0   - 192.150.57.255 
	{ 0xc0963a00, 0xc09648ff, REGISTRY_RIPENCC    }, // 192.150.58.0    - 192.150.72.255 
	{ 0xc0964900, 0xc0964aff, REGISTRY_ARIN       }, // 192.150.73.0    - 192.150.74.255 
	{ 0xc0964b00, 0xc0964cff, REGISTRY_RIPENCC    }, // 192.150.75.0    - 192.150.76.255 
	{ 0xc0964d00, 0xc0964dff, REGISTRY_ARIN       }, // 192.150.77.0    - 192.150.77.255 
	{ 0xc0964e00, 0xc09654ff, REGISTRY_RIPENCC    }, // 192.150.78.0    - 192.150.84.255 
	{ 0xc0965500, 0xc09658ff, REGISTRY_ARIN       }, // 192.150.85.0    - 192.150.88.255 
	{ 0xc0965900, 0xc09659ff, REGISTRY_RIPENCC    }, // 192.150.89.0    - 192.150.89.255 
	{ 0xc0965a00, 0xc0965bff, REGISTRY_ARIN       }, // 192.150.90.0    - 192.150.91.255 
	{ 0xc0965c00, 0xc0965cff, REGISTRY_RIPENCC    }, // 192.150.92.0    - 192.150.92.255 
	{ 0xc0965d00, 0xc0965dff, REGISTRY_ARIN       }, // 192.150.93.0    - 192.150.93.255 
	{ 0xc0965e00, 0xc0965eff, REGISTRY_RIPENCC    }, // 192.150.94.0    - 192.150.94.255 
	{ 0xc0965f00, 0xc0965fff, REGISTRY_ARIN       }, // 192.150.95.0    - 192.150.95.255 
	{ 0xc0966100, 0xc09667ff, REGISTRY_ARIN       }, // 192.150.97.0    - 192.150.103.255
	{ 0xc0966800, 0xc09668ff, REGISTRY_RIPENCC    }, // 192.150.104.0   - 192.150.104.255
	{ 0xc0966900, 0xc09669ff, REGISTRY_ARIN       }, // 192.150.105.0   - 192.150.105.255
	{ 0xc0966a00, 0xc0966aff, REGISTRY_RIPENCC    }, // 192.150.106.0   - 192.150.106.255
	{ 0xc0966c00, 0xc0967bff, REGISTRY_ARIN       }, // 192.150.108.0   - 192.150.123.255
	{ 0xc0967c00, 0xc0967cff, REGISTRY_RIPENCC    }, // 192.150.124.0   - 192.150.124.255
	{ 0xc0967d00, 0xc0967dff, REGISTRY_ARIN       }, // 192.150.125.0   - 192.150.125.255
	{ 0xc0967e00, 0xc0967eff, REGISTRY_LACNIC     }, // 192.150.126.0   - 192.150.126.255
	{ 0xc0967f00, 0xc09680ff, REGISTRY_ARIN       }, // 192.150.127.0   - 192.150.128.255
	{ 0xc0968100, 0xc09687ff, REGISTRY_APNIC      }, // 192.150.129.0   - 192.150.135.255
	{ 0xc0968900, 0xc0968bff, REGISTRY_APNIC      }, // 192.150.137.0   - 192.150.139.255
	{ 0xc0968c00, 0xc0968cff, REGISTRY_RIPENCC    }, // 192.150.140.0   - 192.150.140.255
	{ 0xc0968d00, 0xc0968fff, REGISTRY_ARIN       }, // 192.150.141.0   - 192.150.143.255
	{ 0xc0969100, 0xc09691ff, REGISTRY_ARIN       }, // 192.150.145.0   - 192.150.145.255
	{ 0xc0969200, 0xc09692ff, REGISTRY_RIPENCC    }, // 192.150.146.0   - 192.150.146.255
	{ 0xc0969300, 0xc096b0ff, REGISTRY_ARIN       }, // 192.150.147.0   - 192.150.176.255
	{ 0xc096b100, 0xc096b8ff, REGISTRY_RIPENCC    }, // 192.150.177.0   - 192.150.184.255
	{ 0xc096b900, 0xc096bbff, REGISTRY_ARIN       }, // 192.150.185.0   - 192.150.187.255
	{ 0xc096bc00, 0xc096beff, REGISTRY_RIPENCC    }, // 192.150.188.0   - 192.150.190.255
	{ 0xc096bf00, 0xc096bfff, REGISTRY_ARIN       }, // 192.150.191.0   - 192.150.191.255
	{ 0xc096c000, 0xc096c6ff, REGISTRY_RIPENCC    }, // 192.150.192.0   - 192.150.198.255
	{ 0xc096c700, 0xc096c7ff, REGISTRY_ARIN       }, // 192.150.199.0   - 192.150.199.255
	{ 0xc096c900, 0xc096c9ff, REGISTRY_ARIN       }, // 192.150.201.0   - 192.150.201.255
	{ 0xc096ca00, 0xc096caff, REGISTRY_APNIC      }, // 192.150.202.0   - 192.150.202.255
	{ 0xc096cb00, 0xc096cdff, REGISTRY_RIPENCC    }, // 192.150.203.0   - 192.150.205.255
	{ 0xc096ce00, 0xc096cfff, REGISTRY_ARIN       }, // 192.150.206.0   - 192.150.207.255
	{ 0xc096d000, 0xc096d1ff, REGISTRY_RIPENCC    }, // 192.150.208.0   - 192.150.209.255
	{ 0xc096d200, 0xc096d9ff, REGISTRY_ARIN       }, // 192.150.210.0   - 192.150.217.255
	{ 0xc096da00, 0xc096dbff, REGISTRY_APNIC      }, // 192.150.218.0   - 192.150.219.255
	{ 0xc096dd00, 0xc096deff, REGISTRY_ARIN       }, // 192.150.221.0   - 192.150.222.255
	{ 0xc096df00, 0xc096dfff, REGISTRY_RIPENCC    }, // 192.150.223.0   - 192.150.223.255
	{ 0xc096e000, 0xc096e2ff, REGISTRY_ARIN       }, // 192.150.224.0   - 192.150.226.255
	{ 0xc096e300, 0xc096e9ff, REGISTRY_RIPENCC    }, // 192.150.227.0   - 192.150.233.255
	{ 0xc096ea00, 0xc096edff, REGISTRY_APNIC      }, // 192.150.234.0   - 192.150.237.255
	{ 0xc096ee00, 0xc096eeff, REGISTRY_RIPENCC    }, // 192.150.238.0   - 192.150.238.255
	{ 0xc096ef00, 0xc096f5ff, REGISTRY_ARIN       }, // 192.150.239.0   - 192.150.245.255
	{ 0xc096f600, 0xc096f6ff, REGISTRY_APNIC      }, // 192.150.246.0   - 192.150.246.255
	{ 0xc096f700, 0xc096f7ff, REGISTRY_ARIN       }, // 192.150.247.0   - 192.150.247.255
	{ 0xc096f800, 0xc096f8ff, REGISTRY_RIPENCC    }, // 192.150.248.0   - 192.150.248.255
	{ 0xc096f900, 0xc096fbff, REGISTRY_APNIC      }, // 192.150.249.0   - 192.150.251.255
	{ 0xc096fc00, 0xc096fcff, REGISTRY_RIPENCC    }, // 192.150.252.0   - 192.150.252.255
	{ 0xc096fd00, 0xc096fdff, REGISTRY_ARIN       }, // 192.150.253.0   - 192.150.253.255
	{ 0xc096fe00, 0xc096feff, REGISTRY_RIPENCC    }, // 192.150.254.0   - 192.150.254.255
	{ 0xc096ff00, 0xc09780ff, REGISTRY_ARIN       }, // 192.150.255.0   - 192.151.128.255
	{ 0xc0978200, 0xc09805ff, REGISTRY_ARIN       }, // 192.151.130.0   - 192.152.5.255  
	{ 0xc0980600, 0xc09806ff, REGISTRY_RIPENCC    }, // 192.152.6.0     - 192.152.6.255  
	{ 0xc0980700, 0xc0980dff, REGISTRY_ARIN       }, // 192.152.7.0     - 192.152.13.255 
	{ 0xc0980e00, 0xc0980eff, REGISTRY_RIPENCC    }, // 192.152.14.0    - 192.152.14.255 
	{ 0xc0980f00, 0xc09810ff, REGISTRY_ARIN       }, // 192.152.15.0    - 192.152.16.255 
	{ 0xc0981100, 0xc09811ff, REGISTRY_RIPENCC    }, // 192.152.17.0    - 192.152.17.255 
	{ 0xc0981200, 0xc09819ff, REGISTRY_ARIN       }, // 192.152.18.0    - 192.152.25.255 
	{ 0xc0981a00, 0xc0981bff, REGISTRY_RIPENCC    }, // 192.152.26.0    - 192.152.27.255 
	{ 0xc0981c00, 0xc09829ff, REGISTRY_ARIN       }, // 192.152.28.0    - 192.152.41.255 
	{ 0xc0982a00, 0xc0982aff, REGISTRY_RIPENCC    }, // 192.152.42.0    - 192.152.42.255 
	{ 0xc0982b00, 0xc0982bff, REGISTRY_ARIN       }, // 192.152.43.0    - 192.152.43.255 
	{ 0xc0982c00, 0xc0982cff, REGISTRY_RIPENCC    }, // 192.152.44.0    - 192.152.44.255 
	{ 0xc0982d00, 0xc0982eff, REGISTRY_ARIN       }, // 192.152.45.0    - 192.152.46.255 
	{ 0xc0982f00, 0xc09833ff, REGISTRY_RIPENCC    }, // 192.152.47.0    - 192.152.51.255 
	{ 0xc0983400, 0xc09835ff, REGISTRY_ARIN       }, // 192.152.52.0    - 192.152.53.255 
	{ 0xc0983600, 0xc09836ff, REGISTRY_RIPENCC    }, // 192.152.54.0    - 192.152.54.255 
	{ 0xc0983700, 0xc0983cff, REGISTRY_ARIN       }, // 192.152.55.0    - 192.152.60.255 
	{ 0xc0983d00, 0xc0983fff, REGISTRY_RIPENCC    }, // 192.152.61.0    - 192.152.63.255 
	{ 0xc0984000, 0xc09843ff, REGISTRY_ARIN       }, // 192.152.64.0    - 192.152.67.255 
	{ 0xc0984400, 0xc09844ff, REGISTRY_RIPENCC    }, // 192.152.68.0    - 192.152.68.255 
	{ 0xc0984500, 0xc09845ff, REGISTRY_APNIC      }, // 192.152.69.0    - 192.152.69.255 
	{ 0xc0984600, 0xc09851ff, REGISTRY_ARIN       }, // 192.152.70.0    - 192.152.81.255 
	{ 0xc0985200, 0xc09852ff, REGISTRY_RIPENCC    }, // 192.152.82.0    - 192.152.82.255 
	{ 0xc0985300, 0xc09855ff, REGISTRY_ARIN       }, // 192.152.83.0    - 192.152.85.255 
	{ 0xc0985800, 0xc09861ff, REGISTRY_ARIN       }, // 192.152.88.0    - 192.152.97.255 
	{ 0xc0986200, 0xc09862ff, REGISTRY_RIPENCC    }, // 192.152.98.0    - 192.152.98.255 
	{ 0xc0986300, 0xc0986eff, REGISTRY_ARIN       }, // 192.152.99.0    - 192.152.110.255
	{ 0xc0986f00, 0xc09870ff, REGISTRY_RIPENCC    }, // 192.152.111.0   - 192.152.112.255
	{ 0xc0987100, 0xc09876ff, REGISTRY_ARIN       }, // 192.152.113.0   - 192.152.118.255
	{ 0xc0987700, 0xc09877ff, REGISTRY_APNIC      }, // 192.152.119.0   - 192.152.119.255
	{ 0xc0987800, 0xc09879ff, REGISTRY_ARIN       }, // 192.152.120.0   - 192.152.121.255
	{ 0xc0987a00, 0xc0987aff, REGISTRY_RIPENCC    }, // 192.152.122.0   - 192.152.122.255
	{ 0xc0987b00, 0xc0987bff, REGISTRY_ARIN       }, // 192.152.123.0   - 192.152.123.255
	{ 0xc0987c00, 0xc0987cff, REGISTRY_RIPENCC    }, // 192.152.124.0   - 192.152.124.255
	{ 0xc0987d00, 0xc0988cff, REGISTRY_ARIN       }, // 192.152.125.0   - 192.152.140.255
	{ 0xc0988d00, 0xc0988dff, REGISTRY_RIPENCC    }, // 192.152.141.0   - 192.152.141.255
	{ 0xc0988e00, 0xc0988fff, REGISTRY_ARIN       }, // 192.152.142.0   - 192.152.143.255
	{ 0xc0989100, 0xc09891ff, REGISTRY_ARIN       }, // 192.152.145.0   - 192.152.145.255
	{ 0xc0989300, 0xc09896ff, REGISTRY_ARIN       }, // 192.152.147.0   - 192.152.150.255
	{ 0xc0989700, 0xc09897ff, REGISTRY_RIPENCC    }, // 192.152.151.0   - 192.152.151.255
	{ 0xc0989800, 0xc0989bff, REGISTRY_ARIN       }, // 192.152.152.0   - 192.152.155.255
	{ 0xc0989c00, 0xc0989cff, REGISTRY_RIPENCC    }, // 192.152.156.0   - 192.152.156.255
	{ 0xc0989d00, 0xc098a5ff, REGISTRY_ARIN       }, // 192.152.157.0   - 192.152.165.255
	{ 0xc098a600, 0xc098a7ff, REGISTRY_RIPENCC    }, // 192.152.166.0   - 192.152.167.255
	{ 0xc098a800, 0xc098adff, REGISTRY_ARIN       }, // 192.152.168.0   - 192.152.173.255
	{ 0xc098ae00, 0xc098aeff, REGISTRY_RIPENCC    }, // 192.152.174.0   - 192.152.174.255
	{ 0xc098af00, 0xc098b7ff, REGISTRY_ARIN       }, // 192.152.175.0   - 192.152.183.255
	{ 0xc098b800, 0xc098bbff, REGISTRY_RIPENCC    }, // 192.152.184.0   - 192.152.187.255
	{ 0xc098bc00, 0xc098c4ff, REGISTRY_ARIN       }, // 192.152.188.0   - 192.152.196.255
	{ 0xc098c600, 0xc098d3ff, REGISTRY_ARIN       }, // 192.152.198.0   - 192.152.211.255
	{ 0xc098d400, 0xc098d4ff, REGISTRY_APNIC      }, // 192.152.212.0   - 192.152.212.255
	{ 0xc098d500, 0xc098f0ff, REGISTRY_ARIN       }, // 192.152.213.0   - 192.152.240.255
	{ 0xc098f100, 0xc098f1ff, REGISTRY_RIPENCC    }, // 192.152.241.0   - 192.152.241.255
	{ 0xc098f200, 0xc098f3ff, REGISTRY_ARIN       }, // 192.152.242.0   - 192.152.243.255
	{ 0xc098f400, 0xc098f4ff, REGISTRY_RIPENCC    }, // 192.152.244.0   - 192.152.244.255
	{ 0xc098f500, 0xc098fcff, REGISTRY_ARIN       }, // 192.152.245.0   - 192.152.252.255
	{ 0xc098fd00, 0xc098feff, REGISTRY_RIPENCC    }, // 192.152.253.0   - 192.152.254.255
	{ 0xc098ff00, 0xc09901ff, REGISTRY_ARIN       }, // 192.152.255.0   - 192.153.1.255  
	{ 0xc0990200, 0xc09903ff, REGISTRY_RIPENCC    }, // 192.153.2.0     - 192.153.3.255  
	{ 0xc0990400, 0xc09908ff, REGISTRY_ARIN       }, // 192.153.4.0     - 192.153.8.255  
	{ 0xc0990a00, 0xc0990bff, REGISTRY_ARIN       }, // 192.153.10.0    - 192.153.11.255 
	{ 0xc0990d00, 0xc0990dff, REGISTRY_RIPENCC    }, // 192.153.13.0    - 192.153.13.255 
	{ 0xc0990e00, 0xc09911ff, REGISTRY_ARIN       }, // 192.153.14.0    - 192.153.17.255 
	{ 0xc0991200, 0xc09913ff, REGISTRY_RIPENCC    }, // 192.153.18.0    - 192.153.19.255 
	{ 0xc0991400, 0xc09957ff, REGISTRY_ARIN       }, // 192.153.20.0    - 192.153.87.255 
	{ 0xc0995800, 0xc09958ff, REGISTRY_LACNIC     }, // 192.153.88.0    - 192.153.88.255 
	{ 0xc0995900, 0xc09959ff, REGISTRY_RIPENCC    }, // 192.153.89.0    - 192.153.89.255 
	{ 0xc0995a00, 0xc0995cff, REGISTRY_ARIN       }, // 192.153.90.0    - 192.153.92.255 
	{ 0xc0995d00, 0xc0995dff, REGISTRY_APNIC      }, // 192.153.93.0    - 192.153.93.255 
	{ 0xc0995e00, 0xc0995eff, REGISTRY_ARIN       }, // 192.153.94.0    - 192.153.94.255 
	{ 0xc0995f00, 0xc09972ff, REGISTRY_APNIC      }, // 192.153.95.0    - 192.153.114.255
	{ 0xc0997300, 0xc09973ff, REGISTRY_ARIN       }, // 192.153.115.0   - 192.153.115.255
	{ 0xc0997400, 0xc09974ff, REGISTRY_RIPENCC    }, // 192.153.116.0   - 192.153.116.255
	{ 0xc0997500, 0xc09976ff, REGISTRY_ARIN       }, // 192.153.117.0   - 192.153.118.255
	{ 0xc0997700, 0xc09977ff, REGISTRY_LACNIC     }, // 192.153.119.0   - 192.153.119.255
	{ 0xc0997900, 0xc0997eff, REGISTRY_ARIN       }, // 192.153.121.0   - 192.153.126.255
	{ 0xc0997f00, 0xc0997fff, REGISTRY_RIPENCC    }, // 192.153.127.0   - 192.153.127.255
	{ 0xc0998000, 0xc09998ff, REGISTRY_ARIN       }, // 192.153.128.0   - 192.153.152.255
	{ 0xc0999900, 0xc09999ff, REGISTRY_RIPENCC    }, // 192.153.153.0   - 192.153.153.255
	{ 0xc0999a00, 0xc0999aff, REGISTRY_ARIN       }, // 192.153.154.0   - 192.153.154.255
	{ 0xc0999c00, 0xc0999dff, REGISTRY_ARIN       }, // 192.153.156.0   - 192.153.157.255
	{ 0xc0999e00, 0xc0999eff, REGISTRY_APNIC      }, // 192.153.158.0   - 192.153.158.255
	{ 0xc0999f00, 0xc099a5ff, REGISTRY_ARIN       }, // 192.153.159.0   - 192.153.165.255
	{ 0xc099a600, 0xc099a6ff, REGISTRY_RIPENCC    }, // 192.153.166.0   - 192.153.166.255
	{ 0xc099a700, 0xc099a7ff, REGISTRY_LACNIC     }, // 192.153.167.0   - 192.153.167.255
	{ 0xc099a800, 0xc099a8ff, REGISTRY_RIPENCC    }, // 192.153.168.0   - 192.153.168.255
	{ 0xc099a900, 0xc099aaff, REGISTRY_ARIN       }, // 192.153.169.0   - 192.153.170.255
	{ 0xc099ab00, 0xc099abff, REGISTRY_RIPENCC    }, // 192.153.171.0   - 192.153.171.255
	{ 0xc099ac00, 0xc099acff, REGISTRY_ARIN       }, // 192.153.172.0   - 192.153.172.255
	{ 0xc099ad00, 0xc099b6ff, REGISTRY_RIPENCC    }, // 192.153.173.0   - 192.153.182.255
	{ 0xc099b700, 0xc099bbff, REGISTRY_ARIN       }, // 192.153.183.0   - 192.153.187.255
	{ 0xc099bc00, 0xc099bdff, REGISTRY_RIPENCC    }, // 192.153.188.0   - 192.153.189.255
	{ 0xc099be00, 0xc099c1ff, REGISTRY_ARIN       }, // 192.153.190.0   - 192.153.193.255
	{ 0xc099c200, 0xc099c2ff, REGISTRY_RIPENCC    }, // 192.153.194.0   - 192.153.194.255
	{ 0xc099c300, 0xc099c3ff, REGISTRY_ARIN       }, // 192.153.195.0   - 192.153.195.255
	{ 0xc099c400, 0xc099c5ff, REGISTRY_APNIC      }, // 192.153.196.0   - 192.153.197.255
	{ 0xc099c600, 0xc099d4ff, REGISTRY_ARIN       }, // 192.153.198.0   - 192.153.212.255
	{ 0xc099d500, 0xc099d5ff, REGISTRY_RIPENCC    }, // 192.153.213.0   - 192.153.213.255
	{ 0xc099d600, 0xc099dcff, REGISTRY_ARIN       }, // 192.153.214.0   - 192.153.220.255
	{ 0xc099e500, 0xc099faff, REGISTRY_ARIN       }, // 192.153.229.0   - 192.153.250.255
	{ 0xc099fb00, 0xc099fbff, REGISTRY_APNIC      }, // 192.153.251.0   - 192.153.251.255
	{ 0xc099fc00, 0xc09a0fff, REGISTRY_ARIN       }, // 192.153.252.0   - 192.154.15.255 
	{ 0xc09a1000, 0xc09a19ff, REGISTRY_APNIC      }, // 192.154.16.0    - 192.154.25.255 
	{ 0xc09a1a00, 0xc09b00ff, REGISTRY_ARIN       }, // 192.154.26.0    - 192.155.0.255  
	{ 0xc09b0100, 0xc09b06ff, REGISTRY_RIPENCC    }, // 192.155.1.0     - 192.155.6.255  
	{ 0xc09b0700, 0xc09c83ff, REGISTRY_ARIN       }, // 192.155.7.0     - 192.156.131.255
	{ 0xc09c8400, 0xc09c84ff, REGISTRY_RIPENCC    }, // 192.156.132.0   - 192.156.132.255
	{ 0xc09c8500, 0xc09c8bff, REGISTRY_ARIN       }, // 192.156.133.0   - 192.156.139.255
	{ 0xc09c8c00, 0xc09c8fff, REGISTRY_APNIC      }, // 192.156.140.0   - 192.156.143.255
	{ 0xc09c9100, 0xc09c97ff, REGISTRY_APNIC      }, // 192.156.145.0   - 192.156.151.255
	{ 0xc09c9a00, 0xc09c9aff, REGISTRY_APNIC      }, // 192.156.154.0   - 192.156.154.255
	{ 0xc09c9d00, 0xc09c9dff, REGISTRY_ARIN       }, // 192.156.157.0   - 192.156.157.255
	{ 0xc09c9e00, 0xc09c9fff, REGISTRY_APNIC      }, // 192.156.158.0   - 192.156.159.255
	{ 0xc09ca000, 0xc09ca1ff, REGISTRY_ARIN       }, // 192.156.160.0   - 192.156.161.255
	{ 0xc09ca200, 0xc09ca2ff, REGISTRY_RIPENCC    }, // 192.156.162.0   - 192.156.162.255
	{ 0xc09ca300, 0xc09ca4ff, REGISTRY_ARIN       }, // 192.156.163.0   - 192.156.164.255
	{ 0xc09ca500, 0xc09ca5ff, REGISTRY_APNIC      }, // 192.156.165.0   - 192.156.165.255
	{ 0xc09ca600, 0xc09ca6ff, REGISTRY_ARIN       }, // 192.156.166.0   - 192.156.166.255
	{ 0xc09ca700, 0xc09ca7ff, REGISTRY_RIPENCC    }, // 192.156.167.0   - 192.156.167.255
	{ 0xc09ca800, 0xc09cc9ff, REGISTRY_ARIN       }, // 192.156.168.0   - 192.156.201.255
	{ 0xc09ccb00, 0xc09cceff, REGISTRY_ARIN       }, // 192.156.203.0   - 192.156.206.255
	{ 0xc09ccf00, 0xc09ccfff, REGISTRY_APNIC      }, // 192.156.207.0   - 192.156.207.255
	{ 0xc09cd100, 0xc09cd1ff, REGISTRY_ARIN       }, // 192.156.209.0   - 192.156.209.255
	{ 0xc09cd200, 0xc09cd2ff, REGISTRY_RIPENCC    }, // 192.156.210.0   - 192.156.210.255
	{ 0xc09cd300, 0xc09cd4ff, REGISTRY_ARIN       }, // 192.156.211.0   - 192.156.212.255
	{ 0xc09cd500, 0xc09cd5ff, REGISTRY_RIPENCC    }, // 192.156.213.0   - 192.156.213.255
	{ 0xc09cd600, 0xc09cd8ff, REGISTRY_ARIN       }, // 192.156.214.0   - 192.156.216.255
	{ 0xc09cda00, 0xc09cdbff, REGISTRY_ARIN       }, // 192.156.218.0   - 192.156.219.255
	{ 0xc09cdd00, 0xc09ce0ff, REGISTRY_ARIN       }, // 192.156.221.0   - 192.156.224.255
	{ 0xc09ce100, 0xc09ce1ff, REGISTRY_APNIC      }, // 192.156.225.0   - 192.156.225.255
	{ 0xc09ce200, 0xc09ce2ff, REGISTRY_ARIN       }, // 192.156.226.0   - 192.156.226.255
	{ 0xc09ce300, 0xc09ce3ff, REGISTRY_RIPENCC    }, // 192.156.227.0   - 192.156.227.255
	{ 0xc09ce400, 0xc09ceeff, REGISTRY_ARIN       }, // 192.156.228.0   - 192.156.238.255
	{ 0xc09cef00, 0xc09cefff, REGISTRY_RIPENCC    }, // 192.156.239.0   - 192.156.239.255
	{ 0xc09cf000, 0xc09cf7ff, REGISTRY_ARIN       }, // 192.156.240.0   - 192.156.247.255
	{ 0xc09cf800, 0xc09cf8ff, REGISTRY_RIPENCC    }, // 192.156.248.0   - 192.156.248.255
	{ 0xc09cfa00, 0xc09d00ff, REGISTRY_ARIN       }, // 192.156.250.0   - 192.157.0.255  
	{ 0xc09d0100, 0xc09d03ff, REGISTRY_RIPENCC    }, // 192.157.1.0     - 192.157.3.255  
	{ 0xc09d0400, 0xc09d07ff, REGISTRY_ARIN       }, // 192.157.4.0     - 192.157.7.255  
	{ 0xc09d0800, 0xc09d11ff, REGISTRY_RIPENCC    }, // 192.157.8.0     - 192.157.17.255 
	{ 0xc09d1200, 0xc09d80ff, REGISTRY_ARIN       }, // 192.157.18.0    - 192.157.128.255
	{ 0xc09d8100, 0xc09d81ff, REGISTRY_RIPENCC    }, // 192.157.129.0   - 192.157.129.255
	{ 0xc09d8200, 0xc09da1ff, REGISTRY_ARIN       }, // 192.157.130.0   - 192.157.161.255
	{ 0xc09da300, 0xc09da4ff, REGISTRY_ARIN       }, // 192.157.163.0   - 192.157.164.255
	{ 0xc09da500, 0xc09dacff, REGISTRY_RIPENCC    }, // 192.157.165.0   - 192.157.172.255
	{ 0xc09dad00, 0xc09dadff, REGISTRY_ARIN       }, // 192.157.173.0   - 192.157.173.255
	{ 0xc09dae00, 0xc09daeff, REGISTRY_RIPENCC    }, // 192.157.174.0   - 192.157.174.255
	{ 0xc09daf00, 0xc09dafff, REGISTRY_ARIN       }, // 192.157.175.0   - 192.157.175.255
	{ 0xc09db000, 0xc09db0ff, REGISTRY_RIPENCC    }, // 192.157.176.0   - 192.157.176.255
	{ 0xc09db100, 0xc09db8ff, REGISTRY_ARIN       }, // 192.157.177.0   - 192.157.184.255
	{ 0xc09db900, 0xc09db9ff, REGISTRY_RIPENCC    }, // 192.157.185.0   - 192.157.185.255
	{ 0xc09dba00, 0xc09dbaff, REGISTRY_ARIN       }, // 192.157.186.0   - 192.157.186.255
	{ 0xc09dbb00, 0xc09dbbff, REGISTRY_RIPENCC    }, // 192.157.187.0   - 192.157.187.255
	{ 0xc09dbc00, 0xc09dbcff, REGISTRY_ARIN       }, // 192.157.188.0   - 192.157.188.255
	{ 0xc09dbd00, 0xc09dbdff, REGISTRY_RIPENCC    }, // 192.157.189.0   - 192.157.189.255
	{ 0xc09dbe00, 0xc09dbeff, REGISTRY_AFRINIC    }, // 192.157.190.0   - 192.157.190.255
	{ 0xc09dc000, 0xc09f0fff, REGISTRY_ARIN       }, // 192.157.192.0   - 192.159.15.255 
	{ 0xc09f1000, 0xc09f1eff, REGISTRY_APNIC      }, // 192.159.16.0    - 192.159.30.255 
	{ 0xc09f1f00, 0xc09f45ff, REGISTRY_ARIN       }, // 192.159.31.0    - 192.159.69.255 
	{ 0xc09f4600, 0xc09f46ff, REGISTRY_RIPENCC    }, // 192.159.70.0    - 192.159.70.255 
	{ 0xc09f4700, 0xc09f48ff, REGISTRY_ARIN       }, // 192.159.71.0    - 192.159.72.255 
	{ 0xc09f4900, 0xc09f49ff, REGISTRY_RIPENCC    }, // 192.159.73.0    - 192.159.73.255 
	{ 0xc09f4a00, 0xc09f4cff, REGISTRY_ARIN       }, // 192.159.74.0    - 192.159.76.255 
	{ 0xc09f4d00, 0xc09f4dff, REGISTRY_RIPENCC    }, // 192.159.77.0    - 192.159.77.255 
	{ 0xc09f4e00, 0xc09f53ff, REGISTRY_ARIN       }, // 192.159.78.0    - 192.159.83.255 
	{ 0xc09f5400, 0xc09f55ff, REGISTRY_RIPENCC    }, // 192.159.84.0    - 192.159.85.255 
	{ 0xc09f5600, 0xc09f59ff, REGISTRY_ARIN       }, // 192.159.86.0    - 192.159.89.255 
	{ 0xc09f5a00, 0xc09f5aff, REGISTRY_RIPENCC    }, // 192.159.90.0    - 192.159.90.255 
	{ 0xc09f5b00, 0xc09f5eff, REGISTRY_ARIN       }, // 192.159.91.0    - 192.159.94.255 
	{ 0xc09f5f00, 0xc09f5fff, REGISTRY_RIPENCC    }, // 192.159.95.0    - 192.159.95.255 
	{ 0xc09f6000, 0xc09f62ff, REGISTRY_ARIN       }, // 192.159.96.0    - 192.159.98.255 
	{ 0xc09f6300, 0xc09f67ff, REGISTRY_RIPENCC    }, // 192.159.99.0    - 192.159.103.255
	{ 0xc09f6800, 0xc09f68ff, REGISTRY_ARIN       }, // 192.159.104.0   - 192.159.104.255
	{ 0xc09f6900, 0xc09f69ff, REGISTRY_RIPENCC    }, // 192.159.105.0   - 192.159.105.255
	{ 0xc09f6a00, 0xc09f6bff, REGISTRY_ARIN       }, // 192.159.106.0   - 192.159.107.255
	{ 0xc09f6c00, 0xc09f6dff, REGISTRY_RIPENCC    }, // 192.159.108.0   - 192.159.109.255
	{ 0xc09f6e00, 0xc09f73ff, REGISTRY_ARIN       }, // 192.159.110.0   - 192.159.115.255
	{ 0xc09f7600, 0xc09f76ff, REGISTRY_RIPENCC    }, // 192.159.118.0   - 192.159.118.255
	{ 0xc09f7700, 0xc09f78ff, REGISTRY_ARIN       }, // 192.159.119.0   - 192.159.120.255
	{ 0xc09f7900, 0xc09f7aff, REGISTRY_RIPENCC    }, // 192.159.121.0   - 192.159.122.255
	{ 0xc09f7b00, 0xc0a009ff, REGISTRY_ARIN       }, // 192.159.123.0   - 192.160.9.255  
	{ 0xc0a00a00, 0xc0a00aff, REGISTRY_RIPENCC    }, // 192.160.10.0    - 192.160.10.255 
	{ 0xc0a00b00, 0xc0a00eff, REGISTRY_ARIN       }, // 192.160.11.0    - 192.160.14.255 
	{ 0xc0a00f00, 0xc0a00fff, REGISTRY_RIPENCC    }, // 192.160.15.0    - 192.160.15.255 
	{ 0xc0a01000, 0xc0a010ff, REGISTRY_APNIC      }, // 192.160.16.0    - 192.160.16.255 
	{ 0xc0a01100, 0xc0a012ff, REGISTRY_ARIN       }, // 192.160.17.0    - 192.160.18.255 
	{ 0xc0a01300, 0xc0a013ff, REGISTRY_APNIC      }, // 192.160.19.0    - 192.160.19.255 
	{ 0xc0a01400, 0xc0a014ff, REGISTRY_ARIN       }, // 192.160.20.0    - 192.160.20.255 
	{ 0xc0a01500, 0xc0a017ff, REGISTRY_RIPENCC    }, // 192.160.21.0    - 192.160.23.255 
	{ 0xc0a01800, 0xc0a01aff, REGISTRY_ARIN       }, // 192.160.24.0    - 192.160.26.255 
	{ 0xc0a01b00, 0xc0a01bff, REGISTRY_RIPENCC    }, // 192.160.27.0    - 192.160.27.255 
	{ 0xc0a01c00, 0xc0a01cff, REGISTRY_ARIN       }, // 192.160.28.0    - 192.160.28.255 
	{ 0xc0a01e00, 0xc0a020ff, REGISTRY_ARIN       }, // 192.160.30.0    - 192.160.32.255 
	{ 0xc0a02100, 0xc0a021ff, REGISTRY_RIPENCC    }, // 192.160.33.0    - 192.160.33.255 
	{ 0xc0a02200, 0xc0a024ff, REGISTRY_ARIN       }, // 192.160.34.0    - 192.160.36.255 
	{ 0xc0a02500, 0xc0a025ff, REGISTRY_RIPENCC    }, // 192.160.37.0    - 192.160.37.255 
	{ 0xc0a02600, 0xc0a02cff, REGISTRY_ARIN       }, // 192.160.38.0    - 192.160.44.255 
	{ 0xc0a02e00, 0xc0a031ff, REGISTRY_ARIN       }, // 192.160.46.0    - 192.160.49.255 
	{ 0xc0a03300, 0xc0a040ff, REGISTRY_ARIN       }, // 192.160.51.0    - 192.160.64.255 
	{ 0xc0a04100, 0xc0a041ff, REGISTRY_RIPENCC    }, // 192.160.65.0    - 192.160.65.255 
	{ 0xc0a04200, 0xc0a042ff, REGISTRY_ARIN       }, // 192.160.66.0    - 192.160.66.255 
	{ 0xc0a04300, 0xc0a043ff, REGISTRY_RIPENCC    }, // 192.160.67.0    - 192.160.67.255 
	{ 0xc0a04400, 0xc0a046ff, REGISTRY_ARIN       }, // 192.160.68.0    - 192.160.70.255 
	{ 0xc0a04700, 0xc0a047ff, REGISTRY_APNIC      }, // 192.160.71.0    - 192.160.71.255 
	{ 0xc0a04800, 0xc0a05eff, REGISTRY_ARIN       }, // 192.160.72.0    - 192.160.94.255 
	{ 0xc0a05f00, 0xc0a060ff, REGISTRY_RIPENCC    }, // 192.160.95.0    - 192.160.96.255 
	{ 0xc0a06100, 0xc0a06cff, REGISTRY_ARIN       }, // 192.160.97.0    - 192.160.108.255
	{ 0xc0a06d00, 0xc0a06eff, REGISTRY_RIPENCC    }, // 192.160.109.0   - 192.160.110.255
	{ 0xc0a07000, 0xc0a07aff, REGISTRY_ARIN       }, // 192.160.112.0   - 192.160.122.255
	{ 0xc0a07b00, 0xc0a07bff, REGISTRY_RIPENCC    }, // 192.160.123.0   - 192.160.123.255
	{ 0xc0a07c00, 0xc0a07dff, REGISTRY_ARIN       }, // 192.160.124.0   - 192.160.125.255
	{ 0xc0a07e00, 0xc0a07eff, REGISTRY_RIPENCC    }, // 192.160.126.0   - 192.160.126.255
	{ 0xc0a07f00, 0xc0a07fff, REGISTRY_ARIN       }, // 192.160.127.0   - 192.160.127.255
	{ 0xc0a08100, 0xc0a08dff, REGISTRY_ARIN       }, // 192.160.129.0   - 192.160.141.255
	{ 0xc0a08e00, 0xc0a08fff, REGISTRY_RIPENCC    }, // 192.160.142.0   - 192.160.143.255
	{ 0xc0a09000, 0xc0a097ff, REGISTRY_ARIN       }, // 192.160.144.0   - 192.160.151.255
	{ 0xc0a09800, 0xc0a098ff, REGISTRY_RIPENCC    }, // 192.160.152.0   - 192.160.152.255
	{ 0xc0a09900, 0xc0a09aff, REGISTRY_ARIN       }, // 192.160.153.0   - 192.160.154.255
	{ 0xc0a09c00, 0xc0a09cff, REGISTRY_RIPENCC    }, // 192.160.156.0   - 192.160.156.255
	{ 0xc0a09d00, 0xc0a09fff, REGISTRY_ARIN       }, // 192.160.157.0   - 192.160.159.255
	{ 0xc0a0a000, 0xc0a0a0ff, REGISTRY_RIPENCC    }, // 192.160.160.0   - 192.160.160.255
	{ 0xc0a0a100, 0xc0a0a1ff, REGISTRY_APNIC      }, // 192.160.161.0   - 192.160.161.255
	{ 0xc0a0a200, 0xc0a0a8ff, REGISTRY_ARIN       }, // 192.160.162.0   - 192.160.168.255
	{ 0xc0a0a900, 0xc0a0abff, REGISTRY_APNIC      }, // 192.160.169.0   - 192.160.171.255
	{ 0xc0a0ac00, 0xc0a0acff, REGISTRY_RIPENCC    }, // 192.160.172.0   - 192.160.172.255
	{ 0xc0a0ad00, 0xc0a0b0ff, REGISTRY_ARIN       }, // 192.160.173.0   - 192.160.176.255
	{ 0xc0a0b100, 0xc0a0b3ff, REGISTRY_RIPENCC    }, // 192.160.177.0   - 192.160.179.255
	{ 0xc0a0b400, 0xc0a0bbff, REGISTRY_ARIN       }, // 192.160.180.0   - 192.160.187.255
	{ 0xc0a0bd00, 0xc0a0c1ff, REGISTRY_ARIN       }, // 192.160.189.0   - 192.160.193.255
	{ 0xc0a0c200, 0xc0a0c3ff, REGISTRY_RIPENCC    }, // 192.160.194.0   - 192.160.195.255
	{ 0xc0a0c400, 0xc0a0ccff, REGISTRY_ARIN       }, // 192.160.196.0   - 192.160.204.255
	{ 0xc0a0cd00, 0xc0a0cdff, REGISTRY_APNIC      }, // 192.160.205.0   - 192.160.205.255
	{ 0xc0a0ce00, 0xc0a0dfff, REGISTRY_ARIN       }, // 192.160.206.0   - 192.160.223.255
	{ 0xc0a0e000, 0xc0a0e1ff, REGISTRY_RIPENCC    }, // 192.160.224.0   - 192.160.225.255
	{ 0xc0a0e300, 0xc0a0e4ff, REGISTRY_ARIN       }, // 192.160.227.0   - 192.160.228.255
	{ 0xc0a0e500, 0xc0a0e5ff, REGISTRY_APNIC      }, // 192.160.229.0   - 192.160.229.255
	{ 0xc0a0e600, 0xc0a0e6ff, REGISTRY_ARIN       }, // 192.160.230.0   - 192.160.230.255
	{ 0xc0a0e700, 0xc0a0e9ff, REGISTRY_RIPENCC    }, // 192.160.231.0   - 192.160.233.255
	{ 0xc0a0ea00, 0xc0a0f4ff, REGISTRY_ARIN       }, // 192.160.234.0   - 192.160.244.255
	{ 0xc0a0f500, 0xc0a0f9ff, REGISTRY_RIPENCC    }, // 192.160.245.0   - 192.160.249.255
	{ 0xc0a0fa00, 0xc0a0faff, REGISTRY_ARIN       }, // 192.160.250.0   - 192.160.250.255
	{ 0xc0a0fb00, 0xc0a0fcff, REGISTRY_RIPENCC    }, // 192.160.251.0   - 192.160.252.255
	{ 0xc0a0fd00, 0xc0a13fff, REGISTRY_ARIN       }, // 192.160.253.0   - 192.161.63.255 
	{ 0xc0a14000, 0xc0a141ff, REGISTRY_RIPENCC    }, // 192.161.64.0    - 192.161.65.255 
	{ 0xc0a14200, 0xc0a17fff, REGISTRY_ARIN       }, // 192.161.66.0    - 192.161.127.255
	{ 0xc0a18000, 0xc0a181ff, REGISTRY_APNIC      }, // 192.161.128.0   - 192.161.129.255
	{ 0xc0a18200, 0xc0a1ffff, REGISTRY_ARIN       }, // 192.161.130.0   - 192.161.255.255
	{ 0xc0a20000, 0xc0a263ff, REGISTRY_RIPENCC    }, // 192.162.0.0     - 192.162.99.255 
	{ 0xc0a26400, 0xc0a267ff, REGISTRY_RIPENCC    }, // 192.162.100.0   - 192.162.103.255
	{ 0xc0a26800, 0xc0a2c3ff, REGISTRY_RIPENCC    }, // 192.162.104.0   - 192.162.195.255
	{ 0xc0a2c800, 0xc0a2cbff, REGISTRY_RIPENCC    }, // 192.162.200.0   - 192.162.203.255
	{ 0xc0a2d000, 0xc0a2ffff, REGISTRY_RIPENCC    }, // 192.162.208.0   - 192.162.255.255
	{ 0xc0a30000, 0xc0a31fff, REGISTRY_ARIN       }, // 192.163.0.0     - 192.163.31.255 
	{ 0xc0a32000, 0xc0a39fff, REGISTRY_RIPENCC    }, // 192.163.32.0    - 192.163.159.255
	{ 0xc0a3a000, 0xc0a3ffff, REGISTRY_ARIN       }, // 192.163.160.0   - 192.163.255.255
	{ 0xc0a40000, 0xc0a5ffff, REGISTRY_RIPENCC    }, // 192.164.0.0     - 192.165.255.255
	{ 0xc0a60000, 0xc0a607ff, REGISTRY_RIPENCC    }, // 192.166.0.0     - 192.166.7.255  
	{ 0xc0a60c00, 0xc0a61fff, REGISTRY_RIPENCC    }, // 192.166.12.0    - 192.166.31.255 
	{ 0xc0a63000, 0xc0a650ff, REGISTRY_RIPENCC    }, // 192.166.48.0    - 192.166.80.255 
	{ 0xc0a65200, 0xc0a671ff, REGISTRY_RIPENCC    }, // 192.166.82.0    - 192.166.113.255
	{ 0xc0a67400, 0xc0a6cbff, REGISTRY_RIPENCC    }, // 192.166.116.0   - 192.166.203.255
	{ 0xc0a6d000, 0xc0a6dfff, REGISTRY_RIPENCC    }, // 192.166.208.0   - 192.166.223.255
	{ 0xc0a6e800, 0xc0a6efff, REGISTRY_RIPENCC    }, // 192.166.232.0   - 192.166.239.255
	{ 0xc0a6f800, 0xc0a6fbff, REGISTRY_RIPENCC    }, // 192.166.248.0   - 192.166.251.255
	{ 0xc0a6fd00, 0xc0a6ffff, REGISTRY_RIPENCC    }, // 192.166.253.0   - 192.166.255.255
	{ 0xc0a70000, 0xc0a7ffff, REGISTRY_RIPENCC    }, // 192.167.0.0     - 192.167.255.255
	{ 0xc0a90000, 0xc0a91fff, REGISTRY_ARIN       }, // 192.169.0.0     - 192.169.31.255 
	{ 0xc0a92000, 0xc0a929ff, REGISTRY_APNIC      }, // 192.169.32.0    - 192.169.41.255 
	{ 0xc0a92a00, 0xc0ab00ff, REGISTRY_ARIN       }, // 192.169.42.0    - 192.171.0.255  
	{ 0xc0ab0100, 0xc0ab05ff, REGISTRY_RIPENCC    }, // 192.171.1.0     - 192.171.5.255  
	{ 0xc0ab0600, 0xc0ab7fff, REGISTRY_ARIN       }, // 192.171.6.0     - 192.171.127.255
	{ 0xc0ab8000, 0xc0abc7ff, REGISTRY_RIPENCC    }, // 192.171.128.0   - 192.171.199.255
	{ 0xc0abc800, 0xc0ace2ff, REGISTRY_ARIN       }, // 192.171.200.0   - 192.172.226.255
	{ 0xc0ace300, 0xc0ace7ff, REGISTRY_APNIC      }, // 192.172.227.0   - 192.172.231.255
	{ 0xc0ace900, 0xc0ace9ff, REGISTRY_ARIN       }, // 192.172.233.0   - 192.172.233.255
	{ 0xc0acea00, 0xc0acefff, REGISTRY_APNIC      }, // 192.172.234.0   - 192.172.239.255
	{ 0xc0acf000, 0xc0acf0ff, REGISTRY_ARIN       }, // 192.172.240.0   - 192.172.240.255
	{ 0xc0acf100, 0xc0acf3ff, REGISTRY_APNIC      }, // 192.172.241.0   - 192.172.243.255
	{ 0xc0acf700, 0xc0acfcff, REGISTRY_ARIN       }, // 192.172.247.0   - 192.172.252.255
	{ 0xc0acfd00, 0xc0acfdff, REGISTRY_RIPENCC    }, // 192.172.253.0   - 192.172.253.255
	{ 0xc0acfe00, 0xc0ad00ff, REGISTRY_ARIN       }, // 192.172.254.0   - 192.173.0.255  
	{ 0xc0ad0100, 0xc0ad04ff, REGISTRY_RIPENCC    }, // 192.173.1.0     - 192.173.4.255  
	{ 0xc0ad0500, 0xc0ad0fff, REGISTRY_ARIN       }, // 192.173.5.0     - 192.173.15.255 
	{ 0xc0ad1000, 0xc0ad18ff, REGISTRY_APNIC      }, // 192.173.16.0    - 192.173.24.255 
	{ 0xc0ad1900, 0xc0ad7fff, REGISTRY_ARIN       }, // 192.173.25.0    - 192.173.127.255
	{ 0xc0ad8000, 0xc0ad87ff, REGISTRY_RIPENCC    }, // 192.173.128.0   - 192.173.135.255
	{ 0xc0ad8800, 0xc0ae3fff, REGISTRY_ARIN       }, // 192.173.136.0   - 192.174.63.255 
	{ 0xc0ae4000, 0xc0ae44ff, REGISTRY_RIPENCC    }, // 192.174.64.0    - 192.174.68.255 
	{ 0xc0ae4500, 0xc0ae7fff, REGISTRY_ARIN       }, // 192.174.69.0    - 192.174.127.255
	{ 0xc0ae8000, 0xc0aeffff, REGISTRY_APNIC      }, // 192.174.128.0   - 192.174.255.255
	{ 0xc0af0000, 0xc0af1fff, REGISTRY_ARIN       }, // 192.175.0.0     - 192.175.31.255 
	{ 0xc0af2000, 0xc0af2fff, REGISTRY_RIPENCC    }, // 192.175.32.0    - 192.175.47.255 
	{ 0xc0af3000, 0xc0afffff, REGISTRY_ARIN       }, // 192.175.48.0    - 192.175.255.255
	{ 0xc0b00000, 0xc0b0ffff, REGISTRY_RIPENCC    }, // 192.176.0.0     - 192.176.255.255
	{ 0xc0b10000, 0xc0bb0fff, REGISTRY_ARIN       }, // 192.177.0.0     - 192.187.15.255 
	{ 0xc0bb1000, 0xc0bb19ff, REGISTRY_RIPENCC    }, // 192.187.16.0    - 192.187.25.255 
	{ 0xc0bb1a00, 0xc0bc09ff, REGISTRY_ARIN       }, // 192.187.26.0    - 192.188.9.255  
	{ 0xc0bc0a00, 0xc0bc0aff, REGISTRY_RIPENCC    }, // 192.188.10.0    - 192.188.10.255 
	{ 0xc0bc0b00, 0xc0bc0bff, REGISTRY_LACNIC     }, // 192.188.11.0    - 192.188.11.255 
	{ 0xc0bc0c00, 0xc0bc2aff, REGISTRY_ARIN       }, // 192.188.12.0    - 192.188.42.255 
	{ 0xc0bc2b00, 0xc0bc2bff, REGISTRY_APNIC      }, // 192.188.43.0    - 192.188.43.255 
	{ 0xc0bc2c00, 0xc0bc3cff, REGISTRY_LACNIC     }, // 192.188.44.0    - 192.188.60.255 
	{ 0xc0bc3d00, 0xc0bc3eff, REGISTRY_ARIN       }, // 192.188.61.0    - 192.188.62.255 
	{ 0xc0bc3f00, 0xc0bc41ff, REGISTRY_RIPENCC    }, // 192.188.63.0    - 192.188.65.255 
	{ 0xc0bc4200, 0xc0bc44ff, REGISTRY_ARIN       }, // 192.188.66.0    - 192.188.68.255 
	{ 0xc0bc4500, 0xc0bc45ff, REGISTRY_RIPENCC    }, // 192.188.69.0    - 192.188.69.255 
	{ 0xc0bc4600, 0xc0bc46ff, REGISTRY_ARIN       }, // 192.188.70.0    - 192.188.70.255 
	{ 0xc0bc4700, 0xc0bc47ff, REGISTRY_APNIC      }, // 192.188.71.0    - 192.188.71.255 
	{ 0xc0bc4800, 0xc0bc48ff, REGISTRY_ARIN       }, // 192.188.72.0    - 192.188.72.255 
	{ 0xc0bc4900, 0xc0bc4fff, REGISTRY_APNIC      }, // 192.188.73.0    - 192.188.79.255 
	{ 0xc0bc5400, 0xc0bc54ff, REGISTRY_ARIN       }, // 192.188.84.0    - 192.188.84.255 
	{ 0xc0bc5500, 0xc0bc57ff, REGISTRY_APNIC      }, // 192.188.85.0    - 192.188.87.255 
	{ 0xc0bc5800, 0xc0bc58ff, REGISTRY_ARIN       }, // 192.188.88.0    - 192.188.88.255 
	{ 0xc0bc5900, 0xc0bc5aff, REGISTRY_APNIC      }, // 192.188.89.0    - 192.188.90.255 
	{ 0xc0bc5b00, 0xc0bc5bff, REGISTRY_ARIN       }, // 192.188.91.0    - 192.188.91.255 
	{ 0xc0bc5c00, 0xc0bc5cff, REGISTRY_APNIC      }, // 192.188.92.0    - 192.188.92.255 
	{ 0xc0bc5d00, 0xc0bc5fff, REGISTRY_ARIN       }, // 192.188.93.0    - 192.188.95.255 
	{ 0xc0bc6000, 0xc0bc60ff, REGISTRY_RIPENCC    }, // 192.188.96.0    - 192.188.96.255 
	{ 0xc0bc6100, 0xc0bc64ff, REGISTRY_ARIN       }, // 192.188.97.0    - 192.188.100.255
	{ 0xc0bc6500, 0xc0bc65ff, REGISTRY_APNIC      }, // 192.188.101.0   - 192.188.101.255
	{ 0xc0bc6600, 0xc0bc68ff, REGISTRY_ARIN       }, // 192.188.102.0   - 192.188.104.255
	{ 0xc0bc6900, 0xc0bc69ff, REGISTRY_RIPENCC    }, // 192.188.105.0   - 192.188.105.255
	{ 0xc0bc6a00, 0xc0bc6aff, REGISTRY_ARIN       }, // 192.188.106.0   - 192.188.106.255
	{ 0xc0bc6b00, 0xc0bc6bff, REGISTRY_APNIC      }, // 192.188.107.0   - 192.188.107.255
	{ 0xc0bc6c00, 0xc0bc72ff, REGISTRY_ARIN       }, // 192.188.108.0   - 192.188.114.255
	{ 0xc0bc7300, 0xc0bc73ff, REGISTRY_APNIC      }, // 192.188.115.0   - 192.188.115.255
	{ 0xc0bc7400, 0xc0bc75ff, REGISTRY_RIPENCC    }, // 192.188.116.0   - 192.188.117.255
	{ 0xc0bc7600, 0xc0bc78ff, REGISTRY_ARIN       }, // 192.188.118.0   - 192.188.120.255
	{ 0xc0bc7900, 0xc0bc7aff, REGISTRY_RIPENCC    }, // 192.188.121.0   - 192.188.122.255
	{ 0xc0bc7b00, 0xc0bc7cff, REGISTRY_ARIN       }, // 192.188.123.0   - 192.188.124.255
	{ 0xc0bc7d00, 0xc0bc7dff, REGISTRY_RIPENCC    }, // 192.188.125.0   - 192.188.125.255
	{ 0xc0bc7e00, 0xc0bc7eff, REGISTRY_ARIN       }, // 192.188.126.0   - 192.188.126.255
	{ 0xc0bc7f00, 0xc0bc7fff, REGISTRY_RIPENCC    }, // 192.188.127.0   - 192.188.127.255
	{ 0xc0bc8100, 0xc0bc81ff, REGISTRY_RIPENCC    }, // 192.188.129.0   - 192.188.129.255
	{ 0xc0bc8200, 0xc0bc83ff, REGISTRY_ARIN       }, // 192.188.130.0   - 192.188.131.255
	{ 0xc0bc8400, 0xc0bc84ff, REGISTRY_RIPENCC    }, // 192.188.132.0   - 192.188.132.255
	{ 0xc0bc8500, 0xc0bc87ff, REGISTRY_ARIN       }, // 192.188.133.0   - 192.188.135.255
	{ 0xc0bc8800, 0xc0bc88ff, REGISTRY_RIPENCC    }, // 192.188.136.0   - 192.188.136.255
	{ 0xc0bc8900, 0xc0bc90ff, REGISTRY_ARIN       }, // 192.188.137.0   - 192.188.144.255
	{ 0xc0bc9100, 0xc0bc91ff, REGISTRY_RIPENCC    }, // 192.188.145.0   - 192.188.145.255
	{ 0xc0bc9200, 0xc0bc96ff, REGISTRY_ARIN       }, // 192.188.146.0   - 192.188.150.255
	{ 0xc0bc9700, 0xc0bc97ff, REGISTRY_APNIC      }, // 192.188.151.0   - 192.188.151.255
	{ 0xc0bc9800, 0xc0bc9cff, REGISTRY_ARIN       }, // 192.188.152.0   - 192.188.156.255
	{ 0xc0bc9d00, 0xc0bc9eff, REGISTRY_RIPENCC    }, // 192.188.157.0   - 192.188.158.255
	{ 0xc0bc9f00, 0xc0bca3ff, REGISTRY_ARIN       }, // 192.188.159.0   - 192.188.163.255
	{ 0xc0bca400, 0xc0bca7ff, REGISTRY_AFRINIC    }, // 192.188.164.0   - 192.188.167.255
	{ 0xc0bca800, 0xc0bca9ff, REGISTRY_ARIN       }, // 192.188.168.0   - 192.188.169.255
	{ 0xc0bcaa00, 0xc0bcaaff, REGISTRY_APNIC      }, // 192.188.170.0   - 192.188.170.255
	{ 0xc0bcad00, 0xc0bcadff, REGISTRY_ARIN       }, // 192.188.173.0   - 192.188.173.255
	{ 0xc0bcae00, 0xc0bcafff, REGISTRY_APNIC      }, // 192.188.174.0   - 192.188.175.255
	{ 0xc0bcb000, 0xc0bcb8ff, REGISTRY_ARIN       }, // 192.188.176.0   - 192.188.184.255
	{ 0xc0bcb900, 0xc0bcbaff, REGISTRY_APNIC      }, // 192.188.185.0   - 192.188.186.255
	{ 0xc0bcbb00, 0xc0bcbbff, REGISTRY_RIPENCC    }, // 192.188.187.0   - 192.188.187.255
	{ 0xc0bcbc00, 0xc0bcbcff, REGISTRY_ARIN       }, // 192.188.188.0   - 192.188.188.255
	{ 0xc0bcbd00, 0xc0bcbdff, REGISTRY_RIPENCC    }, // 192.188.189.0   - 192.188.189.255
	{ 0xc0bcbe00, 0xc0bcc1ff, REGISTRY_ARIN       }, // 192.188.190.0   - 192.188.193.255
	{ 0xc0bcc200, 0xc0bcc5ff, REGISTRY_LACNIC     }, // 192.188.194.0   - 192.188.197.255
	{ 0xc0bcc600, 0xc0bce8ff, REGISTRY_ARIN       }, // 192.188.198.0   - 192.188.232.255
	{ 0xc0bce900, 0xc0bcedff, REGISTRY_RIPENCC    }, // 192.188.233.0   - 192.188.237.255
	{ 0xc0bcee00, 0xc0bcf0ff, REGISTRY_ARIN       }, // 192.188.238.0   - 192.188.240.255
	{ 0xc0bcf100, 0xc0bcf1ff, REGISTRY_APNIC      }, // 192.188.241.0   - 192.188.241.255
	{ 0xc0bcf200, 0xc0bcf7ff, REGISTRY_RIPENCC    }, // 192.188.242.0   - 192.188.247.255
	{ 0xc0bcf900, 0xc0bd00ff, REGISTRY_ARIN       }, // 192.188.249.0   - 192.189.0.255  
	{ 0xc0bd0100, 0xc0bd01ff, REGISTRY_RIPENCC    }, // 192.189.1.0     - 192.189.1.255  
	{ 0xc0bd0200, 0xc0bd07ff, REGISTRY_ARIN       }, // 192.189.2.0     - 192.189.7.255  
	{ 0xc0bd0800, 0xc0bd0bff, REGISTRY_RIPENCC    }, // 192.189.8.0     - 192.189.11.255 
	{ 0xc0bd0c00, 0xc0bd0dff, REGISTRY_ARIN       }, // 192.189.12.0    - 192.189.13.255 
	{ 0xc0bd0e00, 0xc0bd0eff, REGISTRY_RIPENCC    }, // 192.189.14.0    - 192.189.14.255 
	{ 0xc0bd0f00, 0xc0bd16ff, REGISTRY_ARIN       }, // 192.189.15.0    - 192.189.22.255 
	{ 0xc0bd1700, 0xc0bd17ff, REGISTRY_RIPENCC    }, // 192.189.23.0    - 192.189.23.255 
	{ 0xc0bd1800, 0xc0bd18ff, REGISTRY_APNIC      }, // 192.189.24.0    - 192.189.24.255 
	{ 0xc0bd1900, 0xc0bd21ff, REGISTRY_ARIN       }, // 192.189.25.0    - 192.189.33.255 
	{ 0xc0bd2200, 0xc0bd22ff, REGISTRY_APNIC      }, // 192.189.34.0    - 192.189.34.255 
	{ 0xc0bd2300, 0xc0bd28ff, REGISTRY_ARIN       }, // 192.189.35.0    - 192.189.40.255 
	{ 0xc0bd2900, 0xc0bd29ff, REGISTRY_RIPENCC    }, // 192.189.41.0    - 192.189.41.255 
	{ 0xc0bd2a00, 0xc0bd32ff, REGISTRY_ARIN       }, // 192.189.42.0    - 192.189.50.255 
	{ 0xc0bd3300, 0xc0bd34ff, REGISTRY_RIPENCC    }, // 192.189.51.0    - 192.189.52.255 
	{ 0xc0bd3500, 0xc0bd35ff, REGISTRY_ARIN       }, // 192.189.53.0    - 192.189.53.255 
	{ 0xc0bd3600, 0xc0bd36ff, REGISTRY_APNIC      }, // 192.189.54.0    - 192.189.54.255 
	{ 0xc0bd3700, 0xc0bd37ff, REGISTRY_RIPENCC    }, // 192.189.55.0    - 192.189.55.255 
	{ 0xc0bd3800, 0xc0bd41ff, REGISTRY_ARIN       }, // 192.189.56.0    - 192.189.65.255 
	{ 0xc0bd4200, 0xc0bd42ff, REGISTRY_RIPENCC    }, // 192.189.66.0    - 192.189.66.255 
	{ 0xc0bd4300, 0xc0bd44ff, REGISTRY_ARIN       }, // 192.189.67.0    - 192.189.68.255 
	{ 0xc0bd4500, 0xc0bd46ff, REGISTRY_RIPENCC    }, // 192.189.69.0    - 192.189.70.255 
	{ 0xc0bd4700, 0xc0bd48ff, REGISTRY_ARIN       }, // 192.189.71.0    - 192.189.72.255 
	{ 0xc0bd4900, 0xc0bd49ff, REGISTRY_RIPENCC    }, // 192.189.73.0    - 192.189.73.255 
	{ 0xc0bd4a00, 0xc0bd4aff, REGISTRY_ARIN       }, // 192.189.74.0    - 192.189.74.255 
	{ 0xc0bd4b00, 0xc0bd4bff, REGISTRY_AFRINIC    }, // 192.189.75.0    - 192.189.75.255 
	{ 0xc0bd4c00, 0xc0bd4cff, REGISTRY_RIPENCC    }, // 192.189.76.0    - 192.189.76.255 
	{ 0xc0bd4d00, 0xc0bd5dff, REGISTRY_ARIN       }, // 192.189.77.0    - 192.189.93.255 
	{ 0xc0bd5f00, 0xc0bd76ff, REGISTRY_ARIN       }, // 192.189.95.0    - 192.189.118.255
	{ 0xc0bd7700, 0xc0bd77ff, REGISTRY_RIPENCC    }, // 192.189.119.0   - 192.189.119.255
	{ 0xc0bd7800, 0xc0bd87ff, REGISTRY_ARIN       }, // 192.189.120.0   - 192.189.135.255
	{ 0xc0bd8800, 0xc0bd88ff, REGISTRY_APNIC      }, // 192.189.136.0   - 192.189.136.255
	{ 0xc0bd8900, 0xc0bd8aff, REGISTRY_ARIN       }, // 192.189.137.0   - 192.189.138.255
	{ 0xc0bd8b00, 0xc0bd8cff, REGISTRY_AFRINIC    }, // 192.189.139.0   - 192.189.140.255
	{ 0xc0bd8d00, 0xc0bd93ff, REGISTRY_ARIN       }, // 192.189.141.0   - 192.189.147.255
	{ 0xc0bd9400, 0xc0bd94ff, REGISTRY_APNIC      }, // 192.189.148.0   - 192.189.148.255
	{ 0xc0bd9500, 0xc0bd96ff, REGISTRY_ARIN       }, // 192.189.149.0   - 192.189.150.255
	{ 0xc0bd9700, 0xc0bd97ff, REGISTRY_RIPENCC    }, // 192.189.151.0   - 192.189.151.255
	{ 0xc0bd9800, 0xc0bd99ff, REGISTRY_ARIN       }, // 192.189.152.0   - 192.189.153.255
	{ 0xc0bd9a00, 0xc0bd9aff, REGISTRY_RIPENCC    }, // 192.189.154.0   - 192.189.154.255
	{ 0xc0bd9b00, 0xc0bd9cff, REGISTRY_ARIN       }, // 192.189.155.0   - 192.189.156.255
	{ 0xc0bd9d00, 0xc0bd9dff, REGISTRY_RIPENCC    }, // 192.189.157.0   - 192.189.157.255
	{ 0xc0bd9e00, 0xc0bd9eff, REGISTRY_ARIN       }, // 192.189.158.0   - 192.189.158.255
	{ 0xc0bda000, 0xc0bda0ff, REGISTRY_RIPENCC    }, // 192.189.160.0   - 192.189.160.255
	{ 0xc0bda100, 0xc0bda5ff, REGISTRY_ARIN       }, // 192.189.161.0   - 192.189.165.255
	{ 0xc0bda600, 0xc0bdaaff, REGISTRY_RIPENCC    }, // 192.189.166.0   - 192.189.170.255
	{ 0xc0bdab00, 0xc0bdc9ff, REGISTRY_ARIN       }, // 192.189.171.0   - 192.189.201.255
	{ 0xc0bdca00, 0xc0bdcbff, REGISTRY_RIPENCC    }, // 192.189.202.0   - 192.189.203.255
	{ 0xc0bdcc00, 0xc0bdcfff, REGISTRY_ARIN       }, // 192.189.204.0   - 192.189.207.255
	{ 0xc0bdd000, 0xc0bdd3ff, REGISTRY_APNIC      }, // 192.189.208.0   - 192.189.211.255
	{ 0xc0bdd400, 0xc0bddeff, REGISTRY_ARIN       }, // 192.189.212.0   - 192.189.222.255
	{ 0xc0bddf00, 0xc0bddfff, REGISTRY_APNIC      }, // 192.189.223.0   - 192.189.223.255
	{ 0xc0bde000, 0xc0bde4ff, REGISTRY_ARIN       }, // 192.189.224.0   - 192.189.228.255
	{ 0xc0bde500, 0xc0bde5ff, REGISTRY_APNIC      }, // 192.189.229.0   - 192.189.229.255
	{ 0xc0bdea00, 0xc0bdfaff, REGISTRY_ARIN       }, // 192.189.234.0   - 192.189.250.255
	{ 0xc0bdfb00, 0xc0bdfbff, REGISTRY_RIPENCC    }, // 192.189.251.0   - 192.189.251.255
	{ 0xc0bdfc00, 0xc0be1dff, REGISTRY_ARIN       }, // 192.189.252.0   - 192.190.29.255 
	{ 0xc0be2000, 0xc0be2bff, REGISTRY_ARIN       }, // 192.190.32.0    - 192.190.43.255 
	{ 0xc0be2c00, 0xc0be2cff, REGISTRY_RIPENCC    }, // 192.190.44.0    - 192.190.44.255 
	{ 0xc0be2d00, 0xc0be39ff, REGISTRY_ARIN       }, // 192.190.45.0    - 192.190.57.255 
	{ 0xc0be3a00, 0xc0be3bff, REGISTRY_RIPENCC    }, // 192.190.58.0    - 192.190.59.255 
	{ 0xc0be3c00, 0xc0be3cff, REGISTRY_ARIN       }, // 192.190.60.0    - 192.190.60.255 
	{ 0xc0be3d00, 0xc0be3dff, REGISTRY_APNIC      }, // 192.190.61.0    - 192.190.61.255 
	{ 0xc0be3e00, 0xc0be3fff, REGISTRY_ARIN       }, // 192.190.62.0    - 192.190.63.255 
	{ 0xc0be4000, 0xc0be40ff, REGISTRY_RIPENCC    }, // 192.190.64.0    - 192.190.64.255 
	{ 0xc0be4100, 0xc0be41ff, REGISTRY_ARIN       }, // 192.190.65.0    - 192.190.65.255 
	{ 0xc0be4200, 0xc0be42ff, REGISTRY_APNIC      }, // 192.190.66.0    - 192.190.66.255 
	{ 0xc0be4300, 0xc0be43ff, REGISTRY_RIPENCC    }, // 192.190.67.0    - 192.190.67.255 
	{ 0xc0be4400, 0xc0be44ff, REGISTRY_ARIN       }, // 192.190.68.0    - 192.190.68.255 
	{ 0xc0be4500, 0xc0be45ff, REGISTRY_RIPENCC    }, // 192.190.69.0    - 192.190.69.255 
	{ 0xc0be4600, 0xc0be5eff, REGISTRY_ARIN       }, // 192.190.70.0    - 192.190.94.255 
	{ 0xc0be5f00, 0xc0be5fff, REGISTRY_RIPENCC    }, // 192.190.95.0    - 192.190.95.255 
	{ 0xc0be6000, 0xc0be6bff, REGISTRY_ARIN       }, // 192.190.96.0    - 192.190.107.255
	{ 0xc0be6c00, 0xc0be6cff, REGISTRY_APNIC      }, // 192.190.108.0   - 192.190.108.255
	{ 0xc0be6d00, 0xc0be80ff, REGISTRY_ARIN       }, // 192.190.109.0   - 192.190.128.255
	{ 0xc0be8100, 0xc0be84ff, REGISTRY_RIPENCC    }, // 192.190.129.0   - 192.190.132.255
	{ 0xc0be8500, 0xc0beacff, REGISTRY_ARIN       }, // 192.190.133.0   - 192.190.172.255
	{ 0xc0bead00, 0xc0beaeff, REGISTRY_RIPENCC    }, // 192.190.173.0   - 192.190.174.255
	{ 0xc0beaf00, 0xc0beb3ff, REGISTRY_ARIN       }, // 192.190.175.0   - 192.190.179.255
	{ 0xc0beb400, 0xc0beb5ff, REGISTRY_APNIC      }, // 192.190.180.0   - 192.190.181.255
	{ 0xc0beb600, 0xc0beb7ff, REGISTRY_RIPENCC    }, // 192.190.182.0   - 192.190.183.255
	{ 0xc0beb800, 0xc0bebdff, REGISTRY_ARIN       }, // 192.190.184.0   - 192.190.189.255
	{ 0xc0bebe00, 0xc0bec1ff, REGISTRY_RIPENCC    }, // 192.190.190.0   - 192.190.193.255
	{ 0xc0bec200, 0xc0bec8ff, REGISTRY_ARIN       }, // 192.190.194.0   - 192.190.200.255
	{ 0xc0bec900, 0xc0becaff, REGISTRY_RIPENCC    }, // 192.190.201.0   - 192.190.202.255
	{ 0xc0becb00, 0xc0becbff, REGISTRY_ARIN       }, // 192.190.203.0   - 192.190.203.255
	{ 0xc0becc00, 0xc0becdff, REGISTRY_APNIC      }, // 192.190.204.0   - 192.190.205.255
	{ 0xc0bece00, 0xc0becfff, REGISTRY_ARIN       }, // 192.190.206.0   - 192.190.207.255
	{ 0xc0bed000, 0xc0bed7ff, REGISTRY_APNIC      }, // 192.190.208.0   - 192.190.215.255
	{ 0xc0bed800, 0xc0bee8ff, REGISTRY_ARIN       }, // 192.190.216.0   - 192.190.232.255
	{ 0xc0bee900, 0xc0beecff, REGISTRY_RIPENCC    }, // 192.190.233.0   - 192.190.236.255
	{ 0xc0beed00, 0xc0beefff, REGISTRY_ARIN       }, // 192.190.237.0   - 192.190.239.255
	{ 0xc0bef000, 0xc0bef0ff, REGISTRY_RIPENCC    }, // 192.190.240.0   - 192.190.240.255
	{ 0xc0bef100, 0xc0bef1ff, REGISTRY_ARIN       }, // 192.190.241.0   - 192.190.241.255
	{ 0xc0bef200, 0xc0bef2ff, REGISTRY_RIPENCC    }, // 192.190.242.0   - 192.190.242.255
	{ 0xc0bef300, 0xc0bef6ff, REGISTRY_ARIN       }, // 192.190.243.0   - 192.190.246.255
	{ 0xc0bef700, 0xc0bef9ff, REGISTRY_RIPENCC    }, // 192.190.247.0   - 192.190.249.255
	{ 0xc0befa00, 0xc0bfffff, REGISTRY_ARIN       }, // 192.190.250.0   - 192.191.255.255
	{ 0xc0c00000, 0xc0c0ffff, REGISTRY_APNIC      }, // 192.192.0.0     - 192.192.255.255
	{ 0xc0c10000, 0xc0c1ffff, REGISTRY_ARIN       }, // 192.193.0.0     - 192.193.255.255
	{ 0xc0c20000, 0xc0c2ffff, REGISTRY_RIPENCC    }, // 192.194.0.0     - 192.194.255.255
	{ 0xc0c30000, 0xc0c300ff, REGISTRY_ARIN       }, // 192.195.0.0     - 192.195.0.255  
	{ 0xc0c30100, 0xc0c301ff, REGISTRY_RIPENCC    }, // 192.195.1.0     - 192.195.1.255  
	{ 0xc0c30300, 0xc0c307ff, REGISTRY_ARIN       }, // 192.195.3.0     - 192.195.7.255  
	{ 0xc0c30800, 0xc0c308ff, REGISTRY_RIPENCC    }, // 192.195.8.0     - 192.195.8.255  
	{ 0xc0c30900, 0xc0c309ff, REGISTRY_ARIN       }, // 192.195.9.0     - 192.195.9.255  
	{ 0xc0c30b00, 0xc0c30bff, REGISTRY_ARIN       }, // 192.195.11.0    - 192.195.11.255 
	{ 0xc0c30c00, 0xc0c30eff, REGISTRY_APNIC      }, // 192.195.12.0    - 192.195.14.255 
	{ 0xc0c30f00, 0xc0c321ff, REGISTRY_ARIN       }, // 192.195.15.0    - 192.195.33.255 
	{ 0xc0c32200, 0xc0c322ff, REGISTRY_APNIC      }, // 192.195.34.0    - 192.195.34.255 
	{ 0xc0c32300, 0xc0c326ff, REGISTRY_ARIN       }, // 192.195.35.0    - 192.195.38.255 
	{ 0xc0c32700, 0xc0c328ff, REGISTRY_APNIC      }, // 192.195.39.0    - 192.195.40.255 
	{ 0xc0c32900, 0xc0c329ff, REGISTRY_ARIN       }, // 192.195.41.0    - 192.195.41.255 
	{ 0xc0c32a00, 0xc0c32bff, REGISTRY_RIPENCC    }, // 192.195.42.0    - 192.195.43.255 
	{ 0xc0c32c00, 0xc0c337ff, REGISTRY_APNIC      }, // 192.195.44.0    - 192.195.55.255 
	{ 0xc0c33a00, 0xc0c347ff, REGISTRY_ARIN       }, // 192.195.58.0    - 192.195.71.255 
	{ 0xc0c34800, 0xc0c348ff, REGISTRY_RIPENCC    }, // 192.195.72.0    - 192.195.72.255 
	{ 0xc0c34900, 0xc0c361ff, REGISTRY_ARIN       }, // 192.195.73.0    - 192.195.97.255 
	{ 0xc0c36200, 0xc0c362ff, REGISTRY_RIPENCC    }, // 192.195.98.0    - 192.195.98.255 
	{ 0xc0c36300, 0xc0c365ff, REGISTRY_ARIN       }, // 192.195.99.0    - 192.195.101.255
	{ 0xc0c36600, 0xc0c366ff, REGISTRY_APNIC      }, // 192.195.102.0   - 192.195.102.255
	{ 0xc0c36700, 0xc0c368ff, REGISTRY_ARIN       }, // 192.195.103.0   - 192.195.104.255
	{ 0xc0c36900, 0xc0c36aff, REGISTRY_RIPENCC    }, // 192.195.105.0   - 192.195.106.255
	{ 0xc0c36b00, 0xc0c36dff, REGISTRY_ARIN       }, // 192.195.107.0   - 192.195.109.255
	{ 0xc0c36e00, 0xc0c36eff, REGISTRY_RIPENCC    }, // 192.195.110.0   - 192.195.110.255
	{ 0xc0c36f00, 0xc0c36fff, REGISTRY_ARIN       }, // 192.195.111.0   - 192.195.111.255
	{ 0xc0c37000, 0xc0c370ff, REGISTRY_APNIC      }, // 192.195.112.0   - 192.195.112.255
	{ 0xc0c37100, 0xc0c373ff, REGISTRY_ARIN       }, // 192.195.113.0   - 192.195.115.255
	{ 0xc0c37400, 0xc0c376ff, REGISTRY_RIPENCC    }, // 192.195.116.0   - 192.195.118.255
	{ 0xc0c37700, 0xc0c385ff, REGISTRY_ARIN       }, // 192.195.119.0   - 192.195.133.255
	{ 0xc0c38600, 0xc0c394ff, REGISTRY_RIPENCC    }, // 192.195.134.0   - 192.195.148.255
	{ 0xc0c39500, 0xc0c397ff, REGISTRY_ARIN       }, // 192.195.149.0   - 192.195.151.255
	{ 0xc0c39800, 0xc0c398ff, REGISTRY_APNIC      }, // 192.195.152.0   - 192.195.152.255
	{ 0xc0c39900, 0xc0c3a9ff, REGISTRY_ARIN       }, // 192.195.153.0   - 192.195.169.255
	{ 0xc0c3aa00, 0xc0c3aaff, REGISTRY_APNIC      }, // 192.195.170.0   - 192.195.170.255
	{ 0xc0c3ab00, 0xc0c3b6ff, REGISTRY_ARIN       }, // 192.195.171.0   - 192.195.182.255
	{ 0xc0c3b700, 0xc0c3b8ff, REGISTRY_RIPENCC    }, // 192.195.183.0   - 192.195.184.255
	{ 0xc0c3b900, 0xc0c3b9ff, REGISTRY_ARIN       }, // 192.195.185.0   - 192.195.185.255
	{ 0xc0c3bb00, 0xc0c3c2ff, REGISTRY_ARIN       }, // 192.195.187.0   - 192.195.194.255
	{ 0xc0c3c300, 0xc0c3c3ff, REGISTRY_RIPENCC    }, // 192.195.195.0   - 192.195.195.255
	{ 0xc0c3c400, 0xc0c3c4ff, REGISTRY_ARIN       }, // 192.195.196.0   - 192.195.196.255
	{ 0xc0c3c500, 0xc0c3c5ff, REGISTRY_APNIC      }, // 192.195.197.0   - 192.195.197.255
	{ 0xc0c3c600, 0xc0c3daff, REGISTRY_ARIN       }, // 192.195.198.0   - 192.195.218.255
	{ 0xc0c3db00, 0xc0c3dbff, REGISTRY_APNIC      }, // 192.195.219.0   - 192.195.219.255
	{ 0xc0c3dc00, 0xc0c3e8ff, REGISTRY_ARIN       }, // 192.195.220.0   - 192.195.232.255
	{ 0xc0c3ea00, 0xc0c3ebff, REGISTRY_ARIN       }, // 192.195.234.0   - 192.195.235.255
	{ 0xc0c3ec00, 0xc0c3ecff, REGISTRY_RIPENCC    }, // 192.195.236.0   - 192.195.236.255
	{ 0xc0c3ee00, 0xc0c400ff, REGISTRY_ARIN       }, // 192.195.238.0   - 192.196.0.255  
	{ 0xc0c40100, 0xc0c49bff, REGISTRY_RIPENCC    }, // 192.196.1.0     - 192.196.155.255
	{ 0xc0c49c00, 0xc0c570ff, REGISTRY_ARIN       }, // 192.196.156.0   - 192.197.112.255
	{ 0xc0c57200, 0xc0c607ff, REGISTRY_ARIN       }, // 192.197.114.0   - 192.198.7.255  
	{ 0xc0c60800, 0xc0c60fff, REGISTRY_LACNIC     }, // 192.198.8.0     - 192.198.15.255 
	{ 0xc0c61000, 0xc0c70fff, REGISTRY_ARIN       }, // 192.198.16.0    - 192.199.15.255 
	{ 0xc0c71000, 0xc0c71fff, REGISTRY_RIPENCC    }, // 192.199.16.0    - 192.199.31.255 
	{ 0xc0c72000, 0xc0c72fff, REGISTRY_APNIC      }, // 192.199.32.0    - 192.199.47.255 
	{ 0xc0c73000, 0xc0c83fff, REGISTRY_ARIN       }, // 192.199.48.0    - 192.200.63.255 
	{ 0xc0c84000, 0xc0c84fff, REGISTRY_APNIC      }, // 192.200.64.0    - 192.200.79.255 
	{ 0xc0c85000, 0xc0cb25ff, REGISTRY_ARIN       }, // 192.200.80.0    - 192.203.37.255 
	{ 0xc0cb2800, 0xc0cb4fff, REGISTRY_ARIN       }, // 192.203.40.0    - 192.203.79.255 
	{ 0xc0cb5000, 0xc0cb50ff, REGISTRY_RIPENCC    }, // 192.203.80.0    - 192.203.80.255 
	{ 0xc0cb6000, 0xc0cb62ff, REGISTRY_ARIN       }, // 192.203.96.0    - 192.203.98.255 
	{ 0xc0cb6400, 0xc0cb6bff, REGISTRY_ARIN       }, // 192.203.100.0   - 192.203.107.255
	{ 0xc0cb6c00, 0xc0cb6dff, REGISTRY_RIPENCC    }, // 192.203.108.0   - 192.203.109.255
	{ 0xc0cb6e00, 0xc0cb89ff, REGISTRY_ARIN       }, // 192.203.110.0   - 192.203.137.255
	{ 0xc0cb8a00, 0xc0cb92ff, REGISTRY_APNIC      }, // 192.203.138.0   - 192.203.146.255
	{ 0xc0cb9300, 0xc0cb99ff, REGISTRY_ARIN       }, // 192.203.147.0   - 192.203.153.255
	{ 0xc0cb9a00, 0xc0cb9aff, REGISTRY_APNIC      }, // 192.203.154.0   - 192.203.154.255
	{ 0xc0cb9b00, 0xc0cb9bff, REGISTRY_ARIN       }, // 192.203.155.0   - 192.203.155.255
	{ 0xc0cb9e00, 0xc0cb9eff, REGISTRY_LACNIC     }, // 192.203.158.0   - 192.203.158.255
	{ 0xc0cb9f00, 0xc0cbafff, REGISTRY_ARIN       }, // 192.203.159.0   - 192.203.175.255
	{ 0xc0cbb000, 0xc0cbb0ff, REGISTRY_APNIC      }, // 192.203.176.0   - 192.203.176.255
	{ 0xc0cbb100, 0xc0cbb1ff, REGISTRY_LACNIC     }, // 192.203.177.0   - 192.203.177.255
	{ 0xc0cbb200, 0xc0cbb6ff, REGISTRY_ARIN       }, // 192.203.178.0   - 192.203.182.255
	{ 0xc0cbba00, 0xc0cbc0ff, REGISTRY_ARIN       }, // 192.203.186.0   - 192.203.192.255
	{ 0xc0cbc200, 0xc0cbcfff, REGISTRY_ARIN       }, // 192.203.194.0   - 192.203.207.255
	{ 0xc0cbd200, 0xc0cbd4ff, REGISTRY_ARIN       }, // 192.203.210.0   - 192.203.212.255
	{ 0xc0cbd500, 0xc0cbd5ff, REGISTRY_APNIC      }, // 192.203.213.0   - 192.203.213.255
	{ 0xc0cbd600, 0xc0cbd7ff, REGISTRY_ARIN       }, // 192.203.214.0   - 192.203.215.255
	{ 0xc0cbd800, 0xc0cbd8ff, REGISTRY_APNIC      }, // 192.203.216.0   - 192.203.216.255
	{ 0xc0cbd900, 0xc0cbe2ff, REGISTRY_ARIN       }, // 192.203.217.0   - 192.203.226.255
	{ 0xc0cbe300, 0xc0cbe3ff, REGISTRY_RIPENCC    }, // 192.203.227.0   - 192.203.227.255
	{ 0xc0cbe400, 0xc0cbe7ff, REGISTRY_ARIN       }, // 192.203.228.0   - 192.203.231.255
	{ 0xc0cbe800, 0xc0cbe8ff, REGISTRY_APNIC      }, // 192.203.232.0   - 192.203.232.255
	{ 0xc0cbe900, 0xc0cbeaff, REGISTRY_ARIN       }, // 192.203.233.0   - 192.203.234.255
	{ 0xc0cbeb00, 0xc0cbebff, REGISTRY_APNIC      }, // 192.203.235.0   - 192.203.235.255
	{ 0xc0cbec00, 0xc0cbf6ff, REGISTRY_ARIN       }, // 192.203.236.0   - 192.203.246.255
	{ 0xc0cbf700, 0xc0cbf7ff, REGISTRY_APNIC      }, // 192.203.247.0   - 192.203.247.255
	{ 0xc0cbf800, 0xc0ce4cff, REGISTRY_ARIN       }, // 192.203.248.0   - 192.206.76.255 
	{ 0xc0ce4d00, 0xc0ce51ff, REGISTRY_RIPENCC    }, // 192.206.77.0    - 192.206.81.255 
	{ 0xc0ce5200, 0xc0ce55ff, REGISTRY_ARIN       }, // 192.206.82.0    - 192.206.85.255 
	{ 0xc0ce5600, 0xc0ce56ff, REGISTRY_RIPENCC    }, // 192.206.86.0    - 192.206.86.255 
	{ 0xc0ce5700, 0xc0ce65ff, REGISTRY_ARIN       }, // 192.206.87.0    - 192.206.101.255
	{ 0xc0ce6700, 0xc0ce6bff, REGISTRY_ARIN       }, // 192.206.103.0   - 192.206.107.255
	{ 0xc0ce6d00, 0xc0ce74ff, REGISTRY_ARIN       }, // 192.206.109.0   - 192.206.116.255
	{ 0xc0ce7600, 0xc0ce97ff, REGISTRY_ARIN       }, // 192.206.118.0   - 192.206.151.255
	{ 0xc0ce9800, 0xc0ce9dff, REGISTRY_APNIC      }, // 192.206.152.0   - 192.206.157.255
	{ 0xc0ce9e00, 0xc0ceddff, REGISTRY_ARIN       }, // 192.206.158.0   - 192.206.221.255
	{ 0xc0cede00, 0xc0cee2ff, REGISTRY_RIPENCC    }, // 192.206.222.0   - 192.206.226.255
	{ 0xc0cee300, 0xc0cf0dff, REGISTRY_ARIN       }, // 192.206.227.0   - 192.207.13.255 
	{ 0xc0cf0e00, 0xc0cf0eff, REGISTRY_RIPENCC    }, // 192.207.14.0    - 192.207.14.255 
	{ 0xc0cf0f00, 0xc0cf1eff, REGISTRY_ARIN       }, // 192.207.15.0    - 192.207.30.255 
	{ 0xc0cf1f00, 0xc0cf1fff, REGISTRY_RIPENCC    }, // 192.207.31.0    - 192.207.31.255 
	{ 0xc0cf2000, 0xc0cf20ff, REGISTRY_ARIN       }, // 192.207.32.0    - 192.207.32.255 
	{ 0xc0cf2100, 0xc0cf21ff, REGISTRY_APNIC      }, // 192.207.33.0    - 192.207.33.255 
	{ 0xc0cf2200, 0xc0cf23ff, REGISTRY_ARIN       }, // 192.207.34.0    - 192.207.35.255 
	{ 0xc0cf2400, 0xc0cf24ff, REGISTRY_APNIC      }, // 192.207.36.0    - 192.207.36.255 
	{ 0xc0cf2500, 0xc0cf27ff, REGISTRY_ARIN       }, // 192.207.37.0    - 192.207.39.255 
	{ 0xc0cf2800, 0xc0cf2aff, REGISTRY_LACNIC     }, // 192.207.40.0    - 192.207.42.255 
	{ 0xc0cf2b00, 0xc0cf3fff, REGISTRY_ARIN       }, // 192.207.43.0    - 192.207.63.255 
	{ 0xc0cf4000, 0xc0cf40ff, REGISTRY_APNIC      }, // 192.207.64.0    - 192.207.64.255 
	{ 0xc0cf4100, 0xc0cf44ff, REGISTRY_LACNIC     }, // 192.207.65.0    - 192.207.68.255 
	{ 0xc0cf4500, 0xc0cf5aff, REGISTRY_ARIN       }, // 192.207.69.0    - 192.207.90.255 
	{ 0xc0cf5b00, 0xc0cf5bff, REGISTRY_APNIC      }, // 192.207.91.0    - 192.207.91.255 
	{ 0xc0cf5c00, 0xc0cf5fff, REGISTRY_ARIN       }, // 192.207.92.0    - 192.207.95.255 
	{ 0xc0cf6000, 0xc0cf62ff, REGISTRY_APNIC      }, // 192.207.96.0    - 192.207.98.255 
	{ 0xc0cf6300, 0xc0cf70ff, REGISTRY_ARIN       }, // 192.207.99.0    - 192.207.112.255
	{ 0xc0cf7100, 0xc0cf71ff, REGISTRY_APNIC      }, // 192.207.113.0   - 192.207.113.255
	{ 0xc0cf7200, 0xc0cf76ff, REGISTRY_ARIN       }, // 192.207.114.0   - 192.207.118.255
	{ 0xc0cf7700, 0xc0cf79ff, REGISTRY_APNIC      }, // 192.207.119.0   - 192.207.121.255
	{ 0xc0cf7a00, 0xc0cf8cff, REGISTRY_ARIN       }, // 192.207.122.0   - 192.207.140.255
	{ 0xc0cf8d00, 0xc0cf8eff, REGISTRY_RIPENCC    }, // 192.207.141.0   - 192.207.142.255
	{ 0xc0cf8f00, 0xc0cf8fff, REGISTRY_APNIC      }, // 192.207.143.0   - 192.207.143.255
	{ 0xc0cf9000, 0xc0cf91ff, REGISTRY_ARIN       }, // 192.207.144.0   - 192.207.145.255
	{ 0xc0cf9200, 0xc0cf92ff, REGISTRY_LACNIC     }, // 192.207.146.0   - 192.207.146.255
	{ 0xc0cf9300, 0xc0cf96ff, REGISTRY_ARIN       }, // 192.207.147.0   - 192.207.150.255
	{ 0xc0cf9700, 0xc0cf99ff, REGISTRY_APNIC      }, // 192.207.151.0   - 192.207.153.255
	{ 0xc0cf9c00, 0xc0cf9eff, REGISTRY_APNIC      }, // 192.207.156.0   - 192.207.158.255
	{ 0xc0cf9f00, 0xc0cfa0ff, REGISTRY_ARIN       }, // 192.207.159.0   - 192.207.160.255
	{ 0xc0cfa100, 0xc0cfa1ff, REGISTRY_APNIC      }, // 192.207.161.0   - 192.207.161.255
	{ 0xc0cfa200, 0xc0cfa4ff, REGISTRY_ARIN       }, // 192.207.162.0   - 192.207.164.255
	{ 0xc0cfa500, 0xc0cfa5ff, REGISTRY_APNIC      }, // 192.207.165.0   - 192.207.165.255
	{ 0xc0cfa600, 0xc0cfb6ff, REGISTRY_ARIN       }, // 192.207.166.0   - 192.207.182.255
	{ 0xc0cfb700, 0xc0cfb7ff, REGISTRY_LACNIC     }, // 192.207.183.0   - 192.207.183.255
	{ 0xc0cfb800, 0xc0cfbaff, REGISTRY_ARIN       }, // 192.207.184.0   - 192.207.186.255
	{ 0xc0cfbb00, 0xc0cfbbff, REGISTRY_APNIC      }, // 192.207.187.0   - 192.207.187.255
	{ 0xc0cfbc00, 0xc0cfc1ff, REGISTRY_ARIN       }, // 192.207.188.0   - 192.207.193.255
	{ 0xc0cfc200, 0xc0cfc2ff, REGISTRY_LACNIC     }, // 192.207.194.0   - 192.207.194.255
	{ 0xc0cfc400, 0xc0cfc4ff, REGISTRY_RIPENCC    }, // 192.207.196.0   - 192.207.196.255
	{ 0xc0cfc500, 0xc0cfc6ff, REGISTRY_APNIC      }, // 192.207.197.0   - 192.207.198.255
	{ 0xc0cfc700, 0xc0cfc7ff, REGISTRY_ARIN       }, // 192.207.199.0   - 192.207.199.255
	{ 0xc0cfc800, 0xc0cfcbff, REGISTRY_LACNIC     }, // 192.207.200.0   - 192.207.203.255
	{ 0xc0cfcf00, 0xc0cff1ff, REGISTRY_ARIN       }, // 192.207.207.0   - 192.207.241.255
	{ 0xc0cff200, 0xc0cff2ff, REGISTRY_APNIC      }, // 192.207.242.0   - 192.207.242.255
	{ 0xc0cff300, 0xc0cff3ff, REGISTRY_ARIN       }, // 192.207.243.0   - 192.207.243.255
	{ 0xc0cff400, 0xc0cff4ff, REGISTRY_LACNIC     }, // 192.207.244.0   - 192.207.244.255
	{ 0xc0cff500, 0xc0cff7ff, REGISTRY_ARIN       }, // 192.207.245.0   - 192.207.247.255
	{ 0xc0cff800, 0xc0cff8ff, REGISTRY_APNIC      }, // 192.207.248.0   - 192.207.248.255
	{ 0xc0cff900, 0xc0cffdff, REGISTRY_ARIN       }, // 192.207.249.0   - 192.207.253.255
	{ 0xc0cfff00, 0xc0d9ffff, REGISTRY_ARIN       }, // 192.207.255.0   - 192.217.255.255
	{ 0xc0da0000, 0xc0daffff, REGISTRY_APNIC      }, // 192.218.0.0     - 192.218.255.255
	{ 0xc0db0000, 0xc0df3fff, REGISTRY_ARIN       }, // 192.219.0.0     - 192.223.63.255 
	{ 0xc0df4000, 0xc0df7fff, REGISTRY_LACNIC     }, // 192.223.64.0    - 192.223.127.255
	{ 0xc0df8000, 0xc0e300ff, REGISTRY_ARIN       }, // 192.223.128.0   - 192.227.0.255  
	{ 0xc0e30100, 0xc0e30fff, REGISTRY_APNIC      }, // 192.227.1.0     - 192.227.15.255 
	{ 0xc0e31000, 0xc0e47fff, REGISTRY_ARIN       }, // 192.227.16.0    - 192.228.127.255
	{ 0xc0e48000, 0xc0e4ffff, REGISTRY_APNIC      }, // 192.228.128.0   - 192.228.255.255
	{ 0xc0e50000, 0xc0e60fff, REGISTRY_ARIN       }, // 192.229.0.0     - 192.230.15.255 
	{ 0xc0e62000, 0xc0e70eff, REGISTRY_ARIN       }, // 192.230.32.0    - 192.231.14.255 
	{ 0xc0e70f00, 0xc0e70fff, REGISTRY_APNIC      }, // 192.231.15.0    - 192.231.15.255 
	{ 0xc0e71000, 0xc0e721ff, REGISTRY_ARIN       }, // 192.231.16.0    - 192.231.33.255 
	{ 0xc0e72200, 0xc0e722ff, REGISTRY_APNIC      }, // 192.231.34.0    - 192.231.34.255 
	{ 0xc0e72300, 0xc0e73aff, REGISTRY_ARIN       }, // 192.231.35.0    - 192.231.58.255 
	{ 0xc0e73b00, 0xc0e73bff, REGISTRY_APNIC      }, // 192.231.59.0    - 192.231.59.255 
	{ 0xc0e73c00, 0xc0e742ff, REGISTRY_ARIN       }, // 192.231.60.0    - 192.231.66.255 
	{ 0xc0e74300, 0xc0e743ff, REGISTRY_RIPENCC    }, // 192.231.67.0    - 192.231.67.255 
	{ 0xc0e74400, 0xc0e74cff, REGISTRY_ARIN       }, // 192.231.68.0    - 192.231.76.255 
	{ 0xc0e74e00, 0xc0e751ff, REGISTRY_ARIN       }, // 192.231.78.0    - 192.231.81.255 
	{ 0xc0e75200, 0xc0e752ff, REGISTRY_RIPENCC    }, // 192.231.82.0    - 192.231.82.255 
	{ 0xc0e75300, 0xc0e76dff, REGISTRY_ARIN       }, // 192.231.83.0    - 192.231.109.255
	{ 0xc0e76e00, 0xc0e76eff, REGISTRY_LACNIC     }, // 192.231.110.0   - 192.231.110.255
	{ 0xc0e76f00, 0xc0e771ff, REGISTRY_ARIN       }, // 192.231.111.0   - 192.231.113.255
	{ 0xc0e77400, 0xc0e777ff, REGISTRY_LACNIC     }, // 192.231.116.0   - 192.231.119.255
	{ 0xc0e77a00, 0xc0e77eff, REGISTRY_ARIN       }, // 192.231.122.0   - 192.231.126.255
	{ 0xc0e77f00, 0xc0e77fff, REGISTRY_APNIC      }, // 192.231.127.0   - 192.231.127.255
	{ 0xc0e78000, 0xc0e786ff, REGISTRY_ARIN       }, // 192.231.128.0   - 192.231.134.255
	{ 0xc0e78700, 0xc0e788ff, REGISTRY_APNIC      }, // 192.231.135.0   - 192.231.136.255
	{ 0xc0e78a00, 0xc0e78bff, REGISTRY_ARIN       }, // 192.231.138.0   - 192.231.139.255
	{ 0xc0e78c00, 0xc0e78cff, REGISTRY_LACNIC     }, // 192.231.140.0   - 192.231.140.255
	{ 0xc0e78d00, 0xc0e78fff, REGISTRY_ARIN       }, // 192.231.141.0   - 192.231.143.255
	{ 0xc0e79100, 0xc0e7a5ff, REGISTRY_ARIN       }, // 192.231.145.0   - 192.231.165.255
	{ 0xc0e7a600, 0xc0e7aaff, REGISTRY_APNIC      }, // 192.231.166.0   - 192.231.170.255
	{ 0xc0e7ab00, 0xc0e7aeff, REGISTRY_ARIN       }, // 192.231.171.0   - 192.231.174.255
	{ 0xc0e7b100, 0xc0e7b6ff, REGISTRY_ARIN       }, // 192.231.177.0   - 192.231.182.255
	{ 0xc0e7b800, 0xc0e7c0ff, REGISTRY_ARIN       }, // 192.231.184.0   - 192.231.192.255
	{ 0xc0e7c100, 0xc0e7c1ff, REGISTRY_APNIC      }, // 192.231.193.0   - 192.231.193.255
	{ 0xc0e7c200, 0xc0e7caff, REGISTRY_ARIN       }, // 192.231.194.0   - 192.231.202.255
	{ 0xc0e7cb00, 0xc0e7cbff, REGISTRY_APNIC      }, // 192.231.203.0   - 192.231.203.255
	{ 0xc0e7cc00, 0xc0e7d2ff, REGISTRY_ARIN       }, // 192.231.204.0   - 192.231.210.255
	{ 0xc0e7d400, 0xc0e7d4ff, REGISTRY_APNIC      }, // 192.231.212.0   - 192.231.212.255
	{ 0xc0e7d500, 0xc0e7d7ff, REGISTRY_ARIN       }, // 192.231.213.0   - 192.231.215.255
	{ 0xc0e7d900, 0xc0e7d9ff, REGISTRY_ARIN       }, // 192.231.217.0   - 192.231.217.255
	{ 0xc0e7db00, 0xc0e7ecff, REGISTRY_ARIN       }, // 192.231.219.0   - 192.231.236.255
	{ 0xc0e7ef00, 0xc0e7f7ff, REGISTRY_ARIN       }, // 192.231.239.0   - 192.231.247.255
	{ 0xc0e7f900, 0xc0e7fdff, REGISTRY_ARIN       }, // 192.231.249.0   - 192.231.253.255
	{ 0xc0e7fe00, 0xc0e7feff, REGISTRY_AFRINIC    }, // 192.231.254.0   - 192.231.254.255
	{ 0xc0e7ff00, 0xc0e81fff, REGISTRY_ARIN       }, // 192.231.255.0   - 192.232.31.255 
	{ 0xc0e84000, 0xc0e87fff, REGISTRY_ARIN       }, // 192.232.64.0    - 192.232.127.255
	{ 0xc0e88000, 0xc0e89fff, REGISTRY_APNIC      }, // 192.232.128.0   - 192.232.159.255
	{ 0xc0e8a000, 0xc0ea39ff, REGISTRY_ARIN       }, // 192.232.160.0   - 192.234.57.255 
	{ 0xc0ea3b00, 0xc0eae6ff, REGISTRY_ARIN       }, // 192.234.59.0    - 192.234.230.255
	{ 0xc0eae800, 0xc0eaf4ff, REGISTRY_ARIN       }, // 192.234.232.0   - 192.234.244.255
	{ 0xc0eaf500, 0xc0eaf5ff, REGISTRY_APNIC      }, // 192.234.245.0   - 192.234.245.255
	{ 0xc0eaf600, 0xc0ee00ff, REGISTRY_ARIN       }, // 192.234.246.0   - 192.238.0.255  
	{ 0xc0ee0100, 0xc0ee0aff, REGISTRY_RIPENCC    }, // 192.238.1.0     - 192.238.10.255 
	{ 0xc0ee0b00, 0xc0f00fff, REGISTRY_ARIN       }, // 192.238.11.0    - 192.240.15.255 
	{ 0xc0f01000, 0xc0f01fff, REGISTRY_APNIC      }, // 192.240.16.0    - 192.240.31.255 
	{ 0xc0f02000, 0xc0f3ffff, REGISTRY_ARIN       }, // 192.240.32.0    - 192.243.255.255
	{ 0xc0f40000, 0xc0f4ffff, REGISTRY_APNIC      }, // 192.244.0.0     - 192.244.255.255
	{ 0xc0f50000, 0xc0f50aff, REGISTRY_ARIN       }, // 192.245.0.0     - 192.245.10.255 
	{ 0xc0f50c00, 0xc0f50cff, REGISTRY_ARIN       }, // 192.245.12.0    - 192.245.12.255 
	{ 0xc0f50d00, 0xc0f50eff, REGISTRY_APNIC      }, // 192.245.13.0    - 192.245.14.255 
	{ 0xc0f50f00, 0xc0f51dff, REGISTRY_ARIN       }, // 192.245.15.0    - 192.245.29.255 
	{ 0xc0f51f00, 0xc0f521ff, REGISTRY_ARIN       }, // 192.245.31.0    - 192.245.33.255 
	{ 0xc0f52400, 0xc0f524ff, REGISTRY_APNIC      }, // 192.245.36.0    - 192.245.36.255 
	{ 0xc0f52500, 0xc0f539ff, REGISTRY_ARIN       }, // 192.245.37.0    - 192.245.57.255 
	{ 0xc0f53a00, 0xc0f53bff, REGISTRY_APNIC      }, // 192.245.58.0    - 192.245.59.255 
	{ 0xc0f53c00, 0xc0f53cff, REGISTRY_LACNIC     }, // 192.245.60.0    - 192.245.60.255 
	{ 0xc0f53d00, 0xc0f548ff, REGISTRY_ARIN       }, // 192.245.61.0    - 192.245.72.255 
	{ 0xc0f55100, 0xc0f55dff, REGISTRY_ARIN       }, // 192.245.81.0    - 192.245.93.255 
	{ 0xc0f55f00, 0xc0f568ff, REGISTRY_ARIN       }, // 192.245.95.0    - 192.245.104.255
	{ 0xc0f56900, 0xc0f570ff, REGISTRY_APNIC      }, // 192.245.105.0   - 192.245.112.255
	{ 0xc0f57100, 0xc0f578ff, REGISTRY_ARIN       }, // 192.245.113.0   - 192.245.120.255
	{ 0xc0f57900, 0xc0f579ff, REGISTRY_LACNIC     }, // 192.245.121.0   - 192.245.121.255
	{ 0xc0f57a00, 0xc0f593ff, REGISTRY_ARIN       }, // 192.245.122.0   - 192.245.147.255
	{ 0xc0f59400, 0xc0f594ff, REGISTRY_AFRINIC    }, // 192.245.148.0   - 192.245.148.255
	{ 0xc0f59500, 0xc0f597ff, REGISTRY_ARIN       }, // 192.245.149.0   - 192.245.151.255
	{ 0xc0f59800, 0xc0f598ff, REGISTRY_RIPENCC    }, // 192.245.152.0   - 192.245.152.255
	{ 0xc0f59900, 0xc0f59aff, REGISTRY_ARIN       }, // 192.245.153.0   - 192.245.154.255
	{ 0xc0f59c00, 0xc0f5a8ff, REGISTRY_ARIN       }, // 192.245.156.0   - 192.245.168.255
	{ 0xc0f5a900, 0xc0f5a9ff, REGISTRY_RIPENCC    }, // 192.245.169.0   - 192.245.169.255
	{ 0xc0f5aa00, 0xc0f5b8ff, REGISTRY_ARIN       }, // 192.245.170.0   - 192.245.184.255
	{ 0xc0f5b900, 0xc0f5b9ff, REGISTRY_APNIC      }, // 192.245.185.0   - 192.245.185.255
	{ 0xc0f5ba00, 0xc0f5bfff, REGISTRY_ARIN       }, // 192.245.186.0   - 192.245.191.255
	{ 0xc0f5c000, 0xc0f5c0ff, REGISTRY_APNIC      }, // 192.245.192.0   - 192.245.192.255
	{ 0xc0f5c100, 0xc0f5c3ff, REGISTRY_ARIN       }, // 192.245.193.0   - 192.245.195.255
	{ 0xc0f5c400, 0xc0f5c4ff, REGISTRY_APNIC      }, // 192.245.196.0   - 192.245.196.255
	{ 0xc0f5c500, 0xc0f5cfff, REGISTRY_ARIN       }, // 192.245.197.0   - 192.245.207.255
	{ 0xc0f5d000, 0xc0f5d0ff, REGISTRY_APNIC      }, // 192.245.208.0   - 192.245.208.255
	{ 0xc0f5d100, 0xc0f5d1ff, REGISTRY_ARIN       }, // 192.245.209.0   - 192.245.209.255
	{ 0xc0f5d200, 0xc0f5d9ff, REGISTRY_APNIC      }, // 192.245.210.0   - 192.245.217.255
	{ 0xc0f5da00, 0xc0f5daff, REGISTRY_ARIN       }, // 192.245.218.0   - 192.245.218.255
	{ 0xc0f5dd00, 0xc0f5e0ff, REGISTRY_ARIN       }, // 192.245.221.0   - 192.245.224.255
	{ 0xc0f5e100, 0xc0f5e1ff, REGISTRY_RIPENCC    }, // 192.245.225.0   - 192.245.225.255
	{ 0xc0f5e200, 0xc0f5f8ff, REGISTRY_ARIN       }, // 192.245.226.0   - 192.245.248.255
	{ 0xc0f5f900, 0xc0f5fbff, REGISTRY_APNIC      }, // 192.245.249.0   - 192.245.251.255
	{ 0xc0f5fc00, 0xc0f700ff, REGISTRY_ARIN       }, // 192.245.252.0   - 192.247.0.255  
	{ 0xc0f70100, 0xc0f70aff, REGISTRY_RIPENCC    }, // 192.247.1.0     - 192.247.10.255 
	{ 0xc0f70b00, 0xc0f7ffff, REGISTRY_ARIN       }, // 192.247.11.0    - 192.247.255.255
	{ 0xc0f80000, 0xc0f87fff, REGISTRY_APNIC      }, // 192.248.0.0     - 192.248.127.255
	{ 0xc0f88000, 0xc0f90fff, REGISTRY_ARIN       }, // 192.248.128.0   - 192.249.15.255 
	{ 0xc0f91000, 0xc0f91fff, REGISTRY_APNIC      }, // 192.249.16.0    - 192.249.31.255 
	{ 0xc0f92000, 0xc0fb26ff, REGISTRY_ARIN       }, // 192.249.32.0    - 192.251.38.255 
	{ 0xc0fb2700, 0xc0fb27ff, REGISTRY_LACNIC     }, // 192.251.39.0    - 192.251.39.255 
	{ 0xc0fb2800, 0xc0fb3cff, REGISTRY_ARIN       }, // 192.251.40.0    - 192.251.60.255 
	{ 0xc0fb3d00, 0xc0fb41ff, REGISTRY_RIPENCC    }, // 192.251.61.0    - 192.251.65.255 
	{ 0xc0fb4200, 0xc0fb93ff, REGISTRY_ARIN       }, // 192.251.66.0    - 192.251.147.255
	{ 0xc0fb9400, 0xc0fb94ff, REGISTRY_APNIC      }, // 192.251.148.0   - 192.251.148.255
	{ 0xc0fb9500, 0xc0fbc2ff, REGISTRY_ARIN       }, // 192.251.149.0   - 192.251.194.255
	{ 0xc0fbc300, 0xc0fbc3ff, REGISTRY_APNIC      }, // 192.251.195.0   - 192.251.195.255
	{ 0xc0fbc400, 0xc0fbc8ff, REGISTRY_ARIN       }, // 192.251.196.0   - 192.251.200.255
	{ 0xc0fbca00, 0xc0fbcaff, REGISTRY_AFRINIC    }, // 192.251.202.0   - 192.251.202.255
	{ 0xc0fbcb00, 0xc0fbcbff, REGISTRY_ARIN       }, // 192.251.203.0   - 192.251.203.255
	{ 0xc0fbcd00, 0xc0fbcfff, REGISTRY_APNIC      }, // 192.251.205.0   - 192.251.207.255
	{ 0xc0fbd000, 0xc0fbe1ff, REGISTRY_ARIN       }, // 192.251.208.0   - 192.251.225.255
	{ 0xc0fbe200, 0xc0fbe2ff, REGISTRY_RIPENCC    }, // 192.251.226.0   - 192.251.226.255
	{ 0xc0fbe700, 0xc0ffffff, REGISTRY_ARIN       }, // 192.251.231.0   - 192.255.255.255
	{ 0xc1000000, 0xc1001fff, REGISTRY_RIPENCC    }, // 193.0.0.0       - 193.0.31.255   
	{ 0xc1002000, 0xc100c7ff, REGISTRY_RIPENCC    }, // 193.0.32.0      - 193.0.199.255  
	{ 0xc100c800, 0xc100cbff, REGISTRY_RIPENCC    }, // 193.0.200.0     - 193.0.203.255  
	{ 0xc100cc00, 0xc100d3ff, REGISTRY_RIPENCC    }, // 193.0.204.0     - 193.0.211.255  
	{ 0xc100d500, 0xc100e2ff, REGISTRY_RIPENCC    }, // 193.0.213.0     - 193.0.226.255  
	{ 0xc100e400, 0xc100e4ff, REGISTRY_RIPENCC    }, // 193.0.228.0     - 193.0.228.255  
	{ 0xc100e700, 0xc100e9ff, REGISTRY_RIPENCC    }, // 193.0.231.0     - 193.0.233.255  
	{ 0xc100ec00, 0xc100eeff, REGISTRY_RIPENCC    }, // 193.0.236.0     - 193.0.238.255  
	{ 0xc100f000, 0xc100f4ff, REGISTRY_RIPENCC    }, // 193.0.240.0     - 193.0.244.255  
	{ 0xc100f600, 0xc100ffff, REGISTRY_RIPENCC    }, // 193.0.246.0     - 193.0.255.255  
	{ 0xc1010000, 0xc106ffff, REGISTRY_RIPENCC    }, // 193.1.0.0       - 193.6.255.255  
	{ 0xc1070000, 0xc1080bff, REGISTRY_RIPENCC    }, // 193.7.0.0       - 193.8.11.255   
	{ 0xc1080e00, 0xc10847ff, REGISTRY_RIPENCC    }, // 193.8.14.0      - 193.8.71.255   
	{ 0xc1084a00, 0xc1084fff, REGISTRY_RIPENCC    }, // 193.8.74.0      - 193.8.79.255   
	{ 0xc1085400, 0xc108a3ff, REGISTRY_RIPENCC    }, // 193.8.84.0      - 193.8.163.255  
	{ 0xc108a500, 0xc108a6ff, REGISTRY_RIPENCC    }, // 193.8.165.0     - 193.8.166.255  
	{ 0xc108a800, 0xc108acff, REGISTRY_RIPENCC    }, // 193.8.168.0     - 193.8.172.255  
	{ 0xc108ae00, 0xc108b9ff, REGISTRY_RIPENCC    }, // 193.8.174.0     - 193.8.185.255  
	{ 0xc108bc00, 0xc108c1ff, REGISTRY_RIPENCC    }, // 193.8.188.0     - 193.8.193.255  
	{ 0xc108c400, 0xc108ccff, REGISTRY_RIPENCC    }, // 193.8.196.0     - 193.8.204.255  
	{ 0xc108ce00, 0xc108ceff, REGISTRY_RIPENCC    }, // 193.8.206.0     - 193.8.206.255  
	{ 0xc108d200, 0xc108d3ff, REGISTRY_RIPENCC    }, // 193.8.210.0     - 193.8.211.255  
	{ 0xc108d500, 0xc108d7ff, REGISTRY_RIPENCC    }, // 193.8.213.0     - 193.8.215.255  
	{ 0xc108da00, 0xc108dbff, REGISTRY_RIPENCC    }, // 193.8.218.0     - 193.8.219.255  
	{ 0xc108de00, 0xc108dfff, REGISTRY_RIPENCC    }, // 193.8.222.0     - 193.8.223.255  
	{ 0xc108e100, 0xc108e2ff, REGISTRY_RIPENCC    }, // 193.8.225.0     - 193.8.226.255  
	{ 0xc108e400, 0xc108e7ff, REGISTRY_RIPENCC    }, // 193.8.228.0     - 193.8.231.255  
	{ 0xc108ea00, 0xc108f8ff, REGISTRY_RIPENCC    }, // 193.8.234.0     - 193.8.248.255  
	{ 0xc108fa00, 0xc108feff, REGISTRY_RIPENCC    }, // 193.8.250.0     - 193.8.254.255  
	{ 0xc1090000, 0xc1092fff, REGISTRY_RIPENCC    }, // 193.9.0.0       - 193.9.47.255   
	{ 0xc1094000, 0xc1096fff, REGISTRY_RIPENCC    }, // 193.9.64.0      - 193.9.111.255  
	{ 0xc1097800, 0xc109feff, REGISTRY_RIPENCC    }, // 193.9.120.0     - 193.9.254.255  
	{ 0xc10a0000, 0xc10fffff, REGISTRY_RIPENCC    }, // 193.10.0.0      - 193.15.255.255 
	{ 0xc1100100, 0xc11001ff, REGISTRY_RIPENCC    }, // 193.16.1.0      - 193.16.1.255   
	{ 0xc1100300, 0xc11007ff, REGISTRY_RIPENCC    }, // 193.16.3.0      - 193.16.7.255   
	{ 0xc1100c00, 0xc1100dff, REGISTRY_RIPENCC    }, // 193.16.12.0     - 193.16.13.255  
	{ 0xc1101000, 0xc1101fff, REGISTRY_RIPENCC    }, // 193.16.16.0     - 193.16.31.255  
	{ 0xc1102b00, 0xc11069ff, REGISTRY_RIPENCC    }, // 193.16.43.0     - 193.16.105.255 
	{ 0xc1106b00, 0xc1106dff, REGISTRY_RIPENCC    }, // 193.16.107.0    - 193.16.109.255 
	{ 0xc1106f00, 0xc1108fff, REGISTRY_RIPENCC    }, // 193.16.111.0    - 193.16.143.255 
	{ 0xc1109200, 0xc1109bff, REGISTRY_RIPENCC    }, // 193.16.146.0    - 193.16.155.255 
	{ 0xc1109d00, 0xc110d4ff, REGISTRY_RIPENCC    }, // 193.16.157.0    - 193.16.212.255 
	{ 0xc110d600, 0xc110dcff, REGISTRY_RIPENCC    }, // 193.16.214.0    - 193.16.220.255 
	{ 0xc110de00, 0xc110ebff, REGISTRY_RIPENCC    }, // 193.16.222.0    - 193.16.235.255 
	{ 0xc110ed00, 0xc110eeff, REGISTRY_RIPENCC    }, // 193.16.237.0    - 193.16.238.255 
	{ 0xc110f000, 0xc11103ff, REGISTRY_RIPENCC    }, // 193.16.240.0    - 193.17.3.255   
	{ 0xc1110600, 0xc11106ff, REGISTRY_RIPENCC    }, // 193.17.6.0      - 193.17.6.255   
	{ 0xc1110800, 0xc1110eff, REGISTRY_RIPENCC    }, // 193.17.8.0      - 193.17.14.255  
	{ 0xc1111000, 0xc11119ff, REGISTRY_RIPENCC    }, // 193.17.16.0     - 193.17.25.255  
	{ 0xc1111b00, 0xc1111bff, REGISTRY_RIPENCC    }, // 193.17.27.0     - 193.17.27.255  
	{ 0xc1112000, 0xc11127ff, REGISTRY_RIPENCC    }, // 193.17.32.0     - 193.17.39.255  
	{ 0xc1112900, 0xc11136ff, REGISTRY_RIPENCC    }, // 193.17.41.0     - 193.17.54.255  
	{ 0xc1113c00, 0xc1113fff, REGISTRY_RIPENCC    }, // 193.17.60.0     - 193.17.63.255  
	{ 0xc1114100, 0xc11145ff, REGISTRY_RIPENCC    }, // 193.17.65.0     - 193.17.69.255  
	{ 0xc1114700, 0xc1114fff, REGISTRY_RIPENCC    }, // 193.17.71.0     - 193.17.79.255  
	{ 0xc1115400, 0xc1115fff, REGISTRY_RIPENCC    }, // 193.17.84.0     - 193.17.95.255  
	{ 0xc1116000, 0xc1117fff, REGISTRY_RIPENCC    }, // 193.17.96.0     - 193.17.127.255 
	{ 0xc1118000, 0xc111b3ff, REGISTRY_RIPENCC    }, // 193.17.128.0    - 193.17.179.255 
	{ 0xc111b800, 0xc111bbff, REGISTRY_RIPENCC    }, // 193.17.184.0    - 193.17.187.255 
	{ 0xc111c000, 0xc111c0ff, REGISTRY_RIPENCC    }, // 193.17.192.0    - 193.17.192.255 
	{ 0xc111c200, 0xc111d6ff, REGISTRY_RIPENCC    }, // 193.17.194.0    - 193.17.214.255 
	{ 0xc111d800, 0xc111dbff, REGISTRY_RIPENCC    }, // 193.17.216.0    - 193.17.219.255 
	{ 0xc111dd00, 0xc111dfff, REGISTRY_RIPENCC    }, // 193.17.221.0    - 193.17.223.255 
	{ 0xc111e100, 0xc111e3ff, REGISTRY_RIPENCC    }, // 193.17.225.0    - 193.17.227.255 
	{ 0xc111e500, 0xc111e6ff, REGISTRY_RIPENCC    }, // 193.17.229.0    - 193.17.230.255 
	{ 0xc111e800, 0xc111fcff, REGISTRY_RIPENCC    }, // 193.17.232.0    - 193.17.252.255 
	{ 0xc111fe00, 0xc111feff, REGISTRY_RIPENCC    }, // 193.17.254.0    - 193.17.254.255 
	{ 0xc1120000, 0xc11347ff, REGISTRY_RIPENCC    }, // 193.18.0.0      - 193.19.71.255  
	{ 0xc1134a00, 0xc1135fff, REGISTRY_RIPENCC    }, // 193.19.74.0     - 193.19.95.255  
	{ 0xc1136200, 0xc11369ff, REGISTRY_RIPENCC    }, // 193.19.98.0     - 193.19.105.255 
	{ 0xc1136c00, 0xc1137fff, REGISTRY_RIPENCC    }, // 193.19.108.0    - 193.19.127.255 
	{ 0xc1138400, 0xc11393ff, REGISTRY_RIPENCC    }, // 193.19.132.0    - 193.19.147.255 
	{ 0xc1139800, 0xc113c7ff, REGISTRY_RIPENCC    }, // 193.19.152.0    - 193.19.199.255 
	{ 0xc113d000, 0xc113dfff, REGISTRY_RIPENCC    }, // 193.19.208.0    - 193.19.223.255 
	{ 0xc113e000, 0xc113e3ff, REGISTRY_RIPENCC    }, // 193.19.224.0    - 193.19.227.255 
	{ 0xc113e400, 0xc113e7ff, REGISTRY_RIPENCC    }, // 193.19.228.0    - 193.19.231.255 
	{ 0xc113e800, 0xc113ebff, REGISTRY_AFRINIC    }, // 193.19.232.0    - 193.19.235.255 
	{ 0xc113ec00, 0xc113f7ff, REGISTRY_RIPENCC    }, // 193.19.236.0    - 193.19.247.255 
	{ 0xc113fc00, 0xc11600ff, REGISTRY_RIPENCC    }, // 193.19.252.0    - 193.22.0.255   
	{ 0xc1160200, 0xc11613ff, REGISTRY_RIPENCC    }, // 193.22.2.0      - 193.22.19.255  
	{ 0xc1161800, 0xc1164fff, REGISTRY_RIPENCC    }, // 193.22.24.0     - 193.22.79.255  
	{ 0xc1165100, 0xc11655ff, REGISTRY_RIPENCC    }, // 193.22.81.0     - 193.22.85.255  
	{ 0xc1165700, 0xc11667ff, REGISTRY_RIPENCC    }, // 193.22.87.0     - 193.22.103.255 
	{ 0xc1166b00, 0xc1166bff, REGISTRY_RIPENCC    }, // 193.22.107.0    - 193.22.107.255 
	{ 0xc1166d00, 0xc1167fff, REGISTRY_RIPENCC    }, // 193.22.109.0    - 193.22.127.255 
	{ 0xc1168c00, 0xc1168cff, REGISTRY_RIPENCC    }, // 193.22.140.0    - 193.22.140.255 
	{ 0xc1168e00, 0xc116a7ff, REGISTRY_RIPENCC    }, // 193.22.142.0    - 193.22.167.255 
	{ 0xc116a900, 0xc116a9ff, REGISTRY_RIPENCC    }, // 193.22.169.0    - 193.22.169.255 
	{ 0xc116ab00, 0xc116dfff, REGISTRY_RIPENCC    }, // 193.22.171.0    - 193.22.223.255 
	{ 0xc116f000, 0xc116f3ff, REGISTRY_RIPENCC    }, // 193.22.240.0    - 193.22.243.255 
	{ 0xc116f500, 0xc11703ff, REGISTRY_RIPENCC    }, // 193.22.245.0    - 193.23.3.255   
	{ 0xc1170800, 0xc1170fff, REGISTRY_RIPENCC    }, // 193.23.8.0      - 193.23.15.255  
	{ 0xc1172000, 0xc1172dff, REGISTRY_RIPENCC    }, // 193.23.32.0     - 193.23.45.255  
	{ 0xc1173000, 0xc11731ff, REGISTRY_RIPENCC    }, // 193.23.48.0     - 193.23.49.255  
	{ 0xc1173300, 0xc11736ff, REGISTRY_RIPENCC    }, // 193.23.51.0     - 193.23.54.255  
	{ 0xc1173800, 0xc1173bff, REGISTRY_RIPENCC    }, // 193.23.56.0     - 193.23.59.255  
	{ 0xc1173d00, 0xc11775ff, REGISTRY_RIPENCC    }, // 193.23.61.0     - 193.23.117.255 
	{ 0xc1177700, 0xc1177eff, REGISTRY_RIPENCC    }, // 193.23.119.0    - 193.23.126.255 
	{ 0xc1178000, 0xc11784ff, REGISTRY_RIPENCC    }, // 193.23.128.0    - 193.23.132.255 
	{ 0xc1178600, 0xc11786ff, REGISTRY_RIPENCC    }, // 193.23.134.0    - 193.23.134.255 
	{ 0xc1178800, 0xc1179fff, REGISTRY_RIPENCC    }, // 193.23.136.0    - 193.23.159.255 
	{ 0xc117a100, 0xc117a3ff, REGISTRY_RIPENCC    }, // 193.23.161.0    - 193.23.163.255 
	{ 0xc117a600, 0xc117acff, REGISTRY_RIPENCC    }, // 193.23.166.0    - 193.23.172.255 
	{ 0xc117ae00, 0xc117afff, REGISTRY_RIPENCC    }, // 193.23.174.0    - 193.23.175.255 
	{ 0xc117b400, 0xc117f4ff, REGISTRY_RIPENCC    }, // 193.23.180.0    - 193.23.244.255 
	{ 0xc117f800, 0xc117f8ff, REGISTRY_RIPENCC    }, // 193.23.248.0    - 193.23.248.255 
	{ 0xc117fa00, 0xc117fcff, REGISTRY_RIPENCC    }, // 193.23.250.0    - 193.23.252.255 
	{ 0xc117fe00, 0xc117ffff, REGISTRY_RIPENCC    }, // 193.23.254.0    - 193.23.255.255 
	{ 0xc1180200, 0xc11802ff, REGISTRY_RIPENCC    }, // 193.24.2.0      - 193.24.2.255   
	{ 0xc1180400, 0xc11804ff, REGISTRY_RIPENCC    }, // 193.24.4.0      - 193.24.4.255   
	{ 0xc1180600, 0xc1180cff, REGISTRY_RIPENCC    }, // 193.24.6.0      - 193.24.12.255  
	{ 0xc1180e00, 0xc1181eff, REGISTRY_RIPENCC    }, // 193.24.14.0     - 193.24.30.255  
	{ 0xc1182000, 0xc11823ff, REGISTRY_RIPENCC    }, // 193.24.32.0     - 193.24.35.255  
	{ 0xc1182500, 0xc11825ff, REGISTRY_RIPENCC    }, // 193.24.37.0     - 193.24.37.255  
	{ 0xc1183000, 0xc118d3ff, REGISTRY_RIPENCC    }, // 193.24.48.0     - 193.24.211.255 
	{ 0xc118d800, 0xc118e3ff, REGISTRY_RIPENCC    }, // 193.24.216.0    - 193.24.227.255 
	{ 0xc118ec00, 0xc1195fff, REGISTRY_RIPENCC    }, // 193.24.236.0    - 193.25.95.255  
	{ 0xc1196200, 0xc11969ff, REGISTRY_RIPENCC    }, // 193.25.98.0     - 193.25.105.255 
	{ 0xc1196e00, 0xc11979ff, REGISTRY_RIPENCC    }, // 193.25.110.0    - 193.25.121.255 
	{ 0xc1197c00, 0xc119bbff, REGISTRY_RIPENCC    }, // 193.25.124.0    - 193.25.187.255 
	{ 0xc119be00, 0xc119c1ff, REGISTRY_RIPENCC    }, // 193.25.190.0    - 193.25.193.255 
	{ 0xc119c300, 0xc119c3ff, REGISTRY_RIPENCC    }, // 193.25.195.0    - 193.25.195.255 
	{ 0xc119c500, 0xc119d1ff, REGISTRY_RIPENCC    }, // 193.25.197.0    - 193.25.209.255 
	{ 0xc119d400, 0xc119d5ff, REGISTRY_RIPENCC    }, // 193.25.212.0    - 193.25.213.255 
	{ 0xc119dc00, 0xc119deff, REGISTRY_RIPENCC    }, // 193.25.220.0    - 193.25.222.255 
	{ 0xc119e000, 0xc119f7ff, REGISTRY_RIPENCC    }, // 193.25.224.0    - 193.25.247.255 
	{ 0xc119fe00, 0xc119feff, REGISTRY_RIPENCC    }, // 193.25.254.0    - 193.25.254.255 
	{ 0xc11a0100, 0xc11a01ff, REGISTRY_RIPENCC    }, // 193.26.1.0      - 193.26.1.255   
	{ 0xc11a0300, 0xc11a0bff, REGISTRY_RIPENCC    }, // 193.26.3.0      - 193.26.11.255  
	{ 0xc11a0d00, 0xc11a0dff, REGISTRY_RIPENCC    }, // 193.26.13.0     - 193.26.13.255  
	{ 0xc11a0f00, 0xc11a14ff, REGISTRY_RIPENCC    }, // 193.26.15.0     - 193.26.20.255  
	{ 0xc11a1700, 0xc11a79ff, REGISTRY_RIPENCC    }, // 193.26.23.0     - 193.26.121.255 
	{ 0xc11a7b00, 0xc11a7eff, REGISTRY_RIPENCC    }, // 193.26.123.0    - 193.26.126.255 
	{ 0xc11a8000, 0xc11a84ff, REGISTRY_RIPENCC    }, // 193.26.128.0    - 193.26.132.255 
	{ 0xc11a8600, 0xc11acfff, REGISTRY_RIPENCC    }, // 193.26.134.0    - 193.26.207.255 
	{ 0xc11ad100, 0xc11ad1ff, REGISTRY_RIPENCC    }, // 193.26.209.0    - 193.26.209.255 
	{ 0xc11ad600, 0xc11ad6ff, REGISTRY_RIPENCC    }, // 193.26.214.0    - 193.26.214.255 
	{ 0xc11ad800, 0xc11adaff, REGISTRY_RIPENCC    }, // 193.26.216.0    - 193.26.218.255 
	{ 0xc11adc00, 0xc11adeff, REGISTRY_RIPENCC    }, // 193.26.220.0    - 193.26.222.255 
	{ 0xc11ae000, 0xc11b07ff, REGISTRY_RIPENCC    }, // 193.26.224.0    - 193.27.7.255   
	{ 0xc11b0900, 0xc11b09ff, REGISTRY_RIPENCC    }, // 193.27.9.0      - 193.27.9.255   
	{ 0xc11b0b00, 0xc11b0bff, REGISTRY_RIPENCC    }, // 193.27.11.0     - 193.27.11.255  
	{ 0xc11b1100, 0xc11b12ff, REGISTRY_RIPENCC    }, // 193.27.17.0     - 193.27.18.255  
	{ 0xc11b1400, 0xc11b16ff, REGISTRY_RIPENCC    }, // 193.27.20.0     - 193.27.22.255  
	{ 0xc11b1800, 0xc11b18ff, REGISTRY_RIPENCC    }, // 193.27.24.0     - 193.27.24.255  
	{ 0xc11b1a00, 0xc11b2cff, REGISTRY_RIPENCC    }, // 193.27.26.0     - 193.27.44.255  
	{ 0xc11b2e00, 0xc11b4bff, REGISTRY_RIPENCC    }, // 193.27.46.0     - 193.27.75.255  
	{ 0xc11b4e00, 0xc11bdfff, REGISTRY_RIPENCC    }, // 193.27.78.0     - 193.27.223.255 
	{ 0xc11be200, 0xc11be3ff, REGISTRY_RIPENCC    }, // 193.27.226.0    - 193.27.227.255 
	{ 0xc11be600, 0xc11be7ff, REGISTRY_RIPENCC    }, // 193.27.230.0    - 193.27.231.255 
	{ 0xc11bec00, 0xc11bf5ff, REGISTRY_RIPENCC    }, // 193.27.236.0    - 193.27.245.255 
	{ 0xc11bfa00, 0xc11c00ff, REGISTRY_RIPENCC    }, // 193.27.250.0    - 193.28.0.255   
	{ 0xc11c0500, 0xc11c0dff, REGISTRY_RIPENCC    }, // 193.28.5.0      - 193.28.13.255  
	{ 0xc11c0f00, 0xc11c23ff, REGISTRY_RIPENCC    }, // 193.28.15.0     - 193.28.35.255  
	{ 0xc11c2800, 0xc11c2aff, REGISTRY_RIPENCC    }, // 193.28.40.0     - 193.28.42.255  
	{ 0xc11c2c00, 0xc11c32ff, REGISTRY_RIPENCC    }, // 193.28.44.0     - 193.28.50.255  
	{ 0xc11c3400, 0xc11c35ff, REGISTRY_RIPENCC    }, // 193.28.52.0     - 193.28.53.255  
	{ 0xc11c3700, 0xc11c38ff, REGISTRY_RIPENCC    }, // 193.28.55.0     - 193.28.56.255  
	{ 0xc11c3d00, 0xc11c3dff, REGISTRY_RIPENCC    }, // 193.28.61.0     - 193.28.61.255  
	{ 0xc11c3f00, 0xc11c5cff, REGISTRY_RIPENCC    }, // 193.28.63.0     - 193.28.92.255  
	{ 0xc11c5e00, 0xc11c8fff, REGISTRY_RIPENCC    }, // 193.28.94.0     - 193.28.143.255 
	{ 0xc11c9100, 0xc11c93ff, REGISTRY_RIPENCC    }, // 193.28.145.0    - 193.28.147.255 
	{ 0xc11c9500, 0xc11cb5ff, REGISTRY_RIPENCC    }, // 193.28.149.0    - 193.28.181.255 
	{ 0xc11cb700, 0xc11cbeff, REGISTRY_RIPENCC    }, // 193.28.183.0    - 193.28.190.255 
	{ 0xc11cc000, 0xc11cc9ff, REGISTRY_RIPENCC    }, // 193.28.192.0    - 193.28.201.255 
	{ 0xc11ccb00, 0xc11cdbff, REGISTRY_RIPENCC    }, // 193.28.203.0    - 193.28.219.255 
	{ 0xc11ce000, 0xc11cecff, REGISTRY_RIPENCC    }, // 193.28.224.0    - 193.28.236.255 
	{ 0xc11cee00, 0xc11cfbff, REGISTRY_RIPENCC    }, // 193.28.238.0    - 193.28.251.255 
	{ 0xc11cfd00, 0xc11cfeff, REGISTRY_RIPENCC    }, // 193.28.253.0    - 193.28.254.255 
	{ 0xc11d0000, 0xc11d00ff, REGISTRY_RIPENCC    }, // 193.29.0.0      - 193.29.0.255   
	{ 0xc11d0200, 0xc11d03ff, REGISTRY_RIPENCC    }, // 193.29.2.0      - 193.29.3.255   
	{ 0xc11d0500, 0xc11d05ff, REGISTRY_RIPENCC    }, // 193.29.5.0      - 193.29.5.255   
	{ 0xc11d0700, 0xc11d07ff, REGISTRY_RIPENCC    }, // 193.29.7.0      - 193.29.7.255   
	{ 0xc11d0900, 0xc11d09ff, REGISTRY_RIPENCC    }, // 193.29.9.0      - 193.29.9.255   
	{ 0xc11d0b00, 0xc11d0dff, REGISTRY_RIPENCC    }, // 193.29.11.0     - 193.29.13.255  
	{ 0xc11d1000, 0xc11d11ff, REGISTRY_RIPENCC    }, // 193.29.16.0     - 193.29.17.255  
	{ 0xc11d1300, 0xc11d14ff, REGISTRY_RIPENCC    }, // 193.29.19.0     - 193.29.20.255  
	{ 0xc11d1600, 0xc11d19ff, REGISTRY_RIPENCC    }, // 193.29.22.0     - 193.29.25.255  
	{ 0xc11d1b00, 0xc11d1fff, REGISTRY_RIPENCC    }, // 193.29.27.0     - 193.29.31.255  
	{ 0xc11d2600, 0xc11d29ff, REGISTRY_RIPENCC    }, // 193.29.38.0     - 193.29.41.255  
	{ 0xc11d2b00, 0xc11d37ff, REGISTRY_RIPENCC    }, // 193.29.43.0     - 193.29.55.255  
	{ 0xc11d4000, 0xc11d7fff, REGISTRY_RIPENCC    }, // 193.29.64.0     - 193.29.127.255 
	{ 0xc11d8200, 0xc11db0ff, REGISTRY_RIPENCC    }, // 193.29.130.0    - 193.29.176.255 
	{ 0xc11db200, 0xc11db3ff, REGISTRY_RIPENCC    }, // 193.29.178.0    - 193.29.179.255 
	{ 0xc11dba00, 0xc11dbcff, REGISTRY_RIPENCC    }, // 193.29.186.0    - 193.29.188.255 
	{ 0xc11dbf00, 0xc11ddfff, REGISTRY_RIPENCC    }, // 193.29.191.0    - 193.29.223.255 
	{ 0xc11de200, 0xc11de5ff, REGISTRY_RIPENCC    }, // 193.29.226.0    - 193.29.229.255 
	{ 0xc11de800, 0xc11df7ff, REGISTRY_RIPENCC    }, // 193.29.232.0    - 193.29.247.255 
	{ 0xc11dfa00, 0xc11dfdff, REGISTRY_RIPENCC    }, // 193.29.250.0    - 193.29.253.255 
	{ 0xc11dff00, 0xc11e00ff, REGISTRY_RIPENCC    }, // 193.29.255.0    - 193.30.0.255   
	{ 0xc11e0300, 0xc11e04ff, REGISTRY_RIPENCC    }, // 193.30.3.0      - 193.30.4.255   
	{ 0xc11e0700, 0xc11e0bff, REGISTRY_RIPENCC    }, // 193.30.7.0      - 193.30.11.255  
	{ 0xc11e1000, 0xc11e14ff, REGISTRY_RIPENCC    }, // 193.30.16.0     - 193.30.20.255  
	{ 0xc11e1600, 0xc11e20ff, REGISTRY_RIPENCC    }, // 193.30.22.0     - 193.30.32.255  
	{ 0xc11e2200, 0xc11e22ff, REGISTRY_RIPENCC    }, // 193.30.34.0     - 193.30.34.255  
	{ 0xc11e2400, 0xc11e27ff, REGISTRY_RIPENCC    }, // 193.30.36.0     - 193.30.39.255  
	{ 0xc11e2900, 0xc11e2aff, REGISTRY_RIPENCC    }, // 193.30.41.0     - 193.30.42.255  
	{ 0xc11e2c00, 0xc11e57ff, REGISTRY_RIPENCC    }, // 193.30.44.0     - 193.30.87.255  
	{ 0xc11e5900, 0xc11e59ff, REGISTRY_RIPENCC    }, // 193.30.89.0     - 193.30.89.255  
	{ 0xc11e5d00, 0xc11e5dff, REGISTRY_RIPENCC    }, // 193.30.93.0     - 193.30.93.255  
	{ 0xc11e6000, 0xc11e6cff, REGISTRY_RIPENCC    }, // 193.30.96.0     - 193.30.108.255 
	{ 0xc11e6e00, 0xc11e70ff, REGISTRY_RIPENCC    }, // 193.30.110.0    - 193.30.112.255 
	{ 0xc11e7600, 0xc11e77ff, REGISTRY_RIPENCC    }, // 193.30.118.0    - 193.30.119.255 
	{ 0xc11e7e00, 0xc11e85ff, REGISTRY_RIPENCC    }, // 193.30.126.0    - 193.30.133.255 
	{ 0xc11e8700, 0xc11ea1ff, REGISTRY_RIPENCC    }, // 193.30.135.0    - 193.30.161.255 
	{ 0xc11ea300, 0xc11ea4ff, REGISTRY_RIPENCC    }, // 193.30.163.0    - 193.30.164.255 
	{ 0xc11ea700, 0xc11f03ff, REGISTRY_RIPENCC    }, // 193.30.167.0    - 193.31.3.255   
	{ 0xc11f0700, 0xc11f0bff, REGISTRY_RIPENCC    }, // 193.31.7.0      - 193.31.11.255  
	{ 0xc11f0e00, 0xc11f0eff, REGISTRY_RIPENCC    }, // 193.31.14.0     - 193.31.14.255  
	{ 0xc11f1200, 0xc11f13ff, REGISTRY_RIPENCC    }, // 193.31.18.0     - 193.31.19.255  
	{ 0xc11f1500, 0xc11f17ff, REGISTRY_RIPENCC    }, // 193.31.21.0     - 193.31.23.255  
	{ 0xc11f2000, 0xc11f37ff, REGISTRY_RIPENCC    }, // 193.31.32.0     - 193.31.55.255  
	{ 0xc11f3d00, 0xc11f3dff, REGISTRY_RIPENCC    }, // 193.31.61.0     - 193.31.61.255  
	{ 0xc11f3f00, 0xc11ff7ff, REGISTRY_RIPENCC    }, // 193.31.63.0     - 193.31.247.255 
	{ 0xc11ffc00, 0xc11ffdff, REGISTRY_RIPENCC    }, // 193.31.252.0    - 193.31.253.255 
	{ 0xc1200200, 0xc12003ff, REGISTRY_RIPENCC    }, // 193.32.2.0      - 193.32.3.255   
	{ 0xc1200600, 0xc12007ff, REGISTRY_RIPENCC    }, // 193.32.6.0      - 193.32.7.255   
	{ 0xc1200900, 0xc12009ff, REGISTRY_RIPENCC    }, // 193.32.9.0      - 193.32.9.255   
	{ 0xc1200c00, 0xc1200fff, REGISTRY_RIPENCC    }, // 193.32.12.0     - 193.32.15.255  
	{ 0xc1201100, 0xc12027ff, REGISTRY_RIPENCC    }, // 193.32.17.0     - 193.32.39.255  
	{ 0xc1202900, 0xc12053ff, REGISTRY_RIPENCC    }, // 193.32.41.0     - 193.32.83.255  
	{ 0xc1205800, 0xc1205bff, REGISTRY_RIPENCC    }, // 193.32.88.0     - 193.32.91.255  
	{ 0xc1206400, 0xc12067ff, REGISTRY_RIPENCC    }, // 193.32.100.0    - 193.32.103.255 
	{ 0xc1206900, 0xc1206dff, REGISTRY_RIPENCC    }, // 193.32.105.0    - 193.32.109.255 
	{ 0xc1206f00, 0xc12071ff, REGISTRY_RIPENCC    }, // 193.32.111.0    - 193.32.113.255 
	{ 0xc1207600, 0xc1207fff, REGISTRY_RIPENCC    }, // 193.32.118.0    - 193.32.127.255 
	{ 0xc120a200, 0xc120a5ff, REGISTRY_RIPENCC    }, // 193.32.162.0    - 193.32.165.255 
	{ 0xc120d200, 0xc120d3ff, REGISTRY_RIPENCC    }, // 193.32.210.0    - 193.32.211.255 
	{ 0xc120f100, 0xc120f1ff, REGISTRY_RIPENCC    }, // 193.32.241.0    - 193.32.241.255 
	{ 0xc120fa00, 0xc12105ff, REGISTRY_RIPENCC    }, // 193.32.250.0    - 193.33.5.255   
	{ 0xc1210800, 0xc12127ff, REGISTRY_RIPENCC    }, // 193.33.8.0      - 193.33.39.255  
	{ 0xc1212a00, 0xc12141ff, REGISTRY_RIPENCC    }, // 193.33.42.0     - 193.33.65.255  
	{ 0xc1214400, 0xc12155ff, REGISTRY_RIPENCC    }, // 193.33.68.0     - 193.33.85.255  
	{ 0xc1215800, 0xc12169ff, REGISTRY_RIPENCC    }, // 193.33.88.0     - 193.33.105.255 
	{ 0xc1216c00, 0xc1216fff, REGISTRY_RIPENCC    }, // 193.33.108.0    - 193.33.111.255 
	{ 0xc1217200, 0xc12181ff, REGISTRY_RIPENCC    }, // 193.33.114.0    - 193.33.129.255 
	{ 0xc1218400, 0xc12187ff, REGISTRY_RIPENCC    }, // 193.33.132.0    - 193.33.135.255 
	{ 0xc1218a00, 0xc1218bff, REGISTRY_RIPENCC    }, // 193.33.138.0    - 193.33.139.255 
	{ 0xc1218e00, 0xc121a1ff, REGISTRY_RIPENCC    }, // 193.33.142.0    - 193.33.161.255 
	{ 0xc121a600, 0xc121cbff, REGISTRY_RIPENCC    }, // 193.33.166.0    - 193.33.203.255 
	{ 0xc121ce00, 0xc121f1ff, REGISTRY_RIPENCC    }, // 193.33.206.0    - 193.33.241.255 
	{ 0xc121f400, 0xc121fbff, REGISTRY_RIPENCC    }, // 193.33.244.0    - 193.33.251.255 
	{ 0xc121fe00, 0xc1224bff, REGISTRY_RIPENCC    }, // 193.33.254.0    - 193.34.75.255  
	{ 0xc1225000, 0xc12273ff, REGISTRY_RIPENCC    }, // 193.34.80.0     - 193.34.115.255 
	{ 0xc1227400, 0xc12277ff, REGISTRY_RIPENCC    }, // 193.34.116.0    - 193.34.119.255 
	{ 0xc1227800, 0xc122c17f, REGISTRY_RIPENCC    }, // 193.34.120.0    - 193.34.193.127 
	{ 0xc122c280, 0xc122c97f, REGISTRY_RIPENCC    }, // 193.34.194.128  - 193.34.201.127 
	{ 0xc122ca00, 0xc122e3ff, REGISTRY_RIPENCC    }, // 193.34.202.0    - 193.34.227.255 
	{ 0xc122e600, 0xc122efff, REGISTRY_RIPENCC    }, // 193.34.230.0    - 193.34.239.255 
	{ 0xc122f800, 0xc12300ff, REGISTRY_RIPENCC    }, // 193.34.248.0    - 193.35.0.255   
	{ 0xc1230400, 0xc1230eff, REGISTRY_RIPENCC    }, // 193.35.4.0      - 193.35.14.255  
	{ 0xc1231900, 0xc12319ff, REGISTRY_RIPENCC    }, // 193.35.25.0     - 193.35.25.255  
	{ 0xc1232000, 0xc12393ff, REGISTRY_RIPENCC    }, // 193.35.32.0     - 193.35.147.255 
	{ 0xc1239d00, 0xc123ceff, REGISTRY_RIPENCC    }, // 193.35.157.0    - 193.35.206.255 
	{ 0xc123d100, 0xc123d5ff, REGISTRY_RIPENCC    }, // 193.35.209.0    - 193.35.213.255 
	{ 0xc123d800, 0xc123d9ff, REGISTRY_RIPENCC    }, // 193.35.216.0    - 193.35.217.255 
	{ 0xc123dc00, 0xc123dfff, REGISTRY_RIPENCC    }, // 193.35.220.0    - 193.35.223.255 
	{ 0xc123e800, 0xc12402ff, REGISTRY_RIPENCC    }, // 193.35.232.0    - 193.36.2.255   
	{ 0xc1240400, 0xc1242fff, REGISTRY_RIPENCC    }, // 193.36.4.0      - 193.36.47.255  
	{ 0xc1244000, 0xc12447ff, REGISTRY_RIPENCC    }, // 193.36.64.0     - 193.36.71.255  
	{ 0xc1244900, 0xc12457ff, REGISTRY_RIPENCC    }, // 193.36.73.0     - 193.36.87.255  
	{ 0xc1246000, 0xc1247fff, REGISTRY_RIPENCC    }, // 193.36.96.0     - 193.36.127.255 
	{ 0xc1248200, 0xc12483ff, REGISTRY_RIPENCC    }, // 193.36.130.0    - 193.36.131.255 
	{ 0xc1248500, 0xc12485ff, REGISTRY_RIPENCC    }, // 193.36.133.0    - 193.36.133.255 
	{ 0xc1248800, 0xc1248fff, REGISTRY_RIPENCC    }, // 193.36.136.0    - 193.36.143.255 
	{ 0xc1249800, 0xc124a1ff, REGISTRY_RIPENCC    }, // 193.36.152.0    - 193.36.161.255 
	{ 0xc124a400, 0xc124abff, REGISTRY_RIPENCC    }, // 193.36.164.0    - 193.36.171.255 
	{ 0xc124ad00, 0xc124adff, REGISTRY_RIPENCC    }, // 193.36.173.0    - 193.36.173.255 
	{ 0xc124b000, 0xc124b2ff, REGISTRY_RIPENCC    }, // 193.36.176.0    - 193.36.178.255 
	{ 0xc124b600, 0xc124b8ff, REGISTRY_RIPENCC    }, // 193.36.182.0    - 193.36.184.255 
	{ 0xc124ba00, 0xc124dfff, REGISTRY_RIPENCC    }, // 193.36.186.0    - 193.36.223.255 
	{ 0xc124e200, 0xc124e2ff, REGISTRY_RIPENCC    }, // 193.36.226.0    - 193.36.226.255 
	{ 0xc124e500, 0xc124e7ff, REGISTRY_RIPENCC    }, // 193.36.229.0    - 193.36.231.255 
	{ 0xc124f000, 0xc1251fff, REGISTRY_RIPENCC    }, // 193.36.240.0    - 193.37.31.255  
	{ 0xc1252300, 0xc12527ff, REGISTRY_RIPENCC    }, // 193.37.35.0     - 193.37.39.255  
	{ 0xc1252c00, 0xc1252cff, REGISTRY_RIPENCC    }, // 193.37.44.0     - 193.37.44.255  
	{ 0xc1252e00, 0xc1252eff, REGISTRY_RIPENCC    }, // 193.37.46.0     - 193.37.46.255  
	{ 0xc1253000, 0xc1253fff, REGISTRY_RIPENCC    }, // 193.37.48.0     - 193.37.63.255  
	{ 0xc1255800, 0xc1256bff, REGISTRY_RIPENCC    }, // 193.37.88.0     - 193.37.107.255 
	{ 0xc1257000, 0xc1259aff, REGISTRY_RIPENCC    }, // 193.37.112.0    - 193.37.154.255 
	{ 0xc1259c00, 0xc125bfff, REGISTRY_RIPENCC    }, // 193.37.156.0    - 193.37.191.255 
	{ 0xc125e100, 0xc125e1ff, REGISTRY_RIPENCC    }, // 193.37.225.0    - 193.37.225.255 
	{ 0xc125e300, 0xc125e5ff, REGISTRY_RIPENCC    }, // 193.37.227.0    - 193.37.229.255 
	{ 0xc125ea00, 0xc1261fff, REGISTRY_RIPENCC    }, // 193.37.234.0    - 193.38.31.255  
	{ 0xc1262800, 0xc1262bff, REGISTRY_RIPENCC    }, // 193.38.40.0     - 193.38.43.255  
	{ 0xc1262f00, 0xc12631ff, REGISTRY_RIPENCC    }, // 193.38.47.0     - 193.38.49.255  
	{ 0xc1263400, 0xc12634ff, REGISTRY_RIPENCC    }, // 193.38.52.0     - 193.38.52.255  
	{ 0xc1263800, 0xc12682ff, REGISTRY_RIPENCC    }, // 193.38.56.0     - 193.38.130.255 
	{ 0xc1268500, 0xc12685ff, REGISTRY_RIPENCC    }, // 193.38.133.0    - 193.38.133.255 
	{ 0xc1268c00, 0xc1268fff, REGISTRY_RIPENCC    }, // 193.38.140.0    - 193.38.143.255 
	{ 0xc126a000, 0xc126dfff, REGISTRY_RIPENCC    }, // 193.38.160.0    - 193.38.223.255 
	{ 0xc1270000, 0xc12709ff, REGISTRY_RIPENCC    }, // 193.39.0.0      - 193.39.9.255   
	{ 0xc1270b00, 0xc1270eff, REGISTRY_RIPENCC    }, // 193.39.11.0     - 193.39.14.255  
	{ 0xc1271000, 0xc1275cff, REGISTRY_RIPENCC    }, // 193.39.16.0     - 193.39.92.255  
	{ 0xc1275e00, 0xc1279fff, REGISTRY_RIPENCC    }, // 193.39.94.0     - 193.39.159.255 
	{ 0xc127ac00, 0xc127b7ff, REGISTRY_RIPENCC    }, // 193.39.172.0    - 193.39.183.255 
	{ 0xc127c800, 0xc127cfff, REGISTRY_RIPENCC    }, // 193.39.200.0    - 193.39.207.255 
	{ 0xc127d200, 0xc127d6ff, REGISTRY_RIPENCC    }, // 193.39.210.0    - 193.39.214.255 
	{ 0xc127e000, 0xc127efff, REGISTRY_RIPENCC    }, // 193.39.224.0    - 193.39.239.255 
	{ 0xc127f200, 0xc127fbff, REGISTRY_RIPENCC    }, // 193.39.242.0    - 193.39.251.255 
	{ 0xc127ff00, 0xc127ffff, REGISTRY_RIPENCC    }, // 193.39.255.0    - 193.39.255.255 
	{ 0xc1280000, 0xc128ffff, REGISTRY_RIPENCC    }, // 193.40.0.0      - 193.40.255.255 
	{ 0xc1290000, 0xc1291fff, REGISTRY_RIPENCC    }, // 193.41.0.0      - 193.41.31.255  
	{ 0xc1292100, 0xc12921ff, REGISTRY_RIPENCC    }, // 193.41.33.0     - 193.41.33.255  
	{ 0xc1292300, 0xc12925ff, REGISTRY_RIPENCC    }, // 193.41.35.0     - 193.41.37.255  
	{ 0xc1292800, 0xc1292eff, REGISTRY_RIPENCC    }, // 193.41.40.0     - 193.41.46.255  
	{ 0xc1293000, 0xc12933ff, REGISTRY_RIPENCC    }, // 193.41.48.0     - 193.41.51.255  
	{ 0xc1293800, 0xc12943ff, REGISTRY_RIPENCC    }, // 193.41.56.0     - 193.41.67.255  
	{ 0xc1294700, 0xc12951ff, REGISTRY_RIPENCC    }, // 193.41.71.0     - 193.41.81.255  
	{ 0xc1295300, 0xc1295aff, REGISTRY_RIPENCC    }, // 193.41.83.0     - 193.41.90.255  
	{ 0xc1295d00, 0xc12971ff, REGISTRY_RIPENCC    }, // 193.41.93.0     - 193.41.113.255 
	{ 0xc1297400, 0xc12979ff, REGISTRY_RIPENCC    }, // 193.41.116.0    - 193.41.121.255 
	{ 0xc1297c00, 0xc12991ff, REGISTRY_RIPENCC    }, // 193.41.124.0    - 193.41.145.255 
	{ 0xc1299200, 0xc12993ff, REGISTRY_AFRINIC    }, // 193.41.146.0    - 193.41.147.255 
	{ 0xc1299400, 0xc12999ff, REGISTRY_RIPENCC    }, // 193.41.148.0    - 193.41.153.255 
	{ 0xc1299c00, 0xc129bfff, REGISTRY_RIPENCC    }, // 193.41.156.0    - 193.41.191.255 
	{ 0xc129c100, 0xc129c6ff, REGISTRY_RIPENCC    }, // 193.41.193.0    - 193.41.198.255 
	{ 0xc129c800, 0xc129cbff, REGISTRY_RIPENCC    }, // 193.41.200.0    - 193.41.203.255 
	{ 0xc129cd00, 0xc129e1ff, REGISTRY_RIPENCC    }, // 193.41.205.0    - 193.41.225.255 
	{ 0xc129e300, 0xc129ecff, REGISTRY_RIPENCC    }, // 193.41.227.0    - 193.41.236.255 
	{ 0xc129ee00, 0xc129ffff, REGISTRY_RIPENCC    }, // 193.41.238.0    - 193.41.255.255 
	{ 0xc12a0200, 0xc12a03ff, REGISTRY_RIPENCC    }, // 193.42.2.0      - 193.42.3.255   
	{ 0xc12a0800, 0xc12a0eff, REGISTRY_RIPENCC    }, // 193.42.8.0      - 193.42.14.255  
	{ 0xc12a4000, 0xc12a5fff, REGISTRY_RIPENCC    }, // 193.42.64.0     - 193.42.95.255  
	{ 0xc12a8400, 0xc12a94ff, REGISTRY_RIPENCC    }, // 193.42.132.0    - 193.42.148.255 
	{ 0xc12a9600, 0xc12ad1ff, REGISTRY_RIPENCC    }, // 193.42.150.0    - 193.42.209.255 
	{ 0xc12ad300, 0xc12ad5ff, REGISTRY_RIPENCC    }, // 193.42.211.0    - 193.42.213.255 
	{ 0xc12ad700, 0xc12ad8ff, REGISTRY_RIPENCC    }, // 193.42.215.0    - 193.42.216.255 
	{ 0xc12ada00, 0xc12adaff, REGISTRY_RIPENCC    }, // 193.42.218.0    - 193.42.218.255 
	{ 0xc12adc00, 0xc12adfff, REGISTRY_RIPENCC    }, // 193.42.220.0    - 193.42.223.255 
	{ 0xc12ae400, 0xc12aefff, REGISTRY_RIPENCC    }, // 193.42.228.0    - 193.42.239.255 
	{ 0xc12af800, 0xc12b07ff, REGISTRY_RIPENCC    }, // 193.42.248.0    - 193.43.7.255   
	{ 0xc12b0c00, 0xc12b13ff, REGISTRY_RIPENCC    }, // 193.43.12.0     - 193.43.19.255  
	{ 0xc12b1800, 0xc12b1bff, REGISTRY_RIPENCC    }, // 193.43.24.0     - 193.43.27.255  
	{ 0xc12b1d00, 0xc12b1fff, REGISTRY_RIPENCC    }, // 193.43.29.0     - 193.43.31.255  
	{ 0xc12b2100, 0xc12b27ff, REGISTRY_RIPENCC    }, // 193.43.33.0     - 193.43.39.255  
	{ 0xc12b2c00, 0xc12b3fff, REGISTRY_RIPENCC    }, // 193.43.44.0     - 193.43.63.255  
	{ 0xc12b4900, 0xc12b49ff, REGISTRY_RIPENCC    }, // 193.43.73.0     - 193.43.73.255  
	{ 0xc12b4c00, 0xc12b4eff, REGISTRY_RIPENCC    }, // 193.43.76.0     - 193.43.78.255  
	{ 0xc12b5000, 0xc12b5aff, REGISTRY_RIPENCC    }, // 193.43.80.0     - 193.43.90.255  
	{ 0xc12b5c00, 0xc12b5dff, REGISTRY_RIPENCC    }, // 193.43.92.0     - 193.43.93.255  
	{ 0xc12b5f00, 0xc12b61ff, REGISTRY_RIPENCC    }, // 193.43.95.0     - 193.43.97.255  
	{ 0xc12b6400, 0xc12b75ff, REGISTRY_RIPENCC    }, // 193.43.100.0    - 193.43.117.255 
	{ 0xc12b7800, 0xc12b7dff, REGISTRY_RIPENCC    }, // 193.43.120.0    - 193.43.125.255 
	{ 0xc12b7f00, 0xc12b86ff, REGISTRY_RIPENCC    }, // 193.43.127.0    - 193.43.134.255 
	{ 0xc12b8800, 0xc12b89ff, REGISTRY_RIPENCC    }, // 193.43.136.0    - 193.43.137.255 
	{ 0xc12b8c00, 0xc12b8dff, REGISTRY_RIPENCC    }, // 193.43.140.0    - 193.43.141.255 
	{ 0xc12b9000, 0xc12b90ff, REGISTRY_RIPENCC    }, // 193.43.144.0    - 193.43.144.255 
	{ 0xc12b9400, 0xc12b94ff, REGISTRY_RIPENCC    }, // 193.43.148.0    - 193.43.148.255 
	{ 0xc12b9600, 0xc12b9eff, REGISTRY_RIPENCC    }, // 193.43.150.0    - 193.43.158.255 
	{ 0xc12ba000, 0xc12bffff, REGISTRY_RIPENCC    }, // 193.43.160.0    - 193.43.255.255 
	{ 0xc12c0000, 0xc12dffff, REGISTRY_RIPENCC    }, // 193.44.0.0      - 193.45.255.255 
	{ 0xc12e0000, 0xc12e13ff, REGISTRY_RIPENCC    }, // 193.46.0.0      - 193.46.19.255  
	{ 0xc12e1800, 0xc12e37ff, REGISTRY_RIPENCC    }, // 193.46.24.0     - 193.46.55.255  
	{ 0xc12e3a00, 0xc12e42ff, REGISTRY_RIPENCC    }, // 193.46.58.0     - 193.46.66.255  
	{ 0xc12e4400, 0xc12e4dff, REGISTRY_RIPENCC    }, // 193.46.68.0     - 193.46.77.255  
	{ 0xc12e5000, 0xc12eabff, REGISTRY_RIPENCC    }, // 193.46.80.0     - 193.46.171.255 
	{ 0xc12eb400, 0xc12ebfff, REGISTRY_RIPENCC    }, // 193.46.180.0    - 193.46.191.255 
	{ 0xc12ec900, 0xc12ed2ff, REGISTRY_RIPENCC    }, // 193.46.201.0    - 193.46.210.255 
	{ 0xc12ed400, 0xc12ed5ff, REGISTRY_RIPENCC    }, // 193.46.212.0    - 193.46.213.255 
	{ 0xc12ed700, 0xc12ed7ff, REGISTRY_RIPENCC    }, // 193.46.215.0    - 193.46.215.255 
	{ 0xc12edc00, 0xc12eddff, REGISTRY_RIPENCC    }, // 193.46.220.0    - 193.46.221.255 
	{ 0xc12edf00, 0xc12ee7ff, REGISTRY_RIPENCC    }, // 193.46.223.0    - 193.46.231.255 
	{ 0xc12eea00, 0xc12efaff, REGISTRY_RIPENCC    }, // 193.46.234.0    - 193.46.250.255 
	{ 0xc12efc00, 0xc12efeff, REGISTRY_RIPENCC    }, // 193.46.252.0    - 193.46.254.255 
	{ 0xc12f0000, 0xc12f42ff, REGISTRY_RIPENCC    }, // 193.47.0.0      - 193.47.66.255  
	{ 0xc12f4700, 0xc12f4aff, REGISTRY_RIPENCC    }, // 193.47.71.0     - 193.47.74.255  
	{ 0xc12f4c00, 0xc12f55ff, REGISTRY_RIPENCC    }, // 193.47.76.0     - 193.47.85.255  
	{ 0xc12f5700, 0xc12f95ff, REGISTRY_RIPENCC    }, // 193.47.87.0     - 193.47.149.255 
	{ 0xc12f9700, 0xc12fc0ff, REGISTRY_RIPENCC    }, // 193.47.151.0    - 193.47.192.255 
	{ 0xc12fc200, 0xc12fe9ff, REGISTRY_RIPENCC    }, // 193.47.194.0    - 193.47.233.255 
	{ 0xc12ff600, 0xc12ffdff, REGISTRY_RIPENCC    }, // 193.47.246.0    - 193.47.253.255 
	{ 0xc12fff00, 0xc12fffff, REGISTRY_RIPENCC    }, // 193.47.255.0    - 193.47.255.255 
	{ 0xc1300000, 0xc134ffff, REGISTRY_RIPENCC    }, // 193.48.0.0      - 193.52.255.255 
	{ 0xc1350200, 0xc13506ff, REGISTRY_RIPENCC    }, // 193.53.2.0      - 193.53.6.255   
	{ 0xc1350800, 0xc13509ff, REGISTRY_RIPENCC    }, // 193.53.8.0      - 193.53.9.255   
	{ 0xc1350b00, 0xc13522ff, REGISTRY_RIPENCC    }, // 193.53.11.0     - 193.53.34.255  
	{ 0xc1352400, 0xc13550ff, REGISTRY_RIPENCC    }, // 193.53.36.0     - 193.53.80.255  
	{ 0xc1355300, 0xc13556ff, REGISTRY_RIPENCC    }, // 193.53.83.0     - 193.53.86.255  
	{ 0xc1355800, 0xc13559ff, REGISTRY_RIPENCC    }, // 193.53.88.0     - 193.53.89.255  
	{ 0xc1355c00, 0xc13566ff, REGISTRY_RIPENCC    }, // 193.53.92.0     - 193.53.102.255 
	{ 0xc1356a00, 0xc1357eff, REGISTRY_RIPENCC    }, // 193.53.106.0    - 193.53.126.255 
	{ 0xc1358000, 0xc1359fff, REGISTRY_RIPENCC    }, // 193.53.128.0    - 193.53.159.255 
	{ 0xc135aa00, 0xc135f4ff, REGISTRY_RIPENCC    }, // 193.53.170.0    - 193.53.244.255 
	{ 0xc135f600, 0xc135ffff, REGISTRY_RIPENCC    }, // 193.53.246.0    - 193.53.255.255 
	{ 0xc1360000, 0xc137ffff, REGISTRY_RIPENCC    }, // 193.54.0.0      - 193.55.255.255 
	{ 0xc1380300, 0xc13807ff, REGISTRY_RIPENCC    }, // 193.56.3.0      - 193.56.7.255   
	{ 0xc1380900, 0xc1380aff, REGISTRY_RIPENCC    }, // 193.56.9.0      - 193.56.10.255  
	{ 0xc1380c00, 0xc1380cff, REGISTRY_RIPENCC    }, // 193.56.12.0     - 193.56.12.255  
	{ 0xc1380e00, 0xc1380fff, REGISTRY_RIPENCC    }, // 193.56.14.0     - 193.56.15.255  
	{ 0xc1381100, 0xc13811ff, REGISTRY_RIPENCC    }, // 193.56.17.0     - 193.56.17.255  
	{ 0xc1381300, 0xc13815ff, REGISTRY_RIPENCC    }, // 193.56.19.0     - 193.56.21.255  
	{ 0xc1381c00, 0xc13828ff, REGISTRY_RIPENCC    }, // 193.56.28.0     - 193.56.40.255  
	{ 0xc1382a00, 0xc13837ff, REGISTRY_RIPENCC    }, // 193.56.42.0     - 193.56.55.255  
	{ 0xc1383900, 0xc1383cff, REGISTRY_RIPENCC    }, // 193.56.57.0     - 193.56.60.255  
	{ 0xc1383e00, 0xc1383fff, REGISTRY_RIPENCC    }, // 193.56.62.0     - 193.56.63.255  
	{ 0xc1384800, 0xc13867ff, REGISTRY_RIPENCC    }, // 193.56.72.0     - 193.56.103.255 
	{ 0xc1386900, 0xc1386fff, REGISTRY_RIPENCC    }, // 193.56.105.0    - 193.56.111.255 
	{ 0xc1387200, 0xc13873ff, REGISTRY_RIPENCC    }, // 193.56.114.0    - 193.56.115.255 
	{ 0xc1387600, 0xc1387bff, REGISTRY_RIPENCC    }, // 193.56.118.0    - 193.56.123.255 
	{ 0xc1387d00, 0xc1388fff, REGISTRY_RIPENCC    }, // 193.56.125.0    - 193.56.143.255 
	{ 0xc1389200, 0xc13893ff, REGISTRY_RIPENCC    }, // 193.56.146.0    - 193.56.147.255 
	{ 0xc1389500, 0xc1389eff, REGISTRY_RIPENCC    }, // 193.56.149.0    - 193.56.158.255 
	{ 0xc138a000, 0xc138a1ff, REGISTRY_RIPENCC    }, // 193.56.160.0    - 193.56.161.255 
	{ 0xc138a600, 0xc138acff, REGISTRY_RIPENCC    }, // 193.56.166.0    - 193.56.172.255 
	{ 0xc138b000, 0xc138b8ff, REGISTRY_RIPENCC    }, // 193.56.176.0    - 193.56.184.255 
	{ 0xc138bb00, 0xc138bfff, REGISTRY_RIPENCC    }, // 193.56.187.0    - 193.56.191.255 
	{ 0xc138c100, 0xc138c3ff, REGISTRY_RIPENCC    }, // 193.56.193.0    - 193.56.195.255 
	{ 0xc138c700, 0xc138c7ff, REGISTRY_RIPENCC    }, // 193.56.199.0    - 193.56.199.255 
	{ 0xc138c900, 0xc138cbff, REGISTRY_RIPENCC    }, // 193.56.201.0    - 193.56.203.255 
	{ 0xc138d100, 0xc138d3ff, REGISTRY_RIPENCC    }, // 193.56.209.0    - 193.56.211.255 
	{ 0xc138d800, 0xc138f6ff, REGISTRY_RIPENCC    }, // 193.56.216.0    - 193.56.246.255 
	{ 0xc138fc00, 0xc138ffff, REGISTRY_RIPENCC    }, // 193.56.252.0    - 193.56.255.255 
	{ 0xc1390100, 0xc13902ff, REGISTRY_RIPENCC    }, // 193.57.1.0      - 193.57.2.255   
	{ 0xc1390500, 0xc13907ff, REGISTRY_RIPENCC    }, // 193.57.5.0      - 193.57.7.255   
	{ 0xc1390900, 0xc13914ff, REGISTRY_RIPENCC    }, // 193.57.9.0      - 193.57.20.255  
	{ 0xc1391600, 0xc13927ff, REGISTRY_RIPENCC    }, // 193.57.22.0     - 193.57.39.255  
	{ 0xc1393000, 0xc13934ff, REGISTRY_RIPENCC    }, // 193.57.48.0     - 193.57.52.255  
	{ 0xc1393600, 0xc13936ff, REGISTRY_RIPENCC    }, // 193.57.54.0     - 193.57.54.255  
	{ 0xc1393800, 0xc13938ff, REGISTRY_RIPENCC    }, // 193.57.56.0     - 193.57.56.255  
	{ 0xc1393f00, 0xc13947ff, REGISTRY_RIPENCC    }, // 193.57.63.0     - 193.57.71.255  
	{ 0xc1394900, 0xc1394bff, REGISTRY_RIPENCC    }, // 193.57.73.0     - 193.57.75.255  
	{ 0xc1394d00, 0xc1394fff, REGISTRY_RIPENCC    }, // 193.57.77.0     - 193.57.79.255  
	{ 0xc1395400, 0xc13957ff, REGISTRY_RIPENCC    }, // 193.57.84.0     - 193.57.87.255  
	{ 0xc1395900, 0xc13959ff, REGISTRY_RIPENCC    }, // 193.57.89.0     - 193.57.89.255  
	{ 0xc1395b00, 0xc1395dff, REGISTRY_RIPENCC    }, // 193.57.91.0     - 193.57.93.255  
	{ 0xc1396000, 0xc1397fff, REGISTRY_RIPENCC    }, // 193.57.96.0     - 193.57.127.255 
	{ 0xc1398400, 0xc1398bff, REGISTRY_RIPENCC    }, // 193.57.132.0    - 193.57.139.255 
	{ 0xc1398d00, 0xc1398fff, REGISTRY_RIPENCC    }, // 193.57.141.0    - 193.57.143.255 
	{ 0xc1399100, 0xc13993ff, REGISTRY_RIPENCC    }, // 193.57.145.0    - 193.57.147.255 
	{ 0xc1399800, 0xc1399eff, REGISTRY_RIPENCC    }, // 193.57.152.0    - 193.57.158.255 
	{ 0xc139a000, 0xc139a1ff, REGISTRY_RIPENCC    }, // 193.57.160.0    - 193.57.161.255 
	{ 0xc139a600, 0xc139a6ff, REGISTRY_RIPENCC    }, // 193.57.166.0    - 193.57.166.255 
	{ 0xc139a900, 0xc139acff, REGISTRY_RIPENCC    }, // 193.57.169.0    - 193.57.172.255 
	{ 0xc139b000, 0xc139c7ff, REGISTRY_RIPENCC    }, // 193.57.176.0    - 193.57.199.255 
	{ 0xc139c900, 0xc139c9ff, REGISTRY_RIPENCC    }, // 193.57.201.0    - 193.57.201.255 
	{ 0xc139cc00, 0xc139cdff, REGISTRY_RIPENCC    }, // 193.57.204.0    - 193.57.205.255 
	{ 0xc139d800, 0xc13a5aff, REGISTRY_RIPENCC    }, // 193.57.216.0    - 193.58.90.255  
	{ 0xc13a5c00, 0xc13a78ff, REGISTRY_RIPENCC    }, // 193.58.92.0     - 193.58.120.255 
	{ 0xc13a8000, 0xc13a83ff, REGISTRY_RIPENCC    }, // 193.58.128.0    - 193.58.131.255 
	{ 0xc13a8700, 0xc13a8fff, REGISTRY_RIPENCC    }, // 193.58.135.0    - 193.58.143.255 
	{ 0xc13a9400, 0xc13a95ff, REGISTRY_RIPENCC    }, // 193.58.148.0    - 193.58.149.255 
	{ 0xc13a9800, 0xc13aacff, REGISTRY_RIPENCC    }, // 193.58.152.0    - 193.58.172.255 
	{ 0xc13abc00, 0xc13aecff, REGISTRY_RIPENCC    }, // 193.58.188.0    - 193.58.236.255 
	{ 0xc13aee00, 0xc13aefff, REGISTRY_RIPENCC    }, // 193.58.238.0    - 193.58.239.255 
	{ 0xc13af100, 0xc13af7ff, REGISTRY_RIPENCC    }, // 193.58.241.0    - 193.58.247.255 
	{ 0xc13afa00, 0xc13afdff, REGISTRY_RIPENCC    }, // 193.58.250.0    - 193.58.253.255 
	{ 0xc13aff00, 0xc13affff, REGISTRY_RIPENCC    }, // 193.58.255.0    - 193.58.255.255 
	{ 0xc13b0000, 0xc153ffff, REGISTRY_RIPENCC    }, // 193.59.0.0      - 193.83.255.255 
	{ 0xc1540000, 0xc15400ff, REGISTRY_RIPENCC    }, // 193.84.0.0      - 193.84.0.255   
	{ 0xc1540600, 0xc1540aff, REGISTRY_RIPENCC    }, // 193.84.6.0      - 193.84.10.255  
	{ 0xc1540c00, 0xc1540fff, REGISTRY_RIPENCC    }, // 193.84.12.0     - 193.84.15.255  
	{ 0xc1541100, 0xc15412ff, REGISTRY_RIPENCC    }, // 193.84.17.0     - 193.84.18.255  
	{ 0xc1541400, 0xc1541dff, REGISTRY_RIPENCC    }, // 193.84.20.0     - 193.84.29.255  
	{ 0xc1541f00, 0xc1542fff, REGISTRY_RIPENCC    }, // 193.84.31.0     - 193.84.47.255  
	{ 0xc1543200, 0xc15445ff, REGISTRY_RIPENCC    }, // 193.84.50.0     - 193.84.69.255  
	{ 0xc1544700, 0xc15449ff, REGISTRY_RIPENCC    }, // 193.84.71.0     - 193.84.73.255  
	{ 0xc1544b00, 0xc1544dff, REGISTRY_RIPENCC    }, // 193.84.75.0     - 193.84.77.255  
	{ 0xc1544f00, 0xc15454ff, REGISTRY_RIPENCC    }, // 193.84.79.0     - 193.84.84.255  
	{ 0xc1545600, 0xc15457ff, REGISTRY_RIPENCC    }, // 193.84.86.0     - 193.84.87.255  
	{ 0xc1545900, 0xc15459ff, REGISTRY_RIPENCC    }, // 193.84.89.0     - 193.84.89.255  
	{ 0xc1545b00, 0xc1545bff, REGISTRY_RIPENCC    }, // 193.84.91.0     - 193.84.91.255  
	{ 0xc1545e00, 0xc15463ff, REGISTRY_RIPENCC    }, // 193.84.94.0     - 193.84.99.255  
	{ 0xc1546800, 0xc1546bff, REGISTRY_RIPENCC    }, // 193.84.104.0    - 193.84.107.255 
	{ 0xc1547000, 0xc15470ff, REGISTRY_RIPENCC    }, // 193.84.112.0    - 193.84.112.255 
	{ 0xc1547400, 0xc15475ff, REGISTRY_RIPENCC    }, // 193.84.116.0    - 193.84.117.255 
	{ 0xc1548000, 0xc15481ff, REGISTRY_RIPENCC    }, // 193.84.128.0    - 193.84.129.255 
	{ 0xc1548e00, 0xc154b2ff, REGISTRY_RIPENCC    }, // 193.84.142.0    - 193.84.178.255 
	{ 0xc154b500, 0xc154baff, REGISTRY_RIPENCC    }, // 193.84.181.0    - 193.84.186.255 
	{ 0xc154c000, 0xc154efff, REGISTRY_RIPENCC    }, // 193.84.192.0    - 193.84.239.255 
	{ 0xc154f500, 0xc154f6ff, REGISTRY_RIPENCC    }, // 193.84.245.0    - 193.84.246.255 
	{ 0xc154f900, 0xc154f9ff, REGISTRY_RIPENCC    }, // 193.84.249.0    - 193.84.249.255 
	{ 0xc154fb00, 0xc154fcff, REGISTRY_RIPENCC    }, // 193.84.251.0    - 193.84.252.255 
	{ 0xc154fe00, 0xc154ffff, REGISTRY_RIPENCC    }, // 193.84.254.0    - 193.84.255.255 
	{ 0xc1550000, 0xc15cffff, REGISTRY_RIPENCC    }, // 193.85.0.0      - 193.92.255.255 
	{ 0xc15d0000, 0xc15d03ff, REGISTRY_RIPENCC    }, // 193.93.0.0      - 193.93.3.255   
	{ 0xc15d0800, 0xc15d1bff, REGISTRY_RIPENCC    }, // 193.93.8.0      - 193.93.27.255  
	{ 0xc15d2000, 0xc15d4fff, REGISTRY_RIPENCC    }, // 193.93.32.0     - 193.93.79.255  
	{ 0xc15d5400, 0xc15dffff, REGISTRY_RIPENCC    }, // 193.93.84.0     - 193.93.255.255 
	{ 0xc15e0000, 0xc15effff, REGISTRY_RIPENCC    }, // 193.94.0.0      - 193.94.255.255 
	{ 0xc15f0000, 0xc15f7fff, REGISTRY_AFRINIC    }, // 193.95.0.0      - 193.95.127.255 
	{ 0xc15f8000, 0xc167ffff, REGISTRY_RIPENCC    }, // 193.95.128.0    - 193.103.255.255
	{ 0xc1680000, 0xc16842ff, REGISTRY_RIPENCC    }, // 193.104.0.0     - 193.104.66.255 
	{ 0xc1684400, 0xc1685cff, REGISTRY_RIPENCC    }, // 193.104.68.0    - 193.104.92.255 
	{ 0xc1685e00, 0xc16898ff, REGISTRY_RIPENCC    }, // 193.104.94.0    - 193.104.152.255
	{ 0xc1689a00, 0xc168d2ff, REGISTRY_RIPENCC    }, // 193.104.154.0   - 193.104.210.255
	{ 0xc168d400, 0xc168ddff, REGISTRY_RIPENCC    }, // 193.104.212.0   - 193.104.221.255
	{ 0xc168df00, 0xc1695eff, REGISTRY_RIPENCC    }, // 193.104.223.0   - 193.105.94.255 
	{ 0xc1696100, 0xc16978ff, REGISTRY_RIPENCC    }, // 193.105.97.0    - 193.105.120.255
	{ 0xc1697a00, 0xc16996ff, REGISTRY_RIPENCC    }, // 193.105.122.0   - 193.105.150.255
	{ 0xc1699800, 0xc169a1ff, REGISTRY_RIPENCC    }, // 193.105.152.0   - 193.105.161.255
	{ 0xc169a300, 0xc16a13ff, REGISTRY_RIPENCC    }, // 193.105.163.0   - 193.106.19.255 
	{ 0xc16a1800, 0xc16b4bff, REGISTRY_RIPENCC    }, // 193.106.24.0    - 193.107.75.255 
	{ 0xc16b5000, 0xc16bb7ff, REGISTRY_RIPENCC    }, // 193.107.80.0    - 193.107.183.255
	{ 0xc16bbc00, 0xc16bc3ff, REGISTRY_RIPENCC    }, // 193.107.188.0   - 193.107.195.255
	{ 0xc16bc400, 0xc16bc7ff, REGISTRY_RIPENCC    }, // 193.107.196.0   - 193.107.199.255
	{ 0xc16bc800, 0xc16bcfff, REGISTRY_RIPENCC    }, // 193.107.200.0   - 193.107.207.255
	{ 0xc16bd400, 0xc16c13ff, REGISTRY_RIPENCC    }, // 193.107.212.0   - 193.108.19.255 
	{ 0xc16c1500, 0xc16c16ff, REGISTRY_RIPENCC    }, // 193.108.21.0    - 193.108.22.255 
	{ 0xc16c1700, 0xc16c17ff, REGISTRY_AFRINIC    }, // 193.108.23.0    - 193.108.23.255 
	{ 0xc16c1800, 0xc16c18ff, REGISTRY_RIPENCC    }, // 193.108.24.0    - 193.108.24.255 
	{ 0xc16c1b00, 0xc16c1bff, REGISTRY_RIPENCC    }, // 193.108.27.0    - 193.108.27.255 
	{ 0xc16c1c00, 0xc16c1cff, REGISTRY_AFRINIC    }, // 193.108.28.0    - 193.108.28.255 
	{ 0xc16c1d00, 0xc16c29ff, REGISTRY_RIPENCC    }, // 193.108.29.0    - 193.108.41.255 
	{ 0xc16c2a00, 0xc16c2bff, REGISTRY_RIPENCC    }, // 193.108.42.0    - 193.108.43.255 
	{ 0xc16c2c00, 0xc16c2dff, REGISTRY_RIPENCC    }, // 193.108.44.0    - 193.108.45.255 
	{ 0xc16c3000, 0xc16c5fff, REGISTRY_RIPENCC    }, // 193.108.48.0    - 193.108.95.255 
	{ 0xc16c6200, 0xc16cb1ff, REGISTRY_RIPENCC    }, // 193.108.98.0    - 193.108.177.255
	{ 0xc16cb300, 0xc16cc5ff, REGISTRY_RIPENCC    }, // 193.108.179.0   - 193.108.197.255
	{ 0xc16cc700, 0xc16cceff, REGISTRY_RIPENCC    }, // 193.108.199.0   - 193.108.206.255
	{ 0xc16cd100, 0xc16cd2ff, REGISTRY_RIPENCC    }, // 193.108.209.0   - 193.108.210.255
	{ 0xc16cd400, 0xc16cd5ff, REGISTRY_RIPENCC    }, // 193.108.212.0   - 193.108.213.255
	{ 0xc16cd600, 0xc16cd6ff, REGISTRY_AFRINIC    }, // 193.108.214.0   - 193.108.214.255
	{ 0xc16cd800, 0xc16ce5ff, REGISTRY_RIPENCC    }, // 193.108.216.0   - 193.108.229.255
	{ 0xc16ce800, 0xc16ce9ff, REGISTRY_RIPENCC    }, // 193.108.232.0   - 193.108.233.255
	{ 0xc16cec00, 0xc16cfbff, REGISTRY_RIPENCC    }, // 193.108.236.0   - 193.108.251.255
	{ 0xc16cfc00, 0xc16cffff, REGISTRY_AFRINIC    }, // 193.108.252.0   - 193.108.255.255
	{ 0xc16d0000, 0xc16d0bff, REGISTRY_RIPENCC    }, // 193.109.0.0     - 193.109.11.255 
	{ 0xc16d1000, 0xc16d3fff, REGISTRY_RIPENCC    }, // 193.109.16.0    - 193.109.63.255 
	{ 0xc16d4200, 0xc16d43ff, REGISTRY_AFRINIC    }, // 193.109.66.0    - 193.109.67.255 
	{ 0xc16d4400, 0xc16d4dff, REGISTRY_RIPENCC    }, // 193.109.68.0    - 193.109.77.255 
	{ 0xc16d5000, 0xc16d53ff, REGISTRY_RIPENCC    }, // 193.109.80.0    - 193.109.83.255 
	{ 0xc16d5600, 0xc16d5bff, REGISTRY_RIPENCC    }, // 193.109.86.0    - 193.109.91.255 
	{ 0xc16d5d00, 0xc16d63ff, REGISTRY_RIPENCC    }, // 193.109.93.0    - 193.109.99.255 
	{ 0xc16d6800, 0xc16d6bff, REGISTRY_RIPENCC    }, // 193.109.104.0   - 193.109.107.255
	{ 0xc16d7000, 0xc16d77ff, REGISTRY_RIPENCC    }, // 193.109.112.0   - 193.109.119.255
	{ 0xc16d7900, 0xc16d87ff, REGISTRY_RIPENCC    }, // 193.109.121.0   - 193.109.135.255
	{ 0xc16d8a00, 0xc16dd4ff, REGISTRY_RIPENCC    }, // 193.109.138.0   - 193.109.212.255
	{ 0xc16dd600, 0xc16dd8ff, REGISTRY_RIPENCC    }, // 193.109.214.0   - 193.109.216.255
	{ 0xc16dda00, 0xc16ddaff, REGISTRY_RIPENCC    }, // 193.109.218.0   - 193.109.218.255
	{ 0xc16ddc00, 0xc16ddcff, REGISTRY_RIPENCC    }, // 193.109.220.0   - 193.109.220.255
	{ 0xc16dde00, 0xc16ddfff, REGISTRY_RIPENCC    }, // 193.109.222.0   - 193.109.223.255
	{ 0xc16de100, 0xc16de1ff, REGISTRY_RIPENCC    }, // 193.109.225.0   - 193.109.225.255
	{ 0xc16de300, 0xc16de5ff, REGISTRY_RIPENCC    }, // 193.109.227.0   - 193.109.229.255
	{ 0xc16de700, 0xc16dffff, REGISTRY_RIPENCC    }, // 193.109.231.0   - 193.109.255.255
	{ 0xc16e0400, 0xc16e27ff, REGISTRY_RIPENCC    }, // 193.110.4.0     - 193.110.39.255 
	{ 0xc16e2800, 0xc16e2fff, REGISTRY_RIPENCC    }, // 193.110.40.0    - 193.110.47.255 
	{ 0xc16e3000, 0xc16e51ff, REGISTRY_RIPENCC    }, // 193.110.48.0    - 193.110.81.255 
	{ 0xc16e5300, 0xc16e5cff, REGISTRY_RIPENCC    }, // 193.110.83.0    - 193.110.92.255 
	{ 0xc16e5e00, 0xc16e67ff, REGISTRY_RIPENCC    }, // 193.110.94.0    - 193.110.103.255
	{ 0xc16e6800, 0xc16e69ff, REGISTRY_AFRINIC    }, // 193.110.104.0   - 193.110.105.255
	{ 0xc16e6a00, 0xc16e82ff, REGISTRY_RIPENCC    }, // 193.110.106.0   - 193.110.130.255
	{ 0xc16e8400, 0xc16e85ff, REGISTRY_RIPENCC    }, // 193.110.132.0   - 193.110.133.255
	{ 0xc16e8900, 0xc16e8cff, REGISTRY_RIPENCC    }, // 193.110.137.0   - 193.110.140.255
	{ 0xc16e8e00, 0xc16e8eff, REGISTRY_RIPENCC    }, // 193.110.142.0   - 193.110.142.255
	{ 0xc16e9000, 0xc16e93ff, REGISTRY_RIPENCC    }, // 193.110.144.0   - 193.110.147.255
	{ 0xc16e9500, 0xc16e9dff, REGISTRY_RIPENCC    }, // 193.110.149.0   - 193.110.157.255
	{ 0xc16e9f00, 0xc16ec7ff, REGISTRY_RIPENCC    }, // 193.110.159.0   - 193.110.199.255
	{ 0xc16ecc00, 0xc16f03ff, REGISTRY_RIPENCC    }, // 193.110.204.0   - 193.111.3.255  
	{ 0xc16f0600, 0xc16f1dff, REGISTRY_RIPENCC    }, // 193.111.6.0     - 193.111.29.255 
	{ 0xc16f2000, 0xc16f2cff, REGISTRY_RIPENCC    }, // 193.111.32.0    - 193.111.44.255 
	{ 0xc16f2e00, 0xc16f33ff, REGISTRY_RIPENCC    }, // 193.111.46.0    - 193.111.51.255 
	{ 0xc16f3800, 0xc16f4bff, REGISTRY_RIPENCC    }, // 193.111.56.0    - 193.111.75.255 
	{ 0xc16f5100, 0xc16f55ff, REGISTRY_RIPENCC    }, // 193.111.81.0    - 193.111.85.255 
	{ 0xc16f5700, 0xc16f59ff, REGISTRY_RIPENCC    }, // 193.111.87.0    - 193.111.89.255 
	{ 0xc16f5c00, 0xc16f73ff, REGISTRY_RIPENCC    }, // 193.111.92.0    - 193.111.115.255
	{ 0xc16f7600, 0xc16f7bff, REGISTRY_RIPENCC    }, // 193.111.118.0   - 193.111.123.255
	{ 0xc16f7e00, 0xc16f93ff, REGISTRY_RIPENCC    }, // 193.111.126.0   - 193.111.147.255
	{ 0xc16f9c00, 0xc16fa7ff, REGISTRY_RIPENCC    }, // 193.111.156.0   - 193.111.167.255
	{ 0xc16fa900, 0xc16fa9ff, REGISTRY_RIPENCC    }, // 193.111.169.0   - 193.111.169.255
	{ 0xc16fac00, 0xc16fadff, REGISTRY_RIPENCC    }, // 193.111.172.0   - 193.111.173.255
	{ 0xc16faf00, 0xc16fb3ff, REGISTRY_RIPENCC    }, // 193.111.175.0   - 193.111.179.255
	{ 0xc16fb800, 0xc16fc3ff, REGISTRY_RIPENCC    }, // 193.111.184.0   - 193.111.195.255
	{ 0xc16fc600, 0xc16fe1ff, REGISTRY_RIPENCC    }, // 193.111.198.0   - 193.111.225.255
	{ 0xc16fe300, 0xc16fe4ff, REGISTRY_RIPENCC    }, // 193.111.227.0   - 193.111.228.255
	{ 0xc16fe600, 0xc16fe8ff, REGISTRY_RIPENCC    }, // 193.111.230.0   - 193.111.232.255
	{ 0xc16fec00, 0xc16ff7ff, REGISTRY_RIPENCC    }, // 193.111.236.0   - 193.111.247.255
	{ 0xc16ffc00, 0xc16fffff, REGISTRY_RIPENCC    }, // 193.111.252.0   - 193.111.255.255
	{ 0xc1700000, 0xc189ffff, REGISTRY_RIPENCC    }, // 193.112.0.0     - 193.137.255.255
	{ 0xc18a0000, 0xc18a1bff, REGISTRY_RIPENCC    }, // 193.138.0.0     - 193.138.27.255 
	{ 0xc18a1d00, 0xc18a1fff, REGISTRY_RIPENCC    }, // 193.138.29.0    - 193.138.31.255 
	{ 0xc18a2000, 0xc18a3fff, REGISTRY_RIPENCC    }, // 193.138.32.0    - 193.138.63.255 
	{ 0xc18a4000, 0xc18a47ff, REGISTRY_RIPENCC    }, // 193.138.64.0    - 193.138.71.255 
	{ 0xc18a4900, 0xc18a4aff, REGISTRY_RIPENCC    }, // 193.138.73.0    - 193.138.74.255 
	{ 0xc18a4c00, 0xc18a54ff, REGISTRY_RIPENCC    }, // 193.138.76.0    - 193.138.84.255 
	{ 0xc18a5600, 0xc18a6eff, REGISTRY_RIPENCC    }, // 193.138.86.0    - 193.138.110.255
	{ 0xc18a7000, 0xc18a77ff, REGISTRY_RIPENCC    }, // 193.138.112.0   - 193.138.119.255
	{ 0xc18a7b00, 0xc18aa7ff, REGISTRY_RIPENCC    }, // 193.138.123.0   - 193.138.167.255
	{ 0xc18ab000, 0xc18afbff, REGISTRY_RIPENCC    }, // 193.138.176.0   - 193.138.251.255
	{ 0xc18b0000, 0xc18dffff, REGISTRY_RIPENCC    }, // 193.139.0.0     - 193.141.255.255
	{ 0xc18e0000, 0xc18e02ff, REGISTRY_RIPENCC    }, // 193.142.0.0     - 193.142.2.255  
	{ 0xc18e0500, 0xc18e05ff, REGISTRY_RIPENCC    }, // 193.142.5.0     - 193.142.5.255  
	{ 0xc18e0700, 0xc18e14ff, REGISTRY_RIPENCC    }, // 193.142.7.0     - 193.142.20.255 
	{ 0xc18e1700, 0xc18e1aff, REGISTRY_RIPENCC    }, // 193.142.23.0    - 193.142.26.255 
	{ 0xc18e1c00, 0xc18e1fff, REGISTRY_RIPENCC    }, // 193.142.28.0    - 193.142.31.255 
	{ 0xc18e3200, 0xc18e33ff, REGISTRY_RIPENCC    }, // 193.142.50.0    - 193.142.51.255 
	{ 0xc18e3500, 0xc18e3aff, REGISTRY_RIPENCC    }, // 193.142.53.0    - 193.142.58.255 
	{ 0xc18e3c00, 0xc18e74ff, REGISTRY_RIPENCC    }, // 193.142.60.0    - 193.142.116.255
	{ 0xc18e7600, 0xc18e7dff, REGISTRY_RIPENCC    }, // 193.142.118.0   - 193.142.125.255
	{ 0xc18e7f00, 0xc18e7fff, REGISTRY_RIPENCC    }, // 193.142.127.0   - 193.142.127.255
	{ 0xc18e8800, 0xc18e8fff, REGISTRY_RIPENCC    }, // 193.142.136.0   - 193.142.143.255
	{ 0xc18e9100, 0xc18e97ff, REGISTRY_RIPENCC    }, // 193.142.145.0   - 193.142.151.255
	{ 0xc18e9900, 0xc18e99ff, REGISTRY_RIPENCC    }, // 193.142.153.0   - 193.142.153.255
	{ 0xc18e9d00, 0xc18ebbff, REGISTRY_RIPENCC    }, // 193.142.157.0   - 193.142.187.255
	{ 0xc18ec400, 0xc18ec4ff, REGISTRY_RIPENCC    }, // 193.142.196.0   - 193.142.196.255
	{ 0xc18ecc00, 0xc18eccff, REGISTRY_RIPENCC    }, // 193.142.204.0   - 193.142.204.255
	{ 0xc18ed000, 0xc18edeff, REGISTRY_RIPENCC    }, // 193.142.208.0   - 193.142.222.255
	{ 0xc18ee000, 0xc18ee7ff, REGISTRY_RIPENCC    }, // 193.142.224.0   - 193.142.231.255
	{ 0xc18eeb00, 0xc18ef0ff, REGISTRY_RIPENCC    }, // 193.142.235.0   - 193.142.240.255
	{ 0xc18ef300, 0xc18ef8ff, REGISTRY_RIPENCC    }, // 193.142.243.0   - 193.142.248.255
	{ 0xc18efa00, 0xc18efcff, REGISTRY_RIPENCC    }, // 193.142.250.0   - 193.142.252.255
	{ 0xc18f0000, 0xc18f00ff, REGISTRY_RIPENCC    }, // 193.143.0.0     - 193.143.0.255  
	{ 0xc18f0400, 0xc18f05ff, REGISTRY_RIPENCC    }, // 193.143.4.0     - 193.143.5.255  
	{ 0xc18f0800, 0xc18f0fff, REGISTRY_RIPENCC    }, // 193.143.8.0     - 193.143.15.255 
	{ 0xc18f1300, 0xc18f13ff, REGISTRY_RIPENCC    }, // 193.143.19.0    - 193.143.19.255 
	{ 0xc18f2000, 0xc18f3fff, REGISTRY_RIPENCC    }, // 193.143.32.0    - 193.143.63.255 
	{ 0xc18f4600, 0xc18f4aff, REGISTRY_RIPENCC    }, // 193.143.70.0    - 193.143.74.255 
	{ 0xc18f4d00, 0xc18f59ff, REGISTRY_RIPENCC    }, // 193.143.77.0    - 193.143.89.255 
	{ 0xc18f5b00, 0xc18f60ff, REGISTRY_RIPENCC    }, // 193.143.91.0    - 193.143.96.255 
	{ 0xc18f6200, 0xc18f7aff, REGISTRY_RIPENCC    }, // 193.143.98.0    - 193.143.122.255
	{ 0xc18f7c00, 0xc18fdfff, REGISTRY_RIPENCC    }, // 193.143.124.0   - 193.143.223.255
	{ 0xc18fe100, 0xc18ff7ff, REGISTRY_RIPENCC    }, // 193.143.225.0   - 193.143.247.255
	{ 0xc18ff900, 0xc18ff9ff, REGISTRY_RIPENCC    }, // 193.143.249.0   - 193.143.249.255
	{ 0xc18ffd00, 0xc18ffeff, REGISTRY_RIPENCC    }, // 193.143.253.0   - 193.143.254.255
	{ 0xc1900000, 0xc193ffff, REGISTRY_RIPENCC    }, // 193.144.0.0     - 193.147.255.255
	{ 0xc1940000, 0xc19400ff, REGISTRY_RIPENCC    }, // 193.148.0.0     - 193.148.0.255  
	{ 0xc1940200, 0xc19407ff, REGISTRY_RIPENCC    }, // 193.148.2.0     - 193.148.7.255  
	{ 0xc1940f00, 0xc1940fff, REGISTRY_RIPENCC    }, // 193.148.15.0    - 193.148.15.255 
	{ 0xc1941800, 0xc19427ff, REGISTRY_RIPENCC    }, // 193.148.24.0    - 193.148.39.255 
	{ 0xc1942c00, 0xc1942eff, REGISTRY_RIPENCC    }, // 193.148.44.0    - 193.148.46.255 
	{ 0xc1943000, 0xc19437ff, REGISTRY_RIPENCC    }, // 193.148.48.0    - 193.148.55.255 
	{ 0xc1946000, 0xc194f3ff, REGISTRY_RIPENCC    }, // 193.148.96.0    - 193.148.243.255
	{ 0xc194f600, 0xc194f6ff, REGISTRY_RIPENCC    }, // 193.148.246.0   - 193.148.246.255
	{ 0xc194fc00, 0xc194fcff, REGISTRY_RIPENCC    }, // 193.148.252.0   - 193.148.252.255
	{ 0xc194fe00, 0xc194feff, REGISTRY_RIPENCC    }, // 193.148.254.0   - 193.148.254.255
	{ 0xc1950000, 0xc19501ff, REGISTRY_RIPENCC    }, // 193.149.0.0     - 193.149.1.255  
	{ 0xc1950400, 0xc1950fff, REGISTRY_RIPENCC    }, // 193.149.4.0     - 193.149.15.255 
	{ 0xc1952000, 0xc1953fff, REGISTRY_RIPENCC    }, // 193.149.32.0    - 193.149.63.255 
	{ 0xc1954000, 0xc1955fff, REGISTRY_RIPENCC    }, // 193.149.64.0    - 193.149.95.255 
	{ 0xc1956000, 0xc1957fff, REGISTRY_RIPENCC    }, // 193.149.96.0    - 193.149.127.255
	{ 0xc1958000, 0xc195bfff, REGISTRY_RIPENCC    }, // 193.149.128.0   - 193.149.191.255
	{ 0xc195c000, 0xc195ffff, REGISTRY_RIPENCC    }, // 193.149.192.0   - 193.149.255.255
	{ 0xc1960000, 0xc196a7ff, REGISTRY_RIPENCC    }, // 193.150.0.0     - 193.150.167.255
	{ 0xc196a900, 0xc196a9ff, REGISTRY_RIPENCC    }, // 193.150.169.0   - 193.150.169.255
	{ 0xc196ac00, 0xc1973bff, REGISTRY_RIPENCC    }, // 193.150.172.0   - 193.151.59.255 
	{ 0xc1973c00, 0xc19743ff, REGISTRY_RIPENCC    }, // 193.151.60.0    - 193.151.67.255 
	{ 0xc1974400, 0xc19747ff, REGISTRY_RIPENCC    }, // 193.151.68.0    - 193.151.71.255 
	{ 0xc1974800, 0xc1974bff, REGISTRY_RIPENCC    }, // 193.151.72.0    - 193.151.75.255 
	{ 0xc1974c00, 0xc197ffff, REGISTRY_RIPENCC    }, // 193.151.76.0    - 193.151.255.255
	{ 0xc1980000, 0xc19fffff, REGISTRY_RIPENCC    }, // 193.152.0.0     - 193.159.255.255
	{ 0xc1a00000, 0xc1a007ff, REGISTRY_RIPENCC    }, // 193.160.0.0     - 193.160.7.255  
	{ 0xc1a00900, 0xc1a009ff, REGISTRY_RIPENCC    }, // 193.160.9.0     - 193.160.9.255  
	{ 0xc1a00c00, 0xc1a00dff, REGISTRY_RIPENCC    }, // 193.160.12.0    - 193.160.13.255 
	{ 0xc1a01400, 0xc1a014ff, REGISTRY_RIPENCC    }, // 193.160.20.0    - 193.160.20.255 
	{ 0xc1a01800, 0xc1a01dff, REGISTRY_RIPENCC    }, // 193.160.24.0    - 193.160.29.255 
	{ 0xc1a02100, 0xc1a03fff, REGISTRY_RIPENCC    }, // 193.160.33.0    - 193.160.63.255 
	{ 0xc1a06100, 0xc1a063ff, REGISTRY_RIPENCC    }, // 193.160.97.0    - 193.160.99.255 
	{ 0xc1a06600, 0xc1a070ff, REGISTRY_RIPENCC    }, // 193.160.102.0   - 193.160.112.255
	{ 0xc1a07200, 0xc1a076ff, REGISTRY_RIPENCC    }, // 193.160.114.0   - 193.160.118.255
	{ 0xc1a07800, 0xc1a07fff, REGISTRY_RIPENCC    }, // 193.160.120.0   - 193.160.127.255
	{ 0xc1a08300, 0xc1a085ff, REGISTRY_RIPENCC    }, // 193.160.131.0   - 193.160.133.255
	{ 0xc1a08900, 0xc1a08aff, REGISTRY_RIPENCC    }, // 193.160.137.0   - 193.160.138.255
	{ 0xc1a09000, 0xc1a090ff, REGISTRY_RIPENCC    }, // 193.160.144.0   - 193.160.144.255
	{ 0xc1a09400, 0xc1a097ff, REGISTRY_RIPENCC    }, // 193.160.148.0   - 193.160.151.255
	{ 0xc1a09c00, 0xc1a09eff, REGISTRY_RIPENCC    }, // 193.160.156.0   - 193.160.158.255
	{ 0xc1a0a000, 0xc1a0bbff, REGISTRY_RIPENCC    }, // 193.160.160.0   - 193.160.187.255
	{ 0xc1a0be00, 0xc1a0cfff, REGISTRY_RIPENCC    }, // 193.160.190.0   - 193.160.207.255
	{ 0xc1a0e000, 0xc1a0e9ff, REGISTRY_RIPENCC    }, // 193.160.224.0   - 193.160.233.255
	{ 0xc1a0ef00, 0xc1a0efff, REGISTRY_RIPENCC    }, // 193.160.239.0   - 193.160.239.255
	{ 0xc1a0f800, 0xc1a0fcff, REGISTRY_RIPENCC    }, // 193.160.248.0   - 193.160.252.255
	{ 0xc1a0ff00, 0xc1a100ff, REGISTRY_RIPENCC    }, // 193.160.255.0   - 193.161.0.255  
	{ 0xc1a10200, 0xc1a117ff, REGISTRY_RIPENCC    }, // 193.161.2.0     - 193.161.23.255 
	{ 0xc1a11a00, 0xc1a11bff, REGISTRY_RIPENCC    }, // 193.161.26.0    - 193.161.27.255 
	{ 0xc1a11d00, 0xc1a16fff, REGISTRY_RIPENCC    }, // 193.161.29.0    - 193.161.111.255
	{ 0xc1a17200, 0xc1a173ff, REGISTRY_RIPENCC    }, // 193.161.114.0   - 193.161.115.255
	{ 0xc1a17500, 0xc1a175ff, REGISTRY_RIPENCC    }, // 193.161.117.0   - 193.161.117.255
	{ 0xc1a17800, 0xc1a192ff, REGISTRY_RIPENCC    }, // 193.161.120.0   - 193.161.146.255
	{ 0xc1a19600, 0xc1a19cff, REGISTRY_RIPENCC    }, // 193.161.150.0   - 193.161.156.255
	{ 0xc1a19e00, 0xc1a1c3ff, REGISTRY_RIPENCC    }, // 193.161.158.0   - 193.161.195.255
	{ 0xc1a1c700, 0xc1a1cbff, REGISTRY_RIPENCC    }, // 193.161.199.0   - 193.161.203.255
	{ 0xc1a1cd00, 0xc1a1cdff, REGISTRY_RIPENCC    }, // 193.161.205.0   - 193.161.205.255
	{ 0xc1a1cf00, 0xc1a1d5ff, REGISTRY_RIPENCC    }, // 193.161.207.0   - 193.161.213.255
	{ 0xc1a1d800, 0xc1a1feff, REGISTRY_RIPENCC    }, // 193.161.216.0   - 193.161.254.255
	{ 0xc1a20000, 0xc1a3ffff, REGISTRY_RIPENCC    }, // 193.162.0.0     - 193.163.255.255
	{ 0xc1a40000, 0xc1a400ff, REGISTRY_RIPENCC    }, // 193.164.0.0     - 193.164.0.255  
	{ 0xc1a40400, 0xc1a405ff, REGISTRY_RIPENCC    }, // 193.164.4.0     - 193.164.5.255  
	{ 0xc1a40800, 0xc1a409ff, REGISTRY_RIPENCC    }, // 193.164.8.0     - 193.164.9.255  
	{ 0xc1a40b00, 0xc1a45fff, REGISTRY_RIPENCC    }, // 193.164.11.0    - 193.164.95.255 
	{ 0xc1a46000, 0xc1a47fff, REGISTRY_RIPENCC    }, // 193.164.96.0    - 193.164.127.255
	{ 0xc1a48000, 0xc1a485ff, REGISTRY_RIPENCC    }, // 193.164.128.0   - 193.164.133.255
	{ 0xc1a48800, 0xc1a494ff, REGISTRY_RIPENCC    }, // 193.164.136.0   - 193.164.148.255
	{ 0xc1a49700, 0xc1a497ff, REGISTRY_RIPENCC    }, // 193.164.151.0   - 193.164.151.255
	{ 0xc1a49900, 0xc1a49fff, REGISTRY_RIPENCC    }, // 193.164.153.0   - 193.164.159.255
	{ 0xc1a4a000, 0xc1a4bfff, REGISTRY_RIPENCC    }, // 193.164.160.0   - 193.164.191.255
	{ 0xc1a4c000, 0xc1a4cfff, REGISTRY_RIPENCC    }, // 193.164.192.0   - 193.164.207.255
	{ 0xc1a4d200, 0xc1a4ddff, REGISTRY_RIPENCC    }, // 193.164.210.0   - 193.164.221.255
	{ 0xc1a4e000, 0xc1a4e85f, REGISTRY_RIPENCC    }, // 193.164.224.0   - 193.164.232.95 
	{ 0xc1a4e880, 0xc1a4f7ff, REGISTRY_RIPENCC    }, // 193.164.232.128 - 193.164.247.255
	{ 0xc1a4fc00, 0xc1a4ffff, REGISTRY_RIPENCC    }, // 193.164.252.0   - 193.164.255.255
	{ 0xc1a50000, 0xc1a7ffff, REGISTRY_RIPENCC    }, // 193.165.0.0     - 193.167.255.255
	{ 0xc1a80000, 0xc1a82dff, REGISTRY_RIPENCC    }, // 193.168.0.0     - 193.168.45.255 
	{ 0xc1a82f00, 0xc1a82fff, REGISTRY_RIPENCC    }, // 193.168.47.0    - 193.168.47.255 
	{ 0xc1a83200, 0xc1a832ff, REGISTRY_RIPENCC    }, // 193.168.50.0    - 193.168.50.255 
	{ 0xc1a83600, 0xc1a83fff, REGISTRY_RIPENCC    }, // 193.168.54.0    - 193.168.63.255 
	{ 0xc1a84000, 0xc1a87fff, REGISTRY_RIPENCC    }, // 193.168.64.0    - 193.168.127.255
	{ 0xc1a88000, 0xc1a919ff, REGISTRY_RIPENCC    }, // 193.168.128.0   - 193.169.25.255 
	{ 0xc1a91c00, 0xc1a969ff, REGISTRY_RIPENCC    }, // 193.169.28.0    - 193.169.105.255
	{ 0xc1a96c00, 0xc1a9a9ff, REGISTRY_RIPENCC    }, // 193.169.108.0   - 193.169.169.255
	{ 0xc1a9ac00, 0xc1a9d9ff, REGISTRY_RIPENCC    }, // 193.169.172.0   - 193.169.217.255
	{ 0xc1a9dc00, 0xc1a9edff, REGISTRY_RIPENCC    }, // 193.169.220.0   - 193.169.237.255
	{ 0xc1a9f000, 0xc1a9f9ff, REGISTRY_RIPENCC    }, // 193.169.240.0   - 193.169.249.255
	{ 0xc1a9fc00, 0xc1a9ffff, REGISTRY_RIPENCC    }, // 193.169.252.0   - 193.169.255.255
	{ 0xc1aa0000, 0xc1afffff, REGISTRY_RIPENCC    }, // 193.170.0.0     - 193.175.255.255
	{ 0xc1b00000, 0xc1b000ff, REGISTRY_RIPENCC    }, // 193.176.0.0     - 193.176.0.255  
	{ 0xc1b00200, 0xc1b027ff, REGISTRY_RIPENCC    }, // 193.176.2.0     - 193.176.39.255 
	{ 0xc1b02b00, 0xc1b06fff, REGISTRY_RIPENCC    }, // 193.176.43.0    - 193.176.111.255
	{ 0xc1b08200, 0xc1b0b3ff, REGISTRY_RIPENCC    }, // 193.176.130.0   - 193.176.179.255
	{ 0xc1b0b600, 0xc1b0d3ff, REGISTRY_RIPENCC    }, // 193.176.182.0   - 193.176.211.255
	{ 0xc1b0d500, 0xc1b1cfff, REGISTRY_RIPENCC    }, // 193.176.213.0   - 193.177.207.255
	{ 0xc1b1e000, 0xc1b1ffff, REGISTRY_RIPENCC    }, // 193.177.224.0   - 193.177.255.255
	{ 0xc1b20100, 0xc1b21eff, REGISTRY_RIPENCC    }, // 193.178.1.0     - 193.178.30.255 
	{ 0xc1b22000, 0xc1b229ff, REGISTRY_RIPENCC    }, // 193.178.32.0    - 193.178.41.255 
	{ 0xc1b22b00, 0xc1b232ff, REGISTRY_RIPENCC    }, // 193.178.43.0    - 193.178.50.255 
	{ 0xc1b23500, 0xc1b277ff, REGISTRY_RIPENCC    }, // 193.178.53.0    - 193.178.119.255
	{ 0xc1b27c00, 0xc1b27fff, REGISTRY_RIPENCC    }, // 193.178.124.0   - 193.178.127.255
	{ 0xc1b28100, 0xc1b28dff, REGISTRY_RIPENCC    }, // 193.178.129.0   - 193.178.141.255
	{ 0xc1b28f00, 0xc1b2a9ff, REGISTRY_RIPENCC    }, // 193.178.143.0   - 193.178.169.255
	{ 0xc1b2ab00, 0xc1b2abff, REGISTRY_RIPENCC    }, // 193.178.171.0   - 193.178.171.255
	{ 0xc1b2ad00, 0xc1b2adff, REGISTRY_RIPENCC    }, // 193.178.173.0   - 193.178.173.255
	{ 0xc1b2af00, 0xc1b2c3ff, REGISTRY_RIPENCC    }, // 193.178.175.0   - 193.178.195.255
	{ 0xc1b2c800, 0xc1b2d3ff, REGISTRY_RIPENCC    }, // 193.178.200.0   - 193.178.211.255
	{ 0xc1b2d500, 0xc1b2d9ff, REGISTRY_RIPENCC    }, // 193.178.213.0   - 193.178.217.255
	{ 0xc1b2db00, 0xc1b2e5ff, REGISTRY_RIPENCC    }, // 193.178.219.0   - 193.178.229.255
	{ 0xc1b2e800, 0xc1b2ffff, REGISTRY_RIPENCC    }, // 193.178.232.0   - 193.178.255.255
	{ 0xc1b30000, 0xc1b9ffff, REGISTRY_RIPENCC    }, // 193.179.0.0     - 193.185.255.255
	{ 0xc1ba0000, 0xc1ba0aff, REGISTRY_RIPENCC    }, // 193.186.0.0     - 193.186.10.255 
	{ 0xc1ba0c00, 0xc1ba9fff, REGISTRY_RIPENCC    }, // 193.186.12.0    - 193.186.159.255
	{ 0xc1baa100, 0xc1babfff, REGISTRY_RIPENCC    }, // 193.186.161.0   - 193.186.191.255
	{ 0xc1bad000, 0xc1bad2ff, REGISTRY_RIPENCC    }, // 193.186.208.0   - 193.186.210.255
	{ 0xc1bad400, 0xc1bad6ff, REGISTRY_RIPENCC    }, // 193.186.212.0   - 193.186.214.255
	{ 0xc1bad800, 0xc1bb93ff, REGISTRY_RIPENCC    }, // 193.186.216.0   - 193.187.147.255
	{ 0xc1bbc400, 0xc1bc00ff, REGISTRY_RIPENCC    }, // 193.187.196.0   - 193.188.0.255  
	{ 0xc1bc0400, 0xc1bc06ff, REGISTRY_RIPENCC    }, // 193.188.4.0     - 193.188.6.255  
	{ 0xc1bc0700, 0xc1bc07ff, REGISTRY_AFRINIC    }, // 193.188.7.0     - 193.188.7.255  
	{ 0xc1bc0800, 0xc1bc0fff, REGISTRY_RIPENCC    }, // 193.188.8.0     - 193.188.15.255 
	{ 0xc1bc2000, 0xc1bc3fff, REGISTRY_RIPENCC    }, // 193.188.32.0    - 193.188.63.255 
	{ 0xc1bc4000, 0xc1bc7fff, REGISTRY_RIPENCC    }, // 193.188.64.0    - 193.188.127.255
	{ 0xc1bc8000, 0xc1bc8687, REGISTRY_RIPENCC    }, // 193.188.128.0   - 193.188.134.135
	{ 0xc1bc8690, 0xc1bc86cf, REGISTRY_RIPENCC    }, // 193.188.134.144 - 193.188.134.207
	{ 0xc1bc86d8, 0xc1bc89ff, REGISTRY_RIPENCC    }, // 193.188.134.216 - 193.188.137.255
	{ 0xc1bc8c00, 0xc1bcc2ff, REGISTRY_RIPENCC    }, // 193.188.140.0   - 193.188.194.255
	{ 0xc1bcc400, 0xc1bcfaff, REGISTRY_RIPENCC    }, // 193.188.196.0   - 193.188.250.255
	{ 0xc1bcfd00, 0xc1bcffff, REGISTRY_RIPENCC    }, // 193.188.253.0   - 193.188.255.255
	{ 0xc1bd0000, 0xc1bd41ff, REGISTRY_AFRINIC    }, // 193.189.0.0     - 193.189.65.255 
	{ 0xc1bd4200, 0xc1bd53ff, REGISTRY_RIPENCC    }, // 193.189.66.0    - 193.189.83.255 
	{ 0xc1bd5600, 0xc1bd59ff, REGISTRY_RIPENCC    }, // 193.189.86.0    - 193.189.89.255 
	{ 0xc1bd5c00, 0xc1bd75ff, REGISTRY_RIPENCC    }, // 193.189.92.0    - 193.189.117.255
	{ 0xc1bd7800, 0xc1bd7fff, REGISTRY_RIPENCC    }, // 193.189.120.0   - 193.189.127.255
	{ 0xc1bd8000, 0xc1bd80ff, REGISTRY_AFRINIC    }, // 193.189.128.0   - 193.189.128.255
	{ 0xc1bd8100, 0xc1bd90ff, REGISTRY_RIPENCC    }, // 193.189.129.0   - 193.189.144.255
	{ 0xc1bd9200, 0xc1bd9fff, REGISTRY_RIPENCC    }, // 193.189.146.0   - 193.189.159.255
	{ 0xc1bda000, 0xc1bfffff, REGISTRY_RIPENCC    }, // 193.189.160.0   - 193.191.255.255
	{ 0xc1c00000, 0xc1c000ff, REGISTRY_RIPENCC    }, // 193.192.0.0     - 193.192.0.255  
	{ 0xc1c00400, 0xc1c00bff, REGISTRY_RIPENCC    }, // 193.192.4.0     - 193.192.11.255 
	{ 0xc1c00c80, 0xc1c00eff, REGISTRY_RIPENCC    }, // 193.192.12.128  - 193.192.14.255 
	{ 0xc1c00f40, 0xc1c00f7f, REGISTRY_RIPENCC    }, // 193.192.15.64   - 193.192.15.127 
	{ 0xc1c00fc0, 0xc1c03fff, REGISTRY_RIPENCC    }, // 193.192.15.192  - 193.192.63.255 
	{ 0xc1c04000, 0xc1c19fff, REGISTRY_RIPENCC    }, // 193.192.64.0    - 193.193.159.255
	{ 0xc1c1a000, 0xc1c1a1ff, REGISTRY_RIPENCC    }, // 193.193.160.0   - 193.193.161.255
	{ 0xc1c1a500, 0xc1c1b5ff, REGISTRY_RIPENCC    }, // 193.193.165.0   - 193.193.181.255
	{ 0xc1c1b700, 0xc1c1bfff, REGISTRY_RIPENCC    }, // 193.193.183.0   - 193.193.191.255
	{ 0xc1c1c000, 0xc1c1ffff, REGISTRY_RIPENCC    }, // 193.193.192.0   - 193.193.255.255
	{ 0xc1c20000, 0xc1c200ff, REGISTRY_RIPENCC    }, // 193.194.0.0     - 193.194.0.255  
	{ 0xc1c20100, 0xc1c205ff, REGISTRY_AFRINIC    }, // 193.194.1.0     - 193.194.5.255  
	{ 0xc1c20600, 0xc1c21fff, REGISTRY_RIPENCC    }, // 193.194.6.0     - 193.194.31.255 
	{ 0xc1c22000, 0xc1c25fff, REGISTRY_AFRINIC    }, // 193.194.32.0    - 193.194.95.255 
	{ 0xc1c26000, 0xc1c27fff, REGISTRY_RIPENCC    }, // 193.194.96.0    - 193.194.127.255
	{ 0xc1c28000, 0xc1c280ff, REGISTRY_AFRINIC    }, // 193.194.128.0   - 193.194.128.255
	{ 0xc1c28100, 0xc1c281ff, REGISTRY_RIPENCC    }, // 193.194.129.0   - 193.194.129.255
	{ 0xc1c28300, 0xc1c292ff, REGISTRY_RIPENCC    }, // 193.194.131.0   - 193.194.146.255
	{ 0xc1c29400, 0xc1c295ff, REGISTRY_RIPENCC    }, // 193.194.148.0   - 193.194.149.255
	{ 0xc1c29800, 0xc1c29aff, REGISTRY_RIPENCC    }, // 193.194.152.0   - 193.194.154.255
	{ 0xc1c29c00, 0xc1c29fff, REGISTRY_RIPENCC    }, // 193.194.156.0   - 193.194.159.255
	{ 0xc1c2a000, 0xc1c2bfff, REGISTRY_AFRINIC    }, // 193.194.160.0   - 193.194.191.255
	{ 0xc1c2c000, 0xc1c7ffff, REGISTRY_RIPENCC    }, // 193.194.192.0   - 193.199.255.255
	{ 0xc1c80100, 0xc1c80cff, REGISTRY_RIPENCC    }, // 193.200.1.0     - 193.200.12.255 
	{ 0xc1c80e00, 0xc1c80fff, REGISTRY_RIPENCC    }, // 193.200.14.0    - 193.200.15.255 
	{ 0xc1c81200, 0xc1c817ff, REGISTRY_RIPENCC    }, // 193.200.18.0    - 193.200.23.255 
	{ 0xc1c81900, 0xc1c819ff, REGISTRY_RIPENCC    }, // 193.200.25.0    - 193.200.25.255 
	{ 0xc1c81c00, 0xc1c833ff, REGISTRY_RIPENCC    }, // 193.200.28.0    - 193.200.51.255 
	{ 0xc1c83600, 0xc1c837ff, REGISTRY_RIPENCC    }, // 193.200.54.0    - 193.200.55.255 
	{ 0xc1c83a00, 0xc1c83dff, REGISTRY_RIPENCC    }, // 193.200.58.0    - 193.200.61.255 
	{ 0xc1c84000, 0xc1c847ff, REGISTRY_RIPENCC    }, // 193.200.64.0    - 193.200.71.255 
	{ 0xc1c84a00, 0xc1c865ff, REGISTRY_RIPENCC    }, // 193.200.74.0    - 193.200.101.255
	{ 0xc1c86800, 0xc1c885ff, REGISTRY_RIPENCC    }, // 193.200.104.0   - 193.200.133.255
	{ 0xc1c88700, 0xc1c897ff, REGISTRY_RIPENCC    }, // 193.200.135.0   - 193.200.151.255
	{ 0xc1c89900, 0xc1c89eff, REGISTRY_RIPENCC    }, // 193.200.153.0   - 193.200.158.255
	{ 0xc1c8a000, 0xc1c8a2ff, REGISTRY_RIPENCC    }, // 193.200.160.0   - 193.200.162.255
	{ 0xc1c8a400, 0xc1c8c1ff, REGISTRY_RIPENCC    }, // 193.200.164.0   - 193.200.193.255
	{ 0xc1c8c300, 0xc1c8d8ff, REGISTRY_RIPENCC    }, // 193.200.195.0   - 193.200.216.255
	{ 0xc1c8da00, 0xc1c8dcff, REGISTRY_RIPENCC    }, // 193.200.218.0   - 193.200.220.255
	{ 0xc1c8de00, 0xc1c8edff, REGISTRY_RIPENCC    }, // 193.200.222.0   - 193.200.237.255
	{ 0xc1c8ef00, 0xc1c8f3ff, REGISTRY_RIPENCC    }, // 193.200.239.0   - 193.200.243.255
	{ 0xc1c8f500, 0xc1c8faff, REGISTRY_RIPENCC    }, // 193.200.245.0   - 193.200.250.255
	{ 0xc1c8fd00, 0xc1c922ff, REGISTRY_RIPENCC    }, // 193.200.253.0   - 193.201.34.255 
	{ 0xc1c92400, 0xc1c925ff, REGISTRY_RIPENCC    }, // 193.201.36.0    - 193.201.37.255 
	{ 0xc1c92700, 0xc1c937ff, REGISTRY_RIPENCC    }, // 193.201.39.0    - 193.201.55.255 
	{ 0xc1c93c00, 0xc1c947ff, REGISTRY_RIPENCC    }, // 193.201.60.0    - 193.201.71.255 
	{ 0xc1c94a00, 0xc1c962ff, REGISTRY_RIPENCC    }, // 193.201.74.0    - 193.201.98.255 
	{ 0xc1c96400, 0xc1c96fff, REGISTRY_RIPENCC    }, // 193.201.100.0   - 193.201.111.255
	{ 0xc1c97400, 0xc1c97dff, REGISTRY_RIPENCC    }, // 193.201.116.0   - 193.201.125.255
	{ 0xc1c98000, 0xc1c9917f, REGISTRY_RIPENCC    }, // 193.201.128.0   - 193.201.145.127
	{ 0xc1c99200, 0xc1c993bf, REGISTRY_RIPENCC    }, // 193.201.146.0   - 193.201.147.191
	{ 0xc1c993e0, 0xc1c9947f, REGISTRY_RIPENCC    }, // 193.201.147.224 - 193.201.148.127
	{ 0xc1c994c0, 0xc1c9957f, REGISTRY_RIPENCC    }, // 193.201.148.192 - 193.201.149.127
	{ 0xc1c995c0, 0xc1c996bf, REGISTRY_RIPENCC    }, // 193.201.149.192 - 193.201.150.191
	{ 0xc1c99700, 0xc1c9977f, REGISTRY_RIPENCC    }, // 193.201.151.0   - 193.201.151.127
	{ 0xc1c997c0, 0xc1c99aff, REGISTRY_RIPENCC    }, // 193.201.151.192 - 193.201.154.255
	{ 0xc1c99b80, 0xc1c99d7f, REGISTRY_RIPENCC    }, // 193.201.155.128 - 193.201.157.127
	{ 0xc1c99e00, 0xc1c99eff, REGISTRY_RIPENCC    }, // 193.201.158.0   - 193.201.158.255
	{ 0xc1c99f80, 0xc1c9bfff, REGISTRY_RIPENCC    }, // 193.201.159.128 - 193.201.191.255
	{ 0xc1c9c200, 0xc1c9cfff, REGISTRY_RIPENCC    }, // 193.201.194.0   - 193.201.207.255
	{ 0xc1c9d400, 0xc1c9f3ff, REGISTRY_RIPENCC    }, // 193.201.212.0   - 193.201.243.255
	{ 0xc1c9f800, 0xc1ca07ff, REGISTRY_RIPENCC    }, // 193.201.248.0   - 193.202.7.255  
	{ 0xc1ca1000, 0xc1ca1eff, REGISTRY_RIPENCC    }, // 193.202.16.0    - 193.202.30.255 
	{ 0xc1ca2000, 0xc1ca49ff, REGISTRY_RIPENCC    }, // 193.202.32.0    - 193.202.73.255 
	{ 0xc1ca4b00, 0xc1ca6fff, REGISTRY_RIPENCC    }, // 193.202.75.0    - 193.202.111.255
	{ 0xc1ca7100, 0xc1cb07ff, REGISTRY_RIPENCC    }, // 193.202.113.0   - 193.203.7.255  
	{ 0xc1cb1000, 0xc1cb15ff, REGISTRY_RIPENCC    }, // 193.203.16.0    - 193.203.21.255 
	{ 0xc1cb1700, 0xc1cb1dff, REGISTRY_RIPENCC    }, // 193.203.23.0    - 193.203.29.255 
	{ 0xc1cb2000, 0xc1cb33ff, REGISTRY_RIPENCC    }, // 193.203.32.0    - 193.203.51.255 
	{ 0xc1cb3800, 0xc1cb3fff, REGISTRY_RIPENCC    }, // 193.203.56.0    - 193.203.63.255 
	{ 0xc1cb4000, 0xc1cb5fff, REGISTRY_RIPENCC    }, // 193.203.64.0    - 193.203.95.255 
	{ 0xc1cb6000, 0xc1cb6dff, REGISTRY_RIPENCC    }, // 193.203.96.0    - 193.203.109.255
	{ 0xc1cb7000, 0xc1cb7fff, REGISTRY_RIPENCC    }, // 193.203.112.0   - 193.203.127.255
	{ 0xc1cb8000, 0xc1cbbfff, REGISTRY_RIPENCC    }, // 193.203.128.0   - 193.203.191.255
	{ 0xc1cbc000, 0xc1cbd5ff, REGISTRY_RIPENCC    }, // 193.203.192.0   - 193.203.213.255
	{ 0xc1cbd800, 0xc1cbffff, REGISTRY_RIPENCC    }, // 193.203.216.0   - 193.203.255.255
	{ 0xc1cc0000, 0xc1d9ffff, REGISTRY_RIPENCC    }, // 193.204.0.0     - 193.217.255.255
	{ 0xc1da0000, 0xc1da06ff, REGISTRY_RIPENCC    }, // 193.218.0.0     - 193.218.6.255  
	{ 0xc1da0800, 0xc1da1fff, REGISTRY_RIPENCC    }, // 193.218.8.0     - 193.218.31.255 
	{ 0xc1da2100, 0xc1da21ff, REGISTRY_RIPENCC    }, // 193.218.33.0    - 193.218.33.255 
	{ 0xc1da2400, 0xc1da51ff, REGISTRY_RIPENCC    }, // 193.218.36.0    - 193.218.81.255 
	{ 0xc1da5400, 0xc1da68ff, REGISTRY_RIPENCC    }, // 193.218.84.0    - 193.218.104.255
	{ 0xc1da6a00, 0xc1da78ff, REGISTRY_RIPENCC    }, // 193.218.106.0   - 193.218.120.255
	{ 0xc1da7a00, 0xc1da9bff, REGISTRY_RIPENCC    }, // 193.218.122.0   - 193.218.155.255
	{ 0xc1da9c00, 0xc1daafff, REGISTRY_RIPENCC    }, // 193.218.156.0   - 193.218.175.255
	{ 0xc1dab000, 0xc1dac8ff, REGISTRY_RIPENCC    }, // 193.218.176.0   - 193.218.200.255
	{ 0xc1daca00, 0xc1dacbff, REGISTRY_RIPENCC    }, // 193.218.202.0   - 193.218.203.255
	{ 0xc1dacd00, 0xc1dacfff, REGISTRY_RIPENCC    }, // 193.218.205.0   - 193.218.207.255
	{ 0xc1dad000, 0xc1daddff, REGISTRY_RIPENCC    }, // 193.218.208.0   - 193.218.221.255
	{ 0xc1dade00, 0xc1daffff, REGISTRY_RIPENCC    }, // 193.218.222.0   - 193.218.255.255
	{ 0xc1db0100, 0xc1db06ff, REGISTRY_RIPENCC    }, // 193.219.1.0     - 193.219.6.255  
	{ 0xc1db0800, 0xc1db1fff, REGISTRY_RIPENCC    }, // 193.219.8.0     - 193.219.31.255 
	{ 0xc1db2000, 0xc1db5fff, REGISTRY_RIPENCC    }, // 193.219.32.0    - 193.219.95.255 
	{ 0xc1db6000, 0xc1db64ff, REGISTRY_RIPENCC    }, // 193.219.96.0    - 193.219.100.255
	{ 0xc1db6600, 0xc1db78ff, REGISTRY_RIPENCC    }, // 193.219.102.0   - 193.219.120.255
	{ 0xc1db7a00, 0xc1db7fff, REGISTRY_RIPENCC    }, // 193.219.122.0   - 193.219.127.255
	{ 0xc1db8000, 0xc1dcffff, REGISTRY_RIPENCC    }, // 193.219.128.0   - 193.220.255.255
	{ 0xc1dd0000, 0xc1dd77ff, REGISTRY_RIPENCC    }, // 193.221.0.0     - 193.221.119.255
	{ 0xc1dd7900, 0xc1dd7aff, REGISTRY_RIPENCC    }, // 193.221.121.0   - 193.221.122.255
	{ 0xc1dd7c00, 0xc1ddbfff, REGISTRY_RIPENCC    }, // 193.221.124.0   - 193.221.191.255
	{ 0xc1ddd400, 0xc1ddd9ff, REGISTRY_RIPENCC    }, // 193.221.212.0   - 193.221.217.255
	{ 0xc1ddda00, 0xc1dddaff, REGISTRY_AFRINIC    }, // 193.221.218.0   - 193.221.218.255
	{ 0xc1dddb00, 0xc1de6eff, REGISTRY_RIPENCC    }, // 193.221.219.0   - 193.222.110.255
	{ 0xc1de7000, 0xc1de8fff, REGISTRY_RIPENCC    }, // 193.222.112.0   - 193.222.143.255
	{ 0xc1de9300, 0xc1debbff, REGISTRY_RIPENCC    }, // 193.222.147.0   - 193.222.187.255
	{ 0xc1debe00, 0xc1df3fff, REGISTRY_RIPENCC    }, // 193.222.190.0   - 193.223.63.255 
	{ 0xc1df4400, 0xc1df44ff, REGISTRY_RIPENCC    }, // 193.223.68.0    - 193.223.68.255 
	{ 0xc1df4c00, 0xc1df66ff, REGISTRY_RIPENCC    }, // 193.223.76.0    - 193.223.102.255
	{ 0xc1df6800, 0xc1df6eff, REGISTRY_RIPENCC    }, // 193.223.104.0   - 193.223.110.255
	{ 0xc1df7000, 0xc1dfffff, REGISTRY_RIPENCC    }, // 193.223.112.0   - 193.223.255.255
	{ 0xc1e00000, 0xc1e2ffff, REGISTRY_RIPENCC    }, // 193.224.0.0     - 193.226.255.255
	{ 0xc1e30000, 0xc1e33fff, REGISTRY_AFRINIC    }, // 193.227.0.0     - 193.227.63.255 
	{ 0xc1e34000, 0xc1e35fff, REGISTRY_RIPENCC    }, // 193.227.64.0    - 193.227.95.255 
	{ 0xc1e36000, 0xc1e366ff, REGISTRY_RIPENCC    }, // 193.227.96.0    - 193.227.102.255
	{ 0xc1e36800, 0xc1e36cff, REGISTRY_RIPENCC    }, // 193.227.104.0   - 193.227.108.255
	{ 0xc1e36e00, 0xc1e371ff, REGISTRY_RIPENCC    }, // 193.227.110.0   - 193.227.113.255
	{ 0xc1e37300, 0xc1e378ff, REGISTRY_RIPENCC    }, // 193.227.115.0   - 193.227.120.255
	{ 0xc1e37b00, 0xc1e37cff, REGISTRY_RIPENCC    }, // 193.227.123.0   - 193.227.124.255
	{ 0xc1e37e00, 0xc1e37fff, REGISTRY_RIPENCC    }, // 193.227.126.0   - 193.227.127.255
	{ 0xc1e38000, 0xc1e380ff, REGISTRY_AFRINIC    }, // 193.227.128.0   - 193.227.128.255
	{ 0xc1e38200, 0xc1e39fff, REGISTRY_RIPENCC    }, // 193.227.130.0   - 193.227.159.255
	{ 0xc1e3a000, 0xc1e3bfff, REGISTRY_RIPENCC    }, // 193.227.160.0   - 193.227.191.255
	{ 0xc1e3c000, 0xc1e3ebff, REGISTRY_RIPENCC    }, // 193.227.192.0   - 193.227.235.255
	{ 0xc1e3ee00, 0xc1e48bff, REGISTRY_RIPENCC    }, // 193.227.238.0   - 193.228.139.255
	{ 0xc1e48d00, 0xc1e490ff, REGISTRY_RIPENCC    }, // 193.228.141.0   - 193.228.144.255
	{ 0xc1e49200, 0xc1e493ff, REGISTRY_RIPENCC    }, // 193.228.146.0   - 193.228.147.255
	{ 0xc1e49500, 0xc1e4b5ff, REGISTRY_RIPENCC    }, // 193.228.149.0   - 193.228.181.255
	{ 0xc1e4b800, 0xc1e4bbff, REGISTRY_RIPENCC    }, // 193.228.184.0   - 193.228.187.255
	{ 0xc1e4bd00, 0xc1e4ffff, REGISTRY_RIPENCC    }, // 193.228.189.0   - 193.228.255.255
	{ 0xc1e50000, 0xc1edffff, REGISTRY_RIPENCC    }, // 193.229.0.0     - 193.237.255.255
	{ 0xc1ee0400, 0xc1ee27ff, REGISTRY_RIPENCC    }, // 193.238.4.0     - 193.238.39.255 
	{ 0xc1ee2800, 0xc1ee2bff, REGISTRY_RIPENCC    }, // 193.238.40.0    - 193.238.43.255 
	{ 0xc1ee3000, 0xc1eebfff, REGISTRY_RIPENCC    }, // 193.238.48.0    - 193.238.191.255
	{ 0xc1eec400, 0xc1eeebff, REGISTRY_RIPENCC    }, // 193.238.196.0   - 193.238.235.255
	{ 0xc1eef000, 0xc1ef91ff, REGISTRY_RIPENCC    }, // 193.238.240.0   - 193.239.145.255
	{ 0xc1ef9400, 0xc1ef95ff, REGISTRY_RIPENCC    }, // 193.239.148.0   - 193.239.149.255
	{ 0xc1ef9800, 0xc1ef99ff, REGISTRY_RIPENCC    }, // 193.239.152.0   - 193.239.153.255
	{ 0xc1ef9c00, 0xc1ef9fff, REGISTRY_RIPENCC    }, // 193.239.156.0   - 193.239.159.255
	{ 0xc1efa200, 0xc1efa5ff, REGISTRY_RIPENCC    }, // 193.239.162.0   - 193.239.165.255
	{ 0xc1efa800, 0xc1efb1ff, REGISTRY_RIPENCC    }, // 193.239.168.0   - 193.239.177.255
	{ 0xc1efb400, 0xc1efbdff, REGISTRY_RIPENCC    }, // 193.239.180.0   - 193.239.189.255
	{ 0xc1efc000, 0xc1efc3ff, REGISTRY_RIPENCC    }, // 193.239.192.0   - 193.239.195.255
	{ 0xc1efc600, 0xc1efebff, REGISTRY_RIPENCC    }, // 193.239.198.0   - 193.239.235.255
	{ 0xc1efee00, 0xc1eff3ff, REGISTRY_RIPENCC    }, // 193.239.238.0   - 193.239.243.255
	{ 0xc1eff600, 0xc1efffff, REGISTRY_RIPENCC    }, // 193.239.246.0   - 193.239.255.255
	{ 0xc1f00000, 0xc1f0ffff, REGISTRY_RIPENCC    }, // 193.240.0.0     - 193.240.255.255
	{ 0xc1f10000, 0xc1f26cff, REGISTRY_RIPENCC    }, // 193.241.0.0     - 193.242.108.255
	{ 0xc1f26e00, 0xc1f385ff, REGISTRY_RIPENCC    }, // 193.242.110.0   - 193.243.133.255
	{ 0xc1f38800, 0xc1f395ff, REGISTRY_RIPENCC    }, // 193.243.136.0   - 193.243.149.255
	{ 0xc1f39800, 0xc1f3a0ff, REGISTRY_RIPENCC    }, // 193.243.152.0   - 193.243.160.255
	{ 0xc1f3a200, 0xc1f3a5ff, REGISTRY_RIPENCC    }, // 193.243.162.0   - 193.243.165.255
	{ 0xc1f3a700, 0xc1f3b5ff, REGISTRY_RIPENCC    }, // 193.243.167.0   - 193.243.181.255
	{ 0xc1f3b700, 0xc1f3b77f, REGISTRY_RIPENCC    }, // 193.243.183.0   - 193.243.183.127
	{ 0xc1f3b7c0, 0xc1f3bfff, REGISTRY_RIPENCC    }, // 193.243.183.192 - 193.243.191.255
	{ 0xc1f3c000, 0xc1f3ffff, REGISTRY_RIPENCC    }, // 193.243.192.0   - 193.243.255.255
	{ 0xc1f40000, 0xc1f5ffff, REGISTRY_RIPENCC    }, // 193.244.0.0     - 193.245.255.255
	{ 0xc1f60000, 0xc1fdffff, REGISTRY_RIPENCC    }, // 193.246.0.0     - 193.253.255.255
	{ 0xc1fe0040, 0xc1fe07ff, REGISTRY_RIPENCC    }, // 193.254.0.64    - 193.254.7.255  
	{ 0xc1fe1200, 0xc1fe1aff, REGISTRY_RIPENCC    }, // 193.254.18.0    - 193.254.26.255 
	{ 0xc1fe1d00, 0xc1fe1fff, REGISTRY_RIPENCC    }, // 193.254.29.0    - 193.254.31.255 
	{ 0xc1fe2000, 0xc1feafff, REGISTRY_RIPENCC    }, // 193.254.32.0    - 193.254.175.255
	{ 0xc1feb000, 0xc1fecbff, REGISTRY_RIPENCC    }, // 193.254.176.0   - 193.254.203.255
	{ 0xc1fece00, 0xc1fed9ff, REGISTRY_RIPENCC    }, // 193.254.206.0   - 193.254.217.255
	{ 0xc1fedc00, 0xc1fee9ff, REGISTRY_RIPENCC    }, // 193.254.220.0   - 193.254.233.255
	{ 0xc1feec00, 0xc1fef3ff, REGISTRY_RIPENCC    }, // 193.254.236.0   - 193.254.243.255
	{ 0xc1fef600, 0xc1feffff, REGISTRY_RIPENCC    }, // 193.254.246.0   - 193.254.255.255
	{ 0xc1ff0000, 0xc1ffffff, REGISTRY_RIPENCC    }, // 193.255.0.0     - 193.255.255.255
	{ 0xc2000000, 0xc20067ff, REGISTRY_RIPENCC    }, // 194.0.0.0       - 194.0.103.255  
	{ 0xc2006c00, 0xc20073ff, REGISTRY_RIPENCC    }, // 194.0.108.0     - 194.0.115.255  
	{ 0xc2007800, 0xc20084ff, REGISTRY_RIPENCC    }, // 194.0.120.0     - 194.0.132.255  
	{ 0xc2008600, 0xc2008aff, REGISTRY_RIPENCC    }, // 194.0.134.0     - 194.0.138.255  
	{ 0xc2008c00, 0xc2008cff, REGISTRY_RIPENCC    }, // 194.0.140.0     - 194.0.140.255  
	{ 0xc2008e00, 0xc2009eff, REGISTRY_RIPENCC    }, // 194.0.142.0     - 194.0.158.255  
	{ 0xc200a000, 0xc200b3ff, REGISTRY_RIPENCC    }, // 194.0.160.0     - 194.0.179.255  
	{ 0xc200b500, 0xc200b9ff, REGISTRY_RIPENCC    }, // 194.0.181.0     - 194.0.185.255  
	{ 0xc200bb00, 0xc200bbff, REGISTRY_RIPENCC    }, // 194.0.187.0     - 194.0.187.255  
	{ 0xc200be00, 0xc200c0ff, REGISTRY_RIPENCC    }, // 194.0.190.0     - 194.0.192.255  
	{ 0xc200c200, 0xc200dcff, REGISTRY_RIPENCC    }, // 194.0.194.0     - 194.0.220.255  
	{ 0xc200de00, 0xc200deff, REGISTRY_RIPENCC    }, // 194.0.222.0     - 194.0.222.255  
	{ 0xc200e000, 0xc200e3ff, REGISTRY_RIPENCC    }, // 194.0.224.0     - 194.0.227.255  
	{ 0xc200e500, 0xc200e6ff, REGISTRY_RIPENCC    }, // 194.0.229.0     - 194.0.230.255  
	{ 0xc200e800, 0xc200f2ff, REGISTRY_RIPENCC    }, // 194.0.232.0     - 194.0.242.255  
	{ 0xc200f500, 0xc200f7ff, REGISTRY_RIPENCC    }, // 194.0.245.0     - 194.0.247.255  
	{ 0xc200f900, 0xc201b0ff, REGISTRY_RIPENCC    }, // 194.0.249.0     - 194.1.176.255  
	{ 0xc201b200, 0xc201b2ff, REGISTRY_RIPENCC    }, // 194.1.178.0     - 194.1.178.255  
	{ 0xc201b400, 0xc201b9ff, REGISTRY_RIPENCC    }, // 194.1.180.0     - 194.1.185.255  
	{ 0xc201bc00, 0xc201d9ff, REGISTRY_RIPENCC    }, // 194.1.188.0     - 194.1.217.255  
	{ 0xc201db00, 0xc201ffff, REGISTRY_RIPENCC    }, // 194.1.219.0     - 194.1.255.255  
	{ 0xc2020000, 0xc203ffff, REGISTRY_RIPENCC    }, // 194.2.0.0       - 194.3.255.255  
	{ 0xc2040000, 0xc20407ff, REGISTRY_RIPENCC    }, // 194.4.0.0       - 194.4.7.255    
	{ 0xc2040a00, 0xc20437ff, REGISTRY_RIPENCC    }, // 194.4.10.0      - 194.4.55.255   
	{ 0xc2044800, 0xc20463ff, REGISTRY_RIPENCC    }, // 194.4.72.0      - 194.4.99.255   
	{ 0xc2046800, 0xc2050cff, REGISTRY_RIPENCC    }, // 194.4.104.0     - 194.5.12.255   
	{ 0xc2051000, 0xc2051bff, REGISTRY_RIPENCC    }, // 194.5.16.0      - 194.5.27.255   
	{ 0xc2051e00, 0xc20527ff, REGISTRY_RIPENCC    }, // 194.5.30.0      - 194.5.39.255   
	{ 0xc2052a00, 0xc20530ff, REGISTRY_RIPENCC    }, // 194.5.42.0      - 194.5.48.255   
	{ 0xc2053200, 0xc20546ff, REGISTRY_RIPENCC    }, // 194.5.50.0      - 194.5.70.255   
	{ 0xc2054800, 0xc2054dff, REGISTRY_RIPENCC    }, // 194.5.72.0      - 194.5.77.255   
	{ 0xc2054f00, 0xc20551ff, REGISTRY_RIPENCC    }, // 194.5.79.0      - 194.5.81.255   
	{ 0xc2055700, 0xc20562ff, REGISTRY_RIPENCC    }, // 194.5.87.0      - 194.5.98.255   
	{ 0xc2056400, 0xc2057eff, REGISTRY_RIPENCC    }, // 194.5.100.0     - 194.5.126.255  
	{ 0xc2058000, 0xc20597ff, REGISTRY_RIPENCC    }, // 194.5.128.0     - 194.5.151.255  
	{ 0xc205a100, 0xc205a2ff, REGISTRY_RIPENCC    }, // 194.5.161.0     - 194.5.162.255  
	{ 0xc205a400, 0xc205b1ff, REGISTRY_RIPENCC    }, // 194.5.164.0     - 194.5.177.255  
	{ 0xc205b400, 0xc205bfff, REGISTRY_RIPENCC    }, // 194.5.180.0     - 194.5.191.255  
	{ 0xc205c100, 0xc205d0ff, REGISTRY_RIPENCC    }, // 194.5.193.0     - 194.5.208.255  
	{ 0xc205d200, 0xc205d3ff, REGISTRY_RIPENCC    }, // 194.5.210.0     - 194.5.211.255  
	{ 0xc205da00, 0xc205e1ff, REGISTRY_RIPENCC    }, // 194.5.218.0     - 194.5.225.255  
	{ 0xc205e400, 0xc205e7ff, REGISTRY_RIPENCC    }, // 194.5.228.0     - 194.5.231.255  
	{ 0xc205ea00, 0xc205f1ff, REGISTRY_RIPENCC    }, // 194.5.234.0     - 194.5.241.255  
	{ 0xc205f300, 0xc205f3ff, REGISTRY_RIPENCC    }, // 194.5.243.0     - 194.5.243.255  
	{ 0xc205f600, 0xc205ffff, REGISTRY_RIPENCC    }, // 194.5.246.0     - 194.5.255.255  
	{ 0xc2060000, 0xc206bfff, REGISTRY_RIPENCC    }, // 194.6.0.0       - 194.6.191.255  
	{ 0xc206c000, 0xc206cbff, REGISTRY_RIPENCC    }, // 194.6.192.0     - 194.6.203.255  
	{ 0xc206cc00, 0xc206cfff, REGISTRY_RIPENCC    }, // 194.6.204.0     - 194.6.207.255  
	{ 0xc206d000, 0xc206dfff, REGISTRY_RIPENCC    }, // 194.6.208.0     - 194.6.223.255  
	{ 0xc206e000, 0xc206e0ff, REGISTRY_AFRINIC    }, // 194.6.224.0     - 194.6.224.255  
	{ 0xc206e100, 0xc206e9ff, REGISTRY_RIPENCC    }, // 194.6.225.0     - 194.6.233.255  
	{ 0xc206eb00, 0xc206f6ff, REGISTRY_RIPENCC    }, // 194.6.235.0     - 194.6.246.255  
	{ 0xc206f800, 0xc206faff, REGISTRY_RIPENCC    }, // 194.6.248.0     - 194.6.250.255  
	{ 0xc206fd00, 0xc206fdff, REGISTRY_RIPENCC    }, // 194.6.253.0     - 194.6.253.255  
	{ 0xc206ff00, 0xc206ffff, REGISTRY_RIPENCC    }, // 194.6.255.0     - 194.6.255.255  
	{ 0xc2070000, 0xc207ffff, REGISTRY_RIPENCC    }, // 194.7.0.0       - 194.7.255.255  
	{ 0xc2080000, 0xc2081bff, REGISTRY_RIPENCC    }, // 194.8.0.0       - 194.8.27.255   
	{ 0xc2081d00, 0xc2082fff, REGISTRY_RIPENCC    }, // 194.8.29.0      - 194.8.47.255   
	{ 0xc2083100, 0xc2083aff, REGISTRY_RIPENCC    }, // 194.8.49.0      - 194.8.58.255   
	{ 0xc2083c00, 0xc20855ff, REGISTRY_RIPENCC    }, // 194.8.60.0      - 194.8.85.255   
	{ 0xc2085800, 0xc2085fff, REGISTRY_RIPENCC    }, // 194.8.88.0      - 194.8.95.255   
	{ 0xc2086000, 0xc2087fff, REGISTRY_RIPENCC    }, // 194.8.96.0      - 194.8.127.255  
	{ 0xc2088000, 0xc2089fff, REGISTRY_RIPENCC    }, // 194.8.128.0     - 194.8.159.255  
	{ 0xc208a000, 0xc208dfff, REGISTRY_RIPENCC    }, // 194.8.160.0     - 194.8.223.255  
	{ 0xc208e000, 0xc208ffff, REGISTRY_RIPENCC    }, // 194.8.224.0     - 194.8.255.255  
	{ 0xc2090200, 0xc20907ff, REGISTRY_RIPENCC    }, // 194.9.2.0       - 194.9.7.255    
	{ 0xc2090a00, 0xc20911ff, REGISTRY_RIPENCC    }, // 194.9.10.0      - 194.9.17.255   
	{ 0xc2091400, 0xc20937ff, REGISTRY_RIPENCC    }, // 194.9.20.0      - 194.9.55.255   
	{ 0xc2093a00, 0xc2093fff, REGISTRY_RIPENCC    }, // 194.9.58.0      - 194.9.63.255   
	{ 0xc2094000, 0xc20941ff, REGISTRY_AFRINIC    }, // 194.9.64.0      - 194.9.65.255   
	{ 0xc2094200, 0xc2094fff, REGISTRY_RIPENCC    }, // 194.9.66.0      - 194.9.79.255   
	{ 0xc2095200, 0xc20953ff, REGISTRY_AFRINIC    }, // 194.9.82.0      - 194.9.83.255   
	{ 0xc2095400, 0xc209abff, REGISTRY_RIPENCC    }, // 194.9.84.0      - 194.9.171.255  
	{ 0xc209af00, 0xc209afff, REGISTRY_RIPENCC    }, // 194.9.175.0     - 194.9.175.255  
	{ 0xc209b400, 0xc209b7ff, REGISTRY_RIPENCC    }, // 194.9.180.0     - 194.9.183.255  
	{ 0xc209bc00, 0xc209cfff, REGISTRY_RIPENCC    }, // 194.9.188.0     - 194.9.207.255  
	{ 0xc209d400, 0xc209d7ff, REGISTRY_RIPENCC    }, // 194.9.212.0     - 194.9.215.255  
	{ 0xc209dc00, 0xc209ddff, REGISTRY_RIPENCC    }, // 194.9.220.0     - 194.9.221.255  
	{ 0xc209df00, 0xc209ffff, REGISTRY_RIPENCC    }, // 194.9.223.0     - 194.9.255.255  
	{ 0xc20a0000, 0xc20affff, REGISTRY_RIPENCC    }, // 194.10.0.0      - 194.10.255.255 
	{ 0xc20b0000, 0xc20b12ff, REGISTRY_RIPENCC    }, // 194.11.0.0      - 194.11.18.255  
	{ 0xc20b1400, 0xc20b18ff, REGISTRY_RIPENCC    }, // 194.11.20.0     - 194.11.24.255  
	{ 0xc20b1a00, 0xc20b83ff, REGISTRY_RIPENCC    }, // 194.11.26.0     - 194.11.131.255 
	{ 0xc20b8500, 0xc20bdbff, REGISTRY_RIPENCC    }, // 194.11.133.0    - 194.11.219.255 
	{ 0xc20bdd00, 0xc20bdfff, REGISTRY_RIPENCC    }, // 194.11.221.0    - 194.11.223.255 
	{ 0xc20be100, 0xc20beeff, REGISTRY_RIPENCC    }, // 194.11.225.0    - 194.11.238.255 
	{ 0xc20bf000, 0xc20bf3ff, REGISTRY_RIPENCC    }, // 194.11.240.0    - 194.11.243.255 
	{ 0xc20bf600, 0xc20bfaff, REGISTRY_RIPENCC    }, // 194.11.246.0    - 194.11.250.255 
	{ 0xc20bfc00, 0xc20bfeff, REGISTRY_RIPENCC    }, // 194.11.252.0    - 194.11.254.255 
	{ 0xc20c0000, 0xc20c1fff, REGISTRY_RIPENCC    }, // 194.12.0.0      - 194.12.31.255  
	{ 0xc20c2000, 0xc20c2fff, REGISTRY_RIPENCC    }, // 194.12.32.0     - 194.12.47.255  
	{ 0xc20c3000, 0xc20c3fff, REGISTRY_RIPENCC    }, // 194.12.48.0     - 194.12.63.255  
	{ 0xc20c4000, 0xc20cdfff, REGISTRY_RIPENCC    }, // 194.12.64.0     - 194.12.223.255 
	{ 0xc20ce000, 0xc20cffff, REGISTRY_RIPENCC    }, // 194.12.224.0    - 194.12.255.255 
	{ 0xc20d0000, 0xc20d87ff, REGISTRY_RIPENCC    }, // 194.13.0.0      - 194.13.135.255 
	{ 0xc20d8a00, 0xc20d8aff, REGISTRY_RIPENCC    }, // 194.13.138.0    - 194.13.138.255 
	{ 0xc20d8c00, 0xc20dffff, REGISTRY_RIPENCC    }, // 194.13.140.0    - 194.13.255.255 
	{ 0xc20e0000, 0xc20effff, REGISTRY_RIPENCC    }, // 194.14.0.0      - 194.14.255.255 
	{ 0xc20f0000, 0xc20f1fff, REGISTRY_RIPENCC    }, // 194.15.0.0      - 194.15.31.255  
	{ 0xc20f4000, 0xc20f97ff, REGISTRY_RIPENCC    }, // 194.15.64.0     - 194.15.151.255 
	{ 0xc20f9a00, 0xc20fdfff, REGISTRY_RIPENCC    }, // 194.15.154.0    - 194.15.223.255 
	{ 0xc20fe400, 0xc20fffff, REGISTRY_RIPENCC    }, // 194.15.228.0    - 194.15.255.255 
	{ 0xc2100000, 0xc217ffff, REGISTRY_RIPENCC    }, // 194.16.0.0      - 194.23.255.255 
	{ 0xc2180000, 0xc218a1ff, REGISTRY_RIPENCC    }, // 194.24.0.0      - 194.24.161.255 
	{ 0xc218a400, 0xc218afff, REGISTRY_RIPENCC    }, // 194.24.164.0    - 194.24.175.255 
	{ 0xc218b200, 0xc218bfff, REGISTRY_RIPENCC    }, // 194.24.178.0    - 194.24.191.255 
	{ 0xc218c000, 0xc218dfff, REGISTRY_RIPENCC    }, // 194.24.192.0    - 194.24.223.255 
	{ 0xc218e000, 0xc218e7ff, REGISTRY_RIPENCC    }, // 194.24.224.0    - 194.24.231.255 
	{ 0xc218ea00, 0xc218f9ff, REGISTRY_RIPENCC    }, // 194.24.234.0    - 194.24.249.255 
	{ 0xc218fc00, 0xc218ffff, REGISTRY_RIPENCC    }, // 194.24.252.0    - 194.24.255.255 
	{ 0xc2190000, 0xc219ffff, REGISTRY_RIPENCC    }, // 194.25.0.0      - 194.25.255.255 
	{ 0xc21a0000, 0xc21a18ff, REGISTRY_RIPENCC    }, // 194.26.0.0      - 194.26.24.255  
	{ 0xc21a1a00, 0xc21a46ff, REGISTRY_RIPENCC    }, // 194.26.26.0     - 194.26.70.255  
	{ 0xc21a4800, 0xc21a4bff, REGISTRY_RIPENCC    }, // 194.26.72.0     - 194.26.75.255  
	{ 0xc21a4d00, 0xc21a63ff, REGISTRY_RIPENCC    }, // 194.26.77.0     - 194.26.99.255  
	{ 0xc21a6500, 0xc21a6bff, REGISTRY_RIPENCC    }, // 194.26.101.0    - 194.26.107.255 
	{ 0xc21a6d00, 0xc21a71ff, REGISTRY_RIPENCC    }, // 194.26.109.0    - 194.26.113.255 
	{ 0xc21a7300, 0xc21a74ff, REGISTRY_RIPENCC    }, // 194.26.115.0    - 194.26.116.255 
	{ 0xc21a7600, 0xc21aafff, REGISTRY_RIPENCC    }, // 194.26.118.0    - 194.26.175.255 
	{ 0xc21ab800, 0xc21affff, REGISTRY_RIPENCC    }, // 194.26.184.0    - 194.26.255.255 
	{ 0xc21b0000, 0xc21bffff, REGISTRY_RIPENCC    }, // 194.27.0.0      - 194.27.255.255 
	{ 0xc21c0000, 0xc21c2bff, REGISTRY_RIPENCC    }, // 194.28.0.0      - 194.28.43.255  
	{ 0xc21c3000, 0xc21cffff, REGISTRY_RIPENCC    }, // 194.28.48.0     - 194.28.255.255 
	{ 0xc21d0000, 0xc21d1fff, REGISTRY_RIPENCC    }, // 194.29.0.0      - 194.29.31.255  
	{ 0xc21d2000, 0xc21d33ff, REGISTRY_RIPENCC    }, // 194.29.32.0     - 194.29.51.255  
	{ 0xc21d3800, 0xc21d3fff, REGISTRY_RIPENCC    }, // 194.29.56.0     - 194.29.63.255  
	{ 0xc21d4000, 0xc21d7fff, REGISTRY_RIPENCC    }, // 194.29.64.0     - 194.29.127.255 
	{ 0xc21d8000, 0xc21ddfff, REGISTRY_RIPENCC    }, // 194.29.128.0    - 194.29.223.255 
	{ 0xc21de000, 0xc21e9fff, REGISTRY_RIPENCC    }, // 194.29.224.0    - 194.30.159.255 
	{ 0xc21ea000, 0xc21ea4ff, REGISTRY_RIPENCC    }, // 194.30.160.0    - 194.30.164.255 
	{ 0xc21ea600, 0xc21eafff, REGISTRY_RIPENCC    }, // 194.30.166.0    - 194.30.175.255 
	{ 0xc21eb200, 0xc21eb6ff, REGISTRY_RIPENCC    }, // 194.30.178.0    - 194.30.182.255 
	{ 0xc21eb800, 0xc21ebfff, REGISTRY_RIPENCC    }, // 194.30.184.0    - 194.30.191.255 
	{ 0xc21ec000, 0xc21effff, REGISTRY_RIPENCC    }, // 194.30.192.0    - 194.30.255.255 
	{ 0xc21f0000, 0xc21f33ff, REGISTRY_RIPENCC    }, // 194.31.0.0      - 194.31.51.255  
	{ 0xc21f3800, 0xc21f3fff, REGISTRY_RIPENCC    }, // 194.31.56.0     - 194.31.63.255  
	{ 0xc21f4100, 0xc21f56ff, REGISTRY_RIPENCC    }, // 194.31.65.0     - 194.31.86.255  
	{ 0xc21f5800, 0xc21fd6ff, REGISTRY_RIPENCC    }, // 194.31.88.0     - 194.31.214.255 
	{ 0xc21fd800, 0xc21febff, REGISTRY_RIPENCC    }, // 194.31.216.0    - 194.31.235.255 
	{ 0xc21fee00, 0xc21ff4ff, REGISTRY_RIPENCC    }, // 194.31.238.0    - 194.31.244.255 
	{ 0xc21ff600, 0xc21ffeff, REGISTRY_RIPENCC    }, // 194.31.246.0    - 194.31.254.255 
	{ 0xc2200000, 0xc22045ff, REGISTRY_RIPENCC    }, // 194.32.0.0      - 194.32.69.255  
	{ 0xc2204700, 0xc2205fff, REGISTRY_RIPENCC    }, // 194.32.71.0     - 194.32.95.255  
	{ 0xc2206e00, 0xc2206eff, REGISTRY_RIPENCC    }, // 194.32.110.0    - 194.32.110.255 
	{ 0xc2207000, 0xc220a7ff, REGISTRY_RIPENCC    }, // 194.32.112.0    - 194.32.167.255 
	{ 0xc220aa00, 0xc220adff, REGISTRY_RIPENCC    }, // 194.32.170.0    - 194.32.173.255 
	{ 0xc220b000, 0xc220dbff, REGISTRY_RIPENCC    }, // 194.32.176.0    - 194.32.219.255 
	{ 0xc220dd00, 0xc2210aff, REGISTRY_RIPENCC    }, // 194.32.221.0    - 194.33.10.255  
	{ 0xc2210c00, 0xc2211cff, REGISTRY_RIPENCC    }, // 194.33.12.0     - 194.33.28.255  
	{ 0xc2211e00, 0xc2211fff, REGISTRY_RIPENCC    }, // 194.33.30.0     - 194.33.31.255  
	{ 0xc2212100, 0xc22123ff, REGISTRY_RIPENCC    }, // 194.33.33.0     - 194.33.35.255  
	{ 0xc2212800, 0xc2212eff, REGISTRY_RIPENCC    }, // 194.33.40.0     - 194.33.46.255  
	{ 0xc2213200, 0xc2213dff, REGISTRY_RIPENCC    }, // 194.33.50.0     - 194.33.61.255  
	{ 0xc2213f00, 0xc22157ff, REGISTRY_RIPENCC    }, // 194.33.63.0     - 194.33.87.255  
	{ 0xc2215c00, 0xc22197ff, REGISTRY_RIPENCC    }, // 194.33.92.0     - 194.33.151.255 
	{ 0xc221a000, 0xc221b5ff, REGISTRY_RIPENCC    }, // 194.33.160.0    - 194.33.181.255 
	{ 0xc221b700, 0xc2223dff, REGISTRY_RIPENCC    }, // 194.33.183.0    - 194.34.61.255  
	{ 0xc2224000, 0xc22264ff, REGISTRY_RIPENCC    }, // 194.34.64.0     - 194.34.100.255 
	{ 0xc2226800, 0xc2227fff, REGISTRY_RIPENCC    }, // 194.34.104.0    - 194.34.127.255 
	{ 0xc2228800, 0xc222a2ff, REGISTRY_RIPENCC    }, // 194.34.136.0    - 194.34.162.255 
	{ 0xc222a400, 0xc222a7ff, REGISTRY_RIPENCC    }, // 194.34.164.0    - 194.34.167.255 
	{ 0xc222ac00, 0xc222bfff, REGISTRY_RIPENCC    }, // 194.34.172.0    - 194.34.191.255 
	{ 0xc222c600, 0xc2230dff, REGISTRY_RIPENCC    }, // 194.34.198.0    - 194.35.13.255  
	{ 0xc2231000, 0xc22330ff, REGISTRY_RIPENCC    }, // 194.35.16.0     - 194.35.48.255  
	{ 0xc2233200, 0xc22332ff, REGISTRY_RIPENCC    }, // 194.35.50.0     - 194.35.50.255  
	{ 0xc2233400, 0xc22335ff, REGISTRY_RIPENCC    }, // 194.35.52.0     - 194.35.53.255  
	{ 0xc2233700, 0xc22357ff, REGISTRY_RIPENCC    }, // 194.35.55.0     - 194.35.87.255  
	{ 0xc2235c00, 0xc2235eff, REGISTRY_RIPENCC    }, // 194.35.92.0     - 194.35.94.255  
	{ 0xc2236000, 0xc223baff, REGISTRY_RIPENCC    }, // 194.35.96.0     - 194.35.186.255 
	{ 0xc223bc00, 0xc223bcff, REGISTRY_RIPENCC    }, // 194.35.188.0    - 194.35.188.255 
	{ 0xc223be00, 0xc223f9ff, REGISTRY_RIPENCC    }, // 194.35.190.0    - 194.35.249.255 
	{ 0xc223fc00, 0xc22417ff, REGISTRY_RIPENCC    }, // 194.35.252.0    - 194.36.23.255  
	{ 0xc2241b00, 0xc2241bff, REGISTRY_RIPENCC    }, // 194.36.27.0     - 194.36.27.255  
	{ 0xc2242000, 0xc22447ff, REGISTRY_RIPENCC    }, // 194.36.32.0     - 194.36.71.255  
	{ 0xc2244c00, 0xc2244fff, REGISTRY_RIPENCC    }, // 194.36.76.0     - 194.36.79.255  
	{ 0xc2245200, 0xc22453ff, REGISTRY_RIPENCC    }, // 194.36.82.0     - 194.36.83.255  
	{ 0xc2245c00, 0xc2245fff, REGISTRY_RIPENCC    }, // 194.36.92.0     - 194.36.95.255  
	{ 0xc2247000, 0xc22473ff, REGISTRY_RIPENCC    }, // 194.36.112.0    - 194.36.115.255 
	{ 0xc2247500, 0xc22477ff, REGISTRY_RIPENCC    }, // 194.36.117.0    - 194.36.119.255 
	{ 0xc2247900, 0xc2248fff, REGISTRY_RIPENCC    }, // 194.36.121.0    - 194.36.143.255 
	{ 0xc2249800, 0xc224a6ff, REGISTRY_RIPENCC    }, // 194.36.152.0    - 194.36.166.255 
	{ 0xc224a800, 0xc224b7ff, REGISTRY_RIPENCC    }, // 194.36.168.0    - 194.36.183.255 
	{ 0xc224c000, 0xc224cfff, REGISTRY_RIPENCC    }, // 194.36.192.0    - 194.36.207.255 
	{ 0xc224d200, 0xc224dcff, REGISTRY_RIPENCC    }, // 194.36.210.0    - 194.36.220.255 
	{ 0xc224df00, 0xc2254fff, REGISTRY_RIPENCC    }, // 194.36.223.0    - 194.37.79.255  
	{ 0xc2255400, 0xc22557ff, REGISTRY_RIPENCC    }, // 194.37.84.0     - 194.37.87.255  
	{ 0xc2256800, 0xc225ffff, REGISTRY_RIPENCC    }, // 194.37.104.0    - 194.37.255.255 
	{ 0xc2264000, 0xc226ffff, REGISTRY_RIPENCC    }, // 194.38.64.0     - 194.38.255.255 
	{ 0xc2270000, 0xc2274dff, REGISTRY_RIPENCC    }, // 194.39.0.0      - 194.39.77.255  
	{ 0xc2275000, 0xc22766ff, REGISTRY_RIPENCC    }, // 194.39.80.0     - 194.39.102.255 
	{ 0xc2276800, 0xc2278dff, REGISTRY_RIPENCC    }, // 194.39.104.0    - 194.39.141.255 
	{ 0xc2278f00, 0xc227baff, REGISTRY_RIPENCC    }, // 194.39.143.0    - 194.39.186.255 
	{ 0xc227bc00, 0xc227c9ff, REGISTRY_RIPENCC    }, // 194.39.188.0    - 194.39.201.255 
	{ 0xc227cb00, 0xc227d3ff, REGISTRY_RIPENCC    }, // 194.39.203.0    - 194.39.211.255 
	{ 0xc227d600, 0xc228f9ff, REGISTRY_RIPENCC    }, // 194.39.214.0    - 194.40.249.255 
	{ 0xc228fc00, 0xc22900ff, REGISTRY_RIPENCC    }, // 194.40.252.0    - 194.41.0.255   
	{ 0xc2290200, 0xc22907ff, REGISTRY_RIPENCC    }, // 194.41.2.0      - 194.41.7.255   
	{ 0xc2290900, 0xc2291fff, REGISTRY_RIPENCC    }, // 194.41.9.0      - 194.41.31.255  
	{ 0xc2292500, 0xc22927ff, REGISTRY_RIPENCC    }, // 194.41.37.0     - 194.41.39.255  
	{ 0xc2293400, 0xc22934ff, REGISTRY_RIPENCC    }, // 194.41.52.0     - 194.41.52.255  
	{ 0xc2293800, 0xc22978ff, REGISTRY_RIPENCC    }, // 194.41.56.0     - 194.41.120.255 
	{ 0xc2298000, 0xc229ffff, REGISTRY_RIPENCC    }, // 194.41.128.0    - 194.41.255.255 
	{ 0xc22a0000, 0xc22a27ff, REGISTRY_RIPENCC    }, // 194.42.0.0      - 194.42.39.255  
	{ 0xc22a2800, 0xc22a2eff, REGISTRY_RIPENCC    }, // 194.42.40.0     - 194.42.46.255  
	{ 0xc22a2f80, 0xc22a3fff, REGISTRY_RIPENCC    }, // 194.42.47.128   - 194.42.63.255  
	{ 0xc22a4000, 0xc22a5fff, REGISTRY_RIPENCC    }, // 194.42.64.0     - 194.42.95.255  
	{ 0xc22a6200, 0xc22a67ff, REGISTRY_RIPENCC    }, // 194.42.98.0     - 194.42.103.255 
	{ 0xc22a6a00, 0xc22a7fff, REGISTRY_RIPENCC    }, // 194.42.106.0    - 194.42.127.255 
	{ 0xc22a8000, 0xc22abfff, REGISTRY_RIPENCC    }, // 194.42.128.0    - 194.42.191.255 
	{ 0xc22ac000, 0xc22adfff, REGISTRY_RIPENCC    }, // 194.42.192.0    - 194.42.223.255 
	{ 0xc22ae000, 0xc22fffff, REGISTRY_RIPENCC    }, // 194.42.224.0    - 194.47.255.255 
	{ 0xc2300000, 0xc230aeff, REGISTRY_RIPENCC    }, // 194.48.0.0      - 194.48.174.255 
	{ 0xc230b000, 0xc230f3ff, REGISTRY_RIPENCC    }, // 194.48.176.0    - 194.48.243.255 
	{ 0xc230f800, 0xc230feff, REGISTRY_RIPENCC    }, // 194.48.248.0    - 194.48.254.255 
	{ 0xc2310000, 0xc23104ff, REGISTRY_RIPENCC    }, // 194.49.0.0      - 194.49.4.255   
	{ 0xc2310600, 0xc23110ff, REGISTRY_RIPENCC    }, // 194.49.6.0      - 194.49.16.255  
	{ 0xc2311300, 0xc23137ff, REGISTRY_RIPENCC    }, // 194.49.19.0     - 194.49.55.255  
	{ 0xc2313b00, 0xc23141ff, REGISTRY_RIPENCC    }, // 194.49.59.0     - 194.49.65.255  
	{ 0xc2314500, 0xc23150ff, REGISTRY_RIPENCC    }, // 194.49.69.0     - 194.49.80.255  
	{ 0xc2315200, 0xc23155ff, REGISTRY_RIPENCC    }, // 194.49.82.0     - 194.49.85.255  
	{ 0xc2315c00, 0xc2315cff, REGISTRY_RIPENCC    }, // 194.49.92.0     - 194.49.92.255  
	{ 0xc2315e00, 0xc23163ff, REGISTRY_RIPENCC    }, // 194.49.94.0     - 194.49.99.255  
	{ 0xc2316500, 0xc2316bff, REGISTRY_RIPENCC    }, // 194.49.101.0    - 194.49.107.255 
	{ 0xc2316e00, 0xc231ffff, REGISTRY_RIPENCC    }, // 194.49.110.0    - 194.49.255.255 
	{ 0xc2320200, 0xc23202ff, REGISTRY_RIPENCC    }, // 194.50.2.0      - 194.50.2.255   
	{ 0xc2320600, 0xc2320bff, REGISTRY_RIPENCC    }, // 194.50.6.0      - 194.50.11.255  
	{ 0xc2321800, 0xc2322dff, REGISTRY_RIPENCC    }, // 194.50.24.0     - 194.50.45.255  
	{ 0xc2322f00, 0xc2322fff, REGISTRY_RIPENCC    }, // 194.50.47.0     - 194.50.47.255  
	{ 0xc2323100, 0xc23233ff, REGISTRY_RIPENCC    }, // 194.50.49.0     - 194.50.51.255  
	{ 0xc2323500, 0xc23248ff, REGISTRY_RIPENCC    }, // 194.50.53.0     - 194.50.72.255  
	{ 0xc2324b00, 0xc23251ff, REGISTRY_RIPENCC    }, // 194.50.75.0     - 194.50.81.255  
	{ 0xc2325300, 0xc2325bff, REGISTRY_RIPENCC    }, // 194.50.83.0     - 194.50.91.255  
	{ 0xc2325d00, 0xc2325dff, REGISTRY_RIPENCC    }, // 194.50.93.0     - 194.50.93.255  
	{ 0xc2325f00, 0xc232a9ff, REGISTRY_RIPENCC    }, // 194.50.95.0     - 194.50.169.255 
	{ 0xc232ac00, 0xc232b3ff, REGISTRY_RIPENCC    }, // 194.50.172.0    - 194.50.179.255 
	{ 0xc232b500, 0xc232b7ff, REGISTRY_RIPENCC    }, // 194.50.181.0    - 194.50.183.255 
	{ 0xc232b900, 0xc232bbff, REGISTRY_RIPENCC    }, // 194.50.185.0    - 194.50.187.255 
	{ 0xc232bd00, 0xc232c8ff, REGISTRY_RIPENCC    }, // 194.50.189.0    - 194.50.200.255 
	{ 0xc232ca00, 0xc232dbff, REGISTRY_RIPENCC    }, // 194.50.202.0    - 194.50.219.255 
	{ 0xc232de00, 0xc232eaff, REGISTRY_RIPENCC    }, // 194.50.222.0    - 194.50.234.255 
	{ 0xc232ec00, 0xc232edff, REGISTRY_RIPENCC    }, // 194.50.236.0    - 194.50.237.255 
	{ 0xc232ef00, 0xc232f5ff, REGISTRY_RIPENCC    }, // 194.50.239.0    - 194.50.245.255 
	{ 0xc232f800, 0xc232f9ff, REGISTRY_RIPENCC    }, // 194.50.248.0    - 194.50.249.255 
	{ 0xc232fc00, 0xc232fcff, REGISTRY_RIPENCC    }, // 194.50.252.0    - 194.50.252.255 
	{ 0xc232fe00, 0xc232ffff, REGISTRY_RIPENCC    }, // 194.50.254.0    - 194.50.255.255 
	{ 0xc2330000, 0xc234ffff, REGISTRY_RIPENCC    }, // 194.51.0.0      - 194.52.255.255 
	{ 0xc2350000, 0xc23554ff, REGISTRY_RIPENCC    }, // 194.53.0.0      - 194.53.84.255  
	{ 0xc2355600, 0xc23567ff, REGISTRY_RIPENCC    }, // 194.53.86.0     - 194.53.103.255 
	{ 0xc2357000, 0xc23577ff, REGISTRY_RIPENCC    }, // 194.53.112.0    - 194.53.119.255 
	{ 0xc2357900, 0xc2358fff, REGISTRY_RIPENCC    }, // 194.53.121.0    - 194.53.143.255 
	{ 0xc235a000, 0xc2361fff, REGISTRY_RIPENCC    }, // 194.53.160.0    - 194.54.31.255  
	{ 0xc2362000, 0xc2363fff, REGISTRY_RIPENCC    }, // 194.54.32.0     - 194.54.63.255  
	{ 0xc2364000, 0xc2364bff, REGISTRY_RIPENCC    }, // 194.54.64.0     - 194.54.75.255  
	{ 0xc2365000, 0xc2365fff, REGISTRY_RIPENCC    }, // 194.54.80.0     - 194.54.95.255  
	{ 0xc2366000, 0xc2367fff, REGISTRY_RIPENCC    }, // 194.54.96.0     - 194.54.127.255 
	{ 0xc2368000, 0xc236bfff, REGISTRY_RIPENCC    }, // 194.54.128.0    - 194.54.191.255 
	{ 0xc236c000, 0xc236ffff, REGISTRY_RIPENCC    }, // 194.54.192.0    - 194.54.255.255 
	{ 0xc2370000, 0xc23703ff, REGISTRY_RIPENCC    }, // 194.55.0.0      - 194.55.3.255   
	{ 0xc2370800, 0xc2372eff, REGISTRY_RIPENCC    }, // 194.55.8.0      - 194.55.46.255  
	{ 0xc2373000, 0xc23767ff, REGISTRY_RIPENCC    }, // 194.55.48.0     - 194.55.103.255 
	{ 0xc2376a00, 0xc23787ff, REGISTRY_RIPENCC    }, // 194.55.106.0    - 194.55.135.255 
	{ 0xc2378a00, 0xc23797ff, REGISTRY_RIPENCC    }, // 194.55.138.0    - 194.55.151.255 
	{ 0xc2379c00, 0xc237a4ff, REGISTRY_RIPENCC    }, // 194.55.156.0    - 194.55.164.255 
	{ 0xc237a600, 0xc237aaff, REGISTRY_RIPENCC    }, // 194.55.166.0    - 194.55.170.255 
	{ 0xc237ac00, 0xc237b9ff, REGISTRY_RIPENCC    }, // 194.55.172.0    - 194.55.185.255 
	{ 0xc237bc00, 0xc237eeff, REGISTRY_RIPENCC    }, // 194.55.188.0    - 194.55.238.255 
	{ 0xc237f000, 0xc237feff, REGISTRY_RIPENCC    }, // 194.55.240.0    - 194.55.254.255 
	{ 0xc2380000, 0xc238ddff, REGISTRY_RIPENCC    }, // 194.56.0.0      - 194.56.221.255 
	{ 0xc238df00, 0xc238f1ff, REGISTRY_RIPENCC    }, // 194.56.223.0    - 194.56.241.255 
	{ 0xc238f300, 0xc238f4ff, REGISTRY_RIPENCC    }, // 194.56.243.0    - 194.56.244.255 
	{ 0xc238f600, 0xc238fcff, REGISTRY_RIPENCC    }, // 194.56.246.0    - 194.56.252.255 
	{ 0xc238fe00, 0xc238ffff, REGISTRY_RIPENCC    }, // 194.56.254.0    - 194.56.255.255 
	{ 0xc2390000, 0xc23affff, REGISTRY_RIPENCC    }, // 194.57.0.0      - 194.58.255.255 
	{ 0xc23b0000, 0xc23b05ff, REGISTRY_RIPENCC    }, // 194.59.0.0      - 194.59.5.255   
	{ 0xc23b0700, 0xc23b2dff, REGISTRY_RIPENCC    }, // 194.59.7.0      - 194.59.45.255  
	{ 0xc23b2f00, 0xc23b9aff, REGISTRY_RIPENCC    }, // 194.59.47.0     - 194.59.154.255 
	{ 0xc23b9c00, 0xc23b9dff, REGISTRY_RIPENCC    }, // 194.59.156.0    - 194.59.157.255 
	{ 0xc23b9f00, 0xc23ba9ff, REGISTRY_RIPENCC    }, // 194.59.159.0    - 194.59.169.255 
	{ 0xc23bab00, 0xc23bafff, REGISTRY_RIPENCC    }, // 194.59.171.0    - 194.59.175.255 
	{ 0xc23bb100, 0xc23bbaff, REGISTRY_RIPENCC    }, // 194.59.177.0    - 194.59.186.255 
	{ 0xc23bbc00, 0xc23bd6ff, REGISTRY_RIPENCC    }, // 194.59.188.0    - 194.59.214.255 
	{ 0xc23bdc00, 0xc23befff, REGISTRY_RIPENCC    }, // 194.59.220.0    - 194.59.239.255 
	{ 0xc23bf400, 0xc23bf7ff, REGISTRY_RIPENCC    }, // 194.59.244.0    - 194.59.247.255 
	{ 0xc23bfa00, 0xc23c57ff, REGISTRY_RIPENCC    }, // 194.59.250.0    - 194.60.87.255  
	{ 0xc23c6000, 0xc23c83ff, REGISTRY_RIPENCC    }, // 194.60.96.0     - 194.60.131.255 
	{ 0xc23c8800, 0xc23cc5ff, REGISTRY_RIPENCC    }, // 194.60.136.0    - 194.60.197.255 
	{ 0xc23cc800, 0xc23cc9ff, REGISTRY_RIPENCC    }, // 194.60.200.0    - 194.60.201.255 
	{ 0xc23ccb00, 0xc23cccff, REGISTRY_RIPENCC    }, // 194.60.203.0    - 194.60.204.255 
	{ 0xc23cce00, 0xc23ccfff, REGISTRY_RIPENCC    }, // 194.60.206.0    - 194.60.207.255 
	{ 0xc23cd800, 0xc23d7bff, REGISTRY_RIPENCC    }, // 194.60.216.0    - 194.61.123.255 
	{ 0xc23d7f00, 0xc23d8bff, REGISTRY_RIPENCC    }, // 194.61.127.0    - 194.61.139.255 
	{ 0xc23d9000, 0xc23d9eff, REGISTRY_RIPENCC    }, // 194.61.144.0    - 194.61.158.255 
	{ 0xc23da000, 0xc23de7ff, REGISTRY_RIPENCC    }, // 194.61.160.0    - 194.61.231.255 
	{ 0xc23df000, 0xc23e00ff, REGISTRY_RIPENCC    }, // 194.61.240.0    - 194.62.0.255   
	{ 0xc23e0200, 0xc23e0fff, REGISTRY_RIPENCC    }, // 194.62.2.0      - 194.62.15.255  
	{ 0xc23e1400, 0xc23e7dff, REGISTRY_RIPENCC    }, // 194.62.20.0     - 194.62.125.255 
	{ 0xc23e7f00, 0xc23e9cff, REGISTRY_RIPENCC    }, // 194.62.127.0    - 194.62.156.255 
	{ 0xc23eac00, 0xc23eb3ff, REGISTRY_RIPENCC    }, // 194.62.172.0    - 194.62.179.255 
	{ 0xc23eb800, 0xc23ebeff, REGISTRY_RIPENCC    }, // 194.62.184.0    - 194.62.190.255 
	{ 0xc23ec000, 0xc23ec7ff, REGISTRY_RIPENCC    }, // 194.62.192.0    - 194.62.199.255 
	{ 0xc23ecc00, 0xc23ed5ff, REGISTRY_RIPENCC    }, // 194.62.204.0    - 194.62.213.255 
	{ 0xc23ee400, 0xc23ee8ff, REGISTRY_RIPENCC    }, // 194.62.228.0    - 194.62.232.255 
	{ 0xc23eea00, 0xc23f8bff, REGISTRY_RIPENCC    }, // 194.62.234.0    - 194.63.139.255 
	{ 0xc23f8c00, 0xc23f8fff, REGISTRY_RIPENCC    }, // 194.63.140.0    - 194.63.143.255 
	{ 0xc23f9400, 0xc23f97ff, REGISTRY_RIPENCC    }, // 194.63.148.0    - 194.63.151.255 
	{ 0xc23f9c00, 0xc23fffff, REGISTRY_RIPENCC    }, // 194.63.156.0    - 194.63.255.255 
	{ 0xc2400000, 0xc244ffff, REGISTRY_RIPENCC    }, // 194.64.0.0      - 194.68.255.255 
	{ 0xc2450000, 0xc2451fff, REGISTRY_RIPENCC    }, // 194.69.0.0      - 194.69.31.255  
	{ 0xc2452000, 0xc2455fff, REGISTRY_RIPENCC    }, // 194.69.32.0     - 194.69.95.255  
	{ 0xc2456000, 0xc2458fff, REGISTRY_RIPENCC    }, // 194.69.96.0     - 194.69.143.255 
	{ 0xc2459000, 0xc245bfff, REGISTRY_RIPENCC    }, // 194.69.144.0    - 194.69.191.255 
	{ 0xc245c000, 0xc245c7ff, REGISTRY_RIPENCC    }, // 194.69.192.0    - 194.69.199.255 
	{ 0xc245cc00, 0xc245cdff, REGISTRY_RIPENCC    }, // 194.69.204.0    - 194.69.205.255 
	{ 0xc245cf00, 0xc245dfff, REGISTRY_RIPENCC    }, // 194.69.207.0    - 194.69.223.255 
	{ 0xc245e000, 0xc24bffff, REGISTRY_RIPENCC    }, // 194.69.224.0    - 194.75.255.255 
	{ 0xc24c0000, 0xc24c11ff, REGISTRY_RIPENCC    }, // 194.76.0.0      - 194.76.17.255  
	{ 0xc24c1300, 0xc24c2bff, REGISTRY_RIPENCC    }, // 194.76.19.0     - 194.76.43.255  
	{ 0xc24c2d00, 0xc24cd9ff, REGISTRY_RIPENCC    }, // 194.76.45.0     - 194.76.217.255 
	{ 0xc24cdb00, 0xc24cebff, REGISTRY_RIPENCC    }, // 194.76.219.0    - 194.76.235.255 
	{ 0xc24cef00, 0xc24cfeff, REGISTRY_RIPENCC    }, // 194.76.239.0    - 194.76.254.255 
	{ 0xc24d0000, 0xc24effff, REGISTRY_RIPENCC    }, // 194.77.0.0      - 194.78.255.255 
	{ 0xc24f0000, 0xc24f1bff, REGISTRY_RIPENCC    }, // 194.79.0.0      - 194.79.27.255  
	{ 0xc24f1c00, 0xc24f1fff, REGISTRY_RIPENCC    }, // 194.79.28.0     - 194.79.31.255  
	{ 0xc24f2000, 0xc24f23ff, REGISTRY_RIPENCC    }, // 194.79.32.0     - 194.79.35.255  
	{ 0xc24f2800, 0xc24f2fff, REGISTRY_RIPENCC    }, // 194.79.40.0     - 194.79.47.255  
	{ 0xc24f3400, 0xc24f3fff, REGISTRY_RIPENCC    }, // 194.79.52.0     - 194.79.63.255  
	{ 0xc24f4000, 0xc24f5fff, REGISTRY_RIPENCC    }, // 194.79.64.0     - 194.79.95.255  
	{ 0xc24f6000, 0xc24f7fff, REGISTRY_AFRINIC    }, // 194.79.96.0     - 194.79.127.255 
	{ 0xc24f8000, 0xc24fdfff, REGISTRY_RIPENCC    }, // 194.79.128.0    - 194.79.223.255 
	{ 0xc24fe000, 0xc24fffff, REGISTRY_RIPENCC    }, // 194.79.224.0    - 194.79.255.255 
	{ 0xc2500000, 0xc257ffff, REGISTRY_RIPENCC    }, // 194.80.0.0      - 194.87.255.255 
	{ 0xc2580000, 0xc25805ff, REGISTRY_RIPENCC    }, // 194.88.0.0      - 194.88.5.255   
	{ 0xc2580800, 0xc2580aff, REGISTRY_RIPENCC    }, // 194.88.8.0      - 194.88.10.255  
	{ 0xc2580c00, 0xc2581fff, REGISTRY_RIPENCC    }, // 194.88.12.0     - 194.88.31.255  
	{ 0xc2582000, 0xc2587fff, REGISTRY_RIPENCC    }, // 194.88.32.0     - 194.88.127.255 
	{ 0xc2588000, 0xc2589fff, REGISTRY_RIPENCC    }, // 194.88.128.0    - 194.88.159.255 
	{ 0xc258a000, 0xc258bfff, REGISTRY_RIPENCC    }, // 194.88.160.0    - 194.88.191.255 
	{ 0xc258c000, 0xc258e1ff, REGISTRY_RIPENCC    }, // 194.88.192.0    - 194.88.225.255 
	{ 0xc258e400, 0xc258fbff, REGISTRY_RIPENCC    }, // 194.88.228.0    - 194.88.251.255 
	{ 0xc258fe00, 0xc258ffff, REGISTRY_RIPENCC    }, // 194.88.254.0    - 194.88.255.255 
	{ 0xc2590000, 0xc25cffff, REGISTRY_RIPENCC    }, // 194.89.0.0      - 194.92.255.255 
	{ 0xc25d4900, 0xc25d7fff, REGISTRY_RIPENCC    }, // 194.93.73.0     - 194.93.127.255 
	{ 0xc25d8000, 0xc262ffff, REGISTRY_RIPENCC    }, // 194.93.128.0    - 194.98.255.255 
	{ 0xc2630000, 0xc26307ff, REGISTRY_RIPENCC    }, // 194.99.0.0      - 194.99.7.255   
	{ 0xc2630900, 0xc26332ff, REGISTRY_RIPENCC    }, // 194.99.9.0      - 194.99.50.255  
	{ 0xc2633400, 0xc26342ff, REGISTRY_RIPENCC    }, // 194.99.52.0     - 194.99.66.255  
	{ 0xc2634400, 0xc26349ff, REGISTRY_RIPENCC    }, // 194.99.68.0     - 194.99.73.255  
	{ 0xc2634b00, 0xc26372ff, REGISTRY_RIPENCC    }, // 194.99.75.0     - 194.99.114.255 
	{ 0xc2637400, 0xc2639bff, REGISTRY_RIPENCC    }, // 194.99.116.0    - 194.99.155.255 
	{ 0xc2639d00, 0xc263ffff, REGISTRY_RIPENCC    }, // 194.99.157.0    - 194.99.255.255 
	{ 0xc2640000, 0xc267ffff, REGISTRY_RIPENCC    }, // 194.100.0.0     - 194.103.255.255
	{ 0xc2680000, 0xc2680fff, REGISTRY_RIPENCC    }, // 194.104.0.0     - 194.104.15.255 
	{ 0xc2681400, 0xc2685bff, REGISTRY_RIPENCC    }, // 194.104.20.0    - 194.104.91.255 
	{ 0xc2685d00, 0xc26876ff, REGISTRY_RIPENCC    }, // 194.104.93.0    - 194.104.118.255
	{ 0xc2687800, 0xc2687dff, REGISTRY_RIPENCC    }, // 194.104.120.0   - 194.104.125.255
	{ 0xc2687f00, 0xc2688fff, REGISTRY_RIPENCC    }, // 194.104.127.0   - 194.104.143.255
	{ 0xc2689400, 0xc2689dff, REGISTRY_RIPENCC    }, // 194.104.148.0   - 194.104.157.255
	{ 0xc2689f00, 0xc268bbff, REGISTRY_RIPENCC    }, // 194.104.159.0   - 194.104.187.255
	{ 0xc268c000, 0xc268ffff, REGISTRY_RIPENCC    }, // 194.104.192.0   - 194.104.255.255
	{ 0xc2690000, 0xc2691fff, REGISTRY_RIPENCC    }, // 194.105.0.0     - 194.105.31.255 
	{ 0xc2692000, 0xc26939ff, REGISTRY_RIPENCC    }, // 194.105.32.0    - 194.105.57.255 
	{ 0xc2693d00, 0xc2693dff, REGISTRY_RIPENCC    }, // 194.105.61.0    - 194.105.61.255 
	{ 0xc2694000, 0xc2695fff, REGISTRY_RIPENCC    }, // 194.105.64.0    - 194.105.95.255 
	{ 0xc2696000, 0xc2699dff, REGISTRY_RIPENCC    }, // 194.105.96.0    - 194.105.157.255
	{ 0xc269a000, 0xc26abfff, REGISTRY_RIPENCC    }, // 194.105.160.0   - 194.106.191.255
	{ 0xc26ac000, 0xc26ac9ff, REGISTRY_RIPENCC    }, // 194.106.192.0   - 194.106.201.255
	{ 0xc26acc00, 0xc26adfff, REGISTRY_RIPENCC    }, // 194.106.204.0   - 194.106.223.255
	{ 0xc26ae000, 0xc26affff, REGISTRY_RIPENCC    }, // 194.106.224.0   - 194.106.255.255
	{ 0xc26b0000, 0xc26b7cff, REGISTRY_RIPENCC    }, // 194.107.0.0     - 194.107.124.255
	{ 0xc26b7e00, 0xc26bafff, REGISTRY_RIPENCC    }, // 194.107.126.0   - 194.107.175.255
	{ 0xc26bb800, 0xc26bcdff, REGISTRY_RIPENCC    }, // 194.107.184.0   - 194.107.205.255
	{ 0xc26bcf00, 0xc26be6ff, REGISTRY_RIPENCC    }, // 194.107.207.0   - 194.107.230.255
	{ 0xc26be800, 0xc26bf7ff, REGISTRY_RIPENCC    }, // 194.107.232.0   - 194.107.247.255
	{ 0xc26c0000, 0xc26dffff, REGISTRY_RIPENCC    }, // 194.108.0.0     - 194.109.255.255
	{ 0xc26e0000, 0xc26e02ff, REGISTRY_RIPENCC    }, // 194.110.0.0     - 194.110.2.255  
	{ 0xc26e0500, 0xc26e07ff, REGISTRY_RIPENCC    }, // 194.110.5.0     - 194.110.7.255  
	{ 0xc26e0e00, 0xc26e10ff, REGISTRY_RIPENCC    }, // 194.110.14.0    - 194.110.16.255 
	{ 0xc26e1200, 0xc26e15ff, REGISTRY_RIPENCC    }, // 194.110.18.0    - 194.110.21.255 
	{ 0xc26e1700, 0xc26e1bff, REGISTRY_RIPENCC    }, // 194.110.23.0    - 194.110.27.255 
	{ 0xc26e1d00, 0xc26e47ff, REGISTRY_RIPENCC    }, // 194.110.29.0    - 194.110.71.255 
	{ 0xc26e4900, 0xc26e49ff, REGISTRY_RIPENCC    }, // 194.110.73.0    - 194.110.73.255 
	{ 0xc26e4b00, 0xc26e50ff, REGISTRY_RIPENCC    }, // 194.110.75.0    - 194.110.80.255 
	{ 0xc26e5200, 0xc26e53ff, REGISTRY_RIPENCC    }, // 194.110.82.0    - 194.110.83.255 
	{ 0xc26e5800, 0xc26e5dff, REGISTRY_RIPENCC    }, // 194.110.88.0    - 194.110.93.255 
	{ 0xc26e6000, 0xc26e75ff, REGISTRY_RIPENCC    }, // 194.110.96.0    - 194.110.117.255
	{ 0xc26e7a00, 0xc26e81ff, REGISTRY_RIPENCC    }, // 194.110.122.0   - 194.110.129.255
	{ 0xc26e8500, 0xc26e85ff, REGISTRY_RIPENCC    }, // 194.110.133.0   - 194.110.133.255
	{ 0xc26e8800, 0xc26e8fff, REGISTRY_RIPENCC    }, // 194.110.136.0   - 194.110.143.255
	{ 0xc26e9600, 0xc26eafff, REGISTRY_RIPENCC    }, // 194.110.150.0   - 194.110.175.255
	{ 0xc26eb000, 0xc26ebfff, REGISTRY_RIPENCC    }, // 194.110.176.0   - 194.110.191.255
	{ 0xc26ec000, 0xc26ec7ff, REGISTRY_RIPENCC    }, // 194.110.192.0   - 194.110.199.255
	{ 0xc26ec900, 0xc26ed1ff, REGISTRY_RIPENCC    }, // 194.110.201.0   - 194.110.209.255
	{ 0xc26ed300, 0xc26ef5ff, REGISTRY_RIPENCC    }, // 194.110.211.0   - 194.110.245.255
	{ 0xc26ef900, 0xc26efdff, REGISTRY_RIPENCC    }, // 194.110.249.0   - 194.110.253.255
	{ 0xc26eff00, 0xc26effff, REGISTRY_RIPENCC    }, // 194.110.255.0   - 194.110.255.255
	{ 0xc26f0000, 0xc270ffff, REGISTRY_RIPENCC    }, // 194.111.0.0     - 194.112.255.255
	{ 0xc2710000, 0xc27117ff, REGISTRY_RIPENCC    }, // 194.113.0.0     - 194.113.23.255 
	{ 0xc2711a00, 0xc2711aff, REGISTRY_RIPENCC    }, // 194.113.26.0    - 194.113.26.255 
	{ 0xc2711c00, 0xc2712aff, REGISTRY_RIPENCC    }, // 194.113.28.0    - 194.113.42.255 
	{ 0xc2712d00, 0xc2712eff, REGISTRY_RIPENCC    }, // 194.113.45.0    - 194.113.46.255 
	{ 0xc2713000, 0xc27147ff, REGISTRY_RIPENCC    }, // 194.113.48.0    - 194.113.71.255 
	{ 0xc2714c00, 0xc2715dff, REGISTRY_RIPENCC    }, // 194.113.76.0    - 194.113.93.255 
	{ 0xc2716000, 0xc27171ff, REGISTRY_RIPENCC    }, // 194.113.96.0    - 194.113.113.255
	{ 0xc2717300, 0xc27175ff, REGISTRY_RIPENCC    }, // 194.113.115.0   - 194.113.117.255
	{ 0xc2717800, 0xc2718fff, REGISTRY_RIPENCC    }, // 194.113.120.0   - 194.113.143.255
	{ 0xc2719100, 0xc27191ff, REGISTRY_RIPENCC    }, // 194.113.145.0   - 194.113.145.255
	{ 0xc2719400, 0xc27196ff, REGISTRY_RIPENCC    }, // 194.113.148.0   - 194.113.150.255
	{ 0xc2719a00, 0xc271c4ff, REGISTRY_RIPENCC    }, // 194.113.154.0   - 194.113.196.255
	{ 0xc271c800, 0xc271f4ff, REGISTRY_RIPENCC    }, // 194.113.200.0   - 194.113.244.255
	{ 0xc271f600, 0xc271f8ff, REGISTRY_RIPENCC    }, // 194.113.246.0   - 194.113.248.255
	{ 0xc271fa00, 0xc272ffff, REGISTRY_RIPENCC    }, // 194.113.250.0   - 194.114.255.255
	{ 0xc2730000, 0xc2747fff, REGISTRY_RIPENCC    }, // 194.115.0.0     - 194.116.127.255
	{ 0xc2748000, 0xc27499ff, REGISTRY_RIPENCC    }, // 194.116.128.0   - 194.116.153.255
	{ 0xc2749c00, 0xc274abff, REGISTRY_RIPENCC    }, // 194.116.156.0   - 194.116.171.255
	{ 0xc274ae00, 0xc274bdff, REGISTRY_RIPENCC    }, // 194.116.174.0   - 194.116.189.255
	{ 0xc274c000, 0xc274d5ff, REGISTRY_RIPENCC    }, // 194.116.192.0   - 194.116.213.255
	{ 0xc274da00, 0xc274e3ff, REGISTRY_RIPENCC    }, // 194.116.218.0   - 194.116.227.255
	{ 0xc274e600, 0xc274ebff, REGISTRY_RIPENCC    }, // 194.116.230.0   - 194.116.235.255
	{ 0xc274ee00, 0xc274f7ff, REGISTRY_RIPENCC    }, // 194.116.238.0   - 194.116.247.255
	{ 0xc274fc00, 0xc274ffff, REGISTRY_RIPENCC    }, // 194.116.252.0   - 194.116.255.255
	{ 0xc2750000, 0xc27531ff, REGISTRY_RIPENCC    }, // 194.117.0.0     - 194.117.49.255 
	{ 0xc2753200, 0xc27534ff, REGISTRY_RIPENCC    }, // 194.117.50.0    - 194.117.52.255 
	{ 0xc2753580, 0xc27537ff, REGISTRY_RIPENCC    }, // 194.117.53.128  - 194.117.55.255 
	{ 0xc2753800, 0xc275dfff, REGISTRY_RIPENCC    }, // 194.117.56.0    - 194.117.223.255
	{ 0xc275e000, 0xc275edff, REGISTRY_RIPENCC    }, // 194.117.224.0   - 194.117.237.255
	{ 0xc275f000, 0xc275f9ff, REGISTRY_RIPENCC    }, // 194.117.240.0   - 194.117.249.255
	{ 0xc275fc00, 0xc275ffff, REGISTRY_RIPENCC    }, // 194.117.252.0   - 194.117.255.255
	{ 0xc2760000, 0xc27bffff, REGISTRY_RIPENCC    }, // 194.118.0.0     - 194.123.255.255
	{ 0xc27c0000, 0xc27c8fff, REGISTRY_RIPENCC    }, // 194.124.0.0     - 194.124.143.255
	{ 0xc27c9100, 0xc27ceaff, REGISTRY_RIPENCC    }, // 194.124.145.0   - 194.124.234.255
	{ 0xc27cec00, 0xc27cecff, REGISTRY_RIPENCC    }, // 194.124.236.0   - 194.124.236.255
	{ 0xc27cee00, 0xc27cf6ff, REGISTRY_RIPENCC    }, // 194.124.238.0   - 194.124.246.255
	{ 0xc27cf800, 0xc27cfeff, REGISTRY_RIPENCC    }, // 194.124.248.0   - 194.124.254.255
	{ 0xc27d0000, 0xc27ddfff, REGISTRY_RIPENCC    }, // 194.125.0.0     - 194.125.223.255
	{ 0xc27de000, 0xc27de3ff, REGISTRY_RIPENCC    }, // 194.125.224.0   - 194.125.227.255
	{ 0xc27de800, 0xc27df7ff, REGISTRY_RIPENCC    }, // 194.125.232.0   - 194.125.247.255
	{ 0xc27dfc00, 0xc27dffff, REGISTRY_RIPENCC    }, // 194.125.252.0   - 194.125.255.255
	{ 0xc27e0000, 0xc27e7fff, REGISTRY_RIPENCC    }, // 194.126.0.0     - 194.126.127.255
	{ 0xc27e8000, 0xc27e84ff, REGISTRY_RIPENCC    }, // 194.126.128.0   - 194.126.132.255
	{ 0xc27e8800, 0xc27e8fff, REGISTRY_RIPENCC    }, // 194.126.136.0   - 194.126.143.255
	{ 0xc27e9000, 0xc27e97ff, REGISTRY_RIPENCC    }, // 194.126.144.0   - 194.126.151.255
	{ 0xc27e9c00, 0xc27e9fff, REGISTRY_RIPENCC    }, // 194.126.156.0   - 194.126.159.255
	{ 0xc27ea400, 0xc27eafff, REGISTRY_RIPENCC    }, // 194.126.164.0   - 194.126.175.255
	{ 0xc27eb400, 0xc27ec9ff, REGISTRY_RIPENCC    }, // 194.126.180.0   - 194.126.201.255
	{ 0xc27ecb00, 0xc27edaff, REGISTRY_RIPENCC    }, // 194.126.203.0   - 194.126.218.255
	{ 0xc27edc00, 0xc27ee8ff, REGISTRY_RIPENCC    }, // 194.126.220.0   - 194.126.232.255
	{ 0xc27eea00, 0xc27ef4ff, REGISTRY_RIPENCC    }, // 194.126.234.0   - 194.126.244.255
	{ 0xc27ef600, 0xc27efaff, REGISTRY_RIPENCC    }, // 194.126.246.0   - 194.126.250.255
	{ 0xc27efc00, 0xc27f63ff, REGISTRY_RIPENCC    }, // 194.126.252.0   - 194.127.99.255 
	{ 0xc27f6500, 0xc27f6bff, REGISTRY_RIPENCC    }, // 194.127.101.0   - 194.127.107.255
	{ 0xc27f7500, 0xc27f76ff, REGISTRY_RIPENCC    }, // 194.127.117.0   - 194.127.118.255
	{ 0xc27f7800, 0xc27f9eff, REGISTRY_RIPENCC    }, // 194.127.120.0   - 194.127.158.255
	{ 0xc27fa000, 0xc27fa2ff, REGISTRY_RIPENCC    }, // 194.127.160.0   - 194.127.162.255
	{ 0xc27fa400, 0xc27fb1ff, REGISTRY_RIPENCC    }, // 194.127.164.0   - 194.127.177.255
	{ 0xc27fb400, 0xc27fcdff, REGISTRY_RIPENCC    }, // 194.127.180.0   - 194.127.205.255
	{ 0xc27fcf00, 0xc27fefff, REGISTRY_RIPENCC    }, // 194.127.207.0   - 194.127.239.255
	{ 0xc27ff100, 0xc27fffff, REGISTRY_RIPENCC    }, // 194.127.241.0   - 194.127.255.255
	{ 0xc2800000, 0xc289ffff, REGISTRY_RIPENCC    }, // 194.128.0.0     - 194.137.255.255
	{ 0xc28a0000, 0xc28affff, REGISTRY_RIPENCC    }, // 194.138.0.0     - 194.138.255.255
	{ 0xc28b0000, 0xc28cdfff, REGISTRY_RIPENCC    }, // 194.139.0.0     - 194.140.223.255
	{ 0xc28ce100, 0xc28ce4ff, REGISTRY_RIPENCC    }, // 194.140.225.0   - 194.140.228.255
	{ 0xc28ce600, 0xc28cecff, REGISTRY_RIPENCC    }, // 194.140.230.0   - 194.140.236.255
	{ 0xc28cee00, 0xc28cf1ff, REGISTRY_RIPENCC    }, // 194.140.238.0   - 194.140.241.255
	{ 0xc28cf300, 0xc28cf8ff, REGISTRY_RIPENCC    }, // 194.140.243.0   - 194.140.248.255
	{ 0xc28cfa00, 0xc28cffff, REGISTRY_RIPENCC    }, // 194.140.250.0   - 194.140.255.255
	{ 0xc28d0000, 0xc28f7fff, REGISTRY_RIPENCC    }, // 194.141.0.0     - 194.143.127.255
	{ 0xc28f8000, 0xc28f9fff, REGISTRY_RIPENCC    }, // 194.143.128.0   - 194.143.159.255
	{ 0xc28fa000, 0xc2911fff, REGISTRY_RIPENCC    }, // 194.143.160.0   - 194.145.31.255 
	{ 0xc2912000, 0xc2916fff, REGISTRY_RIPENCC    }, // 194.145.32.0    - 194.145.111.255
	{ 0xc2917200, 0xc2917eff, REGISTRY_RIPENCC    }, // 194.145.114.0   - 194.145.126.255
	{ 0xc2918000, 0xc29187ff, REGISTRY_RIPENCC    }, // 194.145.128.0   - 194.145.135.255
	{ 0xc2918c00, 0xc29197ff, REGISTRY_RIPENCC    }, // 194.145.140.0   - 194.145.151.255
	{ 0xc2919900, 0xc291d1ff, REGISTRY_RIPENCC    }, // 194.145.153.0   - 194.145.209.255
	{ 0xc291d600, 0xc291ffff, REGISTRY_RIPENCC    }, // 194.145.214.0   - 194.145.255.255
	{ 0xc2920200, 0xc29207ff, REGISTRY_RIPENCC    }, // 194.146.2.0     - 194.146.7.255  
	{ 0xc2920a00, 0xc2920eff, REGISTRY_RIPENCC    }, // 194.146.10.0    - 194.146.14.255 
	{ 0xc2921000, 0xc2921bff, REGISTRY_RIPENCC    }, // 194.146.16.0    - 194.146.27.255 
	{ 0xc2921e00, 0xc29221ff, REGISTRY_RIPENCC    }, // 194.146.30.0    - 194.146.33.255 
	{ 0xc2922500, 0xc29226ff, REGISTRY_RIPENCC    }, // 194.146.37.0    - 194.146.38.255 
	{ 0xc2922900, 0xc2922eff, REGISTRY_RIPENCC    }, // 194.146.41.0    - 194.146.46.255 
	{ 0xc2923000, 0xc29245ff, REGISTRY_RIPENCC    }, // 194.146.48.0    - 194.146.69.255 
	{ 0xc2924700, 0xc29264ff, REGISTRY_RIPENCC    }, // 194.146.71.0    - 194.146.100.255
	{ 0xc2926600, 0xc29271ff, REGISTRY_RIPENCC    }, // 194.146.102.0   - 194.146.113.255
	{ 0xc2927300, 0xc29273ff, REGISTRY_RIPENCC    }, // 194.146.115.0   - 194.146.115.255
	{ 0xc2927500, 0xc2927bff, REGISTRY_RIPENCC    }, // 194.146.117.0   - 194.146.123.255
	{ 0xc2927d00, 0xc2927dff, REGISTRY_RIPENCC    }, // 194.146.125.0   - 194.146.125.255
	{ 0xc2927f00, 0xc2927fff, REGISTRY_RIPENCC    }, // 194.146.127.0   - 194.146.127.255
	{ 0xc2928000, 0xc29283ff, REGISTRY_RIPENCC    }, // 194.146.128.0   - 194.146.131.255
	{ 0xc2928400, 0xc2929bff, REGISTRY_RIPENCC    }, // 194.146.132.0   - 194.146.155.255
	{ 0xc292a000, 0xc292a3ff, REGISTRY_RIPENCC    }, // 194.146.160.0   - 194.146.163.255
	{ 0xc292a800, 0xc292bfff, REGISTRY_RIPENCC    }, // 194.146.168.0   - 194.146.191.255
	{ 0xc292c400, 0xc292cbff, REGISTRY_RIPENCC    }, // 194.146.196.0   - 194.146.203.255
	{ 0xc292d000, 0xc292dbff, REGISTRY_RIPENCC    }, // 194.146.208.0   - 194.146.219.255
	{ 0xc292e000, 0xc292ffff, REGISTRY_RIPENCC    }, // 194.146.224.0   - 194.146.255.255
	{ 0xc2930f00, 0xc29315ff, REGISTRY_RIPENCC    }, // 194.147.15.0    - 194.147.21.255 
	{ 0xc2932600, 0xc2932fff, REGISTRY_RIPENCC    }, // 194.147.38.0    - 194.147.47.255 
	{ 0xc2933100, 0xc29337ff, REGISTRY_RIPENCC    }, // 194.147.49.0    - 194.147.55.255 
	{ 0xc2934200, 0xc29346ff, REGISTRY_RIPENCC    }, // 194.147.66.0    - 194.147.70.255 
	{ 0xc2934800, 0xc29349ff, REGISTRY_RIPENCC    }, // 194.147.72.0    - 194.147.73.255 
	{ 0xc2934b00, 0xc2934dff, REGISTRY_RIPENCC    }, // 194.147.75.0    - 194.147.77.255 
	{ 0xc2934f00, 0xc29351ff, REGISTRY_RIPENCC    }, // 194.147.79.0    - 194.147.81.255 
	{ 0xc2935300, 0xc29361ff, REGISTRY_RIPENCC    }, // 194.147.83.0    - 194.147.97.255 
	{ 0xc2936400, 0xc29364ff, REGISTRY_RIPENCC    }, // 194.147.100.0   - 194.147.100.255
	{ 0xc2936600, 0xc2936aff, REGISTRY_RIPENCC    }, // 194.147.102.0   - 194.147.106.255
	{ 0xc2936c00, 0xc2936cff, REGISTRY_RIPENCC    }, // 194.147.108.0   - 194.147.108.255
	{ 0xc2936f00, 0xc29375ff, REGISTRY_RIPENCC    }, // 194.147.111.0   - 194.147.117.255
	{ 0xc2937900, 0xc2937bff, REGISTRY_RIPENCC    }, // 194.147.121.0   - 194.147.123.255
	{ 0xc2938400, 0xc29397ff, REGISTRY_RIPENCC    }, // 194.147.132.0   - 194.147.151.255
	{ 0xc293a000, 0xc293a5ff, REGISTRY_RIPENCC    }, // 194.147.160.0   - 194.147.165.255
	{ 0xc293a800, 0xc293edff, REGISTRY_RIPENCC    }, // 194.147.168.0   - 194.147.237.255
	{ 0xc293ef00, 0xc293ffff, REGISTRY_RIPENCC    }, // 194.147.239.0   - 194.147.255.255
	{ 0xc2940000, 0xc29547ff, REGISTRY_RIPENCC    }, // 194.148.0.0     - 194.149.71.255 
	{ 0xc2954800, 0xc29558ff, REGISTRY_RIPENCC    }, // 194.149.72.0    - 194.149.88.255 
	{ 0xc2955a00, 0xc2955aff, REGISTRY_RIPENCC    }, // 194.149.90.0    - 194.149.90.255 
	{ 0xc2955c00, 0xc2955cff, REGISTRY_RIPENCC    }, // 194.149.92.0    - 194.149.92.255 
	{ 0xc2955e00, 0xc2955fff, REGISTRY_RIPENCC    }, // 194.149.94.0    - 194.149.95.255 
	{ 0xc2956000, 0xc295dfff, REGISTRY_RIPENCC    }, // 194.149.96.0    - 194.149.223.255
	{ 0xc295e000, 0xc295ffff, REGISTRY_RIPENCC    }, // 194.149.224.0   - 194.149.255.255
	{ 0xc2960000, 0xc2963fff, REGISTRY_RIPENCC    }, // 194.150.0.0     - 194.150.63.255 
	{ 0xc2964000, 0xc29643ff, REGISTRY_RIPENCC    }, // 194.150.64.0    - 194.150.67.255 
	{ 0xc2964800, 0xc2965bff, REGISTRY_RIPENCC    }, // 194.150.72.0    - 194.150.91.255 
	{ 0xc2966000, 0xc2967bff, REGISTRY_RIPENCC    }, // 194.150.96.0    - 194.150.123.255
	{ 0xc2968000, 0xc296b3ff, REGISTRY_RIPENCC    }, // 194.150.128.0   - 194.150.179.255
	{ 0xc296b600, 0xc296d5ff, REGISTRY_RIPENCC    }, // 194.150.182.0   - 194.150.213.255
	{ 0xc296d800, 0xc296e9ff, REGISTRY_RIPENCC    }, // 194.150.216.0   - 194.150.233.255
	{ 0xc296ec00, 0xc296ffff, REGISTRY_RIPENCC    }, // 194.150.236.0   - 194.150.255.255
	{ 0xc2970000, 0xc2981fff, REGISTRY_RIPENCC    }, // 194.151.0.0     - 194.152.31.255 
	{ 0xc2982000, 0xc29839ff, REGISTRY_RIPENCC    }, // 194.152.32.0    - 194.152.57.255 
	{ 0xc2983c00, 0xc2983fff, REGISTRY_RIPENCC    }, // 194.152.60.0    - 194.152.63.255 
	{ 0xc2984000, 0xc2991fff, REGISTRY_RIPENCC    }, // 194.152.64.0    - 194.153.31.255 
	{ 0xc2992000, 0xc29947ff, REGISTRY_RIPENCC    }, // 194.153.32.0    - 194.153.71.255 
	{ 0xc2994a00, 0xc2994bff, REGISTRY_RIPENCC    }, // 194.153.74.0    - 194.153.75.255 
	{ 0xc2994e00, 0xc2994fff, REGISTRY_RIPENCC    }, // 194.153.78.0    - 194.153.79.255 
	{ 0xc2995100, 0xc29962ff, REGISTRY_RIPENCC    }, // 194.153.81.0    - 194.153.98.255 
	{ 0xc2996400, 0xc29965ff, REGISTRY_RIPENCC    }, // 194.153.100.0   - 194.153.101.255
	{ 0xc2996800, 0xc29984ff, REGISTRY_RIPENCC    }, // 194.153.104.0   - 194.153.132.255
	{ 0xc2998600, 0xc29998ff, REGISTRY_RIPENCC    }, // 194.153.134.0   - 194.153.152.255
	{ 0xc2999980, 0xc2999cff, REGISTRY_RIPENCC    }, // 194.153.153.128 - 194.153.156.255
	{ 0xc2999d40, 0xc2999dff, REGISTRY_RIPENCC    }, // 194.153.157.64  - 194.153.157.255
	{ 0xc2999e80, 0xc299a9ff, REGISTRY_RIPENCC    }, // 194.153.158.128 - 194.153.169.255
	{ 0xc299ab00, 0xc299b8ff, REGISTRY_RIPENCC    }, // 194.153.171.0   - 194.153.184.255
	{ 0xc299ba00, 0xc299bfff, REGISTRY_RIPENCC    }, // 194.153.186.0   - 194.153.191.255
	{ 0xc299c000, 0xc299d5ff, REGISTRY_RIPENCC    }, // 194.153.192.0   - 194.153.213.255
	{ 0xc299d600, 0xc299dfff, REGISTRY_RIPENCC    }, // 194.153.214.0   - 194.153.223.255
	{ 0xc299e000, 0xc29bffff, REGISTRY_RIPENCC    }, // 194.153.224.0   - 194.155.255.255
	{ 0xc29c0000, 0xc29c0aff, REGISTRY_RIPENCC    }, // 194.156.0.0     - 194.156.10.255 
	{ 0xc29c0c00, 0xc29c19ff, REGISTRY_RIPENCC    }, // 194.156.12.0    - 194.156.25.255 
	{ 0xc29c1c00, 0xc29c1cff, REGISTRY_RIPENCC    }, // 194.156.28.0    - 194.156.28.255 
	{ 0xc29c2000, 0xc29c3fff, REGISTRY_RIPENCC    }, // 194.156.32.0    - 194.156.63.255 
	{ 0xc29c8000, 0xc29c83ff, REGISTRY_RIPENCC    }, // 194.156.128.0   - 194.156.131.255
	{ 0xc29c8500, 0xc29c8fff, REGISTRY_RIPENCC    }, // 194.156.133.0   - 194.156.143.255
	{ 0xc29c9100, 0xc29c99ff, REGISTRY_RIPENCC    }, // 194.156.145.0   - 194.156.153.255
	{ 0xc29c9c00, 0xc29ca1ff, REGISTRY_RIPENCC    }, // 194.156.156.0   - 194.156.161.255
	{ 0xc29ca300, 0xc29cafff, REGISTRY_RIPENCC    }, // 194.156.163.0   - 194.156.175.255
	{ 0xc29cb400, 0xc29cb8ff, REGISTRY_RIPENCC    }, // 194.156.180.0   - 194.156.184.255
	{ 0xc29cba00, 0xc29cbfff, REGISTRY_RIPENCC    }, // 194.156.186.0   - 194.156.191.255
	{ 0xc29cc300, 0xc29cd5ff, REGISTRY_RIPENCC    }, // 194.156.195.0   - 194.156.213.255
	{ 0xc29cd800, 0xc29ce2ff, REGISTRY_RIPENCC    }, // 194.156.216.0   - 194.156.226.255
	{ 0xc29ce400, 0xc29ce6ff, REGISTRY_RIPENCC    }, // 194.156.228.0   - 194.156.230.255
	{ 0xc29ce800, 0xc29cf7ff, REGISTRY_RIPENCC    }, // 194.156.232.0   - 194.156.247.255
	{ 0xc29cfb00, 0xc29cffff, REGISTRY_RIPENCC    }, // 194.156.251.0   - 194.156.255.255
	{ 0xc29d0000, 0xc2a4ffff, REGISTRY_RIPENCC    }, // 194.157.0.0     - 194.164.255.255
	{ 0xc2a50000, 0xc2a503ff, REGISTRY_RIPENCC    }, // 194.165.0.0     - 194.165.3.255  
	{ 0xc2a50600, 0xc2a522ff, REGISTRY_RIPENCC    }, // 194.165.6.0     - 194.165.34.255 
	{ 0xc2a52400, 0xc2a537ff, REGISTRY_RIPENCC    }, // 194.165.36.0    - 194.165.55.255 
	{ 0xc2a53900, 0xc2a539ff, REGISTRY_RIPENCC    }, // 194.165.57.0    - 194.165.57.255 
	{ 0xc2a53b00, 0xc2a53fff, REGISTRY_RIPENCC    }, // 194.165.59.0    - 194.165.63.255 
	{ 0xc2a54000, 0xc2a8ffff, REGISTRY_RIPENCC    }, // 194.165.64.0    - 194.168.255.255
	{ 0xc2a90000, 0xc2a92fff, REGISTRY_RIPENCC    }, // 194.169.0.0     - 194.169.47.255 
	{ 0xc2a93200, 0xc2a932ff, REGISTRY_RIPENCC    }, // 194.169.50.0    - 194.169.50.255 
	{ 0xc2a93400, 0xc2a937ff, REGISTRY_RIPENCC    }, // 194.169.52.0    - 194.169.55.255 
	{ 0xc2a94000, 0xc2a954ff, REGISTRY_RIPENCC    }, // 194.169.64.0    - 194.169.84.255 
	{ 0xc2a95600, 0xc2a95bff, REGISTRY_RIPENCC    }, // 194.169.86.0    - 194.169.91.255 
	{ 0xc2a96000, 0xc2a99eff, REGISTRY_RIPENCC    }, // 194.169.96.0    - 194.169.158.255
	{ 0xc2a9a000, 0xc2a9b7ff, REGISTRY_RIPENCC    }, // 194.169.160.0   - 194.169.183.255
	{ 0xc2a9bf00, 0xc2a9c0ff, REGISTRY_RIPENCC    }, // 194.169.191.0   - 194.169.192.255
	{ 0xc2a9c200, 0xc2a9d4ff, REGISTRY_RIPENCC    }, // 194.169.194.0   - 194.169.212.255
	{ 0xc2a9d600, 0xc2a9e5ff, REGISTRY_RIPENCC    }, // 194.169.214.0   - 194.169.229.255
	{ 0xc2a9e700, 0xc2a9ecff, REGISTRY_RIPENCC    }, // 194.169.231.0   - 194.169.236.255
	{ 0xc2a9ee00, 0xc2a9f1ff, REGISTRY_RIPENCC    }, // 194.169.238.0   - 194.169.241.255
	{ 0xc2a9f300, 0xc2a9fcff, REGISTRY_RIPENCC    }, // 194.169.243.0   - 194.169.252.255
	{ 0xc2a9fe00, 0xc2a9ffff, REGISTRY_RIPENCC    }, // 194.169.254.0   - 194.169.255.255
	{ 0xc2aa0000, 0xc2b05fff, REGISTRY_RIPENCC    }, // 194.170.0.0     - 194.176.95.255 
	{ 0xc2b06000, 0xc2b061ff, REGISTRY_RIPENCC    }, // 194.176.96.0    - 194.176.97.255 
	{ 0xc2b06400, 0xc2b06aff, REGISTRY_RIPENCC    }, // 194.176.100.0   - 194.176.106.255
	{ 0xc2b06c00, 0xc2b074ff, REGISTRY_RIPENCC    }, // 194.176.108.0   - 194.176.116.255
	{ 0xc2b07600, 0xc2b07aff, REGISTRY_RIPENCC    }, // 194.176.118.0   - 194.176.122.255
	{ 0xc2b07c00, 0xc2b07fff, REGISTRY_RIPENCC    }, // 194.176.124.0   - 194.176.127.255
	{ 0xc2b08000, 0xc2b0ffff, REGISTRY_RIPENCC    }, // 194.176.128.0   - 194.176.255.255
	{ 0xc2b10000, 0xc2b113ff, REGISTRY_RIPENCC    }, // 194.177.0.0     - 194.177.19.255 
	{ 0xc2b11400, 0xc2b117ff, REGISTRY_RIPENCC    }, // 194.177.20.0    - 194.177.23.255 
	{ 0xc2b11800, 0xc2b11fff, REGISTRY_RIPENCC    }, // 194.177.24.0    - 194.177.31.255 
	{ 0xc2b12000, 0xc2b3ffff, REGISTRY_RIPENCC    }, // 194.177.32.0    - 194.179.255.255
	{ 0xc2b40000, 0xc2b412ff, REGISTRY_RIPENCC    }, // 194.180.0.0     - 194.180.18.255 
	{ 0xc2b41400, 0xc2b418ff, REGISTRY_RIPENCC    }, // 194.180.20.0    - 194.180.24.255 
	{ 0xc2b41a00, 0xc2b430ff, REGISTRY_RIPENCC    }, // 194.180.26.0    - 194.180.48.255 
	{ 0xc2b43200, 0xc2b43dff, REGISTRY_RIPENCC    }, // 194.180.50.0    - 194.180.61.255 
	{ 0xc2b43f00, 0xc2b469ff, REGISTRY_RIPENCC    }, // 194.180.63.0    - 194.180.105.255
	{ 0xc2b46c00, 0xc2b4bcff, REGISTRY_RIPENCC    }, // 194.180.108.0   - 194.180.188.255
	{ 0xc2b4be00, 0xc2b4d01f, REGISTRY_RIPENCC    }, // 194.180.190.0   - 194.180.208.31 
	{ 0xc2b4d040, 0xc2b4d0bf, REGISTRY_RIPENCC    }, // 194.180.208.64  - 194.180.208.191
	{ 0xc2b4d0e0, 0xc2b4dbff, REGISTRY_RIPENCC    }, // 194.180.208.224 - 194.180.219.255
	{ 0xc2b4e000, 0xc2b4e28f, REGISTRY_RIPENCC    }, // 194.180.224.0   - 194.180.226.143
	{ 0xc2b4e298, 0xc2b4e2bf, REGISTRY_RIPENCC    }, // 194.180.226.152 - 194.180.226.191
	{ 0xc2b4e2e0, 0xc2b4e3ff, REGISTRY_RIPENCC    }, // 194.180.226.224 - 194.180.227.255
	{ 0xc2b4e700, 0xc2b4ecff, REGISTRY_RIPENCC    }, // 194.180.231.0   - 194.180.236.255
	{ 0xc2b4ee00, 0xc2b4ffff, REGISTRY_RIPENCC    }, // 194.180.238.0   - 194.180.255.255
	{ 0xc2b50000, 0xc2baffff, REGISTRY_RIPENCC    }, // 194.181.0.0     - 194.186.255.255
	{ 0xc2bb0000, 0xc2bb17ff, REGISTRY_RIPENCC    }, // 194.187.0.0     - 194.187.23.255 
	{ 0xc2bb1c00, 0xc2bb77ff, REGISTRY_RIPENCC    }, // 194.187.28.0    - 194.187.119.255
	{ 0xc2bb7c00, 0xc2bbb3ff, REGISTRY_RIPENCC    }, // 194.187.124.0   - 194.187.179.255
	{ 0xc2bbb400, 0xc2bbb7ff, REGISTRY_RIPENCC    }, // 194.187.180.0   - 194.187.183.255
	{ 0xc2bbb800, 0xc2bbbbff, REGISTRY_RIPENCC    }, // 194.187.184.0   - 194.187.187.255
	{ 0xc2bbc000, 0xc2bbf7ff, REGISTRY_RIPENCC    }, // 194.187.192.0   - 194.187.247.255
	{ 0xc2bbf800, 0xc2bbfbff, REGISTRY_RIPENCC    }, // 194.187.248.0   - 194.187.251.255
	{ 0xc2bbfc00, 0xc2bbffff, REGISTRY_RIPENCC    }, // 194.187.252.0   - 194.187.255.255
	{ 0xc2bc0000, 0xc2ccbfff, REGISTRY_RIPENCC    }, // 194.188.0.0     - 194.204.191.255
	{ 0xc2ccc000, 0xc2ccffff, REGISTRY_AFRINIC    }, // 194.204.192.0   - 194.204.255.255
	{ 0xc2cd0000, 0xc2d4ffff, REGISTRY_RIPENCC    }, // 194.205.0.0     - 194.212.255.255
	{ 0xc2d50000, 0xc2d507ff, REGISTRY_RIPENCC    }, // 194.213.0.0     - 194.213.7.255  
	{ 0xc2d50900, 0xc2d509ff, REGISTRY_RIPENCC    }, // 194.213.9.0     - 194.213.9.255  
	{ 0xc2d50b00, 0xc2d50cff, REGISTRY_RIPENCC    }, // 194.213.11.0    - 194.213.12.255 
	{ 0xc2d50e00, 0xc2d510ff, REGISTRY_RIPENCC    }, // 194.213.14.0    - 194.213.16.255 
	{ 0xc2d51200, 0xc2d513ff, REGISTRY_RIPENCC    }, // 194.213.18.0    - 194.213.19.255 
	{ 0xc2d51500, 0xc2d517ff, REGISTRY_RIPENCC    }, // 194.213.21.0    - 194.213.23.255 
	{ 0xc2d51900, 0xc2d51fff, REGISTRY_RIPENCC    }, // 194.213.25.0    - 194.213.31.255 
	{ 0xc2d52000, 0xc2d55fff, REGISTRY_RIPENCC    }, // 194.213.32.0    - 194.213.95.255 
	{ 0xc2d56000, 0xc2d57fff, REGISTRY_RIPENCC    }, // 194.213.96.0    - 194.213.127.255
	{ 0xc2d58000, 0xc2f1ffff, REGISTRY_RIPENCC    }, // 194.213.128.0   - 194.241.255.255
	{ 0xc2f20000, 0xc2f215ff, REGISTRY_RIPENCC    }, // 194.242.0.0     - 194.242.21.255 
	{ 0xc2f21800, 0xc2f21bff, REGISTRY_RIPENCC    }, // 194.242.24.0    - 194.242.27.255 
	{ 0xc2f21e00, 0xc2f225ff, REGISTRY_RIPENCC    }, // 194.242.30.0    - 194.242.37.255 
	{ 0xc2f22700, 0xc2f22cff, REGISTRY_RIPENCC    }, // 194.242.39.0    - 194.242.44.255 
	{ 0xc2f22f00, 0xc2f22fff, REGISTRY_RIPENCC    }, // 194.242.47.0    - 194.242.47.255 
	{ 0xc2f23200, 0xc2f237ff, REGISTRY_RIPENCC    }, // 194.242.50.0    - 194.242.55.255 
	{ 0xc2f23900, 0xc2f23fff, REGISTRY_RIPENCC    }, // 194.242.57.0    - 194.242.63.255 
	{ 0xc2f24000, 0xc2f25fff, REGISTRY_RIPENCC    }, // 194.242.64.0    - 194.242.95.255 
	{ 0xc2f26000, 0xc2f27fff, REGISTRY_RIPENCC    }, // 194.242.96.0    - 194.242.127.255
	{ 0xc2f28000, 0xc2f61fff, REGISTRY_RIPENCC    }, // 194.242.128.0   - 194.246.31.255 
	{ 0xc2f62000, 0xc2f626ff, REGISTRY_RIPENCC    }, // 194.246.32.0    - 194.246.38.255 
	{ 0xc2f62760, 0xc2f627ff, REGISTRY_RIPENCC    }, // 194.246.39.96   - 194.246.39.255 
	{ 0xc2f62c00, 0xc2f657ff, REGISTRY_RIPENCC    }, // 194.246.44.0    - 194.246.87.255 
	{ 0xc2f66000, 0xc2f663ff, REGISTRY_RIPENCC    }, // 194.246.96.0    - 194.246.99.255 
	{ 0xc2f66500, 0xc2f666ff, REGISTRY_RIPENCC    }, // 194.246.101.0   - 194.246.102.255
	{ 0xc2f66800, 0xc2f73fff, REGISTRY_RIPENCC    }, // 194.246.104.0   - 194.247.63.255 
	{ 0xc2f74000, 0xc2f79fff, REGISTRY_RIPENCC    }, // 194.247.64.0    - 194.247.159.255
	{ 0xc2f7a000, 0xc2f7b5ff, REGISTRY_RIPENCC    }, // 194.247.160.0   - 194.247.181.255
	{ 0xc2f7b800, 0xc2f7b9ff, REGISTRY_RIPENCC    }, // 194.247.184.0   - 194.247.185.255
	{ 0xc2f7bc00, 0xc2f7bfff, REGISTRY_RIPENCC    }, // 194.247.188.0   - 194.247.191.255
	{ 0xc2f7c000, 0xc302bfff, REGISTRY_RIPENCC    }, // 194.247.192.0   - 195.2.191.255  
	{ 0xc302c000, 0xc302d3ff, REGISTRY_RIPENCC    }, // 195.2.192.0     - 195.2.211.255  
	{ 0xc302d600, 0xc302f1ff, REGISTRY_RIPENCC    }, // 195.2.214.0     - 195.2.241.255  
	{ 0xc302f400, 0xc302ffff, REGISTRY_RIPENCC    }, // 195.2.244.0     - 195.2.255.255  
	{ 0xc3030000, 0xc3037fff, REGISTRY_RIPENCC    }, // 195.3.0.0       - 195.3.127.255  
	{ 0xc3038000, 0xc303ffff, REGISTRY_RIPENCC    }, // 195.3.128.0     - 195.3.255.255  
	{ 0xc3040000, 0xc3055fff, REGISTRY_RIPENCC    }, // 195.4.0.0       - 195.5.95.255   
	{ 0xc3056200, 0xc3057fff, REGISTRY_RIPENCC    }, // 195.5.98.0      - 195.5.127.255  
	{ 0xc3058000, 0xc3059fff, REGISTRY_RIPENCC    }, // 195.5.128.0     - 195.5.159.255  
	{ 0xc305a000, 0xc305a7ff, REGISTRY_RIPENCC    }, // 195.5.160.0     - 195.5.167.255  
	{ 0xc305a900, 0xc305a9ff, REGISTRY_RIPENCC    }, // 195.5.169.0     - 195.5.169.255  
	{ 0xc305ab00, 0xc305afff, REGISTRY_RIPENCC    }, // 195.5.171.0     - 195.5.175.255  
	{ 0xc305b100, 0xc305bfff, REGISTRY_RIPENCC    }, // 195.5.177.0     - 195.5.191.255  
	{ 0xc305c000, 0xc306ffff, REGISTRY_RIPENCC    }, // 195.5.192.0     - 195.6.255.255  
	{ 0xc3071000, 0xc3071fff, REGISTRY_RIPENCC    }, // 195.7.16.0      - 195.7.31.255   
	{ 0xc3072000, 0xc3081fff, REGISTRY_RIPENCC    }, // 195.7.32.0      - 195.8.31.255   
	{ 0xc3082000, 0xc3082fff, REGISTRY_RIPENCC    }, // 195.8.32.0      - 195.8.47.255   
	{ 0xc3083200, 0xc3083fff, REGISTRY_RIPENCC    }, // 195.8.50.0      - 195.8.63.255   
	{ 0xc3084000, 0xc3085fff, REGISTRY_RIPENCC    }, // 195.8.64.0      - 195.8.95.255   
	{ 0xc3086000, 0xc30865ff, REGISTRY_RIPENCC    }, // 195.8.96.0      - 195.8.101.255  
	{ 0xc3086700, 0xc3086dff, REGISTRY_RIPENCC    }, // 195.8.103.0     - 195.8.109.255  
	{ 0xc3086f00, 0xc3086fff, REGISTRY_RIPENCC    }, // 195.8.111.0     - 195.8.111.255  
	{ 0xc3087100, 0xc30871ff, REGISTRY_RIPENCC    }, // 195.8.113.0     - 195.8.113.255  
	{ 0xc3087300, 0xc30875ff, REGISTRY_RIPENCC    }, // 195.8.115.0     - 195.8.117.255  
	{ 0xc3087800, 0xc3087fff, REGISTRY_RIPENCC    }, // 195.8.120.0     - 195.8.127.255  
	{ 0xc3088000, 0xc308bfff, REGISTRY_RIPENCC    }, // 195.8.128.0     - 195.8.191.255  
	{ 0xc308c000, 0xc308dfff, REGISTRY_RIPENCC    }, // 195.8.192.0     - 195.8.223.255  
	{ 0xc308e000, 0xc30abfff, REGISTRY_RIPENCC    }, // 195.8.224.0     - 195.10.191.255 
	{ 0xc30ac000, 0xc30ad0ff, REGISTRY_RIPENCC    }, // 195.10.192.0    - 195.10.208.255 
	{ 0xc30ad200, 0xc30ad6ff, REGISTRY_RIPENCC    }, // 195.10.210.0    - 195.10.214.255 
	{ 0xc30ad800, 0xc30adaff, REGISTRY_RIPENCC    }, // 195.10.216.0    - 195.10.218.255 
	{ 0xc30adc00, 0xc30addff, REGISTRY_RIPENCC    }, // 195.10.220.0    - 195.10.221.255 
	{ 0xc30adf00, 0xc30adfff, REGISTRY_RIPENCC    }, // 195.10.223.0    - 195.10.223.255 
	{ 0xc30ae000, 0xc30c1fff, REGISTRY_RIPENCC    }, // 195.10.224.0    - 195.12.31.255  
	{ 0xc30c2000, 0xc30c2fff, REGISTRY_RIPENCC    }, // 195.12.32.0     - 195.12.47.255  
	{ 0xc30c3000, 0xc30c33ff, REGISTRY_RIPENCC    }, // 195.12.48.0     - 195.12.51.255  
	{ 0xc30c3400, 0xc30c3fff, REGISTRY_RIPENCC    }, // 195.12.52.0     - 195.12.63.255  
	{ 0xc30c4000, 0xc30d1fff, REGISTRY_RIPENCC    }, // 195.12.64.0     - 195.13.31.255  
	{ 0xc30d2000, 0xc30d2bff, REGISTRY_RIPENCC    }, // 195.13.32.0     - 195.13.43.255  
	{ 0xc30d2d00, 0xc30d2eff, REGISTRY_RIPENCC    }, // 195.13.45.0     - 195.13.46.255  
	{ 0xc30d3000, 0xc30d3fff, REGISTRY_RIPENCC    }, // 195.13.48.0     - 195.13.63.255  
	{ 0xc30d4000, 0xc30dffff, REGISTRY_RIPENCC    }, // 195.13.64.0     - 195.13.255.255 
	{ 0xc30e0000, 0xc30e06ff, REGISTRY_RIPENCC    }, // 195.14.0.0      - 195.14.6.255   
	{ 0xc30e0800, 0xc30e09ff, REGISTRY_RIPENCC    }, // 195.14.8.0      - 195.14.9.255   
	{ 0xc30e0b00, 0xc30e19ff, REGISTRY_RIPENCC    }, // 195.14.11.0     - 195.14.25.255  
	{ 0xc30e1c00, 0xc30e1fff, REGISTRY_RIPENCC    }, // 195.14.28.0     - 195.14.31.255  
	{ 0xc30e2000, 0xc30e5fff, REGISTRY_RIPENCC    }, // 195.14.32.0     - 195.14.95.255  
	{ 0xc30e6000, 0xc30e6fff, REGISTRY_RIPENCC    }, // 195.14.96.0     - 195.14.111.255 
	{ 0xc30e7200, 0xc30e7fff, REGISTRY_RIPENCC    }, // 195.14.114.0    - 195.14.127.255 
	{ 0xc30e8000, 0xc3103fff, REGISTRY_RIPENCC    }, // 195.14.128.0    - 195.16.63.255  
	{ 0xc3104400, 0xc3105fff, REGISTRY_RIPENCC    }, // 195.16.68.0     - 195.16.95.255  
	{ 0xc3106000, 0xc311ffff, REGISTRY_RIPENCC    }, // 195.16.96.0     - 195.17.255.255 
	{ 0xc3120000, 0xc3121fff, REGISTRY_RIPENCC    }, // 195.18.0.0      - 195.18.31.255  
	{ 0xc3122000, 0xc313ffff, REGISTRY_RIPENCC    }, // 195.18.32.0     - 195.19.255.255 
	{ 0xc3140000, 0xc3141fff, REGISTRY_RIPENCC    }, // 195.20.0.0      - 195.20.31.255  
	{ 0xc3142000, 0xc3145fff, REGISTRY_RIPENCC    }, // 195.20.32.0     - 195.20.95.255  
	{ 0xc3146000, 0xc31461ff, REGISTRY_RIPENCC    }, // 195.20.96.0     - 195.20.97.255  
	{ 0xc3146400, 0xc31467ff, REGISTRY_RIPENCC    }, // 195.20.100.0    - 195.20.103.255 
	{ 0xc3146a00, 0xc3148eff, REGISTRY_RIPENCC    }, // 195.20.106.0    - 195.20.142.255 
	{ 0xc3149000, 0xc3149fff, REGISTRY_RIPENCC    }, // 195.20.144.0    - 195.20.159.255 
	{ 0xc314a000, 0xc314bfff, REGISTRY_RIPENCC    }, // 195.20.160.0    - 195.20.191.255 
	{ 0xc314c000, 0xc314dfff, REGISTRY_RIPENCC    }, // 195.20.192.0    - 195.20.223.255 
	{ 0xc314e000, 0xc3165fff, REGISTRY_RIPENCC    }, // 195.20.224.0    - 195.22.95.255  
	{ 0xc3166000, 0xc31679ff, REGISTRY_RIPENCC    }, // 195.22.96.0     - 195.22.121.255 
	{ 0xc3167b00, 0xc31693ff, REGISTRY_RIPENCC    }, // 195.22.123.0    - 195.22.147.255 
	{ 0xc3169600, 0xc31697ff, REGISTRY_RIPENCC    }, // 195.22.150.0    - 195.22.151.255 
	{ 0xc3169a00, 0xc3169bff, REGISTRY_RIPENCC    }, // 195.22.154.0    - 195.22.155.255 
	{ 0xc3169e00, 0xc3169fff, REGISTRY_RIPENCC    }, // 195.22.158.0    - 195.22.159.255 
	{ 0xc316a000, 0xc3183fff, REGISTRY_RIPENCC    }, // 195.22.160.0    - 195.24.63.255  
	{ 0xc3184000, 0xc3184fff, REGISTRY_RIPENCC    }, // 195.24.64.0     - 195.24.79.255  
	{ 0xc3185000, 0xc31857ff, REGISTRY_AFRINIC    }, // 195.24.80.0     - 195.24.87.255  
	{ 0xc3185800, 0xc3185fff, REGISTRY_RIPENCC    }, // 195.24.88.0     - 195.24.95.255  
	{ 0xc3186000, 0xc318bfff, REGISTRY_RIPENCC    }, // 195.24.96.0     - 195.24.191.255 
	{ 0xc318c000, 0xc318dfff, REGISTRY_AFRINIC    }, // 195.24.192.0    - 195.24.223.255 
	{ 0xc318e000, 0xc318ffff, REGISTRY_RIPENCC    }, // 195.24.224.0    - 195.24.255.255 
	{ 0xc3190000, 0xc319ffff, REGISTRY_RIPENCC    }, // 195.25.0.0      - 195.25.255.255 
	{ 0xc31a0000, 0xc31a07ff, REGISTRY_RIPENCC    }, // 195.26.0.0      - 195.26.7.255   
	{ 0xc31a0a00, 0xc31a1fff, REGISTRY_RIPENCC    }, // 195.26.10.0     - 195.26.31.255  
	{ 0xc31a2000, 0xc31a3fff, REGISTRY_RIPENCC    }, // 195.26.32.0     - 195.26.63.255  
	{ 0xc31a4000, 0xc31a43ff, REGISTRY_RIPENCC    }, // 195.26.64.0     - 195.26.67.255  
	{ 0xc31a4800, 0xc31a5fff, REGISTRY_RIPENCC    }, // 195.26.72.0     - 195.26.95.255  
	{ 0xc31a6000, 0xc31bffff, REGISTRY_RIPENCC    }, // 195.26.96.0     - 195.27.255.255 
	{ 0xc31c0000, 0xc31c05ff, REGISTRY_RIPENCC    }, // 195.28.0.0      - 195.28.5.255   
	{ 0xc31c0800, 0xc31c09ff, REGISTRY_RIPENCC    }, // 195.28.8.0      - 195.28.9.255   
	{ 0xc31c0c00, 0xc31c1fff, REGISTRY_RIPENCC    }, // 195.28.12.0     - 195.28.31.255  
	{ 0xc31c2000, 0xc31c9fff, REGISTRY_RIPENCC    }, // 195.28.32.0     - 195.28.159.255 
	{ 0xc31ca000, 0xc31ca7ff, REGISTRY_RIPENCC    }, // 195.28.160.0    - 195.28.167.255 
	{ 0xc31caa00, 0xc31cb1ff, REGISTRY_RIPENCC    }, // 195.28.170.0    - 195.28.177.255 
	{ 0xc31cb400, 0xc31cbfff, REGISTRY_RIPENCC    }, // 195.28.180.0    - 195.28.191.255 
	{ 0xc31cc000, 0xc3223fff, REGISTRY_RIPENCC    }, // 195.28.192.0    - 195.34.63.255  
	{ 0xc3224000, 0xc32241ff, REGISTRY_RIPENCC    }, // 195.34.64.0     - 195.34.65.255  
	{ 0xc3224400, 0xc32245ff, REGISTRY_RIPENCC    }, // 195.34.68.0     - 195.34.69.255  
	{ 0xc3224800, 0xc3225fff, REGISTRY_RIPENCC    }, // 195.34.72.0     - 195.34.95.255  
	{ 0xc3226000, 0xc322bfff, REGISTRY_RIPENCC    }, // 195.34.96.0     - 195.34.191.255 
	{ 0xc322c000, 0xc322c7ff, REGISTRY_RIPENCC    }, // 195.34.192.0    - 195.34.199.255 
	{ 0xc322cc00, 0xc322dfff, REGISTRY_RIPENCC    }, // 195.34.204.0    - 195.34.223.255 
	{ 0xc322e000, 0xc3233fff, REGISTRY_RIPENCC    }, // 195.34.224.0    - 195.35.63.255  
	{ 0xc3234000, 0xc32360ff, REGISTRY_RIPENCC    }, // 195.35.64.0     - 195.35.96.255  
	{ 0xc3236300, 0xc32365ff, REGISTRY_RIPENCC    }, // 195.35.99.0     - 195.35.101.255 
	{ 0xc3236700, 0xc32367ff, REGISTRY_RIPENCC    }, // 195.35.103.0    - 195.35.103.255 
	{ 0xc3236820, 0xc32375ff, REGISTRY_RIPENCC    }, // 195.35.104.32   - 195.35.117.255 
	{ 0xc3237800, 0xc3237fff, REGISTRY_RIPENCC    }, // 195.35.120.0    - 195.35.127.255 
	{ 0xc3238000, 0xc325ffff, REGISTRY_RIPENCC    }, // 195.35.128.0    - 195.37.255.255 
	{ 0xc3260c00, 0xc3261fff, REGISTRY_RIPENCC    }, // 195.38.12.0     - 195.38.31.255  
	{ 0xc3262000, 0xc327bfff, REGISTRY_RIPENCC    }, // 195.38.32.0     - 195.39.191.255 
	{ 0xc327c000, 0xc327c1ff, REGISTRY_RIPENCC    }, // 195.39.192.0    - 195.39.193.255 
	{ 0xc327c400, 0xc327c9ff, REGISTRY_RIPENCC    }, // 195.39.196.0    - 195.39.201.255 
	{ 0xc327cc00, 0xc327d5ff, REGISTRY_RIPENCC    }, // 195.39.204.0    - 195.39.213.255 
	{ 0xc327d800, 0xc327d9ff, REGISTRY_RIPENCC    }, // 195.39.216.0    - 195.39.217.255 
	{ 0xc327da00, 0xc327dbff, REGISTRY_AFRINIC    }, // 195.39.218.0    - 195.39.219.255 
	{ 0xc327de00, 0xc327f5ff, REGISTRY_RIPENCC    }, // 195.39.222.0    - 195.39.245.255 
	{ 0xc327f800, 0xc327f9ff, REGISTRY_RIPENCC    }, // 195.39.248.0    - 195.39.249.255 
	{ 0xc327fe00, 0xc327ffff, REGISTRY_RIPENCC    }, // 195.39.254.0    - 195.39.255.255 
	{ 0xc3280000, 0xc329ffff, REGISTRY_RIPENCC    }, // 195.40.0.0      - 195.41.255.255 
	{ 0xc32a0000, 0xc32a3fff, REGISTRY_RIPENCC    }, // 195.42.0.0      - 195.42.63.255  
	{ 0xc32a4000, 0xc32a5fff, REGISTRY_RIPENCC    }, // 195.42.64.0     - 195.42.95.255  
	{ 0xc32a6000, 0xc32a9dff, REGISTRY_RIPENCC    }, // 195.42.96.0     - 195.42.157.255 
	{ 0xc32aa000, 0xc32adfff, REGISTRY_RIPENCC    }, // 195.42.160.0    - 195.42.223.255 
	{ 0xc32ae000, 0xc32ae7ff, REGISTRY_RIPENCC    }, // 195.42.224.0    - 195.42.231.255 
	{ 0xc32aec00, 0xc32affff, REGISTRY_RIPENCC    }, // 195.42.236.0    - 195.42.255.255 
	{ 0xc32b0000, 0xc32b1fff, REGISTRY_AFRINIC    }, // 195.43.0.0      - 195.43.31.255  
	{ 0xc32b2000, 0xc32b4fff, REGISTRY_RIPENCC    }, // 195.43.32.0     - 195.43.79.255  
	{ 0xc32b5200, 0xc32b5fff, REGISTRY_RIPENCC    }, // 195.43.82.0     - 195.43.95.255  
	{ 0xc32b6000, 0xc32b7fff, REGISTRY_RIPENCC    }, // 195.43.96.0     - 195.43.127.255 
	{ 0xc32b8100, 0xc32b9fff, REGISTRY_RIPENCC    }, // 195.43.129.0    - 195.43.159.255 
	{ 0xc32ba000, 0xc32e1fff, REGISTRY_RIPENCC    }, // 195.43.160.0    - 195.46.31.255  
	{ 0xc32e2000, 0xc32e3bff, REGISTRY_RIPENCC    }, // 195.46.32.0     - 195.46.59.255  
	{ 0xc32e3c00, 0xc32fbfff, REGISTRY_RIPENCC    }, // 195.46.60.0     - 195.47.191.255 
	{ 0xc32fc000, 0xc32fd1ff, REGISTRY_RIPENCC    }, // 195.47.192.0    - 195.47.209.255 
	{ 0xc32fd300, 0xc32fd3ff, REGISTRY_RIPENCC    }, // 195.47.211.0    - 195.47.211.255 
	{ 0xc32fd500, 0xc32fd7ff, REGISTRY_RIPENCC    }, // 195.47.213.0    - 195.47.215.255 
	{ 0xc32fd900, 0xc32fd9ff, REGISTRY_RIPENCC    }, // 195.47.217.0    - 195.47.217.255 
	{ 0xc32fdb00, 0xc32feeff, REGISTRY_RIPENCC    }, // 195.47.219.0    - 195.47.238.255 
	{ 0xc32ff000, 0xc32ff1ff, REGISTRY_RIPENCC    }, // 195.47.240.0    - 195.47.241.255 
	{ 0xc32ff300, 0xc32ff9ff, REGISTRY_RIPENCC    }, // 195.47.243.0    - 195.47.249.255 
	{ 0xc32ffb00, 0xc32fffff, REGISTRY_RIPENCC    }, // 195.47.251.0    - 195.47.255.255 
	{ 0xc3300000, 0xc3317fff, REGISTRY_RIPENCC    }, // 195.48.0.0      - 195.49.127.255 
	{ 0xc3318400, 0xc331afff, REGISTRY_RIPENCC    }, // 195.49.132.0    - 195.49.175.255 
	{ 0xc331b000, 0xc331b3ff, REGISTRY_RIPENCC    }, // 195.49.176.0    - 195.49.179.255 
	{ 0xc331b400, 0xc331e7ff, REGISTRY_RIPENCC    }, // 195.49.180.0    - 195.49.231.255 
	{ 0xc331f000, 0xc331ffff, REGISTRY_RIPENCC    }, // 195.49.240.0    - 195.49.255.255 
	{ 0xc3320000, 0xc3361fff, REGISTRY_RIPENCC    }, // 195.50.0.0      - 195.54.31.255  
	{ 0xc3362000, 0xc3363fff, REGISTRY_RIPENCC    }, // 195.54.32.0     - 195.54.63.255  
	{ 0xc3364000, 0xc3369fff, REGISTRY_RIPENCC    }, // 195.54.64.0     - 195.54.159.255 
	{ 0xc336a200, 0xc336a5ff, REGISTRY_RIPENCC    }, // 195.54.162.0    - 195.54.165.255 
	{ 0xc336a800, 0xc336a9ff, REGISTRY_RIPENCC    }, // 195.54.168.0    - 195.54.169.255 
	{ 0xc336ac00, 0xc336bfff, REGISTRY_RIPENCC    }, // 195.54.172.0    - 195.54.191.255 
	{ 0xc336c000, 0xc33c3fff, REGISTRY_RIPENCC    }, // 195.54.192.0    - 195.60.63.255  
	{ 0xc33c4000, 0xc33c4fff, REGISTRY_RIPENCC    }, // 195.60.64.0     - 195.60.79.255  
	{ 0xc33c5060, 0xc33c547f, REGISTRY_RIPENCC    }, // 195.60.80.96    - 195.60.84.127  
	{ 0xc33c5500, 0xc33c557f, REGISTRY_RIPENCC    }, // 195.60.85.0     - 195.60.85.127  
	{ 0xc33c5600, 0xc33c57ff, REGISTRY_RIPENCC    }, // 195.60.86.0     - 195.60.87.255  
	{ 0xc33c5880, 0xc33c5d3f, REGISTRY_RIPENCC    }, // 195.60.88.128   - 195.60.93.63   
	{ 0xc33c5d80, 0xc33c5e7f, REGISTRY_RIPENCC    }, // 195.60.93.128   - 195.60.94.127  
	{ 0xc33c5f00, 0xc33c5fff, REGISTRY_RIPENCC    }, // 195.60.95.0     - 195.60.95.255  
	{ 0xc33c6000, 0xc33c9fff, REGISTRY_RIPENCC    }, // 195.60.96.0     - 195.60.159.255 
	{ 0xc33ca000, 0xc33cabff, REGISTRY_RIPENCC    }, // 195.60.160.0    - 195.60.171.255 
	{ 0xc33cae00, 0xc33cafff, REGISTRY_RIPENCC    }, // 195.60.174.0    - 195.60.175.255 
	{ 0xc33cb200, 0xc33ccbff, REGISTRY_RIPENCC    }, // 195.60.178.0    - 195.60.203.255 
	{ 0xc33cd000, 0xc33cffff, REGISTRY_RIPENCC    }, // 195.60.208.0    - 195.60.255.255 
	{ 0xc33d0000, 0xc33dffff, REGISTRY_RIPENCC    }, // 195.61.0.0      - 195.61.255.255 
	{ 0xc33e0000, 0xc33e15ff, REGISTRY_RIPENCC    }, // 195.62.0.0      - 195.62.21.255  
	{ 0xc33e1800, 0xc33e55ff, REGISTRY_RIPENCC    }, // 195.62.24.0     - 195.62.85.255  
	{ 0xc33e5800, 0xc33e5fff, REGISTRY_RIPENCC    }, // 195.62.88.0     - 195.62.95.255  
	{ 0xc33e6000, 0xc3407fff, REGISTRY_RIPENCC    }, // 195.62.96.0     - 195.64.127.255 
	{ 0xc3408200, 0xc34097ff, REGISTRY_RIPENCC    }, // 195.64.130.0    - 195.64.151.255 
	{ 0xc3409a00, 0xc340a7ff, REGISTRY_RIPENCC    }, // 195.64.154.0    - 195.64.167.255 
	{ 0xc340aa00, 0xc340bfff, REGISTRY_RIPENCC    }, // 195.64.170.0    - 195.64.191.255 
	{ 0xc340c000, 0xc341ffff, REGISTRY_RIPENCC    }, // 195.64.192.0    - 195.65.255.255 
	{ 0xc3420000, 0xc3421fff, REGISTRY_RIPENCC    }, // 195.66.0.0      - 195.66.31.255  
	{ 0xc3422000, 0xc3423fff, REGISTRY_RIPENCC    }, // 195.66.32.0     - 195.66.63.255  
	{ 0xc3424000, 0xc34256ff, REGISTRY_RIPENCC    }, // 195.66.64.0     - 195.66.86.255  
	{ 0xc3425800, 0xc34267ff, REGISTRY_RIPENCC    }, // 195.66.88.0     - 195.66.103.255 
	{ 0xc3426900, 0xc34271ff, REGISTRY_RIPENCC    }, // 195.66.105.0    - 195.66.113.255 
	{ 0xc3427300, 0xc34277ff, REGISTRY_RIPENCC    }, // 195.66.115.0    - 195.66.119.255 
	{ 0xc3427900, 0xc34297ff, REGISTRY_RIPENCC    }, // 195.66.121.0    - 195.66.151.255 
	{ 0xc3429a00, 0xc3429fff, REGISTRY_RIPENCC    }, // 195.66.154.0    - 195.66.159.255 
	{ 0xc342a000, 0xc344bfff, REGISTRY_RIPENCC    }, // 195.66.160.0    - 195.68.191.255 
	{ 0xc344c000, 0xc344dfff, REGISTRY_RIPENCC    }, // 195.68.192.0    - 195.68.223.255 
	{ 0xc344e400, 0xc344f7ff, REGISTRY_RIPENCC    }, // 195.68.228.0    - 195.68.247.255 
	{ 0xc344fa00, 0xc344fdff, REGISTRY_RIPENCC    }, // 195.68.250.0    - 195.68.253.255 
	{ 0xc3450000, 0xc34563ff, REGISTRY_RIPENCC    }, // 195.69.0.0      - 195.69.99.255  
	{ 0xc3456800, 0xc34587ff, REGISTRY_RIPENCC    }, // 195.69.104.0    - 195.69.135.255 
	{ 0xc3459000, 0xc345abff, REGISTRY_RIPENCC    }, // 195.69.144.0    - 195.69.171.255 
	{ 0xc345ac00, 0xc345afff, REGISTRY_RIPENCC    }, // 195.69.172.0    - 195.69.175.255 
	{ 0xc345b000, 0xc345e3ff, REGISTRY_RIPENCC    }, // 195.69.176.0    - 195.69.227.255 
	{ 0xc345e800, 0xc345efff, REGISTRY_RIPENCC    }, // 195.69.232.0    - 195.69.239.255 
	{ 0xc345f000, 0xc345f3ff, REGISTRY_RIPENCC    }, // 195.69.240.0    - 195.69.243.255 
	{ 0xc345f400, 0xc345fbff, REGISTRY_RIPENCC    }, // 195.69.244.0    - 195.69.251.255 
	{ 0xc3460000, 0xc3485fff, REGISTRY_RIPENCC    }, // 195.70.0.0      - 195.72.95.255  
	{ 0xc3486000, 0xc3489fff, REGISTRY_RIPENCC    }, // 195.72.96.0     - 195.72.159.255 
	{ 0xc348a000, 0xc34a1fff, REGISTRY_RIPENCC    }, // 195.72.160.0    - 195.74.31.255  
	{ 0xc34a2000, 0xc34a37ff, REGISTRY_RIPENCC    }, // 195.74.32.0     - 195.74.55.255  
	{ 0xc34a3800, 0xc34a3bff, REGISTRY_RIPENCC    }, // 195.74.56.0     - 195.74.59.255  
	{ 0xc34a3c00, 0xc34a5fff, REGISTRY_RIPENCC    }, // 195.74.60.0     - 195.74.95.255  
	{ 0xc34a6000, 0xc34e1fff, REGISTRY_RIPENCC    }, // 195.74.96.0     - 195.78.31.255  
	{ 0xc34e2000, 0xc34e2fff, REGISTRY_RIPENCC    }, // 195.78.32.0     - 195.78.47.255  
	{ 0xc34e3200, 0xc34e35ff, REGISTRY_RIPENCC    }, // 195.78.50.0     - 195.78.53.255  
	{ 0xc34e3a00, 0xc34e7fff, REGISTRY_RIPENCC    }, // 195.78.58.0     - 195.78.127.255 
	{ 0xc34e8000, 0xc34edfff, REGISTRY_RIPENCC    }, // 195.78.128.0    - 195.78.223.255 
	{ 0xc34ee000, 0xc34effff, REGISTRY_RIPENCC    }, // 195.78.224.0    - 195.78.255.255 
	{ 0xc34f0000, 0xc35087ff, REGISTRY_RIPENCC    }, // 195.79.0.0      - 195.80.135.255 
	{ 0xc3508800, 0xc35097ff, REGISTRY_RIPENCC    }, // 195.80.136.0    - 195.80.151.255 
	{ 0xc3509800, 0xc350dfff, REGISTRY_RIPENCC    }, // 195.80.152.0    - 195.80.223.255 
	{ 0xc350e000, 0xc350e5ff, REGISTRY_RIPENCC    }, // 195.80.224.0    - 195.80.229.255 
	{ 0xc350e800, 0xc350ffff, REGISTRY_RIPENCC    }, // 195.80.232.0    - 195.80.255.255 
	{ 0xc3510000, 0xc3527fff, REGISTRY_RIPENCC    }, // 195.81.0.0      - 195.82.127.255 
	{ 0xc3528000, 0xc35283ff, REGISTRY_RIPENCC    }, // 195.82.128.0    - 195.82.131.255 
	{ 0xc3528600, 0xc3529fff, REGISTRY_RIPENCC    }, // 195.82.134.0    - 195.82.159.255 
	{ 0xc352a000, 0xc355bfff, REGISTRY_RIPENCC    }, // 195.82.160.0    - 195.85.191.255 
	{ 0xc355c000, 0xc355c1ff, REGISTRY_RIPENCC    }, // 195.85.192.0    - 195.85.193.255 
	{ 0xc355c300, 0xc355c4ff, REGISTRY_RIPENCC    }, // 195.85.195.0    - 195.85.196.255 
	{ 0xc355c600, 0xc355c8ff, REGISTRY_RIPENCC    }, // 195.85.198.0    - 195.85.200.255 
	{ 0xc355ca00, 0xc355ceff, REGISTRY_RIPENCC    }, // 195.85.202.0    - 195.85.206.255 
	{ 0xc355d000, 0xc355d9ff, REGISTRY_RIPENCC    }, // 195.85.208.0    - 195.85.217.255 
	{ 0xc355db00, 0xc355deff, REGISTRY_RIPENCC    }, // 195.85.219.0    - 195.85.222.255 
	{ 0xc355e000, 0xc355e1ff, REGISTRY_RIPENCC    }, // 195.85.224.0    - 195.85.225.255 
	{ 0xc355e300, 0xc355f7ff, REGISTRY_RIPENCC    }, // 195.85.227.0    - 195.85.247.255 
	{ 0xc355f900, 0xc355ffff, REGISTRY_RIPENCC    }, // 195.85.249.0    - 195.85.255.255 
	{ 0xc3560000, 0xc357ffff, REGISTRY_RIPENCC    }, // 195.86.0.0      - 195.87.255.255 
	{ 0xc3580000, 0xc35817ff, REGISTRY_RIPENCC    }, // 195.88.0.0      - 195.88.23.255  
	{ 0xc3581a00, 0xc35837ff, REGISTRY_RIPENCC    }, // 195.88.26.0     - 195.88.55.255  
	{ 0xc3583a00, 0xc35867ff, REGISTRY_RIPENCC    }, // 195.88.58.0     - 195.88.103.255 
	{ 0xc3586a00, 0xc35895ff, REGISTRY_RIPENCC    }, // 195.88.106.0    - 195.88.149.255 
	{ 0xc3589800, 0xc358a7ff, REGISTRY_RIPENCC    }, // 195.88.152.0    - 195.88.167.255 
	{ 0xc358aa00, 0xc358e1ff, REGISTRY_RIPENCC    }, // 195.88.170.0    - 195.88.225.255 
	{ 0xc358e400, 0xc358e5ff, REGISTRY_RIPENCC    }, // 195.88.228.0    - 195.88.229.255 
	{ 0xc358e800, 0xc358e9ff, REGISTRY_RIPENCC    }, // 195.88.232.0    - 195.88.233.255 
	{ 0xc358ec00, 0xc358ffff, REGISTRY_RIPENCC    }, // 195.88.236.0    - 195.88.255.255 
	{ 0xc3590000, 0xc35a5fff, REGISTRY_RIPENCC    }, // 195.89.0.0      - 195.90.95.255  
	{ 0xc35a6000, 0xc35a61ff, REGISTRY_RIPENCC    }, // 195.90.96.0     - 195.90.97.255  
	{ 0xc35a6400, 0xc35a71ff, REGISTRY_RIPENCC    }, // 195.90.100.0    - 195.90.113.255 
	{ 0xc35a7400, 0xc35a75ff, REGISTRY_RIPENCC    }, // 195.90.116.0    - 195.90.117.255 
	{ 0xc35a7800, 0xc35a7fff, REGISTRY_RIPENCC    }, // 195.90.120.0    - 195.90.127.255 
	{ 0xc35a8000, 0xc35d7fff, REGISTRY_RIPENCC    }, // 195.90.128.0    - 195.93.127.255 
	{ 0xc35d8000, 0xc35d9fff, REGISTRY_RIPENCC    }, // 195.93.128.0    - 195.93.159.255 
	{ 0xc35da200, 0xc35dafff, REGISTRY_RIPENCC    }, // 195.93.162.0    - 195.93.175.255 
	{ 0xc35db200, 0xc35db7ff, REGISTRY_RIPENCC    }, // 195.93.178.0    - 195.93.183.255 
	{ 0xc35dba00, 0xc35dcfff, REGISTRY_RIPENCC    }, // 195.93.186.0    - 195.93.207.255 
	{ 0xc35dd200, 0xc35dffff, REGISTRY_RIPENCC    }, // 195.93.210.0    - 195.93.255.255 
	{ 0xc35e0000, 0xc35f7fff, REGISTRY_RIPENCC    }, // 195.94.0.0      - 195.95.127.255 
	{ 0xc35f8000, 0xc35f81ff, REGISTRY_RIPENCC    }, // 195.95.128.0    - 195.95.129.255 
	{ 0xc35f8300, 0xc35f85ff, REGISTRY_RIPENCC    }, // 195.95.131.0    - 195.95.133.255 
	{ 0xc35f8700, 0xc35f9aff, REGISTRY_RIPENCC    }, // 195.95.135.0    - 195.95.154.255 
	{ 0xc35f9c00, 0xc35fb8ff, REGISTRY_RIPENCC    }, // 195.95.156.0    - 195.95.184.255 
	{ 0xc35fba00, 0xc35fc7ff, REGISTRY_RIPENCC    }, // 195.95.186.0    - 195.95.199.255 
	{ 0xc35fca00, 0xc35fffff, REGISTRY_RIPENCC    }, // 195.95.202.0    - 195.95.255.255 
	{ 0xc3600000, 0xc36dffff, REGISTRY_RIPENCC    }, // 195.96.0.0      - 195.109.255.255
	{ 0xc36e0400, 0xc36e15ff, REGISTRY_RIPENCC    }, // 195.110.4.0     - 195.110.21.255 
	{ 0xc36e1800, 0xc36e3fff, REGISTRY_RIPENCC    }, // 195.110.24.0    - 195.110.63.255 
	{ 0xc36e4000, 0xc371ffff, REGISTRY_RIPENCC    }, // 195.110.64.0    - 195.113.255.255
	{ 0xc3720000, 0xc37203ff, REGISTRY_RIPENCC    }, // 195.114.0.0     - 195.114.3.255  
	{ 0xc3720600, 0xc3720dff, REGISTRY_RIPENCC    }, // 195.114.6.0     - 195.114.13.255 
	{ 0xc3721000, 0xc3721fff, REGISTRY_RIPENCC    }, // 195.114.16.0    - 195.114.31.255 
	{ 0xc3722000, 0xc3725fff, REGISTRY_RIPENCC    }, // 195.114.32.0    - 195.114.95.255 
	{ 0xc3726000, 0xc3726bff, REGISTRY_RIPENCC    }, // 195.114.96.0    - 195.114.107.255
	{ 0xc3727000, 0xc37273ff, REGISTRY_RIPENCC    }, // 195.114.112.0   - 195.114.115.255
	{ 0xc3727800, 0xc3727fff, REGISTRY_RIPENCC    }, // 195.114.120.0   - 195.114.127.255
	{ 0xc3728000, 0xc37fffff, REGISTRY_RIPENCC    }, // 195.114.128.0   - 195.127.255.255
	{ 0xc3800000, 0xc3800bff, REGISTRY_RIPENCC    }, // 195.128.0.0     - 195.128.11.255 
	{ 0xc3801000, 0xc38017ff, REGISTRY_RIPENCC    }, // 195.128.16.0    - 195.128.23.255 
	{ 0xc3801c00, 0xc3803fff, REGISTRY_RIPENCC    }, // 195.128.28.0    - 195.128.63.255 
	{ 0xc3804000, 0xc3805fff, REGISTRY_RIPENCC    }, // 195.128.64.0    - 195.128.95.255 
	{ 0xc3806800, 0xc380a1ff, REGISTRY_RIPENCC    }, // 195.128.104.0   - 195.128.161.255
	{ 0xc380a400, 0xc380b1ff, REGISTRY_RIPENCC    }, // 195.128.164.0   - 195.128.177.255
	{ 0xc380b400, 0xc380bfff, REGISTRY_RIPENCC    }, // 195.128.180.0   - 195.128.191.255
	{ 0xc380c000, 0xc380dfff, REGISTRY_RIPENCC    }, // 195.128.192.0   - 195.128.223.255
	{ 0xc380e000, 0xc380efff, REGISTRY_RIPENCC    }, // 195.128.224.0   - 195.128.239.255
	{ 0xc380f200, 0xc380fdff, REGISTRY_RIPENCC    }, // 195.128.242.0   - 195.128.253.255
	{ 0xc3810000, 0xc382bfff, REGISTRY_RIPENCC    }, // 195.129.0.0     - 195.130.191.255
	{ 0xc382c000, 0xc382cbff, REGISTRY_RIPENCC    }, // 195.130.192.0   - 195.130.203.255
	{ 0xc382cd00, 0xc382cfff, REGISTRY_RIPENCC    }, // 195.130.205.0   - 195.130.207.255
	{ 0xc382d100, 0xc382dfff, REGISTRY_RIPENCC    }, // 195.130.209.0   - 195.130.223.255
	{ 0xc382e000, 0xc3863fff, REGISTRY_RIPENCC    }, // 195.130.224.0   - 195.134.63.255 
	{ 0xc3864000, 0xc3867fff, REGISTRY_RIPENCC    }, // 195.134.64.0    - 195.134.127.255
	{ 0xc3868000, 0xc387bfff, REGISTRY_RIPENCC    }, // 195.134.128.0   - 195.135.191.255
	{ 0xc387c000, 0xc387f3ff, REGISTRY_RIPENCC    }, // 195.135.192.0   - 195.135.243.255
	{ 0xc387f800, 0xc387fbff, REGISTRY_RIPENCC    }, // 195.135.248.0   - 195.135.251.255
	{ 0xc3880000, 0xc3899fff, REGISTRY_RIPENCC    }, // 195.136.0.0     - 195.137.159.255
	{ 0xc389a000, 0xc389a3ff, REGISTRY_RIPENCC    }, // 195.137.160.0   - 195.137.163.255
	{ 0xc389a500, 0xc389b9ff, REGISTRY_RIPENCC    }, // 195.137.165.0   - 195.137.185.255
	{ 0xc389bb00, 0xc389bbff, REGISTRY_RIPENCC    }, // 195.137.187.0   - 195.137.187.255
	{ 0xc389bd00, 0xc389bfff, REGISTRY_RIPENCC    }, // 195.137.189.0   - 195.137.191.255
	{ 0xc389c200, 0xc389cbff, REGISTRY_RIPENCC    }, // 195.137.194.0   - 195.137.203.255
	{ 0xc389ce00, 0xc389ffff, REGISTRY_RIPENCC    }, // 195.137.206.0   - 195.137.255.255
	{ 0xc38a0000, 0xc38abfff, REGISTRY_RIPENCC    }, // 195.138.0.0     - 195.138.191.255
	{ 0xc38ac000, 0xc38adbff, REGISTRY_RIPENCC    }, // 195.138.192.0   - 195.138.219.255
	{ 0xc38add00, 0xc38adfff, REGISTRY_RIPENCC    }, // 195.138.221.0   - 195.138.223.255
	{ 0xc38ae000, 0xc38bffff, REGISTRY_RIPENCC    }, // 195.138.224.0   - 195.139.255.255
	{ 0xc38c0000, 0xc38c7fff, REGISTRY_RIPENCC    }, // 195.140.0.0     - 195.140.127.255
	{ 0xc38c8400, 0xc38cdfff, REGISTRY_RIPENCC    }, // 195.140.132.0   - 195.140.223.255
	{ 0xc38ce400, 0xc38cebff, REGISTRY_RIPENCC    }, // 195.140.228.0   - 195.140.235.255
	{ 0xc38cec00, 0xc38cefff, REGISTRY_RIPENCC    }, // 195.140.236.0   - 195.140.239.255
	{ 0xc38cf000, 0xc38cffff, REGISTRY_RIPENCC    }, // 195.140.240.0   - 195.140.255.255
	{ 0xc38d0000, 0xc38fffff, REGISTRY_RIPENCC    }, // 195.141.0.0     - 195.143.255.255
	{ 0xc3900000, 0xc3901aff, REGISTRY_RIPENCC    }, // 195.144.0.0     - 195.144.26.255 
	{ 0xc3901c00, 0xc3901fff, REGISTRY_RIPENCC    }, // 195.144.28.0    - 195.144.31.255 
	{ 0xc3902000, 0xc3953fff, REGISTRY_RIPENCC    }, // 195.144.32.0    - 195.149.63.255 
	{ 0xc3954000, 0xc39542ff, REGISTRY_RIPENCC    }, // 195.149.64.0    - 195.149.66.255 
	{ 0xc3954400, 0xc3955cff, REGISTRY_RIPENCC    }, // 195.149.68.0    - 195.149.92.255 
	{ 0xc3955e00, 0xc39576ff, REGISTRY_RIPENCC    }, // 195.149.94.0    - 195.149.118.255
	{ 0xc3957800, 0xc3957fff, REGISTRY_RIPENCC    }, // 195.149.120.0   - 195.149.127.255
	{ 0xc3958000, 0xc395bfff, REGISTRY_RIPENCC    }, // 195.149.128.0   - 195.149.191.255
	{ 0xc395c000, 0xc395ffff, REGISTRY_RIPENCC    }, // 195.149.192.0   - 195.149.255.255
	{ 0xc3960000, 0xc39edfff, REGISTRY_RIPENCC    }, // 195.150.0.0     - 195.158.223.255
	{ 0xc39ee000, 0xc39ef3ff, REGISTRY_RIPENCC    }, // 195.158.224.0   - 195.158.243.255
	{ 0xc39ef600, 0xc39effff, REGISTRY_RIPENCC    }, // 195.158.246.0   - 195.158.255.255
	{ 0xc39f0000, 0xc39fffff, REGISTRY_RIPENCC    }, // 195.159.0.0     - 195.159.255.255
	{ 0xc3a00000, 0xc3a0b9ff, REGISTRY_RIPENCC    }, // 195.160.0.0     - 195.160.185.255
	{ 0xc3a0bc00, 0xc3a0ffff, REGISTRY_RIPENCC    }, // 195.160.188.0   - 195.160.255.255
	{ 0xc3a10000, 0xc3a1ffff, REGISTRY_RIPENCC    }, // 195.161.0.0     - 195.161.255.255
	{ 0xc3a20000, 0xc3a205ff, REGISTRY_RIPENCC    }, // 195.162.0.0     - 195.162.5.255  
	{ 0xc3a20800, 0xc3a21fff, REGISTRY_RIPENCC    }, // 195.162.8.0     - 195.162.31.255 
	{ 0xc3a22000, 0xc3a23fff, REGISTRY_RIPENCC    }, // 195.162.32.0    - 195.162.63.255 
	{ 0xc3a24000, 0xc3a25fff, REGISTRY_RIPENCC    }, // 195.162.64.0    - 195.162.95.255 
	{ 0xc3a26000, 0xc3a6dfff, REGISTRY_RIPENCC    }, // 195.162.96.0    - 195.166.223.255
	{ 0xc3a70000, 0xc3aa9fff, REGISTRY_RIPENCC    }, // 195.167.0.0     - 195.170.159.255
	{ 0xc3aaa000, 0xc3aaa4ff, REGISTRY_RIPENCC    }, // 195.170.160.0   - 195.170.164.255
	{ 0xc3aaa600, 0xc3aaa6ff, REGISTRY_RIPENCC    }, // 195.170.166.0   - 195.170.166.255
	{ 0xc3aaa800, 0xc3aabfff, REGISTRY_RIPENCC    }, // 195.170.168.0   - 195.170.191.255
	{ 0xc3aac000, 0xc3b13fff, REGISTRY_RIPENCC    }, // 195.170.192.0   - 195.177.63.255 
	{ 0xc3b14000, 0xc3b16bff, REGISTRY_RIPENCC    }, // 195.177.64.0    - 195.177.107.255
	{ 0xc3b17400, 0xc3b17fff, REGISTRY_RIPENCC    }, // 195.177.116.0   - 195.177.127.255
	{ 0xc3b18000, 0xc3b1bfff, REGISTRY_RIPENCC    }, // 195.177.128.0   - 195.177.191.255
	{ 0xc3b1c000, 0xc3b1c1ff, REGISTRY_RIPENCC    }, // 195.177.192.0   - 195.177.193.255
	{ 0xc3b1c400, 0xc3b1e5ff, REGISTRY_RIPENCC    }, // 195.177.196.0   - 195.177.229.255
	{ 0xc3b1e800, 0xc3b21fff, REGISTRY_RIPENCC    }, // 195.177.232.0   - 195.178.31.255 
	{ 0xc3b22000, 0xc3b25fff, REGISTRY_RIPENCC    }, // 195.178.32.0    - 195.178.95.255 
	{ 0xc3b26000, 0xc3b277ff, REGISTRY_RIPENCC    }, // 195.178.96.0    - 195.178.119.255
	{ 0xc3b27a00, 0xc3b27bff, REGISTRY_RIPENCC    }, // 195.178.122.0   - 195.178.123.255
	{ 0xc3b28000, 0xc3b5ffff, REGISTRY_RIPENCC    }, // 195.178.128.0   - 195.181.255.255
	{ 0xc3b60000, 0xc3b609ff, REGISTRY_RIPENCC    }, // 195.182.0.0     - 195.182.9.255  
	{ 0xc3b60b00, 0xc3b60eff, REGISTRY_RIPENCC    }, // 195.182.11.0    - 195.182.14.255 
	{ 0xc3b61000, 0xc3b624ff, REGISTRY_RIPENCC    }, // 195.182.16.0    - 195.182.36.255 
	{ 0xc3b62600, 0xc3b63fff, REGISTRY_RIPENCC    }, // 195.182.38.0    - 195.182.63.255 
	{ 0xc3b64000, 0xc3b6bfff, REGISTRY_RIPENCC    }, // 195.182.64.0    - 195.182.191.255
	{ 0xc3b6c000, 0xc3b6c5ff, REGISTRY_RIPENCC    }, // 195.182.192.0   - 195.182.197.255
	{ 0xc3b6ca00, 0xc3b6cbff, REGISTRY_RIPENCC    }, // 195.182.202.0   - 195.182.203.255
	{ 0xc3b6ce00, 0xc3b6dfff, REGISTRY_RIPENCC    }, // 195.182.206.0   - 195.182.223.255
	{ 0xc3b6e000, 0xc3b83fff, REGISTRY_RIPENCC    }, // 195.182.224.0   - 195.184.63.255 
	{ 0xc3b84000, 0xc3b847ff, REGISTRY_RIPENCC    }, // 195.184.64.0    - 195.184.71.255 
	{ 0xc3b84a00, 0xc3b855ff, REGISTRY_RIPENCC    }, // 195.184.74.0    - 195.184.85.255 
	{ 0xc3b85800, 0xc3b85fff, REGISTRY_RIPENCC    }, // 195.184.88.0    - 195.184.95.255 
	{ 0xc3b86000, 0xc3bcffff, REGISTRY_RIPENCC    }, // 195.184.96.0    - 195.188.255.255
	{ 0xc3bd0000, 0xc3bd97ff, REGISTRY_RIPENCC    }, // 195.189.0.0     - 195.189.151.255
	{ 0xc3bd9a00, 0xc3bda3ff, REGISTRY_RIPENCC    }, // 195.189.154.0   - 195.189.163.255
	{ 0xc3bda600, 0xc3bda7ff, REGISTRY_RIPENCC    }, // 195.189.166.0   - 195.189.167.255
	{ 0xc3bdaa00, 0xc3bdadff, REGISTRY_RIPENCC    }, // 195.189.170.0   - 195.189.173.255
	{ 0xc3bdb000, 0xc3bdb7ff, REGISTRY_RIPENCC    }, // 195.189.176.0   - 195.189.183.255
	{ 0xc3bdba00, 0xc3be1fff, REGISTRY_RIPENCC    }, // 195.189.186.0   - 195.190.31.255 
	{ 0xc3be2000, 0xc3be7fff, REGISTRY_RIPENCC    }, // 195.190.32.0    - 195.190.127.255
	{ 0xc3be8000, 0xc3be8aff, REGISTRY_RIPENCC    }, // 195.190.128.0   - 195.190.138.255
	{ 0xc3be8c00, 0xc3be8fff, REGISTRY_RIPENCC    }, // 195.190.140.0   - 195.190.143.255
	{ 0xc3be9100, 0xc3be94ff, REGISTRY_RIPENCC    }, // 195.190.145.0   - 195.190.148.255
	{ 0xc3be9700, 0xc3be99ff, REGISTRY_RIPENCC    }, // 195.190.151.0   - 195.190.153.255
	{ 0xc3be9b00, 0xc3be9cff, REGISTRY_RIPENCC    }, // 195.190.155.0   - 195.190.156.255
	{ 0xc3be9e00, 0xc3be9fff, REGISTRY_RIPENCC    }, // 195.190.158.0   - 195.190.159.255
	{ 0xc3bea000, 0xc3bedfff, REGISTRY_RIPENCC    }, // 195.190.160.0   - 195.190.223.255
	{ 0xc3bee000, 0xc3bf15ff, REGISTRY_RIPENCC    }, // 195.190.224.0   - 195.191.21.255 
	{ 0xc3bf1800, 0xc3bfafff, REGISTRY_RIPENCC    }, // 195.191.24.0    - 195.191.175.255
	{ 0xc3bfb200, 0xc3bfc5ff, REGISTRY_RIPENCC    }, // 195.191.178.0   - 195.191.197.255
	{ 0xc3bfc800, 0xc3bfcdff, REGISTRY_RIPENCC    }, // 195.191.200.0   - 195.191.205.255
	{ 0xc3bfd000, 0xc3bfffff, REGISTRY_RIPENCC    }, // 195.191.208.0   - 195.191.255.255
	{ 0xc3c00000, 0xc3c83fff, REGISTRY_RIPENCC    }, // 195.192.0.0     - 195.200.63.255 
	{ 0xc3c84000, 0xc3c85fff, REGISTRY_RIPENCC    }, // 195.200.64.0    - 195.200.95.255 
	{ 0xc3c86000, 0xc3c8bfff, REGISTRY_RIPENCC    }, // 195.200.96.0    - 195.200.191.255
	{ 0xc3c8c000, 0xc3c8d6ff, REGISTRY_RIPENCC    }, // 195.200.192.0   - 195.200.214.255
	{ 0xc3c8d800, 0xc3c8dcff, REGISTRY_RIPENCC    }, // 195.200.216.0   - 195.200.220.255
	{ 0xc3c8de00, 0xc3c8ffff, REGISTRY_RIPENCC    }, // 195.200.222.0   - 195.200.255.255
	{ 0xc3c90000, 0xc3ca3fff, REGISTRY_RIPENCC    }, // 195.201.0.0     - 195.202.63.255 
	{ 0xc3ca4000, 0xc3ca5fff, REGISTRY_AFRINIC    }, // 195.202.64.0    - 195.202.95.255 
	{ 0xc3ca6000, 0xc3ce5fff, REGISTRY_RIPENCC    }, // 195.202.96.0    - 195.206.95.255 
	{ 0xc3ce6000, 0xc3ce67ff, REGISTRY_RIPENCC    }, // 195.206.96.0    - 195.206.103.255
	{ 0xc3ce7000, 0xc3ce7fff, REGISTRY_RIPENCC    }, // 195.206.112.0   - 195.206.127.255
	{ 0xc3ce8000, 0xc3cedfff, REGISTRY_RIPENCC    }, // 195.206.128.0   - 195.206.223.255
	{ 0xc3cee000, 0xc3ceffff, REGISTRY_RIPENCC    }, // 195.206.224.0   - 195.206.255.255
	{ 0xc3cf0000, 0xc3d1ffff, REGISTRY_RIPENCC    }, // 195.207.0.0     - 195.209.255.255
	{ 0xc3d20000, 0xc3d23fff, REGISTRY_RIPENCC    }, // 195.210.0.0     - 195.210.63.255 
	{ 0xc3d24000, 0xc3d2ffff, REGISTRY_RIPENCC    }, // 195.210.64.0    - 195.210.255.255
	{ 0xc3d30000, 0xc3d3ffff, REGISTRY_RIPENCC    }, // 195.211.0.0     - 195.211.255.255
	{ 0xc3d40000, 0xc3d6bfff, REGISTRY_RIPENCC    }, // 195.212.0.0     - 195.214.191.255
	{ 0xc3d6c000, 0xc3d6cfff, REGISTRY_RIPENCC    }, // 195.214.192.0   - 195.214.207.255
	{ 0xc3d6d000, 0xc3d6d7ff, REGISTRY_RIPENCC    }, // 195.214.208.0   - 195.214.215.255
	{ 0xc3d6d800, 0xc3d6ffff, REGISTRY_RIPENCC    }, // 195.214.216.0   - 195.214.255.255
	{ 0xc3d70000, 0xc3d8bfff, REGISTRY_RIPENCC    }, // 195.215.0.0     - 195.216.191.255
	{ 0xc3d8c000, 0xc3d8c9ff, REGISTRY_RIPENCC    }, // 195.216.192.0   - 195.216.201.255
	{ 0xc3d8cc00, 0xc3d8cfff, REGISTRY_RIPENCC    }, // 195.216.204.0   - 195.216.207.255
	{ 0xc3d8d200, 0xc3d8e9ff, REGISTRY_RIPENCC    }, // 195.216.210.0   - 195.216.233.255
	{ 0xc3d8eb00, 0xc3d8f4ff, REGISTRY_RIPENCC    }, // 195.216.235.0   - 195.216.244.255
	{ 0xc3d8f600, 0xc3d8f6ff, REGISTRY_RIPENCC    }, // 195.216.246.0   - 195.216.246.255
	{ 0xc3d8f800, 0xc3d8ffff, REGISTRY_RIPENCC    }, // 195.216.248.0   - 195.216.255.255
	{ 0xc3d90000, 0xc3de5fff, REGISTRY_RIPENCC    }, // 195.217.0.0     - 195.222.95.255 
	{ 0xc3de6000, 0xc3de7fff, REGISTRY_RIPENCC    }, // 195.222.96.0    - 195.222.127.255
	{ 0xc3de8000, 0xc3e11fff, REGISTRY_RIPENCC    }, // 195.222.128.0   - 195.225.31.255 
	{ 0xc3e12000, 0xc3e13fff, REGISTRY_RIPENCC    }, // 195.225.32.0    - 195.225.63.255 
	{ 0xc3e14400, 0xc3e1b3ff, REGISTRY_RIPENCC    }, // 195.225.68.0    - 195.225.179.255
	{ 0xc3e1b800, 0xc3e1f7ff, REGISTRY_RIPENCC    }, // 195.225.184.0   - 195.225.247.255
	{ 0xc3e1f800, 0xc3e1fbff, REGISTRY_RIPENCC    }, // 195.225.248.0   - 195.225.251.255
	{ 0xc3e1fc00, 0xc3e1ffff, REGISTRY_RIPENCC    }, // 195.225.252.0   - 195.225.255.255
	{ 0xc3e20000, 0xc3e2bfff, REGISTRY_RIPENCC    }, // 195.226.0.0     - 195.226.191.255
	{ 0xc3e2c000, 0xc3e2d6ff, REGISTRY_RIPENCC    }, // 195.226.192.0   - 195.226.214.255
	{ 0xc3e2d800, 0xc3e2dfff, REGISTRY_RIPENCC    }, // 195.226.216.0   - 195.226.223.255
	{ 0xc3e2e000, 0xc3e65fff, REGISTRY_RIPENCC    }, // 195.226.224.0   - 195.230.95.255 
	{ 0xc3e66000, 0xc3e66aff, REGISTRY_RIPENCC    }, // 195.230.96.0    - 195.230.106.255
	{ 0xc3e66c00, 0xc3e67fff, REGISTRY_RIPENCC    }, // 195.230.108.0   - 195.230.127.255
	{ 0xc3e68000, 0xc3e9ffff, REGISTRY_RIPENCC    }, // 195.230.128.0   - 195.233.255.255
	{ 0xc3ea0000, 0xc3ea3dff, REGISTRY_RIPENCC    }, // 195.234.0.0     - 195.234.61.255 
	{ 0xc3ea4000, 0xc3ea51ff, REGISTRY_RIPENCC    }, // 195.234.64.0    - 195.234.81.255 
	{ 0xc3ea5400, 0xc3ea5bff, REGISTRY_RIPENCC    }, // 195.234.84.0    - 195.234.91.255 
	{ 0xc3ea6000, 0xc3ea6bff, REGISTRY_RIPENCC    }, // 195.234.96.0    - 195.234.107.255
	{ 0xc3ea7000, 0xc3ea77ff, REGISTRY_RIPENCC    }, // 195.234.112.0   - 195.234.119.255
	{ 0xc3ea8000, 0xc3ea81ff, REGISTRY_RIPENCC    }, // 195.234.128.0   - 195.234.129.255
	{ 0xc3ea8300, 0xc3ea8bff, REGISTRY_RIPENCC    }, // 195.234.131.0   - 195.234.139.255
	{ 0xc3ea8d00, 0xc3ea8eff, REGISTRY_RIPENCC    }, // 195.234.141.0   - 195.234.142.255
	{ 0xc3ea9000, 0xc3ea9bff, REGISTRY_RIPENCC    }, // 195.234.144.0   - 195.234.155.255
	{ 0xc3ea9d00, 0xc3ea9eff, REGISTRY_RIPENCC    }, // 195.234.157.0   - 195.234.158.255
	{ 0xc3eaa000, 0xc3eaa0ff, REGISTRY_RIPENCC    }, // 195.234.160.0   - 195.234.160.255
	{ 0xc3eaa200, 0xc3eaa7ff, REGISTRY_RIPENCC    }, // 195.234.162.0   - 195.234.167.255
	{ 0xc3eaa800, 0xc3eaa8ff, REGISTRY_AFRINIC    }, // 195.234.168.0   - 195.234.168.255
	{ 0xc3eaaa00, 0xc3eab4ff, REGISTRY_RIPENCC    }, // 195.234.170.0   - 195.234.180.255
	{ 0xc3eab600, 0xc3eab8ff, REGISTRY_RIPENCC    }, // 195.234.182.0   - 195.234.184.255
	{ 0xc3eab900, 0xc3eab9ff, REGISTRY_AFRINIC    }, // 195.234.185.0   - 195.234.185.255
	{ 0xc3eaba00, 0xc3eabcff, REGISTRY_RIPENCC    }, // 195.234.186.0   - 195.234.188.255
	{ 0xc3eabe00, 0xc3eabeff, REGISTRY_RIPENCC    }, // 195.234.190.0   - 195.234.190.255
	{ 0xc3eac000, 0xc3eafbff, REGISTRY_RIPENCC    }, // 195.234.192.0   - 195.234.251.255
	{ 0xc3eafc00, 0xc3eaffff, REGISTRY_AFRINIC    }, // 195.234.252.0   - 195.234.255.255
	{ 0xc3eb0000, 0xc3edffff, REGISTRY_RIPENCC    }, // 195.235.0.0     - 195.237.255.255
	{ 0xc3ee0000, 0xc3ee1fff, REGISTRY_RIPENCC    }, // 195.238.0.0     - 195.238.31.255 
	{ 0xc3ee2000, 0xc3ee3fff, REGISTRY_RIPENCC    }, // 195.238.32.0    - 195.238.63.255 
	{ 0xc3ee4000, 0xc3ee4dff, REGISTRY_RIPENCC    }, // 195.238.64.0    - 195.238.77.255 
	{ 0xc3ee5000, 0xc3ee5dff, REGISTRY_RIPENCC    }, // 195.238.80.0    - 195.238.93.255 
	{ 0xc3ee6000, 0xc3ee77ff, REGISTRY_RIPENCC    }, // 195.238.96.0    - 195.238.119.255
	{ 0xc3ee8000, 0xc3ee9fff, REGISTRY_RIPENCC    }, // 195.238.128.0   - 195.238.159.255
	{ 0xc3eea000, 0xc3eebfff, REGISTRY_RIPENCC    }, // 195.238.160.0   - 195.238.191.255
	{ 0xc3eec000, 0xc3eedfff, REGISTRY_RIPENCC    }, // 195.238.192.0   - 195.238.223.255
	{ 0xc3eee000, 0xc3eee6ff, REGISTRY_RIPENCC    }, // 195.238.224.0   - 195.238.230.255
	{ 0xc3eee800, 0xc3eef1ff, REGISTRY_RIPENCC    }, // 195.238.232.0   - 195.238.241.255
	{ 0xc3eef400, 0xc3eef6ff, REGISTRY_RIPENCC    }, // 195.238.244.0   - 195.238.246.255
	{ 0xc3eef900, 0xc3eeffff, REGISTRY_RIPENCC    }, // 195.238.249.0   - 195.238.255.255
	{ 0xc3ef0000, 0xc3f23fff, REGISTRY_RIPENCC    }, // 195.239.0.0     - 195.242.63.255 
	{ 0xc3f24000, 0xc3f249ff, REGISTRY_RIPENCC    }, // 195.242.64.0    - 195.242.73.255 
	{ 0xc3f24c00, 0xc3f263ff, REGISTRY_RIPENCC    }, // 195.242.76.0    - 195.242.99.255 
	{ 0xc3f26800, 0xc3f26dff, REGISTRY_RIPENCC    }, // 195.242.104.0   - 195.242.109.255
	{ 0xc3f27000, 0xc3f293ff, REGISTRY_RIPENCC    }, // 195.242.112.0   - 195.242.147.255
	{ 0xc3f29600, 0xc3f2b0ff, REGISTRY_RIPENCC    }, // 195.242.150.0   - 195.242.176.255
	{ 0xc3f2b200, 0xc3f2b5ff, REGISTRY_RIPENCC    }, // 195.242.178.0   - 195.242.181.255
	{ 0xc3f2b700, 0xc3f2baff, REGISTRY_RIPENCC    }, // 195.242.183.0   - 195.242.186.255
	{ 0xc3f2bc00, 0xc3f2d3ff, REGISTRY_RIPENCC    }, // 195.242.188.0   - 195.242.211.255
	{ 0xc3f2d400, 0xc3f2d7ff, REGISTRY_RIPENCC    }, // 195.242.212.0   - 195.242.215.255
	{ 0xc3f2d800, 0xc3f2efff, REGISTRY_RIPENCC    }, // 195.242.216.0   - 195.242.239.255
	{ 0xc3f2f400, 0xc3f2ffff, REGISTRY_RIPENCC    }, // 195.242.244.0   - 195.242.255.255
	{ 0xc3f30000, 0xc3f3ffff, REGISTRY_RIPENCC    }, // 195.243.0.0     - 195.243.255.255
	{ 0xc3f40000, 0xc3f40dff, REGISTRY_RIPENCC    }, // 195.244.0.0     - 195.244.13.255 
	{ 0xc3f41000, 0xc3f411ff, REGISTRY_RIPENCC    }, // 195.244.16.0    - 195.244.17.255 
	{ 0xc3f41400, 0xc3f41fff, REGISTRY_RIPENCC    }, // 195.244.20.0    - 195.244.31.255 
	{ 0xc3f42000, 0xc3f53fff, REGISTRY_RIPENCC    }, // 195.244.32.0    - 195.245.63.255 
	{ 0xc3f54000, 0xc3f557ff, REGISTRY_RIPENCC    }, // 195.245.64.0    - 195.245.87.255 
	{ 0xc3f55a00, 0xc3f55fff, REGISTRY_RIPENCC    }, // 195.245.90.0    - 195.245.95.255 
	{ 0xc3f56400, 0xc3f565ff, REGISTRY_RIPENCC    }, // 195.245.100.0   - 195.245.101.255
	{ 0xc3f56800, 0xc3f56dff, REGISTRY_RIPENCC    }, // 195.245.104.0   - 195.245.109.255
	{ 0xc3f57000, 0xc3f57fff, REGISTRY_RIPENCC    }, // 195.245.112.0   - 195.245.127.255
	{ 0xc3f58000, 0xc3f5bfff, REGISTRY_RIPENCC    }, // 195.245.128.0   - 195.245.191.255
	{ 0xc3f5c000, 0xc3f5c2ff, REGISTRY_RIPENCC    }, // 195.245.192.0   - 195.245.194.255
	{ 0xc3f5c400, 0xc3f5ceff, REGISTRY_RIPENCC    }, // 195.245.196.0   - 195.245.206.255
	{ 0xc3f5d000, 0xc3f5e4ff, REGISTRY_RIPENCC    }, // 195.245.208.0   - 195.245.228.255
	{ 0xc3f5e600, 0xc3f5edff, REGISTRY_RIPENCC    }, // 195.245.230.0   - 195.245.237.255
	{ 0xc3f5f000, 0xc3f5f0ff, REGISTRY_RIPENCC    }, // 195.245.240.0   - 195.245.240.255
	{ 0xc3f5f300, 0xc3f5ffff, REGISTRY_RIPENCC    }, // 195.245.243.0   - 195.245.255.255
	{ 0xc3f60000, 0xc3f61fff, REGISTRY_RIPENCC    }, // 195.246.0.0     - 195.246.31.255 
	{ 0xc3f62000, 0xc3f63fff, REGISTRY_AFRINIC    }, // 195.246.32.0    - 195.246.63.255 
	{ 0xc3f64000, 0xc3f65fff, REGISTRY_RIPENCC    }, // 195.246.64.0    - 195.246.95.255 
	{ 0xc3f66000, 0xc3f66dff, REGISTRY_RIPENCC    }, // 195.246.96.0    - 195.246.109.255
	{ 0xc3f67000, 0xc3f67fff, REGISTRY_RIPENCC    }, // 195.246.112.0   - 195.246.127.255
	{ 0xc3f68000, 0xc3f6bfff, REGISTRY_RIPENCC    }, // 195.246.128.0   - 195.246.191.255
	{ 0xc3f6c000, 0xc3f6c4ff, REGISTRY_RIPENCC    }, // 195.246.192.0   - 195.246.196.255
	{ 0xc3f6c600, 0xc3f6c7ff, REGISTRY_RIPENCC    }, // 195.246.198.0   - 195.246.199.255
	{ 0xc3f6cc00, 0xc3f6daff, REGISTRY_RIPENCC    }, // 195.246.204.0   - 195.246.218.255
	{ 0xc3f6dc00, 0xc3f6f5ff, REGISTRY_RIPENCC    }, // 195.246.220.0   - 195.246.245.255
	{ 0xc3f6fa00, 0xc3f6fdff, REGISTRY_RIPENCC    }, // 195.246.250.0   - 195.246.253.255
	{ 0xc3f70000, 0xc3f83fff, REGISTRY_RIPENCC    }, // 195.247.0.0     - 195.248.63.255 
	{ 0xc3f84000, 0xc3f85fff, REGISTRY_RIPENCC    }, // 195.248.64.0    - 195.248.95.255 
	{ 0xc3f86000, 0xc3f8dfff, REGISTRY_RIPENCC    }, // 195.248.96.0    - 195.248.223.255
	{ 0xc3f8e000, 0xc3f8efff, REGISTRY_RIPENCC    }, // 195.248.224.0   - 195.248.239.255
	{ 0xc3f8f400, 0xc3f8ffff, REGISTRY_RIPENCC    }, // 195.248.244.0   - 195.248.255.255
	{ 0xc3f90000, 0xc3fa1fff, REGISTRY_RIPENCC    }, // 195.249.0.0     - 195.250.31.255 
	{ 0xc3fa2000, 0xc3fa3eff, REGISTRY_RIPENCC    }, // 195.250.32.0    - 195.250.62.255 
	{ 0xc3fa4000, 0xc3fbffff, REGISTRY_RIPENCC    }, // 195.250.64.0    - 195.251.255.255
	{ 0xc3fc0000, 0xc3fc1fff, REGISTRY_RIPENCC    }, // 195.252.0.0     - 195.252.31.255 
	{ 0xc3fc2000, 0xc3fe7fff, REGISTRY_RIPENCC    }, // 195.252.32.0    - 195.254.127.255
	{ 0xc3fe8000, 0xc3fe8dff, REGISTRY_RIPENCC    }, // 195.254.128.0   - 195.254.141.255
	{ 0xc3fe9000, 0xc3fe99ff, REGISTRY_RIPENCC    }, // 195.254.144.0   - 195.254.153.255
	{ 0xc3fe9c00, 0xc3febfff, REGISTRY_RIPENCC    }, // 195.254.156.0   - 195.254.191.255
	{ 0xc3fec000, 0xc3ffffff, REGISTRY_RIPENCC    }, // 195.254.192.0   - 195.255.255.255
	{ 0xc4000000, 0xc40100ff, REGISTRY_AFRINIC    }, // 196.0.0.0       - 196.1.0.255    
	{ 0xc4010100, 0xc40101ff, REGISTRY_APNIC      }, // 196.1.1.0       - 196.1.1.255    
	{ 0xc4010200, 0xc40102ff, REGISTRY_ARIN       }, // 196.1.2.0       - 196.1.2.255    
	{ 0xc4010300, 0xc40103ff, REGISTRY_RIPENCC    }, // 196.1.3.0       - 196.1.3.255    
	{ 0xc4010400, 0xc40104ff, REGISTRY_AFRINIC    }, // 196.1.4.0       - 196.1.4.255    
	{ 0xc4010500, 0xc40106ff, REGISTRY_RIPENCC    }, // 196.1.5.0       - 196.1.6.255    
	{ 0xc4010700, 0xc4013fff, REGISTRY_AFRINIC    }, // 196.1.7.0       - 196.1.63.255   
	{ 0xc4014000, 0xc40143ff, REGISTRY_RIPENCC    }, // 196.1.64.0      - 196.1.67.255   
	{ 0xc4014400, 0xc40144ff, REGISTRY_APNIC      }, // 196.1.68.0      - 196.1.68.255   
	{ 0xc4014500, 0xc40146ff, REGISTRY_RIPENCC    }, // 196.1.69.0      - 196.1.70.255   
	{ 0xc4014700, 0xc40147ff, REGISTRY_AFRINIC    }, // 196.1.71.0      - 196.1.71.255   
	{ 0xc4014800, 0xc40149ff, REGISTRY_ARIN       }, // 196.1.72.0      - 196.1.73.255   
	{ 0xc4014a00, 0xc40167ff, REGISTRY_AFRINIC    }, // 196.1.74.0      - 196.1.103.255  
	{ 0xc4016800, 0xc4016aff, REGISTRY_APNIC      }, // 196.1.104.0     - 196.1.106.255  
	{ 0xc4016b00, 0xc4016bff, REGISTRY_ARIN       }, // 196.1.107.0     - 196.1.107.255  
	{ 0xc4016d00, 0xc4016fff, REGISTRY_APNIC      }, // 196.1.109.0     - 196.1.111.255  
	{ 0xc4017000, 0xc40170ff, REGISTRY_LACNIC     }, // 196.1.112.0     - 196.1.112.255  
	{ 0xc4017100, 0xc40172ff, REGISTRY_APNIC      }, // 196.1.113.0     - 196.1.114.255  
	{ 0xc4017300, 0xc40173ff, REGISTRY_AFRINIC    }, // 196.1.115.0     - 196.1.115.255  
	{ 0xc4017600, 0xc40185ff, REGISTRY_AFRINIC    }, // 196.1.118.0     - 196.1.133.255  
	{ 0xc4018600, 0xc40186ff, REGISTRY_APNIC      }, // 196.1.134.0     - 196.1.134.255  
	{ 0xc4018700, 0xc40187ff, REGISTRY_LACNIC     }, // 196.1.135.0     - 196.1.135.255  
	{ 0xc4018800, 0xc40188ff, REGISTRY_ARIN       }, // 196.1.136.0     - 196.1.136.255  
	{ 0xc4018900, 0xc40189ff, REGISTRY_AFRINIC    }, // 196.1.137.0     - 196.1.137.255  
	{ 0xc4018a00, 0xc4018eff, REGISTRY_ARIN       }, // 196.1.138.0     - 196.1.142.255  
	{ 0xc4018f00, 0xc4019fff, REGISTRY_AFRINIC    }, // 196.1.143.0     - 196.1.159.255  
	{ 0xc401a000, 0xc401afff, REGISTRY_ARIN       }, // 196.1.160.0     - 196.1.175.255  
	{ 0xc401c000, 0xc401ffff, REGISTRY_AFRINIC    }, // 196.1.192.0     - 196.1.255.255  
	{ 0xc4020000, 0xc40201ff, REGISTRY_ARIN       }, // 196.2.0.0       - 196.2.1.255    
	{ 0xc4020200, 0xc40203ff, REGISTRY_AFRINIC    }, // 196.2.2.0       - 196.2.3.255    
	{ 0xc4020400, 0xc40207ff, REGISTRY_RIPENCC    }, // 196.2.4.0       - 196.2.7.255    
	{ 0xc4020800, 0xc402ffff, REGISTRY_AFRINIC    }, // 196.2.8.0       - 196.2.255.255  
	{ 0xc4030000, 0xc4030dff, REGISTRY_ARIN       }, // 196.3.0.0       - 196.3.13.255   
	{ 0xc4030e00, 0xc4030fff, REGISTRY_AFRINIC    }, // 196.3.14.0      - 196.3.15.255   
	{ 0xc4031000, 0xc4031fff, REGISTRY_LACNIC     }, // 196.3.16.0      - 196.3.31.255   
	{ 0xc4032000, 0xc40338ff, REGISTRY_ARIN       }, // 196.3.32.0      - 196.3.56.255   
	{ 0xc4033900, 0xc40340ff, REGISTRY_AFRINIC    }, // 196.3.57.0      - 196.3.64.255   
	{ 0xc4034100, 0xc40341ff, REGISTRY_APNIC      }, // 196.3.65.0      - 196.3.65.255   
	{ 0xc4034200, 0xc40347ff, REGISTRY_RIPENCC    }, // 196.3.66.0      - 196.3.71.255   
	{ 0xc4034800, 0xc40348ff, REGISTRY_APNIC      }, // 196.3.72.0      - 196.3.72.255   
	{ 0xc4034900, 0xc40349ff, REGISTRY_ARIN       }, // 196.3.73.0      - 196.3.73.255   
	{ 0xc4034a00, 0xc40359ff, REGISTRY_LACNIC     }, // 196.3.74.0      - 196.3.89.255   
	{ 0xc4035a00, 0xc4035aff, REGISTRY_AFRINIC    }, // 196.3.90.0      - 196.3.90.255   
	{ 0xc4035b00, 0xc4035bff, REGISTRY_RIPENCC    }, // 196.3.91.0      - 196.3.91.255   
	{ 0xc4035c00, 0xc4035eff, REGISTRY_AFRINIC    }, // 196.3.92.0      - 196.3.94.255   
	{ 0xc4035f00, 0xc4035fff, REGISTRY_ARIN       }, // 196.3.95.0      - 196.3.95.255   
	{ 0xc4036000, 0xc40367ff, REGISTRY_AFRINIC    }, // 196.3.96.0      - 196.3.103.255  
	{ 0xc4036800, 0xc40368ff, REGISTRY_ARIN       }, // 196.3.104.0     - 196.3.104.255  
	{ 0xc4036900, 0xc40369ff, REGISTRY_AFRINIC    }, // 196.3.105.0     - 196.3.105.255  
	{ 0xc4036a00, 0xc4036aff, REGISTRY_LACNIC     }, // 196.3.106.0     - 196.3.106.255  
	{ 0xc4036b00, 0xc40383ff, REGISTRY_AFRINIC    }, // 196.3.107.0     - 196.3.131.255  
	{ 0xc4038400, 0xc40393ff, REGISTRY_LACNIC     }, // 196.3.132.0     - 196.3.147.255  
	{ 0xc4039400, 0xc40397ff, REGISTRY_AFRINIC    }, // 196.3.148.0     - 196.3.151.255  
	{ 0xc4039800, 0xc40398ff, REGISTRY_LACNIC     }, // 196.3.152.0     - 196.3.152.255  
	{ 0xc4039900, 0xc40399ff, REGISTRY_ARIN       }, // 196.3.153.0     - 196.3.153.255  
	{ 0xc4039a00, 0xc403b3ff, REGISTRY_AFRINIC    }, // 196.3.154.0     - 196.3.179.255  
	{ 0xc403b800, 0xc403dfff, REGISTRY_ARIN       }, // 196.3.184.0     - 196.3.223.255  
	{ 0xc403e000, 0xc4042dff, REGISTRY_AFRINIC    }, // 196.3.224.0     - 196.4.45.255   
	{ 0xc4042e00, 0xc40446ff, REGISTRY_ARIN       }, // 196.4.46.0      - 196.4.70.255   
	{ 0xc4044700, 0xc40667ff, REGISTRY_AFRINIC    }, // 196.4.71.0      - 196.6.103.255  
	{ 0xc4067800, 0xc406afff, REGISTRY_AFRINIC    }, // 196.6.120.0     - 196.6.175.255  
	{ 0xc406b800, 0xc406cfff, REGISTRY_AFRINIC    }, // 196.6.184.0     - 196.6.207.255  
	{ 0xc406d400, 0xc406d7ff, REGISTRY_AFRINIC    }, // 196.6.212.0     - 196.6.215.255  
	{ 0xc406dc00, 0xc406dfff, REGISTRY_AFRINIC    }, // 196.6.220.0     - 196.6.223.255  
	{ 0xc406ec00, 0xc409ffff, REGISTRY_AFRINIC    }, // 196.6.236.0     - 196.9.255.255  
	{ 0xc40a0100, 0xc40a32ff, REGISTRY_AFRINIC    }, // 196.10.1.0      - 196.10.50.255  
	{ 0xc40a3400, 0xc40ad5ff, REGISTRY_AFRINIC    }, // 196.10.52.0     - 196.10.213.255 
	{ 0xc40ad800, 0xc40b1fff, REGISTRY_AFRINIC    }, // 196.10.216.0    - 196.11.31.255  
	{ 0xc40b3000, 0xc40b3eff, REGISTRY_AFRINIC    }, // 196.11.48.0     - 196.11.62.255  
	{ 0xc40b4000, 0xc40b4fff, REGISTRY_AFRINIC    }, // 196.11.64.0     - 196.11.79.255  
	{ 0xc40b5800, 0xc40b66ff, REGISTRY_AFRINIC    }, // 196.11.88.0     - 196.11.102.255 
	{ 0xc40b6800, 0xc40b97ff, REGISTRY_AFRINIC    }, // 196.11.104.0    - 196.11.151.255 
	{ 0xc40ba000, 0xc40bafff, REGISTRY_AFRINIC    }, // 196.11.160.0    - 196.11.175.255 
	{ 0xc40bb800, 0xc40bcdff, REGISTRY_AFRINIC    }, // 196.11.184.0    - 196.11.205.255 
	{ 0xc40bd000, 0xc40be9ff, REGISTRY_AFRINIC    }, // 196.11.208.0    - 196.11.233.255 
	{ 0xc40beb00, 0xc40bffff, REGISTRY_AFRINIC    }, // 196.11.235.0    - 196.11.255.255 
	{ 0xc40c0000, 0xc40c09ff, REGISTRY_ARIN       }, // 196.12.0.0      - 196.12.9.255   
	{ 0xc40c0a00, 0xc40c1fff, REGISTRY_AFRINIC    }, // 196.12.10.0     - 196.12.31.255  
	{ 0xc40c2000, 0xc40c3fff, REGISTRY_APNIC      }, // 196.12.32.0     - 196.12.63.255  
	{ 0xc40c4000, 0xc40c7fff, REGISTRY_ARIN       }, // 196.12.64.0     - 196.12.127.255 
	{ 0xc40c8000, 0xc40c9fff, REGISTRY_AFRINIC    }, // 196.12.128.0    - 196.12.159.255 
	{ 0xc40ca000, 0xc40cbfff, REGISTRY_ARIN       }, // 196.12.160.0    - 196.12.191.255 
	{ 0xc40cc000, 0xc40cffff, REGISTRY_AFRINIC    }, // 196.12.192.0    - 196.12.255.255 
	{ 0xc40d0100, 0xc40d65ff, REGISTRY_AFRINIC    }, // 196.13.1.0      - 196.13.101.255 
	{ 0xc40d7000, 0xc40d79ff, REGISTRY_AFRINIC    }, // 196.13.112.0    - 196.13.121.255 
	{ 0xc40d7e00, 0xc40d87ff, REGISTRY_AFRINIC    }, // 196.13.126.0    - 196.13.135.255 
	{ 0xc40d8a00, 0xc40da0ff, REGISTRY_AFRINIC    }, // 196.13.138.0    - 196.13.160.255 
	{ 0xc40da200, 0xc40da8ff, REGISTRY_AFRINIC    }, // 196.13.162.0    - 196.13.168.255 
	{ 0xc40daa00, 0xc40dacff, REGISTRY_AFRINIC    }, // 196.13.170.0    - 196.13.172.255 
	{ 0xc40db800, 0xc40db9ff, REGISTRY_AFRINIC    }, // 196.13.184.0    - 196.13.185.255 
	{ 0xc40dbb00, 0xc40dbfff, REGISTRY_AFRINIC    }, // 196.13.187.0    - 196.13.191.255 
	{ 0xc40dc800, 0xc40dc8ff, REGISTRY_AFRINIC    }, // 196.13.200.0    - 196.13.200.255 
	{ 0xc40dcd00, 0xc40dcdff, REGISTRY_AFRINIC    }, // 196.13.205.0    - 196.13.205.255 
	{ 0xc40dd200, 0xc40df1ff, REGISTRY_AFRINIC    }, // 196.13.210.0    - 196.13.241.255 
	{ 0xc40df600, 0xc40dfbff, REGISTRY_AFRINIC    }, // 196.13.246.0    - 196.13.251.255 
	{ 0xc40e0000, 0xc40f0fff, REGISTRY_AFRINIC    }, // 196.14.0.0      - 196.15.15.255  
	{ 0xc40f1000, 0xc40f1fff, REGISTRY_APNIC      }, // 196.15.16.0     - 196.15.31.255  
	{ 0xc40f2000, 0xc40f3fff, REGISTRY_RIPENCC    }, // 196.15.32.0     - 196.15.63.255  
	{ 0xc40f4000, 0xc41607ff, REGISTRY_AFRINIC    }, // 196.15.64.0     - 196.22.7.255   
	{ 0xc4160c00, 0xc41affff, REGISTRY_AFRINIC    }, // 196.22.12.0     - 196.26.255.255 
	{ 0xc41b0000, 0xc41b3fff, REGISTRY_ARIN       }, // 196.27.0.0      - 196.27.63.255  
	{ 0xc41b4000, 0xc41c2fff, REGISTRY_AFRINIC    }, // 196.27.64.0     - 196.28.47.255  
	{ 0xc41c3000, 0xc41c3fff, REGISTRY_ARIN       }, // 196.28.48.0     - 196.28.63.255  
	{ 0xc41c4000, 0xc41d3fff, REGISTRY_AFRINIC    }, // 196.28.64.0     - 196.29.63.255  
	{ 0xc41d4000, 0xc41d5fff, REGISTRY_LACNIC     }, // 196.29.64.0     - 196.29.95.255  
	{ 0xc41d6000, 0xc41fffff, REGISTRY_AFRINIC    }, // 196.29.96.0     - 196.31.255.255 
	{ 0xc4200000, 0xc42007ff, REGISTRY_ARIN       }, // 196.32.0.0      - 196.32.7.255   
	{ 0xc4202000, 0xc4205fff, REGISTRY_LACNIC     }, // 196.32.32.0     - 196.32.95.255  
	{ 0xc4207000, 0xc4207fff, REGISTRY_AFRINIC    }, // 196.32.112.0    - 196.32.127.255 
	{ 0xc4208000, 0xc4209fff, REGISTRY_ARIN       }, // 196.32.128.0    - 196.32.159.255 
	{ 0xc420c000, 0xc420d7ff, REGISTRY_AFRINIC    }, // 196.32.192.0    - 196.32.215.255 
	{ 0xc420e000, 0xc420f7ff, REGISTRY_AFRINIC    }, // 196.32.224.0    - 196.32.247.255 
	{ 0xc4210000, 0xc427ffff, REGISTRY_AFRINIC    }, // 196.33.0.0      - 196.39.255.255 
	{ 0xc4280000, 0xc4285fff, REGISTRY_LACNIC     }, // 196.40.0.0      - 196.40.95.255  
	{ 0xc4286000, 0xc4286fff, REGISTRY_AFRINIC    }, // 196.40.96.0     - 196.40.111.255 
	{ 0xc4288000, 0xc428afff, REGISTRY_AFRINIC    }, // 196.40.128.0    - 196.40.175.255 
	{ 0xc428c000, 0xc4293fff, REGISTRY_AFRINIC    }, // 196.40.192.0    - 196.41.63.255  
	{ 0xc4296000, 0xc429ffff, REGISTRY_AFRINIC    }, // 196.41.96.0     - 196.41.255.255 
	{ 0xc42a0000, 0xc42a3fff, REGISTRY_ARIN       }, // 196.42.0.0      - 196.42.63.255  
	{ 0xc42a4000, 0xc42bf9ff, REGISTRY_AFRINIC    }, // 196.42.64.0     - 196.43.249.255 
	{ 0xc42bfb00, 0xc42bfbff, REGISTRY_AFRINIC    }, // 196.43.251.0    - 196.43.251.255 
	{ 0xc42c0000, 0xc42c2fff, REGISTRY_AFRINIC    }, // 196.44.0.0      - 196.44.47.255  
	{ 0xc42c4000, 0xc42cffff, REGISTRY_AFRINIC    }, // 196.44.64.0     - 196.44.255.255 
	{ 0xc42d1000, 0xc42fbfff, REGISTRY_AFRINIC    }, // 196.45.16.0     - 196.47.191.255 
	{ 0xc4300000, 0xc43106ff, REGISTRY_AFRINIC    }, // 196.48.0.0      - 196.49.6.255   
	{ 0xc4340000, 0xc437ffff, REGISTRY_AFRINIC    }, // 196.52.0.0      - 196.55.255.255 
	{ 0xc4380000, 0xc43bffff, REGISTRY_AFRINIC    }, // 196.56.0.0      - 196.59.255.255 
	{ 0xc43e0000, 0xc43fffff, REGISTRY_AFRINIC    }, // 196.62.0.0      - 196.63.255.255 
	{ 0xc4c00000, 0xc4c02fff, REGISTRY_AFRINIC    }, // 196.192.0.0     - 196.192.47.255 
	{ 0xc4c04000, 0xc4c047ff, REGISTRY_AFRINIC    }, // 196.192.64.0    - 196.192.71.255 
	{ 0xc4c05000, 0xc4c053ff, REGISTRY_AFRINIC    }, // 196.192.80.0    - 196.192.83.255 
	{ 0xc4c06000, 0xc4c073ff, REGISTRY_AFRINIC    }, // 196.192.96.0    - 196.192.115.255
	{ 0xc4c07c00, 0xc4c07dff, REGISTRY_AFRINIC    }, // 196.192.124.0   - 196.192.125.255
	{ 0xc4c08c00, 0xc4c08fff, REGISTRY_AFRINIC    }, // 196.192.140.0   - 196.192.143.255
	{ 0xc4c0c000, 0xc4c8bfff, REGISTRY_AFRINIC    }, // 196.192.192.0   - 196.200.191.255
	{ 0xc4c90100, 0xc4c903ff, REGISTRY_AFRINIC    }, // 196.201.1.0     - 196.201.3.255  
	{ 0xc4c90600, 0xc4c907ff, REGISTRY_AFRINIC    }, // 196.201.6.0     - 196.201.7.255  
	{ 0xc4c91000, 0xc4c95fff, REGISTRY_AFRINIC    }, // 196.201.16.0    - 196.201.95.255 
	{ 0xc4c98000, 0xc4c99fff, REGISTRY_AFRINIC    }, // 196.201.128.0   - 196.201.159.255
	{ 0xc4c9c000, 0xc4c9e7ff, REGISTRY_AFRINIC    }, // 196.201.192.0   - 196.201.231.255
	{ 0xc4c9f000, 0xc4c9f7ff, REGISTRY_AFRINIC    }, // 196.201.240.0   - 196.201.247.255
	{ 0xc4ca0000, 0xc4ca9fff, REGISTRY_AFRINIC    }, // 196.202.0.0     - 196.202.159.255
	{ 0xc4cac000, 0xc4cadfff, REGISTRY_AFRINIC    }, // 196.202.192.0   - 196.202.223.255
	{ 0xc4cae800, 0xc4cf3fff, REGISTRY_AFRINIC    }, // 196.202.232.0   - 196.207.63.255 
	{ 0xc4cfc000, 0xc4d800ff, REGISTRY_AFRINIC    }, // 196.207.192.0   - 196.216.0.255  
	{ 0xc4d80100, 0xc4d801ff, REGISTRY_ARIN       }, // 196.216.1.0     - 196.216.1.255  
	{ 0xc4d80200, 0xc4d817ff, REGISTRY_AFRINIC    }, // 196.216.2.0     - 196.216.23.255 
	{ 0xc4d82000, 0xc4d85fff, REGISTRY_AFRINIC    }, // 196.216.32.0    - 196.216.95.255 
	{ 0xc4d88000, 0xc4d883ff, REGISTRY_AFRINIC    }, // 196.216.128.0   - 196.216.131.255
	{ 0xc4d88c00, 0xc4d8cbff, REGISTRY_AFRINIC    }, // 196.216.140.0   - 196.216.203.255
	{ 0xc4d8d000, 0xc4d8d7ff, REGISTRY_AFRINIC    }, // 196.216.208.0   - 196.216.215.255
	{ 0xc4d8e400, 0xc4d8f3ff, REGISTRY_AFRINIC    }, // 196.216.228.0   - 196.216.243.255
	{ 0xc4d8f500, 0xc4dc7fff, REGISTRY_AFRINIC    }, // 196.216.245.0   - 196.220.127.255
	{ 0xc4dcc000, 0xc4df1cff, REGISTRY_AFRINIC    }, // 196.220.192.0   - 196.223.28.255 
	{ 0xc4df1e00, 0xc4df25ff, REGISTRY_AFRINIC    }, // 196.223.30.0    - 196.223.37.255 
	{ 0xc4f00000, 0xc4f93fff, REGISTRY_AFRINIC    }, // 196.240.0.0     - 196.249.63.255 
	{ 0xc4fc0000, 0xc59bcfff, REGISTRY_AFRINIC    }, // 196.252.0.0     - 197.155.207.255
	{ 0xc59be000, 0xc59f4fff, REGISTRY_AFRINIC    }, // 197.155.224.0   - 197.159.79.255 
	{ 0xc59f6000, 0xc5eafbff, REGISTRY_AFRINIC    }, // 197.159.96.0    - 197.234.251.255
	{ 0xc5eb0000, 0xc5edffff, REGISTRY_AFRINIC    }, // 197.235.0.0     - 197.237.255.255
	{ 0xc5ef0000, 0xc5ffffff, REGISTRY_AFRINIC    }, // 197.239.0.0     - 197.255.255.255
	{ 0xc6000000, 0xc6020fff, REGISTRY_ARIN       }, // 198.0.0.0       - 198.2.15.255   
	{ 0xc6021000, 0xc6021fff, REGISTRY_LACNIC     }, // 198.2.16.0      - 198.2.31.255   
	{ 0xc6022000, 0xc60affff, REGISTRY_ARIN       }, // 198.2.32.0      - 198.10.255.255 
	{ 0xc60b0000, 0xc60b03ff, REGISTRY_RIPENCC    }, // 198.11.0.0      - 198.11.3.255   
	{ 0xc60b0400, 0xc60c1fff, REGISTRY_ARIN       }, // 198.11.4.0      - 198.12.31.255  
	{ 0xc60c2000, 0xc60c3fff, REGISTRY_LACNIC     }, // 198.12.32.0     - 198.12.63.255  
	{ 0xc60c4000, 0xc60f0fff, REGISTRY_ARIN       }, // 198.12.64.0     - 198.15.15.255  
	{ 0xc60f2000, 0xc60f3fff, REGISTRY_APNIC      }, // 198.15.32.0     - 198.15.63.255  
	{ 0xc60f4000, 0xc61100ff, REGISTRY_ARIN       }, // 198.15.64.0     - 198.17.0.255   
	{ 0xc6110200, 0xc61106ff, REGISTRY_ARIN       }, // 198.17.2.0      - 198.17.6.255   
	{ 0xc6110800, 0xc61145ff, REGISTRY_ARIN       }, // 198.17.8.0      - 198.17.69.255  
	{ 0xc6114600, 0xc61146ff, REGISTRY_APNIC      }, // 198.17.70.0     - 198.17.70.255  
	{ 0xc6114700, 0xc6114cff, REGISTRY_ARIN       }, // 198.17.71.0     - 198.17.76.255  
	{ 0xc6114d00, 0xc6114dff, REGISTRY_RIPENCC    }, // 198.17.77.0     - 198.17.77.255  
	{ 0xc6114e00, 0xc6114eff, REGISTRY_ARIN       }, // 198.17.78.0     - 198.17.78.255  
	{ 0xc6115000, 0xc61169ff, REGISTRY_ARIN       }, // 198.17.80.0     - 198.17.105.255 
	{ 0xc6116b00, 0xc61170ff, REGISTRY_ARIN       }, // 198.17.107.0    - 198.17.112.255 
	{ 0xc6117400, 0xc61174ff, REGISTRY_ARIN       }, // 198.17.116.0    - 198.17.116.255 
	{ 0xc6117500, 0xc61175ff, REGISTRY_RIPENCC    }, // 198.17.117.0    - 198.17.117.255 
	{ 0xc6117600, 0xc61176ff, REGISTRY_APNIC      }, // 198.17.118.0    - 198.17.118.255 
	{ 0xc6117700, 0xc61177ff, REGISTRY_ARIN       }, // 198.17.119.0    - 198.17.119.255 
	{ 0xc6117a00, 0xc611b3ff, REGISTRY_ARIN       }, // 198.17.122.0    - 198.17.179.255 
	{ 0xc611b400, 0xc611b6ff, REGISTRY_RIPENCC    }, // 198.17.180.0    - 198.17.182.255 
	{ 0xc611b700, 0xc611e3ff, REGISTRY_ARIN       }, // 198.17.183.0    - 198.17.227.255 
	{ 0xc611e500, 0xc611e6ff, REGISTRY_ARIN       }, // 198.17.229.0    - 198.17.230.255 
	{ 0xc611e900, 0xc611efff, REGISTRY_ARIN       }, // 198.17.233.0    - 198.17.239.255 
	{ 0xc611f200, 0xc611ffff, REGISTRY_ARIN       }, // 198.17.242.0    - 198.17.255.255 
	{ 0xc6140000, 0xc61621ff, REGISTRY_ARIN       }, // 198.20.0.0      - 198.22.33.255  
	{ 0xc6162400, 0xc61624ff, REGISTRY_ARIN       }, // 198.22.36.0     - 198.22.36.255  
	{ 0xc6162600, 0xc6162eff, REGISTRY_ARIN       }, // 198.22.38.0     - 198.22.46.255  
	{ 0xc6162f00, 0xc6162fff, REGISTRY_APNIC      }, // 198.22.47.0     - 198.22.47.255  
	{ 0xc6163300, 0xc61633ff, REGISTRY_RIPENCC    }, // 198.22.51.0     - 198.22.51.255  
	{ 0xc6163400, 0xc6163cff, REGISTRY_ARIN       }, // 198.22.52.0     - 198.22.60.255  
	{ 0xc6163d00, 0xc6163dff, REGISTRY_APNIC      }, // 198.22.61.0     - 198.22.61.255  
	{ 0xc6163e00, 0xc6165cff, REGISTRY_ARIN       }, // 198.22.62.0     - 198.22.92.255  
	{ 0xc6165d00, 0xc61661ff, REGISTRY_RIPENCC    }, // 198.22.93.0     - 198.22.97.255  
	{ 0xc6166200, 0xc616f9ff, REGISTRY_ARIN       }, // 198.22.98.0     - 198.22.249.255 
	{ 0xc616fa00, 0xc616fbff, REGISTRY_LACNIC     }, // 198.22.250.0    - 198.22.251.255 
	{ 0xc616fc00, 0xc61b03ff, REGISTRY_ARIN       }, // 198.22.252.0    - 198.27.3.255   
	{ 0xc61b0400, 0xc61b08ff, REGISTRY_APNIC      }, // 198.27.4.0      - 198.27.8.255   
	{ 0xc61b0900, 0xc6241fff, REGISTRY_ARIN       }, // 198.27.9.0      - 198.36.31.255  
	{ 0xc6242000, 0xc6242eff, REGISTRY_RIPENCC    }, // 198.36.32.0     - 198.36.46.255  
	{ 0xc6242f00, 0xc6290fff, REGISTRY_ARIN       }, // 198.36.47.0     - 198.41.15.255  
	{ 0xc6291c00, 0xc6291fff, REGISTRY_ARIN       }, // 198.41.28.0     - 198.41.31.255  
	{ 0xc6292000, 0xc6292eff, REGISTRY_LACNIC     }, // 198.41.32.0     - 198.41.46.255  
	{ 0xc6292f00, 0xc62fffff, REGISTRY_ARIN       }, // 198.41.47.0     - 198.47.255.255 
	{ 0xc6300000, 0xc63003ff, REGISTRY_APNIC      }, // 198.48.0.0      - 198.48.3.255   
	{ 0xc6300400, 0xc63101ff, REGISTRY_ARIN       }, // 198.48.4.0      - 198.49.1.255   
	{ 0xc6310400, 0xc6311fff, REGISTRY_ARIN       }, // 198.49.4.0      - 198.49.31.255  
	{ 0xc6312800, 0xc63156ff, REGISTRY_ARIN       }, // 198.49.40.0     - 198.49.86.255  
	{ 0xc6315800, 0xc6316fff, REGISTRY_ARIN       }, // 198.49.88.0     - 198.49.111.255 
	{ 0xc6317000, 0xc63171ff, REGISTRY_APNIC      }, // 198.49.112.0    - 198.49.113.255 
	{ 0xc6317200, 0xc6317bff, REGISTRY_ARIN       }, // 198.49.114.0    - 198.49.123.255 
	{ 0xc6317c00, 0xc6317cff, REGISTRY_APNIC      }, // 198.49.124.0    - 198.49.124.255 
	{ 0xc6317d00, 0xc6317fff, REGISTRY_ARIN       }, // 198.49.125.0    - 198.49.127.255 
	{ 0xc6318000, 0xc63183ff, REGISTRY_LACNIC     }, // 198.49.128.0    - 198.49.131.255 
	{ 0xc6318600, 0xc631a3ff, REGISTRY_ARIN       }, // 198.49.134.0    - 198.49.163.255 
	{ 0xc631a400, 0xc631a4ff, REGISTRY_LACNIC     }, // 198.49.164.0    - 198.49.164.255 
	{ 0xc631a500, 0xc6320fff, REGISTRY_ARIN       }, // 198.49.165.0    - 198.50.15.255  
	{ 0xc6321000, 0xc63217ff, REGISTRY_LACNIC     }, // 198.50.16.0     - 198.50.23.255  
	{ 0xc6321800, 0xc63303ff, REGISTRY_ARIN       }, // 198.50.24.0     - 198.51.3.255   
	{ 0xc6330800, 0xc6330bff, REGISTRY_ARIN       }, // 198.51.8.0      - 198.51.11.255  
	{ 0xc6330c00, 0xc6330cff, REGISTRY_RIPENCC    }, // 198.51.12.0     - 198.51.12.255  
	{ 0xc6330d00, 0xc63346ff, REGISTRY_ARIN       }, // 198.51.13.0     - 198.51.70.255  
	{ 0xc6334700, 0xc63347ff, REGISTRY_LACNIC     }, // 198.51.71.0     - 198.51.71.255  
	{ 0xc6334800, 0xc63362ff, REGISTRY_ARIN       }, // 198.51.72.0     - 198.51.98.255  
	{ 0xc6336600, 0xc6338eff, REGISTRY_ARIN       }, // 198.51.102.0    - 198.51.142.255 
	{ 0xc6338f00, 0xc63392ff, REGISTRY_RIPENCC    }, // 198.51.143.0    - 198.51.146.255 
	{ 0xc6339300, 0xc633b9ff, REGISTRY_ARIN       }, // 198.51.147.0    - 198.51.185.255 
	{ 0xc633bb00, 0xc633c2ff, REGISTRY_ARIN       }, // 198.51.187.0    - 198.51.194.255 
	{ 0xc633c300, 0xc633c3ff, REGISTRY_APNIC      }, // 198.51.195.0    - 198.51.195.255 
	{ 0xc633c500, 0xc633d1ff, REGISTRY_ARIN       }, // 198.51.197.0    - 198.51.209.255 
	{ 0xc633d200, 0xc633d2ff, REGISTRY_APNIC      }, // 198.51.210.0    - 198.51.210.255 
	{ 0xc633d400, 0xc63600ff, REGISTRY_ARIN       }, // 198.51.212.0    - 198.54.0.255   
	{ 0xc6360100, 0xc6360aff, REGISTRY_AFRINIC    }, // 198.54.1.0      - 198.54.10.255  
	{ 0xc6360b00, 0xc6360eff, REGISTRY_ARIN       }, // 198.54.11.0     - 198.54.14.255  
	{ 0xc6360f00, 0xc6363dff, REGISTRY_AFRINIC    }, // 198.54.15.0     - 198.54.61.255  
	{ 0xc6363e00, 0xc6363fff, REGISTRY_ARIN       }, // 198.54.62.0     - 198.54.63.255  
	{ 0xc6364000, 0xc63650ff, REGISTRY_AFRINIC    }, // 198.54.64.0     - 198.54.80.255  
	{ 0xc6365100, 0xc63652ff, REGISTRY_ARIN       }, // 198.54.81.0     - 198.54.82.255  
	{ 0xc6365300, 0xc63657ff, REGISTRY_AFRINIC    }, // 198.54.83.0     - 198.54.87.255  
	{ 0xc6365800, 0xc6365aff, REGISTRY_ARIN       }, // 198.54.88.0     - 198.54.90.255  
	{ 0xc6365b00, 0xc6365bff, REGISTRY_AFRINIC    }, // 198.54.91.0     - 198.54.91.255  
	{ 0xc6365c00, 0xc63661ff, REGISTRY_ARIN       }, // 198.54.92.0     - 198.54.97.255  
	{ 0xc6366200, 0xc63663ff, REGISTRY_AFRINIC    }, // 198.54.98.0     - 198.54.99.255  
	{ 0xc6366400, 0xc6368cff, REGISTRY_ARIN       }, // 198.54.100.0    - 198.54.140.255 
	{ 0xc6368d00, 0xc63697ff, REGISTRY_AFRINIC    }, // 198.54.141.0    - 198.54.151.255 
	{ 0xc6369800, 0xc63699ff, REGISTRY_ARIN       }, // 198.54.152.0    - 198.54.153.255 
	{ 0xc6369a00, 0xc636a3ff, REGISTRY_AFRINIC    }, // 198.54.154.0    - 198.54.163.255 
	{ 0xc636a400, 0xc636a4ff, REGISTRY_ARIN       }, // 198.54.164.0    - 198.54.164.255 
	{ 0xc636a500, 0xc636a5ff, REGISTRY_AFRINIC    }, // 198.54.165.0    - 198.54.165.255 
	{ 0xc636a600, 0xc636a9ff, REGISTRY_ARIN       }, // 198.54.166.0    - 198.54.169.255 
	{ 0xc636aa00, 0xc636aaff, REGISTRY_AFRINIC    }, // 198.54.170.0    - 198.54.170.255 
	{ 0xc636ab00, 0xc636acff, REGISTRY_ARIN       }, // 198.54.171.0    - 198.54.172.255 
	{ 0xc636ad00, 0xc636b5ff, REGISTRY_AFRINIC    }, // 198.54.173.0    - 198.54.181.255 
	{ 0xc636b600, 0xc636b6ff, REGISTRY_ARIN       }, // 198.54.182.0    - 198.54.182.255 
	{ 0xc636b700, 0xc636c7ff, REGISTRY_AFRINIC    }, // 198.54.183.0    - 198.54.199.255 
	{ 0xc636c800, 0xc636c9ff, REGISTRY_ARIN       }, // 198.54.200.0    - 198.54.201.255 
	{ 0xc636ca00, 0xc636d2ff, REGISTRY_AFRINIC    }, // 198.54.202.0    - 198.54.210.255 
	{ 0xc636d300, 0xc636daff, REGISTRY_ARIN       }, // 198.54.211.0    - 198.54.218.255 
	{ 0xc636db00, 0xc636dcff, REGISTRY_AFRINIC    }, // 198.54.219.0    - 198.54.220.255 
	{ 0xc636dd00, 0xc636deff, REGISTRY_ARIN       }, // 198.54.221.0    - 198.54.222.255 
	{ 0xc636df00, 0xc636dfff, REGISTRY_AFRINIC    }, // 198.54.223.0    - 198.54.223.255 
	{ 0xc636e000, 0xc636e0ff, REGISTRY_ARIN       }, // 198.54.224.0    - 198.54.224.255 
	{ 0xc636e100, 0xc636e5ff, REGISTRY_AFRINIC    }, // 198.54.225.0    - 198.54.229.255 
	{ 0xc636e600, 0xc636e6ff, REGISTRY_ARIN       }, // 198.54.230.0    - 198.54.230.255 
	{ 0xc636e700, 0xc636e8ff, REGISTRY_AFRINIC    }, // 198.54.231.0    - 198.54.232.255 
	{ 0xc636e900, 0xc636e9ff, REGISTRY_ARIN       }, // 198.54.233.0    - 198.54.233.255 
	{ 0xc636ea00, 0xc636eaff, REGISTRY_AFRINIC    }, // 198.54.234.0    - 198.54.234.255 
	{ 0xc636eb00, 0xc636f6ff, REGISTRY_ARIN       }, // 198.54.235.0    - 198.54.246.255 
	{ 0xc636f700, 0xc636feff, REGISTRY_AFRINIC    }, // 198.54.247.0    - 198.54.254.255 
	{ 0xc636ff00, 0xc6380fff, REGISTRY_ARIN       }, // 198.54.255.0    - 198.56.15.255  
	{ 0xc6381a00, 0xc63a07ff, REGISTRY_ARIN       }, // 198.56.26.0     - 198.58.7.255   
	{ 0xc63a0800, 0xc63a0bff, REGISTRY_LACNIC     }, // 198.58.8.0      - 198.58.11.255  
	{ 0xc63a0d00, 0xc63d00ff, REGISTRY_ARIN       }, // 198.58.13.0     - 198.61.0.255   
	{ 0xc63d0400, 0xc63d07ff, REGISTRY_ARIN       }, // 198.61.4.0      - 198.61.7.255   
	{ 0xc63d1000, 0xc649dbff, REGISTRY_ARIN       }, // 198.61.16.0     - 198.73.219.255 
	{ 0xc649dc00, 0xc649dcff, REGISTRY_APNIC      }, // 198.73.220.0    - 198.73.220.255 
	{ 0xc649dd00, 0xc66125ff, REGISTRY_ARIN       }, // 198.73.221.0    - 198.97.37.255  
	{ 0xc6612700, 0xc66393ff, REGISTRY_ARIN       }, // 198.97.39.0     - 198.99.147.255 
	{ 0xc6639400, 0xc66394ff, REGISTRY_RIPENCC    }, // 198.99.148.0    - 198.99.148.255 
	{ 0xc6639500, 0xc663acff, REGISTRY_ARIN       }, // 198.99.149.0    - 198.99.172.255 
	{ 0xc663ad00, 0xc663adff, REGISTRY_APNIC      }, // 198.99.173.0    - 198.99.173.255 
	{ 0xc663ae00, 0xc663ddff, REGISTRY_ARIN       }, // 198.99.174.0    - 198.99.221.255 
	{ 0xc663de00, 0xc663deff, REGISTRY_RIPENCC    }, // 198.99.222.0    - 198.99.222.255 
	{ 0xc663df00, 0xc6854fff, REGISTRY_ARIN       }, // 198.99.223.0    - 198.133.79.255 
	{ 0xc6855000, 0xc68555ff, REGISTRY_RIPENCC    }, // 198.133.80.0    - 198.133.85.255 
	{ 0xc6855600, 0xc6858bff, REGISTRY_ARIN       }, // 198.133.86.0    - 198.133.139.255
	{ 0xc6858c00, 0xc6858cff, REGISTRY_RIPENCC    }, // 198.133.140.0   - 198.133.140.255
	{ 0xc6858d00, 0xc685e1ff, REGISTRY_ARIN       }, // 198.133.141.0   - 198.133.225.255
	{ 0xc685e200, 0xc685e2ff, REGISTRY_RIPENCC    }, // 198.133.226.0   - 198.133.226.255
	{ 0xc685e300, 0xc68788ff, REGISTRY_ARIN       }, // 198.133.227.0   - 198.135.136.255
	{ 0xc6878900, 0xc6878aff, REGISTRY_RIPENCC    }, // 198.135.137.0   - 198.135.138.255
	{ 0xc6878b00, 0xc687a6ff, REGISTRY_ARIN       }, // 198.135.139.0   - 198.135.166.255
	{ 0xc687a700, 0xc687a7ff, REGISTRY_RIPENCC    }, // 198.135.167.0   - 198.135.167.255
	{ 0xc687a800, 0xc68dffff, REGISTRY_ARIN       }, // 198.135.168.0   - 198.141.255.255
	{ 0xc68e0000, 0xc68effff, REGISTRY_APNIC      }, // 198.142.0.0     - 198.142.255.255
	{ 0xc68f0000, 0xc6939fff, REGISTRY_ARIN       }, // 198.143.0.0     - 198.147.159.255
	{ 0xc693a000, 0xc693a0ff, REGISTRY_RIPENCC    }, // 198.147.160.0   - 198.147.160.255
	{ 0xc693a100, 0xc694b0ff, REGISTRY_ARIN       }, // 198.147.161.0   - 198.148.176.255
	{ 0xc694b100, 0xc694b2ff, REGISTRY_RIPENCC    }, // 198.148.177.0   - 198.148.178.255
	{ 0xc694b300, 0xc69783ff, REGISTRY_ARIN       }, // 198.148.179.0   - 198.151.131.255
	{ 0xc6978400, 0xc69784ff, REGISTRY_LACNIC     }, // 198.151.132.0   - 198.151.132.255
	{ 0xc6978500, 0xc6b3e0ff, REGISTRY_ARIN       }, // 198.151.133.0   - 198.179.224.255
	{ 0xc6b3e100, 0xc6b3e1ff, REGISTRY_APNIC      }, // 198.179.225.0   - 198.179.225.255
	{ 0xc6b3e200, 0xc6b48dff, REGISTRY_ARIN       }, // 198.179.226.0   - 198.180.141.255
	{ 0xc6b48e00, 0xc6b48eff, REGISTRY_APNIC      }, // 198.180.142.0   - 198.180.142.255
	{ 0xc6b48f00, 0xc6b8a0ff, REGISTRY_ARIN       }, // 198.180.143.0   - 198.184.160.255
	{ 0xc6b8a100, 0xc6b8a1ff, REGISTRY_LACNIC     }, // 198.184.161.0   - 198.184.161.255
	{ 0xc6b8a200, 0xc6c7ffff, REGISTRY_ARIN       }, // 198.184.162.0   - 198.199.255.255
	{ 0xc6c80000, 0xc6c809ff, REGISTRY_APNIC      }, // 198.200.0.0     - 198.200.9.255  
	{ 0xc6c80a00, 0xc6cec4ff, REGISTRY_ARIN       }, // 198.200.10.0    - 198.206.196.255
	{ 0xc6cec500, 0xc6cec5ff, REGISTRY_RIPENCC    }, // 198.206.197.0   - 198.206.197.255
	{ 0xc6cec600, 0xc6cec7ff, REGISTRY_ARIN       }, // 198.206.198.0   - 198.206.199.255
	{ 0xc6cec800, 0xc6cecaff, REGISTRY_RIPENCC    }, // 198.206.200.0   - 198.206.202.255
	{ 0xc6cecb00, 0xc6f07fff, REGISTRY_ARIN       }, // 198.206.203.0   - 198.240.127.255
	{ 0xc6f08000, 0xc6f0ffff, REGISTRY_RIPENCC    }, // 198.240.128.0   - 198.240.255.255
	{ 0xc6f10000, 0xc715abff, REGISTRY_ARIN       }, // 198.241.0.0     - 199.21.171.255 
	{ 0xc715b000, 0xc71ae9ff, REGISTRY_ARIN       }, // 199.21.176.0    - 199.26.233.255 
	{ 0xc71aea00, 0xc71aeaff, REGISTRY_LACNIC     }, // 199.26.234.0    - 199.26.234.255 
	{ 0xc71aeb00, 0xc72b11ff, REGISTRY_ARIN       }, // 199.26.235.0    - 199.43.17.255  
	{ 0xc72b1200, 0xc72b13ff, REGISTRY_APNIC      }, // 199.43.18.0     - 199.43.19.255  
	{ 0xc72b1400, 0xc72b2cff, REGISTRY_ARIN       }, // 199.43.20.0     - 199.43.44.255  
	{ 0xc72b2d00, 0xc72b2dff, REGISTRY_APNIC      }, // 199.43.45.0     - 199.43.45.255  
	{ 0xc72b2e00, 0xc72b3eff, REGISTRY_ARIN       }, // 199.43.46.0     - 199.43.62.255  
	{ 0xc72b3f00, 0xc72b3fff, REGISTRY_APNIC      }, // 199.43.63.0     - 199.43.63.255  
	{ 0xc72b4000, 0xc72bf5ff, REGISTRY_ARIN       }, // 199.43.64.0     - 199.43.245.255 
	{ 0xc72bf600, 0xc72bf7ff, REGISTRY_RIPENCC    }, // 199.43.246.0    - 199.43.247.255 
	{ 0xc72bf800, 0xc734ffff, REGISTRY_ARIN       }, // 199.43.248.0    - 199.52.255.255 
	{ 0xc7350000, 0xc735ffff, REGISTRY_RIPENCC    }, // 199.53.0.0      - 199.53.255.255 
	{ 0xc7360000, 0xc75b0fff, REGISTRY_ARIN       }, // 199.54.0.0      - 199.91.15.255  
	{ 0xc75b1000, 0xc75b1fff, REGISTRY_RIPENCC    }, // 199.91.16.0     - 199.91.31.255  
	{ 0xc75b2000, 0xc76765ff, REGISTRY_ARIN       }, // 199.91.32.0     - 199.103.101.255
	{ 0xc7676600, 0xc76766ff, REGISTRY_LACNIC     }, // 199.103.102.0   - 199.103.102.255
	{ 0xc7676700, 0xc7a621ff, REGISTRY_ARIN       }, // 199.103.103.0   - 199.166.33.255 
	{ 0xc7a62200, 0xc7a625ff, REGISTRY_APNIC      }, // 199.166.34.0    - 199.166.37.255 
	{ 0xc7a62600, 0xc7d438ff, REGISTRY_ARIN       }, // 199.166.38.0    - 199.212.56.255 
	{ 0xc7d43a00, 0xc7f88fff, REGISTRY_ARIN       }, // 199.212.58.0    - 199.248.143.255
	{ 0xc7f89000, 0xc7f890ff, REGISTRY_LACNIC     }, // 199.248.144.0   - 199.248.144.255
	{ 0xc7f89100, 0xc7ffffff, REGISTRY_ARIN       }, // 199.248.145.0   - 199.255.255.255
	{ 0xc8000000, 0xc8003fff, REGISTRY_LACNIC     }, // 200.0.0.0       - 200.0.63.255   
	{ 0xc8004100, 0xc80050ff, REGISTRY_LACNIC     }, // 200.0.65.0      - 200.0.80.255   
	{ 0xc8005200, 0xc80054ff, REGISTRY_LACNIC     }, // 200.0.82.0      - 200.0.84.255   
	{ 0xc8005800, 0xc80058ff, REGISTRY_LACNIC     }, // 200.0.88.0      - 200.0.88.255   
	{ 0xc8005a00, 0xc8005dff, REGISTRY_LACNIC     }, // 200.0.90.0      - 200.0.93.255   
	{ 0xc8005e00, 0xc8005eff, REGISTRY_ARIN       }, // 200.0.94.0      - 200.0.94.255   
	{ 0xc8005f00, 0xc80063ff, REGISTRY_LACNIC     }, // 200.0.95.0      - 200.0.99.255   
	{ 0xc8006700, 0xc80071ff, REGISTRY_LACNIC     }, // 200.0.103.0     - 200.0.113.255  
	{ 0xc8007300, 0xc80085ff, REGISTRY_LACNIC     }, // 200.0.115.0     - 200.0.133.255  
	{ 0xc8008800, 0xc80088ff, REGISTRY_LACNIC     }, // 200.0.136.0     - 200.0.136.255  
	{ 0xc8008900, 0xc8008aff, REGISTRY_ARIN       }, // 200.0.137.0     - 200.0.138.255  
	{ 0xc8008b00, 0xc800c9ff, REGISTRY_LACNIC     }, // 200.0.139.0     - 200.0.201.255  
	{ 0xc800cc00, 0xc800d7ff, REGISTRY_LACNIC     }, // 200.0.204.0     - 200.0.215.255  
	{ 0xc800d800, 0xc800dfff, REGISTRY_ARIN       }, // 200.0.216.0     - 200.0.223.255  
	{ 0xc800e000, 0xc8016fff, REGISTRY_LACNIC     }, // 200.0.224.0     - 200.1.111.255  
	{ 0xc8017100, 0xc80171ff, REGISTRY_LACNIC     }, // 200.1.113.0     - 200.1.113.255  
	{ 0xc8017300, 0xc8019fff, REGISTRY_LACNIC     }, // 200.1.115.0     - 200.1.159.255  
	{ 0xc801a000, 0xc801a0ff, REGISTRY_ARIN       }, // 200.1.160.0     - 200.1.160.255  
	{ 0xc801a100, 0xc80309ff, REGISTRY_LACNIC     }, // 200.1.161.0     - 200.3.9.255    
	{ 0xc8030c00, 0xc803c3ff, REGISTRY_LACNIC     }, // 200.3.12.0      - 200.3.195.255  
	{ 0xc803c800, 0xc804ffff, REGISTRY_LACNIC     }, // 200.3.200.0     - 200.4.255.255  
	{ 0xc8050000, 0xc80508ff, REGISTRY_ARIN       }, // 200.5.0.0       - 200.5.8.255    
	{ 0xc8050a00, 0xc8050aff, REGISTRY_LACNIC     }, // 200.5.10.0      - 200.5.10.255   
	{ 0xc8050b00, 0xc8050bff, REGISTRY_ARIN       }, // 200.5.11.0      - 200.5.11.255   
	{ 0xc8050c00, 0xc80622ff, REGISTRY_LACNIC     }, // 200.5.12.0      - 200.6.34.255   
	{ 0xc8062400, 0xc8062fff, REGISTRY_LACNIC     }, // 200.6.36.0      - 200.6.47.255   
	{ 0xc8063400, 0xc80657ff, REGISTRY_LACNIC     }, // 200.6.52.0      - 200.6.87.255   
	{ 0xc8066000, 0xc80683ff, REGISTRY_LACNIC     }, // 200.6.96.0      - 200.6.131.255  
	{ 0xc8068600, 0xc8070bff, REGISTRY_LACNIC     }, // 200.6.134.0     - 200.7.11.255   
	{ 0xc8070e00, 0xc808ffff, REGISTRY_LACNIC     }, // 200.7.14.0      - 200.8.255.255  
	{ 0xc8090300, 0xc80940ff, REGISTRY_LACNIC     }, // 200.9.3.0       - 200.9.64.255   
	{ 0xc8094200, 0xc80942ff, REGISTRY_LACNIC     }, // 200.9.66.0      - 200.9.66.255   
	{ 0xc8094400, 0xc8094bff, REGISTRY_LACNIC     }, // 200.9.68.0      - 200.9.75.255   
	{ 0xc8094f00, 0xc80951ff, REGISTRY_LACNIC     }, // 200.9.79.0      - 200.9.81.255   
	{ 0xc8095200, 0xc80953ff, REGISTRY_ARIN       }, // 200.9.82.0      - 200.9.83.255   
	{ 0xc8095400, 0xc80954ff, REGISTRY_LACNIC     }, // 200.9.84.0      - 200.9.84.255   
	{ 0xc8095800, 0xc8095bff, REGISTRY_LACNIC     }, // 200.9.88.0      - 200.9.91.255   
	{ 0xc8095f00, 0xc80965ff, REGISTRY_LACNIC     }, // 200.9.95.0      - 200.9.101.255  
	{ 0xc8096800, 0xc8096fff, REGISTRY_LACNIC     }, // 200.9.104.0     - 200.9.111.255  
	{ 0xc8097300, 0xc80973ff, REGISTRY_ARIN       }, // 200.9.115.0     - 200.9.115.255  
	{ 0xc8097400, 0xc80977ff, REGISTRY_LACNIC     }, // 200.9.116.0     - 200.9.119.255  
	{ 0xc8097a00, 0xc8097aff, REGISTRY_LACNIC     }, // 200.9.122.0     - 200.9.122.255  
	{ 0xc8097c00, 0xc80980ff, REGISTRY_LACNIC     }, // 200.9.124.0     - 200.9.128.255  
	{ 0xc8098400, 0xc8098bff, REGISTRY_LACNIC     }, // 200.9.132.0     - 200.9.139.255  
	{ 0xc8098d00, 0xc8098eff, REGISTRY_LACNIC     }, // 200.9.141.0     - 200.9.142.255  
	{ 0xc8099100, 0xc80993ff, REGISTRY_LACNIC     }, // 200.9.145.0     - 200.9.147.255  
	{ 0xc8099500, 0xc80999ff, REGISTRY_LACNIC     }, // 200.9.149.0     - 200.9.153.255  
	{ 0xc8099d00, 0xc8099dff, REGISTRY_LACNIC     }, // 200.9.157.0     - 200.9.157.255  
	{ 0xc809a000, 0xc809a3ff, REGISTRY_LACNIC     }, // 200.9.160.0     - 200.9.163.255  
	{ 0xc809a500, 0xc809a8ff, REGISTRY_LACNIC     }, // 200.9.165.0     - 200.9.168.255  
	{ 0xc809aa00, 0xc809adff, REGISTRY_LACNIC     }, // 200.9.170.0     - 200.9.173.255  
	{ 0xc809af00, 0xc809b4ff, REGISTRY_LACNIC     }, // 200.9.175.0     - 200.9.180.255  
	{ 0xc809bb00, 0xc809c7ff, REGISTRY_LACNIC     }, // 200.9.187.0     - 200.9.199.255  
	{ 0xc809c900, 0xc809c9ff, REGISTRY_LACNIC     }, // 200.9.201.0     - 200.9.201.255  
	{ 0xc809cc00, 0xc809cdff, REGISTRY_LACNIC     }, // 200.9.204.0     - 200.9.205.255  
	{ 0xc809d000, 0xc809d5ff, REGISTRY_LACNIC     }, // 200.9.208.0     - 200.9.213.255  
	{ 0xc809d700, 0xc809dfff, REGISTRY_LACNIC     }, // 200.9.215.0     - 200.9.223.255  
	{ 0xc809e100, 0xc809e1ff, REGISTRY_LACNIC     }, // 200.9.225.0     - 200.9.225.255  
	{ 0xc809e300, 0xc809e4ff, REGISTRY_LACNIC     }, // 200.9.227.0     - 200.9.228.255  
	{ 0xc809e600, 0xc809e9ff, REGISTRY_LACNIC     }, // 200.9.230.0     - 200.9.233.255  
	{ 0xc809eb00, 0xc809f8ff, REGISTRY_LACNIC     }, // 200.9.235.0     - 200.9.248.255  
	{ 0xc809fd00, 0xc80a87ff, REGISTRY_LACNIC     }, // 200.9.253.0     - 200.10.135.255 
	{ 0xc80a8b00, 0xc80a8cff, REGISTRY_LACNIC     }, // 200.10.139.0    - 200.10.140.255 
	{ 0xc80a8e00, 0xc80a8fff, REGISTRY_LACNIC     }, // 200.10.142.0    - 200.10.143.255 
	{ 0xc80a9100, 0xc80a91ff, REGISTRY_LACNIC     }, // 200.10.145.0    - 200.10.145.255 
	{ 0xc80a9300, 0xc80a97ff, REGISTRY_LACNIC     }, // 200.10.147.0    - 200.10.151.255 
	{ 0xc80a9800, 0xc80a98ff, REGISTRY_ARIN       }, // 200.10.152.0    - 200.10.152.255 
	{ 0xc80a9b00, 0xc80a9bff, REGISTRY_ARIN       }, // 200.10.155.0    - 200.10.155.255 
	{ 0xc80a9f00, 0xc80a9fff, REGISTRY_LACNIC     }, // 200.10.159.0    - 200.10.159.255 
	{ 0xc80aa000, 0xc80aa0ff, REGISTRY_ARIN       }, // 200.10.160.0    - 200.10.160.255 
	{ 0xc80aa100, 0xc80aa2ff, REGISTRY_LACNIC     }, // 200.10.161.0    - 200.10.162.255 
	{ 0xc80aa500, 0xc80aa6ff, REGISTRY_ARIN       }, // 200.10.165.0    - 200.10.166.255 
	{ 0xc80aa700, 0xc80aacff, REGISTRY_LACNIC     }, // 200.10.167.0    - 200.10.172.255 
	{ 0xc80ab200, 0xc80ab3ff, REGISTRY_LACNIC     }, // 200.10.178.0    - 200.10.179.255 
	{ 0xc80ab600, 0xc80ab6ff, REGISTRY_LACNIC     }, // 200.10.182.0    - 200.10.182.255 
	{ 0xc80ab800, 0xc80ab8ff, REGISTRY_LACNIC     }, // 200.10.184.0    - 200.10.184.255 
	{ 0xc80aba00, 0xc80abaff, REGISTRY_LACNIC     }, // 200.10.186.0    - 200.10.186.255 
	{ 0xc80abc00, 0xc80abcff, REGISTRY_LACNIC     }, // 200.10.188.0    - 200.10.188.255 
	{ 0xc80abe00, 0xc80abeff, REGISTRY_LACNIC     }, // 200.10.190.0    - 200.10.190.255 
	{ 0xc80ac200, 0xc80acdff, REGISTRY_LACNIC     }, // 200.10.194.0    - 200.10.205.255 
	{ 0xc80acf00, 0xc80ad0ff, REGISTRY_LACNIC     }, // 200.10.207.0    - 200.10.208.255 
	{ 0xc80ad300, 0xc80ae2ff, REGISTRY_LACNIC     }, // 200.10.211.0    - 200.10.226.255 
	{ 0xc80ae400, 0xc80aeaff, REGISTRY_LACNIC     }, // 200.10.228.0    - 200.10.234.255 
	{ 0xc80aec00, 0xc80aeeff, REGISTRY_LACNIC     }, // 200.10.236.0    - 200.10.238.255 
	{ 0xc80af000, 0xc80af4ff, REGISTRY_LACNIC     }, // 200.10.240.0    - 200.10.244.255 
	{ 0xc80af600, 0xc80b67ff, REGISTRY_LACNIC     }, // 200.10.246.0    - 200.11.103.255 
	{ 0xc80b7000, 0xc80b77ff, REGISTRY_LACNIC     }, // 200.11.112.0    - 200.11.119.255 
	{ 0xc80b8000, 0xc80c82ff, REGISTRY_LACNIC     }, // 200.11.128.0    - 200.12.130.255 
	{ 0xc80c8400, 0xc80c8aff, REGISTRY_LACNIC     }, // 200.12.132.0    - 200.12.138.255 
	{ 0xc80c8c00, 0xc80c9cff, REGISTRY_LACNIC     }, // 200.12.140.0    - 200.12.156.255 
	{ 0xc80c9e00, 0xc80ca7ff, REGISTRY_LACNIC     }, // 200.12.158.0    - 200.12.167.255 
	{ 0xc80ca800, 0xc80ca8ff, REGISTRY_ARIN       }, // 200.12.168.0    - 200.12.168.255 
	{ 0xc80ca900, 0xc80cdfff, REGISTRY_LACNIC     }, // 200.12.169.0    - 200.12.223.255 
	{ 0xc80ce000, 0xc80cefff, REGISTRY_ARIN       }, // 200.12.224.0    - 200.12.239.255 
	{ 0xc80cf000, 0xc80d53ff, REGISTRY_LACNIC     }, // 200.12.240.0    - 200.13.83.255  
	{ 0xc80d5800, 0xc80e23ff, REGISTRY_LACNIC     }, // 200.13.88.0     - 200.14.35.255  
	{ 0xc80e2500, 0xc80e37ff, REGISTRY_LACNIC     }, // 200.14.37.0     - 200.14.55.255  
	{ 0xc80e4000, 0xc80e77ff, REGISTRY_LACNIC     }, // 200.14.64.0     - 200.14.119.255 
	{ 0xc80e8000, 0xc80effff, REGISTRY_LACNIC     }, // 200.14.128.0    - 200.14.255.255 
	{ 0xc80f0000, 0xc80fffff, REGISTRY_ARIN       }, // 200.15.0.0      - 200.15.255.255 
	{ 0xc8100000, 0xc81007ff, REGISTRY_LACNIC     }, // 200.16.0.0      - 200.16.7.255   
	{ 0xc8100800, 0xc8100fff, REGISTRY_AFRINIC    }, // 200.16.8.0      - 200.16.15.255  
	{ 0xc8101000, 0xc81057ff, REGISTRY_LACNIC     }, // 200.16.16.0     - 200.16.87.255  
	{ 0xc8105800, 0xc81058ff, REGISTRY_ARIN       }, // 200.16.88.0     - 200.16.88.255  
	{ 0xc8105900, 0xc8171eff, REGISTRY_LACNIC     }, // 200.16.89.0     - 200.23.30.255  
	{ 0xc8172000, 0xc81740ff, REGISTRY_LACNIC     }, // 200.23.32.0     - 200.23.64.255  
	{ 0xc8174200, 0xc8174dff, REGISTRY_LACNIC     }, // 200.23.66.0     - 200.23.77.255  
	{ 0xc8175200, 0xc81753ff, REGISTRY_LACNIC     }, // 200.23.82.0     - 200.23.83.255  
	{ 0xc8175500, 0xc81772ff, REGISTRY_LACNIC     }, // 200.23.85.0     - 200.23.114.255 
	{ 0xc8177500, 0xc81775ff, REGISTRY_LACNIC     }, // 200.23.117.0    - 200.23.117.255 
	{ 0xc8177800, 0xc81793ff, REGISTRY_LACNIC     }, // 200.23.120.0    - 200.23.147.255 
	{ 0xc8179500, 0xc81797ff, REGISTRY_LACNIC     }, // 200.23.149.0    - 200.23.151.255 
	{ 0xc8179a00, 0xc817bcff, REGISTRY_LACNIC     }, // 200.23.154.0    - 200.23.188.255 
	{ 0xc817be00, 0xc817ccff, REGISTRY_LACNIC     }, // 200.23.190.0    - 200.23.204.255 
	{ 0xc817d000, 0xc817fdff, REGISTRY_LACNIC     }, // 200.23.208.0    - 200.23.253.255 
	{ 0xc8180000, 0xc81809ff, REGISTRY_LACNIC     }, // 200.24.0.0      - 200.24.9.255   
	{ 0xc8180c00, 0xc81adfff, REGISTRY_LACNIC     }, // 200.24.12.0     - 200.26.223.255 
	{ 0xc81b0000, 0xc81dffff, REGISTRY_LACNIC     }, // 200.27.0.0      - 200.29.255.255 
	{ 0xc81e0000, 0xc81e3fff, REGISTRY_ARIN       }, // 200.30.0.0      - 200.30.63.255  
	{ 0xc81e4000, 0xc82127ff, REGISTRY_LACNIC     }, // 200.30.64.0     - 200.33.39.255  
	{ 0xc8212900, 0xc82132ff, REGISTRY_LACNIC     }, // 200.33.41.0     - 200.33.50.255  
	{ 0xc8213400, 0xc82150ff, REGISTRY_LACNIC     }, // 200.33.52.0     - 200.33.80.255  
	{ 0xc8215400, 0xc82154ff, REGISTRY_LACNIC     }, // 200.33.84.0     - 200.33.84.255  
	{ 0xc8215600, 0xc8215fff, REGISTRY_LACNIC     }, // 200.33.86.0     - 200.33.95.255  
	{ 0xc8216100, 0xc8216bff, REGISTRY_LACNIC     }, // 200.33.97.0     - 200.33.107.255 
	{ 0xc8216d00, 0xc82170ff, REGISTRY_LACNIC     }, // 200.33.109.0    - 200.33.112.255 
	{ 0xc8217200, 0xc82172ff, REGISTRY_LACNIC     }, // 200.33.114.0    - 200.33.114.255 
	{ 0xc8217400, 0xc82174ff, REGISTRY_LACNIC     }, // 200.33.116.0    - 200.33.116.255 
	{ 0xc8217600, 0xc8217cff, REGISTRY_LACNIC     }, // 200.33.118.0    - 200.33.124.255 
	{ 0xc8218000, 0xc821adff, REGISTRY_LACNIC     }, // 200.33.128.0    - 200.33.173.255 
	{ 0xc821b000, 0xc821caff, REGISTRY_LACNIC     }, // 200.33.176.0    - 200.33.202.255 
	{ 0xc821cc00, 0xc821fcff, REGISTRY_LACNIC     }, // 200.33.204.0    - 200.33.252.255 
	{ 0xc821fe00, 0xc822acff, REGISTRY_LACNIC     }, // 200.33.254.0    - 200.34.172.255 
	{ 0xc822ae00, 0xc822ccff, REGISTRY_LACNIC     }, // 200.34.174.0    - 200.34.204.255 
	{ 0xc822cf00, 0xc822d1ff, REGISTRY_LACNIC     }, // 200.34.207.0    - 200.34.209.255 
	{ 0xc822d300, 0xc822d6ff, REGISTRY_LACNIC     }, // 200.34.211.0    - 200.34.214.255 
	{ 0xc822d800, 0xc822dbff, REGISTRY_LACNIC     }, // 200.34.216.0    - 200.34.219.255 
	{ 0xc822dd00, 0xc831ffff, REGISTRY_LACNIC     }, // 200.34.221.0    - 200.49.255.255 
	{ 0xc8320000, 0xc8321fff, REGISTRY_ARIN       }, // 200.50.0.0      - 200.50.31.255  
	{ 0xc8322000, 0xc8323fff, REGISTRY_LACNIC     }, // 200.50.32.0     - 200.50.63.255  
	{ 0xc8324000, 0xc8325fff, REGISTRY_ARIN       }, // 200.50.64.0     - 200.50.95.255  
	{ 0xc8326000, 0xc8327fff, REGISTRY_LACNIC     }, // 200.50.96.0     - 200.50.127.255 
	{ 0xc8328000, 0xc8328fff, REGISTRY_ARIN       }, // 200.50.128.0    - 200.50.143.255 
	{ 0xc8329000, 0xc832bfff, REGISTRY_LACNIC     }, // 200.50.144.0    - 200.50.191.255 
	{ 0xc832e000, 0xc839ffff, REGISTRY_LACNIC     }, // 200.50.224.0    - 200.57.255.255 
	{ 0xc83a0000, 0xc83a3fff, REGISTRY_ARIN       }, // 200.58.0.0      - 200.58.63.255  
	{ 0xc83a4000, 0xc83af7ff, REGISTRY_LACNIC     }, // 200.58.64.0     - 200.58.247.255 
	{ 0xc83b0000, 0xc83dffff, REGISTRY_LACNIC     }, // 200.59.0.0      - 200.61.255.255 
	{ 0xc83e0000, 0xc83e3fff, REGISTRY_ARIN       }, // 200.62.0.0      - 200.62.63.255  
	{ 0xc83e4000, 0xc8475fff, REGISTRY_LACNIC     }, // 200.62.64.0     - 200.71.95.255  
	{ 0xc8477000, 0xc849d7ff, REGISTRY_LACNIC     }, // 200.71.112.0    - 200.73.215.255 
	{ 0xc849e000, 0xc8512fff, REGISTRY_LACNIC     }, // 200.73.224.0    - 200.81.47.255  
	{ 0xc8513800, 0xc86a7fff, REGISTRY_LACNIC     }, // 200.81.56.0     - 200.106.127.255
	{ 0xc86a9000, 0xc86b6fff, REGISTRY_LACNIC     }, // 200.106.144.0   - 200.107.111.255
	{ 0xc86b7800, 0xc86bd7ff, REGISTRY_LACNIC     }, // 200.107.120.0   - 200.107.215.255
	{ 0xc86be000, 0xc86c9fff, REGISTRY_LACNIC     }, // 200.107.224.0   - 200.108.159.255
	{ 0xc86cc000, 0xc86e5fff, REGISTRY_LACNIC     }, // 200.108.192.0   - 200.110.95.255 
	{ 0xc86e7000, 0xc86ec7ff, REGISTRY_LACNIC     }, // 200.110.112.0   - 200.110.199.255
	{ 0xc86ed000, 0xc8735fff, REGISTRY_LACNIC     }, // 200.110.208.0   - 200.115.95.255 
	{ 0xc8738000, 0xc87bdfff, REGISTRY_LACNIC     }, // 200.115.128.0   - 200.123.223.255
	{ 0xc87bf000, 0xc87c3fff, REGISTRY_LACNIC     }, // 200.123.240.0   - 200.124.63.255 
	{ 0xc87c6000, 0xc87c9fff, REGISTRY_LACNIC     }, // 200.124.96.0    - 200.124.159.255
	{ 0xc87cb000, 0xc87da7ff, REGISTRY_LACNIC     }, // 200.124.176.0   - 200.125.167.255
	{ 0xc87db800, 0xc8c069ff, REGISTRY_LACNIC     }, // 200.125.184.0   - 200.192.105.255
	{ 0xc8c06c00, 0xc8c0e9ff, REGISTRY_LACNIC     }, // 200.192.108.0   - 200.192.233.255
	{ 0xc8c0ec00, 0xc8db93ff, REGISTRY_LACNIC     }, // 200.192.236.0   - 200.219.147.255
	{ 0xc8db9600, 0xc8e5f9ff, REGISTRY_LACNIC     }, // 200.219.150.0   - 200.229.249.255
	{ 0xc8e5fc00, 0xc946ffff, REGISTRY_LACNIC     }, // 200.229.252.0   - 201.70.255.255 
	{ 0xc9472000, 0xc947bfff, REGISTRY_LACNIC     }, // 201.71.32.0     - 201.71.191.255 
	{ 0xc947d000, 0xc94d5fff, REGISTRY_LACNIC     }, // 201.71.208.0    - 201.77.95.255  
	{ 0xc94d7000, 0xc94d8fff, REGISTRY_LACNIC     }, // 201.77.112.0    - 201.77.143.255 
	{ 0xc94da000, 0xc98309ff, REGISTRY_LACNIC     }, // 201.77.160.0    - 201.131.9.255  
	{ 0xc9830c00, 0xc98325ff, REGISTRY_LACNIC     }, // 201.131.12.0    - 201.131.37.255 
	{ 0xc9832800, 0xc98328ff, REGISTRY_LACNIC     }, // 201.131.40.0    - 201.131.40.255 
	{ 0xc9832c00, 0xc9832cff, REGISTRY_LACNIC     }, // 201.131.44.0    - 201.131.44.255 
	{ 0xc9833000, 0xc98330ff, REGISTRY_LACNIC     }, // 201.131.48.0    - 201.131.48.255 
	{ 0xc9833400, 0xc98341ff, REGISTRY_LACNIC     }, // 201.131.52.0    - 201.131.65.255 
	{ 0xc9834400, 0xc98348ff, REGISTRY_LACNIC     }, // 201.131.68.0    - 201.131.72.255 
	{ 0xc9834c00, 0xc9834cff, REGISTRY_LACNIC     }, // 201.131.76.0    - 201.131.76.255 
	{ 0xc9835000, 0xc98359ff, REGISTRY_LACNIC     }, // 201.131.80.0    - 201.131.89.255 
	{ 0xc9835c00, 0xc98360ff, REGISTRY_LACNIC     }, // 201.131.92.0    - 201.131.96.255 
	{ 0xc9836400, 0xc98365ff, REGISTRY_LACNIC     }, // 201.131.100.0   - 201.131.101.255
	{ 0xc9836800, 0xc98369ff, REGISTRY_LACNIC     }, // 201.131.104.0   - 201.131.105.255
	{ 0xc9836c00, 0xc9836dff, REGISTRY_LACNIC     }, // 201.131.108.0   - 201.131.109.255
	{ 0xc9837000, 0xc98371ff, REGISTRY_LACNIC     }, // 201.131.112.0   - 201.131.113.255
	{ 0xc9837400, 0xc98375ff, REGISTRY_LACNIC     }, // 201.131.116.0   - 201.131.117.255
	{ 0xc9837800, 0xc98379ff, REGISTRY_LACNIC     }, // 201.131.120.0   - 201.131.121.255
	{ 0xc9837c00, 0xc9d83fff, REGISTRY_LACNIC     }, // 201.131.124.0   - 201.216.63.255 
	{ 0xc9d88000, 0xc9de1fff, REGISTRY_LACNIC     }, // 201.216.128.0   - 201.222.31.255 
	{ 0xc9de3000, 0xc9ffffff, REGISTRY_LACNIC     }, // 201.222.48.0    - 201.255.255.255
	{ 0xca000000, 0xca005dff, REGISTRY_APNIC      }, // 202.0.0.0       - 202.0.93.255   
	{ 0xca005f00, 0xca0060ff, REGISTRY_APNIC      }, // 202.0.95.0      - 202.0.96.255   
	{ 0xca006200, 0xca0093ff, REGISTRY_APNIC      }, // 202.0.98.0      - 202.0.147.255  
	{ 0xca009500, 0xca0095ff, REGISTRY_APNIC      }, // 202.0.149.0     - 202.0.149.255  
	{ 0xca009700, 0xca0097ff, REGISTRY_APNIC      }, // 202.0.151.0     - 202.0.151.255  
	{ 0xca009a00, 0xca01dfff, REGISTRY_APNIC      }, // 202.0.154.0     - 202.1.223.255  
	{ 0xca01e800, 0xca0347ff, REGISTRY_APNIC      }, // 202.1.232.0     - 202.3.71.255   
	{ 0xca034a00, 0xca04a8ff, REGISTRY_APNIC      }, // 202.3.74.0      - 202.4.168.255  
	{ 0xca04aa00, 0xca04baff, REGISTRY_APNIC      }, // 202.4.170.0     - 202.4.186.255  
	{ 0xca04bc00, 0xca04bcff, REGISTRY_APNIC      }, // 202.4.188.0     - 202.4.188.255  
	{ 0xca04be00, 0xca05cfff, REGISTRY_APNIC      }, // 202.4.190.0     - 202.5.207.255  
	{ 0xca05e000, 0xca064fff, REGISTRY_APNIC      }, // 202.5.224.0     - 202.6.79.255   
	{ 0xca065100, 0xca0818ff, REGISTRY_APNIC      }, // 202.6.81.0      - 202.8.24.255   
	{ 0xca081a00, 0xca085fff, REGISTRY_APNIC      }, // 202.8.26.0      - 202.8.95.255   
	{ 0xca088000, 0xca0936ff, REGISTRY_APNIC      }, // 202.8.128.0     - 202.9.54.255   
	{ 0xca093800, 0xca093bff, REGISTRY_APNIC      }, // 202.9.56.0      - 202.9.59.255   
	{ 0xca094100, 0xca0943ff, REGISTRY_APNIC      }, // 202.9.65.0      - 202.9.67.255   
	{ 0xca094500, 0xca0958ff, REGISTRY_APNIC      }, // 202.9.69.0      - 202.9.88.255   
	{ 0xca095a00, 0xca096fff, REGISTRY_APNIC      }, // 202.9.90.0      - 202.9.111.255  
	{ 0xca098000, 0xca0a6fff, REGISTRY_APNIC      }, // 202.9.128.0     - 202.10.111.255 
	{ 0xca0a8000, 0xca0c4bff, REGISTRY_APNIC      }, // 202.10.128.0    - 202.12.75.255  
	{ 0xca0c5000, 0xca0c79ff, REGISTRY_APNIC      }, // 202.12.80.0     - 202.12.121.255 
	{ 0xca0c7d00, 0xca0cf2ff, REGISTRY_APNIC      }, // 202.12.125.0    - 202.12.242.255 
	{ 0xca0cf400, 0xca0e03ff, REGISTRY_APNIC      }, // 202.12.244.0    - 202.14.3.255   
	{ 0xca0e0800, 0xca0e77ff, REGISTRY_APNIC      }, // 202.14.8.0      - 202.14.119.255 
	{ 0xca0e7c00, 0xca0eabff, REGISTRY_APNIC      }, // 202.14.124.0    - 202.14.171.255 
	{ 0xca0eb000, 0xca0ebaff, REGISTRY_APNIC      }, // 202.14.176.0    - 202.14.186.255 
	{ 0xca0ebc00, 0xca0edfff, REGISTRY_APNIC      }, // 202.14.188.0    - 202.14.223.255 
	{ 0xca0ee100, 0xca1443ff, REGISTRY_APNIC      }, // 202.14.225.0    - 202.20.67.255  
	{ 0xca144500, 0xca1527ff, REGISTRY_APNIC      }, // 202.20.69.0     - 202.21.39.255  
	{ 0xca154000, 0xca1b0bff, REGISTRY_APNIC      }, // 202.21.64.0     - 202.27.11.255  
	{ 0xca1b0d00, 0xca1b0dff, REGISTRY_APNIC      }, // 202.27.13.0     - 202.27.13.255  
	{ 0xca1b0f00, 0xca1be4ff, REGISTRY_APNIC      }, // 202.27.15.0     - 202.27.228.255 
	{ 0xca1be800, 0xca2479ff, REGISTRY_APNIC      }, // 202.27.232.0    - 202.36.121.255 
	{ 0xca247c00, 0xca24e1ff, REGISTRY_APNIC      }, // 202.36.124.0    - 202.36.225.255 
	{ 0xca24e300, 0xca2533ff, REGISTRY_APNIC      }, // 202.36.227.0    - 202.37.51.255  
	{ 0xca253600, 0xca29c3ff, REGISTRY_APNIC      }, // 202.37.54.0     - 202.41.195.255 
	{ 0xca29cc00, 0xca2b77ff, REGISTRY_APNIC      }, // 202.41.204.0    - 202.43.119.255 
	{ 0xca2b8000, 0xca2c2fff, REGISTRY_APNIC      }, // 202.43.128.0    - 202.44.47.255  
	{ 0xca2c3400, 0xca2c60ff, REGISTRY_APNIC      }, // 202.44.52.0     - 202.44.96.255  
	{ 0xca2c6200, 0xca2f5fff, REGISTRY_APNIC      }, // 202.44.98.0     - 202.47.95.255  
	{ 0xca2f7000, 0xca2f7bff, REGISTRY_APNIC      }, // 202.47.112.0    - 202.47.123.255 
	{ 0xca2f7d00, 0xca3120ff, REGISTRY_APNIC      }, // 202.47.125.0    - 202.49.32.255  
	{ 0xca312200, 0xca33f7ff, REGISTRY_APNIC      }, // 202.49.34.0     - 202.51.247.255 
	{ 0xca33fc00, 0xca3420ff, REGISTRY_APNIC      }, // 202.51.252.0    - 202.52.32.255  
	{ 0xca342300, 0xca348eff, REGISTRY_APNIC      }, // 202.52.35.0     - 202.52.142.255 
	{ 0xca349000, 0xca3585ff, REGISTRY_APNIC      }, // 202.52.144.0    - 202.53.133.255 
	{ 0xca358d00, 0xca358eff, REGISTRY_APNIC      }, // 202.53.141.0    - 202.53.142.255 
	{ 0xca35a000, 0xca39bfff, REGISTRY_APNIC      }, // 202.53.160.0    - 202.57.191.255 
	{ 0xca39dc00, 0xca3a67ff, REGISTRY_APNIC      }, // 202.57.220.0    - 202.58.103.255 
	{ 0xca3a7400, 0xca3a7eff, REGISTRY_APNIC      }, // 202.58.116.0    - 202.58.126.255 
	{ 0xca3a8000, 0xca3af7ff, REGISTRY_APNIC      }, // 202.58.128.0    - 202.58.247.255 
	{ 0xca3b0000, 0xca3b00ff, REGISTRY_APNIC      }, // 202.59.0.0      - 202.59.0.255   
	{ 0xca3b0200, 0xca3befff, REGISTRY_APNIC      }, // 202.59.2.0      - 202.59.239.255 
	{ 0xca3bf100, 0xca3d3fff, REGISTRY_APNIC      }, // 202.59.241.0    - 202.61.63.255  
	{ 0xca3d6000, 0xca3d77ff, REGISTRY_APNIC      }, // 202.61.96.0     - 202.61.119.255 
	{ 0xca3d7a00, 0xca3d7aff, REGISTRY_APNIC      }, // 202.61.122.0    - 202.61.122.255 
	{ 0xca3d7c00, 0xca3d7eff, REGISTRY_APNIC      }, // 202.61.124.0    - 202.61.126.255 
	{ 0xca3d8000, 0xca3f4fff, REGISTRY_APNIC      }, // 202.61.128.0    - 202.63.79.255  
	{ 0xca3f5100, 0xca3ffcff, REGISTRY_APNIC      }, // 202.63.81.0     - 202.63.252.255 
	{ 0xca3ffe00, 0xca415fff, REGISTRY_APNIC      }, // 202.63.254.0    - 202.65.95.255  
	{ 0xca417000, 0xca429fff, REGISTRY_APNIC      }, // 202.65.112.0    - 202.66.159.255 
	{ 0xca42c000, 0xca471fff, REGISTRY_APNIC      }, // 202.66.192.0    - 202.71.31.255  
	{ 0xca473000, 0xca486fff, REGISTRY_APNIC      }, // 202.71.48.0     - 202.72.111.255 
	{ 0xca488000, 0xca48dfff, REGISTRY_APNIC      }, // 202.72.128.0    - 202.72.223.255 
	{ 0xca48e800, 0xca49efff, REGISTRY_APNIC      }, // 202.72.232.0    - 202.73.239.255 
	{ 0xca4a0000, 0xca4a23ff, REGISTRY_APNIC      }, // 202.74.0.0      - 202.74.35.255  
	{ 0xca4a2500, 0xca4a29ff, REGISTRY_APNIC      }, // 202.74.37.0     - 202.74.41.255  
	{ 0xca4a2b00, 0xca4a33ff, REGISTRY_APNIC      }, // 202.74.43.0     - 202.74.51.255  
	{ 0xca4a3500, 0xca4ae7ff, REGISTRY_APNIC      }, // 202.74.53.0     - 202.74.231.255 
	{ 0xca4af000, 0xca51afff, REGISTRY_APNIC      }, // 202.74.240.0    - 202.81.175.255 
	{ 0xca51c000, 0xca5377ff, REGISTRY_APNIC      }, // 202.81.192.0    - 202.83.119.255 
	{ 0xca538000, 0xca5413ff, REGISTRY_APNIC      }, // 202.83.128.0    - 202.84.19.255  
	{ 0xca541700, 0xca581fff, REGISTRY_APNIC      }, // 202.84.23.0     - 202.88.31.255  
	{ 0xca583000, 0xca595fff, REGISTRY_APNIC      }, // 202.88.48.0     - 202.89.95.255  
	{ 0xca596400, 0xca596bff, REGISTRY_APNIC      }, // 202.89.100.0    - 202.89.107.255 
	{ 0xca597000, 0xca5976ff, REGISTRY_APNIC      }, // 202.89.112.0    - 202.89.118.255 
	{ 0xca597800, 0xca5a0fff, REGISTRY_APNIC      }, // 202.89.120.0    - 202.90.15.255  
	{ 0xca5a2000, 0xca5ac0ff, REGISTRY_APNIC      }, // 202.90.32.0     - 202.90.192.255 
	{ 0xca5ac200, 0xca5accff, REGISTRY_APNIC      }, // 202.90.194.0    - 202.90.204.255 
	{ 0xca5ace00, 0xca5dffff, REGISTRY_APNIC      }, // 202.90.206.0    - 202.93.255.255 
	{ 0xca5e2000, 0xca5e49ff, REGISTRY_APNIC      }, // 202.94.32.0     - 202.94.73.255  
	{ 0xca5e4b00, 0xca5e50ff, REGISTRY_APNIC      }, // 202.94.75.0     - 202.94.80.255  
	{ 0xca5e5200, 0xca5e59ff, REGISTRY_APNIC      }, // 202.94.82.0     - 202.94.89.255  
	{ 0xca5e5c00, 0xca7affff, REGISTRY_APNIC      }, // 202.94.92.0     - 202.122.255.255
	{ 0xca7b0000, 0xca7b1fff, REGISTRY_AFRINIC    }, // 202.123.0.0     - 202.123.31.255 
	{ 0xca7b2000, 0xca7b6fff, REGISTRY_APNIC      }, // 202.123.32.0    - 202.123.111.255
	{ 0xca7b8000, 0xca7d6cff, REGISTRY_APNIC      }, // 202.123.128.0   - 202.125.108.255
	{ 0xca7d6e00, 0xca81cfff, REGISTRY_APNIC      }, // 202.125.110.0   - 202.129.207.255
	{ 0xca81d100, 0xca8226ff, REGISTRY_APNIC      }, // 202.129.209.0   - 202.130.38.255 
	{ 0xca822800, 0xca853fff, REGISTRY_APNIC      }, // 202.130.40.0    - 202.133.63.255 
	{ 0xca856000, 0xca86cfff, REGISTRY_APNIC      }, // 202.133.96.0    - 202.134.207.255
	{ 0xca86e000, 0xca883fff, REGISTRY_APNIC      }, // 202.134.224.0   - 202.136.63.255 
	{ 0xca886000, 0xca88f7ff, REGISTRY_APNIC      }, // 202.136.96.0    - 202.136.247.255
	{ 0xca88fc00, 0xca8c7fff, REGISTRY_APNIC      }, // 202.136.252.0   - 202.140.127.255
	{ 0xca8c8800, 0xca8c8bff, REGISTRY_APNIC      }, // 202.140.136.0   - 202.140.139.255
	{ 0xca8ca000, 0xca8f5fff, REGISTRY_APNIC      }, // 202.140.160.0   - 202.143.95.255 
	{ 0xca8f7000, 0xca92b9ff, REGISTRY_APNIC      }, // 202.143.112.0   - 202.146.185.255
	{ 0xca92bb00, 0xca9437ff, REGISTRY_APNIC      }, // 202.146.187.0   - 202.148.55.255 
	{ 0xca944000, 0xca9720ff, REGISTRY_APNIC      }, // 202.148.64.0    - 202.151.32.255 
	{ 0xca972200, 0xca9903ff, REGISTRY_APNIC      }, // 202.151.34.0    - 202.153.3.255  
	{ 0xca990600, 0xca9906ff, REGISTRY_APNIC      }, // 202.153.6.0     - 202.153.6.255  
	{ 0xca990800, 0xca9ef1ff, REGISTRY_APNIC      }, // 202.153.8.0     - 202.158.241.255
	{ 0xca9ef300, 0xca9ef7ff, REGISTRY_APNIC      }, // 202.158.243.0   - 202.158.247.255
	{ 0xca9efc00, 0xcaa07fff, REGISTRY_APNIC      }, // 202.158.252.0   - 202.160.127.255
	{ 0xcaa0a000, 0xcaa84fff, REGISTRY_APNIC      }, // 202.160.160.0   - 202.168.79.255 
	{ 0xcaa85800, 0xcaa87fff, REGISTRY_APNIC      }, // 202.168.88.0    - 202.168.127.255
	{ 0xcaa8a000, 0xcaaac7ff, REGISTRY_APNIC      }, // 202.168.160.0   - 202.170.199.255
	{ 0xcaaad000, 0xcaabe7ff, REGISTRY_APNIC      }, // 202.170.208.0   - 202.171.231.255
	{ 0xcaabe900, 0xcaad05ff, REGISTRY_APNIC      }, // 202.171.233.0   - 202.173.5.255  
	{ 0xcaad0700, 0xcaad6fff, REGISTRY_APNIC      }, // 202.173.7.0     - 202.173.111.255
	{ 0xcaad8000, 0xcaae7bff, REGISTRY_APNIC      }, // 202.173.128.0   - 202.174.123.255
	{ 0xcaae8000, 0xcaafffff, REGISTRY_APNIC      }, // 202.174.128.0   - 202.175.255.255
	{ 0xcab00800, 0xcab37fff, REGISTRY_APNIC      }, // 202.176.8.0     - 202.179.127.255
	{ 0xcab3b000, 0xcab4ffff, REGISTRY_APNIC      }, // 202.179.176.0   - 202.180.255.255
	{ 0xcab52000, 0xcb0070ff, REGISTRY_APNIC      }, // 202.181.32.0    - 203.0.112.255  
	{ 0xcb007200, 0xcb06cfff, REGISTRY_APNIC      }, // 203.0.114.0     - 203.6.207.255  
	{ 0xcb06d800, 0xcb0b5aff, REGISTRY_APNIC      }, // 203.6.216.0     - 203.11.90.255  
	{ 0xcb0b5c00, 0xcb0c55ff, REGISTRY_APNIC      }, // 203.11.92.0     - 203.12.85.255  
	{ 0xcb0c5700, 0xcb0de6ff, REGISTRY_APNIC      }, // 203.12.87.0     - 203.13.230.255 
	{ 0xcb0de800, 0xcb100aff, REGISTRY_APNIC      }, // 203.13.232.0    - 203.16.10.255  
	{ 0xcb100c00, 0xcb103eff, REGISTRY_APNIC      }, // 203.16.12.0     - 203.16.62.255  
	{ 0xcb104000, 0xcb11bcff, REGISTRY_APNIC      }, // 203.16.64.0     - 203.17.188.255 
	{ 0xcb11be00, 0xcb11f8ff, REGISTRY_APNIC      }, // 203.17.190.0    - 203.17.248.255 
	{ 0xcb11fa00, 0xcb126eff, REGISTRY_APNIC      }, // 203.17.250.0    - 203.18.110.255 
	{ 0xcb127000, 0xcb129bff, REGISTRY_APNIC      }, // 203.18.112.0    - 203.18.155.255 
	{ 0xcb12a000, 0xcb1300ff, REGISTRY_APNIC      }, // 203.18.160.0    - 203.19.0.255   
	{ 0xcb130200, 0xcb1392ff, REGISTRY_APNIC      }, // 203.19.2.0      - 203.19.146.255 
	{ 0xcb139400, 0xcb13efff, REGISTRY_APNIC      }, // 203.19.148.0    - 203.19.239.255 
	{ 0xcb13f100, 0xcb1429ff, REGISTRY_APNIC      }, // 203.19.241.0    - 203.20.41.255  
	{ 0xcb142b00, 0xcb142bff, REGISTRY_APNIC      }, // 203.20.43.0     - 203.20.43.255  
	{ 0xcb142d00, 0xcb143eff, REGISTRY_APNIC      }, // 203.20.45.0     - 203.20.62.255  
	{ 0xcb144000, 0xcb1448ff, REGISTRY_APNIC      }, // 203.20.64.0     - 203.20.72.255  
	{ 0xcb144a00, 0xcb166bff, REGISTRY_APNIC      }, // 203.20.74.0     - 203.22.107.255 
	{ 0xcb166e00, 0xcb1700ff, REGISTRY_APNIC      }, // 203.22.110.0    - 203.23.0.255   
	{ 0xcb170200, 0xcb1733ff, REGISTRY_APNIC      }, // 203.23.2.0      - 203.23.51.255  
	{ 0xcb173500, 0xcb1745ff, REGISTRY_APNIC      }, // 203.23.53.0     - 203.23.69.255  
	{ 0xcb174700, 0xcb1825ff, REGISTRY_APNIC      }, // 203.23.71.0     - 203.24.37.255  
	{ 0xcb182700, 0xcb1987ff, REGISTRY_APNIC      }, // 203.24.39.0     - 203.25.135.255 
	{ 0xcb198900, 0xcb19a0ff, REGISTRY_APNIC      }, // 203.25.137.0    - 203.25.160.255 
	{ 0xcb19a200, 0xcb1b21ff, REGISTRY_APNIC      }, // 203.25.162.0    - 203.27.33.255  
	{ 0xcb1b2300, 0xcb1e7eff, REGISTRY_APNIC      }, // 203.27.35.0     - 203.30.126.255 
	{ 0xcb1e8000, 0xcb1edcff, REGISTRY_APNIC      }, // 203.30.128.0    - 203.30.220.255 
	{ 0xcb1ede00, 0xcb2055ff, REGISTRY_APNIC      }, // 203.30.222.0    - 203.32.85.255  
	{ 0xcb205800, 0xcb20bbff, REGISTRY_APNIC      }, // 203.32.88.0     - 203.32.187.255 
	{ 0xcb20bd00, 0xcb2251ff, REGISTRY_APNIC      }, // 203.32.189.0    - 203.34.81.255  
	{ 0xcb225300, 0xcb227cff, REGISTRY_APNIC      }, // 203.34.83.0     - 203.34.124.255 
	{ 0xcb227e00, 0xcb2299ff, REGISTRY_APNIC      }, // 203.34.126.0    - 203.34.153.255 
	{ 0xcb229b00, 0xcb22f0ff, REGISTRY_APNIC      }, // 203.34.155.0    - 203.34.240.255 
	{ 0xcb22f200, 0xcb3743ff, REGISTRY_APNIC      }, // 203.34.242.0    - 203.55.67.255  
	{ 0xcb374500, 0xcb38e6ff, REGISTRY_APNIC      }, // 203.55.69.0     - 203.56.230.255 
	{ 0xcb38e800, 0xcb4ccfff, REGISTRY_APNIC      }, // 203.56.232.0    - 203.76.207.255 
	{ 0xcb4d0000, 0xcb4e8fff, REGISTRY_APNIC      }, // 203.77.0.0      - 203.78.143.255 
	{ 0xcb4ea000, 0xcb5080ff, REGISTRY_APNIC      }, // 203.78.160.0    - 203.80.128.255 
	{ 0xcb508200, 0xcb51efff, REGISTRY_APNIC      }, // 203.80.130.0    - 203.81.239.255 
	{ 0xcb51f800, 0xcb5217ff, REGISTRY_APNIC      }, // 203.81.248.0    - 203.82.23.255  
	{ 0xcb522000, 0xcb526fff, REGISTRY_APNIC      }, // 203.82.32.0     - 203.82.111.255 
	{ 0xcb528000, 0xcb52dfff, REGISTRY_APNIC      }, // 203.82.128.0    - 203.82.223.255 
	{ 0xcb52f000, 0xcb5307ff, REGISTRY_APNIC      }, // 203.82.240.0    - 203.83.7.255   
	{ 0xcb531000, 0xcb56f9ff, REGISTRY_APNIC      }, // 203.83.16.0     - 203.86.249.255 
	{ 0xcb56fb00, 0xcb5984ff, REGISTRY_APNIC      }, // 203.86.251.0    - 203.89.132.255 
	{ 0xcb598600, 0xcb5a0bff, REGISTRY_APNIC      }, // 203.89.134.0    - 203.90.11.255  
	{ 0xcb5a1000, 0xcb5c05ff, REGISTRY_APNIC      }, // 203.90.16.0     - 203.92.5.255   
	{ 0xcb5c0700, 0xcb5fbfff, REGISTRY_APNIC      }, // 203.92.7.0      - 203.95.191.255 
	{ 0xcb5fe000, 0xcb638bff, REGISTRY_APNIC      }, // 203.95.224.0    - 203.99.139.255 
	{ 0xcb638e00, 0xcb6439ff, REGISTRY_APNIC      }, // 203.99.142.0    - 203.100.57.255 
	{ 0xcb643b00, 0xcb643bff, REGISTRY_APNIC      }, // 203.100.59.0    - 203.100.59.255 
	{ 0xcb643d00, 0xcb6ffbff, REGISTRY_APNIC      }, // 203.100.61.0    - 203.111.251.255
	{ 0xcb700000, 0xcb7243ff, REGISTRY_APNIC      }, // 203.112.0.0     - 203.114.67.255 
	{ 0xcb726000, 0xcb7b37ff, REGISTRY_APNIC      }, // 203.114.96.0    - 203.123.55.255 
	{ 0xcb7b3b00, 0xcb86f7ff, REGISTRY_APNIC      }, // 203.123.59.0    - 203.134.247.255
	{ 0xcb86fa00, 0xcb8edaff, REGISTRY_APNIC      }, // 203.134.250.0   - 203.142.218.255
	{ 0xcb8edc00, 0xcb9457ff, REGISTRY_APNIC      }, // 203.142.220.0   - 203.148.87.255 
	{ 0xcb945c00, 0xcb990fff, REGISTRY_APNIC      }, // 203.148.92.0    - 203.153.15.255 
	{ 0xcb991800, 0xcb993bff, REGISTRY_APNIC      }, // 203.153.24.0    - 203.153.59.255 
	{ 0xcb994000, 0xcb99cfff, REGISTRY_APNIC      }, // 203.153.64.0    - 203.153.207.255
	{ 0xcb99d200, 0xcba02fff, REGISTRY_APNIC      }, // 203.153.210.0   - 203.160.47.255 
	{ 0xcba03800, 0xcba083ff, REGISTRY_APNIC      }, // 203.160.56.0    - 203.160.131.255
	{ 0xcba08800, 0xcba1b6ff, REGISTRY_APNIC      }, // 203.160.136.0   - 203.161.182.255
	{ 0xcba1b800, 0xcba707ff, REGISTRY_APNIC      }, // 203.161.184.0   - 203.167.7.255  
	{ 0xcba72000, 0xcbaa57ff, REGISTRY_APNIC      }, // 203.167.32.0    - 203.170.87.255 
	{ 0xcbaa5a00, 0xcbabcfff, REGISTRY_APNIC      }, // 203.170.90.0    - 203.171.207.255
	{ 0xcbabd100, 0xcbae05ff, REGISTRY_APNIC      }, // 203.171.209.0   - 203.174.5.255  
	{ 0xcbae0700, 0xcbaf5fff, REGISTRY_APNIC      }, // 203.174.7.0     - 203.175.95.255 
	{ 0xcbaf7000, 0xcbb07bff, REGISTRY_APNIC      }, // 203.175.112.0   - 203.176.123.255
	{ 0xcbb08000, 0xcbb9bcff, REGISTRY_APNIC      }, // 203.176.128.0   - 203.185.188.255
	{ 0xcbb9be00, 0xcbbd73ff, REGISTRY_APNIC      }, // 203.185.190.0   - 203.189.115.255
	{ 0xcbbd7800, 0xcbbde7ff, REGISTRY_APNIC      }, // 203.189.120.0   - 203.189.231.255
	{ 0xcbbe0000, 0xcbbe1fff, REGISTRY_APNIC      }, // 203.190.0.0     - 203.190.31.255 
	{ 0xcbbe2400, 0xcbbf01ff, REGISTRY_APNIC      }, // 203.190.36.0    - 203.191.1.255  
	{ 0xcbbf0300, 0xcbbf04ff, REGISTRY_APNIC      }, // 203.191.3.0     - 203.191.4.255  
	{ 0xcbbf0600, 0xcbbf06ff, REGISTRY_APNIC      }, // 203.191.6.0     - 203.191.6.255  
	{ 0xcbbf0800, 0xcbbf3bff, REGISTRY_APNIC      }, // 203.191.8.0     - 203.191.59.255 
	{ 0xcbbf4000, 0xcbbf84ff, REGISTRY_APNIC      }, // 203.191.64.0    - 203.191.132.255
	{ 0xcbbf8600, 0xcbc417ff, REGISTRY_APNIC      }, // 203.191.134.0   - 203.196.23.255 
	{ 0xcbc42000, 0xcbc9b4ff, REGISTRY_APNIC      }, // 203.196.32.0    - 203.201.180.255
	{ 0xcbc9b700, 0xcbcae7ff, REGISTRY_APNIC      }, // 203.201.183.0   - 203.202.231.255
	{ 0xcbcaea00, 0xcbd41bff, REGISTRY_APNIC      }, // 203.202.234.0   - 203.212.27.255 
	{ 0xcbd42000, 0xcbd9a1ff, REGISTRY_APNIC      }, // 203.212.32.0    - 203.217.161.255
	{ 0xcbd9a800, 0xcbffffff, REGISTRY_APNIC      }, // 203.217.168.0   - 203.255.255.255
	{ 0xcc000000, 0xcc08cbff, REGISTRY_ARIN       }, // 204.0.0.0       - 204.8.203.255  
	{ 0xcc08d000, 0xcc0affff, REGISTRY_ARIN       }, // 204.8.208.0     - 204.10.255.255 
	{ 0xcc0b0400, 0xcc0c7fff, REGISTRY_ARIN       }, // 204.11.4.0      - 204.12.127.255 
	{ 0xcc0c8000, 0xcc0c8fff, REGISTRY_AFRINIC    }, // 204.12.128.0    - 204.12.143.255 
	{ 0xcc0c9000, 0xcc301fff, REGISTRY_ARIN       }, // 204.12.144.0    - 204.48.31.255  
	{ 0xcc302200, 0xcc34beff, REGISTRY_ARIN       }, // 204.48.34.0     - 204.52.190.255 
	{ 0xcc34c000, 0xcc3a87ff, REGISTRY_ARIN       }, // 204.52.192.0    - 204.58.135.255 
	{ 0xcc3a8800, 0xcc3a8bff, REGISTRY_LACNIC     }, // 204.58.136.0    - 204.58.139.255 
	{ 0xcc3a8c00, 0xcc4b8dff, REGISTRY_ARIN       }, // 204.58.140.0    - 204.75.141.255 
	{ 0xcc4b8e00, 0xcc4b8eff, REGISTRY_APNIC      }, // 204.75.142.0    - 204.75.142.255 
	{ 0xcc4b8f00, 0xcc508eff, REGISTRY_ARIN       }, // 204.75.143.0    - 204.80.142.255 
	{ 0xcc508f00, 0xcc508fff, REGISTRY_LACNIC     }, // 204.80.143.0    - 204.80.143.255 
	{ 0xcc509000, 0xcc57a8ff, REGISTRY_ARIN       }, // 204.80.144.0    - 204.87.168.255 
	{ 0xcc57a900, 0xcc57a9ff, REGISTRY_LACNIC     }, // 204.87.169.0    - 204.87.169.255 
	{ 0xcc57aa00, 0xcc57b2ff, REGISTRY_ARIN       }, // 204.87.170.0    - 204.87.178.255 
	{ 0xcc57b300, 0xcc57b3ff, REGISTRY_AFRINIC    }, // 204.87.179.0    - 204.87.179.255 
	{ 0xcc57b400, 0xcc57ccff, REGISTRY_ARIN       }, // 204.87.180.0    - 204.87.204.255 
	{ 0xcc57cd00, 0xcc57cdff, REGISTRY_LACNIC     }, // 204.87.205.0    - 204.87.205.255 
	{ 0xcc57ce00, 0xcc59cdff, REGISTRY_ARIN       }, // 204.87.206.0    - 204.89.205.255 
	{ 0xcc59ce00, 0xcc59ceff, REGISTRY_LACNIC     }, // 204.89.206.0    - 204.89.206.255 
	{ 0xcc59cf00, 0xcc7c67ff, REGISTRY_ARIN       }, // 204.89.207.0    - 204.124.103.255
	{ 0xcc7c6800, 0xcc7c6bff, REGISTRY_LACNIC     }, // 204.124.104.0   - 204.124.107.255
	{ 0xcc7c6c00, 0xcc7e0bff, REGISTRY_ARIN       }, // 204.124.108.0   - 204.126.11.255 
	{ 0xcc7e0c00, 0xcc7e0dff, REGISTRY_LACNIC     }, // 204.126.12.0    - 204.126.13.255 
	{ 0xcc7e0e00, 0xcc7e7fff, REGISTRY_ARIN       }, // 204.126.14.0    - 204.126.127.255
	{ 0xcc7e8000, 0xcc7e81ff, REGISTRY_LACNIC     }, // 204.126.128.0   - 204.126.129.255
	{ 0xcc7e8200, 0xcc7e8bff, REGISTRY_ARIN       }, // 204.126.130.0   - 204.126.139.255
	{ 0xcc7e8c00, 0xcc7e8dff, REGISTRY_LACNIC     }, // 204.126.140.0   - 204.126.141.255
	{ 0xcc7e8e00, 0xcc91c8ff, REGISTRY_ARIN       }, // 204.126.142.0   - 204.145.200.255
	{ 0xcc91c900, 0xcc91c9ff, REGISTRY_LACNIC     }, // 204.145.201.0   - 204.145.201.255
	{ 0xcc91ca00, 0xcc980dff, REGISTRY_ARIN       }, // 204.145.202.0   - 204.152.13.255 
	{ 0xcc980e00, 0xcc980fff, REGISTRY_AFRINIC    }, // 204.152.14.0    - 204.152.15.255 
	{ 0xcc981000, 0xcc9917ff, REGISTRY_ARIN       }, // 204.152.16.0    - 204.153.23.255 
	{ 0xcc991800, 0xcc9919ff, REGISTRY_LACNIC     }, // 204.153.24.0    - 204.153.25.255 
	{ 0xcc991a00, 0xcce129ff, REGISTRY_ARIN       }, // 204.153.26.0    - 204.225.41.255 
	{ 0xcce12c00, 0xcceb1fff, REGISTRY_ARIN       }, // 204.225.44.0    - 204.235.31.255 
	{ 0xcceb2000, 0xcceb2bff, REGISTRY_AFRINIC    }, // 204.235.32.0    - 204.235.43.255 
	{ 0xcceb2c00, 0xcd935fff, REGISTRY_ARIN       }, // 204.235.44.0    - 205.147.95.255 
	{ 0xcd936000, 0xcd936fff, REGISTRY_APNIC      }, // 205.147.96.0    - 205.147.111.255
	{ 0xcd937000, 0xcd9f4eff, REGISTRY_ARIN       }, // 205.147.112.0   - 205.159.78.255 
	{ 0xcd9f4f00, 0xcd9f4fff, REGISTRY_AFRINIC    }, // 205.159.79.0    - 205.159.79.255 
	{ 0xcd9f5000, 0xcda6b0ff, REGISTRY_ARIN       }, // 205.159.80.0    - 205.166.176.255
	{ 0xcda6b100, 0xcda6b1ff, REGISTRY_APNIC      }, // 205.166.177.0   - 205.166.177.255
	{ 0xcda6b200, 0xcda6faff, REGISTRY_ARIN       }, // 205.166.178.0   - 205.166.250.255
	{ 0xcda6fb00, 0xcda6fbff, REGISTRY_LACNIC     }, // 205.166.251.0   - 205.166.251.255
	{ 0xcda6fc00, 0xcdd352ff, REGISTRY_ARIN       }, // 205.166.252.0   - 205.211.82.255 
	{ 0xcdd35400, 0xce83bfff, REGISTRY_ARIN       }, // 205.211.84.0    - 206.131.191.255
	{ 0xce83c000, 0xce83cfff, REGISTRY_APNIC      }, // 206.131.192.0   - 206.131.207.255
	{ 0xce83d000, 0xcedd4fff, REGISTRY_ARIN       }, // 206.131.208.0   - 206.221.79.255 
	{ 0xcedd5000, 0xcedd5fff, REGISTRY_LACNIC     }, // 206.221.80.0    - 206.221.95.255 
	{ 0xcedd6000, 0xcedf7bff, REGISTRY_ARIN       }, // 206.221.96.0    - 206.223.123.255
	{ 0xcedf7c00, 0xcedf7cff, REGISTRY_LACNIC     }, // 206.223.124.0   - 206.223.124.255
	{ 0xcedf7d00, 0xcedf81ff, REGISTRY_ARIN       }, // 206.223.125.0   - 206.223.129.255
	{ 0xcedf8200, 0xcedf82ff, REGISTRY_LACNIC     }, // 206.223.130.0   - 206.223.130.255
	{ 0xcedf8300, 0xcedf87ff, REGISTRY_ARIN       }, // 206.223.131.0   - 206.223.135.255
	{ 0xcedf8800, 0xcedf88ff, REGISTRY_AFRINIC    }, // 206.223.136.0   - 206.223.136.255
	{ 0xcedf8900, 0xcee01fff, REGISTRY_ARIN       }, // 206.223.137.0   - 206.224.31.255 
	{ 0xcee02000, 0xcee03fff, REGISTRY_LACNIC     }, // 206.224.32.0    - 206.224.63.255 
	{ 0xcee04000, 0xcf736fff, REGISTRY_ARIN       }, // 206.224.64.0    - 207.115.111.255
	{ 0xcf738000, 0xcfbf9fff, REGISTRY_ARIN       }, // 207.115.128.0   - 207.191.159.255
	{ 0xcfbfb000, 0xcff7ffff, REGISTRY_ARIN       }, // 207.191.176.0   - 207.247.255.255
	{ 0xcff80000, 0xcff84fff, REGISTRY_LACNIC     }, // 207.248.0.0     - 207.248.79.255 
	{ 0xcff85200, 0xcff855ff, REGISTRY_LACNIC     }, // 207.248.82.0    - 207.248.85.255 
	{ 0xcff85800, 0xcff865ff, REGISTRY_LACNIC     }, // 207.248.88.0    - 207.248.101.255
	{ 0xcff86800, 0xcff869ff, REGISTRY_LACNIC     }, // 207.248.104.0   - 207.248.105.255
	{ 0xcff86c00, 0xcff873ff, REGISTRY_LACNIC     }, // 207.248.108.0   - 207.248.115.255
	{ 0xcff87600, 0xcff9ffff, REGISTRY_LACNIC     }, // 207.248.118.0   - 207.249.255.255
	{ 0xcffa0000, 0xd049efff, REGISTRY_ARIN       }, // 207.250.0.0     - 208.73.239.255 
	{ 0xd049f400, 0xd0559bff, REGISTRY_ARIN       }, // 208.73.244.0    - 208.85.155.255 
	{ 0xd055a000, 0xd10cffff, REGISTRY_ARIN       }, // 208.85.160.0    - 209.12.255.255 
	{ 0xd10d0000, 0xd10dffff, REGISTRY_LACNIC     }, // 209.13.0.0      - 209.13.255.255 
	{ 0xd10e0000, 0xd12cffff, REGISTRY_ARIN       }, // 209.14.0.0      - 209.44.255.255 
	{ 0xd12d0000, 0xd12d7fff, REGISTRY_LACNIC     }, // 209.45.0.0      - 209.45.127.255 
	{ 0xd12d8000, 0xd15ebfff, REGISTRY_ARIN       }, // 209.45.128.0    - 209.94.191.255 
	{ 0xd15ec000, 0xd15edfff, REGISTRY_LACNIC     }, // 209.94.192.0    - 209.94.223.255 
	{ 0xd15ee000, 0xd163dfff, REGISTRY_ARIN       }, // 209.94.224.0    - 209.99.223.255 
	{ 0xd163e000, 0xd163efff, REGISTRY_LACNIC     }, // 209.99.224.0    - 209.99.239.255 
	{ 0xd163f000, 0xd16b7fff, REGISTRY_ARIN       }, // 209.99.240.0    - 209.107.127.255
	{ 0xd16bc000, 0xd1caffff, REGISTRY_ARIN       }, // 209.107.192.0   - 209.202.255.255
	{ 0xd1cb0000, 0xd1cb3fff, REGISTRY_AFRINIC    }, // 209.203.0.0     - 209.203.63.255 
	{ 0xd1cb4000, 0xd1d45fff, REGISTRY_ARIN       }, // 209.203.64.0    - 209.212.95.255 
	{ 0xd1d46000, 0xd1d47fff, REGISTRY_AFRINIC    }, // 209.212.96.0    - 209.212.127.255
	{ 0xd1d48000, 0xd1ffffff, REGISTRY_ARIN       }, // 209.212.128.0   - 209.255.255.255
	{ 0xd2000000, 0xd20737ff, REGISTRY_APNIC      }, // 210.0.0.0       - 210.7.55.255   
	{ 0xd2074000, 0xd2103fff, REGISTRY_APNIC      }, // 210.7.64.0      - 210.16.63.255  
	{ 0xd2108000, 0xd24f7fff, REGISTRY_APNIC      }, // 210.16.128.0    - 210.79.127.255 
	{ 0xd24fc000, 0xd2573fff, REGISTRY_APNIC      }, // 210.79.192.0    - 210.87.63.255  
	{ 0xd2578000, 0xd3ffffff, REGISTRY_APNIC      }, // 210.87.128.0    - 211.255.255.255
	{ 0xd4000000, 0xd4007fff, REGISTRY_RIPENCC    }, // 212.0.0.0       - 212.0.127.255  
	{ 0xd4008000, 0xd4009fff, REGISTRY_AFRINIC    }, // 212.0.128.0     - 212.0.159.255  
	{ 0xd400a000, 0xd40cdfff, REGISTRY_RIPENCC    }, // 212.0.160.0     - 212.12.223.255 
	{ 0xd40ce000, 0xd40cffff, REGISTRY_AFRINIC    }, // 212.12.224.0    - 212.12.255.255 
	{ 0xd40d0000, 0xd4169fff, REGISTRY_RIPENCC    }, // 212.13.0.0      - 212.22.159.255 
	{ 0xd416a000, 0xd416bfff, REGISTRY_AFRINIC    }, // 212.22.160.0    - 212.22.191.255 
	{ 0xd416c000, 0xd427bfff, REGISTRY_RIPENCC    }, // 212.22.192.0    - 212.39.191.255 
	{ 0xd427c000, 0xd427dfff, REGISTRY_RIPENCC    }, // 212.39.192.0    - 212.39.223.255 
	{ 0xd427e000, 0xd4313fff, REGISTRY_RIPENCC    }, // 212.39.224.0    - 212.49.63.255  
	{ 0xd4314000, 0xd4315fff, REGISTRY_AFRINIC    }, // 212.49.64.0     - 212.49.95.255  
	{ 0xd4316000, 0xd4347fff, REGISTRY_RIPENCC    }, // 212.49.96.0     - 212.52.127.255 
	{ 0xd4348000, 0xd4349fff, REGISTRY_AFRINIC    }, // 212.52.128.0    - 212.52.159.255 
	{ 0xd434a000, 0xd43bffff, REGISTRY_RIPENCC    }, // 212.52.160.0    - 212.59.255.255 
	{ 0xd43c2000, 0xd43c3fff, REGISTRY_RIPENCC    }, // 212.60.32.0     - 212.60.63.255  
	{ 0xd43c4000, 0xd43c5fff, REGISTRY_AFRINIC    }, // 212.60.64.0     - 212.60.95.255  
	{ 0xd43c6000, 0xd450bfff, REGISTRY_RIPENCC    }, // 212.60.96.0     - 212.80.191.255 
	{ 0xd450e000, 0xd455bfff, REGISTRY_RIPENCC    }, // 212.80.224.0    - 212.85.191.255 
	{ 0xd455c000, 0xd455dfff, REGISTRY_AFRINIC    }, // 212.85.192.0    - 212.85.223.255 
	{ 0xd455e000, 0xd457bfff, REGISTRY_RIPENCC    }, // 212.85.224.0    - 212.87.191.255 
	{ 0xd457e000, 0xd4585fff, REGISTRY_RIPENCC    }, // 212.87.224.0    - 212.88.95.255  
	{ 0xd4586000, 0xd4587fff, REGISTRY_AFRINIC    }, // 212.88.96.0     - 212.88.127.255 
	{ 0xd4588000, 0xd45a5fff, REGISTRY_RIPENCC    }, // 212.88.128.0    - 212.90.95.255  
	{ 0xd45a8000, 0xd45fffff, REGISTRY_RIPENCC    }, // 212.90.128.0    - 212.95.255.255 
	{ 0xd4600000, 0xd4601fff, REGISTRY_AFRINIC    }, // 212.96.0.0      - 212.96.31.255  
	{ 0xd4602000, 0xd4643fff, REGISTRY_RIPENCC    }, // 212.96.32.0     - 212.100.63.255 
	{ 0xd4644000, 0xd4645fff, REGISTRY_AFRINIC    }, // 212.100.64.0    - 212.100.95.255 
	{ 0xd4646000, 0xd4671fff, REGISTRY_RIPENCC    }, // 212.100.96.0    - 212.103.31.255 
	{ 0xd4674000, 0xd4679fff, REGISTRY_RIPENCC    }, // 212.103.64.0    - 212.103.159.255
	{ 0xd467a000, 0xd467bfff, REGISTRY_AFRINIC    }, // 212.103.160.0   - 212.103.191.255
	{ 0xd467c000, 0xd46affff, REGISTRY_RIPENCC    }, // 212.103.192.0   - 212.106.255.255
	{ 0xd46b2000, 0xd4731fff, REGISTRY_RIPENCC    }, // 212.107.32.0    - 212.115.31.255 
	{ 0xd4734000, 0xd4735fff, REGISTRY_RIPENCC    }, // 212.115.64.0    - 212.115.95.255 
	{ 0xd4738000, 0xd4771fff, REGISTRY_RIPENCC    }, // 212.115.128.0   - 212.119.31.255 
	{ 0xd4774000, 0xd47adfff, REGISTRY_RIPENCC    }, // 212.119.64.0    - 212.122.223.255
	{ 0xd47ae000, 0xd47affff, REGISTRY_AFRINIC    }, // 212.122.224.0   - 212.122.255.255
	{ 0xd47b0000, 0xd4d8ffff, REGISTRY_RIPENCC    }, // 212.123.0.0     - 212.216.255.255
	{ 0xd4d90000, 0xd4d97fff, REGISTRY_AFRINIC    }, // 212.217.0.0     - 212.217.127.255
	{ 0xd4d98000, 0xd504ffff, REGISTRY_RIPENCC    }, // 212.217.128.0   - 213.4.255.255  
	{ 0xd5050000, 0xd505e7ff, REGISTRY_RIPENCC    }, // 213.5.0.0       - 213.5.231.255  
	{ 0xd505f000, 0xd505ffff, REGISTRY_RIPENCC    }, // 213.5.240.0     - 213.5.255.255  
	{ 0xd5060000, 0xd5373fff, REGISTRY_RIPENCC    }, // 213.6.0.0       - 213.55.63.255  
	{ 0xd5374000, 0xd5377fff, REGISTRY_AFRINIC    }, // 213.55.64.0     - 213.55.127.255 
	{ 0xd5378000, 0xd56bffff, REGISTRY_RIPENCC    }, // 213.55.128.0    - 213.107.255.255
	{ 0xd56c0000, 0xd56c2fff, REGISTRY_RIPENCC    }, // 213.108.0.0     - 213.108.47.255 
	{ 0xd56c3800, 0xd56cefff, REGISTRY_RIPENCC    }, // 213.108.56.0    - 213.108.239.255
	{ 0xd56cf800, 0xd56d9fff, REGISTRY_RIPENCC    }, // 213.108.248.0   - 213.109.159.255
	{ 0xd56db000, 0xd56fffff, REGISTRY_RIPENCC    }, // 213.109.176.0   - 213.111.255.255
	{ 0xd5700000, 0xd5833fff, REGISTRY_RIPENCC    }, // 213.112.0.0     - 213.131.63.255 
	{ 0xd5834000, 0xd5835fff, REGISTRY_AFRINIC    }, // 213.131.64.0    - 213.131.95.255 
	{ 0xd5836000, 0xd5885fff, REGISTRY_RIPENCC    }, // 213.131.96.0    - 213.136.95.255 
	{ 0xd5886000, 0xd5887fff, REGISTRY_AFRINIC    }, // 213.136.96.0    - 213.136.127.255
	{ 0xd5888000, 0xd5933fff, REGISTRY_RIPENCC    }, // 213.136.128.0   - 213.147.63.255 
	{ 0xd5934000, 0xd5935fff, REGISTRY_AFRINIC    }, // 213.147.64.0    - 213.147.95.255 
	{ 0xd5936000, 0xd5965fff, REGISTRY_RIPENCC    }, // 213.147.96.0    - 213.150.95.255 
	{ 0xd5966000, 0xd5967fff, REGISTRY_AFRINIC    }, // 213.150.96.0    - 213.150.127.255
	{ 0xd5968000, 0xd5969fff, REGISTRY_RIPENCC    }, // 213.150.128.0   - 213.150.159.255
	{ 0xd596a000, 0xd596bfff, REGISTRY_AFRINIC    }, // 213.150.160.0   - 213.150.191.255
	{ 0xd596e000, 0xd5983fff, REGISTRY_RIPENCC    }, // 213.150.224.0   - 213.152.63.255 
	{ 0xd5984000, 0xd5985fff, REGISTRY_AFRINIC    }, // 213.152.64.0    - 213.152.95.255 
	{ 0xd5986000, 0xd59a1fff, REGISTRY_RIPENCC    }, // 213.152.96.0    - 213.154.31.255 
	{ 0xd59a2000, 0xd59a5fff, REGISTRY_AFRINIC    }, // 213.154.32.0    - 213.154.95.255 
	{ 0xd59a6000, 0xd59e9fff, REGISTRY_RIPENCC    }, // 213.154.96.0    - 213.158.159.255
	{ 0xd59ea000, 0xd59ebfff, REGISTRY_AFRINIC    }, // 213.158.160.0   - 213.158.191.255
	{ 0xd59ec000, 0xd5a29fff, REGISTRY_RIPENCC    }, // 213.158.192.0   - 213.162.159.255
	{ 0xd5a2a000, 0xd5a2bfff, REGISTRY_RIPENCC    }, // 213.162.160.0   - 213.162.191.255
	{ 0xd5a2c000, 0xd5aabfff, REGISTRY_RIPENCC    }, // 213.162.192.0   - 213.170.191.255
	{ 0xd5aae000, 0xd5ac7fff, REGISTRY_RIPENCC    }, // 213.170.224.0   - 213.172.127.255
	{ 0xd5aca000, 0xd5ad1fff, REGISTRY_RIPENCC    }, // 213.172.160.0   - 213.173.31.255 
	{ 0xd5ad4000, 0xd5b39fff, REGISTRY_RIPENCC    }, // 213.173.64.0    - 213.179.159.255
	{ 0xd5b3a000, 0xd5b3bfff, REGISTRY_AFRINIC    }, // 213.179.160.0   - 213.179.191.255
	{ 0xd5b3c000, 0xd5b5dfff, REGISTRY_RIPENCC    }, // 213.179.192.0   - 213.181.223.255
	{ 0xd5b5e000, 0xd5b5ffff, REGISTRY_AFRINIC    }, // 213.181.224.0   - 213.181.255.255
	{ 0xd5b60000, 0xd5b83fff, REGISTRY_RIPENCC    }, // 213.182.0.0     - 213.184.63.255 
	{ 0xd5b86000, 0xd5c11fff, REGISTRY_RIPENCC    }, // 213.184.96.0    - 213.193.31.255 
	{ 0xd5c12000, 0xd5c13fff, REGISTRY_AFRINIC    }, // 213.193.32.0    - 213.193.63.255 
	{ 0xd5c14000, 0xd5d4bfff, REGISTRY_RIPENCC    }, // 213.193.64.0    - 213.212.191.255
	{ 0xd5d4c000, 0xd5d4ffff, REGISTRY_AFRINIC    }, // 213.212.192.0   - 213.212.255.255
	{ 0xd5d50000, 0xd5d8ffff, REGISTRY_RIPENCC    }, // 213.213.0.0     - 213.216.255.255
	{ 0xd5d92000, 0xd5e23fff, REGISTRY_RIPENCC    }, // 213.217.32.0    - 213.226.63.255 
	{ 0xd5e28000, 0xd5f6ffff, REGISTRY_RIPENCC    }, // 213.226.128.0   - 213.246.255.255
	{ 0xd5f70000, 0xd5f71fff, REGISTRY_AFRINIC    }, // 213.247.0.0     - 213.247.31.255 
	{ 0xd5f72000, 0xd5ff7fff, REGISTRY_RIPENCC    }, // 213.247.32.0    - 213.255.127.255
	{ 0xd5ffa000, 0xd5ffffff, REGISTRY_RIPENCC    }, // 213.255.160.0   - 213.255.255.255
	{ 0xd6000000, 0xd807ffff, REGISTRY_ARIN       }, // 214.0.0.0       - 216.7.255.255  
	{ 0xd8080000, 0xd8081fff, REGISTRY_APNIC      }, // 216.8.0.0       - 216.8.31.255   
	{ 0xd8081000, 0xd862cfff, REGISTRY_ARIN       }, // 216.8.16.0      - 216.98.207.255 
	{ 0xd862e000, 0xd897bfff, REGISTRY_ARIN       }, // 216.98.224.0    - 216.151.191.255
	{ 0xd897c000, 0xd897cfff, REGISTRY_APNIC      }, // 216.151.192.0   - 216.151.207.255
	{ 0xd897d000, 0xd8989fff, REGISTRY_ARIN       }, // 216.151.208.0   - 216.152.159.255
	{ 0xd898a000, 0xd898afff, REGISTRY_LACNIC     }, // 216.152.160.0   - 216.152.175.255
	{ 0xd898b000, 0xd89b3fff, REGISTRY_ARIN       }, // 216.152.176.0   - 216.155.63.255 
	{ 0xd89b4000, 0xd89b5fff, REGISTRY_LACNIC     }, // 216.155.64.0    - 216.155.95.255 
	{ 0xd89b6000, 0xd8e67fff, REGISTRY_ARIN       }, // 216.155.96.0    - 216.230.127.255
	{ 0xd8e68000, 0xd8e69fff, REGISTRY_LACNIC     }, // 216.230.128.0   - 216.230.159.255
	{ 0xd8e6a000, 0xd8ecafff, REGISTRY_ARIN       }, // 216.230.160.0   - 216.236.175.255
	{ 0xd8ecb000, 0xd8ecbfff, REGISTRY_AFRINIC    }, // 216.236.176.0   - 216.236.191.255
	{ 0xd8ecc000, 0xd8f0ffff, REGISTRY_ARIN       }, // 216.236.192.0   - 216.240.255.255
	{ 0xd8f10000, 0xd8f11fff, REGISTRY_LACNIC     }, // 216.241.0.0     - 216.241.31.255 
	{ 0xd8f12000, 0xd8f47fff, REGISTRY_ARIN       }, // 216.241.32.0    - 216.244.127.255
	{ 0xd8f48000, 0xd8f4ffff, REGISTRY_LACNIC     }, // 216.244.128.0   - 216.244.255.255
	{ 0xd8f50000, 0xd8fa5fff, REGISTRY_ARIN       }, // 216.245.0.0     - 216.250.95.255 
	{ 0xd8fa7000, 0xd8ffffff, REGISTRY_ARIN       }, // 216.250.112.0   - 216.255.255.255
	{ 0xd9000000, 0xd9086fff, REGISTRY_RIPENCC    }, // 217.0.0.0       - 217.8.111.255  
	{ 0xd9088000, 0xd9090fff, REGISTRY_RIPENCC    }, // 217.8.128.0     - 217.9.15.255   
	{ 0xd9092000, 0xd90e4fff, REGISTRY_RIPENCC    }, // 217.9.32.0      - 217.14.79.255  
	{ 0xd90e5000, 0xd90e5fff, REGISTRY_AFRINIC    }, // 217.14.80.0     - 217.14.95.255  
	{ 0xd90e6000, 0xd914dfff, REGISTRY_RIPENCC    }, // 217.14.96.0     - 217.20.223.255 
	{ 0xd914e000, 0xd914efff, REGISTRY_AFRINIC    }, // 217.20.224.0    - 217.20.239.255 
	{ 0xd914f000, 0xd9156fff, REGISTRY_RIPENCC    }, // 217.20.240.0    - 217.21.111.255 
	{ 0xd9157000, 0xd9157fff, REGISTRY_AFRINIC    }, // 217.21.112.0    - 217.21.127.255 
	{ 0xd9158000, 0xd91d7fff, REGISTRY_RIPENCC    }, // 217.21.128.0    - 217.29.127.255 
	{ 0xd91d9000, 0xd91dcfff, REGISTRY_RIPENCC    }, // 217.29.144.0    - 217.29.207.255 
	{ 0xd91de000, 0xd933ffff, REGISTRY_RIPENCC    }, // 217.29.224.0    - 217.51.255.255 
	{ 0xd9340000, 0xd937ffff, REGISTRY_AFRINIC    }, // 217.52.0.0      - 217.55.255.255 
	{ 0xd9380000, 0xd9405fff, REGISTRY_RIPENCC    }, // 217.56.0.0      - 217.64.95.255  
	{ 0xd9406000, 0xd9406fff, REGISTRY_AFRINIC    }, // 217.64.96.0     - 217.64.111.255 
	{ 0xd9407000, 0xd9421fff, REGISTRY_RIPENCC    }, // 217.64.112.0    - 217.66.31.255  
	{ 0xd9422000, 0xd9423fff, REGISTRY_RIPENCC    }, // 217.66.32.0     - 217.66.63.255  
	{ 0xd9424000, 0xd9477fff, REGISTRY_RIPENCC    }, // 217.66.64.0     - 217.71.127.255 
	{ 0xd9478000, 0xd9479fff, REGISTRY_RIPENCC    }, // 217.71.128.0    - 217.71.159.255 
	{ 0xd947a000, 0xd94d3fff, REGISTRY_RIPENCC    }, // 217.71.160.0    - 217.77.63.255  
	{ 0xd94d4000, 0xd94d4fff, REGISTRY_AFRINIC    }, // 217.77.64.0     - 217.77.79.255  
	{ 0xd94d5000, 0xd94ddfff, REGISTRY_RIPENCC    }, // 217.77.80.0     - 217.77.223.255 
	{ 0xd94de000, 0xd94defff, REGISTRY_RIPENCC    }, // 217.77.224.0    - 217.77.239.255 
	{ 0xd94df000, 0xd94e3fff, REGISTRY_RIPENCC    }, // 217.77.240.0    - 217.78.63.255  
	{ 0xd94e5000, 0xd974ffff, REGISTRY_RIPENCC    }, // 217.78.80.0     - 217.116.255.255
	{ 0xd9750000, 0xd9750fff, REGISTRY_AFRINIC    }, // 217.117.0.0     - 217.117.15.255 
	{ 0xd9751000, 0xd98affff, REGISTRY_RIPENCC    }, // 217.117.16.0    - 217.138.255.255
	{ 0xd98b0000, 0xd98bffff, REGISTRY_AFRINIC    }, // 217.139.0.0     - 217.139.255.255
	{ 0xd98c0000, 0xd991dfff, REGISTRY_RIPENCC    }, // 217.140.0.0     - 217.145.223.255
	{ 0xd991f000, 0xd9947fff, REGISTRY_RIPENCC    }, // 217.145.240.0   - 217.148.127.255
	{ 0xd9949000, 0xd997bfff, REGISTRY_RIPENCC    }, // 217.148.144.0   - 217.151.191.255
	{ 0xd997c000, 0xd997dfff, REGISTRY_RIPENCC    }, // 217.151.192.0   - 217.151.223.255
	{ 0xd997e000, 0xd9aa8fff, REGISTRY_RIPENCC    }, // 217.151.224.0   - 217.170.143.255
	{ 0xd9aa9000, 0xd9aa9fff, REGISTRY_AFRINIC    }, // 217.170.144.0   - 217.170.159.255
	{ 0xd9aaa000, 0xd9ad9fff, REGISTRY_RIPENCC    }, // 217.170.160.0   - 217.173.159.255
	{ 0xd9ada000, 0xd9adbfff, REGISTRY_RIPENCC    }, // 217.173.160.0   - 217.173.191.255
	{ 0xd9adc000, 0xd9c54fff, REGISTRY_RIPENCC    }, // 217.173.192.0   - 217.197.79.255 
	{ 0xd9c55000, 0xd9c55fff, REGISTRY_RIPENCC    }, // 217.197.80.0    - 217.197.95.255 
	{ 0xd9c56000, 0xd9c78fff, REGISTRY_RIPENCC    }, // 217.197.96.0    - 217.199.143.255
	{ 0xd9c79000, 0xd9c79fff, REGISTRY_AFRINIC    }, // 217.199.144.0   - 217.199.159.255
	{ 0xd9c7a000, 0xd9ffffff, REGISTRY_RIPENCC    }, // 217.199.160.0   - 217.255.255.255
	{ 0xda000000, 0xda6413ff, REGISTRY_APNIC      }, // 218.0.0.0       - 218.100.19.255 
	{ 0xda641500, 0xda6432ff, REGISTRY_APNIC      }, // 218.100.21.0    - 218.100.50.255 
	{ 0xda643400, 0xda6443ff, REGISTRY_APNIC      }, // 218.100.52.0    - 218.100.67.255 
	{ 0xda644500, 0xda6445ff, REGISTRY_APNIC      }, // 218.100.69.0    - 218.100.69.255 
	{ 0xda644700, 0xdab9f7ff, REGISTRY_APNIC      }, // 218.100.71.0    - 218.185.247.255
	{ 0xdaba0000, 0xdb5a3fff, REGISTRY_APNIC      }, // 218.186.0.0     - 219.90.63.255  
	{ 0xdb5a5000, 0xdc9e7fff, REGISTRY_APNIC      }, // 219.90.80.0     - 220.158.127.255
	{ 0xdc9f0000, 0xdcf77fff, REGISTRY_APNIC      }, // 220.159.0.0     - 220.247.127.255
	{ 0xdcf78800, 0xdf19fbff, REGISTRY_APNIC      }, // 220.247.136.0   - 223.25.251.255 
	{ 0xdf1a0000, 0xdf1dcfff, REGISTRY_APNIC      }, // 223.26.0.0      - 223.29.207.255 
	{ 0xdf1de000, 0xdf1dfbff, REGISTRY_APNIC      }, // 223.29.224.0    - 223.29.251.255 
	{ 0xdf1e0000, 0xdf8207ff, REGISTRY_APNIC      }, // 223.30.0.0      - 223.130.7.255  
	{ 0xdf820c00, 0xdf820fff, REGISTRY_APNIC      }, // 223.130.12.0    - 223.130.15.255 
	{ 0xdf821400, 0xdf821bff, REGISTRY_APNIC      }, // 223.130.20.0    - 223.130.27.255 
	{ 0xdf822000, 0xdffff7ff, REGISTRY_APNIC      }, // 223.130.32.0    - 223.255.247.255
	{ 0xdffffc00, 0xdfffffff, REGISTRY_APNIC      }, // 223.255.252.0   - 223.255.255.255
};

static const s_ipv4addr_assignment dbipv4addr_assignment_iana[] = {
	//first     , last      , registry  
	{ 0x00000000, 0x00ffffff, REGISTRY_IANA       }, // 0.0.0.0         - 0.255.255.255  
	{ 0x01000000, 0x01ffffff, REGISTRY_APNIC      }, // 1.0.0.0         - 1.255.255.255  
	{ 0x02000000, 0x02ffffff, REGISTRY_RIPENCC    }, // 2.0.0.0         - 2.255.255.255  
	{ 0x03000000, 0x03ffffff, REGISTRY_ARIN       }, // 3.0.0.0         - 3.255.255.255  
	{ 0x04000000, 0x04ffffff, REGISTRY_ARIN       }, // 4.0.0.0         - 4.255.255.255  
	{ 0x05000000, 0x05ffffff, REGISTRY_RIPENCC    }, // 5.0.0.0         - 5.255.255.255  
	{ 0x06000000, 0x06ffffff, REGISTRY_ARIN       }, // 6.0.0.0         - 6.255.255.255  
	{ 0x07000000, 0x07ffffff, REGISTRY_ARIN       }, // 7.0.0.0         - 7.255.255.255  
	{ 0x08000000, 0x08ffffff, REGISTRY_ARIN       }, // 8.0.0.0         - 8.255.255.255  
	{ 0x09000000, 0x09ffffff, REGISTRY_ARIN       }, // 9.0.0.0         - 9.255.255.255  
	{ 0x0a000000, 0x0affffff, REGISTRY_IANA       }, // 10.0.0.0        - 10.255.255.255 
	{ 0x0b000000, 0x0bffffff, REGISTRY_ARIN       }, // 11.0.0.0        - 11.255.255.255 
	{ 0x0c000000, 0x0cffffff, REGISTRY_ARIN       }, // 12.0.0.0        - 12.255.255.255 
	{ 0x0d000000, 0x0dffffff, REGISTRY_ARIN       }, // 13.0.0.0        - 13.255.255.255 
	{ 0x0e000000, 0x0effffff, REGISTRY_APNIC      }, // 14.0.0.0        - 14.255.255.255 
	{ 0x0f000000, 0x0fffffff, REGISTRY_ARIN       }, // 15.0.0.0        - 15.255.255.255 
	{ 0x10000000, 0x10ffffff, REGISTRY_ARIN       }, // 16.0.0.0        - 16.255.255.255 
	{ 0x11000000, 0x11ffffff, REGISTRY_ARIN       }, // 17.0.0.0        - 17.255.255.255 
	{ 0x12000000, 0x12ffffff, REGISTRY_ARIN       }, // 18.0.0.0        - 18.255.255.255 
	{ 0x13000000, 0x13ffffff, REGISTRY_ARIN       }, // 19.0.0.0        - 19.255.255.255 
	{ 0x14000000, 0x14ffffff, REGISTRY_ARIN       }, // 20.0.0.0        - 20.255.255.255 
	{ 0x15000000, 0x15ffffff, REGISTRY_ARIN       }, // 21.0.0.0        - 21.255.255.255 
	{ 0x16000000, 0x16ffffff, REGISTRY_ARIN       }, // 22.0.0.0        - 22.255.255.255 
	{ 0x17000000, 0x17ffffff, REGISTRY_ARIN       }, // 23.0.0.0        - 23.255.255.255 
	{ 0x18000000, 0x18ffffff, REGISTRY_ARIN       }, // 24.0.0.0        - 24.255.255.255 
	{ 0x19000000, 0x19ffffff, REGISTRY_RIPENCC    }, // 25.0.0.0        - 25.255.255.255 
	{ 0x1a000000, 0x1affffff, REGISTRY_ARIN       }, // 26.0.0.0        - 26.255.255.255 
	{ 0x1b000000, 0x1bffffff, REGISTRY_APNIC      }, // 27.0.0.0        - 27.255.255.255 
	{ 0x1c000000, 0x1cffffff, REGISTRY_ARIN       }, // 28.0.0.0        - 28.255.255.255 
	{ 0x1d000000, 0x1dffffff, REGISTRY_ARIN       }, // 29.0.0.0        - 29.255.255.255 
	{ 0x1e000000, 0x1effffff, REGISTRY_ARIN       }, // 30.0.0.0        - 30.255.255.255 
	{ 0x1f000000, 0x1fffffff, REGISTRY_RIPENCC    }, // 31.0.0.0        - 31.255.255.255 
	{ 0x20000000, 0x20ffffff, REGISTRY_ARIN       }, // 32.0.0.0        - 32.255.255.255 
	{ 0x21000000, 0x21ffffff, REGISTRY_ARIN       }, // 33.0.0.0        - 33.255.255.255 
	{ 0x22000000, 0x22ffffff, REGISTRY_ARIN       }, // 34.0.0.0        - 34.255.255.255 
	{ 0x23000000, 0x23ffffff, REGISTRY_ARIN       }, // 35.0.0.0        - 35.255.255.255 
	{ 0x24000000, 0x24ffffff, REGISTRY_APNIC      }, // 36.0.0.0        - 36.255.255.255 
	{ 0x25000000, 0x25ffffff, REGISTRY_RIPENCC    }, // 37.0.0.0        - 37.255.255.255 
	{ 0x26000000, 0x26ffffff, REGISTRY_ARIN       }, // 38.0.0.0        - 38.255.255.255 
	{ 0x27000000, 0x27ffffff, REGISTRY_APNIC      }, // 39.0.0.0        - 39.255.255.255 
	{ 0x28000000, 0x28ffffff, REGISTRY_ARIN       }, // 40.0.0.0        - 40.255.255.255 
	{ 0x29000000, 0x29ffffff, REGISTRY_AFRINIC    }, // 41.0.0.0        - 41.255.255.255 
	{ 0x2a000000, 0x2affffff, REGISTRY_APNIC      }, // 42.0.0.0        - 42.255.255.255 
	{ 0x2b000000, 0x2bffffff, REGISTRY_APNIC      }, // 43.0.0.0        - 43.255.255.255 
	{ 0x2c000000, 0x2cffffff, REGISTRY_ARIN       }, // 44.0.0.0        - 44.255.255.255 
	{ 0x2d000000, 0x2dffffff, REGISTRY_ARIN       }, // 45.0.0.0        - 45.255.255.255 
	{ 0x2e000000, 0x2effffff, REGISTRY_RIPENCC    }, // 46.0.0.0        - 46.255.255.255 
	{ 0x2f000000, 0x2fffffff, REGISTRY_ARIN       }, // 47.0.0.0        - 47.255.255.255 
	{ 0x30000000, 0x30ffffff, REGISTRY_ARIN       }, // 48.0.0.0        - 48.255.255.255 
	{ 0x31000000, 0x31ffffff, REGISTRY_APNIC      }, // 49.0.0.0        - 49.255.255.255 
	{ 0x32000000, 0x32ffffff, REGISTRY_ARIN       }, // 50.0.0.0        - 50.255.255.255 
	{ 0x33000000, 0x33ffffff, REGISTRY_RIPENCC    }, // 51.0.0.0        - 51.255.255.255 
	{ 0x34000000, 0x34ffffff, REGISTRY_ARIN       }, // 52.0.0.0        - 52.255.255.255 
	{ 0x35000000, 0x35ffffff, REGISTRY_ARIN       }, // 53.0.0.0        - 53.255.255.255 
	{ 0x36000000, 0x36ffffff, REGISTRY_ARIN       }, // 54.0.0.0        - 54.255.255.255 
	{ 0x37000000, 0x37ffffff, REGISTRY_ARIN       }, // 55.0.0.0        - 55.255.255.255 
	{ 0x38000000, 0x38ffffff, REGISTRY_ARIN       }, // 56.0.0.0        - 56.255.255.255 
	{ 0x39000000, 0x39ffffff, REGISTRY_ARIN       }, // 57.0.0.0        - 57.255.255.255 
	{ 0x3a000000, 0x3affffff, REGISTRY_APNIC      }, // 58.0.0.0        - 58.255.255.255 
	{ 0x3b000000, 0x3bffffff, REGISTRY_APNIC      }, // 59.0.0.0        - 59.255.255.255 
	{ 0x3c000000, 0x3cffffff, REGISTRY_APNIC      }, // 60.0.0.0        - 60.255.255.255 
	{ 0x3d000000, 0x3dffffff, REGISTRY_APNIC      }, // 61.0.0.0        - 61.255.255.255 
	{ 0x3e000000, 0x3effffff, REGISTRY_RIPENCC    }, // 62.0.0.0        - 62.255.255.255 
	{ 0x3f000000, 0x3fffffff, REGISTRY_ARIN       }, // 63.0.0.0        - 63.255.255.255 
	{ 0x40000000, 0x40ffffff, REGISTRY_ARIN       }, // 64.0.0.0        - 64.255.255.255 
	{ 0x41000000, 0x41ffffff, REGISTRY_ARIN       }, // 65.0.0.0        - 65.255.255.255 
	{ 0x42000000, 0x42ffffff, REGISTRY_ARIN       }, // 66.0.0.0        - 66.255.255.255 
	{ 0x43000000, 0x43ffffff, REGISTRY_ARIN       }, // 67.0.0.0        - 67.255.255.255 
	{ 0x44000000, 0x44ffffff, REGISTRY_ARIN       }, // 68.0.0.0        - 68.255.255.255 
	{ 0x45000000, 0x45ffffff, REGISTRY_ARIN       }, // 69.0.0.0        - 69.255.255.255 
	{ 0x46000000, 0x46ffffff, REGISTRY_ARIN       }, // 70.0.0.0        - 70.255.255.255 
	{ 0x47000000, 0x47ffffff, REGISTRY_ARIN       }, // 71.0.0.0        - 71.255.255.255 
	{ 0x48000000, 0x48ffffff, REGISTRY_ARIN       }, // 72.0.0.0        - 72.255.255.255 
	{ 0x49000000, 0x49ffffff, REGISTRY_ARIN       }, // 73.0.0.0        - 73.255.255.255 
	{ 0x4a000000, 0x4affffff, REGISTRY_ARIN       }, // 74.0.0.0        - 74.255.255.255 
	{ 0x4b000000, 0x4bffffff, REGISTRY_ARIN       }, // 75.0.0.0        - 75.255.255.255 
	{ 0x4c000000, 0x4cffffff, REGISTRY_ARIN       }, // 76.0.0.0        - 76.255.255.255 
	{ 0x4d000000, 0x4dffffff, REGISTRY_RIPENCC    }, // 77.0.0.0        - 77.255.255.255 
	{ 0x4e000000, 0x4effffff, REGISTRY_RIPENCC    }, // 78.0.0.0        - 78.255.255.255 
	{ 0x4f000000, 0x4fffffff, REGISTRY_RIPENCC    }, // 79.0.0.0        - 79.255.255.255 
	{ 0x50000000, 0x50ffffff, REGISTRY_RIPENCC    }, // 80.0.0.0        - 80.255.255.255 
	{ 0x51000000, 0x51ffffff, REGISTRY_RIPENCC    }, // 81.0.0.0        - 81.255.255.255 
	{ 0x52000000, 0x52ffffff, REGISTRY_RIPENCC    }, // 82.0.0.0        - 82.255.255.255 
	{ 0x53000000, 0x53ffffff, REGISTRY_RIPENCC    }, // 83.0.0.0        - 83.255.255.255 
	{ 0x54000000, 0x54ffffff, REGISTRY_RIPENCC    }, // 84.0.0.0        - 84.255.255.255 
	{ 0x55000000, 0x55ffffff, REGISTRY_RIPENCC    }, // 85.0.0.0        - 85.255.255.255 
	{ 0x56000000, 0x56ffffff, REGISTRY_RIPENCC    }, // 86.0.0.0        - 86.255.255.255 
	{ 0x57000000, 0x57ffffff, REGISTRY_RIPENCC    }, // 87.0.0.0        - 87.255.255.255 
	{ 0x58000000, 0x58ffffff, REGISTRY_RIPENCC    }, // 88.0.0.0        - 88.255.255.255 
	{ 0x59000000, 0x59ffffff, REGISTRY_RIPENCC    }, // 89.0.0.0        - 89.255.255.255 
	{ 0x5a000000, 0x5affffff, REGISTRY_RIPENCC    }, // 90.0.0.0        - 90.255.255.255 
	{ 0x5b000000, 0x5bffffff, REGISTRY_RIPENCC    }, // 91.0.0.0        - 91.255.255.255 
	{ 0x5c000000, 0x5cffffff, REGISTRY_RIPENCC    }, // 92.0.0.0        - 92.255.255.255 
	{ 0x5d000000, 0x5dffffff, REGISTRY_RIPENCC    }, // 93.0.0.0        - 93.255.255.255 
	{ 0x5e000000, 0x5effffff, REGISTRY_RIPENCC    }, // 94.0.0.0        - 94.255.255.255 
	{ 0x5f000000, 0x5fffffff, REGISTRY_RIPENCC    }, // 95.0.0.0        - 95.255.255.255 
	{ 0x60000000, 0x60ffffff, REGISTRY_ARIN       }, // 96.0.0.0        - 96.255.255.255 
	{ 0x61000000, 0x61ffffff, REGISTRY_ARIN       }, // 97.0.0.0        - 97.255.255.255 
	{ 0x62000000, 0x62ffffff, REGISTRY_ARIN       }, // 98.0.0.0        - 98.255.255.255 
	{ 0x63000000, 0x63ffffff, REGISTRY_ARIN       }, // 99.0.0.0        - 99.255.255.255 
	{ 0x64000000, 0x64ffffff, REGISTRY_ARIN       }, // 100.0.0.0       - 100.255.255.255
	{ 0x65000000, 0x65ffffff, REGISTRY_APNIC      }, // 101.0.0.0       - 101.255.255.255
	{ 0x66000000, 0x66ffffff, REGISTRY_AFRINIC    }, // 102.0.0.0       - 102.255.255.255
	{ 0x67000000, 0x67ffffff, REGISTRY_APNIC      }, // 103.0.0.0       - 103.255.255.255
	{ 0x68000000, 0x68ffffff, REGISTRY_ARIN       }, // 104.0.0.0       - 104.255.255.255
	{ 0x69000000, 0x69ffffff, REGISTRY_AFRINIC    }, // 105.0.0.0       - 105.255.255.255
	{ 0x6a000000, 0x6affffff, REGISTRY_APNIC      }, // 106.0.0.0       - 106.255.255.255
	{ 0x6b000000, 0x6bffffff, REGISTRY_ARIN       }, // 107.0.0.0       - 107.255.255.255
	{ 0x6c000000, 0x6cffffff, REGISTRY_ARIN       }, // 108.0.0.0       - 108.255.255.255
	{ 0x6d000000, 0x6dffffff, REGISTRY_RIPENCC    }, // 109.0.0.0       - 109.255.255.255
	{ 0x6e000000, 0x6effffff, REGISTRY_APNIC      }, // 110.0.0.0       - 110.255.255.255
	{ 0x6f000000, 0x6fffffff, REGISTRY_APNIC      }, // 111.0.0.0       - 111.255.255.255
	{ 0x70000000, 0x70ffffff, REGISTRY_APNIC      }, // 112.0.0.0       - 112.255.255.255
	{ 0x71000000, 0x71ffffff, REGISTRY_APNIC      }, // 113.0.0.0       - 113.255.255.255
	{ 0x72000000, 0x72ffffff, REGISTRY_APNIC      }, // 114.0.0.0       - 114.255.255.255
	{ 0x73000000, 0x73ffffff, REGISTRY_APNIC      }, // 115.0.0.0       - 115.255.255.255
	{ 0x74000000, 0x74ffffff, REGISTRY_APNIC      }, // 116.0.0.0       - 116.255.255.255
	{ 0x75000000, 0x75ffffff, REGISTRY_APNIC      }, // 117.0.0.0       - 117.255.255.255
	{ 0x76000000, 0x76ffffff, REGISTRY_APNIC      }, // 118.0.0.0       - 118.255.255.255
	{ 0x77000000, 0x77ffffff, REGISTRY_APNIC      }, // 119.0.0.0       - 119.255.255.255
	{ 0x78000000, 0x78ffffff, REGISTRY_APNIC      }, // 120.0.0.0       - 120.255.255.255
	{ 0x79000000, 0x79ffffff, REGISTRY_APNIC      }, // 121.0.0.0       - 121.255.255.255
	{ 0x7a000000, 0x7affffff, REGISTRY_APNIC      }, // 122.0.0.0       - 122.255.255.255
	{ 0x7b000000, 0x7bffffff, REGISTRY_APNIC      }, // 123.0.0.0       - 123.255.255.255
	{ 0x7c000000, 0x7cffffff, REGISTRY_APNIC      }, // 124.0.0.0       - 124.255.255.255
	{ 0x7d000000, 0x7dffffff, REGISTRY_APNIC      }, // 125.0.0.0       - 125.255.255.255
	{ 0x7e000000, 0x7effffff, REGISTRY_APNIC      }, // 126.0.0.0       - 126.255.255.255
	{ 0x7f000000, 0x7fffffff, REGISTRY_IANA       }, // 127.0.0.0       - 127.255.255.255
	{ 0x80000000, 0x80ffffff, REGISTRY_ARIN       }, // 128.0.0.0       - 128.255.255.255
	{ 0x81000000, 0x81ffffff, REGISTRY_ARIN       }, // 129.0.0.0       - 129.255.255.255
	{ 0x82000000, 0x82ffffff, REGISTRY_ARIN       }, // 130.0.0.0       - 130.255.255.255
	{ 0x83000000, 0x83ffffff, REGISTRY_ARIN       }, // 131.0.0.0       - 131.255.255.255
	{ 0x84000000, 0x84ffffff, REGISTRY_ARIN       }, // 132.0.0.0       - 132.255.255.255
	{ 0x85000000, 0x85ffffff, REGISTRY_APNIC      }, // 133.0.0.0       - 133.255.255.255
	{ 0x86000000, 0x86ffffff, REGISTRY_ARIN       }, // 134.0.0.0       - 134.255.255.255
	{ 0x87000000, 0x87ffffff, REGISTRY_ARIN       }, // 135.0.0.0       - 135.255.255.255
	{ 0x88000000, 0x88ffffff, REGISTRY_ARIN       }, // 136.0.0.0       - 136.255.255.255
	{ 0x89000000, 0x89ffffff, REGISTRY_ARIN       }, // 137.0.0.0       - 137.255.255.255
	{ 0x8a000000, 0x8affffff, REGISTRY_ARIN       }, // 138.0.0.0       - 138.255.255.255
	{ 0x8b000000, 0x8bffffff, REGISTRY_ARIN       }, // 139.0.0.0       - 139.255.255.255
	{ 0x8c000000, 0x8cffffff, REGISTRY_ARIN       }, // 140.0.0.0       - 140.255.255.255
	{ 0x8d000000, 0x8dffffff, REGISTRY_RIPENCC    }, // 141.0.0.0       - 141.255.255.255
	{ 0x8e000000, 0x8effffff, REGISTRY_ARIN       }, // 142.0.0.0       - 142.255.255.255
	{ 0x8f000000, 0x8fffffff, REGISTRY_ARIN       }, // 143.0.0.0       - 143.255.255.255
	{ 0x90000000, 0x90ffffff, REGISTRY_ARIN       }, // 144.0.0.0       - 144.255.255.255
	{ 0x91000000, 0x91ffffff, REGISTRY_RIPENCC    }, // 145.0.0.0       - 145.255.255.255
	{ 0x92000000, 0x92ffffff, REGISTRY_ARIN       }, // 146.0.0.0       - 146.255.255.255
	{ 0x93000000, 0x93ffffff, REGISTRY_ARIN       }, // 147.0.0.0       - 147.255.255.255
	{ 0x94000000, 0x94ffffff, REGISTRY_ARIN       }, // 148.0.0.0       - 148.255.255.255
	{ 0x95000000, 0x95ffffff, REGISTRY_ARIN       }, // 149.0.0.0       - 149.255.255.255
	{ 0x96000000, 0x96ffffff, REGISTRY_APNIC      }, // 150.0.0.0       - 150.255.255.255
	{ 0x97000000, 0x97ffffff, REGISTRY_RIPENCC    }, // 151.0.0.0       - 151.255.255.255
	{ 0x98000000, 0x98ffffff, REGISTRY_ARIN       }, // 152.0.0.0       - 152.255.255.255
	{ 0x99000000, 0x99ffffff, REGISTRY_APNIC      }, // 153.0.0.0       - 153.255.255.255
	{ 0x9a000000, 0x9affffff, REGISTRY_AFRINIC    }, // 154.0.0.0       - 154.255.255.255
	{ 0x9b000000, 0x9bffffff, REGISTRY_ARIN       }, // 155.0.0.0       - 155.255.255.255
	{ 0x9c000000, 0x9cffffff, REGISTRY_ARIN       }, // 156.0.0.0       - 156.255.255.255
	{ 0x9d000000, 0x9dffffff, REGISTRY_ARIN       }, // 157.0.0.0       - 157.255.255.255
	{ 0x9e000000, 0x9effffff, REGISTRY_ARIN       }, // 158.0.0.0       - 158.255.255.255
	{ 0x9f000000, 0x9fffffff, REGISTRY_ARIN       }, // 159.0.0.0       - 159.255.255.255
	{ 0xa0000000, 0xa0ffffff, REGISTRY_ARIN       }, // 160.0.0.0       - 160.255.255.255
	{ 0xa1000000, 0xa1ffffff, REGISTRY_ARIN       }, // 161.0.0.0       - 161.255.255.255
	{ 0xa2000000, 0xa2ffffff, REGISTRY_ARIN       }, // 162.0.0.0       - 162.255.255.255
	{ 0xa3000000, 0xa3ffffff, REGISTRY_APNIC      }, // 163.0.0.0       - 163.255.255.255
	{ 0xa4000000, 0xa4ffffff, REGISTRY_ARIN       }, // 164.0.0.0       - 164.255.255.255
	{ 0xa5000000, 0xa5ffffff, REGISTRY_ARIN       }, // 165.0.0.0       - 165.255.255.255
	{ 0xa6000000, 0xa6ffffff, REGISTRY_ARIN       }, // 166.0.0.0       - 166.255.255.255
	{ 0xa7000000, 0xa7ffffff, REGISTRY_ARIN       }, // 167.0.0.0       - 167.255.255.255
	{ 0xa8000000, 0xa8ffffff, REGISTRY_ARIN       }, // 168.0.0.0       - 168.255.255.255
	{ 0xa9000000, 0xa9ffffff, REGISTRY_ARIN       }, // 169.0.0.0       - 169.255.255.255
	{ 0xaa000000, 0xaaffffff, REGISTRY_ARIN       }, // 170.0.0.0       - 170.255.255.255
	{ 0xab000000, 0xabffffff, REGISTRY_APNIC      }, // 171.0.0.0       - 171.255.255.255
	{ 0xac000000, 0xacffffff, REGISTRY_ARIN       }, // 172.0.0.0       - 172.255.255.255
	{ 0xad000000, 0xadffffff, REGISTRY_ARIN       }, // 173.0.0.0       - 173.255.255.255
	{ 0xae000000, 0xaeffffff, REGISTRY_ARIN       }, // 174.0.0.0       - 174.255.255.255
	{ 0xaf000000, 0xafffffff, REGISTRY_APNIC      }, // 175.0.0.0       - 175.255.255.255
	{ 0xb0000000, 0xb0ffffff, REGISTRY_RIPENCC    }, // 176.0.0.0       - 176.255.255.255
	{ 0xb1000000, 0xb1ffffff, REGISTRY_LACNIC     }, // 177.0.0.0       - 177.255.255.255
	{ 0xb2000000, 0xb2ffffff, REGISTRY_RIPENCC    }, // 178.0.0.0       - 178.255.255.255
	{ 0xb3000000, 0xb3ffffff, REGISTRY_LACNIC     }, // 179.0.0.0       - 179.255.255.255
	{ 0xb4000000, 0xb4ffffff, REGISTRY_APNIC      }, // 180.0.0.0       - 180.255.255.255
	{ 0xb5000000, 0xb5ffffff, REGISTRY_LACNIC     }, // 181.0.0.0       - 181.255.255.255
	{ 0xb6000000, 0xb6ffffff, REGISTRY_APNIC      }, // 182.0.0.0       - 182.255.255.255
	{ 0xb7000000, 0xb7ffffff, REGISTRY_APNIC      }, // 183.0.0.0       - 183.255.255.255
	{ 0xb8000000, 0xb8ffffff, REGISTRY_ARIN       }, // 184.0.0.0       - 184.255.255.255
	{ 0xb9000000, 0xb9ffffff, REGISTRY_RIPENCC    }, // 185.0.0.0       - 185.255.255.255
	{ 0xba000000, 0xbaffffff, REGISTRY_LACNIC     }, // 186.0.0.0       - 186.255.255.255
	{ 0xbb000000, 0xbbffffff, REGISTRY_LACNIC     }, // 187.0.0.0       - 187.255.255.255
	{ 0xbc000000, 0xbcffffff, REGISTRY_RIPENCC    }, // 188.0.0.0       - 188.255.255.255
	{ 0xbd000000, 0xbdffffff, REGISTRY_LACNIC     }, // 189.0.0.0       - 189.255.255.255
	{ 0xbe000000, 0xbeffffff, REGISTRY_LACNIC     }, // 190.0.0.0       - 190.255.255.255
	{ 0xbf000000, 0xbfffffff, REGISTRY_LACNIC     }, // 191.0.0.0       - 191.255.255.255
	{ 0xc0000000, 0xc0ffffff, REGISTRY_ARIN       }, // 192.0.0.0       - 192.255.255.255
	{ 0xc1000000, 0xc1ffffff, REGISTRY_RIPENCC    }, // 193.0.0.0       - 193.255.255.255
	{ 0xc2000000, 0xc2ffffff, REGISTRY_RIPENCC    }, // 194.0.0.0       - 194.255.255.255
	{ 0xc3000000, 0xc3ffffff, REGISTRY_RIPENCC    }, // 195.0.0.0       - 195.255.255.255
	{ 0xc4000000, 0xc4ffffff, REGISTRY_AFRINIC    }, // 196.0.0.0       - 196.255.255.255
	{ 0xc5000000, 0xc5ffffff, REGISTRY_AFRINIC    }, // 197.0.0.0       - 197.255.255.255
	{ 0xc6000000, 0xc6ffffff, REGISTRY_ARIN       }, // 198.0.0.0       - 198.255.255.255
	{ 0xc7000000, 0xc7ffffff, REGISTRY_ARIN       }, // 199.0.0.0       - 199.255.255.255
	{ 0xc8000000, 0xc8ffffff, REGISTRY_LACNIC     }, // 200.0.0.0       - 200.255.255.255
	{ 0xc9000000, 0xc9ffffff, REGISTRY_LACNIC     }, // 201.0.0.0       - 201.255.255.255
	{ 0xca000000, 0xcaffffff, REGISTRY_APNIC      }, // 202.0.0.0       - 202.255.255.255
	{ 0xcb000000, 0xcbffffff, REGISTRY_APNIC      }, // 203.0.0.0       - 203.255.255.255
	{ 0xcc000000, 0xccffffff, REGISTRY_ARIN       }, // 204.0.0.0       - 204.255.255.255
	{ 0xcd000000, 0xcdffffff, REGISTRY_ARIN       }, // 205.0.0.0       - 205.255.255.255
	{ 0xce000000, 0xceffffff, REGISTRY_ARIN       }, // 206.0.0.0       - 206.255.255.255
	{ 0xcf000000, 0xcfffffff, REGISTRY_ARIN       }, // 207.0.0.0       - 207.255.255.255
	{ 0xd0000000, 0xd0ffffff, REGISTRY_ARIN       }, // 208.0.0.0       - 208.255.255.255
	{ 0xd1000000, 0xd1ffffff, REGISTRY_ARIN       }, // 209.0.0.0       - 209.255.255.255
	{ 0xd2000000, 0xd2ffffff, REGISTRY_APNIC      }, // 210.0.0.0       - 210.255.255.255
	{ 0xd3000000, 0xd3ffffff, REGISTRY_APNIC      }, // 211.0.0.0       - 211.255.255.255
	{ 0xd4000000, 0xd4ffffff, REGISTRY_RIPENCC    }, // 212.0.0.0       - 212.255.255.255
	{ 0xd5000000, 0xd5ffffff, REGISTRY_RIPENCC    }, // 213.0.0.0       - 213.255.255.255
	{ 0xd6000000, 0xd6ffffff, REGISTRY_ARIN       }, // 214.0.0.0       - 214.255.255.255
	{ 0xd7000000, 0xd7ffffff, REGISTRY_ARIN       }, // 215.0.0.0       - 215.255.255.255
	{ 0xd8000000, 0xd8ffffff, REGISTRY_ARIN       }, // 216.0.0.0       - 216.255.255.255
	{ 0xd9000000, 0xd9ffffff, REGISTRY_RIPENCC    }, // 217.0.0.0       - 217.255.255.255
	{ 0xda000000, 0xdaffffff, REGISTRY_APNIC      }, // 218.0.0.0       - 218.255.255.255
	{ 0xdb000000, 0xdbffffff, REGISTRY_APNIC      }, // 219.0.0.0       - 219.255.255.255
	{ 0xdc000000, 0xdcffffff, REGISTRY_APNIC      }, // 220.0.0.0       - 220.255.255.255
	{ 0xdd000000, 0xddffffff, REGISTRY_APNIC      }, // 221.0.0.0       - 221.255.255.255
	{ 0xde000000, 0xdeffffff, REGISTRY_APNIC      }, // 222.0.0.0       - 222.255.255.255
	{ 0xdf000000, 0xdfffffff, REGISTRY_APNIC      }, // 223.0.0.0       - 223.255.255.255
	{ 0xe0000000, 0xe0ffffff, REGISTRY_IANA       }, // 224.0.0.0       - 224.255.255.255
	{ 0xe1000000, 0xe1ffffff, REGISTRY_IANA       }, // 225.0.0.0       - 225.255.255.255
	{ 0xe2000000, 0xe2ffffff, REGISTRY_IANA       }, // 226.0.0.0       - 226.255.255.255
	{ 0xe3000000, 0xe3ffffff, REGISTRY_IANA       }, // 227.0.0.0       - 227.255.255.255
	{ 0xe4000000, 0xe4ffffff, REGISTRY_IANA       }, // 228.0.0.0       - 228.255.255.255
	{ 0xe5000000, 0xe5ffffff, REGISTRY_IANA       }, // 229.0.0.0       - 229.255.255.255
	{ 0xe6000000, 0xe6ffffff, REGISTRY_IANA       }, // 230.0.0.0       - 230.255.255.255
	{ 0xe7000000, 0xe7ffffff, REGISTRY_IANA       }, // 231.0.0.0       - 231.255.255.255
	{ 0xe8000000, 0xe8ffffff, REGISTRY_IANA       }, // 232.0.0.0       - 232.255.255.255
	{ 0xe9000000, 0xe9ffffff, REGISTRY_IANA       }, // 233.0.0.0       - 233.255.255.255
	{ 0xea000000, 0xeaffffff, REGISTRY_IANA       }, // 234.0.0.0       - 234.255.255.255
	{ 0xeb000000, 0xebffffff, REGISTRY_IANA       }, // 235.0.0.0       - 235.255.255.255
	{ 0xec000000, 0xecffffff, REGISTRY_IANA       }, // 236.0.0.0       - 236.255.255.255
	{ 0xed000000, 0xedffffff, REGISTRY_IANA       }, // 237.0.0.0       - 237.255.255.255
	{ 0xee000000, 0xeeffffff, REGISTRY_IANA       }, // 238.0.0.0       - 238.255.255.255
	{ 0xef000000, 0xefffffff, REGISTRY_IANA       }, // 239.0.0.0       - 239.255.255.255
	{ 0xf0000000, 0xf0ffffff, REGISTRY_IANA       }, // 240.0.0.0       - 240.255.255.255
	{ 0xf1000000, 0xf1ffffff, REGISTRY_IANA       }, // 241.0.0.0       - 241.255.255.255
	{ 0xf2000000, 0xf2ffffff, REGISTRY_IANA       }, // 242.0.0.0       - 242.255.255.255
	{ 0xf3000000, 0xf3ffffff, REGISTRY_IANA       }, // 243.0.0.0       - 243.255.255.255
	{ 0xf4000000, 0xf4ffffff, REGISTRY_IANA       }, // 244.0.0.0       - 244.255.255.255
	{ 0xf5000000, 0xf5ffffff, REGISTRY_IANA       }, // 245.0.0.0       - 245.255.255.255
	{ 0xf6000000, 0xf6ffffff, REGISTRY_IANA       }, // 246.0.0.0       - 246.255.255.255
	{ 0xf7000000, 0xf7ffffff, REGISTRY_IANA       }, // 247.0.0.0       - 247.255.255.255
	{ 0xf8000000, 0xf8ffffff, REGISTRY_IANA       }, // 248.0.0.0       - 248.255.255.255
	{ 0xf9000000, 0xf9ffffff, REGISTRY_IANA       }, // 249.0.0.0       - 249.255.255.255
	{ 0xfa000000, 0xfaffffff, REGISTRY_IANA       }, // 250.0.0.0       - 250.255.255.255
	{ 0xfb000000, 0xfbffffff, REGISTRY_IANA       }, // 251.0.0.0       - 251.255.255.255
	{ 0xfc000000, 0xfcffffff, REGISTRY_IANA       }, // 252.0.0.0       - 252.255.255.255
	{ 0xfd000000, 0xfdffffff, REGISTRY_IANA       }, // 253.0.0.0       - 253.255.255.255
	{ 0xfe000000, 0xfeffffff, REGISTRY_IANA       }, // 254.0.0.0       - 254.255.255.255
	{ 0xff000000, 0xffffffff, REGISTRY_IANA       }, // 255.0.0.0       - 255.255.255.255
};
