#!/usr/bin/env python
# -*- coding: utf-8 -*-

# Copyright (C) 2008-2009 Alessio Treglia
#
# This file is part of installation-report-generator.
#
# installation-report-generator is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# installation-report-generator is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with installation-report-generator.  If not, see <http://www.gnu.org/licenses/>.

try:
    import gtkmvc
    gtkmvc.require("1.2.1")
except AssertionError:
    raise EnvironmentError, _("Missing PyGTK MVC")

try:
    import pygtk
    pygtk.require20()
except AssertionError:
    raise EnvironmentError, _("Missing PyGTK+")

import gobject, gtk, gtk.glade, gtk.gdk

import irgenerator, irgenerator.globals, irgenerator.core
from irgenerator.core import report, backends
from irgenerator.core.plugcentral import PluginCentral
#from core import report, backends

def progress_timeout(pbobj):
    if pbobj.activity_check == 1:
        pbobj.view['progressbar_wait'].pulse()
    elif pbobj.activity_check == 0:
        pbobj.view['progressbar_wait'].set_fraction(0.0)
    else:
        pbobj.view['progressbar_wait'].set_fraction(1.0)
    return True

class MainWindowView(gtkmvc.View):
    def __init__(self, ctrl):
        gtkmvc.View.__init__(self, ctrl, irgenerator.globals.GLADE_MAIN_WINDOW)

class AboutDialog(object):
    def __init__(self):
        glade_XML = gtk.glade.XML(irgenerator.globals.GLADE_ABOUT_DIALOG)
        self.__dialog = glade_XML.get_widget('about_dialog')
        self.__dialog.set_version(irgenerator.globals.get_version())
        self.__dialog.set_license(irgenerator.globals.LICENSE)
        self.__dialog.set_icon_from_file(irgenerator.globals.LOGO_PNG)
        self.__dialog.set_logo(gtk.gdk.pixbuf_new_from_file(irgenerator.globals.LOGO_SVG))
        self.__dialog.set_authors(['Alessio Treglia <quadrispro@ubuntu.com>',
'Installation Report Generator Developers http://launchpad.net/~irgenerator-developers'])
    def show(self):
        self.__dialog.run()
        self.__dialog.hide()

class MainWindowCtrl(gtkmvc.Controller):
    def showMessageDialog(self, type, message_format):
        md = gtk.MessageDialog(flags=gtk.DIALOG_MODAL, buttons=gtk.BUTTONS_CLOSE,type=type,message_format=message_format)
        pixbuf = gtk.gdk.pixbuf_new_from_file(irgenerator.globals.LOGO_PNG)
        md.set_icon(pixbuf)
        md.run()
        md.destroy()
    def update_buttons(self, **show_buttons):
            for i in show_buttons:
                getattr(self.view[i], show_buttons[i])()
    def show_tab_intro(self):
        self.update_buttons(button_forward='show', button_back='hide', button_ok='hide', button_exit='hide', button_about='show')
    def show_tab_configuration(self):
        self.update_buttons(button_forward='show', button_back='show', button_ok='hide', button_exit='hide', button_about='hide')
    def show_tab_distribution(self):
        self.update_buttons(button_forward='show', button_back='show', button_ok='hide', button_exit='hide', button_about='hide')
    def show_tab_plugin(self): # just done :)
        self.update_buttons(button_forward='show', button_back='show', button_ok='hide', button_exit='hide', button_about='hide')
    def show_tab_wait(self):
        self.update_buttons(button_forward='hide', button_back='show', button_ok='show', button_exit='hide', button_about='hide')
    def show_tab_final(self):
        self.update_buttons(button_forward='hide', button_back='hide', button_exit='show', button_about='show')
        textview_content = self.report #self.wpage.page
        buf = gtk.TextBuffer()
        buf.set_text(textview_content)
        self.view['textview_final'].set_buffer(buf)
    def on_button_forward_clicked(self, widget, data=None):
        def goto_tab_configuration():
            self.view['notebook'].next_page()
            self.show_tab_configuration()
        def goto_tab_distribution():
            # validate informations entered by user 
            if self.model.model.strip() == '' or self.model.vendor.strip() == '' or self.model.vga.strip() == '':
                self.showMessageDialog(type=gtk.MESSAGE_ERROR, message_format=_("You must fill vendor, model and vga fields."))
            else:
                self.view['notebook'].next_page()
                self.show_tab_distribution()
        def goto_tab_plugin():
            if not self.view['checkbutton_distribution_autodetect'].get_active():
                for i in self.view['radiobutton_hardy'].get_group():
                    if i.get_active():
                        self.model.release = i.get_label().replace('Ubuntu', '').strip()
                        break
            else:
                self.model.release = ''
            self.view['notebook'].next_page()
            self.show_tab_plugin()
        def goto_tab_wait():
            self.view['notebook'].next_page()
            self.show_tab_wait()
        def goto_tab_final():
            self.view['notebook'].next_page()
            self.show_tab_final()
        cur_page = self.view['notebook'].get_current_page()
        (goto_tab_configuration, goto_tab_distribution, goto_tab_plugin, goto_tab_wait, goto_tab_final)[cur_page]()
    def on_button_back_clicked(self, widget, data=None):
        cur_page = self.view['notebook'].get_current_page()
        (self.show_tab_intro, self.show_tab_configuration,
         self.show_tab_distribution, self.show_tab_plugin)[cur_page-1]()
        self.view['notebook'].prev_page()
    def on_button_ok_clicked(self, widget, data=None):
        self.update_buttons(button_back='hide', button_ok='hide')
        self.view['progressbar_wait'].set_text(_("Please wait..."))
        # Load plugin and run it
        self.backend = PluginCentral.load_plugin(self.selected_plugin)()
        self.backend.set_active_obj(self)
        self.backend.set_hwconfig(self.model)
        self.backend.start()
    def on_button_exit_clicked(self, widget, data=None):
        self.destroy(widget)
    def on_checkbutton_distribution_autodetect_toggled(self, widget, data=None):
        for i in self.view['radiobutton_hardy'].get_group():
            (i.set_flags, i.unset_flags)[widget.get_active()](gtk.SENSITIVE)
    def on_combobox_plugin_changed(self, widget, data=None):
        self.selected_plugin = self.view['combobox_plugin'].get_active_text()
        self.view['combobox_plugin'].set_tooltip_text(self.available_plugins[self.selected_plugin])
    def report_is_ready(self):
        """
        Notices to the controller that the report is ready.
        """
        self.report = self.backend.get_report() # get the report
        self.update_buttons(button_forward='show') # show the correct buttons configuration
        self.view['progressbar_wait'].set_text(_("Press «Forward»")) # changes pbar's status
    def destroy(self, widget, data=None):
        gobject.source_remove(self.timer)
        gtk.main_quit()
    def show(self):
        self.view['main_window'].show()
    def register_adapters(self):
        # L'introduzione degli adapters comporta
        # alcune modifiche nel file Glade.
        self.adapt("vendor")
        self.adapt("model")
        self.adapt("cpu")
        self.adapt("memory")
        self.adapt("vga")
        self.adapt("website")
    def register_view(self, view):
        gtkmvc.Controller.register_view(self, view)
        self.__setup_widgets()
        self.show_tab_intro()
    def on_button_about_clicked(self, widget, data=None):
        self.about_dialog.show()
    def property_vendor_value_change(self, model, old, new):
        self.view['laptoplabel'].set_text(' '.join([new,model.model]))
    def property_model_value_change(self, model, old, new):
        self.view['laptoplabel'].set_text(' '.join([model.vendor,new]))
    def property_cpu_value_change(self, model, old, new):
        if new.strip() == '':
            self.view['cpulabel'].set_markup(self.autodetect_str)
        else:
            self.view['cpulabel'].set_text(new)
    def property_memory_value_change(self, model, old, new):
        if new.strip() == '':
            self.view['memorylabel'].set_markup(self.autodetect_str)
        else:
            self.view['memorylabel'].set_text(new)
    def property_vga_value_change(self, model, old, new):
        self.view['vgalabel'].set_text(new)
    def property_website_value_change(self, model, old, new):
        self.view['websitelabel'].set_text(new)
    def property_release_value_change(self, model, old, new):
        if new.strip() == '':
            self.view['distributionlabel'].set_markup(self.autodetect_str)
        else:
            self.view['distributionlabel'].set_text(' '.join(['Ubuntu', new]))
    def __setup_widgets(self):
        # Set window icon
        self.view['main_window'].set_icon_from_file(irgenerator.globals.LOGO_PNG)
        # update available plugins list
        map(self.view['combobox_plugin'].append_text, self.available_plugins)
        self.view['combobox_plugin'].set_active(0)
        self.view['image_head'].set_from_file(irgenerator.globals.HEADER_PNG)
    def __init__(self, model):
        gtkmvc.Controller.__init__(self, model)
        self.timer = gobject.timeout_add(100, progress_timeout, self)
        self.activity_check = 0
        #self.wpage = irgenerator.core.backends.WikiPage(self)
        ## Test plugin support
        self.available_plugins = PluginCentral.get_available_plugins()
        #self.__setup_widgets()
        self.selected_plugin = ''
        self.backend = None #PluginCentral.load_plugin('UbuntuItWiki')()#(self, self.model)
        self.report = None
        self.autodetect_str = _('<i>Autodetect</i>')
        self.about_dialog = AboutDialog()
