/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2011 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#ifndef IDATAEXPLORER_H
#define IDATAEXPLORER_H


#include <vtkObject.h>
#include "imultitypedataconsumer.h"

class iDataType;
class iHistogram;
class iHistogramMaker;
class iObjectType;
class iPosition;


class iDataExplorer : public vtkObject, public iMultiTypeDataConsumer
{

	friend class iExtensionFactory;

public:

	struct Info
	{
		float Maximum;
		float Minimum;
		float Median;
		float Average;
		float Dispersion;
		const iHistogram* Histogram;
		vtkIdType CellMin, CellMax;
		const iPosition *PosMin, *PosMax;
	};

	vtkTypeMacro(iDataExplorer,vtkObject);
	static iDataExplorer* New(iViewModule *vm = 0);
	static const iObjectType& Type();

	//
	//  using a struct, only one Update is needed to bring everything up to date
	//
	const Info& GetInfo(bool rangeonly = false, int rank = -1);

	void SetStretch(int v);
	void SetInputComponent(int c);
	int GetNumberOfInputComponents() const;

protected:
	
	virtual ~iDataExplorer();

	virtual void Execute();
	virtual void SyncWithDataBody(const iDataSyncRequest &r);

	virtual void UpdateDataType(int prev);

private:

	iDataExplorer(iViewModule *vm);

	bool mComputeRangeOnly;
	int mComponent, mStretch;
	Info mInfo;
	iHistogramMaker *mHistogramMaker;
	unsigned long mMTime;
};

#endif  // IDATAEXPLORER_H

