/******************************************************************************
 * Icinga 2                                                                   *
 * Copyright (C) 2012-2015 Icinga Development Team (http://www.icinga.org)    *
 *                                                                            *
 * This program is free software; you can redistribute it and/or              *
 * modify it under the terms of the GNU General Public License                *
 * as published by the Free Software Foundation; either version 2             *
 * of the License, or (at your option) any later version.                     *
 *                                                                            *
 * This program is distributed in the hope that it will be useful,            *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              *
 * GNU General Public License for more details.                               *
 *                                                                            *
 * You should have received a copy of the GNU General Public License          *
 * along with this program; if not, write to the Free Software Foundation     *
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.             *
 ******************************************************************************/

#include "demo/demo.hpp"
#include "remote/apilistener.hpp"
#include "remote/apifunction.hpp"
#include "base/dynamictype.hpp"
#include "base/logger.hpp"

using namespace icinga;

REGISTER_TYPE(Demo);

REGISTER_APIFUNCTION(HelloWorld, demo, &Demo::DemoMessageHandler);

/**
 * Starts the component.
 */
void Demo::Start(void)
{
	DynamicObject::Start();

	m_DemoTimer = new Timer();
	m_DemoTimer->SetInterval(5);
	m_DemoTimer->OnTimerExpired.connect(boost::bind(&Demo::DemoTimerHandler, this));
	m_DemoTimer->Start();
}

/**
 * Periodically broadcasts an API message.
 */
void Demo::DemoTimerHandler(void)
{
	Dictionary::Ptr message = new Dictionary();
	message->Set("method", "demo::HelloWorld");

	ApiListener::Ptr listener = ApiListener::GetInstance();
	if (listener) {
		listener->RelayMessage(MessageOrigin(), DynamicObject::Ptr(), message, true);
		Log(LogInformation, "Demo", "Sent demo::HelloWorld message");
	}
}

Value Demo::DemoMessageHandler(const MessageOrigin& origin, const Dictionary::Ptr&)
{
	Log(LogInformation, "Demo")
	    << "Got demo message from '" << origin.FromClient->GetEndpoint()->GetName() << "'";

	return Empty;
}
