dnl 
dnl This file is part of hyantes.
dnl 
dnl hypersmooth is free software; you can redistribute it and/or modify
dnl it under the terms of the CeCILL-C License
dnl 
dnl You should have received a copy of the CeCILL-C License
dnl along with this program.  If not, see <http://www.cecill.info/licences>.
dnl 

dnl ACX_CHECK_LIB(libname, function)
dnl -------------------------------------
AC_DEFUN(
    [ACX_CHECK_LIB],
    [
        AC_CHECK_LIB(
            $1,
            $2,
        )
        with_$1=${ac_cv_lib_$1_$2}
    ]
)

dnl ACX_STRICT_CHECK_LIB(libname, function)
dnl -------------------------------------
AC_DEFUN(
    [ACX_STRICT_CHECK_LIB],
    [
        AC_CHECK_LIB(
            $1,
            $2,
            [],
            AC_MSG_ERROR([Cannot find $1 library!])
        )
    ]
)

dnl ACX_STRICT_STRICT_CHECK_HEADER(header)
dnl -------------------------------------
AC_DEFUN(
    [ACX_STRICT_CHECK_HEADER],
    [
        AC_CHECK_HEADER(
            $1,
            [],
            AC_MSG_ERROR([Cannot find $1 header!])
        )
    ]
)

dnl ACX_STRICT_CHECK_FUNC(func)
dnl -------------------------------------
AC_DEFUN(
    [ACX_STRICT_CHECK_FUNC],
    [
        AC_CHECK_FUNC(
            $1,
            [],
            AC_MSG_ERROR([Cannot find $1 function!])
        )
    ]
)

dnl ACX_PATH_PROG(VAR,prog)
dnl -----------------------
AC_DEFUN(
    [ACX_PATH_PROG],
    [
        AC_PATH_PROG([$1],[$2])
        AC_ARG_VAR([$1],[$2 command])
        have_$2=yes
        test "x$$1" = x && $1="false ...$2 program required..." && have_$2=no
    ]
)


dnl ACX_SUMMARY_BEGIN
dnl -----------------
AC_DEFUN(
    [ACX_SUMMARY_BEGIN],
    [
        echo
        echo "= configure result ="
        echo
        acx_configure_failed="no"
    ]
)

dnl ACX_SUMMARY_END
dnl ---------------
AC_DEFUN(
    [ACX_SUMMARY_END],
    [
        echo
        if test "${acx_configure_failed}" = "no"
        then
            echo " => configure succeeded"
            echo
            echo "you can now run 'make' to build software"
        else
            echo " => configure failed"
            echo 
            echo "check summary for missing components"
        fi
    ]
)
            
        
    ]
)

dnl ACX_SUMMARY_LIB(libname,is_opt=no)
dnl ----------------
AC_DEFUN(
    [ACX_SUMMARY_LIB],
    [
        if test "${with_$1}" = "yes"
        then
            echo " + using library $1"
        else
            echo " - library $1 not found"
            test "$2" = "opt" || acx_configure_failed="yes"
        fi
    ]
)

dnl ACX_SUMMARY_PROG(progname,is_opt=no)
dnl ----------------
AC_DEFUN(
    [ACX_SUMMARY_PROG],
    [
        if test "${have_$1}" = "yes"
        then
            echo " + using program $1"
        else
            echo " - program $1 not found"
            test "$2" = "opt" || acx_configure_failed="yes"
        fi
    ]
)

dnl ACX_SUMMARY_MSG(msg)
dnl ------------------------------
AC_DEFUN(
    [ACX_SUMMARY_MSG],
    [
        echo " + $1"
    ]
)
