module Main where

import Graphics.Rendering.Diagrams
import Graphics.Rendering.Diagrams.Engine
import Graphics.Rendering.Diagrams.Types

import Data.List
import Data.Function

partitions :: Int -> [[Int]]
partitions n = partitions' n n
  where partitions' 0 _ = [[]]
        partitions' n 1 = [replicate n 1]
        partitions' n k = do s <- [k,k-1..1]
                             p <- partitions' (n-s) (min (n-s) s)
                             return (s:p)

parts = groupBy ((==) `on` head) . partitions

ferrersTableaux :: Int -> Diagram
ferrersTableaux = vsep 20 . map (hsep 20 . map ferrers) . parts

ferrers :: [Int] -> Diagram
ferrers = hsep 3 . map (vsep 3 . flip replicate (circle 10))

main = renderAs PNG "ferrers.png" (Height 300) (lw 0 $ fc black $ ferrersTableaux 6)