//*****************************************************************************
//                                GNetList.hpp                                *
//                               --------------                               *
// Description : Provides a programatic interface to the utility gnetlist     *
//               which is used to generate netlist file from various          *
//               schematic editor formats.                                    *
// Started     : 29/01/2004                                                   *
// Last Update : 30/05/2011                                                   *
// Copyright   : (C) 2004 by MSWaters                                         *
// Email       : M.Waters@bom.gov.au                                          *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#ifndef PRCGNETLIST_HPP
#define PRCGNETLIST_HPP

// System Includes

#include <iostream>

// wxWidgets Includes

#include <wx/wx.h>
#include <wx/filename.h>
#include <wx/regex.h>
#include <wx/tokenzr.h>

// Application Includes

#include "base/PrcBase.hpp"

// Local Constant Declarations

#define GNETLST_BIN_NAME    wxT("gnetlist")       // The binary file name
#define GNETLST_LOG_FILE    wxT("gspiceui.log")   // Default log file name
#define GNETLST_GUILE_PROC  wxT("spice-sdb")      // Default Guile procedure
#define GNETLST_USE_SCHEM   wxT("use-schem-name") // Use schem. name for netlist
#define GNETLST_CUR_PROC    100  // A value greater than the no. of Guile proc's

//*****************************************************************************

class PrcGNetList : public PrcBase
{
  private :

    size_t         m_szGuileProc;     // The Guile procedure specifier
    wxArrayString  m_osaGuileProcs;   // Array of all possible Guile procedures
    ArrayFileName  m_ofnaSchemFiles;  // The full names of the schematic file/s
    wxFileName     m_ofnNetLstFile;   // The full name  of the list file

    void  InitGuileProcs( void );

  public :

    PrcGNetList( void );
   ~PrcGNetList( );

    bool  bClear( void );

    bool  bSetGuileProc ( const wxString      &  rosGProc=GNETLST_GUILE_PROC );
    bool  bSetSchemFiles( const wxString      &  rosFNames );
    bool  bSetSchemFiles( const wxArrayString & rosaFNames );
    bool  bSetNetLstFile( const wxString      &  rosFName=GNETLST_USE_SCHEM );

    const wxArrayString & rosaGetGuileProcs( void ) { return( m_osaGuileProcs ); }
    const wxString      &  rosGetGuileProc ( size_t szIndex=GNETLST_CUR_PROC );
    const ArrayFileName &  roaGetSchemFiles( void ) { return( m_ofnaSchemFiles ); }
    const wxFileName    &   roGetSchemFile ( size_t szIndex=0 );
    const wxFileName    &   roGetNetLstFile( void ) { return( m_ofnNetLstFile ); }

    virtual  bool  bExec( void );
};

//*****************************************************************************

#endif // PRCGNETLIST_HPP
