/*
 * Copyright 2003-2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */





package org.codehaus.groovy.transform.traitx

class Groovy7213Bug extends GroovyTestCase {
    void testShouldAllowPrivateMethodInTraitEvenIfUseCompileStatic() {
        assertScript '''
trait Foo {
   private int f(int x) { x }
   int foo() { f(2) }
}

@groovy.transform.CompileStatic
class A implements Foo {}
assert new A().foo() == 2
'''
    }
}
