/*
   Copyright (c) 2004, 2005 by AOSASA Shigeru and Red Hat, Inc.
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are
   met:

   - Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.

   - Redistributions in binary form must reproduce the above
   copyright notice, this list of conditions and the following
   disclaimer in the documentation and/or other materials provided
   with the distribution.  

   - Neither the name of the AOSASA Shigeru, Red Hat, Inc
   nor the names of its contributors may be used to endorse or
   promote products derived from this software without specific
   prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
   COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
   INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
   (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
   SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
   STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
   OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*
   This software development was supported by
   Information-technorogy Promotion Agency, Japan (IPA).
*/

#include "gtkcontainer-utils.h"

#include "gtkwidget-utils.h"


#include <string.h>



GList *
gtk_container_get_descendants_list (GtkContainer *container)
{
  GList *descendants;

  g_return_val_if_fail (container != NULL, NULL);
  g_return_val_if_fail (GTK_IS_CONTAINER (container), NULL);


  descendants = NULL;

  if (GTK_IS_CONTAINER (container))
    {
      GList *children;
      GList *tmp;
      GtkWidget *child;


      children = gtk_container_get_children (GTK_CONTAINER (container));

      tmp = children;
      while (tmp != NULL)
	{
	  child = GTK_WIDGET (tmp->data);
	  tmp = g_list_next (tmp);

	  
	  descendants = g_list_append (descendants, child);

	  if (GTK_IS_CONTAINER (child))
	    {
	      descendants
		= g_list_concat (descendants,
				 gtk_container_get_descendants_list
						(GTK_CONTAINER (child)));
	    }
	}
      g_list_free (children);
    }

  return descendants;
}


GtkWidget*
gtk_container_find_child_by_qdata (GtkContainer *container,
				   GQuark        quark,
				   gpointer      data)
{
  GtkWidget *widget;

  g_return_val_if_fail (container != NULL, NULL);
  g_return_val_if_fail (GTK_IS_CONTAINER (container), NULL);


  if (quark != 0)
    {
      GList *children;
      GList *tmp;
      GtkWidget *tmp_child;
      gpointer tmp_data;
      
      widget = NULL;
      children = gtk_container_get_children (container);

      tmp = children;
      while (tmp != NULL)
	{
	  tmp_child = GTK_WIDGET (tmp->data);
	  tmp = g_list_next (tmp);

	  tmp_data = g_object_get_qdata (G_OBJECT (tmp_child),
					 quark);
      
	  if (tmp_data == data)
	    {
	      widget = tmp_child;
	      break;
	    }
	}

      if (children != NULL)
	{
	  g_list_free (children);
	}
    }
  else
    {
      widget = NULL;
    }


  return widget;
}

GtkWidget*
gtk_container_find_descendant_by_qdata (GtkContainer *container,
					GQuark        quark,
					gpointer      data)
{
  GtkWidget *widget;

  g_return_val_if_fail (container != NULL, NULL);
  g_return_val_if_fail (GTK_IS_CONTAINER (container), NULL);


  if (quark != 0)
    {
      GList *children;
      GList *tmp;
      GtkWidget *tmp_child;
      gpointer *tmp_data;
      GtkWidget *tmp_widget;

      widget = NULL;
      children = gtk_container_get_children (container);

      tmp = children;
      while (tmp != NULL)
	{
	  tmp_child = GTK_WIDGET (tmp->data);
	  tmp = g_list_next (tmp);

	  tmp_data = g_object_get_qdata (G_OBJECT (tmp_child),
					 quark);
      
	  if (tmp_data == data)
	    {
	      widget = tmp_child;
	      break;
	    }

	  if (GTK_IS_CONTAINER (tmp_child))
	    {
	      tmp_widget
		= gtk_container_find_descendant_by_qdata (GTK_CONTAINER (tmp_child),
							  quark,
							  data);

	      if (tmp_widget != NULL)
		{
		  widget = tmp_widget;
		  break;
		}
	    }
	}

      if (children != NULL)
	{
	  g_list_free (children);
	}
    }
  else
    {
      widget = NULL;
    }

  return widget;
}

GtkWidget*
gtk_container_find_child_by_data (GtkContainer *container,
				  const gchar  *key,
				  gpointer      data)
{
  GQuark quark;
  GtkWidget *widget;

  g_return_val_if_fail (container != NULL, NULL);
  g_return_val_if_fail (GTK_IS_CONTAINER (container), NULL);
  g_return_val_if_fail (key != NULL, NULL);


  quark = g_quark_try_string (key);

  if (quark != 0)
    {
      widget = gtk_container_find_child_by_qdata (container,
						  quark,
						  data);
    }
  else
    {
      widget = NULL;
    }


  return widget;
}

GtkWidget*
gtk_container_find_descendant_by_data (GtkContainer *container,
				       const gchar  *key,
				       gpointer      data)
{
  GQuark quark;
  GtkWidget *widget;

  g_return_val_if_fail (container != NULL, NULL);
  g_return_val_if_fail (GTK_IS_CONTAINER (container), NULL);
  g_return_val_if_fail (key != NULL, NULL);


  quark = g_quark_try_string (key);

  if (quark != 0)
    {
      widget = gtk_container_find_descendant_by_qdata (container,
						       quark,
						       data);
    }
  else
    {
      widget = NULL;
    }


  return widget;
}

GtkWidget*
gtk_container_find_child_by_name (GtkContainer *container,
				  const gchar  *name)
{
  GtkWidget *widget;
  GList *children;
  GList *tmp;
  GtkWidget *tmp_child;
  gchar *tmp_child_name;

  g_return_val_if_fail (container != NULL, NULL);
  g_return_val_if_fail (GTK_IS_CONTAINER (container), NULL);
  g_return_val_if_fail (name != NULL, NULL);


  widget = NULL;
  children = gtk_container_get_children (container);

  tmp = children;
  while (tmp != NULL)
    {
      tmp_child = GTK_WIDGET (tmp->data);
      tmp = g_list_next (tmp);

      tmp_child_name = gtk_widget_get_name_or_empty (tmp_child);
      
      if (strcmp (tmp_child_name, name) == 0)
	{
	  widget = tmp_child;
	  break;
	}
    }

  if (children != NULL)
    {
      g_list_free (children);
    }

  return widget;
}

GtkWidget*
gtk_container_find_descendant_by_name (GtkContainer *container,
				       const gchar  *name)
{
  GtkWidget *widget;
  GList *children;
  GList *tmp;
  GtkWidget *tmp_child;
  gchar *tmp_child_name;
  GtkWidget *tmp_widget;

  g_return_val_if_fail (container != NULL, NULL);
  g_return_val_if_fail (GTK_IS_CONTAINER (container), NULL);
  g_return_val_if_fail (name != NULL, NULL);


  widget = NULL;
  children = gtk_container_get_children (container);

  tmp = children;
  while (tmp != NULL)
    {
      tmp_child = GTK_WIDGET (tmp->data);
      tmp = g_list_next (tmp);

      tmp_child_name = gtk_widget_get_name_or_empty (tmp_child);
      
      if (strcmp (tmp_child_name, name) == 0)
	{
	  widget = tmp_child;
	  break;
	}

      if (GTK_IS_CONTAINER (tmp_child))
	{
	  tmp_widget
	    = gtk_container_find_descendant_by_name (GTK_CONTAINER (tmp_child), name);

	  if (tmp_widget != NULL)
	    {
	      widget = tmp_widget;
	      break;
	    }
	}
    }

  if (children != NULL)
    {
      g_list_free (children);
    }

  return widget;
}
