#if HAVE_DEMANGLE

#include <string.h>
#include <demangle.h>

const char* ezt_demangle(const char* mangled_str) {
  /* todo: add an option to get only the function name */
  /* get the full function prototype (including parameters and return type)  */

  const char* res_str = cplus_demangle(mangled_str, DMGL_AUTO | DMGL_PARAMS);

  if(!res_str) {
    /* demangling failed. return the mangled string */
    int len = strlen(mangled_str) + 1;
    res_str = malloc(sizeof(char*) * len);
    strncpy(res_str, mangled_str, len);
  }
  return res_str;
}

#else  /* HAVE_DEMANGLE */

/* Libiberty is not available, return a copy of the mangled string */
const char* ezt_demangle(const char* mangled_str) {
  int len = strlen(mangled_str) + 1;
  const char* res_str = malloc(sizeof(char*) * len);
  strncpy(res_str, mangled_str, len);
  return res_str;
}

#endif	/* HAVE_DEMANGLE */
