C Copyright 1981-2007 ECMWF
C 
C Licensed under the GNU Lesser General Public License which
C incorporates the terms and conditions of version 3 of the GNU
C General Public License.
C See LICENSE and gpl-3.0.txt for details.
C

      INTEGER FUNCTION INTFA( INGRIB,INLEN,FLDIN,OUTGRIB,OUTLEN,FLDOUT)
C
C---->
C**** INTFA
C
C     Purpose
C     -------
C
C     Prepare to interpolate input field...
C
C
C     Interface
C     ---------
C
C     IRET = INTFA( INGRIB,INLEN,FLDIN,OUTGRIB,OUTLEN,FLDOUT)
C
C     Input
C     -----
C
C     INGRIB - Input field (packed).
C     INLEN  - Input field length (words).
C     FLDIN  - Input field (unpacked).
C
C
C     Output
C     ------
C
C     OUTGRIB - Output field (packed).
C     OUTLEN  - Output field length (words).
C     FLDOUT  - Output field (unpacked).
C
C
C     Method
C     ------
C
C     Unpack field if GRIB).
C
C
C     Externals
C     ---------
C
C     IBASINI - Ensure basic interpolation setup is done.
C     GRIBEX  - Decode/encode GRIB product.
C     GRSVCK  - Turn off GRIB checking
C     RESET_C - Reset interpolation handling options using GRIB product.
C     PDDEFS  - Setup interpolation using parameter dependent options.
C     INTLOG  - Log error message.
C
C
C     Author
C     ------
C
C     J.D.Chambers     ECMWF     Jan 1995
C
C----<
C
      IMPLICIT NONE
C
C     Function arguments
      INTEGER INGRIB(*),OUTGRIB(*),INLEN,OUTLEN
      REAL FLDIN(*),FLDOUT(*)
C
#include "parim.h"
#include "nifld.common"
#include "nofld.common"
#include "grfixed.h"
#include "intf.h"
C
C     Parameters
      INTEGER JPROUTINE
      PARAMETER (JPROUTINE = 26100 )
C
C     Local variables
C
      INTEGER IWORD, IERR
      INTEGER KPR
      INTEGER LOOP
C
C     Externals
      INTEGER IBASINI, RESET_C, PDDEFS
C
C ------------------------------------------------------------------
C*    Section 1.   Initialise
C ------------------------------------------------------------------
C
  100 CONTINUE
      INTFA = 0
      IERR = 0
      KPR = 0
C
C     Check that basic initialisation has been done
      IERR = IBASINI(0)
      IF ( IERR .NE. 0 ) THEN
        CALL INTLOG(JP_ERROR,'INTFA: basic initialisation fail',JPQUIET)
        INTFA = IERR
        GOTO 900
      ENDIF
C
C ------------------------------------------------------------------
C*    Section 2.   Decode data from the GRIB code
C ------------------------------------------------------------------
C
  200 CONTINUE
C
C     Allocate work array ZNFELDI if not already done.
C
      IF( IZNJDCI.NE.1952999238 ) THEN
        CALL JMEMHAN( 19, IZNFLDI, JPEXPAND, 1, IERR)
        IF( IERR.NE.0 ) THEN
          CALL INTLOG(JP_WARN,'INTFA: ZNFELDI allocation fail',JPQUIET)
          INTFA = IERR
          GOTO 900
        ENDIF
        IZNJDCI = 1952999238
      ENDIF
C
C     If input is a GRIB product
      If (NIFORM .EQ. 1) THEN
C
C       Decode data from GRIB code (no checking)
C
        IWORD = INLEN
        IERR  =  0
        CALL GRSVCK(0)
        IERR = 1
        ISEC3(2) = NINT(RMISSGV)
        ZSEC3(2) = RMISSGV
        CALL GRIBEX(ISEC0, ISEC1, ISEC2, ZSEC2, ISEC3, ZSEC3, ISEC4,
     X              ZNFELDI, JPEXPAND, INGRIB, INLEN, IWORD, 'D',IERR)
        IF ( IERR .NE. 0) THEN
          CALL INTLOG(JP_ERROR, 'INTFA: GRIBEX decoding failed.',IERR)
          INTFA = IERR
          GOTO 900
        ENDIF
C
C       Setup interpolation options from GRIB product characteristics
        IERR = RESET_C( ISEC1, ISEC2, ZSEC2, ISEC4)
        IF ( IERR .NE. 0 ) THEN
          CALL INTLOG(JP_ERROR,
     X      'INTFA: Setup interp. options from GRIB failed.',JPQUIET)
          INTFA = IERR
          GOTO 900
        ENDIF
C
C     Otherwise, move unpacked values in from user array
      ELSE
        DO 210 LOOP = 1, INLEN
          ZNFELDI( LOOP ) = FLDIN( LOOP )
 210    CONTINUE
C
      ENDIF
C
C     Setup interpolation options based on parameter in field.
      IERR = PDDEFS()
      IF ( IERR .NE. 0 ) THEN
        CALL INTLOG(JP_ERROR,
     X    'INTFA: Setup interp. options from parameter failed.',JPQUIET)
        INTFA = IERR
        GOTO 900
      ENDIF
C
C
C ------------------------------------------------------------------
C*    Section 9.   Closedown.
C ------------------------------------------------------------------
C
  900 CONTINUE
C
C     Clear change flags for next product processing
C
      RETURN
      END
