/*
  emilda-print
  Part of the Emilda project (http://www.emilda.org/)
	
  Copyright (C) 2003 Realnode Ltd

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  
  Authors:
    Mattias Nordstrom <nordstrom (at) realnode.com>

  $Id: epd.cpp,v 1.3 2003/12/27 19:18:43 matta Exp $
    This file provides the EPD (Emilda Print Data) class.

*/

#include <string.h>
#include <ctype.h>
#include <stdlib.h>
//#include <iostream>

#include "epd.h"

using namespace std;

epd::epd()
{

}

epd::~epd()
{

}

int epd::parse_epd(void *fd)
{
	char *buffer;
	unsigned int i;
	int length;
	
	ifstream *input = (ifstream*) fd;
	
	// Get length of input.
	input->seekg (0, ios::end);
	length = input->tellg();
	input->seekg (0, ios::beg);
	
	buffer = new char[length];
	
	if (input->eof()) {
		free(buffer);
		return EPD_PARSE_NODOC;
	}
	
	input->getline(buffer, 10);
	if (strncmp(buffer, "EPD/", 4) != 0) {
		// Not an EPD document.
		free(buffer);
		return EPD_PARSE_NODOC;
	}
	
	// Parse version.
	if (!isdigit(buffer[4]) || buffer[5] != '.' || !isdigit(buffer[6])) {
		// Version format wrong.
		free(buffer);
		return EPD_PARSE_VER;
	}
	document.version_ma = atoi(&buffer[4]);
	document.version_mi = atoi(&buffer[6]);
	if (document.version_ma != EPD_VERSION_MA || document.version_mi != EPD_VERSION_MI) {
		// Wrong version.
		free(buffer);
		return EPD_PARSE_VER;
	}
	
	// Parse type.
	input->getline(buffer, 100);
	if (strcmp(buffer, "postscript") == 0) document.type = EPD_TYPE_PS;
	else if (strcmp(buffer, "label") == 0) document.type = EPD_TYPE_LABEL;
	else if (strcmp(buffer, "receipt") == 0) document.type = EPD_TYPE_RECEIPT;
	else {
		free(buffer);
		return EPD_PARSE_TYPE;	// Unknown type.
	}
	
	// Parse options.
	input->getline(buffer, length);
	char *result = NULL;
	string tmp_opt;
	size_t loc;
	result = strtok(buffer, ";");
	
	while (result != NULL) {
		loc = strcspn(result, "=");
		tmp_opt = "";
		
		for (i=0; i<loc; i++) {
			tmp_opt += result[i];
		}
		
		result = result + (i+1);
				
		/*if (tmp_opt == "option") {
			document.options.option = atoi(result);
		}*/
		result = strtok(NULL, ";");
	}
	
	// Parse data.
	while (!input->eof() && (strcspn(buffer, "\n") != 0)) {
		// Ignore extra lines for possible future protocol enchancements.
		input->getline(buffer, length);
	}
	if (strcspn(buffer, "\n") == 0) {
		int datalen = length-(input->tellg());
		input->read(buffer, datalen);
		buffer[datalen] = '\0';
		document.data = buffer;
	} else {
		free(buffer);
		return EPD_PARSE_NODOC;
	}
	
	free(buffer);
	return EPD_PARSE_OK;
}
