/*
	Copyright (c) 2010 by Dennis Schridde

	This file is part of dovecot-metadata.

	dovecot-metadata is free software: you can redistribute it and/or modify
	it under the terms of the GNU Lesser General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	dovecot-metadata is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU Lesser General Public License for more details.

	You should have received a copy of the GNU Lesser General Public License
	along with dovecot-metadata.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "metadata-global.h"

#include "mail-storage-hooks.h"

#include "metadata-mail-user-module.h"
#include "metadata-mail-storage-module.h"

#ifdef DOVECOT_ABI_VERSION
const char *metadata_plugin_version = DOVECOT_ABI_VERSION;
#else
const char *metadata_plugin_version = DOVECOT_VERSION;
#endif

static struct mail_storage_hooks metadata_mail_storage_hooks = {
	.mail_user_created = metadata_mail_user_created,
	.mailbox_allocated = metadata_mailbox_allocated
};

void metadata_plugin_init(struct module *module)
{
	mail_storage_hooks_add(module, &metadata_mail_storage_hooks);
}

void metadata_plugin_deinit(void)
{
	mail_storage_hooks_remove(&metadata_mail_storage_hooks);
}
