from re import compile, IGNORECASE, DOTALL

from dosage.helpers import BasicScraper, queryNamer


class WayfarersMoon(BasicScraper):
    latestUrl = 'http://www.wayfarersmoon.com/'
    imageUrl = 'http://www.wayfarersmoon.com/index.php\?page=%s'
    imageSearch = compile(r'<img src="(/admin.+?)"')
    prevSearch = compile(r'<a href="(.+?)".+?btn_back.gif')
    help = 'Index format: nn'


class WhiteNinja(BasicScraper):
    latestUrl = 'http://www.whiteninjacomics.com/comics.shtml'
    imageUrl = 'http://www.whiteninjacomics.com/comics/%s.shtml'
    imageSearch = compile(r'<img src=(/images/comics/(?!t-).+?\.gif) border=0')
    prevSearch = compile(r'(/comics/.+?shtml).+?previous')
    help = 'Index format: s (comic name)'


class WhyTheLongFace(BasicScraper):
    latestUrl = 'http://www.absurdnotions.org/'
    imageUrl = 'http://www.absurdnotions.org/wtlf%s.html'
    imageSearch = compile(r'<IMG SRC="(lf\d+\..+?)"')
    prevSearch = compile(r'<A.*?HREF="(wtlf\d+\.html)"><img SRC="nprev\.gif"')
    help = 'Index format: yyyymm'


class Wigu(BasicScraper):
    latestUrl = 'http://www.wigu.com/wigu/'
    imageUrl = 'http://www.wigu.com/wigu/?date=%s'
    imageSearch = compile(r'<img src="(strips/\d{8}\..+?)" alt=""')
    prevSearch = compile(r'<a href="(\?date=\d{8})" class=comic>< PREVIOUS COMIC')
    help = 'Index format: yyyymmdd'


class WiguTV(BasicScraper):
    latestUrl = 'http://jjrowland.com/'
    imageUrl = 'http://jjrowland.com/archive/%s.html'
    imageSearch = compile(r'"(/comics/.+?)"')
    prevSearch = compile(r'nbsp;<a href="(/archive/.+?)".+?previous')
    help = 'Index format: yyyymmdd'

class WotNow(BasicScraper):
    latestUrl = 'http://www.shadowburn.com/wotnow/'
    imageUrl = 'http://www.shadowburn.com/wotnow/comic.php?comic_id=%s'
    imageSearch = compile(r'<IMG SRC="(comics/wn\d{4}\..+?)"')
    prevSearch = compile(r'HREF="(/wotnow/comic.php\?comic_id=\d+)"><IMG SRC="images/b_prev.gif"')
    help = 'Index format: n (unpadded)'


class Winter(BasicScraper):
    latestUrl = 'http://www.wintercomic.com/'
    imageUrl = 'http://www.wintercomic.com/index.php?strip_id=%s'
    imageSearch = compile(r'<img src=\'(/index\.php\?do_command=show_strip&strip_id=\d+.+?)\'')
    prevSearch = compile(r'<a href=[\'"](/?index\.php\?strip_id=\d+)[\'"]><img.+?src=[\'"]\./img/lastpage.gif[\'"]')
    help = 'Index format: n (unpadded)'
    namer = queryNamer('strip_id')


class Wulffmorgenthaler(BasicScraper):
    latestUrl = 'http://www.wulffmorgenthaler.com/'
    imageUrl = 'http://www.wulffmorgenthaler.com/Default.aspx?id=%s'
    imageSearch = compile(r'img id="ctl00_content_Strip1_imgStrip".+?class="strip" src="(striphandler\.ashx\?stripid=[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12})"')
    prevSearch = compile(r'<a href="(/Default\.aspx\?id=[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12})" id="ctl00_content_Strip1_aPrev">')
    help = 'Index format: xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx (GUID)'
    namer = queryNamer('stripid')


def webcomicsNation():
    class WebcomicsNation(BasicScraper):
        imageSearch = compile(r'<a name="strip\d*?">.*?<img[^>]+?src="([^"]*?memberimages/.+?)"', IGNORECASE + DOTALL)
        prevSearch = compile(r'href="([^"]*?whichbutton=prev[^"]*?)"', IGNORECASE)
        help = 'Index format: nnnn (non-contiguous)'

        @property
        def imageUrl(self):
            return self.baseUrl + '?view=archive&amp;chapter=%s'

    comics = {
        'AgnesQuill': 'daveroman/agnes/',
        'Elvenbaath': 'tdotodot2k/elvenbaath/',
        'IrrationalFears': 'uvernon/irrationalfears/',
        'KismetHuntersMoon': 'laylalawlor/huntersmoon/',
        'SaikoAndLavender': 'gc/saiko/',
        'MyMuse': 'gc/muse/',
        'NekkoAndJoruba': 'nekkoandjoruba/nekkoandjoruba/',
        'JaxEpoch': 'johngreen/quicken/',
        'QuantumRockOfAges': 'DreamchildNYC/quantum/',
        }

    return dict((name, WebcomicsNation.make('WebcomicsNation/' + name, latestUrl='http://www.webcomicsnation.com/' + subpath)) for name, subpath in comics.iteritems())

globals().update(webcomicsNation())
