from re import compile, IGNORECASE

from dosage.helpers import BasicScraper, bounceStarter
from dosage.util import getQueryParams


class UnderPower(BasicScraper):
    latestUrl = 'http://underpower.non-essential.com/'
    imageUrl = 'http://underpower.non-essential.com/index.php?comic=%s'
    imageSearch = compile(r'<img src="(comics/\d{8}\..+?)"')
    prevSearch = compile(r'<a href="(/index.php\?comic=\d{8})"><img src="images/previous-comic\.gif"')
    help = 'Index format: yyyymmdd'


class UnicornJelly(BasicScraper):
    latestUrl = 'http://unicornjelly.com/uni666.html'
    imageUrl = 'http://unicornjelly.com/uni%s.html'
    imageSearch = compile(r'</TABLE>(?:<FONT COLOR="BLACK">)?<IMG SRC="(images/[^"]+)" WIDTH=')
    prevSearch = compile(r'<A HREF="(uni\d{3}[bcs]?\.html)">(<FONT COLOR="BLACK">)?<IMG SRC="images/back00\.gif"')
    help = 'Index format: nnn'


class UserFriendly(BasicScraper):
    starter = bounceStarter('http://ars.userfriendly.org/cartoons/?mode=classic', compile(r'<area shape="rect" href="(/cartoons/\?id=\d{8}&mode=classic)" coords="[\d, ]+?" alt="">'))
    imageUrl = 'http://ars.userfriendly.org/cartoons/?id=%s&mode=classic'
    imageSearch = compile(r'<img border="0" src="(http://www.userfriendly.org/cartoons/archives/\d{2}\w{3}/.+?\.gif)"')
    prevSearch = compile(r'<area shape="rect" href="(/cartoons/\?id=\d{8}&mode=classic)" coords="[\d, ]+?" alt="Previous Cartoon">')
    help = 'Index format: yyyymmdd'

    def namer(cls, imageUrl, pageUrl):
        return 'uf%s' % (getQueryParams(pageUrl)['id'][0][2:],)


class UndeadFriend(BasicScraper):
    latestUrl = 'http://www.undeadfriend.com/'
    imageUrl = 'http://www.undeadfriend.com/d/%s.html'
    imageSearch = compile(r'src="(http://www\.undeadfriend\.com/comics/.+?)"', IGNORECASE)
    prevSearch = compile(r'<a.+?href="(http://www\.undeadfriend\.com/d/\d+?\.html)"><img border="0" name="previous_day" alt="Previous comic" src="http://www\.undeadfriend\.com/images/previous_day\.jpg', IGNORECASE)
    help = 'Index format: yyyymmdd'
