from re import compile

from dosage.helpers import BasicScraper, bounceStarter


class RWWR(BasicScraper):
    latestUrl = 'http://www.rwwr.com/'
    imageUrl = 'http://www.rwwr.com/view.php?comic=%s'
    imageSearch = compile(r'(http.+?/strips/.+?)>')
    prevSearch = compile(r'"(view.+?)".+?back')
    help = 'Index format: nnn'


class RabidMonkeys(BasicScraper):
    latestUrl = 'http://www.rabid-monkeys.com/'
    imageUrl = 'http://rabid-monkeys.com/?file=%s'
    imageSearch = compile(r"\'(comics/.*?)\'")
    prevSearch = compile(r"</a><a href=\'(\?file=.*?)\'.*?nav-prev")
    help = 'Index format: nnnn'


class RadioactivePanda(BasicScraper):
    latestUrl = 'http://www.radioactivepanda.com/'
    imageUrl = 'http://www.radioactivepanda.com/comic/%s'
    imageSearch = compile(r'<img src="(/Assets/.*?)".+?"comicimg"')
    prevSearch = compile(r'<a href="(/comic/.*?)".+?previous_btn')
    help = 'Index format: n (no padding)'


class RealLife(BasicScraper):
    latestUrl = 'http://www.reallifecomics.com/'
    imageUrl = 'http://www.reallifecomics.com/achive/%s.html'
    imageSearch = compile(r'"(/comics/.+?)"')
    prevSearch = compile(r'"(/archive/.+?)".+?nav_previous')
    help = 'Index format: yymmdd)'


class RedString(BasicScraper):
    latestUrl = 'http://redstring.strawberrycomics.com/index.html'
    imageUrl = 'http://redstring.strawberrycomics.com/comic/%s.html'
    imageSearch = compile(r'<IMG SRC="(.+?.jpg)" width="50')
    prevSearch = compile(r'\*  <a href="(.+?)">PREVIOUS')
    help = 'Index format: chnn-pnn'


class Roza(BasicScraper):
    latestUrl = 'http://www.junglestudio.com/roza/index.php'
    imageUrl = 'http://www.junglestudio.com/roza/index.php\?date=%s'
    imageSearch = compile(r'<img src="(pages/.+?)"')
    prevSearch = compile(r'<a href="(index.php\?date=.+?)">[^>].+?navtable_01.gif')
    help = 'Index format: yyyy-mm-dd'


class RedMeat(BasicScraper):
    starter = bounceStarter('http://www.redmeat.com/redmeat/current/index.html', compile(r'<a href="(\.\./\d{4}-\d{2}-\d{2}/index\.html)">next</a>'))
    imageUrl = 'http://www.redmeat.com/redmeat/%s/index.html'
    imageSearch = compile(r'<img src="(index-1\.gif)" width="\d+" height="\d+" [^>]*>')
    prevSearch = compile(r'<a href="(\.\./\d{4}-\d{2}-\d{2}/index\.html)">previous</a>')
    help = 'Index format: yyyy-mm-dd'

    def namer(cls, imageUrl, pageUrl):
        return imageUrl.split('/')[-2]
