from re import compile

from dosage.helpers import BasicScraper


class QuestionableContent(BasicScraper):
    latestUrl = 'http://www.questionablecontent.net/'
    imageUrl = 'http://www.questionablecontent.net/view.php?comic=%s'
    imageSearch = compile(r'<img src="((?:http://www\.questionablecontent\.net|\.{1,2})/comics/\d+\.png)"')
    prevSearch = compile(r'<a href="(view.php\?comic=\d+)">Previous')
    help = 'Index format: n (unpadded)'


class Qwantz(BasicScraper):
    latestUrl = 'http://www.qwantz.com/'
    imageUrl = 'http://www.qwantz.com/index.pl?comic=%s'
    imageSearch = compile(r'"(http://www.qwantz.com/comics/.+?)"')
    prevSearch = compile(r'(/archive/.+?)">previous')
    help = 'Index format: n'
