from re import compile

from dosage.helpers import BasicScraper


class Heliothaumic(BasicScraper):
    latestUrl = 'http://thaumic.net/'
    imageUrl = 'http://thaumic.net/%s'
    imageSearch = compile(r"'(http://thaumic.net/comics/.+?)'")
    prevSearch = compile(r'(http://thaumic.net/.+?)".+?Prev')
    help = 'Index format: yyyy/mm/dd/n(unpadded)-comicname'


class Housd(BasicScraper):
    latestUrl = 'http://www.housd.net/'
    imageUrl = 'http://housd.net/archive_page.php?comicID=%s'
    imageSearch = compile(r'"(.+?/comics/.+?)"')
    prevSearch = compile(r'"(h.+?comicID=.+?)".+?prev')
    help = 'Index format: nnnn'
