-- Copyright (C) 2001-2004 Rodolphe Quiedeville <rodolphe@quiedeville.org>
-- Copyright (C) 2003      Jean-Louis Bergamo   <jlb@j1b.org>
-- Copyright (C) 2004-2009 Laurent Destailleur  <eldy@users.sourceforge.net>
-- Copyright (C) 2004      Benoit Mortier       <benoit.mortier@opensides.be>
-- Copyright (C) 2004      Guillaume Delecourt  <guillaume.delecourt@opensides.be>
-- Copyright (C) 2005-2009 Regis Houssin        <regis.houssin@capnetworks.com>
-- Copyright (C) 2007 	   Patrick Raguin       <patrick.raguin@gmail.com>
-- Copyright (C) 2011-2016 Alexandre Spangaro   <aspangaro.dolibarr@gmail.com>
--
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program. If not, see <http://www.gnu.org/licenses/>.
--
--

--
-- Ne pas placer de commentaire en fin de ligne, ce fichier est parsé lors
-- de l'install et tous les sigles '--' sont supprimés.
--

delete from llx_accounting_account;
delete from llx_accounting_system;

--
-- Descriptif des plans comptables FR PCG99-ABREGE
--

INSERT INTO llx_accounting_system (rowid, pcg_version, label, active) VALUES (1,'PCG99-ABREGE', 'The simple accountancy french plan', 1);

INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (  1,'PCG99-ABREGE','CAPIT', 'CAPITAL', '101', '1401', 'Capital', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (  2,'PCG99-ABREGE','CAPIT', 'XXXXXX',  '105', '1401', 'Ecarts de réévaluation', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (  3,'PCG99-ABREGE','CAPIT', 'XXXXXX', '1061', '1401', 'Réserve légale', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (  4,'PCG99-ABREGE','CAPIT', 'XXXXXX', '1063', '1401', 'Réserves statutaires ou contractuelles', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (  5,'PCG99-ABREGE','CAPIT', 'XXXXXX', '1064', '1401', 'Réserves réglementées', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (  6,'PCG99-ABREGE','CAPIT', 'XXXXXX', '1068', '1401', 'Autres réserves', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (  7,'PCG99-ABREGE','CAPIT', 'XXXXXX',  '108', '1401', 'Compte de l''exploitant', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (  8,'PCG99-ABREGE','CAPIT', 'XXXXXX',   '12', '1401', 'Résultat de l''exercice', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (  9,'PCG99-ABREGE','CAPIT', 'XXXXXX',  '145', '1401', 'Amortissements dérogatoires', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 10,'PCG99-ABREGE','CAPIT', 'XXXXXX',  '146', '1401', 'Provision spéciale de réévaluation', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 11,'PCG99-ABREGE','CAPIT', 'XXXXXX',  '147', '1401', 'Plus-values réinvesties', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 12,'PCG99-ABREGE','CAPIT', 'XXXXXX',  '148', '1401', 'Autres provisions réglementées', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 13,'PCG99-ABREGE','CAPIT', 'XXXXXX',   '15', '1401', 'Provisions pour risques et charges', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 14,'PCG99-ABREGE','CAPIT', 'XXXXXX',   '16', '1401', 'Emprunts et dettes assimilees', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 15,'PCG99-ABREGE','IMMO',  'XXXXXX',   '20', '1402', 'Immobilisations incorporelles', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 16,'PCG99-ABREGE','IMMO',  'XXXXXX',  '201',	'15', 'Frais d''établissement', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 17,'PCG99-ABREGE','IMMO',  'XXXXXX',  '206',	'15', 'Droit au bail', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 18,'PCG99-ABREGE','IMMO',  'XXXXXX',  '207',	'15', 'Fonds commercial', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 19,'PCG99-ABREGE','IMMO',  'XXXXXX',  '208',	'15', 'Autres immobilisations incorporelles', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 20,'PCG99-ABREGE','IMMO',  'XXXXXX',   '21', '1402', 'Immobilisations corporelles', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 21,'PCG99-ABREGE','IMMO',  'XXXXXX',   '23', '1402', 'Immobilisations en cours', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 22,'PCG99-ABREGE','IMMO',  'XXXXXX',   '27', '1402', 'Autres immobilisations financieres', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 23,'PCG99-ABREGE','IMMO',  'XXXXXX',  '280', '1402', 'Amortissements des immobilisations incorporelles', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 24,'PCG99-ABREGE','IMMO',  'XXXXXX',  '281', '1402', 'Amortissements des immobilisations corporelles', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 25,'PCG99-ABREGE','IMMO',  'XXXXXX',  '290', '1402', 'Provisions pour dépréciation des immobilisations incorporelles', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 26,'PCG99-ABREGE','IMMO',  'XXXXXX',  '291', '1402', 'Provisions pour dépréciation des immobilisations corporelles', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 27,'PCG99-ABREGE','IMMO',  'XXXXXX',  '297', '1402', 'Provisions pour dépréciation des autres immobilisations financières', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 28,'PCG99-ABREGE','STOCK', 'XXXXXX',   '31', '1403', 'Matieres premières', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 29,'PCG99-ABREGE','STOCK', 'XXXXXX',   '32', '1403', 'Autres approvisionnements', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 30,'PCG99-ABREGE','STOCK', 'XXXXXX',   '33', '1403', 'En-cours de production de biens', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 31,'PCG99-ABREGE','STOCK', 'XXXXXX',   '34', '1403', 'En-cours de production de services', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 32,'PCG99-ABREGE','STOCK', 'XXXXXX',   '35', '1403', 'Stocks de produits', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 33,'PCG99-ABREGE','STOCK', 'XXXXXX',   '37', '1403', 'Stocks de marchandises', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 34,'PCG99-ABREGE','STOCK', 'XXXXXX',  '391', '1403', 'Provisions pour dépréciation des matières premières', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 35,'PCG99-ABREGE','STOCK', 'XXXXXX',  '392', '1403', 'Provisions pour dépréciation des autres approvisionnements', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 36,'PCG99-ABREGE','STOCK', 'XXXXXX',  '393', '1403', 'Provisions pour dépréciation des en-cours de production de biens', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 37,'PCG99-ABREGE','STOCK', 'XXXXXX',  '394', '1403', 'Provisions pour dépréciation des en-cours de production de services', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 38,'PCG99-ABREGE','STOCK', 'XXXXXX',  '395', '1403', 'Provisions pour dépréciation des stocks de produits', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 39,'PCG99-ABREGE','STOCK', 'XXXXXX',  '397', '1403', 'Provisions pour dépréciation des stocks de marchandises', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 40,'PCG99-ABREGE','TIERS', 'SUPPLIER','400', '1404', 'Fournisseurs et Comptes rattachés', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 41,'PCG99-ABREGE','TIERS', 'XXXXXX',  '409', '1404', 'Fournisseurs débiteurs', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 42,'PCG99-ABREGE','TIERS', 'CUSTOMER','410', '1404', 'Clients et Comptes rattachés', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 43,'PCG99-ABREGE','TIERS', 'XXXXXX',  '419', '1404', 'Clients créditeurs', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 44,'PCG99-ABREGE','TIERS', 'XXXXXX',  '421', '1404', 'Personnel', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 45,'PCG99-ABREGE','TIERS', 'XXXXXX',  '428', '1404', 'Personnel', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 46,'PCG99-ABREGE','TIERS', 'XXXXXX',   '43', '1404', 'Sécurité sociale et autres organismes sociaux', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 47,'PCG99-ABREGE','TIERS', 'XXXXXX',  '444', '1404', 'Etat - impôts sur bénéfice', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 48,'PCG99-ABREGE','TIERS', 'XXXXXX',  '445', '1404', 'Etat - Taxes sur chiffre affaires', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 49,'PCG99-ABREGE','TIERS', 'XXXXXX',  '447', '1404', 'Autres impôts, taxes et versements assimilés', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 50,'PCG99-ABREGE','TIERS', 'XXXXXX',   '45', '1404', 'Groupe et associes', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 51,'PCG99-ABREGE','TIERS', 'XXXXXX',  '455',	'50', 'Associés', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 52,'PCG99-ABREGE','TIERS', 'XXXXXX',   '46', '1404', 'Débiteurs divers et créditeurs divers', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 53,'PCG99-ABREGE','TIERS', 'XXXXXX',   '47', '1404', 'Comptes transitoires ou d''attente', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 54,'PCG99-ABREGE','TIERS', 'XXXXXX',  '481', '1404', 'Charges à répartir sur plusieurs exercices', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 55,'PCG99-ABREGE','TIERS', 'XXXXXX',  '486', '1404', 'Charges constatées d''avance', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 56,'PCG99-ABREGE','TIERS', 'XXXXXX',  '487', '1404', 'Produits constatés d''avance', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 57,'PCG99-ABREGE','TIERS', 'XXXXXX',  '491', '1404', 'Provisions pour dépréciation des comptes de clients', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 58,'PCG99-ABREGE','TIERS', 'XXXXXX',  '496', '1404', 'Provisions pour dépréciation des comptes de débiteurs divers', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 59,'PCG99-ABREGE','FINAN', 'XXXXXX',   '50', '1405', 'Valeurs mobilières de placement', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 60,'PCG99-ABREGE','FINAN', 'BANK',     '51', '1405', 'Banques, établissements financiers et assimilés', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 61,'PCG99-ABREGE','FINAN', 'CASH',     '53', '1405', 'Caisse', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 62,'PCG99-ABREGE','FINAN', 'XXXXXX',   '54', '1405', 'Régies d''avance et accréditifs', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 63,'PCG99-ABREGE','FINAN', 'XXXXXX',   '58', '1405', 'Virements internes', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 64,'PCG99-ABREGE','FINAN', 'XXXXXX',  '590', '1405', 'Provisions pour dépréciation des valeurs mobilières de placement', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 65,'PCG99-ABREGE','CHARGE','PRODUCT',  '60', '1406', 'Achats', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 66,'PCG99-ABREGE','CHARGE','XXXXXX',  '603',	'65', 'Variations des stocks', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 67,'PCG99-ABREGE','CHARGE','SERVICE',  '61', '1406', 'Services extérieurs', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 68,'PCG99-ABREGE','CHARGE','XXXXXX',   '62', '1406', 'Autres services extérieurs', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 69,'PCG99-ABREGE','CHARGE','XXXXXX',   '63', '1406', 'Impôts, taxes et versements assimiles', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 70,'PCG99-ABREGE','CHARGE','XXXXXX',  '641', '1406', 'Rémunérations du personnel', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 71,'PCG99-ABREGE','CHARGE','XXXXXX',  '644', '1406', 'Rémunération du travail de l''exploitant', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 72,'PCG99-ABREGE','CHARGE','SOCIAL',  '645', '1406', 'Charges de sécurité sociale et de prévoyance', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 73,'PCG99-ABREGE','CHARGE','XXXXXX',  '646', '1406', 'Cotisations sociales personnelles de l''exploitant', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 74,'PCG99-ABREGE','CHARGE','XXXXXX',   '65', '1406', 'Autres charges de gestion courante', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 75,'PCG99-ABREGE','CHARGE','XXXXXX',   '66', '1406', 'Charges financières', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 76,'PCG99-ABREGE','CHARGE','XXXXXX',   '67', '1406', 'Charges exceptionnelles', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 77,'PCG99-ABREGE','CHARGE','XXXXXX',  '681', '1406', 'Dotations aux amortissements et aux provisions', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 78,'PCG99-ABREGE','CHARGE','XXXXXX',  '686', '1406', 'Dotations aux amortissements et aux provisions', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 79,'PCG99-ABREGE','CHARGE','XXXXXX',  '687', '1406', 'Dotations aux amortissements et aux provisions', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 80,'PCG99-ABREGE','CHARGE','XXXXXX',  '691', '1406', 'Participation des salariés aux résultats', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 81,'PCG99-ABREGE','CHARGE','XXXXXX',  '695', '1406', 'Impôts sur les bénéfices', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 82,'PCG99-ABREGE','CHARGE','XXXXXX',  '697', '1406', 'Imposition forfaitaire annuelle des sociétés', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 83,'PCG99-ABREGE','CHARGE','XXXXXX',  '699', '1406', 'Produits', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 84,'PCG99-ABREGE','PROD',  'PRODUCT', '701', '1407', 'Ventes de produits finis', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 85,'PCG99-ABREGE','PROD',  'SERVICE', '706', '1407', 'Prestations de services', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 86,'PCG99-ABREGE','PROD',  'PRODUCT', '707', '1407', 'Ventes de marchandises', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 87,'PCG99-ABREGE','PROD',  'PRODUCT', '708', '1407', 'Produits des activités annexes', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 88,'PCG99-ABREGE','PROD',  'XXXXXX',  '709', '1407', 'Rabais, remises et ristournes accordés par l''entreprise', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 89,'PCG99-ABREGE','PROD',  'XXXXXX',  '713', '1407', 'Variation des stocks', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 90,'PCG99-ABREGE','PROD',  'XXXXXX',   '72', '1407', 'Production immobilisée', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 91,'PCG99-ABREGE','PROD',  'XXXXXX',   '73', '1407', 'Produits nets partiels sur opérations à long terme', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 92,'PCG99-ABREGE','PROD',  'XXXXXX',   '74', '1407', 'Subventions d''exploitation', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 93,'PCG99-ABREGE','PROD',  'XXXXXX',   '75', '1407', 'Autres produits de gestion courante', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 94,'PCG99-ABREGE','PROD',  'XXXXXX',  '753', 	'93', 'Jetons de présence et rémunérations d''administrateurs, gérants,...', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 95,'PCG99-ABREGE','PROD',  'XXXXXX',  '754',	'93', 'Ristournes perçues des coopératives', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 96,'PCG99-ABREGE','PROD',  'XXXXXX',  '755',	'93', 'Quotes-parts de résultat sur opérations faites en commun', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 97,'PCG99-ABREGE','PROD',  'XXXXXX',   '76', '1407', 'Produits financiers', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 98,'PCG99-ABREGE','PROD',  'XXXXXX',   '77', '1407', 'Produits exceptionnels', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES ( 99,'PCG99-ABREGE','PROD',  'XXXXXX',  '781', '1407', 'Reprises sur amortissements et provisions', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (100,'PCG99-ABREGE','PROD',  'XXXXXX',  '786', '1407', 'Reprises sur provisions pour risques', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (101,'PCG99-ABREGE','PROD',  'XXXXXX',  '787', '1407', 'Reprises sur provisions', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (102,'PCG99-ABREGE','PROD',  'XXXXXX',   '79', '1407', 'Transferts de charges', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1401,'PCG99-ABREGE','CAPIT', 'XXXXXX', '1', '0', 'Fonds propres, provisions pour risques et charges et dettes à plus d''un an', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1402,'PCG99-ABREGE','IMMO',  'XXXXXX', '2', '0', 'Frais d''établissement. Actifs immobilisés et créances à plus d''un an', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1403,'PCG99-ABREGE','STOCK', 'XXXXXX', '3', '0', 'Stock et commandes en cours d''exécution', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1404,'PCG99-ABREGE','TIERS', 'XXXXXX', '4', '0', 'Créances et dettes à un an au plus', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1405,'PCG99-ABREGE','FINAN', 'XXXXXX', '5', '0', 'Placement de trésorerie et de valeurs disponibles', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1406,'PCG99-ABREGE','CHARGE','XXXXXX', '6', '0', 'Charges', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1407,'PCG99-ABREGE','PROD',  'XXXXXX', '7', '0', 'Produits', 1);

--
-- Descriptif des plans comptables FR PCG99-BASE
--

INSERT INTO llx_accounting_system (rowid, pcg_version, label, active) VALUES (2,'PCG99-BASE', 'The base accountancy french plan', 1);

INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (103,'PCG99-BASE','CAPIT', 'XXXXXX',   '10','1501', 'Capital  et réserves', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (104,'PCG99-BASE','CAPIT', 'CAPITAL', '101', '103', 'Capital', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (105,'PCG99-BASE','CAPIT', 'XXXXXX',  '104', '103', 'Primes liées au capital social', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (106,'PCG99-BASE','CAPIT', 'XXXXXX',  '105', '103', 'Ecarts de réévaluation', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (107,'PCG99-BASE','CAPIT', 'XXXXXX',  '106', '103', 'Réserves', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (108,'PCG99-BASE','CAPIT', 'XXXXXX',  '107', '103', 'Ecart d''equivalence', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (109,'PCG99-BASE','CAPIT', 'XXXXXX',  '108', '103', 'Compte de l''exploitant', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (110,'PCG99-BASE','CAPIT', 'XXXXXX',  '109', '103', 'Actionnaires : capital souscrit - non appelé', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (111,'PCG99-BASE','CAPIT', 'XXXXXX',   '11','1501', 'Report à nouveau (solde créditeur ou débiteur)', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (112,'PCG99-BASE','CAPIT', 'XXXXXX',  '110', '111', 'Report à nouveau (solde créditeur)', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (113,'PCG99-BASE','CAPIT', 'XXXXXX',  '119', '111', 'Report à nouveau (solde débiteur)', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (114,'PCG99-BASE','CAPIT', 'XXXXXX',   '12','1501', 'Résultat de l''exercice (bénéfice ou perte)', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (115,'PCG99-BASE','CAPIT', 'XXXXXX',  '120', '114', 'Résultat de l''exercice (bénéfice)', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (116,'PCG99-BASE','CAPIT', 'XXXXXX',  '129', '114', 'Résultat de l''exercice (perte)', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (117,'PCG99-BASE','CAPIT', 'XXXXXX',   '13','1501', 'Subventions d''investissement', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (118,'PCG99-BASE','CAPIT', 'XXXXXX',  '131', '117', 'Subventions d''équipement', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (119,'PCG99-BASE','CAPIT', 'XXXXXX',  '138', '117', 'Autres subventions d''investissement', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (120,'PCG99-BASE','CAPIT', 'XXXXXX',  '139', '117', 'Subventions d''investissement inscrites au compte de résultat', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (121,'PCG99-BASE','CAPIT', 'XXXXXX',   '14','1501', 'Provisions réglementées', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (122,'PCG99-BASE','CAPIT', 'XXXXXX',  '142', '121', 'Provisions réglementées relatives aux immobilisations', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (123,'PCG99-BASE','CAPIT', 'XXXXXX',  '143', '121', 'Provisions réglementées relatives aux stocks', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (124,'PCG99-BASE','CAPIT', 'XXXXXX',  '144', '121', 'Provisions réglementées relatives aux autres éléments de l''actif', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (125,'PCG99-BASE','CAPIT', 'XXXXXX',  '145', '121', 'Amortissements dérogatoires', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (126,'PCG99-BASE','CAPIT', 'XXXXXX',  '146', '121', 'Provision spéciale de réévaluation', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (127,'PCG99-BASE','CAPIT', 'XXXXXX',  '147', '121', 'Plus-values réinvesties', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (128,'PCG99-BASE','CAPIT', 'XXXXXX',  '148', '121', 'Autres provisions réglementées', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (129,'PCG99-BASE','CAPIT', 'XXXXXX',   '15','1501', 'Provisions pour risques et charges', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (130,'PCG99-BASE','CAPIT', 'XXXXXX',  '151', '129', 'Provisions pour risques', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (131,'PCG99-BASE','CAPIT', 'XXXXXX',  '153', '129', 'Provisions pour pensions et obligations similaires', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (132,'PCG99-BASE','CAPIT', 'XXXXXX',  '154', '129', 'Provisions pour restructurations', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (133,'PCG99-BASE','CAPIT', 'XXXXXX',  '155', '129', 'Provisions pour impôts', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (134,'PCG99-BASE','CAPIT', 'XXXXXX',  '156', '129', 'Provisions pour renouvellement des immobilisations (entreprises concessionnaires)', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (135,'PCG99-BASE','CAPIT', 'XXXXXX',  '157', '129', 'Provisions pour charges à répartir sur plusieurs exercices', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (136,'PCG99-BASE','CAPIT', 'XXXXXX',  '158', '129', 'Autres provisions pour charges', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (137,'PCG99-BASE','CAPIT', 'XXXXXX',   '16','1501', 'Emprunts et dettes assimilees', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (138,'PCG99-BASE','CAPIT', 'XXXXXX',  '161', '137', 'Emprunts obligataires convertibles', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (139,'PCG99-BASE','CAPIT', 'XXXXXX',  '163', '137', 'Autres emprunts obligataires', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (140,'PCG99-BASE','CAPIT', 'XXXXXX',  '164', '137', 'Emprunts auprès des établissements de crédit', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (141,'PCG99-BASE','CAPIT', 'XXXXXX',  '165', '137', 'Dépôts et cautionnements reçus', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (142,'PCG99-BASE','CAPIT', 'XXXXXX',  '166', '137', 'Participation des salariés aux résultats', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (143,'PCG99-BASE','CAPIT', 'XXXXXX',  '167', '137', 'Emprunts et dettes assortis de conditions particulières', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (144,'PCG99-BASE','CAPIT', 'XXXXXX',  '168', '137', 'Autres emprunts et dettes assimilées', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (145,'PCG99-BASE','CAPIT', 'XXXXXX',  '169', '137', 'Primes de remboursement des obligations', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (146,'PCG99-BASE','CAPIT', 'XXXXXX',   '17','1501', 'Dettes rattachées à des participations', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (147,'PCG99-BASE','CAPIT', 'XXXXXX',  '171', '146', 'Dettes rattachées à des participations (groupe)', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (148,'PCG99-BASE','CAPIT', 'XXXXXX',  '174', '146', 'Dettes rattachées à des participations (hors groupe)', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (149,'PCG99-BASE','CAPIT', 'XXXXXX',  '178', '146', 'Dettes rattachées à des sociétés en participation', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (150,'PCG99-BASE','CAPIT', 'XXXXXX',   '18','1501', 'Comptes de liaison des établissements et sociétés en participation', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (151,'PCG99-BASE','CAPIT', 'XXXXXX',  '181', '150', 'Comptes de liaison des établissements', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (152,'PCG99-BASE','CAPIT', 'XXXXXX',  '186', '150', 'Biens et prestations de services échangés entre établissements (charges)', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (153,'PCG99-BASE','CAPIT', 'XXXXXX',  '187', '150', 'Biens et prestations de services échangés entre établissements (produits)', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (154,'PCG99-BASE','CAPIT', 'XXXXXX',  '188', '150', 'Comptes de liaison des sociétés en participation', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (155,'PCG99-BASE','IMMO',  'XXXXXX',   '20','1502', 'Immobilisations incorporelles', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (156,'PCG99-BASE','IMMO',  'XXXXXX',  '201', '155', 'Frais d''établissement', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (157,'PCG99-BASE','IMMO',  'XXXXXX',  '203', '155', 'Frais de recherche et de développement', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (158,'PCG99-BASE','IMMO',  'XXXXXX',  '205', '155', 'Concessions et droits similaires, brevets, licences, marques, procédés, logiciels, droits et valeurs similaires', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (159,'PCG99-BASE','IMMO',  'XXXXXX',  '206', '155', 'Droit au bail', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (160,'PCG99-BASE','IMMO',  'XXXXXX',  '207', '155', 'Fonds commercial', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (161,'PCG99-BASE','IMMO',  'XXXXXX',  '208', '155', 'Autres immobilisations incorporelles', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (162,'PCG99-BASE','IMMO',  'XXXXXX',   '21','1502', 'Immobilisations corporelles', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (163,'PCG99-BASE','IMMO',  'XXXXXX',  '211', '162', 'Terrains', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (164,'PCG99-BASE','IMMO',  'XXXXXX',  '212', '162', 'Agencements et aménagements de terrains', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (165,'PCG99-BASE','IMMO',  'XXXXXX',  '213', '162', 'Constructions', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (166,'PCG99-BASE','IMMO',  'XXXXXX',  '214', '162', 'Constructions sur sol d''autrui', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (167,'PCG99-BASE','IMMO',  'XXXXXX',  '215', '162', 'Installations techniques, matériels et outillage industriels', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (168,'PCG99-BASE','IMMO',  'XXXXXX',  '218', '162', 'Autres immobilisations corporelles', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (169,'PCG99-BASE','IMMO',  'XXXXXX',   '22','1502', 'Immobilisations mises en concession', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (170,'PCG99-BASE','IMMO',  'XXXXXX',   '23','1502', 'Immobilisations en cours', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (171,'PCG99-BASE','IMMO',  'XXXXXX',  '231', '170', 'Immobilisations corporelles en cours', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (172,'PCG99-BASE','IMMO',  'XXXXXX',  '232', '170', 'Immobilisations incorporelles en cours', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (173,'PCG99-BASE','IMMO',  'XXXXXX',  '237', '170', 'Avances et acomptes versés sur immobilisations incorporelles', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (174,'PCG99-BASE','IMMO',  'XXXXXX',  '238', '170', 'Avances et acomptes versés sur commandes d''immobilisations corporelles', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (175,'PCG99-BASE','IMMO',  'XXXXXX',   '25','1502', 'Parts dans des entreprises liées et créances sur des entreprises liées', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (176,'PCG99-BASE','IMMO',  'XXXXXX',   '26','1502', 'Participations et créances rattachées à des participations', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (177,'PCG99-BASE','IMMO',  'XXXXXX',  '261', '176', 'Titres de participation', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (178,'PCG99-BASE','IMMO',  'XXXXXX',  '266', '176', 'Autres formes de participation', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (179,'PCG99-BASE','IMMO',  'XXXXXX',  '267', '176', 'Créances rattachées à des participations', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (180,'PCG99-BASE','IMMO',  'XXXXXX',  '268', '176', 'Créances rattachées à des sociétés en participation', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (181,'PCG99-BASE','IMMO',  'XXXXXX',  '269', '176', 'Versements restant à effectuer sur titres de participation non libérés', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (182,'PCG99-BASE','IMMO',  'XXXXXX',   '27','1502', 'Autres immobilisations financieres', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (183,'PCG99-BASE','IMMO',  'XXXXXX',  '271', '183', 'Titres immobilisés autres que les titres immobilisés de l''activité de portefeuille (droit de propriété)', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (184,'PCG99-BASE','IMMO',  'XXXXXX',  '272', '183', 'Titres immobilisés (droit de créance)', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (185,'PCG99-BASE','IMMO',  'XXXXXX',  '273', '183', 'Titres immobilisés de l''activité de portefeuille', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (186,'PCG99-BASE','IMMO',  'XXXXXX',  '274', '183', 'Prêts', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (187,'PCG99-BASE','IMMO',  'XXXXXX',  '275', '183', 'Dépôts et cautionnements versés', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (188,'PCG99-BASE','IMMO',  'XXXXXX',  '276', '183', 'Autres créances immobilisées', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (189,'PCG99-BASE','IMMO',  'XXXXXX',  '277', '183', '(Actions propres ou parts propres)', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (190,'PCG99-BASE','IMMO',  'XXXXXX',  '279', '183', 'Versements restant à effectuer sur titres immobilisés non libérés', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (191,'PCG99-BASE','IMMO',  'XXXXXX',   '28','1502', 'Amortissements des immobilisations', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (192,'PCG99-BASE','IMMO',  'XXXXXX',  '280', '191', 'Amortissements des immobilisations incorporelles', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (193,'PCG99-BASE','IMMO',  'XXXXXX',  '281', '191', 'Amortissements des immobilisations corporelles', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (194,'PCG99-BASE','IMMO',  'XXXXXX',  '282', '191', 'Amortissements des immobilisations mises en concession', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (195,'PCG99-BASE','IMMO',  'XXXXXX',   '29','1502', 'Dépréciations des immobilisations', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (196,'PCG99-BASE','IMMO',  'XXXXXX',  '290', '195', 'Dépréciations des immobilisations incorporelles', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (197,'PCG99-BASE','IMMO',  'XXXXXX',  '291', '195', 'Dépréciations des immobilisations corporelles', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (198,'PCG99-BASE','IMMO',  'XXXXXX',  '292', '195', 'Dépréciations des immobilisations mises en concession', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (199,'PCG99-BASE','IMMO',  'XXXXXX',  '293', '195', 'Dépréciations des immobilisations en cours', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (200,'PCG99-BASE','IMMO',  'XXXXXX',  '296', '195', 'Provisions pour dépréciation des participations et créances rattachées à des participations', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (201,'PCG99-BASE','IMMO',  'XXXXXX',  '297', '195', 'Provisions pour dépréciation des autres immobilisations financières', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (202,'PCG99-BASE','STOCK', 'XXXXXX',   '31','1503', 'Matières premières (et fournitures)', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (203,'PCG99-BASE','STOCK', 'XXXXXX',  '311', '202', 'Matières (ou groupe) A', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (204,'PCG99-BASE','STOCK', 'XXXXXX',  '312', '202', 'Matières (ou groupe) B', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (205,'PCG99-BASE','STOCK', 'XXXXXX',  '317', '202', 'Fournitures A, B, C,', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (206,'PCG99-BASE','STOCK', 'XXXXXX',   '32','1503', 'Autres approvisionnements', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (207,'PCG99-BASE','STOCK', 'XXXXXX',  '321', '206', 'Matières consommables', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (208,'PCG99-BASE','STOCK', 'XXXXXX',  '322', '206', 'Fournitures consommables', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (209,'PCG99-BASE','STOCK', 'XXXXXX',  '326', '206', 'Emballages', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (210,'PCG99-BASE','STOCK', 'XXXXXX',   '33','1503', 'En-cours de production de biens', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (211,'PCG99-BASE','STOCK', 'XXXXXX',  '331', '210', 'Produits en cours', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (212,'PCG99-BASE','STOCK', 'XXXXXX',  '335', '210', 'Travaux en cours', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (213,'PCG99-BASE','STOCK', 'XXXXXX',   '34','1503', 'En-cours de production de services', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (214,'PCG99-BASE','STOCK', 'XXXXXX',  '341', '213', 'Etudes en cours', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (215,'PCG99-BASE','STOCK', 'XXXXXX',  '345', '213', 'Prestations de services en cours', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (216,'PCG99-BASE','STOCK', 'XXXXXX',   '35','1503', 'Stocks de produits', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (217,'PCG99-BASE','STOCK', 'XXXXXX',  '351', '216', 'Produits intermédiaires', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (218,'PCG99-BASE','STOCK', 'XXXXXX',  '355', '216', 'Produits finis', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (219,'PCG99-BASE','STOCK', 'XXXXXX',  '358', '216', 'Produits résiduels (ou matières de récupération)', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (220,'PCG99-BASE','STOCK', 'XXXXXX',   '37','1503', 'Stocks de marchandises', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (221,'PCG99-BASE','STOCK', 'XXXXXX',  '371', '220', 'Marchandises (ou groupe) A', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (222,'PCG99-BASE','STOCK', 'XXXXXX',  '372', '220', 'Marchandises (ou groupe) B', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (223,'PCG99-BASE','STOCK', 'XXXXXX',   '39','1503', 'Provisions pour dépréciation des stocks et en-cours', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (224,'PCG99-BASE','STOCK', 'XXXXXX',  '391', '223', 'Provisions pour dépréciation des matières premières', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (225,'PCG99-BASE','STOCK', 'XXXXXX',  '392', '223', 'Provisions pour dépréciation des autres approvisionnements', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (226,'PCG99-BASE','STOCK', 'XXXXXX',  '393', '223', 'Provisions pour dépréciation des en-cours de production de biens', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (227,'PCG99-BASE','STOCK', 'XXXXXX',  '394', '223', 'Provisions pour dépréciation des en-cours de production de services', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (228,'PCG99-BASE','STOCK', 'XXXXXX',  '395', '223', 'Provisions pour dépréciation des stocks de produits', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (229,'PCG99-BASE','STOCK', 'XXXXXX',  '397', '223', 'Provisions pour dépréciation des stocks de marchandises', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (230,'PCG99-BASE','TIERS', 'XXXXXX',   '40','1504', 'Fournisseurs et Comptes rattachés', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (231,'PCG99-BASE','TIERS', 'XXXXXX',  '400', '230', 'Fournisseurs et Comptes rattachés', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (232,'PCG99-BASE','TIERS', 'SUPPLIER','401', '230', 'Fournisseurs', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (233,'PCG99-BASE','TIERS', 'XXXXXX',  '403', '230', 'Fournisseurs - Effets à payer', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (234,'PCG99-BASE','TIERS', 'XXXXXX',  '404', '230', 'Fournisseurs d''immobilisations', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (235,'PCG99-BASE','TIERS', 'XXXXXX',  '405', '230', 'Fournisseurs d''immobilisations - Effets à payer', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (236,'PCG99-BASE','TIERS', 'XXXXXX',  '408', '230', 'Fournisseurs - Factures non parvenues', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (237,'PCG99-BASE','TIERS', 'XXXXXX',  '409', '230', 'Fournisseurs débiteurs', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (238,'PCG99-BASE','TIERS', 'XXXXXX',   '41','1504', 'Clients et comptes rattachés', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (239,'PCG99-BASE','TIERS', 'XXXXXX',  '410', '238', 'Clients et Comptes rattachés', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (240,'PCG99-BASE','TIERS', 'CUSTOMER','411', '238', 'Clients', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (241,'PCG99-BASE','TIERS', 'XXXXXX',  '413', '238', 'Clients - Effets à recevoir', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (242,'PCG99-BASE','TIERS', 'XXXXXX',  '416', '238', 'Clients douteux ou litigieux', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (243,'PCG99-BASE','TIERS', 'XXXXXX',  '418', '238', 'Clients - Produits non encore facturés', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (244,'PCG99-BASE','TIERS', 'XXXXXX',  '419', '238', 'Clients créditeurs', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (245,'PCG99-BASE','TIERS', 'XXXXXX',   '42','1504', 'Personnel et comptes rattachés', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (246,'PCG99-BASE','TIERS', 'XXXXXX',  '421', '245', 'Personnel - Rémunérations dues', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (247,'PCG99-BASE','TIERS', 'XXXXXX',  '422', '245', 'Comités d''entreprises, d''établissement, ...', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (248,'PCG99-BASE','TIERS', 'XXXXXX',  '424', '245', 'Participation des salariés aux résultats', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (249,'PCG99-BASE','TIERS', 'XXXXXX',  '425', '245', 'Personnel - Avances et acomptes', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (250,'PCG99-BASE','TIERS', 'XXXXXX',  '426', '245', 'Personnel - Dépôts', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (251,'PCG99-BASE','TIERS', 'XXXXXX',  '427', '245', 'Personnel - Oppositions', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (252,'PCG99-BASE','TIERS', 'XXXXXX',  '428', '245', 'Personnel - Charges à payer et produits à recevoir', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (253,'PCG99-BASE','TIERS', 'XXXXXX',   '43','1504', 'Sécurité sociale et autres organismes sociaux', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (254,'PCG99-BASE','TIERS', 'XXXXXX',  '431', '253', 'Sécurité sociale', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (255,'PCG99-BASE','TIERS', 'XXXXXX',  '437', '253', 'Autres organismes sociaux', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (256,'PCG99-BASE','TIERS', 'XXXXXX',  '438', '253', 'Organismes sociaux - Charges à payer et produits à recevoir', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (257,'PCG99-BASE','TIERS', 'XXXXXX',   '44','1504', 'État et autres collectivités publiques', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (258,'PCG99-BASE','TIERS', 'XXXXXX',  '441', '257', 'État - Subventions à recevoir', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (259,'PCG99-BASE','TIERS', 'XXXXXX',  '442', '257', 'Etat - Impôts et taxes recouvrables sur des tiers', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (260,'PCG99-BASE','TIERS', 'XXXXXX',  '443', '257', 'Opérations particulières avec l''Etat, les collectivités publiques, les organismes internationaux', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (261,'PCG99-BASE','TIERS', 'XXXXXX',  '444', '257', 'Etat - Impôts sur les bénéfices', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (262,'PCG99-BASE','TIERS', 'XXXXXX',  '445', '257', 'Etat - Taxes sur le chiffre d''affaires', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (263,'PCG99-BASE','TIERS', 'XXXXXX',  '446', '257', 'Obligations cautionnées', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (264,'PCG99-BASE','TIERS', 'XXXXXX',  '447', '257', 'Autres impôts, taxes et versements assimilés', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (265,'PCG99-BASE','TIERS', 'XXXXXX',  '448', '257', 'Etat - Charges à payer et produits à recevoir', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (266,'PCG99-BASE','TIERS', 'XXXXXX',  '449', '257', 'Quotas d''émission à restituer à l''Etat', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (267,'PCG99-BASE','TIERS', 'XXXXXX',   '45','1504', 'Groupe et associes', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (268,'PCG99-BASE','TIERS', 'XXXXXX',  '451', '267', 'Groupe', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (269,'PCG99-BASE','TIERS', 'XXXXXX',  '455', '267', 'Associés - Comptes courants', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (270,'PCG99-BASE','TIERS', 'XXXXXX',  '456', '267', 'Associés - Opérations sur le capital', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (271,'PCG99-BASE','TIERS', 'XXXXXX',  '457', '267', 'Associés - Dividendes à payer', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (272,'PCG99-BASE','TIERS', 'XXXXXX',  '458', '267', 'Associés - Opérations faites en commun et en G.I.E.', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (273,'PCG99-BASE','TIERS', 'XXXXXX',   '46','1504', 'Débiteurs divers et créditeurs divers', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (274,'PCG99-BASE','TIERS', 'XXXXXX',  '462', '273', 'Créances sur cessions d''immobilisations', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (275,'PCG99-BASE','TIERS', 'XXXXXX',  '464', '273', 'Dettes sur acquisitions de valeurs mobilières de placement', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (276,'PCG99-BASE','TIERS', 'XXXXXX',  '465', '273', 'Créances sur cessions de valeurs mobilières de placement', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (277,'PCG99-BASE','TIERS', 'XXXXXX',  '467', '273', 'Autres comptes débiteurs ou créditeurs', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (278,'PCG99-BASE','TIERS', 'XXXXXX',  '468', '273', 'Divers - Charges à payer et produits à recevoir', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (279,'PCG99-BASE','TIERS', 'XXXXXX',   '47','1504', 'Comptes transitoires ou d''attente', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (280,'PCG99-BASE','TIERS', 'XXXXXX',  '471', '279', 'Comptes d''attente', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (281,'PCG99-BASE','TIERS', 'XXXXXX',  '476', '279', 'Différence de conversion - Actif', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (282,'PCG99-BASE','TIERS', 'XXXXXX',  '477', '279', 'Différences de conversion - Passif', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (283,'PCG99-BASE','TIERS', 'XXXXXX',  '478', '279', 'Autres comptes transitoires', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (284,'PCG99-BASE','TIERS', 'XXXXXX',   '48','1504', 'Comptes de régularisation', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (285,'PCG99-BASE','TIERS', 'XXXXXX',  '481', '284', 'Charges à répartir sur plusieurs exercices', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (286,'PCG99-BASE','TIERS', 'XXXXXX',  '486', '284', 'Charges constatées d''avance', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (287,'PCG99-BASE','TIERS', 'XXXXXX',  '487', '284', 'Produits constatés d''avance', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (288,'PCG99-BASE','TIERS', 'XXXXXX',  '488', '284', 'Comptes de répartition périodique des charges et des produits', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (289,'PCG99-BASE','TIERS', 'XXXXXX',  '489', '284', 'Quotas d''émission alloués par l''Etat', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (290,'PCG99-BASE','TIERS', 'XXXXXX',   '49','1504', 'Provisions pour dépréciation des comptes de tiers', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (291,'PCG99-BASE','TIERS', 'XXXXXX',  '491', '290', 'Provisions pour dépréciation des comptes de clients', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (292,'PCG99-BASE','TIERS', 'XXXXXX',  '495', '290', 'Provisions pour dépréciation des comptes du groupe et des associés', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (293,'PCG99-BASE','TIERS', 'XXXXXX',  '496', '290', 'Provisions pour dépréciation des comptes de débiteurs divers', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (294,'PCG99-BASE','FINAN', 'XXXXXX',   '50','1505', 'Valeurs mobilières de placement', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (295,'PCG99-BASE','FINAN', 'XXXXXX',  '501', '294', 'Parts dans des entreprises liées', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (296,'PCG99-BASE','FINAN', 'XXXXXX',  '502', '294', 'Actions propres', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (297,'PCG99-BASE','FINAN', 'XXXXXX',  '503', '294', 'Actions', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (298,'PCG99-BASE','FINAN', 'XXXXXX',  '504', '294', 'Autres titres conférant un droit de propriété', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (299,'PCG99-BASE','FINAN', 'XXXXXX',  '505', '294', 'Obligations et bons émis par la société et rachetés par elle', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (300,'PCG99-BASE','FINAN', 'XXXXXX',  '506', '294', 'Obligations', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (301,'PCG99-BASE','FINAN', 'XXXXXX',  '507', '294', 'Bons du Trésor et bons de caisse à court terme', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (302,'PCG99-BASE','FINAN', 'XXXXXX',  '508', '294', 'Autres valeurs mobilières de placement et autres créances assimilées', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (303,'PCG99-BASE','FINAN', 'XXXXXX',  '509', '294', 'Versements restant à effectuer sur valeurs mobilières de placement non libérées', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (304,'PCG99-BASE','FINAN', 'XXXXXX',   '51','1505', 'Banques, établissements financiers et assimilés', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (305,'PCG99-BASE','FINAN', 'XXXXXX',  '511', '304', 'Valeurs à l''encaissement', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (306,'PCG99-BASE','FINAN', 'BANK',    '512', '304', 'Banques', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (307,'PCG99-BASE','FINAN', 'XXXXXX',  '514', '304', 'Chèques postaux', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (308,'PCG99-BASE','FINAN', 'XXXXXX',  '515', '304', '"Caisses" du Trésor et des établissements publics', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (309,'PCG99-BASE','FINAN', 'XXXXXX',  '516', '304', 'Sociétés de bourse', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (310,'PCG99-BASE','FINAN', 'XXXXXX',  '517', '304', 'Autres organismes financiers', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (311,'PCG99-BASE','FINAN', 'XXXXXX',  '518', '304', 'Intérêts courus', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (312,'PCG99-BASE','FINAN', 'XXXXXX',  '519', '304', 'Concours bancaires courants', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (313,'PCG99-BASE','FINAN', 'XXXXXX',   '52','1505', 'Instruments de trésorerie', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (314,'PCG99-BASE','FINAN', 'CASH',     '53','1505', 'Caisse', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (315,'PCG99-BASE','FINAN', 'XXXXXX',  '531', '314', 'Caisse siège social', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (316,'PCG99-BASE','FINAN', 'XXXXXX',  '532', '314', 'Caisse succursale (ou usine) A', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (317,'PCG99-BASE','FINAN', 'XXXXXX',  '533', '314', 'Caisse succursale (ou usine) B', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (318,'PCG99-BASE','FINAN', 'XXXXXX',   '54','1505', 'Régies d''avance et accréditifs', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (319,'PCG99-BASE','FINAN', 'XXXXXX',   '58','1505', 'Virements internes', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (320,'PCG99-BASE','FINAN', 'XXXXXX',   '59','1505', 'Provisions pour dépréciation des comptes financiers', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (321,'PCG99-BASE','FINAN', 'XXXXXX',  '590', '320', 'Provisions pour dépréciation des valeurs mobilières de placement', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (322,'PCG99-BASE','CHARGE','PRODUCT',  '60','1506', 'Achats', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (323,'PCG99-BASE','CHARGE','XXXXXX',  '601', '322', 'Achats stockés - Matières premières (et fournitures)', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (324,'PCG99-BASE','CHARGE','XXXXXX',  '602', '322', 'Achats stockés - Autres approvisionnements', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (325,'PCG99-BASE','CHARGE','XXXXXX',  '603', '322', 'Variations des stocks (approvisionnements et marchandises)', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (326,'PCG99-BASE','CHARGE','XXXXXX',  '604', '322', 'Achats stockés - Matières premières (et fournitures)', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (327,'PCG99-BASE','CHARGE','XXXXXX',  '605', '322', 'Achats de matériel, équipements et travaux', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (328,'PCG99-BASE','CHARGE','XXXXXX',  '606', '322', 'Achats non stockés de matière et fournitures', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (329,'PCG99-BASE','CHARGE','XXXXXX',  '607', '322', 'Achats de marchandises', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (330,'PCG99-BASE','CHARGE','XXXXXX',  '608', '322', '(Compte réservé, le cas échéant, à la récapitulation des frais accessoires incorporés aux achats)', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (331,'PCG99-BASE','CHARGE','XXXXXX',  '609', '322', 'Rabais, remises et ristournes obtenus sur achats', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (332,'PCG99-BASE','CHARGE','SERVICE',  '61','1506', 'Services extérieurs', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (333,'PCG99-BASE','CHARGE','XXXXXX',  '611', '332', 'Sous-traitance générale', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (334,'PCG99-BASE','CHARGE','XXXXXX',  '612', '332', 'Redevances de crédit-bail', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (335,'PCG99-BASE','CHARGE','XXXXXX',  '613', '332', 'Locations', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (336,'PCG99-BASE','CHARGE','XXXXXX',  '614', '332', 'Charges locatives et de copropriété', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (337,'PCG99-BASE','CHARGE','XXXXXX',  '615', '332', 'Entretien et réparations', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (338,'PCG99-BASE','CHARGE','XXXXXX',  '616', '332', 'Primes d''assurances', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (339,'PCG99-BASE','CHARGE','XXXXXX',  '617', '332', 'Etudes et recherches', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (340,'PCG99-BASE','CHARGE','XXXXXX',  '618', '332', 'Divers', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (341,'PCG99-BASE','CHARGE','XXXXXX',  '619', '332', 'Rabais, remises et ristournes obtenus sur services extérieurs', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (342,'PCG99-BASE','CHARGE','XXXXXX',   '62','1506', 'Autres services extérieurs', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (343,'PCG99-BASE','CHARGE','XXXXXX',  '621', '342', 'Personnel extérieur à l''entreprise', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (344,'PCG99-BASE','CHARGE','XXXXXX',  '622', '342', 'Rémunérations d''intermédiaires et honoraires', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (345,'PCG99-BASE','CHARGE','XXXXXX',  '623', '342', 'Publicité, publications, relations publiques', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (346,'PCG99-BASE','CHARGE','XXXXXX',  '624', '342', 'Transports de biens et transports collectifs du personnel', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (347,'PCG99-BASE','CHARGE','XXXXXX',  '625', '342', 'Déplacements, missions et réceptions', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (348,'PCG99-BASE','CHARGE','XXXXXX',  '626', '342', 'Frais postaux et de télécommunications', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (349,'PCG99-BASE','CHARGE','XXXXXX',  '627', '342', 'Services bancaires et assimilés', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (350,'PCG99-BASE','CHARGE','XXXXXX',  '628', '342', 'Divers', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (351,'PCG99-BASE','CHARGE','XXXXXX',  '629', '342', 'Rabais, remises et ristournes obtenus sur autres services extérieurs', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (352,'PCG99-BASE','CHARGE','XXXXXX',   '63','1506', 'Impôts, taxes et versements assimilés', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (353,'PCG99-BASE','CHARGE','XXXXXX',  '631', '352', 'Impôts, taxes et versements assimilés sur rémunérations (administrations des impôts)', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (354,'PCG99-BASE','CHARGE','XXXXXX',  '633', '352', 'Impôts, taxes et versements assimilés sur rémunérations (autres organismes)', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (355,'PCG99-BASE','CHARGE','XXXXXX',  '635', '352', 'Autres impôts, taxes et versements assimilés (administrations des impôts)', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (356,'PCG99-BASE','CHARGE','XXXXXX',  '637', '352', 'Autres impôts, taxes et versements assimilés (autres organismes)', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (357,'PCG99-BASE','CHARGE','XXXXXX',   '64','1506', 'Charges de personnel', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (358,'PCG99-BASE','CHARGE','XXXXXX',  '641', '357', 'Rémunérations du personnel', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (359,'PCG99-BASE','CHARGE','XXXXXX',  '644', '357', 'Rémunération du travail de l''exploitant', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (360,'PCG99-BASE','CHARGE','SOCIAL',  '645', '357', 'Charges de sécurité sociale et de prévoyance', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (361,'PCG99-BASE','CHARGE','XXXXXX',  '646', '357', 'Cotisations sociales personnelles de l''exploitant', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (362,'PCG99-BASE','CHARGE','XXXXXX',  '647', '357', 'Autres charges sociales', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (363,'PCG99-BASE','CHARGE','XXXXXX',  '648', '357', 'Autres charges de personnel', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (364,'PCG99-BASE','CHARGE','XXXXXX',   '65','1506', 'Autres charges de gestion courante', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (365,'PCG99-BASE','CHARGE','XXXXXX',  '651', '364', 'Redevances pour concessions, brevets, licences, marques, procédés, logiciels, droits et valeurs similaires', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (366,'PCG99-BASE','CHARGE','XXXXXX',  '653', '364', 'Jetons de présence', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (367,'PCG99-BASE','CHARGE','XXXXXX',  '654', '364', 'Pertes sur créances irrécouvrables', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (368,'PCG99-BASE','CHARGE','XXXXXX',  '655', '364', 'Quote-part de résultat sur opérations faites en commun', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (369,'PCG99-BASE','CHARGE','XXXXXX',  '658', '364', 'Charges diverses de gestion courante', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (370,'PCG99-BASE','CHARGE','XXXXXX',   '66','1506', 'Charges financières', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (371,'PCG99-BASE','CHARGE','XXXXXX',  '661', '370', 'Charges d''intérêts', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (372,'PCG99-BASE','CHARGE','XXXXXX',  '664', '370', 'Pertes sur créances liées à des participations', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (373,'PCG99-BASE','CHARGE','XXXXXX',  '665', '370', 'Escomptes accordés', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (374,'PCG99-BASE','CHARGE','XXXXXX',  '666', '370', 'Pertes de change', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (375,'PCG99-BASE','CHARGE','XXXXXX',  '667', '370', 'Charges nettes sur cessions de valeurs mobilières de placement', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (376,'PCG99-BASE','CHARGE','XXXXXX',  '668', '370', 'Autres charges financières', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (377,'PCG99-BASE','CHARGE','XXXXXX',   '67','1506', 'Charges exceptionnelles', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (378,'PCG99-BASE','CHARGE','XXXXXX',  '671', '377', 'Charges exceptionnelles sur opérations de gestion', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (379,'PCG99-BASE','CHARGE','XXXXXX',  '672', '377', '(Compte à la disposition des entités pour enregistrer, en cours d''exercice, les charges sur exercices antérieurs)', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (380,'PCG99-BASE','CHARGE','XXXXXX',  '675', '377', 'Valeurs comptables des éléments d''actif cédés', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (381,'PCG99-BASE','CHARGE','XXXXXX',  '678', '377', 'Autres charges exceptionnelles', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (382,'PCG99-BASE','CHARGE','XXXXXX',   '68','1506', 'Dotations aux amortissements et aux provisions', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (383,'PCG99-BASE','CHARGE','XXXXXX',  '681', '382', 'Dotations aux amortissements et aux provisions - Charges d''exploitation', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (384,'PCG99-BASE','CHARGE','XXXXXX',  '686', '382', 'Dotations aux amortissements et aux provisions - Charges financières', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (385,'PCG99-BASE','CHARGE','XXXXXX',  '687', '382', 'Dotations aux amortissements et aux provisions - Charges exceptionnelles', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (386,'PCG99-BASE','CHARGE','XXXXXX',   '69','1506', 'Participation des salariés - impôts sur les bénéfices et assimiles', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (387,'PCG99-BASE','CHARGE','XXXXXX',  '691', '386', 'Participation des salariés aux résultats', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (388,'PCG99-BASE','CHARGE','XXXXXX',  '695', '386', 'Impôts sur les bénéfices', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (389,'PCG99-BASE','CHARGE','XXXXXX',  '696', '386', 'Suppléments d''impôt sur les sociétés liés aux distributions', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (390,'PCG99-BASE','CHARGE','XXXXXX',  '697', '386', 'Imposition forfaitaire annuelle des sociétés', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (391,'PCG99-BASE','CHARGE','XXXXXX',  '698', '386', 'Intégration fiscale', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (392,'PCG99-BASE','CHARGE','XXXXXX',  '699', '386', 'Produits - Reports en arrière des déficits', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (393,'PCG99-BASE','PROD',  'XXXXXX',   '70','1507', 'Ventes de produits fabriqués, prestations de services, marchandises', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (394,'PCG99-BASE','PROD',  'PRODUCT', '701', '393', 'Ventes de produits finis', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (395,'PCG99-BASE','PROD',  'XXXXXX',  '702', '393', 'Ventes de produits intermédiaires', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (396,'PCG99-BASE','PROD',  'XXXXXX',  '703', '393', 'Ventes de produits résiduels', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (397,'PCG99-BASE','PROD',  'XXXXXX',  '704', '393', 'Travaux', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (398,'PCG99-BASE','PROD',  'XXXXXX',  '705', '393', 'Etudes', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (399,'PCG99-BASE','PROD',  'SERVICE', '706', '393', 'Prestations de services', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (400,'PCG99-BASE','PROD',  'PRODUCT', '707', '393', 'Ventes de marchandises', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (401,'PCG99-BASE','PROD',  'PRODUCT', '708', '393', 'Produits des activités annexes', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (402,'PCG99-BASE','PROD',  'XXXXXX',  '709', '393', 'Rabais, remises et ristournes accordés par l''entreprise', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (403,'PCG99-BASE','PROD',  'XXXXXX',   '71','1507', 'Production stockée (ou déstockage)', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (404,'PCG99-BASE','PROD',  'XXXXXX',  '713', '403', 'Variation des stocks (en-cours de production, produits)', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (405,'PCG99-BASE','PROD',  'XXXXXX',   '72','1507', 'Production immobilisée', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (406,'PCG99-BASE','PROD',  'XXXXXX',  '721', '405', 'Immobilisations incorporelles', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (407,'PCG99-BASE','PROD',  'XXXXXX',  '722', '405', 'Immobilisations corporelles', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (408,'PCG99-BASE','PROD',  'XXXXXX',   '74','1507', 'Subventions d''exploitation', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (409,'PCG99-BASE','PROD',  'XXXXXX',   '75','1507', 'Autres produits de gestion courante', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (410,'PCG99-BASE','PROD',  'XXXXXX',  '751', '409', 'Redevances pour concessions, brevets, licences, marques, procédés, logiciels, droits et valeurs similaires', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (411,'PCG99-BASE','PROD',  'XXXXXX',  '752', '409', 'Revenus des immeubles non affectés à des activités professionnelles', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (412,'PCG99-BASE','PROD',  'XXXXXX',  '753', '409', 'Jetons de présence et rémunérations d''administrateurs, gérants,...', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (413,'PCG99-BASE','PROD',  'XXXXXX',  '754', '409', 'Ristournes perçues des coopératives (provenant des excédents)', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (414,'PCG99-BASE','PROD',  'XXXXXX',  '755', '409', 'Quotes-parts de résultat sur opérations faites en commun', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (415,'PCG99-BASE','PROD',  'XXXXXX',  '758', '409', 'Produits divers de gestion courante', 1); 
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (416,'PCG99-BASE','PROD',  'XXXXXX',   '76','1507', 'Produits financiers', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (417,'PCG99-BASE','PROD',  'XXXXXX',  '761', '416', 'Produits de participations', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (418,'PCG99-BASE','PROD',  'XXXXXX',  '762', '416', 'Produits des autres immobilisations financières', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (419,'PCG99-BASE','PROD',  'XXXXXX',  '763', '416', 'Revenus des autres créances', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (420,'PCG99-BASE','PROD',  'XXXXXX',  '764', '416', 'Revenus des valeurs mobilières de placement', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (421,'PCG99-BASE','PROD',  'XXXXXX',  '765', '416', 'Escomptes obtenus', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (422,'PCG99-BASE','PROD',  'XXXXXX',  '766', '416', 'Gains de change', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (423,'PCG99-BASE','PROD',  'XXXXXX',  '767', '416', 'Produits nets sur cessions de valeurs mobilières de placement', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (424,'PCG99-BASE','PROD',  'XXXXXX',  '768', '416', 'Autres produits financiers', 1); 
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (425,'PCG99-BASE','PROD',  'XXXXXX',   '77','1507', 'Produits exceptionnels', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (426,'PCG99-BASE','PROD',  'XXXXXX',  '771', '425', 'Produits exceptionnels sur opérations de gestion', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (427,'PCG99-BASE','PROD',  'XXXXXX',  '772', '425', '(Compte à la disposition des entités pour enregistrer, en cours d''exercice, les produits sur exercices antérieurs)', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (428,'PCG99-BASE','PROD',  'XXXXXX',  '775', '425', 'Produits des cessions d''éléments d''actif', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (429,'PCG99-BASE','PROD',  'XXXXXX',  '777', '425', 'Quote-part des subventions d''investissement virée au résultat de l''exercice', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (430,'PCG99-BASE','PROD',  'XXXXXX',  '778', '425', 'Autres produits exceptionnels', 1); 
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (431,'PCG99-BASE','PROD',  'XXXXXX',   '78','1507', 'Reprises sur amortissements et provisions', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (432,'PCG99-BASE','PROD',  'XXXXXX',  '781', '431', 'Reprises sur amortissements et provisions (à inscrire dans les produits d''exploitation)', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (433,'PCG99-BASE','PROD',  'XXXXXX',  '786', '431', 'Reprises sur provisions pour risques (à inscrire dans les produits financiers)', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (434,'PCG99-BASE','PROD',  'XXXXXX',  '787', '431', 'Reprises sur provisions (à inscrire dans les produits exceptionnels)', 1); 
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (435,'PCG99-BASE','PROD',  'XXXXXX',   '79','1507', 'Transferts de charges', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (436,'PCG99-BASE','PROD',  'XXXXXX',  '791', '435', 'Transferts de charges d''exploitation ', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (437,'PCG99-BASE','PROD',  'XXXXXX',  '796', '435', 'Transferts de charges financières', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (438,'PCG99-BASE','PROD',  'XXXXXX',  '797', '435', 'Transferts de charges exceptionnelles', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1501,'PCG99-BASE','CAPIT', 'XXXXXX', '1', '0', 'Fonds propres, provisions pour risques et charges et dettes à plus d''un an', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1502,'PCG99-BASE','IMMO',  'XXXXXX', '2', '0', 'Frais d''établissement. Actifs immobilisés et créances à plus d''un an', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1503,'PCG99-BASE','STOCK', 'XXXXXX', '3', '0', 'Stock et commandes en cours d''exécution', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1504,'PCG99-BASE','TIERS', 'XXXXXX', '4', '0', 'Créances et dettes à un an au plus', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1505,'PCG99-BASE','FINAN', 'XXXXXX', '5', '0', 'Placement de trésorerie et de valeurs disponibles', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1506,'PCG99-BASE','CHARGE','XXXXXX', '6', '0', 'Charges', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1507,'PCG99-BASE','PROD',  'XXXXXX', '7', '0', 'Produits', 1);

--
-- Descriptif des plans comptables BE PCMN-BASE
--

INSERT INTO llx_accounting_system (rowid, pcg_version, label, active) VALUES (3, 'PCMN-BASE', 'The base accountancy belgium plan', 1);

INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (439, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '10', '1351', 'Capital', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (440, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '100', '439', 'Capital souscrit ou capital personnel', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (441, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '1000', '440', 'Capital non amorti', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (442, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '1001', '440', 'Capital amorti', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (443, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '101', '439', 'Capital non appelé', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (444, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '109', '439', 'Compte de l''exploitant', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (445, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '1090', '444', 'Opérations courantes', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (446, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '1091', '444', 'Impôts personnels', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (447, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '1092', '444', 'Rémunérations et autres avantages', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (448, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '11', '1351', 'Primes d''émission', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (449, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '12', '1351', 'Plus-values de réévaluation', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (450, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '120', '449', 'Plus-values de réévaluation sur immobilisations incorporelles', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (451, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '1200', '450', 'Plus-values de réévaluation', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (452, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '1201', '450', 'Reprises de réductions de valeur', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (453, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '121', '449', 'Plus-values de réévaluation sur immobilisations corporelles', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (454, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '1210', '453', 'Plus-values de réévaluation', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (455, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '1211', '453', 'Reprises de réductions de valeur', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (456, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '122', '449', 'Plus-values de réévaluation sur immobilisations financières', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (457, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '1220', '456', 'Plus-values de réévaluation', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (458, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '1221', '456', 'Reprises de réductions de valeur', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (459, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '123', '449', 'Plus-values de réévaluation sur stocks', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (460, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '124', '449', 'Reprises de réductions de valeur sur placements de trésorerie', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (461, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '13', '1351', 'Réserve', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (462, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '130', '461', 'Réserve légale', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (463, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '131', '461', 'Réserves indisponibles', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (464, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '1310', '463', 'Réserve pour actions propres', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (465, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '1311', '463', 'Autres réserves indisponibles', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (466, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '132', '461', 'Réserves immunisées', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (467, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '133', '461', 'Réserves disponibles', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (468, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '1330', '467', 'Réserve pour régularisation de dividendes', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (469, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '1331', '467', 'Réserve pour renouvellement des immobilisations', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (470, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '1332', '467', 'Réserve pour installations en faveur du personnel 1333 Réserves libres', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (471, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '14', '1351', 'Bénéfice reporté (ou perte reportée)', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (472, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '15', '1351', 'Subsides en capital', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (473, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '150', '472', 'Montants obtenus', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (474, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '151', '472', 'Montants transférés aux résultats', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (475, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '16', '1351', 'Provisions pour risques et charges', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (476, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '160', '475', 'Provisions pour pensions et obligations similaires', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (477, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '161', '475', 'Provisions pour charges fiscales', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (478, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '162', '475', 'Provisions pour grosses réparations et gros entretiens', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (479, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '163', '475', 'à 169 Provisions pour autres risques et charges', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (480, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '164', '475', 'Provisions pour sûretés personnelles ou réelles constituées à l''appui de dettes et d''engagements de tiers', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (481, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '165', '475', 'Provisions pour engagements relatifs à l''acquisition ou à la cession d''immobilisations', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (482, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '166', '475', 'Provisions pour exécution de commandes passées ou reçues', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (483, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '167', '475', 'Provisions pour positions et marchés à terme en devises ou positions et marchés à terme en marchandises', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (484, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '168', '475', 'Provisions pour garanties techniques attachées aux ventes et prestations déjà effectuées par l''entreprise', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (485, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '169', '475', 'Provisions pour autres risques et charges', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (486, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '1690', '485', 'Pour litiges en cours', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (487, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '1691', '485', 'Pour amendes, doubles droits et pénalités', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (488, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '1692', '485', 'Pour propre assureur', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (489, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '1693', '485', 'Pour risques inhérents aux opérations de crédits à moyen ou long terme', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (490, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '1695', '485', 'Provision pour charge de liquidation', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (491, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '1696', '485', 'Provision pour départ de personnel', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (492, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '1699', '485', 'Pour risques divers', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (493, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '17', '1351', 'Dettes à plus d''un an', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (494, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '170', '493', 'Emprunts subordonnés', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (495, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '1700', '494', 'Convertibles', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (496, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '1701', '494', 'Non convertibles', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (497, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '171', '493', 'Emprunts obligataires non subordonnés', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (498, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '1710', '498', 'Convertibles', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (499, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '1711', '498', 'Non convertibles', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (500, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '172', '493', 'Dettes de location-financement et assimilés', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (501, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '1720', '500', 'Dettes de location-financement de biens immobiliers', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (502, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '1721', '500', 'Dettes de location-financement de biens mobiliers', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (503, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '1722', '500', 'Dettes sur droits réels sur immeubles', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (504, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '173', '493', 'Etablissements de crédit', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (505, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '1730', '504', 'Dettes en compte', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (506, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '17300', '505', 'Banque A', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (507, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '17301', '505', 'Banque B', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (508, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '17302', '505', 'Banque C', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (509, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '17303', '505', 'Banque D', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (510, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '1731', '504', 'Promesses', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (511, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '17310', '510', 'Banque A', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (512, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '17311', '510', 'Banque B', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (513, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '17312', '510', 'Banque C', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (514, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '17313', '510', 'Banque D', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (515, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '1732', '504', 'Crédits d''acceptation', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (516, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '17320', '515', 'Banque A', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (517, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '17321', '515', 'Banque B', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (518, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '17322', '515', 'Banque C', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (519, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '17323', '515', 'Banque D', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (520, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '174', '493', 'Autres emprunts', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (521, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '175', '493', 'Dettes commerciales', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (522, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '1750', '521', 'Fournisseurs : dettes en compte', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (523, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '17500', '522', 'Entreprises apparentées', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (524, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '175000', '523', 'Entreprises liées', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (525, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '175001', '523', 'Entreprises avec lesquelles il existe un lien de participation', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (526, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '17501', '522', 'Fournisseurs ordinaires', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (527, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '175010', '526', 'Fournisseurs belges', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (528, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '175011', '526', 'Fournisseurs C.E.E.', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (529, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '175012', '526', 'Fournisseurs importation', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (530, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '1751', '521', 'Effets à payer', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (531, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '17510', '530', 'Entreprises apparentées', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (532, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '175100', '531', 'Entreprises liées', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (533, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '175101', '531', 'Entreprises avec lesquelles il existe un lien de participation', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (534, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '17511', '530', 'Fournisseurs ordinaires', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (535, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '175110', '534', 'Fournisseurs belges', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (536, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '175111', '534', 'Fournisseurs C.E.E.', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (537, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '175112', '534', 'Fournisseurs importation', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (538, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '176', '493', 'Acomptes reçus sur commandes', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (539, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '178', '493', 'Cautionnements reçus en numéraires', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (540, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '179', '493', 'Dettes diverses', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (541, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '1790', '540', 'Entreprises liées', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (542, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '1791', '540', 'Autres entreprises avec lesquelles il existe un lien de participation', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (543, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '1792', '540', 'Administrateurs, gérants et associés', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (544, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '1794', '540', 'Rentes viagères capitalisées', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (545, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '1798', '540', 'Dettes envers les coparticipants des associations momentanées et en participation', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (546, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '1799', '540', 'Autres dettes diverses', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (547, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '18', '1351', 'Comptes de liaison des établissements et succursales', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (548, 'PCMN-BASE', 'IMMO', 'XXXXXX', '20', '1352', 'Frais d''établissement', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (549, 'PCMN-BASE', 'IMMO', 'XXXXXX', '200', '548', 'Frais de constitution et d''augmentation de capital', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (550, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2000', '549', 'Frais de constitution et d''augmentation de capital', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (551, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2009', '549', 'Amortissements sur frais de constitution et d''augmentation de capital', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (552, 'PCMN-BASE', 'IMMO', 'XXXXXX', '201', '548', 'Frais d''émission d''emprunts et primes de remboursement', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (553, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2010', '552', 'Agios sur emprunts et frais d''émission d''emprunts', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (554, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2019', '552', 'Amortissements sur agios sur emprunts et frais d''émission d''emprunts', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (555, 'PCMN-BASE', 'IMMO', 'XXXXXX', '202', '548', 'Autres frais d''établissement', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (556, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2020', '555', 'Autres frais d''établissement', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (557, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2029', '555', 'Amortissements sur autres frais d''établissement', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (558, 'PCMN-BASE', 'IMMO', 'XXXXXX', '203', '548', 'Intérêts intercalaires', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (559, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2030', '558', 'Intérêts intercalaires', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (560, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2039', '558', 'Amortissements sur intérêts intercalaires', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (561, 'PCMN-BASE', 'IMMO', 'XXXXXX', '204', '548', 'Frais de restructuration', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (562, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2040', '561', 'Coût des frais de restructuration', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (563, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2049', '561', 'Amortissements sur frais de restructuration', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (564, 'PCMN-BASE', 'IMMO', 'XXXXXX', '21', '1352', 'Immobilisations incorporelles', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (565, 'PCMN-BASE', 'IMMO', 'XXXXXX', '210', '564', 'Frais de recherche et de développement', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (566, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2100', '565', 'Frais de recherche et de mise au point', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (567, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2108', '565', 'Plus-values actées sur frais de recherche et de mise au point', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (568, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2109', '565', 'Amortissements sur frais de recherche et de mise au point', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (569, 'PCMN-BASE', 'IMMO', 'XXXXXX', '211', '564', 'Concessions, brevets, licences, savoir-faire, marque et droits similaires', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (570, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2110', '569', 'Concessions, brevets, licences, marques, etc', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (571, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2118', '569', 'Plus-values actées sur concessions, etc', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (572, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2119', '569', 'Amortissements sur concessions, etc', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (573, 'PCMN-BASE', 'IMMO', 'XXXXXX', '212', '564', 'Goodwill', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (574, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2120', '573', 'Coût d''acquisition', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (575, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2128', '573', 'Plus-values actées', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (576, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2129', '573', 'Amortissements sur goodwill', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (577, 'PCMN-BASE', 'IMMO', 'XXXXXX', '213', '564', 'Acomptes versés', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (578, 'PCMN-BASE', 'IMMO', 'XXXXXX', '22', '1352', 'Terrains et constructions', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (579, 'PCMN-BASE', 'IMMO', 'XXXXXX', '220', '578', 'Terrains', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (580, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2200', '579', 'Terrains', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (581, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2201', '579', 'Frais d''acquisition sur terrains', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (582, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2208', '579', 'Plus-values actées sur terrains', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (583, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2209', '579', 'Amortissements et réductions de valeur', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (584, 'PCMN-BASE', 'IMMO', 'XXXXXX', '22090', '583', 'Amortissements sur frais d''acquisition', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (585, 'PCMN-BASE', 'IMMO', 'XXXXXX', '22091', '583', 'Réductions de valeur sur terrains', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (586, 'PCMN-BASE', 'IMMO', 'XXXXXX', '221', '578', 'Constructions', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (587, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2210', '586', 'Bâtiments industriels', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (588, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2211', '586', 'Bâtiments administratifs et commerciaux', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (589, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2212', '586', 'Autres bâtiments d''exploitation', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (590, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2213', '586', 'Voies de transport et ouvrages d''art', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (591, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2215', '586', 'Constructions sur sol d''autrui', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (592, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2216', '586', 'Frais d''acquisition sur constructions', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (593, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2218', '586', 'Plus-values actées', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (594, 'PCMN-BASE', 'IMMO', 'XXXXXX', '22180', '593', 'Sur bâtiments industriels', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (595, 'PCMN-BASE', 'IMMO', 'XXXXXX', '22181', '593', 'Sur bâtiments administratifs et commerciaux', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (596, 'PCMN-BASE', 'IMMO', 'XXXXXX', '22182', '593', 'Sur autres bâtiments d''exploitation', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (597, 'PCMN-BASE', 'IMMO', 'XXXXXX', '22184', '593', 'Sur voies de transport et ouvrages d''art', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (598, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2219', '586', 'Amortissements sur constructions', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (599, 'PCMN-BASE', 'IMMO', 'XXXXXX', '22190', '598', 'Sur bâtiments industriels', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (600, 'PCMN-BASE', 'IMMO', 'XXXXXX', '22191', '598', 'Sur bâtiments administratifs et commerciaux', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (601, 'PCMN-BASE', 'IMMO', 'XXXXXX', '22192', '598', 'Sur autres bâtiments d''exploitation', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (602, 'PCMN-BASE', 'IMMO', 'XXXXXX', '22194', '598', 'Sur voies de transport et ouvrages d''art', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (603, 'PCMN-BASE', 'IMMO', 'XXXXXX', '22195', '598', 'Sur constructions sur sol d''autrui', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (604, 'PCMN-BASE', 'IMMO', 'XXXXXX', '22196', '598', 'Sur frais d''acquisition sur constructions', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (605, 'PCMN-BASE', 'IMMO', 'XXXXXX', '222', '578', 'Terrains bâtis', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (606, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2220', '605', 'Valeur d''acquisition', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (607, 'PCMN-BASE', 'IMMO', 'XXXXXX', '22200', '606', 'Bâtiments industriels', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (608, 'PCMN-BASE', 'IMMO', 'XXXXXX', '22201', '606', 'Bâtiments administratifs et commerciaux', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (609, 'PCMN-BASE', 'IMMO', 'XXXXXX', '22202', '606', 'Autres bâtiments d''exploitation', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (610, 'PCMN-BASE', 'IMMO', 'XXXXXX', '22203', '606', 'Voies de transport et ouvrages d''art', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (611, 'PCMN-BASE', 'IMMO', 'XXXXXX', '22204', '606', 'Frais d''acquisition des terrains à bâtir', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (612, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2228', '605', 'Plus-values actées', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (613, 'PCMN-BASE', 'IMMO', 'XXXXXX', '22280', '612', 'Sur bâtiments industriels', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (614, 'PCMN-BASE', 'IMMO', 'XXXXXX', '22281', '612', 'Sur bâtiments administratifs et commerciaux', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (615, 'PCMN-BASE', 'IMMO', 'XXXXXX', '22282', '612', 'Sur autres bâtiments d''exploitation', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (616, 'PCMN-BASE', 'IMMO', 'XXXXXX', '22283', '612', 'Sur voies de transport et ouvrages d''art', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (617, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2229', '605', 'Amortissements sur terrains bâtis', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (618, 'PCMN-BASE', 'IMMO', 'XXXXXX', '22290', '617', 'Sur bâtiments industriels', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (619, 'PCMN-BASE', 'IMMO', 'XXXXXX', '22291', '617', 'Sur bâtiments administratifs et commerciaux', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (620, 'PCMN-BASE', 'IMMO', 'XXXXXX', '22292', '617', 'Sur autres bâtiments d''exploitation', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (621, 'PCMN-BASE', 'IMMO', 'XXXXXX', '22293', '617', 'Sur voies de transport et ouvrages d''art', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (622, 'PCMN-BASE', 'IMMO', 'XXXXXX', '22294', '617', 'Sur frais d''acquisition des terrains bâtis', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (623, 'PCMN-BASE', 'IMMO', 'XXXXXX', '223', '578', 'Autres droits réels sur des immeubles', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (624, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2230', '623', 'Valeur d''acquisition', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (625, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2238', '623', 'Plus-values actées', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (626, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2239', '623', 'Amortissements', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (627, 'PCMN-BASE', 'IMMO', 'XXXXXX', '23', '1352', 'Installations, machines et outillages', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (628, 'PCMN-BASE', 'IMMO', 'XXXXXX', '230', '627', 'Installations', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (629, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2300', '628', 'Installations bâtiments industriels', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (630, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2301', '628', 'Installations bâtiments administratifs et commerciaux', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (631, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2302', '628', 'Installations bâtiments d''exploitation', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (632, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2303', '628', 'Installations voies de transport et ouvrages d''art', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (633, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2300', '628', 'Installation d''eau', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (634, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2301', '628', 'Installation d''électricité', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (635, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2302', '628', 'Installation de vapeur', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (636, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2303', '628', 'Installation de gaz', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (637, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2304', '628', 'Installation de chauffage', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (638, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2305', '628', 'Installation de conditionnement d''air', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (639, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2306', '628', 'Installation de chargement', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (640, 'PCMN-BASE', 'IMMO', 'XXXXXX', '231', '627', 'Machines', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (641, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2310', '640', 'Division A', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (642, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2311', '640', 'Division B', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (643, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2312', '640', 'Division C', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (644, 'PCMN-BASE', 'IMMO', 'XXXXXX', '237', '627', 'Outillage', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (645, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2370', '644', 'Division A', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (646, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2371', '644', 'Division B', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (647, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2372', '644', 'Division C', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (648, 'PCMN-BASE', 'IMMO', 'XXXXXX', '238', '627', 'Plus-values actées', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (649, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2380', '648', 'Sur installations', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (650, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2381', '648', 'Sur machines', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (651, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2382', '648', 'Sur outillage', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (652, 'PCMN-BASE', 'IMMO', 'XXXXXX', '239', '627', 'Amortissements', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (653, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2390', '652', 'Sur installations', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (654, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2391', '652', 'Sur machines', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (655, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2392', '652', 'Sur outillage', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (656, 'PCMN-BASE', 'IMMO', 'XXXXXX', '24', '1352', 'Mobilier et matériel roulant', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (657, 'PCMN-BASE', 'IMMO', 'XXXXXX', '240', '656', 'Mobilier', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (658, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2400', '656', 'Mobilier', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (659, 'PCMN-BASE', 'IMMO', 'XXXXXX', '24000', '658', 'Mobilier des bâtiments industriels', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (660, 'PCMN-BASE', 'IMMO', 'XXXXXX', '24001', '658', 'Mobilier des bâtiments administratifs et commerciaux', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (661, 'PCMN-BASE', 'IMMO', 'XXXXXX', '24002', '658', 'Mobilier des autres bâtiments d''exploitation', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (662, 'PCMN-BASE', 'IMMO', 'XXXXXX', '24003', '658', 'Mobilier oeuvres sociales', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (663, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2401', '657', 'Matériel de bureau et de service social', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (664, 'PCMN-BASE', 'IMMO', 'XXXXXX', '24010', '663', 'Des bâtiments industriels', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (665, 'PCMN-BASE', 'IMMO', 'XXXXXX', '24011', '663', 'Des bâtiments administratifs et commerciaux', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (666, 'PCMN-BASE', 'IMMO', 'XXXXXX', '24012', '663', 'Des autres bâtiments d''exploitation', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (667, 'PCMN-BASE', 'IMMO', 'XXXXXX', '24013', '663', 'Des oeuvres sociales', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (668, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2408', '657', 'Plus-values actées', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (669, 'PCMN-BASE', 'IMMO', 'XXXXXX', '24080', '668', 'Plus-values actées sur mobilier', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (670, 'PCMN-BASE', 'IMMO', 'XXXXXX', '24081', '668', 'Plus-values actées sur matériel de bureau et service social', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (671, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2409', '657', 'Amortissements', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (672, 'PCMN-BASE', 'IMMO', 'XXXXXX', '24090', '671', 'Amortissements sur mobilier', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (673, 'PCMN-BASE', 'IMMO', 'XXXXXX', '24091', '671', 'Amortissements sur matériel de bureau et service social', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (674, 'PCMN-BASE', 'IMMO', 'XXXXXX', '241', '656', 'Matériel roulant', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (675, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2410', '674', 'Matériel automobile', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (676, 'PCMN-BASE', 'IMMO', 'XXXXXX', '24100', '675', 'Voitures', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (677, 'PCMN-BASE', 'IMMO', 'XXXXXX', '24105', '675', 'Camions', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (678, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2411', '674', 'Matériel ferroviaire', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (679, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2412', '674', 'Matériel fluvial', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (680, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2413', '674', 'Matériel naval', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (681, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2414', '674', 'Matériel aérien', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (682, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2418', '674', 'Plus-values sur matériel roulant', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (683, 'PCMN-BASE', 'IMMO', 'XXXXXX', '24180', '682', 'Plus-values sur matériel automobile', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (684, 'PCMN-BASE', 'IMMO', 'XXXXXX', '24181', '682', 'Idem sur matériel ferroviaire', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (685, 'PCMN-BASE', 'IMMO', 'XXXXXX', '24182', '682', 'Idem sur matériel fluvial', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (686, 'PCMN-BASE', 'IMMO', 'XXXXXX', '24183', '682', 'Idem sur matériel naval', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (687, 'PCMN-BASE', 'IMMO', 'XXXXXX', '24184', '682', 'Idem sur matériel aérien', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (688, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2419', '674', 'Amortissements sur matériel roulant', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (689, 'PCMN-BASE', 'IMMO', 'XXXXXX', '24190', '688', 'Amortissements sur matériel automobile', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (690, 'PCMN-BASE', 'IMMO', 'XXXXXX', '24191', '688', 'Idem sur matériel ferroviaire', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (691, 'PCMN-BASE', 'IMMO', 'XXXXXX', '24192', '688', 'Idem sur matériel fluvial', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (692, 'PCMN-BASE', 'IMMO', 'XXXXXX', '24193', '688', 'Idem sur matériel naval', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (693, 'PCMN-BASE', 'IMMO', 'XXXXXX', '24194', '688', 'Idem sur matériel aérien', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (694, 'PCMN-BASE', 'IMMO', 'XXXXXX', '25', '1352', 'Immobilisation détenues en location-financement et droits similaires', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (695, 'PCMN-BASE', 'IMMO', 'XXXXXX', '250', '694', 'Terrains et constructions', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (696, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2500', '695', 'Terrains', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (697, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2501', '695', 'Constructions', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (698, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2508', '695', 'Plus-values sur emphytéose,  leasing et droits similaires : terrains et constructions', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (699, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2509', '695', 'Amortissements et réductions de valeur sur terrains et constructions en leasing', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (700, 'PCMN-BASE', 'IMMO', 'XXXXXX', '251', '694', 'Installations,  machines et outillage', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (701, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2510', '700', 'Installations', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (702, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2511', '700', 'Machines', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (703, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2512', '700', 'Outillage', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (704, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2518', '700', 'Plus-values actées sur installations machines et outillage pris en leasing', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (705, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2519', '700', 'Amortissements sur installations machines et outillage pris en leasing', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (706, 'PCMN-BASE', 'IMMO', 'XXXXXX', '252', '694', 'Mobilier et matériel roulant', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (707, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2520', '706', 'Mobilier', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (708, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2521', '706', 'Matériel roulant', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (709, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2528', '706', 'Plus-values actées sur mobilier et matériel roulant en leasing', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (710, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2529', '706', 'Amortissements sur mobilier et matériel roulant en leasing', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (711, 'PCMN-BASE', 'IMMO', 'XXXXXX', '26', '1352', 'Autres immobilisations corporelles', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (712, 'PCMN-BASE', 'IMMO', 'XXXXXX', '260', '711', 'Frais d''aménagements de locaux pris en location', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (713, 'PCMN-BASE', 'IMMO', 'XXXXXX', '261', '711', 'Maison d''habitation', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (714, 'PCMN-BASE', 'IMMO', 'XXXXXX', '262', '711', 'Réserve immobilière', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (715, 'PCMN-BASE', 'IMMO', 'XXXXXX', '263', '711', 'Matériel d''emballage', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (716, 'PCMN-BASE', 'IMMO', 'XXXXXX', '264', '711', 'Emballages récupérables', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (717, 'PCMN-BASE', 'IMMO', 'XXXXXX', '268', '711', 'Plus-values actées sur autres immobilisations corporelles', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (718, 'PCMN-BASE', 'IMMO', 'XXXXXX', '269', '711', 'Amortissements sur autres immobilisations corporelles', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (719, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2690', '718', 'Amortissements sur frais d''aménagement des locaux pris en location', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (720, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2691', '718', 'Amortissements sur maison d''habitation', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (721, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2692', '718', 'Amortissements sur réserve immobilière', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (722, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2693', '718', 'Amortissements sur matériel d''emballage', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (723, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2694', '718', 'Amortissements sur emballages récupérables', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (724, 'PCMN-BASE', 'IMMO', 'XXXXXX', '27', '1352', 'Immobilisations corporelles en cours et acomptes versés', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (725, 'PCMN-BASE', 'IMMO', 'XXXXXX', '270', '724', 'Immobilisations en cours', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (726, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2700', '725', 'Constructions', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (727, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2701', '725', 'Installations machines et outillage', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (728, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2702', '725', 'Mobilier et matériel roulant', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (729, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2703', '725', 'Autres immobilisations corporelles', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (730, 'PCMN-BASE', 'IMMO', 'XXXXXX', '271', '724', 'Avances et acomptes versés sur immobilisations en cours', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (731, 'PCMN-BASE', 'IMMO', 'XXXXXX', '28', '1352', 'Immobilisations financières', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (732, 'PCMN-BASE', 'IMMO', 'XXXXXX', '280', '731', 'Participations dans des entreprises liées', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (733, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2800', '732', 'Valeur d''acquisition (peut être subdivisé par participation)', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (734, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2801', '732', 'Montants non appelés (idem)', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (735, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2808', '732', 'Plus-values actées (idem)', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (736, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2809', '732', 'Réductions de valeurs actées (idem)', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (737, 'PCMN-BASE', 'IMMO', 'XXXXXX', '281', '731', 'Créances sur des entreprises liées', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (738, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2810', '737', 'Créances en compte', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (739, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2811', '737', 'Effets à recevoir', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (740, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2812', '737', 'Titres à revenu fixes', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (741, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2817', '737', 'Créances douteuses', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (742, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2819', '737', 'Réductions de valeurs actées', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (743, 'PCMN-BASE', 'IMMO', 'XXXXXX', '282', '731', 'Participations dans des entreprises avec lesquelles il existe un lien de participation', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (744, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2820', '743', 'Valeur d''acquisition (peut être subdivisé par participation)', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (745, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2821', '743', 'Montants non appelés (idem)', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (746, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2828', '743', 'Plus-values actées (idem)', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (747, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2829', '743', 'Réductions de valeurs actées (idem)', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (748, 'PCMN-BASE', 'IMMO', 'XXXXXX', '283', '731', 'Créances sur des entreprises avec lesquelles il existe un lien de participation', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (749, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2830', '748', 'Créances en compte', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (750, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2831', '748', 'Effets à recevoir', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (751, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2832', '748', 'Titres à revenu fixe', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (752, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2837', '748', 'Créances douteuses', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (753, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2839', '748', 'Réductions de valeurs actées', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (754, 'PCMN-BASE', 'IMMO', 'XXXXXX', '284', '731', 'Autres actions et parts', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (755, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2840', '754', 'Valeur d''acquisition', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (756, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2841', '754', 'Montants non appelés', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (757, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2848', '754', 'Plus-values actées', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (758, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2849', '754', 'Réductions de valeur actées', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (759, 'PCMN-BASE', 'IMMO', 'XXXXXX', '285', '731', 'Autres créances', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (760, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2850', '759', 'Créances en compte', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (761, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2851', '759', 'Effets à recevoir', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (762, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2852', '759', 'Titres à revenu fixe', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (763, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2857', '759', 'Créances douteuses', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (764, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2859', '759', 'Réductions de valeur actées', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (765, 'PCMN-BASE', 'IMMO', 'XXXXXX', '288', '731', 'Cautionnements versés en numéraires', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (766, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2880', '765', 'Téléphone, téléfax, télex', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (767, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2881', '765', 'Gaz', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (768, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2882', '765', 'Eau', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (769, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2883', '765', 'Electricité', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (770, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2887', '765', 'Autres cautionnements versés en numéraires', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (771, 'PCMN-BASE', 'IMMO', 'XXXXXX', '29', '1352', 'Créances à plus d''un an', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (772, 'PCMN-BASE', 'IMMO', 'XXXXXX', '290', '771', 'Créances commerciales', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (773, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2900', '772', 'Clients', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (774, 'PCMN-BASE', 'IMMO', 'XXXXXX', '29000', '773', 'Créances en compte sur entreprises liées', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (775, 'PCMN-BASE', 'IMMO', 'XXXXXX', '29001', '773', 'Sur entreprises avec lesquelles il existe un lien de participation', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (776, 'PCMN-BASE', 'IMMO', 'XXXXXX', '29002', '773', 'Sur clients Belgique', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (777, 'PCMN-BASE', 'IMMO', 'XXXXXX', '29003', '773', 'Sur clients C.E.E.', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (778, 'PCMN-BASE', 'IMMO', 'XXXXXX', '29004', '773', 'Sur clients exportation hors C.E.E.', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (779, 'PCMN-BASE', 'IMMO', 'XXXXXX', '29005', '773', 'Créances sur les coparticipants (associations momentanées)', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (780, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2901', '772', 'Effets à recevoir', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (781, 'PCMN-BASE', 'IMMO', 'XXXXXX', '29010', '780', 'Sur entreprises liées', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (782, 'PCMN-BASE', 'IMMO', 'XXXXXX', '29011', '780', 'Sur entreprises avec lesquelles il existe un lien de participation', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (783, 'PCMN-BASE', 'IMMO', 'XXXXXX', '29012', '780', 'Sur clients Belgique', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (784, 'PCMN-BASE', 'IMMO', 'XXXXXX', '29013', '780', 'Sur clients C.E.E.', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (785, 'PCMN-BASE', 'IMMO', 'XXXXXX', '29014', '780', 'Sur clients exportation hors C.E.E.', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (786, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2905', '772', 'Retenues sur garanties', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (787, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2906', '772', 'Acomptes versés', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (788, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2907', '772', 'Créances douteuses (à ventiler comme clients 2900)', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (789, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2909', '772', 'Réductions de valeur actées (à ventiler comme clients 2900)', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (790, 'PCMN-BASE', 'IMMO', 'XXXXXX', '291', '771', 'Autres créances', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (791, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2910', '790', 'Créances en compte', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (792, 'PCMN-BASE', 'IMMO', 'XXXXXX', '29100', '791', 'Sur entreprises liées', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (793, 'PCMN-BASE', 'IMMO', 'XXXXXX', '29101', '791', 'Sur entreprises avec lesquelles il existe un lien de participation', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (794, 'PCMN-BASE', 'IMMO', 'XXXXXX', '29102', '791', 'Sur autres débiteurs', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (795, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2911', '790', 'Effets à recevoir', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (796, 'PCMN-BASE', 'IMMO', 'XXXXXX', '29110', '795', 'Sur entreprises liées', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (797, 'PCMN-BASE', 'IMMO', 'XXXXXX', '29111', '795', 'Sur entreprises avec lesquelles il existe un lien de participation', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (798, 'PCMN-BASE', 'IMMO', 'XXXXXX', '29112', '795', 'Sur autres débiteurs', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (799, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2912', '790', 'Créances résultant de la cession d''immobilisations données en leasing', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (800, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2917', '790', 'Créances douteuses', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (801, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2919', '790', 'Réductions de valeur actées', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (802, 'PCMN-BASE', 'STOCK', 'XXXXXX', '30', '1353', 'Approvisionnements - matières premières', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (803, 'PCMN-BASE', 'STOCK', 'XXXXXX', '300', '802', 'Valeur d''acquisition', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (804, 'PCMN-BASE', 'STOCK', 'XXXXXX', '309', '802', 'Réductions de valeur actées', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (805, 'PCMN-BASE', 'STOCK', 'XXXXXX', '31', '1353', 'Approvsionnements et fournitures', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (806, 'PCMN-BASE', 'STOCK', 'XXXXXX', '310', '805', 'Valeur d''acquisition', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (807, 'PCMN-BASE', 'STOCK', 'XXXXXX', '3100', '806', 'Matières d''approvisionnement', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (808, 'PCMN-BASE', 'STOCK', 'XXXXXX', '3101', '806', 'Energie, charbon, coke, mazout, essence, propane', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (809, 'PCMN-BASE', 'STOCK', 'XXXXXX', '3102', '806', 'Produits d''entretien', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (810, 'PCMN-BASE', 'STOCK', 'XXXXXX', '3103', '806', 'Fournitures diverses et petit outillage', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (811, 'PCMN-BASE', 'STOCK', 'XXXXXX', '3104', '806', 'Imprimés et fournitures de bureau', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (812, 'PCMN-BASE', 'STOCK', 'XXXXXX', '3105', '806', 'Fournitures de services sociaux', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (813, 'PCMN-BASE', 'STOCK', 'XXXXXX', '3106', '806', 'Emballages commerciaux', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (814, 'PCMN-BASE', 'STOCK', 'XXXXXX', '31060', '813', 'Emballages perdus', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (815, 'PCMN-BASE', 'STOCK', 'XXXXXX', '31061', '813', 'Emballages récupérables', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (816, 'PCMN-BASE', 'STOCK', 'XXXXXX', '319', '805', 'Réductions de valeur actées', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (817, 'PCMN-BASE', 'STOCK', 'XXXXXX', '32', '1353', 'En cours de fabrication', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (818, 'PCMN-BASE', 'STOCK', 'XXXXXX', '320', '817', 'Valeur d''acquisition', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (819, 'PCMN-BASE', 'STOCK', 'XXXXXX', '3200', '818', 'Produits semi-ouvrés', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (820, 'PCMN-BASE', 'STOCK', 'XXXXXX', '3201', '818', 'Produits en cours de fabrication', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (821, 'PCMN-BASE', 'STOCK', 'XXXXXX', '3202', '818', 'Travaux en cours', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (822, 'PCMN-BASE', 'STOCK', 'XXXXXX', '3205', '818', 'Déchets', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (823, 'PCMN-BASE', 'STOCK', 'XXXXXX', '3206', '818', 'Rebuts', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (824, 'PCMN-BASE', 'STOCK', 'XXXXXX', '3209', '818', 'Travaux en association momentanée', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (825, 'PCMN-BASE', 'STOCK', 'XXXXXX', '329', '817', 'Réductions de valeur actées', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (826, 'PCMN-BASE', 'STOCK', 'XXXXXX', '33', '1353', 'Produits finis', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (827, 'PCMN-BASE', 'STOCK', 'XXXXXX', '330', '826', 'Valeur d''acquisition', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (828, 'PCMN-BASE', 'STOCK', 'XXXXXX', '3300', '827', 'Produits finis', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (829, 'PCMN-BASE', 'STOCK', 'XXXXXX', '339', '826', 'Réductions de valeur actées', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (830, 'PCMN-BASE', 'STOCK', 'XXXXXX', '34', '1353', 'Marchandises', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (831, 'PCMN-BASE', 'STOCK', 'XXXXXX', '340', '830', 'Valeur d''acquisition', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (832, 'PCMN-BASE', 'STOCK', 'XXXXXX', '3400', '831', 'Groupe A', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (833, 'PCMN-BASE', 'STOCK', 'XXXXXX', '3401', '831', 'Groupe B', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (834, 'PCMN-BASE', 'STOCK', 'XXXXXX', '3402', '831', 'Groupe C', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (835, 'PCMN-BASE', 'STOCK', 'XXXXXX', '349', '830', 'Réductions de valeur actées', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (836, 'PCMN-BASE', 'STOCK', 'XXXXXX', '35', '1353', 'Immeubles destinés à la vente', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (837, 'PCMN-BASE', 'STOCK', 'XXXXXX', '350', '836', 'Valeur d''acquisition', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (838, 'PCMN-BASE', 'STOCK', 'XXXXXX', '3500', '837', 'Immeuble A', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (839, 'PCMN-BASE', 'STOCK', 'XXXXXX', '3501', '837', 'Immeuble B', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (840, 'PCMN-BASE', 'STOCK', 'XXXXXX', '3502', '837', 'Immeuble C', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (841, 'PCMN-BASE', 'STOCK', 'XXXXXX', '351', '836', 'Immeubles construits en vue de leur revente', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (842, 'PCMN-BASE', 'STOCK', 'XXXXXX', '3510', '841', 'Immeuble A', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (843, 'PCMN-BASE', 'STOCK', 'XXXXXX', '3511', '841', 'Immeuble B', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (844, 'PCMN-BASE', 'STOCK', 'XXXXXX', '3512', '841', 'Immeuble C', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (845, 'PCMN-BASE', 'STOCK', 'XXXXXX', '359', '836', 'Réductions de valeurs actées', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (846, 'PCMN-BASE', 'STOCK', 'XXXXXX', '36', '1353', 'Acomptes versés sur achats pour stocks', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (847, 'PCMN-BASE', 'STOCK', 'XXXXXX', '360', '846', 'Acomptes versés (à ventiler éventuellement par catégorie)', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (848, 'PCMN-BASE', 'STOCK', 'XXXXXX', '369', '846', 'Réductions de valeur actées', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (849, 'PCMN-BASE', 'STOCK', 'XXXXXX', '37', '1353', 'Commandes en cours d''exécution', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (850, 'PCMN-BASE', 'STOCK', 'XXXXXX', '370', '849', 'Valeur d''acquisition', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (851, 'PCMN-BASE', 'STOCK', 'XXXXXX', '371', '849', 'Bénéfice pris en compte', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (852, 'PCMN-BASE', 'STOCK', 'XXXXXX', '379', '849', 'Réductions de valeur actées', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (853, 'PCMN-BASE', 'TIERS', 'XXXXXX', '40', '1354', 'Créances commerciales', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (854, 'PCMN-BASE', 'TIERS', 'XXXXXX', '400', '853', 'Clients', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (855, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4007', '854', 'Rabais, remises et  ristournes à accorder et autres notes de crédit à établir', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (856, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4008', '854', 'Créances résultant de livraisons de biens (associations momentanées)', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (857, 'PCMN-BASE', 'TIERS', 'XXXXXX', '401', '853', 'Effets à recevoir', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (858, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4010', '857', 'Effets à recevoir', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (859, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4013', '857', 'Effets à l''encaissement', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (860, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4015', '857', 'Effets à l''escompte', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (861, 'PCMN-BASE', 'TIERS', 'XXXXXX', '402', '853', 'Clients, créances courantes, entreprises apparentées, administrateurs et gérants', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (862, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4020', '861', 'Entreprises liées', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (863, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4021', '861', 'Autres entreprises avec lesquelles il existe un lien de participation', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (864, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4022', '861', 'Administrateurs et gérants d''entreprise', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (865, 'PCMN-BASE', 'TIERS', 'XXXXXX', '403', '853', 'Effets à recevoir sur entreprises apparentées et administrateurs et gérants', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (866, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4030', '865', 'Entreprises liées', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (867, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4031', '865', 'Autres entreprises avec lesquelles il existe un lien de participation', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (868, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4032', '865', 'Administrateurs et gérants de l''entreprise', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (869, 'PCMN-BASE', 'TIERS', 'XXXXXX', '404', '853', 'Produits à recevoir (factures à établir)', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (870, 'PCMN-BASE', 'TIERS', 'XXXXXX', '405', '853', 'Clients : retenues sur garanties', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (871, 'PCMN-BASE', 'TIERS', 'XXXXXX', '406', '853', 'Acomptes versés', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (872, 'PCMN-BASE', 'TIERS', 'XXXXXX', '407', '853', 'Créances douteuses', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (873, 'PCMN-BASE', 'TIERS', 'XXXXXX', '408', '853', 'Compensation clients', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (874, 'PCMN-BASE', 'TIERS', 'XXXXXX', '409', '853', 'Réductions de valeur actées', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (875, 'PCMN-BASE', 'TIERS', 'XXXXXX', '41', '1354', 'Autres créances', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (876, 'PCMN-BASE', 'TIERS', 'XXXXXX', '410', '875', 'Capital appelé, non versé', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (877, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4100', '876', 'Appels de fonds', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (878, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4101', '876', 'Actionnaires défaillants', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (879, 'PCMN-BASE', 'TIERS', 'XXXXXX', '411', '875', 'T.V.A. à récupérer', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (880, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4110', '879', 'T.V.A. due', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (881, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4111', '879', 'T.V.A. déductible', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (882, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4112', '879', 'Compte courant administration T.V.A.', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (883, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4118', '879', 'Taxe d''égalisation due', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (884, 'PCMN-BASE', 'TIERS', 'XXXXXX', '412', '875', 'Impôts et versements fiscaux à récupérer', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (885, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4120', '884', 'Impôts belges sur le résultat', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (886, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4125', '884', 'Autres impôts belges', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (887, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4128', '884', 'Impôts étrangers', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (888, 'PCMN-BASE', 'TIERS', 'XXXXXX', '414', '875', 'Produits à recevoir', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (889, 'PCMN-BASE', 'TIERS', 'XXXXXX', '416', '875', 'Créances diverses', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (890, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4160', '889', 'Associés (compte d''apport en société)', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (891, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4161', '889', 'Avances et prêts au personnel', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (892, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4162', '889', 'Compte courant des associés en S.P.R.L.', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (893, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4163', '889', 'Compte courant des administrateurs et gérants', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (894, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4164', '889', 'Créances sur sociétés apparentées', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (895, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4166', '889', 'Emballages et matériel à rendre', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (896, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4167', '889', 'Etat et établissements publics', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (897, 'PCMN-BASE', 'TIERS', 'XXXXXX', '41670', '896', 'Subsides à recevoir', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (898, 'PCMN-BASE', 'TIERS', 'XXXXXX', '41671', '896', 'Autres créances', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (899, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4168', '889', 'Rabais, ristournes et remises à obtenir et autres avoirs non encore reçus', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (900, 'PCMN-BASE', 'TIERS', 'XXXXXX', '417', '875', 'Créances douteuses', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (901, 'PCMN-BASE', 'TIERS', 'XXXXXX', '418', '875', 'Cautionnements versés en numéraires', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (902, 'PCMN-BASE', 'TIERS', 'XXXXXX', '419', '875', 'Réductions de valeur actées', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (903, 'PCMN-BASE', 'TIERS', 'XXXXXX', '42', '1354', 'Dettes à plus d''un an échéant dans l''année', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (904, 'PCMN-BASE', 'TIERS', 'XXXXXX', '420', '903', 'Emprunts subordonnés', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (905, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4200', '904', 'Convertibles', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (906, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4201', '904', 'Non convertibles', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (907, 'PCMN-BASE', 'TIERS', 'XXXXXX', '421', '903', 'Emprunts obligataires non subordonnés', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (908, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4210', '907', 'Convertibles', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (909, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4211', '907', 'Non convertibles', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (910, 'PCMN-BASE', 'TIERS', 'XXXXXX', '422', '903', 'Dettes de location-financement et assimilées', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (911, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4220', '910', 'Financement de biens immobiliers', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (912, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4221', '910', 'Financement de biens mobiliers', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (913, 'PCMN-BASE', 'TIERS', 'XXXXXX', '423', '903', 'Etablissements de crédit', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (914, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4230', '913', 'Dettes en compte', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (915, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4231', '913', 'Promesses', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (916, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4232', '913', 'Crédits d''acceptation', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (917, 'PCMN-BASE', 'TIERS', 'XXXXXX', '424', '903', 'Autres emprunts', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (918, 'PCMN-BASE', 'TIERS', 'XXXXXX', '425', '903', 'Dettes commerciales', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (919, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4250', '918', 'Fournisseurs', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (920, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4251', '918', 'Effets à payer', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (921, 'PCMN-BASE', 'TIERS', 'XXXXXX', '426', '903', 'Cautionnements reçus en numéraires', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (922, 'PCMN-BASE', 'TIERS', 'XXXXXX', '429', '903', 'Dettes diverses', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (923, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4290', '922', 'Entreprises liées', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (924, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4291', '922', 'Entreprises avec lesquelles il existe un lien de participation', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (925, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4292', '922', 'Administrateurs, gérants, associés', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (926, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4299', '922', 'Autres dettes', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (927, 'PCMN-BASE', 'TIERS', 'XXXXXX', '43', '1354', 'Dettes financières', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (928, 'PCMN-BASE', 'TIERS', 'XXXXXX', '430', '927', 'Etablissements de crédit. Emprunts en compte à terme fixe', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (929, 'PCMN-BASE', 'TIERS', 'XXXXXX', '431', '927', 'Etablissements de crédit. Promesses', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (930, 'PCMN-BASE', 'TIERS', 'XXXXXX', '432', '927', 'Etablissements de crédit. Crédits d''acceptation', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (931, 'PCMN-BASE', 'TIERS', 'XXXXXX', '433', '927', 'Etablissements de crédit. Dettes en compte courant', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (932, 'PCMN-BASE', 'TIERS', 'XXXXXX', '439', '927', 'Autres emprunts', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (933, 'PCMN-BASE', 'TIERS', 'XXXXXX', '44', '1354', 'Dettes commerciales', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (934, 'PCMN-BASE', 'TIERS', 'XXXXXX', '440', '933', 'Fournisseurs', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (935, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4400', '934', 'Entreprises apparentées', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (936, 'PCMN-BASE', 'TIERS', 'XXXXXX', '44000', '935', 'Entreprises liées', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (937, 'PCMN-BASE', 'TIERS', 'XXXXXX', '44001', '935', 'Entreprises avec lesquelles il existe un lien de participation', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (938, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4401', '934', 'Fournisseurs ordinaires', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (939, 'PCMN-BASE', 'TIERS', 'XXXXXX', '44010', '938', 'Fournisseurs belges', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (940, 'PCMN-BASE', 'TIERS', 'XXXXXX', '44011', '938', 'Fournisseurs CEE', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (941, 'PCMN-BASE', 'TIERS', 'XXXXXX', '44012', '938', 'Fournisseurs importation', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (942, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4402', '934', 'Dettes envers les coparticipants (associations momentanées)', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (943, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4403', '934', 'Fournisseurs - retenues de garanties', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (944, 'PCMN-BASE', 'TIERS', 'XXXXXX', '441', '933', 'Effets à payer', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (945, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4410', '944', 'Entreprises apparentées', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (946, 'PCMN-BASE', 'TIERS', 'XXXXXX', '44100', '945', 'Entreprises liées', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (947, 'PCMN-BASE', 'TIERS', 'XXXXXX', '44101', '945', 'Entreprises avec lesquelles il existe un lien de participation', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (948, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4411', '944', 'Fournisseurs ordinaires', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (949, 'PCMN-BASE', 'TIERS', 'XXXXXX', '44110', '948', 'Fournisseurs belges', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (950, 'PCMN-BASE', 'TIERS', 'XXXXXX', '44111', '948', 'Fournisseurs CEE', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (951, 'PCMN-BASE', 'TIERS', 'XXXXXX', '44112', '948', 'Fournisseurs importation', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (952, 'PCMN-BASE', 'TIERS', 'XXXXXX', '444', '933', 'Factures à recevoir', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (953, 'PCMN-BASE', 'TIERS', 'XXXXXX', '446', '933', 'Acomptes reçus', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (954, 'PCMN-BASE', 'TIERS', 'XXXXXX', '448', '933', 'Compensations fournisseurs', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (955, 'PCMN-BASE', 'TIERS', 'XXXXXX', '45', '1354', 'Dettes fiscales, salariales et sociales', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (956, 'PCMN-BASE', 'TIERS', 'XXXXXX', '450', '955', 'Dettes fiscales estimées', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (957, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4501', '956', 'Impôts sur le résultat', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (958, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4505', '956', 'Autres impôts en Belgique', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (959, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4508', '956', 'Impôts à l''étranger', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (960, 'PCMN-BASE', 'TIERS', 'XXXXXX', '451', '955', 'T.V.A. à payer', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (961, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4510', '960', 'T.V.A. due', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (962, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4511', '960', 'T.V.A. déductible', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (963, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4512', '960', 'Compte courant administration T.V.A.', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (964, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4518', '960', 'Taxe d''égalisation due', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (965, 'PCMN-BASE', 'TIERS', 'XXXXXX', '452', '955', 'Impôts et taxes à payer', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (966, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4520', '965', 'Autres impôts sur le résultat', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (967, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4525', '965', 'Autres impôts et taxes en Belgique', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (968, 'PCMN-BASE', 'TIERS', 'XXXXXX', '45250', '967', 'Précompte immobilier', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (969, 'PCMN-BASE', 'TIERS', 'XXXXXX', '45251', '967', 'Impôts communaux à payer', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (970, 'PCMN-BASE', 'TIERS', 'XXXXXX', '45252', '967', 'Impôts provinciaux à payer', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (971, 'PCMN-BASE', 'TIERS', 'XXXXXX', '45253', '967', 'Autres impôts et taxes à payer', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (972, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4528', '965', 'Impôts et taxes à l''étranger', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (973, 'PCMN-BASE', 'TIERS', 'XXXXXX', '453', '955', 'Précomptes retenus', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (974, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4530', '973', 'Précompte professionnel retenu sur rémunérations', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (975, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4531', '973', 'Précompte professionnel retenu sur tantièmes', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (976, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4532', '973', 'Précompte mobilier retenu sur dividendes attribués', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (977, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4533', '973', 'Précompte mobilier retenu sur intérêts payés', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (978, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4538', '973', 'Autres précomptes retenus', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (979, 'PCMN-BASE', 'TIERS', 'XXXXXX', '454', '955', 'Office National de la Sécurité Sociale', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (980, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4540', '979', 'Arriérés', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (981, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4541', '979', '1er trimestre', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (982, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4542', '979', '2ème trimestre', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (983, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4543', '979', '3ème trimestre', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (984, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4544', '979', '4ème trimestre', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (985, 'PCMN-BASE', 'TIERS', 'XXXXXX', '455', '955', 'Rémunérations', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (986, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4550', '985', 'Administrateurs,  gérants et commissaires (non réviseurs)', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (987, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4551', '985', 'Direction', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (988, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4552', '985', 'Employés', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (989, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4553', '985', 'Ouvriers', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (990, 'PCMN-BASE', 'TIERS', 'XXXXXX', '456', '955', 'Pécules de vacances', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (991, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4560', '990', 'Direction', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (992, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4561', '990', 'Employés', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (993, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4562', '990', 'Ouvriers', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (994, 'PCMN-BASE', 'TIERS', 'XXXXXX', '459', '955', 'Autres dettes sociales', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (995, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4590', '994', 'Provision pour gratifications de fin d''année', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (996, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4591', '994', 'Départs de personnel', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (997, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4592', '994', 'Oppositions sur rémunérations', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (998, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4593', '994', 'Assurances relatives au personnel', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (999, 'PCMN-BASE', 'TIERS', 'XXXXXX', '45930', '998', 'Assurance loi', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1000, 'PCMN-BASE', 'TIERS', 'XXXXXX', '45931', '998', 'Assurance salaire garanti', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1001, 'PCMN-BASE', 'TIERS', 'XXXXXX', '45932', '998', 'Assurance groupe', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1002, 'PCMN-BASE', 'TIERS', 'XXXXXX', '45933', '998', 'Assurances individuelles', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1003, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4594', '994', 'Caisse d''assurances sociales pour travailleurs indépendants', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1004, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4597', '994', 'Dettes et provisions sociales diverses', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1005, 'PCMN-BASE', 'TIERS', 'XXXXXX', '46', '1354', 'Acomptes reçus sur commande', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1006, 'PCMN-BASE', 'TIERS', 'XXXXXX', '47', '1354', 'Dettes découlant de l''affectation des résultats', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1007, 'PCMN-BASE', 'TIERS', 'XXXXXX', '470', '1006', 'Dividendes et tantièmes d''exercices antérieurs', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1008, 'PCMN-BASE', 'TIERS', 'XXXXXX', '471', '1006', 'Dividendes de l''exercice', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1009, 'PCMN-BASE', 'TIERS', 'XXXXXX', '472', '1006', 'Tantièmes de l''exercice', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1010, 'PCMN-BASE', 'TIERS', 'XXXXXX', '473', '1006', 'Autres allocataires', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1011, 'PCMN-BASE', 'TIERS', 'XXXXXX', '48', '4', 'Dettes diverses', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1012, 'PCMN-BASE', 'TIERS', 'XXXXXX', '480', '1011', 'Obligations et coupons échus', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1013, 'PCMN-BASE', 'TIERS', 'XXXXXX', '481', '1011', 'Actionnaires - capital à rembourser', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1014, 'PCMN-BASE', 'TIERS', 'XXXXXX', '482', '1011', 'Participation du personnel à payer', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1015, 'PCMN-BASE', 'TIERS', 'XXXXXX', '483', '1011', 'Acomptes reçus d''autres tiers à moins d''un an', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1016, 'PCMN-BASE', 'TIERS', 'XXXXXX', '486', '1011', 'Emballages et matériel consignés', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1017, 'PCMN-BASE', 'TIERS', 'XXXXXX', '488', '1011', 'Cautionnements reçus en numéraires', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1018, 'PCMN-BASE', 'TIERS', 'XXXXXX', '489', '1011', 'Autres dettes diverses', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1019, 'PCMN-BASE', 'TIERS', 'XXXXXX', '49', '1354', 'Comptes de régularisation et compte d''attente', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1020, 'PCMN-BASE', 'TIERS', 'XXXXXX', '490', '1019', 'Charges à reporter (à subdiviser par catégorie de charges)', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1021, 'PCMN-BASE', 'TIERS', 'XXXXXX', '491', '1019', 'Produits acquis', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1022, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4910', '1021', 'Produits d''exploitation', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1023, 'PCMN-BASE', 'TIERS', 'XXXXXX', '49100', '1022', 'Ristournes et rabais à obtenir', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1024, 'PCMN-BASE', 'TIERS', 'XXXXXX', '49101', '1022', 'Commissions à obtenir', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1025, 'PCMN-BASE', 'TIERS', 'XXXXXX', '49102', '1022', 'Autres produits d''exploitation (redevances par exemple)', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1026, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4911', '1021', 'Produits financiers', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1027, 'PCMN-BASE', 'TIERS', 'XXXXXX', '49110', '1026', 'Intérêts courus et non échus sur prêts et débits', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1028, 'PCMN-BASE', 'TIERS', 'XXXXXX', '49111', '1026', 'Autres produits financiers', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1029, 'PCMN-BASE', 'TIERS', 'XXXXXX', '492', '1019', 'Charges à imputer (à subdiviser par catégorie de charges)', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1030, 'PCMN-BASE', 'TIERS', 'XXXXXX', '493', '1019', 'Produits à reporter', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1031, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4930', '1030', 'Produits d''exploitation à reporter', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1032, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4931', '1030', 'Produits financiers à reporter', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1033, 'PCMN-BASE', 'TIERS', 'XXXXXX', '499', '1019', 'Comptes d''attente', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1034, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4990', '1033', 'Compte d''attente', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1035, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4991', '1033', 'Compte de répartition périodique des charges', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1036, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4999', '1033', 'Transferts d''exercice', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1037, 'PCMN-BASE', 'FINAN', 'XXXXXX', '50', '1355', 'Actions propres', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1038, 'PCMN-BASE', 'FINAN', 'XXXXXX', '51', '1355', 'Actions et parts', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1039, 'PCMN-BASE', 'FINAN', 'XXXXXX', '510', '1038', 'Valeur d''acquisition', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1040, 'PCMN-BASE', 'FINAN', 'XXXXXX', '511', '1038', 'Montants non appelés', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1041, 'PCMN-BASE', 'FINAN', 'XXXXXX', '519', '1038', 'Réductions de valeur actées', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1042, 'PCMN-BASE', 'FINAN', 'XXXXXX', '52', '1355', 'Titres à revenus fixes', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1043, 'PCMN-BASE', 'FINAN', 'XXXXXX', '520', '1042', 'Valeur d''acquisition', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1044, 'PCMN-BASE', 'FINAN', 'XXXXXX', '529', '1042', 'Réductions de valeur actées', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1045, 'PCMN-BASE', 'FINAN', 'XXXXXX', '53', '1355', 'Dépots à terme', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1046, 'PCMN-BASE', 'FINAN', 'XXXXXX', '530', '1045', 'De plus d''un an', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1047, 'PCMN-BASE', 'FINAN', 'XXXXXX', '531', '1045', 'De plus d''un mois et à un an au plus', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1048, 'PCMN-BASE', 'FINAN', 'XXXXXX', '532', '1045', 'd''un mois au plus', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1049, 'PCMN-BASE', 'FINAN', 'XXXXXX', '539', '1045', 'Réductions de valeur actées', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1050, 'PCMN-BASE', 'FINAN', 'XXXXXX', '54', '1355', 'Valeurs échues à l''encaissement', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1051, 'PCMN-BASE', 'FINAN', 'XXXXXX', '540', '1050', 'Chèques à encaisser', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1052, 'PCMN-BASE', 'FINAN', 'XXXXXX', '541', '1050', 'Coupons à encaisser', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1053, 'PCMN-BASE', 'FINAN', 'XXXXXX', '55', '1355', 'Etablissements de crédit - Comptes ouverts auprès des divers établissements.', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1054, 'PCMN-BASE', 'FINAN', 'XXXXXX', '550', '1053', 'Comptes courants', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1055, 'PCMN-BASE', 'FINAN', 'XXXXXX', '551', '1053', 'Chèques émis', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1056, 'PCMN-BASE', 'FINAN', 'XXXXXX', '559', '1053', 'Réductions de valeur actées', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1057, 'PCMN-BASE', 'FINAN', 'XXXXXX', '56', '1355', 'Office des chèques postaux', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1058, 'PCMN-BASE', 'FINAN', 'XXXXXX', '560', '1057', 'Compte courant', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1059, 'PCMN-BASE', 'FINAN', 'XXXXXX', '561', '1057', 'Chèques émis', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1060, 'PCMN-BASE', 'FINAN', 'XXXXXX', '57', '1355', 'Caisses', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1061, 'PCMN-BASE', 'FINAN', 'XXXXXX', '570', '1060', 'à 577 Caisses - espèces ( 0 - centrale ; 7 - succursales et agences)', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1062, 'PCMN-BASE', 'FINAN', 'XXXXXX', '578', '1060', 'Caisses - timbres ( 0 - fiscaux ; 1 - postaux)', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1063, 'PCMN-BASE', 'FINAN', 'XXXXXX', '58', '1355', 'Virements internes', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1064, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '60', '1356', 'Approvisionnements et marchandises', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1065, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '600', '1064', 'Achats de matières premières', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1066, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '601', '1064', 'Achats de fournitures', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1067, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '602', '1064', 'Achats de services, travaux et études', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1068, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '603', '1064', 'Sous-traitances générales', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1069, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '604', '1064', 'Achats de marchandises', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1070, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '605', '1064', 'Achats d''immeubles destinés à la revente', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1071, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '608', '1064', 'Remises , ristournes et rabais obtenus sur achats', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1072, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '609', '1064', 'Variations de stocks', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1073, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '6090', '1072', 'De matières premières', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1074, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '6091', '1072', 'De fournitures', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1075, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '6094', '1072', 'De marchandises', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1076, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '6095', '1072', 'd''immeubles destinés à la vente', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1077, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '61', '1356', 'Services et biens divers', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1078, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '610', '1077', 'Loyers et charges locatives', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1079, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '6100', '1078', 'Loyers divers', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1080, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '6101', '1078', 'Charges locatives (assurances, frais de confort,etc)', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1081, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '611', '1077', 'Entretien et réparation (fournitures et prestations)', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1082, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '612', '1077', 'Fournitures faites à l''entreprise', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1083, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '6120', '1082', 'Eau, gaz, électricité, vapeur', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1084, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '61200', '1083', 'Eau', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1085, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '61201', '1083', 'Gaz', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1086, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '61202', '1083', 'Electricité', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1087, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '61203', '1083', 'Vapeur', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1088, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '6121', '1082', 'Téléphone, télégrammes, télex, téléfax, frais postaux', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1089, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '61210', '1088', 'Téléphone', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1090, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '61211', '1088', 'Télégrammes', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1091, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '61212', '1088', 'Télex et téléfax', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1092, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '61213', '1088', 'Frais postaux', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1093, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '6122', '1082', 'Livres, bibliothèque', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1094, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '6123', '1082', 'Imprimés et fournitures de bureau (si non comptabilisé au 601)', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1095, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '613', '1077', 'Rétributions de tiers', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1096, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '6130', '1095', 'Redevances et royalties', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1097, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '61300', '1096', 'Redevances pour brevets, licences, marques et accessoires', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1098, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '61301', '1096', 'Autres redevances (procédés de fabrication)', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1099, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '6131', '1095', 'Assurances non relatives au personnel', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1100, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '61310', '1099', 'Assurance incendie', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1101, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '61311', '1099', 'Assurance vol', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1102, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '61312', '1099', 'Assurance autos', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1103, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '61313', '1099', 'Assurance crédit', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1104, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '61314', '1099', 'Assurances frais généraux', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1105, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '6132', '1095', 'Divers', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1106, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '61320', '1105', 'Commissions aux tiers', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1107, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '61321', '1105', 'Honoraires d''avocats, d''experts, etc', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1108, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '61322', '1105', 'Cotisations aux groupements professionnels', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1109, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '61323', '1105', 'Dons, libéralités, etc', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1110, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '61324', '1105', 'Frais de contentieux', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1111, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '61325', '1105', 'Publications légales', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1112, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '6133', '1095', 'Transports et déplacements', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1113, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '61330', '1112', 'Transports de personnel', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1114, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '61331', '1112', 'Voyages, déplacements et représentations', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1115, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '6134', '1095', 'Personnel intérimaire', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1116, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '614', '1077', 'Annonces, publicité, propagande et documentation', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1117, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '6140', '1116', 'Annonces et insertions', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1118, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '6141', '1116', 'Catalogues et imprimés', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1119, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '6142', '1116', 'Echantillons', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1120, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '6143', '1116', 'Foires et expositions', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1121, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '6144', '1116', 'Primes', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1122, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '6145', '1116', 'Cadeaux à la clientèle', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1123, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '6146', '1116', 'Missions et réceptions', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1124, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '6147', '1116', 'Documentation', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1125, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '615', '1077', 'Sous-traitants', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1126, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '6150', '1125', 'Sous-traitants pour activités propres', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1127, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '6151', '1125', 'Sous-traitants d''associations momentanées (coparticipants)', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1128, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '6152', '1125', 'Quote-part bénéficiaire des coparticipants', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1129, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '617', '1077', 'Personnel intérimaire et personnes mises à la disposition de l''entreprise', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1130, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '618', '1077', 'Rémunérations, primes pour assurances extralégales, pensions de retraite et de survie des administrateurs, gérants et associés actifs qui ne sont pas attribuées en vertu d''un contrat de travail', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1131, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '62', '1356', 'Rémunérations, charges sociales et pensions', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1132, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '620', '1131', 'Rémunérations et avantages sociaux directs', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1133, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '6200', '1132', 'Administrateurs ou gérants', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1134, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '6201', '1132', 'Personnel de direction', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1135, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '6202', '1132', 'Employés', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1136, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '6203', '1132', 'Ouvriers', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1137, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '6204', '1132', 'Autres membres du personnel', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1138, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '621', '1131', 'Cotisations patronales d''assurances sociales', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1139, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '6210', '1138', 'Sur salaires', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1140, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '6211', '1138', 'Sur appointements et commissions', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1141, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '622', '1131', 'Primes patronales pour assurances extralégales', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1142, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '623', '1131', 'Autres frais de personnel', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1143, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '6230', '1142', 'Assurances du personnel', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1144, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '62300', '1143', 'Assurances loi, responsabilité civile, chemin du travail', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1145, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '62301', '1143', 'Assurance salaire garanti', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1146, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '62302', '1143', 'Assurances individuelles', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1147, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '6231', '1142', 'Charges sociales diverses', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1148, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '62310', '1147', 'Jours fériés payés', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1149, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '62311', '1147', 'Salaire hebdomadaire garanti', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1150, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '62312', '1147', 'Allocations familiales complémentaires', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1151, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '6232', '1142', 'Charges sociales des administrateurs, gérants et commissaires', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1152, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '62320', '1151', 'Allocations familiales complémentaires pour non salariés', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1153, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '62321', '1151', 'Lois sociales pour indépendants', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1154, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '62322', '1151', 'Divers', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1155, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '624', '1131', 'Pensions de retraite et de survie', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1156, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '6240', '1155', 'Administrateurs et gérants', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1157, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '6241', '1155', 'Personnel', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1158, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '625', '1131', 'Provision pour pécule de vacances', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1159, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '6250', '1158', 'Dotations', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1160, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '6251', '1158', 'Utilisations et reprises', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1161, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '63', '1356', 'Amortissements, réductions de valeur et provisions pour risques et charges', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1162, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '630', '1161', 'Dotations aux amortissements et aux réductions de valeur sur immobilisations', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1163, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '6300', '1162', 'Dotations aux amortissements sur frais d''établissement', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1164, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '6301', '1162', 'Dotations aux amortissements sur immobilisations incorporelles', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1165, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '6302', '1162', 'Dotations aux amortissements sur immobilisations corporelles', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1166, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '6308', '1162', 'Dotations aux réductions de valeur sur immobilisations incorporelles', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1167, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '6309', '1162', 'Dotations aux réductions de valeur sur immobilisations corporelles', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1168, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '631', '1161', 'Réductions de valeur sur stocks', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1169, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '6310', '1168', 'Dotations', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1170, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '6311', '1168', 'Reprises', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1171, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '632', '1161', 'Réductions de valeur sur commandes en cours d''exécution', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1172, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '6320', '1171', 'Dotations', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1173, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '6321', '1171', 'Reprises', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1174, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '633', '1161', 'Réductions de valeur sur créances commerciales à plus d''un an', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1175, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '6330', '1174', 'Dotations', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1176, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '6331', '1174', 'Reprises', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1177, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '634', '1161', 'Réductions de valeur sur créances commerciales à un an au plus', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1178, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '6340', '1177', 'Dotations', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1179, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '6341', '1177', 'Reprises', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1180, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '635', '1161', 'Provisions pour pensions et obligations similaires', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1181, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '6350', '1180', 'Dotations', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1182, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '6351', '1180', 'Utilisations et reprises', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1183, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '636', '11613', 'Provisions pour grosses réparations et gros entretiens', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1184, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '6360', '1183', 'Dotations', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1185, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '6361', '1183', 'Utilisations et reprises', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1186, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '637', '1161', 'Provisions pour autres risques et charges', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1187, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '6370', '1186', 'Dotations', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1188, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '6371', '1186', 'Utilisations et reprises', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1189, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '64', '1356', 'Autres charges d''exploitation', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1190, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '640', '1189', 'Charges fiscales d''exploitation', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1191, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '6400', '1190', 'Taxes et impôts directs', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1192, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '64000', '1191', 'Taxes sur autos et camions', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1193, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '6401', '1190', 'Taxes et impôts indirects', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1194, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '64010', '1193', 'Timbres fiscaux pris en charge par la firme', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1195, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '64011', '1193', 'Droits d''enregistrement', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1196, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '64012', '1193', 'T.V.A. non déductible', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1197, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '6402', '1190', 'Impôts provinciaux et communaux', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1198, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '64020', '1197', 'Taxe sur la force motrice', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1199, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '64021', '1197', 'Taxe sur le personnel occupé', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1200, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '6403', '1190', 'Taxes diverses', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1201, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '641', '1189', 'Moins-values sur réalisations courantes d''immobilisations corporelles', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1202, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '642', '1189', 'Moins-values sur réalisations de créances commerciales', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1203, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '643', '1189', 'à 648 Charges d''exploitations diverses', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1204, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '649', '1189', 'Charges d''exploitation portées à l''actif au titre de restructuration', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1205, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '65', '1356', 'Charges financières', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1206, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '650', '1205', 'Charges des dettes', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1207, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '6500', '1206', 'Intérêts, commissions et frais afférents aux dettes', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1208, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '6501', '1206', 'Amortissements des agios et frais d''émission d''emprunts', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1209, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '6502', '1206', 'Autres charges de dettes', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1210, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '6503', '1206', 'Intérêts intercalaires portés à l''actif', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1211, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '651', '1205', 'Réductions de valeur sur actifs circulants', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1212, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '6510', '1211', 'Dotations', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1213, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '6511', '1211', 'Reprises', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1214, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '652', '1205', 'Moins-values sur réalisation d''actifs circulants', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1215, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '653', '1205', 'Charges d''escompte de créances', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1216, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '654', '1205', 'Différences de change', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1217, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '655', '1205', 'Ecarts de conversion des devises', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1218, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '656', '1205', 'Frais de banques, de chèques postaux', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1219, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '657', '1205', 'Commissions sur ouvertures de crédit, cautions et avals', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1220, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '658', '1205', 'Frais de vente des titres', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1221, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '66', '1356', 'Charges exceptionnelles', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1222, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '660', '1221', 'Amortissements et réductions de valeur exceptionnels', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1223, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '6600', '1222', 'Sur frais d''établissement', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1224, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '6601', '1222', 'Sur immobilisations incorporelles', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1225, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '6602', '1222', 'Sur immobilisations corporelles', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1226, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '661', '1221', 'Réductions de valeur sur immobilisations financières', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1227, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '662', '1221', 'Provisions pour risques et charges exceptionnels', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1228, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '663', '1221', 'Moins-values sur réalisation d''actifs immobilisés', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1229, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '6630', '1228', 'Sur immobilisations incorporelles', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1230, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '6631', '1228', 'Sur immobilisations corporelles', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1231, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '6632', '1228', 'Sur immobilisations détenues en location-financement et droits similaires', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1232, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '6633', '1228', 'Sur immobilisations financières', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1233, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '6634', '1228', 'Sur immeubles acquis ou construits en vue de la revente', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1234, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '664', '1221', 'à 668 Autres charges exceptionnelles', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1235, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '664', '1221', 'Pénalités et amendes diverses', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1236, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '665', '1221', 'Différence de charge', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1237, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '669', '1221', 'Charges exceptionnelles transférées à l''actif en frais de restructuration', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1238, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '67', '1356', 'Impôts sur le résultat', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1239, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '670', '1238', 'Impôts belges sur le résultat de l''exercice', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1240, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '6700', '1239', 'Impôts et précomptes dus ou versés', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1241, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '6701', '1239', 'Excédent de versements d''impôts et précomptes porté à l''actif', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1242, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '6702', '1239', 'Charges fiscales estimées', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1243, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '671', '1238', 'Impôts belges sur le résultat d''exercices antérieurs', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1244, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '6710', '1243', 'Suppléments d''impôts dus ou versés', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1245, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '6711', '1243', 'Suppléments d''impôts estimés', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1246, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '6712', '1243', 'Provisions fiscales constituées', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1247, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '672', '1238', 'Impôts étrangers sur le résultat de l''exercice', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1248, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '673', '1238', 'Impôts étrangers sur le résultat d''exercices antérieurs', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1249, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '68', '1356', 'Transferts aux réserves immunisées', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1250, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '69', '1356', 'Affectation des résultats', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1251, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '690', '1250', 'Perte reportée de l''exercice précédent', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1252, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '691', '1250', 'Dotation à la réserve légale', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1253, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '692', '1250', 'Dotation aux autres réserves', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1254, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '693', '1250', 'Bénéfice à reporter', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1255, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '694', '1250', 'Rémunération du capital', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1256, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '695', '1250', 'Administrateurs ou gérants', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1257, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '696', '1250', 'Autres allocataires', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1258, 'PCMN-BASE', 'PROD', 'XXXXXX', '70', '1357', 'Chiffre d''affaires', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1260, 'PCMN-BASE', 'PROD', 'XXXXXX', '700', '1258', 'Ventes de marchandises', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1261, 'PCMN-BASE', 'PROD', 'XXXXXX', '7000', '1260', 'Ventes en Belgique', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1262, 'PCMN-BASE', 'PROD', 'XXXXXX', '7001', '1260', 'Ventes dans les pays membres de la C.E.E.', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1263, 'PCMN-BASE', 'PROD', 'XXXXXX', '7002', '1260', 'Ventes à l''exportation', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1264, 'PCMN-BASE', 'PROD', 'XXXXXX', '701', '1258', 'Ventes de produits finis', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1265, 'PCMN-BASE', 'PROD', 'XXXXXX', '7010', '1264', 'Ventes en Belgique', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1266, 'PCMN-BASE', 'PROD', 'XXXXXX', '7011', '1264', 'Ventes dans les pays membres de la C.E.E.', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1267, 'PCMN-BASE', 'PROD', 'XXXXXX', '7012', '1264', 'Ventes à l''exportation', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1268, 'PCMN-BASE', 'PROD', 'XXXXXX', '702', '1258', 'Ventes de déchets et rebuts', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1269, 'PCMN-BASE', 'PROD', 'XXXXXX', '7020', '1268', 'Ventes en Belgique', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1270, 'PCMN-BASE', 'PROD', 'XXXXXX', '7021', '1268', 'Ventes dans les pays membres de la C.E.E.', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1271, 'PCMN-BASE', 'PROD', 'XXXXXX', '7022', '1268', 'Ventes à l''exportation', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1272, 'PCMN-BASE', 'PROD', 'XXXXXX', '703', '1258', 'Ventes d''emballages récupérables', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1273, 'PCMN-BASE', 'PROD', 'XXXXXX', '704', '1258', 'Facturations des travaux en cours (associations momentanées)', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1274, 'PCMN-BASE', 'PROD', 'XXXXXX', '705', '1258', 'Prestations de services', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1275, 'PCMN-BASE', 'PROD', 'XXXXXX', '7050', '1274', 'Prestations de services en Belgique', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1276, 'PCMN-BASE', 'PROD', 'XXXXXX', '7051', '1274', 'Prestations de services dans les pays membres de la C.E.E.', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1277, 'PCMN-BASE', 'PROD', 'XXXXXX', '7052', '1274', 'Prestations de services en vue de l''exportation', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1278, 'PCMN-BASE', 'PROD', 'XXXXXX', '706', '1258', 'Pénalités et dédits obtenus par l''entreprise', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1279, 'PCMN-BASE', 'PROD', 'XXXXXX', '708', '1258', 'Remises, ristournes et rabais accordés', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1280, 'PCMN-BASE', 'PROD', 'XXXXXX', '7080', '1279', 'Sur ventes de marchandises', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1281, 'PCMN-BASE', 'PROD', 'XXXXXX', '7081', '1279', 'Sur ventes de produits finis', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1282, 'PCMN-BASE', 'PROD', 'XXXXXX', '7082', '1279', 'Sur ventes de déchets et rebuts', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1283, 'PCMN-BASE', 'PROD', 'XXXXXX', '7083', '1279', 'Sur prestations de services', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1284, 'PCMN-BASE', 'PROD', 'XXXXXX', '7084', '1279', 'Mali sur travaux facturés aux associations momentanées', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1285, 'PCMN-BASE', 'PROD', 'XXXXXX', '71', '1357', 'Variation des stocks et des commandes en cours d''exécution', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1286, 'PCMN-BASE', 'PROD', 'XXXXXX', '712', '1285', 'Des en cours de fabrication', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1287, 'PCMN-BASE', 'PROD', 'XXXXXX', '713', '1285', 'Des produits finis', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1288, 'PCMN-BASE', 'PROD', 'XXXXXX', '715', '1285', 'Des immeubles construits destinés à la vente', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1289, 'PCMN-BASE', 'PROD', 'XXXXXX', '717', '1285', 'Des commandes en cours d''exécution', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1290, 'PCMN-BASE', 'PROD', 'XXXXXX', '7170', '1289', 'Commandes en cours - Coût de revient', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1291, 'PCMN-BASE', 'PROD', 'XXXXXX', '71700', '1290', 'Coût des commandes en cours d''exécution', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1292, 'PCMN-BASE', 'PROD', 'XXXXXX', '71701', '1290', 'Coût des travaux en cours des associations momentanées', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1293, 'PCMN-BASE', 'PROD', 'XXXXXX', '7171', '1289', 'Bénéfices portés en compte sur commandes en cours', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1294, 'PCMN-BASE', 'PROD', 'XXXXXX', '71710', '1293', 'Sur commandes en cours d''exécution', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1295, 'PCMN-BASE', 'PROD', 'XXXXXX', '71711', '1293', 'Sur travaux en cours des associations momentanées', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1296, 'PCMN-BASE', 'PROD', 'XXXXXX', '72', '1357', 'Production immobilisée', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1297, 'PCMN-BASE', 'PROD', 'XXXXXX', '720', '1296', 'En frais d''établissement', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1298, 'PCMN-BASE', 'PROD', 'XXXXXX', '721', '1296', 'En immobilisations incorporelles', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1299, 'PCMN-BASE', 'PROD', 'XXXXXX', '722', '1296', 'En immobilisations corporelles', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1300, 'PCMN-BASE', 'PROD', 'XXXXXX', '723', '1296', 'En immobilisations en cours', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1301, 'PCMN-BASE', 'PROD', 'XXXXXX', '74', '1357', 'Autres produits d''exploitation', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1302, 'PCMN-BASE', 'PROD', 'XXXXXX', '740', '1301', 'Subsides d''exploitation et montants compensatoires', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1303, 'PCMN-BASE', 'PROD', 'XXXXXX', '741', '1301', 'Plus-values sur réalisations courantes d''immobilisations corporelles', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1304, 'PCMN-BASE', 'PROD', 'XXXXXX', '742', '1301', 'Plus-values sur réalisations de créances commerciales', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1305, 'PCMN-BASE', 'PROD', 'XXXXXX', '743', '1301', 'à 749 Produits d''exploitation divers', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1306, 'PCMN-BASE', 'PROD', 'XXXXXX', '743', '1301', 'Produits de services exploités dans l''intérêt du personnel', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1307, 'PCMN-BASE', 'PROD', 'XXXXXX', '744', '1301', 'Commissions et courtages', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1308, 'PCMN-BASE', 'PROD', 'XXXXXX', '745', '1301', 'Redevances pour brevets et licences', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1309, 'PCMN-BASE', 'PROD', 'XXXXXX', '746', '1301', 'Prestations de services (transports, études, etc)', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1310, 'PCMN-BASE', 'PROD', 'XXXXXX', '747', '1301', 'Revenus des immeubles affectés aux activités non professionnelles', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1311, 'PCMN-BASE', 'PROD', 'XXXXXX', '748', '1301', 'Locations diverses à caractère professionnel', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1312, 'PCMN-BASE', 'PROD', 'XXXXXX', '749', '1301', 'Produits divers', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1313, 'PCMN-BASE', 'PROD', 'XXXXXX', '7490', '1312', 'Bonis sur reprises d''emballages consignés', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1314, 'PCMN-BASE', 'PROD', 'XXXXXX', '7491', '1312', 'Bonis sur travaux en associations momentanées', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1315, 'PCMN-BASE', 'PROD', 'XXXXXX', '75', '1357', 'Produits financiers', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1316, 'PCMN-BASE', 'PROD', 'XXXXXX', '750', '1315', 'Produits des immobilisations financières', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1317, 'PCMN-BASE', 'PROD', 'XXXXXX', '7500', '1316', 'Revenus des actions', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1318, 'PCMN-BASE', 'PROD', 'XXXXXX', '7501', '1316', 'Revenus des obligations', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1319, 'PCMN-BASE', 'PROD', 'XXXXXX', '7502', '1316', 'Revenus des créances à plus d''un an', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1320, 'PCMN-BASE', 'PROD', 'XXXXXX', '751', '1315', 'Produits des actifs circulants', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1321, 'PCMN-BASE', 'PROD', 'XXXXXX', '752', '1315', 'Plus-values sur réalisations d''actifs circulants', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1322, 'PCMN-BASE', 'PROD', 'XXXXXX', '753', '1315', 'Subsides en capital et en intérêts', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1323, 'PCMN-BASE', 'PROD', 'XXXXXX', '754', '1315', 'Différences de change', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1324, 'PCMN-BASE', 'PROD', 'XXXXXX', '755', '1315', 'Ecarts de conversion des devises', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1325, 'PCMN-BASE', 'PROD', 'XXXXXX', '756', '1315', 'à 759 Produits financiers divers', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1326, 'PCMN-BASE', 'PROD', 'XXXXXX', '756', '1315', 'Produits des autres créances', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1327, 'PCMN-BASE', 'PROD', 'XXXXXX', '757', '1315', 'Escomptes obtenus', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1328, 'PCMN-BASE', 'PROD', 'XXXXXX', '76', '1357', 'Produits exceptionnels', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1329, 'PCMN-BASE', 'PROD', 'XXXXXX', '760', '1328', 'Reprises d''amortissements et de réductions de valeur', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1330, 'PCMN-BASE', 'PROD', 'XXXXXX', '7600', '1329', 'Sur immobilisations incorporelles', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1331, 'PCMN-BASE', 'PROD', 'XXXXXX', '7601', '1329', 'Sur immobilisations corporelles', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1332, 'PCMN-BASE', 'PROD', 'XXXXXX', '761', '1328', 'Reprises de réductions de valeur sur immobilisations financières', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1333, 'PCMN-BASE', 'PROD', 'XXXXXX', '762', '1328', 'Reprises de provisions pour risques et charges exceptionnelles', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1334, 'PCMN-BASE', 'PROD', 'XXXXXX', '763', '1328', 'Plus-values sur réalisation d''actifs immobilisés', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1335, 'PCMN-BASE', 'PROD', 'XXXXXX', '7630', '1334', 'Sur immobilisations incorporelles', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1336, 'PCMN-BASE', 'PROD', 'XXXXXX', '7631', '1334', 'Sur immobilisations corporelles', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1337, 'PCMN-BASE', 'PROD', 'XXXXXX', '7632', '1334', 'Sur immobilisations financières', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1338, 'PCMN-BASE', 'PROD', 'XXXXXX', '764', '1328', 'Autres produits exceptionnels', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1339, 'PCMN-BASE', 'PROD', 'XXXXXX', '77', '1357', 'Régularisations d''impôts et reprises de provisions fiscales', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1340, 'PCMN-BASE', 'PROD', 'XXXXXX', '771', '1339', 'Impôts belges sur le résultat', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1341, 'PCMN-BASE', 'PROD', 'XXXXXX', '7710', '1340', 'Régularisations d''impôts dus ou versés', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1342, 'PCMN-BASE', 'PROD', 'XXXXXX', '7711', '1340', 'Régularisations d''impôts estimés', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1343, 'PCMN-BASE', 'PROD', 'XXXXXX', '7712', '1340', 'Reprises de provisions fiscales', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1344, 'PCMN-BASE', 'PROD', 'XXXXXX', '773', '1339', 'Impôts étrangers sur le résultat', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1345, 'PCMN-BASE', 'PROD', 'XXXXXX', '79', '1357', 'Affectation aux résultats', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1346, 'PCMN-BASE', 'PROD', 'XXXXXX', '790', '1345', 'Bénéfice reporté de l''exercice précédent', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1347, 'PCMN-BASE', 'PROD', 'XXXXXX', '791', '1345', 'Prélèvement sur le capital et les primes d''émission', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1348, 'PCMN-BASE', 'PROD', 'XXXXXX', '792', '1345', 'Prélèvement sur les réserves', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1349, 'PCMN-BASE', 'PROD', 'XXXXXX', '793', '1345', 'Perte à reporter', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1350, 'PCMN-BASE', 'PROD', 'XXXXXX', '794', '1345', 'Intervention d''associés (ou du propriétaire) dans la perte', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1351, 'PCMN-BASE', 'CAPIT', 'XXXXXX', '1', '0', 'Fonds propres, provisions pour risques et charges et dettes à plus d''un an', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1352, 'PCMN-BASE', 'IMMO', 'XXXXXX', '2', '0', 'Frais d''établissement. Actifs immobilisés et créances à plus d''un an', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1353, 'PCMN-BASE', 'STOCK', 'XXXXXX', '3', '0', 'Stock et commandes en cours d''exécution', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1354, 'PCMN-BASE', 'TIERS', 'XXXXXX', '4', '0', 'Créances et dettes à un an au plus', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1355, 'PCMN-BASE', 'FINAN', 'XXXXXX', '5', '0', 'Placement de trésorerie et de valeurs disponibles', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1356, 'PCMN-BASE', 'CHARGE', 'XXXXXX', '6', '0', 'Charges', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (1357, 'PCMN-BASE', 'PROD', 'XXXXXX', '7', '0', 'Produits', 1);

--
-- Descriptif des plans comptables ES PCG08-PYME
--

INSERT INTO llx_accounting_system (rowid, pcg_version, label, active) VALUES (4, 'PCG08-PYME', 'The PYME accountancy spanish plan', 1);

INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4001,'PCG08-PYME','FINANCIACION', 'XXXXXX', '1', '0', 'Financiación básica', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4002,'PCG08-PYME','ACTIVO',  'XXXXXX', '2', '0', 'Activo no corriente', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4003,'PCG08-PYME','EXISTENCIAS', 'XXXXXX', '3', '0', 'Existencias', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4004,'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '4', '0', 'Acreedores y deudores por operaciones comerciales', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4005,'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '5', '0', 'Cuentas financieras', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4006,'PCG08-PYME','COMPRAS_GASTOS','XXXXXX', '6', '0', 'Compras y gastos', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4007,'PCG08-PYME','VENTAS_E_INGRESOS',  'XXXXXX', '7', '0', 'Ventas e ingresos', 1);

INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4008, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '10', '4001', 'CAPITAL', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4009, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '100', '4008', 'Capital social', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4010, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '101', '4008', 'Fondo social', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4011, 'PCG08-PYME','FINANCIACION', 'CAPITAL', '102', '4008', 'Capital', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4012, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '103', '4008', 'Socios por desembolsos no exigidos', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4013, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '1030', '4012', 'Socios por desembolsos no exigidos capital social', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4014, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '1034', '4012', 'Socios por desembolsos no exigidos capital pendiente de inscripción', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4015, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '104', '4008', 'Socios por aportaciones no dineradas pendientes', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4016, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '1040', '4015', 'Socios por aportaciones no dineradas pendientes capital social', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4017, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '1044', '4015', 'Socios por aportaciones no dineradas pendientes capital pendiente de inscripción', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4018, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '108', '4008', 'Acciones o participaciones propias en situaciones especiales', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4019, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '109', '4008', 'Acciones o participaciones propias para reducción de capital', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4020, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '11', '4001', 'Reservas y otros instrumentos de patrimonio', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4021, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '110', '4020', 'Prima de emisión o asunción', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4022, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '111', '4020', 'Otros instrumentos de patrimonio neto', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4023, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '1110', '4022', 'Patrimonio neto por emisión de instrumentos financieros compuestos', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4024, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '1111', '4022', 'Resto de instrumentos de patrimoio neto', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4025, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '112', '4020', 'Reserva legal', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4026, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '113', '4020', 'Reservas voluntarias', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4027, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '114', '4020', 'Reservas especiales', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4028, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '1140', '4027', 'Reservas para acciones o participaciones de la sociedad dominante', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4029, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '1141', '4027', 'Reservas estatutarias', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4030, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '1142', '4027', 'Reservas por capital amortizado', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4031, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '1143', '4027', 'Reservas por fondo de comercio', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4032, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '1144', '4028', 'Reservas por acciones propias aceptadas en garantía', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4033, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '115', '4020', 'Reservas por pérdidas y ganancias actuariales y otros ajustes', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4034, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '118', '4020', 'Aportaciones de socios o propietarios', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4035, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '119', '4020', 'Diferencias por ajuste del capital a euros', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4036, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '12', '4001', 'Resultados pendientes de aplicación', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4037, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '120', '4036', 'Remanente', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4038, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '121', '4036', 'Resultados negativos de ejercicios anteriores', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4039, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '129', '4036', 'Resultado del ejercicio', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4040, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '13', '4001', 'Subvenciones, donaciones y ajustes por cambio de valor', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4041, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '130', '4040', 'Subvenciones oficiales de capital', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4042, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '131', '4040', 'Donaciones y legados de capital', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4043, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '132', '4040', 'Otras subvenciones, donaciones y legados', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4044, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '133', '4040', 'Ajustes por valoración en activos financieros disponibles para la venta', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4045, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '134', '4040', 'Operaciones de cobertura', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4046, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '1340', '4045', 'Cobertura de flujos de efectivo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4047, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '1341', '4045', 'Cobertura de una inversión neta en un negocio extranjero', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4048, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '135', '4040', 'Diferencias de conversión', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4049, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '136', '4040', 'Ajustes por valoración en activos no corrientes y grupos enajenables de elementos mantenidos para la venta', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4050, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '137', '4040', 'Ingresos fiscales a distribuir en varios ejercicios', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4051, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '1370', '4050', 'Ingresos fiscales por diferencias permanentes a distribuir en varios ejercicios', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4052, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '1371', '4050', 'Ingresos fiscales por deducciones y bonificaciones a distribuir en varios ejercicios', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4053, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '14', '4001', 'Provisiones', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4054, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '141', '4053', 'Provisión para impuestos', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4055, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '142', '4053', 'Provisión para otras responsabilidades', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4056, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '143', '4053', 'Provisión por desmantelamiento, retiro o rehabilitación del inmovilizado', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4057, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '145', '4053', 'Provisión para actuaciones medioambientales', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4058, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '15', '4001', 'Deudas a largo plazo con características especiales', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4059, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '150', '4058', 'Acciones o participaciones a largo plazo consideradas como pasivos financieros', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4060, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '153', '4058', 'Desembolsos no exigidos por acciones o participaciones consideradas como pasivos financieros', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4061, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '1533', '4060', 'Desembolsos no exigidos empresas del grupo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4062, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '1534', '4060', 'Desembolsos no exigidos empresas asociadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4063, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '1535', '4060', 'Desembolsos no exigidos otras partes vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4064, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '1536', '4060', 'Otros desembolsos no exigidos', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4065, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '154', '4058', 'Aportaciones no dinerarias pendientes por acciones o participaciones consideradas como pasivos financieros', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4066, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '1543', '4065', 'Aportaciones no dinerarias pendientes empresas del grupo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4067, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '1544', '4065', 'Aportaciones no dinerarias pendientes empresas asociadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4068, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '1545', '4065', 'Aportaciones no dinerarias pendientes otras partes vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4069, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '1546', '4065', 'Otras aportaciones no dinerarias pendientes', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4070, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '16', '4001', 'Deudas a largo plazo con partes vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4071, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '160', '4070', 'Deudas a largo plazo con entidades de crédito vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4072, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '1603', '4071', 'Deudas a largo plazo con entidades de crédito empresas del grupo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4073, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '1604', '4071', 'Deudas a largo plazo con entidades de crédito empresas asociadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4074, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '1605', '4071', 'Deudas a largo plazo con otras entidades de crédito vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4075, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '161', '4070', 'Proveedores de inmovilizado a largo plazo partes vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4076, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '1613', '4075', 'Proveedores de inmovilizado a largo plazo empresas del grupo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4077, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '1614', '4075', 'Proveedores de inmovilizado a largo plazo empresas asociadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4078, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '1615', '4075', 'Proveedores de inmovilizado a largo plazo otras partes vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4079, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '162', '4070', 'Acreedores por arrendamiento financiero a largo plazo partes vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4080, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '1623', '4079', 'Acreedores por arrendamiento financiero a largo plazo empresas del grupo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4081, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '1624', '4080', 'Acreedores por arrendamiento financiero a largo plazo empresas asociadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4082, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '1625', '4080', 'Acreedores por arrendamiento financiero a largo plazo otras partes vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4083, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '163', '4070', 'Otras deudas a largo plazo con partes vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4084, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '1633', '4083', 'Otras deudas a largo plazo empresas del grupo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4085, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '1634', '4083', 'Otras deudas a largo plazo empresas asociadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4086, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '1635', '4083', 'Otras deudas a largo plazo otras partes vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4087, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '17', '4001', 'Deudas a largo plazo por préstamos recibidos empresitos y otros conceptos', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4088, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '170', '4087', 'Deudas a largo plazo con entidades de crédito', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4089, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '171', '4087', 'Deudas a largo plazo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4090, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '172', '4087', 'Deudas a largo plazo transformables en suvbenciones donaciones y legados', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4091, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '173', '4087', 'Proveedores de inmovilizado a largo plazo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4092, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '174', '4087', 'Acreedores por arrendamiento financiero a largo plazo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4093, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '175', '4087', 'Efectos a pagar a largo plazo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4094, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '176', '4087', 'Pasivos por derivados financieros a largo plazo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4095, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '177', '4087', 'Obligaciones y bonos', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4096, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '179', '4087', 'Deudas representadas en otros valores negociables', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4097, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '18', '4001', 'Pasivos por fianzas garantias y otros conceptos a largo plazo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4098, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '180', '4097', 'Fianzas recibidas a largo plazo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4099, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '181', '4097', 'Anticipos recibidos por ventas o prestaciones de servicios a largo plazo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4100, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '185', '4097', 'Depositos recibidos a largo plazo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4101, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '19', '4001', 'Situaciones transitorias de financiación', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4102, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '190', '4101', 'Acciones o participaciones emitidas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4103, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '192', '4101', 'Suscriptores de acciones', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4104, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '194', '4101', 'Capital emitido pendiente de inscripción', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4105, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '195', '4101', 'Acciones o participaciones emitidas consideradas como pasivos financieros', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4106, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '197', '4101', 'Suscriptores de acciones consideradas como pasivos financieros', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4107, 'PCG08-PYME','FINANCIACION', 'XXXXXX', '199', '4101', 'Acciones o participaciones emitidas consideradas como pasivos financieros pendientes de inscripción', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4108, 'PCG08-PYME','ACTIVO', 'XXXXXX', '20', '4002', 'Inmovilizaciones intangibles', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4109, 'PCG08-PYME','ACTIVO', 'XXXXXX', '200', '4108', 'Investigación', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4110, 'PCG08-PYME','ACTIVO', 'XXXXXX', '201', '4108', 'Desarrollo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4111, 'PCG08-PYME','ACTIVO', 'XXXXXX', '202', '4108', 'Concesiones administrativas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4112, 'PCG08-PYME','ACTIVO', 'XXXXXX', '203', '4108', 'Propiedad industrial', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4113, 'PCG08-PYME','ACTIVO', 'XXXXXX', '205', '4108', 'Derechos de transpaso', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4114, 'PCG08-PYME','ACTIVO', 'XXXXXX', '206', '4108', 'Aplicaciones informáticas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4115, 'PCG08-PYME','ACTIVO', 'XXXXXX', '209', '4108', 'Anticipos para inmovilizaciones intangibles', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4116, 'PCG08-PYME','ACTIVO', 'XXXXXX', '21', '4002', 'Inmovilizaciones materiales', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4117, 'PCG08-PYME','ACTIVO', 'XXXXXX', '210', '4116', 'Terrenos y bienes naturales', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4118, 'PCG08-PYME','ACTIVO', 'XXXXXX', '211', '4116', 'Construcciones', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4119, 'PCG08-PYME','ACTIVO', 'XXXXXX', '212', '4116', 'Instalaciones técnicas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4120, 'PCG08-PYME','ACTIVO', 'XXXXXX', '213', '4116', 'Maquinaria', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4121, 'PCG08-PYME','ACTIVO', 'XXXXXX', '214', '4116', 'Utillaje', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4122, 'PCG08-PYME','ACTIVO', 'XXXXXX', '215', '4116', 'Otras instalaciones', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4123, 'PCG08-PYME','ACTIVO', 'XXXXXX', '216', '4116', 'Mobiliario', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4124, 'PCG08-PYME','ACTIVO', 'XXXXXX', '217', '4116', 'Equipos para procesos de información', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4125, 'PCG08-PYME','ACTIVO', 'XXXXXX', '218', '4116', 'Elementos de transporte', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4126, 'PCG08-PYME','ACTIVO', 'XXXXXX', '219', '4116', 'Otro inmovilizado material', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4127, 'PCG08-PYME','ACTIVO', 'XXXXXX', '22', '4002', 'Inversiones inmobiliarias', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4128, 'PCG08-PYME','ACTIVO', 'XXXXXX', '220', '4127', 'Inversiones en terreons y bienes naturales', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4129, 'PCG08-PYME','ACTIVO', 'XXXXXX', '221', '4127', 'Inversiones en construcciones', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4130, 'PCG08-PYME','ACTIVO', 'XXXXXX', '23', '4002', 'Inmovilizaciones materiales en curso', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4131, 'PCG08-PYME','ACTIVO', 'XXXXXX', '230', '4130', 'Adaptación de terrenos y bienes naturales', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4132, 'PCG08-PYME','ACTIVO', 'XXXXXX', '231', '4130', 'Construcciones en curso', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4133, 'PCG08-PYME','ACTIVO', 'XXXXXX', '232', '4130', 'Instalaciones técnicas en montaje', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4134, 'PCG08-PYME','ACTIVO', 'XXXXXX', '233', '4130', 'Maquinaria en montaje', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4135, 'PCG08-PYME','ACTIVO', 'XXXXXX', '237', '4130', 'Equipos para procesos de información en montaje', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4136, 'PCG08-PYME','ACTIVO', 'XXXXXX', '239', '4130', 'Anticipos para inmovilizaciones materiales', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4137, 'PCG08-PYME','ACTIVO', 'XXXXXX', '24', '4002', 'Inversiones financieras a largo plazo en partes vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4138, 'PCG08-PYME','ACTIVO', 'XXXXXX', '240', '4137', 'Participaciones a largo plazo en partes vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4139, 'PCG08-PYME','ACTIVO', 'XXXXXX', '2403', '4138', 'Participaciones a largo plazo en empresas del grupo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4140, 'PCG08-PYME','ACTIVO', 'XXXXXX', '2404', '4138', 'Participaciones a largo plazo en empresas asociadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4141, 'PCG08-PYME','ACTIVO', 'XXXXXX', '2405', '4138', 'Participaciones a largo plazo en otras partes vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4142, 'PCG08-PYME','ACTIVO', 'XXXXXX', '241', '4137', 'Valores representativos de deuda a largo plazo de partes vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4143, 'PCG08-PYME','ACTIVO', 'XXXXXX', '2413', '4142', 'Valores representativos de deuda a largo plazo de empresas del grupo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4144, 'PCG08-PYME','ACTIVO', 'XXXXXX', '2414', '4142', 'Valores representativos de deuda a largo plazo de empresas asociadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4145, 'PCG08-PYME','ACTIVO', 'XXXXXX', '2415', '4142', 'Valores representativos de deuda a largo plazo de otras partes vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4146, 'PCG08-PYME','ACTIVO', 'XXXXXX', '242', '4137', 'Créditos a largo plazo a partes vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4147, 'PCG08-PYME','ACTIVO', 'XXXXXX', '2423', '4146', 'Créditos a largo plazo a empresas del grupo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4148, 'PCG08-PYME','ACTIVO', 'XXXXXX', '2424', '4146', 'Créditos a largo plazo a empresas asociadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4149, 'PCG08-PYME','ACTIVO', 'XXXXXX', '2425', '4146', 'Créditos a largo plazo a otras partes vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4150, 'PCG08-PYME','ACTIVO', 'XXXXXX', '249', '4137', 'Desembolsos pendientes sobre participaciones a largo plazo en partes vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4151, 'PCG08-PYME','ACTIVO', 'XXXXXX', '2493', '4150', 'Desembolsos pendientes sobre participaciones a largo plazo en empresas del grupo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4152, 'PCG08-PYME','ACTIVO', 'XXXXXX', '2494', '4150', 'Desembolsos pendientes sobre participaciones a largo plazo en empresas asociadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4153, 'PCG08-PYME','ACTIVO', 'XXXXXX', '2495', '4150', 'Desembolsos pendientes sobre participaciones a largo plazo en otras partes vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4154, 'PCG08-PYME','ACTIVO', 'XXXXXX', '25', '4002', 'Otras inversiones financieras a largo plazo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4155, 'PCG08-PYME','ACTIVO', 'XXXXXX', '250', '4154', 'Inversiones financieras a largo plazo en instrumentos de patrimonio', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4156, 'PCG08-PYME','ACTIVO', 'XXXXXX', '251', '4154', 'Valores representativos de deuda a largo plazo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4157, 'PCG08-PYME','ACTIVO', 'XXXXXX', '252', '4154', 'Créditos a largo plazo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4158, 'PCG08-PYME','ACTIVO', 'XXXXXX', '253', '4154', 'Créditos a largo plazo por enajenación de inmovilizado', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4159, 'PCG08-PYME','ACTIVO', 'XXXXXX', '254', '4154', 'Créditos a largo plazo al personal', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4160, 'PCG08-PYME','ACTIVO', 'XXXXXX', '255', '4154', 'Activos por derivados financieros a largo plazo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4161, 'PCG08-PYME','ACTIVO', 'XXXXXX', '258', '4154', 'Imposiciones a largo plazo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4162, 'PCG08-PYME','ACTIVO', 'XXXXXX', '259', '4154', 'Desembolsos pendientes sobre participaciones en el patrimonio neto a largo plazo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4163, 'PCG08-PYME','ACTIVO', 'XXXXXX', '26', '4002', 'Fianzas y depósitos constituidos a largo plazo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4164, 'PCG08-PYME','ACTIVO', 'XXXXXX', '260', '4163', 'Fianzas constituidas a largo plazo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4165, 'PCG08-PYME','ACTIVO', 'XXXXXX', '261', '4163', 'Depósitos constituidos a largo plazo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4166, 'PCG08-PYME','ACTIVO', 'XXXXXX', '28', '4002', 'Amortización acumulada del inmovilizado', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4167, 'PCG08-PYME','ACTIVO', 'XXXXXX', '280', '4166', 'Amortización acumulado del inmovilizado intangible', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4168, 'PCG08-PYME','ACTIVO', 'XXXXXX', '2800', '4167', 'Amortización acumulada de investigación', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4169, 'PCG08-PYME','ACTIVO', 'XXXXXX', '2801', '4167', 'Amortización acumulada de desarrollo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4170, 'PCG08-PYME','ACTIVO', 'XXXXXX', '2802', '4167', 'Amortización acumulada de concesiones administrativas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4171, 'PCG08-PYME','ACTIVO', 'XXXXXX', '2803', '4167', 'Amortización acumulada de propiedad industrial', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4172, 'PCG08-PYME','ACTIVO', 'XXXXXX', '2805', '4167', 'Amortización acumulada de derechos de transpaso', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4173, 'PCG08-PYME','ACTIVO', 'XXXXXX', '2806', '4167', 'Amortización acumulada de aplicaciones informáticas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4174, 'PCG08-PYME','ACTIVO', 'XXXXXX', '281', '4166', 'Amortización acumulado del inmovilizado material', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4175, 'PCG08-PYME','ACTIVO', 'XXXXXX', '2811', '4174', 'Amortización acumulada de construcciones', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4176, 'PCG08-PYME','ACTIVO', 'XXXXXX', '2812', '4174', 'Amortización acumulada de instalaciones técnicas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4177, 'PCG08-PYME','ACTIVO', 'XXXXXX', '2813', '4174', 'Amortización acumulada de maquinaria', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4178, 'PCG08-PYME','ACTIVO', 'XXXXXX', '2814', '4174', 'Amortización acumulada de utillaje', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4179, 'PCG08-PYME','ACTIVO', 'XXXXXX', '2815', '4174', 'Amortización acumulada de otras instalaciones', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4180, 'PCG08-PYME','ACTIVO', 'XXXXXX', '2816', '4174', 'Amortización acumulada de mobiliario', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4181, 'PCG08-PYME','ACTIVO', 'XXXXXX', '2817', '4174', 'Amortización acumulada de equipos para proceso de información', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4182, 'PCG08-PYME','ACTIVO', 'XXXXXX', '2818', '4174', 'Amortización acumulada de elementos de transporte', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4183, 'PCG08-PYME','ACTIVO', 'XXXXXX', '2819', '4175', 'Amortización acumulada de otro inmovilizado material', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4184, 'PCG08-PYME','ACTIVO', 'XXXXXX', '282', '4166', 'Amortización acumulada de las inversiones inmobiliarias', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4185, 'PCG08-PYME','ACTIVO', 'XXXXXX', '29', '4002', 'Deterioro de valor de activos no corrientes', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4186, 'PCG08-PYME','ACTIVO', 'XXXXXX', '290', '4185', 'Deterioro de valor del inmovilizado intangible', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4187, 'PCG08-PYME','ACTIVO', 'XXXXXX', '2900', '4186', 'Deterioro de valor de investigación', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4188, 'PCG08-PYME','ACTIVO', 'XXXXXX', '2901', '4186', 'Deterioro de valor de desarrollo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4189, 'PCG08-PYME','ACTIVO', 'XXXXXX', '2902', '4186', 'Deterioro de valor de concesiones administrativas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4190, 'PCG08-PYME','ACTIVO', 'XXXXXX', '2903', '4186', 'Deterioro de valor de propiedad industrial', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4191, 'PCG08-PYME','ACTIVO', 'XXXXXX', '2905', '4186', 'Deterioro de valor de derechos de transpaso', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4192, 'PCG08-PYME','ACTIVO', 'XXXXXX', '2906', '4186', 'Deterioro de valor de aplicaciones informáticas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4193, 'PCG08-PYME','ACTIVO', 'XXXXXX', '291', '4185', 'Deterioro de valor del inmovilizado material', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4194, 'PCG08-PYME','ACTIVO', 'XXXXXX', '2910', '4193', 'Deterioro de valor de terrenos y bienes naturales', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4195, 'PCG08-PYME','ACTIVO', 'XXXXXX', '2911', '4193', 'Deterioro de valor de construcciones', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4196, 'PCG08-PYME','ACTIVO', 'XXXXXX', '2912', '4193', 'Deterioro de valor de instalaciones técnicas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4197, 'PCG08-PYME','ACTIVO', 'XXXXXX', '2913', '4193', 'Deterioro de valor de maquinaria', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4198, 'PCG08-PYME','ACTIVO', 'XXXXXX', '2914', '4193', 'Deterioro de valor de utillajes', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4199, 'PCG08-PYME','ACTIVO', 'XXXXXX', '2915', '4194', 'Deterioro de valor de otras instalaciones', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4200, 'PCG08-PYME','ACTIVO', 'XXXXXX', '2916', '4194', 'Deterioro de valor de mobiliario', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4201, 'PCG08-PYME','ACTIVO', 'XXXXXX', '2917', '4194', 'Deterioro de valor de equipos para proceso de información', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4202, 'PCG08-PYME','ACTIVO', 'XXXXXX', '2918', '4194', 'Deterioro de valor de elementos de transporte', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4203, 'PCG08-PYME','ACTIVO', 'XXXXXX', '2919', '4194', 'Deterioro de valor de otro inmovilizado material', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4204, 'PCG08-PYME','ACTIVO', 'XXXXXX', '292', '4185', 'Deterioro de valor de las inversiones inmobiliarias', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4205, 'PCG08-PYME','ACTIVO', 'XXXXXX', '2920', '4204', 'Deterioro de valor de terrenos y bienes naturales', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4206, 'PCG08-PYME','ACTIVO', 'XXXXXX', '2921', '4204', 'Deterioro de valor de construcciones', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4207, 'PCG08-PYME','ACTIVO', 'XXXXXX', '293', '4185', 'Deterioro de valor de participaciones a largo plazo en partes vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4208, 'PCG08-PYME','ACTIVO', 'XXXXXX', '2933', '4207', 'Deterioro de valor de participaciones a largo plazo en empresas del grupo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4209, 'PCG08-PYME','ACTIVO', 'XXXXXX', '2934', '4207', 'Deterioro de valor de sobre participaciones a largo plazo en empresas asociadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4210, 'PCG08-PYME','ACTIVO', 'XXXXXX', '2935', '4207', 'Deterioro de valor de sobre participaciones a largo plazo en otras partes vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4211, 'PCG08-PYME','ACTIVO', 'XXXXXX', '294', '4185', 'Deterioro de valor de valores representativos de deuda a largo plazo en partes vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4212, 'PCG08-PYME','ACTIVO', 'XXXXXX', '2943', '4211', 'Deterioro de valor de valores representativos de deuda a largo plazo en empresas del grupo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4213, 'PCG08-PYME','ACTIVO', 'XXXXXX', '2944', '4211', 'Deterioro de valor de valores representativos de deuda a largo plazo en empresas asociadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4214, 'PCG08-PYME','ACTIVO', 'XXXXXX', '2945', '4211', 'Deterioro de valor de valores representativos de deuda a largo plazo en otras partes vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4215, 'PCG08-PYME','ACTIVO', 'XXXXXX', '295', '4185', 'Deterioro de valor de créditos a largo plazo a partes vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4216, 'PCG08-PYME','ACTIVO', 'XXXXXX', '2953', '4215', 'Deterioro de valor de créditos a largo plazo a empresas del grupo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4217, 'PCG08-PYME','ACTIVO', 'XXXXXX', '2954', '4215', 'Deterioro de valor de créditos a largo plazo a empresas asociadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4218, 'PCG08-PYME','ACTIVO', 'XXXXXX', '2955', '4215', 'Deterioro de valor de créditos a largo plazo a otras partes vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4219, 'PCG08-PYME','ACTIVO', 'XXXXXX', '296', '4185', 'Deterioro de valor de participaciones en el patrimonio netoa largo plazo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4220, 'PCG08-PYME','ACTIVO', 'XXXXXX', '297', '4185', 'Deterioro de valor de valores representativos de deuda a largo plazo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4221, 'PCG08-PYME','ACTIVO', 'XXXXXX', '298', '4185', 'Deterioro de valor de créditos a largo plazo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4222, 'PCG08-PYME','EXISTENCIAS', 'XXXXXX', '30', '4003', 'Comerciales', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4223, 'PCG08-PYME','EXISTENCIAS', 'XXXXXX', '300', '4222', 'Mercaderías A', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4224, 'PCG08-PYME','EXISTENCIAS', 'XXXXXX', '301', '4222', 'Mercaderías B', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4225, 'PCG08-PYME','EXISTENCIAS', 'XXXXXX', '31', '4003', 'Materias primas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4226, 'PCG08-PYME','EXISTENCIAS', 'XXXXXX', '310', '4225', 'Materias primas A', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4227, 'PCG08-PYME','EXISTENCIAS', 'XXXXXX', '311', '4225', 'Materias primas B', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4228, 'PCG08-PYME','EXISTENCIAS', 'XXXXXX', '32', '4003', 'Otros aprovisionamientos', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4229, 'PCG08-PYME','EXISTENCIAS', 'XXXXXX', '320', '4228', 'Elementos y conjuntos incorporables', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4230, 'PCG08-PYME','EXISTENCIAS', 'XXXXXX', '321', '4228', 'Combustibles', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4231, 'PCG08-PYME','EXISTENCIAS', 'XXXXXX', '322', '4228', 'Repuestos', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4232, 'PCG08-PYME','EXISTENCIAS', 'XXXXXX', '325', '4228', 'Materiales diversos', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4233, 'PCG08-PYME','EXISTENCIAS', 'XXXXXX', '326', '4228', 'Embalajes', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4234, 'PCG08-PYME','EXISTENCIAS', 'XXXXXX', '327', '4228', 'Envases', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4235, 'PCG08-PYME','EXISTENCIAS', 'XXXXXX', '328', '4229', 'Material de oficina', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4236, 'PCG08-PYME','EXISTENCIAS', 'XXXXXX', '33', '4003', 'Productos en curso', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4237, 'PCG08-PYME','EXISTENCIAS', 'XXXXXX', '330', '4236', 'Productos en curos A', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4238, 'PCG08-PYME','EXISTENCIAS', 'XXXXXX', '331', '4236', 'Productos en curso B', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4239, 'PCG08-PYME','EXISTENCIAS', 'XXXXXX', '34', '4003', 'Productos semiterminados', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4240, 'PCG08-PYME','EXISTENCIAS', 'XXXXXX', '340', '4239', 'Productos semiterminados A', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4241, 'PCG08-PYME','EXISTENCIAS', 'XXXXXX', '341', '4239', 'Productos semiterminados B', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4242, 'PCG08-PYME','EXISTENCIAS', 'XXXXXX', '35', '4003', 'Productos terminados', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4243, 'PCG08-PYME','EXISTENCIAS', 'XXXXXX', '350', '4242', 'Productos terminados A', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4244, 'PCG08-PYME','EXISTENCIAS', 'XXXXXX', '351', '4242', 'Productos terminados B', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4245, 'PCG08-PYME','EXISTENCIAS', 'XXXXXX', '36', '4003', 'Subproductos, residuos y materiales recuperados', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4246, 'PCG08-PYME','EXISTENCIAS', 'XXXXXX', '360', '4245', 'Subproductos A', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4247, 'PCG08-PYME','EXISTENCIAS', 'XXXXXX', '361', '4245', 'Subproductos B', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4248, 'PCG08-PYME','EXISTENCIAS', 'XXXXXX', '365', '4245', 'Residuos A', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4249, 'PCG08-PYME','EXISTENCIAS', 'XXXXXX', '366', '4245', 'Residuos B', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4250, 'PCG08-PYME','EXISTENCIAS', 'XXXXXX', '368', '4245', 'Materiales recuperados A', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4251, 'PCG08-PYME','EXISTENCIAS', 'XXXXXX', '369', '4245', 'Materiales recuperados B', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4252, 'PCG08-PYME','EXISTENCIAS', 'XXXXXX', '39', '4003', 'Deterioro de valor de las existencias', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4253, 'PCG08-PYME','EXISTENCIAS', 'XXXXXX', '390', '4252', 'Deterioro de valor de las mercaderías', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4254, 'PCG08-PYME','EXISTENCIAS', 'XXXXXX', '391', '4252', 'Deterioro de valor de las materias primas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4255, 'PCG08-PYME','EXISTENCIAS', 'XXXXXX', '392', '4252', 'Deterioro de valor de otros aprovisionamientos', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4256, 'PCG08-PYME','EXISTENCIAS', 'XXXXXX', '393', '4252', 'Deterioro de valor de los productos en curso', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4257, 'PCG08-PYME','EXISTENCIAS', 'XXXXXX', '394', '4252', 'Deterioro de valor de los productos semiterminados', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4258, 'PCG08-PYME','EXISTENCIAS', 'XXXXXX', '395', '4252', 'Deterioro de valor de los productos terminados', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4259, 'PCG08-PYME','EXISTENCIAS', 'XXXXXX', '396', '4252', 'Deterioro de valor de los subproductos, residuos y materiales recuperados', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4260, 'PCG08-PYME','ACREEDORES_DEUDORES', 'PROVEEDORES', '40', '4004', 'Proveedores', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4261, 'PCG08-PYME','ACREEDORES_DEUDORES', 'PROVEEDORES', '400', '4260', 'Proveedores', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4262, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '4000', '4261', 'Proveedores euros', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4263, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '4004', '4261', 'Proveedores moneda extranjera', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4264, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '4009', '4261', 'Proveedores facturas pendientes de recibir o formalizar', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4265, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '401', '4260', 'Proveedores efectos comerciales a pagar', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4266, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '403', '4260', 'Proveedores empresas del grupo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4267, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '4030', '4266', 'Proveedores empresas del grupo euros', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4268, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '4031', '4266', 'Efectos comerciales a pagar empresas del grupo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4269, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '4034', '4266', 'Proveedores empresas del grupo moneda extranjera', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4270, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '4036', '4266', 'Envases y embalajes a devolver a proveedores empresas del grupo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4271, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '4039', '4266', 'Proveedores empresas del grupo facturas pendientes de recibir o de formalizar', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4272, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '404', '4260', 'Proveedores empresas asociadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4273, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '405', '4260', 'Proveedores otras partes vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4274, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '406', '4260', 'Envases y embalajes a devolver a proveedores', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4275, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '407', '4260', 'Anticipos a proveedores', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4276, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '41', '4004', 'Acreedores varios', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4277, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '410', '4276', 'Acreedores por prestaciones de servicios', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4278, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '4100', '4277', 'Acreedores por prestaciones de servicios euros', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4279, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '4104', '4277', 'Acreedores por prestaciones de servicios moneda extranjera', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4280, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '4109', '4277', 'Acreedores por prestaciones de servicios facturas pendientes de recibir o formalizar', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4281, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '411', '4276', 'Acreedores efectos comerciales a pagar', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4282, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '419', '4276', 'Acreedores por operaciones en común', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4283, 'PCG08-PYME','ACREEDORES_DEUDORES', 'CLIENTES', '43', '4004', 'Clientes', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4284, 'PCG08-PYME','ACREEDORES_DEUDORES', 'CLIENTES', '430', '4283', 'Clientes', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4285, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '4300', '4284', 'Clientes euros', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4286, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '4304', '4284', 'Clientes moneda extranjera', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4287, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '4309', '4284', 'Clientes facturas pendientes de formalizar', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4288, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '431', '4283', 'Clientes efectos comerciales a cobrar', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4289, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '4310', '4288', 'Efectos comerciales en cartera', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4290, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '4311', '4288', 'Efectos comerciales descontados', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4291, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '4312', '4288', 'Efectos comerciales en gestión de cobro', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4292, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '4315', '4288', 'Efectos comerciales impagados', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4293, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '432', '4283', 'Clientes operaciones de factoring', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4294, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '433', '4283', 'Clientes empresas del grupo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4295, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '4330', '4294', 'Clientes empresas del grupo euros', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4296, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '4331', '4294', 'Efectos comerciales a cobrar empresas del grupo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4297, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '4332', '4294', 'Clientes empresas del grupo operaciones de factoring', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4298, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '4334', '4294', 'Clientes empresas del grupo moneda extranjera', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4299, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '4336', '4294', 'Clientes empresas del grupo dudoso cobro', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4300, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '4337', '4294', 'Envases y embalajes a devolver a clientes empresas del grupo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4301, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '4339', '4294', 'Clientes empresas del grupo facturas pendientes de formalizar', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4302, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '434', '4283', 'Clientes empresas asociadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4303, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '435', '4283', 'Clientes otras partes vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4304, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '436', '4283', 'Clientes de dudoso cobro', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4305, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '437', '4283', 'Envases y embalajes a devolver por clientes', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4306, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '438', '4283', 'Anticipos de clientes', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4307, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '44', '4004', 'Deudores varios', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4308, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '440', '4307', 'Deudores', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4309, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '4400', '4308', 'Deudores euros', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4310, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '4404', '4308', 'Deudores moneda extranjera', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4311, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '4409', '4308', 'Deudores facturas pendientes de formalizar', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4312, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '441', '4307', 'Deudores efectos comerciales a cobrar', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4313, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '4410', '4312', 'Deudores efectos comerciales en cartera', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4314, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '4411', '4312', 'Deudores efectos comerciales descontados', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4315, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '4412', '4312', 'Deudores efectos comerciales en gestión de cobro', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4316, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '4415', '4312', 'Deudores efectos comerciales impagados', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4317, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '446', '4307', 'Deudores de dusoso cobro', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4318, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '449', '4307', 'Deudores por operaciones en común', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4319, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '46', '4004', 'Personal', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4320, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '460', '4319', 'Anticipos de renumeraciones', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4321, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '465', '4319', 'Renumeraciones pendientes de pago', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4322, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '47', '4004', 'Administraciones Públicas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4323, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '470', '4322', 'Hacienda Pública deudora por diversos conceptos', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4324, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '4700', '4323', 'Hacienda Pública deudora por IVA', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4325, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '4708', '4323', 'Hacienda Pública deudora por subvenciones concedidas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4326, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '4709', '4323', 'Hacienda Pública deudora por devolución de impuestos', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4327, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '471', '4322', 'Organismos de la Seguridad Social deudores', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4328, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '472', '4322', 'Hacienda Pública IVA soportado', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4329, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '473', '4322', 'Hacienda Pública retenciones y pagos a cuenta', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4330, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '474', '4322', 'Activos por impuesto diferido', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4331, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '4740', '4330', 'Activos por diferencias temporarias deducibles', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4332, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '4742', '4330', 'Derechos por deducciones y bonificaciones pendientes de aplicar', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4333, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '4745', '4330', 'Crédito por pérdidasa compensar del ejercicio', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4334, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '475', '4322', 'Hacienda Pública acreedora por conceptos fiscales', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4335, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '4750', '4334', 'Hacienda Pública acreedora por IVA', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4336, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '4751', '4334', 'Hacienda Pública acreedora por retenciones practicadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4337, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '4752', '4334', 'Hacienda Pública acreedora por impuesto sobre sociedades', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4338, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '4758', '4334', 'Hacienda Pública acreedora por subvenciones a integrar', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4339, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '476', '4322', 'Organismos de la Seguridad Social acreedores', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4340, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '477', '4322', 'Hacienda Pública IVA repercutido', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4341, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '479', '4322', 'Pasivos por diferencias temporarias imponibles', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4342, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '48', '4004', 'Ajustes por periodificación', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4343, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '480', '4342', 'Gastos anticipados', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4344, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '485', '4342', 'Ingresos anticipados', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4345, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '49', '4004', 'Deterioro de valor de créditos comerciales y provisiones a corto plazo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4346, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '490', '4345', 'Deterioro de valor de créditos por operaciones comerciales', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4347, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '493', '4345', 'Deterioro de valor de créditos por operaciones comerciales con partes vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4348, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '4933', '4347', 'Deterioro de valor de créditos por operaciones comerciales con empresas del grupo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4349, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '4934', '4347', 'Deterioro de valor de créditos por operaciones comerciales con empresas asociadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4350, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '4935', '4347', 'Deterioro de valor de créditos por operaciones comerciales con otras partes vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4351, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '499', '4345', 'Provisiones por operaciones comerciales', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4352, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '4994', '4351', 'Provisión para contratos anerosos', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4353, 'PCG08-PYME','ACREEDORES_DEUDORES', 'XXXXXX', '4999', '4351', 'Provisión para otras operaciones comerciales', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4354, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '50', '4005', 'Emprésitos deudas con características especiales y otras emisiones análogas a corto plazo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4355, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '500', '4354', 'Obligaciones y bonos a corto plazo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4356, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '502', '4354', 'Acciones o participaciones a corto plazo consideradas como pasivos financieros', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4357, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '505', '4354', 'Deudas representadas en otros valores negociables a corto plazo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4358, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '506', '4354', 'Intereses a corto plazo de emprésitos y otras emisiones analógicas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4359, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '507', '4354', 'Dividendos de acciones o participaciones consideradas como pasivos financieros', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4360, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '509', '4354', 'Valores negociables amortizados', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4361, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '5090', '4360', 'Obligaciones y bonos amortizados', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4362, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '5095', '4360', 'Otros valores negociables amortizados', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4363, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '51', '4005', 'Deudas a corto plazo con partes vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4364, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '510', '4363', 'Deudas a corto plazo con entidades de crédito vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4365, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '5103', '4364', 'Deudas a corto plazo con entidades de crédito empresas del grupo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4366, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '5104', '4364', 'Deudas a corto plazo con entidades de crédito empresas asociadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4367, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '5105', '4364', 'Deudas a corto plazo con otras entidades de crédito vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4368, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '511', '4363', 'Proveedores de inmovilizado a corto plazo partes vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4369, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '5113', '4368', 'Proveedores de inmovilizado a corto plazo empresas del grupo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4370, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '5114', '4368', 'Proveedores de inmovilizado a corto plazo empresas asociadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4371, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '5115', '4368', 'Proveedores de inmovilizado a corto plazo otras partes vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4372, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '512', '4363', 'Acreedores por arrendamiento financiero a corto plazo partes vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4373, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '5123', '4372', 'Acreedores por arrendamiento financiero a corto plazo empresas del grupo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4374, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '5124', '4372', 'Acreedores por arrendamiento financiero a corto plazo empresas asociadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4375, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '5125', '4372', 'Acreedores por arrendamiento financiero a corto plazo otras partes vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4376, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '513', '4363', 'Otras deudas a corto plazo con partes vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4377, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '5133', '4376', 'Otras deudas a corto plazo con empresas del grupo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4378, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '5134', '4376', 'Otras deudas a corto plazo con empresas asociadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4379, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '5135', '4376', 'Otras deudas a corto plazo con partes vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4380, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '514', '4363', 'Intereses a corto plazo con partes vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4381, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '5143', '4380', 'Intereses a corto plazo empresas del grupo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4382, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '5144', '4380', 'Intereses a corto plazo empresas asociadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4383, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '5145', '4380', 'Intereses deudas a corto plazo partes vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4384, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '52', '4005', 'Deudas a corto plazo por préstamos recibidos y otros conceptos', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4385, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '520', '4384', 'Deudas a corto plazo con entidades de crédito', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4386, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '5200', '4385', 'Préstamos a corto plazo de entidades de crédito', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4387, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '5201', '4385', 'Deudas a corto plazo por crédito dispuesto', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4388, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '5208', '4385', 'Deudas por efectos descontados', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4389, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '5209', '4385', 'Deudas por operaciones de factoring', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4390, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '521', '4384', 'Deudas a corto plazo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4391, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '522', '4384', 'Deudas a corto plazo transformables en subvenciones donaciones y legados', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4392, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '523', '4384', 'Proveedores de inmovilizado a corto plazo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4393, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '526', '4384', 'Dividendo activo a pagar', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4394, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '527', '4384', 'Intereses a corto plazo de deudas con entidades de crédito', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4395, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '528', '4384', 'Intereses a corto plazo de deudas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4396, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '529', '4384', 'Provisiones a corto plazo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4397, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '5291', '4396', 'Provisión a corto plazo para impuestos', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4398, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '5292', '4396', 'Provisión a corto plazo para otras responsabilidades', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4399, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '5293', '4396', 'Provisión a corto plazo por desmantelamiento retiro o rehabilitación del inmovilizado', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4400, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '5295', '4396', 'Provisión a corto plazo para actuaciones medioambientales', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4401, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '53', '4005', 'Inversiones financieras a corto plazo en partes vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4402, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '530', '4401', 'Participaciones a corto plazo en partes vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4403, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '5303', '4402', 'Participaciones a corto plazo en empresas del grupo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4404, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '5304', '4402', 'Participaciones a corto plazo en empresas asociadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4405, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '5305', '4402', 'Participaciones a corto plazo en otras partes vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4406, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '531', '4401', 'Valores representativos de deuda a corto plazo de partes vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4407, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '5313', '4406', 'Valores representativos de deuda a corto plazo de empresas del grupo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4408, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '5314', '4406', 'Valores representativos de deuda a corto plazo de empresas asociadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4409, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '5315', '4406', 'Valores representativos de deuda a corto plazo de otras partes vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4410, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '532', '4401', 'Créditos a corto plazo a partes vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4411, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '5323', '4410', 'Créditos a corto plazo a empresas del grupo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4412, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '5324', '4410', 'Créditos a corto plazo a empresas asociadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4413, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '5325', '4410', 'Créditos a corto plazo a otras partes vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4414, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '533', '4401', 'Intereses a corto plazo de valores representativos de deuda de partes vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4415, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '5333', '4414', 'Intereses a corto plazo de valores representativos de deuda en empresas del grupo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4416, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '5334', '4414', 'Intereses a corto plazo de valores representativos de deuda en empresas asociadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4417, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '5335', '4414', 'Intereses a corto plazo de valores representativos de deuda en otras partes vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4418, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '534', '4401', 'Intereses a corto plazo de créditos a partes vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4419, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '5343', '4418', 'Intereses a corto plazo de créditos a empresas del grupo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4420, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '5344', '4418', 'Intereses a corto plazo de créditos a empresas asociadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4421, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '5345', '4418', 'Intereses a corto plazo de créditos a otras partes vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4422, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '535', '4401', 'Dividendo a cobrar de inversiones financieras en partes vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4423, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '5353', '4422', 'Dividendo a cobrar de empresas del grupo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4424, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '5354', '4422', 'Dividendo a cobrar de empresas asociadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4425, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '5355', '4422', 'Dividendo a cobrar de otras partes vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4426, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '539', '4401', 'Desembolsos pendientes sobre participaciones a corto plazo en partes vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4427, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '5393', '4426', 'Desembolsos pendientes sobre participaciones a corto plazo en empresas del grupo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4428, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '5394', '4426', 'Desembolsos pendientes sobre participaciones a corto plazo en empresas asociadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4429, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '5395', '4426', 'Desembolsos pendientes sobre participaciones a corto plazo en otras partes vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4430, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '54', '4005', 'Otras inversiones financieras a corto plazo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4431, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '540', '4430', 'Inversiones financieras a corto plazo en instrumentos de patrimonio', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4432, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '541', '4430', 'Valores representativos de deuda a corto plazo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4433, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '542', '4430', 'Créditos a corto plazo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4434, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '543', '4430', 'Créditos a corto plazo por enejenación de inmovilizado', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4435, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '544', '4430', 'Créditos a corto plazo al personal', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4436, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '545', '4430', 'Dividendo a cobrar', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4437, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '546', '4430', 'Intereses a corto plazo de valores reprsentativos de deuda', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4438, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '547', '4430', 'Intereses a corto plazo de créditos', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4439, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '548', '4430', 'Imposiciones a corto plazo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4440, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '549', '4430', 'Desembolsos pendientes sobre participaciones en el patrimonio neto a corto plazo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4441, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '55', '4005', 'Otras cuentas no bancarias', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4442, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '550', '4441', 'Titular de la explotación', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4443, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '551', '4441', 'Cuenta corriente con socios y administradores', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4444, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '552', '4441', 'Cuenta corriente otras personas y entidades vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4445, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '5523', '4444', 'Cuenta corriente con empresas del grupo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4446, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '5524', '4444', 'Cuenta corriente con empresas asociadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4447, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '5525', '4444', 'Cuenta corriente con otras partes vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4448, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '554', '4441', 'Cuenta corriente con uniones temporales de empresas y comunidades de bienes', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4449, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '555', '4441', 'Partidas pendientes de aplicación', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4450, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '556', '4441', 'Desembolsos exigidos sobre participaciones en el patrimonio neto', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4451, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '5563', '4450', 'Desembolsos exigidos sobre participaciones empresas del grupo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4452, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '5564', '4450', 'Desembolsos exigidos sobre participaciones empresas asociadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4453, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '5565', '4450', 'Desembolsos exigidos sobre participaciones otras partes vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4454, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '5566', '4450', 'Desembolsos exigidos sobre participaciones otras empresas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4455, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '557', '4441', 'Dividendo activo a cuenta', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4456, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '558', '4441', 'Socios por desembolsos exigidos', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4457, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '5580', '4456', 'Socios por desembolsos exigidos sobre acciones o participaciones ordinarias', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4458, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '5585', '4456', 'Socios por desembolsos exigidos sobre acciones o participaciones consideradas como pasivos financieros', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4459, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '559', '4441', 'Derivados financieros a corto plazo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4460, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '5590', '4459', 'Activos por derivados financieros a corto plazo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4461, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '5595', '4459', 'Pasivos por derivados financieros a corto plazo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4462, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '56', '4005', 'Finanzas y depósitos recibidos y constituidos a corto plazo y ajustes por periodificación', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4463, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '560', '4462', 'Finanzas recibidas a corto plazo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4464, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '561', '4462', 'Depósitos recibidos a corto plazo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4465, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '565', '4462', 'Finanzas constituidas a corto plazo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4466, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '566', '4462', 'Depósitos constituidos a corto plazo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4467, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '567', '4462', 'Intereses pagados por anticipado', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4468, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '568', '4462', 'Intereses cobrados a corto plazo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4469, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '57', '4005', 'Tesorería', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4470, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'CAJA', '570', '4469', 'Caja euros', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4471, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '571', '4469', 'Caja moneda extranjera', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4472, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'BANCOS', '572', '4469', 'Bancos e instituciones de crédito cc vista euros', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4473, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '573', '4469', 'Bancos e instituciones de crédito cc vista moneda extranjera', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4474, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '574', '4469', 'Bancos e instituciones de crédito cuentas de ahorro euros', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4475, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '575', '4469', 'Bancos e instituciones de crédito cuentas de ahorro moneda extranjera', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4476, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '576', '4469', 'Inversiones a corto plazo de gran liquidez', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4477, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '59', '4005', 'Deterioro del valor de las inversiones financieras a corto plazo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4478, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '593', '4477', 'Deterioro del valor de participaciones a corto plazo en partes vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4479, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '5933', '4478', 'Deterioro del valor de participaciones a corto plazo en empresas del grupo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4480, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '5934', '4478', 'Deterioro del valor de participaciones a corto plazo en empresas asociadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4481, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '5935', '4478', 'Deterioro del valor de participaciones a corto plazo en otras partes vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4482, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '594', '4477', 'Deterioro del valor de valores representativos de deuda a corto plazo en partes vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4483, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '5943', '4482', 'Deterioro del valor de valores representativos de deuda a corto plazo en empresas del grupo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4484, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '5944', '4482', 'Deterioro del valor de valores representativos de deuda a corto plazo en empresas asociadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4485, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '5945', '4482', 'Deterioro del valor de valores representativos de deuda a corto plazo en otras partes vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4486, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '595', '4477', 'Deterioro del valor de créditos a corto plazo en partes vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4487, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '5953', '4486', 'Deterioro del valor de créditos a corto plazo en empresas del grupo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4488, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '5954', '4486', 'Deterioro del valor de créditos a corto plazo en empresas asociadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4489, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '5955', '4486', 'Deterioro del valor de créditos a corto plazo en otras partes vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4490, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '596', '4477', 'Deterioro del valor de participaciones a corto plazo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4491, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '597', '4477', 'Deterioro del valor de valores representativos de deuda a corto plazo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4492, 'PCG08-PYME','CUENTAS_FINANCIERAS', 'XXXXXX', '598', '4477', 'Deterioro de valor de créditos a corto plazo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4493, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '60', '4006', 'Compras', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4494, 'PCG08-PYME','COMPRAS_GASTOS', 'COMPRAS', '600', '4493', 'Compras de mercaderías', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4495, 'PCG08-PYME','COMPRAS_GASTOS', 'COMPRAS', '601', '4493', 'Compras de materias primas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4496, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '602', '4493', 'Compras de otros aprovisionamientos', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4497, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '606', '4493', 'Descuentos sobre compras por pronto pago', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4498, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6060', '4497', 'Descuentos sobre compras por pronto pago de mercaderías', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4499, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6061', '4497', 'Descuentos sobre compras por pronto pago de materias primas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4500, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6062', '4497', 'Descuentos sobre compras por pronto pago de otros aprovisionamientos', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4501, 'PCG08-PYME','COMPRAS_GASTOS', 'COMPRAS', '607', '4493', 'Trabajos realizados por otras empresas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4502, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '608', '4493', 'Devoluciones de compras y operaciones similares', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4503, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6080', '4502', 'Devoluciones de compras de mercaderías', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4504, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6081', '4502', 'Devoluciones de compras de materias primas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4505, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6082', '4502', 'Devoluciones de compras de otros aprovisionamientos', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4506, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '609', '4493', 'Rappels por compras', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4507, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6090', '4506', 'Rappels por compras de mercaderías', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4508, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6091', '4506', 'Rappels por compras de materias primas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4509, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6092', '4506', 'Rappels por compras de otros aprovisionamientos', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4510, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '61', '4006', 'Variación de existencias', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4511, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '610', '4510', 'Variación de existencias de mercaderías', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4512, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '611', '4510', 'Variación de existencias de materias primas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4513, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '612', '4510', 'Variación de existencias de otros aprovisionamientos', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4514, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '62', '4006', 'Servicios exteriores', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4515, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '620', '4514', 'Gastos en investigación y desarrollo del ejercicio', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4516, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '621', '4514', 'Arrendamientos y cánones', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4517, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '622', '4514', 'Reparaciones y conservación', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4518, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '623', '4514', 'Servicios profesionales independientes', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4519, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '624', '4514', 'Transportes', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4520, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '625', '4514', 'Primas de seguros', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4521, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '626', '4514', 'Servicios bancarios y similares', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4522, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '627', '4514', 'Publicidad, propaganda y relaciones públicas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4523, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '628', '4514', 'Suministros', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4524, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '629', '4514', 'Otros servicios', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4525, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '63', '4006', 'Tributos', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4526, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '630', '4525', 'Impuesto sobre benecifios', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4527, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6300', '4526', 'Impuesto corriente', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4528, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6301', '4526', 'Impuesto diferido', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4529, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '631', '4525', 'Otros tributos', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4530, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '633', '4525', 'Ajustes negativos en la imposición sobre beneficios', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4531, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '634', '4525', 'Ajustes negativos en la imposición indirecta', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4532, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6341', '4531', 'Ajustes negativos en IVA de activo corriente', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4533, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6342', '4531', 'Ajustes negativos en IVA de inversiones', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4534, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '636', '4525', 'Devolución de impuestos', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4535, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '638', '4525', 'Ajustes positivos en la imposición sobre beneficios', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4536, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '639', '4525', 'Ajustes positivos en la imposición directa', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4537, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6391', '4536', 'Ajustes positivos en IVA de activo corriente', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4538, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6392', '4536', 'Ajustes positivos en IVA de inversiones', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4539, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '64', '4006', 'Gastos de personal', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4540, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '640', '4539', 'Sueldos y salarios', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4541, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '641', '4539', 'Indemnizaciones', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4542, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '642', '4539', 'Seguridad social a cargo de la empresa', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4543, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '649', '4539', 'Otros gastos sociales', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4544, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '65', '4006', 'Otros gastos de gestión', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4545, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '650', '4544', 'Pérdidas de créditos comerciales incobrables', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4546, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '651', '4544', 'Resultados de operaciones en común', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4547, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6510', '4546', 'Beneficio transferido gestor', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4548, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6511', '4546', 'Pérdida soportada participe o asociado no gestor', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4549, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '659', '4544', 'Otras pérdidas en gestión corriente', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4550, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '66', '4006', 'Gastos financieros', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4551, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '660', '4550', 'Gastos financieros por actualización de provisiones', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4552, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '661', '4550', 'Intereses de obligaciones y bonos', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4553, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6610', '4452', 'Intereses de obligaciones y bonos a largo plazo empresas del grupo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4554, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6611', '4452', 'Intereses de obligaciones y bonos a largo plazo empresas asociadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4555, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6612', '4452', 'Intereses de obligaciones y bonos a largo plazo otras partes vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4556, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6613', '4452', 'Intereses de obligaciones y bonos a largo plazo otras empresas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4557, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6615', '4452', 'Intereses de obligaciones y bonos a corto plazo empresas del grupo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4558, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6616', '4452', 'Intereses de obligaciones y bonos a corto plazo empresas asociadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4559, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6617', '4452', 'Intereses de obligaciones y bonos a corto plazo otras partes vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4560, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6618', '4452', 'Intereses de obligaciones y bonos a corto plazo otras empresas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4561, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '662', '4550', 'Intereses de deudas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4562, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6620', '4561', 'Intereses de deudas empresas del grupo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4563, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6621', '4561', 'Intereses de deudas empresas asociadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4564, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6622', '4561', 'Intereses de deudas otras partes vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4565, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6623', '4561', 'Intereses de deudas con entidades de crédito', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4566, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6624', '4561', 'Intereses de deudas otras empresas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4567, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '663', '4550', 'Pérdidas por valorización de activos y pasivos financieros por su valor razonable', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4568, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '664', '4550', 'Gastos por dividendos de acciones o participaciones consideradas como pasivos financieros', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4569, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6640', '4568', 'Dividendos de pasivos empresas del grupo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4570, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6641', '4568', 'Dividendos de pasivos empresas asociadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4571, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6642', '4568', 'Dividendos de pasivos otras partes vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4572, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6643', '4568', 'Dividendos de pasivos otras empresas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4573, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '665', '4550', 'Intereses por descuento de efectos y operaciones de factoring', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4574, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6650', '4573', 'Intereses por descuento de efectos en entidades de crédito del grupo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4575, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6651', '4573', 'Intereses por descuento de efectos en entidades de crédito asociadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4576, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6652', '4573', 'Intereses por descuento de efectos en entidades de crédito vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4577, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6653', '4573', 'Intereses por descuento de efectos en otras entidades de crédito', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4578, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6654', '4573', 'Intereses por operaciones de factoring con entidades de crédito del grupo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4579, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6655', '4573', 'Intereses por operaciones de factoring con entidades de crédito asociadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4580, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6656', '4573', 'Intereses por operaciones de factoring con otras entidades de crédito vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4581, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6657', '4573', 'Intereses por operaciones de factoring con otras entidades de crédito', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4582, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '666', '4550', 'Pérdidas en participaciones y valores representativos de deuda', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4583, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6660', '4582', 'Pérdidas en valores representativos de deuda a largo plazo empresas del grupo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4584, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6661', '4582', 'Pérdidas en valores representativos de deuda a largo plazo empresas asociadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4585, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6662', '4582', 'Pérdidas en valores representativos de deuda a largo plazo otras partes vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4586, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6663', '4582', 'Pérdidas en participaciones y valores representativos de deuda a largo plazo otras empresas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4587, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6665', '4582', 'Pérdidas en participaciones y valores representativos de deuda a corto plazo empresas del grupo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4588, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6666', '4582', 'Pérdidas en participaciones y valores representativos de deuda a corto plazo empresas asociadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4589, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6667', '4582', 'Pérdidas en valores representativos de deuda a corto plazo otras partes vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4590, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6668', '4582', 'Pérdidas en valores representativos de deuda a corto plazo otras empresas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4591, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '667', '4550', 'Pérdidas de créditos no comerciales', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4592, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6670', '4591', 'Pérdidas de créditos a largo plazo empresas del grupo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4593, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6671', '4591', 'Pérdidas de créditos a largo plazo empresas asociadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4594, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6672', '4591', 'Pérdidas de créditos a largo plazo otras partes vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4595, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6673', '4591', 'Pérdidas de créditos a largo plazo otras empresas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4596, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6675', '4591', 'Pérdidas de créditos a corto plazo empresas del grupo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4597, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6676', '4591', 'Pérdidas de créditos a corto plazo empresas asociadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4598, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6677', '4591', 'Pérdidas de créditos a corto plazo otras partes vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4599, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6678', '4591', 'Pérdidas de créditos a corto plazo otras empresas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4600, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '668', '4550', 'Diferencias negativas de cambio', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4601, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '669', '4550', 'Otros gastos financieros', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4602, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '67', '4006', 'Pérdidas procedentes de activos no corrientes y gastos excepcionales', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4603, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '670', '4602', 'Pérdidas procedentes del inmovilizado intangible', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4604, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '671', '4602', 'Pérdidas procedentes del inmovilizado material', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4605, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '672', '4602', 'Pérdidas procedentes de las inversiones inmobiliarias', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4607, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '673', '4602', 'Pérdidas procedentes de participaciones a largo plazo en partes vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4608, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6733', '4607', 'Pérdidas procedentes de participaciones a largo plazo empresas del grupo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4609, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6734', '4607', 'Pérdidas procedentes de participaciones a largo plazo empresas asociadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4610, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6735', '4607', 'Pérdidas procedentes de participaciones a largo plazo otras partes vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4611, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '675', '4602', 'Pérdidas por operaciones con obligaciones propias', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4612, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '678', '4602', 'Gastos excepcionales', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4613, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '68', '4006', 'Dotaciones para amortizaciones', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4614, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '680', '4613', 'Amortización del inmovilizado intangible', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4615, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '681', '4613', 'Amortización del inmovilizado material', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4616, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '682', '4613', 'Amortización de las inversiones inmobiliarias', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4617, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '69', '4006', 'Pérdidas por deterioro y otras dotaciones', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4618, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '690', '4617', 'Pérdidas por deterioro del inmovilizado intangible', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4619, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '691', '4617', 'Pérdidas por deterioro del inmovilizado material', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4620, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '692', '4617', 'Pérdidas por deterioro de las inversiones inmobiliarias', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4621, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '693', '4617', 'Pérdidas por deterioro de existencias', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4622, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6930', '4621', 'Pérdidas por deterioro de productos terminados y en curso de fabricación', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4623, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6931', '4621', 'Pérdidas por deterioro de mercaderías', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4624, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6932', '4621', 'Pérdidas por deterioro de materias primas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4625, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6933', '4621', 'Pérdidas por deterioro de otros aprovisionamientos', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4626, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '694', '4617', 'Pérdidas por deterioro de créditos por operaciones comerciales', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4627, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '695', '4617', 'Dotación a la provisión por operaciones comerciales', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4628, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6954', '4627', 'Dotación a la provisión por contratos onerosos', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4629, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6959', '4628', 'Dotación a la provisión para otras operaciones comerciales', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4630, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '696', '4617', 'Pérdidas por deterioro de participaciones y valores representativos de deuda a largo plazo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4631, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6960', '4630', 'Pérdidas por deterioro de participaciones en instrumentos de patrimonio neto a largo plazo empresas del grupo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4632, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6961', '4630', 'Pérdidas por deterioro de participaciones en instrumentos de patrimonio neto a largo plazo empresas asociadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4633, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6962', '4630', 'Pérdidas por deterioro de participaciones en instrumentos de patrimonio neto a largo plazo otras partes vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4634, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6963', '4630', 'Pérdidas por deterioro de participaciones en instrumentos de patrimonio neto a largo plazo otras empresas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4635, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6965', '4630', 'Pérdidas por deterioro en valores representativos de deuda a largo plazo empresas del grupo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4636, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6966', '4630', 'Pérdidas por deterioro en valores representativos de deuda a largo plazo empresas asociadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4637, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6967', '4630', 'Pérdidas por deterioro en valores representativos de deuda a largo plazo otras partes vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4638, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6968', '4630', 'Pérdidas por deterioro en valores representativos de deuda a largo plazo otras empresas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4639, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '697', '4617', 'Pérdidas por deterioro de créditos a largo plazo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4640, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6970', '4639', 'Pérdidas por deterioro de créditos a largo plazo empresas del grupo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4641, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6971', '4639', 'Pérdidas por deterioro de créditos a largo plazo empresas asociadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4642, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6972', '4639', 'Pérdidas por deterioro de créditos a largo plazo otras partes vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4643, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6973', '4639', 'Pérdidas por deterioro de créditos a largo plazo otras empresas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4644, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '698', '4617', 'Pérdidas por deterioro de participaciones y valores representativos de deuda a corto plazo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4645, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6980', '4644', 'Pérdidas por deterioro de participaciones en instrumentos de patrimonio neto a corto plazo empresas del grupo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4646, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6981', '4644', 'Pérdidas por deterioro de participaciones en instrumentos de patrimonio neto a corto plazo empresas asociadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4647, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6985', '4644', 'Pérdidas por deterioro en valores representativos de deuda a corto plazo empresas del grupo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4648, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6986', '4644', 'Pérdidas por deterioro en valores representativos de deuda a corto plazo empresas asociadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4649, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6988', '4644', 'Pérdidas por deterioro en valores representativos de deuda a corto plazo de otras empresas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4650, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '699', '4617', 'Pérdidas por deterioro de crédito a corto plazo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4651, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6990', '4650', 'Pérdidas por deterioro de crédito a corto plazo empresas del grupo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4652, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6991', '4650', 'Pérdidas por deterioro de crédito a corto plazo empresas asociadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4653, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6992', '4650', 'Pérdidas por deterioro de crédito a corto plazo otras partes vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4654, 'PCG08-PYME','COMPRAS_GASTOS', 'XXXXXX', '6993', '4650', 'Pérdidas por deterioro de crédito a corto plazo otras empresas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4655, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '70', '4007', 'Ventas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4656, 'PCG08-PYME','VENTAS_E_INGRESOS', 'VENTAS', '700', '4655', 'Ventas de mercaderías', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4657, 'PCG08-PYME','VENTAS_E_INGRESOS', 'VENTAS', '701', '4655', 'Ventas de productos terminados', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4658, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '702', '4655', 'Ventas de productos semiterminados', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4659, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '703', '4655', 'Ventas de subproductos y residuos', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4660, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '704', '4655', 'Ventas de envases y embalajes', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4661, 'PCG08-PYME','VENTAS_E_INGRESOS', 'VENTAS', '705', '4655', 'Prestaciones de servicios', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4662, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '706', '4655', 'Descuentos sobre ventas por pronto pago', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4663, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '7060', '4662', 'Descuentos sobre ventas por pronto pago de mercaderías', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4664, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '7061', '4662', 'Descuentos sobre ventas por pronto pago de productos terminados', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4665, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '7062', '4662', 'Descuentos sobre ventas por pronto pago de productos semiterminados', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4666, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '7063', '4662', 'Descuentos sobre ventas por pronto pago de subproductos y residuos', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4667, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '708', '4655', 'Devoluciones de ventas y operacioes similares', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4668, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '7080', '4667', 'Devoluciones de ventas de mercaderías', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4669, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '7081', '4667', 'Devoluciones de ventas de productos terminados', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4670, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '7082', '4667', 'Devoluciones de ventas de productos semiterminados', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4671, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '7083', '4667', 'Devoluciones de ventas de subproductos y residuos', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4672, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '7084', '4667', 'Devoluciones de ventas de envases y embalajes', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4673, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '71', '4007', 'Variación de existencias', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4674, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '710', '4673', 'Variación de existencias de productos en curso', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4675, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '711', '4673', 'Variación de existencias de productos semiterminados', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4676, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '712', '4673', 'Variación de existencias de productos terminados', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4677, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '713', '4673', 'Variación de existencias de subproductos, residuos y materiales recuperados', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4678, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '73', '4007', 'Trabajos realizados para la empresa', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4679, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '730', '4678', 'Trabajos realizados para el inmovilizado intangible', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4680, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '731', '4678', 'Trabajos realizados para el inmovilizado tangible', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4681, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '732', '4678', 'Trabajos realizados en inversiones inmobiliarias', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4682, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '733', '4678', 'Trabajos realizados para el inmovilizado material en curso', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4683, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '74', '4007', 'Subvenciones, donaciones y legados', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4684, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '740', '4683', 'Subvenciones, donaciones y legados a la explotación', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4685, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '746', '4683', 'Subvenciones, donaciones y legados de capital transferidos al resultado del ejercicio', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4686, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '747', '4683', 'Otras subvenciones, donaciones y legados transferidos al resultado del ejercicio', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4687, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '75', '4007', 'Otros ingresos de gestión', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4688, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '751', '4687', 'Resultados de operaciones en común', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4689, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '7510', '4688', 'Pérdida transferida gestor', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4690, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '7511', '4688', 'Beneficio atribuido participe o asociado no gestor', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4691, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '752', '4687', 'Ingreso por arrendamiento', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4692, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '753', '4687', 'Ingresos de propiedad industrial cedida en explotación', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4693, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '754', '4687', 'Ingresos por comisiones', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4694, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '755', '4687', 'Ingresos por servicios al personal', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4695, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '759', '4687', 'Ingresos por servicios diversos', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4696, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '76', '4007', 'Ingresos financieros', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4697, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '760', '4696', 'Ingresos de participaciones en instrumentos de patrimonio', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4698, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '7600', '4697', 'Ingresos de participaciones en instrumentos de patrimonio empresas del grupo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4699, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '7601', '4697', 'Ingresos de participaciones en instrumentos de patrimonio empresas asociadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4700, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '7602', '4697', 'Ingresos de participaciones en instrumentos de patrimonio otras partes asociadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4701, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '7603', '4697', 'Ingresos de participaciones en instrumentos de patrimonio otras empresas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4702, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '761', '4696', 'Ingresos de valores representativos de deuda', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4703, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '7610', '4702', 'Ingresos de valores representativos de deuda empresas del grupo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4704, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '7611', '4702', 'Ingresos de valores representativos de deuda empresas asociadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4705, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '7612', '4702', 'Ingresos de valores representativos de deuda otras partes asociadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4706, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '7613', '4702', 'Ingresos de valores representativos de deuda otras empresas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4707, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '762', '4696', 'Ingresos de créditos', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4708, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '7620', '4707', 'Ingresos de créditos a largo plazo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4709, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '76200', '4708', 'Ingresos de crédito a largo plazo empresas del grupo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4710, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '76201', '4708', 'Ingresos de crédito a largo plazo empresas asociadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4711, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '76202', '4708', 'Ingresos de crédito a largo plazo otras partes asociadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4712, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '76203', '4708', 'Ingresos de crédito a largo plazo otras empresas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4713, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '7621', '4707', 'Ingresos de créditos a corto plazo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4714, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '76210', '4713', 'Ingresos de crédito a corto plazo empresas del grupo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4715, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '76211', '4713', 'Ingresos de crédito a corto plazo empresas asociadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4716, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '76212', '4713', 'Ingresos de crédito a corto plazo otras partes asociadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4717, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '76213', '4713', 'Ingresos de crédito a corto plazo otras empresas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4718, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '763', '4696', 'Beneficios por valorización de activos y pasivos financieros por su valor razonable', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4719, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '766', '4696', 'Beneficios en participaciones y valores representativos de deuda', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4720, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '7660', '4719', 'Beneficios en participaciones y valores representativos de deuda a largo plazo empresas del grupo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4721, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '7661', '4719', 'Beneficios en participaciones y valores representativos de deuda a largo plazo empresas asociadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4722, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '7662', '4719', 'Beneficios en participaciones y valores representativos de deuda a largo plazo otras partes asociadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4723, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '7663', '4719', 'Beneficios en participaciones y valores representativos de deuda a largo plazo otras empresas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4724, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '7665', '4719', 'Beneficios en participaciones y valores representativos de deuda a corto plazo empresas del grupo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4725, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '7666', '4719', 'Beneficios en participaciones y valores representativos de deuda a corto plazo empresas asociadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4726, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '7667', '4719', 'Beneficios en participaciones y valores representativos de deuda a corto plazo otras partes asociadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4727, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '7668', '4719', 'Beneficios en participaciones y valores representativos de deuda a corto plazo otras empresas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4728, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '768', '4696', 'Diferencias positivas de cambio', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4729, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '769', '4696', 'Otros ingresos financieros', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4730, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '77', '4007', 'Beneficios procedentes de activos no corrientes e ingresos excepcionales', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4731, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '770', '4730', 'Beneficios procedentes del inmovilizado intangible', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4732, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '771', '4730', 'Beneficios procedentes del inmovilizado material', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4733, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '772', '4730', 'Beneficios procedentes de las inversiones inmobiliarias', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4734, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '773', '4730', 'Beneficios procedentes de participaciones a largo plazo en partes vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4735, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '7733', '4734', 'Beneficios procedentes de participaciones a largo plazo empresas del grupo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4736, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '7734', '4734', 'Beneficios procedentes de participaciones a largo plazo empresas asociadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4737, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '7735', '4734', 'Beneficios procedentes de participaciones a largo plazo otras partes vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4738, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '775', '4730', 'Beneficios por operaciones con obligaciones propias', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4739, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '778', '4730', 'Ingresos excepcionales', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4741, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '79', '4007', 'Excesos y aplicaciones de provisiones y pérdidas por deterioro', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4742, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '790', '4741', 'Revisión del deterioro del inmovilizado intangible', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4743, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '791', '4741', 'Revisión del deterioro del inmovilizado material', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4744, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '792', '4741', 'Revisión del deterioro de las inversiones inmobiliarias', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4745, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '793', '4741', 'Revisión del deterioro de las existencias', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4746, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '7930', '4745', 'Revisión del deterioro de productos terminados y en curso de fabricación', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4747, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '7931', '4745', 'Revisión del deterioro de mercaderías', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4748, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '7932', '4745', 'Revisión del deterioro de materias primas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4749, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '7933', '4745', 'Revisión del deterioro de otros aprovisionamientos', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4750, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '794', '4741', 'Revisión del deterioro de créditos por operaciones comerciales', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4751, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '795', '4741', 'Exceso de provisiones', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4752, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '7951', '4751', 'Exceso de provisión para impuestos', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4753, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '7952', '4751', 'Exceso de provisión para otras responsabilidades', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4755, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '7954', '4751', 'Exceso de provisión para operaciones comerciales', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4756, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '79544', '4755', 'Exceso de provisión por contratos onerosos', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4757, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '79549', '4755', 'Exceso de provisión para otras operaciones comerciales', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4758, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '7955', '4751', 'Exceso de provisión para actuaciones medioambienteales', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4759, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '796', '4741', 'Revisión del deterioro de participaciones y valores representativos de deuda a largo plazo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4760, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '7960', '4759', 'Revisión del deterioro de participaciones en instrumentos de patrimonio neto a largo plazo empresas del grupo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4761, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '7961', '4759', 'Revisión del deterioro de participaciones en instrumentos de patrimonio neto a largo plazo empresas asociadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4762, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '7962', '4759', 'Revisión del deterioro de participaciones en instrumentos de patrimonio neto a largo plazo otras partes vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4763, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '7963', '4759', 'Revisión del deterioro de participaciones en instrumentos de patrimonio neto a largo plazo otras empresas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4764, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '7965', '4759', 'Revisión del deterioro de valores representativos a largo plazo empresas del grupo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4765, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '7966', '4759', 'Revisión del deterioro de valores representativos a largo plazo empresas asociadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4766, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '7967', '4759', 'Revisión del deterioro de valores representativos a largo otras partes vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4767, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '7968', '4759', 'Revisión del deterioro de valores representativos a largo plazo otras empresas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4768, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '797', '4741', 'Revisión del deterioro de créditos a largo plazo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4769, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '7970', '4768', 'Revisión del deterioro de créditos a largo plazo empresas del grupo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4770, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '7971', '4768', 'Revisión del deterioro de créditos a largo plazo empresas asociadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4771, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '7972', '4768', 'Revisión del deterioro de créditos a largo plazo otras partes vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4772, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '7973', '4768', 'Revisión del deterioro de créditos a largo plazo otras empresas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4773, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '798', '4741', 'Revisión del deterioro de participaciones y valores representativos de deuda a corto plazo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4774, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '7980', '4773', 'Revisión del deterioro de participaciones en instrumentos de patrimonio neto a corto plazo empresas del grupo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4775, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '7981', '4773', 'Revisión del deterioro de participaciones en instrumentos de patrimonio neto a corto plazo empresas asociadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4776, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '7985', '4773', 'Revisión del deterioro de valores representativos de deuda a corto plazo empresas del grupo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4777, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '7986', '4773', 'Revisión del deterioro de valores representativos de deuda a corto plazo empresas asociadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4778, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '7987', '4773', 'Revisión del deterioro de valores representativos de deuda a corto plazo otras partes vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4779, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '7988', '4773', 'Revisión del deterioro de valores representativos de deuda a corto plazo otras empresas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4780, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '799', '4741', 'Revisión del deterioro de créditos a corto plazo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4781, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '7990', '4780', 'Revisión del deterioro de créditos a corto plazo empresas del grupo', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4782, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '7991', '4780', 'Revisión del deterioro de créditos a corto plazo empresas asociadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4783, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '7992', '4780', 'Revisión del deterioro de créditos a corto plazo otras partes vinculadas', 1);
INSERT INTO llx_accounting_account (rowid, fk_pcg_version, pcg_type, pcg_subtype, account_number, account_parent, label, active) VALUES (4784, 'PCG08-PYME','VENTAS_E_INGRESOS', 'XXXXXX', '7993', '4780', 'Revisión del deterioro de créditos a corto plazo otras empresas', 1);
