# -*- coding: utf-8 -*-
"""The compilemodules module of dolfin"""
from dolfin.compilemodules import compilemodule
from dolfin.compilemodules import expressions
from dolfin.compilemodules import subdomains
from dolfin.compilemodules import jit

from .compilemodule import compile_extension_module
from .expressions import compile_expressions
from .subdomains import CompiledSubDomain
from .jit import jit

# NOTE: The automatic documentation system in DOLFIN requires to _not_ define
# NOTE: classes or functions within this file. Use separate modules for that
# NOTE: purpose.

__all__ = ["compile_extension_module", "compile_expressions",
           "CompiledSubDomain", "jit"]
