// This code conforms with the UFC specification version 2016.1.0
// and was automatically generated by FFC version 2016.1.0.
//
// This code was generated with the option '-l dolfin' and
// contains DOLFIN-specific wrappers that depend on DOLFIN.
// 
// This code was generated with the following parameters:
// 
//   convert_exceptions_to_warnings: False
//   cpp_optimize:                   True
//   cpp_optimize_flags:             '-O2'
//   epsilon:                        1e-14
//   error_control:                  True
//   form_postfix:                   True
//   format:                         'dolfin'
//   optimize:                       True
//   precision:                      15
//   quadrature_degree:              -1
//   quadrature_rule:                'auto'
//   representation:                 'auto'
//   split:                          False

#ifndef __ADAPTIVEPOISSON_H
#define __ADAPTIVEPOISSON_H
#include <stdexcept>
#include <ufc.h>

class adaptivepoisson_finite_element_0: public ufc::finite_element
{
public:

  adaptivepoisson_finite_element_0() : ufc::finite_element()
  {
    // Do nothing
  }

  ~adaptivepoisson_finite_element_0() override
  {
    // Do nothing
  }

  const char * signature() const final override
  {
    return "FiniteElement('Lagrange', triangle, 1)";
  }

  ufc::shape cell_shape() const final override
  {
    return ufc::shape::triangle;
  }

  std::size_t topological_dimension() const final override
  {
    return 2;
  }

  std::size_t geometric_dimension() const final override
  {
    return 2;
  }

  std::size_t space_dimension() const final override
  {
    return 3;
  }

  std::size_t value_rank() const final override
  {
    return 0;
  }

  std::size_t value_dimension(std::size_t i) const final override
  {
    return 1;
  }

  std::size_t value_size() const final override
  {
    return 1;
  }

  std::size_t reference_value_rank() const final override
  {
    return 0;
  }

  std::size_t reference_value_dimension(std::size_t i) const final override
  {
    return 1;
  }

  std::size_t reference_value_size() const final override
  {
    return 1;
  }

  std::size_t degree() const final override
  {
    return 1;
  }

  const char * family() const final override
  {
    return "Lagrange";
  }

  static void _evaluate_basis(std::size_t i,
                              double * values,
                              const double * x,
                              const double * coordinate_dofs,
                              int cell_orientation)
  {
    // Compute Jacobian
    double J[4];
    compute_jacobian_triangle_2d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[4];
    double detJ;
    compute_jacobian_inverse_triangle_2d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = coordinate_dofs[2] + coordinate_dofs[4];
    const double C1 = coordinate_dofs[3] + coordinate_dofs[5];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J[1]*(C1 - 2.0*x[1]) + J[3]*(2.0*x[0] - C0)) / detJ;
    double Y = (J[0]*(2.0*x[1] - C1) + J[2]*(C0 - 2.0*x[0])) / detJ;
    
    // Reset values
    *values = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, -0.288675134594813, -0.166666666666667};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 3; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, 0.288675134594813, -0.166666666666667};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 3; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, 0.0, 0.333333333333333};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 3; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    }
    
  }

  void evaluate_basis(std::size_t i,
                      double * values,
                      const double * x,
                      const double * coordinate_dofs,
                      int cell_orientation) const final override
  {
    _evaluate_basis(i, values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_all(double * values,
                                  const double * x,
                                  const double * coordinate_dofs,
                                  int cell_orientation)
  {
    // Helper variable to hold values of a single dof.
    double dof_values = 0.0;
    
    // Loop dofs and call evaluate_basis
    for (unsigned int r = 0; r < 3; r++)
    {
      _evaluate_basis(r, &dof_values, x, coordinate_dofs, cell_orientation);
      values[r] = dof_values;
    } // end loop over 'r'
  }

  void evaluate_basis_all(double * values,
                          const double * x,
                          const double * coordinate_dofs,
                          int cell_orientation) const final override
  {
    _evaluate_basis_all(values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_derivatives(std::size_t i,
                                          std::size_t n,
                                          double * values,
                                          const double * x,
                                          const double * coordinate_dofs,
                                          int cell_orientation)
  {
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    } // end loop over 'r'
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.0;
    } // end loop over 'r'
    
    // Call evaluate_basis if order of derivatives is equal to zero.
    if (n == 0)
    {
      _evaluate_basis(i, values, x, coordinate_dofs, cell_orientation);
      return ;
    }
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 1)
    {
    return ;
    }
    
    // Compute Jacobian
    double J[4];
    compute_jacobian_triangle_2d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[4];
    double detJ;
    compute_jacobian_inverse_triangle_2d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = coordinate_dofs[2] + coordinate_dofs[4];
    const double C1 = coordinate_dofs[3] + coordinate_dofs[5];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J[1]*(C1 - 2.0*x[1]) + J[3]*(2.0*x[0] - C0)) / detJ;
    double Y = (J[0]*(2.0*x[1] - C1) + J[2]*(C0 - 2.0*x[0])) / detJ;
    
    // Declare two dimensional array that holds combinations of derivatives and initialise
    unsigned int combinations[2][1];
    for (unsigned int row = 0; row < 2; row++)
    {
      for (unsigned int col = 0; col < 1; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 1)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[2][2] = {{K[0], K[1]}, {K[2], K[3]}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double transform[2][2];
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, -0.288675134594813, -0.166666666666667};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[3][3] = \
      {{0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0},
      {0.0, 0.0, 0.0}};
      
      static const double dmats1[3][3] = \
      {{0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[2];
      for (unsigned int r = 0; r < 2; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 3; t++)
        {
          for (unsigned int u = 0; u < 3; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 3; s++)
        {
          for (unsigned int t = 0; t < 3; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, 0.288675134594813, -0.166666666666667};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[3][3] = \
      {{0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0},
      {0.0, 0.0, 0.0}};
      
      static const double dmats1[3][3] = \
      {{0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[2];
      for (unsigned int r = 0; r < 2; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 3; t++)
        {
          for (unsigned int u = 0; u < 3; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 3; s++)
        {
          for (unsigned int t = 0; t < 3; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, 0.0, 0.333333333333333};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[3][3] = \
      {{0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0},
      {0.0, 0.0, 0.0}};
      
      static const double dmats1[3][3] = \
      {{0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[2];
      for (unsigned int r = 0; r < 2; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 3; t++)
        {
          for (unsigned int u = 0; u < 3; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 3; s++)
        {
          for (unsigned int t = 0; t < 3; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    }
    
  }

  void evaluate_basis_derivatives(std::size_t i,
                                  std::size_t n,
                                  double * values,
                                  const double * x,
                                  const double * coordinate_dofs,
                                  int cell_orientation) const final override
  {
    _evaluate_basis_derivatives(i, n, values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_derivatives_all(std::size_t n,
                                              double * values,
                                              const double * x,
                                              const double * coordinate_dofs,
                                              int cell_orientation)
  {
    // Call evaluate_basis_all if order of derivatives is equal to zero.
    if (n == 0)
    {
      _evaluate_basis_all(values, x, coordinate_dofs, cell_orientation);
      return ;
    }
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    } // end loop over 'r'
    
    // Set values equal to zero.
    for (unsigned int r = 0; r < 3; r++)
    {
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = 0.0;
      } // end loop over 's'
    } // end loop over 'r'
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 1)
    {
      return ;
    }
    
    // Helper variable to hold values of a single dof.
    double dof_values[2];
    for (unsigned int r = 0; r < 2; r++)
    {
      dof_values[r] = 0.0;
    } // end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 3; r++)
    {
      _evaluate_basis_derivatives(r, n, dof_values, x, coordinate_dofs, cell_orientation);
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = dof_values[s];
      } // end loop over 's'
    } // end loop over 'r'
  }

  void evaluate_basis_derivatives_all(std::size_t n,
                                      double * values,
                                      const double * x,
                                      const double * coordinate_dofs,
                                      int cell_orientation) const final override
  {
    _evaluate_basis_derivatives_all(n, values, x, coordinate_dofs, cell_orientation);
  }

  double evaluate_dof(std::size_t i,
                      const ufc::function& f,
                      const double * coordinate_dofs,
                      int cell_orientation,
                      const ufc::cell& c) const final override
  {
    // Declare variables for result of evaluation
    double vals[1];
    
    // Declare variable for physical coordinates
    double y[2];
    switch (i)
    {
    case 0:
      {
        y[0] = coordinate_dofs[0];
      y[1] = coordinate_dofs[1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = coordinate_dofs[2];
      y[1] = coordinate_dofs[3];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = coordinate_dofs[4];
      y[1] = coordinate_dofs[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.0;
  }

  void evaluate_dofs(double * values,
                             const ufc::function& f,
                             const double * coordinate_dofs,
                             int cell_orientation,
                             const ufc::cell& c) const final override
  {
    // Declare variables for result of evaluation
    double vals[1];
    
    // Declare variable for physical coordinates
    double y[2];
    y[0] = coordinate_dofs[0];
    y[1] = coordinate_dofs[1];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = coordinate_dofs[2];
    y[1] = coordinate_dofs[3];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = coordinate_dofs[4];
    y[1] = coordinate_dofs[5];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
  }

  void interpolate_vertex_values(double * vertex_values,
                                 const double * dof_values,
                                 const double * coordinate_dofs,
                                 int cell_orientation,
                                 const ufc::cell& c) const final override
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[1];
    vertex_values[2] = dof_values[2];
  }

  void tabulate_dof_coordinates(double * dof_coordinates,
                                const double * coordinate_dofs) const final override
  {
    dof_coordinates[0] = coordinate_dofs[0];
    dof_coordinates[1] = coordinate_dofs[1];
    dof_coordinates[2] = coordinate_dofs[2];
    dof_coordinates[3] = coordinate_dofs[3];
    dof_coordinates[4] = coordinate_dofs[4];
    dof_coordinates[5] = coordinate_dofs[5];
  }

  std::size_t num_sub_elements() const final override
  {
    return 0;
  }

  ufc::finite_element * create_sub_element(std::size_t i) const final override
  {
    return 0;
  }

  ufc::finite_element * create() const final override
  {
    return new adaptivepoisson_finite_element_0();
  }

};


class adaptivepoisson_finite_element_1: public ufc::finite_element
{
public:

  adaptivepoisson_finite_element_1() : ufc::finite_element()
  {
    // Do nothing
  }

  ~adaptivepoisson_finite_element_1() override
  {
    // Do nothing
  }

  const char * signature() const final override
  {
    return "VectorElement(FiniteElement('Lagrange', triangle, 1), dim=2)";
  }

  ufc::shape cell_shape() const final override
  {
    return ufc::shape::triangle;
  }

  std::size_t topological_dimension() const final override
  {
    return 2;
  }

  std::size_t geometric_dimension() const final override
  {
    return 2;
  }

  std::size_t space_dimension() const final override
  {
    return 6;
  }

  std::size_t value_rank() const final override
  {
    return 1;
  }

  std::size_t value_dimension(std::size_t i) const final override
  {
    switch (i)
    {
    case 0:
      {
        return 2;
        break;
      }
    }
    
    return 0;
  }

  std::size_t value_size() const final override
  {
    return 2;
  }

  std::size_t reference_value_rank() const final override
  {
    return 1;
  }

  std::size_t reference_value_dimension(std::size_t i) const final override
  {
    switch (i)
    {
    case 0:
      {
        return 2;
        break;
      }
    }
    
    return 0;
  }

  std::size_t reference_value_size() const final override
  {
    return 2;
  }

  std::size_t degree() const final override
  {
    return 1;
  }

  const char * family() const final override
  {
    return "Lagrange";
  }

  static void _evaluate_basis(std::size_t i,
                              double * values,
                              const double * x,
                              const double * coordinate_dofs,
                              int cell_orientation)
  {
    // Compute Jacobian
    double J[4];
    compute_jacobian_triangle_2d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[4];
    double detJ;
    compute_jacobian_inverse_triangle_2d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = coordinate_dofs[2] + coordinate_dofs[4];
    const double C1 = coordinate_dofs[3] + coordinate_dofs[5];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J[1]*(C1 - 2.0*x[1]) + J[3]*(2.0*x[0] - C0)) / detJ;
    double Y = (J[0]*(2.0*x[1] - C1) + J[2]*(C0 - 2.0*x[0])) / detJ;
    
    // Reset values
    values[0] = 0.0;
    values[1] = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, -0.288675134594813, -0.166666666666667};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 3; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, 0.288675134594813, -0.166666666666667};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 3; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, 0.0, 0.333333333333333};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 3; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, -0.288675134594813, -0.166666666666667};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 3; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, 0.288675134594813, -0.166666666666667};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 3; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, 0.0, 0.333333333333333};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 3; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    }
    
  }

  void evaluate_basis(std::size_t i,
                      double * values,
                      const double * x,
                      const double * coordinate_dofs,
                      int cell_orientation) const final override
  {
    _evaluate_basis(i, values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_all(double * values,
                                  const double * x,
                                  const double * coordinate_dofs,
                                  int cell_orientation)
  {
    // Helper variable to hold values of a single dof.
    double dof_values[2] = {0.0, 0.0};
    
    // Loop dofs and call evaluate_basis
    for (unsigned int r = 0; r < 6; r++)
    {
      _evaluate_basis(r, dof_values, x, coordinate_dofs, cell_orientation);
      for (unsigned int s = 0; s < 2; s++)
      {
        values[r*2 + s] = dof_values[s];
      } // end loop over 's'
    } // end loop over 'r'
  }

  void evaluate_basis_all(double * values,
                          const double * x,
                          const double * coordinate_dofs,
                          int cell_orientation) const final override
  {
    _evaluate_basis_all(values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_derivatives(std::size_t i,
                                          std::size_t n,
                                          double * values,
                                          const double * x,
                                          const double * coordinate_dofs,
                                          int cell_orientation)
  {
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    } // end loop over 'r'
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < 2*num_derivatives; r++)
    {
      values[r] = 0.0;
    } // end loop over 'r'
    
    // Call evaluate_basis if order of derivatives is equal to zero.
    if (n == 0)
    {
      _evaluate_basis(i, values, x, coordinate_dofs, cell_orientation);
      return ;
    }
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 1)
    {
    return ;
    }
    
    // Compute Jacobian
    double J[4];
    compute_jacobian_triangle_2d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[4];
    double detJ;
    compute_jacobian_inverse_triangle_2d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = coordinate_dofs[2] + coordinate_dofs[4];
    const double C1 = coordinate_dofs[3] + coordinate_dofs[5];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J[1]*(C1 - 2.0*x[1]) + J[3]*(2.0*x[0] - C0)) / detJ;
    double Y = (J[0]*(2.0*x[1] - C1) + J[2]*(C0 - 2.0*x[0])) / detJ;
    
    // Declare two dimensional array that holds combinations of derivatives and initialise
    unsigned int combinations[2][1];
    for (unsigned int row = 0; row < 2; row++)
    {
      for (unsigned int col = 0; col < 1; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 1)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[2][2] = {{K[0], K[1]}, {K[2], K[3]}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double transform[2][2];
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, -0.288675134594813, -0.166666666666667};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[3][3] = \
      {{0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0},
      {0.0, 0.0, 0.0}};
      
      static const double dmats1[3][3] = \
      {{0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[2];
      for (unsigned int r = 0; r < 2; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 3; t++)
        {
          for (unsigned int u = 0; u < 3; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 3; s++)
        {
          for (unsigned int t = 0; t < 3; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, 0.288675134594813, -0.166666666666667};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[3][3] = \
      {{0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0},
      {0.0, 0.0, 0.0}};
      
      static const double dmats1[3][3] = \
      {{0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[2];
      for (unsigned int r = 0; r < 2; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 3; t++)
        {
          for (unsigned int u = 0; u < 3; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 3; s++)
        {
          for (unsigned int t = 0; t < 3; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, 0.0, 0.333333333333333};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[3][3] = \
      {{0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0},
      {0.0, 0.0, 0.0}};
      
      static const double dmats1[3][3] = \
      {{0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[2];
      for (unsigned int r = 0; r < 2; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 3; t++)
        {
          for (unsigned int u = 0; u < 3; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 3; s++)
        {
          for (unsigned int t = 0; t < 3; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, -0.288675134594813, -0.166666666666667};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[3][3] = \
      {{0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0},
      {0.0, 0.0, 0.0}};
      
      static const double dmats1[3][3] = \
      {{0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[2];
      for (unsigned int r = 0; r < 2; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 3; t++)
        {
          for (unsigned int u = 0; u < 3; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 3; s++)
        {
          for (unsigned int t = 0; t < 3; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, 0.288675134594813, -0.166666666666667};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[3][3] = \
      {{0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0},
      {0.0, 0.0, 0.0}};
      
      static const double dmats1[3][3] = \
      {{0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[2];
      for (unsigned int r = 0; r < 2; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 3; t++)
        {
          for (unsigned int u = 0; u < 3; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 3; s++)
        {
          for (unsigned int t = 0; t < 3; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, 0.0, 0.333333333333333};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[3][3] = \
      {{0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0},
      {0.0, 0.0, 0.0}};
      
      static const double dmats1[3][3] = \
      {{0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[2];
      for (unsigned int r = 0; r < 2; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 3; t++)
        {
          for (unsigned int u = 0; u < 3; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 3; s++)
        {
          for (unsigned int t = 0; t < 3; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    }
    
  }

  void evaluate_basis_derivatives(std::size_t i,
                                  std::size_t n,
                                  double * values,
                                  const double * x,
                                  const double * coordinate_dofs,
                                  int cell_orientation) const final override
  {
    _evaluate_basis_derivatives(i, n, values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_derivatives_all(std::size_t n,
                                              double * values,
                                              const double * x,
                                              const double * coordinate_dofs,
                                              int cell_orientation)
  {
    // Call evaluate_basis_all if order of derivatives is equal to zero.
    if (n == 0)
    {
      _evaluate_basis_all(values, x, coordinate_dofs, cell_orientation);
      return ;
    }
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    } // end loop over 'r'
    
    // Set values equal to zero.
    for (unsigned int r = 0; r < 6; r++)
    {
      for (unsigned int s = 0; s < 2*num_derivatives; s++)
      {
        values[r*2*num_derivatives + s] = 0.0;
      } // end loop over 's'
    } // end loop over 'r'
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 1)
    {
      return ;
    }
    
    // Helper variable to hold values of a single dof.
    double dof_values[4];
    for (unsigned int r = 0; r < 4; r++)
    {
      dof_values[r] = 0.0;
    } // end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 6; r++)
    {
      _evaluate_basis_derivatives(r, n, dof_values, x, coordinate_dofs, cell_orientation);
      for (unsigned int s = 0; s < 2*num_derivatives; s++)
      {
        values[r*2*num_derivatives + s] = dof_values[s];
      } // end loop over 's'
    } // end loop over 'r'
  }

  void evaluate_basis_derivatives_all(std::size_t n,
                                      double * values,
                                      const double * x,
                                      const double * coordinate_dofs,
                                      int cell_orientation) const final override
  {
    _evaluate_basis_derivatives_all(n, values, x, coordinate_dofs, cell_orientation);
  }

  double evaluate_dof(std::size_t i,
                      const ufc::function& f,
                      const double * coordinate_dofs,
                      int cell_orientation,
                      const ufc::cell& c) const final override
  {
    // Declare variables for result of evaluation
    double vals[2];
    
    // Declare variable for physical coordinates
    double y[2];
    switch (i)
    {
    case 0:
      {
        y[0] = coordinate_dofs[0];
      y[1] = coordinate_dofs[1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = coordinate_dofs[2];
      y[1] = coordinate_dofs[3];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = coordinate_dofs[4];
      y[1] = coordinate_dofs[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = coordinate_dofs[0];
      y[1] = coordinate_dofs[1];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 4:
      {
        y[0] = coordinate_dofs[2];
      y[1] = coordinate_dofs[3];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 5:
      {
        y[0] = coordinate_dofs[4];
      y[1] = coordinate_dofs[5];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    }
    
    return 0.0;
  }

  void evaluate_dofs(double * values,
                             const ufc::function& f,
                             const double * coordinate_dofs,
                             int cell_orientation,
                             const ufc::cell& c) const final override
  {
    // Declare variables for result of evaluation
    double vals[2];
    
    // Declare variable for physical coordinates
    double y[2];
    y[0] = coordinate_dofs[0];
    y[1] = coordinate_dofs[1];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = coordinate_dofs[2];
    y[1] = coordinate_dofs[3];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = coordinate_dofs[4];
    y[1] = coordinate_dofs[5];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = coordinate_dofs[0];
    y[1] = coordinate_dofs[1];
    f.evaluate(vals, y, c);
    values[3] = vals[1];
    y[0] = coordinate_dofs[2];
    y[1] = coordinate_dofs[3];
    f.evaluate(vals, y, c);
    values[4] = vals[1];
    y[0] = coordinate_dofs[4];
    y[1] = coordinate_dofs[5];
    f.evaluate(vals, y, c);
    values[5] = vals[1];
  }

  void interpolate_vertex_values(double * vertex_values,
                                 const double * dof_values,
                                 const double * coordinate_dofs,
                                 int cell_orientation,
                                 const ufc::cell& c) const final override
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[2] = dof_values[1];
    vertex_values[4] = dof_values[2];
    // Evaluate function and change variables
    vertex_values[1] = dof_values[3];
    vertex_values[3] = dof_values[4];
    vertex_values[5] = dof_values[5];
  }

  void tabulate_dof_coordinates(double * dof_coordinates,
                                const double * coordinate_dofs) const final override
  {
    dof_coordinates[0] = coordinate_dofs[0];
    dof_coordinates[1] = coordinate_dofs[1];
    dof_coordinates[2] = coordinate_dofs[2];
    dof_coordinates[3] = coordinate_dofs[3];
    dof_coordinates[4] = coordinate_dofs[4];
    dof_coordinates[5] = coordinate_dofs[5];
    dof_coordinates[6] = coordinate_dofs[0];
    dof_coordinates[7] = coordinate_dofs[1];
    dof_coordinates[8] = coordinate_dofs[2];
    dof_coordinates[9] = coordinate_dofs[3];
    dof_coordinates[10] = coordinate_dofs[4];
    dof_coordinates[11] = coordinate_dofs[5];
  }

  std::size_t num_sub_elements() const final override
  {
    return 2;
  }

  ufc::finite_element * create_sub_element(std::size_t i) const final override
  {
    switch (i)
    {
    case 0:
      {
        return new adaptivepoisson_finite_element_0();
        break;
      }
    case 1:
      {
        return new adaptivepoisson_finite_element_0();
        break;
      }
    }
    
    return 0;
  }

  ufc::finite_element * create() const final override
  {
    return new adaptivepoisson_finite_element_1();
  }

};


class adaptivepoisson_finite_element_2: public ufc::finite_element
{
public:

  adaptivepoisson_finite_element_2() : ufc::finite_element()
  {
    // Do nothing
  }

  ~adaptivepoisson_finite_element_2() override
  {
    // Do nothing
  }

  const char * signature() const final override
  {
    return "FiniteElement('Lagrange', triangle, 2)";
  }

  ufc::shape cell_shape() const final override
  {
    return ufc::shape::triangle;
  }

  std::size_t topological_dimension() const final override
  {
    return 2;
  }

  std::size_t geometric_dimension() const final override
  {
    return 2;
  }

  std::size_t space_dimension() const final override
  {
    return 6;
  }

  std::size_t value_rank() const final override
  {
    return 0;
  }

  std::size_t value_dimension(std::size_t i) const final override
  {
    return 1;
  }

  std::size_t value_size() const final override
  {
    return 1;
  }

  std::size_t reference_value_rank() const final override
  {
    return 0;
  }

  std::size_t reference_value_dimension(std::size_t i) const final override
  {
    return 1;
  }

  std::size_t reference_value_size() const final override
  {
    return 1;
  }

  std::size_t degree() const final override
  {
    return 2;
  }

  const char * family() const final override
  {
    return "Lagrange";
  }

  static void _evaluate_basis(std::size_t i,
                              double * values,
                              const double * x,
                              const double * coordinate_dofs,
                              int cell_orientation)
  {
    // Compute Jacobian
    double J[4];
    compute_jacobian_triangle_2d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[4];
    double detJ;
    compute_jacobian_inverse_triangle_2d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = coordinate_dofs[2] + coordinate_dofs[4];
    const double C1 = coordinate_dofs[3] + coordinate_dofs[5];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J[1]*(C1 - 2.0*x[1]) + J[3]*(2.0*x[0] - C0)) / detJ;
    double Y = (J[0]*(2.0*x[1] - C1) + J[2]*(C0 - 2.0*x[0])) / detJ;
    
    // Reset values
    *values = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[6] = \
      {0.0, -0.173205080756888, -0.1, 0.121716123890037, 0.0942809041582063, 0.0544331053951817};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 6; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[6] = \
      {0.0, 0.173205080756888, -0.1, 0.121716123890037, -0.0942809041582064, 0.0544331053951818};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 6; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[6] = \
      {0.0, 0.0, 0.2, 0.0, 0.0, 0.163299316185545};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 6; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[6] = \
      {0.471404520791032, 0.23094010767585, 0.133333333333333, 0.0, 0.188561808316413, -0.163299316185545};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 6; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[6] = \
      {0.471404520791032, -0.23094010767585, 0.133333333333333, 0.0, -0.188561808316413, -0.163299316185545};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 6; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[6] = \
      {0.471404520791032, 0.0, -0.266666666666667, -0.243432247780074, 0.0, 0.0544331053951817};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 6; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    }
    
  }

  void evaluate_basis(std::size_t i,
                      double * values,
                      const double * x,
                      const double * coordinate_dofs,
                      int cell_orientation) const final override
  {
    _evaluate_basis(i, values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_all(double * values,
                                  const double * x,
                                  const double * coordinate_dofs,
                                  int cell_orientation)
  {
    // Helper variable to hold values of a single dof.
    double dof_values = 0.0;
    
    // Loop dofs and call evaluate_basis
    for (unsigned int r = 0; r < 6; r++)
    {
      _evaluate_basis(r, &dof_values, x, coordinate_dofs, cell_orientation);
      values[r] = dof_values;
    } // end loop over 'r'
  }

  void evaluate_basis_all(double * values,
                          const double * x,
                          const double * coordinate_dofs,
                          int cell_orientation) const final override
  {
    _evaluate_basis_all(values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_derivatives(std::size_t i,
                                          std::size_t n,
                                          double * values,
                                          const double * x,
                                          const double * coordinate_dofs,
                                          int cell_orientation)
  {
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    } // end loop over 'r'
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.0;
    } // end loop over 'r'
    
    // Call evaluate_basis if order of derivatives is equal to zero.
    if (n == 0)
    {
      _evaluate_basis(i, values, x, coordinate_dofs, cell_orientation);
      return ;
    }
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 2)
    {
    return ;
    }
    
    // Compute Jacobian
    double J[4];
    compute_jacobian_triangle_2d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[4];
    double detJ;
    compute_jacobian_inverse_triangle_2d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = coordinate_dofs[2] + coordinate_dofs[4];
    const double C1 = coordinate_dofs[3] + coordinate_dofs[5];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J[1]*(C1 - 2.0*x[1]) + J[3]*(2.0*x[0] - C0)) / detJ;
    double Y = (J[0]*(2.0*x[1] - C1) + J[2]*(C0 - 2.0*x[0])) / detJ;
    
    // Declare two dimensional array that holds combinations of derivatives and initialise
    unsigned int combinations[4][2];
    for (unsigned int row = 0; row < 4; row++)
    {
      for (unsigned int col = 0; col < 2; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 1)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[2][2] = {{K[0], K[1]}, {K[2], K[3]}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double transform[4][4];
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[6] = \
      {0.0, -0.173205080756888, -0.1, 0.121716123890037, 0.0942809041582063, 0.0544331053951817};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050515, 0.0, 0.0, 0.0, 0.0},
      {3.99999999999999, 0.0, 7.07106781186547, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747162, 4.74341649025257, -0.91287092917528, 0.0, 0.0, 0.0},
      {1.99999999999992, 6.12372435695794, 3.53553390593273, 0.0, 0.0, 0.0},
      {-2.30940107675849, 0.0, 8.16496580927727, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[4];
      for (unsigned int r = 0; r < 4; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[6] = \
      {0.0, 0.173205080756888, -0.1, 0.121716123890037, -0.0942809041582064, 0.0544331053951818};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050515, 0.0, 0.0, 0.0, 0.0},
      {3.99999999999999, 0.0, 7.07106781186547, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747162, 4.74341649025257, -0.91287092917528, 0.0, 0.0, 0.0},
      {1.99999999999992, 6.12372435695794, 3.53553390593273, 0.0, 0.0, 0.0},
      {-2.30940107675849, 0.0, 8.16496580927727, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[4];
      for (unsigned int r = 0; r < 4; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[6] = \
      {0.0, 0.0, 0.2, 0.0, 0.0, 0.163299316185545};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050515, 0.0, 0.0, 0.0, 0.0},
      {3.99999999999999, 0.0, 7.07106781186547, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747162, 4.74341649025257, -0.91287092917528, 0.0, 0.0, 0.0},
      {1.99999999999992, 6.12372435695794, 3.53553390593273, 0.0, 0.0, 0.0},
      {-2.30940107675849, 0.0, 8.16496580927727, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[4];
      for (unsigned int r = 0; r < 4; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[6] = \
      {0.471404520791032, 0.23094010767585, 0.133333333333333, 0.0, 0.188561808316413, -0.163299316185545};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050515, 0.0, 0.0, 0.0, 0.0},
      {3.99999999999999, 0.0, 7.07106781186547, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747162, 4.74341649025257, -0.91287092917528, 0.0, 0.0, 0.0},
      {1.99999999999992, 6.12372435695794, 3.53553390593273, 0.0, 0.0, 0.0},
      {-2.30940107675849, 0.0, 8.16496580927727, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[4];
      for (unsigned int r = 0; r < 4; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[6] = \
      {0.471404520791032, -0.23094010767585, 0.133333333333333, 0.0, -0.188561808316413, -0.163299316185545};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050515, 0.0, 0.0, 0.0, 0.0},
      {3.99999999999999, 0.0, 7.07106781186547, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747162, 4.74341649025257, -0.91287092917528, 0.0, 0.0, 0.0},
      {1.99999999999992, 6.12372435695794, 3.53553390593273, 0.0, 0.0, 0.0},
      {-2.30940107675849, 0.0, 8.16496580927727, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[4];
      for (unsigned int r = 0; r < 4; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[6] = \
      {0.471404520791032, 0.0, -0.266666666666667, -0.243432247780074, 0.0, 0.0544331053951817};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050515, 0.0, 0.0, 0.0, 0.0},
      {3.99999999999999, 0.0, 7.07106781186547, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747162, 4.74341649025257, -0.91287092917528, 0.0, 0.0, 0.0},
      {1.99999999999992, 6.12372435695794, 3.53553390593273, 0.0, 0.0, 0.0},
      {-2.30940107675849, 0.0, 8.16496580927727, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[4];
      for (unsigned int r = 0; r < 4; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    }
    
  }

  void evaluate_basis_derivatives(std::size_t i,
                                  std::size_t n,
                                  double * values,
                                  const double * x,
                                  const double * coordinate_dofs,
                                  int cell_orientation) const final override
  {
    _evaluate_basis_derivatives(i, n, values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_derivatives_all(std::size_t n,
                                              double * values,
                                              const double * x,
                                              const double * coordinate_dofs,
                                              int cell_orientation)
  {
    // Call evaluate_basis_all if order of derivatives is equal to zero.
    if (n == 0)
    {
      _evaluate_basis_all(values, x, coordinate_dofs, cell_orientation);
      return ;
    }
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    } // end loop over 'r'
    
    // Set values equal to zero.
    for (unsigned int r = 0; r < 6; r++)
    {
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = 0.0;
      } // end loop over 's'
    } // end loop over 'r'
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 2)
    {
      return ;
    }
    
    // Helper variable to hold values of a single dof.
    double dof_values[4];
    for (unsigned int r = 0; r < 4; r++)
    {
      dof_values[r] = 0.0;
    } // end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 6; r++)
    {
      _evaluate_basis_derivatives(r, n, dof_values, x, coordinate_dofs, cell_orientation);
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = dof_values[s];
      } // end loop over 's'
    } // end loop over 'r'
  }

  void evaluate_basis_derivatives_all(std::size_t n,
                                      double * values,
                                      const double * x,
                                      const double * coordinate_dofs,
                                      int cell_orientation) const final override
  {
    _evaluate_basis_derivatives_all(n, values, x, coordinate_dofs, cell_orientation);
  }

  double evaluate_dof(std::size_t i,
                      const ufc::function& f,
                      const double * coordinate_dofs,
                      int cell_orientation,
                      const ufc::cell& c) const final override
  {
    // Declare variables for result of evaluation
    double vals[1];
    
    // Declare variable for physical coordinates
    double y[2];
    switch (i)
    {
    case 0:
      {
        y[0] = coordinate_dofs[0];
      y[1] = coordinate_dofs[1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = coordinate_dofs[2];
      y[1] = coordinate_dofs[3];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = coordinate_dofs[4];
      y[1] = coordinate_dofs[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = 0.5*coordinate_dofs[2] + 0.5*coordinate_dofs[4];
      y[1] = 0.5*coordinate_dofs[3] + 0.5*coordinate_dofs[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 4:
      {
        y[0] = 0.5*coordinate_dofs[0] + 0.5*coordinate_dofs[4];
      y[1] = 0.5*coordinate_dofs[1] + 0.5*coordinate_dofs[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 5:
      {
        y[0] = 0.5*coordinate_dofs[0] + 0.5*coordinate_dofs[2];
      y[1] = 0.5*coordinate_dofs[1] + 0.5*coordinate_dofs[3];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.0;
  }

  void evaluate_dofs(double * values,
                             const ufc::function& f,
                             const double * coordinate_dofs,
                             int cell_orientation,
                             const ufc::cell& c) const final override
  {
    // Declare variables for result of evaluation
    double vals[1];
    
    // Declare variable for physical coordinates
    double y[2];
    y[0] = coordinate_dofs[0];
    y[1] = coordinate_dofs[1];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = coordinate_dofs[2];
    y[1] = coordinate_dofs[3];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = coordinate_dofs[4];
    y[1] = coordinate_dofs[5];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = 0.5*coordinate_dofs[2] + 0.5*coordinate_dofs[4];
    y[1] = 0.5*coordinate_dofs[3] + 0.5*coordinate_dofs[5];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
    y[0] = 0.5*coordinate_dofs[0] + 0.5*coordinate_dofs[4];
    y[1] = 0.5*coordinate_dofs[1] + 0.5*coordinate_dofs[5];
    f.evaluate(vals, y, c);
    values[4] = vals[0];
    y[0] = 0.5*coordinate_dofs[0] + 0.5*coordinate_dofs[2];
    y[1] = 0.5*coordinate_dofs[1] + 0.5*coordinate_dofs[3];
    f.evaluate(vals, y, c);
    values[5] = vals[0];
  }

  void interpolate_vertex_values(double * vertex_values,
                                 const double * dof_values,
                                 const double * coordinate_dofs,
                                 int cell_orientation,
                                 const ufc::cell& c) const final override
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[1];
    vertex_values[2] = dof_values[2];
  }

  void tabulate_dof_coordinates(double * dof_coordinates,
                                const double * coordinate_dofs) const final override
  {
    dof_coordinates[0] = coordinate_dofs[0];
    dof_coordinates[1] = coordinate_dofs[1];
    dof_coordinates[2] = coordinate_dofs[2];
    dof_coordinates[3] = coordinate_dofs[3];
    dof_coordinates[4] = coordinate_dofs[4];
    dof_coordinates[5] = coordinate_dofs[5];
    dof_coordinates[6] = 0.5*coordinate_dofs[2] + 0.5*coordinate_dofs[4];
    dof_coordinates[7] = 0.5*coordinate_dofs[3] + 0.5*coordinate_dofs[5];
    dof_coordinates[8] = 0.5*coordinate_dofs[0] + 0.5*coordinate_dofs[4];
    dof_coordinates[9] = 0.5*coordinate_dofs[1] + 0.5*coordinate_dofs[5];
    dof_coordinates[10] = 0.5*coordinate_dofs[0] + 0.5*coordinate_dofs[2];
    dof_coordinates[11] = 0.5*coordinate_dofs[1] + 0.5*coordinate_dofs[3];
  }

  std::size_t num_sub_elements() const final override
  {
    return 0;
  }

  ufc::finite_element * create_sub_element(std::size_t i) const final override
  {
    return 0;
  }

  ufc::finite_element * create() const final override
  {
    return new adaptivepoisson_finite_element_2();
  }

};


class adaptivepoisson_finite_element_3: public ufc::finite_element
{
public:

  adaptivepoisson_finite_element_3() : ufc::finite_element()
  {
    // Do nothing
  }

  ~adaptivepoisson_finite_element_3() override
  {
    // Do nothing
  }

  const char * signature() const final override
  {
    return "FiniteElement('Discontinuous Lagrange', triangle, 2)";
  }

  ufc::shape cell_shape() const final override
  {
    return ufc::shape::triangle;
  }

  std::size_t topological_dimension() const final override
  {
    return 2;
  }

  std::size_t geometric_dimension() const final override
  {
    return 2;
  }

  std::size_t space_dimension() const final override
  {
    return 6;
  }

  std::size_t value_rank() const final override
  {
    return 0;
  }

  std::size_t value_dimension(std::size_t i) const final override
  {
    return 1;
  }

  std::size_t value_size() const final override
  {
    return 1;
  }

  std::size_t reference_value_rank() const final override
  {
    return 0;
  }

  std::size_t reference_value_dimension(std::size_t i) const final override
  {
    return 1;
  }

  std::size_t reference_value_size() const final override
  {
    return 1;
  }

  std::size_t degree() const final override
  {
    return 2;
  }

  const char * family() const final override
  {
    return "Discontinuous Lagrange";
  }

  static void _evaluate_basis(std::size_t i,
                              double * values,
                              const double * x,
                              const double * coordinate_dofs,
                              int cell_orientation)
  {
    // Compute Jacobian
    double J[4];
    compute_jacobian_triangle_2d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[4];
    double detJ;
    compute_jacobian_inverse_triangle_2d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = coordinate_dofs[2] + coordinate_dofs[4];
    const double C1 = coordinate_dofs[3] + coordinate_dofs[5];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J[1]*(C1 - 2.0*x[1]) + J[3]*(2.0*x[0] - C0)) / detJ;
    double Y = (J[0]*(2.0*x[1] - C1) + J[2]*(C0 - 2.0*x[0])) / detJ;
    
    // Reset values
    *values = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[6] = \
      {0.0, -0.173205080756888, -0.1, 0.121716123890037, 0.0942809041582063, 0.0544331053951817};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 6; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[6] = \
      {0.0, 0.173205080756888, -0.1, 0.121716123890037, -0.0942809041582064, 0.0544331053951818};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 6; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[6] = \
      {0.0, 0.0, 0.2, 0.0, 0.0, 0.163299316185545};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 6; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[6] = \
      {0.471404520791032, 0.23094010767585, 0.133333333333333, 0.0, 0.188561808316413, -0.163299316185545};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 6; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[6] = \
      {0.471404520791032, -0.23094010767585, 0.133333333333333, 0.0, -0.188561808316413, -0.163299316185545};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 6; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[6] = \
      {0.471404520791032, 0.0, -0.266666666666667, -0.243432247780074, 0.0, 0.0544331053951817};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 6; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    }
    
  }

  void evaluate_basis(std::size_t i,
                      double * values,
                      const double * x,
                      const double * coordinate_dofs,
                      int cell_orientation) const final override
  {
    _evaluate_basis(i, values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_all(double * values,
                                  const double * x,
                                  const double * coordinate_dofs,
                                  int cell_orientation)
  {
    // Helper variable to hold values of a single dof.
    double dof_values = 0.0;
    
    // Loop dofs and call evaluate_basis
    for (unsigned int r = 0; r < 6; r++)
    {
      _evaluate_basis(r, &dof_values, x, coordinate_dofs, cell_orientation);
      values[r] = dof_values;
    } // end loop over 'r'
  }

  void evaluate_basis_all(double * values,
                          const double * x,
                          const double * coordinate_dofs,
                          int cell_orientation) const final override
  {
    _evaluate_basis_all(values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_derivatives(std::size_t i,
                                          std::size_t n,
                                          double * values,
                                          const double * x,
                                          const double * coordinate_dofs,
                                          int cell_orientation)
  {
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    } // end loop over 'r'
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.0;
    } // end loop over 'r'
    
    // Call evaluate_basis if order of derivatives is equal to zero.
    if (n == 0)
    {
      _evaluate_basis(i, values, x, coordinate_dofs, cell_orientation);
      return ;
    }
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 2)
    {
    return ;
    }
    
    // Compute Jacobian
    double J[4];
    compute_jacobian_triangle_2d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[4];
    double detJ;
    compute_jacobian_inverse_triangle_2d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = coordinate_dofs[2] + coordinate_dofs[4];
    const double C1 = coordinate_dofs[3] + coordinate_dofs[5];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J[1]*(C1 - 2.0*x[1]) + J[3]*(2.0*x[0] - C0)) / detJ;
    double Y = (J[0]*(2.0*x[1] - C1) + J[2]*(C0 - 2.0*x[0])) / detJ;
    
    // Declare two dimensional array that holds combinations of derivatives and initialise
    unsigned int combinations[4][2];
    for (unsigned int row = 0; row < 4; row++)
    {
      for (unsigned int col = 0; col < 2; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 1)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[2][2] = {{K[0], K[1]}, {K[2], K[3]}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double transform[4][4];
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[6] = \
      {0.0, -0.173205080756888, -0.1, 0.121716123890037, 0.0942809041582063, 0.0544331053951817};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050515, 0.0, 0.0, 0.0, 0.0},
      {3.99999999999999, 0.0, 7.07106781186547, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747162, 4.74341649025257, -0.91287092917528, 0.0, 0.0, 0.0},
      {1.99999999999992, 6.12372435695794, 3.53553390593273, 0.0, 0.0, 0.0},
      {-2.30940107675849, 0.0, 8.16496580927727, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[4];
      for (unsigned int r = 0; r < 4; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[6] = \
      {0.0, 0.173205080756888, -0.1, 0.121716123890037, -0.0942809041582064, 0.0544331053951818};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050515, 0.0, 0.0, 0.0, 0.0},
      {3.99999999999999, 0.0, 7.07106781186547, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747162, 4.74341649025257, -0.91287092917528, 0.0, 0.0, 0.0},
      {1.99999999999992, 6.12372435695794, 3.53553390593273, 0.0, 0.0, 0.0},
      {-2.30940107675849, 0.0, 8.16496580927727, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[4];
      for (unsigned int r = 0; r < 4; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[6] = \
      {0.0, 0.0, 0.2, 0.0, 0.0, 0.163299316185545};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050515, 0.0, 0.0, 0.0, 0.0},
      {3.99999999999999, 0.0, 7.07106781186547, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747162, 4.74341649025257, -0.91287092917528, 0.0, 0.0, 0.0},
      {1.99999999999992, 6.12372435695794, 3.53553390593273, 0.0, 0.0, 0.0},
      {-2.30940107675849, 0.0, 8.16496580927727, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[4];
      for (unsigned int r = 0; r < 4; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[6] = \
      {0.471404520791032, 0.23094010767585, 0.133333333333333, 0.0, 0.188561808316413, -0.163299316185545};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050515, 0.0, 0.0, 0.0, 0.0},
      {3.99999999999999, 0.0, 7.07106781186547, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747162, 4.74341649025257, -0.91287092917528, 0.0, 0.0, 0.0},
      {1.99999999999992, 6.12372435695794, 3.53553390593273, 0.0, 0.0, 0.0},
      {-2.30940107675849, 0.0, 8.16496580927727, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[4];
      for (unsigned int r = 0; r < 4; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[6] = \
      {0.471404520791032, -0.23094010767585, 0.133333333333333, 0.0, -0.188561808316413, -0.163299316185545};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050515, 0.0, 0.0, 0.0, 0.0},
      {3.99999999999999, 0.0, 7.07106781186547, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747162, 4.74341649025257, -0.91287092917528, 0.0, 0.0, 0.0},
      {1.99999999999992, 6.12372435695794, 3.53553390593273, 0.0, 0.0, 0.0},
      {-2.30940107675849, 0.0, 8.16496580927727, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[4];
      for (unsigned int r = 0; r < 4; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[6] = \
      {0.471404520791032, 0.0, -0.266666666666667, -0.243432247780074, 0.0, 0.0544331053951817};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050515, 0.0, 0.0, 0.0, 0.0},
      {3.99999999999999, 0.0, 7.07106781186547, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747162, 4.74341649025257, -0.91287092917528, 0.0, 0.0, 0.0},
      {1.99999999999992, 6.12372435695794, 3.53553390593273, 0.0, 0.0, 0.0},
      {-2.30940107675849, 0.0, 8.16496580927727, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[4];
      for (unsigned int r = 0; r < 4; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    }
    
  }

  void evaluate_basis_derivatives(std::size_t i,
                                  std::size_t n,
                                  double * values,
                                  const double * x,
                                  const double * coordinate_dofs,
                                  int cell_orientation) const final override
  {
    _evaluate_basis_derivatives(i, n, values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_derivatives_all(std::size_t n,
                                              double * values,
                                              const double * x,
                                              const double * coordinate_dofs,
                                              int cell_orientation)
  {
    // Call evaluate_basis_all if order of derivatives is equal to zero.
    if (n == 0)
    {
      _evaluate_basis_all(values, x, coordinate_dofs, cell_orientation);
      return ;
    }
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    } // end loop over 'r'
    
    // Set values equal to zero.
    for (unsigned int r = 0; r < 6; r++)
    {
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = 0.0;
      } // end loop over 's'
    } // end loop over 'r'
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 2)
    {
      return ;
    }
    
    // Helper variable to hold values of a single dof.
    double dof_values[4];
    for (unsigned int r = 0; r < 4; r++)
    {
      dof_values[r] = 0.0;
    } // end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 6; r++)
    {
      _evaluate_basis_derivatives(r, n, dof_values, x, coordinate_dofs, cell_orientation);
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = dof_values[s];
      } // end loop over 's'
    } // end loop over 'r'
  }

  void evaluate_basis_derivatives_all(std::size_t n,
                                      double * values,
                                      const double * x,
                                      const double * coordinate_dofs,
                                      int cell_orientation) const final override
  {
    _evaluate_basis_derivatives_all(n, values, x, coordinate_dofs, cell_orientation);
  }

  double evaluate_dof(std::size_t i,
                      const ufc::function& f,
                      const double * coordinate_dofs,
                      int cell_orientation,
                      const ufc::cell& c) const final override
  {
    // Declare variables for result of evaluation
    double vals[1];
    
    // Declare variable for physical coordinates
    double y[2];
    switch (i)
    {
    case 0:
      {
        y[0] = coordinate_dofs[0];
      y[1] = coordinate_dofs[1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = coordinate_dofs[2];
      y[1] = coordinate_dofs[3];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = coordinate_dofs[4];
      y[1] = coordinate_dofs[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = 0.5*coordinate_dofs[2] + 0.5*coordinate_dofs[4];
      y[1] = 0.5*coordinate_dofs[3] + 0.5*coordinate_dofs[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 4:
      {
        y[0] = 0.5*coordinate_dofs[0] + 0.5*coordinate_dofs[4];
      y[1] = 0.5*coordinate_dofs[1] + 0.5*coordinate_dofs[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 5:
      {
        y[0] = 0.5*coordinate_dofs[0] + 0.5*coordinate_dofs[2];
      y[1] = 0.5*coordinate_dofs[1] + 0.5*coordinate_dofs[3];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.0;
  }

  void evaluate_dofs(double * values,
                             const ufc::function& f,
                             const double * coordinate_dofs,
                             int cell_orientation,
                             const ufc::cell& c) const final override
  {
    // Declare variables for result of evaluation
    double vals[1];
    
    // Declare variable for physical coordinates
    double y[2];
    y[0] = coordinate_dofs[0];
    y[1] = coordinate_dofs[1];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = coordinate_dofs[2];
    y[1] = coordinate_dofs[3];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = coordinate_dofs[4];
    y[1] = coordinate_dofs[5];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = 0.5*coordinate_dofs[2] + 0.5*coordinate_dofs[4];
    y[1] = 0.5*coordinate_dofs[3] + 0.5*coordinate_dofs[5];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
    y[0] = 0.5*coordinate_dofs[0] + 0.5*coordinate_dofs[4];
    y[1] = 0.5*coordinate_dofs[1] + 0.5*coordinate_dofs[5];
    f.evaluate(vals, y, c);
    values[4] = vals[0];
    y[0] = 0.5*coordinate_dofs[0] + 0.5*coordinate_dofs[2];
    y[1] = 0.5*coordinate_dofs[1] + 0.5*coordinate_dofs[3];
    f.evaluate(vals, y, c);
    values[5] = vals[0];
  }

  void interpolate_vertex_values(double * vertex_values,
                                 const double * dof_values,
                                 const double * coordinate_dofs,
                                 int cell_orientation,
                                 const ufc::cell& c) const final override
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[1];
    vertex_values[2] = dof_values[2];
  }

  void tabulate_dof_coordinates(double * dof_coordinates,
                                const double * coordinate_dofs) const final override
  {
    dof_coordinates[0] = coordinate_dofs[0];
    dof_coordinates[1] = coordinate_dofs[1];
    dof_coordinates[2] = coordinate_dofs[2];
    dof_coordinates[3] = coordinate_dofs[3];
    dof_coordinates[4] = coordinate_dofs[4];
    dof_coordinates[5] = coordinate_dofs[5];
    dof_coordinates[6] = 0.5*coordinate_dofs[2] + 0.5*coordinate_dofs[4];
    dof_coordinates[7] = 0.5*coordinate_dofs[3] + 0.5*coordinate_dofs[5];
    dof_coordinates[8] = 0.5*coordinate_dofs[0] + 0.5*coordinate_dofs[4];
    dof_coordinates[9] = 0.5*coordinate_dofs[1] + 0.5*coordinate_dofs[5];
    dof_coordinates[10] = 0.5*coordinate_dofs[0] + 0.5*coordinate_dofs[2];
    dof_coordinates[11] = 0.5*coordinate_dofs[1] + 0.5*coordinate_dofs[3];
  }

  std::size_t num_sub_elements() const final override
  {
    return 0;
  }

  ufc::finite_element * create_sub_element(std::size_t i) const final override
  {
    return 0;
  }

  ufc::finite_element * create() const final override
  {
    return new adaptivepoisson_finite_element_3();
  }

};


class adaptivepoisson_finite_element_4: public ufc::finite_element
{
public:

  adaptivepoisson_finite_element_4() : ufc::finite_element()
  {
    // Do nothing
  }

  ~adaptivepoisson_finite_element_4() override
  {
    // Do nothing
  }

  const char * signature() const final override
  {
    return "FiniteElement('Discontinuous Lagrange', triangle, 1)";
  }

  ufc::shape cell_shape() const final override
  {
    return ufc::shape::triangle;
  }

  std::size_t topological_dimension() const final override
  {
    return 2;
  }

  std::size_t geometric_dimension() const final override
  {
    return 2;
  }

  std::size_t space_dimension() const final override
  {
    return 3;
  }

  std::size_t value_rank() const final override
  {
    return 0;
  }

  std::size_t value_dimension(std::size_t i) const final override
  {
    return 1;
  }

  std::size_t value_size() const final override
  {
    return 1;
  }

  std::size_t reference_value_rank() const final override
  {
    return 0;
  }

  std::size_t reference_value_dimension(std::size_t i) const final override
  {
    return 1;
  }

  std::size_t reference_value_size() const final override
  {
    return 1;
  }

  std::size_t degree() const final override
  {
    return 1;
  }

  const char * family() const final override
  {
    return "Discontinuous Lagrange";
  }

  static void _evaluate_basis(std::size_t i,
                              double * values,
                              const double * x,
                              const double * coordinate_dofs,
                              int cell_orientation)
  {
    // Compute Jacobian
    double J[4];
    compute_jacobian_triangle_2d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[4];
    double detJ;
    compute_jacobian_inverse_triangle_2d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = coordinate_dofs[2] + coordinate_dofs[4];
    const double C1 = coordinate_dofs[3] + coordinate_dofs[5];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J[1]*(C1 - 2.0*x[1]) + J[3]*(2.0*x[0] - C0)) / detJ;
    double Y = (J[0]*(2.0*x[1] - C1) + J[2]*(C0 - 2.0*x[0])) / detJ;
    
    // Reset values
    *values = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, -0.288675134594813, -0.166666666666667};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 3; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, 0.288675134594813, -0.166666666666667};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 3; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, 0.0, 0.333333333333333};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 3; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    }
    
  }

  void evaluate_basis(std::size_t i,
                      double * values,
                      const double * x,
                      const double * coordinate_dofs,
                      int cell_orientation) const final override
  {
    _evaluate_basis(i, values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_all(double * values,
                                  const double * x,
                                  const double * coordinate_dofs,
                                  int cell_orientation)
  {
    // Helper variable to hold values of a single dof.
    double dof_values = 0.0;
    
    // Loop dofs and call evaluate_basis
    for (unsigned int r = 0; r < 3; r++)
    {
      _evaluate_basis(r, &dof_values, x, coordinate_dofs, cell_orientation);
      values[r] = dof_values;
    } // end loop over 'r'
  }

  void evaluate_basis_all(double * values,
                          const double * x,
                          const double * coordinate_dofs,
                          int cell_orientation) const final override
  {
    _evaluate_basis_all(values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_derivatives(std::size_t i,
                                          std::size_t n,
                                          double * values,
                                          const double * x,
                                          const double * coordinate_dofs,
                                          int cell_orientation)
  {
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    } // end loop over 'r'
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.0;
    } // end loop over 'r'
    
    // Call evaluate_basis if order of derivatives is equal to zero.
    if (n == 0)
    {
      _evaluate_basis(i, values, x, coordinate_dofs, cell_orientation);
      return ;
    }
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 1)
    {
    return ;
    }
    
    // Compute Jacobian
    double J[4];
    compute_jacobian_triangle_2d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[4];
    double detJ;
    compute_jacobian_inverse_triangle_2d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = coordinate_dofs[2] + coordinate_dofs[4];
    const double C1 = coordinate_dofs[3] + coordinate_dofs[5];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J[1]*(C1 - 2.0*x[1]) + J[3]*(2.0*x[0] - C0)) / detJ;
    double Y = (J[0]*(2.0*x[1] - C1) + J[2]*(C0 - 2.0*x[0])) / detJ;
    
    // Declare two dimensional array that holds combinations of derivatives and initialise
    unsigned int combinations[2][1];
    for (unsigned int row = 0; row < 2; row++)
    {
      for (unsigned int col = 0; col < 1; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 1)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[2][2] = {{K[0], K[1]}, {K[2], K[3]}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double transform[2][2];
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, -0.288675134594813, -0.166666666666667};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[3][3] = \
      {{0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0},
      {0.0, 0.0, 0.0}};
      
      static const double dmats1[3][3] = \
      {{0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[2];
      for (unsigned int r = 0; r < 2; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 3; t++)
        {
          for (unsigned int u = 0; u < 3; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 3; s++)
        {
          for (unsigned int t = 0; t < 3; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, 0.288675134594813, -0.166666666666667};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[3][3] = \
      {{0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0},
      {0.0, 0.0, 0.0}};
      
      static const double dmats1[3][3] = \
      {{0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[2];
      for (unsigned int r = 0; r < 2; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 3; t++)
        {
          for (unsigned int u = 0; u < 3; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 3; s++)
        {
          for (unsigned int t = 0; t < 3; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, 0.0, 0.333333333333333};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[3][3] = \
      {{0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0},
      {0.0, 0.0, 0.0}};
      
      static const double dmats1[3][3] = \
      {{0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[2];
      for (unsigned int r = 0; r < 2; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 3; t++)
        {
          for (unsigned int u = 0; u < 3; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 3; s++)
        {
          for (unsigned int t = 0; t < 3; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    }
    
  }

  void evaluate_basis_derivatives(std::size_t i,
                                  std::size_t n,
                                  double * values,
                                  const double * x,
                                  const double * coordinate_dofs,
                                  int cell_orientation) const final override
  {
    _evaluate_basis_derivatives(i, n, values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_derivatives_all(std::size_t n,
                                              double * values,
                                              const double * x,
                                              const double * coordinate_dofs,
                                              int cell_orientation)
  {
    // Call evaluate_basis_all if order of derivatives is equal to zero.
    if (n == 0)
    {
      _evaluate_basis_all(values, x, coordinate_dofs, cell_orientation);
      return ;
    }
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    } // end loop over 'r'
    
    // Set values equal to zero.
    for (unsigned int r = 0; r < 3; r++)
    {
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = 0.0;
      } // end loop over 's'
    } // end loop over 'r'
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 1)
    {
      return ;
    }
    
    // Helper variable to hold values of a single dof.
    double dof_values[2];
    for (unsigned int r = 0; r < 2; r++)
    {
      dof_values[r] = 0.0;
    } // end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 3; r++)
    {
      _evaluate_basis_derivatives(r, n, dof_values, x, coordinate_dofs, cell_orientation);
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = dof_values[s];
      } // end loop over 's'
    } // end loop over 'r'
  }

  void evaluate_basis_derivatives_all(std::size_t n,
                                      double * values,
                                      const double * x,
                                      const double * coordinate_dofs,
                                      int cell_orientation) const final override
  {
    _evaluate_basis_derivatives_all(n, values, x, coordinate_dofs, cell_orientation);
  }

  double evaluate_dof(std::size_t i,
                      const ufc::function& f,
                      const double * coordinate_dofs,
                      int cell_orientation,
                      const ufc::cell& c) const final override
  {
    // Declare variables for result of evaluation
    double vals[1];
    
    // Declare variable for physical coordinates
    double y[2];
    switch (i)
    {
    case 0:
      {
        y[0] = coordinate_dofs[0];
      y[1] = coordinate_dofs[1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = coordinate_dofs[2];
      y[1] = coordinate_dofs[3];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = coordinate_dofs[4];
      y[1] = coordinate_dofs[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.0;
  }

  void evaluate_dofs(double * values,
                             const ufc::function& f,
                             const double * coordinate_dofs,
                             int cell_orientation,
                             const ufc::cell& c) const final override
  {
    // Declare variables for result of evaluation
    double vals[1];
    
    // Declare variable for physical coordinates
    double y[2];
    y[0] = coordinate_dofs[0];
    y[1] = coordinate_dofs[1];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = coordinate_dofs[2];
    y[1] = coordinate_dofs[3];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = coordinate_dofs[4];
    y[1] = coordinate_dofs[5];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
  }

  void interpolate_vertex_values(double * vertex_values,
                                 const double * dof_values,
                                 const double * coordinate_dofs,
                                 int cell_orientation,
                                 const ufc::cell& c) const final override
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[1];
    vertex_values[2] = dof_values[2];
  }

  void tabulate_dof_coordinates(double * dof_coordinates,
                                const double * coordinate_dofs) const final override
  {
    dof_coordinates[0] = coordinate_dofs[0];
    dof_coordinates[1] = coordinate_dofs[1];
    dof_coordinates[2] = coordinate_dofs[2];
    dof_coordinates[3] = coordinate_dofs[3];
    dof_coordinates[4] = coordinate_dofs[4];
    dof_coordinates[5] = coordinate_dofs[5];
  }

  std::size_t num_sub_elements() const final override
  {
    return 0;
  }

  ufc::finite_element * create_sub_element(std::size_t i) const final override
  {
    return 0;
  }

  ufc::finite_element * create() const final override
  {
    return new adaptivepoisson_finite_element_4();
  }

};


class adaptivepoisson_finite_element_5: public ufc::finite_element
{
public:

  adaptivepoisson_finite_element_5() : ufc::finite_element()
  {
    // Do nothing
  }

  ~adaptivepoisson_finite_element_5() override
  {
    // Do nothing
  }

  const char * signature() const final override
  {
    return "FiniteElement('Discontinuous Lagrange', triangle, 0)";
  }

  ufc::shape cell_shape() const final override
  {
    return ufc::shape::triangle;
  }

  std::size_t topological_dimension() const final override
  {
    return 2;
  }

  std::size_t geometric_dimension() const final override
  {
    return 2;
  }

  std::size_t space_dimension() const final override
  {
    return 1;
  }

  std::size_t value_rank() const final override
  {
    return 0;
  }

  std::size_t value_dimension(std::size_t i) const final override
  {
    return 1;
  }

  std::size_t value_size() const final override
  {
    return 1;
  }

  std::size_t reference_value_rank() const final override
  {
    return 0;
  }

  std::size_t reference_value_dimension(std::size_t i) const final override
  {
    return 1;
  }

  std::size_t reference_value_size() const final override
  {
    return 1;
  }

  std::size_t degree() const final override
  {
    return 0;
  }

  const char * family() const final override
  {
    return "Discontinuous Lagrange";
  }

  static void _evaluate_basis(std::size_t i,
                              double * values,
                              const double * x,
                              const double * coordinate_dofs,
                              int cell_orientation)
  {
    // Compute Jacobian
    double J[4];
    compute_jacobian_triangle_2d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[4];
    double detJ;
    compute_jacobian_inverse_triangle_2d(K, detJ, J);
    
    
    // Compute constants
    
    // Get coordinates and map to the reference (FIAT) element
    
    // Reset values
    *values = 0.0;
    
    // Array of basisvalues
    double basisvalues[1] = {0.0};
    
    // Declare helper variables
    
    // Compute basisvalues
    basisvalues[0] = 1.0;
    
    // Table(s) of coefficients
    static const double coefficients0[1] = \
    {1.0};
    
    // Compute value(s)
    for (unsigned int r = 0; r < 1; r++)
    {
      *values += coefficients0[r]*basisvalues[r];
    } // end loop over 'r'
  }

  void evaluate_basis(std::size_t i,
                      double * values,
                      const double * x,
                      const double * coordinate_dofs,
                      int cell_orientation) const final override
  {
    _evaluate_basis(i, values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_all(double * values,
                                  const double * x,
                                  const double * coordinate_dofs,
                                  int cell_orientation)
  {
    // Element is constant, calling evaluate_basis.
    _evaluate_basis(0, values, x, coordinate_dofs, cell_orientation);
  }

  void evaluate_basis_all(double * values,
                          const double * x,
                          const double * coordinate_dofs,
                          int cell_orientation) const final override
  {
    _evaluate_basis_all(values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_derivatives(std::size_t i,
                                          std::size_t n,
                                          double * values,
                                          const double * x,
                                          const double * coordinate_dofs,
                                          int cell_orientation)
  {
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    } // end loop over 'r'
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.0;
    } // end loop over 'r'
    
    // Call evaluate_basis if order of derivatives is equal to zero.
    if (n == 0)
    {
      _evaluate_basis(i, values, x, coordinate_dofs, cell_orientation);
      return ;
    }
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 0)
    {
    return ;
    }
    
  }

  void evaluate_basis_derivatives(std::size_t i,
                                  std::size_t n,
                                  double * values,
                                  const double * x,
                                  const double * coordinate_dofs,
                                  int cell_orientation) const final override
  {
    _evaluate_basis_derivatives(i, n, values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_derivatives_all(std::size_t n,
                                              double * values,
                                              const double * x,
                                              const double * coordinate_dofs,
                                              int cell_orientation)
  {
    // Element is constant, calling evaluate_basis_derivatives.
    _evaluate_basis_derivatives(0, n, values, x, coordinate_dofs, cell_orientation);
  }

  void evaluate_basis_derivatives_all(std::size_t n,
                                      double * values,
                                      const double * x,
                                      const double * coordinate_dofs,
                                      int cell_orientation) const final override
  {
    _evaluate_basis_derivatives_all(n, values, x, coordinate_dofs, cell_orientation);
  }

  double evaluate_dof(std::size_t i,
                      const ufc::function& f,
                      const double * coordinate_dofs,
                      int cell_orientation,
                      const ufc::cell& c) const final override
  {
    // Declare variables for result of evaluation
    double vals[1];
    
    // Declare variable for physical coordinates
    double y[2];
    switch (i)
    {
    case 0:
      {
        y[0] = 0.333333333333333*coordinate_dofs[0] + 0.333333333333333*coordinate_dofs[2] + 0.333333333333333*coordinate_dofs[4];
      y[1] = 0.333333333333333*coordinate_dofs[1] + 0.333333333333333*coordinate_dofs[3] + 0.333333333333333*coordinate_dofs[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.0;
  }

  void evaluate_dofs(double * values,
                             const ufc::function& f,
                             const double * coordinate_dofs,
                             int cell_orientation,
                             const ufc::cell& c) const final override
  {
    // Declare variables for result of evaluation
    double vals[1];
    
    // Declare variable for physical coordinates
    double y[2];
    y[0] = 0.333333333333333*coordinate_dofs[0] + 0.333333333333333*coordinate_dofs[2] + 0.333333333333333*coordinate_dofs[4];
    y[1] = 0.333333333333333*coordinate_dofs[1] + 0.333333333333333*coordinate_dofs[3] + 0.333333333333333*coordinate_dofs[5];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
  }

  void interpolate_vertex_values(double * vertex_values,
                                 const double * dof_values,
                                 const double * coordinate_dofs,
                                 int cell_orientation,
                                 const ufc::cell& c) const final override
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[0];
    vertex_values[2] = dof_values[0];
  }

  void tabulate_dof_coordinates(double * dof_coordinates,
                                const double * coordinate_dofs) const final override
  {
    dof_coordinates[0] = 0.333333333333333*coordinate_dofs[0] + 0.333333333333333*coordinate_dofs[2] + 0.333333333333333*coordinate_dofs[4];
    dof_coordinates[1] = 0.333333333333333*coordinate_dofs[1] + 0.333333333333333*coordinate_dofs[3] + 0.333333333333333*coordinate_dofs[5];
  }

  std::size_t num_sub_elements() const final override
  {
    return 0;
  }

  ufc::finite_element * create_sub_element(std::size_t i) const final override
  {
    return 0;
  }

  ufc::finite_element * create() const final override
  {
    return new adaptivepoisson_finite_element_5();
  }

};


class adaptivepoisson_finite_element_6: public ufc::finite_element
{
public:

  adaptivepoisson_finite_element_6() : ufc::finite_element()
  {
    // Do nothing
  }

  ~adaptivepoisson_finite_element_6() override
  {
    // Do nothing
  }

  const char * signature() const final override
  {
    return "FiniteElement('Bubble', triangle, 3)";
  }

  ufc::shape cell_shape() const final override
  {
    return ufc::shape::triangle;
  }

  std::size_t topological_dimension() const final override
  {
    return 2;
  }

  std::size_t geometric_dimension() const final override
  {
    return 2;
  }

  std::size_t space_dimension() const final override
  {
    return 1;
  }

  std::size_t value_rank() const final override
  {
    return 0;
  }

  std::size_t value_dimension(std::size_t i) const final override
  {
    return 1;
  }

  std::size_t value_size() const final override
  {
    return 1;
  }

  std::size_t reference_value_rank() const final override
  {
    return 0;
  }

  std::size_t reference_value_dimension(std::size_t i) const final override
  {
    return 1;
  }

  std::size_t reference_value_size() const final override
  {
    return 1;
  }

  std::size_t degree() const final override
  {
    return 3;
  }

  const char * family() const final override
  {
    return "Bubble";
  }

  static void _evaluate_basis(std::size_t i,
                              double * values,
                              const double * x,
                              const double * coordinate_dofs,
                              int cell_orientation)
  {
    // Compute Jacobian
    double J[4];
    compute_jacobian_triangle_2d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[4];
    double detJ;
    compute_jacobian_inverse_triangle_2d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = coordinate_dofs[2] + coordinate_dofs[4];
    const double C1 = coordinate_dofs[3] + coordinate_dofs[5];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J[1]*(C1 - 2.0*x[1]) + J[3]*(2.0*x[0] - C0)) / detJ;
    double Y = (J[0]*(2.0*x[1] - C1) + J[2]*(C0 - 2.0*x[0])) / detJ;
    
    // Reset values
    *values = 0.0;
    
    // Array of basisvalues
    double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
    
    // Declare helper variables
    double tmp0 = (1.0 + Y + 2.0*X)/2.0;
    double tmp1 = (1.0 - Y)/2.0;
    double tmp2 = tmp1*tmp1;
    
    // Compute basisvalues
    basisvalues[0] = 1.0;
    basisvalues[1] = tmp0;
    basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
    basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
    basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
    basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
    basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
    basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
    basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
    basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
    basisvalues[0] *= std::sqrt(0.5);
    basisvalues[2] *= std::sqrt(1.0);
    basisvalues[5] *= std::sqrt(1.5);
    basisvalues[9] *= std::sqrt(2.0);
    basisvalues[1] *= std::sqrt(3.0);
    basisvalues[4] *= std::sqrt(4.5);
    basisvalues[8] *= std::sqrt(6.0);
    basisvalues[3] *= std::sqrt(7.5);
    basisvalues[7] *= std::sqrt(10.0);
    basisvalues[6] *= std::sqrt(14.0);
    
    // Table(s) of coefficients
    static const double coefficients0[10] = \
    {0.636396103067893, 0.0, 0.0, -0.234738238930785, 0.0, -0.262445329583912, 0.0, -0.203289278153682, 0.0, 0.090913729009699};
    
    // Compute value(s)
    for (unsigned int r = 0; r < 10; r++)
    {
      *values += coefficients0[r]*basisvalues[r];
    } // end loop over 'r'
  }

  void evaluate_basis(std::size_t i,
                      double * values,
                      const double * x,
                      const double * coordinate_dofs,
                      int cell_orientation) const final override
  {
    _evaluate_basis(i, values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_all(double * values,
                                  const double * x,
                                  const double * coordinate_dofs,
                                  int cell_orientation)
  {
    // Element is constant, calling evaluate_basis.
    _evaluate_basis(0, values, x, coordinate_dofs, cell_orientation);
  }

  void evaluate_basis_all(double * values,
                          const double * x,
                          const double * coordinate_dofs,
                          int cell_orientation) const final override
  {
    _evaluate_basis_all(values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_derivatives(std::size_t i,
                                          std::size_t n,
                                          double * values,
                                          const double * x,
                                          const double * coordinate_dofs,
                                          int cell_orientation)
  {
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    } // end loop over 'r'
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.0;
    } // end loop over 'r'
    
    // Call evaluate_basis if order of derivatives is equal to zero.
    if (n == 0)
    {
      _evaluate_basis(i, values, x, coordinate_dofs, cell_orientation);
      return ;
    }
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 3)
    {
    return ;
    }
    
    // Compute Jacobian
    double J[4];
    compute_jacobian_triangle_2d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[4];
    double detJ;
    compute_jacobian_inverse_triangle_2d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = coordinate_dofs[2] + coordinate_dofs[4];
    const double C1 = coordinate_dofs[3] + coordinate_dofs[5];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J[1]*(C1 - 2.0*x[1]) + J[3]*(2.0*x[0] - C0)) / detJ;
    double Y = (J[0]*(2.0*x[1] - C1) + J[2]*(C0 - 2.0*x[0])) / detJ;
    
    // Declare two dimensional array that holds combinations of derivatives and initialise
    unsigned int combinations[8][3];
    for (unsigned int row = 0; row < 8; row++)
    {
      for (unsigned int col = 0; col < 3; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 1)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[2][2] = {{K[0], K[1]}, {K[2], K[3]}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double transform[8][8];
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Array of basisvalues
    double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
    
    // Declare helper variables
    double tmp0 = (1.0 + Y + 2.0*X)/2.0;
    double tmp1 = (1.0 - Y)/2.0;
    double tmp2 = tmp1*tmp1;
    
    // Compute basisvalues
    basisvalues[0] = 1.0;
    basisvalues[1] = tmp0;
    basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
    basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
    basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
    basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
    basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
    basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
    basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
    basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
    basisvalues[0] *= std::sqrt(0.5);
    basisvalues[2] *= std::sqrt(1.0);
    basisvalues[5] *= std::sqrt(1.5);
    basisvalues[9] *= std::sqrt(2.0);
    basisvalues[1] *= std::sqrt(3.0);
    basisvalues[4] *= std::sqrt(4.5);
    basisvalues[8] *= std::sqrt(6.0);
    basisvalues[3] *= std::sqrt(7.5);
    basisvalues[7] *= std::sqrt(10.0);
    basisvalues[6] *= std::sqrt(14.0);
    
    // Table(s) of coefficients
    static const double coefficients0[10] = \
    {0.636396103067893, 0.0, 0.0, -0.234738238930785, 0.0, -0.262445329583912, 0.0, -0.203289278153682, 0.0, 0.090913729009699};
    
    // Tables of derivatives of the polynomial base (transpose).
    static const double dmats0[10][10] = \
    {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {0.0, 9.48683298050515, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {3.99999999999999, 0.0, 7.07106781186547, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {5.29150262212919, -4.61061686781004e-14, -2.99332590941916, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
    {0.0, 4.38178046004134, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
    {3.46410161513775, 0.0, 7.83836717690618, 0.0, 0.0, 8.40000000000001, 0.0, 0.0, 0.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
    
    static const double dmats1[10][10] = \
    {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {4.24264068711929, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {2.58198889747162, 4.74341649025258, -0.912870929175281, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {1.99999999999992, 6.12372435695794, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {-2.30940107675849, 0.0, 8.16496580927727, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {2.64575131106457, 5.18459255872625, -1.49666295470956, 6.83130051063972, -1.05830052442583, 0.305505046330388, 0.0, 0.0, 0.0, 0.0},
    {2.23606797749982, 2.19089023002068, 2.52982212813469, 8.08290376865477, 6.26099033699941, -1.80739222823012, 0.0, 0.0, 0.0, 0.0},
    {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.6994845223857, 4.20000000000001, 0.0, 0.0, 0.0, 0.0},
    {5.00000000000002, 0.0, -2.82842712474623, 0.0, 0.0, 12.1243556529822, 0.0, 0.0, 0.0, 0.0}};
    
    // Compute reference derivatives.
    // Declare array of derivatives on FIAT element.
    double derivatives[8];
    for (unsigned int r = 0; r < 8; r++)
    {
      derivatives[r] = 0.0;
    } // end loop over 'r'
    
    // Declare derivative matrix (of polynomial basis).
    double dmats[10][10] = \
    {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
    
    // Declare (auxiliary) derivative matrix (of polynomial basis).
    double dmats_old[10][10] = \
    {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
    
    // Loop possible derivatives.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      // Resetting dmats values to compute next derivative.
      for (unsigned int t = 0; t < 10; t++)
      {
        for (unsigned int u = 0; u < 10; u++)
        {
          dmats[t][u] = 0.0;
          if (t == u)
          {
          dmats[t][u] = 1.0;
          }
          
        } // end loop over 'u'
      } // end loop over 't'
      
      // Looping derivative order to generate dmats.
      for (unsigned int s = 0; s < n; s++)
      {
        // Updating dmats_old with new values and resetting dmats.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats_old[t][u] = dmats[t][u];
            dmats[t][u] = 0.0;
          } // end loop over 'u'
        } // end loop over 't'
        
        // Update dmats using an inner product.
        if (combinations[r][s] == 0)
        {
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            for (unsigned int tu = 0; tu < 10; tu++)
            {
              dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
            } // end loop over 'tu'
          } // end loop over 'u'
        } // end loop over 't'
        }
        
        if (combinations[r][s] == 1)
        {
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            for (unsigned int tu = 0; tu < 10; tu++)
            {
              dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
            } // end loop over 'tu'
          } // end loop over 'u'
        } // end loop over 't'
        }
        
      } // end loop over 's'
      for (unsigned int s = 0; s < 10; s++)
      {
        for (unsigned int t = 0; t < 10; t++)
        {
          derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
        } // end loop over 't'
      } // end loop over 's'
    } // end loop over 'r'
    
    // Transform derivatives back to physical element
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r] += transform[r][s]*derivatives[s];
      } // end loop over 's'
    } // end loop over 'r'
  }

  void evaluate_basis_derivatives(std::size_t i,
                                  std::size_t n,
                                  double * values,
                                  const double * x,
                                  const double * coordinate_dofs,
                                  int cell_orientation) const final override
  {
    _evaluate_basis_derivatives(i, n, values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_derivatives_all(std::size_t n,
                                              double * values,
                                              const double * x,
                                              const double * coordinate_dofs,
                                              int cell_orientation)
  {
    // Element is constant, calling evaluate_basis_derivatives.
    _evaluate_basis_derivatives(0, n, values, x, coordinate_dofs, cell_orientation);
  }

  void evaluate_basis_derivatives_all(std::size_t n,
                                      double * values,
                                      const double * x,
                                      const double * coordinate_dofs,
                                      int cell_orientation) const final override
  {
    _evaluate_basis_derivatives_all(n, values, x, coordinate_dofs, cell_orientation);
  }

  double evaluate_dof(std::size_t i,
                      const ufc::function& f,
                      const double * coordinate_dofs,
                      int cell_orientation,
                      const ufc::cell& c) const final override
  {
    // Declare variables for result of evaluation
    double vals[1];
    
    // Declare variable for physical coordinates
    double y[2];
    switch (i)
    {
    case 0:
      {
        y[0] = 0.333333333333333*coordinate_dofs[0] + 0.333333333333333*coordinate_dofs[2] + 0.333333333333333*coordinate_dofs[4];
      y[1] = 0.333333333333333*coordinate_dofs[1] + 0.333333333333333*coordinate_dofs[3] + 0.333333333333333*coordinate_dofs[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.0;
  }

  void evaluate_dofs(double * values,
                             const ufc::function& f,
                             const double * coordinate_dofs,
                             int cell_orientation,
                             const ufc::cell& c) const final override
  {
    // Declare variables for result of evaluation
    double vals[1];
    
    // Declare variable for physical coordinates
    double y[2];
    y[0] = 0.333333333333333*coordinate_dofs[0] + 0.333333333333333*coordinate_dofs[2] + 0.333333333333333*coordinate_dofs[4];
    y[1] = 0.333333333333333*coordinate_dofs[1] + 0.333333333333333*coordinate_dofs[3] + 0.333333333333333*coordinate_dofs[5];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
  }

  void interpolate_vertex_values(double * vertex_values,
                                 const double * dof_values,
                                 const double * coordinate_dofs,
                                 int cell_orientation,
                                 const ufc::cell& c) const final override
  {
    // Evaluate function and change variables
    vertex_values[0] = 0;
    vertex_values[1] = 0;
    vertex_values[2] = 0;
  }

  void tabulate_dof_coordinates(double * dof_coordinates,
                                const double * coordinate_dofs) const final override
  {
    dof_coordinates[0] = 0.333333333333333*coordinate_dofs[0] + 0.333333333333333*coordinate_dofs[2] + 0.333333333333333*coordinate_dofs[4];
    dof_coordinates[1] = 0.333333333333333*coordinate_dofs[1] + 0.333333333333333*coordinate_dofs[3] + 0.333333333333333*coordinate_dofs[5];
  }

  std::size_t num_sub_elements() const final override
  {
    return 0;
  }

  ufc::finite_element * create_sub_element(std::size_t i) const final override
  {
    return 0;
  }

  ufc::finite_element * create() const final override
  {
    return new adaptivepoisson_finite_element_6();
  }

};


class adaptivepoisson_dofmap_0: public ufc::dofmap
{
public:

  adaptivepoisson_dofmap_0() : ufc::dofmap()
  {
    // Do nothing
  }

  ~adaptivepoisson_dofmap_0() override
  {
    // Do nothing
  }

  const char * signature() const final override
  {
    return "FFC dofmap for FiniteElement('Lagrange', triangle, 1)";
  }

  bool needs_mesh_entities(std::size_t d) const final override
  {
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return false;
        break;
      }
    case 2:
      {
        return false;
        break;
      }
    }
    
    return false;
  }

  std::size_t topological_dimension() const final override
  {
    return 2;
  }

  std::size_t global_dimension(const std::vector<std::size_t>&
                               num_global_entities) const final override
  {
    return num_global_entities[0];
  }

  std::size_t num_element_dofs() const final override
  {
    return 3;
  }

  std::size_t num_facet_dofs() const final override
  {
    return 2;
  }

  std::size_t num_entity_dofs(std::size_t d) const final override
  {
    switch (d)
    {
    case 0:
      {
        return 1;
        break;
      }
    case 1:
      {
        return 0;
        break;
      }
    case 2:
      {
        return 0;
        break;
      }
    }
    
    return 0;
  }

  void tabulate_dofs(std::size_t * dofs,
                     const std::vector<std::size_t>& num_global_entities,
                     const std::vector<std::vector<std::size_t>>& entity_indices) const final override
  {
    dofs[0] = entity_indices[0][0];
    dofs[1] = entity_indices[0][1];
    dofs[2] = entity_indices[0][2];
  }

  void tabulate_facet_dofs(std::size_t * dofs,
                           std::size_t facet) const final override
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
        break;
      }
    }
    
  }

  void tabulate_entity_dofs(std::size_t * dofs,
                            std::size_t d, std::size_t i) const final override
  {
    if (d > 2)
    {
    throw std::runtime_error("d is larger than dimension (2)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        
        break;
      }
    }
    
  }


  std::size_t num_sub_dofmaps() const final override
  {
    return 0;
  }

  ufc::dofmap * create_sub_dofmap(std::size_t i) const final override
  {
    return 0;
  }

  ufc::dofmap * create() const final override
  {
    return new adaptivepoisson_dofmap_0();
  }

};


class adaptivepoisson_dofmap_1: public ufc::dofmap
{
public:

  adaptivepoisson_dofmap_1() : ufc::dofmap()
  {
    // Do nothing
  }

  ~adaptivepoisson_dofmap_1() override
  {
    // Do nothing
  }

  const char * signature() const final override
  {
    return "FFC dofmap for VectorElement(FiniteElement('Lagrange', triangle, 1), dim=2)";
  }

  bool needs_mesh_entities(std::size_t d) const final override
  {
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return false;
        break;
      }
    case 2:
      {
        return false;
        break;
      }
    }
    
    return false;
  }

  std::size_t topological_dimension() const final override
  {
    return 2;
  }

  std::size_t global_dimension(const std::vector<std::size_t>&
                               num_global_entities) const final override
  {
    return 2*num_global_entities[0];
  }

  std::size_t num_element_dofs() const final override
  {
    return 6;
  }

  std::size_t num_facet_dofs() const final override
  {
    return 4;
  }

  std::size_t num_entity_dofs(std::size_t d) const final override
  {
    switch (d)
    {
    case 0:
      {
        return 2;
        break;
      }
    case 1:
      {
        return 0;
        break;
      }
    case 2:
      {
        return 0;
        break;
      }
    }
    
    return 0;
  }

  void tabulate_dofs(std::size_t * dofs,
                     const std::vector<std::size_t>& num_global_entities,
                     const std::vector<std::vector<std::size_t>>& entity_indices) const final override
  {
    unsigned int offset = 0;
    dofs[0] = offset + entity_indices[0][0];
    dofs[1] = offset + entity_indices[0][1];
    dofs[2] = offset + entity_indices[0][2];
    offset += num_global_entities[0];
    dofs[3] = offset + entity_indices[0][0];
    dofs[4] = offset + entity_indices[0][1];
    dofs[5] = offset + entity_indices[0][2];
    offset += num_global_entities[0];
  }

  void tabulate_facet_dofs(std::size_t * dofs,
                           std::size_t facet) const final override
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 4;
      dofs[3] = 5;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 5;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 3;
      dofs[3] = 4;
        break;
      }
    }
    
  }

  void tabulate_entity_dofs(std::size_t * dofs,
                            std::size_t d, std::size_t i) const final override
  {
    if (d > 2)
    {
    throw std::runtime_error("d is larger than dimension (2)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
        dofs[1] = 3;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
        dofs[1] = 4;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
        dofs[1] = 5;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        
        break;
      }
    }
    
  }


  std::size_t num_sub_dofmaps() const final override
  {
    return 2;
  }

  ufc::dofmap * create_sub_dofmap(std::size_t i) const final override
  {
    switch (i)
    {
    case 0:
      {
        return new adaptivepoisson_dofmap_0();
        break;
      }
    case 1:
      {
        return new adaptivepoisson_dofmap_0();
        break;
      }
    }
    
    return 0;
  }

  ufc::dofmap * create() const final override
  {
    return new adaptivepoisson_dofmap_1();
  }

};


class adaptivepoisson_dofmap_2: public ufc::dofmap
{
public:

  adaptivepoisson_dofmap_2() : ufc::dofmap()
  {
    // Do nothing
  }

  ~adaptivepoisson_dofmap_2() override
  {
    // Do nothing
  }

  const char * signature() const final override
  {
    return "FFC dofmap for FiniteElement('Lagrange', triangle, 2)";
  }

  bool needs_mesh_entities(std::size_t d) const final override
  {
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return true;
        break;
      }
    case 2:
      {
        return false;
        break;
      }
    }
    
    return false;
  }

  std::size_t topological_dimension() const final override
  {
    return 2;
  }

  std::size_t global_dimension(const std::vector<std::size_t>&
                               num_global_entities) const final override
  {
    return num_global_entities[0] + num_global_entities[1];
  }

  std::size_t num_element_dofs() const final override
  {
    return 6;
  }

  std::size_t num_facet_dofs() const final override
  {
    return 3;
  }

  std::size_t num_entity_dofs(std::size_t d) const final override
  {
    switch (d)
    {
    case 0:
      {
        return 1;
        break;
      }
    case 1:
      {
        return 1;
        break;
      }
    case 2:
      {
        return 0;
        break;
      }
    }
    
    return 0;
  }

  void tabulate_dofs(std::size_t * dofs,
                     const std::vector<std::size_t>& num_global_entities,
                     const std::vector<std::vector<std::size_t>>& entity_indices) const final override
  {
    unsigned int offset = 0;
    dofs[0] = offset + entity_indices[0][0];
    dofs[1] = offset + entity_indices[0][1];
    dofs[2] = offset + entity_indices[0][2];
    offset += num_global_entities[0];
    dofs[3] = offset + entity_indices[1][0];
    dofs[4] = offset + entity_indices[1][1];
    dofs[5] = offset + entity_indices[1][2];
    offset += num_global_entities[1];
  }

  void tabulate_facet_dofs(std::size_t * dofs,
                           std::size_t facet) const final override
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 3;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 4;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 5;
        break;
      }
    }
    
  }

  void tabulate_entity_dofs(std::size_t * dofs,
                            std::size_t d, std::size_t i) const final override
  {
    if (d > 2)
    {
    throw std::runtime_error("d is larger than dimension (2)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 3;
          break;
        }
      case 1:
        {
          dofs[0] = 4;
          break;
        }
      case 2:
        {
          dofs[0] = 5;
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        
        break;
      }
    }
    
  }


  std::size_t num_sub_dofmaps() const final override
  {
    return 0;
  }

  ufc::dofmap * create_sub_dofmap(std::size_t i) const final override
  {
    return 0;
  }

  ufc::dofmap * create() const final override
  {
    return new adaptivepoisson_dofmap_2();
  }

};


class adaptivepoisson_dofmap_3: public ufc::dofmap
{
public:

  adaptivepoisson_dofmap_3() : ufc::dofmap()
  {
    // Do nothing
  }

  ~adaptivepoisson_dofmap_3() override
  {
    // Do nothing
  }

  const char * signature() const final override
  {
    return "FFC dofmap for FiniteElement('Discontinuous Lagrange', triangle, 2)";
  }

  bool needs_mesh_entities(std::size_t d) const final override
  {
    switch (d)
    {
    case 0:
      {
        return false;
        break;
      }
    case 1:
      {
        return false;
        break;
      }
    case 2:
      {
        return true;
        break;
      }
    }
    
    return false;
  }

  std::size_t topological_dimension() const final override
  {
    return 2;
  }

  std::size_t global_dimension(const std::vector<std::size_t>&
                               num_global_entities) const final override
  {
    return 6*num_global_entities[2];
  }

  std::size_t num_element_dofs() const final override
  {
    return 6;
  }

  std::size_t num_facet_dofs() const final override
  {
    return 0;
  }

  std::size_t num_entity_dofs(std::size_t d) const final override
  {
    switch (d)
    {
    case 0:
      {
        return 0;
        break;
      }
    case 1:
      {
        return 0;
        break;
      }
    case 2:
      {
        return 6;
        break;
      }
    }
    
    return 0;
  }

  void tabulate_dofs(std::size_t * dofs,
                     const std::vector<std::size_t>& num_global_entities,
                     const std::vector<std::vector<std::size_t>>& entity_indices) const final override
  {
    dofs[0] = 6*entity_indices[2][0];
    dofs[1] = 6*entity_indices[2][0] + 1;
    dofs[2] = 6*entity_indices[2][0] + 2;
    dofs[3] = 6*entity_indices[2][0] + 3;
    dofs[4] = 6*entity_indices[2][0] + 4;
    dofs[5] = 6*entity_indices[2][0] + 5;
  }

  void tabulate_facet_dofs(std::size_t * dofs,
                           std::size_t facet) const final override
  {
    switch (facet)
    {
    case 0:
      {
        
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        
        break;
      }
    }
    
  }

  void tabulate_entity_dofs(std::size_t * dofs,
                            std::size_t d, std::size_t i) const final override
  {
    if (d > 2)
    {
    throw std::runtime_error("d is larger than dimension (2)");
    }
    
    switch (d)
    {
    case 0:
      {
        
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        if (i > 0)
      {
      throw std::runtime_error("i is larger than number of entities (0)");
      }
      
      dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 2;
      dofs[3] = 3;
      dofs[4] = 4;
      dofs[5] = 5;
        break;
      }
    }
    
  }


  std::size_t num_sub_dofmaps() const final override
  {
    return 0;
  }

  ufc::dofmap * create_sub_dofmap(std::size_t i) const final override
  {
    return 0;
  }

  ufc::dofmap * create() const final override
  {
    return new adaptivepoisson_dofmap_3();
  }

};


class adaptivepoisson_dofmap_4: public ufc::dofmap
{
public:

  adaptivepoisson_dofmap_4() : ufc::dofmap()
  {
    // Do nothing
  }

  ~adaptivepoisson_dofmap_4() override
  {
    // Do nothing
  }

  const char * signature() const final override
  {
    return "FFC dofmap for FiniteElement('Discontinuous Lagrange', triangle, 1)";
  }

  bool needs_mesh_entities(std::size_t d) const final override
  {
    switch (d)
    {
    case 0:
      {
        return false;
        break;
      }
    case 1:
      {
        return false;
        break;
      }
    case 2:
      {
        return true;
        break;
      }
    }
    
    return false;
  }

  std::size_t topological_dimension() const final override
  {
    return 2;
  }

  std::size_t global_dimension(const std::vector<std::size_t>&
                               num_global_entities) const final override
  {
    return 3*num_global_entities[2];
  }

  std::size_t num_element_dofs() const final override
  {
    return 3;
  }

  std::size_t num_facet_dofs() const final override
  {
    return 0;
  }

  std::size_t num_entity_dofs(std::size_t d) const final override
  {
    switch (d)
    {
    case 0:
      {
        return 0;
        break;
      }
    case 1:
      {
        return 0;
        break;
      }
    case 2:
      {
        return 3;
        break;
      }
    }
    
    return 0;
  }

  void tabulate_dofs(std::size_t * dofs,
                     const std::vector<std::size_t>& num_global_entities,
                     const std::vector<std::vector<std::size_t>>& entity_indices) const final override
  {
    dofs[0] = 3*entity_indices[2][0];
    dofs[1] = 3*entity_indices[2][0] + 1;
    dofs[2] = 3*entity_indices[2][0] + 2;
  }

  void tabulate_facet_dofs(std::size_t * dofs,
                           std::size_t facet) const final override
  {
    switch (facet)
    {
    case 0:
      {
        
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        
        break;
      }
    }
    
  }

  void tabulate_entity_dofs(std::size_t * dofs,
                            std::size_t d, std::size_t i) const final override
  {
    if (d > 2)
    {
    throw std::runtime_error("d is larger than dimension (2)");
    }
    
    switch (d)
    {
    case 0:
      {
        
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        if (i > 0)
      {
      throw std::runtime_error("i is larger than number of entities (0)");
      }
      
      dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 2;
        break;
      }
    }
    
  }


  std::size_t num_sub_dofmaps() const final override
  {
    return 0;
  }

  ufc::dofmap * create_sub_dofmap(std::size_t i) const final override
  {
    return 0;
  }

  ufc::dofmap * create() const final override
  {
    return new adaptivepoisson_dofmap_4();
  }

};


class adaptivepoisson_dofmap_5: public ufc::dofmap
{
public:

  adaptivepoisson_dofmap_5() : ufc::dofmap()
  {
    // Do nothing
  }

  ~adaptivepoisson_dofmap_5() override
  {
    // Do nothing
  }

  const char * signature() const final override
  {
    return "FFC dofmap for FiniteElement('Discontinuous Lagrange', triangle, 0)";
  }

  bool needs_mesh_entities(std::size_t d) const final override
  {
    switch (d)
    {
    case 0:
      {
        return false;
        break;
      }
    case 1:
      {
        return false;
        break;
      }
    case 2:
      {
        return true;
        break;
      }
    }
    
    return false;
  }

  std::size_t topological_dimension() const final override
  {
    return 2;
  }

  std::size_t global_dimension(const std::vector<std::size_t>&
                               num_global_entities) const final override
  {
    return num_global_entities[2];
  }

  std::size_t num_element_dofs() const final override
  {
    return 1;
  }

  std::size_t num_facet_dofs() const final override
  {
    return 0;
  }

  std::size_t num_entity_dofs(std::size_t d) const final override
  {
    switch (d)
    {
    case 0:
      {
        return 0;
        break;
      }
    case 1:
      {
        return 0;
        break;
      }
    case 2:
      {
        return 1;
        break;
      }
    }
    
    return 0;
  }

  void tabulate_dofs(std::size_t * dofs,
                     const std::vector<std::size_t>& num_global_entities,
                     const std::vector<std::vector<std::size_t>>& entity_indices) const final override
  {
    dofs[0] = entity_indices[2][0];
  }

  void tabulate_facet_dofs(std::size_t * dofs,
                           std::size_t facet) const final override
  {
    switch (facet)
    {
    case 0:
      {
        
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        
        break;
      }
    }
    
  }

  void tabulate_entity_dofs(std::size_t * dofs,
                            std::size_t d, std::size_t i) const final override
  {
    if (d > 2)
    {
    throw std::runtime_error("d is larger than dimension (2)");
    }
    
    switch (d)
    {
    case 0:
      {
        
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        if (i > 0)
      {
      throw std::runtime_error("i is larger than number of entities (0)");
      }
      
      dofs[0] = 0;
        break;
      }
    }
    
  }


  std::size_t num_sub_dofmaps() const final override
  {
    return 0;
  }

  ufc::dofmap * create_sub_dofmap(std::size_t i) const final override
  {
    return 0;
  }

  ufc::dofmap * create() const final override
  {
    return new adaptivepoisson_dofmap_5();
  }

};


class adaptivepoisson_dofmap_6: public ufc::dofmap
{
public:

  adaptivepoisson_dofmap_6() : ufc::dofmap()
  {
    // Do nothing
  }

  ~adaptivepoisson_dofmap_6() override
  {
    // Do nothing
  }

  const char * signature() const final override
  {
    return "FFC dofmap for FiniteElement('Bubble', triangle, 3)";
  }

  bool needs_mesh_entities(std::size_t d) const final override
  {
    switch (d)
    {
    case 0:
      {
        return false;
        break;
      }
    case 1:
      {
        return false;
        break;
      }
    case 2:
      {
        return true;
        break;
      }
    }
    
    return false;
  }

  std::size_t topological_dimension() const final override
  {
    return 2;
  }

  std::size_t global_dimension(const std::vector<std::size_t>&
                               num_global_entities) const final override
  {
    return num_global_entities[2];
  }

  std::size_t num_element_dofs() const final override
  {
    return 1;
  }

  std::size_t num_facet_dofs() const final override
  {
    return 0;
  }

  std::size_t num_entity_dofs(std::size_t d) const final override
  {
    switch (d)
    {
    case 0:
      {
        return 0;
        break;
      }
    case 1:
      {
        return 0;
        break;
      }
    case 2:
      {
        return 1;
        break;
      }
    }
    
    return 0;
  }

  void tabulate_dofs(std::size_t * dofs,
                     const std::vector<std::size_t>& num_global_entities,
                     const std::vector<std::vector<std::size_t>>& entity_indices) const final override
  {
    dofs[0] = entity_indices[2][0];
  }

  void tabulate_facet_dofs(std::size_t * dofs,
                           std::size_t facet) const final override
  {
    switch (facet)
    {
    case 0:
      {
        
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        
        break;
      }
    }
    
  }

  void tabulate_entity_dofs(std::size_t * dofs,
                            std::size_t d, std::size_t i) const final override
  {
    if (d > 2)
    {
    throw std::runtime_error("d is larger than dimension (2)");
    }
    
    switch (d)
    {
    case 0:
      {
        
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        if (i > 0)
      {
      throw std::runtime_error("i is larger than number of entities (0)");
      }
      
      dofs[0] = 0;
        break;
      }
    }
    
  }


  std::size_t num_sub_dofmaps() const final override
  {
    return 0;
  }

  ufc::dofmap * create_sub_dofmap(std::size_t i) const final override
  {
    return 0;
  }

  ufc::dofmap * create() const final override
  {
    return new adaptivepoisson_dofmap_6();
  }

};


class adaptivepoisson_cell_integral_0_otherwise: public ufc::cell_integral
{
public:

  adaptivepoisson_cell_integral_0_otherwise() : ufc::cell_integral()
  {
    
  }

  ~adaptivepoisson_cell_integral_0_otherwise() override
  {
    
  }

  const std::vector<bool> & enabled_coefficients() const final override
  {
    static const std::vector<bool> enabled({});
    return enabled;
  }

  void tabulate_tensor(double * A,
                       const double * const * w,
                       const double * coordinate_dofs,
                       int cell_orientation) const final override
  {
    // Number of operations (multiply-add pairs) for Jacobian data:      3
    // Number of operations (multiply-add pairs) for geometry tensor:    8
    // Number of operations (multiply-add pairs) for tensor contraction: 11
    // Total number of operations (multiply-add pairs):                  22
    
    // Compute Jacobian
    double J[4];
    compute_jacobian_triangle_2d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[4];
    double detJ;
    compute_jacobian_inverse_triangle_2d(K, detJ, J);
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Compute geometry tensor
    const double G0_0_0 = det*(K[0]*K[0] + K[1]*K[1]);
    const double G0_0_1 = det*(K[0]*K[2] + K[1]*K[3]);
    const double G0_1_0 = det*(K[2]*K[0] + K[3]*K[1]);
    const double G0_1_1 = det*(K[2]*K[2] + K[3]*K[3]);
    
    // Compute element tensor
    A[0] = 0.499999999999999*G0_0_0 + 0.5*G0_0_1 + 0.5*G0_1_0 + 0.5*G0_1_1;
    A[1] = -0.499999999999999*G0_0_0 - 0.5*G0_1_0;
    A[2] = -0.5*G0_0_1 - 0.5*G0_1_1;
    A[3] = -0.499999999999999*G0_0_0 - 0.5*G0_0_1;
    A[4] = 0.499999999999999*G0_0_0;
    A[5] = 0.5*G0_0_1;
    A[6] = -0.5*G0_1_0 - 0.5*G0_1_1;
    A[7] = 0.5*G0_1_0;
    A[8] = 0.5*G0_1_1;
  }

};


class adaptivepoisson_cell_integral_1_otherwise: public ufc::cell_integral
{
public:

  adaptivepoisson_cell_integral_1_otherwise() : ufc::cell_integral()
  {
    
  }

  ~adaptivepoisson_cell_integral_1_otherwise() override
  {
    
  }

  const std::vector<bool> & enabled_coefficients() const final override
  {
    static const std::vector<bool> enabled({});
    return enabled;
  }

  void tabulate_tensor(double * A,
                       const double * const * w,
                       const double * coordinate_dofs,
                       int cell_orientation) const final override
  {
    // Number of operations (multiply-add pairs) for Jacobian data:      3
    // Number of operations (multiply-add pairs) for geometry tensor:    0
    // Number of operations (multiply-add pairs) for tensor contraction: 1
    // Total number of operations (multiply-add pairs):                  4
    
    // Compute Jacobian
    double J[4];
    compute_jacobian_triangle_2d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[4];
    double detJ;
    compute_jacobian_inverse_triangle_2d(K, detJ, J);
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Compute geometry tensor
    const double G0_ = det;
    
    // Compute element tensor
    A[0] = 0.166666666666667*G0_;
    A[1] = 0.166666666666667*G0_;
    A[2] = 0.166666666666667*G0_;
  }

};


class adaptivepoisson_cell_integral_2_otherwise: public ufc::cell_integral
{
public:

  adaptivepoisson_cell_integral_2_otherwise() : ufc::cell_integral()
  {
    
  }

  ~adaptivepoisson_cell_integral_2_otherwise() override
  {
    
  }

  const std::vector<bool> & enabled_coefficients() const final override
  {
    static const std::vector<bool> enabled({true, false, true, true});
    return enabled;
  }

  void tabulate_tensor(double * A,
                       const double * const * w,
                       const double * coordinate_dofs,
                       int cell_orientation) const final override
  {
    // Compute Jacobian
    double J[4];
    compute_jacobian_triangle_2d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[4];
    double detJ;
    compute_jacobian_inverse_triangle_2d(K, detJ, J);
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Compute cell volume
    
    
    // Compute circumradius of triangle in 2D
    
    
    // Array of quadrature weights.
    static const double W6[6] = {0.0833333333333333, 0.0833333333333333, 0.0833333333333333, 0.0833333333333333, 0.0833333333333333, 0.0833333333333333};
    // Quadrature points on the UFC reference element: (0.659027622374092, 0.231933368553031), (0.659027622374092, 0.109039009072877), (0.231933368553031, 0.659027622374092), (0.231933368553031, 0.109039009072877), (0.109039009072877, 0.659027622374092), (0.109039009072877, 0.231933368553031)
    
    // Values of basis functions at quadrature points.
    static const double FE0[6][3] = \
    {{0.109039009072877, 0.659027622374092, 0.231933368553031},
    {0.231933368553031, 0.659027622374092, 0.109039009072877},
    {0.109039009072877, 0.231933368553031, 0.659027622374092},
    {0.659027622374092, 0.231933368553031, 0.109039009072877},
    {0.231933368553031, 0.109039009072877, 0.659027622374092},
    {0.659027622374092, 0.109039009072877, 0.231933368553031}};
    
    static const double FE0_D01[6][2] = \
    {{-1.0, 1.0},
    {-1.0, 1.0},
    {-1.0, 1.0},
    {-1.0, 1.0},
    {-1.0, 1.0},
    {-1.0, 1.0}};
    
    // Array of non-zero columns
    static const unsigned int nzc0[2] = {0, 2};
    
    // Array of non-zero columns
    static const unsigned int nzc1[2] = {0, 1};
    
    static const double FE1[6][6] = \
    {{-0.0852599980736871, 0.209607191730006, -0.124347193656319, 0.611401985706872, 0.101159138711827, 0.287438875581301},
    {-0.124347193656319, 0.209607191730006, -0.0852599980736871, 0.287438875581301, 0.101159138711827, 0.611401985706872},
    {-0.085259998073687, -0.124347193656319, 0.209607191730006, 0.611401985706872, 0.287438875581301, 0.101159138711827},
    {0.209607191730006, -0.124347193656319, -0.0852599980736871, 0.101159138711827, 0.287438875581301, 0.611401985706872},
    {-0.124347193656319, -0.0852599980736871, 0.209607191730006, 0.287438875581301, 0.611401985706872, 0.101159138711827},
    {0.209607191730006, -0.0852599980736871, -0.124347193656319, 0.101159138711827, 0.611401985706872, 0.287438875581301}};
    
    static const double FE1_D01[6][5] = \
    {{0.563843963708487, -0.0722665257878746, 2.63611048949635, -0.491577437920606, -2.63611048949637},
    {0.0722665257878714, -0.563843963708491, 2.63611048949635, 0.491577437920626, -2.63611048949637},
    {0.563843963708487, 1.63611048949637, 0.927733474212109, -2.19995445320485, -0.927733474212123},
    {-1.63611048949637, -0.563843963708491, 0.927733474212113, 2.19995445320487, -0.927733474212124},
    {0.0722665257878707, 1.63611048949637, 0.436156036291494, -1.70837701528424, -0.436156036291506},
    {-1.63611048949637, -0.0722665257878746, 0.436156036291497, 1.70837701528425, -0.436156036291507}};
    
    // Array of non-zero columns
    static const unsigned int nzc2[5] = {0, 2, 3, 4, 5};
    
    static const double FE1_D10[6][5] = \
    {{0.563843963708494, 1.63611048949637, 0.927733474212122, -0.927733474212122, -2.19995445320486},
    {0.072266525787878, 1.63611048949637, 0.436156036291507, -0.436156036291507, -1.70837701528425},
    {0.563843963708492, -0.0722665257878757, 2.63611048949636, -2.63611048949636, -0.491577437920617},
    {-1.63611048949637, -0.0722665257878778, 0.436156036291507, -0.436156036291507, 1.70837701528425},
    {0.0722665257878754, -0.563843963708493, 2.63611048949636, -2.63611048949636, 0.491577437920617},
    {-1.63611048949637, -0.563843963708494, 0.927733474212122, -0.927733474212122, 2.19995445320486}};
    
    // Array of non-zero columns
    static const unsigned int nzc3[5] = {0, 1, 3, 4, 5};
    
    // Reset values in the element tensor.
    A[0] = 0.0;
    // Number of operations to compute geometry constants: 12.
    double G[3];
    G[0] =  - det*(K[0]*K[0] + K[1]*K[1]);
    G[1] =  - det*(K[0]*K[2] + K[1]*K[3]);
    G[2] =  - det*(K[2]*K[2] + K[3]*K[3]);
    
    // Compute element tensor using UFL quadrature representation
    // Optimisations: ('eliminate zeros', True), ('ignore ones', True), ('ignore zero tables', True), ('optimisation', 'simplify_expressions'), ('remove zero terms', True)
    
    // Loop quadrature points for integral.
    // Number of operations to compute element tensor for following IP loop = 366
    for (unsigned int ip = 0; ip < 6; ip++)
    {
      
      // Coefficient declarations.
      double F0 = 0.0;
      double F1 = 0.0;
      double F2 = 0.0;
      double F3 = 0.0;
      double F4 = 0.0;
      double F5 = 0.0;
      
      // Total number of operations to compute function values = 8
      for (unsigned int r = 0; r < 2; r++)
      {
        F2 += FE0_D01[ip][r]*w[2][nzc1[r]];
        F3 += FE0_D01[ip][r]*w[2][nzc0[r]];
      } // end loop over 'r'
      
      // Total number of operations to compute function values = 6
      for (unsigned int r = 0; r < 3; r++)
      {
        F0 += FE0[ip][r]*w[0][r];
      } // end loop over 'r'
      
      // Total number of operations to compute function values = 20
      for (unsigned int r = 0; r < 5; r++)
      {
        F4 += FE1_D10[ip][r]*w[3][nzc3[r]];
        F5 += FE1_D01[ip][r]*w[3][nzc2[r]];
      } // end loop over 'r'
      
      // Total number of operations to compute function values = 12
      for (unsigned int r = 0; r < 6; r++)
      {
        F1 += FE1[ip][r]*w[3][r];
      } // end loop over 'r'
      
      // Number of operations to compute ip constants: 14
      double I[1];
      // Number of operations: 14
      I[0] = W6[ip]*(F0*F1*det + F2*F4*G[0] + F3*F5*G[2] + G[1]*(F2*F5 + F3*F4));
      
      
      // Number of operations for primary indices: 1
      // Number of operations to compute entry: 1
      A[0] += I[0];
    } // end loop over 'ip'
  }

};


class adaptivepoisson_exterior_facet_integral_2_otherwise: public ufc::exterior_facet_integral
{
public:

  adaptivepoisson_exterior_facet_integral_2_otherwise() : ufc::exterior_facet_integral()
  {
    
  }

  ~adaptivepoisson_exterior_facet_integral_2_otherwise() override
  {
    
  }

  const std::vector<bool> & enabled_coefficients() const final override
  {
    static const std::vector<bool> enabled({false, true, false, true});
    return enabled;
  }

  void tabulate_tensor(double * A,
                       const double * const * w,
                       const double * coordinate_dofs,
                       std::size_t facet,
                       int cell_orientation) const final override
  {
    // Number of operations (multiply-add pairs) for Jacobian data:      10
    // Number of operations (multiply-add pairs) for geometry tensor:    13
    // Number of operations (multiply-add pairs) for tensor contraction: 10
    // Total number of operations (multiply-add pairs):                  33
    
    // Compute Jacobian
    double J[4];
    compute_jacobian_triangle_2d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[4];
    double detJ;
    compute_jacobian_inverse_triangle_2d(K, detJ, J);
    
    // Get vertices on edge
    static unsigned int edge_vertices[3][2] = {{1, 2}, {0, 2}, {0, 1}};
    const unsigned int v0 = edge_vertices[facet][0];
    const unsigned int v1 = edge_vertices[facet][1];
    
    // Compute scale factor (length of edge scaled by length of reference interval)
    const double dx0 = coordinate_dofs[2*v1 + 0] - coordinate_dofs[2*v0 + 0];
    const double dx1 = coordinate_dofs[2*v1 + 1] - coordinate_dofs[2*v0 + 1];
    const double det = std::sqrt(dx0*dx0 + dx1*dx1);
    
    
    // Compute geometry tensor
    const double G0_0_0 = det*w[1][0]*w[3][0]*(1.0);
    const double G0_0_4 = det*w[1][0]*w[3][4]*(1.0);
    const double G0_0_5 = det*w[1][0]*w[3][5]*(1.0);
    const double G0_1_1 = det*w[1][1]*w[3][1]*(1.0);
    const double G0_1_3 = det*w[1][1]*w[3][3]*(1.0);
    const double G0_1_5 = det*w[1][1]*w[3][5]*(1.0);
    const double G0_2_2 = det*w[1][2]*w[3][2]*(1.0);
    const double G0_2_3 = det*w[1][2]*w[3][3]*(1.0);
    const double G0_2_4 = det*w[1][2]*w[3][4]*(1.0);
    
    // Compute element tensor
    switch (facet)
    {
    case 0:
      {
        A[0] = 0.166666666666666*G0_1_1 + 0.333333333333333*G0_1_3 + 0.166666666666667*G0_2_2 + 0.333333333333333*G0_2_3;
        break;
      }
    case 1:
      {
        A[0] = 0.166666666666667*G0_0_0 + 0.333333333333333*G0_0_4 + 0.166666666666667*G0_2_2 + 0.333333333333333*G0_2_4;
        break;
      }
    case 2:
      {
        A[0] = 0.166666666666667*G0_0_0 + 0.333333333333333*G0_0_5 + 0.166666666666666*G0_1_1 + 0.333333333333333*G0_1_5;
        break;
      }
    }
    
  }

};


class adaptivepoisson_cell_integral_3_otherwise: public ufc::cell_integral
{
public:

  adaptivepoisson_cell_integral_3_otherwise() : ufc::cell_integral()
  {
    
  }

  ~adaptivepoisson_cell_integral_3_otherwise() override
  {
    
  }

  const std::vector<bool> & enabled_coefficients() const final override
  {
    static const std::vector<bool> enabled({true});
    return enabled;
  }

  void tabulate_tensor(double * A,
                       const double * const * w,
                       const double * coordinate_dofs,
                       int cell_orientation) const final override
  {
    // Number of operations (multiply-add pairs) for Jacobian data:      3
    // Number of operations (multiply-add pairs) for geometry tensor:    1
    // Number of operations (multiply-add pairs) for tensor contraction: 4
    // Total number of operations (multiply-add pairs):                  8
    
    // Compute Jacobian
    double J[4];
    compute_jacobian_triangle_2d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[4];
    double detJ;
    compute_jacobian_inverse_triangle_2d(K, detJ, J);
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Compute geometry tensor
    const double G0_0 = det*w[0][0]*(1.0);
    
    // Compute element tensor
    A[0] = 0.0321428571428571*G0_0;
    A[1] = 0.0214285714285714*G0_0;
    A[2] = 0.0214285714285714*G0_0;
    A[3] = 0.0214285714285714*G0_0;
    A[4] = 0.0321428571428571*G0_0;
    A[5] = 0.0214285714285714*G0_0;
    A[6] = 0.0214285714285714*G0_0;
    A[7] = 0.0214285714285714*G0_0;
    A[8] = 0.0321428571428571*G0_0;
  }

};


class adaptivepoisson_cell_integral_4_otherwise: public ufc::cell_integral
{
public:

  adaptivepoisson_cell_integral_4_otherwise() : ufc::cell_integral()
  {
    
  }

  ~adaptivepoisson_cell_integral_4_otherwise() override
  {
    
  }

  const std::vector<bool> & enabled_coefficients() const final override
  {
    static const std::vector<bool> enabled({true, false, true, true});
    return enabled;
  }

  void tabulate_tensor(double * A,
                       const double * const * w,
                       const double * coordinate_dofs,
                       int cell_orientation) const final override
  {
    // Compute Jacobian
    double J[4];
    compute_jacobian_triangle_2d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[4];
    double detJ;
    compute_jacobian_inverse_triangle_2d(K, detJ, J);
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Compute cell volume
    
    
    // Compute circumradius of triangle in 2D
    
    
    // Array of quadrature weights.
    static const double W7[7] = {0.1125, 0.0629695902724136, 0.0629695902724136, 0.0629695902724136, 0.0661970763942531, 0.0661970763942531, 0.0661970763942531};
    // Quadrature points on the UFC reference element: (0.333333333333333, 0.333333333333333), (0.797426985353087, 0.101286507323456), (0.101286507323456, 0.797426985353087), (0.101286507323456, 0.101286507323456), (0.0597158717897698, 0.470142064105115), (0.470142064105115, 0.0597158717897698), (0.470142064105115, 0.470142064105115)
    
    // Values of basis functions at quadrature points.
    static const double FE0[7][1] = \
    {{1.0},
    {0.22088075779229},
    {0.22088075779229},
    {0.22088075779229},
    {0.356378717426368},
    {0.356378717426369},
    {0.356378717426369}};
    
    static const double FE0_D01[7][1] = \
    {{0.0},
    {0.0},
    {-1.90376021590478},
    {1.90376021590477},
    {0.0},
    {5.20988266488436},
    {-5.20988266488437}};
    
    static const double FE0_D10[7][1] = \
    {{0.0},
    {-1.90376021590478},
    {0.0},
    {1.90376021590477},
    {5.20988266488437},
    {0.0},
    {-5.20988266488436}};
    
    static const double FE1[7][3] = \
    {{0.333333333333333, 0.333333333333333, 0.333333333333333},
    {0.101286507323456, 0.797426985353087, 0.101286507323456},
    {0.101286507323457, 0.101286507323456, 0.797426985353087},
    {0.797426985353087, 0.101286507323456, 0.101286507323456},
    {0.470142064105115, 0.0597158717897698, 0.470142064105115},
    {0.470142064105115, 0.470142064105115, 0.0597158717897697},
    {0.0597158717897699, 0.470142064105115, 0.470142064105115}};
    
    static const double FE1_D01[7][2] = \
    {{-1.0, 1.0},
    {-1.0, 1.0},
    {-1.0, 1.0},
    {-1.0, 1.0},
    {-1.0, 1.0},
    {-1.0, 1.0},
    {-1.0, 1.0}};
    
    // Array of non-zero columns
    static const unsigned int nzc0[2] = {0, 2};
    
    // Array of non-zero columns
    static const unsigned int nzc1[2] = {0, 1};
    
    // Reset values in the element tensor.
    for (unsigned int r = 0; r < 3; r++)
    {
      A[r] = 0.0;
    } // end loop over 'r'
    // Number of operations to compute geometry constants: 12.
    double G[3];
    G[0] =  - det*(K[0]*K[2] + K[1]*K[3]);
    G[1] =  - det*(K[2]*K[2] + K[3]*K[3]);
    G[2] =  - det*(K[0]*K[0] + K[1]*K[1]);
    
    // Compute element tensor using UFL quadrature representation
    // Optimisations: ('eliminate zeros', True), ('ignore ones', True), ('ignore zero tables', True), ('optimisation', 'simplify_expressions'), ('remove zero terms', True)
    
    // Loop quadrature points for integral.
    // Number of operations to compute element tensor for following IP loop = 406
    for (unsigned int ip = 0; ip < 7; ip++)
    {
      
      // Coefficient declarations.
      double F0 = 0.0;
      double F1 = 0.0;
      double F2 = 0.0;
      double F3 = 0.0;
      double F4 = 0.0;
      double F5 = 0.0;
      
      // Total number of operations to compute function values = 6
      for (unsigned int r = 0; r < 1; r++)
      {
        F1 += FE0[ip][0]*w[3][0];
        F2 += FE0_D10[ip][0]*w[3][0];
        F3 += FE0_D01[ip][0]*w[3][0];
      } // end loop over 'r'
      
      // Total number of operations to compute function values = 8
      for (unsigned int r = 0; r < 2; r++)
      {
        F4 += FE1_D01[ip][r]*w[2][nzc1[r]];
        F5 += FE1_D01[ip][r]*w[2][nzc0[r]];
      } // end loop over 'r'
      
      // Total number of operations to compute function values = 6
      for (unsigned int r = 0; r < 3; r++)
      {
        F0 += FE1[ip][r]*w[0][r];
      } // end loop over 'r'
      
      // Number of operations to compute ip constants: 24
      double I[3];
      // Number of operations: 5
      I[0] = F1*W7[ip]*(F4*G[0] + F5*G[1]);
      
      // Number of operations: 5
      I[1] = F1*W7[ip]*(F4*G[2] + F5*G[0]);
      
      // Number of operations: 14
      I[2] = W7[ip]*(F0*F1*det + F2*F4*G[2] + F3*F5*G[1] + G[0]*(F2*F5 + F3*F4));
      
      
      // Number of operations for primary indices: 8
      for (unsigned int j = 0; j < 2; j++)
      {
        // Number of operations to compute entry: 2
        A[nzc0[j]] += FE1_D01[ip][j]*I[0];
        // Number of operations to compute entry: 2
        A[nzc1[j]] += FE1_D01[ip][j]*I[1];
      } // end loop over 'j'
      
      // Number of operations for primary indices: 6
      for (unsigned int j = 0; j < 3; j++)
      {
        // Number of operations to compute entry: 2
        A[j] += FE1[ip][j]*I[2];
      } // end loop over 'j'
    } // end loop over 'ip'
  }

};


class adaptivepoisson_exterior_facet_integral_4_otherwise: public ufc::exterior_facet_integral
{
public:

  adaptivepoisson_exterior_facet_integral_4_otherwise() : ufc::exterior_facet_integral()
  {
    
  }

  ~adaptivepoisson_exterior_facet_integral_4_otherwise() override
  {
    
  }

  const std::vector<bool> & enabled_coefficients() const final override
  {
    static const std::vector<bool> enabled({false, true, false, true});
    return enabled;
  }

  void tabulate_tensor(double * A,
                       const double * const * w,
                       const double * coordinate_dofs,
                       std::size_t facet,
                       int cell_orientation) const final override
  {
    // Number of operations (multiply-add pairs) for Jacobian data:      4
    // Number of operations (multiply-add pairs) for geometry tensor:    0
    // Number of operations (multiply-add pairs) for tensor contraction: 0
    // Total number of operations (multiply-add pairs):                  4
    
    // Compute Jacobian
    double J[4];
    compute_jacobian_triangle_2d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[4];
    double detJ;
    compute_jacobian_inverse_triangle_2d(K, detJ, J);
    
    // Get vertices on edge
    
    // Compute scale factor (length of edge scaled by length of reference interval)
    
    
    // Compute geometry tensor
    
    
    // Compute element tensor
    switch (facet)
    {
    case 0:
      {
        A[0] = 0.0;
      A[1] = 0.0;
      A[2] = 0.0;
        break;
      }
    case 1:
      {
        A[0] = 0.0;
      A[1] = 0.0;
      A[2] = 0.0;
        break;
      }
    case 2:
      {
        A[0] = 0.0;
      A[1] = 0.0;
      A[2] = 0.0;
        break;
      }
    }
    
  }

};


class adaptivepoisson_exterior_facet_integral_5_otherwise: public ufc::exterior_facet_integral
{
public:

  adaptivepoisson_exterior_facet_integral_5_otherwise() : ufc::exterior_facet_integral()
  {
    
  }

  ~adaptivepoisson_exterior_facet_integral_5_otherwise() override
  {
    
  }

  const std::vector<bool> & enabled_coefficients() const final override
  {
    static const std::vector<bool> enabled({true});
    return enabled;
  }

  void tabulate_tensor(double * A,
                       const double * const * w,
                       const double * coordinate_dofs,
                       std::size_t facet,
                       int cell_orientation) const final override
  {
    // Number of operations (multiply-add pairs) for Jacobian data:      10
    // Number of operations (multiply-add pairs) for geometry tensor:    6
    // Number of operations (multiply-add pairs) for tensor contraction: 30
    // Total number of operations (multiply-add pairs):                  46
    
    // Compute Jacobian
    double J[4];
    compute_jacobian_triangle_2d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[4];
    double detJ;
    compute_jacobian_inverse_triangle_2d(K, detJ, J);
    
    // Get vertices on edge
    static unsigned int edge_vertices[3][2] = {{1, 2}, {0, 2}, {0, 1}};
    const unsigned int v0 = edge_vertices[facet][0];
    const unsigned int v1 = edge_vertices[facet][1];
    
    // Compute scale factor (length of edge scaled by length of reference interval)
    const double dx0 = coordinate_dofs[2*v1 + 0] - coordinate_dofs[2*v0 + 0];
    const double dx1 = coordinate_dofs[2*v1 + 1] - coordinate_dofs[2*v0 + 1];
    const double det = std::sqrt(dx0*dx0 + dx1*dx1);
    
    
    // Compute geometry tensor
    const double G0_0 = det*w[0][0]*(1.0);
    const double G0_1 = det*w[0][1]*(1.0);
    const double G0_2 = det*w[0][2]*(1.0);
    const double G0_3 = det*w[0][3]*(1.0);
    const double G0_4 = det*w[0][4]*(1.0);
    const double G0_5 = det*w[0][5]*(1.0);
    
    // Compute element tensor
    switch (facet)
    {
    case 0:
      {
        A[0] = 0.0;
      A[1] = 0.0;
      A[2] = 0.0;
      A[3] = 0.0;
      A[4] = 0.15*G0_1 - 0.0166666666666666*G0_2 + 0.2*G0_3;
      A[5] = 0.0166666666666666*G0_1 + 0.0166666666666667*G0_2 + 0.133333333333333*G0_3;
      A[6] = 0.0;
      A[7] = 0.0166666666666666*G0_1 + 0.0166666666666667*G0_2 + 0.133333333333333*G0_3;
      A[8] = -0.0166666666666667*G0_1 + 0.15*G0_2 + 0.2*G0_3;
        break;
      }
    case 1:
      {
        A[0] = 0.15*G0_0 - 0.0166666666666666*G0_2 + 0.2*G0_4;
      A[1] = 0.0;
      A[2] = 0.0166666666666667*G0_0 + 0.0166666666666667*G0_2 + 0.133333333333333*G0_4;
      A[3] = 0.0;
      A[4] = 0.0;
      A[5] = 0.0;
      A[6] = 0.0166666666666667*G0_0 + 0.0166666666666667*G0_2 + 0.133333333333333*G0_4;
      A[7] = 0.0;
      A[8] = -0.0166666666666666*G0_0 + 0.15*G0_2 + 0.2*G0_4;
        break;
      }
    case 2:
      {
        A[0] = 0.15*G0_0 - 0.0166666666666666*G0_1 + 0.2*G0_5;
      A[1] = 0.0166666666666667*G0_0 + 0.0166666666666667*G0_1 + 0.133333333333333*G0_5;
      A[2] = 0.0;
      A[3] = 0.0166666666666667*G0_0 + 0.0166666666666667*G0_1 + 0.133333333333333*G0_5;
      A[4] = -0.0166666666666667*G0_0 + 0.15*G0_1 + 0.2*G0_5;
      A[5] = 0.0;
      A[6] = 0.0;
      A[7] = 0.0;
      A[8] = 0.0;
        break;
      }
    }
    
  }

};


class adaptivepoisson_interior_facet_integral_5_otherwise: public ufc::interior_facet_integral
{
public:

  adaptivepoisson_interior_facet_integral_5_otherwise() : ufc::interior_facet_integral()
  {
    
  }

  ~adaptivepoisson_interior_facet_integral_5_otherwise() override
  {
    
  }

  const std::vector<bool> & enabled_coefficients() const final override
  {
    static const std::vector<bool> enabled({true});
    return enabled;
  }

  void tabulate_tensor(double * A,
                       const double * const * w,
                       const double * coordinate_dofs_0,
                       const double * coordinate_dofs_1,
                       std::size_t facet_0,
                       std::size_t facet_1,
                       int cell_orientation_0,
                       int cell_orientation_1) const final override
  {
    // Number of operations (multiply-add pairs) for Jacobian data:      12
    // Number of operations (multiply-add pairs) for geometry tensor:    12
    // Number of operations (multiply-add pairs) for tensor contraction: 180
    // Total number of operations (multiply-add pairs):                  204
    
    // Compute Jacobian
    double J_0[4];
    compute_jacobian_triangle_2d(J_0, coordinate_dofs_0);
    
    // Compute Jacobian inverse and determinant
    double K_0[4];
    double detJ_0;
    compute_jacobian_inverse_triangle_2d(K_0, detJ_0, J_0);
    
    // Compute Jacobian
    double J_1[4];
    compute_jacobian_triangle_2d(J_1, coordinate_dofs_1);
    
    // Compute Jacobian inverse and determinant
    double K_1[4];
    double detJ_1;
    compute_jacobian_inverse_triangle_2d(K_1, detJ_1, J_1);
    
    // Get vertices on edge
    static unsigned int edge_vertices[3][2] = {{1, 2}, {0, 2}, {0, 1}};
    const unsigned int v0 = edge_vertices[facet_0][0];
    const unsigned int v1 = edge_vertices[facet_0][1];
    
    // Compute scale factor (length of edge scaled by length of reference interval)
    const double dx0 = coordinate_dofs_0[2*v1 + 0] - coordinate_dofs_0[2*v0 + 0];
    const double dx1 = coordinate_dofs_0[2*v1 + 1] - coordinate_dofs_0[2*v0 + 1];
    const double det = std::sqrt(dx0*dx0 + dx1*dx1);
    
    
    
    // Compute geometry tensor
    const double G0_0 = det*w[0][0]*(1.0);
    const double G0_1 = det*w[0][1]*(1.0);
    const double G0_2 = det*w[0][2]*(1.0);
    const double G0_3 = det*w[0][3]*(1.0);
    const double G0_4 = det*w[0][4]*(1.0);
    const double G0_5 = det*w[0][5]*(1.0);
    const double G1_6 = det*w[0][6]*(1.0);
    const double G1_7 = det*w[0][7]*(1.0);
    const double G1_8 = det*w[0][8]*(1.0);
    const double G1_9 = det*w[0][9]*(1.0);
    const double G1_10 = det*w[0][10]*(1.0);
    const double G1_11 = det*w[0][11]*(1.0);
    
    // Compute element tensor
    switch (facet_0)
    {
    case 0:
      {
        switch (facet_1)
      {
      case 0:
        {
          A[0] = 0.0;
        A[1] = 0.0;
        A[2] = 0.0;
        A[3] = 0.0;
        A[4] = 0.0;
        A[5] = 0.0;
        A[6] = 0.0;
        A[7] = 0.15*G0_1 - 0.0166666666666666*G0_2 + 0.2*G0_3;
        A[8] = 0.0166666666666666*G0_1 + 0.0166666666666667*G0_2 + 0.133333333333333*G0_3;
        A[9] = 0.0;
        A[10] = 0.0;
        A[11] = 0.0;
        A[12] = 0.0;
        A[13] = 0.0166666666666666*G0_1 + 0.0166666666666667*G0_2 + 0.133333333333333*G0_3;
        A[14] = -0.0166666666666667*G0_1 + 0.15*G0_2 + 0.2*G0_3;
        A[15] = 0.0;
        A[16] = 0.0;
        A[17] = 0.0;
        A[18] = 0.0;
        A[19] = 0.0;
        A[20] = 0.0;
        A[21] = 0.0;
        A[22] = 0.0;
        A[23] = 0.0;
        A[24] = 0.0;
        A[25] = 0.0;
        A[26] = 0.0;
        A[27] = 0.0;
        A[28] = 0.15*G1_7 - 0.0166666666666666*G1_8 + 0.2*G1_9;
        A[29] = 0.0166666666666666*G1_7 + 0.0166666666666667*G1_8 + 0.133333333333333*G1_9;
        A[30] = 0.0;
        A[31] = 0.0;
        A[32] = 0.0;
        A[33] = 0.0;
        A[34] = 0.0166666666666666*G1_7 + 0.0166666666666667*G1_8 + 0.133333333333333*G1_9;
        A[35] = -0.0166666666666667*G1_7 + 0.15*G1_8 + 0.2*G1_9;
          break;
        }
      case 1:
        {
          A[0] = 0.0;
        A[1] = 0.0;
        A[2] = 0.0;
        A[3] = 0.0;
        A[4] = 0.0;
        A[5] = 0.0;
        A[6] = 0.0;
        A[7] = 0.15*G0_1 - 0.0166666666666666*G0_2 + 0.2*G0_3;
        A[8] = 0.0166666666666666*G0_1 + 0.0166666666666667*G0_2 + 0.133333333333333*G0_3;
        A[9] = 0.0;
        A[10] = 0.0;
        A[11] = 0.0;
        A[12] = 0.0;
        A[13] = 0.0166666666666666*G0_1 + 0.0166666666666667*G0_2 + 0.133333333333333*G0_3;
        A[14] = -0.0166666666666667*G0_1 + 0.15*G0_2 + 0.2*G0_3;
        A[15] = 0.0;
        A[16] = 0.0;
        A[17] = 0.0;
        A[18] = 0.0;
        A[19] = 0.0;
        A[20] = 0.0;
        A[21] = 0.15*G1_6 - 0.0166666666666666*G1_8 + 0.2*G1_10;
        A[22] = 0.0;
        A[23] = 0.0166666666666667*G1_6 + 0.0166666666666667*G1_8 + 0.133333333333333*G1_10;
        A[24] = 0.0;
        A[25] = 0.0;
        A[26] = 0.0;
        A[27] = 0.0;
        A[28] = 0.0;
        A[29] = 0.0;
        A[30] = 0.0;
        A[31] = 0.0;
        A[32] = 0.0;
        A[33] = 0.0166666666666667*G1_6 + 0.0166666666666667*G1_8 + 0.133333333333333*G1_10;
        A[34] = 0.0;
        A[35] = -0.0166666666666666*G1_6 + 0.15*G1_8 + 0.2*G1_10;
          break;
        }
      case 2:
        {
          A[0] = 0.0;
        A[1] = 0.0;
        A[2] = 0.0;
        A[3] = 0.0;
        A[4] = 0.0;
        A[5] = 0.0;
        A[6] = 0.0;
        A[7] = 0.15*G0_1 - 0.0166666666666666*G0_2 + 0.2*G0_3;
        A[8] = 0.0166666666666666*G0_1 + 0.0166666666666667*G0_2 + 0.133333333333333*G0_3;
        A[9] = 0.0;
        A[10] = 0.0;
        A[11] = 0.0;
        A[12] = 0.0;
        A[13] = 0.0166666666666666*G0_1 + 0.0166666666666667*G0_2 + 0.133333333333333*G0_3;
        A[14] = -0.0166666666666667*G0_1 + 0.15*G0_2 + 0.2*G0_3;
        A[15] = 0.0;
        A[16] = 0.0;
        A[17] = 0.0;
        A[18] = 0.0;
        A[19] = 0.0;
        A[20] = 0.0;
        A[21] = 0.15*G1_6 - 0.0166666666666666*G1_7 + 0.2*G1_11;
        A[22] = 0.0166666666666667*G1_6 + 0.0166666666666667*G1_7 + 0.133333333333333*G1_11;
        A[23] = 0.0;
        A[24] = 0.0;
        A[25] = 0.0;
        A[26] = 0.0;
        A[27] = 0.0166666666666667*G1_6 + 0.0166666666666667*G1_7 + 0.133333333333333*G1_11;
        A[28] = -0.0166666666666667*G1_6 + 0.15*G1_7 + 0.2*G1_11;
        A[29] = 0.0;
        A[30] = 0.0;
        A[31] = 0.0;
        A[32] = 0.0;
        A[33] = 0.0;
        A[34] = 0.0;
        A[35] = 0.0;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        switch (facet_1)
      {
      case 0:
        {
          A[0] = 0.15*G0_0 - 0.0166666666666666*G0_2 + 0.2*G0_4;
        A[1] = 0.0;
        A[2] = 0.0166666666666667*G0_0 + 0.0166666666666667*G0_2 + 0.133333333333333*G0_4;
        A[3] = 0.0;
        A[4] = 0.0;
        A[5] = 0.0;
        A[6] = 0.0;
        A[7] = 0.0;
        A[8] = 0.0;
        A[9] = 0.0;
        A[10] = 0.0;
        A[11] = 0.0;
        A[12] = 0.0166666666666667*G0_0 + 0.0166666666666667*G0_2 + 0.133333333333333*G0_4;
        A[13] = 0.0;
        A[14] = -0.0166666666666666*G0_0 + 0.15*G0_2 + 0.2*G0_4;
        A[15] = 0.0;
        A[16] = 0.0;
        A[17] = 0.0;
        A[18] = 0.0;
        A[19] = 0.0;
        A[20] = 0.0;
        A[21] = 0.0;
        A[22] = 0.0;
        A[23] = 0.0;
        A[24] = 0.0;
        A[25] = 0.0;
        A[26] = 0.0;
        A[27] = 0.0;
        A[28] = 0.15*G1_7 - 0.0166666666666666*G1_8 + 0.2*G1_9;
        A[29] = 0.0166666666666666*G1_7 + 0.0166666666666667*G1_8 + 0.133333333333333*G1_9;
        A[30] = 0.0;
        A[31] = 0.0;
        A[32] = 0.0;
        A[33] = 0.0;
        A[34] = 0.0166666666666666*G1_7 + 0.0166666666666667*G1_8 + 0.133333333333333*G1_9;
        A[35] = -0.0166666666666667*G1_7 + 0.15*G1_8 + 0.2*G1_9;
          break;
        }
      case 1:
        {
          A[0] = 0.15*G0_0 - 0.0166666666666666*G0_2 + 0.2*G0_4;
        A[1] = 0.0;
        A[2] = 0.0166666666666667*G0_0 + 0.0166666666666667*G0_2 + 0.133333333333333*G0_4;
        A[3] = 0.0;
        A[4] = 0.0;
        A[5] = 0.0;
        A[6] = 0.0;
        A[7] = 0.0;
        A[8] = 0.0;
        A[9] = 0.0;
        A[10] = 0.0;
        A[11] = 0.0;
        A[12] = 0.0166666666666667*G0_0 + 0.0166666666666667*G0_2 + 0.133333333333333*G0_4;
        A[13] = 0.0;
        A[14] = -0.0166666666666666*G0_0 + 0.15*G0_2 + 0.2*G0_4;
        A[15] = 0.0;
        A[16] = 0.0;
        A[17] = 0.0;
        A[18] = 0.0;
        A[19] = 0.0;
        A[20] = 0.0;
        A[21] = 0.15*G1_6 - 0.0166666666666666*G1_8 + 0.2*G1_10;
        A[22] = 0.0;
        A[23] = 0.0166666666666667*G1_6 + 0.0166666666666667*G1_8 + 0.133333333333333*G1_10;
        A[24] = 0.0;
        A[25] = 0.0;
        A[26] = 0.0;
        A[27] = 0.0;
        A[28] = 0.0;
        A[29] = 0.0;
        A[30] = 0.0;
        A[31] = 0.0;
        A[32] = 0.0;
        A[33] = 0.0166666666666667*G1_6 + 0.0166666666666667*G1_8 + 0.133333333333333*G1_10;
        A[34] = 0.0;
        A[35] = -0.0166666666666666*G1_6 + 0.15*G1_8 + 0.2*G1_10;
          break;
        }
      case 2:
        {
          A[0] = 0.15*G0_0 - 0.0166666666666666*G0_2 + 0.2*G0_4;
        A[1] = 0.0;
        A[2] = 0.0166666666666667*G0_0 + 0.0166666666666667*G0_2 + 0.133333333333333*G0_4;
        A[3] = 0.0;
        A[4] = 0.0;
        A[5] = 0.0;
        A[6] = 0.0;
        A[7] = 0.0;
        A[8] = 0.0;
        A[9] = 0.0;
        A[10] = 0.0;
        A[11] = 0.0;
        A[12] = 0.0166666666666667*G0_0 + 0.0166666666666667*G0_2 + 0.133333333333333*G0_4;
        A[13] = 0.0;
        A[14] = -0.0166666666666666*G0_0 + 0.15*G0_2 + 0.2*G0_4;
        A[15] = 0.0;
        A[16] = 0.0;
        A[17] = 0.0;
        A[18] = 0.0;
        A[19] = 0.0;
        A[20] = 0.0;
        A[21] = 0.15*G1_6 - 0.0166666666666666*G1_7 + 0.2*G1_11;
        A[22] = 0.0166666666666667*G1_6 + 0.0166666666666667*G1_7 + 0.133333333333333*G1_11;
        A[23] = 0.0;
        A[24] = 0.0;
        A[25] = 0.0;
        A[26] = 0.0;
        A[27] = 0.0166666666666667*G1_6 + 0.0166666666666667*G1_7 + 0.133333333333333*G1_11;
        A[28] = -0.0166666666666667*G1_6 + 0.15*G1_7 + 0.2*G1_11;
        A[29] = 0.0;
        A[30] = 0.0;
        A[31] = 0.0;
        A[32] = 0.0;
        A[33] = 0.0;
        A[34] = 0.0;
        A[35] = 0.0;
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        switch (facet_1)
      {
      case 0:
        {
          A[0] = 0.15*G0_0 - 0.0166666666666666*G0_1 + 0.2*G0_5;
        A[1] = 0.0166666666666667*G0_0 + 0.0166666666666667*G0_1 + 0.133333333333333*G0_5;
        A[2] = 0.0;
        A[3] = 0.0;
        A[4] = 0.0;
        A[5] = 0.0;
        A[6] = 0.0166666666666667*G0_0 + 0.0166666666666667*G0_1 + 0.133333333333333*G0_5;
        A[7] = -0.0166666666666667*G0_0 + 0.15*G0_1 + 0.2*G0_5;
        A[8] = 0.0;
        A[9] = 0.0;
        A[10] = 0.0;
        A[11] = 0.0;
        A[12] = 0.0;
        A[13] = 0.0;
        A[14] = 0.0;
        A[15] = 0.0;
        A[16] = 0.0;
        A[17] = 0.0;
        A[18] = 0.0;
        A[19] = 0.0;
        A[20] = 0.0;
        A[21] = 0.0;
        A[22] = 0.0;
        A[23] = 0.0;
        A[24] = 0.0;
        A[25] = 0.0;
        A[26] = 0.0;
        A[27] = 0.0;
        A[28] = 0.15*G1_7 - 0.0166666666666666*G1_8 + 0.2*G1_9;
        A[29] = 0.0166666666666666*G1_7 + 0.0166666666666667*G1_8 + 0.133333333333333*G1_9;
        A[30] = 0.0;
        A[31] = 0.0;
        A[32] = 0.0;
        A[33] = 0.0;
        A[34] = 0.0166666666666666*G1_7 + 0.0166666666666667*G1_8 + 0.133333333333333*G1_9;
        A[35] = -0.0166666666666667*G1_7 + 0.15*G1_8 + 0.2*G1_9;
          break;
        }
      case 1:
        {
          A[0] = 0.15*G0_0 - 0.0166666666666666*G0_1 + 0.2*G0_5;
        A[1] = 0.0166666666666667*G0_0 + 0.0166666666666667*G0_1 + 0.133333333333333*G0_5;
        A[2] = 0.0;
        A[3] = 0.0;
        A[4] = 0.0;
        A[5] = 0.0;
        A[6] = 0.0166666666666667*G0_0 + 0.0166666666666667*G0_1 + 0.133333333333333*G0_5;
        A[7] = -0.0166666666666667*G0_0 + 0.15*G0_1 + 0.2*G0_5;
        A[8] = 0.0;
        A[9] = 0.0;
        A[10] = 0.0;
        A[11] = 0.0;
        A[12] = 0.0;
        A[13] = 0.0;
        A[14] = 0.0;
        A[15] = 0.0;
        A[16] = 0.0;
        A[17] = 0.0;
        A[18] = 0.0;
        A[19] = 0.0;
        A[20] = 0.0;
        A[21] = 0.15*G1_6 - 0.0166666666666666*G1_8 + 0.2*G1_10;
        A[22] = 0.0;
        A[23] = 0.0166666666666667*G1_6 + 0.0166666666666667*G1_8 + 0.133333333333333*G1_10;
        A[24] = 0.0;
        A[25] = 0.0;
        A[26] = 0.0;
        A[27] = 0.0;
        A[28] = 0.0;
        A[29] = 0.0;
        A[30] = 0.0;
        A[31] = 0.0;
        A[32] = 0.0;
        A[33] = 0.0166666666666667*G1_6 + 0.0166666666666667*G1_8 + 0.133333333333333*G1_10;
        A[34] = 0.0;
        A[35] = -0.0166666666666666*G1_6 + 0.15*G1_8 + 0.2*G1_10;
          break;
        }
      case 2:
        {
          A[0] = 0.15*G0_0 - 0.0166666666666666*G0_1 + 0.2*G0_5;
        A[1] = 0.0166666666666667*G0_0 + 0.0166666666666667*G0_1 + 0.133333333333333*G0_5;
        A[2] = 0.0;
        A[3] = 0.0;
        A[4] = 0.0;
        A[5] = 0.0;
        A[6] = 0.0166666666666667*G0_0 + 0.0166666666666667*G0_1 + 0.133333333333333*G0_5;
        A[7] = -0.0166666666666667*G0_0 + 0.15*G0_1 + 0.2*G0_5;
        A[8] = 0.0;
        A[9] = 0.0;
        A[10] = 0.0;
        A[11] = 0.0;
        A[12] = 0.0;
        A[13] = 0.0;
        A[14] = 0.0;
        A[15] = 0.0;
        A[16] = 0.0;
        A[17] = 0.0;
        A[18] = 0.0;
        A[19] = 0.0;
        A[20] = 0.0;
        A[21] = 0.15*G1_6 - 0.0166666666666666*G1_7 + 0.2*G1_11;
        A[22] = 0.0166666666666667*G1_6 + 0.0166666666666667*G1_7 + 0.133333333333333*G1_11;
        A[23] = 0.0;
        A[24] = 0.0;
        A[25] = 0.0;
        A[26] = 0.0;
        A[27] = 0.0166666666666667*G1_6 + 0.0166666666666667*G1_7 + 0.133333333333333*G1_11;
        A[28] = -0.0166666666666667*G1_6 + 0.15*G1_7 + 0.2*G1_11;
        A[29] = 0.0;
        A[30] = 0.0;
        A[31] = 0.0;
        A[32] = 0.0;
        A[33] = 0.0;
        A[34] = 0.0;
        A[35] = 0.0;
          break;
        }
      }
      
        break;
      }
    }
    
  }

};


class adaptivepoisson_cell_integral_6_otherwise: public ufc::cell_integral
{
public:

  adaptivepoisson_cell_integral_6_otherwise() : ufc::cell_integral()
  {
    
  }

  ~adaptivepoisson_cell_integral_6_otherwise() override
  {
    
  }

  const std::vector<bool> & enabled_coefficients() const final override
  {
    static const std::vector<bool> enabled({true, false, true, true, true});
    return enabled;
  }

  void tabulate_tensor(double * A,
                       const double * const * w,
                       const double * coordinate_dofs,
                       int cell_orientation) const final override
  {
    // Compute Jacobian
    double J[4];
    compute_jacobian_triangle_2d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[4];
    double detJ;
    compute_jacobian_inverse_triangle_2d(K, detJ, J);
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Compute cell volume
    
    
    // Compute circumradius of triangle in 2D
    
    
    // Array of quadrature weights.
    static const double W6[6] = {0.054975871827661, 0.054975871827661, 0.054975871827661, 0.111690794839005, 0.111690794839005, 0.111690794839005};
    // Quadrature points on the UFC reference element: (0.816847572980459, 0.091576213509771), (0.091576213509771, 0.816847572980459), (0.091576213509771, 0.091576213509771), (0.10810301816807, 0.445948490915965), (0.445948490915965, 0.10810301816807), (0.445948490915965, 0.445948490915965)
    
    // Values of basis functions at quadrature points.
    static const double FE0[6][3] = \
    {{0.09157621350977, 0.816847572980459, 0.091576213509771},
    {0.0915762135097701, 0.0915762135097711, 0.816847572980459},
    {0.816847572980458, 0.091576213509771, 0.091576213509771},
    {0.445948490915965, 0.10810301816807, 0.445948490915965},
    {0.445948490915965, 0.445948490915965, 0.10810301816807},
    {0.10810301816807, 0.445948490915965, 0.445948490915965}};
    
    static const double FE0_D01[6][2] = \
    {{-1.0, 1.0},
    {-1.0, 1.0},
    {-1.0, 1.0},
    {-1.0, 1.0},
    {-1.0, 1.0},
    {-1.0, 1.0}};
    
    // Array of non-zero columns
    static const unsigned int nzc0[2] = {0, 2};
    
    // Array of non-zero columns
    static const unsigned int nzc1[2] = {0, 1};
    
    static const double FE2[6][6] = \
    {{-0.074803807748196, 0.517632341987673, -0.0748038077481966, 0.299215230992787, 0.0335448115231483, 0.299215230992784},
    {-0.074803807748196, -0.0748038077481966, 0.517632341987674, 0.299215230992787, 0.299215230992784, 0.0335448115231483},
    {0.517632341987671, -0.0748038077481966, -0.0748038077481966, 0.0335448115231487, 0.299215230992787, 0.299215230992787},
    {-0.0482083778155119, -0.0847304930939778, -0.0482083778155119, 0.192833511262048, 0.795480226200906, 0.192833511262048},
    {-0.0482083778155119, -0.048208377815512, -0.0847304930939778, 0.192833511262048, 0.192833511262048, 0.795480226200906},
    {-0.0847304930939778, -0.048208377815512, -0.0482083778155119, 0.795480226200906, 0.192833511262048, 0.192833511262048}};
    
    static const double FE2_D01[6][5] = \
    {{0.633695145960915, -0.633695145960916, 3.26739029192182, 0.0, -3.26739029192184},
    {0.633695145960915, 2.26739029192184, 0.366304854039068, -2.90108543788275, -0.366304854039081},
    {-2.26739029192184, -0.633695145960916, 0.366304854039074, 2.90108543788276, -0.366304854039083},
    {-0.783793963663865, 0.783793963663862, 0.432412072672267, 0.0, -0.432412072672279},
    {-0.783793963663864, -0.567587927327719, 1.78379396366385, 1.35138189099159, -1.78379396366386},
    {0.567587927327715, 0.783793963663862, 1.78379396366385, -1.35138189099157, -1.78379396366386}};
    
    // Array of non-zero columns
    static const unsigned int nzc2[5] = {0, 2, 3, 4, 5};
    
    static const double FE2_D10[6][5] = \
    {{0.633695145960922, 2.26739029192184, 0.366304854039083, -0.366304854039083, -2.90108543788276},
    {0.63369514596092, -0.633695145960917, 3.26739029192183, -3.26739029192183, 0.0},
    {-2.26739029192183, -0.633695145960919, 0.366304854039083, -0.366304854039083, 2.90108543788275},
    {-0.78379396366386, -0.567587927327721, 1.78379396366386, -1.78379396366386, 1.35138189099158},
    {-0.783793963663859, 0.783793963663859, 0.432412072672279, -0.432412072672279, 0.0},
    {0.567587927327721, 0.783793963663861, 1.78379396366386, -1.78379396366386, -1.35138189099158}};
    
    // Array of non-zero columns
    static const unsigned int nzc3[5] = {0, 1, 3, 4, 5};
    
    // Reset values in the element tensor.
    for (unsigned int r = 0; r < 3; r++)
    {
      A[r] = 0.0;
    } // end loop over 'r'
    // Number of operations to compute geometry constants: 12.
    double G[3];
    G[0] =  - det*(K[0]*K[2] + K[1]*K[3]);
    G[1] =  - det*(K[2]*K[2] + K[3]*K[3]);
    G[2] =  - det*(K[0]*K[0] + K[1]*K[1]);
    
    // Compute element tensor using UFL quadrature representation
    // Optimisations: ('eliminate zeros', True), ('ignore ones', True), ('ignore zero tables', True), ('optimisation', 'simplify_expressions'), ('remove zero terms', True)
    
    // Loop quadrature points for integral.
    // Number of operations to compute element tensor for following IP loop = 546
    for (unsigned int ip = 0; ip < 6; ip++)
    {
      
      // Coefficient declarations.
      double F0 = 0.0;
      double F1 = 0.0;
      double F2 = 0.0;
      double F3 = 0.0;
      double F4 = 0.0;
      double F5 = 0.0;
      double F6 = 0.0;
      
      // Total number of operations to compute function values = 8
      for (unsigned int r = 0; r < 2; r++)
      {
        F5 += FE0_D01[ip][r]*w[2][nzc1[r]];
        F6 += FE0_D01[ip][r]*w[2][nzc0[r]];
      } // end loop over 'r'
      
      // Total number of operations to compute function values = 12
      for (unsigned int r = 0; r < 3; r++)
      {
        F0 += FE0[ip][r]*w[0][r];
        F2 += FE0[ip][r]*w[3][r];
      } // end loop over 'r'
      
      // Total number of operations to compute function values = 20
      for (unsigned int r = 0; r < 5; r++)
      {
        F3 += FE2_D10[ip][r]*w[4][nzc3[r]];
        F4 += FE2_D01[ip][r]*w[4][nzc2[r]];
      } // end loop over 'r'
      
      // Total number of operations to compute function values = 12
      for (unsigned int r = 0; r < 6; r++)
      {
        F1 += FE2[ip][r]*w[4][r];
      } // end loop over 'r'
      
      // Number of operations to compute ip constants: 25
      double I[3];
      // Number of operations: 5
      I[0] = F1*W6[ip]*(F5*G[0] + F6*G[1]);
      
      // Number of operations: 5
      I[1] = F1*W6[ip]*(F5*G[2] + F6*G[0]);
      
      // Number of operations: 15
      I[2] = W6[ip]*(F1*det*(F0 - F2) + F3*F5*G[2] + F4*F6*G[1] + G[0]*(F3*F6 + F4*F5));
      
      
      // Number of operations for primary indices: 8
      for (unsigned int j = 0; j < 2; j++)
      {
        // Number of operations to compute entry: 2
        A[nzc0[j]] += FE0_D01[ip][j]*I[0];
        // Number of operations to compute entry: 2
        A[nzc1[j]] += FE0_D01[ip][j]*I[1];
      } // end loop over 'j'
      
      // Number of operations for primary indices: 6
      for (unsigned int j = 0; j < 3; j++)
      {
        // Number of operations to compute entry: 2
        A[j] += FE0[ip][j]*I[2];
      } // end loop over 'j'
    } // end loop over 'ip'
  }

};


class adaptivepoisson_exterior_facet_integral_6_otherwise: public ufc::exterior_facet_integral
{
public:

  adaptivepoisson_exterior_facet_integral_6_otherwise() : ufc::exterior_facet_integral()
  {
    
  }

  ~adaptivepoisson_exterior_facet_integral_6_otherwise() override
  {
    
  }

  const std::vector<bool> & enabled_coefficients() const final override
  {
    static const std::vector<bool> enabled({false, true, false, false, true});
    return enabled;
  }

  void tabulate_tensor(double * A,
                       const double * const * w,
                       const double * coordinate_dofs,
                       std::size_t facet,
                       int cell_orientation) const final override
  {
    // Number of operations (multiply-add pairs) for Jacobian data:      10
    // Number of operations (multiply-add pairs) for geometry tensor:    22
    // Number of operations (multiply-add pairs) for tensor contraction: 33
    // Total number of operations (multiply-add pairs):                  65
    
    // Compute Jacobian
    double J[4];
    compute_jacobian_triangle_2d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[4];
    double detJ;
    compute_jacobian_inverse_triangle_2d(K, detJ, J);
    
    // Get vertices on edge
    static unsigned int edge_vertices[3][2] = {{1, 2}, {0, 2}, {0, 1}};
    const unsigned int v0 = edge_vertices[facet][0];
    const unsigned int v1 = edge_vertices[facet][1];
    
    // Compute scale factor (length of edge scaled by length of reference interval)
    const double dx0 = coordinate_dofs[2*v1 + 0] - coordinate_dofs[2*v0 + 0];
    const double dx1 = coordinate_dofs[2*v1 + 1] - coordinate_dofs[2*v0 + 1];
    const double det = std::sqrt(dx0*dx0 + dx1*dx1);
    
    
    // Compute geometry tensor
    const double G0_0_0 = det*w[1][0]*w[4][0]*(1.0);
    const double G0_0_1 = det*w[1][0]*w[4][1]*(1.0);
    const double G0_0_2 = det*w[1][0]*w[4][2]*(1.0);
    const double G0_0_4 = det*w[1][0]*w[4][4]*(1.0);
    const double G0_0_5 = det*w[1][0]*w[4][5]*(1.0);
    const double G0_1_0 = det*w[1][1]*w[4][0]*(1.0);
    const double G0_1_1 = det*w[1][1]*w[4][1]*(1.0);
    const double G0_1_2 = det*w[1][1]*w[4][2]*(1.0);
    const double G0_1_3 = det*w[1][1]*w[4][3]*(1.0);
    const double G0_1_5 = det*w[1][1]*w[4][5]*(1.0);
    const double G0_2_0 = det*w[1][2]*w[4][0]*(1.0);
    const double G0_2_1 = det*w[1][2]*w[4][1]*(1.0);
    const double G0_2_2 = det*w[1][2]*w[4][2]*(1.0);
    const double G0_2_3 = det*w[1][2]*w[4][3]*(1.0);
    const double G0_2_4 = det*w[1][2]*w[4][4]*(1.0);
    
    // Compute element tensor
    switch (facet)
    {
    case 0:
      {
        A[0] = 0.0;
      A[1] = 0.15*G0_1_1 - 0.0166666666666666*G0_1_2 + 0.2*G0_1_3 + 0.0166666666666666*G0_2_1 + 0.0166666666666667*G0_2_2 + 0.133333333333333*G0_2_3;
      A[2] = 0.0166666666666666*G0_1_1 + 0.0166666666666667*G0_1_2 + 0.133333333333333*G0_1_3 - 0.0166666666666667*G0_2_1 + 0.15*G0_2_2 + 0.2*G0_2_3;
        break;
      }
    case 1:
      {
        A[0] = 0.15*G0_0_0 - 0.0166666666666666*G0_0_2 + 0.2*G0_0_4 + 0.0166666666666667*G0_2_0 + 0.0166666666666667*G0_2_2 + 0.133333333333333*G0_2_4;
      A[1] = 0.0;
      A[2] = 0.0166666666666667*G0_0_0 + 0.0166666666666667*G0_0_2 + 0.133333333333333*G0_0_4 - 0.0166666666666666*G0_2_0 + 0.15*G0_2_2 + 0.2*G0_2_4;
        break;
      }
    case 2:
      {
        A[0] = 0.15*G0_0_0 - 0.0166666666666666*G0_0_1 + 0.2*G0_0_5 + 0.0166666666666667*G0_1_0 + 0.0166666666666667*G0_1_1 + 0.133333333333333*G0_1_5;
      A[1] = 0.0166666666666667*G0_0_0 + 0.0166666666666667*G0_0_1 + 0.133333333333333*G0_0_5 - 0.0166666666666667*G0_1_0 + 0.15*G0_1_1 + 0.2*G0_1_5;
      A[2] = 0.0;
        break;
      }
    }
    
  }

};


class adaptivepoisson_cell_integral_7_otherwise: public ufc::cell_integral
{
public:

  adaptivepoisson_cell_integral_7_otherwise() : ufc::cell_integral()
  {
    
  }

  ~adaptivepoisson_cell_integral_7_otherwise() override
  {
    
  }

  const std::vector<bool> & enabled_coefficients() const final override
  {
    static const std::vector<bool> enabled({true, true, false, true});
    return enabled;
  }

  void tabulate_tensor(double * A,
                       const double * const * w,
                       const double * coordinate_dofs,
                       int cell_orientation) const final override
  {
    // Number of operations (multiply-add pairs) for Jacobian data:      3
    // Number of operations (multiply-add pairs) for geometry tensor:    40
    // Number of operations (multiply-add pairs) for tensor contraction: 26
    // Total number of operations (multiply-add pairs):                  69
    
    // Compute Jacobian
    double J[4];
    compute_jacobian_triangle_2d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[4];
    double detJ;
    compute_jacobian_inverse_triangle_2d(K, detJ, J);
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Compute geometry tensor
    const double G0_0_0 = det*w[1][0]*w[0][0]*(1.0);
    const double G0_0_1 = det*w[1][0]*w[0][1]*(1.0);
    const double G0_0_2 = det*w[1][0]*w[0][2]*(1.0);
    const double G0_0_3 = det*w[1][0]*w[0][3]*(1.0);
    const double G0_0_4 = det*w[1][0]*w[0][4]*(1.0);
    const double G0_0_5 = det*w[1][0]*w[0][5]*(1.0);
    const double G0_1_0 = det*w[1][1]*w[0][0]*(1.0);
    const double G0_1_1 = det*w[1][1]*w[0][1]*(1.0);
    const double G0_1_2 = det*w[1][1]*w[0][2]*(1.0);
    const double G0_1_3 = det*w[1][1]*w[0][3]*(1.0);
    const double G0_1_4 = det*w[1][1]*w[0][4]*(1.0);
    const double G0_1_5 = det*w[1][1]*w[0][5]*(1.0);
    const double G0_2_0 = det*w[1][2]*w[0][0]*(1.0);
    const double G0_2_1 = det*w[1][2]*w[0][1]*(1.0);
    const double G0_2_2 = det*w[1][2]*w[0][2]*(1.0);
    const double G0_2_3 = det*w[1][2]*w[0][3]*(1.0);
    const double G0_2_4 = det*w[1][2]*w[0][4]*(1.0);
    const double G0_2_5 = det*w[1][2]*w[0][5]*(1.0);
    const double G1_0_0 = det*w[1][0]*w[3][0]*(1.0);
    const double G1_0_1 = det*w[1][0]*w[3][1]*(1.0);
    const double G1_0_2 = det*w[1][0]*w[3][2]*(1.0);
    const double G1_1_0 = det*w[1][1]*w[3][0]*(1.0);
    const double G1_1_1 = det*w[1][1]*w[3][1]*(1.0);
    const double G1_1_2 = det*w[1][1]*w[3][2]*(1.0);
    const double G1_2_0 = det*w[1][2]*w[3][0]*(1.0);
    const double G1_2_1 = det*w[1][2]*w[3][1]*(1.0);
    const double G1_2_2 = det*w[1][2]*w[3][2]*(1.0);
    
    // Compute element tensor
    A[0] = 0.0166666666666666*G0_0_0 - 0.00833333333333333*G0_0_1 - 0.00833333333333332*G0_0_2 + 0.0333333333333333*G0_0_3 + 0.0666666666666667*G0_0_4 + 0.0666666666666667*G0_0_5 - 0.00833333333333332*G0_1_0 + 0.0166666666666666*G0_1_1 - 0.00833333333333332*G0_1_2 + 0.0666666666666667*G0_1_3 + 0.0333333333333333*G0_1_4 + 0.0666666666666667*G0_1_5 - 0.00833333333333332*G0_2_0 - 0.00833333333333333*G0_2_1 + 0.0166666666666666*G0_2_2 + 0.0666666666666667*G0_2_3 + 0.0666666666666667*G0_2_4 + 0.0333333333333333*G0_2_5 - 0.0833333333333333*G1_0_0 - 0.0416666666666667*G1_0_1 - 0.0416666666666667*G1_0_2 - 0.0416666666666667*G1_1_0 - 0.0833333333333333*G1_1_1 - 0.0416666666666667*G1_1_2 - 0.0416666666666667*G1_2_0 - 0.0416666666666667*G1_2_1 - 0.0833333333333333*G1_2_2;
  }

};


class adaptivepoisson_exterior_facet_integral_7_otherwise: public ufc::exterior_facet_integral
{
public:

  adaptivepoisson_exterior_facet_integral_7_otherwise() : ufc::exterior_facet_integral()
  {
    
  }

  ~adaptivepoisson_exterior_facet_integral_7_otherwise() override
  {
    
  }

  const std::vector<bool> & enabled_coefficients() const final override
  {
    static const std::vector<bool> enabled({true, false, true, true});
    return enabled;
  }

  void tabulate_tensor(double * A,
                       const double * const * w,
                       const double * coordinate_dofs,
                       std::size_t facet,
                       int cell_orientation) const final override
  {
    // Number of operations (multiply-add pairs) for Jacobian data:      10
    // Number of operations (multiply-add pairs) for geometry tensor:    27
    // Number of operations (multiply-add pairs) for tensor contraction: 22
    // Total number of operations (multiply-add pairs):                  59
    
    // Compute Jacobian
    double J[4];
    compute_jacobian_triangle_2d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[4];
    double detJ;
    compute_jacobian_inverse_triangle_2d(K, detJ, J);
    
    // Get vertices on edge
    static unsigned int edge_vertices[3][2] = {{1, 2}, {0, 2}, {0, 1}};
    const unsigned int v0 = edge_vertices[facet][0];
    const unsigned int v1 = edge_vertices[facet][1];
    
    // Compute scale factor (length of edge scaled by length of reference interval)
    const double dx0 = coordinate_dofs[2*v1 + 0] - coordinate_dofs[2*v0 + 0];
    const double dx1 = coordinate_dofs[2*v1 + 1] - coordinate_dofs[2*v0 + 1];
    const double det = std::sqrt(dx0*dx0 + dx1*dx1);
    
    
    // Compute geometry tensor
    const double G0_0_0 = det*w[2][0]*w[0][0]*(1.0);
    const double G0_0_4 = det*w[2][0]*w[0][4]*(1.0);
    const double G0_0_5 = det*w[2][0]*w[0][5]*(1.0);
    const double G0_1_1 = det*w[2][1]*w[0][1]*(1.0);
    const double G0_1_3 = det*w[2][1]*w[0][3]*(1.0);
    const double G0_1_5 = det*w[2][1]*w[0][5]*(1.0);
    const double G0_2_2 = det*w[2][2]*w[0][2]*(1.0);
    const double G0_2_3 = det*w[2][2]*w[0][3]*(1.0);
    const double G0_2_4 = det*w[2][2]*w[0][4]*(1.0);
    const double G1_0_0 = det*w[2][0]*w[3][0]*(1.0);
    const double G1_0_1 = det*w[2][0]*w[3][1]*(1.0);
    const double G1_0_2 = det*w[2][0]*w[3][2]*(1.0);
    const double G1_1_0 = det*w[2][1]*w[3][0]*(1.0);
    const double G1_1_1 = det*w[2][1]*w[3][1]*(1.0);
    const double G1_1_2 = det*w[2][1]*w[3][2]*(1.0);
    const double G1_2_0 = det*w[2][2]*w[3][0]*(1.0);
    const double G1_2_1 = det*w[2][2]*w[3][1]*(1.0);
    const double G1_2_2 = det*w[2][2]*w[3][2]*(1.0);
    
    // Compute element tensor
    switch (facet)
    {
    case 0:
      {
        A[0] = 0.166666666666666*G0_1_1 + 0.333333333333333*G0_1_3 + 0.166666666666667*G0_2_2 + 0.333333333333333*G0_2_3 - 0.333333333333333*G1_1_1 - 0.166666666666667*G1_1_2 - 0.166666666666667*G1_2_1 - 0.333333333333333*G1_2_2;
        break;
      }
    case 1:
      {
        A[0] = 0.166666666666667*G0_0_0 + 0.333333333333333*G0_0_4 + 0.166666666666667*G0_2_2 + 0.333333333333333*G0_2_4 - 0.333333333333333*G1_0_0 - 0.166666666666667*G1_0_2 - 0.166666666666667*G1_2_0 - 0.333333333333333*G1_2_2;
        break;
      }
    case 2:
      {
        A[0] = 0.166666666666667*G0_0_0 + 0.333333333333333*G0_0_5 + 0.166666666666666*G0_1_1 + 0.333333333333333*G0_1_5 - 0.333333333333333*G1_0_0 - 0.166666666666667*G1_0_1 - 0.166666666666667*G1_1_0 - 0.333333333333333*G1_1_1;
        break;
      }
    }
    
  }

};


class adaptivepoisson_interior_facet_integral_7_otherwise: public ufc::interior_facet_integral
{
public:

  adaptivepoisson_interior_facet_integral_7_otherwise() : ufc::interior_facet_integral()
  {
    
  }

  ~adaptivepoisson_interior_facet_integral_7_otherwise() override
  {
    
  }

  const std::vector<bool> & enabled_coefficients() const final override
  {
    static const std::vector<bool> enabled({true, false, true, true});
    return enabled;
  }

  void tabulate_tensor(double * A,
                       const double * const * w,
                       const double * coordinate_dofs_0,
                       const double * coordinate_dofs_1,
                       std::size_t facet_0,
                       std::size_t facet_1,
                       int cell_orientation_0,
                       int cell_orientation_1) const final override
  {
    // Number of operations (multiply-add pairs) for Jacobian data:      12
    // Number of operations (multiply-add pairs) for geometry tensor:    108
    // Number of operations (multiply-add pairs) for tensor contraction: 279
    // Total number of operations (multiply-add pairs):                  399
    
    // Compute Jacobian
    double J_0[4];
    compute_jacobian_triangle_2d(J_0, coordinate_dofs_0);
    
    // Compute Jacobian inverse and determinant
    double K_0[4];
    double detJ_0;
    compute_jacobian_inverse_triangle_2d(K_0, detJ_0, J_0);
    
    // Compute Jacobian
    double J_1[4];
    compute_jacobian_triangle_2d(J_1, coordinate_dofs_1);
    
    // Compute Jacobian inverse and determinant
    double K_1[4];
    double detJ_1;
    compute_jacobian_inverse_triangle_2d(K_1, detJ_1, J_1);
    
    // Get vertices on edge
    static unsigned int edge_vertices[3][2] = {{1, 2}, {0, 2}, {0, 1}};
    const unsigned int v0 = edge_vertices[facet_0][0];
    const unsigned int v1 = edge_vertices[facet_0][1];
    
    // Compute scale factor (length of edge scaled by length of reference interval)
    const double dx0 = coordinate_dofs_0[2*v1 + 0] - coordinate_dofs_0[2*v0 + 0];
    const double dx1 = coordinate_dofs_0[2*v1 + 1] - coordinate_dofs_0[2*v0 + 1];
    const double det = std::sqrt(dx0*dx0 + dx1*dx1);
    
    
    
    // Compute geometry tensor
    const double G0_0_0 = det*w[3][0]*w[2][0]*(1.0);
    const double G0_0_1 = det*w[3][0]*w[2][1]*(1.0);
    const double G0_0_2 = det*w[3][0]*w[2][2]*(1.0);
    const double G0_1_0 = det*w[3][1]*w[2][0]*(1.0);
    const double G0_1_1 = det*w[3][1]*w[2][1]*(1.0);
    const double G0_1_2 = det*w[3][1]*w[2][2]*(1.0);
    const double G0_2_0 = det*w[3][2]*w[2][0]*(1.0);
    const double G0_2_1 = det*w[3][2]*w[2][1]*(1.0);
    const double G0_2_2 = det*w[3][2]*w[2][2]*(1.0);
    const double G1_0_0 = det*w[3][0]*w[2][0]*(1.0);
    const double G1_0_1 = det*w[3][0]*w[2][1]*(1.0);
    const double G1_0_2 = det*w[3][0]*w[2][2]*(1.0);
    const double G1_1_0 = det*w[3][1]*w[2][0]*(1.0);
    const double G1_1_1 = det*w[3][1]*w[2][1]*(1.0);
    const double G1_1_2 = det*w[3][1]*w[2][2]*(1.0);
    const double G1_2_0 = det*w[3][2]*w[2][0]*(1.0);
    const double G1_2_1 = det*w[3][2]*w[2][1]*(1.0);
    const double G1_2_2 = det*w[3][2]*w[2][2]*(1.0);
    const double G2_0_0 = det*w[0][0]*w[2][0]*(1.0);
    const double G2_1_1 = det*w[0][1]*w[2][1]*(1.0);
    const double G2_2_2 = det*w[0][2]*w[2][2]*(1.0);
    const double G2_3_1 = det*w[0][3]*w[2][1]*(1.0);
    const double G2_3_2 = det*w[0][3]*w[2][2]*(1.0);
    const double G2_4_0 = det*w[0][4]*w[2][0]*(1.0);
    const double G2_4_2 = det*w[0][4]*w[2][2]*(1.0);
    const double G2_5_0 = det*w[0][5]*w[2][0]*(1.0);
    const double G2_5_1 = det*w[0][5]*w[2][1]*(1.0);
    const double G3_0_0 = det*w[0][0]*w[2][0]*(1.0);
    const double G3_1_1 = det*w[0][1]*w[2][1]*(1.0);
    const double G3_2_2 = det*w[0][2]*w[2][2]*(1.0);
    const double G3_3_1 = det*w[0][3]*w[2][1]*(1.0);
    const double G3_3_2 = det*w[0][3]*w[2][2]*(1.0);
    const double G3_4_0 = det*w[0][4]*w[2][0]*(1.0);
    const double G3_4_2 = det*w[0][4]*w[2][2]*(1.0);
    const double G3_5_0 = det*w[0][5]*w[2][0]*(1.0);
    const double G3_5_1 = det*w[0][5]*w[2][1]*(1.0);
    const double G4_3_3 = det*w[3][3]*w[2][3]*(1.0);
    const double G4_3_4 = det*w[3][3]*w[2][4]*(1.0);
    const double G4_3_5 = det*w[3][3]*w[2][5]*(1.0);
    const double G4_4_3 = det*w[3][4]*w[2][3]*(1.0);
    const double G4_4_4 = det*w[3][4]*w[2][4]*(1.0);
    const double G4_4_5 = det*w[3][4]*w[2][5]*(1.0);
    const double G4_5_3 = det*w[3][5]*w[2][3]*(1.0);
    const double G4_5_4 = det*w[3][5]*w[2][4]*(1.0);
    const double G4_5_5 = det*w[3][5]*w[2][5]*(1.0);
    const double G5_3_3 = det*w[3][3]*w[2][3]*(1.0);
    const double G5_3_4 = det*w[3][3]*w[2][4]*(1.0);
    const double G5_3_5 = det*w[3][3]*w[2][5]*(1.0);
    const double G5_4_3 = det*w[3][4]*w[2][3]*(1.0);
    const double G5_4_4 = det*w[3][4]*w[2][4]*(1.0);
    const double G5_4_5 = det*w[3][4]*w[2][5]*(1.0);
    const double G5_5_3 = det*w[3][5]*w[2][3]*(1.0);
    const double G5_5_4 = det*w[3][5]*w[2][4]*(1.0);
    const double G5_5_5 = det*w[3][5]*w[2][5]*(1.0);
    const double G6_6_3 = det*w[0][6]*w[2][3]*(1.0);
    const double G6_7_4 = det*w[0][7]*w[2][4]*(1.0);
    const double G6_8_5 = det*w[0][8]*w[2][5]*(1.0);
    const double G6_9_4 = det*w[0][9]*w[2][4]*(1.0);
    const double G6_9_5 = det*w[0][9]*w[2][5]*(1.0);
    const double G6_10_3 = det*w[0][10]*w[2][3]*(1.0);
    const double G6_10_5 = det*w[0][10]*w[2][5]*(1.0);
    const double G6_11_3 = det*w[0][11]*w[2][3]*(1.0);
    const double G6_11_4 = det*w[0][11]*w[2][4]*(1.0);
    const double G7_6_3 = det*w[0][6]*w[2][3]*(1.0);
    const double G7_7_4 = det*w[0][7]*w[2][4]*(1.0);
    const double G7_8_5 = det*w[0][8]*w[2][5]*(1.0);
    const double G7_9_4 = det*w[0][9]*w[2][4]*(1.0);
    const double G7_9_5 = det*w[0][9]*w[2][5]*(1.0);
    const double G7_10_3 = det*w[0][10]*w[2][3]*(1.0);
    const double G7_10_5 = det*w[0][10]*w[2][5]*(1.0);
    const double G7_11_3 = det*w[0][11]*w[2][3]*(1.0);
    const double G7_11_4 = det*w[0][11]*w[2][4]*(1.0);
    
    // Compute element tensor
    switch (facet_0)
    {
    case 0:
      {
        switch (facet_1)
      {
      case 0:
        {
          A[0] = -0.166666666666667*G0_1_1 - 0.0833333333333333*G0_1_2 - 0.0833333333333333*G0_2_1 - 0.166666666666667*G0_2_2 + 0.0833333333333332*G2_1_1 + 0.0833333333333333*G2_2_2 + 0.166666666666667*G2_3_1 + 0.166666666666667*G2_3_2 - 0.166666666666667*G4_4_4 - 0.0833333333333333*G4_4_5 - 0.0833333333333333*G4_5_4 - 0.166666666666667*G4_5_5 + 0.0833333333333332*G6_7_4 + 0.0833333333333333*G6_8_5 + 0.166666666666667*G6_9_4 + 0.166666666666667*G6_9_5;
        A[1] = -0.166666666666667*G1_1_1 - 0.0833333333333333*G1_1_2 - 0.0833333333333333*G1_2_1 - 0.166666666666667*G1_2_2 + 0.0833333333333332*G3_1_1 + 0.0833333333333333*G3_2_2 + 0.166666666666667*G3_3_1 + 0.166666666666667*G3_3_2 - 0.166666666666667*G5_4_4 - 0.0833333333333333*G5_4_5 - 0.0833333333333333*G5_5_4 - 0.166666666666667*G5_5_5 + 0.0833333333333332*G7_7_4 + 0.0833333333333333*G7_8_5 + 0.166666666666667*G7_9_4 + 0.166666666666667*G7_9_5;
          break;
        }
      case 1:
        {
          A[0] = -0.166666666666667*G0_1_1 - 0.0833333333333333*G0_1_2 - 0.0833333333333333*G0_2_1 - 0.166666666666667*G0_2_2 + 0.0833333333333332*G2_1_1 + 0.0833333333333333*G2_2_2 + 0.166666666666667*G2_3_1 + 0.166666666666667*G2_3_2 - 0.166666666666667*G4_3_3 - 0.0833333333333333*G4_3_5 - 0.0833333333333333*G4_5_3 - 0.166666666666667*G4_5_5 + 0.0833333333333333*G6_6_3 + 0.0833333333333333*G6_8_5 + 0.166666666666667*G6_10_3 + 0.166666666666667*G6_10_5;
        A[1] = -0.166666666666667*G1_1_1 - 0.0833333333333333*G1_1_2 - 0.0833333333333333*G1_2_1 - 0.166666666666667*G1_2_2 + 0.0833333333333332*G3_1_1 + 0.0833333333333333*G3_2_2 + 0.166666666666667*G3_3_1 + 0.166666666666667*G3_3_2 - 0.166666666666667*G5_3_3 - 0.0833333333333333*G5_3_5 - 0.0833333333333333*G5_5_3 - 0.166666666666667*G5_5_5 + 0.0833333333333333*G7_6_3 + 0.0833333333333333*G7_8_5 + 0.166666666666667*G7_10_3 + 0.166666666666667*G7_10_5;
          break;
        }
      case 2:
        {
          A[0] = -0.166666666666667*G0_1_1 - 0.0833333333333333*G0_1_2 - 0.0833333333333333*G0_2_1 - 0.166666666666667*G0_2_2 + 0.0833333333333332*G2_1_1 + 0.0833333333333333*G2_2_2 + 0.166666666666667*G2_3_1 + 0.166666666666667*G2_3_2 - 0.166666666666667*G4_3_3 - 0.0833333333333333*G4_3_4 - 0.0833333333333333*G4_4_3 - 0.166666666666667*G4_4_4 + 0.0833333333333333*G6_6_3 + 0.0833333333333332*G6_7_4 + 0.166666666666667*G6_11_3 + 0.166666666666667*G6_11_4;
        A[1] = -0.166666666666667*G1_1_1 - 0.0833333333333333*G1_1_2 - 0.0833333333333333*G1_2_1 - 0.166666666666667*G1_2_2 + 0.0833333333333332*G3_1_1 + 0.0833333333333333*G3_2_2 + 0.166666666666667*G3_3_1 + 0.166666666666667*G3_3_2 - 0.166666666666667*G5_3_3 - 0.0833333333333333*G5_3_4 - 0.0833333333333333*G5_4_3 - 0.166666666666667*G5_4_4 + 0.0833333333333333*G7_6_3 + 0.0833333333333332*G7_7_4 + 0.166666666666667*G7_11_3 + 0.166666666666667*G7_11_4;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        switch (facet_1)
      {
      case 0:
        {
          A[0] = -0.166666666666667*G0_0_0 - 0.0833333333333333*G0_0_2 - 0.0833333333333333*G0_2_0 - 0.166666666666667*G0_2_2 + 0.0833333333333333*G2_0_0 + 0.0833333333333333*G2_2_2 + 0.166666666666667*G2_4_0 + 0.166666666666667*G2_4_2 - 0.166666666666667*G4_4_4 - 0.0833333333333333*G4_4_5 - 0.0833333333333333*G4_5_4 - 0.166666666666667*G4_5_5 + 0.0833333333333332*G6_7_4 + 0.0833333333333333*G6_8_5 + 0.166666666666667*G6_9_4 + 0.166666666666667*G6_9_5;
        A[1] = -0.166666666666667*G1_0_0 - 0.0833333333333333*G1_0_2 - 0.0833333333333333*G1_2_0 - 0.166666666666667*G1_2_2 + 0.0833333333333333*G3_0_0 + 0.0833333333333333*G3_2_2 + 0.166666666666667*G3_4_0 + 0.166666666666667*G3_4_2 - 0.166666666666667*G5_4_4 - 0.0833333333333333*G5_4_5 - 0.0833333333333333*G5_5_4 - 0.166666666666667*G5_5_5 + 0.0833333333333332*G7_7_4 + 0.0833333333333333*G7_8_5 + 0.166666666666667*G7_9_4 + 0.166666666666667*G7_9_5;
          break;
        }
      case 1:
        {
          A[0] = -0.166666666666667*G0_0_0 - 0.0833333333333333*G0_0_2 - 0.0833333333333333*G0_2_0 - 0.166666666666667*G0_2_2 + 0.0833333333333333*G2_0_0 + 0.0833333333333333*G2_2_2 + 0.166666666666667*G2_4_0 + 0.166666666666667*G2_4_2 - 0.166666666666667*G4_3_3 - 0.0833333333333333*G4_3_5 - 0.0833333333333333*G4_5_3 - 0.166666666666667*G4_5_5 + 0.0833333333333333*G6_6_3 + 0.0833333333333333*G6_8_5 + 0.166666666666667*G6_10_3 + 0.166666666666667*G6_10_5;
        A[1] = -0.166666666666667*G1_0_0 - 0.0833333333333333*G1_0_2 - 0.0833333333333333*G1_2_0 - 0.166666666666667*G1_2_2 + 0.0833333333333333*G3_0_0 + 0.0833333333333333*G3_2_2 + 0.166666666666667*G3_4_0 + 0.166666666666667*G3_4_2 - 0.166666666666667*G5_3_3 - 0.0833333333333333*G5_3_5 - 0.0833333333333333*G5_5_3 - 0.166666666666667*G5_5_5 + 0.0833333333333333*G7_6_3 + 0.0833333333333333*G7_8_5 + 0.166666666666667*G7_10_3 + 0.166666666666667*G7_10_5;
          break;
        }
      case 2:
        {
          A[0] = -0.166666666666667*G0_0_0 - 0.0833333333333333*G0_0_2 - 0.0833333333333333*G0_2_0 - 0.166666666666667*G0_2_2 + 0.0833333333333333*G2_0_0 + 0.0833333333333333*G2_2_2 + 0.166666666666667*G2_4_0 + 0.166666666666667*G2_4_2 - 0.166666666666667*G4_3_3 - 0.0833333333333333*G4_3_4 - 0.0833333333333333*G4_4_3 - 0.166666666666667*G4_4_4 + 0.0833333333333333*G6_6_3 + 0.0833333333333332*G6_7_4 + 0.166666666666667*G6_11_3 + 0.166666666666667*G6_11_4;
        A[1] = -0.166666666666667*G1_0_0 - 0.0833333333333333*G1_0_2 - 0.0833333333333333*G1_2_0 - 0.166666666666667*G1_2_2 + 0.0833333333333333*G3_0_0 + 0.0833333333333333*G3_2_2 + 0.166666666666667*G3_4_0 + 0.166666666666667*G3_4_2 - 0.166666666666667*G5_3_3 - 0.0833333333333333*G5_3_4 - 0.0833333333333333*G5_4_3 - 0.166666666666667*G5_4_4 + 0.0833333333333333*G7_6_3 + 0.0833333333333332*G7_7_4 + 0.166666666666667*G7_11_3 + 0.166666666666667*G7_11_4;
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        switch (facet_1)
      {
      case 0:
        {
          A[0] = -0.166666666666667*G0_0_0 - 0.0833333333333333*G0_0_1 - 0.0833333333333333*G0_1_0 - 0.166666666666667*G0_1_1 + 0.0833333333333333*G2_0_0 + 0.0833333333333332*G2_1_1 + 0.166666666666667*G2_5_0 + 0.166666666666667*G2_5_1 - 0.166666666666667*G4_4_4 - 0.0833333333333333*G4_4_5 - 0.0833333333333333*G4_5_4 - 0.166666666666667*G4_5_5 + 0.0833333333333332*G6_7_4 + 0.0833333333333333*G6_8_5 + 0.166666666666667*G6_9_4 + 0.166666666666667*G6_9_5;
        A[1] = -0.166666666666667*G1_0_0 - 0.0833333333333333*G1_0_1 - 0.0833333333333333*G1_1_0 - 0.166666666666667*G1_1_1 + 0.0833333333333333*G3_0_0 + 0.0833333333333332*G3_1_1 + 0.166666666666667*G3_5_0 + 0.166666666666667*G3_5_1 - 0.166666666666667*G5_4_4 - 0.0833333333333333*G5_4_5 - 0.0833333333333333*G5_5_4 - 0.166666666666667*G5_5_5 + 0.0833333333333332*G7_7_4 + 0.0833333333333333*G7_8_5 + 0.166666666666667*G7_9_4 + 0.166666666666667*G7_9_5;
          break;
        }
      case 1:
        {
          A[0] = -0.166666666666667*G0_0_0 - 0.0833333333333333*G0_0_1 - 0.0833333333333333*G0_1_0 - 0.166666666666667*G0_1_1 + 0.0833333333333333*G2_0_0 + 0.0833333333333332*G2_1_1 + 0.166666666666667*G2_5_0 + 0.166666666666667*G2_5_1 - 0.166666666666667*G4_3_3 - 0.0833333333333333*G4_3_5 - 0.0833333333333333*G4_5_3 - 0.166666666666667*G4_5_5 + 0.0833333333333333*G6_6_3 + 0.0833333333333333*G6_8_5 + 0.166666666666667*G6_10_3 + 0.166666666666667*G6_10_5;
        A[1] = -0.166666666666667*G1_0_0 - 0.0833333333333333*G1_0_1 - 0.0833333333333333*G1_1_0 - 0.166666666666667*G1_1_1 + 0.0833333333333333*G3_0_0 + 0.0833333333333332*G3_1_1 + 0.166666666666667*G3_5_0 + 0.166666666666667*G3_5_1 - 0.166666666666667*G5_3_3 - 0.0833333333333333*G5_3_5 - 0.0833333333333333*G5_5_3 - 0.166666666666667*G5_5_5 + 0.0833333333333333*G7_6_3 + 0.0833333333333333*G7_8_5 + 0.166666666666667*G7_10_3 + 0.166666666666667*G7_10_5;
          break;
        }
      case 2:
        {
          A[0] = -0.166666666666667*G0_0_0 - 0.0833333333333333*G0_0_1 - 0.0833333333333333*G0_1_0 - 0.166666666666667*G0_1_1 + 0.0833333333333333*G2_0_0 + 0.0833333333333332*G2_1_1 + 0.166666666666667*G2_5_0 + 0.166666666666667*G2_5_1 - 0.166666666666667*G4_3_3 - 0.0833333333333333*G4_3_4 - 0.0833333333333333*G4_4_3 - 0.166666666666667*G4_4_4 + 0.0833333333333333*G6_6_3 + 0.0833333333333332*G6_7_4 + 0.166666666666667*G6_11_3 + 0.166666666666667*G6_11_4;
        A[1] = -0.166666666666667*G1_0_0 - 0.0833333333333333*G1_0_1 - 0.0833333333333333*G1_1_0 - 0.166666666666667*G1_1_1 + 0.0833333333333333*G3_0_0 + 0.0833333333333332*G3_1_1 + 0.166666666666667*G3_5_0 + 0.166666666666667*G3_5_1 - 0.166666666666667*G5_3_3 - 0.0833333333333333*G5_3_4 - 0.0833333333333333*G5_4_3 - 0.166666666666667*G5_4_4 + 0.0833333333333333*G7_6_3 + 0.0833333333333332*G7_7_4 + 0.166666666666667*G7_11_3 + 0.166666666666667*G7_11_4;
          break;
        }
      }
      
        break;
      }
    }
    
  }

};


class adaptivepoisson_cell_integral_8_otherwise: public ufc::cell_integral
{
public:

  adaptivepoisson_cell_integral_8_otherwise() : ufc::cell_integral()
  {
    
  }

  ~adaptivepoisson_cell_integral_8_otherwise() override
  {
    
  }

  const std::vector<bool> & enabled_coefficients() const final override
  {
    static const std::vector<bool> enabled({});
    return enabled;
  }

  void tabulate_tensor(double * A,
                       const double * const * w,
                       const double * coordinate_dofs,
                       int cell_orientation) const final override
  {
    // Number of operations (multiply-add pairs) for Jacobian data:      3
    // Number of operations (multiply-add pairs) for geometry tensor:    8
    // Number of operations (multiply-add pairs) for tensor contraction: 11
    // Total number of operations (multiply-add pairs):                  22
    
    // Compute Jacobian
    double J[4];
    compute_jacobian_triangle_2d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[4];
    double detJ;
    compute_jacobian_inverse_triangle_2d(K, detJ, J);
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Compute geometry tensor
    const double G0_0_0 = det*(K[0]*K[0] + K[1]*K[1]);
    const double G0_0_1 = det*(K[0]*K[2] + K[1]*K[3]);
    const double G0_1_0 = det*(K[2]*K[0] + K[3]*K[1]);
    const double G0_1_1 = det*(K[2]*K[2] + K[3]*K[3]);
    
    // Compute element tensor
    A[0] = 0.499999999999999*G0_0_0 + 0.5*G0_0_1 + 0.5*G0_1_0 + 0.5*G0_1_1;
    A[1] = -0.499999999999999*G0_0_0 - 0.5*G0_1_0;
    A[2] = -0.5*G0_0_1 - 0.5*G0_1_1;
    A[3] = -0.499999999999999*G0_0_0 - 0.5*G0_0_1;
    A[4] = 0.499999999999999*G0_0_0;
    A[5] = 0.5*G0_0_1;
    A[6] = -0.5*G0_1_0 - 0.5*G0_1_1;
    A[7] = 0.5*G0_1_0;
    A[8] = 0.5*G0_1_1;
  }

};


class adaptivepoisson_cell_integral_9_otherwise: public ufc::cell_integral
{
public:

  adaptivepoisson_cell_integral_9_otherwise() : ufc::cell_integral()
  {
    
  }

  ~adaptivepoisson_cell_integral_9_otherwise() override
  {
    
  }

  const std::vector<bool> & enabled_coefficients() const final override
  {
    static const std::vector<bool> enabled({true, false});
    return enabled;
  }

  void tabulate_tensor(double * A,
                       const double * const * w,
                       const double * coordinate_dofs,
                       int cell_orientation) const final override
  {
    // Number of operations (multiply-add pairs) for Jacobian data:      3
    // Number of operations (multiply-add pairs) for geometry tensor:    3
    // Number of operations (multiply-add pairs) for tensor contraction: 7
    // Total number of operations (multiply-add pairs):                  13
    
    // Compute Jacobian
    double J[4];
    compute_jacobian_triangle_2d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[4];
    double detJ;
    compute_jacobian_inverse_triangle_2d(K, detJ, J);
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Compute geometry tensor
    const double G0_0 = det*w[0][0]*(1.0);
    const double G0_1 = det*w[0][1]*(1.0);
    const double G0_2 = det*w[0][2]*(1.0);
    
    // Compute element tensor
    A[0] = 0.0833333333333334*G0_0 + 0.0416666666666667*G0_1 + 0.0416666666666667*G0_2;
    A[1] = 0.0416666666666667*G0_0 + 0.0833333333333333*G0_1 + 0.0416666666666666*G0_2;
    A[2] = 0.0416666666666667*G0_0 + 0.0416666666666666*G0_1 + 0.0833333333333333*G0_2;
  }

};


class adaptivepoisson_exterior_facet_integral_9_otherwise: public ufc::exterior_facet_integral
{
public:

  adaptivepoisson_exterior_facet_integral_9_otherwise() : ufc::exterior_facet_integral()
  {
    
  }

  ~adaptivepoisson_exterior_facet_integral_9_otherwise() override
  {
    
  }

  const std::vector<bool> & enabled_coefficients() const final override
  {
    static const std::vector<bool> enabled({false, true});
    return enabled;
  }

  void tabulate_tensor(double * A,
                       const double * const * w,
                       const double * coordinate_dofs,
                       std::size_t facet,
                       int cell_orientation) const final override
  {
    // Number of operations (multiply-add pairs) for Jacobian data:      10
    // Number of operations (multiply-add pairs) for geometry tensor:    3
    // Number of operations (multiply-add pairs) for tensor contraction: 9
    // Total number of operations (multiply-add pairs):                  22
    
    // Compute Jacobian
    double J[4];
    compute_jacobian_triangle_2d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[4];
    double detJ;
    compute_jacobian_inverse_triangle_2d(K, detJ, J);
    
    // Get vertices on edge
    static unsigned int edge_vertices[3][2] = {{1, 2}, {0, 2}, {0, 1}};
    const unsigned int v0 = edge_vertices[facet][0];
    const unsigned int v1 = edge_vertices[facet][1];
    
    // Compute scale factor (length of edge scaled by length of reference interval)
    const double dx0 = coordinate_dofs[2*v1 + 0] - coordinate_dofs[2*v0 + 0];
    const double dx1 = coordinate_dofs[2*v1 + 1] - coordinate_dofs[2*v0 + 1];
    const double det = std::sqrt(dx0*dx0 + dx1*dx1);
    
    
    // Compute geometry tensor
    const double G0_0 = det*w[1][0]*(1.0);
    const double G0_1 = det*w[1][1]*(1.0);
    const double G0_2 = det*w[1][2]*(1.0);
    
    // Compute element tensor
    switch (facet)
    {
    case 0:
      {
        A[0] = 0.0;
      A[1] = 0.333333333333333*G0_1 + 0.166666666666667*G0_2;
      A[2] = 0.166666666666667*G0_1 + 0.333333333333333*G0_2;
        break;
      }
    case 1:
      {
        A[0] = 0.333333333333333*G0_0 + 0.166666666666667*G0_2;
      A[1] = 0.0;
      A[2] = 0.166666666666667*G0_0 + 0.333333333333333*G0_2;
        break;
      }
    case 2:
      {
        A[0] = 0.333333333333333*G0_0 + 0.166666666666667*G0_1;
      A[1] = 0.166666666666667*G0_0 + 0.333333333333333*G0_1;
      A[2] = 0.0;
        break;
      }
    }
    
  }

};


class adaptivepoisson_cell_integral_10_otherwise: public ufc::cell_integral
{
public:

  adaptivepoisson_cell_integral_10_otherwise() : ufc::cell_integral()
  {
    
  }

  ~adaptivepoisson_cell_integral_10_otherwise() override
  {
    
  }

  const std::vector<bool> & enabled_coefficients() const final override
  {
    static const std::vector<bool> enabled({true});
    return enabled;
  }

  void tabulate_tensor(double * A,
                       const double * const * w,
                       const double * coordinate_dofs,
                       int cell_orientation) const final override
  {
    // Number of operations (multiply-add pairs) for Jacobian data:      3
    // Number of operations (multiply-add pairs) for geometry tensor:    3
    // Number of operations (multiply-add pairs) for tensor contraction: 2
    // Total number of operations (multiply-add pairs):                  8
    
    // Compute Jacobian
    double J[4];
    compute_jacobian_triangle_2d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[4];
    double detJ;
    compute_jacobian_inverse_triangle_2d(K, detJ, J);
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Compute geometry tensor
    const double G0_0 = det*w[0][0]*(1.0);
    const double G0_1 = det*w[0][1]*(1.0);
    const double G0_2 = det*w[0][2]*(1.0);
    
    // Compute element tensor
    A[0] = 0.166666666666667*G0_0 + 0.166666666666667*G0_1 + 0.166666666666667*G0_2;
  }

};


class adaptivepoisson_form_0: public ufc::form
{
public:

  adaptivepoisson_form_0() : ufc::form()
  {
    // Do nothing
  }

  ~adaptivepoisson_form_0() override
  {
    // Do nothing
  }

  const char * signature() const final override
  {
    return "19b425e17889d62d86285b64713d25de6a9d28c3bf37be81e351fd1214bae8f3ab570ea127ee8fa95c6788e1b1652bd8b1a9a91f5f2e67712064bb901dcbf177";
  }

  std::size_t rank() const final override
  {
    return 2;
  }

  std::size_t num_coefficients() const final override
  {
    return 0;
  }

  std::size_t original_coefficient_position(std::size_t i) const final override
  {
    static const std::vector<std::size_t> position({});
    return position[i];
  }

  ufc::finite_element * create_coordinate_finite_element() const final override
  {
    return new adaptivepoisson_finite_element_1();
  }

  ufc::dofmap * create_coordinate_dofmap() const final override
  {
    return new adaptivepoisson_dofmap_1();
   }

  ufc::coordinate_mapping * create_coordinate_mapping() const final override
  {
    return nullptr;
  }

  ufc::finite_element * create_finite_element(std::size_t i) const final override
  {
    switch (i)
    {
    case 0:
      {
        return new adaptivepoisson_finite_element_0();
        break;
      }
    case 1:
      {
        return new adaptivepoisson_finite_element_0();
        break;
      }
    }
    
    return 0;
  }

  ufc::dofmap * create_dofmap(std::size_t i) const final override
  {
    switch (i)
    {
    case 0:
      {
        return new adaptivepoisson_dofmap_0();
        break;
      }
    case 1:
      {
        return new adaptivepoisson_dofmap_0();
        break;
      }
    }
    
    return 0;
  }

  std::size_t max_cell_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_exterior_facet_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_interior_facet_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_vertex_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_custom_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_cutcell_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_interface_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_overlap_subdomain_id() const final override
  {
    return 0;
  }

  bool has_cell_integrals() const final override
  {
    return true;
  }

  bool has_exterior_facet_integrals() const final override
  {
    return false;
  }

  bool has_interior_facet_integrals() const final override
  {
    return false;
  }

  bool has_vertex_integrals() const final override
  {
    return false;
  }

  bool has_custom_integrals() const final override
  {
    return false;
  }

  bool has_cutcell_integrals() const final override
  {
    return false;
  }

  bool has_interface_integrals() const final override
  {
    return false;
  }

  bool has_overlap_integrals() const final override
  {
    return false;
  }

  ufc::cell_integral * create_cell_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::exterior_facet_integral * create_exterior_facet_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::interior_facet_integral * create_interior_facet_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::vertex_integral * create_vertex_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::custom_integral * create_custom_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::cutcell_integral * create_cutcell_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::interface_integral * create_interface_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::overlap_integral * create_overlap_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::cell_integral * create_default_cell_integral() const final override
  {
    return new adaptivepoisson_cell_integral_0_otherwise();
  }

  ufc::exterior_facet_integral * create_default_exterior_facet_integral() const final override
  {
    return 0;
  }

  ufc::interior_facet_integral * create_default_interior_facet_integral() const final override
  {
    return 0;
  }

  ufc::vertex_integral * create_default_vertex_integral() const final override
  {
    return 0;
  }

  ufc::custom_integral * create_default_custom_integral() const final override
  {
    return 0;
  }

  ufc::cutcell_integral * create_default_cutcell_integral() const final override
  {
    return 0;
  }

  ufc::interface_integral * create_default_interface_integral() const final override
  {
    return 0;
  }

  ufc::overlap_integral * create_default_overlap_integral() const final override
  {
    return 0;
  }

};


class adaptivepoisson_form_1: public ufc::form
{
public:

  adaptivepoisson_form_1() : ufc::form()
  {
    // Do nothing
  }

  ~adaptivepoisson_form_1() override
  {
    // Do nothing
  }

  const char * signature() const final override
  {
    return "02bc16ff054ec42b7e33aede0bd2b486869176764829aa02538e72a0895b2d136af0d28a10e3c8bd55af13bb7482a70a6f4af5e10dbf93059941282dfb759568";
  }

  std::size_t rank() const final override
  {
    return 1;
  }

  std::size_t num_coefficients() const final override
  {
    return 0;
  }

  std::size_t original_coefficient_position(std::size_t i) const final override
  {
    static const std::vector<std::size_t> position({});
    return position[i];
  }

  ufc::finite_element * create_coordinate_finite_element() const final override
  {
    return new adaptivepoisson_finite_element_1();
  }

  ufc::dofmap * create_coordinate_dofmap() const final override
  {
    return new adaptivepoisson_dofmap_1();
   }

  ufc::coordinate_mapping * create_coordinate_mapping() const final override
  {
    return nullptr;
  }

  ufc::finite_element * create_finite_element(std::size_t i) const final override
  {
    switch (i)
    {
    case 0:
      {
        return new adaptivepoisson_finite_element_0();
        break;
      }
    }
    
    return 0;
  }

  ufc::dofmap * create_dofmap(std::size_t i) const final override
  {
    switch (i)
    {
    case 0:
      {
        return new adaptivepoisson_dofmap_0();
        break;
      }
    }
    
    return 0;
  }

  std::size_t max_cell_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_exterior_facet_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_interior_facet_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_vertex_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_custom_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_cutcell_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_interface_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_overlap_subdomain_id() const final override
  {
    return 0;
  }

  bool has_cell_integrals() const final override
  {
    return true;
  }

  bool has_exterior_facet_integrals() const final override
  {
    return false;
  }

  bool has_interior_facet_integrals() const final override
  {
    return false;
  }

  bool has_vertex_integrals() const final override
  {
    return false;
  }

  bool has_custom_integrals() const final override
  {
    return false;
  }

  bool has_cutcell_integrals() const final override
  {
    return false;
  }

  bool has_interface_integrals() const final override
  {
    return false;
  }

  bool has_overlap_integrals() const final override
  {
    return false;
  }

  ufc::cell_integral * create_cell_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::exterior_facet_integral * create_exterior_facet_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::interior_facet_integral * create_interior_facet_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::vertex_integral * create_vertex_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::custom_integral * create_custom_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::cutcell_integral * create_cutcell_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::interface_integral * create_interface_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::overlap_integral * create_overlap_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::cell_integral * create_default_cell_integral() const final override
  {
    return new adaptivepoisson_cell_integral_1_otherwise();
  }

  ufc::exterior_facet_integral * create_default_exterior_facet_integral() const final override
  {
    return 0;
  }

  ufc::interior_facet_integral * create_default_interior_facet_integral() const final override
  {
    return 0;
  }

  ufc::vertex_integral * create_default_vertex_integral() const final override
  {
    return 0;
  }

  ufc::custom_integral * create_default_custom_integral() const final override
  {
    return 0;
  }

  ufc::cutcell_integral * create_default_cutcell_integral() const final override
  {
    return 0;
  }

  ufc::interface_integral * create_default_interface_integral() const final override
  {
    return 0;
  }

  ufc::overlap_integral * create_default_overlap_integral() const final override
  {
    return 0;
  }

};


class adaptivepoisson_form_2: public ufc::form
{
public:

  adaptivepoisson_form_2() : ufc::form()
  {
    // Do nothing
  }

  ~adaptivepoisson_form_2() override
  {
    // Do nothing
  }

  const char * signature() const final override
  {
    return "003c517c2a9dc538ab933fb1bbef26c6adb1141704507e2470cbe6aaf20116173ad1055484f33e3770aaec8af5af68155468ce3f0bdf08c5c82de09a24bb136d";
  }

  std::size_t rank() const final override
  {
    return 0;
  }

  std::size_t num_coefficients() const final override
  {
    return 4;
  }

  std::size_t original_coefficient_position(std::size_t i) const final override
  {
    static const std::vector<std::size_t> position({0, 1, 2, 3});
    return position[i];
  }

  ufc::finite_element * create_coordinate_finite_element() const final override
  {
    return new adaptivepoisson_finite_element_1();
  }

  ufc::dofmap * create_coordinate_dofmap() const final override
  {
    return new adaptivepoisson_dofmap_1();
   }

  ufc::coordinate_mapping * create_coordinate_mapping() const final override
  {
    return nullptr;
  }

  ufc::finite_element * create_finite_element(std::size_t i) const final override
  {
    switch (i)
    {
    case 0:
      {
        return new adaptivepoisson_finite_element_0();
        break;
      }
    case 1:
      {
        return new adaptivepoisson_finite_element_0();
        break;
      }
    case 2:
      {
        return new adaptivepoisson_finite_element_0();
        break;
      }
    case 3:
      {
        return new adaptivepoisson_finite_element_2();
        break;
      }
    }
    
    return 0;
  }

  ufc::dofmap * create_dofmap(std::size_t i) const final override
  {
    switch (i)
    {
    case 0:
      {
        return new adaptivepoisson_dofmap_0();
        break;
      }
    case 1:
      {
        return new adaptivepoisson_dofmap_0();
        break;
      }
    case 2:
      {
        return new adaptivepoisson_dofmap_0();
        break;
      }
    case 3:
      {
        return new adaptivepoisson_dofmap_2();
        break;
      }
    }
    
    return 0;
  }

  std::size_t max_cell_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_exterior_facet_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_interior_facet_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_vertex_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_custom_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_cutcell_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_interface_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_overlap_subdomain_id() const final override
  {
    return 0;
  }

  bool has_cell_integrals() const final override
  {
    return true;
  }

  bool has_exterior_facet_integrals() const final override
  {
    return true;
  }

  bool has_interior_facet_integrals() const final override
  {
    return false;
  }

  bool has_vertex_integrals() const final override
  {
    return false;
  }

  bool has_custom_integrals() const final override
  {
    return false;
  }

  bool has_cutcell_integrals() const final override
  {
    return false;
  }

  bool has_interface_integrals() const final override
  {
    return false;
  }

  bool has_overlap_integrals() const final override
  {
    return false;
  }

  ufc::cell_integral * create_cell_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::exterior_facet_integral * create_exterior_facet_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::interior_facet_integral * create_interior_facet_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::vertex_integral * create_vertex_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::custom_integral * create_custom_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::cutcell_integral * create_cutcell_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::interface_integral * create_interface_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::overlap_integral * create_overlap_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::cell_integral * create_default_cell_integral() const final override
  {
    return new adaptivepoisson_cell_integral_2_otherwise();
  }

  ufc::exterior_facet_integral * create_default_exterior_facet_integral() const final override
  {
    return new adaptivepoisson_exterior_facet_integral_2_otherwise();
  }

  ufc::interior_facet_integral * create_default_interior_facet_integral() const final override
  {
    return 0;
  }

  ufc::vertex_integral * create_default_vertex_integral() const final override
  {
    return 0;
  }

  ufc::custom_integral * create_default_custom_integral() const final override
  {
    return 0;
  }

  ufc::cutcell_integral * create_default_cutcell_integral() const final override
  {
    return 0;
  }

  ufc::interface_integral * create_default_interface_integral() const final override
  {
    return 0;
  }

  ufc::overlap_integral * create_default_overlap_integral() const final override
  {
    return 0;
  }

};


class adaptivepoisson_form_3: public ufc::form
{
public:

  adaptivepoisson_form_3() : ufc::form()
  {
    // Do nothing
  }

  ~adaptivepoisson_form_3() override
  {
    // Do nothing
  }

  const char * signature() const final override
  {
    return "5262e5b0fb2103d4ddbaf946276b5441abcabf81b0b0a01363c5fb8d9f97d3e7b083a38009560849cca1d3596e7837d3fc0ab0e6a6444f8b3988eeb9e47b2e3e";
  }

  std::size_t rank() const final override
  {
    return 2;
  }

  std::size_t num_coefficients() const final override
  {
    return 1;
  }

  std::size_t original_coefficient_position(std::size_t i) const final override
  {
    static const std::vector<std::size_t> position({0});
    return position[i];
  }

  ufc::finite_element * create_coordinate_finite_element() const final override
  {
    return new adaptivepoisson_finite_element_1();
  }

  ufc::dofmap * create_coordinate_dofmap() const final override
  {
    return new adaptivepoisson_dofmap_1();
   }

  ufc::coordinate_mapping * create_coordinate_mapping() const final override
  {
    return nullptr;
  }

  ufc::finite_element * create_finite_element(std::size_t i) const final override
  {
    switch (i)
    {
    case 0:
      {
        return new adaptivepoisson_finite_element_4();
        break;
      }
    case 1:
      {
        return new adaptivepoisson_finite_element_4();
        break;
      }
    case 2:
      {
        return new adaptivepoisson_finite_element_6();
        break;
      }
    }
    
    return 0;
  }

  ufc::dofmap * create_dofmap(std::size_t i) const final override
  {
    switch (i)
    {
    case 0:
      {
        return new adaptivepoisson_dofmap_4();
        break;
      }
    case 1:
      {
        return new adaptivepoisson_dofmap_4();
        break;
      }
    case 2:
      {
        return new adaptivepoisson_dofmap_6();
        break;
      }
    }
    
    return 0;
  }

  std::size_t max_cell_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_exterior_facet_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_interior_facet_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_vertex_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_custom_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_cutcell_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_interface_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_overlap_subdomain_id() const final override
  {
    return 0;
  }

  bool has_cell_integrals() const final override
  {
    return true;
  }

  bool has_exterior_facet_integrals() const final override
  {
    return false;
  }

  bool has_interior_facet_integrals() const final override
  {
    return false;
  }

  bool has_vertex_integrals() const final override
  {
    return false;
  }

  bool has_custom_integrals() const final override
  {
    return false;
  }

  bool has_cutcell_integrals() const final override
  {
    return false;
  }

  bool has_interface_integrals() const final override
  {
    return false;
  }

  bool has_overlap_integrals() const final override
  {
    return false;
  }

  ufc::cell_integral * create_cell_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::exterior_facet_integral * create_exterior_facet_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::interior_facet_integral * create_interior_facet_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::vertex_integral * create_vertex_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::custom_integral * create_custom_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::cutcell_integral * create_cutcell_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::interface_integral * create_interface_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::overlap_integral * create_overlap_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::cell_integral * create_default_cell_integral() const final override
  {
    return new adaptivepoisson_cell_integral_3_otherwise();
  }

  ufc::exterior_facet_integral * create_default_exterior_facet_integral() const final override
  {
    return 0;
  }

  ufc::interior_facet_integral * create_default_interior_facet_integral() const final override
  {
    return 0;
  }

  ufc::vertex_integral * create_default_vertex_integral() const final override
  {
    return 0;
  }

  ufc::custom_integral * create_default_custom_integral() const final override
  {
    return 0;
  }

  ufc::cutcell_integral * create_default_cutcell_integral() const final override
  {
    return 0;
  }

  ufc::interface_integral * create_default_interface_integral() const final override
  {
    return 0;
  }

  ufc::overlap_integral * create_default_overlap_integral() const final override
  {
    return 0;
  }

};


class adaptivepoisson_form_4: public ufc::form
{
public:

  adaptivepoisson_form_4() : ufc::form()
  {
    // Do nothing
  }

  ~adaptivepoisson_form_4() override
  {
    // Do nothing
  }

  const char * signature() const final override
  {
    return "fa048975b81c9bb048b7469d0e239109a08b00f261d03cc8ee864d973cd706f35f6083c1f1f08b4466feff2005fe8e99dce2d8ccafa5b570a8deca6082bf9c49";
  }

  std::size_t rank() const final override
  {
    return 1;
  }

  std::size_t num_coefficients() const final override
  {
    return 4;
  }

  std::size_t original_coefficient_position(std::size_t i) const final override
  {
    static const std::vector<std::size_t> position({0, 1, 2, 3});
    return position[i];
  }

  ufc::finite_element * create_coordinate_finite_element() const final override
  {
    return new adaptivepoisson_finite_element_1();
  }

  ufc::dofmap * create_coordinate_dofmap() const final override
  {
    return new adaptivepoisson_dofmap_1();
   }

  ufc::coordinate_mapping * create_coordinate_mapping() const final override
  {
    return nullptr;
  }

  ufc::finite_element * create_finite_element(std::size_t i) const final override
  {
    switch (i)
    {
    case 0:
      {
        return new adaptivepoisson_finite_element_4();
        break;
      }
    case 1:
      {
        return new adaptivepoisson_finite_element_0();
        break;
      }
    case 2:
      {
        return new adaptivepoisson_finite_element_0();
        break;
      }
    case 3:
      {
        return new adaptivepoisson_finite_element_0();
        break;
      }
    case 4:
      {
        return new adaptivepoisson_finite_element_6();
        break;
      }
    }
    
    return 0;
  }

  ufc::dofmap * create_dofmap(std::size_t i) const final override
  {
    switch (i)
    {
    case 0:
      {
        return new adaptivepoisson_dofmap_4();
        break;
      }
    case 1:
      {
        return new adaptivepoisson_dofmap_0();
        break;
      }
    case 2:
      {
        return new adaptivepoisson_dofmap_0();
        break;
      }
    case 3:
      {
        return new adaptivepoisson_dofmap_0();
        break;
      }
    case 4:
      {
        return new adaptivepoisson_dofmap_6();
        break;
      }
    }
    
    return 0;
  }

  std::size_t max_cell_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_exterior_facet_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_interior_facet_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_vertex_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_custom_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_cutcell_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_interface_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_overlap_subdomain_id() const final override
  {
    return 0;
  }

  bool has_cell_integrals() const final override
  {
    return true;
  }

  bool has_exterior_facet_integrals() const final override
  {
    return true;
  }

  bool has_interior_facet_integrals() const final override
  {
    return false;
  }

  bool has_vertex_integrals() const final override
  {
    return false;
  }

  bool has_custom_integrals() const final override
  {
    return false;
  }

  bool has_cutcell_integrals() const final override
  {
    return false;
  }

  bool has_interface_integrals() const final override
  {
    return false;
  }

  bool has_overlap_integrals() const final override
  {
    return false;
  }

  ufc::cell_integral * create_cell_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::exterior_facet_integral * create_exterior_facet_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::interior_facet_integral * create_interior_facet_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::vertex_integral * create_vertex_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::custom_integral * create_custom_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::cutcell_integral * create_cutcell_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::interface_integral * create_interface_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::overlap_integral * create_overlap_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::cell_integral * create_default_cell_integral() const final override
  {
    return new adaptivepoisson_cell_integral_4_otherwise();
  }

  ufc::exterior_facet_integral * create_default_exterior_facet_integral() const final override
  {
    return new adaptivepoisson_exterior_facet_integral_4_otherwise();
  }

  ufc::interior_facet_integral * create_default_interior_facet_integral() const final override
  {
    return 0;
  }

  ufc::vertex_integral * create_default_vertex_integral() const final override
  {
    return 0;
  }

  ufc::custom_integral * create_default_custom_integral() const final override
  {
    return 0;
  }

  ufc::cutcell_integral * create_default_cutcell_integral() const final override
  {
    return 0;
  }

  ufc::interface_integral * create_default_interface_integral() const final override
  {
    return 0;
  }

  ufc::overlap_integral * create_default_overlap_integral() const final override
  {
    return 0;
  }

};


class adaptivepoisson_form_5: public ufc::form
{
public:

  adaptivepoisson_form_5() : ufc::form()
  {
    // Do nothing
  }

  ~adaptivepoisson_form_5() override
  {
    // Do nothing
  }

  const char * signature() const final override
  {
    return "04086c717ea4914d5a9cfe4d17a5d10d551f86d1a0238e23a644af889f92c8ae10d06ac99222130f8f0226a41e549d46c1bc034436cdbdddc198695e2f4ad2c3";
  }

  std::size_t rank() const final override
  {
    return 2;
  }

  std::size_t num_coefficients() const final override
  {
    return 1;
  }

  std::size_t original_coefficient_position(std::size_t i) const final override
  {
    static const std::vector<std::size_t> position({0});
    return position[i];
  }

  ufc::finite_element * create_coordinate_finite_element() const final override
  {
    return new adaptivepoisson_finite_element_1();
  }

  ufc::dofmap * create_coordinate_dofmap() const final override
  {
    return new adaptivepoisson_dofmap_1();
   }

  ufc::coordinate_mapping * create_coordinate_mapping() const final override
  {
    return nullptr;
  }

  ufc::finite_element * create_finite_element(std::size_t i) const final override
  {
    switch (i)
    {
    case 0:
      {
        return new adaptivepoisson_finite_element_4();
        break;
      }
    case 1:
      {
        return new adaptivepoisson_finite_element_4();
        break;
      }
    case 2:
      {
        return new adaptivepoisson_finite_element_3();
        break;
      }
    }
    
    return 0;
  }

  ufc::dofmap * create_dofmap(std::size_t i) const final override
  {
    switch (i)
    {
    case 0:
      {
        return new adaptivepoisson_dofmap_4();
        break;
      }
    case 1:
      {
        return new adaptivepoisson_dofmap_4();
        break;
      }
    case 2:
      {
        return new adaptivepoisson_dofmap_3();
        break;
      }
    }
    
    return 0;
  }

  std::size_t max_cell_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_exterior_facet_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_interior_facet_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_vertex_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_custom_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_cutcell_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_interface_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_overlap_subdomain_id() const final override
  {
    return 0;
  }

  bool has_cell_integrals() const final override
  {
    return false;
  }

  bool has_exterior_facet_integrals() const final override
  {
    return true;
  }

  bool has_interior_facet_integrals() const final override
  {
    return true;
  }

  bool has_vertex_integrals() const final override
  {
    return false;
  }

  bool has_custom_integrals() const final override
  {
    return false;
  }

  bool has_cutcell_integrals() const final override
  {
    return false;
  }

  bool has_interface_integrals() const final override
  {
    return false;
  }

  bool has_overlap_integrals() const final override
  {
    return false;
  }

  ufc::cell_integral * create_cell_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::exterior_facet_integral * create_exterior_facet_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::interior_facet_integral * create_interior_facet_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::vertex_integral * create_vertex_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::custom_integral * create_custom_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::cutcell_integral * create_cutcell_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::interface_integral * create_interface_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::overlap_integral * create_overlap_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::cell_integral * create_default_cell_integral() const final override
  {
    return 0;
  }

  ufc::exterior_facet_integral * create_default_exterior_facet_integral() const final override
  {
    return new adaptivepoisson_exterior_facet_integral_5_otherwise();
  }

  ufc::interior_facet_integral * create_default_interior_facet_integral() const final override
  {
    return new adaptivepoisson_interior_facet_integral_5_otherwise();
  }

  ufc::vertex_integral * create_default_vertex_integral() const final override
  {
    return 0;
  }

  ufc::custom_integral * create_default_custom_integral() const final override
  {
    return 0;
  }

  ufc::cutcell_integral * create_default_cutcell_integral() const final override
  {
    return 0;
  }

  ufc::interface_integral * create_default_interface_integral() const final override
  {
    return 0;
  }

  ufc::overlap_integral * create_default_overlap_integral() const final override
  {
    return 0;
  }

};


class adaptivepoisson_form_6: public ufc::form
{
public:

  adaptivepoisson_form_6() : ufc::form()
  {
    // Do nothing
  }

  ~adaptivepoisson_form_6() override
  {
    // Do nothing
  }

  const char * signature() const final override
  {
    return "8dbddc016477ebaa4600985afa7048aa0abb5b8156fa9241bcd7b7ad91e5f8fffa27fcd0c0202057c764ad40f8575eb6718c28c6aa2400c1db4018478a10b6f0";
  }

  std::size_t rank() const final override
  {
    return 1;
  }

  std::size_t num_coefficients() const final override
  {
    return 5;
  }

  std::size_t original_coefficient_position(std::size_t i) const final override
  {
    static const std::vector<std::size_t> position({0, 1, 2, 3, 4});
    return position[i];
  }

  ufc::finite_element * create_coordinate_finite_element() const final override
  {
    return new adaptivepoisson_finite_element_1();
  }

  ufc::dofmap * create_coordinate_dofmap() const final override
  {
    return new adaptivepoisson_dofmap_1();
   }

  ufc::coordinate_mapping * create_coordinate_mapping() const final override
  {
    return nullptr;
  }

  ufc::finite_element * create_finite_element(std::size_t i) const final override
  {
    switch (i)
    {
    case 0:
      {
        return new adaptivepoisson_finite_element_4();
        break;
      }
    case 1:
      {
        return new adaptivepoisson_finite_element_0();
        break;
      }
    case 2:
      {
        return new adaptivepoisson_finite_element_0();
        break;
      }
    case 3:
      {
        return new adaptivepoisson_finite_element_0();
        break;
      }
    case 4:
      {
        return new adaptivepoisson_finite_element_4();
        break;
      }
    case 5:
      {
        return new adaptivepoisson_finite_element_3();
        break;
      }
    }
    
    return 0;
  }

  ufc::dofmap * create_dofmap(std::size_t i) const final override
  {
    switch (i)
    {
    case 0:
      {
        return new adaptivepoisson_dofmap_4();
        break;
      }
    case 1:
      {
        return new adaptivepoisson_dofmap_0();
        break;
      }
    case 2:
      {
        return new adaptivepoisson_dofmap_0();
        break;
      }
    case 3:
      {
        return new adaptivepoisson_dofmap_0();
        break;
      }
    case 4:
      {
        return new adaptivepoisson_dofmap_4();
        break;
      }
    case 5:
      {
        return new adaptivepoisson_dofmap_3();
        break;
      }
    }
    
    return 0;
  }

  std::size_t max_cell_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_exterior_facet_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_interior_facet_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_vertex_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_custom_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_cutcell_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_interface_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_overlap_subdomain_id() const final override
  {
    return 0;
  }

  bool has_cell_integrals() const final override
  {
    return true;
  }

  bool has_exterior_facet_integrals() const final override
  {
    return true;
  }

  bool has_interior_facet_integrals() const final override
  {
    return false;
  }

  bool has_vertex_integrals() const final override
  {
    return false;
  }

  bool has_custom_integrals() const final override
  {
    return false;
  }

  bool has_cutcell_integrals() const final override
  {
    return false;
  }

  bool has_interface_integrals() const final override
  {
    return false;
  }

  bool has_overlap_integrals() const final override
  {
    return false;
  }

  ufc::cell_integral * create_cell_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::exterior_facet_integral * create_exterior_facet_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::interior_facet_integral * create_interior_facet_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::vertex_integral * create_vertex_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::custom_integral * create_custom_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::cutcell_integral * create_cutcell_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::interface_integral * create_interface_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::overlap_integral * create_overlap_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::cell_integral * create_default_cell_integral() const final override
  {
    return new adaptivepoisson_cell_integral_6_otherwise();
  }

  ufc::exterior_facet_integral * create_default_exterior_facet_integral() const final override
  {
    return new adaptivepoisson_exterior_facet_integral_6_otherwise();
  }

  ufc::interior_facet_integral * create_default_interior_facet_integral() const final override
  {
    return 0;
  }

  ufc::vertex_integral * create_default_vertex_integral() const final override
  {
    return 0;
  }

  ufc::custom_integral * create_default_custom_integral() const final override
  {
    return 0;
  }

  ufc::cutcell_integral * create_default_cutcell_integral() const final override
  {
    return 0;
  }

  ufc::interface_integral * create_default_interface_integral() const final override
  {
    return 0;
  }

  ufc::overlap_integral * create_default_overlap_integral() const final override
  {
    return 0;
  }

};


class adaptivepoisson_form_7: public ufc::form
{
public:

  adaptivepoisson_form_7() : ufc::form()
  {
    // Do nothing
  }

  ~adaptivepoisson_form_7() override
  {
    // Do nothing
  }

  const char * signature() const final override
  {
    return "f6de60e88f517edad66b6202a12ed316ecc7df6fc4b69280416112a9b61e5282384effbcd415f51d7c5f0e7c2bbfa83f9e0531085eb9d6d875fd025921b1500c";
  }

  std::size_t rank() const final override
  {
    return 1;
  }

  std::size_t num_coefficients() const final override
  {
    return 4;
  }

  std::size_t original_coefficient_position(std::size_t i) const final override
  {
    static const std::vector<std::size_t> position({0, 1, 2, 3});
    return position[i];
  }

  ufc::finite_element * create_coordinate_finite_element() const final override
  {
    return new adaptivepoisson_finite_element_1();
  }

  ufc::dofmap * create_coordinate_dofmap() const final override
  {
    return new adaptivepoisson_dofmap_1();
   }

  ufc::coordinate_mapping * create_coordinate_mapping() const final override
  {
    return nullptr;
  }

  ufc::finite_element * create_finite_element(std::size_t i) const final override
  {
    switch (i)
    {
    case 0:
      {
        return new adaptivepoisson_finite_element_5();
        break;
      }
    case 1:
      {
        return new adaptivepoisson_finite_element_2();
        break;
      }
    case 2:
      {
        return new adaptivepoisson_finite_element_4();
        break;
      }
    case 3:
      {
        return new adaptivepoisson_finite_element_4();
        break;
      }
    case 4:
      {
        return new adaptivepoisson_finite_element_0();
        break;
      }
    }
    
    return 0;
  }

  ufc::dofmap * create_dofmap(std::size_t i) const final override
  {
    switch (i)
    {
    case 0:
      {
        return new adaptivepoisson_dofmap_5();
        break;
      }
    case 1:
      {
        return new adaptivepoisson_dofmap_2();
        break;
      }
    case 2:
      {
        return new adaptivepoisson_dofmap_4();
        break;
      }
    case 3:
      {
        return new adaptivepoisson_dofmap_4();
        break;
      }
    case 4:
      {
        return new adaptivepoisson_dofmap_0();
        break;
      }
    }
    
    return 0;
  }

  std::size_t max_cell_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_exterior_facet_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_interior_facet_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_vertex_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_custom_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_cutcell_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_interface_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_overlap_subdomain_id() const final override
  {
    return 0;
  }

  bool has_cell_integrals() const final override
  {
    return true;
  }

  bool has_exterior_facet_integrals() const final override
  {
    return true;
  }

  bool has_interior_facet_integrals() const final override
  {
    return true;
  }

  bool has_vertex_integrals() const final override
  {
    return false;
  }

  bool has_custom_integrals() const final override
  {
    return false;
  }

  bool has_cutcell_integrals() const final override
  {
    return false;
  }

  bool has_interface_integrals() const final override
  {
    return false;
  }

  bool has_overlap_integrals() const final override
  {
    return false;
  }

  ufc::cell_integral * create_cell_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::exterior_facet_integral * create_exterior_facet_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::interior_facet_integral * create_interior_facet_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::vertex_integral * create_vertex_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::custom_integral * create_custom_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::cutcell_integral * create_cutcell_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::interface_integral * create_interface_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::overlap_integral * create_overlap_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::cell_integral * create_default_cell_integral() const final override
  {
    return new adaptivepoisson_cell_integral_7_otherwise();
  }

  ufc::exterior_facet_integral * create_default_exterior_facet_integral() const final override
  {
    return new adaptivepoisson_exterior_facet_integral_7_otherwise();
  }

  ufc::interior_facet_integral * create_default_interior_facet_integral() const final override
  {
    return new adaptivepoisson_interior_facet_integral_7_otherwise();
  }

  ufc::vertex_integral * create_default_vertex_integral() const final override
  {
    return 0;
  }

  ufc::custom_integral * create_default_custom_integral() const final override
  {
    return 0;
  }

  ufc::cutcell_integral * create_default_cutcell_integral() const final override
  {
    return 0;
  }

  ufc::interface_integral * create_default_interface_integral() const final override
  {
    return 0;
  }

  ufc::overlap_integral * create_default_overlap_integral() const final override
  {
    return 0;
  }

};


class adaptivepoisson_form_8: public ufc::form
{
public:

  adaptivepoisson_form_8() : ufc::form()
  {
    // Do nothing
  }

  ~adaptivepoisson_form_8() override
  {
    // Do nothing
  }

  const char * signature() const final override
  {
    return "327a2ebce665f0df9dcdfb386a5f82bed655eb49e6748bfe664bd49258af417c023ae55cb0509c094373c6b9856a9f7f919048c8bddfe52512e528caaee3cde4";
  }

  std::size_t rank() const final override
  {
    return 2;
  }

  std::size_t num_coefficients() const final override
  {
    return 0;
  }

  std::size_t original_coefficient_position(std::size_t i) const final override
  {
    static const std::vector<std::size_t> position({});
    return position[i];
  }

  ufc::finite_element * create_coordinate_finite_element() const final override
  {
    return new adaptivepoisson_finite_element_1();
  }

  ufc::dofmap * create_coordinate_dofmap() const final override
  {
    return new adaptivepoisson_dofmap_1();
   }

  ufc::coordinate_mapping * create_coordinate_mapping() const final override
  {
    return nullptr;
  }

  ufc::finite_element * create_finite_element(std::size_t i) const final override
  {
    switch (i)
    {
    case 0:
      {
        return new adaptivepoisson_finite_element_0();
        break;
      }
    case 1:
      {
        return new adaptivepoisson_finite_element_0();
        break;
      }
    }
    
    return 0;
  }

  ufc::dofmap * create_dofmap(std::size_t i) const final override
  {
    switch (i)
    {
    case 0:
      {
        return new adaptivepoisson_dofmap_0();
        break;
      }
    case 1:
      {
        return new adaptivepoisson_dofmap_0();
        break;
      }
    }
    
    return 0;
  }

  std::size_t max_cell_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_exterior_facet_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_interior_facet_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_vertex_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_custom_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_cutcell_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_interface_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_overlap_subdomain_id() const final override
  {
    return 0;
  }

  bool has_cell_integrals() const final override
  {
    return true;
  }

  bool has_exterior_facet_integrals() const final override
  {
    return false;
  }

  bool has_interior_facet_integrals() const final override
  {
    return false;
  }

  bool has_vertex_integrals() const final override
  {
    return false;
  }

  bool has_custom_integrals() const final override
  {
    return false;
  }

  bool has_cutcell_integrals() const final override
  {
    return false;
  }

  bool has_interface_integrals() const final override
  {
    return false;
  }

  bool has_overlap_integrals() const final override
  {
    return false;
  }

  ufc::cell_integral * create_cell_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::exterior_facet_integral * create_exterior_facet_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::interior_facet_integral * create_interior_facet_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::vertex_integral * create_vertex_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::custom_integral * create_custom_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::cutcell_integral * create_cutcell_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::interface_integral * create_interface_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::overlap_integral * create_overlap_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::cell_integral * create_default_cell_integral() const final override
  {
    return new adaptivepoisson_cell_integral_8_otherwise();
  }

  ufc::exterior_facet_integral * create_default_exterior_facet_integral() const final override
  {
    return 0;
  }

  ufc::interior_facet_integral * create_default_interior_facet_integral() const final override
  {
    return 0;
  }

  ufc::vertex_integral * create_default_vertex_integral() const final override
  {
    return 0;
  }

  ufc::custom_integral * create_default_custom_integral() const final override
  {
    return 0;
  }

  ufc::cutcell_integral * create_default_cutcell_integral() const final override
  {
    return 0;
  }

  ufc::interface_integral * create_default_interface_integral() const final override
  {
    return 0;
  }

  ufc::overlap_integral * create_default_overlap_integral() const final override
  {
    return 0;
  }

};


class adaptivepoisson_form_9: public ufc::form
{
public:

  adaptivepoisson_form_9() : ufc::form()
  {
    // Do nothing
  }

  ~adaptivepoisson_form_9() override
  {
    // Do nothing
  }

  const char * signature() const final override
  {
    return "4b3b1c93f282ab055c940e8938b5687d692b500d84be151f71593ae9d6ad97e0c11f287e5960fa8de2ad6025423bd6e9dc808cf75c5a18587d11a7db9b67ccf0";
  }

  std::size_t rank() const final override
  {
    return 1;
  }

  std::size_t num_coefficients() const final override
  {
    return 2;
  }

  std::size_t original_coefficient_position(std::size_t i) const final override
  {
    static const std::vector<std::size_t> position({0, 1});
    return position[i];
  }

  ufc::finite_element * create_coordinate_finite_element() const final override
  {
    return new adaptivepoisson_finite_element_1();
  }

  ufc::dofmap * create_coordinate_dofmap() const final override
  {
    return new adaptivepoisson_dofmap_1();
   }

  ufc::coordinate_mapping * create_coordinate_mapping() const final override
  {
    return nullptr;
  }

  ufc::finite_element * create_finite_element(std::size_t i) const final override
  {
    switch (i)
    {
    case 0:
      {
        return new adaptivepoisson_finite_element_0();
        break;
      }
    case 1:
      {
        return new adaptivepoisson_finite_element_0();
        break;
      }
    case 2:
      {
        return new adaptivepoisson_finite_element_0();
        break;
      }
    }
    
    return 0;
  }

  ufc::dofmap * create_dofmap(std::size_t i) const final override
  {
    switch (i)
    {
    case 0:
      {
        return new adaptivepoisson_dofmap_0();
        break;
      }
    case 1:
      {
        return new adaptivepoisson_dofmap_0();
        break;
      }
    case 2:
      {
        return new adaptivepoisson_dofmap_0();
        break;
      }
    }
    
    return 0;
  }

  std::size_t max_cell_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_exterior_facet_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_interior_facet_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_vertex_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_custom_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_cutcell_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_interface_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_overlap_subdomain_id() const final override
  {
    return 0;
  }

  bool has_cell_integrals() const final override
  {
    return true;
  }

  bool has_exterior_facet_integrals() const final override
  {
    return true;
  }

  bool has_interior_facet_integrals() const final override
  {
    return false;
  }

  bool has_vertex_integrals() const final override
  {
    return false;
  }

  bool has_custom_integrals() const final override
  {
    return false;
  }

  bool has_cutcell_integrals() const final override
  {
    return false;
  }

  bool has_interface_integrals() const final override
  {
    return false;
  }

  bool has_overlap_integrals() const final override
  {
    return false;
  }

  ufc::cell_integral * create_cell_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::exterior_facet_integral * create_exterior_facet_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::interior_facet_integral * create_interior_facet_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::vertex_integral * create_vertex_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::custom_integral * create_custom_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::cutcell_integral * create_cutcell_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::interface_integral * create_interface_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::overlap_integral * create_overlap_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::cell_integral * create_default_cell_integral() const final override
  {
    return new adaptivepoisson_cell_integral_9_otherwise();
  }

  ufc::exterior_facet_integral * create_default_exterior_facet_integral() const final override
  {
    return new adaptivepoisson_exterior_facet_integral_9_otherwise();
  }

  ufc::interior_facet_integral * create_default_interior_facet_integral() const final override
  {
    return 0;
  }

  ufc::vertex_integral * create_default_vertex_integral() const final override
  {
    return 0;
  }

  ufc::custom_integral * create_default_custom_integral() const final override
  {
    return 0;
  }

  ufc::cutcell_integral * create_default_cutcell_integral() const final override
  {
    return 0;
  }

  ufc::interface_integral * create_default_interface_integral() const final override
  {
    return 0;
  }

  ufc::overlap_integral * create_default_overlap_integral() const final override
  {
    return 0;
  }

};


class adaptivepoisson_form_10: public ufc::form
{
public:

  adaptivepoisson_form_10() : ufc::form()
  {
    // Do nothing
  }

  ~adaptivepoisson_form_10() override
  {
    // Do nothing
  }

  const char * signature() const final override
  {
    return "50bbc7cf240795d58d8aa20ad76af963b7191605d923b45d4c90151a987751f8d90adee2e27ef4192932024d4e4f77a9dfe936f84a6abb2d323b1d1dbde2cc52";
  }

  std::size_t rank() const final override
  {
    return 0;
  }

  std::size_t num_coefficients() const final override
  {
    return 1;
  }

  std::size_t original_coefficient_position(std::size_t i) const final override
  {
    static const std::vector<std::size_t> position({0});
    return position[i];
  }

  ufc::finite_element * create_coordinate_finite_element() const final override
  {
    return new adaptivepoisson_finite_element_1();
  }

  ufc::dofmap * create_coordinate_dofmap() const final override
  {
    return new adaptivepoisson_dofmap_1();
   }

  ufc::coordinate_mapping * create_coordinate_mapping() const final override
  {
    return nullptr;
  }

  ufc::finite_element * create_finite_element(std::size_t i) const final override
  {
    switch (i)
    {
    case 0:
      {
        return new adaptivepoisson_finite_element_0();
        break;
      }
    }
    
    return 0;
  }

  ufc::dofmap * create_dofmap(std::size_t i) const final override
  {
    switch (i)
    {
    case 0:
      {
        return new adaptivepoisson_dofmap_0();
        break;
      }
    }
    
    return 0;
  }

  std::size_t max_cell_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_exterior_facet_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_interior_facet_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_vertex_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_custom_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_cutcell_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_interface_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_overlap_subdomain_id() const final override
  {
    return 0;
  }

  bool has_cell_integrals() const final override
  {
    return true;
  }

  bool has_exterior_facet_integrals() const final override
  {
    return false;
  }

  bool has_interior_facet_integrals() const final override
  {
    return false;
  }

  bool has_vertex_integrals() const final override
  {
    return false;
  }

  bool has_custom_integrals() const final override
  {
    return false;
  }

  bool has_cutcell_integrals() const final override
  {
    return false;
  }

  bool has_interface_integrals() const final override
  {
    return false;
  }

  bool has_overlap_integrals() const final override
  {
    return false;
  }

  ufc::cell_integral * create_cell_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::exterior_facet_integral * create_exterior_facet_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::interior_facet_integral * create_interior_facet_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::vertex_integral * create_vertex_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::custom_integral * create_custom_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::cutcell_integral * create_cutcell_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::interface_integral * create_interface_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::overlap_integral * create_overlap_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::cell_integral * create_default_cell_integral() const final override
  {
    return new adaptivepoisson_cell_integral_10_otherwise();
  }

  ufc::exterior_facet_integral * create_default_exterior_facet_integral() const final override
  {
    return 0;
  }

  ufc::interior_facet_integral * create_default_interior_facet_integral() const final override
  {
    return 0;
  }

  ufc::vertex_integral * create_default_vertex_integral() const final override
  {
    return 0;
  }

  ufc::custom_integral * create_default_custom_integral() const final override
  {
    return 0;
  }

  ufc::cutcell_integral * create_default_cutcell_integral() const final override
  {
    return 0;
  }

  ufc::interface_integral * create_default_interface_integral() const final override
  {
    return 0;
  }

  ufc::overlap_integral * create_default_overlap_integral() const final override
  {
    return 0;
  }

};

// DOLFIN wrappers

// Standard library includes
#include <string>

// DOLFIN includes
#include <dolfin/common/NoDeleter.h>
#include <dolfin/mesh/Mesh.h>
#include <dolfin/mesh/MultiMesh.h>
#include <dolfin/fem/FiniteElement.h>
#include <dolfin/fem/DofMap.h>
#include <dolfin/fem/Form.h>
#include <dolfin/fem/MultiMeshForm.h>
#include <dolfin/function/FunctionSpace.h>
#include <dolfin/function/MultiMeshFunctionSpace.h>
#include <dolfin/function/GenericFunction.h>
#include <dolfin/function/CoefficientAssigner.h>
#include <dolfin/function/MultiMeshCoefficientAssigner.h>
#include <dolfin/adaptivity/ErrorControl.h>
#include <dolfin/adaptivity/GoalFunctional.h>
#include <dolfin/la/GenericVector.h>

namespace AdaptivePoisson
{

class CoefficientSpace___cell_bubble: public dolfin::FunctionSpace
{
public:

  // Constructor for standard function space
  CoefficientSpace___cell_bubble(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<adaptivepoisson_finite_element_6>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<adaptivepoisson_dofmap_6>(), *mesh))
  {
    // Do nothing
  }

  // Constructor for constrained function space
  CoefficientSpace___cell_bubble(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<adaptivepoisson_finite_element_6>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<adaptivepoisson_dofmap_6>(), *mesh, constrained_domain))
  {
    // Do nothing
  }

};

class CoefficientSpace___cell_cone: public dolfin::FunctionSpace
{
public:

  // Constructor for standard function space
  CoefficientSpace___cell_cone(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<adaptivepoisson_finite_element_3>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<adaptivepoisson_dofmap_3>(), *mesh))
  {
    // Do nothing
  }

  // Constructor for constrained function space
  CoefficientSpace___cell_cone(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<adaptivepoisson_finite_element_3>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<adaptivepoisson_dofmap_3>(), *mesh, constrained_domain))
  {
    // Do nothing
  }

};

class CoefficientSpace___cell_residual: public dolfin::FunctionSpace
{
public:

  // Constructor for standard function space
  CoefficientSpace___cell_residual(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<adaptivepoisson_finite_element_4>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<adaptivepoisson_dofmap_4>(), *mesh))
  {
    // Do nothing
  }

  // Constructor for constrained function space
  CoefficientSpace___cell_residual(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<adaptivepoisson_finite_element_4>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<adaptivepoisson_dofmap_4>(), *mesh, constrained_domain))
  {
    // Do nothing
  }

};

class CoefficientSpace___discrete_dual_solution: public dolfin::FunctionSpace
{
public:

  // Constructor for standard function space
  CoefficientSpace___discrete_dual_solution(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<adaptivepoisson_finite_element_0>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<adaptivepoisson_dofmap_0>(), *mesh))
  {
    // Do nothing
  }

  // Constructor for constrained function space
  CoefficientSpace___discrete_dual_solution(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<adaptivepoisson_finite_element_0>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<adaptivepoisson_dofmap_0>(), *mesh, constrained_domain))
  {
    // Do nothing
  }

};

class CoefficientSpace___discrete_primal_solution: public dolfin::FunctionSpace
{
public:

  // Constructor for standard function space
  CoefficientSpace___discrete_primal_solution(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<adaptivepoisson_finite_element_0>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<adaptivepoisson_dofmap_0>(), *mesh))
  {
    // Do nothing
  }

  // Constructor for constrained function space
  CoefficientSpace___discrete_primal_solution(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<adaptivepoisson_finite_element_0>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<adaptivepoisson_dofmap_0>(), *mesh, constrained_domain))
  {
    // Do nothing
  }

};

class CoefficientSpace___facet_residual: public dolfin::FunctionSpace
{
public:

  // Constructor for standard function space
  CoefficientSpace___facet_residual(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<adaptivepoisson_finite_element_4>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<adaptivepoisson_dofmap_4>(), *mesh))
  {
    // Do nothing
  }

  // Constructor for constrained function space
  CoefficientSpace___facet_residual(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<adaptivepoisson_finite_element_4>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<adaptivepoisson_dofmap_4>(), *mesh, constrained_domain))
  {
    // Do nothing
  }

};

class CoefficientSpace___improved_dual: public dolfin::FunctionSpace
{
public:

  // Constructor for standard function space
  CoefficientSpace___improved_dual(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<adaptivepoisson_finite_element_2>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<adaptivepoisson_dofmap_2>(), *mesh))
  {
    // Do nothing
  }

  // Constructor for constrained function space
  CoefficientSpace___improved_dual(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<adaptivepoisson_finite_element_2>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<adaptivepoisson_dofmap_2>(), *mesh, constrained_domain))
  {
    // Do nothing
  }

};

class CoefficientSpace_f: public dolfin::FunctionSpace
{
public:

  // Constructor for standard function space
  CoefficientSpace_f(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<adaptivepoisson_finite_element_0>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<adaptivepoisson_dofmap_0>(), *mesh))
  {
    // Do nothing
  }

  // Constructor for constrained function space
  CoefficientSpace_f(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<adaptivepoisson_finite_element_0>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<adaptivepoisson_dofmap_0>(), *mesh, constrained_domain))
  {
    // Do nothing
  }

};

class CoefficientSpace_g: public dolfin::FunctionSpace
{
public:

  // Constructor for standard function space
  CoefficientSpace_g(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<adaptivepoisson_finite_element_0>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<adaptivepoisson_dofmap_0>(), *mesh))
  {
    // Do nothing
  }

  // Constructor for constrained function space
  CoefficientSpace_g(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<adaptivepoisson_finite_element_0>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<adaptivepoisson_dofmap_0>(), *mesh, constrained_domain))
  {
    // Do nothing
  }

};

class Form_0_FunctionSpace_0: public dolfin::FunctionSpace
{
public:

  // Constructor for standard function space
  Form_0_FunctionSpace_0(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<adaptivepoisson_finite_element_0>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<adaptivepoisson_dofmap_0>(), *mesh))
  {
    // Do nothing
  }

  // Constructor for constrained function space
  Form_0_FunctionSpace_0(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<adaptivepoisson_finite_element_0>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<adaptivepoisson_dofmap_0>(), *mesh, constrained_domain))
  {
    // Do nothing
  }

};

class Form_0_FunctionSpace_1: public dolfin::FunctionSpace
{
public:

  // Constructor for standard function space
  Form_0_FunctionSpace_1(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<adaptivepoisson_finite_element_0>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<adaptivepoisson_dofmap_0>(), *mesh))
  {
    // Do nothing
  }

  // Constructor for constrained function space
  Form_0_FunctionSpace_1(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<adaptivepoisson_finite_element_0>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<adaptivepoisson_dofmap_0>(), *mesh, constrained_domain))
  {
    // Do nothing
  }

};

class Form_0: public dolfin::Form
{
public:

  // Constructor
  Form_0(std::shared_ptr<const dolfin::FunctionSpace> V1, std::shared_ptr<const dolfin::FunctionSpace> V0):
    dolfin::Form(2, 0)
  {
    _function_spaces[0] = V0;
    _function_spaces[1] = V1;

    _ufc_form = std::make_shared<const adaptivepoisson_form_0>();
  }

  // Destructor
  ~Form_0()
  {}

  /// Return the number of the coefficient with this name
  virtual std::size_t coefficient_number(const std::string& name) const
  {

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "There are no coefficients");
    return 0;
  }

  /// Return the name of the coefficient with this number
  virtual std::string coefficient_name(std::size_t i) const
  {

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "There are no coefficients");
    return "unnamed";
  }

  // Typedefs
  typedef Form_0_FunctionSpace_0 TestSpace;
  typedef Form_0_FunctionSpace_1 TrialSpace;

  // Coefficients
};


class Form_1_FunctionSpace_0: public dolfin::FunctionSpace
{
public:

  // Constructor for standard function space
  Form_1_FunctionSpace_0(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<adaptivepoisson_finite_element_0>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<adaptivepoisson_dofmap_0>(), *mesh))
  {
    // Do nothing
  }

  // Constructor for constrained function space
  Form_1_FunctionSpace_0(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<adaptivepoisson_finite_element_0>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<adaptivepoisson_dofmap_0>(), *mesh, constrained_domain))
  {
    // Do nothing
  }

};

class Form_1: public dolfin::Form
{
public:

  // Constructor
  Form_1(std::shared_ptr<const dolfin::FunctionSpace> V0):
    dolfin::Form(1, 0)
  {
    _function_spaces[0] = V0;

    _ufc_form = std::make_shared<const adaptivepoisson_form_1>();
  }

  // Destructor
  ~Form_1()
  {}

  /// Return the number of the coefficient with this name
  virtual std::size_t coefficient_number(const std::string& name) const
  {

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "There are no coefficients");
    return 0;
  }

  /// Return the name of the coefficient with this number
  virtual std::string coefficient_name(std::size_t i) const
  {

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "There are no coefficients");
    return "unnamed";
  }

  // Typedefs
  typedef Form_1_FunctionSpace_0 TestSpace;

  // Coefficients
};


typedef CoefficientSpace_f Form_2_FunctionSpace_0;

typedef CoefficientSpace_g Form_2_FunctionSpace_1;

typedef CoefficientSpace___discrete_primal_solution Form_2_FunctionSpace_2;

typedef CoefficientSpace___improved_dual Form_2_FunctionSpace_3;

class Form_2: public dolfin::Form
{
public:

  // Constructor
  Form_2(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::Form(0, 4), f(*this, 0), g(*this, 1), __discrete_primal_solution(*this, 2), __improved_dual(*this, 3)
  {
    _mesh = mesh;
    _ufc_form = std::make_shared<const adaptivepoisson_form_2>();
  }

  // Constructor
  Form_2(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::GenericFunction> f, std::shared_ptr<const dolfin::GenericFunction> g, std::shared_ptr<const dolfin::GenericFunction> __discrete_primal_solution, std::shared_ptr<const dolfin::GenericFunction> __improved_dual):
    dolfin::Form(0, 4), f(*this, 0), g(*this, 1), __discrete_primal_solution(*this, 2), __improved_dual(*this, 3)
  {
    _mesh = mesh;
    this->f = f;
    this->g = g;
    this->__discrete_primal_solution = __discrete_primal_solution;
    this->__improved_dual = __improved_dual;

    _ufc_form = std::make_shared<const adaptivepoisson_form_2>();
  }

  // Destructor
  ~Form_2()
  {}

  /// Return the number of the coefficient with this name
  virtual std::size_t coefficient_number(const std::string& name) const
  {
    if (name == "f")
      return 0;
    else if (name == "g")
      return 1;
    else if (name == "__discrete_primal_solution")
      return 2;
    else if (name == "__improved_dual")
      return 3;

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "Invalid coefficient");
    return 0;
  }

  /// Return the name of the coefficient with this number
  virtual std::string coefficient_name(std::size_t i) const
  {
    switch (i)
    {
    case 0:
      return "f";
    case 1:
      return "g";
    case 2:
      return "__discrete_primal_solution";
    case 3:
      return "__improved_dual";
    }

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "Invalid coefficient");
    return "unnamed";
  }

  // Typedefs
  typedef Form_2_FunctionSpace_0 CoefficientSpace_f;
  typedef Form_2_FunctionSpace_1 CoefficientSpace_g;
  typedef Form_2_FunctionSpace_2 CoefficientSpace___discrete_primal_solution;
  typedef Form_2_FunctionSpace_3 CoefficientSpace___improved_dual;

  // Coefficients
  dolfin::CoefficientAssigner f;
  dolfin::CoefficientAssigner g;
  dolfin::CoefficientAssigner __discrete_primal_solution;
  dolfin::CoefficientAssigner __improved_dual;
};


class Form_3_FunctionSpace_0: public dolfin::FunctionSpace
{
public:

  // Constructor for standard function space
  Form_3_FunctionSpace_0(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<adaptivepoisson_finite_element_4>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<adaptivepoisson_dofmap_4>(), *mesh))
  {
    // Do nothing
  }

  // Constructor for constrained function space
  Form_3_FunctionSpace_0(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<adaptivepoisson_finite_element_4>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<adaptivepoisson_dofmap_4>(), *mesh, constrained_domain))
  {
    // Do nothing
  }

};

class Form_3_FunctionSpace_1: public dolfin::FunctionSpace
{
public:

  // Constructor for standard function space
  Form_3_FunctionSpace_1(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<adaptivepoisson_finite_element_4>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<adaptivepoisson_dofmap_4>(), *mesh))
  {
    // Do nothing
  }

  // Constructor for constrained function space
  Form_3_FunctionSpace_1(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<adaptivepoisson_finite_element_4>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<adaptivepoisson_dofmap_4>(), *mesh, constrained_domain))
  {
    // Do nothing
  }

};

typedef CoefficientSpace___cell_bubble Form_3_FunctionSpace_2;

class Form_3: public dolfin::Form
{
public:

  // Constructor
  Form_3(std::shared_ptr<const dolfin::FunctionSpace> V1, std::shared_ptr<const dolfin::FunctionSpace> V0):
    dolfin::Form(2, 1), __cell_bubble(*this, 0)
  {
    _function_spaces[0] = V0;
    _function_spaces[1] = V1;

    _ufc_form = std::make_shared<const adaptivepoisson_form_3>();
  }

  // Constructor
  Form_3(std::shared_ptr<const dolfin::FunctionSpace> V1, std::shared_ptr<const dolfin::FunctionSpace> V0, std::shared_ptr<const dolfin::GenericFunction> __cell_bubble):
    dolfin::Form(2, 1), __cell_bubble(*this, 0)
  {
    _function_spaces[0] = V0;
    _function_spaces[1] = V1;

    this->__cell_bubble = __cell_bubble;

    _ufc_form = std::make_shared<const adaptivepoisson_form_3>();
  }

  // Destructor
  ~Form_3()
  {}

  /// Return the number of the coefficient with this name
  virtual std::size_t coefficient_number(const std::string& name) const
  {
    if (name == "__cell_bubble")
      return 0;

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "Invalid coefficient");
    return 0;
  }

  /// Return the name of the coefficient with this number
  virtual std::string coefficient_name(std::size_t i) const
  {
    switch (i)
    {
    case 0:
      return "__cell_bubble";
    }

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "Invalid coefficient");
    return "unnamed";
  }

  // Typedefs
  typedef Form_3_FunctionSpace_0 TestSpace;
  typedef Form_3_FunctionSpace_1 TrialSpace;
  typedef Form_3_FunctionSpace_2 CoefficientSpace___cell_bubble;

  // Coefficients
  dolfin::CoefficientAssigner __cell_bubble;
};


class Form_4_FunctionSpace_0: public dolfin::FunctionSpace
{
public:

  // Constructor for standard function space
  Form_4_FunctionSpace_0(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<adaptivepoisson_finite_element_4>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<adaptivepoisson_dofmap_4>(), *mesh))
  {
    // Do nothing
  }

  // Constructor for constrained function space
  Form_4_FunctionSpace_0(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<adaptivepoisson_finite_element_4>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<adaptivepoisson_dofmap_4>(), *mesh, constrained_domain))
  {
    // Do nothing
  }

};

typedef CoefficientSpace_f Form_4_FunctionSpace_1;

typedef CoefficientSpace_g Form_4_FunctionSpace_2;

typedef CoefficientSpace___discrete_primal_solution Form_4_FunctionSpace_3;

typedef CoefficientSpace___cell_bubble Form_4_FunctionSpace_4;

class Form_4: public dolfin::Form
{
public:

  // Constructor
  Form_4(std::shared_ptr<const dolfin::FunctionSpace> V0):
    dolfin::Form(1, 4), f(*this, 0), g(*this, 1), __discrete_primal_solution(*this, 2), __cell_bubble(*this, 3)
  {
    _function_spaces[0] = V0;

    _ufc_form = std::make_shared<const adaptivepoisson_form_4>();
  }

  // Constructor
  Form_4(std::shared_ptr<const dolfin::FunctionSpace> V0, std::shared_ptr<const dolfin::GenericFunction> f, std::shared_ptr<const dolfin::GenericFunction> g, std::shared_ptr<const dolfin::GenericFunction> __discrete_primal_solution, std::shared_ptr<const dolfin::GenericFunction> __cell_bubble):
    dolfin::Form(1, 4), f(*this, 0), g(*this, 1), __discrete_primal_solution(*this, 2), __cell_bubble(*this, 3)
  {
    _function_spaces[0] = V0;

    this->f = f;
    this->g = g;
    this->__discrete_primal_solution = __discrete_primal_solution;
    this->__cell_bubble = __cell_bubble;

    _ufc_form = std::make_shared<const adaptivepoisson_form_4>();
  }

  // Destructor
  ~Form_4()
  {}

  /// Return the number of the coefficient with this name
  virtual std::size_t coefficient_number(const std::string& name) const
  {
    if (name == "f")
      return 0;
    else if (name == "g")
      return 1;
    else if (name == "__discrete_primal_solution")
      return 2;
    else if (name == "__cell_bubble")
      return 3;

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "Invalid coefficient");
    return 0;
  }

  /// Return the name of the coefficient with this number
  virtual std::string coefficient_name(std::size_t i) const
  {
    switch (i)
    {
    case 0:
      return "f";
    case 1:
      return "g";
    case 2:
      return "__discrete_primal_solution";
    case 3:
      return "__cell_bubble";
    }

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "Invalid coefficient");
    return "unnamed";
  }

  // Typedefs
  typedef Form_4_FunctionSpace_0 TestSpace;
  typedef Form_4_FunctionSpace_1 CoefficientSpace_f;
  typedef Form_4_FunctionSpace_2 CoefficientSpace_g;
  typedef Form_4_FunctionSpace_3 CoefficientSpace___discrete_primal_solution;
  typedef Form_4_FunctionSpace_4 CoefficientSpace___cell_bubble;

  // Coefficients
  dolfin::CoefficientAssigner f;
  dolfin::CoefficientAssigner g;
  dolfin::CoefficientAssigner __discrete_primal_solution;
  dolfin::CoefficientAssigner __cell_bubble;
};


class Form_5_FunctionSpace_0: public dolfin::FunctionSpace
{
public:

  // Constructor for standard function space
  Form_5_FunctionSpace_0(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<adaptivepoisson_finite_element_4>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<adaptivepoisson_dofmap_4>(), *mesh))
  {
    // Do nothing
  }

  // Constructor for constrained function space
  Form_5_FunctionSpace_0(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<adaptivepoisson_finite_element_4>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<adaptivepoisson_dofmap_4>(), *mesh, constrained_domain))
  {
    // Do nothing
  }

};

class Form_5_FunctionSpace_1: public dolfin::FunctionSpace
{
public:

  // Constructor for standard function space
  Form_5_FunctionSpace_1(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<adaptivepoisson_finite_element_4>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<adaptivepoisson_dofmap_4>(), *mesh))
  {
    // Do nothing
  }

  // Constructor for constrained function space
  Form_5_FunctionSpace_1(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<adaptivepoisson_finite_element_4>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<adaptivepoisson_dofmap_4>(), *mesh, constrained_domain))
  {
    // Do nothing
  }

};

typedef CoefficientSpace___cell_cone Form_5_FunctionSpace_2;

class Form_5: public dolfin::Form
{
public:

  // Constructor
  Form_5(std::shared_ptr<const dolfin::FunctionSpace> V1, std::shared_ptr<const dolfin::FunctionSpace> V0):
    dolfin::Form(2, 1), __cell_cone(*this, 0)
  {
    _function_spaces[0] = V0;
    _function_spaces[1] = V1;

    _ufc_form = std::make_shared<const adaptivepoisson_form_5>();
  }

  // Constructor
  Form_5(std::shared_ptr<const dolfin::FunctionSpace> V1, std::shared_ptr<const dolfin::FunctionSpace> V0, std::shared_ptr<const dolfin::GenericFunction> __cell_cone):
    dolfin::Form(2, 1), __cell_cone(*this, 0)
  {
    _function_spaces[0] = V0;
    _function_spaces[1] = V1;

    this->__cell_cone = __cell_cone;

    _ufc_form = std::make_shared<const adaptivepoisson_form_5>();
  }

  // Destructor
  ~Form_5()
  {}

  /// Return the number of the coefficient with this name
  virtual std::size_t coefficient_number(const std::string& name) const
  {
    if (name == "__cell_cone")
      return 0;

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "Invalid coefficient");
    return 0;
  }

  /// Return the name of the coefficient with this number
  virtual std::string coefficient_name(std::size_t i) const
  {
    switch (i)
    {
    case 0:
      return "__cell_cone";
    }

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "Invalid coefficient");
    return "unnamed";
  }

  // Typedefs
  typedef Form_5_FunctionSpace_0 TestSpace;
  typedef Form_5_FunctionSpace_1 TrialSpace;
  typedef Form_5_FunctionSpace_2 CoefficientSpace___cell_cone;

  // Coefficients
  dolfin::CoefficientAssigner __cell_cone;
};


class Form_6_FunctionSpace_0: public dolfin::FunctionSpace
{
public:

  // Constructor for standard function space
  Form_6_FunctionSpace_0(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<adaptivepoisson_finite_element_4>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<adaptivepoisson_dofmap_4>(), *mesh))
  {
    // Do nothing
  }

  // Constructor for constrained function space
  Form_6_FunctionSpace_0(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<adaptivepoisson_finite_element_4>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<adaptivepoisson_dofmap_4>(), *mesh, constrained_domain))
  {
    // Do nothing
  }

};

typedef CoefficientSpace_f Form_6_FunctionSpace_1;

typedef CoefficientSpace_g Form_6_FunctionSpace_2;

typedef CoefficientSpace___discrete_primal_solution Form_6_FunctionSpace_3;

typedef CoefficientSpace___cell_residual Form_6_FunctionSpace_4;

typedef CoefficientSpace___cell_cone Form_6_FunctionSpace_5;

class Form_6: public dolfin::Form
{
public:

  // Constructor
  Form_6(std::shared_ptr<const dolfin::FunctionSpace> V0):
    dolfin::Form(1, 5), f(*this, 0), g(*this, 1), __discrete_primal_solution(*this, 2), __cell_residual(*this, 3), __cell_cone(*this, 4)
  {
    _function_spaces[0] = V0;

    _ufc_form = std::make_shared<const adaptivepoisson_form_6>();
  }

  // Constructor
  Form_6(std::shared_ptr<const dolfin::FunctionSpace> V0, std::shared_ptr<const dolfin::GenericFunction> f, std::shared_ptr<const dolfin::GenericFunction> g, std::shared_ptr<const dolfin::GenericFunction> __discrete_primal_solution, std::shared_ptr<const dolfin::GenericFunction> __cell_residual, std::shared_ptr<const dolfin::GenericFunction> __cell_cone):
    dolfin::Form(1, 5), f(*this, 0), g(*this, 1), __discrete_primal_solution(*this, 2), __cell_residual(*this, 3), __cell_cone(*this, 4)
  {
    _function_spaces[0] = V0;

    this->f = f;
    this->g = g;
    this->__discrete_primal_solution = __discrete_primal_solution;
    this->__cell_residual = __cell_residual;
    this->__cell_cone = __cell_cone;

    _ufc_form = std::make_shared<const adaptivepoisson_form_6>();
  }

  // Destructor
  ~Form_6()
  {}

  /// Return the number of the coefficient with this name
  virtual std::size_t coefficient_number(const std::string& name) const
  {
    if (name == "f")
      return 0;
    else if (name == "g")
      return 1;
    else if (name == "__discrete_primal_solution")
      return 2;
    else if (name == "__cell_residual")
      return 3;
    else if (name == "__cell_cone")
      return 4;

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "Invalid coefficient");
    return 0;
  }

  /// Return the name of the coefficient with this number
  virtual std::string coefficient_name(std::size_t i) const
  {
    switch (i)
    {
    case 0:
      return "f";
    case 1:
      return "g";
    case 2:
      return "__discrete_primal_solution";
    case 3:
      return "__cell_residual";
    case 4:
      return "__cell_cone";
    }

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "Invalid coefficient");
    return "unnamed";
  }

  // Typedefs
  typedef Form_6_FunctionSpace_0 TestSpace;
  typedef Form_6_FunctionSpace_1 CoefficientSpace_f;
  typedef Form_6_FunctionSpace_2 CoefficientSpace_g;
  typedef Form_6_FunctionSpace_3 CoefficientSpace___discrete_primal_solution;
  typedef Form_6_FunctionSpace_4 CoefficientSpace___cell_residual;
  typedef Form_6_FunctionSpace_5 CoefficientSpace___cell_cone;

  // Coefficients
  dolfin::CoefficientAssigner f;
  dolfin::CoefficientAssigner g;
  dolfin::CoefficientAssigner __discrete_primal_solution;
  dolfin::CoefficientAssigner __cell_residual;
  dolfin::CoefficientAssigner __cell_cone;
};


class Form_7_FunctionSpace_0: public dolfin::FunctionSpace
{
public:

  // Constructor for standard function space
  Form_7_FunctionSpace_0(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<adaptivepoisson_finite_element_5>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<adaptivepoisson_dofmap_5>(), *mesh))
  {
    // Do nothing
  }

  // Constructor for constrained function space
  Form_7_FunctionSpace_0(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<adaptivepoisson_finite_element_5>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<adaptivepoisson_dofmap_5>(), *mesh, constrained_domain))
  {
    // Do nothing
  }

};

typedef CoefficientSpace___improved_dual Form_7_FunctionSpace_1;

typedef CoefficientSpace___cell_residual Form_7_FunctionSpace_2;

typedef CoefficientSpace___facet_residual Form_7_FunctionSpace_3;

typedef CoefficientSpace___discrete_dual_solution Form_7_FunctionSpace_4;

class Form_7: public dolfin::Form
{
public:

  // Constructor
  Form_7(std::shared_ptr<const dolfin::FunctionSpace> V0):
    dolfin::Form(1, 4), __improved_dual(*this, 0), __cell_residual(*this, 1), __facet_residual(*this, 2), __discrete_dual_solution(*this, 3)
  {
    _function_spaces[0] = V0;

    _ufc_form = std::make_shared<const adaptivepoisson_form_7>();
  }

  // Constructor
  Form_7(std::shared_ptr<const dolfin::FunctionSpace> V0, std::shared_ptr<const dolfin::GenericFunction> __improved_dual, std::shared_ptr<const dolfin::GenericFunction> __cell_residual, std::shared_ptr<const dolfin::GenericFunction> __facet_residual, std::shared_ptr<const dolfin::GenericFunction> __discrete_dual_solution):
    dolfin::Form(1, 4), __improved_dual(*this, 0), __cell_residual(*this, 1), __facet_residual(*this, 2), __discrete_dual_solution(*this, 3)
  {
    _function_spaces[0] = V0;

    this->__improved_dual = __improved_dual;
    this->__cell_residual = __cell_residual;
    this->__facet_residual = __facet_residual;
    this->__discrete_dual_solution = __discrete_dual_solution;

    _ufc_form = std::make_shared<const adaptivepoisson_form_7>();
  }

  // Destructor
  ~Form_7()
  {}

  /// Return the number of the coefficient with this name
  virtual std::size_t coefficient_number(const std::string& name) const
  {
    if (name == "__improved_dual")
      return 0;
    else if (name == "__cell_residual")
      return 1;
    else if (name == "__facet_residual")
      return 2;
    else if (name == "__discrete_dual_solution")
      return 3;

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "Invalid coefficient");
    return 0;
  }

  /// Return the name of the coefficient with this number
  virtual std::string coefficient_name(std::size_t i) const
  {
    switch (i)
    {
    case 0:
      return "__improved_dual";
    case 1:
      return "__cell_residual";
    case 2:
      return "__facet_residual";
    case 3:
      return "__discrete_dual_solution";
    }

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "Invalid coefficient");
    return "unnamed";
  }

  // Typedefs
  typedef Form_7_FunctionSpace_0 TestSpace;
  typedef Form_7_FunctionSpace_1 CoefficientSpace___improved_dual;
  typedef Form_7_FunctionSpace_2 CoefficientSpace___cell_residual;
  typedef Form_7_FunctionSpace_3 CoefficientSpace___facet_residual;
  typedef Form_7_FunctionSpace_4 CoefficientSpace___discrete_dual_solution;

  // Coefficients
  dolfin::CoefficientAssigner __improved_dual;
  dolfin::CoefficientAssigner __cell_residual;
  dolfin::CoefficientAssigner __facet_residual;
  dolfin::CoefficientAssigner __discrete_dual_solution;
};


class Form_lhs_FunctionSpace_0: public dolfin::FunctionSpace
{
public:

  // Constructor for standard function space
  Form_lhs_FunctionSpace_0(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<adaptivepoisson_finite_element_0>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<adaptivepoisson_dofmap_0>(), *mesh))
  {
    // Do nothing
  }

  // Constructor for constrained function space
  Form_lhs_FunctionSpace_0(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<adaptivepoisson_finite_element_0>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<adaptivepoisson_dofmap_0>(), *mesh, constrained_domain))
  {
    // Do nothing
  }

};

class Form_lhs_FunctionSpace_1: public dolfin::FunctionSpace
{
public:

  // Constructor for standard function space
  Form_lhs_FunctionSpace_1(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<adaptivepoisson_finite_element_0>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<adaptivepoisson_dofmap_0>(), *mesh))
  {
    // Do nothing
  }

  // Constructor for constrained function space
  Form_lhs_FunctionSpace_1(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<adaptivepoisson_finite_element_0>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<adaptivepoisson_dofmap_0>(), *mesh, constrained_domain))
  {
    // Do nothing
  }

};

class Form_lhs: public dolfin::Form
{
public:

  // Constructor
  Form_lhs(std::shared_ptr<const dolfin::FunctionSpace> V1, std::shared_ptr<const dolfin::FunctionSpace> V0):
    dolfin::Form(2, 0)
  {
    _function_spaces[0] = V0;
    _function_spaces[1] = V1;

    _ufc_form = std::make_shared<const adaptivepoisson_form_8>();
  }

  // Destructor
  ~Form_lhs()
  {}

  /// Return the number of the coefficient with this name
  virtual std::size_t coefficient_number(const std::string& name) const
  {

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "There are no coefficients");
    return 0;
  }

  /// Return the name of the coefficient with this number
  virtual std::string coefficient_name(std::size_t i) const
  {

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "There are no coefficients");
    return "unnamed";
  }

  // Typedefs
  typedef Form_lhs_FunctionSpace_0 TestSpace;
  typedef Form_lhs_FunctionSpace_1 TrialSpace;

  // Coefficients
};


class Form_rhs_FunctionSpace_0: public dolfin::FunctionSpace
{
public:

  // Constructor for standard function space
  Form_rhs_FunctionSpace_0(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<adaptivepoisson_finite_element_0>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<adaptivepoisson_dofmap_0>(), *mesh))
  {
    // Do nothing
  }

  // Constructor for constrained function space
  Form_rhs_FunctionSpace_0(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<adaptivepoisson_finite_element_0>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<adaptivepoisson_dofmap_0>(), *mesh, constrained_domain))
  {
    // Do nothing
  }

};

typedef CoefficientSpace_f Form_rhs_FunctionSpace_1;

typedef CoefficientSpace_g Form_rhs_FunctionSpace_2;

class Form_rhs: public dolfin::Form
{
public:

  // Constructor
  Form_rhs(std::shared_ptr<const dolfin::FunctionSpace> V0):
    dolfin::Form(1, 2), f(*this, 0), g(*this, 1)
  {
    _function_spaces[0] = V0;

    _ufc_form = std::make_shared<const adaptivepoisson_form_9>();
  }

  // Constructor
  Form_rhs(std::shared_ptr<const dolfin::FunctionSpace> V0, std::shared_ptr<const dolfin::GenericFunction> f, std::shared_ptr<const dolfin::GenericFunction> g):
    dolfin::Form(1, 2), f(*this, 0), g(*this, 1)
  {
    _function_spaces[0] = V0;

    this->f = f;
    this->g = g;

    _ufc_form = std::make_shared<const adaptivepoisson_form_9>();
  }

  // Destructor
  ~Form_rhs()
  {}

  /// Return the number of the coefficient with this name
  virtual std::size_t coefficient_number(const std::string& name) const
  {
    if (name == "f")
      return 0;
    else if (name == "g")
      return 1;

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "Invalid coefficient");
    return 0;
  }

  /// Return the name of the coefficient with this number
  virtual std::string coefficient_name(std::size_t i) const
  {
    switch (i)
    {
    case 0:
      return "f";
    case 1:
      return "g";
    }

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "Invalid coefficient");
    return "unnamed";
  }

  // Typedefs
  typedef Form_rhs_FunctionSpace_0 TestSpace;
  typedef Form_rhs_FunctionSpace_1 CoefficientSpace_f;
  typedef Form_rhs_FunctionSpace_2 CoefficientSpace_g;

  // Coefficients
  dolfin::CoefficientAssigner f;
  dolfin::CoefficientAssigner g;
};


typedef CoefficientSpace___discrete_primal_solution Form_goal_FunctionSpace_0;

class Form_goal: public dolfin::GoalFunctional
{
public:

  // Constructor
  Form_goal(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::GoalFunctional(0, 1), __discrete_primal_solution(*this, 0)
  {
    _mesh = mesh;
    _ufc_form = std::make_shared<const adaptivepoisson_form_10>();
  }

  // Constructor
  Form_goal(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::GenericFunction> __discrete_primal_solution):
    dolfin::GoalFunctional(0, 1), __discrete_primal_solution(*this, 0)
  {
    _mesh = mesh;
    this->__discrete_primal_solution = __discrete_primal_solution;

    _ufc_form = std::make_shared<const adaptivepoisson_form_10>();
  }

  // Destructor
  ~Form_goal()
  {}

  /// Return the number of the coefficient with this name
  virtual std::size_t coefficient_number(const std::string& name) const
  {
    if (name == "__discrete_primal_solution")
      return 0;

    dolfin::dolfin_error("generated code for class GoalFunctional",
                         "access coefficient data",
                         "Invalid coefficient");
    return 0;
  }

  /// Return the name of the coefficient with this number
  virtual std::string coefficient_name(std::size_t i) const
  {
    switch (i)
    {
    case 0:
      return "__discrete_primal_solution";
    }

    dolfin::dolfin_error("generated code for class GoalFunctional",
                         "access coefficient data",
                         "Invalid coefficient");
    return "unnamed";
  }

  // Typedefs
  typedef Form_goal_FunctionSpace_0 CoefficientSpace___discrete_primal_solution;

  // Coefficients
  dolfin::CoefficientAssigner __discrete_primal_solution;

  /// Initialize all error control forms, attach coefficients and
  /// (re-)set error control
  virtual void update_ec(const dolfin::Form& a, const dolfin::Form& L)
  {
    // This stuff is created here and shipped elsewhere
    std::shared_ptr<dolfin::Form> a_star;           // Dual lhs
    std::shared_ptr<dolfin::Form> L_star;           // Dual rhs
    std::shared_ptr<dolfin::FunctionSpace> V_Ez_h;  // Extrapolation space
    std::shared_ptr<dolfin::Function> Ez_h;         // Extrapolated dual
    std::shared_ptr<dolfin::Form> residual;         // Residual (as functional)
    std::shared_ptr<dolfin::FunctionSpace> V_R_T;   // Trial space for cell residual
    std::shared_ptr<dolfin::Form> a_R_T;            // Cell residual lhs
    std::shared_ptr<dolfin::Form> L_R_T;            // Cell residual rhs
    std::shared_ptr<dolfin::FunctionSpace> V_b_T;   // Function space for cell bubble
    std::shared_ptr<dolfin::Function> b_T;          // Cell bubble
    std::shared_ptr<dolfin::FunctionSpace> V_R_dT;  // Trial space for facet residual
    std::shared_ptr<dolfin::Form> a_R_dT;           // Facet residual lhs
    std::shared_ptr<dolfin::Form> L_R_dT;           // Facet residual rhs
    std::shared_ptr<dolfin::FunctionSpace> V_b_e;   // Function space for cell cone
    std::shared_ptr<dolfin::Function> b_e;          // Cell cone
    std::shared_ptr<dolfin::FunctionSpace> V_eta_T; // Function space for indicators
    std::shared_ptr<dolfin::Form> eta_T;            // Indicator form

    // Some handy views
    assert(a.function_space(0));
    const auto Vhat = a.function_space(0); // Primal test

    assert(a.function_space(0));
    const auto V = a.function_space(1);    // Primal trial

    assert(V->mesh());
    const auto mesh = V->mesh();

    std::string name;

    // Initialize dual forms
    a_star.reset(new Form_0(V, Vhat));
    L_star.reset(new Form_1(V));

    
    // Attach coefficients from a to a_star
    for (std::size_t i = 0; i < a.num_coefficients(); i++)
    {
      name = a.coefficient_name(i);
      // Don't attach discrete primal solution here (not computed).
      if (name == "__discrete_primal_solution")
        continue;

      // Test whether a_star has coefficient named 'name'
      try {
        a_star->coefficient_number(name);
      } catch (...) {
        std::cout << "Attaching coefficient named: " << name << " to a_star";
        std::cout << " failed! But this might be expected." << std::endl;
        continue;
      }
      a_star->set_coefficient(name, a.coefficient(i));
    }
    
    // Attach subdomains from a to a_star
    a_star->dx = a.cell_domains();
    a_star->ds = a.exterior_facet_domains();
    a_star->dS = a.interior_facet_domains();

    
    // Attach coefficients from (*this) to L_star
    for (std::size_t i = 0; i < (*this).num_coefficients(); i++)
    {
      name = (*this).coefficient_name(i);
      // Don't attach discrete primal solution here (not computed).
      if (name == "__discrete_primal_solution")
        continue;

      // Test whether L_star has coefficient named 'name'
      try {
        L_star->coefficient_number(name);
      } catch (...) {
        std::cout << "Attaching coefficient named: " << name << " to L_star";
        std::cout << " failed! But this might be expected." << std::endl;
        continue;
      }
      L_star->set_coefficient(name, (*this).coefficient(i));
    }
    
    // Attach subdomains from (*this) to L_star
    L_star->dx = (*this).cell_domains();
    L_star->ds = (*this).exterior_facet_domains();
    L_star->dS = (*this).interior_facet_domains();


    // Initialize residual
    residual.reset(new Form_2(mesh));
    
    // Attach coefficients from a to residual
    for (std::size_t i = 0; i < a.num_coefficients(); i++)
    {
      name = a.coefficient_name(i);
      // Don't attach discrete primal solution here (not computed).
      if (name == "__discrete_primal_solution")
        continue;

      // Test whether residual has coefficient named 'name'
      try {
        residual->coefficient_number(name);
      } catch (...) {
        std::cout << "Attaching coefficient named: " << name << " to residual";
        std::cout << " failed! But this might be expected." << std::endl;
        continue;
      }
      residual->set_coefficient(name, a.coefficient(i));
    }
    

    // Attach coefficients from L to residual
    for (std::size_t i = 0; i < L.num_coefficients(); i++)
    {
      name = L.coefficient_name(i);
      // Don't attach discrete primal solution here (not computed).
      if (name == "__discrete_primal_solution")
        continue;

      // Test whether residual has coefficient named 'name'
      try {
        residual->coefficient_number(name);
      } catch (...) {
        std::cout << "Attaching coefficient named: " << name << " to residual";
        std::cout << " failed! But this might be expected." << std::endl;
        continue;
      }
      residual->set_coefficient(name, L.coefficient(i));
    }
    
    // Attach subdomains from L to residual
    residual->dx = L.cell_domains();
    residual->ds = L.exterior_facet_domains();
    residual->dS = L.interior_facet_domains();


    // Initialize extrapolation space and (fake) extrapolation
    V_Ez_h.reset(new CoefficientSpace___improved_dual(mesh));
    Ez_h.reset(new dolfin::Function(V_Ez_h));
    residual->set_coefficient("__improved_dual", Ez_h);

    // Create bilinear and linear form for computing cell residual R_T
    V_R_T.reset(new Form_4::TestSpace(mesh));
    a_R_T.reset(new Form_3(V_R_T, V_R_T));
    L_R_T.reset(new Form_4(V_R_T));

    // Initialize bubble and attach to a_R_T and L_R_T
    V_b_T.reset(new CoefficientSpace___cell_bubble(mesh));
    b_T.reset(new dolfin::Function(V_b_T));
    *b_T->vector() = 1.0;
    
    // Attach coefficients from a to L_R_T
    for (std::size_t i = 0; i < a.num_coefficients(); i++)
    {
      name = a.coefficient_name(i);
      // Don't attach discrete primal solution here (not computed).
      if (name == "__discrete_primal_solution")
        continue;

      // Test whether L_R_T has coefficient named 'name'
      try {
        L_R_T->coefficient_number(name);
      } catch (...) {
        std::cout << "Attaching coefficient named: " << name << " to L_R_T";
        std::cout << " failed! But this might be expected." << std::endl;
        continue;
      }
      L_R_T->set_coefficient(name, a.coefficient(i));
    }
    

    // Attach coefficients from L to L_R_T
    for (std::size_t i = 0; i < L.num_coefficients(); i++)
    {
      name = L.coefficient_name(i);
      // Don't attach discrete primal solution here (not computed).
      if (name == "__discrete_primal_solution")
        continue;

      // Test whether L_R_T has coefficient named 'name'
      try {
        L_R_T->coefficient_number(name);
      } catch (...) {
        std::cout << "Attaching coefficient named: " << name << " to L_R_T";
        std::cout << " failed! But this might be expected." << std::endl;
        continue;
      }
      L_R_T->set_coefficient(name, L.coefficient(i));
    }
    
    // Attach subdomains from L to L_R_T
    L_R_T->dx = L.cell_domains();
    L_R_T->ds = L.exterior_facet_domains();
    L_R_T->dS = L.interior_facet_domains();


    // Attach bubble function to _a_R_T and _L_R_T
    a_R_T->set_coefficient("__cell_bubble", b_T);
    L_R_T->set_coefficient("__cell_bubble", b_T);

    // Create bilinear and linear form for computing facet residual R_dT
    V_R_dT.reset(new Form_6::TestSpace(mesh));
    a_R_dT.reset(new Form_5(V_R_dT, V_R_dT));
    L_R_dT.reset(new Form_6(V_R_dT));
    
    // Attach coefficients from a to L_R_dT
    for (std::size_t i = 0; i < a.num_coefficients(); i++)
    {
      name = a.coefficient_name(i);
      // Don't attach discrete primal solution here (not computed).
      if (name == "__discrete_primal_solution")
        continue;

      // Test whether L_R_dT has coefficient named 'name'
      try {
        L_R_dT->coefficient_number(name);
      } catch (...) {
        std::cout << "Attaching coefficient named: " << name << " to L_R_dT";
        std::cout << " failed! But this might be expected." << std::endl;
        continue;
      }
      L_R_dT->set_coefficient(name, a.coefficient(i));
    }
    

    // Attach coefficients from L to L_R_dT
    for (std::size_t i = 0; i < L.num_coefficients(); i++)
    {
      name = L.coefficient_name(i);
      // Don't attach discrete primal solution here (not computed).
      if (name == "__discrete_primal_solution")
        continue;

      // Test whether L_R_dT has coefficient named 'name'
      try {
        L_R_dT->coefficient_number(name);
      } catch (...) {
        std::cout << "Attaching coefficient named: " << name << " to L_R_dT";
        std::cout << " failed! But this might be expected." << std::endl;
        continue;
      }
      L_R_dT->set_coefficient(name, L.coefficient(i));
    }
    
    // Attach subdomains from L to L_R_dT
    L_R_dT->dx = L.cell_domains();
    L_R_dT->ds = L.exterior_facet_domains();
    L_R_dT->dS = L.interior_facet_domains();


    // Initialize (fake) cone and attach to a_R_dT and L_R_dT
    V_b_e.reset(new CoefficientSpace___cell_cone(mesh));
    b_e.reset(new dolfin::Function(V_b_e));
    a_R_dT->set_coefficient("__cell_cone", b_e);
    L_R_dT->set_coefficient("__cell_cone", b_e);

    // Create error indicator form
    V_eta_T.reset(new Form_7::TestSpace(mesh));
    eta_T.reset(new Form_7(V_eta_T));

    // Update error control
    _ec.reset(new dolfin::ErrorControl(a_star, L_star, residual,
                                       a_R_T, L_R_T, a_R_dT, L_R_dT, eta_T,
                                       true));
  }

};


// Class typedefs
typedef Form_lhs BilinearForm;
typedef Form_rhs LinearForm;
typedef Form_goal GoalFunctional;

}

#endif
