# Development Report for April 28, 2017

Sorry for the slow reports lately.  Last week was Dockercon and many people inside Docker and external contributors where in Austin for the week.  It was a long week and we didn't get much work done on the project but it was good meeting everyone IRL and putting a face to the github handle.  Also, thank you to everyone that stayed a day late to attend the summit on Thursday.  You can see the summit notes at the bottom of this report.

## New Projects to the Org.

We are looking to move some of our dependencies used by containerd into the org.  We want to have a simple maintainer model for containerd and any other repository that is added to the org.  Bascially, if you are a maintainer of containerd, you are a maintainer on all of the repos.  We don't want to have separate maintainers for the various parts as we should all share the responsibility for quality and stability for the project as a whole.

We have an issue on github discussing the various projects that we want to add.  If you have any feedback please let us know on the issue below.

[projects!](https://github.com/containerd/containerd/issues/772)
[process](https://github.com/containerd/containerd/pull/779)

## Darwin/BSD Port

Justin has begun work on porting over containerd to Darwin and BSD.  `ctr` compiles and there were a few changes in terminal handling that had to be made but overall its going fairly smooth.  You can ping @justincormack for more information or if you are interested in working on something like a BSD jails port of `runc`.

## Introspection

@AkihiroSuda has been working on introspection RPCs to make sure consumers know the services and features that they are interacting with.  There is still a lot to consider when exposing service versions, containerd versions and functionality; if you have any input you can take a look at the current PR [here](https://github.com/containerd/containerd/pull/776).

## Expanded Registry Support

@dmcgowan has been working on expanding registry support with authentication in [783](https://github.com/containerd/containerd/pull/783).  This expands registry support for gcr.io, Dockerhub, and local registries.


## Task List for week of May 1

So, now that we are all back from Dockercon and not rested at all, whats on the agenda for next week?

* Docker Integration Pass
	- Replace the current v0.2.x branch of containerd in Docker for execution with the 1.0 execution service
* Converge Event Handling
* Move new projects into containerd organization
* New Layer creation for supporting build
* Continue work on metadata service
	- container
	- layer
	- image
	- namespace support

If are you looking for areas to contribute to containerd just take a pass through the issue tracker.  There are issues such as [770](https://github.com/containerd/containerd/issues/770) that could use some help in solving as well as other.  Also feel free to stop by the slack channel for containerd to chat and find ideas on what needs to be developed next.

## containerd Summit Notes

Here are the notes from the containerd summit that was held after Dockercon.  If there are important to you and you would like to start working on a feature, fix, request, please go ahead and open an issue on github.  Just remember, we shouldn't have to have a summit to get things into containerd.  Open issues, disscuss with other members of the community and write the code ;)

* “Since containerd is one of the bottom bricks in the stack, how can we setup automated integration tests for consumers of containerd?”
	- Looking for others to provide compute (testing within Docker, K8s, Microsoft)
	- Would we publish results of integration tests, not likely per PR
	- K8s had a similar problem, solved by pushing builds to buckets and creating dashboards from results pushed back to buckets
	- Need tests for projects containerd is integrated with (Windows, runv), testing containerd connection to shims
* “We'd like to propose an Authorization plugin to containerd that would allow an external component to police events like container start & stop (and have a discussion about the best way to go about it)”
	- Need to look into how it could be implemented with containerd
	- Possible to be done by MITM the GRPC socket
	- Currently seen as out of scope for server, can be done via client (or proxy), we could build a client package to support this so it does not have to be implemented by each integrator.
	- Currently only unix socket allowed which prevents unauthorized access
* “Should containerd provide image filesystem metrics? If yes, what metrics should be included? How to implement that?”
	- Previously discussed, yes, PR to provide this information through the snapshot interface.
	- Figuring out what is being shared, could figure out it from mapping layers to images
* “Support for disk quotas: How? What is the role of containerd? How is it going to be integrated with volume managers that want to be in the same quota group?”
	- Expanding question, “will each snapshot driver have a quota system? What is the granularity, per container, global?”
	- Stephen’s hope is that quota management can be done based on the returned mounts, otherwise need to figure out quota abstraction
	- Could we rely on work being done for volumes with CSI
	- Need to open up issue to discuss project quotas and general snapshot quotas
* “Checkpoint/Restore: how can we support more use cases? One of the big issues here is the large number of options that can be passed to CRIU.”
	- Not currently in Containerd, requires runc update as well
	- Need to figure out a way to pass in options opaquely
	- Needs to be discuss with Michael for what best solution for runc will be
	- Today caller must know runtime since runtime spec is passed opaquely on create to runtime
* “How to support multi-OS docker images, for example, Linux Vs Windows using one graph driver plugin properly?”
	- From looking into implementing linux containers on HyperV
	- Missing options when creating rootfs to specify the snapshot driver
	- Containerd will support running multiple snapshotter
	- Timeline, Docker will first use update runtime after stabilizing
* “Containerd is acting as init system in LinuxKit, is there a plan to support what init systems support”
-	 Containerd was not implemented as an init system, we are not trying to compete with it. A higher level init system could be implemented with it.
* “Will containerd be able to leverage runtime plugins specified within Docker?”
	- Docker would have to orchestrate re-configuring containerd with the new runtime
	- Currently cannot hotswap plugins, runtime and shim are built in
	- Would require defining plugin interface or getting go 1.8 plugins working
	- We could have a plugin which connects to a grpc address
	- Resolved in rocket by first allowing downloading a runtime and running it as privileged
	- Need to open up an issue to discuss this
* “What do we want from orchestrator who are looking at integration?”
	- Feedback is biggest
	- Currently targeting K8s and SwarmKit to keep API grounded
	- Starting PoCs now, we have already made changes based on early feedback
