/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2009 Christian Schallhart <christian@schallhart.net>,
 *                    Michael Tautschnig <tautschnig@forsyte.de>
 *               2008 model.in.tum.de group, FORSYTE group
 *               2006-2007 model.in.tum.de group
 *               2002-2005 Christian Schallhart
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * @file diagnostics/unittest/test_system/test_data_adaptor.hpp
 *
 * @brief [LEVEL: beta] @ref diagnostics::unittest::Test_Data_Adaptor interface
 *
 * $Id: test_data_adaptor.hpp,v 1.11 2005/06/23 09:54:26 esdentem Exp $
 * 
 * @author Christian Schallhart
 *
 * @test Interface Compliance Test-Suite: diagnostics/unittest/test_system/test_data_adaptor.ts.hpp
 */
#ifndef DIAGNOSTICS__UNITTEST__TEST_SYSTEM__TEST_DATA_ADAPTOR_HPP__INCLUDE_GUARD
#define DIAGNOSTICS__UNITTEST__TEST_SYSTEM__TEST_DATA_ADAPTOR_HPP__INCLUDE_GUARD

// used as base class
#include <diagnostics/unittest/test_data.hpp>


DIAGNOSTICS_NAMESPACE_BEGIN;
UNITTEST_NAMESPACE_BEGIN;

// used in the interface by reference
// <diagnostics/unittest/test_system/test_data_source.hpp>
class Test_Data_Source;

/**
 * @class Test_Data_Adaptor diagnostics/unittest/test_system/test_data_adaptor.hpp
 *
 * @brief a Test_Data_Adaptor adapts a @ref Test_Data_Source to @ref
 * Test_Data interface.
 *
 * Different Test_Data_Adaptors correspond to different interactions
 * with the user of the unittest environment. For example, in a batch
 * run, the user might wish a read-only Test_Data interface, but in an
 * interactive run, the user might want to have manual control in case
 * of conflicts (a missing entry, or a mismatching entry). 
 *
 * @nosubgrouping
 */
class Test_Data_Adaptor :
    public Test_Data
{
public:
    /**
     * @throw never
     */
    virtual ~Test_Data_Adaptor();

    ////////////////////////////////////////////////////////////////////////////////
    /**
     * @name Modifiers
     * @{ 
     */
public:
    /** 
     * @brief attaches @a test_data_source to the adaptor -- ownership is NOT changed.
     *
     * @post POST.backend() == @a backend
     *
     * @throw Test_System_Exception if test_data_source==NULL
     */
    virtual void attach(Test_Data_Source * const backend) =0;
    // @}

    ////////////////////////////////////////////////////////////////////////////////
    /**
     * @name Accessors
     * @{ 
     */
public:
    /**
     * @brief returns the current backend.
     *
     * @throw never
     */
    virtual Test_Data_Source* backend() const=0;
    // @}
};

UNITTEST_NAMESPACE_END;
DIAGNOSTICS_NAMESPACE_END;


#endif
// vim:ts=4:sw=4
