;;; dh-elpa.el --- package.el style packages for Debian  -*- lexical-binding:t -*-

;; Copyright (C) 2015 David Bremner
;; Portions Copyright 2007-2015 The Free Software Foundation

;; Author: David Bremner <bremner@debian.org>
;; Created: 11 July 2015
;; Version: 0.0.2
;; Keywords: tools
;; Package-Requires: ((tabulated-list "1.0"))

;; This file is NOT part of GNU Emacs.

;; dh-elpa  is free software: you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or
;; (at your option) any later version.

;; dh-elpa is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with dh-elpa.  If not, see <http://www.gnu.org/licenses/>.

(require 'package)

;; Originally package-unpack from package.el in Emacs 24.5
(defun dhelpa-unpack (pkg-desc destdir)
  "Install the contents of the current buffer as a package."
  (let* ((name (package-desc-name pkg-desc))
         (dirname (package-desc-full-name pkg-desc))
	 (pkg-dir (expand-file-name dirname destdir))
	 (backup-inhibited t))
    (make-directory pkg-dir t)
    (pcase (package-desc-kind pkg-desc)
      (`tar
       (let ((default-directory (file-name-as-directory destdir)))
	 (package-untar-buffer dirname)))
      (`single
       (let ((el-file (expand-file-name (format "%s.el" name) pkg-dir)))
         (package--write-file-no-coding el-file)))
      (kind (error "Unknown package kind: %S" kind)))
    (package--make-autoloads-and-stuff pkg-desc pkg-dir)
    pkg-dir))

;;;###autoload
(defun dhelpa-install-from-buffer (destdir)
  "Install a package from the current buffer.
The current buffer is assumed to be a single .el or .tar file that follows the
packaging guidelines; see info node `(elisp)Packaging'."
  (interactive "D")
  (let ((pkg-desc (if (derived-mode-p 'tar-mode)
                      (package-tar-file-info)
                    (package-buffer-info))))
    (dhelpa-unpack pkg-desc destdir)
    pkg-desc))

;;;###autoload
(defun dhelpa-batch-install-file ()
  "Install second command line argument (an emacs lisp file or
tar file) into second command line argument (a directory)"
  (let ((dest (car command-line-args-left))
	(el-file (cadr command-line-args-left)))
    (dhelpa-install-file dest el-file)))

;;;###autoload
(defun dhelpa-install-file (dest el-file)
  "Install second argument (an emacs lisp file or tar file) into
first command line argument (a directory)"
  (with-temp-buffer
    (insert-file-contents-literally el-file)
    (when (string-match "\\.tar\\'" el-file) (tar-mode))
    (dhelpa-install-from-buffer (expand-file-name dest))))

;;; dh-elpa.el ends here
