% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBResult.R
\name{dbFetch}
\alias{dbFetch}
\alias{fetch}
\title{Fetch records from a previously executed query}
\usage{
dbFetch(res, n = -1, ...)

fetch(res, n = -1, ...)
}
\arguments{
\item{res}{An object inheriting from \code{\linkS4class{DBIResult}}.}

\item{n}{maximum number of records to retrieve per fetch. Use \code{n = -1}
to retrieve all pending records.  Some implementations may recognize other
special values.}

\item{...}{Other arguments passed on to methods.}
}
\value{
a data.frame with as many rows as records were fetched and as many
  columns as fields in the result set.
}
\description{
Fetch the next \code{n} elements (rows) from the result set and return them
as a data.frame.
}
\details{
\code{fetch} is provided for compatibility with older DBI clients - for all
new code you are strongly encouraged to use \code{dbFetch}. The default
method for \code{dbFetch} calls \code{fetch} so that it is compatible with
existing code. Implementors are free to provide methods for \code{dbFetch}
only.
}
\examples{
con <- dbConnect(RSQLite::SQLite(), ":memory:")

dbWriteTable(con, "mtcars", mtcars)

# Fetch all results
rs <- dbSendQuery(con, "SELECT * FROM mtcars WHERE cyl = 4")
dbFetch(rs)
dbClearResult(rs)

# Fetch in chunks
rs <- dbSendQuery(con, "SELECT * FROM mtcars")
while (!dbHasCompleted(rs)) {
  chunk <- fetch(rs, 10)
  print(nrow(chunk))
}

dbClearResult(rs)
dbDisconnect(con)
}
\seealso{
close the result set with \code{\link{dbClearResult}} as soon as you
  finish retrieving the records you want.

Other DBIResult generics: \code{\link{DBIResult-class}},
  \code{\link{SQL}}, \code{\link{dbBind}},
  \code{\link{dbClearResult}}, \code{\link{dbColumnInfo}},
  \code{\link{dbGetInfo}}, \code{\link{dbGetRowCount}},
  \code{\link{dbGetRowsAffected}},
  \code{\link{dbGetStatement}},
  \code{\link{dbHasCompleted}}, \code{\link{dbIsValid}}
}

