/*
** (c) 1996-2000 The Regents of the University of California (through
** E.O. Lawrence Berkeley National Laboratory), subject to approval by
** the U.S. Department of Energy.  Your use of this software is under
** license -- the license agreement is attached and included in the
** directory as license.txt or you may contact Berkeley Lab's Technology
** Transfer Department at TTD@lbl.gov.  NOTICE OF U.S. GOVERNMENT RIGHTS.
** The Software was developed under funding from the U.S. Government
** which consequently retains certain rights as follows: the
** U.S. Government has been granted for itself and others acting on its
** behalf a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, and perform publicly
** and display publicly.  Beginning five (5) years after the date
** permission to assert copyright is obtained from the U.S. Department of
** Energy, and subject to any subsequent five (5) year renewals, the
** U.S. Government is granted for itself and others acting on its behalf
** a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, distribute copies to
** the public, perform publicly and display publicly, and to permit
** others to do so.
*/


#ifndef _BOUNDCOND_H_
#define _BOUNDCOND_H_

//
// $Id: BoundCond.H,v 1.8 2000/10/02 20:51:15 lijewski Exp $
//

#include <BLassert.H>

//@Man:
/*@Memo:
  Maintain an identifier for boundary condition types.
*/        
/*@Doc:
        This is a placeholder for more extensive boundary condition
        implementations, which might include stencils, etc.  Presently,
        boundary conditions are specified via an integer identifier.
        This class maintains that integer.
*/

class BoundCond
{
public:
    //
    //@ManDoc: Initializes boundary condition type to default.
    //
    BoundCond () : bctype(-1) {}
    //
    //@ManDoc: Initializes boundary condition type to specified value.
    //
    BoundCond (int _bctype) : bctype(_bctype) {}
    //
    //@ManDoc: Copy constructor.
    //
    BoundCond (const BoundCond& rhs) : bctype(rhs.bctype) {}
    //
    //@ManDoc: Copy assignment operator.
    //
    BoundCond& operator= (const BoundCond& rhs)
    {
        if (!(this == &rhs))
        {
            bctype = rhs.bctype;
        }
        return *this;
    }
    //
    //@ManDoc: Return index of boundary condition type.
    //
    operator int () const
    {
        BL_ASSERT(bctype != -1);
        return bctype;
    }
    //
    //@ManDoc: Set index of boundary condition type.
    //
    BoundCond& operator= (const int _bctype)
    {
        bctype = _bctype;
        return *this;
    }
private:
    //
    // Index of boundary condition type.
    //
    int bctype;
};

#endif /*_BOUNDCOND_H_*/
