/*
 * Decompiled with CFR 0.152.
 */
package yuku.alkitabconverter.yes_common;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Scanner;
import yuku.alkitab.model.FootnoteEntry;
import yuku.alkitab.model.XrefEntry;
import yuku.alkitab.yes2.Yes2Writer;
import yuku.alkitab.yes2.compress.SnappyOutputStream;
import yuku.alkitab.yes2.io.MemoryRandomOutputStream;
import yuku.alkitab.yes2.io.RandomAccessFileRandomOutputStream;
import yuku.alkitab.yes2.io.RandomOutputStream;
import yuku.alkitab.yes2.model.PericopeData;
import yuku.alkitab.yes2.model.VerseBytes;
import yuku.alkitab.yes2.model.Yes2Book;
import yuku.alkitab.yes2.section.BooksInfoSection;
import yuku.alkitab.yes2.section.PericopesSection;
import yuku.alkitab.yes2.section.VersionInfoSection;
import yuku.alkitab.yes2.section.base.SectionContent;
import yuku.alkitabconverter.util.FootnoteDb;
import yuku.alkitabconverter.util.TextDb;
import yuku.alkitabconverter.util.XrefDb;
import yuku.bintex.BintexWriter;
import yuku.bintex.ValueMap;

public class Yes2Common {
    public static final String TAG = Yes2Common.class.getSimpleName();

    private static BooksInfoSection getBooksInfoSection(VersionInfo versionInfo, TextDb textDb) throws IOException {
        ArrayList<Yes2Book> yes2books = new ArrayList<Yes2Book>();
        int offsetTotal = 0;
        int offsetPassed = 0;
        for (int bookId : textDb.getBookIds()) {
            Yes2Book b = new Yes2Book();
            b.bookId = bookId;
            b.chapter_count = textDb.getChapterCountForBook(bookId);
            b.chapter_offsets = new int[b.chapter_count + 1];
            b.offset = offsetTotal;
            b.shortName = versionInfo.getBookShortName(bookId);
            b.abbreviation = versionInfo.getBookAbbreviation(bookId);
            b.verse_counts = new int[b.chapter_count];
            b.chapter_offsets[0] = 0;
            for (int chapter_0 = 0; chapter_0 < b.chapter_count; ++chapter_0) {
                b.verse_counts[chapter_0] = textDb.getVerseCountForBookChapter(bookId, chapter_0 + 1);
                for (int verse_0 = 0; verse_0 < b.verse_counts[chapter_0]; ++verse_0) {
                    String verseText = textDb.getVerseText(bookId, chapter_0 + 1, verse_0 + 1);
                    offsetPassed += VerseBytes.bytesForAVerse(verseText).length;
                }
                b.chapter_offsets[chapter_0 + 1] = offsetPassed;
            }
            yes2books.add(b);
            offsetTotal += offsetPassed;
            offsetPassed = 0;
        }
        BooksInfoSection res = new BooksInfoSection();
        res.yes2Books = yes2books;
        return res;
    }

    private static VersionInfoSection getVersionInfoSection(VersionInfo versionInfo, TextDb textDb, boolean hasPericopes) {
        VersionInfoSection res = new VersionInfoSection();
        res.book_count = textDb.getBookCount();
        res.description = versionInfo.description;
        res.hasPericopes = hasPericopes ? 1 : 0;
        res.locale = versionInfo.locale;
        res.longName = versionInfo.longName;
        res.shortName = versionInfo.shortName;
        res.buildTime = (int)(System.currentTimeMillis() / 1000L);
        res.textEncoding = 2;
        return res;
    }

    public static void createYesFile(File outputFile, VersionInfo versionInfo, TextDb textDb, PericopeData pericopeData, boolean compressed) throws IOException {
        Yes2Common.createYesFile(outputFile, versionInfo, textDb, pericopeData, compressed, null, null);
    }

    public static void createYesFile(File outputFile, VersionInfo versionInfo, TextDb textDb, PericopeData pericopeData, boolean compressed, LinkedHashMap<Integer, XrefEntry> xrefEntries, LinkedHashMap<Integer, FootnoteEntry> footnoteEntries) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(outputFile, "rw");
        raf.setLength(0L);
        RandomAccessFileRandomOutputStream output = new RandomAccessFileRandomOutputStream(raf);
        Yes2Common.createYesFile(output, versionInfo, textDb, pericopeData, compressed, xrefEntries, footnoteEntries);
        ((OutputStream)output).close();
    }

    public static void createYesFile(RandomOutputStream ros, VersionInfo versionInfo, TextDb textDb, PericopeData pericopeData, boolean compressed, LinkedHashMap<Integer, XrefEntry> xrefEntries, LinkedHashMap<Integer, FootnoteEntry> footnoteEntries) throws IOException {
        VersionInfoSection versionInfoSection = Yes2Common.getVersionInfoSection(versionInfo, textDb, pericopeData != null);
        BooksInfoSection booksInfoSection = Yes2Common.getBooksInfoSection(versionInfo, textDb);
        Yes2Writer yesWriter = new Yes2Writer();
        yesWriter.sections.add(versionInfoSection);
        yesWriter.sections.add(booksInfoSection);
        if (pericopeData != null) {
            yesWriter.sections.add(new CompressiblePericopesSection(pericopeData, compressed));
        }
        yesWriter.sections.add(new CompressibleLazyText(textDb, compressed));
        if (xrefEntries != null) {
            yesWriter.sections.add(new CompressibleXrefsSection(xrefEntries, compressed));
        }
        if (footnoteEntries != null) {
            yesWriter.sections.add(new CompressibleFootnotesSection(footnoteEntries, compressed));
        }
        yesWriter.writeToFile(ros);
    }

    static class CompressibleFootnotesSection
    extends SectionContent
    implements SectionContent.Writer {
        final CompressionInfo compressionInfo;

        public CompressibleFootnotesSection(LinkedHashMap<Integer, FootnoteEntry> footnoteEntries, boolean compressed) throws IOException {
            super("footnotes");
            this.compressionInfo = new CompressionInfo(compressed);
            BintexWriter bw = new BintexWriter(this.compressionInfo.getOutputStream());
            FootnoteDb.writeFootnoteEntriesTo(footnoteEntries, bw);
            this.compressionInfo.finalizeOutputStream();
        }

        @Override
        public ValueMap getAttributes() {
            return this.compressionInfo.getSectionAttributes();
        }

        @Override
        public void write(RandomOutputStream output) throws IOException {
            this.compressionInfo.writeOutputBufferTo(output);
        }
    }

    static class CompressibleXrefsSection
    extends SectionContent
    implements SectionContent.Writer {
        final CompressionInfo compressionInfo;

        public CompressibleXrefsSection(LinkedHashMap<Integer, XrefEntry> xrefEntries, boolean compressed) throws IOException {
            super("xrefs");
            this.compressionInfo = new CompressionInfo(compressed);
            BintexWriter bw = new BintexWriter(this.compressionInfo.getOutputStream());
            XrefDb.writeXrefEntriesTo(xrefEntries, bw);
            this.compressionInfo.finalizeOutputStream();
        }

        @Override
        public ValueMap getAttributes() {
            return this.compressionInfo.getSectionAttributes();
        }

        @Override
        public void write(RandomOutputStream output) throws IOException {
            this.compressionInfo.writeOutputBufferTo(output);
        }
    }

    static class CompressiblePericopesSection
    extends PericopesSection
    implements SectionContent.Writer {
        final CompressionInfo compressionInfo;

        public CompressiblePericopesSection(PericopeData pericopeData, boolean compressed) {
            super(pericopeData);
            this.compressionInfo = new CompressionInfo(compressed);
            try {
                MemoryRandomOutputStream mem = new MemoryRandomOutputStream();
                super.write(mem);
                OutputStream os = this.compressionInfo.getOutputStream();
                os.write(mem.getBuffer(), mem.getBufferOffset(), mem.getBufferLength());
                this.compressionInfo.finalizeOutputStream();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public ValueMap getAttributes() {
            return this.compressionInfo.getSectionAttributes();
        }

        @Override
        public void write(RandomOutputStream output) throws IOException {
            this.compressionInfo.writeOutputBufferTo(output);
        }
    }

    static class CompressibleLazyText
    extends SectionContent
    implements SectionContent.Writer {
        final CompressionInfo compressionInfo;

        public CompressibleLazyText(TextDb textDb, boolean compressed) throws IOException {
            super("text");
            this.compressionInfo = new CompressionInfo(compressed);
            final BintexWriter bw = new BintexWriter(this.compressionInfo.getOutputStream());
            textDb.processEach(new TextDb.TextProcessor(){

                @Override
                public void process(int ari, TextDb.VerseState verseState) {
                    byte[] bytes = VerseBytes.bytesForAVerse(verseState.text);
                    try {
                        bw.writeRaw(bytes);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            this.compressionInfo.finalizeOutputStream();
        }

        @Override
        public ValueMap getAttributes() {
            return this.compressionInfo.getSectionAttributes();
        }

        @Override
        public void write(RandomOutputStream output) throws IOException {
            this.compressionInfo.writeOutputBufferTo(output);
        }
    }

    static class CompressionInfo {
        final boolean compressed;
        final int COMPRESS_BLOCK_SIZE = 32768;
        ByteArrayOutputStream outputBuffer;
        SnappyOutputStream snappyOutputStream;
        private int[] compressed_block_sizes;

        CompressionInfo(boolean compressed) {
            this.compressed = compressed;
        }

        OutputStream getOutputStream() {
            this.outputBuffer = new ByteArrayOutputStream();
            if (this.compressed) {
                this.snappyOutputStream = new SnappyOutputStream(this.outputBuffer, 32768);
                return this.snappyOutputStream;
            }
            return this.outputBuffer;
        }

        public ValueMap getSectionAttributes() {
            ValueMap res = new ValueMap();
            if (this.compressed) {
                assert (this.compressed_block_sizes != null);
                ValueMap compressionInfo = new ValueMap();
                compressionInfo.put("block_size", (Object)32768);
                compressionInfo.put("compressed_block_sizes", (Object)this.compressed_block_sizes);
                res.put("compression.name", (Object)"snappy-blocks");
                res.put("compression.version", (Object)1);
                res.put("compression.info", (Object)compressionInfo);
            }
            return res;
        }

        public void finalizeOutputStream() throws IOException {
            if (this.snappyOutputStream != null) {
                this.snappyOutputStream.flush();
                this.compressed_block_sizes = this.snappyOutputStream.getCompressedBlockSizes();
            }
        }

        public void writeOutputBufferTo(RandomOutputStream output) throws IOException {
            this.outputBuffer.writeTo(output);
        }
    }

    public static class VersionInfo {
        public String locale;
        public String shortName;
        public String longName;
        public String description;
        private List<String> bookNames;
        private List<String> bookAbbreviations;

        public String getBookShortName(int bookId) {
            return this.bookNames.get(bookId);
        }

        public String getBookAbbreviation(int bookId) {
            if (this.bookAbbreviations == null) {
                return null;
            }
            return this.bookAbbreviations.get(bookId);
        }

        public void setBookNamesAndAbbreviations(List<String> bookNames, List<String> bookAbbreviations) {
            this.bookNames = bookNames;
            this.bookAbbreviations = bookAbbreviations;
        }

        public void setBookNamesFromFile(String inputBookNames) throws IOException {
            ArrayList<String> bookNames = new ArrayList<String>();
            Scanner sc = new Scanner(new File(inputBookNames), "utf-8");
            int c = 0;
            while (sc.hasNextLine()) {
                String line = sc.nextLine().trim();
                bookNames.add(line);
                ++c;
            }
            this.bookNames = bookNames;
        }
    }
}

