# -*- coding: utf-8 -*-
# Balazar in the Rancid Skull Dungeon
# Copyright (C) 2008 Jean-Baptiste LAMY
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import os, sys, cPickle, time
import cerealizer
import soya
import PIL, PIL.Image

extra_code   = u""
animations   = []
scale_factor = 0.334
filename     = u""
step         = 1.0
center       = 0
fade_dither  = 0
wait_round   = 0

i = 1
while i < len(sys.argv):
  if   sys.argv[i] == "--path"        : i += 1; soya.path.append(sys.argv[i])
  elif sys.argv[i] == "--animation"   : i += 2; animations.append((sys.argv[i - 1], int(sys.argv[i])))
  elif sys.argv[i] == "--scale-factor": i += 1; scale_factor = float(sys.argv[i])
  elif sys.argv[i] == "--filename"    : i += 1; filename = sys.argv[i]
  elif sys.argv[i] == "--extra-code"  : i += 1; extra_code = sys.argv[i]
  elif sys.argv[i] == "--step"        : i += 1; step = float(sys.argv[i])
  elif sys.argv[i] == "--center"      : center = 1
  elif sys.argv[i] == "--fade-dither" : fade_dither = 1
  i += 1
  
soya.set_file_format(cerealizer, [cerealizer, cPickle])
#soya.init(width = 640, height = 480)
soya.init(width = 1024, height = 756)
soya.set_quality(2)

SHADER_DEFAULT_MATERIAL = soya.Material.get("shader")
SHADER_DEFAULT_MATERIAL.filename = "__SHADER_DEFAULT_MATERIAL__"
soya._soya._set_shader_default_material(SHADER_DEFAULT_MATERIAL)
  

scene = soya.World()
scene.atmosphere = soya.Atmosphere()
scene.atmosphere.ambient = (0.3, 0.3, 0.3, 1.0)

character = soya.World(scene)

camera = soya.Camera(scene)
#camera.set_xyz(0.0, 3.5, 2.5)
camera.set_xyz(0.0, 5.95, 4.25)
camera.look_at(soya.Point(character, 0.0, 1.0, 0.0))

light = soya.Light(scene)
light.set_xyz(-2.0, 4.0, 1.0)

main_loop = soya.MainLoop(scene)
soya.set_root_widget(camera)
exec extra_code


x0, y0 = camera.coord3d_to_2d(soya.Point(scene, 0.0, 0.0, 0.0))
x0 = int(round(x0 * scale_factor))
y0 = int(round(y0 * scale_factor))


if wait_round:
  character.animate_blend_cycle("attente")
  while wait_round:
    wait_round -= 1
    scene.begin_round()
    scene.advance_time(1.0)
    scene.end_round()
    soya.render()
  character.animate_reset()
  character.animate_clear_cycle("attente")
  

for animation, nb in animations:
  scene.begin_round()
  if isinstance(character.model, soya.AnimatedModel):
    character.animate_reset()
    character.animate_execute_action(animation, fade_in = 0.0, fade_out = 0.0)
  scene.advance_time(0.0)
  
  info_file = open("%s_%s.info" % (filename, animation), "w")
  
  for i in range(nb):
    scene.end_round()
    
    scene.atmosphere.bg_color = (0.0, 0.0, 0.0, 0.0)
    soya.render()
    image_black = soya.screenshot()
    
    scene.atmosphere.bg_color = (1.0, 0.0, 0.0, 0.0)
    soya.render()
    image_red = soya.screenshot()
    
    width, height = image_black.size
    #image_black.save("/tmp/image_black.png")
    #image_red  .save("/tmp/image_red.png")
    image_black = image_black.resize((int(width * scale_factor), int(height * scale_factor)), PIL.Image.BILINEAR)
    image_red   = image_red  .resize((int(width * scale_factor), int(height * scale_factor)), PIL.Image.BILINEAR)
    
    width, height = image_black.size
    mask = PIL.Image.new("1", (width, height))
    for x in range(width):
      for y in range(height):
        p = (x, y)
        if (image_red.getpixel(p) == (255, 0, 0)) and (image_black.getpixel(p) == (0, 0, 0)):
          mask.putpixel(p, 0)
        #elif (image_red.getpixel(p) != image_black.getpixel(p)):
        #  r = image_red  .getpixel(p)
        #  b = image_black.getpixel(p)
        #  d = (r[0] - b[0]) ** 2 + (r[1] - b[1]) ** 2 + (r[2] - b[2]) ** 2
        #  if   d < 12288:
        #    if (x % 2 == 0) and ((x + y) % 2 == 0): mask.putpixel((x, y), 0)
        #    else:                                   mask.putpixel((x, y), 1)
        #  if   d < 49152:
        #    if (x + y) % 2 == 0: mask.putpixel((x, y), 0)
        #    else:                mask.putpixel((x, y), 1)
        #  else:
        #    if (x % 2 == 0) or ((x + y) % 2 == 0): mask.putpixel((x, y), 0)
        #    else:                                  mask.putpixel((x, y), 1)
        else:
          mask.putpixel(p, 1)
    
    if fade_dither:
      if    i == nb - 4:
        for x in range(width):
          for y in range(height):
            if (x % 2 == 0) and ((x + y) % 2 == 0): mask.putpixel((x, y), 0)
            
      elif (i == nb - 2) or (i == nb - 3):
        for x in range(width):
          for y in range(height):
            if (x + y) % 2 == 0: mask.putpixel((x, y), 0)
              
      elif  i == nb - 1:
        for x in range(width):
          for y in range(height):
            if (x % 2 == 0) or ((x + y) % 2 == 0): mask.putpixel((x, y), 0)
        
      
    image_black.putalpha(mask)
    box = image_black.getbbox()
    if center: info_file.write("%s %s %s %s\n" % (-(box[2] - box[0]) // 2, -(box[3] - box[1]) // 2, box[2] - box[0], box[3] - box[1]))
    else:      info_file.write("%s %s %s %s\n" % (box[0] - x0, box[1] - y0, box[2] - box[0], box[3] - box[1]))
    
    image_black = image_black.crop(box)
    image_black.save("%s_%s_%s.png" % (filename, animation, i))
    
    scene.begin_round()
    scene.advance_time(step)


