<?php
/**
 * Copyright 2010-2013 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in compliance with the License.
 * A copy of the License is located at
 *
 * http://aws.amazon.com/apache2.0
 *
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */

namespace Aws\StorageGateway\Enum;

use Aws\Common\Enum;

/**
 * Contains enumerable GatewayTimezone values
 */
class GatewayTimezone extends Enum
{
    const GMT_MINUS_1200 = 'GMT-12:00';
    const GMT_MINUS_1100 = 'GMT-11:00';
    const GMT_MINUS_1000 = 'GMT-10:00';
    const GMT_MINUS_900 = 'GMT-9:00';
    const GMT_MINUS_800 = 'GMT-8:00';
    const GMT_MINUS_700 = 'GMT-7:00';
    const GMT_MINUS_600 = 'GMT-6:00';
    const GMT_MINUS_500 = 'GMT-5:00';
    const GMT_MINUS_400 = 'GMT-4:00';
    const GMT_MINUS_330 = 'GMT-3:30';
    const GMT_MINUS_300 = 'GMT-3:00';
    const GMT_MINUS_200 = 'GMT-2:00';
    const GMT_MINUS_100 = 'GMT-1:00';
    const GMT = 'GMT';
    const GMT_PLUS_100 = 'GMT+1:00';
    const GMT_PLUS_200 = 'GMT+2:00';
    const GMT_PLUS_300 = 'GMT+3:00';
    const GMT_PLUS_330 = 'GMT+3:30';
    const GMT_PLUS_400 = 'GMT+4:00';
    const GMT_PLUS_430 = 'GMT+4:30';
    const GMT_PLUS_500 = 'GMT+5:00';
    const GMT_PLUS_530 = 'GMT+5:30';
    const GMT_PLUS_545 = 'GMT+5:45';
    const GMT_PLUS_600 = 'GMT+6:00';
    const GMT_PLUS_700 = 'GMT+7:00';
    const GMT_PLUS_800 = 'GMT+8:00';
    const GMT_PLUS_900 = 'GMT+9:00';
    const GMT_PLUS_930 = 'GMT+9:30';
    const GMT_PLUS_1000 = 'GMT+10:00';
    const GMT_PLUS_1100 = 'GMT+11:00';
    const GMT_PLUS_1200 = 'GMT+12:00';
}
