/*
Copyright (C) 2000-2001 Jos Roberto B. de A. Monteiro <jrm@autsens.com>
                        and Pedro Zorzenon Neto <pzn@autsens.com>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>

#include "avrconf.h"
#include "avrprog.h"

int avrprog_conf_port_allowed(unsigned int parallel_port) {
  FILE * fin;
  char s[STRSIZE], s2[STRSIZE], * ss, * sn, * sa;
  unsigned int parport = 0;

  if (!parallel_port)
    return 0;
  fin = fopen(AVRPROG_CONFIG_FILE_NAME, "r");
  if (!fin) {
    perror(AVRPROG_CONFIG_FILE_NAME);
    abort();
  }

  ss = fgets(s, STRSIZE, fin);
  while (ss) {
    if (strlen(s) > 2 && s[0]!='#') {
      int n;
      n = strcspn(s, "#");
      strncpy(s2, s, n);
      s2[n] = '\0';
      /*      printf("s2 = (%d) %s\n", n, s2); */
      sa = s2;
      sn = strsep(&sa, " \t\n");
      if (sn) {
	if (strcmp(sn, PARPORT_VALID) == 0) {
	  sn = strsep(&sa, " \t\n");
	  while (sn) {
	    errno =0;
	    parport = strtoul(sn, NULL, 0);
	    if (errno)
	      parport = 0;
	    /* 	    printf("Parport valid = 0x%x\n", parport); */
	    if (parallel_port == parport)
	      return 1;
	  sn = strsep(&sa, " \t\n");
	  }
	}
      }
    }
    ss = fgets(s, STRSIZE, fin);
  }
  fclose(fin);

  return 0;
}

unsigned int avrprog_conf_port_default() {
  FILE * fin;
  char s[STRSIZE], * ss, * sn, * sa;
  unsigned int parport = 0;

  fin = fopen(AVRPROG_CONFIG_FILE_NAME, "r");
  if (!fin) {
    perror(AVRPROG_CONFIG_FILE_NAME);
    abort();
  }

  ss = fgets(s, STRSIZE, fin);
  while (ss) {
    if (strlen(s) > 2 && s[0]!='#') {
      sa = ss;
      sn = strsep(&sa, " \t\n");
      if (sn) {
	if (strcmp(sn, PARPORT_DEFAULT) == 0) {
	  sn = strsep(&sa, " \t\n");
	  if (sn) {
	    errno =0;
	    parport = strtoul(sn, NULL, 0);
	    if (errno)
	      parport = 0;
	  }
	}
      }
    }
    ss = fgets(s, STRSIZE, fin);
  }
  fclose(fin);
  /*  printf("Parport = 0x%x\n", parport); */
  return parport;
}
