/* simple-launcher.c generated by valac 0.10.4, the Vala compiler
 * generated from simple-launcher.vala, do not modify */

/*
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA.
 *
 * Author : Michal Hruby <michal.mhr@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <libawn/libawn.h>
#include <gtk/gtk.h>
#include <libdesktop-agnostic/config.h>
#include <stdlib.h>
#include <string.h>
#include <config.h>
#include <gdk/gdk.h>
#include <libdesktop-agnostic/vfs.h>
#include <libdesktop-agnostic/fdo.h>
#include <libdesktop-agnostic/ui.h>


#define TYPE_SIMPLE_LAUNCHER (simple_launcher_get_type ())
#define SIMPLE_LAUNCHER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SIMPLE_LAUNCHER, SimpleLauncher))
#define SIMPLE_LAUNCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SIMPLE_LAUNCHER, SimpleLauncherClass))
#define IS_SIMPLE_LAUNCHER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SIMPLE_LAUNCHER))
#define IS_SIMPLE_LAUNCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SIMPLE_LAUNCHER))
#define SIMPLE_LAUNCHER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SIMPLE_LAUNCHER, SimpleLauncherClass))

typedef struct _SimpleLauncher SimpleLauncher;
typedef struct _SimpleLauncherClass SimpleLauncherClass;
typedef struct _SimpleLauncherPrivate SimpleLauncherPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_value_array_free0(var) ((var == NULL) ? NULL : (var = (g_value_array_free (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _gdk_event_free0(var) ((var == NULL) ? NULL : (var = (gdk_event_free (var), NULL)))
#define __g_slist_free_g_object_unref0(var) ((var == NULL) ? NULL : (var = (_g_slist_free_g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _SimpleLauncher {
	AwnApplet parent_instance;
	SimpleLauncherPrivate * priv;
};

struct _SimpleLauncherClass {
	AwnAppletClass parent_class;
};

struct _SimpleLauncherPrivate {
	AwnIconBox* icon_box;
	AwnThemedIcon* add_icon;
	GtkMenu* menu;
	GtkMenu* add_icon_menu;
	GtkMenuItem* remove_menu_item;
	GtkMenuItem* edit_menu_item;
	DesktopAgnosticConfigClient* client;
	char* config_dir;
	GPtrArray* launchers;
	guint timer_id;
	GValueArray* _launcher_list;
};


static gpointer simple_launcher_parent_class = NULL;

GType simple_launcher_get_type (void) G_GNUC_CONST;
#define SIMPLE_LAUNCHER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SIMPLE_LAUNCHER, SimpleLauncherPrivate))
enum  {
	SIMPLE_LAUNCHER_DUMMY_PROPERTY,
	SIMPLE_LAUNCHER_LAUNCHER_LIST
};
#define SIMPLE_LAUNCHER_DESKTOP_ENTRY "desktop-entry-object"
SimpleLauncher* simple_launcher_new (const char* canonical_name, const char* uid, gint panel_id);
SimpleLauncher* simple_launcher_construct (GType object_type, const char* canonical_name, const char* uid, gint panel_id);
static void simple_launcher_init_widgets (SimpleLauncher* self);
static void simple_launcher_launchers_changed (SimpleLauncher* self);
static void _simple_launcher_launchers_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void simple_launcher_create_new_launcher (SimpleLauncher* self);
static void _simple_launcher_create_new_launcher_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void simple_launcher_edit_clicked (SimpleLauncher* self);
static void _simple_launcher_edit_clicked_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void simple_launcher_remove_clicked (SimpleLauncher* self);
static void _simple_launcher_remove_clicked_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void simple_launcher_add_folders (SimpleLauncher* self);
static void _simple_launcher_add_folders_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void simple_launcher_uri_received (SimpleLauncher* self, GdkDragContext* context, gint x, gint y, GtkSelectionData* data, guint info, guint time_);
static void _simple_launcher_uri_received_gtk_widget_drag_data_received (GtkWidget* _sender, GdkDragContext* context, gint x, gint y, GtkSelectionData* selection_data, guint info, guint time_, gpointer self);
static gboolean _lambda1_ (SimpleLauncher* self);
static gboolean __lambda1__gtk_widget_drag_motion (GtkWidget* _sender, GdkDragContext* context, gint x, gint y, guint time_, gpointer self);
static void simple_launcher_on_add_icon_clicked (SimpleLauncher* self);
static void _simple_launcher_on_add_icon_clicked_awn_icon_clicked (AwnIcon* _sender, gpointer self);
static void _simple_launcher_on_add_icon_clicked_awn_icon_context_menu_popup (AwnIcon* _sender, GdkEventButton* event, gpointer self);
static void simple_launcher_on_size_changed (SimpleLauncher* self);
static void _simple_launcher_on_size_changed_awn_applet_size_changed (AwnApplet* _sender, gint size, gpointer self);
static gboolean _vala_string_array_contains (char** stack, int stack_length, char* needle);
static void _vala_array_add1 (char*** array, int* length, int* size, char* value);
static void simple_launcher_process_uri (SimpleLauncher* self, DesktopAgnosticVFSFile* file);
static void _g_slist_free_g_object_unref (GSList* self);
static char* simple_launcher_pick_icon_name (SimpleLauncher* self, char** icon_names, int icon_names_length1);
static DesktopAgnosticVFSFile* simple_launcher_get_new_desktop_file (SimpleLauncher* self);
static AwnThemedIcon* simple_launcher_create_launcher (SimpleLauncher* self, const char* path);
static void _vala_array_add2 (gint** array, int* length, int* size, gint value);
static void simple_launcher_remove_launcher (SimpleLauncher* self, AwnThemedIcon* launcher, gboolean delete_desktop_file);
static void simple_launcher_on_launcher_clicked (SimpleLauncher* self, AwnIcon* launcher);
static void _simple_launcher_on_launcher_clicked_awn_icon_clicked (AwnIcon* _sender, gpointer self);
static void simple_launcher_on_launcher_ctx_menu (SimpleLauncher* self, AwnIcon* launcher, GdkEventButton* event);
static void _simple_launcher_on_launcher_ctx_menu_awn_icon_context_menu_popup (AwnIcon* _sender, GdkEventButton* event, gpointer self);
static gboolean simple_launcher_on_launcher_drag_motion (SimpleLauncher* self);
static gboolean _simple_launcher_on_launcher_drag_motion_gtk_widget_drag_motion (GtkWidget* _sender, GdkDragContext* context, gint x, gint y, guint time_, gpointer self);
static gboolean _lambda0_ (SimpleLauncher* self);
static gboolean __lambda0__gsource_func (gpointer self);
GValueArray* simple_launcher_get_launcher_list (SimpleLauncher* self);
void simple_launcher_set_launcher_list (SimpleLauncher* self, GValueArray* value);
static GObject * simple_launcher_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void simple_launcher_finalize (GObject* obj);
static void simple_launcher_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void simple_launcher_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
AwnApplet* awn_applet_factory_initp (const char* canonical_name, const char* uid, gint panel_id);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static int _vala_strcmp0 (const char * str1, const char * str2);

static const GtkTargetEntry SIMPLE_LAUNCHER_targets[2] = {{"text/uri-list", (guint) 0, (guint) 0}, {"text/plain", (guint) 0, (guint) 0}};


static void _simple_launcher_launchers_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	simple_launcher_launchers_changed (self);
}


SimpleLauncher* simple_launcher_construct (GType object_type, const char* canonical_name, const char* uid, gint panel_id) {
	SimpleLauncher * self = NULL;
	g_return_val_if_fail (canonical_name != NULL, NULL);
	g_return_val_if_fail (uid != NULL, NULL);
	self = (SimpleLauncher*) g_object_new (object_type, "canonical-name", canonical_name, "uid", uid, "panel-id", panel_id, NULL);
	simple_launcher_init_widgets (self);
	g_signal_connect_object ((GObject*) self, "notify::launcher-list", (GCallback) _simple_launcher_launchers_changed_g_object_notify, self, 0);
	simple_launcher_launchers_changed (self);
	return self;
}


SimpleLauncher* simple_launcher_new (const char* canonical_name, const char* uid, gint panel_id) {
	return simple_launcher_construct (TYPE_SIMPLE_LAUNCHER, canonical_name, uid, panel_id);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _simple_launcher_create_new_launcher_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	simple_launcher_create_new_launcher (self);
}


static void _simple_launcher_edit_clicked_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	simple_launcher_edit_clicked (self);
}


static void _simple_launcher_remove_clicked_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	simple_launcher_remove_clicked (self);
}


static void _simple_launcher_add_folders_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	simple_launcher_add_folders (self);
}


static void _simple_launcher_uri_received_gtk_widget_drag_data_received (GtkWidget* _sender, GdkDragContext* context, gint x, gint y, GtkSelectionData* selection_data, guint info, guint time_, gpointer self) {
	simple_launcher_uri_received (self, context, x, y, selection_data, info, time_);
}


static gboolean _lambda1_ (SimpleLauncher* self) {
	gboolean result = FALSE;
	awn_effects_start_ex (awn_overlayable_get_effects ((AwnOverlayable*) self->priv->add_icon), AWN_EFFECT_LAUNCHING, 1, FALSE, FALSE);
	result = FALSE;
	return result;
}


static gboolean __lambda1__gtk_widget_drag_motion (GtkWidget* _sender, GdkDragContext* context, gint x, gint y, guint time_, gpointer self) {
	gboolean result;
	result = _lambda1_ (self);
	return result;
}


static void _simple_launcher_on_add_icon_clicked_awn_icon_clicked (AwnIcon* _sender, gpointer self) {
	simple_launcher_on_add_icon_clicked (self);
}


static void _simple_launcher_on_add_icon_clicked_awn_icon_context_menu_popup (AwnIcon* _sender, GdkEventButton* event, gpointer self) {
	simple_launcher_on_add_icon_clicked (self);
}


static void _simple_launcher_on_size_changed_awn_applet_size_changed (AwnApplet* _sender, gint size, gpointer self) {
	simple_launcher_on_size_changed (self);
}


static void simple_launcher_init_widgets (SimpleLauncher* self) {
	GtkWidget* _tmp0_;
	GtkMenuItem* about_item1;
	GtkWidget* _tmp1_;
	GtkMenuItem* about_item2;
	GtkWidget* _tmp2_;
	GtkMenu* _tmp3_;
	GtkMenuItem* add_launcher_item1;
	GtkSeparatorMenuItem* _tmp4_;
	GtkMenuItem* _tmp5_;
	GtkMenuItem* _tmp6_;
	GtkSeparatorMenuItem* _tmp7_;
	GtkWidget* _tmp8_;
	GtkMenu* _tmp9_;
	GtkMenuItem* add_launcher_item2;
	GtkMenuItem* add_folders_item;
	GtkSeparatorMenuItem* _tmp10_;
	AwnIconBox* _tmp11_;
	AwnThemedIcon* _tmp12_;
	AwnThemedIcon* _tmp13_;
	g_return_if_fail (self != NULL);
	about_item1 = _g_object_ref0 ((_tmp0_ = awn_applet_create_about_item_simple ((AwnApplet*) self, "Copyright © 2010 Michal Hruby", AWN_APPLET_LICENSE_GPLV2, VERSION), GTK_IS_MENU_ITEM (_tmp0_) ? ((GtkMenuItem*) _tmp0_) : NULL));
	about_item2 = _g_object_ref0 ((_tmp1_ = awn_applet_create_about_item_simple ((AwnApplet*) self, "Copyright © 2010 Michal Hruby", AWN_APPLET_LICENSE_GPLV2, VERSION), GTK_IS_MENU_ITEM (_tmp1_) ? ((GtkMenuItem*) _tmp1_) : NULL));
	self->priv->menu = (_tmp3_ = _g_object_ref0 ((_tmp2_ = awn_applet_create_default_menu ((AwnApplet*) self), GTK_IS_MENU (_tmp2_) ? ((GtkMenu*) _tmp2_) : NULL)), _g_object_unref0 (self->priv->menu), _tmp3_);
	add_launcher_item1 = g_object_ref_sink ((GtkMenuItem*) gtk_menu_item_new_with_label ("Add Launcher..."));
	g_signal_connect_object (add_launcher_item1, "activate", (GCallback) _simple_launcher_create_new_launcher_gtk_menu_item_activate, self, 0);
	gtk_menu_shell_append ((GtkMenuShell*) self->priv->menu, (GtkWidget*) add_launcher_item1);
	gtk_menu_shell_append ((GtkMenuShell*) self->priv->menu, (GtkWidget*) ((GtkMenuItem*) (_tmp4_ = g_object_ref_sink ((GtkSeparatorMenuItem*) gtk_separator_menu_item_new ()))));
	_g_object_unref0 (_tmp4_);
	self->priv->edit_menu_item = (_tmp5_ = g_object_ref_sink ((GtkMenuItem*) gtk_menu_item_new_with_label ("Edit Launcher")), _g_object_unref0 (self->priv->edit_menu_item), _tmp5_);
	g_signal_connect_object (self->priv->edit_menu_item, "activate", (GCallback) _simple_launcher_edit_clicked_gtk_menu_item_activate, self, 0);
	gtk_menu_shell_append ((GtkMenuShell*) self->priv->menu, (GtkWidget*) self->priv->edit_menu_item);
	self->priv->remove_menu_item = (_tmp6_ = g_object_ref_sink ((GtkMenuItem*) gtk_menu_item_new_with_label ("Remove Launcher")), _g_object_unref0 (self->priv->remove_menu_item), _tmp6_);
	g_signal_connect_object (self->priv->remove_menu_item, "activate", (GCallback) _simple_launcher_remove_clicked_gtk_menu_item_activate, self, 0);
	gtk_menu_shell_append ((GtkMenuShell*) self->priv->menu, (GtkWidget*) self->priv->remove_menu_item);
	gtk_menu_shell_append ((GtkMenuShell*) self->priv->menu, (GtkWidget*) ((GtkMenuItem*) (_tmp7_ = g_object_ref_sink ((GtkSeparatorMenuItem*) gtk_separator_menu_item_new ()))));
	_g_object_unref0 (_tmp7_);
	gtk_menu_shell_append ((GtkMenuShell*) self->priv->menu, (GtkWidget*) about_item1);
	gtk_widget_show_all ((GtkWidget*) self->priv->menu);
	self->priv->add_icon_menu = (_tmp9_ = _g_object_ref0 ((_tmp8_ = awn_applet_create_default_menu ((AwnApplet*) self), GTK_IS_MENU (_tmp8_) ? ((GtkMenu*) _tmp8_) : NULL)), _g_object_unref0 (self->priv->add_icon_menu), _tmp9_);
	add_launcher_item2 = g_object_ref_sink ((GtkMenuItem*) gtk_menu_item_new_with_label ("Add Launcher..."));
	g_signal_connect_object (add_launcher_item2, "activate", (GCallback) _simple_launcher_create_new_launcher_gtk_menu_item_activate, self, 0);
	gtk_menu_shell_append ((GtkMenuShell*) self->priv->add_icon_menu, (GtkWidget*) add_launcher_item2);
	add_folders_item = g_object_ref_sink ((GtkMenuItem*) gtk_menu_item_new_with_label ("Add common folders"));
	g_signal_connect_object (add_folders_item, "activate", (GCallback) _simple_launcher_add_folders_gtk_menu_item_activate, self, 0);
	gtk_menu_shell_append ((GtkMenuShell*) self->priv->add_icon_menu, (GtkWidget*) add_folders_item);
	gtk_menu_shell_append ((GtkMenuShell*) self->priv->add_icon_menu, (GtkWidget*) ((GtkMenuItem*) (_tmp10_ = g_object_ref_sink ((GtkSeparatorMenuItem*) gtk_separator_menu_item_new ()))));
	_g_object_unref0 (_tmp10_);
	gtk_menu_shell_append ((GtkMenuShell*) self->priv->add_icon_menu, (GtkWidget*) about_item2);
	gtk_widget_show_all ((GtkWidget*) self->priv->add_icon_menu);
	self->priv->icon_box = (_tmp11_ = g_object_ref_sink ((AwnIconBox*) awn_icon_box_new_for_applet ((AwnApplet*) self)), _g_object_unref0 (self->priv->icon_box), _tmp11_);
	self->priv->add_icon = (_tmp12_ = g_object_ref_sink ((AwnThemedIcon*) awn_themed_icon_new ()), _g_object_unref0 (self->priv->add_icon), _tmp12_);
	g_object_set (self->priv->add_icon, "drag-and-drop", FALSE, NULL);
	awn_themed_icon_set_size (self->priv->add_icon, awn_applet_get_size ((AwnApplet*) self));
	gtk_drag_dest_set ((GtkWidget*) self->priv->add_icon, GTK_DEST_DEFAULT_MOTION | GTK_DEST_DEFAULT_DROP, SIMPLE_LAUNCHER_targets, G_N_ELEMENTS (SIMPLE_LAUNCHER_targets), GDK_ACTION_COPY);
	g_signal_connect_object ((_tmp13_ = self->priv->add_icon, GTK_IS_WIDGET (_tmp13_) ? ((GtkWidget*) _tmp13_) : NULL), "drag-data-received", (GCallback) _simple_launcher_uri_received_gtk_widget_drag_data_received, self, 0);
	g_signal_connect_object ((GtkWidget*) self->priv->add_icon, "drag-motion", (GCallback) __lambda1__gtk_widget_drag_motion, self, G_CONNECT_AFTER);
	g_signal_connect_object ((AwnIcon*) self->priv->add_icon, "clicked", (GCallback) _simple_launcher_on_add_icon_clicked_awn_icon_clicked, self, 0);
	g_signal_connect_object ((AwnIcon*) self->priv->add_icon, "context-menu-popup", (GCallback) _simple_launcher_on_add_icon_clicked_awn_icon_context_menu_popup, self, 0);
	awn_themed_icon_set_info_simple (self->priv->add_icon, awn_applet_get_canonical_name ((AwnApplet*) self), awn_applet_get_uid ((AwnApplet*) self), "add");
	awn_icon_set_tooltip_text ((AwnIcon*) self->priv->add_icon, "Drop launcher here");
	gtk_widget_show ((GtkWidget*) self->priv->add_icon);
	gtk_container_add ((GtkContainer*) self->priv->icon_box, (GtkWidget*) self->priv->add_icon);
	gtk_box_set_child_packing ((GtkBox*) self->priv->icon_box, (GtkWidget*) self->priv->add_icon, FALSE, FALSE, (guint) 0, GTK_PACK_END);
	gtk_widget_show ((GtkWidget*) self->priv->icon_box);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) self->priv->icon_box);
	g_signal_connect_object ((AwnApplet*) self, "size-changed", (GCallback) _simple_launcher_on_size_changed_awn_applet_size_changed, self, 0);
	_g_object_unref0 (add_folders_item);
	_g_object_unref0 (add_launcher_item2);
	_g_object_unref0 (add_launcher_item1);
	_g_object_unref0 (about_item2);
	_g_object_unref0 (about_item1);
}


static void simple_launcher_on_size_changed (SimpleLauncher* self) {
	g_return_if_fail (self != NULL);
	{
		GList* w_collection;
		GList* w_it;
		w_collection = gtk_container_get_children ((GtkContainer*) self->priv->icon_box);
		for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
			GtkWidget* w;
			w = (GtkWidget*) w_it->data;
			{
				GtkWidget* _tmp0_;
				AwnThemedIcon* i;
				i = (_tmp0_ = w, AWN_IS_THEMED_ICON (_tmp0_) ? ((AwnThemedIcon*) _tmp0_) : NULL);
				if (i != NULL) {
					awn_themed_icon_set_size (i, awn_applet_get_size ((AwnApplet*) self));
				}
			}
		}
		_g_list_free0 (w_collection);
	}
}


static void simple_launcher_on_add_icon_clicked (SimpleLauncher* self) {
	GdkEvent* e;
	guint _tmp0_ = 0U;
	gboolean _tmp1_ = FALSE;
	guint button;
	g_return_if_fail (self != NULL);
	e = gtk_get_current_event ();
	if (e == NULL) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = e->type != GDK_BUTTON_PRESS;
	}
	if (_tmp1_) {
		_tmp0_ = (guint) 0;
	} else {
		_tmp0_ = e->button.button;
	}
	button = _tmp0_;
	awn_icon_popup_gtk_menu ((AwnIcon*) self->priv->add_icon, (GtkWidget*) self->priv->add_icon_menu, button, gtk_get_current_event_time ());
	_gdk_event_free0 (e);
}


static gboolean _vala_string_array_contains (char** stack, int stack_length, char* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (_vala_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


static void _vala_array_add1 (char*** array, int* length, int* size, char* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (char*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void simple_launcher_add_folders (SimpleLauncher* self) {
	gint directories_length1;
	gint _directories_size_;
	char** _tmp1_;
	char** _tmp0_ = NULL;
	char** directories;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	directories = (_tmp1_ = (_tmp0_ = g_new0 (char*, 0 + 1), _tmp0_), directories_length1 = 0, _directories_size_ = directories_length1, _tmp1_);
	g_object_freeze_notify ((GObject*) self);
	{
		GUserDirectory dir;
		dir = G_USER_DIRECTORY_DESKTOP;
		{
			gboolean _tmp2_;
			_tmp2_ = TRUE;
			while (TRUE) {
				char* path;
				DesktopAgnosticVFSFile* f;
				if (!_tmp2_) {
					dir = dir + 1;
				}
				_tmp2_ = FALSE;
				if (!(dir <= G_USER_DIRECTORY_VIDEOS)) {
					break;
				}
				path = g_strdup (g_get_user_special_dir (dir));
				if (_vala_string_array_contains (directories, directories_length1, path)) {
					_g_free0 (path);
					continue;
				}
				_vala_array_add1 (&directories, &directories_length1, &_directories_size_, g_strdup (path));
				f = desktop_agnostic_vfs_file_new_for_path (path, &_inner_error_);
				if (_inner_error_ != NULL) {
					_g_free0 (path);
					directories = (_vala_array_free (directories, directories_length1, (GDestroyNotify) g_free), NULL);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				if (desktop_agnostic_vfs_file_exists (f)) {
					simple_launcher_process_uri (self, f);
				}
				_g_object_unref0 (f);
				_g_free0 (path);
			}
		}
	}
	g_object_thaw_notify ((GObject*) self);
	directories = (_vala_array_free (directories, directories_length1, (GDestroyNotify) g_free), NULL);
}


static void _g_slist_free_g_object_unref (GSList* self) {
	g_slist_foreach (self, (GFunc) g_object_unref, NULL);
	g_slist_free (self);
}


static void simple_launcher_uri_received (SimpleLauncher* self, GdkDragContext* context, gint x, gint y, GtkSelectionData* data, guint info, guint time_) {
	gboolean _tmp0_ = FALSE;
	GSList* files;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (data != NULL);
	if (data == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = gtk_selection_data_get_length (data) == 0;
	}
	if (_tmp0_) {
		gtk_drag_finish (context, FALSE, FALSE, (guint32) time_);
		return;
	}
	files = desktop_agnostic_vfs_files_from_uri_list ((const char*) data->data, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	simple_launcher_process_uri (self, (DesktopAgnosticVFSFile*) files->data);
	gtk_drag_finish (context, TRUE, FALSE, (guint32) time_);
	__g_slist_free_g_object_unref0 (files);
}


static char* simple_launcher_pick_icon_name (SimpleLauncher* self, char** icon_names, int icon_names_length1) {
	char* result = NULL;
	GtkIconTheme* it;
	g_return_val_if_fail (self != NULL, NULL);
	it = _g_object_ref0 (gtk_icon_theme_get_default ());
	{
		char** icon_collection;
		int icon_collection_length1;
		int icon_it;
		icon_collection = icon_names;
		icon_collection_length1 = icon_names_length1;
		for (icon_it = 0; icon_it < icon_names_length1; icon_it = icon_it + 1) {
			const char* icon;
			icon = icon_collection[icon_it];
			{
				if (gtk_icon_theme_has_icon (it, icon)) {
					result = g_strdup (icon);
					_g_object_unref0 (it);
					return result;
				}
			}
		}
	}
	result = NULL;
	_g_object_unref0 (it);
	return result;
}


static void simple_launcher_process_uri (SimpleLauncher* self, DesktopAgnosticVFSFile* file) {
	char* uri;
	DesktopAgnosticVFSFile* df;
	char* path;
	GValue _tmp10_ = {0};
	GValue v;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	uri = desktop_agnostic_vfs_file_get_uri (file);
	g_debug ("simple-launcher.vala:232: received %s", uri);
	df = simple_launcher_get_new_desktop_file (self);
	path = desktop_agnostic_vfs_file_get_path (df);
	if (g_str_has_suffix (uri, ".desktop")) {
		if (desktop_agnostic_vfs_file_is_writable (file)) {
			DesktopAgnosticFDODesktopEntry* de;
			de = desktop_agnostic_fdo_desktop_entry_new_for_file (file, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_free0 (path);
				_g_object_unref0 (df);
				_g_free0 (uri);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			desktop_agnostic_fdo_desktop_entry_save (de, df, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (de);
				_g_free0 (path);
				_g_object_unref0 (df);
				_g_free0 (uri);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			_g_object_unref0 (de);
		} else {
			char* _tmp0_;
			path = (_tmp0_ = desktop_agnostic_vfs_file_get_path (file), _g_free0 (path), _tmp0_);
		}
	} else {
		DesktopAgnosticFDODesktopEntry* link_entry;
		char* _tmp1_;
		char* _tmp2_;
		char* icon_name;
		link_entry = desktop_agnostic_fdo_desktop_entry_new (&_inner_error_);
		if (_inner_error_ != NULL) {
			_g_free0 (path);
			_g_object_unref0 (df);
			_g_free0 (uri);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		desktop_agnostic_fdo_desktop_entry_set_entry_type (link_entry, DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_TYPE_LINK);
		desktop_agnostic_fdo_desktop_entry_set_name (link_entry, _tmp2_ = g_uri_unescape_string (_tmp1_ = g_path_get_basename (uri), NULL));
		_g_free0 (_tmp2_);
		_g_free0 (_tmp1_);
		desktop_agnostic_fdo_desktop_entry_set_string (link_entry, "URL", uri);
		icon_name = g_strdup ("image-missing");
		{
			DesktopAgnosticVFSFile* f;
			f = desktop_agnostic_vfs_file_new_for_uri (uri, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch0_g_error;
			}
			if (desktop_agnostic_vfs_file_is_native (f)) {
				gint _tmp4__length1;
				gint __tmp4__size_;
				char** _tmp5_;
				gint _tmp3_;
				char** _tmp4_;
				char** _tmp6_;
				gint _tmp6__length1;
				char* _tmp7_;
				char* i;
				_tmp4_ = (_tmp5_ = desktop_agnostic_vfs_file_get_icon_names (f, &_tmp3_, &_inner_error_), _tmp4__length1 = _tmp3_, __tmp4__size_ = _tmp4__length1, _tmp5_);
				if (_inner_error_ != NULL) {
					_g_object_unref0 (f);
					goto __catch0_g_error;
				}
				i = (_tmp7_ = simple_launcher_pick_icon_name (self, (_tmp6_ = _tmp4_, _tmp6__length1 = _tmp4__length1, _tmp6_), _tmp4__length1), _tmp6_ = (_vala_array_free (_tmp6_, _tmp6__length1, (GDestroyNotify) g_free), NULL), _tmp7_);
				if (i != NULL) {
					char* _tmp8_;
					icon_name = (_tmp8_ = g_strdup (i), _g_free0 (icon_name), _tmp8_);
				}
				_g_free0 (i);
			} else {
				char* _tmp9_;
				icon_name = (_tmp9_ = g_strdup ("unknown"), _g_free0 (icon_name), _tmp9_);
			}
			_g_object_unref0 (f);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError * err;
			err = _inner_error_;
			_inner_error_ = NULL;
			{
				g_warning ("simple-launcher.vala:276: %s", err->message);
				_g_error_free0 (err);
			}
		}
		__finally0:
		if (_inner_error_ != NULL) {
			_g_free0 (icon_name);
			_g_object_unref0 (link_entry);
			_g_free0 (path);
			_g_object_unref0 (df);
			_g_free0 (uri);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		desktop_agnostic_fdo_desktop_entry_set_icon (link_entry, icon_name);
		desktop_agnostic_fdo_desktop_entry_save (link_entry, df, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_free0 (icon_name);
			_g_object_unref0 (link_entry);
			_g_free0 (path);
			_g_object_unref0 (df);
			_g_free0 (uri);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_free0 (icon_name);
		_g_object_unref0 (link_entry);
	}
	v = (g_value_init (&_tmp10_, G_TYPE_STRING), g_value_set_string (&_tmp10_, path), _tmp10_);
	g_value_array_append (self->priv->_launcher_list, &v);
	g_object_notify ((GObject*) self, "launcher-list");
	G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
	_g_free0 (path);
	_g_object_unref0 (df);
	_g_free0 (uri);
}


static DesktopAgnosticVFSFile* simple_launcher_get_new_desktop_file (SimpleLauncher* self) {
	DesktopAgnosticVFSFile* result = NULL;
	DesktopAgnosticVFSFile* f;
	gint counter;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	f = NULL;
	counter = 1;
	{
		gboolean _tmp0_;
		_tmp0_ = TRUE;
		while (TRUE) {
			char* _tmp1_;
			char* _tmp2_;
			char* path;
			DesktopAgnosticVFSFile* _tmp3_;
			DesktopAgnosticVFSFile* _tmp4_;
			if (!_tmp0_) {
				if (!desktop_agnostic_vfs_file_exists (f)) {
					break;
				}
			}
			_tmp0_ = FALSE;
			path = (_tmp2_ = g_build_filename (self->priv->config_dir, _tmp1_ = g_strdup_printf ("launcher-%d.desktop", counter++), NULL, NULL), _g_free0 (_tmp1_), _tmp2_);
			_tmp3_ = desktop_agnostic_vfs_file_new_for_path (path, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_free0 (path);
				_g_object_unref0 (f);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			f = (_tmp4_ = _tmp3_, _g_object_unref0 (f), _tmp4_);
			_g_free0 (path);
		}
	}
	result = f;
	return result;
}


static void simple_launcher_create_new_launcher (SimpleLauncher* self) {
	DesktopAgnosticVFSFile* f;
	DesktopAgnosticUILauncherEditorDialog* d;
	g_return_if_fail (self != NULL);
	f = simple_launcher_get_new_desktop_file (self);
	d = g_object_ref_sink (desktop_agnostic_ui_launcher_editor_dialog_new (f, NULL, TRUE));
	gtk_widget_show_all ((GtkWidget*) d);
	if (gtk_dialog_run ((GtkDialog*) d) == GTK_RESPONSE_APPLY) {
		GValue _tmp0_ = {0};
		GValue v;
		v = (g_value_init (&_tmp0_, G_TYPE_STRING), g_value_take_string (&_tmp0_, desktop_agnostic_vfs_file_get_path (f)), _tmp0_);
		g_value_array_append (self->priv->_launcher_list, &v);
		g_object_notify ((GObject*) self, "launcher-list");
		G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
	}
	gtk_object_destroy ((GtkObject*) d);
	_g_object_unref0 (d);
	_g_object_unref0 (f);
}


static gint g_ptr_array_get_length (GPtrArray* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) self->len;
	return result;
}


static void g_ptr_array_set_length (GPtrArray* self, gint value) {
	g_return_if_fail (self != NULL);
	g_ptr_array_set_size (self, value);
}


static void _vala_array_add2 (gint** array, int* length, int* size, gint value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gint, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void simple_launcher_launchers_changed (SimpleLauncher* self) {
	gint i = 0;
	gint invalid_launchers_length1;
	gint _invalid_launchers_size_;
	gint* _tmp1_;
	gint* _tmp0_ = NULL;
	gint* invalid_launchers;
	gint index;
	GList* l;
	gboolean something_removed;
	g_return_if_fail (self != NULL);
	invalid_launchers = (_tmp1_ = (_tmp0_ = g_new0 (gint, 0), _tmp0_), invalid_launchers_length1 = 0, _invalid_launchers_size_ = invalid_launchers_length1, _tmp1_);
	{
		gboolean _tmp2_;
		i = 0;
		_tmp2_ = TRUE;
		while (TRUE) {
			if (!_tmp2_) {
				i++;
			}
			_tmp2_ = FALSE;
			if (!(i < g_ptr_array_get_length (self->priv->launchers))) {
				break;
			}
			g_object_set_data_full ((GObject*) ((AwnThemedIcon*) g_ptr_array_index (self->priv->launchers, (guint) i)), "untouched", GINT_TO_POINTER (1), NULL);
		}
	}
	index = 0;
	{
		GValueArray* v_collection;
		guint v_index;
		v_collection = self->priv->_launcher_list;
		for (v_index = 0; v_index < v_collection->n_values; v_index = v_index + 1) {
			GValue _tmp6_ = {0};
			GValue v;
			v = G_IS_VALUE (g_value_array_get_nth (v_collection, v_index)) ? (g_value_init (&_tmp6_, G_VALUE_TYPE (g_value_array_get_nth (v_collection, v_index))), g_value_copy (g_value_array_get_nth (v_collection, v_index), &_tmp6_), _tmp6_) : (*g_value_array_get_nth (v_collection, v_index));
			{
				char* de_path;
				gboolean found;
				de_path = g_strdup (g_value_get_string (&v));
				found = FALSE;
				{
					gboolean _tmp3_;
					i = 0;
					_tmp3_ = TRUE;
					while (TRUE) {
						DesktopAgnosticFDODesktopEntry* de;
						gboolean _tmp4_ = FALSE;
						if (!_tmp3_) {
							i++;
						}
						_tmp3_ = FALSE;
						if (!(i < g_ptr_array_get_length (self->priv->launchers))) {
							break;
						}
						de = _g_object_ref0 ((DesktopAgnosticFDODesktopEntry*) g_object_get_data ((GObject*) ((AwnThemedIcon*) g_ptr_array_index (self->priv->launchers, (guint) i)), SIMPLE_LAUNCHER_DESKTOP_ENTRY));
						if (de != NULL) {
							char* _tmp5_;
							_tmp4_ = _vala_strcmp0 (_tmp5_ = desktop_agnostic_vfs_file_get_path (desktop_agnostic_fdo_desktop_entry_get_file (de)), de_path) == 0;
							_g_free0 (_tmp5_);
						} else {
							_tmp4_ = FALSE;
						}
						if (_tmp4_) {
							g_object_set_data_full ((GObject*) ((AwnThemedIcon*) g_ptr_array_index (self->priv->launchers, (guint) i)), "untouched", GINT_TO_POINTER (0), NULL);
							found = TRUE;
							gtk_box_reorder_child ((GtkBox*) self->priv->icon_box, (GtkWidget*) ((AwnThemedIcon*) g_ptr_array_index (self->priv->launchers, (guint) i)), index);
							_g_object_unref0 (de);
							break;
						}
						_g_object_unref0 (de);
					}
				}
				if (!found) {
					AwnThemedIcon* icon;
					icon = simple_launcher_create_launcher (self, de_path);
					if (icon != NULL) {
						gtk_box_reorder_child ((GtkBox*) self->priv->icon_box, (GtkWidget*) icon, index);
					} else {
						_vala_array_add2 (&invalid_launchers, &invalid_launchers_length1, &_invalid_launchers_size_, index);
					}
					_g_object_unref0 (icon);
				}
				index++;
				_g_free0 (de_path);
				G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
			}
		}
	}
	l = NULL;
	{
		gboolean _tmp7_;
		i = 0;
		_tmp7_ = TRUE;
		while (TRUE) {
			if (!_tmp7_) {
				i++;
			}
			_tmp7_ = FALSE;
			if (!(i < g_ptr_array_get_length (self->priv->launchers))) {
				break;
			}
			if (GPOINTER_TO_INT (g_object_get_data ((GObject*) ((AwnThemedIcon*) g_ptr_array_index (self->priv->launchers, (guint) i)), "untouched")) != 0) {
				l = g_list_append (l, (AwnThemedIcon*) g_ptr_array_index (self->priv->launchers, (guint) i));
			}
		}
	}
	{
		GList* ti_collection;
		GList* ti_it;
		ti_collection = l;
		for (ti_it = ti_collection; ti_it != NULL; ti_it = ti_it->next) {
			AwnThemedIcon* ti;
			ti = (AwnThemedIcon*) ti_it->data;
			{
				simple_launcher_remove_launcher (self, ti, TRUE);
			}
		}
	}
	if (g_ptr_array_get_length (self->priv->launchers) > 0) {
		gtk_widget_hide ((GtkWidget*) self->priv->add_icon);
	} else {
		gtk_widget_show ((GtkWidget*) self->priv->add_icon);
	}
	something_removed = FALSE;
	{
		gboolean _tmp8_;
		i = invalid_launchers_length1 - 1;
		_tmp8_ = TRUE;
		while (TRUE) {
			if (!_tmp8_) {
				i--;
			}
			_tmp8_ = FALSE;
			if (!(i >= 0)) {
				break;
			}
			g_value_array_remove (self->priv->_launcher_list, (guint) invalid_launchers[i]);
			something_removed = TRUE;
		}
	}
	if (something_removed) {
		g_object_notify ((GObject*) self, "launcher-list");
	}
	_g_list_free0 (l);
	invalid_launchers = (g_free (invalid_launchers), NULL);
}


static void _simple_launcher_on_launcher_clicked_awn_icon_clicked (AwnIcon* _sender, gpointer self) {
	simple_launcher_on_launcher_clicked (self, _sender);
}


static void _simple_launcher_on_launcher_ctx_menu_awn_icon_context_menu_popup (AwnIcon* _sender, GdkEventButton* event, gpointer self) {
	simple_launcher_on_launcher_ctx_menu (self, _sender, event);
}


static gboolean _simple_launcher_on_launcher_drag_motion_gtk_widget_drag_motion (GtkWidget* _sender, GdkDragContext* context, gint x, gint y, guint time_, gpointer self) {
	gboolean result;
	result = simple_launcher_on_launcher_drag_motion (self);
	return result;
}


static AwnThemedIcon* simple_launcher_create_launcher (SimpleLauncher* self, const char* path) {
	AwnThemedIcon* result = NULL;
	DesktopAgnosticVFSFile* f;
	DesktopAgnosticFDODesktopEntry* de;
	AwnThemedIcon* icon;
	char* icon_name;
	char* _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	f = desktop_agnostic_vfs_file_new_for_path (path, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	if (!desktop_agnostic_vfs_file_exists (f)) {
		g_warning ("simple-launcher.vala:396: Desktop file \"%s\" doesn't exist!", path);
		result = NULL;
		_g_object_unref0 (f);
		return result;
	}
	de = desktop_agnostic_fdo_desktop_entry_new_for_file (f, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (f);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	icon = g_object_ref_sink ((AwnThemedIcon*) awn_themed_icon_new ());
	g_object_set (icon, "drag-and-drop", FALSE, NULL);
	g_object_set_data_full ((GObject*) icon, SIMPLE_LAUNCHER_DESKTOP_ENTRY, _g_object_ref0 (de), g_object_unref);
	awn_themed_icon_set_size (icon, awn_applet_get_size ((AwnApplet*) self));
	icon_name = g_strdup ("image-missing");
	if (desktop_agnostic_fdo_desktop_entry_key_exists (de, "Icon")) {
		char* _tmp0_;
		icon_name = (_tmp0_ = desktop_agnostic_fdo_desktop_entry_get_string (de, "Icon"), _g_free0 (icon_name), _tmp0_);
	}
	awn_themed_icon_set_info_simple (icon, awn_applet_get_canonical_name ((AwnApplet*) self), awn_applet_get_uid ((AwnApplet*) self), icon_name);
	awn_icon_set_tooltip_text ((AwnIcon*) icon, _tmp1_ = desktop_agnostic_fdo_desktop_entry_get_localestring (de, "Name", NULL));
	_g_free0 (_tmp1_);
	g_signal_connect_object ((AwnIcon*) icon, "clicked", (GCallback) _simple_launcher_on_launcher_clicked_awn_icon_clicked, self, 0);
	g_signal_connect_object ((AwnIcon*) icon, "context-menu-popup", (GCallback) _simple_launcher_on_launcher_ctx_menu_awn_icon_context_menu_popup, self, 0);
	gtk_container_add ((GtkContainer*) self->priv->icon_box, (GtkWidget*) icon);
	gtk_widget_show ((GtkWidget*) icon);
	gtk_drag_dest_set ((GtkWidget*) icon, 0, NULL, 0, GDK_ACTION_PRIVATE);
	g_signal_connect_object ((GtkWidget*) icon, "drag-motion", (GCallback) _simple_launcher_on_launcher_drag_motion_gtk_widget_drag_motion, self, 0);
	g_ptr_array_add (self->priv->launchers, _g_object_ref0 (icon));
	result = icon;
	_g_free0 (icon_name);
	_g_object_unref0 (de);
	_g_object_unref0 (f);
	return result;
}


static void simple_launcher_remove_launcher (SimpleLauncher* self, AwnThemedIcon* launcher, gboolean delete_desktop_file) {
	DesktopAgnosticFDODesktopEntry* de;
	gboolean _tmp0_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (launcher != NULL);
	de = (DesktopAgnosticFDODesktopEntry*) g_object_steal_data ((GObject*) launcher, SIMPLE_LAUNCHER_DESKTOP_ENTRY);
	if (delete_desktop_file) {
		char* _tmp1_;
		_tmp0_ = g_str_has_prefix (_tmp1_ = desktop_agnostic_vfs_file_get_path (desktop_agnostic_fdo_desktop_entry_get_file (de)), self->priv->config_dir);
		_g_free0 (_tmp1_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		desktop_agnostic_vfs_file_remove (desktop_agnostic_fdo_desktop_entry_get_file (de), &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (de);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	g_ptr_array_remove (self->priv->launchers, launcher);
	gtk_object_destroy ((GtkObject*) launcher);
	_g_object_unref0 (de);
}


static gboolean _lambda0_ (SimpleLauncher* self) {
	gboolean result = FALSE;
	gtk_widget_hide ((GtkWidget*) self->priv->add_icon);
	result = FALSE;
	return result;
}


static gboolean __lambda0__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda0_ (self);
	return result;
}


static gboolean simple_launcher_on_launcher_drag_motion (SimpleLauncher* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->timer_id != 0) {
		g_source_remove (self->priv->timer_id);
	}
	self->priv->timer_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 2500, __lambda0__gsource_func, g_object_ref (self), g_object_unref);
	gtk_widget_show ((GtkWidget*) self->priv->add_icon);
	result = FALSE;
	return result;
}


static void simple_launcher_on_launcher_clicked (SimpleLauncher* self, AwnIcon* launcher) {
	DesktopAgnosticFDODesktopEntry* de;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (launcher != NULL);
	de = _g_object_ref0 ((DesktopAgnosticFDODesktopEntry*) g_object_get_data ((GObject*) launcher, SIMPLE_LAUNCHER_DESKTOP_ENTRY));
	g_return_if_fail (de != NULL);
	{
		desktop_agnostic_fdo_desktop_entry_launch (de, 0, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
		awn_effects_start_ex (awn_overlayable_get_effects ((AwnOverlayable*) launcher), AWN_EFFECT_LAUNCHING, 1, FALSE, FALSE);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			GtkMessageDialog* d;
			d = g_object_ref_sink ((GtkMessageDialog*) gtk_message_dialog_new (NULL, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, "Unable to start launcher!\n\n" "Error details:\n%s", err->message));
			gtk_dialog_run ((GtkDialog*) d);
			gtk_object_destroy ((GtkObject*) d);
			_g_object_unref0 (d);
			_g_error_free0 (err);
		}
	}
	__finally1:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (de);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (de);
}


static void simple_launcher_on_launcher_ctx_menu (SimpleLauncher* self, AwnIcon* launcher, GdkEventButton* event) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (launcher != NULL);
	g_object_set_data_full ((GObject*) self->priv->remove_menu_item, SIMPLE_LAUNCHER_DESKTOP_ENTRY, _g_object_ref0 (launcher), g_object_unref);
	g_object_set_data_full ((GObject*) self->priv->edit_menu_item, SIMPLE_LAUNCHER_DESKTOP_ENTRY, _g_object_ref0 (launcher), g_object_unref);
	awn_icon_popup_gtk_menu (launcher, (GtkWidget*) self->priv->menu, (*event).button, (*event).time);
}


static void simple_launcher_remove_clicked (SimpleLauncher* self) {
	AwnThemedIcon* ti;
	DesktopAgnosticFDODesktopEntry* de;
	guint index;
	g_return_if_fail (self != NULL);
	ti = _g_object_ref0 ((AwnThemedIcon*) g_object_get_data ((GObject*) self->priv->remove_menu_item, SIMPLE_LAUNCHER_DESKTOP_ENTRY));
	de = _g_object_ref0 ((DesktopAgnosticFDODesktopEntry*) g_object_get_data ((GObject*) ti, SIMPLE_LAUNCHER_DESKTOP_ENTRY));
	index = (guint) 0;
	{
		GValueArray* v_collection;
		guint v_index;
		v_collection = self->priv->_launcher_list;
		for (v_index = 0; v_index < v_collection->n_values; v_index = v_index + 1) {
			GValue _tmp2_ = {0};
			GValue v;
			v = G_IS_VALUE (g_value_array_get_nth (v_collection, v_index)) ? (g_value_init (&_tmp2_, G_VALUE_TYPE (g_value_array_get_nth (v_collection, v_index))), g_value_copy (g_value_array_get_nth (v_collection, v_index), &_tmp2_), _tmp2_) : (*g_value_array_get_nth (v_collection, v_index));
			{
				char* _tmp0_;
				gboolean _tmp1_;
				if ((_tmp1_ = _vala_strcmp0 (g_value_get_string (&v), _tmp0_ = desktop_agnostic_vfs_file_get_path (desktop_agnostic_fdo_desktop_entry_get_file (de))) == 0, _g_free0 (_tmp0_), _tmp1_)) {
					G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
					break;
				}
				index++;
				G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
			}
		}
	}
	if (index < self->priv->_launcher_list->n_values) {
		g_value_array_remove (self->priv->_launcher_list, index);
	}
	g_object_notify ((GObject*) self, "launcher-list");
	_g_object_unref0 (de);
	_g_object_unref0 (ti);
}


static void simple_launcher_edit_clicked (SimpleLauncher* self) {
	AwnThemedIcon* ti;
	DesktopAgnosticFDODesktopEntry* de;
	DesktopAgnosticVFSFile* input;
	DesktopAgnosticVFSFile* output;
	char* _tmp0_;
	gboolean _tmp1_;
	DesktopAgnosticUILauncherEditorDialog* d;
	g_return_if_fail (self != NULL);
	ti = _g_object_ref0 ((AwnThemedIcon*) g_object_get_data ((GObject*) self->priv->remove_menu_item, SIMPLE_LAUNCHER_DESKTOP_ENTRY));
	de = _g_object_ref0 ((DesktopAgnosticFDODesktopEntry*) g_object_get_data ((GObject*) ti, SIMPLE_LAUNCHER_DESKTOP_ENTRY));
	input = _g_object_ref0 (desktop_agnostic_fdo_desktop_entry_get_file (de));
	output = NULL;
	if ((_tmp1_ = !g_str_has_prefix (_tmp0_ = desktop_agnostic_vfs_file_get_path (input), self->priv->config_dir), _g_free0 (_tmp0_), _tmp1_)) {
		DesktopAgnosticVFSFile* _tmp2_;
		output = (_tmp2_ = simple_launcher_get_new_desktop_file (self), _g_object_unref0 (output), _tmp2_);
	}
	d = g_object_ref_sink (desktop_agnostic_ui_launcher_editor_dialog_new (input, output, TRUE));
	gtk_widget_show_all ((GtkWidget*) d);
	if (gtk_dialog_run ((GtkDialog*) d) == GTK_RESPONSE_APPLY) {
		if (output == NULL) {
			simple_launcher_remove_launcher (self, ti, FALSE);
			simple_launcher_launchers_changed (self);
		} else {
			GValue* val = NULL;
			{
				guint i;
				i = (guint) 0;
				{
					gboolean _tmp3_;
					_tmp3_ = TRUE;
					while (TRUE) {
						char* _tmp4_;
						gboolean _tmp5_;
						if (!_tmp3_) {
							i++;
						}
						_tmp3_ = FALSE;
						if (!(i < self->priv->_launcher_list->n_values)) {
							break;
						}
						val = g_value_array_get_nth (self->priv->_launcher_list, i);
						if ((_tmp5_ = _vala_strcmp0 (g_value_get_string (val), _tmp4_ = desktop_agnostic_vfs_file_get_path (input)) == 0, _g_free0 (_tmp4_), _tmp5_)) {
							char* _tmp6_;
							g_value_set_string (val, _tmp6_ = desktop_agnostic_vfs_file_get_path (output));
							_g_free0 (_tmp6_);
						}
					}
				}
			}
			g_object_notify ((GObject*) self, "launcher-list");
		}
	}
	gtk_object_destroy ((GtkObject*) d);
	_g_object_unref0 (d);
	_g_object_unref0 (output);
	_g_object_unref0 (input);
	_g_object_unref0 (de);
	_g_object_unref0 (ti);
}


GValueArray* simple_launcher_get_launcher_list (SimpleLauncher* self) {
	GValueArray* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_launcher_list;
	return result;
}


void simple_launcher_set_launcher_list (SimpleLauncher* self, GValueArray* value) {
	GValueArray* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_launcher_list = (_tmp0_ = g_value_array_copy (value), _g_value_array_free0 (self->priv->_launcher_list), _tmp0_);
	g_object_notify ((GObject *) self, "launcher-list");
}


static GObject * simple_launcher_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	SimpleLauncher * self;
	GError * _inner_error_;
	parent_class = G_OBJECT_CLASS (simple_launcher_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = SIMPLE_LAUNCHER (obj);
	_inner_error_ = NULL;
	{
		char* _tmp0_;
		GPtrArray* _tmp1_;
		DesktopAgnosticConfigClient* _tmp2_;
		DesktopAgnosticConfigClient* _tmp3_;
		self->priv->config_dir = (_tmp0_ = g_build_filename (g_get_user_config_dir (), "awn", "applets", "simple-launcher", NULL, NULL), _g_free0 (self->priv->config_dir), _tmp0_);
		g_mkdir_with_parents (self->priv->config_dir, 0755);
		self->priv->launchers = (_tmp1_ = g_ptr_array_new_with_free_func (g_object_unref), _g_ptr_array_unref0 (self->priv->launchers), _tmp1_);
		_tmp2_ = awn_config_get_default_for_applet ((AwnApplet*) self, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		self->priv->client = (_tmp3_ = _g_object_ref0 (_tmp2_), _g_object_unref0 (self->priv->client), _tmp3_);
		{
			desktop_agnostic_config_client_bind (self->priv->client, DESKTOP_AGNOSTIC_CONFIG_GROUP_DEFAULT, "launcher_list", (GObject*) self, "launcher-list", FALSE, DESKTOP_AGNOSTIC_CONFIG_BIND_METHOD_FALLBACK, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == DESKTOP_AGNOSTIC_CONFIG_ERROR) {
					goto __catch2_desktop_agnostic_config_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
			}
		}
		goto __finally2;
		__catch2_desktop_agnostic_config_error:
		{
			GError * err;
			err = _inner_error_;
			_inner_error_ = NULL;
			{
				g_critical ("simple-launcher.vala:157: Config Error: %s", err->message);
				_g_error_free0 (err);
			}
		}
		__finally2:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
	}
	return obj;
}


static void simple_launcher_class_init (SimpleLauncherClass * klass) {
	simple_launcher_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SimpleLauncherPrivate));
	G_OBJECT_CLASS (klass)->get_property = simple_launcher_get_property;
	G_OBJECT_CLASS (klass)->set_property = simple_launcher_set_property;
	G_OBJECT_CLASS (klass)->constructor = simple_launcher_constructor;
	G_OBJECT_CLASS (klass)->finalize = simple_launcher_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SIMPLE_LAUNCHER_LAUNCHER_LIST, g_param_spec_boxed ("launcher-list", "launcher-list", "launcher-list", G_TYPE_VALUE_ARRAY, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void simple_launcher_instance_init (SimpleLauncher * self) {
	self->priv = SIMPLE_LAUNCHER_GET_PRIVATE (self);
	self->priv->timer_id = (guint) 0;
	self->priv->_launcher_list = g_value_array_new ((guint) 4);
}


static void simple_launcher_finalize (GObject* obj) {
	SimpleLauncher * self;
	self = SIMPLE_LAUNCHER (obj);
	_g_object_unref0 (self->priv->icon_box);
	_g_object_unref0 (self->priv->add_icon);
	_g_object_unref0 (self->priv->menu);
	_g_object_unref0 (self->priv->add_icon_menu);
	_g_object_unref0 (self->priv->remove_menu_item);
	_g_object_unref0 (self->priv->edit_menu_item);
	_g_object_unref0 (self->priv->client);
	_g_free0 (self->priv->config_dir);
	_g_ptr_array_unref0 (self->priv->launchers);
	_g_value_array_free0 (self->priv->_launcher_list);
	G_OBJECT_CLASS (simple_launcher_parent_class)->finalize (obj);
}


GType simple_launcher_get_type (void) {
	static volatile gsize simple_launcher_type_id__volatile = 0;
	if (g_once_init_enter (&simple_launcher_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SimpleLauncherClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) simple_launcher_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SimpleLauncher), 0, (GInstanceInitFunc) simple_launcher_instance_init, NULL };
		GType simple_launcher_type_id;
		simple_launcher_type_id = g_type_register_static (AWN_TYPE_APPLET, "SimpleLauncher", &g_define_type_info, 0);
		g_once_init_leave (&simple_launcher_type_id__volatile, simple_launcher_type_id);
	}
	return simple_launcher_type_id__volatile;
}


static void simple_launcher_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SimpleLauncher * self;
	self = SIMPLE_LAUNCHER (object);
	switch (property_id) {
		case SIMPLE_LAUNCHER_LAUNCHER_LIST:
		g_value_set_boxed (value, simple_launcher_get_launcher_list (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void simple_launcher_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SimpleLauncher * self;
	self = SIMPLE_LAUNCHER (object);
	switch (property_id) {
		case SIMPLE_LAUNCHER_LAUNCHER_LIST:
		simple_launcher_set_launcher_list (self, g_value_get_boxed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


AwnApplet* awn_applet_factory_initp (const char* canonical_name, const char* uid, gint panel_id) {
	AwnApplet* result = NULL;
	g_return_val_if_fail (canonical_name != NULL, NULL);
	g_return_val_if_fail (uid != NULL, NULL);
	result = (AwnApplet*) g_object_ref_sink (simple_launcher_new (canonical_name, uid, panel_id));
	return result;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




