# -*- coding: utf-8 -*-

# ==============================================================================
# COPYRIGHT (C) 1991 - 2003  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ==============================================================================

"""Define a logger for asrun
"""

import logging as LO
from logging import FATAL, ERROR, WARNING, INFO, DEBUG


_title = {
    FATAL   : "<F>",
    ERROR   : "<E>",
    WARNING : "<A>",
    INFO    : "<I>",
    DEBUG   : "DEBUG",    
}

_width = max([len(s) for s in _title.values()])
_fmt_title = "%%-%ds" % _width


class AsRunLogger(LO.Logger):
    """Some enhancements for asrun logger."""
    def __init__(self, keyword="KEY", level=INFO, **kwargs):
        LO.Logger.__init__(self, keyword, level=level)

        # very similar to logging.basicConfig
        filename = kwargs.get("filename")
        if filename:
            mode = kwargs.get("filemode", 'a')
            hdlr = LO.FileHandler(filename, mode)
        else:
            stream = kwargs.get("stream")
            hdlr = LO.StreamHandler(stream)
        fs = kwargs.get("format", "%(message)s")
        dfs = kwargs.get("datefmt", None)
        fmt = LO.Formatter(fs, dfs)
        hdlr.setFormatter(fmt)
        self.addHandler(hdlr)
        level = kwargs.get("level")
        if level:
            self.setLevel(level)


    def makeRecord(self, name, level, fn, lno, msg, args, exc_info, func=None, extra=None):
        """Add title at the beginning of the message."""
        strtit = ""
        if _title.get(level):
            strtit = _fmt_title % _title[level] + " "
        msg = strtit + msg
        return LO.Logger.makeRecord(self, name, level, fn, lno, msg, args, exc_info, func, extra)


log = AsRunLogger()




