#include <unistd.h>
#include "debconf.h"
#include <QTimer>
#include <KCmdLineArgs>
#include <KAboutData>
#include <KApplication>

using namespace adept;
using namespace std;

int main( int argc, char **argv ) {
    KAboutData aboutData( "adept_debconf",
                          QByteArray(),
                          ki18n("Adept Manager"),
                          "3.0-Alpha",
                          ki18n( "Adept Manager" ),
                          KAboutData::License_BSD );

    KCmdLineArgs::init( 1, argv, &aboutData );

    KApplication app;
    MainWin *win = new MainWin();
    app.setTopWidget( win );
    win->show();

    pid_t pid = fork();
    if ( pid == -1 ) {
        cerr << "fork() failed" << std::endl;
        exit( 1 );
    }

    if ( pid == 0 ) {
        execvp( "dpkg-reconfigure", argv );
        exit( 1 );
    }

    QTimer::singleShot( 0, win, SLOT( monitoringLoop() ) );

    // busy-wait (ick) for dpkg-reconfigure to call us
    return app.exec();
}
