/*###############################################################################
# Linux Management Providers (LMP), IP provider package
# Copyright (C) 2007 Ilsoo Byun <widepis@etri.re.kr ,widepis@empal.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
###############################################################################*/

#ifndef OPENDRIM_IPPROTOCOLENDPOINTACCESS_H_
#define OPENDRIM_IPPROTOCOLENDPOINTACCESS_H_

#include "IP_Common.h"

#include "OpenDRIM_IPProtocolEndpoint.h"

int IP_OpenDRIM_IPProtocolEndpoint_load(const CMPIBroker* broker, string& errorMessage);

int IP_OpenDRIM_IPProtocolEndpoint_unload(string& errorMessage);

int IP_OpenDRIM_IPProtocolEndpoint_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_IPProtocolEndpoint>& instances, const char** properties, string& errorMessage, const string& discriminant);

int IP_OpenDRIM_IPProtocolEndpoint_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_IPProtocolEndpoint& instance, const char** properties, string& errorMessage);

int IP_OpenDRIM_IPProtocolEndpoint_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_IPProtocolEndpoint& newInstance, const OpenDRIM_IPProtocolEndpoint& oldInstance, const char** properties, string& errorMessage);

int IP_OpenDRIM_IPProtocolEndpoint_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_IPProtocolEndpoint& instance, string& errorMessage);

int IP_OpenDRIM_IPProtocolEndpoint_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_IPProtocolEndpoint& instance, string& errorMessage);

int IP_OpenDRIM_IPProtocolEndpoint_RequestStateChange(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_IPProtocolEndpoint& instance, unsigned int& returnValue, const OpenDRIM_IPProtocolEndpoint_RequestStateChange_In& in, OpenDRIM_IPProtocolEndpoint_RequestStateChange_Out& out, string& errorMessage);

int IP_OpenDRIM_IPProtocolEndpoint_BroadcastReset(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_IPProtocolEndpoint& instance, unsigned int& returnValue, string& errorMessage);

int IP_OpenDRIM_IPProtocolEndpoint_populate(OpenDRIM_IPProtocolEndpoint& instance, string& errorMessage);

#endif /*OPENDRIM_IPPROTOCOLENDPOINTACCESS_H_*/
