/* ShowDetailsAction.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.list.actions;


import java.awt.event.ActionEvent;
import javax.swing.JComponent;

import org.grinvin.invariants.InvariantValue;
import org.grinvin.invariants.InvariantValueDelegate;
import org.grinvin.list.graphs.GraphListElement;

/**
 * Action which can be used to show details for an invariant value.
 */
public class ShowDetailsAction extends AbstractInvariantValueAction {
    
    //
    public void setEnabled(InvariantValue value) {
        if (value != null && gle != null) {
            InvariantValueDelegate delegate = value.getType().getDelegate();
            setEnabled(delegate.hasDetails(value));
        } else {
            setEnabled(false);
        }
    }
    
    //
    protected void setEnabled(GraphListElement element) {
        if (element != null && iv != null) {
            InvariantValueDelegate delegate = iv.getType().getDelegate();
            setEnabled(delegate.hasDetails(iv));
        } else {
            setEnabled(false);
        }
    }
    
    //
    private int x;
    
    //
    public void setX(int x) {
        this.x = x;
    }
    
    //
    private int y;
    
    //
    public void setY(int y) {
        this.y = y;
    }
    
    //
    private JComponent comp;
    
    //
    public void setComponent(JComponent comp) {
        this.comp = comp;
    }
    
    /**
     * Create an action of this type for the given invariant value and graph list element.
     */
    public ShowDetailsAction(InvariantValue iv, GraphListElement gle) {
        super(iv, gle, "ShowDetails.description");
    }
    
    /**
     * Create an action of this type. The graph list element and invariant value to which
     * this action applies should be set later using {@link #setGraphListElement} and
     * {@link #setInvariantValue}.
     */
    public ShowDetailsAction() {
        this(null, null);
    }
    
    //
    public void actionPerformed(ActionEvent ev) {
        if (iv != null && gle != null && iv.equals(gle.getBundle().getInvariantValue(iv.getInvariant()))) {
            InvariantValueDelegate delegate = iv.getType().getDelegate();
            if (delegate.hasDetails(iv))
                delegate.showDetails(iv, gle, comp, x, y );
        }
    }
}
