/* GraphViewer.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.help;

import be.ugent.caagt.swirl.dnd.LocalTransferHandler;

import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JLabel;

import org.grinvin.gui.components.GraphComponent;
import org.grinvin.list.graphs.GraphListElement;
import org.grinvin.list.HasSelectableValues;
import org.grinvin.gui.dnd.SelectionDragHandler;

/**
 * Component for displaying a graph in the {@link InlineGraphViewer}. The image can be dragged as a
 * {@link GraphListElement }.
 */
public class GraphViewer extends GraphComponent implements MouseMotionListener, HasSelectableValues {
    
    // shared transfer handler
    private static final LocalTransferHandler TRANSFER_HANDLER;
    
    static {
        TRANSFER_HANDLER = new LocalTransferHandler();
        TRANSFER_HANDLER.setDragHandler(new SelectionDragHandler(GraphListElement.class));
    }
    
    public GraphViewer(){
        setPreferredSize(new Dimension(200, 200));
        setMinimumSize(new Dimension(200, 200));
        setVerticalTextPosition(JLabel.BOTTOM);
        addMouseMotionListener(this);
        setTransferHandler(TRANSFER_HANDLER);
    }
    
    public GraphListElement[] getSelectedValues () {
        return new GraphListElement[] { getElement() };
    }
    
    
    /*============================================================
     * DRAG SUPPORT
     *============================================================*/
    
    // implements MouseMotionListener
    public void mouseDragged(MouseEvent e) {
        // TODO: is this the way to initiate dragging?
        //if (dragEnabled) {
            TRANSFER_HANDLER.exportAsDrag(GraphViewer.this, e,
                    TRANSFER_HANDLER.COPY);
        //}
    }
    
    // implements MouseMotionListener
    public void mouseMoved(MouseEvent e) {
        // do nothing
    }
}
