/* WatermarkPainter.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;

/**
 * Paint a 'watermark' onto a component consisting of repeated text slanted at an 
 * angle of 45 degrees
 */
public class WatermarkPainter {
    
    //
    private final int fontSize;
    
    //
    private final String watermark;
    
    //
    private final Color watermarkColor;
    
    //
    private final Font font;
    
    /**
     * Create a watermark painter with the given specs.
     */
    public WatermarkPainter (int fontSize, String watermark, Color watermarkColor) {
        this.fontSize = fontSize;
        this.watermark = watermark;
        this.watermarkColor = watermarkColor;
        this.font = new Font ("SansSerif", Font.BOLD, fontSize);
        
    }
    
    /**
     * Paint the watermark onto the background of the given component.
     */
    public void paint(Component component, Graphics g) {
        int width = component.getWidth();
        int height = component.getHeight();
        
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setFont(font);
        g2.setColor(watermarkColor);
        
        g2.translate(width/2, height/2);
        g2.rotate(Math.PI/4);
        int sw = g2.getFontMetrics().stringWidth(watermark);
        int limit = (width + height)/2;
        g2.drawString(watermark, -sw/2, fontSize/2);
        for (int j=sw/2+fontSize; j < limit; j+=sw+fontSize) {
            g2.drawString(watermark, j, fontSize/2);
            g2.drawString(watermark, -j -sw, fontSize/2);
        }
        for (int i=4*fontSize; i < limit; i+= 4*fontSize) {
            g2.drawString(watermark, -sw/2, fontSize/2 + i);
            g2.drawString(watermark, -sw/2, fontSize/2 - i);
            for (int j=sw/2+fontSize; j < limit; j+=sw+fontSize) {
                g2.drawString(watermark, j, fontSize/2 + i);
                g2.drawString(watermark, -j -sw, fontSize/2 + i);
                g2.drawString(watermark, j, fontSize/2 - i);
                g2.drawString(watermark, -j -sw, fontSize/2 - i);
            }
            for (int j=fontSize/2; j < limit; j+=sw+fontSize) {
                g2.drawString(watermark, j, -3*fontSize/2 + i);
                g2.drawString(watermark, -j -sw, -3*fontSize/2 + i);
                g2.drawString(watermark, j, 5*fontSize/2 - i);
                g2.drawString(watermark, -j -sw, 5*fontSize/2 - i);
            }
        }
        
    }
    
}
