/* SnapshotAction.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.gred.actions;

import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ResourceBundle;

import org.grinvin.graphs.DefaultGraphBundle;
import org.grinvin.graphs.GraphBundle;
import org.grinvin.gred.GraphPanel;
import org.grinvin.list.graphs.GraphList;
import org.grinvin.list.graphs.GraphListElement;
import org.grinvin.list.graphs.GraphListElementManager;
import org.grinvin.util.InternationalizedProperties;

/**
 * Action that takes a snapshot of the current graph in a panel and
 * stores it into the given graph list.
 */
public class SnapshotAction extends GraphPanelAction {
    
    //
    private final GraphList graphList;
    
    //
    private int count;
    
    /**
     * Construct an action of this kind.
     */
    public SnapshotAction(GraphPanel panel, GraphList graphList) {
        super(panel);
        this.graphList = graphList;
        this.count = 1;
    }
    
    /**
     * Takes a snapshot of the current graph in a panel and
     * stores it into the given graph list.
     */
    public void actionPerformed(ActionEvent e) {

        GraphBundle graphbundle = new DefaultGraphBundle();
        //TODO init with empty properties?
        InternationalizedProperties properties = new InternationalizedProperties();
        
        ResourceBundle rbundle = ResourceBundle.getBundle ("org.grinvin.gred.editor");
        String newGraphName = MessageFormat.format(rbundle.getString("newgraphname.text"), count++);
        
        properties.setProperty("graph.name", newGraphName);
        graphbundle.setProperties(properties);
        panel.fillGraphBundle(graphbundle);
        
        GraphListElement g = GraphListElementManager.getInstance().createGraphListElement(graphbundle);
        graphList.add(g);
        
        panel.setDirty(false);
    }
    
    
    
}
