/* OtherTableModel.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.about;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

/**
 *
 */
public class OtherTableModel extends AbstractTableModel {
    
    private OtherTableModel() {
        this.rowList = new ArrayList<Pair<String, String>>();
    }
    
    //
    private static final OtherTableModel THE_TABLE_MODEL = new OtherTableModel();
    
    static {
        THE_TABLE_MODEL.addPropertyValueFor("os.name");
        THE_TABLE_MODEL.addPropertyValueFor("os.version");
        THE_TABLE_MODEL.addPropertyValueFor("os.arch");
        THE_TABLE_MODEL.addPropertyValueFor("java.vm.name");
        THE_TABLE_MODEL.addPropertyValueFor("java.vm.version");
        THE_TABLE_MODEL.addPropertyValueFor("java.vm.vendor");
    }
    
    public static OtherTableModel getInstance() {
        return THE_TABLE_MODEL;
    }
    
    //
    private final List<Pair<String, String>> rowList;
    
    public void addPropertyValueFor(String name) {
        String value = System.getProperty(name);
        if (value != null)
            rowList.add(new Pair<String, String>(name, value));
        else
            rowList.add(new Pair<String, String>(name, "<unavailable>"));
    }
    
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }
    
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0)
            return rowList.get(rowIndex).getCar();
        else if (columnIndex == 1)
            return rowList.get(rowIndex).getCdr();
        else
            throw new IndexOutOfBoundsException();
    }
    
    public int getRowCount() {
        return rowList.size();
    }
    
    public int getColumnCount() {
        return 2;
    }
    
    public String getColumnName(int column) {
        return null; // TODO: use proper names? (internationalized)
    }
    
    private static final Class<String> STRING_CLASS = String.class;
    
    public Class<?> getColumnClass(int columnIndex) {
        return STRING_CLASS;
    }
    
    private static class Pair<K,V> {
        private K car;
        private V cdr;
        public Pair(K car, V cdr) {
            this.car = car;
            this.cdr = cdr;
        }
        public K getCar() {
            return car;
        }
        public V getCdr() {
            return cdr;
        }
    }
    
}
