/*
 * $RCSfile: CollectionChangeEvent.java,v $
 *
 * Copyright (c) 2005 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * $Revision: 1.1 $
 * $Date: 2005-02-11 04:57:05 $
 * $State: Exp $
 */
package javax.media.jai;

import java.util.Collection;

/**
 * Class representing an event generated by a <code>CollectionOp</code>
 * when the wrapped <code>Collection</code> is regenerated.
 *
 * @since JAI 1.1
 */
public class CollectionChangeEvent extends PropertyChangeEventJAI {
    public CollectionChangeEvent(CollectionOp source,
				 Collection oldValue,
				 Collection newValue) {
        super(source, "Collection", oldValue, newValue);
    }
}
