/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.ImportInstanceConversionTask;
import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.cmd.CreateConversionTask;
import com.amazon.aes.webservices.client.cmd.GeneralError;
import com.amazon.aes.webservices.client.cmd.InvalidArgumentCombination;
import com.amazon.aes.webservices.client.cmd.Outputter;
import com.amazon.aes.webservices.client.vmconversion.InternalException;
import com.amazon.aes.webservices.client.vmconversion.VerificationException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import sun.misc.BASE64Encoder;

public class ImportInstance
extends CreateConversionTask {
    public static final String TASK_TYPE = "ImportInstance";
    public static final String[] AVAILABILITYZONE_DESC = new String[]{"Specifies the availability zone for the imported virtual machine. Run the", "'ec2-describe-availability-zones' command for a list of values, and", "see the latest Developer's Guide for their meanings."};
    public static final String[] INSTANCE_TYPE_DESC = new String[]{"Specifies the type of instance to be launched. Refer to the latest", "Developer's Guide for valid values. Defaults to m1.small if not supplied."};
    public static final String[] ARCHITECTURE_DESC = new String[]{"The architecture of the image; (one of i386 or x86_64)", "Defaults to i386 if --instance-type is not supplied."};
    public static final String[] USER_DATA_FILE_DESC = new String[]{"Specifies the file containing user data to be made available to", "this instance."};
    public static final String[] USER_DATA_DESC = new String[]{"Specifies the user data to be made available to this instance."};
    private static final String[] GROUP_DESC = new String[]{"Specifies the security group (or groups if specified multiple times)", "within which the instance(s) should be run. Determines the ingress", "firewall rules that will be applied to the launched instances.", "Defaults to the user's default group if not supplied."};
    public static final String GROUP_ARG = "GROUP [--group GROUP...]";
    public static final String[] SUBNET_DESC = new String[]{"If you're using Amazon Virtual Private Cloud, this specifies the ID of the", "subnet you want to launch the instance into."};
    public static final String[] PRIVATE_IP_DESC = new String[]{"If you're using Amazon Virtual Private Cloud, you can optionally use this ", "parameter to assign the instance a specific available IP address from the", "subnet."};
    public static final String PRIVATE_IP = "private-ip-address";
    public static final String PRIVATE_IP_ARG = "ip_address";
    public static final String[] INSTANCE_INITIATED_SHUTDOWN_BEHAVIOR_DESC = new String[]{"Indicates what the instance(s) should do if an instance shutdown is", "issued. The following values are supported:", "", " - 'stop': indicates that the instance should move into the stopped", "    state and remain available to be restarted.", "", " - 'terminate': indicates that the instance should move into the", "    terminated state."};
    public static final String[] MONITORING_DESC = new String[]{"Enables monitoring of the specified instance(s)."};
    public static final String[] PLATFORM_DESC = new String[]{"Specifies the platform of the virtual machine. See the Developer's", "Guide to see the supported values. Defaults to Windows."};
    String arch;
    String instanceType;
    String userData;
    List<String> groupSet;
    String subnet;
    String shutdownBehavior;
    String platform;
    boolean monitoring;
    String privateIpAddress;

    public ImportInstance(String[] args) {
        super("ec2iin", new String[]{"ec2ii", "ec2-import-instance"});
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    protected Options getOptions() {
        Options options = super.getOptions();
        OptionBuilder.withLongOpt((String)"availability-zone");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"ZONE");
        OptionBuilder.withDescription((String)ImportInstance.joinDescription(AVAILABILITYZONE_DESC));
        options.addOption(OptionBuilder.create((String)"z"));
        OptionBuilder.withLongOpt((String)"instance-type");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"INSTANCETYPE");
        OptionBuilder.withDescription((String)ImportInstance.joinDescription(INSTANCE_TYPE_DESC));
        options.addOption(OptionBuilder.create((String)"t"));
        OptionBuilder.withLongOpt((String)"architecture");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"ARCHITECTURE");
        OptionBuilder.withDescription((String)ImportInstance.joinDescription(ARCHITECTURE_DESC));
        options.addOption(OptionBuilder.create((String)"a"));
        OptionBuilder.withLongOpt((String)"user-data");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"USERDATA");
        OptionBuilder.withDescription((String)ImportInstance.joinDescription(USER_DATA_DESC));
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"user-data-file");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"DATA-FILE");
        OptionBuilder.withDescription((String)ImportInstance.joinDescription(USER_DATA_FILE_DESC));
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"group");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)GROUP_ARG);
        OptionBuilder.withDescription((String)ImportInstance.joinDescription(GROUP_DESC));
        options.addOption(OptionBuilder.create((String)"g"));
        OptionBuilder.withLongOpt((String)"instance-initiated-shutdown-behavior");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"BEHAVIOR");
        OptionBuilder.withDescription((String)ImportInstance.joinDescription(INSTANCE_INITIATED_SHUTDOWN_BEHAVIOR_DESC));
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)PRIVATE_IP);
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)PRIVATE_IP_ARG);
        OptionBuilder.withDescription((String)ImportInstance.joinDescription(PRIVATE_IP_DESC));
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"platform");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"PLATFORM");
        OptionBuilder.withDescription((String)ImportInstance.joinDescription(PLATFORM_DESC));
        options.addOption(OptionBuilder.create((String)"p"));
        OptionBuilder.withLongOpt((String)"subnet");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"SUBNET");
        OptionBuilder.withDescription((String)ImportInstance.joinDescription(SUBNET_DESC));
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"monitor");
        OptionBuilder.withDescription((String)ImportInstance.joinDescription(MONITORING_DESC));
        options.addOption(OptionBuilder.create());
        return options;
    }

    public void printOptions() {
        super.printOptions(true);
        this.printOption("instance-type");
        this.printOption("group");
        this.printOption("format");
        this.printOption("architecture");
        this.printOption("platform");
        this.printOption("bucket");
        this.printOption("owner-akid");
        this.printOption("owner-sak");
        this.printOption("prefix");
        this.printOption("manifest-url");
        this.printOption("volume-size");
        this.printOption("availability-zone");
        this.printOption("description");
        this.printOption("user-data");
        this.printOption("user-data-file");
        this.printOption("subnet");
        this.printOption(PRIVATE_IP);
        this.printOption("monitor");
        this.printOption("instance-initiated-shutdown-behavior");
        this.printOption("expires");
        this.printOption("ignore-region-affinity");
        this.printOption("user-threads");
        this.printOption("dry-run");
        this.printOption("dont-verify-format");
        this.printOption("no-upload");
    }

    public void printDescription() {
        super.printDescription();
        System.out.println("     Create an import instance task to import a virtual machine into EC2");
        System.out.println("     using meta-data from the given disk image. The volume size for the ");
        System.out.println("     imported disk-image will be calculated automatically, unless specified.");
    }

    protected void validateMyParameters() throws IOException, GeneralError, VerificationException {
        super.validateParameters();
        String string = this.az = this.isOptionSet("availability-zone") ? this.getOptionValue("availability-zone") : null;
        if (this.isOptionSet("instance-type")) {
            this.instanceType = this.getOptionValue("instance-type");
            this.assertOptionSet("architecture");
            this.arch = this.getOptionValue("architecture");
        } else {
            this.instanceType = "m1.small";
            this.arch = "i386";
        }
        this.platform = this.isOptionSet("platform") ? this.getOptionValue("platform") : "Windows";
        this.userData = null;
        if (this.isOptionSet("user-data") && this.isOptionSet("user-data-file")) {
            throw new InvalidArgumentCombination("You may not specify both user data on the command line and a file containing user data.");
        }
        if (this.isOptionSet("user-data")) {
            this.userData = this.getUserData(this.getOptionValue("user-data"));
        } else if (this.isOptionSet("user-data-file")) {
            this.userData = this.getUserDataFile(this.getOptionValue("user-data-file"));
        }
        this.groupSet = Arrays.asList(this.getOptionValues("group"));
        this.shutdownBehavior = this.getOptionValue("instance-initiated-shutdown-behavior");
        this.subnet = this.getOptionValue("subnet");
        this.privateIpAddress = this.getOptionValue(PRIVATE_IP);
        this.monitoring = this.isOptionSet("monitor");
    }

    private String getUserData(String str) {
        String base64 = new BASE64Encoder().encodeBuffer(str.getBytes());
        return base64.replaceAll("\\s", "");
    }

    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        try {
            this.validateMyParameters();
            if (this.dryRun) {
                return true;
            }
            this.createSignedManifestUrl();
            long diskImageSize = this.image.length();
            this.task = jec2.importInstance(this.az, this.description, this.instanceType, this.arch, this.platform, this.userData, this.groupSet, this.shutdownBehavior, this.subnet, this.privateIpAddress, Boolean.valueOf(this.monitoring), this.diskImageFormat, this.signedManifestUrl, diskImageSize, this.volumeSize);
            ImportInstanceConversionTask impi_task = this.task.getImportInstanceConversionTask();
            out.output(System.out, this.task, impi_task, false);
            if (this.noUpload) {
                return true;
            }
            return this.invokeUpload();
        }
        catch (VerificationException e) {
            System.err.println("ERROR: " + e.getMessage());
            return false;
        }
        catch (InternalException e) {
            System.err.println("ERROR: " + e.getMessage());
            return false;
        }
    }

    public static void main(String[] args) {
        new ImportInstance(args).invoke();
    }
}

