/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.VpnGatewayAttachmentDescription;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class DetachVpnGateway
extends BaseCmd {
    private static final String VPN_GATEWAY_DESC = "The ID of the VPN gateway you want to detach from the VPC.";
    private static final String VPC_DESC = "The ID of the VPC you want to detach the VPN gateway from.";
    private String vpnGatewayId;
    private String vpcId;

    public DetachVpnGateway(String[] args) {
        super("ec2detvgw", "ec2-detach-vpn-gateway");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    protected String getOptionString() {
        return "VPN_GATEWAY -c VPC";
    }

    private Options getOptions() {
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"vpc");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"VPC");
        OptionBuilder.withDescription((String)this.joinDescription(VPC_DESC));
        options.addOption(OptionBuilder.create((String)"c"));
        return options;
    }

    public void printDescription() {
        super.printDescription();
        System.out.println("     Detaches a VPN gateway from a VPC. The VPN_GATEWAY parameter is the VPN");
        System.out.println("     gateway you want to detach from the VPC.");
    }

    public void printOptions() {
        super.printOptions(true);
        this.printOption("vpc");
    }

    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        this.validateParameters();
        this.vpnGatewayId = this.getNonOptions()[0];
        this.vpcId = this.getOptionValue("vpc");
        RequestResultPair rsp = jec2.detachVpnGateway(this.vpcId, this.vpnGatewayId);
        if (((Boolean)rsp.getResponse()).booleanValue()) {
            out.output(System.out, new VpnGatewayAttachmentDescription(this.vpcId, "detaching"));
        }
        out.printRequestId(System.out, (RequestResult)rsp);
        return (Boolean)rsp.getResponse();
    }

    protected void parseOpts(String[] args) {
        super.parseOpts(args);
    }

    protected void validateParameters() {
        this.assertNonOptionSet("VPN_GATEWAY");
        this.warnIfTooManyNonOptions();
        this.assertOptionSet("vpc");
    }

    public static void main(String[] args) {
        new DetachVpnGateway(args).invoke();
    }
}

