<?php
  /*
   This file is  part of phpWebApp, which is  a framework for building
   web application based on relational databases.

   Copyright 2001, 2002, 2003, 2004, 2005, 2006, 2007
   Dashamir Hoxha, dashohoxha@users.sourceforge.net

   phpWebApp is  free software; you can redistribute  it and/or modify
   it under the  terms of the GNU General  Public License as published
   by the Free  Software Foundation; either version 2  of the License,
   or (at your option) any later version.

   phpWebApp is  distributed in the hope  that it will  be useful, but
   WITHOUT  ANY  WARRANTY;  without   even  the  implied  warranty  of
   MERCHANTABILITY or  FITNESS FOR A PARTICULAR PURPOSE.   See the GNU
   General Public License for more details.

   You should have  received a copy of the  GNU General Public License
   along  with   phpWebApp;  if  not,  write  to   the  Free  Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
   USA
  */


  /**
   * @package     webobjects
   * @subpackage  dbTable
   */
class table extends WebObject
{
  function onRender()
  {
    //get the name of the table
    $table = $this->params["table"]; 
    $table = WebApp::replaceVars($table);
    $fields = $this->params["fields"];
    $where = $this->params["where"];
    $where = WebApp::replaceVars($where);

    //get the recordset "{{table}}->fields"
    $arr_fields = explode(",", $fields);
    $table_fields = new EditableRS($table."->fields");
    $rs = WebApp::execQuery("SHOW FIELDS FROM $table");
    while (!$rs->EOF())
      {
        $fld_name = $rs->Field("Field");
        $rec = array("fld_name"=>$fld_name);
        if ($fields=="*")
          {
            $table_fields->addRec($rec);
          }
        else if (in_array($fld_name, $arr_fields))
          {
            $table_fields->addRec($rec);
          }

        $rs->MoveNext();
      }

    //get the recordset "{{table}}->records"
    $id = $table."->records";
    if ($where<>"")  $where = "WHERE $where";
    $query = "SELECT $fields FROM $table $where";
    $table_records = new EditableRS($id, $query);
    $table_records->Open();

    //add the recordsets to $webPage
    global $webPage;
    $webPage->addRecordset($table_fields);
    $webPage->addRecordset($table_records);
  }
}
?>