#ifndef DATABASE_H
#define DATABASE_H

#include <stdio.h>


//========================================================================
// $Id: database.h,v 1.5 2001/03/11 05:21:32 radnev Exp $
//========================================================================


class Database {

public:
	Database();
	~Database();
	bool createDictionary(const char *fileName, const long fixedLastWordPointer = 0);
	bool findWord(const char *word, char **result);
	char *getWord();
	char *getResult();
	char *getNextRandomWord();
	bool goToNextWord();
	void goToFirstWord();
	void goToLastWord();

private:
	static const int  MAX_WORD_LEN;
	static const int  MAX_DATA_LEN;
	static const char WORD_SEPARATOR;
	static const char DATA_SEPARATOR;
	static const char NON_ALPHA_CHARS[];

	FILE *dataFile;
	char *dataBuffer;
	char *wordBuffer;
	char *compBuffer;
	long firstWordPointer;
	long lastWordPointer;
	long lastSearchWordPointer;
	long currentWordPointer;

	void onlyLetters(const char *word);
	void readData();

}; // End of class Database

#endif
