/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.evpull;

import java.io.File;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.TreeReceiver;
import net.sf.saxon.evpull.Decomposer;
import net.sf.saxon.evpull.EndDocumentEvent;
import net.sf.saxon.evpull.EndElementEvent;
import net.sf.saxon.evpull.EventIterator;
import net.sf.saxon.evpull.EventIteratorToReceiver;
import net.sf.saxon.evpull.EventStackIterator;
import net.sf.saxon.evpull.PullEvent;
import net.sf.saxon.evpull.SingletonEventIterator;
import net.sf.saxon.evpull.StartDocumentEvent;
import net.sf.saxon.evpull.StartElementEvent;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.query.QueryResult;
import net.sf.saxon.tinytree.TinyBuilder;
import net.sf.saxon.trans.XPathException;

public class SequenceComposer
implements SequenceIterator {
    private EventIterator base;
    private int position = 0;
    private Item current = null;
    private PipelineConfiguration pipe;

    public SequenceComposer(EventIterator iter, PipelineConfiguration pipe) {
        this.base = EventStackIterator.flatten(iter);
        this.pipe = pipe;
    }

    public Item next() throws XPathException {
        PullEvent pe = this.base.next();
        if (pe == null) {
            this.position = -1;
            this.current = null;
            return null;
        }
        if (pe instanceof Item) {
            this.current = (Item)pe;
            ++this.position;
            return this.current;
        }
        if (pe instanceof StartDocumentEvent || pe instanceof StartElementEvent) {
            SubtreeIterator sub = new SubtreeIterator(this.base, pe);
            TinyBuilder builder = new TinyBuilder();
            builder.setPipelineConfiguration(this.pipe);
            TreeReceiver receiver = new TreeReceiver(builder);
            builder.setPipelineConfiguration(this.pipe);
            EventIteratorToReceiver.copy(sub, receiver);
            this.current = builder.getCurrentRoot();
            ++this.position;
            return this.current;
        }
        throw new IllegalStateException(pe.getClass().getName());
    }

    public Item current() {
        return this.current;
    }

    public SequenceIterator getAnother() throws XPathException {
        throw new UnsupportedOperationException("getAnother");
    }

    public int getProperties() {
        return 0;
    }

    public int position() {
        return this.position;
    }

    public static void main(String[] args) throws Exception {
        NodeInfo item;
        Configuration config = new Configuration();
        DocumentInfo doc = config.buildDocument(new StreamSource(new File("c:/MyJava/samples/data/books.xml")));
        Decomposer e = new Decomposer(new SingletonEventIterator(doc), config);
        SequenceComposer iter = new SequenceComposer(e, config.makePipelineConfiguration());
        while ((item = (NodeInfo)iter.next()) != null) {
            System.out.println(QueryResult.serialize(item));
        }
    }

    private static class SubtreeIterator
    implements EventIterator {
        private int level = 0;
        private EventIterator base;
        private PullEvent first;

        public SubtreeIterator(EventIterator base, PullEvent first) {
            this.base = base;
            this.first = first;
        }

        public PullEvent next() throws XPathException {
            if (this.first != null) {
                PullEvent pe = this.first;
                this.first = null;
                return pe;
            }
            if (this.level < 0) {
                return null;
            }
            PullEvent pe = this.base.next();
            if (pe instanceof StartElementEvent || pe instanceof StartDocumentEvent) {
                ++this.level;
            } else if (pe instanceof EndElementEvent || pe instanceof EndDocumentEvent) {
                --this.level;
            }
            return pe;
        }

        public boolean isFlatSequence() {
            return this.base.isFlatSequence();
        }
    }
}

