/*
 * Copyright (C) 2016 Canonical, Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef MIR_MOCK_H
#define MIR_MOCK_H

#include <unity/shell/application/Mir.h>

class MirMock : public ::Mir
{
    Q_OBJECT
public:
    explicit MirMock();
    virtual ~MirMock();

    static MirMock *instance();

    void setCursorName(const QString &cursorName) override;
    QString cursorName() const override;

private:
    static MirMock *the_mir;
    QString m_cursorName;
};

#endif
