// -*- Mode: C++; indent-tabs-mode: nil; tab-width: 2 -*-
/*
 * Copyright (C) 2010 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Jason Smith <jason.smith@canonical.com>
 */

#include "DesktopLauncherIcon.h"
#include "WindowManager.h"

#include <glib/gi18n-lib.h>

namespace unity
{
namespace launcher
{

DesktopLauncherIcon::DesktopLauncherIcon()
  :   SimpleLauncherIcon()
  ,   show_in_switcher_(true)
{
  tooltip_text = _("Show Desktop");
  icon_name = "desktop";
  SetQuirk(QUIRK_VISIBLE, true);
  SetQuirk(QUIRK_RUNNING, false);
  SetIconType(TYPE_BEGIN);
  SetShowInSwitcher(false);
}

DesktopLauncherIcon::~DesktopLauncherIcon()
{
}

void
DesktopLauncherIcon::ActivateLauncherIcon(ActionArg arg)
{
  SimpleLauncherIcon::ActivateLauncherIcon(arg);
  WindowManager::Default()->ShowDesktop();
}

std::string DesktopLauncherIcon::GetName() const
{
  return "DesktopLauncherIcon";
}

} // namespace launcher
} // namespace unity
