/*
 * Copyright (C) 2010 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Mikkel Kamstrup Erlandsen <mikkel.kamstrup@canonical.com>
 *
 */
using Dee;
using Config;
using Gee;

namespace Unity.MusicLens {
  
  const string ICON_PATH = "/usr/share/icons/unity-icon-theme/places/svg/";
  
  public class Daemon : GLib.Object
  {
    private Unity.Lens lens;
    private BansheeScopeProxy banshee;
    private RhythmboxScope rb;
     
    construct
    {
      lens = new Unity.Lens("/com/canonical/unity/lens/music", "music");
      lens.search_in_global = true;
      lens.search_hint = _("Search Music Collection");
      lens.sources_display_name = _("Sources");
      lens.visible = true;
      
      populate_categories ();
      populate_filters();

      var app_check = new DesktopAppInfo ("banshee.desktop");
      if (app_check != null)
      {
        banshee = new BansheeScopeProxy ();
        lens.add_local_scope (banshee.scope);
      }

      app_check = new DesktopAppInfo ("rhythmbox.desktop");
      if (app_check != null)
      {
        rb = new RhythmboxScope ();
        lens.add_local_scope (rb.scope);
      }

      try {
        lens.export ();
      } catch (GLib.IOError e) {
        stdout.printf ("error %s\n", e.message);
      }
    }

    private void populate_filters ()
    {
      var filters = new GLib.List<Unity.Filter> ();

      /* Decade filter */
      {
        var filter = new MultiRangeFilter ("decade", _("Decade"));

        filter.add_option ("0", _("Old"));
        filter.add_option ("1960", _("60s"));
        filter.add_option ("1970", _("70s"));
        filter.add_option ("1980", _("80s"));
	filter.add_option ("1990", _("90s"));
        filter.add_option ("2000", _("00s"));
        filter.add_option ("2010", _("10s"));

        filters.append (filter);
      }

      /* Genre filter */
      {
        var filter = new CheckOptionFilterCompact ("genre", _("Genre"));
        filter.sort_type = OptionsFilter.SortType.DISPLAY_NAME;

        filter.add_option (Genre.BLUES_ID, _("Blues"));
        filter.add_option (Genre.CLASSIC_ID, _("Classic"));
        filter.add_option (Genre.COUNTRY_ID, _("Country"));
        filter.add_option (Genre.DISCO_ID, _("Disco"));
        filter.add_option (Genre.FUNK_ID, _("Funk"));
        filter.add_option (Genre.ROCK_ID, _("Rock"));
        filter.add_option (Genre.METAL_ID, _("Metal"));
        filter.add_option (Genre.HIPHOP_ID, _("Hip-hop"));
        filter.add_option (Genre.HOUSE_ID, _("House"));
        filter.add_option (Genre.NEWWAVE_ID, _("New-wave"));
        filter.add_option (Genre.RANDB_ID, _("R&B"));
        filter.add_option (Genre.PUNK_ID, _("Punk"));
        filter.add_option (Genre.JAZZ_ID, _("Jazz"));
        filter.add_option (Genre.POP_ID, _("Pop"));
        filter.add_option (Genre.REGGAE_ID, _("Reggae"));
        filter.add_option (Genre.SOUL_ID, _("Soul"));
        filter.add_option (Genre.TECHNO_ID, _("Techno"));
        filter.add_option (Genre.OTHER_ID, _("Other"));

        filters.append (filter);
      }

      lens.filters = filters;
    }

    // FIXME icons
    private void populate_categories ()
    {
      /* Offsets of categories must match up with the Category enum */
      
      var categories = new GLib.List<Unity.Category> ();
      var icon_dir = File.new_for_path (ICON_PATH);

      var cat = new Unity.Category (_("Songs"),
                                    new FileIcon (icon_dir.get_child ("group-songs.svg")));
      categories.append (cat);

      cat =  new Unity.Category (_("Albums"),
                                 new FileIcon (icon_dir.get_child ("group-albums.svg")));
      categories.append (cat);

      cat = new Unity.Category (_("Available for Purchase"),
                                new FileIcon (icon_dir.get_child ("group-purchase.svg")));
      categories.append (cat);
      
      cat = new Unity.Category (_("Music"),
                                new FileIcon (icon_dir.get_child ("group-songs.svg")));
      categories.append (cat);

      lens.categories = categories;
    }
  }
} /* namespace */

