/* daemon.c generated by valac 0.14.2, the Vala compiler
 * generated from daemon.vala, do not modify */

/*
 * Copyright (C) 2010 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Mikkel Kamstrup Erlandsen <mikkel.kamstrup@canonical.com>
 *             Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <unity-package-search.h>
#include <zeitgeist.h>
#include <gee.h>
#include <unity-ratings-db.h>
#include <unity.h>
#include <gio/gio.h>
#include <gnome-menus/gmenu-tree.h>
#include <glib/gi18n-lib.h>
#include <dee.h>
#include <glib/gstdio.h>
#include <float.h>
#include <math.h>


#define UNITY_APPLICATIONS_LENS_TYPE_DAEMON (unity_applications_lens_daemon_get_type ())
#define UNITY_APPLICATIONS_LENS_DAEMON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_APPLICATIONS_LENS_TYPE_DAEMON, UnityApplicationsLensDaemon))
#define UNITY_APPLICATIONS_LENS_DAEMON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_APPLICATIONS_LENS_TYPE_DAEMON, UnityApplicationsLensDaemonClass))
#define UNITY_APPLICATIONS_LENS_IS_DAEMON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_APPLICATIONS_LENS_TYPE_DAEMON))
#define UNITY_APPLICATIONS_LENS_IS_DAEMON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_APPLICATIONS_LENS_TYPE_DAEMON))
#define UNITY_APPLICATIONS_LENS_DAEMON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_APPLICATIONS_LENS_TYPE_DAEMON, UnityApplicationsLensDaemonClass))

typedef struct _UnityApplicationsLensDaemon UnityApplicationsLensDaemon;
typedef struct _UnityApplicationsLensDaemonClass UnityApplicationsLensDaemonClass;
typedef struct _UnityApplicationsLensDaemonPrivate UnityApplicationsLensDaemonPrivate;

#define UNITY_APPLICATIONS_LENS_TYPE_RUNNER (unity_applications_lens_runner_get_type ())
#define UNITY_APPLICATIONS_LENS_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_APPLICATIONS_LENS_TYPE_RUNNER, UnityApplicationsLensRunner))
#define UNITY_APPLICATIONS_LENS_RUNNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_APPLICATIONS_LENS_TYPE_RUNNER, UnityApplicationsLensRunnerClass))
#define UNITY_APPLICATIONS_LENS_IS_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_APPLICATIONS_LENS_TYPE_RUNNER))
#define UNITY_APPLICATIONS_LENS_IS_RUNNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_APPLICATIONS_LENS_TYPE_RUNNER))
#define UNITY_APPLICATIONS_LENS_RUNNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_APPLICATIONS_LENS_TYPE_RUNNER, UnityApplicationsLensRunnerClass))

typedef struct _UnityApplicationsLensRunner UnityApplicationsLensRunner;
typedef struct _UnityApplicationsLensRunnerClass UnityApplicationsLensRunnerClass;

#define UNITY_APPLICATIONS_LENS_TYPE_APP_WATCHER (unity_applications_lens_app_watcher_get_type ())
#define UNITY_APPLICATIONS_LENS_APP_WATCHER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_APPLICATIONS_LENS_TYPE_APP_WATCHER, UnityApplicationsLensAppWatcher))
#define UNITY_APPLICATIONS_LENS_APP_WATCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_APPLICATIONS_LENS_TYPE_APP_WATCHER, UnityApplicationsLensAppWatcherClass))
#define UNITY_APPLICATIONS_LENS_IS_APP_WATCHER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_APPLICATIONS_LENS_TYPE_APP_WATCHER))
#define UNITY_APPLICATIONS_LENS_IS_APP_WATCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_APPLICATIONS_LENS_TYPE_APP_WATCHER))
#define UNITY_APPLICATIONS_LENS_APP_WATCHER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_APPLICATIONS_LENS_TYPE_APP_WATCHER, UnityApplicationsLensAppWatcherClass))

typedef struct _UnityApplicationsLensAppWatcher UnityApplicationsLensAppWatcher;
typedef struct _UnityApplicationsLensAppWatcherClass UnityApplicationsLensAppWatcherClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _unity_package_searcher_free0(var) ((var == NULL) ? NULL : (var = (unity_package_searcher_free (var), NULL)))
#define _unity_ratings_database_free0(var) ((var == NULL) ? NULL : (var = (unity_ratings_database_free (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _gmenu_tree_unref0(var) ((var == NULL) ? NULL : (var = (gmenu_tree_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _UnityApplicationsLensDaemonDispatchSearchData UnityApplicationsLensDaemonDispatchSearchData;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _UnityApplicationsLensDaemonUpdatePopularitiesData UnityApplicationsLensDaemonUpdatePopularitiesData;

#define UNITY_APPLICATIONS_LENS_TYPE_CATEGORY (unity_applications_lens_category_get_type ())
#define _unity_package_search_result_free0(var) ((var == NULL) ? NULL : (var = (unity_package_search_result_free (var), NULL)))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
typedef struct _UnityApplicationsLensDaemonUpdateScopeSearchData UnityApplicationsLensDaemonUpdateScopeSearchData;
typedef struct _UnityApplicationsLensDaemonUpdateGlobalSearchData UnityApplicationsLensDaemonUpdateGlobalSearchData;
typedef struct _UnityApplicationsLensDaemonUpdateGlobalWithoutSearchData UnityApplicationsLensDaemonUpdateGlobalWithoutSearchData;
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))

struct _UnityApplicationsLensDaemon {
	GObject parent_instance;
	UnityApplicationsLensDaemonPrivate * priv;
	UnityPackageSearcher* appsearcher;
};

struct _UnityApplicationsLensDaemonClass {
	GObjectClass parent_class;
};

struct _UnityApplicationsLensDaemonPrivate {
	ZeitgeistLog* log;
	ZeitgeistIndex* zg_index;
	ZeitgeistMonitor* monitor;
	GeeMap* popularity_map;
	gboolean popularities_dirty;
	UnityPackageSearcher* pkgsearcher;
	UnityRatingsDatabase* ratings;
	UnityLens* lens;
	UnityScope* scope;
	UnityApplicationsLensRunner* runner;
	UnityFilterOption* local_apps_option;
	UnityFilterOption* usc_apps_option;
	GHashTable* type_queries;
	GeeList* image_extensions;
	GHashTable* file_icon_cache;
	UnityLauncherFavorites* favorite_apps;
	UnityApplicationsLensAppWatcher* app_watcher;
	GPtrArray* zg_templates;
	guint app_menu_changed_reindex_timeout;
	GMenuTree* app_menu;
	GRegex* uri_regex;
	GRegex* mountable_regex;
	GSettings* gp_settings;
	gboolean _display_recent_apps;
	gboolean _display_available_apps;
};

struct _UnityApplicationsLensDaemonDispatchSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityApplicationsLensDaemon* self;
	UnityLensSearch* lens_search;
	UnitySearchType search_type;
	GCancellable* cancellable;
	gboolean _tmp0_;
	GCancellable* _tmp1_;
	gboolean _tmp2_;
	UnitySearchType _tmp3_;
	UnityLensSearch* _tmp4_;
	GCancellable* _tmp5_;
	UnityLensSearch* _tmp6_;
	GCancellable* _tmp7_;
};

struct _UnityApplicationsLensDaemonUpdatePopularitiesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityApplicationsLensDaemon* self;
	gint64 _tmp0_;
	gint64 end_ts;
	gint64 _tmp1_;
	gint64 _tmp2_;
	gint64 start_ts;
	ZeitgeistLog* _tmp3_;
	gint64 _tmp4_;
	gint64 _tmp5_;
	ZeitgeistTimeRange* _tmp6_;
	ZeitgeistTimeRange* _tmp7_;
	GPtrArray* _tmp8_;
	GPtrArray* _tmp9_;
	ZeitgeistResultSet* _tmp10_;
	ZeitgeistResultSet* _tmp11_;
	ZeitgeistResultSet* rs;
	gint relevancy;
	ZeitgeistResultSet* _tmp12_;
	ZeitgeistResultSet* _tmp13_;
	ZeitgeistResultSet* _event_it;
	ZeitgeistEvent* event;
	ZeitgeistResultSet* _tmp14_;
	ZeitgeistEvent* _tmp15_;
	ZeitgeistEvent* _tmp16_;
	gint i;
	gboolean _tmp17_;
	gboolean _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	ZeitgeistEvent* _tmp21_;
	gint _tmp22_;
	ZeitgeistEvent* _tmp23_;
	gint _tmp24_;
	ZeitgeistSubject* _tmp25_;
	const gchar* _tmp26_;
	const gchar* uri;
	const gchar* _tmp27_;
	GeeMap* _tmp28_;
	const gchar* _tmp29_;
	gint _tmp30_;
	gint _tmp31_;
	GError* err;
	GError* _tmp32_;
	const gchar* _tmp33_;
	GError * _inner_error_;
};

typedef enum  {
	UNITY_APPLICATIONS_LENS_CATEGORY_RECENT,
	UNITY_APPLICATIONS_LENS_CATEGORY_RECENT_APPS,
	UNITY_APPLICATIONS_LENS_CATEGORY_INSTALLED,
	UNITY_APPLICATIONS_LENS_CATEGORY_AVAILABLE,
	UNITY_APPLICATIONS_LENS_CATEGORY_APPLICATIONS
} UnityApplicationsLensCategory;

struct _UnityApplicationsLensDaemonUpdateScopeSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityApplicationsLensDaemon* self;
	UnityLensSearch* search;
	GCancellable* cancellable;
	UnityLensSearch* _tmp0_;
	DeeSerializableModel* _tmp1_;
	DeeSerializableModel* _tmp2_;
	DeeSerializableModel* _tmp3_;
	DeeSerializableModel* model;
	UnityLensSearch* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	UnityScope* _tmp7_;
	UnityFilter* _tmp8_;
	UnityOptionsFilter* filter;
	UnityLensSearch* _tmp9_;
	UnityOptionsFilter* _tmp10_;
	gchar* _tmp11_;
	gchar* pkg_search_string;
	UnityLensSearch* _tmp12_;
	gboolean _tmp13_;
	gboolean has_search;
	GTimer* _tmp14_;
	GTimer* timer;
	DeeSerializableModel* _tmp15_;
	DeeTransaction* _tmp16_;
	DeeTransaction* transaction;
	DeeTransaction* _tmp17_;
	GeeHashSet* _tmp18_;
	GeeSet* installed_uris;
	GeeHashSet* _tmp19_;
	GeeSet* available_uris;
	UnityPackageSort _tmp20_;
	gboolean _tmp21_;
	UnityPackageSearcher* _tmp22_;
	const gchar* _tmp23_;
	UnityPackageSort _tmp24_;
	UnityPackageSearchResult* _tmp25_;
	UnityPackageSearchResult* appresults;
	gboolean _tmp26_;
	gboolean _tmp27_;
	UnityPackageSearchResult* _tmp28_;
	UnityPackageSearchResult* _tmp29_;
	GeeSet* _tmp30_;
	GeeSet* _tmp31_;
	DeeTransaction* _tmp32_;
	GTimer* _tmp33_;
	UnityPackageSearchResult* _tmp34_;
	gint _tmp35_;
	GTimer* _tmp36_;
	gdouble _tmp37_;
	const gchar* _tmp38_;
	gboolean _tmp39_;
	gboolean _tmp40_;
	gboolean _tmp41_;
	gboolean _tmp42_;
	GTimer* _tmp43_;
	UnityOptionsFilter* _tmp44_;
	gchar* _tmp45_;
	gchar* zg_search_string;
	ZeitgeistIndex* _tmp46_;
	const gchar* _tmp47_;
	ZeitgeistTimeRange* _tmp48_;
	ZeitgeistTimeRange* _tmp49_;
	GPtrArray* _tmp50_;
	GPtrArray* _tmp51_;
	GCancellable* _tmp52_;
	ZeitgeistResultSet* _tmp53_;
	ZeitgeistResultSet* _tmp54_;
	ZeitgeistResultSet* results;
	ZeitgeistResultSet* _tmp55_;
	DeeTransaction* _tmp56_;
	GeeSet* _tmp57_;
	GTimer* _tmp58_;
	ZeitgeistResultSet* _tmp59_;
	guint _tmp60_;
	ZeitgeistResultSet* _tmp61_;
	guint _tmp62_;
	GTimer* _tmp63_;
	gdouble _tmp64_;
	const gchar* _tmp65_;
	GError* ioe;
	GError* e;
	UnityLensSearch* _tmp66_;
	const gchar* _tmp67_;
	const gchar* _tmp68_;
	GError* _tmp69_;
	const gchar* _tmp70_;
	DeeTransaction* _tmp71_;
	gboolean _tmp72_;
	gboolean _tmp73_;
	gboolean _tmp74_;
	gboolean _tmp75_;
	gboolean _tmp76_;
	UnityPackageSearcher* _tmp77_;
	gboolean _tmp78_;
	gboolean _tmp79_;
	GTimer* _tmp80_;
	UnityPackageSearcher* _tmp81_;
	const gchar* _tmp82_;
	UnityPackageSearchResult* _tmp83_;
	UnityPackageSearchResult* pkgresults;
	UnityPackageSearchResult* _tmp84_;
	GeeSet* _tmp85_;
	GeeSet* _tmp86_;
	DeeSerializableModel* _tmp87_;
	GTimer* _tmp88_;
	UnityPackageSearchResult* _tmp89_;
	gint _tmp90_;
	GTimer* _tmp91_;
	gdouble _tmp92_;
	const gchar* _tmp93_;
	GTimer* _tmp94_;
	UnityLensSearch* _tmp95_;
	UnityOptionsFilter* _tmp96_;
	gchar* _tmp97_;
	gchar* filter_query;
	UnityPackageSearcher* _tmp98_;
	const gchar* _tmp99_;
	UnityPackageSearchResult* _tmp100_;
	UnityPackageSearchResult* random_pkgresults;
	UnityPackageSearchResult* _tmp101_;
	GeeSet* _tmp102_;
	GeeSet* _tmp103_;
	DeeSerializableModel* _tmp104_;
	GTimer* _tmp105_;
	UnityPackageSearchResult* _tmp106_;
	gint _tmp107_;
	GTimer* _tmp108_;
	gdouble _tmp109_;
	DeeSerializableModel* _tmp110_;
	guint _tmp111_;
	UnityLensSearch* _tmp112_;
	const gchar* _tmp113_;
	GVariant* _tmp114_;
	UnityLensSearch* _tmp115_;
	GError * _inner_error_;
};

struct _UnityApplicationsLensDaemonUpdateGlobalSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityApplicationsLensDaemon* self;
	UnityLensSearch* search;
	GCancellable* cancellable;
	UnityLensSearch* _tmp0_;
	gboolean _tmp1_;
	UnityLensSearch* _tmp2_;
	GCancellable* _tmp3_;
	UnityLensSearch* _tmp4_;
	DeeSerializableModel* _tmp5_;
	DeeSerializableModel* _tmp6_;
	DeeSerializableModel* _tmp7_;
	DeeSerializableModel* model;
	DeeSerializableModel* _tmp8_;
	UnityLensSearch* _tmp9_;
	gchar* _tmp10_;
	gchar* search_string;
	GeeHashSet* _tmp11_;
	GeeSet* installed_uris;
	GeeHashSet* _tmp12_;
	GeeSet* available_uris;
	GTimer* _tmp13_;
	GTimer* timer;
	UnityPackageSearcher* _tmp14_;
	const gchar* _tmp15_;
	UnityPackageSearchResult* _tmp16_;
	UnityPackageSearchResult* appresults;
	UnityPackageSearchResult* _tmp17_;
	UnityPackageSearchResult* _tmp18_;
	GeeSet* _tmp19_;
	GeeSet* _tmp20_;
	DeeSerializableModel* _tmp21_;
	GTimer* _tmp22_;
	UnityPackageSearchResult* _tmp23_;
	gint _tmp24_;
	GTimer* _tmp25_;
	gdouble _tmp26_;
	const gchar* _tmp27_;
	UnityLensSearch* _tmp28_;
};

struct _UnityApplicationsLensDaemonUpdateGlobalWithoutSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityApplicationsLensDaemon* self;
	UnityLensSearch* search;
	GCancellable* cancellable;
	UnityLensSearch* _tmp0_;
	DeeSerializableModel* _tmp1_;
	DeeSerializableModel* _tmp2_;
	DeeSerializableModel* _tmp3_;
	DeeSerializableModel* model;
	GTimer* _tmp4_;
	GTimer* timer;
	gboolean _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	UnityLensSearch* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* zg_search_string;
	ZeitgeistTimeRange* _tmp13_;
	ZeitgeistTimeRange* _tmp14_;
	ZeitgeistTimeRange* time_range;
	ZeitgeistLog* _tmp15_;
	ZeitgeistTimeRange* _tmp16_;
	GPtrArray* _tmp17_;
	GPtrArray* _tmp18_;
	GCancellable* _tmp19_;
	ZeitgeistResultSet* _tmp20_;
	ZeitgeistResultSet* results;
	DeeSerializableModel* _tmp21_;
	ZeitgeistResultSet* _tmp22_;
	DeeSerializableModel* _tmp23_;
	gint _tmp24_;
	GTimer* _tmp25_;
	ZeitgeistResultSet* _tmp26_;
	guint _tmp27_;
	ZeitgeistResultSet* _tmp28_;
	guint _tmp29_;
	GTimer* _tmp30_;
	gdouble _tmp31_;
	const gchar* _tmp32_;
	GError* ioe;
	GError* e;
	UnityLensSearch* _tmp33_;
	const gchar* _tmp34_;
	const gchar* _tmp35_;
	GError* _tmp36_;
	const gchar* _tmp37_;
	UnityLensSearch* _tmp38_;
	GError * _inner_error_;
};


static gpointer unity_applications_lens_daemon_parent_class = NULL;

#define CONFIG_DATADIR "/usr/local/share"
#define UNITY_APPLICATIONS_LENS_ICON_PATH CONFIG_DATADIR "/icons/unity-icon-theme/places/svg/"
GType unity_applications_lens_daemon_get_type (void) G_GNUC_CONST;
GType unity_applications_lens_runner_get_type (void) G_GNUC_CONST;
GType unity_applications_lens_app_watcher_get_type (void) G_GNUC_CONST;
#define UNITY_APPLICATIONS_LENS_DAEMON_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_APPLICATIONS_LENS_TYPE_DAEMON, UnityApplicationsLensDaemonPrivate))
enum  {
	UNITY_APPLICATIONS_LENS_DAEMON_DUMMY_PROPERTY,
	UNITY_APPLICATIONS_LENS_DAEMON_DISPLAY_RECENT_APPS,
	UNITY_APPLICATIONS_LENS_DAEMON_DISPLAY_AVAILABLE_APPS
};
#define UNITY_APPLICATIONS_LENS_DAEMON_DISPLAY_RECENT_APPS_KEY "display-recent-apps"
#define UNITY_APPLICATIONS_LENS_DAEMON_DISPLAY_AVAILABLE_APPS_KEY "display-available-apps"
static void unity_applications_lens_daemon_dispatch_search_data_free (gpointer _data);
static void unity_applications_lens_daemon_dispatch_search (UnityApplicationsLensDaemon* self, UnityLensSearch* lens_search, UnitySearchType search_type, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void unity_applications_lens_daemon_dispatch_search_finish (UnityApplicationsLensDaemon* self, GAsyncResult* _res_);
static gboolean unity_applications_lens_daemon_dispatch_search_co (UnityApplicationsLensDaemonDispatchSearchData* _data_);
static void unity_applications_lens_daemon_update_popularities (UnityApplicationsLensDaemon* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void unity_applications_lens_daemon_update_popularities_finish (UnityApplicationsLensDaemon* self, GAsyncResult* _res_);
static void unity_applications_lens_daemon_dispatch_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void unity_applications_lens_daemon_update_scope_search (UnityApplicationsLensDaemon* self, UnityLensSearch* search, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void unity_applications_lens_daemon_update_scope_search_finish (UnityApplicationsLensDaemon* self, GAsyncResult* _res_);
static void unity_applications_lens_daemon_update_global_search (UnityApplicationsLensDaemon* self, UnityLensSearch* search, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void unity_applications_lens_daemon_update_global_search_finish (UnityApplicationsLensDaemon* self, GAsyncResult* _res_);
static void unity_applications_lens_daemon_populate_type_queries (UnityApplicationsLensDaemon* self);
static void _g_free0_ (gpointer var);
static void unity_applications_lens_daemon_populate_categories (UnityApplicationsLensDaemon* self);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static void unity_applications_lens_daemon_populate_filters (UnityApplicationsLensDaemon* self);
static gboolean unity_applications_lens_daemon_local_apps_active (UnityApplicationsLensDaemon* self);
static gboolean unity_applications_lens_daemon_usc_apps_active (UnityApplicationsLensDaemon* self);
static gboolean unity_applications_lens_daemon_build_app_menu_index (UnityApplicationsLensDaemon* self);
static void ___lambda5_ (UnityApplicationsLensDaemon* self, GMenuTree* menu);
static gboolean unity_applications_lens_daemon_build_app_menu_index_and_result_models (UnityApplicationsLensDaemon* self);
static gboolean _unity_applications_lens_daemon_build_app_menu_index_and_result_models_gsource_func (gpointer self);
static void ____lambda5__gmenu_tree_changed_func (GMenuTree* tree, gpointer self);
static void unity_applications_lens_daemon_mark_dirty (UnityApplicationsLensDaemon* self);
static void unity_applications_lens_daemon_populate_zg_templates (UnityApplicationsLensDaemon* self);
static gchar* unity_applications_lens_daemon_prepare_zg_search_string (UnityApplicationsLensDaemon* self, const gchar* search_string, UnityOptionsFilter* options);
static gchar* unity_applications_lens_daemon_extract_type_query (UnityApplicationsLensDaemon* self, UnityOptionsFilter* options);
static void unity_applications_lens_daemon_update_popularities_data_free (gpointer _data);
static gboolean unity_applications_lens_daemon_update_popularities_co (UnityApplicationsLensDaemonUpdatePopularitiesData* _data_);
static void unity_applications_lens_daemon_update_popularities_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void unity_applications_lens_daemon_update_scope_search_data_free (gpointer _data);
static gboolean unity_applications_lens_daemon_update_scope_search_co (UnityApplicationsLensDaemonUpdateScopeSearchData* _data_);
static gchar* unity_applications_lens_daemon_prepare_pkg_search_string (UnityApplicationsLensDaemon* self, UnityLensSearch* search, UnityOptionsFilter* options);
gboolean unity_applications_lens_utils_is_search_empty (UnityLensSearch* search);
static void unity_applications_lens_daemon_resort_pkg_search_results (UnityApplicationsLensDaemon* self, UnityPackageSearchResult* results);
GType unity_applications_lens_category_get_type (void) G_GNUC_CONST;
static void unity_applications_lens_daemon_add_pkg_search_result (UnityApplicationsLensDaemon* self, UnityPackageSearchResult* results, GeeSet* installed_uris, GeeSet* available_uris, DeeModel* model, UnityApplicationsLensCategory category, guint max_add);
gboolean unity_applications_lens_daemon_get_display_recent_apps (UnityApplicationsLensDaemon* self);
static void unity_applications_lens_daemon_update_scope_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void unity_applications_lens_daemon_append_events_with_category (UnityApplicationsLensDaemon* self, ZeitgeistResultSet* events, DeeModel* results, guint category_id, gboolean include_favorites, gint max_results, GeeSet* allowed_uris);
gboolean unity_applications_lens_daemon_get_display_available_apps (UnityApplicationsLensDaemon* self);
static GVariant* _variant_new4 (const gchar* value);
static void unity_applications_lens_daemon_update_global_search_data_free (gpointer _data);
static gboolean unity_applications_lens_daemon_update_global_search_co (UnityApplicationsLensDaemonUpdateGlobalSearchData* _data_);
static void unity_applications_lens_daemon_update_global_without_search (UnityApplicationsLensDaemon* self, UnityLensSearch* search, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void unity_applications_lens_daemon_update_global_without_search_finish (UnityApplicationsLensDaemon* self, GAsyncResult* _res_);
static void unity_applications_lens_daemon_update_global_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void unity_applications_lens_daemon_update_global_without_search_data_free (gpointer _data);
static gboolean unity_applications_lens_daemon_update_global_without_search_co (UnityApplicationsLensDaemonUpdateGlobalWithoutSearchData* _data_);
static void unity_applications_lens_daemon_update_global_without_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GIcon* unity_applications_lens_daemon_find_pkg_icon (UnityApplicationsLensDaemon* self, UnityPackageInfo* pkginfo);
static gchar* unity_applications_lens_daemon_extract_desktop_id (UnityApplicationsLensDaemon* self, const gchar* desktop_file, gboolean unmangle);
static gint __lambda4_ (UnityApplicationsLensDaemon* self, UnityPackageInfo* a, UnityPackageInfo* b);
static gint ___lambda4__gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self);
const gchar* unity_applications_lens_category_to_string (UnityApplicationsLensCategory self);
UnityActivationResponse* unity_applications_lens_daemon_activate (UnityApplicationsLensDaemon* self, const gchar* uri);
static void _g_list_free__g_free0_ (GList* self);
gchar* unity_applications_lens_utils_subst_tilde (const gchar* s);
void unity_applications_lens_runner_add_history (UnityApplicationsLensRunner* self, const gchar* last_command);
gchar* unity_applications_lens_utils_get_desktop_id_for_actor (const gchar* actor);
gboolean unity_applications_lens_app_watcher_has_app_id (UnityApplicationsLensAppWatcher* self, const gchar* desktop_id);
UnityApplicationsLensDaemon* unity_applications_lens_daemon_new (void);
UnityApplicationsLensDaemon* unity_applications_lens_daemon_construct (GType object_type);
void unity_applications_lens_daemon_set_display_recent_apps (UnityApplicationsLensDaemon* self, gboolean value);
void unity_applications_lens_daemon_set_display_available_apps (UnityApplicationsLensDaemon* self, gboolean value);
static GObject * unity_applications_lens_daemon_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _unity_applications_lens_daemon_mark_dirty_zeitgeist_monitor_events_inserted (ZeitgeistMonitor* _sender, ZeitgeistTimeRange* time_range, ZeitgeistResultSet* events, gpointer self);
static void _unity_applications_lens_daemon_mark_dirty_zeitgeist_monitor_events_deleted (ZeitgeistMonitor* _sender, ZeitgeistTimeRange* time_range, GArray* event_ids, gpointer self);
static gboolean _unity_applications_lens_daemon___lambda6_ (UnityApplicationsLensDaemon* self);
static gboolean __unity_applications_lens_daemon___lambda6__gsource_func (gpointer self);
static gchar* _unity_applications_lens_daemon___lambda7_ (UnityApplicationsLensDaemon* self, UnityLensSearch* lens_search);
static gchar* __unity_applications_lens_daemon___lambda7__unity_scope_generate_search_key (UnityScope* _sender, UnityLensSearch* search, gpointer self);
static void _unity_applications_lens_daemon___lambda8_ (UnityApplicationsLensDaemon* self, UnityLensSearch* lens_search, UnitySearchType search_type, GCancellable* cancellable);
static void __unity_applications_lens_daemon___lambda8__unity_scope_search_changed (UnityScope* _sender, UnityLensSearch* search, UnitySearchType search_type, GCancellable* cancellable, gpointer self);
static void _unity_applications_lens_daemon___lambda9_ (UnityApplicationsLensDaemon* self);
static void __unity_applications_lens_daemon___lambda9__unity_scope_filters_changed (UnityScope* _sender, gpointer self);
static void _unity_applications_lens_daemon___lambda10_ (UnityApplicationsLensDaemon* self);
static void __unity_applications_lens_daemon___lambda10__unity_scope_active_sources_changed (UnityScope* _sender, gchar** active_ids, int active_ids_length1, gpointer self);
static UnityActivationResponse* _unity_applications_lens_daemon_activate_unity_scope_activate_uri (UnityScope* _sender, const gchar* uri, gpointer self);
static void _unity_applications_lens_daemon_mark_dirty_unity_app_info_manager_changed (UnityAppInfoManager* _sender, const gchar* id, GAppInfo* new_appinfo, gpointer self);
UnityApplicationsLensRunner* unity_applications_lens_runner_new (UnityApplicationsLensDaemon* daemon);
UnityApplicationsLensRunner* unity_applications_lens_runner_construct (GType object_type, UnityApplicationsLensDaemon* daemon);
static void _unity_applications_lens_daemon_mark_dirty_unity_launcher_favorites_changed (UnityLauncherFavorites* _sender, gpointer self);
UnityApplicationsLensAppWatcher* unity_applications_lens_app_watcher_new (void);
UnityApplicationsLensAppWatcher* unity_applications_lens_app_watcher_construct (GType object_type);
static void _unity_applications_lens_daemon_mark_dirty_unity_applications_lens_app_watcher_running_applications_changed (UnityApplicationsLensAppWatcher* _sender, gpointer self);
static void unity_applications_lens_daemon_finalize (GObject* obj);
static void _vala_unity_applications_lens_daemon_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_unity_applications_lens_daemon_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const gchar* UNITY_APPLICATIONS_LENS_DAEMON_option_types[13] = {"accessories", "education", "game", "graphics", "internet", "fonts", "office", "media", "customization", "accessibility", "developer", "science-and-engineering", "system"};

static void unity_applications_lens_daemon_dispatch_search_data_free (gpointer _data) {
	UnityApplicationsLensDaemonDispatchSearchData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->lens_search);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (UnityApplicationsLensDaemonDispatchSearchData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void unity_applications_lens_daemon_dispatch_search (UnityApplicationsLensDaemon* self, UnityLensSearch* lens_search, UnitySearchType search_type, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityApplicationsLensDaemonDispatchSearchData* _data_;
	UnityApplicationsLensDaemon* _tmp0_;
	UnityLensSearch* _tmp1_;
	UnityLensSearch* _tmp2_;
	UnitySearchType _tmp3_;
	GCancellable* _tmp4_;
	GCancellable* _tmp5_;
	_data_ = g_slice_new0 (UnityApplicationsLensDaemonDispatchSearchData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_applications_lens_daemon_dispatch_search);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_applications_lens_daemon_dispatch_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = lens_search;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->lens_search = _tmp2_;
	_tmp3_ = search_type;
	_data_->search_type = _tmp3_;
	_tmp4_ = cancellable;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_data_->cancellable = _tmp5_;
	unity_applications_lens_daemon_dispatch_search_co (_data_);
}


static void unity_applications_lens_daemon_dispatch_search_finish (UnityApplicationsLensDaemon* self, GAsyncResult* _res_) {
	UnityApplicationsLensDaemonDispatchSearchData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void unity_applications_lens_daemon_dispatch_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	UnityApplicationsLensDaemonDispatchSearchData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	unity_applications_lens_daemon_dispatch_search_co (_data_);
}


static gboolean unity_applications_lens_daemon_dispatch_search_co (UnityApplicationsLensDaemonDispatchSearchData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->popularities_dirty;
	if (_data_->_tmp0_) {
		_data_->self->priv->popularities_dirty = FALSE;
		_data_->_state_ = 1;
		unity_applications_lens_daemon_update_popularities (_data_->self, unity_applications_lens_daemon_dispatch_search_ready, _data_);
		return FALSE;
		_state_1:
		unity_applications_lens_daemon_update_popularities_finish (_data_->self, _data_->_res_);
		_data_->_tmp1_ = _data_->cancellable;
		_data_->_tmp2_ = FALSE;
		_data_->_tmp2_ = g_cancellable_is_cancelled (_data_->_tmp1_);
		if (_data_->_tmp2_) {
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp3_ = _data_->search_type;
	if (_data_->_tmp3_ == UNITY_SEARCH_TYPE_DEFAULT) {
		_data_->_tmp4_ = _data_->lens_search;
		_data_->_tmp5_ = _data_->cancellable;
		_data_->_state_ = 2;
		unity_applications_lens_daemon_update_scope_search (_data_->self, _data_->_tmp4_, _data_->_tmp5_, unity_applications_lens_daemon_dispatch_search_ready, _data_);
		return FALSE;
		_state_2:
		unity_applications_lens_daemon_update_scope_search_finish (_data_->self, _data_->_res_);
	} else {
		_data_->_tmp6_ = _data_->lens_search;
		_data_->_tmp7_ = _data_->cancellable;
		_data_->_state_ = 3;
		unity_applications_lens_daemon_update_global_search (_data_->self, _data_->_tmp6_, _data_->_tmp7_, unity_applications_lens_daemon_dispatch_search_ready, _data_);
		return FALSE;
		_state_3:
		unity_applications_lens_daemon_update_global_search_finish (_data_->self, _data_->_res_);
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void unity_applications_lens_daemon_populate_type_queries (UnityApplicationsLensDaemon* self) {
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GHashTable* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GHashTable* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GHashTable* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GHashTable* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	GHashTable* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	GHashTable* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	GHashTable* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	GHashTable* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	GHashTable* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	GHashTable* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	GHashTable* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	GHashTable* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	GHashTable* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	GHashTable* _tmp42_;
	gchar* _tmp43_;
	gchar* _tmp44_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_free0_);
	_g_hash_table_unref0 (self->priv->type_queries);
	self->priv->type_queries = _tmp2_;
	_tmp3_ = self->priv->type_queries;
	_tmp4_ = g_strdup ("all");
	_tmp5_ = g_strdup ("NOT category:XYZ");
	g_hash_table_insert (_tmp3_, _tmp4_, _tmp5_);
	_tmp6_ = self->priv->type_queries;
	_tmp7_ = g_strdup ("accessories");
	_tmp8_ = g_strdup ("(category:Utility AND NOT category:Accessibility)");
	g_hash_table_insert (_tmp6_, _tmp7_, _tmp8_);
	_tmp9_ = self->priv->type_queries;
	_tmp10_ = g_strdup ("education");
	_tmp11_ = g_strdup ("(category:Education AND NOT category:Science)");
	g_hash_table_insert (_tmp9_, _tmp10_, _tmp11_);
	_tmp12_ = self->priv->type_queries;
	_tmp13_ = g_strdup ("game");
	_tmp14_ = g_strdup ("category:Game");
	g_hash_table_insert (_tmp12_, _tmp13_, _tmp14_);
	_tmp15_ = self->priv->type_queries;
	_tmp16_ = g_strdup ("graphics");
	_tmp17_ = g_strdup ("category:Graphics");
	g_hash_table_insert (_tmp15_, _tmp16_, _tmp17_);
	_tmp18_ = self->priv->type_queries;
	_tmp19_ = g_strdup ("internet");
	_tmp20_ = g_strdup ("category:Network");
	g_hash_table_insert (_tmp18_, _tmp19_, _tmp20_);
	_tmp21_ = self->priv->type_queries;
	_tmp22_ = g_strdup ("fonts");
	_tmp23_ = g_strdup ("category:Fonts");
	g_hash_table_insert (_tmp21_, _tmp22_, _tmp23_);
	_tmp24_ = self->priv->type_queries;
	_tmp25_ = g_strdup ("office");
	_tmp26_ = g_strdup ("category:Office");
	g_hash_table_insert (_tmp24_, _tmp25_, _tmp26_);
	_tmp27_ = self->priv->type_queries;
	_tmp28_ = g_strdup ("media");
	_tmp29_ = g_strdup ("category:AudioVideo");
	g_hash_table_insert (_tmp27_, _tmp28_, _tmp29_);
	_tmp30_ = self->priv->type_queries;
	_tmp31_ = g_strdup ("customization");
	_tmp32_ = g_strdup ("category:Settings");
	g_hash_table_insert (_tmp30_, _tmp31_, _tmp32_);
	_tmp33_ = self->priv->type_queries;
	_tmp34_ = g_strdup ("accessibility");
	_tmp35_ = g_strdup ("(category:Accessibility AND NOT category:Settings)");
	g_hash_table_insert (_tmp33_, _tmp34_, _tmp35_);
	_tmp36_ = self->priv->type_queries;
	_tmp37_ = g_strdup ("developer");
	_tmp38_ = g_strdup ("category:Development");
	g_hash_table_insert (_tmp36_, _tmp37_, _tmp38_);
	_tmp39_ = self->priv->type_queries;
	_tmp40_ = g_strdup ("science-and-engineering");
	_tmp41_ = g_strdup ("(category:Science OR category:Engineering)");
	g_hash_table_insert (_tmp39_, _tmp40_, _tmp41_);
	_tmp42_ = self->priv->type_queries;
	_tmp43_ = g_strdup ("system");
	_tmp44_ = g_strdup ("(category:System OR category:Security)");
	g_hash_table_insert (_tmp42_, _tmp43_, _tmp44_);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static void unity_applications_lens_daemon_populate_categories (UnityApplicationsLensDaemon* self) {
	GList* categories;
	GFile* _tmp0_ = NULL;
	GFile* icon_dir;
	const gchar* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	GFile* _tmp3_;
	GFileIcon* _tmp4_;
	GFileIcon* _tmp5_;
	UnityCategory* _tmp6_;
	UnityCategory* _tmp7_;
	UnityCategory* cat;
	UnityCategory* _tmp8_;
	UnityCategory* _tmp9_;
	const gchar* _tmp10_ = NULL;
	GFile* _tmp11_ = NULL;
	GFile* _tmp12_;
	GFileIcon* _tmp13_;
	GFileIcon* _tmp14_;
	UnityCategory* _tmp15_;
	UnityCategory* _tmp16_;
	UnityCategory* _tmp17_;
	const gchar* _tmp18_ = NULL;
	GFile* _tmp19_ = NULL;
	GFile* _tmp20_;
	GFileIcon* _tmp21_;
	GFileIcon* _tmp22_;
	UnityCategory* _tmp23_;
	UnityCategory* _tmp24_;
	UnityCategory* _tmp25_;
	const gchar* _tmp26_ = NULL;
	GFile* _tmp27_ = NULL;
	GFile* _tmp28_;
	GFileIcon* _tmp29_;
	GFileIcon* _tmp30_;
	UnityCategory* _tmp31_;
	UnityCategory* _tmp32_;
	UnityCategory* _tmp33_;
	const gchar* _tmp34_ = NULL;
	GFile* _tmp35_ = NULL;
	GFile* _tmp36_;
	GFileIcon* _tmp37_;
	GFileIcon* _tmp38_;
	UnityCategory* _tmp39_;
	UnityCategory* _tmp40_;
	UnityCategory* _tmp41_;
	UnityLens* _tmp42_;
	g_return_if_fail (self != NULL);
	categories = NULL;
	_tmp0_ = g_file_new_for_path (UNITY_APPLICATIONS_LENS_ICON_PATH);
	icon_dir = _tmp0_;
	_tmp1_ = _ ("Recently Used");
	_tmp2_ = g_file_get_child (icon_dir, "group-recent.svg");
	_tmp3_ = _tmp2_;
	_tmp4_ = (GFileIcon*) g_file_icon_new (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = unity_category_new (_tmp1_, (GIcon*) _tmp5_, UNITY_CATEGORY_RENDERER_VERTICAL_TILE);
	_tmp7_ = _tmp6_;
	_g_object_unref0 (_tmp5_);
	_g_object_unref0 (_tmp3_);
	cat = _tmp7_;
	_tmp8_ = cat;
	_tmp9_ = _g_object_ref0 (_tmp8_);
	categories = g_list_append (categories, _tmp9_);
	_tmp10_ = _ ("Recent Apps");
	_tmp11_ = g_file_get_child (icon_dir, "group-apps.svg");
	_tmp12_ = _tmp11_;
	_tmp13_ = (GFileIcon*) g_file_icon_new (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = unity_category_new (_tmp10_, (GIcon*) _tmp14_, UNITY_CATEGORY_RENDERER_VERTICAL_TILE);
	_g_object_unref0 (cat);
	cat = _tmp15_;
	_g_object_unref0 (_tmp14_);
	_g_object_unref0 (_tmp12_);
	_tmp16_ = cat;
	_tmp17_ = _g_object_ref0 (_tmp16_);
	categories = g_list_append (categories, _tmp17_);
	_tmp18_ = _ ("Installed");
	_tmp19_ = g_file_get_child (icon_dir, "group-installed.svg");
	_tmp20_ = _tmp19_;
	_tmp21_ = (GFileIcon*) g_file_icon_new (_tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = unity_category_new (_tmp18_, (GIcon*) _tmp22_, UNITY_CATEGORY_RENDERER_VERTICAL_TILE);
	_g_object_unref0 (cat);
	cat = _tmp23_;
	_g_object_unref0 (_tmp22_);
	_g_object_unref0 (_tmp20_);
	_tmp24_ = cat;
	_tmp25_ = _g_object_ref0 (_tmp24_);
	categories = g_list_append (categories, _tmp25_);
	_tmp26_ = _ ("Apps Available for Download");
	_tmp27_ = g_file_get_child (icon_dir, "group-downloads.svg");
	_tmp28_ = _tmp27_;
	_tmp29_ = (GFileIcon*) g_file_icon_new (_tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = unity_category_new (_tmp26_, (GIcon*) _tmp30_, UNITY_CATEGORY_RENDERER_VERTICAL_TILE);
	_g_object_unref0 (cat);
	cat = _tmp31_;
	_g_object_unref0 (_tmp30_);
	_g_object_unref0 (_tmp28_);
	_tmp32_ = cat;
	_tmp33_ = _g_object_ref0 (_tmp32_);
	categories = g_list_append (categories, _tmp33_);
	_tmp34_ = _ ("Applications");
	_tmp35_ = g_file_get_child (icon_dir, "group-apps.svg");
	_tmp36_ = _tmp35_;
	_tmp37_ = (GFileIcon*) g_file_icon_new (_tmp36_);
	_tmp38_ = _tmp37_;
	_tmp39_ = unity_category_new (_tmp34_, (GIcon*) _tmp38_, UNITY_CATEGORY_RENDERER_VERTICAL_TILE);
	_g_object_unref0 (cat);
	cat = _tmp39_;
	_g_object_unref0 (_tmp38_);
	_g_object_unref0 (_tmp36_);
	_tmp40_ = cat;
	_tmp41_ = _g_object_ref0 (_tmp40_);
	categories = g_list_append (categories, _tmp41_);
	_tmp42_ = self->priv->lens;
	unity_lens_set_categories (_tmp42_, categories);
	_g_object_unref0 (cat);
	_g_object_unref0 (icon_dir);
	__g_list_free__g_object_unref0_0 (categories);
}


static void unity_applications_lens_daemon_populate_filters (UnityApplicationsLensDaemon* self) {
	GList* filters;
	UnityLens* _tmp45_;
	g_return_if_fail (self != NULL);
	filters = NULL;
	{
		const gchar* _tmp0_ = NULL;
		UnityCheckOptionFilter* _tmp1_;
		UnityCheckOptionFilter* filter;
		const gchar* _tmp2_ = NULL;
		UnityFilterOption* _tmp3_ = NULL;
		UnityFilterOption* _tmp4_;
		const gchar* _tmp5_ = NULL;
		UnityFilterOption* _tmp6_ = NULL;
		UnityFilterOption* _tmp7_;
		const gchar* _tmp8_ = NULL;
		UnityFilterOption* _tmp9_ = NULL;
		UnityFilterOption* _tmp10_;
		const gchar* _tmp11_ = NULL;
		UnityFilterOption* _tmp12_ = NULL;
		UnityFilterOption* _tmp13_;
		const gchar* _tmp14_ = NULL;
		UnityFilterOption* _tmp15_ = NULL;
		UnityFilterOption* _tmp16_;
		const gchar* _tmp17_ = NULL;
		UnityFilterOption* _tmp18_ = NULL;
		UnityFilterOption* _tmp19_;
		const gchar* _tmp20_ = NULL;
		UnityFilterOption* _tmp21_ = NULL;
		UnityFilterOption* _tmp22_;
		const gchar* _tmp23_ = NULL;
		UnityFilterOption* _tmp24_ = NULL;
		UnityFilterOption* _tmp25_;
		const gchar* _tmp26_ = NULL;
		UnityFilterOption* _tmp27_ = NULL;
		UnityFilterOption* _tmp28_;
		const gchar* _tmp29_ = NULL;
		UnityFilterOption* _tmp30_ = NULL;
		UnityFilterOption* _tmp31_;
		const gchar* _tmp32_ = NULL;
		UnityFilterOption* _tmp33_ = NULL;
		UnityFilterOption* _tmp34_;
		const gchar* _tmp35_ = NULL;
		UnityFilterOption* _tmp36_ = NULL;
		UnityFilterOption* _tmp37_;
		const gchar* _tmp38_ = NULL;
		UnityFilterOption* _tmp39_ = NULL;
		UnityFilterOption* _tmp40_;
		UnityFilter* _tmp41_;
		_tmp0_ = _ ("Type");
		_tmp1_ = unity_check_option_filter_new ("type", _tmp0_, NULL, FALSE);
		filter = _tmp1_;
		unity_options_filter_set_sort_type ((UnityOptionsFilter*) filter, UNITY_OPTIONS_FILTER_SORT_TYPE_DISPLAY_NAME);
		_tmp2_ = _ ("Accessories");
		_tmp3_ = unity_options_filter_add_option ((UnityOptionsFilter*) filter, "accessories", _tmp2_, NULL);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp4_);
		_tmp5_ = _ ("Education");
		_tmp6_ = unity_options_filter_add_option ((UnityOptionsFilter*) filter, "education", _tmp5_, NULL);
		_tmp7_ = _tmp6_;
		_g_object_unref0 (_tmp7_);
		_tmp8_ = _ ("Games");
		_tmp9_ = unity_options_filter_add_option ((UnityOptionsFilter*) filter, "game", _tmp8_, NULL);
		_tmp10_ = _tmp9_;
		_g_object_unref0 (_tmp10_);
		_tmp11_ = _ ("Graphics");
		_tmp12_ = unity_options_filter_add_option ((UnityOptionsFilter*) filter, "graphics", _tmp11_, NULL);
		_tmp13_ = _tmp12_;
		_g_object_unref0 (_tmp13_);
		_tmp14_ = _ ("Internet");
		_tmp15_ = unity_options_filter_add_option ((UnityOptionsFilter*) filter, "internet", _tmp14_, NULL);
		_tmp16_ = _tmp15_;
		_g_object_unref0 (_tmp16_);
		_tmp17_ = _ ("Fonts");
		_tmp18_ = unity_options_filter_add_option ((UnityOptionsFilter*) filter, "fonts", _tmp17_, NULL);
		_tmp19_ = _tmp18_;
		_g_object_unref0 (_tmp19_);
		_tmp20_ = _ ("Office");
		_tmp21_ = unity_options_filter_add_option ((UnityOptionsFilter*) filter, "office", _tmp20_, NULL);
		_tmp22_ = _tmp21_;
		_g_object_unref0 (_tmp22_);
		_tmp23_ = _ ("Media");
		_tmp24_ = unity_options_filter_add_option ((UnityOptionsFilter*) filter, "media", _tmp23_, NULL);
		_tmp25_ = _tmp24_;
		_g_object_unref0 (_tmp25_);
		_tmp26_ = _ ("Customization");
		_tmp27_ = unity_options_filter_add_option ((UnityOptionsFilter*) filter, "customization", _tmp26_, NULL);
		_tmp28_ = _tmp27_;
		_g_object_unref0 (_tmp28_);
		_tmp29_ = _ ("Accessibility");
		_tmp30_ = unity_options_filter_add_option ((UnityOptionsFilter*) filter, "accessibility", _tmp29_, NULL);
		_tmp31_ = _tmp30_;
		_g_object_unref0 (_tmp31_);
		_tmp32_ = _ ("Developer");
		_tmp33_ = unity_options_filter_add_option ((UnityOptionsFilter*) filter, "developer", _tmp32_, NULL);
		_tmp34_ = _tmp33_;
		_g_object_unref0 (_tmp34_);
		_tmp35_ = _ ("Science & Engineering");
		_tmp36_ = unity_options_filter_add_option ((UnityOptionsFilter*) filter, "science-and-engineering", _tmp35_, NULL);
		_tmp37_ = _tmp36_;
		_g_object_unref0 (_tmp37_);
		_tmp38_ = _ ("System");
		_tmp39_ = unity_options_filter_add_option ((UnityOptionsFilter*) filter, "system", _tmp38_, NULL);
		_tmp40_ = _tmp39_;
		_g_object_unref0 (_tmp40_);
		_tmp41_ = _g_object_ref0 ((UnityFilter*) filter);
		filters = g_list_append (filters, _tmp41_);
		_g_object_unref0 (filter);
	}
	{
		const gchar* _tmp42_ = NULL;
		UnityRatingsFilter* _tmp43_;
		UnityRatingsFilter* filter;
		UnityFilter* _tmp44_;
		_tmp42_ = _ ("Rating");
		_tmp43_ = unity_ratings_filter_new ("rating", _tmp42_, NULL, FALSE);
		filter = _tmp43_;
		_tmp44_ = _g_object_ref0 ((UnityFilter*) filter);
		filters = g_list_append (filters, _tmp44_);
		_g_object_unref0 (filter);
	}
	_tmp45_ = self->priv->lens;
	unity_lens_set_filters (_tmp45_, filters);
	__g_list_free__g_object_unref0_0 (filters);
}


static gboolean unity_applications_lens_daemon_local_apps_active (UnityApplicationsLensDaemon* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	UnityScope* _tmp1_;
	UnityOptionsFilter* _tmp2_;
	UnityOptionsFilter* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp7_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->scope;
	_tmp2_ = unity_scope_get_sources (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = unity_filter_get_filtering ((UnityFilter*) _tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_) {
		UnityFilterOption* _tmp6_;
		_tmp6_ = self->priv->local_apps_option;
		_tmp0_ = _tmp6_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp7_ = _tmp0_;
	if (_tmp7_) {
		UnityFilterOption* _tmp8_;
		gboolean _tmp9_;
		gboolean _tmp10_;
		_tmp8_ = self->priv->local_apps_option;
		_tmp9_ = unity_filter_option_get_active (_tmp8_);
		_tmp10_ = _tmp9_;
		result = _tmp10_;
		return result;
	}
	result = TRUE;
	return result;
}


static gboolean unity_applications_lens_daemon_usc_apps_active (UnityApplicationsLensDaemon* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	UnityScope* _tmp1_;
	UnityOptionsFilter* _tmp2_;
	UnityOptionsFilter* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp7_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->scope;
	_tmp2_ = unity_scope_get_sources (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = unity_filter_get_filtering ((UnityFilter*) _tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_) {
		UnityFilterOption* _tmp6_;
		_tmp6_ = self->priv->usc_apps_option;
		_tmp0_ = _tmp6_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp7_ = _tmp0_;
	if (_tmp7_) {
		UnityFilterOption* _tmp8_;
		gboolean _tmp9_;
		gboolean _tmp10_;
		_tmp8_ = self->priv->usc_apps_option;
		_tmp9_ = unity_filter_option_get_active (_tmp8_);
		_tmp10_ = _tmp9_;
		result = _tmp10_;
		return result;
	}
	result = TRUE;
	return result;
}


static gpointer _gmenu_tree_ref0 (gpointer self) {
	return self ? gmenu_tree_ref (self) : NULL;
}


static gboolean _unity_applications_lens_daemon_build_app_menu_index_and_result_models_gsource_func (gpointer self) {
	gboolean result;
	result = unity_applications_lens_daemon_build_app_menu_index_and_result_models (self);
	return result;
}


static void ___lambda5_ (UnityApplicationsLensDaemon* self, GMenuTree* menu) {
	guint _tmp0_;
	guint _tmp2_ = 0U;
	g_return_if_fail (menu != NULL);
	_tmp0_ = self->priv->app_menu_changed_reindex_timeout;
	if (_tmp0_ != ((guint) 0)) {
		guint _tmp1_;
		_tmp1_ = self->priv->app_menu_changed_reindex_timeout;
		g_source_remove (_tmp1_);
	}
	_tmp2_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 5, _unity_applications_lens_daemon_build_app_menu_index_and_result_models_gsource_func, g_object_ref (self), g_object_unref);
	self->priv->app_menu_changed_reindex_timeout = _tmp2_;
}


static void ____lambda5__gmenu_tree_changed_func (GMenuTree* tree, gpointer self) {
	___lambda5_ (self, tree);
}


static gboolean unity_applications_lens_daemon_build_app_menu_index (UnityApplicationsLensDaemon* self) {
	gboolean result = FALSE;
	GMenuTree* _tmp0_;
	GMenuTree* _tmp4_;
	UnityPackageSearcher* _tmp5_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->app_menu;
	if (_tmp0_ == NULL) {
		GMenuTree* _tmp1_ = NULL;
		GMenuTree* _tmp2_;
		GMenuTree* _tmp3_;
		g_debug ("daemon.vala:331: Building initial application menu");
		_tmp1_ = gmenu_tree_lookup ("unity-lens-applications.menu", GMENU_TREE_FLAGS_INCLUDE_NODISPLAY);
		_tmp2_ = _gmenu_tree_ref0 (_tmp1_);
		_gmenu_tree_unref0 (self->priv->app_menu);
		self->priv->app_menu = _tmp2_;
		_tmp3_ = self->priv->app_menu;
		gmenu_tree_add_monitor (_tmp3_, ____lambda5__gmenu_tree_changed_func, self);
	}
	g_debug ("daemon.vala:352: Indexing application menu");
	_tmp4_ = self->priv->app_menu;
	_tmp5_ = unity_package_searcher_new_for_menu (_tmp4_);
	_unity_package_searcher_free0 (self->appsearcher);
	self->appsearcher = _tmp5_;
	self->priv->app_menu_changed_reindex_timeout = (guint) 0;
	result = FALSE;
	return result;
}


static gboolean unity_applications_lens_daemon_build_app_menu_index_and_result_models (UnityApplicationsLensDaemon* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	unity_applications_lens_daemon_build_app_menu_index (self);
	unity_applications_lens_daemon_mark_dirty (self);
	result = FALSE;
	return result;
}


static void unity_applications_lens_daemon_populate_zg_templates (UnityApplicationsLensDaemon* self) {
	GPtrArray* _tmp0_;
	ZeitgeistSubject* _tmp1_;
	ZeitgeistSubject* _tmp2_;
	ZeitgeistEvent* _tmp3_;
	ZeitgeistEvent* _tmp4_;
	ZeitgeistEvent* _tmp5_;
	ZeitgeistEvent* ev;
	GPtrArray* _tmp6_;
	GObject* _tmp7_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_ptr_array_sized_new ((guint) 1);
	_g_ptr_array_unref0 (self->priv->zg_templates);
	self->priv->zg_templates = _tmp0_;
	_tmp1_ = zeitgeist_subject_new_full ("application*", "", "", "", "", "", "");
	_tmp2_ = g_object_ref_sink (_tmp1_);
	_tmp3_ = zeitgeist_event_new_full (ZEITGEIST_ZG_ACCESS_EVENT, ZEITGEIST_ZG_USER_ACTIVITY, "", _tmp2_, NULL);
	_tmp4_ = g_object_ref_sink (_tmp3_);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp2_);
	ev = _tmp5_;
	_tmp6_ = self->priv->zg_templates;
	_tmp7_ = g_object_ref (G_IS_OBJECT (ev) ? ((GObject*) ev) : NULL);
	g_ptr_array_add (_tmp6_, _tmp7_);
	_g_object_unref0 (ev);
}


static void unity_applications_lens_daemon_mark_dirty (UnityApplicationsLensDaemon* self) {
	UnityScope* _tmp0_;
	UnityScope* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->scope;
	unity_scope_queue_search_changed (_tmp0_, UNITY_SEARCH_TYPE_DEFAULT);
	_tmp1_ = self->priv->scope;
	unity_scope_queue_search_changed (_tmp1_, UNITY_SEARCH_TYPE_GLOBAL);
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static gchar* unity_applications_lens_daemon_prepare_zg_search_string (UnityApplicationsLensDaemon* self, const gchar* search_string, UnityOptionsFilter* options) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* s;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp6_;
	const gchar* _tmp9_;
	gboolean _tmp15_ = FALSE;
	UnityOptionsFilter* _tmp16_;
	gboolean _tmp20_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (search_string != NULL, NULL);
	_tmp0_ = search_string;
	_tmp1_ = string_strip (_tmp0_);
	s = _tmp1_;
	_tmp3_ = s;
	_tmp4_ = g_str_has_suffix (_tmp3_, "*");
	if (!_tmp4_) {
		const gchar* _tmp5_;
		_tmp5_ = s;
		_tmp2_ = g_strcmp0 (_tmp5_, "") != 0;
	} else {
		_tmp2_ = FALSE;
	}
	_tmp6_ = _tmp2_;
	if (_tmp6_) {
		const gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp7_ = s;
		_tmp8_ = g_strconcat (_tmp7_, "*", NULL);
		_g_free0 (s);
		s = _tmp8_;
	}
	_tmp9_ = s;
	if (g_strcmp0 (_tmp9_, "") != 0) {
		const gchar* _tmp10_;
		const gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		_tmp10_ = s;
		_tmp11_ = string_to_string (_tmp10_);
		_tmp12_ = g_strconcat ("app:(", _tmp11_, ")", NULL);
		_g_free0 (s);
		s = _tmp12_;
	} else {
		UnityOptionsFilter* _tmp13_;
		gchar* _tmp14_ = NULL;
		_tmp13_ = options;
		_tmp14_ = unity_applications_lens_daemon_extract_type_query (self, _tmp13_);
		result = _tmp14_;
		_g_free0 (s);
		return result;
	}
	_tmp16_ = options;
	if (_tmp16_ == NULL) {
		_tmp15_ = TRUE;
	} else {
		UnityOptionsFilter* _tmp17_;
		gboolean _tmp18_;
		gboolean _tmp19_;
		_tmp17_ = options;
		_tmp18_ = unity_filter_get_filtering ((UnityFilter*) _tmp17_);
		_tmp19_ = _tmp18_;
		_tmp15_ = !_tmp19_;
	}
	_tmp20_ = _tmp15_;
	if (_tmp20_) {
		result = s;
		return result;
	} else {
		const gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		UnityOptionsFilter* _tmp24_;
		gchar* _tmp25_ = NULL;
		gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		_tmp21_ = s;
		_tmp22_ = g_strconcat (_tmp21_, " AND ", NULL);
		_tmp23_ = _tmp22_;
		_tmp24_ = options;
		_tmp25_ = unity_applications_lens_daemon_extract_type_query (self, _tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = g_strconcat (_tmp23_, _tmp26_, NULL);
		_tmp28_ = _tmp27_;
		_g_free0 (_tmp26_);
		_g_free0 (_tmp23_);
		result = _tmp28_;
		_g_free0 (s);
		return result;
	}
	_g_free0 (s);
}


static void unity_applications_lens_daemon_update_popularities_data_free (gpointer _data) {
	UnityApplicationsLensDaemonUpdatePopularitiesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (UnityApplicationsLensDaemonUpdatePopularitiesData, _data_);
}


static void unity_applications_lens_daemon_update_popularities (UnityApplicationsLensDaemon* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityApplicationsLensDaemonUpdatePopularitiesData* _data_;
	UnityApplicationsLensDaemon* _tmp0_;
	_data_ = g_slice_new0 (UnityApplicationsLensDaemonUpdatePopularitiesData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_applications_lens_daemon_update_popularities);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_applications_lens_daemon_update_popularities_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	unity_applications_lens_daemon_update_popularities_co (_data_);
}


static void unity_applications_lens_daemon_update_popularities_finish (UnityApplicationsLensDaemon* self, GAsyncResult* _res_) {
	UnityApplicationsLensDaemonUpdatePopularitiesData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gpointer _g_ptr_array_ref0 (gpointer self) {
	return self ? g_ptr_array_ref (self) : NULL;
}


static void unity_applications_lens_daemon_update_popularities_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	UnityApplicationsLensDaemonUpdatePopularitiesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	unity_applications_lens_daemon_update_popularities_co (_data_);
}


static gboolean unity_applications_lens_daemon_update_popularities_co (UnityApplicationsLensDaemonUpdatePopularitiesData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = 0LL;
		_data_->_tmp0_ = zeitgeist_timestamp_for_now ();
		_data_->end_ts = _data_->_tmp0_;
		_data_->_tmp1_ = _data_->end_ts;
		_data_->_tmp2_ = ZEITGEIST_TIMESTAMP_WEEK;
		_data_->start_ts = _data_->_tmp1_ - (_data_->_tmp2_ * 3);
		_data_->_tmp3_ = _data_->self->priv->log;
		_data_->_tmp4_ = _data_->start_ts;
		_data_->_tmp5_ = _data_->end_ts;
		_data_->_tmp6_ = zeitgeist_time_range_new (_data_->_tmp4_, _data_->_tmp5_);
		_data_->_tmp7_ = g_object_ref_sink (_data_->_tmp6_);
		_data_->_tmp8_ = _data_->self->priv->zg_templates;
		_data_->_tmp9_ = _g_ptr_array_ref0 (_data_->_tmp8_);
		_data_->_state_ = 1;
		zeitgeist_log_find_events (_data_->_tmp3_, _data_->_tmp7_, _data_->_tmp9_, ZEITGEIST_STORAGE_STATE_ANY, (guint32) 256, ZEITGEIST_RESULT_TYPE_MOST_POPULAR_SUBJECTS, NULL, unity_applications_lens_daemon_update_popularities_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp10_ = NULL;
		_data_->_tmp10_ = zeitgeist_log_find_events_finish (_data_->_tmp3_, _data_->_res_, &_data_->_inner_error_);
		_data_->_tmp11_ = _data_->_tmp10_;
		_g_object_unref0 (_data_->_tmp7_);
		_data_->rs = _data_->_tmp11_;
		if (_data_->_inner_error_ != NULL) {
			goto __catch2_g_error;
		}
		_data_->relevancy = 256;
		{
			_data_->_tmp12_ = _data_->rs;
			_data_->_tmp13_ = NULL;
			_data_->_tmp13_ = _vala_zeitgeist_result_set_iterator (_data_->_tmp12_);
			_data_->_event_it = _data_->_tmp13_;
			while (TRUE) {
				_data_->_tmp14_ = _data_->_event_it;
				_data_->_tmp15_ = NULL;
				_data_->_tmp15_ = _vala_zeitgeist_result_set_next_value (_data_->_tmp14_);
				_data_->event = _data_->_tmp15_;
				_data_->_tmp16_ = _data_->event;
				if (!(_data_->_tmp16_ != NULL)) {
					break;
				}
				{
					_data_->i = 0;
					{
						_data_->_tmp17_ = TRUE;
						while (TRUE) {
							_data_->_tmp18_ = _data_->_tmp17_;
							if (!_data_->_tmp18_) {
								_data_->_tmp19_ = _data_->i;
								_data_->i = _data_->_tmp19_ + 1;
							}
							_data_->_tmp17_ = FALSE;
							_data_->_tmp20_ = _data_->i;
							_data_->_tmp21_ = _data_->event;
							_data_->_tmp22_ = 0;
							_data_->_tmp22_ = zeitgeist_event_num_subjects (_data_->_tmp21_);
							if (!(_data_->_tmp20_ < _data_->_tmp22_)) {
								break;
							}
							_data_->_tmp23_ = _data_->event;
							_data_->_tmp24_ = _data_->i;
							_data_->_tmp25_ = NULL;
							_data_->_tmp25_ = zeitgeist_event_get_subject (_data_->_tmp23_, _data_->_tmp24_);
							_data_->_tmp26_ = NULL;
							_data_->_tmp26_ = zeitgeist_subject_get_uri (_data_->_tmp25_);
							_data_->uri = _data_->_tmp26_;
							_data_->_tmp27_ = _data_->uri;
							if (_data_->_tmp27_ == NULL) {
								continue;
							}
							_data_->_tmp28_ = _data_->self->priv->popularity_map;
							_data_->_tmp29_ = _data_->uri;
							_data_->_tmp30_ = _data_->relevancy;
							gee_map_set (_data_->_tmp28_, _data_->_tmp29_, GINT_TO_POINTER (_data_->_tmp30_));
						}
					}
				}
				_data_->_tmp31_ = _data_->relevancy;
				_data_->relevancy = _data_->_tmp31_ - 1;
			}
			_g_object_unref0 (_data_->_event_it);
		}
		_g_object_unref0 (_data_->rs);
	}
	goto __finally2;
	__catch2_g_error:
	{
		_data_->err = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp32_ = _data_->err;
		_data_->_tmp33_ = _data_->_tmp32_->message;
		g_warning ("daemon.vala:439: %s", _data_->_tmp33_);
		_g_error_free0 (_data_->err);
	}
	__finally2:
	if (_data_->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void unity_applications_lens_daemon_update_scope_search_data_free (gpointer _data) {
	UnityApplicationsLensDaemonUpdateScopeSearchData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->search);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (UnityApplicationsLensDaemonUpdateScopeSearchData, _data_);
}


static void unity_applications_lens_daemon_update_scope_search (UnityApplicationsLensDaemon* self, UnityLensSearch* search, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityApplicationsLensDaemonUpdateScopeSearchData* _data_;
	UnityApplicationsLensDaemon* _tmp0_;
	UnityLensSearch* _tmp1_;
	UnityLensSearch* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
	_data_ = g_slice_new0 (UnityApplicationsLensDaemonUpdateScopeSearchData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_applications_lens_daemon_update_scope_search);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_applications_lens_daemon_update_scope_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = search;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->search = _tmp2_;
	_tmp3_ = cancellable;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_data_->cancellable = _tmp4_;
	unity_applications_lens_daemon_update_scope_search_co (_data_);
}


static void unity_applications_lens_daemon_update_scope_search_finish (UnityApplicationsLensDaemon* self, GAsyncResult* _res_) {
	UnityApplicationsLensDaemonUpdateScopeSearchData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void unity_applications_lens_daemon_update_scope_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	UnityApplicationsLensDaemonUpdateScopeSearchData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	unity_applications_lens_daemon_update_scope_search_co (_data_);
}


static GVariant* _variant_new4 (const gchar* value) {
	return g_variant_ref_sink (g_variant_new_string (value));
}


static gboolean unity_applications_lens_daemon_update_scope_search_co (UnityApplicationsLensDaemonUpdateScopeSearchData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->search;
	_data_->_tmp1_ = unity_lens_search_get_results_model (_data_->_tmp0_);
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = _g_object_ref0 (_data_->_tmp2_);
	_data_->model = _data_->_tmp3_;
	_data_->_tmp4_ = _data_->search;
	_data_->_tmp5_ = unity_lens_search_get_search_string (_data_->_tmp4_);
	_data_->_tmp6_ = _data_->_tmp5_;
	g_debug ("daemon.vala:450: Searching for: %s", _data_->_tmp6_);
	_data_->_tmp7_ = _data_->self->priv->scope;
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = unity_scope_get_filter (_data_->_tmp7_, "type");
	_data_->filter = UNITY_IS_OPTIONS_FILTER (_data_->_tmp8_) ? ((UnityOptionsFilter*) _data_->_tmp8_) : NULL;
	_data_->_tmp9_ = _data_->search;
	_data_->_tmp10_ = _data_->filter;
	_data_->_tmp11_ = NULL;
	_data_->_tmp11_ = unity_applications_lens_daemon_prepare_pkg_search_string (_data_->self, _data_->_tmp9_, _data_->_tmp10_);
	_data_->pkg_search_string = _data_->_tmp11_;
	_data_->_tmp12_ = _data_->search;
	_data_->_tmp13_ = FALSE;
	_data_->_tmp13_ = unity_applications_lens_utils_is_search_empty (_data_->_tmp12_);
	_data_->has_search = !_data_->_tmp13_;
	_data_->_tmp14_ = g_timer_new ();
	_data_->timer = _data_->_tmp14_;
	_data_->_tmp15_ = _data_->model;
	_data_->_tmp16_ = (DeeTransaction*) dee_transaction_new ((DeeModel*) _data_->_tmp15_);
	_data_->transaction = _data_->_tmp16_;
	_data_->_tmp17_ = _data_->transaction;
	dee_model_clear ((DeeModel*) _data_->_tmp17_);
	_data_->_tmp18_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL);
	_data_->installed_uris = (GeeSet*) _data_->_tmp18_;
	_data_->_tmp19_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL);
	_data_->available_uris = (GeeSet*) _data_->_tmp19_;
	_data_->_tmp21_ = _data_->has_search;
	if (_data_->_tmp21_) {
		_data_->_tmp20_ = UNITY_PACKAGE_SORT_BY_RELEVANCY;
	} else {
		_data_->_tmp20_ = UNITY_PACKAGE_SORT_BY_NAME;
	}
	_data_->_tmp22_ = _data_->self->appsearcher;
	_data_->_tmp23_ = _data_->pkg_search_string;
	_data_->_tmp24_ = _data_->_tmp20_;
	_data_->_tmp25_ = NULL;
	_data_->_tmp25_ = unity_package_searcher_search (_data_->_tmp22_, _data_->_tmp23_, (guint) 0, UNITY_PACKAGE_SEARCHTYPE_PREFIX, _data_->_tmp24_);
	_data_->appresults = _data_->_tmp25_;
	_data_->_tmp26_ = FALSE;
	_data_->_tmp26_ = unity_applications_lens_daemon_local_apps_active (_data_->self);
	if (_data_->_tmp26_) {
		_data_->_tmp27_ = _data_->has_search;
		if (_data_->_tmp27_) {
			_data_->_tmp28_ = _data_->appresults;
			unity_applications_lens_daemon_resort_pkg_search_results (_data_->self, _data_->_tmp28_);
		}
		_data_->_tmp29_ = _data_->appresults;
		_data_->_tmp30_ = _data_->installed_uris;
		_data_->_tmp31_ = _data_->available_uris;
		_data_->_tmp32_ = _data_->transaction;
		unity_applications_lens_daemon_add_pkg_search_result (_data_->self, _data_->_tmp29_, _data_->_tmp30_, _data_->_tmp31_, (DeeModel*) _data_->_tmp32_, UNITY_APPLICATIONS_LENS_CATEGORY_INSTALLED, (guint) 0);
	}
	_data_->_tmp33_ = _data_->timer;
	g_timer_stop (_data_->_tmp33_);
	_data_->_tmp34_ = _data_->appresults;
	_data_->_tmp35_ = _data_->_tmp34_->num_hits;
	_data_->_tmp36_ = _data_->timer;
	_data_->_tmp37_ = 0.0;
	_data_->_tmp37_ = g_timer_elapsed (_data_->_tmp36_, NULL);
	_data_->_tmp38_ = _data_->pkg_search_string;
	g_debug ("daemon.vala:483: Entry search listed %i Installed apps in %fms for que" \
"ry: %s", _data_->_tmp35_, _data_->_tmp37_ * 1000, _data_->_tmp38_);
	_data_->_tmp40_ = FALSE;
	_data_->_tmp40_ = unity_applications_lens_daemon_local_apps_active (_data_->self);
	if (_data_->_tmp40_) {
		_data_->_tmp41_ = _data_->self->priv->_display_recent_apps;
		_data_->_tmp39_ = _data_->_tmp41_;
	} else {
		_data_->_tmp39_ = FALSE;
	}
	_data_->_tmp42_ = _data_->_tmp39_;
	if (_data_->_tmp42_) {
		{
			_data_->_tmp43_ = _data_->timer;
			g_timer_start (_data_->_tmp43_);
			_data_->_tmp44_ = _data_->filter;
			_data_->_tmp45_ = NULL;
			_data_->_tmp45_ = unity_applications_lens_daemon_prepare_zg_search_string (_data_->self, "", _data_->_tmp44_);
			_data_->zg_search_string = _data_->_tmp45_;
			_data_->_tmp46_ = _data_->self->priv->zg_index;
			_data_->_tmp47_ = _data_->zg_search_string;
			_data_->_tmp48_ = zeitgeist_time_range_new_anytime ();
			_data_->_tmp49_ = g_object_ref_sink (_data_->_tmp48_);
			_data_->_tmp50_ = _data_->self->priv->zg_templates;
			_data_->_tmp51_ = _g_ptr_array_ref0 (_data_->_tmp50_);
			_data_->_tmp52_ = _data_->cancellable;
			_data_->_state_ = 1;
			zeitgeist_index_search (_data_->_tmp46_, _data_->_tmp47_, _data_->_tmp49_, _data_->_tmp51_, (guint32) 0, (guint32) 20, ZEITGEIST_RESULT_TYPE_MOST_RECENT_SUBJECTS, _data_->_tmp52_, unity_applications_lens_daemon_update_scope_search_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp53_ = NULL;
			_data_->_tmp53_ = zeitgeist_index_search_finish (_data_->_tmp46_, _data_->_res_, &_data_->_inner_error_);
			_data_->_tmp54_ = _data_->_tmp53_;
			_g_object_unref0 (_data_->_tmp49_);
			_data_->results = _data_->_tmp54_;
			if (_data_->_inner_error_ != NULL) {
				_g_free0 (_data_->zg_search_string);
				if (g_error_matches (_data_->_inner_error_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
					goto __catch3_g_io_error_cancelled;
				}
				goto __catch3_g_error;
			}
			_data_->_tmp55_ = _data_->results;
			_data_->_tmp56_ = _data_->transaction;
			_data_->_tmp57_ = _data_->installed_uris;
			unity_applications_lens_daemon_append_events_with_category (_data_->self, _data_->_tmp55_, (DeeModel*) _data_->_tmp56_, (guint) UNITY_APPLICATIONS_LENS_CATEGORY_RECENT, FALSE, 6, _data_->_tmp57_);
			_data_->_tmp58_ = _data_->timer;
			g_timer_stop (_data_->_tmp58_);
			_data_->_tmp59_ = _data_->results;
			_data_->_tmp60_ = 0U;
			_data_->_tmp60_ = zeitgeist_result_set_size (_data_->_tmp59_);
			_data_->_tmp61_ = _data_->results;
			_data_->_tmp62_ = 0U;
			_data_->_tmp62_ = zeitgeist_result_set_estimated_matches (_data_->_tmp61_);
			_data_->_tmp63_ = _data_->timer;
			_data_->_tmp64_ = 0.0;
			_data_->_tmp64_ = g_timer_elapsed (_data_->_tmp63_, NULL);
			_data_->_tmp65_ = _data_->zg_search_string;
			g_debug ("daemon.vala:508: Entry search found %u/%u Recently Used apps in %fms f" \
"or query '%s'", _data_->_tmp60_, _data_->_tmp62_, _data_->_tmp64_ * 1000, _data_->_tmp65_);
			_g_object_unref0 (_data_->results);
			_g_free0 (_data_->zg_search_string);
		}
		goto __finally3;
		__catch3_g_io_error_cancelled:
		{
			_data_->ioe = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_g_error_free0 (_data_->ioe);
			_unity_package_search_result_free0 (_data_->appresults);
			_g_object_unref0 (_data_->available_uris);
			_g_object_unref0 (_data_->installed_uris);
			_g_object_unref0 (_data_->transaction);
			_g_timer_destroy0 (_data_->timer);
			_g_free0 (_data_->pkg_search_string);
			_g_object_unref0 (_data_->filter);
			_g_object_unref0 (_data_->model);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		goto __finally3;
		__catch3_g_error:
		{
			_data_->e = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_data_->_tmp66_ = _data_->search;
			_data_->_tmp67_ = unity_lens_search_get_search_string (_data_->_tmp66_);
			_data_->_tmp68_ = _data_->_tmp67_;
			_data_->_tmp69_ = _data_->e;
			_data_->_tmp70_ = _data_->_tmp69_->message;
			g_warning ("daemon.vala:516: Error performing search '%s': %s", _data_->_tmp68_, _data_->_tmp70_);
			_g_error_free0 (_data_->e);
		}
		__finally3:
		if (_data_->_inner_error_ != NULL) {
			_unity_package_search_result_free0 (_data_->appresults);
			_g_object_unref0 (_data_->available_uris);
			_g_object_unref0 (_data_->installed_uris);
			_g_object_unref0 (_data_->transaction);
			_g_timer_destroy0 (_data_->timer);
			_g_free0 (_data_->pkg_search_string);
			_g_object_unref0 (_data_->filter);
			_g_object_unref0 (_data_->model);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->_tmp71_ = _data_->transaction;
	dee_transaction_commit (_data_->_tmp71_, &_data_->_inner_error_);
	if (_data_->_inner_error_ != NULL) {
		_unity_package_search_result_free0 (_data_->appresults);
		_g_object_unref0 (_data_->available_uris);
		_g_object_unref0 (_data_->installed_uris);
		_g_object_unref0 (_data_->transaction);
		_g_timer_destroy0 (_data_->timer);
		_g_free0 (_data_->pkg_search_string);
		_g_object_unref0 (_data_->filter);
		_g_object_unref0 (_data_->model);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->_tmp74_ = FALSE;
	_data_->_tmp74_ = unity_applications_lens_daemon_usc_apps_active (_data_->self);
	if (_data_->_tmp74_) {
		_data_->_tmp75_ = _data_->self->priv->_display_available_apps;
		_data_->_tmp73_ = _data_->_tmp75_;
	} else {
		_data_->_tmp73_ = FALSE;
	}
	_data_->_tmp76_ = _data_->_tmp73_;
	if (_data_->_tmp76_) {
		_data_->_tmp77_ = _data_->self->priv->pkgsearcher;
		_data_->_tmp72_ = _data_->_tmp77_ != NULL;
	} else {
		_data_->_tmp72_ = FALSE;
	}
	_data_->_tmp78_ = _data_->_tmp72_;
	if (_data_->_tmp78_) {
		_data_->_tmp79_ = _data_->has_search;
		if (_data_->_tmp79_) {
			_data_->_tmp80_ = _data_->timer;
			g_timer_start (_data_->_tmp80_);
			_data_->_tmp81_ = _data_->self->priv->pkgsearcher;
			_data_->_tmp82_ = _data_->pkg_search_string;
			_data_->_tmp83_ = NULL;
			_data_->_tmp83_ = unity_package_searcher_search (_data_->_tmp81_, _data_->_tmp82_, (guint) 50, UNITY_PACKAGE_SEARCHTYPE_PREFIX, UNITY_PACKAGE_SORT_BY_RELEVANCY);
			_data_->pkgresults = _data_->_tmp83_;
			_data_->_tmp84_ = _data_->pkgresults;
			_data_->_tmp85_ = _data_->installed_uris;
			_data_->_tmp86_ = _data_->available_uris;
			_data_->_tmp87_ = _data_->model;
			unity_applications_lens_daemon_add_pkg_search_result (_data_->self, _data_->_tmp84_, _data_->_tmp85_, _data_->_tmp86_, (DeeModel*) _data_->_tmp87_, UNITY_APPLICATIONS_LENS_CATEGORY_AVAILABLE, (guint) 0);
			_data_->_tmp88_ = _data_->timer;
			g_timer_stop (_data_->_tmp88_);
			_data_->_tmp89_ = _data_->pkgresults;
			_data_->_tmp90_ = _data_->_tmp89_->num_hits;
			_data_->_tmp91_ = _data_->timer;
			_data_->_tmp92_ = 0.0;
			_data_->_tmp92_ = g_timer_elapsed (_data_->_tmp91_, NULL);
			_data_->_tmp93_ = _data_->pkg_search_string;
			g_debug ("daemon.vala:535: Entry search listed %i Available apps in %fms for que" \
"ry: %s", _data_->_tmp90_, _data_->_tmp92_ * 1000, _data_->_tmp93_);
			_unity_package_search_result_free0 (_data_->pkgresults);
		} else {
			_data_->_tmp94_ = _data_->timer;
			g_timer_start (_data_->_tmp94_);
			_data_->_tmp95_ = _data_->search;
			_data_->_tmp96_ = _data_->filter;
			_data_->_tmp97_ = NULL;
			_data_->_tmp97_ = unity_applications_lens_daemon_prepare_pkg_search_string (_data_->self, _data_->_tmp95_, _data_->_tmp96_);
			_data_->filter_query = _data_->_tmp97_;
			_data_->_tmp98_ = _data_->self->priv->pkgsearcher;
			_data_->_tmp99_ = _data_->filter_query;
			_data_->_tmp100_ = NULL;
			_data_->_tmp100_ = unity_package_searcher_get_random_apps (_data_->_tmp98_, _data_->_tmp99_, (guint) 12);
			_data_->random_pkgresults = _data_->_tmp100_;
			_data_->_tmp101_ = _data_->random_pkgresults;
			_data_->_tmp102_ = _data_->installed_uris;
			_data_->_tmp103_ = _data_->available_uris;
			_data_->_tmp104_ = _data_->model;
			unity_applications_lens_daemon_add_pkg_search_result (_data_->self, _data_->_tmp101_, _data_->_tmp102_, _data_->_tmp103_, (DeeModel*) _data_->_tmp104_, UNITY_APPLICATIONS_LENS_CATEGORY_AVAILABLE, (guint) 6);
			_data_->_tmp105_ = _data_->timer;
			g_timer_stop (_data_->_tmp105_);
			_data_->_tmp106_ = _data_->random_pkgresults;
			_data_->_tmp107_ = _data_->_tmp106_->num_hits;
			_data_->_tmp108_ = _data_->timer;
			_data_->_tmp109_ = 0.0;
			_data_->_tmp109_ = g_timer_elapsed (_data_->_tmp108_, NULL);
			g_debug ("daemon.vala:546: Entry search listed %i random Available apps in %fms", _data_->_tmp107_, _data_->_tmp109_ * 1000);
			_unity_package_search_result_free0 (_data_->random_pkgresults);
			_g_free0 (_data_->filter_query);
		}
	}
	_data_->_tmp110_ = _data_->model;
	_data_->_tmp111_ = 0U;
	_data_->_tmp111_ = dee_model_get_n_rows ((DeeModel*) _data_->_tmp110_);
	if (_data_->_tmp111_ == ((guint) 0)) {
		_data_->_tmp112_ = _data_->search;
		_data_->_tmp113_ = NULL;
		_data_->_tmp113_ = _ ("Sorry, there are no applications that match your search.");
		_data_->_tmp114_ = _variant_new4 (_data_->_tmp113_);
		unity_lens_search_set_reply_hint (_data_->_tmp112_, "no-results-hint", _data_->_tmp114_);
	}
	_data_->_tmp115_ = _data_->search;
	g_signal_emit_by_name (_data_->_tmp115_, "finished");
	_unity_package_search_result_free0 (_data_->appresults);
	_g_object_unref0 (_data_->available_uris);
	_g_object_unref0 (_data_->installed_uris);
	_g_object_unref0 (_data_->transaction);
	_g_timer_destroy0 (_data_->timer);
	_g_free0 (_data_->pkg_search_string);
	_g_object_unref0 (_data_->filter);
	_g_object_unref0 (_data_->model);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void unity_applications_lens_daemon_update_global_search_data_free (gpointer _data) {
	UnityApplicationsLensDaemonUpdateGlobalSearchData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->search);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (UnityApplicationsLensDaemonUpdateGlobalSearchData, _data_);
}


static void unity_applications_lens_daemon_update_global_search (UnityApplicationsLensDaemon* self, UnityLensSearch* search, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityApplicationsLensDaemonUpdateGlobalSearchData* _data_;
	UnityApplicationsLensDaemon* _tmp0_;
	UnityLensSearch* _tmp1_;
	UnityLensSearch* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
	_data_ = g_slice_new0 (UnityApplicationsLensDaemonUpdateGlobalSearchData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_applications_lens_daemon_update_global_search);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_applications_lens_daemon_update_global_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = search;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->search = _tmp2_;
	_tmp3_ = cancellable;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_data_->cancellable = _tmp4_;
	unity_applications_lens_daemon_update_global_search_co (_data_);
}


static void unity_applications_lens_daemon_update_global_search_finish (UnityApplicationsLensDaemon* self, GAsyncResult* _res_) {
	UnityApplicationsLensDaemonUpdateGlobalSearchData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void unity_applications_lens_daemon_update_global_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	UnityApplicationsLensDaemonUpdateGlobalSearchData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	unity_applications_lens_daemon_update_global_search_co (_data_);
}


static gboolean unity_applications_lens_daemon_update_global_search_co (UnityApplicationsLensDaemonUpdateGlobalSearchData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->search;
	_data_->_tmp1_ = FALSE;
	_data_->_tmp1_ = unity_applications_lens_utils_is_search_empty (_data_->_tmp0_);
	if (_data_->_tmp1_) {
		_data_->_tmp2_ = _data_->search;
		_data_->_tmp3_ = _data_->cancellable;
		_data_->_state_ = 1;
		unity_applications_lens_daemon_update_global_without_search (_data_->self, _data_->_tmp2_, _data_->_tmp3_, unity_applications_lens_daemon_update_global_search_ready, _data_);
		return FALSE;
		_state_1:
		unity_applications_lens_daemon_update_global_without_search_finish (_data_->self, _data_->_res_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp4_ = _data_->search;
	_data_->_tmp5_ = unity_lens_search_get_results_model (_data_->_tmp4_);
	_data_->_tmp6_ = _data_->_tmp5_;
	_data_->_tmp7_ = _g_object_ref0 (_data_->_tmp6_);
	_data_->model = _data_->_tmp7_;
	_data_->_tmp8_ = _data_->model;
	dee_model_clear ((DeeModel*) _data_->_tmp8_);
	_data_->_tmp9_ = _data_->search;
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = unity_applications_lens_daemon_prepare_pkg_search_string (_data_->self, _data_->_tmp9_, NULL);
	_data_->search_string = _data_->_tmp10_;
	_data_->_tmp11_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL);
	_data_->installed_uris = (GeeSet*) _data_->_tmp11_;
	_data_->_tmp12_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL);
	_data_->available_uris = (GeeSet*) _data_->_tmp12_;
	_data_->_tmp13_ = g_timer_new ();
	_data_->timer = _data_->_tmp13_;
	_data_->_tmp14_ = _data_->self->appsearcher;
	_data_->_tmp15_ = _data_->search_string;
	_data_->_tmp16_ = NULL;
	_data_->_tmp16_ = unity_package_searcher_search (_data_->_tmp14_, _data_->_tmp15_, (guint) 0, UNITY_PACKAGE_SEARCHTYPE_PREFIX, UNITY_PACKAGE_SORT_BY_RELEVANCY);
	_data_->appresults = _data_->_tmp16_;
	_data_->_tmp17_ = _data_->appresults;
	unity_applications_lens_daemon_resort_pkg_search_results (_data_->self, _data_->_tmp17_);
	_data_->_tmp18_ = _data_->appresults;
	_data_->_tmp19_ = _data_->installed_uris;
	_data_->_tmp20_ = _data_->available_uris;
	_data_->_tmp21_ = _data_->model;
	unity_applications_lens_daemon_add_pkg_search_result (_data_->self, _data_->_tmp18_, _data_->_tmp19_, _data_->_tmp20_, (DeeModel*) _data_->_tmp21_, UNITY_APPLICATIONS_LENS_CATEGORY_APPLICATIONS, (guint) 0);
	_data_->_tmp22_ = _data_->timer;
	g_timer_stop (_data_->_tmp22_);
	_data_->_tmp23_ = _data_->appresults;
	_data_->_tmp24_ = _data_->_tmp23_->num_hits;
	_data_->_tmp25_ = _data_->timer;
	_data_->_tmp26_ = 0.0;
	_data_->_tmp26_ = g_timer_elapsed (_data_->_tmp25_, NULL);
	_data_->_tmp27_ = _data_->search_string;
	g_debug ("daemon.vala:590: Global search listed %i Installed apps in %fms for qu" \
"ery: %s", _data_->_tmp24_, _data_->_tmp26_ * 1000, _data_->_tmp27_);
	_data_->_tmp28_ = _data_->search;
	g_signal_emit_by_name (_data_->_tmp28_, "finished");
	_unity_package_search_result_free0 (_data_->appresults);
	_g_timer_destroy0 (_data_->timer);
	_g_object_unref0 (_data_->available_uris);
	_g_object_unref0 (_data_->installed_uris);
	_g_free0 (_data_->search_string);
	_g_object_unref0 (_data_->model);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void unity_applications_lens_daemon_update_global_without_search_data_free (gpointer _data) {
	UnityApplicationsLensDaemonUpdateGlobalWithoutSearchData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->search);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (UnityApplicationsLensDaemonUpdateGlobalWithoutSearchData, _data_);
}


static void unity_applications_lens_daemon_update_global_without_search (UnityApplicationsLensDaemon* self, UnityLensSearch* search, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityApplicationsLensDaemonUpdateGlobalWithoutSearchData* _data_;
	UnityApplicationsLensDaemon* _tmp0_;
	UnityLensSearch* _tmp1_;
	UnityLensSearch* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
	_data_ = g_slice_new0 (UnityApplicationsLensDaemonUpdateGlobalWithoutSearchData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_applications_lens_daemon_update_global_without_search);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_applications_lens_daemon_update_global_without_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = search;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->search = _tmp2_;
	_tmp3_ = cancellable;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_data_->cancellable = _tmp4_;
	unity_applications_lens_daemon_update_global_without_search_co (_data_);
}


static void unity_applications_lens_daemon_update_global_without_search_finish (UnityApplicationsLensDaemon* self, GAsyncResult* _res_) {
	UnityApplicationsLensDaemonUpdateGlobalWithoutSearchData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void unity_applications_lens_daemon_update_global_without_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	UnityApplicationsLensDaemonUpdateGlobalWithoutSearchData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	unity_applications_lens_daemon_update_global_without_search_co (_data_);
}


static gboolean unity_applications_lens_daemon_update_global_without_search_co (UnityApplicationsLensDaemonUpdateGlobalWithoutSearchData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->search;
	_data_->_tmp1_ = unity_lens_search_get_results_model (_data_->_tmp0_);
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = _g_object_ref0 (_data_->_tmp2_);
	_data_->model = _data_->_tmp3_;
	_data_->_tmp4_ = g_timer_new ();
	_data_->timer = _data_->_tmp4_;
	_data_->_tmp6_ = FALSE;
	_data_->_tmp6_ = unity_applications_lens_daemon_local_apps_active (_data_->self);
	if (_data_->_tmp6_) {
		_data_->_tmp7_ = _data_->self->priv->_display_recent_apps;
		_data_->_tmp5_ = _data_->_tmp7_;
	} else {
		_data_->_tmp5_ = FALSE;
	}
	_data_->_tmp8_ = _data_->_tmp5_;
	if (_data_->_tmp8_) {
		{
			_data_->_tmp9_ = _data_->search;
			_data_->_tmp10_ = unity_lens_search_get_search_string (_data_->_tmp9_);
			_data_->_tmp11_ = _data_->_tmp10_;
			_data_->_tmp12_ = NULL;
			_data_->_tmp12_ = unity_applications_lens_daemon_prepare_zg_search_string (_data_->self, _data_->_tmp11_, NULL);
			_data_->zg_search_string = _data_->_tmp12_;
			_data_->_tmp13_ = zeitgeist_time_range_new_anytime ();
			_data_->_tmp14_ = g_object_ref_sink (_data_->_tmp13_);
			_data_->time_range = _data_->_tmp14_;
			_data_->_tmp15_ = _data_->self->priv->log;
			_data_->_tmp16_ = _data_->time_range;
			_data_->_tmp17_ = _data_->self->priv->zg_templates;
			_data_->_tmp18_ = _g_ptr_array_ref0 (_data_->_tmp17_);
			_data_->_tmp19_ = _data_->cancellable;
			_data_->_state_ = 1;
			zeitgeist_log_find_events (_data_->_tmp15_, _data_->_tmp16_, _data_->_tmp18_, ZEITGEIST_STORAGE_STATE_ANY, (guint32) 40, ZEITGEIST_RESULT_TYPE_MOST_RECENT_SUBJECTS, _data_->_tmp19_, unity_applications_lens_daemon_update_global_without_search_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp20_ = NULL;
			_data_->_tmp20_ = zeitgeist_log_find_events_finish (_data_->_tmp15_, _data_->_res_, &_data_->_inner_error_);
			_data_->results = _data_->_tmp20_;
			if (_data_->_inner_error_ != NULL) {
				_g_object_unref0 (_data_->time_range);
				_g_free0 (_data_->zg_search_string);
				if (g_error_matches (_data_->_inner_error_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
					goto __catch4_g_io_error_cancelled;
				}
				goto __catch4_g_error;
			}
			_data_->_tmp21_ = _data_->model;
			dee_model_clear ((DeeModel*) _data_->_tmp21_);
			_data_->_tmp22_ = _data_->results;
			_data_->_tmp23_ = _data_->model;
			_data_->_tmp24_ = G_MAXINT;
			unity_applications_lens_daemon_append_events_with_category (_data_->self, _data_->_tmp22_, (DeeModel*) _data_->_tmp23_, (guint) UNITY_APPLICATIONS_LENS_CATEGORY_RECENT_APPS, FALSE, _data_->_tmp24_, NULL);
			_data_->_tmp25_ = _data_->timer;
			g_timer_stop (_data_->_tmp25_);
			_data_->_tmp26_ = _data_->results;
			_data_->_tmp27_ = 0U;
			_data_->_tmp27_ = zeitgeist_result_set_size (_data_->_tmp26_);
			_data_->_tmp28_ = _data_->results;
			_data_->_tmp29_ = 0U;
			_data_->_tmp29_ = zeitgeist_result_set_estimated_matches (_data_->_tmp28_);
			_data_->_tmp30_ = _data_->timer;
			_data_->_tmp31_ = 0.0;
			_data_->_tmp31_ = g_timer_elapsed (_data_->_tmp30_, NULL);
			_data_->_tmp32_ = _data_->zg_search_string;
			g_debug ("daemon.vala:631: Entry search found %u/%u Recently Used apps in %fms f" \
"or query '%s'", _data_->_tmp27_, _data_->_tmp29_, _data_->_tmp31_ * 1000, _data_->_tmp32_);
			_g_object_unref0 (_data_->results);
			_g_object_unref0 (_data_->time_range);
			_g_free0 (_data_->zg_search_string);
		}
		goto __finally4;
		__catch4_g_io_error_cancelled:
		{
			_data_->ioe = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_g_error_free0 (_data_->ioe);
			_g_timer_destroy0 (_data_->timer);
			_g_object_unref0 (_data_->model);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		goto __finally4;
		__catch4_g_error:
		{
			_data_->e = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_data_->_tmp33_ = _data_->search;
			_data_->_tmp34_ = unity_lens_search_get_search_string (_data_->_tmp33_);
			_data_->_tmp35_ = _data_->_tmp34_;
			_data_->_tmp36_ = _data_->e;
			_data_->_tmp37_ = _data_->_tmp36_->message;
			g_warning ("daemon.vala:639: Error performing search '%s': %s", _data_->_tmp35_, _data_->_tmp37_);
			_g_error_free0 (_data_->e);
		}
		__finally4:
		if (_data_->_inner_error_ != NULL) {
			_g_timer_destroy0 (_data_->timer);
			_g_object_unref0 (_data_->model);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->_tmp38_ = _data_->search;
	g_signal_emit_by_name (_data_->_tmp38_, "finished");
	_g_timer_destroy0 (_data_->timer);
	_g_object_unref0 (_data_->model);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gchar* unity_applications_lens_daemon_extract_type_query (UnityApplicationsLensDaemon* self, UnityOptionsFilter* options) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	UnityOptionsFilter* _tmp1_;
	gboolean _tmp5_;
	gchar* _result_;
	gchar* _tmp26_ = NULL;
	const gchar* _tmp27_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = options;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		UnityOptionsFilter* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp2_ = options;
		_tmp3_ = unity_filter_get_filtering ((UnityFilter*) _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = !_tmp4_;
	}
	_tmp5_ = _tmp0_;
	if (_tmp5_) {
		gchar* _tmp6_;
		_tmp6_ = g_strdup ("NOT category:XYZ");
		result = _tmp6_;
		return result;
	}
	_result_ = NULL;
	{
		const gchar** type_id_collection = NULL;
		gint type_id_collection_length1 = 0;
		gint _type_id_collection_size_ = 0;
		gint type_id_it = 0;
		type_id_collection = UNITY_APPLICATIONS_LENS_DAEMON_option_types;
		type_id_collection_length1 = G_N_ELEMENTS (UNITY_APPLICATIONS_LENS_DAEMON_option_types);
		for (type_id_it = 0; type_id_it < G_N_ELEMENTS (UNITY_APPLICATIONS_LENS_DAEMON_option_types); type_id_it = type_id_it + 1) {
			const gchar* type_id = NULL;
			type_id = type_id_collection[type_id_it];
			{
				UnityOptionsFilter* _tmp7_;
				const gchar* _tmp8_;
				UnityFilterOption* _tmp9_ = NULL;
				UnityFilterOption* option;
				UnityFilterOption* _tmp10_;
				UnityFilterOption* _tmp11_;
				gboolean _tmp12_;
				gboolean _tmp13_;
				const gchar* _tmp14_;
				_tmp7_ = options;
				_tmp8_ = type_id;
				_tmp9_ = unity_options_filter_get_option (_tmp7_, _tmp8_);
				option = _tmp9_;
				_tmp10_ = option;
				if (_tmp10_ == NULL) {
					_g_object_unref0 (option);
					continue;
				}
				_tmp11_ = option;
				_tmp12_ = unity_filter_option_get_active (_tmp11_);
				_tmp13_ = _tmp12_;
				if (!_tmp13_) {
					_g_object_unref0 (option);
					continue;
				}
				_tmp14_ = _result_;
				if (_tmp14_ == NULL) {
					GHashTable* _tmp15_;
					const gchar* _tmp16_;
					gconstpointer _tmp17_ = NULL;
					gchar* _tmp18_;
					_tmp15_ = self->priv->type_queries;
					_tmp16_ = type_id;
					_tmp17_ = g_hash_table_lookup (_tmp15_, _tmp16_);
					_tmp18_ = g_strdup ((const gchar*) _tmp17_);
					_g_free0 (_result_);
					_result_ = _tmp18_;
				} else {
					const gchar* _tmp19_;
					GHashTable* _tmp20_;
					const gchar* _tmp21_;
					gconstpointer _tmp22_ = NULL;
					gchar* _tmp23_;
					gchar* _tmp24_;
					gchar* _tmp25_;
					_tmp19_ = _result_;
					_tmp20_ = self->priv->type_queries;
					_tmp21_ = type_id;
					_tmp22_ = g_hash_table_lookup (_tmp20_, _tmp21_);
					_tmp23_ = g_strconcat (" OR ", (const gchar*) _tmp22_, NULL);
					_tmp24_ = _tmp23_;
					_tmp25_ = g_strconcat (_tmp19_, _tmp24_, NULL);
					_g_free0 (_result_);
					_result_ = _tmp25_;
					_g_free0 (_tmp24_);
				}
				_g_object_unref0 (option);
			}
		}
	}
	_tmp27_ = _result_;
	if (_tmp27_ == NULL) {
		gchar* _tmp28_;
		_tmp28_ = g_strdup ("NOT category:XYZ");
		_g_free0 (_tmp26_);
		_tmp26_ = _tmp28_;
	} else {
		const gchar* _tmp29_;
		gchar* _tmp30_ = NULL;
		_tmp29_ = _result_;
		_tmp30_ = g_strdup_printf ("(%s)", _tmp29_);
		_g_free0 (_tmp26_);
		_tmp26_ = _tmp30_;
	}
	result = _tmp26_;
	_g_free0 (_result_);
	return result;
}


static gchar* string_delimit (const gchar* self, const gchar* delimiters, gchar new_delimiter) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (delimiters != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	_tmp2_ = delimiters;
	_tmp3_ = new_delimiter;
	g_strdelimit (_tmp1_, _tmp2_, _tmp3_);
	result = _result_;
	return result;
}


static gchar* unity_applications_lens_daemon_prepare_pkg_search_string (UnityApplicationsLensDaemon* self, UnityLensSearch* search, UnityOptionsFilter* options) {
	gchar* result = NULL;
	UnityLensSearch* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (search != NULL, NULL);
	_tmp0_ = search;
	_tmp1_ = unity_applications_lens_utils_is_search_empty (_tmp0_);
	if (_tmp1_) {
		gboolean _tmp2_ = FALSE;
		UnityOptionsFilter* _tmp3_;
		gboolean _tmp7_;
		_tmp3_ = options;
		if (_tmp3_ == NULL) {
			_tmp2_ = TRUE;
		} else {
			UnityOptionsFilter* _tmp4_;
			gboolean _tmp5_;
			gboolean _tmp6_;
			_tmp4_ = options;
			_tmp5_ = unity_filter_get_filtering ((UnityFilter*) _tmp4_);
			_tmp6_ = _tmp5_;
			_tmp2_ = !_tmp6_;
		}
		_tmp7_ = _tmp2_;
		if (_tmp7_) {
			gchar* _tmp8_;
			_tmp8_ = g_strdup ("type:Application");
			result = _tmp8_;
			return result;
		} else {
			UnityOptionsFilter* _tmp9_;
			gchar* _tmp10_ = NULL;
			gchar* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			_tmp9_ = options;
			_tmp10_ = unity_applications_lens_daemon_extract_type_query (self, _tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = g_strconcat ("type:Application AND ", _tmp11_, NULL);
			_tmp13_ = _tmp12_;
			_g_free0 (_tmp11_);
			result = _tmp13_;
			return result;
		}
	} else {
		UnityLensSearch* _tmp14_;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* s;
		const gchar* _tmp18_;
		gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		gchar* _tmp21_ = NULL;
		gboolean _tmp22_ = FALSE;
		UnityOptionsFilter* _tmp23_;
		gboolean _tmp27_;
		_tmp14_ = search;
		_tmp15_ = unity_lens_search_get_search_string (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = g_strdup (_tmp16_);
		s = _tmp17_;
		_tmp18_ = s;
		_tmp19_ = string_strip (_tmp18_);
		_g_free0 (s);
		s = _tmp19_;
		_tmp20_ = s;
		_tmp21_ = string_delimit (_tmp20_, "-", ' ');
		_g_free0 (s);
		s = _tmp21_;
		_tmp23_ = options;
		if (_tmp23_ == NULL) {
			_tmp22_ = TRUE;
		} else {
			UnityOptionsFilter* _tmp24_;
			gboolean _tmp25_;
			gboolean _tmp26_;
			_tmp24_ = options;
			_tmp25_ = unity_filter_get_filtering ((UnityFilter*) _tmp24_);
			_tmp26_ = _tmp25_;
			_tmp22_ = !_tmp26_;
		}
		_tmp27_ = _tmp22_;
		if (_tmp27_) {
			const gchar* _tmp28_;
			gchar* _tmp29_;
			_tmp28_ = s;
			_tmp29_ = g_strconcat ("type:Application AND ", _tmp28_, NULL);
			result = _tmp29_;
			_g_free0 (s);
			return result;
		} else {
			UnityOptionsFilter* _tmp30_;
			gchar* _tmp31_ = NULL;
			gchar* _tmp32_;
			const gchar* _tmp33_;
			gchar* _tmp34_ = NULL;
			gchar* _tmp35_;
			_tmp30_ = options;
			_tmp31_ = unity_applications_lens_daemon_extract_type_query (self, _tmp30_);
			_tmp32_ = _tmp31_;
			_tmp33_ = s;
			_tmp34_ = g_strdup_printf ("type:Application AND %s AND %s", _tmp32_, _tmp33_);
			_tmp35_ = _tmp34_;
			_g_free0 (_tmp32_);
			result = _tmp35_;
			_g_free0 (s);
			return result;
		}
		_g_free0 (s);
	}
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


GIcon* unity_applications_lens_daemon_find_pkg_icon (UnityApplicationsLensDaemon* self, UnityPackageInfo* pkginfo) {
	GIcon* result = NULL;
	UnityPackageInfo* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* desktop_id;
	UnityAppInfoManager* _tmp3_ = NULL;
	UnityAppInfoManager* _tmp4_;
	const gchar* _tmp5_;
	GAppInfo* _tmp6_ = NULL;
	GAppInfo* _tmp7_;
	gboolean _tmp8_;
	gboolean installed;
	gboolean _tmp9_;
	UnityPackageInfo* _tmp13_;
	const gchar* _tmp14_;
	gboolean _tmp15_ = FALSE;
	GThemedIcon* _tmp94_;
	GThemedIcon* icon;
	GHashTable* _tmp95_;
	UnityPackageInfo* _tmp96_;
	const gchar* _tmp97_;
	gchar* _tmp98_;
	GThemedIcon* _tmp99_;
	GIcon* _tmp100_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (pkginfo != NULL, NULL);
	_tmp0_ = pkginfo;
	_tmp1_ = _tmp0_->desktop_file;
	_tmp2_ = g_path_get_basename (_tmp1_);
	desktop_id = _tmp2_;
	_tmp3_ = unity_app_info_manager_get_default ();
	_tmp4_ = _tmp3_;
	_tmp5_ = desktop_id;
	_tmp6_ = unity_app_info_manager_lookup (_tmp4_, _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _tmp7_ != NULL;
	_g_object_unref0 (_tmp7_);
	_g_object_unref0 (_tmp4_);
	installed = _tmp8_;
	_tmp9_ = installed;
	if (_tmp9_) {
		UnityPackageInfo* _tmp10_;
		const gchar* _tmp11_;
		GThemedIcon* _tmp12_;
		_tmp10_ = pkginfo;
		_tmp11_ = _tmp10_->icon;
		_tmp12_ = (GThemedIcon*) g_themed_icon_new (_tmp11_);
		result = (GIcon*) _tmp12_;
		_g_free0 (desktop_id);
		return result;
	}
	_tmp13_ = pkginfo;
	_tmp14_ = _tmp13_->icon;
	_tmp15_ = g_str_has_prefix (_tmp14_, "/");
	if (_tmp15_) {
		UnityPackageInfo* _tmp16_;
		const gchar* _tmp17_;
		GFile* _tmp18_ = NULL;
		GFile* _tmp19_;
		GFileIcon* _tmp20_;
		GIcon* _tmp21_;
		_tmp16_ = pkginfo;
		_tmp17_ = _tmp16_->icon;
		_tmp18_ = g_file_new_for_path (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = (GFileIcon*) g_file_icon_new (_tmp19_);
		_tmp21_ = (GIcon*) _tmp20_;
		_g_object_unref0 (_tmp19_);
		result = _tmp21_;
		_g_free0 (desktop_id);
		return result;
	} else {
		GHashTable* _tmp22_;
		UnityPackageInfo* _tmp23_;
		const gchar* _tmp24_;
		gconstpointer _tmp25_ = NULL;
		GIcon* _tmp26_;
		GIcon* icon;
		GIcon* _tmp27_;
		gchar* path = NULL;
		UnityPackageInfo* _tmp28_;
		const gchar* _tmp29_;
		gboolean _tmp30_ = FALSE;
		_tmp22_ = self->priv->file_icon_cache;
		_tmp23_ = pkginfo;
		_tmp24_ = _tmp23_->icon;
		_tmp25_ = g_hash_table_lookup (_tmp22_, _tmp24_);
		_tmp26_ = _g_object_ref0 ((GIcon*) _tmp25_);
		icon = _tmp26_;
		_tmp27_ = icon;
		if (_tmp27_ != NULL) {
			result = icon;
			_g_free0 (desktop_id);
			return result;
		}
		_tmp28_ = pkginfo;
		_tmp29_ = _tmp28_->icon;
		_tmp30_ = string_contains (_tmp29_, ".");
		if (_tmp30_) {
			const gchar* _tmp31_ = NULL;
			UnityPackageInfo* _tmp32_;
			const gchar* _tmp33_;
			const gchar* _tmp34_ = NULL;
			gchar* _tmp35_ = NULL;
			const gchar* _tmp36_;
			gboolean _tmp37_ = FALSE;
			const gchar* _tmp48_ = NULL;
			UnityPackageInfo* _tmp49_;
			const gchar* _tmp50_;
			gchar* _tmp51_ = NULL;
			const gchar* _tmp52_;
			gboolean _tmp53_ = FALSE;
			_tmp31_ = string_to_string (CONFIG_DATADIR);
			_tmp32_ = pkginfo;
			_tmp33_ = _tmp32_->icon;
			_tmp34_ = string_to_string (_tmp33_);
			_tmp35_ = g_strconcat (_tmp31_, "/app-install/icons/", _tmp34_, NULL);
			_g_free0 (path);
			path = _tmp35_;
			_tmp36_ = path;
			_tmp37_ = g_file_test (_tmp36_, G_FILE_TEST_EXISTS);
			if (_tmp37_) {
				const gchar* _tmp38_;
				GFile* _tmp39_ = NULL;
				GFile* _tmp40_;
				GFileIcon* _tmp41_;
				GHashTable* _tmp42_;
				UnityPackageInfo* _tmp43_;
				const gchar* _tmp44_;
				gchar* _tmp45_;
				GIcon* _tmp46_;
				GIcon* _tmp47_;
				_tmp38_ = path;
				_tmp39_ = g_file_new_for_path (_tmp38_);
				_tmp40_ = _tmp39_;
				_tmp41_ = (GFileIcon*) g_file_icon_new (_tmp40_);
				_g_object_unref0 (icon);
				icon = (GIcon*) _tmp41_;
				_g_object_unref0 (_tmp40_);
				_tmp42_ = self->priv->file_icon_cache;
				_tmp43_ = pkginfo;
				_tmp44_ = _tmp43_->icon;
				_tmp45_ = g_strdup (_tmp44_);
				_tmp46_ = icon;
				_tmp47_ = _g_object_ref0 (_tmp46_);
				g_hash_table_insert (_tmp42_, _tmp45_, _tmp47_);
				result = icon;
				_g_free0 (path);
				_g_free0 (desktop_id);
				return result;
			}
			_tmp48_ = g_get_user_cache_dir ();
			_tmp49_ = pkginfo;
			_tmp50_ = _tmp49_->icon;
			_tmp51_ = g_build_filename (_tmp48_, "software-center", "icons", _tmp50_, NULL);
			_g_free0 (path);
			path = _tmp51_;
			_tmp52_ = path;
			_tmp53_ = g_file_test (_tmp52_, G_FILE_TEST_EXISTS);
			if (_tmp53_) {
				const gchar* _tmp54_;
				GFile* _tmp55_ = NULL;
				GFile* _tmp56_;
				GFileIcon* _tmp57_;
				GHashTable* _tmp58_;
				UnityPackageInfo* _tmp59_;
				const gchar* _tmp60_;
				gchar* _tmp61_;
				GIcon* _tmp62_;
				GIcon* _tmp63_;
				_tmp54_ = path;
				_tmp55_ = g_file_new_for_path (_tmp54_);
				_tmp56_ = _tmp55_;
				_tmp57_ = (GFileIcon*) g_file_icon_new (_tmp56_);
				_g_object_unref0 (icon);
				icon = (GIcon*) _tmp57_;
				_g_object_unref0 (_tmp56_);
				_tmp58_ = self->priv->file_icon_cache;
				_tmp59_ = pkginfo;
				_tmp60_ = _tmp59_->icon;
				_tmp61_ = g_strdup (_tmp60_);
				_tmp62_ = icon;
				_tmp63_ = _g_object_ref0 (_tmp62_);
				g_hash_table_insert (_tmp58_, _tmp61_, _tmp63_);
				result = icon;
				_g_free0 (path);
				_g_free0 (desktop_id);
				return result;
			}
		}
		{
			GeeList* _tmp64_;
			GeeList* _tmp65_;
			GeeList* _ext_list;
			GeeList* _tmp66_;
			gint _tmp67_;
			gint _tmp68_;
			gint _ext_size;
			gint _ext_index;
			_tmp64_ = self->priv->image_extensions;
			_tmp65_ = _g_object_ref0 (_tmp64_);
			_ext_list = _tmp65_;
			_tmp66_ = _ext_list;
			_tmp67_ = gee_collection_get_size ((GeeCollection*) _tmp66_);
			_tmp68_ = _tmp67_;
			_ext_size = _tmp68_;
			_ext_index = -1;
			while (TRUE) {
				gint _tmp69_;
				gint _tmp70_;
				gint _tmp71_;
				GeeList* _tmp72_;
				gint _tmp73_;
				gpointer _tmp74_ = NULL;
				gchar* ext;
				const gchar* _tmp75_ = NULL;
				UnityPackageInfo* _tmp76_;
				const gchar* _tmp77_;
				const gchar* _tmp78_ = NULL;
				const gchar* _tmp79_;
				const gchar* _tmp80_ = NULL;
				gchar* _tmp81_ = NULL;
				const gchar* _tmp82_;
				gboolean _tmp83_ = FALSE;
				_tmp69_ = _ext_index;
				_ext_index = _tmp69_ + 1;
				_tmp70_ = _ext_index;
				_tmp71_ = _ext_size;
				if (!(_tmp70_ < _tmp71_)) {
					break;
				}
				_tmp72_ = _ext_list;
				_tmp73_ = _ext_index;
				_tmp74_ = gee_list_get (_tmp72_, _tmp73_);
				ext = (gchar*) _tmp74_;
				_tmp75_ = string_to_string (CONFIG_DATADIR);
				_tmp76_ = pkginfo;
				_tmp77_ = _tmp76_->icon;
				_tmp78_ = string_to_string (_tmp77_);
				_tmp79_ = ext;
				_tmp80_ = string_to_string (_tmp79_);
				_tmp81_ = g_strconcat (_tmp75_, "/app-install/icons/", _tmp78_, ".", _tmp80_, NULL);
				_g_free0 (path);
				path = _tmp81_;
				_tmp82_ = path;
				_tmp83_ = g_file_test (_tmp82_, G_FILE_TEST_EXISTS);
				if (_tmp83_) {
					const gchar* _tmp84_;
					GFile* _tmp85_ = NULL;
					GFile* _tmp86_;
					GFileIcon* _tmp87_;
					GHashTable* _tmp88_;
					UnityPackageInfo* _tmp89_;
					const gchar* _tmp90_;
					gchar* _tmp91_;
					GIcon* _tmp92_;
					GIcon* _tmp93_;
					_tmp84_ = path;
					_tmp85_ = g_file_new_for_path (_tmp84_);
					_tmp86_ = _tmp85_;
					_tmp87_ = (GFileIcon*) g_file_icon_new (_tmp86_);
					_g_object_unref0 (icon);
					icon = (GIcon*) _tmp87_;
					_g_object_unref0 (_tmp86_);
					_tmp88_ = self->priv->file_icon_cache;
					_tmp89_ = pkginfo;
					_tmp90_ = _tmp89_->icon;
					_tmp91_ = g_strdup (_tmp90_);
					_tmp92_ = icon;
					_tmp93_ = _g_object_ref0 (_tmp92_);
					g_hash_table_insert (_tmp88_, _tmp91_, _tmp93_);
					result = icon;
					_g_free0 (ext);
					_g_object_unref0 (_ext_list);
					_g_free0 (path);
					_g_free0 (desktop_id);
					return result;
				}
				_g_free0 (ext);
			}
			_g_object_unref0 (_ext_list);
		}
		_g_free0 (path);
		_g_object_unref0 (icon);
	}
	_tmp94_ = (GThemedIcon*) g_themed_icon_new ("applications-other");
	icon = _tmp94_;
	_tmp95_ = self->priv->file_icon_cache;
	_tmp96_ = pkginfo;
	_tmp97_ = _tmp96_->icon;
	_tmp98_ = g_strdup (_tmp97_);
	_tmp99_ = icon;
	_tmp100_ = _g_object_ref0 ((GIcon*) _tmp99_);
	g_hash_table_insert (_tmp95_, _tmp98_, _tmp100_);
	result = (GIcon*) icon;
	_g_free0 (desktop_id);
	return result;
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gint _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _result_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = needle;
	_tmp2_ = strstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	glong string_length;
	glong _tmp2_;
	glong _tmp5_;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_;
	gboolean _tmp12_;
	gboolean _tmp13_ = FALSE;
	glong _tmp14_;
	gboolean _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_;
		glong _tmp4_;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_;
		glong _tmp7_;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	_tmp12_ = _tmp8_;
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp14_ = end;
	if (_tmp14_ >= ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = end;
		_tmp16_ = string_length;
		_tmp13_ = _tmp15_ <= _tmp16_;
	} else {
		_tmp13_ = FALSE;
	}
	_tmp17_ = _tmp13_;
	g_return_val_if_fail (_tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	g_return_val_if_fail (_tmp18_ <= _tmp19_, NULL);
	_tmp20_ = start;
	_tmp21_ = end;
	_tmp22_ = start;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) (_tmp21_ - _tmp22_));
	result = _tmp23_;
	return result;
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		const gchar* _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		GRegex* _tmp3_;
		GRegex* _tmp4_;
		GRegex* regex;
		GRegex* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch5_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp5_ = regex;
		_tmp6_ = replacement;
		_tmp7_ = g_regex_replace_literal (_tmp5_, self, (gssize) (-1), 0, _tmp6_, 0, &_inner_error_);
		_tmp8_ = _tmp7_;
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch5_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp8_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally5;
	__catch5_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally5:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gchar* unity_applications_lens_daemon_extract_desktop_id (UnityApplicationsLensDaemon* self, const gchar* desktop_file, gboolean unmangle) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* desktop_id;
	const gchar* _tmp4_;
	gint _tmp5_ = 0;
	gint colon_pos;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_;
	gboolean _tmp9_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = desktop_file;
	if (_tmp0_ == NULL) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("");
		result = _tmp1_;
		return result;
	}
	_tmp2_ = desktop_file;
	_tmp3_ = g_path_get_basename (_tmp2_);
	desktop_id = _tmp3_;
	_tmp4_ = desktop_id;
	_tmp5_ = string_index_of (_tmp4_, ":", 0);
	colon_pos = _tmp5_;
	_tmp7_ = unmangle;
	if (_tmp7_) {
		gint _tmp8_;
		_tmp8_ = colon_pos;
		_tmp6_ = _tmp8_ > 0;
	} else {
		_tmp6_ = FALSE;
	}
	_tmp9_ = _tmp6_;
	if (_tmp9_) {
		const gchar* _tmp10_;
		gint _tmp11_;
		const gchar* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gchar* _tmp15_ = NULL;
		const gchar* _tmp16_;
		gchar* _tmp17_ = NULL;
		_tmp10_ = desktop_id;
		_tmp11_ = colon_pos;
		_tmp12_ = desktop_id;
		_tmp13_ = strlen (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = string_slice (_tmp10_, (glong) (_tmp11_ + 1), (glong) _tmp14_);
		_g_free0 (desktop_id);
		desktop_id = _tmp15_;
		_tmp16_ = desktop_id;
		_tmp17_ = string_replace (_tmp16_, "__", "-");
		_g_free0 (desktop_id);
		desktop_id = _tmp17_;
	}
	result = desktop_id;
	return result;
}


static gint __lambda4_ (UnityApplicationsLensDaemon* self, UnityPackageInfo* a, UnityPackageInfo* b) {
	gint result = 0;
	UnityPackageInfo* _tmp0_;
	gint _tmp1_;
	gint rel_a;
	UnityPackageInfo* _tmp2_;
	gint _tmp3_;
	gint rel_b;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp6_ = 0;
	gint delta;
	gint _tmp7_;
	gint _tmp24_;
	gint _tmp25_;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = a;
	_tmp1_ = _tmp0_->relevancy;
	rel_a = _tmp1_;
	_tmp2_ = b;
	_tmp3_ = _tmp2_->relevancy;
	rel_b = _tmp3_;
	_tmp4_ = rel_a;
	_tmp5_ = rel_b;
	_tmp6_ = abs (_tmp4_ - _tmp5_);
	delta = _tmp6_;
	_tmp7_ = delta;
	if (_tmp7_ < 10) {
		UnityPackageInfo* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_ = NULL;
		gchar* id_a;
		UnityPackageInfo* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_ = NULL;
		gchar* id_b;
		GeeMap* _tmp14_;
		const gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gpointer _tmp18_ = NULL;
		GeeMap* _tmp19_;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gpointer _tmp23_ = NULL;
		_tmp8_ = a;
		_tmp9_ = _tmp8_->desktop_file;
		_tmp10_ = unity_applications_lens_daemon_extract_desktop_id (self, _tmp9_, FALSE);
		id_a = _tmp10_;
		_tmp11_ = b;
		_tmp12_ = _tmp11_->desktop_file;
		_tmp13_ = unity_applications_lens_daemon_extract_desktop_id (self, _tmp12_, FALSE);
		id_b = _tmp13_;
		_tmp14_ = self->priv->popularity_map;
		_tmp15_ = id_a;
		_tmp16_ = g_strconcat ("application://", _tmp15_, NULL);
		_tmp17_ = _tmp16_;
		_tmp18_ = gee_map_get (_tmp14_, _tmp17_);
		rel_a = GPOINTER_TO_INT (_tmp18_);
		_g_free0 (_tmp17_);
		_tmp19_ = self->priv->popularity_map;
		_tmp20_ = id_b;
		_tmp21_ = g_strconcat ("application://", _tmp20_, NULL);
		_tmp22_ = _tmp21_;
		_tmp23_ = gee_map_get (_tmp19_, _tmp22_);
		rel_b = GPOINTER_TO_INT (_tmp23_);
		_g_free0 (_tmp22_);
		_g_free0 (id_b);
		_g_free0 (id_a);
	}
	_tmp24_ = rel_b;
	_tmp25_ = rel_a;
	result = _tmp24_ - _tmp25_;
	return result;
}


static gint ___lambda4__gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gint result;
	result = __lambda4_ (self, a, b);
	return result;
}


static void unity_applications_lens_daemon_resort_pkg_search_results (UnityApplicationsLensDaemon* self, UnityPackageSearchResult* results) {
	UnityPackageSearchResult* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (results != NULL);
	_tmp0_ = results;
	_tmp0_->results = g_slist_sort_with_data (_tmp0_->results, ___lambda4__gcompare_data_func, self);
}


static void unity_applications_lens_daemon_add_pkg_search_result (UnityApplicationsLensDaemon* self, UnityPackageSearchResult* results, GeeSet* installed_uris, GeeSet* available_uris, DeeModel* model, UnityApplicationsLensCategory category, guint max_add) {
	UnityAppInfoManager* _tmp0_ = NULL;
	UnityAppInfoManager* appmanager;
	UnityScope* _tmp1_;
	UnityFilter* _tmp2_ = NULL;
	UnityRatingsFilter* ratings_filter;
	guint n_added;
	UnityPackageSearchResult* _tmp3_;
	GSList* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (results != NULL);
	g_return_if_fail (installed_uris != NULL);
	g_return_if_fail (available_uris != NULL);
	g_return_if_fail (model != NULL);
	_tmp0_ = unity_app_info_manager_get_default ();
	appmanager = _tmp0_;
	_tmp1_ = self->priv->scope;
	_tmp2_ = unity_scope_get_filter (_tmp1_, "rating");
	ratings_filter = UNITY_IS_RATINGS_FILTER (_tmp2_) ? ((UnityRatingsFilter*) _tmp2_) : NULL;
	n_added = (guint) 0;
	_tmp3_ = results;
	_tmp4_ = _tmp3_->results;
	{
		GSList* pkginfo_collection = NULL;
		GSList* pkginfo_it = NULL;
		pkginfo_collection = _tmp4_;
		for (pkginfo_it = pkginfo_collection; pkginfo_it != NULL; pkginfo_it = pkginfo_it->next) {
			UnityPackageInfo* pkginfo = NULL;
			pkginfo = (UnityPackageInfo*) pkginfo_it->data;
			{
				UnityPackageInfo* _tmp5_;
				const gchar* _tmp6_;
				UnityPackageInfo* _tmp7_;
				const gchar* _tmp8_;
				UnityApplicationsLensCategory _tmp9_;
				gchar* _tmp10_ = NULL;
				gchar* desktop_id;
				gchar* full_path = NULL;
				UnityAppInfoManager* _tmp11_;
				const gchar* _tmp12_;
				GAppInfo* _tmp13_ = NULL;
				GAppInfo* app;
				UnityAppInfoManager* _tmp14_;
				const gchar* _tmp15_;
				gchar* _tmp16_ = NULL;
				const gchar* _tmp17_;
				const gchar* _tmp18_ = NULL;
				gchar* _tmp19_ = NULL;
				gchar* uri;
				gboolean _tmp20_ = FALSE;
				GeeSet* _tmp21_;
				const gchar* _tmp22_;
				gboolean _tmp23_ = FALSE;
				gboolean _tmp27_;
				gchar* display_name = NULL;
				gchar* comment = NULL;
				UnityApplicationsLensCategory _tmp28_;
				gboolean _tmp47_ = FALSE;
				GAppInfo* _tmp48_;
				gboolean _tmp51_;
				UnityApplicationsLensCategory _tmp52_;
				UnityPackageInfo* _tmp79_;
				GIcon* _tmp80_ = NULL;
				GIcon* icon;
				const gchar* _tmp81_ = NULL;
				const gchar* _tmp82_;
				const gchar* _tmp84_ = NULL;
				const gchar* _tmp85_;
				gchar* _tmp87_ = NULL;
				const gchar* _tmp88_;
				DeeModel* _tmp92_;
				const gchar* _tmp93_;
				GIcon* _tmp94_;
				gchar* _tmp95_ = NULL;
				gchar* _tmp96_;
				UnityApplicationsLensCategory _tmp97_;
				const gchar* _tmp98_;
				const gchar* _tmp99_;
				const gchar* _tmp100_;
				guint _tmp101_;
				gboolean _tmp102_ = FALSE;
				guint _tmp103_;
				gboolean _tmp106_;
				_tmp5_ = pkginfo;
				_tmp6_ = _tmp5_->desktop_file;
				if (_tmp6_ == NULL) {
					continue;
				}
				_tmp7_ = pkginfo;
				_tmp8_ = _tmp7_->desktop_file;
				_tmp9_ = category;
				_tmp10_ = unity_applications_lens_daemon_extract_desktop_id (self, _tmp8_, _tmp9_ == UNITY_APPLICATIONS_LENS_CATEGORY_AVAILABLE);
				desktop_id = _tmp10_;
				_tmp11_ = appmanager;
				_tmp12_ = desktop_id;
				_tmp13_ = unity_app_info_manager_lookup (_tmp11_, _tmp12_);
				app = _tmp13_;
				_tmp14_ = appmanager;
				_tmp15_ = desktop_id;
				_tmp16_ = unity_app_info_manager_get_path (_tmp14_, _tmp15_);
				_g_free0 (full_path);
				full_path = _tmp16_;
				_tmp17_ = desktop_id;
				_tmp18_ = string_to_string (_tmp17_);
				_tmp19_ = g_strconcat ("application://", _tmp18_, NULL);
				uri = _tmp19_;
				_tmp21_ = installed_uris;
				_tmp22_ = uri;
				_tmp23_ = gee_collection_contains ((GeeCollection*) _tmp21_, _tmp22_);
				if (_tmp23_) {
					_tmp20_ = TRUE;
				} else {
					GeeSet* _tmp24_;
					const gchar* _tmp25_;
					gboolean _tmp26_ = FALSE;
					_tmp24_ = available_uris;
					_tmp25_ = uri;
					_tmp26_ = gee_collection_contains ((GeeCollection*) _tmp24_, _tmp25_);
					_tmp20_ = _tmp26_;
				}
				_tmp27_ = _tmp20_;
				if (_tmp27_) {
					_g_free0 (uri);
					_g_object_unref0 (app);
					_g_free0 (full_path);
					_g_free0 (desktop_id);
					continue;
				}
				_tmp28_ = category;
				switch (_tmp28_) {
					case UNITY_APPLICATIONS_LENS_CATEGORY_INSTALLED:
					case UNITY_APPLICATIONS_LENS_CATEGORY_APPLICATIONS:
					{
						GeeSet* _tmp29_;
						const gchar* _tmp30_;
						GAppInfo* _tmp31_;
						const gchar* _tmp32_ = NULL;
						gchar* _tmp33_;
						GAppInfo* _tmp34_;
						const gchar* _tmp35_ = NULL;
						gchar* _tmp36_;
						_tmp29_ = installed_uris;
						_tmp30_ = uri;
						gee_collection_add ((GeeCollection*) _tmp29_, _tmp30_);
						_tmp31_ = app;
						_tmp32_ = g_app_info_get_display_name (_tmp31_);
						_tmp33_ = g_strdup (_tmp32_);
						_g_free0 (display_name);
						display_name = _tmp33_;
						_tmp34_ = app;
						_tmp35_ = g_app_info_get_description (_tmp34_);
						_tmp36_ = g_strdup (_tmp35_);
						_g_free0 (comment);
						comment = _tmp36_;
						break;
					}
					case UNITY_APPLICATIONS_LENS_CATEGORY_AVAILABLE:
					{
						GeeSet* _tmp37_;
						const gchar* _tmp38_;
						UnityPackageInfo* _tmp39_;
						const gchar* _tmp40_;
						gchar* _tmp41_;
						gchar* _tmp42_;
						_tmp37_ = available_uris;
						_tmp38_ = uri;
						gee_collection_add ((GeeCollection*) _tmp37_, _tmp38_);
						_tmp39_ = pkginfo;
						_tmp40_ = _tmp39_->application_name;
						_tmp41_ = g_strdup (_tmp40_);
						_g_free0 (display_name);
						display_name = _tmp41_;
						_tmp42_ = g_strdup ("");
						_g_free0 (comment);
						comment = _tmp42_;
						break;
					}
					default:
					{
						UnityApplicationsLensCategory _tmp43_;
						GEnumValue* _tmp44_;
						gchar* _tmp45_ = NULL;
						gchar* _tmp46_;
						_tmp43_ = category;
						_tmp44_ = g_enum_get_value (g_type_class_ref (UNITY_APPLICATIONS_LENS_TYPE_CATEGORY), _tmp43_);
						_tmp45_ = g_strconcat ("Illegal category for package search ", (_tmp44_ != NULL) ? _tmp44_->value_name : NULL, NULL);
						_tmp46_ = _tmp45_;
						g_warning ("daemon.vala:875: %s", _tmp46_);
						_g_free0 (_tmp46_);
						continue;
					}
				}
				_tmp48_ = app;
				if (_tmp48_ != NULL) {
					GAppInfo* _tmp49_;
					gboolean _tmp50_ = FALSE;
					_tmp49_ = app;
					_tmp50_ = g_app_info_should_show (_tmp49_);
					_tmp47_ = !_tmp50_;
				} else {
					_tmp47_ = FALSE;
				}
				_tmp51_ = _tmp47_;
				if (_tmp51_) {
					_g_free0 (comment);
					_g_free0 (display_name);
					_g_free0 (uri);
					_g_object_unref0 (app);
					_g_free0 (full_path);
					_g_free0 (desktop_id);
					continue;
				}
				_tmp52_ = category;
				if (_tmp52_ == UNITY_APPLICATIONS_LENS_CATEGORY_AVAILABLE) {
					GAppInfo* _tmp53_;
					gboolean _tmp54_ = FALSE;
					UnityRatingsDatabase* _tmp55_;
					gboolean _tmp59_;
					UnityPackageInfo* _tmp70_;
					const gchar* _tmp71_;
					const gchar* _tmp72_ = NULL;
					UnityPackageInfo* _tmp73_;
					const gchar* _tmp74_;
					const gchar* _tmp75_ = NULL;
					gchar* _tmp76_ = NULL;
					GeeSet* _tmp77_;
					const gchar* _tmp78_;
					_tmp53_ = app;
					if (_tmp53_ != NULL) {
						_g_free0 (comment);
						_g_free0 (display_name);
						_g_free0 (uri);
						_g_object_unref0 (app);
						_g_free0 (full_path);
						_g_free0 (desktop_id);
						continue;
					}
					_tmp55_ = self->priv->ratings;
					if (_tmp55_ != NULL) {
						UnityRatingsFilter* _tmp56_;
						gfloat _tmp57_;
						gfloat _tmp58_;
						_tmp56_ = ratings_filter;
						_tmp57_ = unity_ratings_filter_get_rating (_tmp56_);
						_tmp58_ = _tmp57_;
						_tmp54_ = ((gdouble) _tmp58_) > 0.00001;
					} else {
						_tmp54_ = FALSE;
					}
					_tmp59_ = _tmp54_;
					if (_tmp59_) {
						UnityRatingsResult _result_ = {0};
						UnityRatingsDatabase* _tmp60_;
						UnityPackageInfo* _tmp61_;
						const gchar* _tmp62_;
						UnityRatingsResult _tmp63_ = {0};
						gboolean _tmp64_ = FALSE;
						_tmp60_ = self->priv->ratings;
						_tmp61_ = pkginfo;
						_tmp62_ = _tmp61_->package_name;
						_tmp64_ = unity_ratings_database_query (_tmp60_, _tmp62_, &_tmp63_);
						_result_ = _tmp63_;
						if (_tmp64_) {
							UnityRatingsResult _tmp65_;
							gint32 _tmp66_;
							UnityRatingsFilter* _tmp67_;
							gfloat _tmp68_;
							gfloat _tmp69_;
							_tmp65_ = _result_;
							_tmp66_ = _tmp65_.average_rating;
							_tmp67_ = ratings_filter;
							_tmp68_ = unity_ratings_filter_get_rating (_tmp67_);
							_tmp69_ = _tmp68_;
							if (((gdouble) _tmp66_) < ((_tmp69_ * 5) - 0.2)) {
								_g_free0 (comment);
								_g_free0 (display_name);
								_g_free0 (uri);
								_g_object_unref0 (app);
								_g_free0 (full_path);
								_g_free0 (desktop_id);
								continue;
							}
						} else {
							_g_free0 (comment);
							_g_free0 (display_name);
							_g_free0 (uri);
							_g_object_unref0 (app);
							_g_free0 (full_path);
							_g_free0 (desktop_id);
							continue;
						}
					}
					_tmp70_ = pkginfo;
					_tmp71_ = _tmp70_->package_name;
					_tmp72_ = string_to_string (_tmp71_);
					_tmp73_ = pkginfo;
					_tmp74_ = _tmp73_->application_name;
					_tmp75_ = string_to_string (_tmp74_);
					_tmp76_ = g_strconcat ("unity-install://", _tmp72_, "/", _tmp75_, NULL);
					_g_free0 (uri);
					uri = _tmp76_;
					_tmp77_ = available_uris;
					_tmp78_ = uri;
					gee_collection_add ((GeeCollection*) _tmp77_, _tmp78_);
				}
				_tmp79_ = pkginfo;
				_tmp80_ = unity_applications_lens_daemon_find_pkg_icon (self, _tmp79_);
				icon = _tmp80_;
				_tmp82_ = display_name;
				if (_tmp82_ != NULL) {
					const gchar* _tmp83_;
					_tmp83_ = display_name;
					_tmp81_ = _tmp83_;
				} else {
					_tmp81_ = "";
				}
				_tmp85_ = comment;
				if (_tmp85_ != NULL) {
					const gchar* _tmp86_;
					_tmp86_ = comment;
					_tmp84_ = _tmp86_;
				} else {
					_tmp84_ = "";
				}
				_tmp88_ = full_path;
				if (_tmp88_ != NULL) {
					const gchar* _tmp89_;
					gchar* _tmp90_;
					_tmp89_ = full_path;
					_tmp90_ = g_strconcat ("file://", _tmp89_, NULL);
					_g_free0 (_tmp87_);
					_tmp87_ = _tmp90_;
				} else {
					gchar* _tmp91_;
					_tmp91_ = g_strdup ("");
					_g_free0 (_tmp87_);
					_tmp87_ = _tmp91_;
				}
				_tmp92_ = model;
				_tmp93_ = uri;
				_tmp94_ = icon;
				_tmp95_ = g_icon_to_string (_tmp94_);
				_tmp96_ = _tmp95_;
				_tmp97_ = category;
				_tmp98_ = _tmp81_;
				_tmp99_ = _tmp84_;
				_tmp100_ = _tmp87_;
				dee_model_append (_tmp92_, _tmp93_, _tmp96_, _tmp97_, "application/x-desktop", _tmp98_, _tmp99_, _tmp100_, NULL);
				_g_free0 (_tmp96_);
				_tmp101_ = n_added;
				n_added = _tmp101_ + 1;
				_tmp103_ = max_add;
				if (_tmp103_ > ((guint) 0)) {
					guint _tmp104_;
					guint _tmp105_;
					_tmp104_ = n_added;
					_tmp105_ = max_add;
					_tmp102_ = _tmp104_ >= _tmp105_;
				} else {
					_tmp102_ = FALSE;
				}
				_tmp106_ = _tmp102_;
				if (_tmp106_) {
					_g_free0 (_tmp87_);
					_g_object_unref0 (icon);
					_g_free0 (comment);
					_g_free0 (display_name);
					_g_free0 (uri);
					_g_object_unref0 (app);
					_g_free0 (full_path);
					_g_free0 (desktop_id);
					_g_object_unref0 (ratings_filter);
					_g_object_unref0 (appmanager);
					return;
				}
				_g_free0 (_tmp87_);
				_g_object_unref0 (icon);
				_g_free0 (comment);
				_g_free0 (display_name);
				_g_free0 (uri);
				_g_object_unref0 (app);
				_g_free0 (full_path);
				_g_free0 (desktop_id);
			}
		}
	}
	_g_object_unref0 (ratings_filter);
	_g_object_unref0 (appmanager);
}


/**
     * Override of the default activation handler. The apps lens daemon
     * can handle activation of installable apps using the Software Center
     */
static const gchar* string_offset (const gchar* self, glong offset) {
	const gchar* result = NULL;
	glong _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = offset;
	result = (const gchar*) (((gchar*) self) + _tmp0_);
	return result;
}


static void _g_list_free__g_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
	g_list_free (self);
}


UnityActivationResponse* unity_applications_lens_daemon_activate (UnityApplicationsLensDaemon* self, const gchar* uri) {
	UnityActivationResponse* result = NULL;
	gchar** args = NULL;
	gint args_length1 = 0;
	gint _args_size_ = 0;
	gchar* exec_or_dir;
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp67_ = FALSE;
	const gchar* _tmp68_;
	gboolean _tmp71_;
	UnityActivationResponse* _tmp88_;
	UnityActivationResponse* _tmp89_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	exec_or_dir = NULL;
	_tmp0_ = uri;
	_tmp1_ = g_str_has_prefix (_tmp0_, "unity-install://");
	if (_tmp1_) {
		const gchar* _tmp2_;
		const gchar* _tmp3_ = NULL;
		const gchar* pkg;
		const gchar* _tmp4_;
		gchar** _tmp5_ = NULL;
		gchar** _tmp6_;
		gint _tmp6__length1;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar** _tmp9_;
		gint _tmp9__length1;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp2_ = uri;
		_tmp3_ = string_offset (_tmp2_, (glong) 16);
		pkg = _tmp3_;
		_tmp4_ = pkg;
		g_debug ("daemon.vala:941: Installing: %s", _tmp4_);
		_tmp5_ = g_new0 (gchar*, 2 + 1);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		args = _tmp5_;
		args_length1 = 2;
		_args_size_ = args_length1;
		_tmp6_ = args;
		_tmp6__length1 = args_length1;
		_tmp7_ = g_strdup ("software-center");
		_g_free0 (_tmp6_[0]);
		_tmp6_[0] = _tmp7_;
		_tmp8_ = _tmp6_[0];
		_tmp9_ = args;
		_tmp9__length1 = args_length1;
		_tmp10_ = pkg;
		_tmp11_ = g_strdup (_tmp10_);
		_g_free0 (_tmp9_[1]);
		_tmp9_[1] = _tmp11_;
		_tmp12_ = _tmp9_[1];
	} else {
		const gchar* _tmp13_;
		gboolean _tmp14_ = FALSE;
		_tmp13_ = uri;
		_tmp14_ = g_str_has_prefix (_tmp13_, "unity-runner://");
		if (_tmp14_) {
			gchar* orig = NULL;
			const gchar* _tmp15_;
			const gchar* _tmp16_ = NULL;
			gchar* _tmp17_;
			const gchar* _tmp18_;
			gboolean _tmp19_ = FALSE;
			gboolean _tmp22_ = FALSE;
			GRegex* _tmp23_;
			gboolean _tmp27_;
			UnityApplicationsLensRunner* _tmp60_;
			const gchar* _tmp61_;
			_tmp15_ = uri;
			_tmp16_ = string_offset (_tmp15_, (glong) 15);
			_tmp17_ = g_strdup (_tmp16_);
			_g_free0 (orig);
			orig = _tmp17_;
			_tmp18_ = orig;
			_tmp19_ = g_str_has_prefix (_tmp18_, "\\\\");
			if (_tmp19_) {
				const gchar* _tmp20_;
				gchar* _tmp21_ = NULL;
				_tmp20_ = orig;
				_tmp21_ = string_replace (_tmp20_, "\\\\", "smb://");
				_g_free0 (orig);
				orig = _tmp21_;
			}
			_tmp23_ = self->priv->uri_regex;
			if (_tmp23_ != NULL) {
				GRegex* _tmp24_;
				const gchar* _tmp25_;
				gboolean _tmp26_ = FALSE;
				_tmp24_ = self->priv->uri_regex;
				_tmp25_ = orig;
				_tmp26_ = g_regex_match (_tmp24_, _tmp25_, 0, NULL);
				_tmp22_ = _tmp26_;
			} else {
				_tmp22_ = FALSE;
			}
			_tmp27_ = _tmp22_;
			if (_tmp27_) {
				UnityActivationResponse* _tmp41_;
				UnityActivationResponse* _tmp42_;
				{
					GRegex* _tmp28_;
					const gchar* _tmp29_;
					gboolean _tmp30_ = FALSE;
					_tmp28_ = self->priv->mountable_regex;
					_tmp29_ = orig;
					_tmp30_ = g_regex_match (_tmp28_, _tmp29_, 0, NULL);
					if (_tmp30_) {
						GList* muris;
						const gchar* _tmp31_;
						gchar* _tmp32_;
						GAppInfo* _tmp33_ = NULL;
						GAppInfo* _tmp34_;
						GAppInfo* file_manager;
						GAppInfo* _tmp35_;
						GList* _tmp36_;
						muris = NULL;
						_tmp31_ = orig;
						_tmp32_ = g_strdup (_tmp31_);
						muris = g_list_prepend (muris, _tmp32_);
						_tmp33_ = g_app_info_get_default_for_type ("inode/directory", TRUE);
						_tmp34_ = _g_object_ref0 (_tmp33_);
						file_manager = _tmp34_;
						_tmp35_ = file_manager;
						_tmp36_ = muris;
						g_app_info_launch_uris (_tmp35_, _tmp36_, NULL, &_inner_error_);
						if (_inner_error_ != NULL) {
							_g_object_unref0 (file_manager);
							__g_list_free__g_free0_0 (muris);
							goto __catch6_g_error;
						}
						_g_object_unref0 (file_manager);
						__g_list_free__g_free0_0 (muris);
					} else {
						const gchar* _tmp37_;
						_tmp37_ = orig;
						g_app_info_launch_default_for_uri (_tmp37_, NULL, &_inner_error_);
						if (_inner_error_ != NULL) {
							goto __catch6_g_error;
						}
					}
				}
				goto __finally6;
				__catch6_g_error:
				{
					GError* _error_ = NULL;
					const gchar* _tmp38_;
					UnityActivationResponse* _tmp39_;
					UnityActivationResponse* _tmp40_;
					_error_ = _inner_error_;
					_inner_error_ = NULL;
					_tmp38_ = orig;
					g_warning ("daemon.vala:965: Failed to launch URI %s", _tmp38_);
					_tmp39_ = unity_activation_response_new (UNITY_HANDLED_TYPE_NOT_HANDLED, "");
					_tmp40_ = g_object_ref_sink (_tmp39_);
					result = _tmp40_;
					_g_error_free0 (_error_);
					_g_free0 (orig);
					_g_free0 (exec_or_dir);
					args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
					return result;
				}
				__finally6:
				if (_inner_error_ != NULL) {
					_g_free0 (orig);
					_g_free0 (exec_or_dir);
					args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
				_tmp41_ = unity_activation_response_new (UNITY_HANDLED_TYPE_HIDE_DASH, "");
				_tmp42_ = g_object_ref_sink (_tmp41_);
				result = _tmp42_;
				_g_free0 (orig);
				_g_free0 (exec_or_dir);
				args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
				return result;
			} else {
				const gchar* _tmp43_;
				gchar* _tmp44_ = NULL;
				const gchar* _tmp45_;
				gchar** _tmp46_;
				gchar** _tmp47_ = NULL;
				_tmp43_ = orig;
				_tmp44_ = unity_applications_lens_utils_subst_tilde (_tmp43_);
				_g_free0 (exec_or_dir);
				exec_or_dir = _tmp44_;
				_tmp45_ = exec_or_dir;
				_tmp47_ = _tmp46_ = g_strsplit (_tmp45_, " ", 0);
				args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
				args = _tmp47_;
				args_length1 = _vala_array_length (_tmp46_);
				_args_size_ = args_length1;
				{
					gint i;
					i = 0;
					{
						gboolean _tmp48_;
						_tmp48_ = TRUE;
						while (TRUE) {
							gboolean _tmp49_;
							gint _tmp51_;
							gchar** _tmp52_;
							gint _tmp52__length1;
							gchar** _tmp53_;
							gint _tmp53__length1;
							gint _tmp54_;
							gchar** _tmp55_;
							gint _tmp55__length1;
							gint _tmp56_;
							const gchar* _tmp57_;
							gchar* _tmp58_ = NULL;
							gchar* _tmp59_;
							_tmp49_ = _tmp48_;
							if (!_tmp49_) {
								gint _tmp50_;
								_tmp50_ = i;
								i = _tmp50_ + 1;
							}
							_tmp48_ = FALSE;
							_tmp51_ = i;
							_tmp52_ = args;
							_tmp52__length1 = args_length1;
							if (!(_tmp51_ < _tmp52__length1)) {
								break;
							}
							_tmp53_ = args;
							_tmp53__length1 = args_length1;
							_tmp54_ = i;
							_tmp55_ = args;
							_tmp55__length1 = args_length1;
							_tmp56_ = i;
							_tmp57_ = _tmp55_[_tmp56_];
							_tmp58_ = unity_applications_lens_utils_subst_tilde (_tmp57_);
							_g_free0 (_tmp53_[_tmp54_]);
							_tmp53_[_tmp54_] = _tmp58_;
							_tmp59_ = _tmp53_[_tmp54_];
						}
					}
				}
			}
			_tmp60_ = self->priv->runner;
			_tmp61_ = orig;
			unity_applications_lens_runner_add_history (_tmp60_, _tmp61_);
			_g_free0 (orig);
		} else {
			GeeMap* _tmp62_;
			gint _tmp63_;
			gint _tmp64_;
			UnityActivationResponse* _tmp65_;
			UnityActivationResponse* _tmp66_;
			_tmp62_ = self->priv->popularity_map;
			_tmp63_ = gee_map_get_size (_tmp62_);
			_tmp64_ = _tmp63_;
			if (_tmp64_ <= 5) {
				self->priv->popularities_dirty = TRUE;
			}
			_tmp65_ = unity_activation_response_new (UNITY_HANDLED_TYPE_NOT_HANDLED, "");
			_tmp66_ = g_object_ref_sink (_tmp65_);
			result = _tmp66_;
			_g_free0 (exec_or_dir);
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			return result;
		}
	}
	_tmp68_ = exec_or_dir;
	if (_tmp68_ != NULL) {
		const gchar* _tmp69_;
		gboolean _tmp70_ = FALSE;
		_tmp69_ = exec_or_dir;
		_tmp70_ = g_file_test (_tmp69_, G_FILE_TEST_IS_DIR);
		_tmp67_ = _tmp70_;
	} else {
		_tmp67_ = FALSE;
	}
	_tmp71_ = _tmp67_;
	if (_tmp71_) {
		{
			const gchar* _tmp72_;
			gchar* _tmp73_;
			gchar* _tmp74_;
			_tmp72_ = exec_or_dir;
			_tmp73_ = g_strconcat ("file://", _tmp72_, NULL);
			_tmp74_ = _tmp73_;
			g_app_info_launch_default_for_uri (_tmp74_, NULL, &_inner_error_);
			_g_free0 (_tmp74_);
			if (_inner_error_ != NULL) {
				goto __catch7_g_error;
			}
		}
		goto __finally7;
		__catch7_g_error:
		{
			GError* err = NULL;
			const gchar* _tmp75_;
			GError* _tmp76_;
			const gchar* _tmp77_;
			UnityActivationResponse* _tmp78_;
			UnityActivationResponse* _tmp79_;
			err = _inner_error_;
			_inner_error_ = NULL;
			_tmp75_ = exec_or_dir;
			_tmp76_ = err;
			_tmp77_ = _tmp76_->message;
			g_warning ("daemon.vala:993: Failed to open current folder '%s' in file manager: %" \
"s", _tmp75_, _tmp77_);
			_tmp78_ = unity_activation_response_new (UNITY_HANDLED_TYPE_NOT_HANDLED, "");
			_tmp79_ = g_object_ref_sink (_tmp78_);
			result = _tmp79_;
			_g_error_free0 (err);
			_g_free0 (exec_or_dir);
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			return result;
		}
		__finally7:
		if (_inner_error_ != NULL) {
			_g_free0 (exec_or_dir);
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	} else {
		{
			const gchar* _tmp80_ = NULL;
			const gchar* home_dir;
			const gchar* _tmp81_;
			gchar** _tmp82_;
			gint _tmp82__length1;
			_tmp80_ = g_get_home_dir ();
			home_dir = _tmp80_;
			_tmp81_ = home_dir;
			_tmp82_ = args;
			_tmp82__length1 = args_length1;
			g_spawn_async (_tmp81_, _tmp82_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_SPAWN_ERROR) {
					goto __catch8_g_spawn_error;
				}
				_g_free0 (exec_or_dir);
				args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		goto __finally8;
		__catch8_g_spawn_error:
		{
			GError* e = NULL;
			const gchar* _tmp83_;
			GError* _tmp84_;
			const gchar* _tmp85_;
			UnityActivationResponse* _tmp86_;
			UnityActivationResponse* _tmp87_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp83_ = uri;
			_tmp84_ = e;
			_tmp85_ = _tmp84_->message;
			g_warning ("daemon.vala:1004: Failed to spawn software-center or direct URI activa" \
"tion '%s': %s", _tmp83_, _tmp85_);
			_tmp86_ = unity_activation_response_new (UNITY_HANDLED_TYPE_NOT_HANDLED, "");
			_tmp87_ = g_object_ref_sink (_tmp86_);
			result = _tmp87_;
			_g_error_free0 (e);
			_g_free0 (exec_or_dir);
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			return result;
		}
		__finally8:
		if (_inner_error_ != NULL) {
			_g_free0 (exec_or_dir);
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp88_ = unity_activation_response_new (UNITY_HANDLED_TYPE_HIDE_DASH, "");
	_tmp89_ = g_object_ref_sink (_tmp88_);
	result = _tmp89_;
	_g_free0 (exec_or_dir);
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


void unity_applications_lens_daemon_append_events_with_category (UnityApplicationsLensDaemon* self, ZeitgeistResultSet* events, DeeModel* results, guint category_id, gboolean include_favorites, gint max_results, GeeSet* allowed_uris) {
	gint num_results;
	g_return_if_fail (self != NULL);
	g_return_if_fail (events != NULL);
	g_return_if_fail (results != NULL);
	num_results = 0;
	{
		ZeitgeistResultSet* _tmp0_;
		ZeitgeistResultSet* _tmp1_ = NULL;
		ZeitgeistResultSet* _ev_it;
		ZeitgeistEvent* ev = NULL;
		_tmp0_ = events;
		_tmp1_ = _vala_zeitgeist_result_set_iterator (_tmp0_);
		_ev_it = _tmp1_;
		while (TRUE) {
			ZeitgeistResultSet* _tmp2_;
			ZeitgeistEvent* _tmp3_ = NULL;
			ZeitgeistEvent* _tmp4_;
			gchar* app_uri;
			ZeitgeistEvent* _tmp5_;
			gint _tmp6_ = 0;
			const gchar* _tmp11_;
			const gchar* _tmp12_;
			gchar* _tmp13_ = NULL;
			gchar* desktop_id;
			gboolean _tmp14_ = FALSE;
			gboolean _tmp15_ = FALSE;
			gboolean _tmp16_ = FALSE;
			guint _tmp17_;
			gboolean _tmp19_;
			gboolean _tmp21_;
			gboolean _tmp30_;
			UnityAppInfoManager* _tmp31_ = NULL;
			UnityAppInfoManager* appmanager;
			UnityAppInfoManager* _tmp32_;
			const gchar* _tmp33_;
			GAppInfo* _tmp34_ = NULL;
			GAppInfo* app;
			GAppInfo* _tmp35_;
			GAppInfo* _tmp36_;
			gboolean _tmp37_ = FALSE;
			gint _tmp38_;
			gint _tmp39_;
			gboolean _tmp40_ = FALSE;
			GeeSet* _tmp41_;
			gboolean _tmp45_;
			UnityAppInfoManager* _tmp46_;
			const gchar* _tmp47_;
			gchar* _tmp48_ = NULL;
			gchar* full_path;
			gchar* _tmp49_ = NULL;
			const gchar* _tmp50_;
			const gchar* _tmp55_;
			gchar* _tmp56_;
			gchar* full_uri;
			DeeModel* _tmp57_;
			const gchar* _tmp58_;
			GAppInfo* _tmp59_;
			GIcon* _tmp60_ = NULL;
			gchar* _tmp61_ = NULL;
			gchar* _tmp62_;
			guint _tmp63_;
			GAppInfo* _tmp64_;
			const gchar* _tmp65_ = NULL;
			GAppInfo* _tmp66_;
			const gchar* _tmp67_ = NULL;
			const gchar* _tmp68_;
			_tmp2_ = _ev_it;
			_tmp3_ = _vala_zeitgeist_result_set_next_value (_tmp2_);
			ev = _tmp3_;
			_tmp4_ = ev;
			if (!(_tmp4_ != NULL)) {
				break;
			}
			app_uri = NULL;
			_tmp5_ = ev;
			_tmp6_ = zeitgeist_event_num_subjects (_tmp5_);
			if (_tmp6_ > 0) {
				ZeitgeistEvent* _tmp7_;
				ZeitgeistSubject* _tmp8_ = NULL;
				const gchar* _tmp9_ = NULL;
				gchar* _tmp10_;
				_tmp7_ = ev;
				_tmp8_ = zeitgeist_event_get_subject (_tmp7_, 0);
				_tmp9_ = zeitgeist_subject_get_uri (_tmp8_);
				_tmp10_ = g_strdup (_tmp9_);
				_g_free0 (app_uri);
				app_uri = _tmp10_;
			}
			_tmp11_ = app_uri;
			if (_tmp11_ == NULL) {
				g_warning ("daemon.vala:1032: Unexpected event without subject");
				_g_free0 (app_uri);
				continue;
			}
			_tmp12_ = app_uri;
			_tmp13_ = unity_applications_lens_utils_get_desktop_id_for_actor (_tmp12_);
			desktop_id = _tmp13_;
			_tmp17_ = category_id;
			if (_tmp17_ == ((guint) UNITY_APPLICATIONS_LENS_CATEGORY_RECENT)) {
				_tmp16_ = TRUE;
			} else {
				guint _tmp18_;
				_tmp18_ = category_id;
				_tmp16_ = _tmp18_ == ((guint) UNITY_APPLICATIONS_LENS_CATEGORY_RECENT_APPS);
			}
			_tmp19_ = _tmp16_;
			if (_tmp19_) {
				gboolean _tmp20_;
				_tmp20_ = include_favorites;
				_tmp15_ = !_tmp20_;
			} else {
				_tmp15_ = FALSE;
			}
			_tmp21_ = _tmp15_;
			if (_tmp21_) {
				gboolean _tmp22_ = FALSE;
				UnityLauncherFavorites* _tmp23_;
				const gchar* _tmp24_;
				gboolean _tmp25_ = FALSE;
				gboolean _tmp29_;
				_tmp23_ = self->priv->favorite_apps;
				_tmp24_ = desktop_id;
				_tmp25_ = unity_launcher_favorites_has_app_id (_tmp23_, _tmp24_);
				if (_tmp25_) {
					_tmp22_ = TRUE;
				} else {
					UnityApplicationsLensAppWatcher* _tmp26_;
					const gchar* _tmp27_;
					gboolean _tmp28_ = FALSE;
					_tmp26_ = self->priv->app_watcher;
					_tmp27_ = desktop_id;
					_tmp28_ = unity_applications_lens_app_watcher_has_app_id (_tmp26_, _tmp27_);
					_tmp22_ = _tmp28_;
				}
				_tmp29_ = _tmp22_;
				_tmp14_ = _tmp29_;
			} else {
				_tmp14_ = FALSE;
			}
			_tmp30_ = _tmp14_;
			if (_tmp30_) {
				_g_free0 (desktop_id);
				_g_free0 (app_uri);
				continue;
			}
			_tmp31_ = unity_app_info_manager_get_default ();
			appmanager = _tmp31_;
			_tmp32_ = appmanager;
			_tmp33_ = desktop_id;
			_tmp34_ = unity_app_info_manager_lookup (_tmp32_, _tmp33_);
			app = _tmp34_;
			_tmp35_ = app;
			if (_tmp35_ == NULL) {
				_g_object_unref0 (app);
				_g_object_unref0 (appmanager);
				_g_free0 (desktop_id);
				_g_free0 (app_uri);
				continue;
			}
			_tmp36_ = app;
			_tmp37_ = g_app_info_should_show (_tmp36_);
			if (!_tmp37_) {
				_g_object_unref0 (app);
				_g_object_unref0 (appmanager);
				_g_free0 (desktop_id);
				_g_free0 (app_uri);
				continue;
			}
			_tmp38_ = num_results;
			num_results = _tmp38_ + 1;
			_tmp39_ = max_results;
			if (_tmp38_ >= _tmp39_) {
				_g_object_unref0 (app);
				_g_object_unref0 (appmanager);
				_g_free0 (desktop_id);
				_g_free0 (app_uri);
				break;
			}
			_tmp41_ = allowed_uris;
			if (_tmp41_ != NULL) {
				GeeSet* _tmp42_;
				const gchar* _tmp43_;
				gboolean _tmp44_ = FALSE;
				_tmp42_ = allowed_uris;
				_tmp43_ = app_uri;
				_tmp44_ = gee_collection_contains ((GeeCollection*) _tmp42_, _tmp43_);
				_tmp40_ = !_tmp44_;
			} else {
				_tmp40_ = FALSE;
			}
			_tmp45_ = _tmp40_;
			if (_tmp45_) {
				_g_object_unref0 (app);
				_g_object_unref0 (appmanager);
				_g_free0 (desktop_id);
				_g_free0 (app_uri);
				continue;
			}
			_tmp46_ = appmanager;
			_tmp47_ = desktop_id;
			_tmp48_ = unity_app_info_manager_get_path (_tmp46_, _tmp47_);
			full_path = _tmp48_;
			_tmp50_ = full_path;
			if (_tmp50_ != NULL) {
				const gchar* _tmp51_;
				gchar* _tmp52_;
				_tmp51_ = full_path;
				_tmp52_ = g_strconcat ("file://", _tmp51_, NULL);
				_g_free0 (_tmp49_);
				_tmp49_ = _tmp52_;
			} else {
				const gchar* _tmp53_;
				gchar* _tmp54_;
				_tmp53_ = app_uri;
				_tmp54_ = g_strdup (_tmp53_);
				_g_free0 (_tmp49_);
				_tmp49_ = _tmp54_;
			}
			_tmp55_ = _tmp49_;
			_tmp56_ = g_strdup (_tmp55_);
			full_uri = _tmp56_;
			_tmp57_ = results;
			_tmp58_ = app_uri;
			_tmp59_ = app;
			_tmp60_ = g_app_info_get_icon (_tmp59_);
			_tmp61_ = g_icon_to_string (_tmp60_);
			_tmp62_ = _tmp61_;
			_tmp63_ = category_id;
			_tmp64_ = app;
			_tmp65_ = g_app_info_get_display_name (_tmp64_);
			_tmp66_ = app;
			_tmp67_ = g_app_info_get_description (_tmp66_);
			_tmp68_ = full_uri;
			dee_model_append (_tmp57_, _tmp58_, _tmp62_, _tmp63_, "application/x-desktop", _tmp65_, _tmp67_, _tmp68_, NULL);
			_g_free0 (_tmp62_);
			_g_free0 (full_uri);
			_g_free0 (_tmp49_);
			_g_free0 (full_path);
			_g_object_unref0 (app);
			_g_object_unref0 (appmanager);
			_g_free0 (desktop_id);
			_g_free0 (app_uri);
		}
		_g_object_unref0 (_ev_it);
	}
}


UnityApplicationsLensDaemon* unity_applications_lens_daemon_construct (GType object_type) {
	UnityApplicationsLensDaemon * self = NULL;
	self = (UnityApplicationsLensDaemon*) g_object_new (object_type, NULL);
	return self;
}


UnityApplicationsLensDaemon* unity_applications_lens_daemon_new (void) {
	return unity_applications_lens_daemon_construct (UNITY_APPLICATIONS_LENS_TYPE_DAEMON);
}


gboolean unity_applications_lens_daemon_get_display_recent_apps (UnityApplicationsLensDaemon* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_display_recent_apps;
	result = _tmp0_;
	return result;
}


void unity_applications_lens_daemon_set_display_recent_apps (UnityApplicationsLensDaemon* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_display_recent_apps = _tmp0_;
	g_object_notify ((GObject *) self, "display-recent-apps");
}


gboolean unity_applications_lens_daemon_get_display_available_apps (UnityApplicationsLensDaemon* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_display_available_apps;
	result = _tmp0_;
	return result;
}


void unity_applications_lens_daemon_set_display_available_apps (UnityApplicationsLensDaemon* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_display_available_apps = _tmp0_;
	g_object_notify ((GObject *) self, "display-available-apps");
}


static void _unity_applications_lens_daemon_mark_dirty_zeitgeist_monitor_events_inserted (ZeitgeistMonitor* _sender, ZeitgeistTimeRange* time_range, ZeitgeistResultSet* events, gpointer self) {
	unity_applications_lens_daemon_mark_dirty (self);
}


static void _unity_applications_lens_daemon_mark_dirty_zeitgeist_monitor_events_deleted (ZeitgeistMonitor* _sender, ZeitgeistTimeRange* time_range, GArray* event_ids, gpointer self) {
	unity_applications_lens_daemon_mark_dirty (self);
}


static gboolean _unity_applications_lens_daemon___lambda6_ (UnityApplicationsLensDaemon* self) {
	gboolean result = FALSE;
	self->priv->popularities_dirty = TRUE;
	result = TRUE;
	return result;
}


static gboolean __unity_applications_lens_daemon___lambda6__gsource_func (gpointer self) {
	gboolean result;
	result = _unity_applications_lens_daemon___lambda6_ (self);
	return result;
}


static gchar* _unity_applications_lens_daemon___lambda7_ (UnityApplicationsLensDaemon* self, UnityLensSearch* lens_search) {
	gchar* result = NULL;
	UnityLensSearch* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (lens_search != NULL, NULL);
	_tmp0_ = lens_search;
	_tmp1_ = unity_lens_search_get_search_string (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = string_strip (_tmp2_);
	result = _tmp3_;
	return result;
}


static gchar* __unity_applications_lens_daemon___lambda7__unity_scope_generate_search_key (UnityScope* _sender, UnityLensSearch* search, gpointer self) {
	gchar* result;
	result = _unity_applications_lens_daemon___lambda7_ (self, search);
	return result;
}


static void _unity_applications_lens_daemon___lambda8_ (UnityApplicationsLensDaemon* self, UnityLensSearch* lens_search, UnitySearchType search_type, GCancellable* cancellable) {
	UnityLensSearch* _tmp0_;
	UnitySearchType _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (lens_search != NULL);
	g_return_if_fail (cancellable != NULL);
	_tmp0_ = lens_search;
	_tmp1_ = search_type;
	_tmp2_ = cancellable;
	unity_applications_lens_daemon_dispatch_search (self, _tmp0_, _tmp1_, _tmp2_, NULL, NULL);
}


static void __unity_applications_lens_daemon___lambda8__unity_scope_search_changed (UnityScope* _sender, UnityLensSearch* search, UnitySearchType search_type, GCancellable* cancellable, gpointer self) {
	_unity_applications_lens_daemon___lambda8_ (self, search, search_type, cancellable);
}


static void _unity_applications_lens_daemon___lambda9_ (UnityApplicationsLensDaemon* self) {
	UnityScope* _tmp0_;
	_tmp0_ = self->priv->scope;
	unity_scope_queue_search_changed (_tmp0_, UNITY_SEARCH_TYPE_DEFAULT);
}


static void __unity_applications_lens_daemon___lambda9__unity_scope_filters_changed (UnityScope* _sender, gpointer self) {
	_unity_applications_lens_daemon___lambda9_ (self);
}


static void _unity_applications_lens_daemon___lambda10_ (UnityApplicationsLensDaemon* self) {
	UnityScope* _tmp0_;
	_tmp0_ = self->priv->scope;
	unity_scope_queue_search_changed (_tmp0_, UNITY_SEARCH_TYPE_DEFAULT);
}


static void __unity_applications_lens_daemon___lambda10__unity_scope_active_sources_changed (UnityScope* _sender, gchar** active_ids, int active_ids_length1, gpointer self) {
	_unity_applications_lens_daemon___lambda10_ (self);
}


static UnityActivationResponse* _unity_applications_lens_daemon_activate_unity_scope_activate_uri (UnityScope* _sender, const gchar* uri, gpointer self) {
	UnityActivationResponse* result;
	result = unity_applications_lens_daemon_activate (self, uri);
	return result;
}


static void _unity_applications_lens_daemon_mark_dirty_unity_app_info_manager_changed (UnityAppInfoManager* _sender, const gchar* id, GAppInfo* new_appinfo, gpointer self) {
	unity_applications_lens_daemon_mark_dirty (self);
}


static void _unity_applications_lens_daemon_mark_dirty_unity_launcher_favorites_changed (UnityLauncherFavorites* _sender, gpointer self) {
	unity_applications_lens_daemon_mark_dirty (self);
}


static void _unity_applications_lens_daemon_mark_dirty_unity_applications_lens_app_watcher_running_applications_changed (UnityApplicationsLensAppWatcher* _sender, gpointer self) {
	unity_applications_lens_daemon_mark_dirty (self);
}


static GObject * unity_applications_lens_daemon_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	UnityApplicationsLensDaemon * self;
	ZeitgeistLog* _tmp0_;
	ZeitgeistIndex* _tmp1_;
	ZeitgeistTimeRange* _tmp2_;
	ZeitgeistTimeRange* _tmp3_;
	GPtrArray* _tmp4_;
	GPtrArray* _tmp5_;
	ZeitgeistMonitor* _tmp6_;
	ZeitgeistMonitor* _tmp7_;
	ZeitgeistMonitor* _tmp8_;
	ZeitgeistLog* _tmp9_;
	ZeitgeistMonitor* _tmp10_;
	GeeHashMap* _tmp11_;
	GSettings* _tmp12_;
	GSettings* _tmp13_;
	GSettings* _tmp14_;
	UnityPackageSearcher* _tmp15_;
	UnityPackageSearcher* _tmp16_;
	GeeArrayList* _tmp21_;
	GeeList* _tmp22_;
	GeeList* _tmp23_;
	GeeList* _tmp24_;
	GeeList* _tmp25_;
	GeeList* _tmp26_;
	GeeList* _tmp27_;
	GeeList* _tmp28_;
	GHashFunc _tmp29_;
	GEqualFunc _tmp30_;
	GHashTable* _tmp31_;
	UnityScope* _tmp32_;
	UnityScope* _tmp33_;
	UnityOptionsFilter* _tmp34_;
	UnityOptionsFilter* _tmp35_;
	const gchar* _tmp36_ = NULL;
	UnityFilterOption* _tmp37_ = NULL;
	gboolean _tmp38_;
	UnityScope* _tmp44_;
	UnityScope* _tmp45_;
	UnityScope* _tmp46_;
	UnityScope* _tmp47_;
	UnityScope* _tmp48_;
	UnityAppInfoManager* _tmp49_ = NULL;
	UnityAppInfoManager* _tmp50_;
	UnityApplicationsLensRunner* _tmp51_;
	UnityLauncherFavorites* _tmp56_ = NULL;
	UnityLauncherFavorites* _tmp57_;
	UnityLauncherFavorites* _tmp58_;
	UnityApplicationsLensAppWatcher* _tmp59_;
	UnityApplicationsLensAppWatcher* _tmp60_;
	UnityLens* _tmp61_;
	UnityLens* _tmp62_;
	const gchar* _tmp63_ = NULL;
	UnityLens* _tmp64_;
	UnityLens* _tmp65_;
	UnityLens* _tmp66_;
	const gchar* _tmp67_ = NULL;
	UnityLens* _tmp68_;
	UnityScope* _tmp69_;
	UnityLens* _tmp70_;
	GError * _inner_error_ = NULL;
	parent_class = G_OBJECT_CLASS (unity_applications_lens_daemon_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = UNITY_APPLICATIONS_LENS_DAEMON (obj);
	unity_applications_lens_daemon_populate_type_queries (self);
	unity_applications_lens_daemon_populate_zg_templates (self);
	_tmp0_ = zeitgeist_log_new ();
	_g_object_unref0 (self->priv->log);
	self->priv->log = _tmp0_;
	_tmp1_ = zeitgeist_index_new ();
	_g_object_unref0 (self->priv->zg_index);
	self->priv->zg_index = _tmp1_;
	_tmp2_ = zeitgeist_time_range_new_from_now ();
	_tmp3_ = g_object_ref_sink (_tmp2_);
	_tmp4_ = self->priv->zg_templates;
	_tmp5_ = _g_ptr_array_ref0 (_tmp4_);
	_tmp6_ = zeitgeist_monitor_new (_tmp3_, _tmp5_);
	_g_object_unref0 (self->priv->monitor);
	self->priv->monitor = _tmp6_;
	_g_object_unref0 (_tmp3_);
	_tmp7_ = self->priv->monitor;
	g_signal_connect_object (_tmp7_, "events-inserted", (GCallback) _unity_applications_lens_daemon_mark_dirty_zeitgeist_monitor_events_inserted, self, 0);
	_tmp8_ = self->priv->monitor;
	g_signal_connect_object (_tmp8_, "events-deleted", (GCallback) _unity_applications_lens_daemon_mark_dirty_zeitgeist_monitor_events_deleted, self, 0);
	_tmp9_ = self->priv->log;
	_tmp10_ = self->priv->monitor;
	zeitgeist_log_install_monitor (_tmp9_, _tmp10_);
	_tmp11_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_INT, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->popularity_map);
	self->priv->popularity_map = (GeeMap*) _tmp11_;
	self->priv->popularities_dirty = TRUE;
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) (30 * 60), __unity_applications_lens_daemon___lambda6__gsource_func, g_object_ref (self), g_object_unref);
	_tmp12_ = g_settings_new ("com.canonical.Unity.ApplicationsLens");
	_g_object_unref0 (self->priv->gp_settings);
	self->priv->gp_settings = _tmp12_;
	_tmp13_ = self->priv->gp_settings;
	g_settings_bind (_tmp13_, UNITY_APPLICATIONS_LENS_DAEMON_DISPLAY_RECENT_APPS_KEY, self, "display_recent_apps", G_SETTINGS_BIND_GET);
	_tmp14_ = self->priv->gp_settings;
	g_settings_bind (_tmp14_, UNITY_APPLICATIONS_LENS_DAEMON_DISPLAY_AVAILABLE_APPS_KEY, self, "display_available_apps", G_SETTINGS_BIND_GET);
	_tmp15_ = unity_package_searcher_new ();
	_unity_package_searcher_free0 (self->priv->pkgsearcher);
	self->priv->pkgsearcher = _tmp15_;
	_tmp16_ = self->priv->pkgsearcher;
	if (_tmp16_ == NULL) {
		g_critical ("daemon.vala:115: Failed to load Software Center index. 'Apps Available" \
" for Download' will not be listed");
	}
	{
		UnityRatingsDatabase* _tmp17_;
		UnityRatingsDatabase* _tmp18_;
		_tmp17_ = unity_ratings_database_new (&_inner_error_);
		_tmp18_ = _tmp17_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch9_g_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		_unity_ratings_database_free0 (self->priv->ratings);
		self->priv->ratings = _tmp18_;
	}
	goto __finally9;
	__catch9_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp19_;
		const gchar* _tmp20_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp19_ = e;
		_tmp20_ = _tmp19_->message;
		g_warning ("daemon.vala:121: %s", _tmp20_);
		_unity_ratings_database_free0 (self->priv->ratings);
		self->priv->ratings = NULL;
		_g_error_free0 (e);
	}
	__finally9:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	_tmp21_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	_g_object_unref0 (self->priv->image_extensions);
	self->priv->image_extensions = (GeeList*) _tmp21_;
	_tmp22_ = self->priv->image_extensions;
	gee_collection_add ((GeeCollection*) _tmp22_, "png");
	_tmp23_ = self->priv->image_extensions;
	gee_collection_add ((GeeCollection*) _tmp23_, "xpm");
	_tmp24_ = self->priv->image_extensions;
	gee_collection_add ((GeeCollection*) _tmp24_, "svg");
	_tmp25_ = self->priv->image_extensions;
	gee_collection_add ((GeeCollection*) _tmp25_, "tiff");
	_tmp26_ = self->priv->image_extensions;
	gee_collection_add ((GeeCollection*) _tmp26_, "ico");
	_tmp27_ = self->priv->image_extensions;
	gee_collection_add ((GeeCollection*) _tmp27_, "tif");
	_tmp28_ = self->priv->image_extensions;
	gee_collection_add ((GeeCollection*) _tmp28_, "jpg");
	unity_applications_lens_daemon_build_app_menu_index (self);
	_tmp29_ = g_str_hash;
	_tmp30_ = g_str_equal;
	_tmp31_ = g_hash_table_new_full (_tmp29_, _tmp30_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->file_icon_cache);
	self->priv->file_icon_cache = _tmp31_;
	_tmp32_ = unity_scope_new ("/com/canonical/unity/scope/applications");
	_g_object_unref0 (self->priv->scope);
	self->priv->scope = _tmp32_;
	_tmp33_ = self->priv->scope;
	_tmp34_ = unity_scope_get_sources (_tmp33_);
	_tmp35_ = _tmp34_;
	_tmp36_ = _ ("Local Apps");
	_tmp37_ = unity_options_filter_add_option (_tmp35_, "local", _tmp36_, NULL);
	_g_object_unref0 (self->priv->local_apps_option);
	self->priv->local_apps_option = _tmp37_;
	_tmp38_ = self->priv->_display_available_apps;
	if (_tmp38_) {
		UnityScope* _tmp39_;
		UnityOptionsFilter* _tmp40_;
		UnityOptionsFilter* _tmp41_;
		const gchar* _tmp42_ = NULL;
		UnityFilterOption* _tmp43_ = NULL;
		_tmp39_ = self->priv->scope;
		_tmp40_ = unity_scope_get_sources (_tmp39_);
		_tmp41_ = _tmp40_;
		_tmp42_ = _ ("Software Center");
		_tmp43_ = unity_options_filter_add_option (_tmp41_, "usc", _tmp42_, NULL);
		_g_object_unref0 (self->priv->usc_apps_option);
		self->priv->usc_apps_option = _tmp43_;
	}
	_tmp44_ = self->priv->scope;
	g_signal_connect_object (_tmp44_, "generate-search-key", (GCallback) __unity_applications_lens_daemon___lambda7__unity_scope_generate_search_key, self, 0);
	_tmp45_ = self->priv->scope;
	g_signal_connect_object (_tmp45_, "search-changed", (GCallback) __unity_applications_lens_daemon___lambda8__unity_scope_search_changed, self, 0);
	_tmp46_ = self->priv->scope;
	g_signal_connect_object (_tmp46_, "filters-changed", (GCallback) __unity_applications_lens_daemon___lambda9__unity_scope_filters_changed, self, 0);
	_tmp47_ = self->priv->scope;
	g_signal_connect_object (_tmp47_, "active-sources-changed", (GCallback) __unity_applications_lens_daemon___lambda10__unity_scope_active_sources_changed, self, 0);
	_tmp48_ = self->priv->scope;
	g_signal_connect_object (_tmp48_, "activate-uri", (GCallback) _unity_applications_lens_daemon_activate_unity_scope_activate_uri, self, 0);
	_tmp49_ = unity_app_info_manager_get_default ();
	_tmp50_ = _tmp49_;
	g_signal_connect_object (_tmp50_, "changed", (GCallback) _unity_applications_lens_daemon_mark_dirty_unity_app_info_manager_changed, self, 0);
	_g_object_unref0 (_tmp50_);
	_tmp51_ = unity_applications_lens_runner_new (self);
	_g_object_unref0 (self->priv->runner);
	self->priv->runner = _tmp51_;
	{
		GRegex* _tmp52_;
		GRegex* _tmp53_;
		GRegex* _tmp54_;
		GRegex* _tmp55_;
		_tmp52_ = g_regex_new ("^[a-z]+:.+$", 0, 0, &_inner_error_);
		_tmp53_ = _tmp52_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch10_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		_g_regex_unref0 (self->priv->uri_regex);
		self->priv->uri_regex = _tmp53_;
		_tmp54_ = g_regex_new ("((ftp|ssh|sftp|smb|dav)://).+", 0, 0, &_inner_error_);
		_tmp55_ = _tmp54_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch10_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		_g_regex_unref0 (self->priv->mountable_regex);
		self->priv->mountable_regex = _tmp55_;
	}
	goto __finally10;
	__catch10_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_regex_unref0 (self->priv->uri_regex);
		self->priv->uri_regex = NULL;
		g_critical ("daemon.vala:187: Failed to compile URI regex. URL launching will be di" \
"sabled");
		_g_error_free0 (e);
	}
	__finally10:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	_tmp56_ = unity_launcher_favorites_get_default ();
	_tmp57_ = _g_object_ref0 (_tmp56_);
	_g_object_unref0 (self->priv->favorite_apps);
	self->priv->favorite_apps = _tmp57_;
	_tmp58_ = self->priv->favorite_apps;
	g_signal_connect_object (_tmp58_, "changed", (GCallback) _unity_applications_lens_daemon_mark_dirty_unity_launcher_favorites_changed, self, 0);
	_tmp59_ = unity_applications_lens_app_watcher_new ();
	_g_object_unref0 (self->priv->app_watcher);
	self->priv->app_watcher = _tmp59_;
	_tmp60_ = self->priv->app_watcher;
	g_signal_connect_object (_tmp60_, "running-applications-changed", (GCallback) _unity_applications_lens_daemon_mark_dirty_unity_applications_lens_app_watcher_running_applications_changed, self, 0);
	_tmp61_ = unity_lens_new ("/com/canonical/unity/lens/applications", "applications");
	_g_object_unref0 (self->priv->lens);
	self->priv->lens = _tmp61_;
	_tmp62_ = self->priv->lens;
	_tmp63_ = _ ("Search Applications");
	unity_lens_set_search_hint (_tmp62_, _tmp63_);
	_tmp64_ = self->priv->lens;
	unity_lens_set_visible (_tmp64_, TRUE);
	_tmp65_ = self->priv->lens;
	unity_lens_set_search_in_global (_tmp65_, TRUE);
	_tmp66_ = self->priv->lens;
	_tmp67_ = _ ("Sources");
	unity_lens_set_sources_display_name (_tmp66_, _tmp67_);
	unity_applications_lens_daemon_populate_categories (self);
	unity_applications_lens_daemon_populate_filters (self);
	_tmp68_ = self->priv->lens;
	_tmp69_ = self->priv->scope;
	unity_lens_add_local_scope (_tmp68_, _tmp69_);
	_tmp70_ = self->priv->lens;
	unity_lens_export (_tmp70_, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	return obj;
}


static void unity_applications_lens_daemon_class_init (UnityApplicationsLensDaemonClass * klass) {
	unity_applications_lens_daemon_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityApplicationsLensDaemonPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_unity_applications_lens_daemon_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_unity_applications_lens_daemon_set_property;
	G_OBJECT_CLASS (klass)->constructor = unity_applications_lens_daemon_constructor;
	G_OBJECT_CLASS (klass)->finalize = unity_applications_lens_daemon_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_APPLICATIONS_LENS_DAEMON_DISPLAY_RECENT_APPS, g_param_spec_boolean ("display-recent-apps", "display-recent-apps", "display-recent-apps", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_APPLICATIONS_LENS_DAEMON_DISPLAY_AVAILABLE_APPS, g_param_spec_boolean ("display-available-apps", "display-available-apps", "display-available-apps", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void unity_applications_lens_daemon_instance_init (UnityApplicationsLensDaemon * self) {
	self->priv = UNITY_APPLICATIONS_LENS_DAEMON_GET_PRIVATE (self);
	self->priv->app_menu_changed_reindex_timeout = (guint) 0;
	self->priv->app_menu = NULL;
	self->priv->_display_recent_apps = TRUE;
	self->priv->_display_available_apps = TRUE;
}


static void unity_applications_lens_daemon_finalize (GObject* obj) {
	UnityApplicationsLensDaemon * self;
	self = UNITY_APPLICATIONS_LENS_DAEMON (obj);
	_g_object_unref0 (self->priv->log);
	_g_object_unref0 (self->priv->zg_index);
	_g_object_unref0 (self->priv->monitor);
	_g_object_unref0 (self->priv->popularity_map);
	_unity_package_searcher_free0 (self->priv->pkgsearcher);
	_unity_package_searcher_free0 (self->appsearcher);
	_unity_ratings_database_free0 (self->priv->ratings);
	_g_object_unref0 (self->priv->lens);
	_g_object_unref0 (self->priv->scope);
	_g_object_unref0 (self->priv->runner);
	_g_object_unref0 (self->priv->local_apps_option);
	_g_object_unref0 (self->priv->usc_apps_option);
	_g_hash_table_unref0 (self->priv->type_queries);
	_g_object_unref0 (self->priv->image_extensions);
	_g_hash_table_unref0 (self->priv->file_icon_cache);
	_g_object_unref0 (self->priv->favorite_apps);
	_g_object_unref0 (self->priv->app_watcher);
	_g_ptr_array_unref0 (self->priv->zg_templates);
	_gmenu_tree_unref0 (self->priv->app_menu);
	_g_regex_unref0 (self->priv->uri_regex);
	_g_regex_unref0 (self->priv->mountable_regex);
	_g_object_unref0 (self->priv->gp_settings);
	G_OBJECT_CLASS (unity_applications_lens_daemon_parent_class)->finalize (obj);
}


GType unity_applications_lens_daemon_get_type (void) {
	static volatile gsize unity_applications_lens_daemon_type_id__volatile = 0;
	if (g_once_init_enter (&unity_applications_lens_daemon_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityApplicationsLensDaemonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_applications_lens_daemon_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityApplicationsLensDaemon), 0, (GInstanceInitFunc) unity_applications_lens_daemon_instance_init, NULL };
		GType unity_applications_lens_daemon_type_id;
		unity_applications_lens_daemon_type_id = g_type_register_static (G_TYPE_OBJECT, "UnityApplicationsLensDaemon", &g_define_type_info, 0);
		g_once_init_leave (&unity_applications_lens_daemon_type_id__volatile, unity_applications_lens_daemon_type_id);
	}
	return unity_applications_lens_daemon_type_id__volatile;
}


static void _vala_unity_applications_lens_daemon_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	UnityApplicationsLensDaemon * self;
	self = UNITY_APPLICATIONS_LENS_DAEMON (object);
	switch (property_id) {
		case UNITY_APPLICATIONS_LENS_DAEMON_DISPLAY_RECENT_APPS:
		g_value_set_boolean (value, unity_applications_lens_daemon_get_display_recent_apps (self));
		break;
		case UNITY_APPLICATIONS_LENS_DAEMON_DISPLAY_AVAILABLE_APPS:
		g_value_set_boolean (value, unity_applications_lens_daemon_get_display_available_apps (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_unity_applications_lens_daemon_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	UnityApplicationsLensDaemon * self;
	self = UNITY_APPLICATIONS_LENS_DAEMON (object);
	switch (property_id) {
		case UNITY_APPLICATIONS_LENS_DAEMON_DISPLAY_RECENT_APPS:
		unity_applications_lens_daemon_set_display_recent_apps (self, g_value_get_boolean (value));
		break;
		case UNITY_APPLICATIONS_LENS_DAEMON_DISPLAY_AVAILABLE_APPS:
		unity_applications_lens_daemon_set_display_available_apps (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



